
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V10/interpreter/klb_body_blt_profile.psl.c
   ----- CREATED   : by imai@icot22, on Fri Aug  2 11:20:38 1991
   ----- LAST SAVED: by imai@icot22, on Tue Sep 10 16:44:44 1991
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : $B%W%m%;%C%5%W%m%U%!%$%k$K4X$9$kAH9~=R8l(B
			processor_profile
			log_event
		     $B$K4X$9$kDj5A(B

$B;EMM$K4X$9$k>\:Y$O!"(B
  PSM-M-P-EVL-009 (for Multi-PSI)
  PIM-I-P-PSL-184 (VPIM)
$B$r;2>H$N$3$H!#(B
  PIM-I-P-PSL-184 (VPIM) $B$O!"(BPSM-M-P-EVL-009 (for Multi-PSI) $B$H$N(B
$B:9J,$r5-=R$7$F$$$k!#(B
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
kblt_b_processor_profile

       written by imai@icot22      on Fri Aug  2 11:37:54 1991

  0            1            2            3            4
  +------------+------------+------------+------------+
  |   b_processor_profile   |     A1     |     A2     |
  +------------+------------+------------+------------+

<Arguments>
  A1 $BF~NO(B $B%Y%/%?(B $BL$Dj5A$J$i%5%9%Z%s%I(B
  A2 $B=PNO(B $B%Y%/%?(B 
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B%W%m%;%C%5%W%m%U%!%$%k$N(B on / off $B$r9T$J$&(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_SrcNextVect    _IndirectRegField1
#OPF_define I_DstCurrentVect _IndirectRegField2

#PSL_define kblt_b_processor_profile()
{
  @DEBUG{
    s_IfArgTypeErr(I_SrcNextVect){
      VPIM_ERROR("kblt_b_processor_profile","Illegal Type");
    };
  };
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp2ArgVect_IO_Sub
	    (D_WorkArgVect,I_SrcNextVect,I_DstCurrentVect));
      f_TraceBodyBuiltin(BLT_B_PROCESSOR_PROFILE,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  $USE(D_Workreg);
  f_ActiveDeref(I_SrcNextVect,D_Workreg);
  TypeSwitch(I_SrcNextVect) {
  case NullVectorGrp():
  case ShortVectorGrp():
    $RELEASE(D_Workreg);
    $USE(D_WorkResult);
    $CALL( f_DoProcessorProfileBuiltin_Sub
	  (I_SrcNextVect,I_DstCurrentVect,D_WorkResult));
    ValueSwitch(D_WorkResult) {
    case  _PROCESSOR_PROFILE_PROPER_INPUT:
      $RELEASE(D_WorkResult);	goto End_of_KL1B_Instruction;
    case  _PROCESSOR_PROFILE_SUSPENTION_INPUT:
      $RELEASE(D_WorkResult);	goto Suspend;
    case _PROCESSOR_PROFILE_ILLEGAL_INPUT:
      $RELEASE(D_WorkResult);	goto Illegal_Input_Exception;
    case _PROCESSOR_PROFILE_RANGE_OVERFLOW:
      $RELEASE(D_WorkResult);	goto Range_Overflow_Exception;
    default:
      @DEBUG{VPIM_ERROR("kblt_b_processor_profile","Unbelievable!!");};
    }
    break;
  case UnboundGroup():
    p_MoveWord(D_Workreg, I_SrcNextVect);
    $RELEASE(D_Workreg);
    goto Suspend;
  case LongVectorGrp():
	/* $BCm0U!*>-Mh7WB,9`L\$,A}$($k$H!"Nc30$G$J$/$J$k2DG=@-$"$j(B */
  default:
    $RELEASE(D_Workreg);
    goto Illegal_Input_Exception;
  }
 Suspend:
  f_DcodeEnqueue2Ope_IO
    (BLT_B_PROCESSOR_PROFILE,I_SrcNextVect,I_DstCurrentVect);
  goto End_of_KL1B_Instruction;
 Range_Overflow_Exception:
  $USE(D_WorkExceptionCode);
  b_SetImmTypeValueMRBoff (INT, _RANGE_OVERFLOW_EXCP, D_WorkExceptionCode);
  goto ExceptionCommon;
 Illegal_Input_Exception:
  $USE(D_WorkExceptionCode);
  b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
 ExceptionCommon:
  $USE (D_WorkOpCode); $USE(D_WorkExcepArgPos); 
  b_SetImmTypeValueMRBoff (INT, BLT_B_PROCESSOR_PROFILE, D_WorkOpCode);
  b_SetImmTypeValueMRBoff (INT, _ZERO, D_WorkExcepArgPos);
  $CALL (f_Exception_2Arg_IO_Sub
	 (D_WorkExceptionCode, D_WorkOpCode, D_WorkExcepArgPos,
	  I_SrcNextVect,I_DstCurrentVect)); 
  $RELEASE(D_WorkOpCode); $RELEASE(D_WorkExceptionCode); 
  $RELEASE(D_WorkExcepArgPos);
  goto End_of_KL1B_Instruction;
 End_of_KL1B_Instruction:;
}

/******************************************************************** PSL **
kblt_b_log_event

       written by imai@icot22      on Fri Aug  2 11:37:50 1991

  0            1            2            3            4
  +------------+------------+------------+------------+
  |       b_log_event       |     A1     | Don't Care |
  +------------+------------+------------+------------+

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  log_event $B$K(B $B;~9o$H(BA1 $B$r5-O?$9$k!#(B
<Examples>
<Test>
<Explanation>
  A1 $B$O$?$H$(L$Dj5A$G$bCfCG$7$J$$!#%G%l%U%!%l%s%9$b9T$J$o$J$$!#(B
<ETC>
********************************************************************* PSL **/

#OPF_define I_SrcEventID	_IndirectRegField1

#PSL_define kblt_b_log_event()
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp1ArgVect_I_Sub(D_WorkArgVect,I_SrcEventID));
      f_TraceBodyBuiltin(BLT_B_LOG_EVENT,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };
  f_DoLogEvent(I_SrcEventID);
 End_of_KL1B_Instruction:;
}
