/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/interpreter/klb_body_blt_io.psl.c
   ----- CREATED   : by f-doumae@icot22, on Sat Jun 16 14:32:23 1990
   ----- LAST SAVED: by f-takei@icot22, on Mon Mar  9 11:14:57 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : interpreter
   ----- ABSTRACT  : SCSI$BAH$_9~$_=R8l(B
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */
#DATA_define D_WorkCommRec XXX
#DATA_define D_WorkTransRec XXX
#DATA_define D_WorkNextPhase XXX
#DATA_define D_WorkLun      XXX
#DATA_define D_WorkCommand  XXX
#DATA_define D_WorkData1    XXX
#DATA_define D_WorkCommLen  XXX
#DATA_define D_WorkCDB      XXX
#DATA_define D_WorkContinue XXX

/******************************************************************** PSL **
kblt_b_scsi_command  
    (SCSI, InVect, ^NewData, ^TransferredLength, ^ID, ^Result, ^NewSCSI)

       written by f-doumae@icot22      on Tue Nov 13 15:06:40 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    $B%$%K%7%(!<%?5!G=!#(B
    $B%?!<%2%C%H$K%3%^%s%I$r<B9T$5$;$kA`:n$NM=Ls$r9T$J$&!#(B
<Examples>
<Test>
<Explanation>
    $B=PNO0z?t(B ID, NewSCSI $B$O%3%^%s%IM=Ls40N;;~E@$G%f%K%U%!%$$5$l$k$,!"(B
    $B$=$NB>$N=PNO0z?t$K$D$$$F$O<B:]$N%3%^%s%I$N<B9T$,=*N;$7$?;~E@$G(B
    $B%f%K%U%!%$$,9T$J$o$l$k!#(B
    $B0l$D$N%3%^%s%I<B9T$K$O%3%^%s%IE>Aw!"%G!<%?E>Aw!"%9%F!<%?%9E>Aw(B
    $B%a%C%;!<%8E>Aw$,IU?o$7!"$=$N4V$K$O(B disconnect/reconnect $B$K$h$k(B
    $BJ#?t2s$N%3%M%/%7%g%s$,9T$J$o$l$k>l9g$b$"$k$,!"$=$l$i$O(BKL1$B%W%m(B
    $B%0%i%`$K$OCN$i$;$:=hM}7O%l%Y%k0J2<$G<+F0E*$K9T$J$&!#(B
    $BF1$8(B Unit, LUN $B$K4X$9$k%3%^%s%I$OM=Ls$5$l$?=g=x$G<B9T$r9T$J$&$3$H$r(B
    $BJ]>Z$9$k!#(B
<ETC>
********************************************************************* PSL **/
#CONST_define _SCSI_MIN_UNIT_NUMBER        0
#CONST_define _SCSI_MAX_UNIT_NUMBER        7
#CONST_define _SCSI_MIN_LUN                0
#CONST_define _SCSI_MAX_LUN             2047
#CONST_define _SCSI_MIN_CDB_SIZE           6
#CONST_define _SCSI_MAX_CDB_SIZE          16
/* $BF~NO0z?t%Y%/%?Cf$NMWAG0LCV(B */
#ADDR_define _SCSI_COMM_UNIT_OFST          0
#ADDR_define _SCSI_COMM_LUN_OFST           1      
#ADDR_define _SCSI_COMM_COMMAND_OFST       2
#ADDR_define _SCSI_COMM_LENGTH_OFST        3
#ADDR_define _SCSI_COMM_DIRECTION_OFST     4
#ADDR_define _SCSI_COMM_DATA_OFST          5
#ADDR_define _SCSI_COMM_DATA_POS_OFST      6

#OPF_define I_RegScsi       _IndirectRegField1          /* $BF~NO(B */
#OPF_define I_RegArgVect    _IndirectRegField2          /* $BF~NO0z?t%Y%/%?(B */
                                                       /* MRB$B!{$,A0Ds(B    */
#OPF_define I_RegNewData    _IndirectRegField3          /* $B=PNO(B */
#OPF_define I_RegTransferredLength _IndirectRegField4   /* $B=PNO(B */
#OPF_define I_RegID         _IndirectRegField5          /* $B=PNO(B */
#OPF_define I_RegResult     _IndirectRegField6          /* $B=PNO(B */
#OPF_define I_RegNewScsi    _IndirectRegField7          /* $B=PNO(B */

#PSL_define kblt_b_scsi_command()
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp7ArgVect_IIOOOOO_Sub(D_WorkArgVect,
					   I_RegScsi,
					   I_RegArgVect,
					   I_RegNewData,
					   I_RegTransferredLength,
					   I_RegID,
 					   I_RegResult,
					   I_RegNewScsi));
      f_TraceBodyBuiltin(BLT_B_SCSI_COMMAND,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

/**** $BNc30%A%'%C%/(B ****/
  $USE(D_WorkFlagReg);
  $USE(D_WorkExceptionCode);
  $USE(D_WorkExcepArgPos);
  i_ScsiCommandExceptionCheck(I_RegScsi, I_RegArgVect, D_WorkFlagReg, 
			      D_WorkExceptionCode, D_WorkExcepArgPos);
/*------------------------------------------------------------- 
  i_ScsiCommandExceptionCheck $B$G$O0z?t%Y%/%?(BI_RegArgVect$B$N(B
  $B3FMWAG$N%G%l%U%!%l%s%9$H=q$-La$7$r9T$J$C$F$$$k!#(B
  $B%(%/%;%W%7%g%s$,5/$3$C$?>l9g!"(B
      D_WorkFlagReg       : 0$B$G$J$$CM(B
      D_WorkExceptionCode : $B%(%/%;%W%7%g%s%3!<%I(B
      D_WorkExcepArgPos   : $B%(%/%;%W%7%g%s$r5/$3$7$?0z?t0LCV(B
  $B$,JV$k!#(B
---------------------------------------------------------------*/
  b_IfNotZero(D_WorkFlagReg){ /* $B%(%/%;%W%7%g%s$,H/@8$7$?>l9g(B */
      $RELEASE(D_WorkFlagReg);
      $USE(D_WorkOpCode);
      b_SetImmTypeValueMRBoff(INT, BLT_B_SCSI_COMMAND, D_WorkOpCode);
      $CALL (f_Exception_7Arg_IIOOOOO_Sub
	     (D_WorkExceptionCode,D_WorkOpCode, D_WorkExcepArgPos, 
	      I_RegScsi, I_RegArgVect, I_RegNewData, 
	      I_RegTransferredLength, I_RegID, I_RegResult, I_RegNewScsi));
      $RELEASE(D_WorkOpCode);
      $RELEASE(D_WorkExcepArgPos);
      $RELEASE(D_WorkExceptionCode);
      goto End_of_KL1B_Instruction;
  }
  $RELEASE(D_WorkFlagReg);
  $RELEASE(D_WorkExceptionCode);
  $RELEASE(D_WorkExcepArgPos);


/**** $BL$B+G{JQ?t%A%'%C%/(B ****/

/*----------------------------------------------------------*/
/* I_RegScsi,I_RegArgVect$B$H$b%G%l%U$NI,MW$O$J$$(B             */
/* $B4{$K(Bi_ScsiCommandExceptionCheck $B$G%G%l%U$5$l$F$$$k!#(B     */
/*----------------------------------------------------------*/
  
/*---------- $BBh(B1$B0z?t$N%A%'%C%/(B -----------------------------*/
  s_IfREF(I_RegScsi){
      goto MAKE_DCODE_GOAL_ENQUEUE;
  }

/*---------- $BBh(B2$B0z?t$N%A%'%C%/(B -----------------------------*/
  s_IfREF(I_RegArgVect){
      goto MAKE_DCODE_GOAL_ENQUEUE;
  }

/*---------- $BBh(B2$B0z?t$N3FMWAG$N%A%'%C%/(B ---------------------*/
/*---------- $BBh(B2$B0z?t(B($BBh(B0$BMWAG(B)$B$N%A%'%C%/(B ----------------*/
  $USE(D_WorkUnit);
  p_ReadWithOffset(I_RegArgVect, _SCSI_COMM_UNIT_OFST, D_WorkUnit);
  s_IfREF(D_WorkUnit){
      $RELEASE(D_WorkUnit);
      goto MAKE_DCODE_GOAL_ENQUEUE;
  }
/*---------- $BBh(B2$B0z?t(B($BBh(B1$BMWAG(B)$B$N%A%'%C%/(B ----------------*/
  $USE(D_WorkLun);
  p_ReadWithOffset(I_RegArgVect, _SCSI_COMM_LUN_OFST, D_WorkLun);
  s_IfREF(D_WorkLun){
      $RELEASE(D_WorkUnit);$RELEASE(D_WorkLun);
      goto MAKE_DCODE_GOAL_ENQUEUE;
  }
/*---------- $BBh(B2$B0z?t(B($BBh(B2$BMWAG(B)$B$N%A%'%C%/(B ----------------*/
  $USE(D_WorkCommand);
  p_ReadWithOffset(I_RegArgVect, _SCSI_COMM_COMMAND_OFST, D_WorkCommand);
  s_IfREF(D_WorkCommand){
      $RELEASE(D_WorkUnit);$RELEASE(D_WorkLun);$RELEASE(D_WorkCommand);
      goto MAKE_DCODE_GOAL_ENQUEUE;
  }
/*---------- $BBh(B2$B0z?t(B($BBh(B3$BMWAG(B)$B$N%A%'%C%/(B ----------------*/
  $USE(D_WorkLength);
  p_ReadWithOffset(I_RegArgVect, _SCSI_COMM_LENGTH_OFST, D_WorkLength);
  s_IfREF(D_WorkLength){
      $RELEASE(D_WorkUnit);$RELEASE(D_WorkLun);$RELEASE(D_WorkCommand);
      $RELEASE(D_WorkLength);
      goto MAKE_DCODE_GOAL_ENQUEUE;
  }
/*---------- $BBh(B2$B0z?t(B($BBh(B4$BMWAG(B)$B$N%A%'%C%/(B ----------------*/
  $USE(D_WorkDirection);
  p_ReadWithOffset(I_RegArgVect, _SCSI_COMM_DIRECTION_OFST, D_WorkDirection);
  s_IfREF(D_WorkDirection){
      $RELEASE(D_WorkUnit);$RELEASE(D_WorkLun);$RELEASE(D_WorkCommand);
      $RELEASE(D_WorkLength);$RELEASE(D_WorkDirection);
      goto MAKE_DCODE_GOAL_ENQUEUE;
  }
/*---------- $BBh(B2$B0z?t(B($BBh(B5$BMWAG(B)$B$N%A%'%C%/(B ----------------*/
  $USE(D_WorkData);
  p_ReadWithOffset(I_RegArgVect, _SCSI_COMM_DATA_OFST, D_WorkData);
  s_IfREF(D_WorkData){
      $RELEASE(D_WorkUnit);$RELEASE(D_WorkLun);$RELEASE(D_WorkCommand);
      $RELEASE(D_WorkLength);$RELEASE(D_WorkDirection);$RELEASE(D_WorkData);
      goto MAKE_DCODE_GOAL_ENQUEUE;
  }
/*---------- $BBh(B2$B0z?t(B($BBh(B6$BMWAG(B)$B$N%A%'%C%/(B ----------------*/
  $USE(D_WorkDataPos);
  p_ReadWithOffset(I_RegArgVect, _SCSI_COMM_DATA_POS_OFST, D_WorkDataPos);
  s_IfREF(D_WorkDataPos){
      $RELEASE(D_WorkUnit);$RELEASE(D_WorkLun);$RELEASE(D_WorkCommand);
      $RELEASE(D_WorkLength);$RELEASE(D_WorkDirection);$RELEASE(D_WorkData);
      $RELEASE(D_WorkDataPos);
      goto MAKE_DCODE_GOAL_ENQUEUE;
  }

  s_IfEmptyCommRecFreeList(){
      $RELEASE(D_WorkUnit);$RELEASE(D_WorkLun);$RELEASE(D_WorkCommand);
      $RELEASE(D_WorkLength);$RELEASE(D_WorkDirection);$RELEASE(D_WorkData);
      $RELEASE(D_WorkDataPos);
    /*-----------------------------------------------------------------
       $B%3%^%s%I%l%3!<%I$,%U%j!<%j%9%H$K$J$+$C$?$i!"(BD$B%3!<%I%4!<%k$r:n$j(B
       $B%3%^%s%I%U%j!<%j%9%HBT$A$K$9$k!#(B
       $B%3%^%s%I$N<B9T$,0l$D=*N;$7%3%^%s%I%l%3!<%I$,%U%j!<%j%9%H$KJV$5$l$k(B
       $B;~!"%3%^%s%I%U%j!<%j%9%HBT$A$KEPO?$5$l$F$$$k%4!<%k$,$"$l$P$=$N<B9T$K(B
       $B0\$k!#(B
     ------------------------------------------------------------------*/
    f_DcodeEnqueueToCommRecFreeListWaiting(I_RegScsi, I_RegArgVect, 
     I_RegNewData, I_RegTransferredLength, I_RegID, I_RegResult, I_RegNewScsi);
    goto End_of_KL1B_Instruction;
  }

  $USE(D_WorkCommRec);
  s_AllocCommRec(D_WorkCommRec);
  
  /*-------------------------------------------------------------------
    $B%3%^%s%I%l%3!<%I$,<h$l$?$i0z?t$r%3%T!<$9$k!#(B

      $B!&E>AwJ}8~$,(Bdata in$B$G3n$D0z?t(BData$B$N(BMRB$B$,!|$N;~$O!"7k2L$N3JG<$N$?$a$K(B
        $B%3%T!<$r$D$/$C$F$=$l$rMQ$$$k!#(B
        $B$?$@$7!"%R!<%WITB-$G%3%T!<$,$G$-$J$+$C$?;~$K$O3d$jEv$F$?%3%^%s%I(B
        $B%l%3!<%I$r%U%j!<%j%9%H$KLa$7!"(BDcode$B%4!<%k$r%(%s%-%e!<$7$F=*$k!#(B
      $B!&E>AwJ}8~$,(Bdata out$B$N>l9g$O!"E>Aw%G!<%?$r%3%^%s%I%l%3!<%I$NE>Aw%P%C%U%!(B
        $B$K%3%T!<$9$k!#(B
      $B!&=PNOJQ?t$O$3$3$G3d$jEv$F$k!#(B
        $BM=Ls<u$1IU$1HV9f$K$D$$$F$OM=Ls;~E@$GJV$7$F$7$^$&!#(B
   --------------------------------------------------------------------*/

  $USE(D_WorkData1);
  s_IfMRBon(D_WorkData){
    b_IfEqualImm (D_WorkDirection, _DIR_DATA_IN){
      $USE(D_WorkDesc);
      s_GetStringDesc(D_WorkData, D_WorkDesc);
      $CALL( s_AllocStrgMRBoffWithDesc_Sub(D_WorkData1, D_WorkDesc) );
      $RELEASE(D_WorkDesc);
      b_IfWordNotEq(D_WorkData1, D_NULL) {
	  $CALL(s_CopyWordString_Sub(D_WorkData, D_WorkData1));
      }else{
	  $RELEASE(D_WorkUnit);$RELEASE(D_WorkLun);$RELEASE(D_WorkCommand);
	  $RELEASE(D_WorkLength);$RELEASE(D_WorkDirection);
	  $RELEASE(D_WorkData);$RELEASE(D_WorkDataPos);
       /*------------------------------------------------------
	   $B%R!<%WNN0hITB-$G!"%9%H%j%s%0$r@8@.$G$-$J$+$C$?;~$O!"(B
	   $B%a%b%j%Z!<%8MW5a$r=P$7!"(BDcode $B%4!<%k$r(B enqueue $B$9$k!#(B
	   $B$^$?(BD_WorkCommRec$B$N;X$9%3%^%s%I%l%3!<%I$r%U%j!<%j%9%H$KLa$9!#(B
        -------------------------------------------------------*/
	$RELEASE(D_WorkData1);
	b_SetEventFlag(_PAGE_ALLOC_FAIL_EVENT, D_PE_Number);
	s_ReclaimCommRec(D_WorkCommRec);
	$RELEASE(D_WorkCommRec);
	goto MAKE_DCODE_GOAL_ENQUEUE;
      } /*---- end of b_IfWordEq ----*/
    } else {
      p_MoveWord(D_WorkData, D_WorkData1);
    } /*---- end of b_IfEqualImm ----*/
  } else {
    p_MoveWord(D_WorkData, D_WorkData1);
  } /*---- end of s_IfMRBon ---- */
  $RELEASE(D_WorkData);

  s_IfMRBoff(I_RegArgVect){
      s_ReclaimVect7(I_RegArgVect);
  }
  /*-------------------------------------------------
   $B%5%9%Z%s%I$9$kMW0x$,$J$/$J$C$?$N$G!"(BMRB$B$,!{$J$i$P!"(B
   $B0z?t%Y%/%?$NH"$O2s<}$9$k!#(B
   --------------------------------------------------*/

  /* $BF~NO%G!<%?$r%3%^%s%I%l%3!<%I$K%3%T!<$9$k(B */
  s_SetScsiCommRecUnit(D_WorkUnit,D_WorkCommRec);
  s_SetScsiCommRecLUN(D_WorkLun ,D_WorkCommRec);
  s_SetScsiCommRecDataLength(D_WorkLength,D_WorkCommRec);
  s_SetScsiCommRecDirection(D_WorkDirection,D_WorkCommRec);
  s_SetScsiCommRecOldData(D_WorkData1, D_WorkCommRec);
  s_SetScsiCommRecDataPos(D_WorkDataPos,D_WorkCommRec);

  $USE(D_WorkElement);
  $USE(D_WorkElemSize);
  $USE(D_WorkElemPos);
  b_SetImmValueDNTC(_ELEM_SIZE_OF_STRG8, D_WorkElemSize);
  b_SetImmValueDNTC(_ZERO, D_WorkElemPos);
  s_GetStringElement
      (D_WorkCommand, D_WorkElemPos, D_WorkElemSize, D_WorkElement);
  $RELEASE(D_WorkElemPos);
  $RELEASE(D_WorkElemSize);
  $USE(D_WorkCommLen);
  s_GetScsiCDBLength(D_WorkElement, D_WorkCommLen);
  $RELEASE(D_WorkElement);
  s_SetScsiCommRecCDBLength(D_WorkCommLen,D_WorkCommRec);

  /*---------------------------------------------------------
     D_WorkCommand$B$N;X$9(BCDB($B%P%$%H%9%H%j%s%0(B)$B$r%3%^%s%I%l%3!<%ICf$N(B
     CDB Slot$B$K%3%T!<$9$k!#(B
   ------------------------------------------------------------*/ 
  $USE(D_WorkCDB);
  s_GetScsiCommRecPtrToCDB(D_WorkCommRec, D_WorkCDB);
  $CALL( s_CopyWordString_Sub(D_WorkCommand, D_WorkCDB));
  $USE(D_WorkElemSize);
  b_SetImmValueDNTC(_ELEM_SIZE_OF_STRG8, D_WorkElemSize);
  b_IncrementReg(D_WorkCommLen);
  s_PutStringElement(D_WorkCDB, D_WorkCommLen, D_WorkElemSize, D_NULL);
  /* $B:G8e$N%3%s%H%m!<%k%P%$%H$rF~$l$k!#(B(0-padding) */
  $RELEASE(D_WorkElemSize);
  $RELEASE(D_WorkCommLen);
  $RELEASE(D_WorkCDB);
  $RELEASE(D_WorkCommand);

  b_IfEqualImm(D_WorkDirection, _DIR_DATA_OUT){
      $USE(D_WorkDataBuff);
      s_GetScsiCommRecPtrToDataBuff(D_WorkCommRec, D_WorkDataBuff);
      $USE(D_WorkRestSize);
      f_CopyByteSubStringByWord(D_WorkData1, D_WorkDataBuff, D_WorkDataPos, 
				D_WorkLength,D_WorkRestSize);
      $RELEASE(D_WorkDataBuff);
      /*-------------------------------------------------------------
       $B%3%T!<$7$?%P%$%H%9%H%j%s%0%G!<%?$NL58zMWAG?t$r%G!<%?%+%&%s%?$N(B
       $B=i4|CM$H$9$k!#(B
       --------------------------------------------------------------*/
      s_SetScsiCommRecDataPtr(D_WorkRestSize, D_WorkCommRec);
      $RELEASE(D_WorkRestSize);
  }else{
      s_SetScsiCommRecDataPtr(D_NULL, D_WorkCommRec);
  }
  $RELEASE(D_WorkDataPos);
  $RELEASE(D_WorkLength);
  $RELEASE(D_WorkDirection);
  $RELEASE(D_WorkData1);


  /*---------------------------------------------------------------
      $B=PNO0z?t$r3d$jEv$F%3%^%s%I%l%3!<%I$K%3%T!<$9$k!#(B
   ----------------------------------------------------------------*/
  /*-- (1)NEW DATA --*/
  $USE(D_WorkGoalPtr);
  $USE(D_WorkData);
  s_AllocVariable(I_RegNewData);
  s_AllocVariable(D_WorkData);
  $CALL(f_MakeUnifier_Sub(D_WorkGoalPtr, I_RegNewData, D_WorkData));
  p_Write(D_WorkGoalPtr, D_WorkData);
  s_SetScsiCommRecNewData(D_WorkData, D_WorkCommRec);

  /*-- (2)TRANSFERRED LENGTH --*/
  s_AllocVariable(I_RegTransferredLength);
  s_AllocVariable(D_WorkData);
  $CALL(f_MakeUnifier_Sub(D_WorkGoalPtr, I_RegTransferredLength, D_WorkData));
  p_Write(D_WorkGoalPtr, D_WorkData);
  s_SetScsiCommRecTransLength(D_WorkData, D_WorkCommRec);

  /*-- (3)RESULT --*/
  s_AllocVariable(I_RegResult);
  s_AllocVariable(D_WorkData);
  $CALL(f_MakeUnifier_Sub(D_WorkGoalPtr, I_RegResult, D_WorkData));
  p_Write(D_WorkGoalPtr, D_WorkData);
  s_SetScsiCommRecResult(D_WorkData, D_WorkCommRec);
  $RELEASE(D_WorkData);
  $RELEASE(D_WorkGoalPtr);

  /*-- (4)ID --*/
  s_GetScsiID(D_WorkCommRec, I_RegID);
                                 /*ID$B$OB(:B$K7hDj$7!"0z?t%l%8%9%?$KJV$9!#(B*/

  /*--------------------------------------------------------------
      $B%3%^%s%I$N<B9T=`Hw$,=*$j!"<!$NM=Ls$,2DG=$K$J$k$H(BNewScsi$B$K<!$N(B
      $BM=Ls$N$?$a$N(BSCSI$B7?%G!<%?$rJV$9!#(B
   ---------------------------------------------------------------*/
  p_MoveWord(I_RegScsi, I_RegNewScsi); 
    

  /* $B$=$NB>(B */
  s_SetScsiCommRecFPPtr(D_Current_FP_Ptr, D_WorkCommRec);
/*  s_IncrementFPChildCount(D_Current_FP_Ptr); */
  /*--------------------------------------------------------------------
    $B%3%^%s%I%l%3!<%ICf$K$O%+%l%s%HN$?F$N%]%$%s%?$r3JG<$9$k$?$a!"(B
    $BN$?F$,;2>H$K5$IU$+$:$K=*N;$7$J$$$h$&$K(BChildCount$B$r%$%s%/%j%a%s%H$7$F$*$/!#(B
   ---------------------------------------------------------------------*/
  s_SetScsiCommRecEnvironment(D_CurrentEnvRecPtr, D_WorkCommRec);

  s_InitializeScsiCommRecDataCtr(D_WorkCommRec);
  s_InitializeScsiCommRecCancelFlag(D_WorkCommRec);
  s_InitializeScsiCommRecStatus(D_WorkCommRec);
  s_InitializeScsiCommRecResultCode(D_WorkCommRec);
  s_InitializeScsiCommRecErrorCode(D_WorkCommRec);
    
/*------------------------------------------------------------------
   $B$3$3$^$G$G%3%^%s%I%l%3!<%I$N=`Hw$,=*N;!#$3$3$+$i<B:]$N%3%^%s%I$N<B9T$,(B
   $B;n$_$i$l$k!#(B
--------------------------------------------------------------------*/
  $CALL(i_SCSIDeviceDriverInitiatorMain_Sub
	(D_WorkCommRec, D_WorkUnit, D_WorkLun));
  $RELEASE(D_WorkLun);
  $RELEASE(D_WorkUnit);
  $RELEASE(D_WorkCommRec);
  goto End_of_KL1B_Instruction;

 MAKE_DCODE_GOAL_ENQUEUE:
  f_DcodeEnqueue7Ope_IIOOOOO
      (BLT_B_SCSI_COMMAND, I_RegScsi, I_RegArgVect,I_RegNewData,
       I_RegTransferredLength, I_RegID, I_RegResult, I_RegNewScsi);
 
 End_of_KL1B_Instruction:;
}

/******************************************************************** PSL **
i_ScsiCommandExceptionCheck
               (scsi, arg_vect, excep_flag, excep_code, excep_arg_pos)

       written by f-doumae@icot22      on Mon Feb  4 11:10:51 1991
<Arguments>
    scsi     : $BF~NO0z?t(BSCSI
    arg_vect : $BF~NO0z?t%Y%/%?(B {Unit,LUN,Command,Length,Direction,Data,DataP}
    excep_flag : $B%(%/%;%W%7%g%s$,H/@8$7$?$+$I$&$+$r<($9%U%i%0(B(destination)
    excep_code       : $BNc30%3!<%I(B(destination)
    excep_arg_pos    : $BNc30$,5/$-$?0z?t0LCV(B(destination)
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    scsi_command/7 $B$NF~NO0z?t$NNc30%A%'%C%/$r9T$J$&!#(B
    $BNc30$,5/$-$?>l9g!"%(%/%;%W%7%g%s%3!<%I!"%(%/%;%W%7%g%s$r5/$3$7$?0z?t0LCV!"(B
    $B%U%i%0$N@_Dj$r9T$J$&!#(B
    arg_vect $B$NMWAG$O%G%l%U%!%l%s%9$r$9$k$H$H$b$K%Y%/%?K\BN$K=q$-La$7$r$9$k!#(B
<Examples>
<Test>
<Explanation>
    $BNc30%A%'%C%/$N;EMM$O(BPIM$B<B5!Kh$K$3$H$J$k2DG=@-$,$"$k!#(B
    ($B%P%C%U%!%5%$%:$J$I$O(BPIM$B<B5!$N%^%7%s9=@.$K$h$C$F0[$J$jF@$k!#(B)

    scsi_command/7 $B$O(BKL1$B%G%P%$%9%I%i%$%P$N%7%9%F%`5-=R<T$N$_$,;HMQ$9$k(B
    $BAH$_9~$_=R8l$G$"$k$?$a!"Nc30%A%'%C%/$O(BKL1$B%G%P%$%9%I%i%$%P$N%G%P%C%0MQ(B
    $B$H9M$($F$$$k!#(B($B8=:_$N$H$3$m(BKL1$B%G%P%$%9%I%i%$%P$GNc30$r@Q6KE*$KMQ$$$k(B
    $B$3$H$O9M$($i$l$F$$$J$$!#(B)
********************************************************************* PSL **/
#PSL_define i_ScsiCommandExceptionCheck
                       (scsi, arg_vect, excep_flag, excep_code, excep_arg_pos)
{
  $USE(D_Workreg1);

/*---------- $BBh(B1$B0z?t$N%A%'%C%/(B ----------------*/
  f_ActiveDeref(scsi, D_Workreg1);
  s_IfNotINT(scsi){ 
      s_IfUnbound(scsi){
	  @DEBUG{WARNING("i_ScsiCommandExceptionCheck","scsi");};
	  p_MoveWord(D_Workreg1, scsi);
	  $RELEASE(D_Workreg1);
	  b_SetZero( excep_flag );	/* $BNc30$G$O$J$$(B */
	  goto END;
      }else{
	  $RELEASE(D_Workreg1);
	  b_SetImmTypeValueMRBoff (INT, _ZERO, excep_arg_pos);
	  b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, excep_code);
	  p_MoveWord(D_ONE, excep_flag);
	  goto END;
      }
  }

/*---------- $BBh(B2$B0z?t$N%A%'%C%/(B ----------------*/
  f_ActiveDeref(arg_vect, D_Workreg1);
  s_IfNotVECT7(arg_vect){ 
      s_IfUnbound(arg_vect){
	  @DEBUG{WARNING("i_ScsiCommandExceptionCheck","arg_vect");};
	  p_MoveWord(D_Workreg1, arg_vect);
	  $RELEASE(D_Workreg1);
	  b_SetZero( excep_flag );	/* $BNc30$G$O$J$$(B */
	  goto END;
      }else{
	  $RELEASE(D_Workreg1);
	  b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
	  b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, excep_code);
	  p_MoveWord(D_ONE, excep_flag);
	  goto END;
      }
  }
  $RELEASE(D_Workreg1);

  $USE(D_WorkUnit); $USE(D_WorkLun); $USE(D_WorkCommand); $USE(D_WorkLength);
  $USE(D_WorkDirection); $USE(D_WorkData); $USE(D_WorkDataPos);
  /* $BF~NO0z?t%Y%/%?MWAG$NFI$_=P$7(B */
  s_ReadWithOffsetMRBor(arg_vect, _SCSI_COMM_UNIT_OFST, D_WorkUnit);
  s_ReadWithOffsetMRBor(arg_vect, _SCSI_COMM_LUN_OFST, D_WorkLun);
  s_ReadWithOffsetMRBor(arg_vect, _SCSI_COMM_COMMAND_OFST, D_WorkCommand);
  s_ReadWithOffsetMRBor(arg_vect, _SCSI_COMM_LENGTH_OFST, D_WorkLength);
  s_ReadWithOffsetMRBor(arg_vect, _SCSI_COMM_DIRECTION_OFST, D_WorkDirection);
  s_ReadWithOffsetMRBor(arg_vect, _SCSI_COMM_DATA_OFST, D_WorkData);
  s_ReadWithOffsetMRBor(arg_vect, _SCSI_COMM_DATA_POS_OFST, D_WorkDataPos);

  $USE(D_WorkPos);
  b_SetZero(D_WorkPos);
/*---------- $BBh(B2$B0z?t(B($BBh(B0$BMWAG(B)$B$N%A%'%C%/(B ----------------*/
  f_DerefElementReg(arg_vect, D_WorkPos, D_WorkUnit);
  s_IfINT(D_WorkUnit){
      b_IfScsiRangeErr
	  (D_WorkUnit, _SCSI_MIN_UNIT_NUMBER, _SCSI_MAX_UNIT_NUMBER){
	      $RELEASE(D_WorkPos);
	      b_SetImmTypeValueMRBoff (INT, _RANGE_OVERFLOW_EXCP, excep_code);
	      b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
	      goto EXCEPTION;
	  }
  }else{
      $RELEASE(D_WorkPos);
      s_IfREF(D_WorkUnit){ goto CHECK_END;}
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, excep_code);
      b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
      goto EXCEPTION;
  }
/*---------- $BBh(B2$B0z?t(B($BBh(B1$BMWAG(B)$B$N%A%'%C%/(B ----------------*/
  b_IncrementAddrReg(D_WorkPos);
  f_DerefElementReg(arg_vect, D_WorkPos, D_WorkLun);
  s_IfINT(D_WorkLun){
      b_IfScsiRangeErr(D_WorkLun, _SCSI_MIN_LUN, _SCSI_MAX_LUN){
	  $RELEASE(D_WorkPos);
	  b_SetImmTypeValueMRBoff 
	      (INT, _RANGE_OVERFLOW_EXCP, excep_code);
	  b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
	  goto EXCEPTION;
      }
  }else{
      $RELEASE(D_WorkPos);
      s_IfREF(D_WorkLun){ goto CHECK_END;}
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, excep_code);
      b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
      goto EXCEPTION;
  }
/*---------- $BBh(B2$B0z?t(B($BBh(B2$BMWAG(B)$B$N%A%'%C%/(B ----------------*/
  b_IncrementAddrReg(D_WorkPos);
  f_DerefElementReg(arg_vect, D_WorkPos, D_WorkCommand);
  s_IfSTRG(D_WorkCommand){
      $USE(D_WorkTypeCheckReg);
      $USE(D_WorkStringLen);
      s_GetStringType(D_WorkCommand, D_WorkStringLen, D_WorkTypeCheckReg);
      b_IfNotEqualImm(D_WorkTypeCheckReg, _ELEM_SIZE_OF_STRG8){
	  $RELEASE(D_WorkPos);
	  $RELEASE(D_WorkTypeCheckReg);
	  $RELEASE(D_WorkStringLen);
	  b_SetImmTypeValueMRBoff (INT,_ILLEGAL_INPUT_EXCP, excep_code);
	  b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
	  goto EXCEPTION;
      }
      $RELEASE(D_WorkTypeCheckReg);
      f_IfScsiInvalidPhysicalCommandLength(D_WorkStringLen){
	  $RELEASE(D_WorkPos);
	  $RELEASE(D_WorkStringLen);
	  b_SetImmTypeValueMRBoff 
	      (INT, _RANGE_OVERFLOW_EXCP, excep_code);
	  b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
	  goto EXCEPTION;
      }
      $RELEASE(D_WorkStringLen);
      $USE(D_WorkElement);
      $USE(D_WorkElemSize);
      $USE(D_WorkElemPos);
      b_SetImmValueDNTC(_ELEM_SIZE_OF_STRG8, D_WorkElemSize);
      b_SetImmValueDNTC(_ZERO, D_WorkElemPos);
      s_GetStringElement
	  (D_WorkCommand, D_WorkElemPos, D_WorkElemSize, D_WorkElement);
      $RELEASE(D_WorkElemPos);
      $RELEASE(D_WorkElemSize);
      $USE(D_WorkCommLen);
      s_GetScsiCDBLength(D_WorkElement, D_WorkCommLen);
      $RELEASE(D_WorkElement);
      f_IfScsiInvalidLogicalCommandLength(D_WorkCommLen){
	  $RELEASE(D_WorkPos);
	  $RELEASE(D_WorkCommLen);
	  b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, excep_code);
	  b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
	  goto EXCEPTION;
      }
      $RELEASE(D_WorkCommLen);
  }else{
      $RELEASE(D_WorkPos);
      s_IfREF(D_WorkCommand){ goto CHECK_END;}
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, excep_code);
      b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
      goto EXCEPTION;
  }
/*---------- $BBh(B2$B0z?t(B($BBh(B3$BMWAG(B)$B$N%A%'%C%/(B ----------------*/
  b_IncrementAddrReg(D_WorkPos);
  f_DerefElementReg(arg_vect, D_WorkPos, D_WorkLength);
  s_IfINT(D_WorkLength){
      b_IfScsiRangeErr(D_WorkLength, _ZERO, _MAX_LEN_OF_TRANS_DATA_IN_COMMAND){
	  $RELEASE(D_WorkPos);
	  b_SetImmTypeValueMRBoff (INT, _RANGE_OVERFLOW_EXCP, excep_code);
	  b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
	  goto EXCEPTION;
      }
  }else{
      $RELEASE(D_WorkPos);
      s_IfREF(D_WorkLength){ goto CHECK_END;}
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, excep_code);
      b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
      goto EXCEPTION;
  }
/*---------- $BBh(B2$B0z?t(B($BBh(B4$BMWAG(B)$B$N%A%'%C%/(B ----------------*/
  b_IncrementAddrReg(D_WorkPos);
  f_DerefElementReg(arg_vect, D_WorkPos, D_WorkDirection);
  s_IfINT(D_WorkDirection){
      b_IfScsiRangeErr(D_WorkDirection, _ZERO, _TWO){
	  $RELEASE(D_WorkPos);
	  b_SetImmTypeValueMRBoff (INT,_RANGE_OVERFLOW_EXCP,excep_code);
	  b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
	  goto EXCEPTION;
      }
  }else{
      $RELEASE(D_WorkPos);
      s_IfREF(D_WorkDirection){ goto CHECK_END;}
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, excep_code);
      b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
      goto EXCEPTION;
  }
/*---------- $BBh(B2$B0z?t(B($BBh(B5$BMWAG(B)$B$N%A%'%C%/(B ----------------*/
  b_IncrementAddrReg(D_WorkPos);
  f_DerefElementReg(arg_vect, D_WorkPos, D_WorkData);
  s_IfNotSTRG(D_WorkData){
      $RELEASE(D_WorkPos);
      s_IfREF(D_WorkData){ goto CHECK_END;}
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, excep_code);
      b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
      goto EXCEPTION;
  }else{
      $USE(D_WorkTypeCheckReg);
      $USE(D_WorkStringLen);
      s_GetStringType(D_WorkData, D_WorkStringLen, D_WorkTypeCheckReg);
      b_IfNotEqualImm(D_WorkTypeCheckReg, _ELEM_SIZE_OF_STRG8){
	  $RELEASE(D_WorkPos);
	  $RELEASE(D_WorkTypeCheckReg);
	  $RELEASE(D_WorkStringLen);
	  b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, excep_code);
	  b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
	  goto EXCEPTION;
      }
      $RELEASE(D_WorkTypeCheckReg);
      b_IfGreater(D_WorkLength, D_WorkStringLen){
	  $RELEASE(D_WorkPos);
	  $RELEASE(D_WorkStringLen);
	  b_SetImmTypeValueMRBoff (INT, _RANGE_OVERFLOW_EXCP, excep_code);
	  b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
	  goto EXCEPTION;
      }
  }
/*---------- $BBh(B2$B0z?t(B($BBh(B6$BMWAG(B)$B$N%A%'%C%/(B ----------------*/
  b_IncrementAddrReg(D_WorkPos);
  f_DerefElementReg(arg_vect, D_WorkPos, D_WorkDataPos);
  s_IfINT(D_WorkDataPos){
      b_IfLess(D_WorkDataPos, D_NULL){
	  $RELEASE(D_WorkPos);
	  $RELEASE(D_WorkStringLen);
	  b_SetImmTypeValueMRBoff (INT, _RANGE_OVERFLOW_EXCP, excep_code);
	  b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
	  goto EXCEPTION;
      }
      b_IfRangeOver(D_WorkDataPos, D_WorkStringLen){
	  b_IfNotZero(D_WorkDataPos){
	      /* $B%9%H%j%s%0D9#0!"%]%8%7%g%s#0$N;~$N$_!"Nc30$G$O$J$$(B */
	      $RELEASE(D_WorkPos);
	      $RELEASE(D_WorkStringLen);
	      b_SetImmTypeValueMRBoff (INT, _RANGE_OVERFLOW_EXCP, excep_code);
	      b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
	      goto EXCEPTION;
	  }
      }
      b_IfEqualImm(D_WorkDirection, _ZERO){
	  /* <- b_IfNotEqualImm , reviced by f-takei 91.6.24 */
	  $RELEASE(D_WorkStringLen);
	  $RELEASE(D_WorkPos);
	  goto CHECK_END;
      }
      b_SubtractWithDNTC(D_WorkStringLen, D_WorkDataPos, D_WorkStringLen);
      b_IfGreater(D_WorkLength, D_WorkStringLen){
	  $RELEASE(D_WorkPos);
	  $RELEASE(D_WorkStringLen);
	  b_SetImmTypeValueMRBoff (INT, _RANGE_OVERFLOW_EXCP, excep_code);
	  b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
	  goto EXCEPTION;
      }
      $RELEASE(D_WorkStringLen);
  }else{
      $RELEASE(D_WorkStringLen);
      $RELEASE(D_WorkPos);
      s_IfREF(D_WorkDataPos){ goto CHECK_END;}
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, excep_code);
      b_SetImmValueDNTC (_ONE, excep_arg_pos);
      goto EXCEPTION;
  }

  $RELEASE(D_WorkPos);
 CHECK_END:
  $RELEASE(D_WorkUnit); $RELEASE(D_WorkLun); $RELEASE(D_WorkCommand); 
  $RELEASE(D_WorkLength); $RELEASE(D_WorkDirection); $RELEASE(D_WorkData); 
  $RELEASE(D_WorkDataPos);

  b_SetZero(excep_flag);
  goto END;

 EXCEPTION:
  $RELEASE(D_WorkUnit); $RELEASE(D_WorkLun); $RELEASE(D_WorkCommand); 
  $RELEASE(D_WorkLength); $RELEASE(D_WorkDirection); $RELEASE(D_WorkData); 
  $RELEASE(D_WorkDataPos);

  p_MoveWord(D_ONE, excep_flag);

 END:
  ;
}

/******************************************************************** PSL **
SUBROUTINE i_SCSIDeviceDriverInitiatorMain_Sub(A_CommRec, A_Unit, A_LUN)

       written by f-doumae@icot22      on Tue Nov 13 15:12:49 1990
<Arguments>
  A_CommRec : $B%3%^%s%I%l%3!<%I$X$N%]%$%s%?(B
  A_Unit    : $B%f%K%C%HHV9f(B
  A_LUN     : $BO@M}%f%K%C%HHV9f(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    scsi_command $B$+$i8F$S=P$5$l$k%G%P%$%9%I%i%$%PK\BN$N%H%C%W%l%Y%k!#(B
    $B%-%e!<$+$i<h$j=P$5$l$k%l%3!<%I$,%3%^%s%I!"E>Aw$H8r8_$K7+$jJV$5$l$k$H(B
    $B$=$l$>$l$N=hM}$,B?CJ$K%M%9%H$9$k$?$a!"$=$l$rHr$1$k$h$&$K$3$3$G@)8f$9$k!#(B

<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#DATA_define D_WorkRecord  XXX

#SUBARG_define A_CommRec  MODIFY
#SUBARG_define A_Unit     SRC
#SUBARG_define A_LUN      SRC

#SUBROUTINE i_SCSIDeviceDriverInitiatorMain_Sub(A_CommRec, A_Unit, A_LUN)
{
  /* $B;XDj$5$l$?(BUnit,LUN$B$G<B9TCf!"$^$?$O%P%98"BT$A$N%3%^%s%I$,$J$$$+$rD4$Y$k!#(B
     ($B%P%98"%-%e!<!"<B9TCf%j%9%H$r%9%-%c%s(B)                                */
  $USE(D_WorkRecord);
  f_SearchCommRecWithUnitAndLUN
      (D_ScsiBusFreeWaitingTop, A_Unit, A_LUN, D_WorkRecord);
  s_IfNotScsiCommRec(D_WorkRecord){ /* $B%P%98"%-%e!<$KB8:_$7$J$$>l9g(B */
    f_SearchCommRecWithUnitAndLUN
	(D_ScsiExecutingListTop, A_Unit, A_LUN, D_WorkRecord);
    s_IfNotScsiCommRec(D_WorkRecord){ /* $B<B9TCf%j%9%H$K$bB8:_$7$J$$>l9g(B */
	$RELEASE(D_WorkRecord);
	$CALL( i_SCSIDeviceDriverInitiatorBody_Sub (A_CommRec));
	f_IfArbitrationFailure(A_CommRec){ goto END;}
    }else{ /* $B%P%98"%-%e!<$KB8:_$9$k>l9g(B */ /* $B"*<B9TCf%j%9%H$KB8:_$9$k>l9g(B? */
	$RELEASE(D_WorkRecord);
	f_EnqueueToReserv (A_CommRec);
	/* $B8=:_$N%3%^%s%I%l%3!<%I$X$N%]%$%s%?$rM=Ls%-%e!<$KF~$l$k!#(B*/
    }
  }else{ /* $B<B9TCf%j%9%H$KB8:_$9$k>l9g(B */ /* $B"*%P%98"%-%e!<$KB8:_$9$k>l9g(B? */
      $RELEASE(D_WorkRecord);
      f_EnqueueToReserv (A_CommRec);
      /* $B8=:_$N%3%^%s%I%l%3!<%I$X$N%]%$%s%?$rM=Ls%-%e!<$KF~$l$k!#(B*/
  }
/*  $RELEASE(D_WorkRecord); */

  i_SCSIDeviceDriver();

 END:
  $RETURN();
}

/******************************************************************** PSL **
SUBROUTINE i_SCSIDeviceDriverInitiatorBodyTemp_Sub (A_CommRec)

       written by f-doumae@icot22      on Tue Nov 13 15:54:13 1990
<Arguments>
  A_CommRec : $B%3%^%s%I%l%3!<%I$X$N%]%$%s%?(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    $B%G%P%$%9%I%i%$%P(B($B%$%K%7%(!<%?(B)$B$NK\BN!#(B
    $B%$%K%7%(!<%?$N%U%'!<%:$NA+0\$r@)8f$9$k!#(B
    $B%P%98"%-%e!<$+$i%3%^%s%I%l%3!<%I$,<h$j=P$5$l$k4V$O%$%K%7%(!<%?$H$7$F$N(B
    $B=hM}$r7+$jJV$9!#%P%98"%-%e!<$+$iE>Aw%l%3!<%I$,<h$j=P$5$l$?;~!"$^$?$O(B
    $B%-%e!<$,6u$K$J$C$?;~(Bi_SCSIDeviceDriverInitiatorMain_Sub $B$KJV$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#SUBARG_define A_CommRec       MODIFY

#SUBROUTINE i_SCSIDeviceDriverInitiatorBodyTemp_Sub(A_CommRec)
{
  $USE(D_WorkNextPhase);
  $CALL(f_ScsiSelectionPhase_Sub(A_CommRec, D_WorkNextPhase));

  LOOP(){
      ValueSwitch(D_WorkNextPhase){
	case _ARBITRATION_FAILURE:
	  b_SetEOL(A_CommRec); /* $B%"!<%S%H%l!<%7%g%s<:GT(B */
	  goto END;
	case _COMMAND_TRANSFER:
	  $CALL( f_ScsiCommandTransferPhase_Sub(A_CommRec, D_WorkNextPhase));
	  break;
	case _DATA_TRANSFER:
	  $CALL( f_ScsiDataTransferPhase_Sub(A_CommRec, D_WorkNextPhase));
          break;
	case _STATUS_TRANSFER:
	  $CALL( f_ScsiStatusTransferPhase_Sub(A_CommRec, D_WorkNextPhase));
          break;
	case _INITIATOR_TERMINATE:
	  $CALL( f_ScsiInitiatorTerminate_Sub(A_CommRec, D_WorkNextPhase));
          break;
	case _RESELECTED:
	  $CALL( f_ScsiReselected_Sub());
	  goto END;
	case _SELECTED:
	  $CALL( f_ScsiSelected_Sub());
	  goto END;
	case _RESULT_REPORT:
	  $CALL( f_ScsiInitiatorResultReport_Sub(A_CommRec));
	  /*-------------------------------------------------------
           $B$3$3$G(B1$B$D$N%3%^%s%I$N<B9T$,40N;$9$k!#(B
          ----------------------------------------------------------*/
	  f_ScsiQueueManagementOnCommandEnd(A_CommRec);
	  goto END;
	case _ERROR_END:
	  $CALL(f_ScsiResetConditionHandling_Sub(A_CommRec));
	  goto END;
	default:
	  @DEBUG{
	      VPIM_ERROR("i_SCSIDeviceDriverInitiatorBodyTemp_Sub",
			 "unknown phase. What happened?");
	  };
	  break;
      }
  }

 END:
  $RELEASE(D_WorkNextPhase);
  $RETURN();
}

#DATA_define D_WorkUnit1 XXX
#DATA_define D_WorkLun1  XXX

#SUBARG_define A_CommRec       MODIFY

#SUBROUTINE i_SCSIDeviceDriverInitiatorBody_Sub(A_CommRec)
{
  $USE(D_WorkNextPhase);
 Selection:  
  $CALL(f_ScsiSelectionPhase_Sub(A_CommRec, D_WorkNextPhase));
  ValueSwitch(D_WorkNextPhase) {
    case _COMMAND_TRANSFER:
      goto Command_Transfer;
    case _RESELECTED:
      $CALL(f_ScsiReselected_Sub());
      goto Normal_End;
    case _SELECTED:
      $CALL(f_ScsiSelected_Sub());
      goto Normal_End;
    case _ARBITRATION_FAILURE:
      b_SetEOL(A_CommRec);
      goto Normal_End;
    case _ERROR_END:
      goto Error_End;
    case _FATAL_ERROR_END:
      goto Fatal_Error_End;
    case _RESULT_REPORT:
      goto Result_Report;
    case _POP_NEXT_COMM_REC:
      goto Normal_End;
    default:
      @DEBUG{
	  VPIM_ERROR("i_SCSIDeviceDriverInitiatorBody_Sub",
		     "unexpected phase. unbelievable!!!");
      };
  }

 Command_Transfer:
  $CALL(f_ScsiCommandTransferPhase_Sub(A_CommRec, D_WorkNextPhase));
  ValueSwitch(D_WorkNextPhase) {
    case _DATA_TRANSFER:
      goto Data_Transfer;
    case _RESULT_REPORT:
      goto Result_Report;
    case _POP_NEXT_COMM_REC:
      goto Normal_End;
    case _ERROR_END:
      goto Error_End;
    case _FATAL_ERROR_END:
      goto Fatal_Error_End;
    default:
      @DEBUG{
	  VPIM_ERROR("i_SCSIDeviceDriverInitiatorBody_Sub",
		     "unexpected phase. unbelievable!!!");
      };
  }

 Data_Transfer:
  $CALL(f_ScsiDataTransferPhase_Sub(A_CommRec, D_WorkNextPhase));
  ValueSwitch(D_WorkNextPhase) {
    case _STATUS_TRANSFER:
      goto Status_Transfer;
    case _RESULT_REPORT:
      goto Result_Report;
    case _POP_NEXT_COMM_REC:
      goto Normal_End;
    case _ERROR_END:
      goto Error_End;
    case _FATAL_ERROR_END:
      goto Fatal_Error_End;
    default:
      @DEBUG{
	  VPIM_ERROR("i_SCSIDeviceDriverInitiatorBody_Sub",
		     "unexpected phase. unbelievable!!!");
      };
  }

 Status_Transfer:
  $CALL(f_ScsiStatusTransferPhase_Sub(A_CommRec, D_WorkNextPhase));
  ValueSwitch(D_WorkNextPhase) {
    case _INITIATOR_TERMINATE:
      goto Initiator_Terminate;
    case _RESULT_REPORT:
      goto Result_Report;
    case _POP_NEXT_COMM_REC:
      goto Normal_End;
    case _ERROR_END:
      goto Error_End;
    case _FATAL_ERROR_END:
      goto Fatal_Error_End;
    default:
      @DEBUG{
	  VPIM_ERROR("i_SCSIDeviceDriverInitiatorBody_Sub",
		     "unexpected phase. unbelievable!!!");
      };
  }

 Initiator_Terminate:
  $CALL(f_ScsiInitiatorTerminate_Sub(A_CommRec, D_WorkNextPhase));
  ValueSwitch(D_WorkNextPhase) {
    case _RESULT_REPORT:
      goto Result_Report;
    case _POP_NEXT_COMM_REC:
      goto Normal_End;
    case _ERROR_END:
      goto Error_End;
    case _FATAL_ERROR_END:
      goto Fatal_Error_End;
    default:
      @DEBUG{
	  VPIM_ERROR("i_SCSIDeviceDriverInitiatorBody_Sub",
		     "unexpected phase. unbelievable!!!");
      };
  }

 Result_Report:
  $CALL(f_ScsiInitiatorResultReport_Sub(A_CommRec));
  /*-------------------------------------------------------
      $B$3$3$G(B1$B$D$N%3%^%s%I$N<B9T$,40N;$9$k!#(B
      $B%3%^%s%I%l%3!<%I$r%U%j!<%j%9%H$KJV$9;~!"%3%^%s%I%l%3!<%I%U%j!<%j%9%H(B
      $BBT$A%-%e!<$K%4!<%k%l%3!<%I$,$"$l$P$=$l$r%l%G%#%4!<%k%9%?%C%/$KF~$l$k!#(B
  ----------------------------------------------------------*/
  f_ScsiQueueManagementOnCommandEnd(A_CommRec);
  /*-------------------------------------------------------
  f_ScsiQueueManagementOnCommandEnd(A_CommRec)$B$N=hM}FbMF(B

  $B!&(BA_CommRec$B$N;X$9%3%^%s%I%l%3!<%I$r%U%j!<%j%9%H$KLa$9(B
  $B!&N$?F$N(BChildCount$B$r(B1$B8:$i$9(B
  $B!&%3%^%s%I%l%3!<%I$N%U%j!<%j%9%HBT$A$N%4!<%k$,$"$l$P%j%9%1%8%e!<%k$9$k(B
  $B!&F1$8(BUnit,LUN$B$G<B9T$rBT$C$F$$$?%3%^%s%I$,M=Ls%-%e!<$K$"$l$P(B
    $B%P%98"%-%e!<$K0\$9!#(B
  ---------------------------------------------------------*/
  goto Normal_End;

 Error_End:
  $CALL(f_ScsiResetConditionHandling_Sub(A_CommRec));
  goto Normal_End;

 Fatal_Error_End:
  $CALL(f_ScsiFatalErrorEnd_Sub(D_NULL, A_CommRec));

 Normal_End:
  $RELEASE(D_WorkNextPhase);
  $RETURN();
}

/******************************************************************** PSL **
kblt_b_scsi_transfer(SCSI,InVect,^NewData,^TransferredLength,^Result,^NewSCSI)

       written by f-takei@icot22      on Wed Sep 12 16:56:48 1990
       revised by f-takei@icot22      on Thu Nov  7 21:43:48 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    $B%?!<%2%C%H5!G=!#(B
    

<Examples>
<Test>
<Explanation>
<ETC>
<Revised Memo on "Nov  7">
  $BE>AwJ}8~(B data out $B$G0z?t(BData$B$N(BMRB$B!|$N>l9g$K%9%H%j%s%0%G!<%?$N%3%T!<$N:n@.!"(B
  $B$*$h$SE>AwJ}8~(B data in $B$G$N0z?t%G!<%?$NE>Aw%l%3!<%I$X$N%3%T!<$H$J$C$F$$$?$,!"(B
  $B@5$7$/$O!"A0<T$,!XE>AwJ}8~$,%$%s%W%C%H!Y!"8e<T$,!XE>AwJ}8~$,%"%&%H%W%C%H!Y$H(B
  $B$J$i$J$1$l$P$J$i$J$$!#(B
  $B$3$l$^$G$N;EMM=q$G$O$9$Y$F(B "data out", "data in" $B$H$J$C$F$$$?$,!"=$@5$9$Y$-(B
  $B$G$"$k!#(B
********************************************************************* PSL **/
#CONST_define _SCSI_MIN_KIND                0
#CONST_define _SCSI_MAX_KIND                7

/* $BF~NO0z?t%Y%/%?Cf$NMWAG0LCV(B */
#ADDR_define _SCSI_TRANS_UNIT_OFST          0
#ADDR_define _SCSI_TRANS_LUN_OFST           1      
#ADDR_define _SCSI_TRANS_KIND_OFST          2
#ADDR_define _SCSI_TRANS_LENGTH_OFST        3
#ADDR_define _SCSI_TRANS_CONTINUE_OFST      4
#ADDR_define _SCSI_TRANS_DATA_OFST          5
#ADDR_define _SCSI_TRANS_DATA_POS_OFST      6

#OPF_define I_RegScsi       _IndirectRegField1          /* $BF~NO(B */
#OPF_define I_RegArgVect    _IndirectRegField2          /* $BF~NO%Y%/%?(B */
#OPF_define I_RegNewData    _IndirectRegField3          /* $B=PNO(B */
#OPF_define I_RegTransferredLength   _IndirectRegField4 /* $B=PNO(B */
#OPF_define I_RegResult     _IndirectRegField5          /* $B=PNO(B */
#OPF_define I_RegNewScsi    _IndirectRegField6          /* $B=PNO(B */

#PSL_define kblt_b_scsi_transfer()
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp6ArgVect_IIOOOO_Sub(D_WorkArgVect,
					   I_RegScsi,
					   I_RegArgVect,
					   I_RegNewData,
					   I_RegTransferredLength,
					   I_RegResult,
					   I_RegNewScsi));
      f_TraceBodyBuiltin(BLT_B_SCSI_TRANSFER,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

/**** $BNc30%A%'%C%/(B ****/
  $USE(D_WorkFlagReg);
  $USE(D_WorkExceptionCode);
  $USE(D_WorkExcepArgPos);
  i_ScsiTransferExceptionCheck(I_RegScsi, I_RegArgVect, D_WorkFlagReg,
			       D_WorkExceptionCode, D_WorkExcepArgPos);
/*------------------------------------------------------------- 
  i_ScsiTransferExceptionCheck $B$G$O0z?t%Y%/%?(BI_RegArgVect$B$N(B
  $B3FMWAG$N%G%l%U%!%l%s%9$H=q$-La$7$r9T$J$C$F$$$k!#(B
  $B%(%/%;%W%7%g%s$,5/$3$C$?>l9g!"(B
      D_WorkFlagReg       : 0$B$G$J$$CM(B
      D_WorkExceptionCode : $B%(%/%;%W%7%g%s%3!<%I(B
      D_WorkExcepArgPos   : $B%(%/%;%W%7%g%s$r5/$3$7$?0z?t0LCV(B
  $B$,JV$k!#(B
---------------------------------------------------------------*/
  b_IfNotZero(D_WorkFlagReg){ /* $B%(%/%;%W%7%g%s$,H/@8$7$?>l9g(B */
      $RELEASE(D_WorkFlagReg);
      $USE(D_WorkOpCode);
      b_SetImmTypeValueMRBoff(INT, BLT_B_SCSI_TRANSFER, D_WorkOpCode);
      $CALL (f_Exception_6Arg_IIOOOO_Sub
	     (D_WorkExceptionCode,D_WorkOpCode, D_WorkExcepArgPos, 
	      I_RegScsi, I_RegArgVect, I_RegNewData, 
	      I_RegTransferredLength, I_RegResult, I_RegNewScsi));
      $RELEASE(D_WorkOpCode);
      $RELEASE(D_WorkExceptionCode);
      $RELEASE(D_WorkExcepArgPos);
      goto End_of_KL1B_Instruction;
  }
  $RELEASE(D_WorkExceptionCode);
  $RELEASE(D_WorkExcepArgPos);
  $RELEASE(D_WorkFlagReg);

  
/**** $BL$B+G{JQ?t%A%'%C%/(B ****/

/*----------------------------------------------------------*/
/* I_RegScsi,I_RegArgVect$B$H$b%G%l%U$NI,MW$O$J$$(B             */
/* $B4{$K(Bi_ScsiTransferExceptionCheck $B$G%G%l%U$5$l$F$$$k!#(B    */
/*----------------------------------------------------------*/
  
/*---------- $BBh(B1$B0z?t$N%A%'%C%/(B -----------------------------*/
  s_IfREF(I_RegScsi){
      goto MAKE_DCODE_GOAL_ENQUEUE;
  }

/*---------- $BBh(B2$B0z?t$N%A%'%C%/(B -----------------------------*/
  s_IfREF(I_RegArgVect){
      goto MAKE_DCODE_GOAL_ENQUEUE;
  }

/*---------- $BBh(B2$B0z?t$N3FMWAG$N%A%'%C%/(B ---------------------*/
/*---------- $BBh(B2$B0z?t(B($BBh(B0$BMWAG(B)$B$N%A%'%C%/(B ----------------*/
  $USE(D_WorkUnit);
  p_ReadWithOffset(I_RegArgVect, _SCSI_TRANS_UNIT_OFST, D_WorkUnit);
  s_IfREF(D_WorkUnit){
      $RELEASE(D_WorkUnit);
      goto MAKE_DCODE_GOAL_ENQUEUE;
  }
/*---------- $BBh(B2$B0z?t(B($BBh(B1$BMWAG(B)$B$N%A%'%C%/(B ----------------*/
  $USE(D_WorkLun);
  p_ReadWithOffset(I_RegArgVect, _SCSI_TRANS_LUN_OFST, D_WorkLun);
  s_IfREF(D_WorkLun){
      $RELEASE(D_WorkUnit);$RELEASE(D_WorkLun);
      goto MAKE_DCODE_GOAL_ENQUEUE;
  }
/*---------- $BBh(B2$B0z?t(B($BBh(B2$BMWAG(B)$B$N%A%'%C%/(B ----------------*/
  $USE(D_WorkKind);
  p_ReadWithOffset(I_RegArgVect, _SCSI_TRANS_KIND_OFST, D_WorkKind);
  s_IfREF(D_WorkKind){
      $RELEASE(D_WorkUnit);$RELEASE(D_WorkLun);$RELEASE(D_WorkKind);
      goto MAKE_DCODE_GOAL_ENQUEUE;
  }
/*---------- $BBh(B2$B0z?t(B($BBh(B3$BMWAG(B)$B$N%A%'%C%/(B ----------------*/
  $USE(D_WorkLength);
  p_ReadWithOffset(I_RegArgVect, _SCSI_TRANS_LENGTH_OFST, D_WorkLength);
  s_IfREF(D_WorkLength){
      $RELEASE(D_WorkUnit);$RELEASE(D_WorkLun);$RELEASE(D_WorkKind);
      $RELEASE(D_WorkLength);
      goto MAKE_DCODE_GOAL_ENQUEUE;
  }
/*---------- $BBh(B2$B0z?t(B($BBh(B4$BMWAG(B)$B$N%A%'%C%/(B ----------------*/
  $USE(D_WorkContinue);
  p_ReadWithOffset(I_RegArgVect, _SCSI_TRANS_CONTINUE_OFST, D_WorkContinue);
  s_IfREF(D_WorkContinue){
      $RELEASE(D_WorkUnit);$RELEASE(D_WorkLun);$RELEASE(D_WorkKind);
      $RELEASE(D_WorkLength);$RELEASE(D_WorkContinue);
      goto MAKE_DCODE_GOAL_ENQUEUE;
  }
/*---------- $BBh(B2$B0z?t(B($BBh(B5$BMWAG(B)$B$N%A%'%C%/(B ----------------*/
  $USE(D_WorkData);
  p_ReadWithOffset(I_RegArgVect, _SCSI_TRANS_DATA_OFST, D_WorkData);
  s_IfREF(D_WorkData){
      $RELEASE(D_WorkUnit);$RELEASE(D_WorkLun);$RELEASE(D_WorkKind);
      $RELEASE(D_WorkLength);$RELEASE(D_WorkContinue);$RELEASE(D_WorkData);
      goto MAKE_DCODE_GOAL_ENQUEUE;
  }
/*---------- $BBh(B2$B0z?t(B($BBh(B6$BMWAG(B)$B$N%A%'%C%/(B ----------------*/
  $USE(D_WorkDataPos);
  p_ReadWithOffset(I_RegArgVect, _SCSI_TRANS_DATA_POS_OFST, D_WorkDataPos);
  s_IfREF(D_WorkDataPos){
      $RELEASE(D_WorkUnit);$RELEASE(D_WorkLun);$RELEASE(D_WorkKind);
      $RELEASE(D_WorkLength);$RELEASE(D_WorkContinue);$RELEASE(D_WorkData);
      $RELEASE(D_WorkDataPos);
      goto MAKE_DCODE_GOAL_ENQUEUE;
  }

/*------------------------------------------------------
  Unit,LUN$B$,0JA0$K0[>o=*N;$r5/$3$7$?%3%M%/%7%g%s$G$"$l$P(B
  $BA4$F$NF~NO0z?t$,6qBN2=$7$?;~E@$GE>Aw$r%-%c%s%;%k$9$k!#(B
--------------------------------------------------------*/
  $USE(D_WorkRecord);
  f_IfScsiErrDetectedConnection(D_WorkUnit, D_WorkLun, D_WorkRecord){
      $RELEASE(D_WorkRecord);
      /*--------------------------------------------------
	Data$B$O$=$N$^$^(BNewData$B$KJV$9!#(B
       ---------------------------------------------------*/
      p_MoveWord(D_WorkData, I_RegNewData);

      /*--------------------------------------------------
	Result$B$O%-%c%s%;%k$5$l$?$3$H$r<($9(B [] $B$rJV$9!#(B
       ---------------------------------------------------*/
      $USE(D_Workreg);
      b_SetImmTypeValueMRBoff(ATOM, _ZERO, D_Workreg);
      p_MoveWord(D_Workreg, I_RegResult);
      $RELEASE(D_Workreg);
      
      /*---------------------------------------------------
	TransferredLength $B$O<B:]$NE>Aw$,$J$$$+$i(B 0 $B$rJV$9!#(B
       ----------------------------------------------------*/
      $USE(D_WorkTransLen);
      b_SetImmTypeValueMRBoff(INT, _ZERO, D_WorkTransLen);
      p_MoveWord(D_WorkTransLen, I_RegTransferredLength);
      $RELEASE(D_WorkTransLen);
      
      /*---------------------------------------------------
	$BA`:nM=Ls%$%s%?!<%U%'%$%9$rJV$9!#(B
       ----------------------------------------------------*/
      p_MoveWord(I_RegScsi, I_RegNewScsi);

      $RELEASE(D_WorkUnit);$RELEASE(D_WorkLun);$RELEASE(D_WorkKind);
      $RELEASE(D_WorkLength);$RELEASE(D_WorkContinue);$RELEASE(D_WorkData);
      $RELEASE(D_WorkDataPos);
      goto End_of_KL1B_Instruction;
  }
  $RELEASE(D_WorkRecord);

  s_IfEmptyTransRecFreeList(){
    $RELEASE(D_WorkUnit);$RELEASE(D_WorkLun);$RELEASE(D_WorkKind);
    $RELEASE(D_WorkLength);$RELEASE(D_WorkContinue);
    $RELEASE(D_WorkData);$RELEASE(D_WorkDataPos);
    /*-----------------------------------------------------------------
       $BE>Aw%l%3!<%I$,%U%j!<%j%9%H$K$J$+$C$?$i!"(BD$B%3!<%I%4!<%k$r:n$j(B
       $BE>Aw%l%3!<%I%U%j!<%j%9%HBT$A$K$9$k!#(B
       $BE>Aw$N<B9T$,0l$D=*N;$7E>Aw%l%3!<%I$,%U%j!<%j%9%H$KJV$5$l$k(B
       $B;~!"E>Aw%l%3!<%I%U%j!<%j%9%HBT$A$KEPO?$5$l$F$$$k%4!<%k$,$"$l$P$=$N<B9T$K(B
       $B0\$k!#(B
     ------------------------------------------------------------------*/
    f_DcodeEnqueueToTransRecFreeListWaiting(I_RegScsi,I_RegArgVect, 
	      I_RegNewData, I_RegTransferredLength, I_RegResult, I_RegNewScsi);
    goto End_of_KL1B_Instruction;
  }

  $USE(D_WorkTransRec);
  s_AllocTransRec(D_WorkTransRec);
  /*-------------------------------------------------------------------
    $BE>Aw%l%3!<%I$,<h$l$?$i0z?t$r%3%T!<$9$k!#(B

      $B!&E>AwJ}8~$,%$%s%W%C%H(B(command, data out)$B$G3n$D0z?t(BData$B$N(BMRB$B$,!|$N;~$O!"(B
        $B7k2L$N3JG<$N$?$a$K%3%T!<$r$D$/$C$F$=$l$rMQ$$$k!#(B
        $B$?$@$7!"%R!<%WITB-$G%3%T!<$,$G$-$J$+$C$?;~$K$O3d$jEv$F$?E>Aw%l%3!<%I$r(B
        $B%U%j!<%j%9%H$KLa$7!"(BDcode$B%4!<%k$r%(%s%-%e!<$7$F=*$k!#(B
      $B!&E>AwJ}8~$,%"%&%H%W%C%H(B(data in, status, message in)$B$N>l9g$O!"E>Aw%G!<%?(B
        $B$r%3%^%s%I%l%3!<%I$NE>Aw%P%C%U%!$K%3%T!<$9$k!#(B
      $B!&=PNOJQ?t$O$3$3$G3d$jEv$F$k!#(B
   --------------------------------------------------------------------*/
  $USE(D_WorkData1);
  s_IfMRBon(D_WorkData) {
    ValueSwitch(D_WorkKind){
      case _KIND_COMMAND:
      case _KIND_DATA_OUT:
	$USE(D_WorkDesc);
	s_GetStringDesc(D_WorkData, D_WorkDesc);
	$CALL( s_AllocStrgMRBoffWithDesc_Sub(D_WorkData1, D_WorkDesc) );
	$RELEASE(D_WorkDesc);
	b_IfWordNotEq(D_WorkData1, D_NULL) {
	    $CALL(s_CopyWordString_Sub(D_WorkData, D_WorkData1));
	}else{
	    $RELEASE(D_WorkUnit);$RELEASE(D_WorkLun);
	    $RELEASE(D_WorkKind);$RELEASE(D_WorkLength);
	    $RELEASE(D_WorkContinue);$RELEASE(D_WorkData);
	    $RELEASE(D_WorkDataPos);
	    /*------------------------------------------------------
	      $B%R!<%WNN0hITB-$G!"%9%H%j%s%0$r@8@.$G$-$J$+$C$?;~$O!"(B
	      $B%a%b%j%Z!<%8MW5a$r=P$7!"(BDcode $B%4!<%k$r(B enqueue $B$9$k!#(B
	      $B$^$?(BD_WorkTransRec$B$N;X$9E>Aw%l%3!<%I$r%U%j!<%j%9%H$KLa$9!#(B
	     -------------------------------------------------------*/
	    $RELEASE(D_WorkData1);
	    b_SetEventFlag(_PAGE_ALLOC_FAIL_EVENT, D_PE_Number);
	    s_ReclaimTransRec(D_WorkTransRec);
	    $RELEASE(D_WorkTransRec);
	    goto MAKE_DCODE_GOAL_ENQUEUE;
	}
	break;
      default:
	p_MoveWord(D_WorkData, D_WorkData1);
	break;
    }
  } else {
    p_MoveWord(D_WorkData, D_WorkData1);
  } /*---- end of s_IfMRBon ---- */
  $RELEASE(D_WorkData);

  s_IfMRBoff(I_RegArgVect){
      s_ReclaimVect7(I_RegArgVect); 
  }
  /*-------------------------------------------------------------
   $BJQ?t%A%'%C%/$,=*$C$?$N$G!"(BMRB$B!{$J$i$P0z?t%Y%/%?$NH"$O2s<}$9$k!#(B
   -------------------------------------------------------------*/

  /* $BF~NO%G!<%?$N%3%T!<(B */
  s_SetScsiTransRecUnit(D_WorkUnit,D_WorkTransRec);
  s_SetScsiTransRecLUN(D_WorkLun ,D_WorkTransRec);
  s_SetScsiTransRecKind(D_WorkKind ,D_WorkTransRec);
  s_SetScsiTransRecDataLength(D_WorkLength,D_WorkTransRec);
  s_SetScsiTransRecContinue(D_WorkContinue,D_WorkTransRec);
  $RELEASE(D_WorkContinue);
  s_SetScsiTransRecDataPos(D_WorkDataPos,D_WorkTransRec);
  s_SetScsiTransRecOldData(D_WorkData1, D_WorkTransRec);

  ValueSwitch(D_WorkKind){
    case _KIND_DATA_IN:
    case _KIND_STATUS:
    case _KIND_MSG_IN:
      $USE(D_WorkDataBuff);
      s_GetScsiTransRecPtrToDataBuff(D_WorkTransRec, D_WorkDataBuff);
      $USE(D_WorkRestSize);
      f_CopyByteSubStringByWord(D_WorkData1, D_WorkDataBuff, D_WorkDataPos, 
				D_WorkLength, D_WorkRestSize);
      $RELEASE(D_WorkDataBuff);
      /*-------------------------------------------------------------
       $B%3%T!<$7$?%P%$%H%9%H%j%s%0%G!<%?$NL58zMWAG?t$r%G!<%?%+%&%s%?$N(B
       $B=i4|CM$H$9$k!#(B
       --------------------------------------------------------------*/
      s_SetScsiTransRecDataPtr(D_WorkRestSize, D_WorkTransRec);
      $RELEASE(D_WorkRestSize);
      break;
    default:
      s_SetScsiTransRecDataPtr(D_NULL, D_WorkTransRec);
      break;
  }
  $RELEASE(D_WorkKind);$RELEASE(D_WorkLength);$RELEASE(D_WorkDataPos);
  $RELEASE(D_WorkData1);

  /*---------------------------------------------------------------
      $B=PNO0z?t$r3d$jEv$FE>Aw%l%3!<%I$K%3%T!<$9$k!#(B
   ----------------------------------------------------------------*/
  /*-- (1) NEW DATA --*/
  $USE(D_WorkData);
  $USE(D_WorkGoalPtr);
  s_AllocVariable(I_RegNewData);
  s_AllocVariable(D_WorkData);
  $CALL(f_MakeUnifier_Sub(D_WorkGoalPtr, I_RegNewData, D_WorkData));
  p_Write(D_WorkGoalPtr, D_WorkData);
  s_SetScsiTransRecNewData(D_WorkData, D_WorkTransRec);

  /*-- (2) TRANSFERRED LENGTH --*/
  s_AllocVariable(I_RegTransferredLength);
  s_AllocVariable(D_WorkData);
  $CALL(f_MakeUnifier_Sub(D_WorkGoalPtr, I_RegTransferredLength, D_WorkData));
  p_Write(D_WorkGoalPtr, D_WorkData);
  s_SetScsiTransRecTransLength(D_WorkData, D_WorkTransRec);

  /*-- (3) RESULT --*/
  s_AllocVariable(I_RegResult);
  s_AllocVariable(D_WorkData);
  $CALL(f_MakeUnifier_Sub(D_WorkGoalPtr, I_RegResult, D_WorkData));
  p_Write(D_WorkGoalPtr, D_WorkData);
  s_SetScsiTransRecResult(D_WorkData, D_WorkTransRec);
  $RELEASE(D_WorkGoalPtr);
  $RELEASE(D_WorkData);

  /*--------------------------------------------------------------
      $BE>Aw$N<B9T=`Hw$,=*$j!"<!$NM=Ls$,2DG=$K$J$k$H(BNewScsi$B$K<!$N(B
      $BM=Ls$N$?$a$N(BSCSI$B7?%G!<%?$rJV$9!#(B
   ---------------------------------------------------------------*/
  p_MoveWord(I_RegScsi, I_RegNewScsi);

  /* $B$=$NB>(B */
  s_SetScsiTransRecFPPtr(D_Current_FP_Ptr, D_WorkTransRec);
/*  s_IncrementFPChildCount(D_Current_FP_Ptr); */
  /*--------------------------------------------------------------------
    $BE>Aw%l%3!<%ICf$K$O%+%l%s%HN$?F$N%]%$%s%?$r3JG<$9$k$?$a!"(B
    $BN$?F$,;2>H$K5$IU$+$:$K=*N;$7$J$$$h$&$K(BChildCount$B$r%$%s%/%j%a%s%H$7$F$*$/!#(B
   ---------------------------------------------------------------------*/

  s_SetScsiTransRecEnvironment(D_CurrentEnvRecPtr, D_WorkTransRec);

  s_InitializeScsiTransRecResultCode(D_WorkTransRec);
  s_InitializeScsiTransRecDataCtr(D_WorkTransRec);

/*------------------------------------------------------------------
   $B$3$3$^$G$GE>Aw%l%3!<%I$N=`Hw$,=*N;!#$3$3$+$i<B:]$NE>Aw$N<B9T$,(B
   $B;n$_$i$l$k!#(B
--------------------------------------------------------------------*/
  $CALL(i_SCSIDeviceDriverTargetMain_Sub
	(D_WorkTransRec, D_WorkUnit, D_WorkLun));
  $RELEASE(D_WorkLun);
  $RELEASE(D_WorkUnit);
  $RELEASE(D_WorkTransRec);
  goto End_of_KL1B_Instruction;

 MAKE_DCODE_GOAL_ENQUEUE:
  f_DcodeEnqueue6Ope_IIOOOO
      (BLT_B_SCSI_TRANSFER, I_RegScsi, I_RegArgVect, I_RegNewData, 
       I_RegTransferredLength, I_RegResult, I_RegNewScsi);
  goto End_of_KL1B_Instruction;

 End_of_KL1B_Instruction:
  ;
}

/******************************************************************** PSL **
i_ScsiTransferExceptionCheck
               (scsi, arg_vect, excep_flag, excep_code, excep_arg_pos)

       written by f-doumae@icot22      on Mon Feb  4 11:10:51 1991
<Arguments>
    scsi     : $BF~NO0z?t(BSCSI
    arg_vect : $BF~NO0z?t%Y%/%?(B {Unit,LUN,Kind,Length,Continue,Data,DataP}
    excep_flag : $B%(%/%;%W%7%g%s$,H/@8$7$?$+$I$&$+$r<($9%U%i%0(B(destination)
    excep_code    : $BNc30%3!<%I(B(destination)
    excep_arg_pos : $BNc30$,5/$-$?0z?t0LCV(B(destination)
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    scsi_transfer/6 $B$NF~NO0z?t$NNc30%A%'%C%/$r9T$J$&!#(B
    $BNc30$,5/$-$?>l9g$=$N0z?t0LCV$r(B excep_arg_pos $B$K!"Nc30%3!<%I$r(B excep_code
    $B$K@_Dj$9$k!#(B
    arg_vect $B$NMWAG$O%G%l%U%!%l%s%9$r$9$k$H$H$b$K%Y%/%?K\BN$K=q$-La$7$r$9$k!#(B
<Examples>
<Test>
<Explanation>
    $BNc30%A%'%C%/$N;EMM$O(BPIM$B<B5!Kh$K$3$H$J$k2DG=@-$,$"$k!#(B
    ($B%P%C%U%!%5%$%:$J$I$O(BPIM$B<B5!$N%^%7%s9=@.$K$h$C$F0[$J$jF@$k!#(B)

    scsi_transfer/6 $B$O(BKL1$B%G%P%$%9%I%i%$%P$N%7%9%F%`5-=R<T$N$_$,;HMQ$9$k(B
    $BAH$_9~$_=R8l$G$"$k$?$a!"Nc30%A%'%C%/$O(BKL1$B%G%P%$%9%I%i%$%P$N%G%P%C%0MQ(B
    $B$H9M$($F$$$k!#(B($B8=:_$N$H$3$m(BKL1$B%G%P%$%9%I%i%$%P$GNc30$r@Q6KE*$KMQ$$$k(B
    $B$3$H$O9M$($i$l$F$$$J$$!#(B)
********************************************************************* PSL **/
#PSL_define i_ScsiTransferExceptionCheck
                        (scsi, arg_vect, excep_flag, excep_code, excep_arg_pos)
{
  $USE(D_Workreg1);

/*---------- $BBh(B1$B0z?t$N%A%'%C%/(B ----------------*/
  f_ActiveDeref(scsi, D_Workreg1);
  s_IfNotINT(scsi){ 
      s_IfUnbound(scsi){
	  @DEBUG{WARNING("i_ScsiTransferExceptionCheck","scsi");};
	  p_MoveWord(D_Workreg1, scsi);
	  $RELEASE(D_Workreg1);
	  b_SetZero(excep_flag);
	  goto END;
      }else{
	  $RELEASE(D_Workreg1);
	  b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, excep_code);
	  b_SetImmTypeValueMRBoff (INT, _ZERO, excep_arg_pos);
	  p_MoveWord(D_ONE, excep_flag);
	  goto END;
      }
  }

/*---------- $BBh(B2$B0z?t$N%A%'%C%/(B ----------------*/
  f_ActiveDeref(arg_vect, D_Workreg1);
  s_IfNotVECT7(arg_vect){ 
      s_IfUnbound(arg_vect){
	  @DEBUG{WARNING("i_ScsiTransferExceptionCheck","arg_vect");};
	  p_MoveWord(D_Workreg1, arg_vect);
	  $RELEASE(D_Workreg1);
	  b_SetZero(excep_flag);
	  goto END;
      }else{
	  $RELEASE(D_Workreg1);
	  b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, excep_code);
	  b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
	  p_MoveWord(D_ONE, excep_flag);
	  goto END;
      }
  }
  $RELEASE(D_Workreg1);

  $USE(D_WorkUnit); $USE(D_WorkLun); $USE(D_WorkKind); $USE(D_WorkLength);
  $USE(D_WorkContinue); $USE(D_WorkData); $USE(D_WorkDataPos);
  /* $BF~NO0z?t%Y%/%?MWAG$NFI$_=P$7(B */
  s_ReadWithOffsetMRBor(arg_vect, _SCSI_TRANS_UNIT_OFST, D_WorkUnit);
  s_ReadWithOffsetMRBor(arg_vect, _SCSI_TRANS_LUN_OFST, D_WorkLun);
  s_ReadWithOffsetMRBor(arg_vect, _SCSI_TRANS_KIND_OFST, D_WorkKind);
  s_ReadWithOffsetMRBor(arg_vect, _SCSI_TRANS_LENGTH_OFST, D_WorkLength);
  s_ReadWithOffsetMRBor(arg_vect, _SCSI_TRANS_CONTINUE_OFST, D_WorkContinue);
  s_ReadWithOffsetMRBor(arg_vect, _SCSI_TRANS_DATA_OFST, D_WorkData);
  s_ReadWithOffsetMRBor(arg_vect, _SCSI_TRANS_DATA_POS_OFST, D_WorkDataPos);

  $USE(D_WorkPos);
  b_SetZero(D_WorkPos);
/*---------- $BBh(B2$B0z?t(B($BBh(B0$BMWAG(B)$B$N%A%'%C%/(B ----------------*/
  f_DerefElementReg(arg_vect, D_WorkPos, D_WorkUnit);
  s_IfINT(D_WorkUnit){
      b_IfScsiRangeErr
	  (D_WorkUnit, _SCSI_MIN_UNIT_NUMBER, _SCSI_MAX_UNIT_NUMBER){
	      $RELEASE(D_WorkPos);
	      b_SetImmTypeValueMRBoff (INT, _RANGE_OVERFLOW_EXCP, excep_code);
	      b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
	      goto EXCEPTION;
	  }
  }else{
      $RELEASE(D_WorkPos);
      s_IfREF(D_WorkUnit){ goto CHECK_END;}
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, excep_code);
      b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
      goto EXCEPTION;
  }
/*---------- $BBh(B2$B0z?t(B($BBh(B1$BMWAG(B)$B$N%A%'%C%/(B ----------------*/
  b_IncrementAddrReg(D_WorkPos);
  f_DerefElementReg(arg_vect, D_WorkPos, D_WorkLun);
  s_IfINT(D_WorkLun){
      b_IfScsiRangeErr(D_WorkLun, _SCSI_MIN_LUN, _SCSI_MAX_LUN){
	  $RELEASE(D_WorkPos);
	  b_SetImmTypeValueMRBoff (INT, _RANGE_OVERFLOW_EXCP, excep_code);
	  b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
	  goto EXCEPTION;
      }
  }else{
      s_IfATOM(D_WorkLun){
	  b_IfNotEqual(D_WorkLun, D_NULL){
	      $RELEASE(D_WorkPos);
	      b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
	      b_SetImmTypeValueMRBoff
		  (INT, _ILLEGAL_INPUT_EXCP, excep_code);
	      goto EXCEPTION;
	  }
      }else{
	  $RELEASE(D_WorkPos);
	  s_IfREF(D_WorkLun){ goto CHECK_END;}
	  b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, excep_code);
	  b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
	  goto EXCEPTION;
      }
  }
/*---------- $BBh(B2$B0z?t(B($BBh(B2$BMWAG(B)$B$N%A%'%C%/(B ----------------*/
  b_IncrementAddrReg(D_WorkPos);
  f_DerefElementReg(arg_vect, D_WorkPos, D_WorkKind);
  s_IfINT(D_WorkKind){
      b_IfScsiRangeErr(D_WorkKind, _SCSI_MIN_KIND, _SCSI_MAX_KIND){
	  $RELEASE(D_WorkPos);
	  b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
	  b_SetImmTypeValueMRBoff (INT, _RANGE_OVERFLOW_EXCP, excep_code);
	  goto EXCEPTION;
      }
      f_IfScsiInvalidKind(D_WorkKind){
	  $RELEASE(D_WorkPos);
	  /*  001,011,101 $B$r=|30!#(B $B$3$3$N%3!<%G%#%s%0$OMW8!F$(B */
	  b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
	  b_SetImmTypeValueMRBoff (INT,_RANGE_OVERFLOW_EXCP,excep_code);
	  goto EXCEPTION;
      }
  }else{
      $RELEASE(D_WorkPos);
      s_IfREF(D_WorkKind){ goto CHECK_END;}
      b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, excep_code);
      goto EXCEPTION;
  }
/*---------- $BBh(B2$B0z?t(B($BBh(B3$BMWAG(B)$B$N%A%'%C%/(B ----------------*/
  b_IncrementAddrReg(D_WorkPos);
  f_DerefElementReg(arg_vect, D_WorkPos, D_WorkLength);
  s_IfINT(D_WorkLength){
      b_IfScsiRangeErr
	  (D_WorkLength, _ZERO, _MAX_LEN_OF_TRANS_DATA_IN_TRANSFER){
	      $RELEASE(D_WorkPos);
	      b_SetImmTypeValueMRBoff (INT, _RANGE_OVERFLOW_EXCP, excep_code);
	      b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
	      goto EXCEPTION;
	  }
      b_IfEqualImm(D_WorkKind, _KIND_COMMAND){
	  b_IfGreaterImm(D_WorkLength, _SCSI_MAX_CDB_SIZE){
	      $RELEASE(D_WorkPos);
	      b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
	      b_SetImmTypeValueMRBoff (INT,_RANGE_OVERFLOW_EXCP,excep_code);
	      goto EXCEPTION;
	  }
      }else{
	  b_IfEqualImm(D_WorkKind, _KIND_STATUS){
	      b_IfNotEqual(D_WorkLength, D_ONE){
		  $RELEASE(D_WorkPos);
		  b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
		  b_SetImmTypeValueMRBoff
		      (INT, _RANGE_OVERFLOW_EXCP, excep_code);
		  goto EXCEPTION;
	      }
	  }
      }
  }else{
      $RELEASE(D_WorkPos);
      s_IfREF(D_WorkLength){ goto CHECK_END;}
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, excep_code);
      b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
      goto EXCEPTION;
  }
/*---------- $BBh(B2$B0z?t(B($BBh(B4$BMWAG(B)$B$N%A%'%C%/(B ----------------*/
  b_IncrementAddrReg(D_WorkPos);
  f_DerefElementReg(arg_vect, D_WorkPos, D_WorkContinue);
  s_IfINT(D_WorkContinue){
      b_IfNotEqual(D_WorkContinue, D_NULL){
	  b_IfNotEqual(D_WorkContinue, D_ONE){
	      $RELEASE(D_WorkPos);
	      b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
	      b_SetImmTypeValueMRBoff
		  (INT, _RANGE_OVERFLOW_EXCP, excep_code);
	      goto EXCEPTION;
	  }
      }
  }else{
      $RELEASE(D_WorkPos);
      s_IfREF(D_WorkContinue){ goto CHECK_END;}
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, excep_code);
      b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
      goto EXCEPTION;
  }
/*---------- $BBh(B2$B0z?t(B($BBh(B5$BMWAG(B)$B$N%A%'%C%/(B ----------------*/
  b_IncrementAddrReg(D_WorkPos);
  f_DerefElementReg(arg_vect, D_WorkPos, D_WorkData);
  s_IfNotSTRG(D_WorkData){
      $RELEASE(D_WorkPos);
      s_IfREF(D_WorkData){ goto CHECK_END;}
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, excep_code);
      b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
      goto EXCEPTION;
  }else{
      $USE(D_WorkTypeCheckReg);
      $USE(D_WorkStringLen);
      s_GetStringType(D_WorkData, D_WorkStringLen, D_WorkTypeCheckReg);
      b_IfNotEqualImm(D_WorkTypeCheckReg, _ELEM_SIZE_OF_STRG8){
	  $RELEASE(D_WorkPos);
	  $RELEASE(D_WorkTypeCheckReg);
	  $RELEASE(D_WorkStringLen);
	  b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
	  b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, excep_code);
	  goto EXCEPTION;
      }      
      $RELEASE(D_WorkTypeCheckReg);
      b_IfGreater(D_WorkLength, D_WorkStringLen){
	  $RELEASE(D_WorkPos);
	  $RELEASE(D_WorkStringLen);
	  b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
	  b_SetImmTypeValueMRBoff (INT, _RANGE_OVERFLOW_EXCP, excep_code);
	  goto EXCEPTION;
      }      
  }
/*---------- $BBh(B2$B0z?t(B($BBh(B6$BMWAG(B)$B$N%A%'%C%/(B ----------------*/
  b_IncrementAddrReg(D_WorkPos);
  f_DerefElementReg(arg_vect, D_WorkPos, D_WorkDataPos);
  s_IfINT(D_WorkDataPos){
      b_IfLess(D_WorkDataPos, D_NULL){
	  $RELEASE(D_WorkPos);
	  $RELEASE(D_WorkStringLen);
	  b_SetImmTypeValueMRBoff (INT, _RANGE_OVERFLOW_EXCP, excep_code);
	  b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
	  goto EXCEPTION;
      }
      b_IfRangeOver(D_WorkDataPos, D_WorkStringLen){
	  b_IfNotZero(D_WorkDataPos) {
	      /* $B%9%H%j%s%0D9#0!"%]%8%7%g%s#0$N;~$N$_!"Nc30$G$O$J$$(B */
	      $RELEASE(D_WorkPos);
	      $RELEASE(D_WorkStringLen);
	      b_SetImmTypeValueMRBoff (INT, _RANGE_OVERFLOW_EXCP, excep_code);
	      b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
	      goto EXCEPTION;
	  }
      }
      b_SubtractWithDNTC(D_WorkStringLen, D_WorkDataPos, D_WorkStringLen);
      b_IfGreater(D_WorkLength, D_WorkStringLen){
	  $RELEASE(D_WorkPos);
	  $RELEASE(D_WorkStringLen);
	  b_SetImmTypeValueMRBoff (INT, _RANGE_OVERFLOW_EXCP, excep_code);
	  b_SetImmTypeValueMRBoff (INT, _ONE, excep_arg_pos);
	  goto EXCEPTION;
      }
      $RELEASE(D_WorkStringLen);
  }else{
      $RELEASE(D_WorkStringLen);
      $RELEASE(D_WorkPos);
      s_IfREF(D_WorkDataPos){ goto CHECK_END;}
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, excep_code);
      b_SetImmValueDNTC (_ONE, excep_arg_pos);
      goto EXCEPTION;
  }
  $RELEASE(D_WorkPos);

 CHECK_END:
  $RELEASE(D_WorkUnit); $RELEASE(D_WorkLun); $RELEASE(D_WorkKind); 
  $RELEASE(D_WorkLength); $RELEASE(D_WorkContinue); $RELEASE(D_WorkData); 
  $RELEASE(D_WorkDataPos);

  b_SetZero(excep_flag);
  goto END;

 EXCEPTION:
  p_MoveWord(D_ONE, excep_flag);

 END:
  ;
}

#SUBARG_define A_TransRec      MODIFY
#SUBARG_define A_Unit          SRC
#SUBARG_define A_LUN           SRC

#SUBROUTINE  i_SCSIDeviceDriverTargetMain_Sub(A_TransRec, A_Unit, A_LUN)
{
  /* $B;XDj$5$l$?(BUnit($B%$%K%7%(!<%?B&(B)$B!"(BLUN($B%?!<%2%C%HB&(B)$B$G<B9TCf!"(B
     $B$^$?$O%P%98"BT$A$NE>Aw$,$J$$$+$rD4$Y$k!#(B
     ($B%P%98"%-%e!<$NE>Aw%l%3!<%I$r%9%-%c%s(B)                  */
  $USE(D_WorkRecord);
  f_SearchTransRecWithUnitAndLUN
      (D_ScsiBusFreeWaitingTop, A_Unit, A_LUN, D_WorkRecord);
  s_IfNotScsiTransRec(D_WorkRecord){ /* $B%P%98"%-%e!<$KB8:_$7$J$$>l9g(B */
      $RELEASE(D_WorkRecord);
      $CALL(i_SCSIDeviceDriverTargetBody_Sub(A_TransRec));
      f_IfArbitrationFailure(A_TransRec){ goto END;}
  }else{
      $RELEASE(D_WorkRecord);
      f_EnqueueToReserv (A_TransRec);
  }
/*  $RELEASE(D_WorkRecord); */

  i_SCSIDeviceDriver();

 END:
  $RETURN();
}

#SUBARG_define A_TransRec      MODIFY

#SUBROUTINE i_SCSIDeviceDriverTargetBodyTemp_Sub(A_TransRec)
{
  $USE(D_WorkNextPhase);
  $CALL(f_ScsiReselectionPhase_Sub(A_TransRec, D_WorkNextPhase));

  LOOP(){
      ValueSwitch(D_WorkNextPhase) {
	case _TARGET_TRANSFER:
	  $USE(D_WorkKind);
	  s_GetScsiTransRecKind(A_TransRec, D_WorkKind);
	  ValueSwitch(D_WorkKind){
	    case _KIND_COMMAND:
	      $RELEASE(D_WorkKind);
	      $CALL(f_ScsiTargetCommandTransfer_Sub
		    (A_TransRec, D_WorkNextPhase));
	      break;
	    case _KIND_DATA_IN:
	    case _KIND_MSG_IN:
	    case _KIND_STATUS:
	      $RELEASE(D_WorkKind);
	      $CALL(f_ScsiTargetSendData_Sub(A_TransRec, D_WorkNextPhase));
	      break;
	    case _KIND_DATA_OUT:
	      $RELEASE(D_WorkKind);
	      $CALL(f_ScsiTargetReceiveData_Sub(A_TransRec, D_WorkNextPhase));
	      break;
	    default:
	      $RELEASE(D_WorkKind);
	      @DEBUG{
		  VPIM_ERROR("i_SCSIDeviceDriverTargetBodyTemp_Sub",
			     "unknown kind. What happened?");
	      };
	      break;
	  }
	  break;
	case _RESELECTED:
	  $CALL(f_ScsiReselected_Sub());
	  goto END;
	case _SELECTED:
	  $CALL(f_ScsiSelected_Sub());
	  goto END;
	case _ARBITRATION_FAILURE:
	  b_SetEOL(A_TransRec);
	  goto END;
	case _TARGET_TERMINATE:
	  $CALL(f_ScsiTargetResultReport_Sub(A_TransRec));
	  /*-----------------------------------------------
	      $B$3$3$G(B1$B$D$NE>Aw$N<B9T$,40N;$9$k!#(B
	  -------------------------------------------------*/
	  f_ScsiQueueManagementOnTransferEnd(A_TransRec);
	  goto END;
	case _ERROR_END:
	  $CALL(f_ScsiResetConditionHandling_Sub(A_TransRec));
	  goto END;
	case _POP_NEXT_TRANS_REC:
	  goto END;
	default:
	  @DEBUG{
	      VPIM_ERROR("i_SCSIDeviceDriverTargetBodyTemp_Sub",
			 "unexpected phase. What happened?");
	  };
      }
  } /* end of LOOP() */

 END:
  $RELEASE(D_WorkNextPhase);
  $RETURN();
}

#SUBARG_define A_TransRec      MODIFY

#SUBROUTINE i_SCSIDeviceDriverTargetBody_Sub(A_TransRec)
{
  $USE(D_WorkNextPhase);
 Reselection:  
  $CALL(f_ScsiReselectionPhase_Sub(A_TransRec, D_WorkNextPhase));
  ValueSwitch(D_WorkNextPhase) {
    case _TARGET_TRANSFER:
      goto Target_Transfer;
    case _RESELECTED:
      $CALL(f_ScsiReselected_Sub());
      goto Normal_End;
    case _SELECTED:
      $CALL(f_ScsiSelected_Sub());
      goto Normal_End;
    case _ARBITRATION_FAILURE:
      b_SetEOL(A_TransRec);
      goto Normal_End;
    case _TARGET_TERMINATE:
      goto Target_Terminate;
    case _ERROR_END:
      goto Error_End;
    case _FATAL_ERROR_END:
      goto Fatal_Error_End;
    case _POP_NEXT_TRANS_REC:
      goto Normal_End;
    default:
      @DEBUG{
	  VPIM_ERROR("i_SCSIDeviceDriverTargetBody_Sub",
		     "unexpected phase. What happened?");
      };
  }

 Target_Transfer:
  $USE(D_WorkKind);
  s_GetScsiTransRecKind(A_TransRec, D_WorkKind);
  ValueSwitch(D_WorkKind){
    case _KIND_COMMAND:
      $RELEASE(D_WorkKind);
      $CALL(f_ScsiTargetCommandTransfer_Sub(A_TransRec, D_WorkNextPhase));
      break;
    case _KIND_DATA_IN:
    case _KIND_MSG_IN:
    case _KIND_STATUS:
      $RELEASE(D_WorkKind);
      $CALL(f_ScsiTargetSendData_Sub(A_TransRec, D_WorkNextPhase));
      break;
    case _KIND_DATA_OUT:
      $RELEASE(D_WorkKind);
      $CALL(f_ScsiTargetReceiveData_Sub(A_TransRec, D_WorkNextPhase));
      break;
    default:
      $RELEASE(D_WorkKind);
      @DEBUG{
	  VPIM_ERROR("i_SCSIDeviceDriverTargetBody_Sub",
		     "unknown kind. What happened?");
      };
  }

  ValueSwitch(D_WorkNextPhase){
    case _TARGET_TERMINATE:
      goto Target_Terminate;
    case _POP_NEXT_TRANS_REC:
      goto Normal_End;
    case _ERROR_END:
      goto Error_End;
    case _FATAL_ERROR_END:
      goto Fatal_Error_End;
    default:
      @DEBUG{
	  VPIM_ERROR("i_SCSIDeviceDriverTargetBody_Sub",
		     "unexpected phase. What happened?");
      };
  }

 Target_Terminate:
  $CALL(f_ScsiTargetResultReport_Sub(A_TransRec));
  /*-----------------------------------------------
      $B$3$3$G(B1$B$D$NE>Aw$N<B9T$,40N;$9$k!#(B
  -------------------------------------------------*/
  f_ScsiQueueManagementOnTransferEnd(A_TransRec);
  goto Normal_End;

 Error_End:
  $CALL(f_ScsiResetConditionHandling_Sub(A_TransRec));
  goto Normal_End;

 Fatal_Error_End:
  $CALL(f_ScsiFatalErrorEnd_Sub(D_NULL, A_TransRec));

 Normal_End:
  $RELEASE(D_WorkNextPhase);
  $RETURN();
}


#OPF_define I_RegScsi    _IndirectRegField1 /* $BF~NO(B */
#OPF_define I_RegID      _IndirectRegField2 /* $BF~NO(B */
#OPF_define I_RegNewScsi _IndirectRegField3 /* $B=PNO(B */

#PSL_define kblt_b_scsi_abort()
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp3ArgVect_IIO_Sub(D_WorkArgVect,
				       I_RegScsi,I_RegID,I_RegNewScsi));
      f_TraceBodyBuiltin(BLT_B_SCSI_ABORT,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

/***** $BNc30%A%'%C%/(B******/
  $USE(D_WorkFlagReg);
  $USE(D_WorkExceptionCode);
  $USE(D_WorkExcepArgPos);
  i_ScsiAbortExceptionCheck(I_RegScsi, I_RegID, D_WorkFlagReg, 
			    D_WorkExceptionCode, D_WorkExcepArgPos);
  b_IfNotZero(D_WorkFlagReg){
      $USE(D_WorkOpCode);
      b_SetImmTypeValueMRBoff(INT, BLT_B_SCSI_ABORT, D_WorkOpCode);
      $CALL( f_Exception_3Arg_IIO_Sub 
	    (D_WorkOpCode, D_WorkExceptionCode, D_WorkExcepArgPos,
	     I_RegScsi, I_RegID, I_RegNewScsi));
      $RELEASE(D_WorkExceptionCode);
      $RELEASE(D_WorkOpCode);
      $RELEASE(D_WorkExcepArgPos);
      goto End_of_KL1B_Instruction;
  }
  $RELEASE(D_WorkFlagReg);
  $RELEASE(D_WorkExcepArgPos);
  $RELEASE(D_WorkExceptionCode);

/***** $BL$B+G{JQ?t%A%'%C%/(B****/
  s_IfNotREF(I_RegScsi){
      s_IfNotREF(I_RegID){
	  goto Check_End;
      }
  }

  f_DcodeEnqueue3Ope_IIO(BLT_B_SCSI_ABORT, I_RegScsi, I_RegID, I_RegNewScsi);
  goto End_of_KL1B_Instruction;

 Check_End:
/*---------------------------------------------------------------
  $BM=Ls%-%e!<$NCf$+$iM=LsHV9f(BI_RegID$B$N%3%^%s%I%l%3!<%I$r%G%-%e!<$9$k!#(B  
  $BB8:_$7$J$$;~$O(BD_WorkRecord$B$K(BEOL$B$,JV$k!#(B
-----------------------------------------------------------------*/
  $USE(D_WorkRecord);
  f_DequeueCommRecFromReservWithID(I_RegID, D_WorkRecord);
  b_IfNotEOL(D_WorkRecord){
      s_OrResultCodeCommRec(_CANCELED_BEFORE_EXEC, D_WorkRecord);
      /* $B<B9TA0$K%-%c%s%;%k$5$l$?$3$H$r<($940N;>uBV%U%i%0$r(BON$B$K$9$k(B */
      $CALL( f_ScsiInitiatorResultReport_Sub(D_WorkRecord));

      s_ReclaimCommRec(D_WorkRecord); /* $B%U%j!<%j%9%H$KLa$9!#(B*/
      $RELEASE(D_WorkRecord);

      f_IfNotEmptyCommRecFreeListWaiting(){
	  $USE(D_WorkGoalPtr);
	  f_DequeueFromCommRecFreeListWaiting(D_WorkGoalPtr);
	  $USE(D_WorkPriority);
	  s_GetPriorityEnvGoalRecord(D_WorkGoalPtr, D_WorkPriority);
	  $CALL(f_PushGoalToStackWithPriority_Sub
		(D_WorkGoalPtr, D_WorkPriority));
	  $RELEASE(D_WorkPriority);
	  $RELEASE(D_WorkGoalPtr);
      }
      goto Unify_Scsi;
  }
/*---------------------------------------------------------------
  $B%P%98"%-%e!<$NCf$+$iM=LsHV9f(BI_RegID$B$N%3%^%s%I%l%3!<%I$r%G%-%e!<$9$k!#(B
  $BB8:_$7$J$$;~$O(BD_WorkRecord$B$K(BEOL$B$,JV$k!#(B
-----------------------------------------------------------------*/
  f_DequeueCommRecFromBusFreeWaitingWithID(I_RegID, D_WorkRecord);
  b_IfNotEOL(D_WorkRecord){
    s_OrResultCodeCommRec(_CANCELED_BEFORE_EXEC, D_WorkRecord);
    /* $B<B9TA0$K%-%c%s%;%k$5$l$?$3$H$r<($940N;>uBV%U%i%0$r(BON$B$K$9$k(B */
    $CALL( f_ScsiInitiatorResultReport_Sub(D_WorkRecord));
    f_ScsiQueueManagementOnCommandEnd(D_WorkRecord);
    $RELEASE(D_WorkRecord);
    goto Unify_Scsi;
  }
/*----------------------------------------------------------------
  $B<B9TCf%j%9%H$NCf$+$iM=LsHV9f(BI_RegID$B$N%3%^%s%I%l%3!<%I$rA\$7!"(B
  $B%-%c%s%;%k%U%i%0$r(BON$B$K$9$k!#B8:_$7$J$$;~$O(BD_WorkRecord$B$K(BEOL$B$,JV$k!#(B
  $B<B:]$K%-%c%s%;%k$5$l$k$N$O%j%3%M%/%H$5$l$?;~$G$"$k!#(B
  ($B%-%c%s%;%k%U%i%0$r%A%'%C%/$9$k(B)
------------------------------------------------------------------*/
  f_SearchCommRecWithID(D_ScsiExecutingListTop, I_RegID, D_WorkRecord);
  b_IfNotEOL(D_WorkRecord){
    s_SetScsiCommRecCancelFlagOn(D_WorkRecord);
  }
  $RELEASE(D_WorkRecord);
  /*----------------------------------------------------------
      I_RegID$B$G;XDj$5$l$?M=LsHV9f$N%3%^%s%I%l%3!<%I$,M=Ls%-%e!<!"(B
      $B%P%98"%-%e!<!"<B9TCf%j%9%H$N$$$:$l$K$bB8:_$7$J$$!#(B
	  ====> scsi_abort $B=*N;(B
   -------------------------------------------------------------*/

 Unify_Scsi:
  p_MoveWord(I_RegScsi, I_RegNewScsi);

 End_of_KL1B_Instruction:
  ;
}

/******************************************************************** PSL **
i_ScsiAbortExceptionCheck
               (scsi, id, excep_flag, excep_code, excep_arg_pos)

       written by f-doumae@icot22      on Mon Feb  4 11:10:51 1991
<Arguments>
    scsi     : $BF~NO0z?t(BSCSI
    id       : $BF~NO0z?t(BID
    excep_flag : $B%(%/%;%W%7%g%s$,H/@8$7$?$+$I$&$+$r<($9%U%i%0(B(destination)
    excep_code       : $BNc30%3!<%I(B(destination)
    excep_arg_pos    : $BNc30$,5/$-$?0z?t0LCV(B(destination)
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    scsi_abort/3 $B$NF~NO0z?t$NNc30%A%'%C%/$r9T$J$&!#(B
    $BNc30$,5/$-$?>l9g!"%(%/%;%W%7%g%s%3!<%I!"%(%/%;%W%7%g%s$r5/$3$7$?0z?t0LCV(B
    $B$r@_Dj$7!"%U%i%0$r(BON$B$K$9$k!#(B
<Examples>
<Test>
<Explanation>
    $BNc30%A%'%C%/$N;EMM$O(BPIM$B<B5!Kh$K$3$H$J$k2DG=@-$,$"$k!#(B
    ($B%P%C%U%!%5%$%:$J$I$O(BPIM$B<B5!$N%^%7%s9=@.$K$h$C$F0[$J$jF@$k!#(B)

    scsi_abort/3 $B$O(BKL1$B%G%P%$%9%I%i%$%P$N%7%9%F%`5-=R<T$N$_$,;HMQ$9$k(B
    $BAH$_9~$_=R8l$G$"$k$?$a!"Nc30%A%'%C%/$O(BKL1$B%G%P%$%9%I%i%$%P$N%G%P%C%0MQ(B
    $B$H9M$($F$$$k!#(B($B8=:_$N$H$3$m(BKL1$B%G%P%$%9%I%i%$%P$GNc30$r@Q6KE*$KMQ$$$k(B
    $B$3$H$O9M$($i$l$F$$$J$$!#(B)
********************************************************************* PSL **/
#PSL_define i_ScsiAbortExceptionCheck(scsi, id, excep_flag, 
                                                excep_code, excep_arg_pos)
{
  $USE(D_Workreg1);
  f_ActiveDeref(scsi, D_Workreg1);
  s_IfNotINT(scsi){
    s_IfUnbound(scsi){
      p_MoveWord(D_Workreg1, scsi);
      $RELEASE(D_Workreg1);
      goto Check_End;
    }else{
      $RELEASE(D_Workreg1);
      b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, excep_code);
      b_SetImmTypeValueMRBoff(INT, _ZERO, excep_arg_pos);
      goto EXCEPTION;
    }
  }

  f_ActiveDeref(id, D_Workreg1);
  s_IfNotINT(id){
    s_IfUnbound(id){
      p_MoveWord(D_Workreg1, id);
      $RELEASE(D_Workreg1);
      goto Check_End;
    }else{
      $RELEASE(D_Workreg1);
      b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, excep_code);
      b_SetImmTypeValueMRBoff(INT, _ONE, excep_arg_pos);
      goto EXCEPTION;
    }
  }
  $RELEASE(D_Workreg1);

 Check_End:
  b_SetZero(excep_flag);
  goto END;

 EXCEPTION:
  p_MoveWord(D_ONE, excep_flag);

 END:
  ;
}

#OPF_define I_RegScsi    _IndirectRegField1 /* $BF~NO(B */
#OPF_define I_RegUnit    _IndirectRegField2 /* $BF~NO(B */
#OPF_define I_RegLUN     _IndirectRegField3 /* $BF~NO(B */
#OPF_define I_RegNewScsi _IndirectRegField4 /* $B=PNO(B */

#PSL_define kblt_b_scsi_reset()
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp4ArgVect_IIIO_Sub
	    (D_WorkArgVect,I_RegScsi,I_RegUnit,I_RegLUN, I_RegNewScsi));
      f_TraceBodyBuiltin(BLT_B_SCSI_RESET,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

/**** $BNc30%A%'%C%/(B ****/
  $USE(D_WorkFlagReg);
  $USE(D_WorkExceptionCode);
  $USE(D_WorkExcepArgPos);
  i_ScsiResetExceptionCheck(I_RegScsi, I_RegUnit, I_RegLUN, D_WorkFlagReg, 
			    D_WorkExceptionCode, D_WorkExcepArgPos);
  b_IfNotZero(D_WorkFlagReg){
      $USE(D_WorkOpCode);
      b_SetImmTypeValueMRBoff(INT, BLT_B_SCSI_RESET, D_WorkOpCode);
      $CALL( f_Exception_4Arg_IIIO_Sub 
	    (D_WorkOpCode, D_WorkExceptionCode, D_WorkExcepArgPos,
	     I_RegScsi, I_RegUnit, I_RegLUN, I_RegNewScsi));
      $RELEASE(D_WorkOpCode);
      $RELEASE(D_WorkExcepArgPos);
      $RELEASE(D_WorkExceptionCode);
      $RELEASE(D_WorkFlagReg);
      goto End_of_KL1B_Instruction;
  }
  $RELEASE(D_WorkFlagReg);
  $RELEASE(D_WorkExcepArgPos);
  $RELEASE(D_WorkExceptionCode);

/***** $BL$B+G{JQ?t%A%'%C%/(B****/
  s_IfNotREF(I_RegScsi){
      s_IfNotREF(I_RegUnit){
	  s_IfNotREF(I_RegLUN){
	      goto Check_End;
	  }
      }
  }
  f_DcodeEnqueue4Ope_IIIO(BLT_B_SCSI_RESET, I_RegScsi, I_RegUnit, 
			  I_RegLUN, I_RegNewScsi);
  goto End_of_KL1B_Instruction;

 Check_End:
  f_DequeueFromErrDetectedConnectionListWithUnitAndLun(I_RegUnit, I_RegLUN);
  p_MoveWord(I_RegScsi, I_RegNewScsi);

 End_of_KL1B_Instruction:
  ;
}

/******************************************************************** PSL **
i_ScsiResetExceptionCheck
               (scsi, unit, lun, excep_flag, excep_code, excep_arg_pos)

       written by f-doumae@icot22      on Mon Feb  4 11:10:51 1991
<Arguments>
    scsi     : $BF~NO0z?t(BSCSI
    unit     : $BF~NO0z?t(BUnit
    lun      : $BF~NO0z?t(BLUN
    excep_flag : $B%(%/%;%W%7%g%s$,H/@8$7$?$+$I$&$+$r<($9%U%i%0(B(destination)
    excep_code       : $BNc30%3!<%I(B(destination)
    excep_arg_pos    : $BNc30$,5/$-$?0z?t0LCV(B(destination)
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    scsi_reset/3 $B$NF~NO0z?t$NNc30%A%'%C%/$r9T$J$&!#(B
    $BNc30$,5/$-$?>l9g!"%(%/%;%W%7%g%s%3!<%I!"%(%/%;%W%7%g%s$r5/$3$7$?0z?t0LCV(B
    $B$r@_Dj$7!"%U%i%0$r(BON$B$K$9$k!#(B
<Examples>
<Test>
<Explanation>
    $BNc30%A%'%C%/$N;EMM$O(BPIM$B<B5!Kh$K$3$H$J$k2DG=@-$,$"$k!#(B
    ($B%P%C%U%!%5%$%:$J$I$O(BPIM$B<B5!$N%^%7%s9=@.$K$h$C$F0[$J$jF@$k!#(B)

    scsi_reset/3 $B$O(BKL1$B%G%P%$%9%I%i%$%P$N%7%9%F%`5-=R<T$N$_$,;HMQ$9$k(B
    $BAH$_9~$_=R8l$G$"$k$?$a!"Nc30%A%'%C%/$O(BKL1$B%G%P%$%9%I%i%$%P$N%G%P%C%0MQ(B
    $B$H9M$($F$$$k!#(B($B8=:_$N$H$3$m(BKL1$B%G%P%$%9%I%i%$%P$GNc30$r@Q6KE*$KMQ$$$k(B
    $B$3$H$O9M$($i$l$F$$$J$$!#(B)
********************************************************************* PSL **/
#PSL_define i_ScsiResetExceptionCheck(scsi, unit, lun, excep_flag, 
                                                excep_code, excep_arg_pos)
{
  $USE(D_Workreg1);
  f_ActiveDeref(scsi, D_Workreg1);
  s_IfNotINT(scsi){
    s_IfUnbound(scsi){
      p_MoveWord(D_Workreg1, scsi);
      $RELEASE(D_Workreg1);
      goto Check_End;
    }else{
      $RELEASE(D_Workreg1);
      b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, excep_code);
      b_SetImmTypeValueMRBoff(INT, _ZERO, excep_arg_pos);
      goto EXCEPTION;
    }
  }

  f_ActiveDeref(unit, D_Workreg1);
  s_IfINT(unit){
      b_IfScsiRangeErr(unit, _SCSI_MIN_UNIT_NUMBER, _SCSI_MAX_UNIT_NUMBER){
	  $RELEASE(D_Workreg1);
	  b_SetImmTypeValueMRBoff(INT, _RANGE_OVERFLOW_EXCP, excep_code);
	  b_SetImmTypeValueMRBoff(INT, _ONE, excep_arg_pos);
	  goto EXCEPTION;
      }
  }else{
    s_IfUnbound(unit){
      p_MoveWord(D_Workreg1, unit);
      $RELEASE(D_Workreg1);
      goto Check_End;
    }else{
      $RELEASE(D_Workreg1);
      b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, excep_code);
      b_SetImmTypeValueMRBoff(INT, _ONE, excep_arg_pos);
      goto EXCEPTION;
    }
  }

  f_ActiveDeref(lun, D_Workreg1);
  s_IfINT(lun){
      b_IfScsiRangeErr(lun, _SCSI_MIN_LUN, _SCSI_MAX_LUN){
	  $RELEASE(D_Workreg1);
	  b_SetImmTypeValueMRBoff(INT, _RANGE_OVERFLOW_EXCP, excep_code);
	  b_SetImmTypeValueMRBoff(INT, _TWO, excep_arg_pos);
	  goto EXCEPTION;
      }
  }else{
      s_IfATOM(lun){
	  b_IfNotEqual(lun, D_NULL){
	      $RELEASE(D_Workreg1);
	      b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, excep_code);
	      b_SetImmTypeValueMRBoff(INT, _TWO, excep_arg_pos);
	      goto EXCEPTION;
	  }
      }else{
	  s_IfUnbound(lun){
	      p_MoveWord(D_Workreg1, lun);
	      $RELEASE(D_Workreg1);
	      goto Check_End;
	  }else{
	      $RELEASE(D_Workreg1);
	      b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, excep_code);
	      b_SetImmTypeValueMRBoff(INT, _TWO, excep_arg_pos);
	      goto EXCEPTION;
	  }
      }
  }
  $RELEASE(D_Workreg1);

 Check_End:
  b_SetZero(excep_flag);
  goto END;

 EXCEPTION:
  p_MoveWord(D_ONE, excep_flag);

 END:
  ;
}

#DATA_define D_DeviceNumberOnScsi  XXX
#DATA_define D_ScsiInterruptStr XXX
#DATA_define D_WorkScsi  XXX

#OPF_define I_RegScsi    _IndirectRegField1 /* $B=PNO(B */
#OPF_define I_RegRepVect _IndirectRegField2 /* $B=PNO(B */
#OPF_define I_RegInfo    _IndirectRegField3 /* $B=PNO(B */

#PSL_define kblt_b_scsi_init()
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp3ArgVect_OOO_Sub
	    (D_WorkArgVect,I_RegScsi,I_RegRepVect,I_RegInfo));
      f_TraceBodyBuiltin(BLT_B_SCSI_INIT,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  /** SCSI **/
  $USE(D_WorkScsi);
  b_ShiftLeftImmediateWithTag(D_CL_Number, _SHIFT_LEN_16, D_WorkScsi);
  $USE(D_Workreg);
  b_ShiftLeftImmediate(D_PE_Number, _SHIFT_LEN_8, D_Workreg);
  b_BitwiseOrWithTag(D_WorkScsi, D_Workreg, D_WorkScsi);
  $RELEASE(D_Workreg);
  b_BitwiseOrWithTag(D_WorkScsi, D_DeviceNumberOnScsi, I_RegScsi);
  $RELEASE(D_WorkScsi);

  /** ReportVect **/
  s_AllocVariable(I_RegRepVect);
  p_MoveWord(I_RegRepVect, D_ScsiSelectVect);

  /** Info **/
  s_AllocVect4(I_RegInfo);
  $USE(D_Workreg);
     /*** $B%3%^%s%I%l%3!<%IFb$N%G!<%?%P%C%U%!%5%$%:(B ***/
  b_SetImmTypeValueMRBoff(INT, _MAX_LEN_OF_TRANS_DATA_IN_COMMAND, D_Workreg);
  p_WriteWithOffset(D_Workreg, I_RegInfo, _ELEM1_OFST_VECT);
     /*** $BE>Aw%l%3!<%IFb$N%G!<%?%P%C%U%!%5%$%:(B ***/
  b_SetImmTypeValueMRBoff(INT, _MAX_LEN_OF_TRANS_DATA_IN_TRANSFER, D_Workreg);
  p_WriteWithOffset(D_Workreg, I_RegInfo, _ELEM2_OFST_VECT);
     /*** $B3HD%(BIdentify$B%a%C%;!<%8;HMQ2D(B/$BIT2D(B ***/
  b_SetImmTypeValueMRBoff(INT, _ONE,  D_Workreg);
  p_WriteWithOffset(D_Workreg, I_RegInfo, _ELEM3_OFST_VECT);
     /*** $B3d$j9~$_DLCNMQ%9%H%j!<%`(B ***/
  s_AllocVariable(D_Workreg);
  p_WriteWithOffset(D_Workreg, I_RegInfo, _ELEM4_OFST_VECT);
  p_MoveWord(D_Workreg, D_ScsiInterruptStr);
  $RELEASE(D_Workreg);

 End_of_KL1B_Instruction:
  ;
}

/******************************************************************** PSL **
i_SCSIDeviceDriver()

       written by f-doumae@icot22      on Mon Mar 18 16:35:33 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    $B%3%^%s%I!"E>Aw$N<B9T$r9T$J$&!#(B
    $B%P%98"%-%e!<$K%l%3!<%I$,$"$k4V!"%3%^%s%I!"E>Aw%l%3!<%I$K$D$$$F(B
    $B$=$l$>$l%$%K%7%(!<%?5!G=!"%?!<%2%C%H5!G=$r8F$S=P$9!#(B
    $B$?$@$7!"<B9T7k2L$,%"!<%S%H%l!<%7%g%s<:GT$N>l9g$O=hM}$r=*$($k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#PSL_define i_SCSIDeviceDriver()
{
  $USE(D_WorkRecord);
  LOOP(){
      f_IfNotEmptyBusFreeWaiting(){
	  f_DequeueFromBusFreeWaiting (D_WorkRecord);
	  /* $B%P%98"%-%e!<$+$i%3%^%s%I!"$^$?$OE>Aw%l%3!<%I$r<h$j=P$9!#(B*/
      }else{  /* $B%P%98"%-%e!<$,6u$J$i$*$7$^$$!#(B */
	  break;
      }
      s_IfScsiCommRec(D_WorkRecord){
	  $CALL(i_SCSIDeviceDriverInitiatorBody_Sub(D_WorkRecord));
      }else{
	  $CALL( i_SCSIDeviceDriverTargetBody_Sub (D_WorkRecord));
	  @DEBUG{
	      s_IfNotScsiTransRec(D_WorkRecord){
		  VPIM_ERROR("i_SCSIDeviceDriver","llegal pointer type");
	      }
	  };
      }
      f_IfArbitrationFailure(D_WorkRecord){break;}
      /* $B%"!<%S%H%l!<%7%g%s<:GT$N>l9g!"(BD_WorkRecord$B$K$O(BEOL$B$,JV$5$l$k!#(B*/
  }
  $RELEASE(D_WorkRecord);
}

#DATA_define D_WorkWhere	XXX

#OPF_define I_RegWhere	_IndirectRegField1 /* $B=PNO(B */

#PSL_define kblt_b_scsi_where()
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp1ArgVect_O_Sub(D_WorkArgVect,I_RegWhere));
      f_TraceBodyBuiltin(BLT_B_SCSI_WHERE,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  $USE(D_WorkDataPtr);
  b_SetImmValueDNTC(_SYSTEM_CONFIG_AREA_BASE, D_WorkDataPtr);
  b_AddImmediateWithDNTC(D_WorkDataPtr,
			 _SCSI_SYS_CONFIG_AREA_BASE, D_WorkDataPtr);
  $USE(D_WorkData);
  b_ReadScsiConfigClusterNumInSystem(D_WorkDataPtr, D_WorkData);
    /*-------------------------------------------
      SCSI$B$N9=@.>pJs$N@hF,%G!<%?(B
        $B"*(B all zero $B$J$i(BSCSI$B$K$D$$$F$N>pJs$O$J$$(B
     -------------------------------------------*/
  b_IfWordEq(D_WorkData, D_NULL){
      b_SetImmTypeValueMRBoff(ATOM, _ZERO, I_RegWhere);
      $RELEASE(D_WorkData); $RELEASE(D_WorkDataPtr);
      goto End_of_KL1B_Instruction;
  }
  $USE(D_Workreg);
  $USE(D_WorkWhere);
  s_AllocList(I_RegWhere);
  p_MoveWord(I_RegWhere, D_WorkWhere);
  s_AllocVect4(D_Workreg);
  LOOP(){
        /* $B%/%i%9%?HV9f(B */
      b_SetImmTypeMRBoff(INT, D_WorkData);
        /* $B%7%9%F%`9=@.>pJsNN0h$K(B tag word $B$G=q$+$l$F$$$l$PI,MW$J$$(B */
      p_WriteWithOffset(D_WorkData, D_Workreg, _ELEM1_OFST_VECT);
      b_ReadScsiConfigPENumInCluster(D_WorkDataPtr, D_WorkData);
        /* $B%W%m%;%C%5HV9f(B */
      b_SetImmTypeMRBoff(INT, D_WorkData);
        /* $B%7%9%F%`9=@.>pJsNN0h$K(B tag word $B$G=q$+$l$F$$$l$PI,MW$J$$(B */
      p_WriteWithOffset(D_WorkData, D_Workreg, _ELEM2_OFST_VECT);
      b_ReadScsiConfigDeviceNumOnScsi(D_WorkDataPtr, D_WorkData);
        /* SCSI ID */
      b_SetImmTypeMRBoff(INT, D_WorkData);
        /* $B%7%9%F%`9=@.>pJsNN0h$K(B tag word $B$G=q$+$l$F$$$l$PI,MW$J$$(B */
      p_WriteWithOffset(D_WorkData, D_Workreg, _ELEM3_OFST_VECT);
      b_ReadScsiConfigScsiPortNum(D_WorkDataPtr, D_WorkData);
        /* SCSI$B%]!<%HHV9f(B */
      b_SetImmTypeMRBoff(INT, D_WorkData);
        /* $B%7%9%F%`9=@.>pJsNN0h$K(B tag word $B$G=q$+$l$F$$$l$PI,MW$J$$(B */
      p_WriteWithOffset(D_WorkData, D_Workreg, _ELEM4_OFST_VECT);

      p_WriteWithOffset(D_Workreg, D_WorkWhere, _CAR_OFST_LIST);
/*      s_AllocVariable(D_Workreg); */
/*      p_WriteWithOffset(D_Workreg, D_WorkWhere, _CDR_OFST_LIST); */
/*      p_MoveWord(D_WorkWhere, D_Workreg); */
      b_AddImmediateWithDNTC(D_WorkDataPtr,
			     _SIZE_OF_SCSI_SYS_CONFIG_AREA, D_WorkDataPtr);

      b_ReadScsiConfigClusterNumInSystem(D_WorkDataPtr, D_WorkData);
        /* $B%/%i%9%?HV9f(B */
      b_IfWordNotEq(D_WorkData, D_NULL){
	  s_AllocList(D_Workreg);
	  p_WriteWithOffset(D_Workreg, D_WorkWhere, _CDR_OFST_LIST);
	  p_MoveWord(D_Workreg, D_WorkWhere);
	  s_AllocVect4(D_Workreg);
      }else{
	  b_SetImmTypeValueMRBoff(ATOM, _ZERO, D_Workreg);
	  p_WriteWithOffset(D_Workreg, D_WorkWhere, _CDR_OFST_LIST);
	  break;
      }
  }
  $RELEASE(D_WorkDataPtr);
  $RELEASE(D_WorkData);
  $RELEASE(D_Workreg);
  $RELEASE(D_WorkWhere);

 End_of_KL1B_Instruction:
  ;
}

/******************************************************************** PSL **
kblt_b_scsi_bus_reset(BusID)

       written by f-takei@icot22      on Tue Oct  1 10:48:21 1991
<Arguments>
    BusID : {Node, Processor, SCSI_PORT, SCSI_ID}
             Node      : $B%/%i%9%?HV9f(B
             Processor : $B%W%m%;%C%5HV9f(B
             SCSI_PORT : SCSI $B%]!<%HHV9f(B
             SCSI_ID   : SCSI $B%P%9%G%P%$%9(B ID
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    SCSI $B$KBP$9$k%j%;%C%H$r9T$&!#(B
    $BF~NO0z?t$N(B BusID $B$N(B SCSI_ID $B$N;XDj$K$h$C$F0J2<$N%j%;%C%H$r9T$&!#(B
    1. [] $B$r;XDj$9$l$P!"(BSCSI $B%P%9%j%;%C%H$r9T$&!#(B
       $B$3$N;~=hM}7O%l%Y%k(B(VPIM)$B%l%Y%k$G$N%j%;%C%H$r9T$&!#(B
    2. SCSI_ID $B$G;XDj$5$l$?%G%P%$%9$N$_$r%j%;%C%H$9$k!#(B
    3. $B<+(B ID $B$r;XDj$9$l$P!"=hM}7O(B(VPIM)$B%l%Y%k$G$N%j%;%C%H$r9T$&!#(B
<Examples>
<Test>
<Explanation>
    $B8=:_$O>e5-5!G=$NFb!"(B1 $B$N(B SCSI $B%P%9%j%;%C%H5!G=$N$_$r%5%]!<%H$9$k!#(B
    2, 3 $B$K$D$$$F$OI,MW$K1~$8$F%5%]!<%H$9$k!#(B
<ETC>
********************************************************************* PSL **/

#OPF_define I_RegBusID	_IndirectRegField1	/* $BF~NO(B */

#PSL_define kblt_b_scsi_bus_reset()
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp1ArgVect_I_Sub(D_WorkArgVect,I_RegBusID));
      f_TraceBodyBuiltin(BLT_B_SCSI_BUS_RESET,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

/**** $BNc30%A%'%C%/(B ****/
  $USE(D_WorkFlagReg);
  $USE(D_WorkExceptionCode);
  $USE(D_WorkExcepArgPos);
  i_ScsiBusResetExceptionCheck(I_RegBusID, D_WorkFlagReg,
			       D_WorkExceptionCode, D_WorkExcepArgPos);
  b_IfNotZero(D_WorkFlagReg){
      $USE(D_WorkOpCode);
      b_SetImmTypeValueMRBoff(INT, BLT_B_SCSI_BUS_RESET, D_WorkOpCode);
      $CALL(f_Exception_1Arg_I_Sub(D_WorkOpCode, D_WorkExceptionCode,
				   D_WorkExcepArgPos, I_RegBusID));
      $RELEASE(D_WorkOpCode);
      $RELEASE(D_WorkExcepArgPos);
      $RELEASE(D_WorkExceptionCode);
      $RELEASE(D_WorkFlagReg);
      goto End_of_KL1B_Instruction;
  }
  $RELEASE(D_WorkExcepArgPos);
  $RELEASE(D_WorkExceptionCode);
  $RELEASE(D_WorkFlagReg);

  s_IfREF(I_RegBusID){
      goto MAKE_DCODE_GOAL_ENQUEUE;
  }

  $USE(D_WorkNodeNum);
  p_ReadWithOffset(I_RegBusID, _ELEM1_OFST_VECT, D_WorkNodeNum);
  s_IfREF(D_WorkNodeNum){
      $RELEASE(D_WorkNodeNum);
      goto MAKE_DCODE_GOAL_ENQUEUE;
  }
  $USE(D_WorkPENum);
  p_ReadWithOffset(I_RegBusID, _ELEM2_OFST_VECT, D_WorkPENum);
  s_IfREF(D_WorkPENum){
      $RELEASE(D_WorkNodeNum); $RELEASE(D_WorkPENum);
      goto MAKE_DCODE_GOAL_ENQUEUE;
  }
  $USE(D_WorkScsiPort);
  p_ReadWithOffset(I_RegBusID, _ELEM3_OFST_VECT, D_WorkScsiPort);
  s_IfREF(D_WorkScsiPort){
      $RELEASE(D_WorkNodeNum); $RELEASE(D_WorkPENum);
      $RELEASE(D_WorkScsiPort);
      goto MAKE_DCODE_GOAL_ENQUEUE;
  }
  $USE(D_WorkID);
  p_ReadWithOffset(I_RegBusID, _ELEM4_OFST_VECT, D_WorkID);
  s_IfREF(D_WorkID){
      $RELEASE(D_WorkNodeNum); $RELEASE(D_WorkPENum);
      $RELEASE(D_WorkScsiPort); $RELEASE(D_WorkID);
      goto MAKE_DCODE_GOAL_ENQUEUE;
  }

  s_IfATOM(D_WorkID){
      b_IfEqual(D_WorkID, D_NULL){
	  $RELEASE(D_WorkNodeNum); $RELEASE(D_WorkPENum);
	  $RELEASE(D_WorkScsiPort); $RELEASE(D_WorkID);
	  /* SCSI Bus Reset :: SPC.SCMD.bit4=1 */
	  $CALL(f_ScsiResetConditionHandling_Sub(D_NULL));
	  goto End_of_KL1B_Instruction;
      }
  }
  $RELEASE(D_WorkNodeNum); $RELEASE(D_WorkPENum);
  $RELEASE(D_WorkScsiPort); $RELEASE(D_WorkID);
  @DEBUG{
      OUT_OF_SPEC("kblt_b_scsi_bus_reset","unsupported SCSI_ID");
  };

 MAKE_DCODE_GOAL_ENQUEUE:
  f_DcodeEnqueue1Ope_I(BLT_B_SCSI_BUS_RESET, I_RegBusID);
  goto End_of_KL1B_Instruction;

 End_of_KL1B_Instruction:
  ;
}

/******************************************************************** PSL **
i_ScsiBusResetExceptionCheck
		(vect, excep_flag, excep_code, excep_arg_pos)
       written by f-takei@icot22      on Tue Oct  1 20:26:31 1991

<Arguments>
    vect : $BF~NO0z?t%Y%/%?(B {Node, Processor, SCSI_Port, SCSI_ID}
    excep_flag : $B%(%/%;%W%7%g%s$,H/@8$7$?$+$I$&$+$r<($9%U%i%0(B(destination)
    excep_code    : $BNc30%3!<%I(B(destination)
    excep_arg_pos : $BNc30$,5/$-$?0z?t0LCV(B(destination)
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    scsi_bus_reset/1 $B$NF~NO0z?t$NNc30%A%'%C%/$r9T$J$&!#(B
    $BNc30$,5/$-$?>l9g$=$N0z?t0LCV$r(B excep_arg_pos $B$K!"Nc30%3!<%I$r(B excep_code
    $B$K@_Dj$9$k!#(B
    vect $B$NMWAG$O%G%l%U%!%l%s%9$r$9$k$H$H$b$K%Y%/%?K\BN$K=q$-La$7$r$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkScsiPort XXX

#PSL_define i_ScsiBusResetExceptionCheck
		(vect, excep_flag, excep_code, excep_arg_pos)
{
  $USE(D_Workreg1);
  f_ActiveDeref(vect, D_Workreg1);
  s_IfNotVECT4(vect){
      s_IfUnbound(vect){
	  @DEBUG{WARNING("i_ScsiBusResetExceptionCheck", "vect");};
	  p_MoveWord(D_Workreg1, vect);
	  $RELEASE(D_Workreg1);
	  goto CHECK_END;
      }else{
	  $RELEASE(D_Workreg1);
	  b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, excep_code);
	  b_SetImmTypeValueMRBoff(INT, _ZERO, excep_arg_pos);
	  p_MoveWord(D_ONE, excep_flag);
	  goto END;
      }
  }
  $RELEASE(D_Workreg1);

  $USE(D_WorkNodeNum); $USE(D_WorkPENum); $USE(D_WorkScsiPort); $USE(D_WorkID);
  /* $BF~NO%Y%/%?MWAG$NFI$_=P$7(B */
  s_ReadWithOffsetMRBor(vect, _ELEM1_OFST_VECT, D_WorkNodeNum);
  s_ReadWithOffsetMRBor(vect, _ELEM2_OFST_VECT, D_WorkPENum);
  s_ReadWithOffsetMRBor(vect, _ELEM3_OFST_VECT, D_WorkScsiPort);
  s_ReadWithOffsetMRBor(vect, _ELEM4_OFST_VECT, D_WorkID);

  $USE(D_WorkPos);
  b_SetZero(D_WorkPos);
/*---------- $BBh(B0$BMWAG$N%A%'%C%/(B ----------------*/
  f_DerefElementReg(vect, D_WorkPos, D_WorkNodeNum);
  s_IfINT(D_WorkNodeNum){
      b_IfScsiRangeErr(D_WorkNodeNum, _ZERO, _MAX_CLUSTER){
	  $RELEASE(D_WorkPos); $RELEASE(D_WorkNodeNum); $RELEASE(D_WorkPENum);
	  $RELEASE(D_WorkScsiPort); $RELEASE(D_WorkID);
	  b_SetImmTypeValueMRBoff(INT, _RANGE_OVERFLOW_EXCP, excep_code);
	  b_SetImmTypeValueMRBoff(INT, _ZERO, excep_arg_pos);
	  goto EXCEPTION;
      }else{
	  b_IfNotEqual(D_WorkNodeNum, D_CL_Number){
	      $RELEASE(D_WorkPos); $RELEASE(D_WorkNodeNum);
	      $RELEASE(D_WorkPENum);
	      $RELEASE(D_WorkScsiPort); $RELEASE(D_WorkID);
	      b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, excep_code);
	      b_SetImmTypeValueMRBoff(INT, _ZERO, excep_arg_pos);
	      goto EXCEPTION;
	  }
	  $RELEASE(D_WorkNodeNum);
      }
  }else{
      s_IfREF(D_WorkNodeNum){
	  $RELEASE(D_WorkPos); $RELEASE(D_WorkNodeNum); $RELEASE(D_WorkPENum);
	  $RELEASE(D_WorkScsiPort); $RELEASE(D_WorkID);
	  goto CHECK_END;
      }
      $RELEASE(D_WorkPos); $RELEASE(D_WorkNodeNum); $RELEASE(D_WorkPENum);
      $RELEASE(D_WorkScsiPort); $RELEASE(D_WorkID);
      b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, excep_code);
      b_SetImmTypeValueMRBoff(INT, _ZERO, excep_arg_pos);
      goto EXCEPTION;
  }
/*---------- $BBh(B1$BMWAG$N%A%'%C%/(B ----------------*/
  b_IncrementAddrReg(D_WorkPos);
  f_DerefElementReg(vect, D_WorkPos, D_WorkPENum);
  s_IfINT(D_WorkPENum){
      b_IfScsiRangeErr(D_WorkPENum, _ZERO, _MAX_PE_NUM){
	  $RELEASE(D_WorkPos); $RELEASE(D_WorkPENum);
	  $RELEASE(D_WorkScsiPort); $RELEASE(D_WorkID);
	  b_SetImmTypeValueMRBoff(INT, _RANGE_OVERFLOW_EXCP, excep_code);
	  b_SetImmTypeValueMRBoff(INT, _ZERO, excep_arg_pos);
	  goto EXCEPTION;
      }else{
	  b_IfNotEqual(D_WorkPENum, D_PE_Number){
	      $RELEASE(D_WorkPos); $RELEASE(D_WorkPENum);
	      $RELEASE(D_WorkScsiPort); $RELEASE(D_WorkID);
	      b_SetImmTypeValueMRBoff(INT, _RANGE_OVERFLOW_EXCP, excep_code);
	      b_SetImmTypeValueMRBoff(INT, _ZERO, excep_arg_pos);
	      goto EXCEPTION;
	  }
	  $RELEASE(D_WorkPENum);
      }
  }else{
      s_IfREF(D_WorkPENum){
	  $RELEASE(D_WorkPos); $RELEASE(D_WorkPENum);
	  $RELEASE(D_WorkScsiPort); $RELEASE(D_WorkID);
	  goto CHECK_END;
      }
      $RELEASE(D_WorkPos); $RELEASE(D_WorkPENum);
      $RELEASE(D_WorkScsiPort); $RELEASE(D_WorkID);
      b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, excep_code);
      b_SetImmTypeValueMRBoff(INT, _ZERO, excep_arg_pos);
      goto EXCEPTION;
  }
/*---------- $BBh(B2$BMWAG$N%A%'%C%/(B ----------------*/
  b_IncrementAddrReg(D_WorkPos);
  f_DerefElementReg(vect, D_WorkPos, D_WorkScsiPort);
  s_IfINT(D_WorkScsiPort){
      b_IfNotZero(D_WorkScsiPort){
	  $RELEASE(D_WorkPos);
	  $RELEASE(D_WorkScsiPort); $RELEASE(D_WorkID);
	  b_SetImmTypeValueMRBoff(INT, _RANGE_OVERFLOW_EXCP, excep_code);
	  b_SetImmTypeValueMRBoff(INT, _ZERO, excep_arg_pos);
	  goto EXCEPTION;
      }
      $RELEASE(D_WorkScsiPort);
  }else{
      s_IfREF(D_WorkScsiPort){
	  $RELEASE(D_WorkPos);
	  $RELEASE(D_WorkScsiPort); $RELEASE(D_WorkID);
	  goto CHECK_END;
      }
      $RELEASE(D_WorkPos);
      $RELEASE(D_WorkScsiPort); $RELEASE(D_WorkID);
      b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, excep_code);
      b_SetImmTypeValueMRBoff(INT, _ZERO, excep_arg_pos);
      goto EXCEPTION;
  }
/*---------- $BBh(B3$BMWAG$N%A%'%C%/(B ----------------*/
  b_IncrementAddrReg(D_WorkPos);
  f_DerefElementReg(vect, D_WorkPos, D_WorkID);
  $RELEASE(D_WorkPos);
  s_IfINT(D_WorkID){
      b_IfScsiRangeErr(D_WorkID, _SCSI_MIN_UNIT_NUMBER, _SCSI_MAX_UNIT_NUMBER){
	  $RELEASE(D_WorkID);
	  b_SetImmTypeValueMRBoff(INT, _RANGE_OVERFLOW_EXCP, excep_code);
	  b_SetImmTypeValueMRBoff(INT, _ZERO, excep_arg_pos);
	  goto EXCEPTION;
      }
  }else{
      s_IfREF(D_WorkID){
	  $RELEASE(D_WorkID);
	  goto CHECK_END;
      }
      s_IfNotATOM(D_WorkID){
	  $RELEASE(D_WorkID);
	  b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, excep_code);
	  b_SetImmTypeValueMRBoff(INT, _ZERO, excep_arg_pos);
	  goto EXCEPTION;
      }else{
	  b_IfNotEqual(D_WorkID, D_NULL){
	      $RELEASE(D_WorkID);
	      b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, excep_code);
	      b_SetImmTypeValueMRBoff(INT, _ZERO, excep_arg_pos);
	      goto EXCEPTION;
	  }
	  $RELEASE(D_WorkID);
      }
  }

 CHECK_END:
  b_SetZero(excep_flag);
  goto END;

 EXCEPTION:
  p_MoveWord(D_ONE, excep_flag);

 END:
  ;
}

/******************************************************************** PSL **
kblt_b_scsi_terminate
       written by f-takei@icot22      on Tue Oct  1 20:09:10 1991

<Arguments>
    $B$J$7!#(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    scsi_init/3 $B$K$h$C$F@8@.$5$l$?%9%H%j!<%`(B
       D_ScsiInterruptStr, D_ScsiSelectVect
    $B$r(B nil $B$K6qBN2=$7$FJD$8$k!#(B
    $B$^$?!"(BSCSI $B$H$N%"%/%;%9$rJD$8$k!#(B
<Examples>
<Test>
<Explanation>
    $BEvAH9~=R8l$G$O!"$3$l$r<B9T$7$?%W%m%;%C%5$,%9%H%j!<%`$r;}$C$F$$$k$+(B
    ($B$9$J$o$A!"(Bscsi_init/3 $B$K$h$C$F=i4|2=$5$l$F$$$k$+(B)$BH]$+$K$D$$$F$O!"(B
    $B%A%'%C%/$7$J$$!#$3$l$K$D$$$F$O!"$9$Y$F(B KL1 $B%W%m%0%i%`$N@UG$$H$J$k!#(B
    $B<B9T40N;A0$NM=LsA`:n$K$D$$$F$N=hM}$O!"$3$3$G$O9T$o$J$$!#$7$?$,$C$F!"(B
    $BEvAH9~=R8l<B9TA0$K$O!"M=LsA`:n$,$J$$>uBV$H$7$F$*$/$Y$-$G$"$k!#(B

    $BEvAH9~=R8l<B9T8e$O!":F$S(B scsi_init/3 $B$K$h$k=i4|2=$,9T$o$l$k$^$G$O!"(B
    SCSI $B$H$N%"%/%;%9$O!"(BSPC $B%A%C%W$r%j%;%C%H>uBV$H$7$F@ZCG$9$k!#(B
<ETC>
********************************************************************* PSL **/

#PSL_define kblt_b_scsi_terminate()
{
    $USE(D_WorkData);
    b_SetImmTypeValueMRBoff(ATOM, _ZERO, D_WorkData);

    $USE(D_WorkEnvRecPtr);
    s_AllocNonDebugEnvRecord(D_WorkEnvRecPtr);
    $USE(D_WorkPriority);
    b_SetImmTypeValueMRBoff(INT, _MAX_LOGICAL_PRIO, D_WorkPriority);
    s_PutPriorityEnvRecord(D_WorkEnvRecPtr, D_WorkPriority);
    $RELEASE(D_WorkPriority);
    s_PutImmAttributeEnvRecord(D_WorkEnvRecPtr, _RESIDENT_PE);
    $USE(D_WorkFPPtr);
    b_SetImmTypeValueMRBoff
	(FPREC, _DUMMY_FOSTER_PARENT_AREA_BASE, D_WorkFPPtr); 
    $CALL(f_UnifyRetryInOtherFP_Sub
	  (D_WorkFPPtr, D_WorkEnvRecPtr, D_WorkData, D_ScsiInterruptStr));

    s_AllocNonDebugEnvRecord(D_WorkEnvRecPtr);
    $USE(D_WorkPriority);
    b_SetImmTypeValueMRBoff(INT, _MAX_LOGICAL_PRIO, D_WorkPriority);
    s_PutPriorityEnvRecord(D_WorkEnvRecPtr, D_WorkPriority);
    $RELEASE(D_WorkPriority);
    s_PutImmAttributeEnvRecord(D_WorkEnvRecPtr, _RESIDENT_PE);
    b_SetImmTypeValueMRBoff
	(FPREC, _DUMMY_FOSTER_PARENT_AREA_BASE, D_WorkFPPtr); 
    $CALL(f_UnifyRetryInOtherFP_Sub
	  (D_WorkFPPtr, D_WorkEnvRecPtr, D_WorkData, D_ScsiSelectVect));
    $RELEASE(D_WorkFPPtr);
    $RELEASE(D_WorkEnvRecPtr);
    $RELEASE(D_WorkData);

    b_SetEOL(D_ScsiInterruptStr);
    b_SetEOL(D_ScsiSelectVect);

    b_ScsiSPCResetAndDisable();
    /* SPC $B$r%j%;%C%H>uBV$K$9$k!#(B*/
}
