
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V10/interpreter/klb_body_blt_floating_point.psl.c
   ----- CREATED   : by yamamoto@icot22, on Sun Jun 23 17:50:28 1991
   ----- LAST SAVED: by yamamoto@icot22, on Tue Sep  3 22:41:33 1991
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : 
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **

b_floating_point_add  A1 A2 A3


  0            1            2            3            4
  +------------+------------+------------+------------+
  |  b_floating_point_add   |     A1     |     A2     |
  +------------+------------+------------+------------+
  |    A3      |              don't care              |
  +------------+------------+------------+------------+

<Arguments>
  A1   $B%l%8%9%?(B($BL$Dj5A$J$i!"%5%9%Z%s%I!#(BFLT$B0J30$K6qBN2=$5$l$F$$$?$i!"Nc30(B)
  A2   $B%l%8%9%?(B($BL$Dj5A$J$i!"%5%9%Z%s%I!#(BFLT$B0J30$K6qBN2=$5$l$F$$$?$i!"Nc30(B)
  A3   $B%l%8%9%?(B(FLT$B=PNO(B)
<Temporally Used Variables>
<Level>        INTERPRETER
<PreCondition>
<Function>
  $B!&(BA1$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I$K$h$k%5%9%Z%s%I=hM}$r9T$$!"<!L?Na$r<B9T!#(B
    $B!&IbF0>.?tE@?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30=hM}!#(B
  $B!&(BA2$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I$K$h$k%5%9%Z%s%I=hM}$r9T$$!"<!L?Na$r<B9T!#(B
    $B!&IbF0>.?tE@?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30=hM}!#(B
  $B!&(BA1$B$H(BA2$B$r2C$($?CM$r!"(BA3$B$K=q$-9~$`!#(B
    $B!&%R!<%W>e$N%G!<%?$N<BBN$O(BA1,A2$B$K(BMRBoff$B$N$b$N$,$"$l$P!":FMxMQ$9$k!#(B
<Examples>
<Test>
<Explanation>
  $B!&%=!<%9%l%8%9%?$,L$Dj5A$N>l9g!"(BD$B%3!<%I$K$h$k%4!<%k$r@8@.$7!"(B
    $B%5%9%Z%s%I=hM}$r9T$&!#(B
  $B!&0l$DL\$N0z?t$G%5%9%Z%s%I$r5/$3$9>l9g$K!"Fs$DL\$N0z?t$O%A%'%C%/$7$J$$(B
<ETC>
********************************************************************* PSL **/

#OPF_define I_FltSrc1 _IndirectRegField1
#OPF_define I_FltSrc2 _IndirectRegField2
#OPF_define I_FltDst  _IndirectRegField3

#PSL_define kblt_b_floating_point_add(){
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp3ArgVect_IIO_Sub
	    (D_WorkArgVect,I_FltSrc1,I_FltSrc2,I_FltDst));
      f_TraceBodyBuiltin(BLT_B_FLOATING_POINT_ADD,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };
  s_IfFLT (I_FltSrc1) {
    s_IfFLT (I_FltSrc2) {
      s_FLT_Add(I_FltSrc1, I_FltSrc2, I_FltDst);
      goto End_of_KL1B_Instruction; /* end of KLB instruction */
    }
  }
  i_BodyBltFloatingPoint3Arg (BLT_B_FLOATING_POINT_ADD, 
			      I_FltSrc1, I_FltSrc2, I_FltDst);
 End_of_KL1B_Instruction: ;
}

/******************************************************************** PSL **

b_floating_point_subtract  A1 A2 A3


  0            1            2            3            4
  +------------+------------+------------+------------+
  | b_floating_subtract_add |     A1     |     A2     |
  +------------+------------+------------+------------+
  |    A3      |              don't care              |
  +------------+------------+------------+------------+

<Arguments>
  A1   $B%l%8%9%?(B($BL$Dj5A$J$i!"%5%9%Z%s%I!#(BFLT$B0J30$K6qBN2=$5$l$F$$$?$i!"Nc30(B)
  A2   $B%l%8%9%?(B($BL$Dj5A$J$i!"%5%9%Z%s%I!#(BFLT$B0J30$K6qBN2=$5$l$F$$$?$i!"Nc30(B)
  A3   $B%l%8%9%?(B(FLT$B=PNO(B)
<Temporally Used Variables>
<Level>        INTERPRETER
<PreCondition>
<Function>
  $B!&(BA1$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I$K$h$k%5%9%Z%s%I=hM}$r9T$$!"<!L?Na$r<B9T!#(B
    $B!&IbF0>.?tE@?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30=hM}!#(B
  $B!&(BA2$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I$K$h$k%5%9%Z%s%I=hM}$r9T$$!"<!L?Na$r<B9T!#(B
    $B!&IbF0>.?tE@?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30=hM}!#(B
  $B!&(BA1$B$+$i(BA2$B$r0z$$$?CM$r!"(BA3$B$K=q$-9~$`!#(B
    $B!&%R!<%W>e$N%G!<%?$N<BBN$O(BA1,A2$B$K(BMRBoff$B$N$b$N$,$"$l$P!":FMxMQ$9$k!#(B
<Examples>
<Test>
<Explanation>
  $B!&%=!<%9%l%8%9%?$,L$Dj5A$N>l9g!"(BD$B%3!<%I$K$h$k%4!<%k$r@8@.$7!"(B
    $B%5%9%Z%s%I=hM}$r9T$&!#(B
  $B!&0l$DL\$N0z?t$G%5%9%Z%s%I$r5/$3$9>l9g$K!"Fs$DL\$N0z?t$O%A%'%C%/$7$J$$(B
<ETC>
********************************************************************* PSL **/

#OPF_define I_FltSrc1 _IndirectRegField1
#OPF_define I_FltSrc2 _IndirectRegField2
#OPF_define I_FltDst  _IndirectRegField3

#PSL_define kblt_b_floating_point_subtract(){
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp3ArgVect_IIO_Sub
	    (D_WorkArgVect,I_FltSrc1,I_FltSrc2,I_FltDst));
      f_TraceBodyBuiltin(BLT_B_FLOATING_POINT_SUBTRACT,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };
  s_IfFLT (I_FltSrc1) {
    s_IfFLT (I_FltSrc2) {
      s_FLT_Subtract(I_FltSrc1, I_FltSrc2, I_FltDst);
      goto End_of_KL1B_Instruction; /* end of KLB instruction */
    }
  }
  i_BodyBltFloatingPoint3Arg (BLT_B_FLOATING_POINT_SUBTRACT, 
			      I_FltSrc1, I_FltSrc2, I_FltDst);
 End_of_KL1B_Instruction: ;
}

/******************************************************************** PSL **

b_floating_point_multiply  A1 A2 A3


  0            1            2            3            4
  +------------+------------+------------+------------+
  |b_floating_point_multiply|     A1     |     A2     |
  +------------+------------+------------+------------+
  |    A3      |              don't care              |
  +------------+------------+------------+------------+

<Arguments>
  A1   $B%l%8%9%?(B($BL$Dj5A$J$i!"%5%9%Z%s%I!#(BFLT$B0J30$K6qBN2=$5$l$F$$$?$i!"Nc30(B)
  A2   $B%l%8%9%?(B($BL$Dj5A$J$i!"%5%9%Z%s%I!#(BFLT$B0J30$K6qBN2=$5$l$F$$$?$i!"Nc30(B)
  A3   $B%l%8%9%?(B(FLT$B=PNO(B)
<Temporally Used Variables>
<Level>        INTERPRETER
<PreCondition>
<Function>
  $B!&(BA1$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I$K$h$k%5%9%Z%s%I=hM}$r9T$$!"<!L?Na$r<B9T!#(B
    $B!&IbF0>.?tE@?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30=hM}!#(B
  $B!&(BA2$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I$K$h$k%5%9%Z%s%I=hM}$r9T$$!"<!L?Na$r<B9T!#(B
    $B!&IbF0>.?tE@?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30=hM}!#(B
  $B!&(BA1$B$H(BA2$B$r3]$19g$o$;$?CM$r!"(BA3$B$K=q$-9~$`!#(B
    $B!&%R!<%W>e$N%G!<%?$N<BBN$O(BA1,A2$B$K(BMRBoff$B$N$b$N$,$"$l$P!":FMxMQ$9$k!#(B
<Examples>
<Test>
<Explanation>
  $B!&%=!<%9%l%8%9%?$,L$Dj5A$N>l9g!"(BD$B%3!<%I$K$h$k%4!<%k$r@8@.$7!"(B
    $B%5%9%Z%s%I=hM}$r9T$&!#(B
  $B!&0l$DL\$N0z?t$G%5%9%Z%s%I$r5/$3$9>l9g$K!"Fs$DL\$N0z?t$O%A%'%C%/$7$J$$(B
<ETC>
********************************************************************* PSL **/

#OPF_define I_FltSrc1 _IndirectRegField1
#OPF_define I_FltSrc2 _IndirectRegField2
#OPF_define I_FltDst  _IndirectRegField3

#PSL_define kblt_b_floating_point_multiply(){
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp3ArgVect_IIO_Sub
	    (D_WorkArgVect,I_FltSrc1,I_FltSrc2,I_FltDst));
      f_TraceBodyBuiltin(BLT_B_FLOATING_POINT_MULTIPLY,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };
  s_IfFLT (I_FltSrc1) {
    s_IfFLT (I_FltSrc2) {
      s_FLT_Multiply(I_FltSrc1, I_FltSrc2, I_FltDst);
      goto End_of_KL1B_Instruction; /* end of KLB instruction */
    }
  }
  i_BodyBltFloatingPoint3Arg (BLT_B_FLOATING_POINT_MULTIPLY, 
			      I_FltSrc1, I_FltSrc2, I_FltDst);
 End_of_KL1B_Instruction: ;
}

/******************************************************************** PSL **

b_floating_point_divide  A1 A2 A3


  0            1            2            3            4
  +------------+------------+------------+------------+
  | b_floating_point_divide |     A1     |     A2     |
  +------------+------------+------------+------------+
  |    A3      |              don't care              |
  +------------+------------+------------+------------+

<Arguments>
  A1   $B%l%8%9%?(B($BL$Dj5A$J$i!"%5%9%Z%s%I!#(BFLT$B0J30$K6qBN2=$5$l$F$$$?$i!"Nc30(B)
  A2   $B%l%8%9%?(B($BL$Dj5A$J$i!"%5%9%Z%s%I!#(BFLT$B0J30$K6qBN2=$5$l$F$$$?$i!"Nc30(B)
  A3   $B%l%8%9%?(B(FLT$B=PNO(B)
<Temporally Used Variables>
<Level>        INTERPRETER
<PreCondition>
<Function>
  $B!&(BA1$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I$K$h$k%5%9%Z%s%I=hM}$r9T$$!"<!L?Na$r<B9T!#(B
    $B!&IbF0>.?tE@?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30=hM}!#(B
  $B!&(BA2$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I$K$h$k%5%9%Z%s%I=hM}$r9T$$!"<!L?Na$r<B9T!#(B
    $B!&IbF0>.?tE@?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30=hM}!#(B
  $B!&(BA1$B$r(BA2$B$G3d$C$?CM$r!"(BA3$B$K=q$-9~$`!#(B
    $B!&%R!<%W>e$N%G!<%?$N<BBN$O(BA1,A2$B$K(BMRBoff$B$N$b$N$,$"$l$P!":FMxMQ$9$k!#(B
<Examples>
<Test>
<Explanation>
  $B!&%=!<%9%l%8%9%?$,L$Dj5A$N>l9g!"(BD$B%3!<%I$K$h$k%4!<%k$r@8@.$7!"(B
    $B%5%9%Z%s%I=hM}$r9T$&!#(B
  $B!&0l$DL\$N0z?t$G%5%9%Z%s%I$r5/$3$9>l9g$K!"Fs$DL\$N0z?t$O%A%'%C%/$7$J$$(B
<ETC>
********************************************************************* PSL **/

#OPF_define I_FltSrc1 _IndirectRegField1
#OPF_define I_FltSrc2 _IndirectRegField2
#OPF_define I_FltDst  _IndirectRegField3

#PSL_define kblt_b_floating_point_divide(){
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp3ArgVect_IIO_Sub
	    (D_WorkArgVect,I_FltSrc1,I_FltSrc2,I_FltDst));
      f_TraceBodyBuiltin(BLT_B_FLOATING_POINT_DIVIDE,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };
  s_IfFLT (I_FltSrc1) {
    s_IfFLT (I_FltSrc2) {
      s_FLT_Divide(I_FltSrc1, I_FltSrc2, I_FltDst);
      goto End_of_KL1B_Instruction; /* end of KLB instruction */
    }
  }
  i_BodyBltFloatingPoint3Arg (BLT_B_FLOATING_POINT_DIVIDE, 
			      I_FltSrc1, I_FltSrc2, I_FltDst);
 End_of_KL1B_Instruction: ;
}

/* klb_body_blt_arith.psl.c $B$N$d$jJ}$r??;w$F$_$^$7$?!#(B*/

#PSL_define i_BodyBltFloatingPoint3Arg(imm_ope, src1, src2, dst)
{
  $USE(D_WorkArithOpe);
  b_SetImmTypeValueMRBoff (INT, imm_ope, D_WorkArithOpe);
  $CALL( i_BodyBltFloatingPoint3Arg_Sub (D_WorkArithOpe, src1, src2, dst) );
  $RELEASE(D_WorkArithOpe);
}

#SUBARG_define	A_ArithOpe	SRC
#SUBARG_define	A_Arg0		MODIFY
#SUBARG_define	A_Arg1		MODIFY
#SUBARG_define	A_Arg2		DST

#SUBROUTINE i_BodyBltFloatingPoint3Arg_Sub (A_ArithOpe, A_Arg0, A_Arg1, A_Arg2)
{
  $USE(D_WorkDrfPtr);
  f_ActiveDeref(A_Arg0,D_WorkDrfPtr);
  s_IfFLT(A_Arg0) { 		/* $BBh0l0z?t$,(BFLT$B$N>l9g(B */
    f_ActiveDeref(A_Arg1,D_WorkDrfPtr);
    s_IfFLT(A_Arg1) {		/* $BBhFs0z?t$,(BFLT$B$N>l9g(B  */
      $RELEASE(D_WorkDrfPtr);
      i_ExecuteBodyFloatingPoint3Arg(A_ArithOpe,A_Arg0,A_Arg1,A_Arg2);
      $RETURN();
    } else {
      s_IfUnbound(A_Arg1) {
	p_MoveWord(D_WorkDrfPtr, A_Arg1);
	goto Suspend;
      } else {
	goto Exception_1;
      }
    }
  } else { /* $BBh0l0z?t$,(BFLT$B0J30$N>l9g(B */
    s_IfUnbound(A_Arg0) {
      p_MoveWord(D_WorkDrfPtr, A_Arg0);
      goto Suspend;
    } else {
      goto Exception_0;
    }
  }
 Suspend:
  $RELEASE(D_WorkDrfPtr);
  f_DcodeEnqueue3Ope_IIO_Reg(A_ArithOpe,A_Arg0,A_Arg1,A_Arg2);
  $RETURN();
 Exception_0:
  $RELEASE(D_WorkDrfPtr);
  $USE(D_WorkExcepArgPos);
  b_SetImmTypeValueMRBoff (INT, _ZERO, D_WorkExcepArgPos);
  goto Exception_Common;
 Exception_1:
  $RELEASE(D_WorkDrfPtr);
  $USE(D_WorkExcepArgPos);
  b_SetImmTypeValueMRBoff (INT, _ONE, D_WorkExcepArgPos);
 Exception_Common:
  $USE(D_WorkExceptionCode);
  b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
  $CALL (f_Exception_3Arg_IIO_Sub (D_WorkExceptionCode, A_ArithOpe, 
				   D_WorkExcepArgPos, A_Arg0, A_Arg1, A_Arg2));
  $RELEASE (D_WorkExceptionCode);
  $RELEASE(D_WorkExcepArgPos);
  $RETURN ();
}

#PSL_define i_ExecuteBodyFloatingPoint3Arg (ope_code_reg, arg1, arg2, arg3)
{
  ValueSwitch (ope_code_reg) {
    case BLT_B_FLOATING_POINT_ADD :
      s_FLT_Add(arg1,arg2,arg3);
      break;
    case BLT_B_FLOATING_POINT_SUBTRACT :
      s_FLT_Subtract(arg1,arg2,arg3);
      break;
    case BLT_B_FLOATING_POINT_MULTIPLY :
      s_FLT_Multiply(arg1,arg2,arg3);
      break;
    case BLT_B_FLOATING_POINT_DIVIDE :
      s_FLT_Divide(arg1,arg2,arg3);
      break;
    default:
      @DEBUG{
	OUT_OF_SPEC("body_blt_3_ope_floating_point","illegal_operation");
      };
  } /* end of ValueSwitch */
}

/************************ conversion *******************/

/******************************************************************** PSL **

b_floating_point_to_integer  A1 A2


  0            1            2            3            4
  +------------+------------+------------+------------+
  |  b_floating_point_add   |     A1     |     A2     |
  +------------+------------+------------+------------+

<Arguments>
  A1   $B%l%8%9%?(B($BL$Dj5A$J$i!"%5%9%Z%s%I!#(BFLT$B0J30$K6qBN2=$5$l$F$$$?$i!"Nc30(B)
  A2   $B%l%8%9%?(B(INT$B=PNO(B)
<Temporally Used Variables>
<Level>        INTERPRETER
<PreCondition>
<Function>
  $B!&(BA1$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I$K$h$k%5%9%Z%s%I=hM}$r9T$$!"<!L?Na$r<B9T!#(B
    $B!&IbF0>.?tE@?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30=hM}!#(B
  $B!&(BA1$B$H@0?t$KJQ49$7$?CM$r!"(BA3$B$K=q$-9~$`!#(B
    $B!&%R!<%W>e$N%G!<%?$N<BBN$O(BA1$B$,(BMRBoff$B$J$i2s<}$9$k!#(B
<Examples>
<Test>
<Explanation>
  $B!&%=!<%9%l%8%9%?$,L$Dj5A$N>l9g!"(BD$B%3!<%I$K$h$k%4!<%k$r@8@.$7!"(B
    $B%5%9%Z%s%I=hM}$r9T$&!#(B
<ETC>
********************************************************************* PSL **/

#OPF_define I_FltSrc _IndirectRegField1
#OPF_define I_IntDst _IndirectRegField2

#PSL_define kblt_b_floating_point_to_integer(){
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp2ArgVect_IO_Sub
	    (D_WorkArgVect,I_FltSrc,I_IntDst));
      f_TraceBodyBuiltin(BLT_B_FLOATING_POINT_TO_INTEGER,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };
  s_IfFLT(I_FltSrc){
    f_FloatingPointToIntegerAndCheckOverFlowException(I_FltSrc,I_IntDst);
    goto End_of_KL1B_Instruction; 
  }
  $USE(D_WorkDrfPtr);
  f_ActiveDeref(I_FltSrc,D_WorkDrfPtr);
  s_IfFLT(I_FltSrc){
    $RELEASE(D_WorkDrfPtr);
    f_FloatingPointToIntegerAndCheckOverFlowException(I_FltSrc,I_IntDst);
    goto End_of_KL1B_Instruction; 
  }
  s_IfUnbound(I_FltSrc) {
    p_MoveWord(D_WorkDrfPtr, I_FltSrc);
    $RELEASE(D_WorkDrfPtr);
    f_DcodeEnqueue2Ope_IO(BLT_B_FLOATING_POINT_TO_INTEGER,
			      I_FltSrc,I_IntDst);
    goto End_of_KL1B_Instruction;
  }
  $RELEASE(D_WorkDrfPtr);
  $USE (D_WorkOpCode);
  b_SetImmTypeValueMRBoff (INT, BLT_B_FLOATING_POINT_TO_INTEGER, D_WorkOpCode);
  $USE(D_WorkExcepArgPos);
  b_SetImmTypeValueMRBoff (INT, _ZERO, D_WorkExcepArgPos);
  $USE(D_WorkExceptionCode);
  b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
  $CALL (f_Exception_2Arg_IO_Sub (D_WorkExceptionCode, 
				  D_WorkOpCode, 
				  D_WorkExcepArgPos, I_FltSrc,I_IntDst));
  $RELEASE (D_WorkExceptionCode);
  $RELEASE (D_WorkOpCode);
  $RELEASE(D_WorkExcepArgPos);
 End_of_KL1B_Instruction: ;
}

#OPF_define I_IntSrc _IndirectRegField1
#OPF_define I_FltDst _IndirectRegField2

#PSL_define kblt_b_integer_to_floating_point(){
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp2ArgVect_IO_Sub
	    (D_WorkArgVect,I_IntSrc,I_FltDst));
      f_TraceBodyBuiltin(BLT_B_INTEGER_TO_FLOATING_POINT,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };
  s_IfINT(I_IntSrc){
      s_IntegerToFloatingPoint(I_IntSrc,I_FltDst);
      goto End_of_KL1B_Instruction; 
  }
  $USE(D_WorkDrfPtr);
  f_ActiveDeref(I_IntSrc,D_WorkDrfPtr);
  s_IfINT(I_IntSrc){
    $RELEASE(D_WorkDrfPtr);
      s_IntegerToFloatingPoint(I_IntSrc,I_FltDst);
      goto End_of_KL1B_Instruction; 
  }
  s_IfUnbound(I_IntSrc) {
    p_MoveWord(D_WorkDrfPtr, I_IntSrc);
    $RELEASE(D_WorkDrfPtr);
    f_DcodeEnqueue2Ope_IO(BLT_B_INTEGER_TO_FLOATING_POINT,
			      I_IntSrc,I_FltDst);
    goto End_of_KL1B_Instruction;
  }
  $RELEASE(D_WorkDrfPtr);
  $USE (D_WorkOpCode);
  b_SetImmTypeValueMRBoff (INT, BLT_B_INTEGER_TO_FLOATING_POINT, D_WorkOpCode);
  $USE(D_WorkExcepArgPos);
  b_SetImmTypeValueMRBoff (INT, _ZERO, D_WorkExcepArgPos);
  $USE(D_WorkExceptionCode);
  b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
  $CALL (f_Exception_2Arg_IO_Sub (D_WorkExceptionCode, 
				  D_WorkOpCode, 
				  D_WorkExcepArgPos, I_IntSrc,I_FltDst));
  $RELEASE (D_WorkExceptionCode);
  $RELEASE (D_WorkOpCode);
  $RELEASE(D_WorkExcepArgPos);
 End_of_KL1B_Instruction: ;
}

#OPF_define I_FltSrc  _IndirectRegField1
#OPF_define I_IntDst1 _IndirectRegField2
#OPF_define I_IntDst2 _IndirectRegField3

#PSL_define kblt_b_floating_point_to_binary(){
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp3ArgVect_IOO_Sub
	    (D_WorkArgVect,I_FltSrc,I_IntDst1,I_IntDst2));
      f_TraceBodyBuiltin(BLT_B_FLOATING_POINT_TO_BINARY,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };
  s_IfFLT(I_FltSrc){
      s_FloatingPointToBinary(I_FltSrc,I_IntDst1,I_IntDst2);
      goto End_of_KL1B_Instruction; 
  }
  $USE(D_WorkDrfPtr);
  f_ActiveDeref(I_FltSrc,D_WorkDrfPtr);
  s_IfFLT(I_FltSrc){
    $RELEASE(D_WorkDrfPtr);
      s_FloatingPointToBinary(I_FltSrc,I_IntDst1,I_IntDst2);
      goto End_of_KL1B_Instruction; 
  }
  s_IfUnbound(I_FltSrc) {
    p_MoveWord(D_WorkDrfPtr, I_FltSrc);
    $RELEASE(D_WorkDrfPtr);
    f_DcodeEnqueue3Ope_IOO(BLT_B_FLOATING_POINT_TO_BINARY,
			      I_FltSrc,I_IntDst1,I_IntDst2);
    goto End_of_KL1B_Instruction;
  }
  $RELEASE(D_WorkDrfPtr);
  $USE (D_WorkOpCode);
  b_SetImmTypeValueMRBoff (INT, BLT_B_FLOATING_POINT_TO_BINARY, D_WorkOpCode);
  $USE(D_WorkExcepArgPos);
  b_SetImmTypeValueMRBoff (INT, _ZERO, D_WorkExcepArgPos);
  $USE(D_WorkExceptionCode);
  b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
  $CALL (f_Exception_3Arg_IOO_Sub (D_WorkExceptionCode, 
				   D_WorkOpCode, 
				   D_WorkExcepArgPos, 
				   I_FltSrc,I_IntDst1,I_IntDst2));
  $RELEASE (D_WorkExceptionCode);
  $RELEASE (D_WorkOpCode);
  $RELEASE(D_WorkExcepArgPos);

 End_of_KL1B_Instruction: ;
}

#OPF_define I_IntSrc1 _IndirectRegField1
#OPF_define I_IntSrc2 _IndirectRegField2
#OPF_define I_FltDst  _IndirectRegField3

#PSL_define kblt_b_binary_to_floating_point(){

  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp3ArgVect_IIO_Sub
	    (D_WorkArgVect,I_IntSrc1,I_IntSrc2,I_FltDst));
      f_TraceBodyBuiltin(BLT_B_BINARY_TO_FLOATING_POINT,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };
  $USE(D_WorkDrfPtr);
  f_ActiveDeref(I_IntSrc1,D_WorkDrfPtr);
  s_IfINT(I_IntSrc1){
    $RELEASE(D_WorkDrfPtr);
    $USE(D_WorkDrfPtr);
    f_ActiveDeref(I_IntSrc2,D_WorkDrfPtr);
    s_IfINT(I_IntSrc2){
      $RELEASE(D_WorkDrfPtr);
      s_BinaryToFloatingPoint(I_IntSrc1,I_IntSrc2,I_FltDst);
      goto End_of_KL1B_Instruction; 
    }
    s_IfUnbound(I_IntSrc2) {
      p_MoveWord(D_WorkDrfPtr, I_IntSrc2);
      $RELEASE(D_WorkDrfPtr);
      goto L_suspend;
    }
    $RELEASE(D_WorkDrfPtr);
    $USE(D_WorkExcepArgPos);
    b_SetImmTypeValueMRBoff (INT, _ONE, D_WorkExcepArgPos);
    goto L_exception;
  }
  s_IfUnbound(I_IntSrc1) {
    p_MoveWord(D_WorkDrfPtr, I_IntSrc1);
    $RELEASE(D_WorkDrfPtr);
    goto L_suspend;
  }
  $RELEASE(D_WorkDrfPtr);
  $USE(D_WorkExcepArgPos);
  b_SetImmTypeValueMRBoff (INT, _ZERO, D_WorkExcepArgPos);
  goto L_exception;

 L_suspend:
  f_DcodeEnqueue3Ope_IIO(BLT_B_BINARY_TO_FLOATING_POINT,
			I_IntSrc1,I_IntSrc2,I_FltDst);
  goto End_of_KL1B_Instruction;

 L_exception:

  $USE (D_WorkOpCode);
  b_SetImmTypeValueMRBoff (INT, BLT_B_BINARY_TO_FLOATING_POINT, D_WorkOpCode);
  $USE(D_WorkExceptionCode);
  b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
  $CALL (f_Exception_3Arg_IIO_Sub (D_WorkExceptionCode, 
				   D_WorkOpCode, 
				   D_WorkExcepArgPos,
				   I_IntSrc1,I_IntSrc2,I_FltDst));
  $RELEASE (D_WorkExceptionCode);
  $RELEASE (D_WorkOpCode);
  $RELEASE(D_WorkExcepArgPos);

 End_of_KL1B_Instruction: ;
}
