
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V10/interpreter/klb_body_blt_data.psl.c
   ----- CREATED   : by yamamoto@icot22, on Mon Jun  4 20:19:30 1990
   ----- LAST SAVED: by yamamoto@icot22, on Mon Aug  5 21:11:07 1991
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : INTERPRETER
   ----- ABSTRACT  : $B%G!<%?A`:nAH$_9~$_(B(....misc :-)
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
b_hash
       written by f-hataza@icot22      on Tue Apr  3 18:45:56 1990

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_SrcReg             _IndirectRegField1
#OPF_define I_HashValue          _IndirectRegField2
#OPF_define I_DstReg             _IndirectRegField3

#PSL_define kblt_b_hash()
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp3ArgVect_IOO_Sub
	    (D_WorkArgVect, I_SrcReg, I_HashValue, I_DstReg));
      f_TraceBodyBuiltin(BLT_B_HASH,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  $USE(D_Workreg);
  f_ActiveDeref(I_SrcReg,D_Workreg);
  s_IfUnbound(I_SrcReg) {
    p_MoveWord(D_Workreg,I_SrcReg);
    f_DcodeEnqueue3Ope_IOO(BLT_B_HASH,I_SrcReg,I_HashValue,I_DstReg);
  } else {
    f_Hash(I_SrcReg,I_HashValue);
    p_MoveWord(I_SrcReg,I_DstReg);
  }
  $RELEASE(D_Workreg);
 End_of_KL1B_Instruction:;
}

/******************************************************************** PSL **
hash$BMQ$N%^%/%m(B
       written by f-hataza@icot22      on Tue Apr  3 20:16:02 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
  f-$B%l%Y%k$N%^%/%m$@$1$I!"$H$j$"$($:$3$3$K$*$$$F$*$-$^$9!#(B(f-hataza,90.04.03)
********************************************************************* PSL **/
#CONST_define HASH_VALUE_OF_LIST    -1

#PSL_define f_Hash(src_reg, hash_reg)
{
  TypeSwitch (src_reg) {
    case INT:
      p_MoveWord (src_reg, hash_reg);
      break;
    case ATOM:
      b_MoveWithImmTypeMRBoff (src_reg, INT, hash_reg);
      break;
    case FLT:
      p_Read(src_reg,hash_reg);
      break;
    case NullVectorGrp ():
      b_MoveWithImmTypeMRBoff (D_NULL, INT, hash_reg);
      break;
    case ShortVectorGrp ():
      s_GetSizeShortVect (src_reg, hash_reg);
      break;
    case LongVectorGrp ():
      s_GetSizeLongVect (src_reg, hash_reg);
      break;
    case LIST:
      p_SetImmediateWord (INT, _MRB_OFF, HASH_VALUE_OF_LIST, hash_reg);
      break;
    case STRG:
      f_GetStringHashValue (src_reg, hash_reg);
      p_SetImmediateType (INT, hash_reg);
      break;
    case SHREC:
      s_GetShoenId (src_reg, hash_reg);
      p_SetImmediateType (INT, hash_reg);
      break;
    default:
      b_MoveWithImmTypeMRBoff(D_NULL, INT, hash_reg);
      break;
  }
}

/******************************************************************** PSL **
b_atom_number A1,A2

       written by f-hataza@icot22      on Thu Apr 12 16:56:37 1990
<Arguments>
  A1  $BF~NO(B  $B%"%H%`(B $B!J%l%8%9%?!K(B
  A2  $B=PNO(B  $B@0?t(B   $B!J%l%8%9%?!K(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  A2 $B$K(B $B%"%H%`(BA1 $B$N(B $B%"%H%`HV9f$r=PNO$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_SrcAtom _IndirectRegField1
#OPF_define I_DstNum  _IndirectRegField2

#PSL_define kblt_b_atom_number () 
{  
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp2ArgVect_IO_Sub(D_WorkArgVect, I_SrcAtom, I_DstNum));
      f_TraceBodyBuiltin(BLT_B_ATOM_NUMBER,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  $USE (D_WorkDerefPtr);

  f_ActiveDeref (I_SrcAtom, D_WorkDerefPtr);
  TypeSwitch (I_SrcAtom) {
    case ATOM:
      b_MoveWithImmTypeMRBoff (I_SrcAtom, INT, I_DstNum);
      break;
    case UnboundGroup (): 
      p_MoveWord (D_WorkDerefPtr, I_SrcAtom);
      f_DcodeEnqueue2Ope_IO (BLT_B_ATOM_NUMBER,I_SrcAtom, I_DstNum);
      break;
    default:
      $USE (D_WorkOpCode); $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, BLT_B_ATOM_NUMBER, D_WorkOpCode);
      b_SetImmTypeValueMRBoff (INT, _ZERO, D_WorkExcepArgPos);
      $CALL (f_Exception_2Arg_IO_Sub (D_WorkExceptionCode, D_WorkOpCode, 
			D_WorkExcepArgPos, I_SrcAtom, I_DstNum) );
      $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
      $RELEASE(D_WorkExcepArgPos);
      break;
    }
  $RELEASE (D_WorkDerefPtr);
 End_of_KL1B_Instruction:;
}

