
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/interpreter/klb_body_blt_cont.psl.c
   ----- CREATED   : by yamamoto@icot22, on Mon Jun  4 20:06:04 1990
   ----- LAST SAVED: by imai@icot22, on Fri May  1 11:41:47 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : INTERPRETER
   ----- ABSTRACT  : $B@)8f7O$NAH$_9~$_=R8l(B

  KL1$B$G=R8l$rF0E*$K8F$S=P$9AH$_9~$_=R8l!#AH$_9~$_=R8l(B 'apply'$B$O!"8=:_(B
$B<B9TCf$NN$?F$N2<$G<B9T$5$l$k%4!<%k$r6/@)E*$K%(%s%-%e!<$9$k!#(B
  'apply' $B$KEO$5$l$k0z?t$O!"<B9T$5$l$k%3!<%I$r;X$9%]%$%s%?$H%4!<%k$KEO(B
$B$5$l$k0z?t%Y%/%?$G$J$1$l$P$J$i$J$$!#(B
  $B<B9T$5$l$k%3!<%I$r;X$9%]%$%s%?$O!"AH$_9~$_=R8l(B 'predicate_to_code'$B$K(B
$B$h$C$F@8@.$5$l$k!#(B
  $BE57?E*$J;HMQNc$r0J2<$K<($9!#(B

 go(X):-true|predicate_to_code(module#ap,ap,3,CODE),apply(CODE,{[a],[d,c],X}).
                                   ^     ^  ^  ^                ^^^^^^^^^^^
                                   |     |  |  |                 $B0z?t%Y%/%?(B
                                   |     |  |  |
                                   |     |  |  +- $B%3!<%I$X$N%]%$%s%?(B
                                   |     |  +---- $B%"%j%F%#?t(B 
                                   |     +------- $B=R8lL>(B($B%"%H%`(B)
                                   +------------- $B%b%8%e!<%kL>(B($B%b%8%e!<%kDj?t(B)


  $B@)8f7O$NAH$_9~$_=R8l$bB>$N%\%G%#$NAH$_9~$_=R8l$HF1MM$K!"F~NO0z?t$,L$(B
$BDj5A$N>l9g%5%9%Z%s%I$9$k!#(B
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */


/******************************************************************** PSL **
b_apply A1, A2

       written by nakase@icot22      on Wed Feb 22 15:18:25 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |      b_apply          |     A1    |     A2    |
    +-----------+-----------+-----------+-----------+

<Arguments>
 A1: $B%3!<%I$X$N%]%$%s%?(B
 A2: $B0z$-?t%Y%/%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
$B!&(BA1 $B$,%3!<%I0J30$J$iNc30!"L$Dj5A$J$i%5%9%Z%s%I(B
$B!&(BA2 $B$,%Y%/%?0J30$J$iNc30!"L$Dj5A$J$i%5%9%Z%s%I(B
<Function>
 A1$B$G<($5$l$k%3!<%I$X$N%]%$%s%?$H(BA2$B$G<($5$l$k0z$-?t%Y%/%?$r;}$D%4!<%k(B
$B%l%3!<%I$r:n@.$7$F%(%s%-%e!<$9$k!#(B
<Examples> 
<Test> 
<Explanation>
<ETC>
********************************************************************PSL **/

#DATA_define D_WorkApplyGoal	XXX
#DATA_define D_WorkDerefPtr1	XXX

#OPF_define I_PtrToCode _IndirectRegField1
#OPF_define I_ArgVect _IndirectRegField2

#PSL_define kblt_b_apply()
{
  @DEBUG{
    s_IfArgTypeErr(I_PtrToCode){
      VPIM_ERROR("kblt_b_apply","InvalieArg1");
    };
    s_IfArgTypeErr(I_ArgVect){
      VPIM_ERROR("kblt_b_apply","InvalieArg2");
    }
  };

  $USE(D_WorkDerefPtr1);

  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp2ArgVect_II_Sub(D_WorkArgVect,I_PtrToCode,I_ArgVect));
      f_TraceBodyBuiltin(BLT_B_APPLY,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  f_ActiveDeref(I_PtrToCode,D_WorkDerefPtr1);
  s_IfCOD (I_PtrToCode) {
    @SPY{
      f_IfSpyMode() {
	f_IfSpiedCode(I_PtrToCode) {
	  $USE(D_WorkArgVect);
	  $CALL(f_MakeExcp2ArgVect_II_Sub
		(D_WorkArgVect,I_PtrToCode,I_ArgVect));
	  f_ReportSpyExceptionBuiltin( BLT_B_APPLY, D_WorkArgVect );
	  $RELEASE(D_WorkArgVect);
	  goto End_of_KL1B_Instruction;
	}
      }
    };
    f_ActiveDeref(I_ArgVect,D_WorkDerefPtr1);
    s_IfVectors(I_ArgVect) {
      i_IfSuccessArityCheckApply(I_PtrToCode,I_ArgVect) {
	$USE(D_WorkApplyGoal);
	i_AllocApplyGoal(D_WorkApplyGoal, I_PtrToCode, I_ArgVect);     
	f_AttachApplyInfoGoalRecord( D_WorkApplyGoal );
	f_PushGoalToStack (D_WorkApplyGoal);
	s_IncrementForkCounter ();
	$RELEASE(D_WorkApplyGoal);
	goto End_of_KL1B_Instruction;
      } else {
	goto Exception_Arity_Mismatch;
      }
    } else {
      s_IfUnbound(I_ArgVect) {
	p_MoveWord(D_WorkDerefPtr1, I_ArgVect);
	goto Suspend;
      } else {
	goto Exception_Arg1;
      }
    }
  } else {
    s_IfUnbound(I_PtrToCode) {
      p_MoveWord(D_WorkDerefPtr1, I_PtrToCode);
      goto Suspend;
    } else {
      goto Exception_Arg0;
    }
  }
 Suspend:
  f_DcodeEnqueue2Ope_II(BLT_B_APPLY,I_PtrToCode,I_ArgVect);
  goto End_of_KL1B_Instruction;
 Exception_Arity_Mismatch:
  $USE(D_WorkExceptionCode);
  b_SetImmTypeValueMRBoff(INT, _ARITY_MISMATCH_EXCP, D_WorkExceptionCode);
  $USE(D_WorkExcepArgPos);
  b_SetImmTypeValueMRBoff(INT, _ZERO, D_WorkExcepArgPos);
  goto Exception_Common;
 Exception_Arg0:
  $USE(D_WorkExcepArgPos);
  b_SetImmTypeValueMRBoff(INT, _ZERO, D_WorkExcepArgPos);
  goto Exception_ArgCommon;
 Exception_Arg1:
  $USE(D_WorkExcepArgPos);
  b_SetImmTypeValueMRBoff(INT, _ONE, D_WorkExcepArgPos);
 Exception_ArgCommon:
  $USE(D_WorkExceptionCode);
  b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
 Exception_Common:
  $USE(D_WorkOpCode); 
  b_SetImmTypeValueMRBoff(INT, BLT_B_APPLY, D_WorkOpCode);
  $CALL(f_Exception_2Arg_II_Sub(D_WorkExceptionCode,D_WorkOpCode,
				D_WorkExcepArgPos,I_PtrToCode,I_ArgVect) );
  $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
  $RELEASE(D_WorkExcepArgPos);
 End_of_KL1B_Instruction:
  $RELEASE(D_WorkDerefPtr1);
}

/******************************************************************** PSL **
b_apply_tracing A1, A2, A3

       written by imai@icot22      on Thu Dec 13 18:45:54 1990

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |   b_apply_tracing     |     A1    |     A2    |
    +-----------+-----------+-----------+-----------+
    |     A3    |             Don't Care            |
    +-----------+-----------+-----------+-----------+

<Arguments>
 A1: $B%3!<%I$X$N%]%$%s%?(B
 A2: $B0z$-?t%Y%/%?(B
 A3: $B%H%l!<%9(B ID ($BG$0U$N%G!<%?%?%$%W(B)
<Temporally Used Variables>
<Level>
<PreCondition>
$B!&(BA1 $B$,%3!<%I0J30$J$iNc30!"L$Dj5A$J$i%5%9%Z%s%I(B
$B!&(BA2 $B$,%Y%/%?0J30$J$iNc30!"L$Dj5A$J$i%5%9%Z%s%I(B
<Function>
 A1$B$G<($5$l$k%3!<%I$X$N%]%$%s%?$H(BA2$B$G<($5$l$k0z$-?t%Y%/%?$r;}$D%4!<%k(B
 $B%l%3!<%I$r:n@.$7$F!"%H%l!<%9%b!<%I$G%(%s%-%e!<$9$k!#(B
 A3 $B$O!"%H%l!<%9Nc30$r5/$3$7$?;~$KIUM?$9$k>pJs$G!"(B
 $B%G!<%?%?%$%W$O!"G$0U$G$"$k(B
<Examples> 
<Test> 
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define	I_PtrToCode	_IndirectRegField1
#OPF_define	I_ArgVect	_IndirectRegField2
#OPF_define	I_TraceId	_IndirectRegField3

#PSL_define kblt_b_apply_tracing()
{
  $USE(D_WorkDerefPtr1);

  @SPY{
    f_IfSpyMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp3ArgVect_III_Sub
	    (D_WorkArgVect,I_PtrToCode,I_ArgVect,I_TraceId));
      f_ReportSpyExceptionBuiltin( BLT_B_APPLY_TRACING, D_WorkArgVect );
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp3ArgVect_III_Sub
	    (D_WorkArgVect,I_PtrToCode,I_ArgVect,I_TraceId));
      f_TraceBodyBuiltin(BLT_B_APPLY_TRACING,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  f_ActiveDeref(I_PtrToCode,D_WorkDerefPtr1);
  s_IfCOD (I_PtrToCode) {
    f_ActiveDeref(I_ArgVect,D_WorkDerefPtr1);
    s_IfVectors(I_ArgVect) {
      i_IfSuccessArityCheckApply(I_PtrToCode,I_ArgVect) {
	$USE(D_WorkApplyGoal);
	i_AllocApplyGoal(D_WorkApplyGoal, I_PtrToCode, I_ArgVect);     
	f_AttachTracingInfoGoalRecord(D_WorkApplyGoal,I_TraceId);
	f_PushGoalToStack (D_WorkApplyGoal);
	s_IncrementForkCounter ();
	$RELEASE(D_WorkApplyGoal);
	goto End_of_KL1B_Instruction;
      } else {
	goto Exception_Arity_Mismatch;
      }
    } else {
      s_IfUnbound(I_ArgVect) {
	p_MoveWord(D_WorkDerefPtr1, I_ArgVect);
	goto Suspend;
      } else {
	goto Exception_Arg1;
      }
    }
  } else {
    s_IfUnbound(I_PtrToCode) {
      p_MoveWord(D_WorkDerefPtr1, I_PtrToCode);
      goto Suspend;
    } else {
      goto Exception_Arg0;
    }
  }
 Suspend:
  f_DcodeEnqueue3Ope_III(BLT_B_APPLY_TRACING,I_PtrToCode,I_ArgVect,I_TraceId);
  goto End_of_KL1B_Instruction;
 Exception_Arity_Mismatch:
  $USE(D_WorkExceptionCode);
  b_SetImmTypeValueMRBoff(INT, _ARITY_MISMATCH_EXCP, D_WorkExceptionCode);
  $USE(D_WorkExcepArgPos);
  b_SetImmTypeValueMRBoff(INT, _ZERO, D_WorkExcepArgPos);
  goto Exception_Common;
 Exception_Arg0:
  $USE(D_WorkExcepArgPos);
  b_SetImmTypeValueMRBoff(INT, _ZERO, D_WorkExcepArgPos);
  goto Exception_ArgCommon;
 Exception_Arg1:
  $USE(D_WorkExcepArgPos);
  b_SetImmTypeValueMRBoff(INT, _ONE, D_WorkExcepArgPos);
 Exception_ArgCommon:
  $USE(D_WorkExceptionCode);
  b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
 Exception_Common:
  $USE(D_WorkOpCode); 
  b_SetImmTypeValueMRBoff(INT, BLT_B_APPLY_TRACING, D_WorkOpCode);
  $CALL(f_Exception_3Arg_III_Sub(D_WorkExceptionCode,D_WorkOpCode,
				 D_WorkExcepArgPos,
				 I_PtrToCode,I_ArgVect,I_TraceId) );
  $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
  $RELEASE(D_WorkExcepArgPos);
 End_of_KL1B_Instruction:
  $RELEASE(D_WorkDerefPtr1);
}

/******************************************************************** PSL **
b_apply_spying A1, A2, A3, A4

       written by imai@icot22      on Thu Dec 13 18:45:54 1990

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |   b_apply_spying      |     A1    |     A2    |
    +-----------+-----------+-----------+-----------+
    |     A3    |     A4    |      Don't Care       |
    +-----------+-----------+-----------+-----------+

<Arguments>
 A1: $B%3!<%I$X$N%]%$%s%?(B
 A2: $B0z$-?t%Y%/%?(B
 A3: $B%9%Q%$%3!<%I%Y%/%?(B
 A4: $B%9%Q%$(B ID ($BG$0U$N%G!<%?%?%$%W(B)
<Temporally Used Variables>
<Level>
<PreCondition>
$B!&(BA1 $B$,%3!<%I0J30$J$iNc30!"L$Dj5A$J$i%5%9%Z%s%I(B
$B!&(BA2 $B$,%Y%/%?0J30$J$iNc30!"L$Dj5A$J$i%5%9%Z%s%I(B
$B!&(BA3 $B$,%Y%/%?0J30$J$iNc30!"L$Dj5A$J$i%5%9%Z%s%I(B
<Function>
 A1$B$G<($5$l$k%3!<%I$X$N%]%$%s%?$H(BA2$B$G<($5$l$k0z$-?t%Y%/%?$r;}$D%4!<%k(B
 $B%l%3!<%I$r:n@.$7$F!"%9%Q%$%b!<%I$G%(%s%-%e!<$9$k!#(B
 A3 $B$O!"%9%Q%$Nc30$rH/8+$9$k$?$a$KMQ$$$k%Y%/%?$G!"(B
  $B%Y%/%?$N%5%$%:$O#3$N@0?tG\!"(B
  $B%Y%/%?$NMWAG$O!"I,$:6qBN2=$7$F$$$J$1$l$P$J$i$J$$!#(B
 A4 $B$O!"%9%Q%$Nc30$r5/$3$7$?;~$KIUM?$9$k>pJs$G!"(B
 $B%G!<%?%?%$%W$O!"G$0U$G$"$k(B
<Examples> 
<Test> 
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define	I_PtrToCode	_IndirectRegField1
#OPF_define	I_ArgVect	_IndirectRegField2
#OPF_define	I_SpiedCodeVect	_IndirectRegField3
#OPF_define	I_SpyId		_IndirectRegField4

#PSL_define kblt_b_apply_spying()
{
  $USE(D_WorkDerefPtr1);

  @SPY{
    f_IfSpyMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp4ArgVect_IIII_Sub
	    (D_WorkArgVect,I_PtrToCode,I_ArgVect,I_SpiedCodeVect,I_SpyId));
      f_ReportSpyExceptionBuiltin( BLT_B_APPLY_SPYING, D_WorkArgVect );
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp4ArgVect_IIII_Sub
	    (D_WorkArgVect,I_PtrToCode,I_ArgVect,I_SpiedCodeVect,I_SpyId));
      f_TraceBodyBuiltin(BLT_B_APPLY_SPYING,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  f_ActiveDeref(I_PtrToCode,D_WorkDerefPtr1);
  s_IfCOD (I_PtrToCode) {
    f_ActiveDeref(I_ArgVect,D_WorkDerefPtr1);
    s_IfVectors(I_ArgVect) {
      i_IfSuccessArityCheckApply(I_PtrToCode,I_ArgVect) {
	f_ActiveDeref(I_SpiedCodeVect,D_WorkDerefPtr1);
	s_IfVectors(I_SpiedCodeVect) {
	  f_IfAcceptableSpiedCodeVect(I_SpiedCodeVect) {
	    $USE(D_WorkApplyGoal);
	    i_AllocApplyGoal(D_WorkApplyGoal, I_PtrToCode, I_ArgVect);     
	    f_AttachSpyingInfoGoalRecord
	      (D_WorkApplyGoal,I_SpyId,I_SpiedCodeVect);
	    f_PushGoalToStack (D_WorkApplyGoal);
	    s_IncrementForkCounter ();
	    $RELEASE(D_WorkApplyGoal);
	    goto End_of_KL1B_Instruction;
	  } else {
	    goto Exception_Arg2;
	  }
	} else {
	  s_IfUnbound(I_SpiedCodeVect) {
	    p_MoveWord(D_WorkDerefPtr1, I_SpiedCodeVect);
	    goto Suspend;
	  } else {
	    goto Exception_Arg2;
	  }
	}
      } else {
	goto Exception_Arity_Mismatch;
      }
    } else {
      s_IfUnbound(I_ArgVect) {
	p_MoveWord(D_WorkDerefPtr1, I_ArgVect);
	goto Suspend;
      } else {
	goto Exception_Arg1;
      }
    }
  } else {
    s_IfUnbound(I_PtrToCode) {
      p_MoveWord(D_WorkDerefPtr1, I_PtrToCode);
      goto Suspend;
    } else {
      goto Exception_Arg0;
    }
  }
 Suspend:
  f_DcodeEnqueue4Ope_IIII
      (BLT_B_APPLY_SPYING,I_PtrToCode,I_ArgVect,I_SpiedCodeVect,I_SpyId);
  goto End_of_KL1B_Instruction;
 Exception_Arity_Mismatch:
  $USE(D_WorkExceptionCode);
  b_SetImmTypeValueMRBoff(INT, _ARITY_MISMATCH_EXCP, D_WorkExceptionCode);
  $USE(D_WorkExcepArgPos);
  b_SetImmTypeValueMRBoff(INT, _ZERO, D_WorkExcepArgPos);
  goto Exception_Common;
 Exception_Arg0:
  $USE(D_WorkExcepArgPos);
  b_SetImmTypeValueMRBoff(INT, _ZERO, D_WorkExcepArgPos);
  goto Exception_ArgCommon;
 Exception_Arg1:
  $USE(D_WorkExcepArgPos);
  b_SetImmTypeValueMRBoff(INT, _ONE, D_WorkExcepArgPos);
  goto Exception_ArgCommon;
 Exception_Arg2:
  $USE(D_WorkExcepArgPos);
  b_SetImmTypeValueMRBoff(INT, _TWO, D_WorkExcepArgPos);
 Exception_ArgCommon:
  $USE(D_WorkExceptionCode);
  b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
 Exception_Common:
  $USE(D_WorkOpCode); 
  b_SetImmTypeValueMRBoff(INT, BLT_B_APPLY_SPYING, D_WorkOpCode);
  $CALL(f_Exception_4Arg_IIII_Sub(D_WorkExceptionCode,D_WorkOpCode,
	D_WorkExcepArgPos,I_PtrToCode,I_ArgVect,I_SpiedCodeVect,I_SpyId) );
  $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
  $RELEASE(D_WorkExcepArgPos);
 End_of_KL1B_Instruction:
  $RELEASE(D_WorkDerefPtr1);
}

/******************************************************************** PSL **
APPLY $B%4!<%k$N@8@.(B
       written by goto@icot22      on Thu Mar 16 20:22:27 1989
       revised by imai@icot22      on Mon Mar 19 19:43:58 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
<Revised Memo on "Mar 19">
  argv $B$,%m%s%0%Y%/%?$G$b$$$$$h$&$K2~NI$7$?!#(B
********************************************************************* PSL **/

#DATA_define D_WorkArgvArity	XXX
#DATA_define D_WorkArgvElem	XXX

#PSL_define i_AllocApplyGoal (ptr_to_gr, code_ptr, argv_ptr)
{
  $USE(D_WorkArgvArity); 
  s_GetSizeVectType (argv_ptr, D_WorkArgvArity);

  b_IfGreaterImm(D_WorkArgvArity,_MAX_ARGS_SHORT_GR) {
    @DEBUG{b_IfGreaterImm(D_WorkArgvArity,_MAX_ARGS_LONG_GR) {
      OUT_OF_SPEC("i_AllocApplyGoal","Too Many Arguments in argv_ptr");
    }};
    s_AllocLongGoalRecord(ptr_to_gr);
  } else {
    s_AllocShortGoalRecord (ptr_to_gr);
  }
  s_PutArityGoalRecord (ptr_to_gr, D_WorkArgvArity);
  s_PutProcessorIdGoalRecord (ptr_to_gr, D_PE_Number);
  s_PutFosterparentGoalRecord (ptr_to_gr, D_Current_FP_Ptr);
  s_PutCodeGoalRecord (ptr_to_gr, code_ptr);

  b_IfNotZero ( D_WorkArgvArity ) {
    LOOP () {
      b_DecrementReg (D_WorkArgvArity);
      $USE(D_WorkArgvElem);
      s_GetVectElementPosReg (argv_ptr, D_WorkArgvArity, D_WorkArgvElem);
      s_PutArgGoalRecord (ptr_to_gr, D_WorkArgvArity, D_WorkArgvElem);
      $RELEASE(D_WorkArgvElem);
      b_IfLessEqImm (D_WorkArgvArity, _ZERO) {break;}
    }
  }
  $RELEASE(D_WorkArgvArity); 
}

/******************************************************************** PSL **
  apply $B%4!<%k$N%"%j%F%#%A%'%C%/(B

       written by imai@icot22      on Fri Dec 14 11:34:18 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  ptr_to_code $B$G;X$5$l$k(B $B%3!<%I$,MW5a$7$F$$$k%"%j%F%#$H(B
  ptr_to_argv $B$G;X$7$F$$$k$Y$/B?%5%$%:$,Ey$7$$$+$I$&$+$N%F%9%H$r9T$J$&(B
<Examples>
<Test>
<Explanation>
  1. ptr_to_code $B$,;X$9%3!<%INN0h$K=q$+$l$?%"%j%F%#$r!"(BD_WorkArity
    $B$KFI$_9~$`!#(B
  2. ptr_to_argv $B$N%Y%/%?%5%$%:$r(B D_WorkVectSize $B$K@_Dj$9$k!#(B
  3. D_WorkArity $B$H(B D_WorkVectSize $B$NCM$rHf3S$9$k(B
<ETC>
********************************************************************* PSL **/

#CTRL_define i_IfSuccessArityCheckApply(ptr_to_code,ptr_to_argv)
{
  $USE(D_WorkArity);	$USE(D_WorkVectSize);
  s_GetPredArityFromCode(ptr_to_code,D_WorkArity);
  s_GetSizeVectType(ptr_to_argv,D_WorkVectSize);
  p_Compare(D_WorkArity,D_WorkVectSize);
  $RELEASE(D_WorkArity);	$RELEASE(D_WorkVectSize); 
  p_IfEQ()
}

/******************************************************************** PSL **
b_predicate_to_code A1,A2,A3,A4

       written by nakase@icot22      on Thu Mar 30 15:07:04 1989
       revised by nakase@icot22      on Thu Mar 30 18:20:19 1989
       revised by f-doumae@icot22      on Tue Feb 20 12:01:39 1990
       revised by ttakagi@icot22      on Tue Dec 11 17:21:16 1990

    +-----------+-----------+-----------+-----------+
    | b_predicate_to_code   |    A1     |    A2     |
    +-----------+-----------+-----------+-----------+
    |    A3     |    A4     |      don't care       | 
    +-----------+-----------+-----------+-----------+

<Arguments>
 A1: $B%b%8%e!<%k$X$N%]%$%s%?(B   
 A2: $B=R8lL>(B ( $B%"%H%`(B )
 A3: $B=R8l$N%"%j%F%#(B ( $B@0?t(B )
 A4: $B%3!<%I=PNO(B 
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
<Revised Memo on "Mar 30">
<Revised Memo on "Feb 20">
********************************************************************* PSL **/

#CONST_define _ArityMask 0xff000000
#CONST_define _PredMask  0x0000ffff

#OPF_define I_PtrToMod 		_IndirectRegField1
#OPF_define I_PredNameReg 	_IndirectRegField2
#OPF_define I_PredArityReg 	_IndirectRegField3
#OPF_define I_DstCodePtr 	_IndirectRegField4

#ADDR_define _PRED_TO_COD_PTR_TO_MOD_OFST 0
#ADDR_define _PRED_TO_COD_PRED_NAME_OFST  1
#ADDR_define _PRED_TO_COD_PRED_ARITY_OFST 2

#PSL_define kblt_b_predicate_to_code() 
{ 
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp4ArgVect_IIIO_Sub(D_WorkArgVect,
					I_PtrToMod,
					I_PredNameReg,
					I_PredArityReg,
					I_DstCodePtr));
      f_TraceBodyBuiltin(BLT_B_PREDICATE_TO_CODE,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  $USE(D_WorkDerefPtr);
  f_ActiveDeref(I_PtrToMod,D_WorkDerefPtr);
  s_IfNotMOD(I_PtrToMod) {
    s_IfUnbound(I_PtrToMod) {
      p_MoveWord(D_WorkDerefPtr, I_PtrToMod);
      goto Suspend;
    } else {
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff(INT, _ZERO, D_WorkExcepArgPos);
      goto Exception;
    }
  } /* End of s_IfNotMOD */
    /* I_PtrToMod must have MOD type */

  f_ActiveDeref(I_PredNameReg,D_WorkDerefPtr);
  s_IfNotATOM (I_PredNameReg) {
    s_IfUnbound(I_PredNameReg) {
      p_MoveWord(D_WorkDerefPtr, I_PredNameReg);
      goto Suspend;
    } else {
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff(INT, _ONE, D_WorkExcepArgPos);
      goto Exception;
    }
  } /* End of s_IfNotATOM */
    /* I_PredNameReg must have ATOM type */

  f_ActiveDeref(I_PredArityReg,D_WorkDerefPtr);
  s_IfNotINT (I_PredArityReg) {
    s_IfUnbound (I_PredArityReg) {
      p_MoveWord(D_WorkDerefPtr, I_PredArityReg);
      goto Suspend;
    } else {
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff(INT, _TWO, D_WorkExcepArgPos);
      goto Exception;
    }
    /* I_PredArityReg must have INT type */
  }

  $RELEASE(D_WorkDerefPtr);
  /*--------------------------------------------------------------------------
   * $BF~NO0z?t(B (I_PtrToMod, I_PredNameReg, I_PredArityReg ) $B$N6qBN2=$,3NG'$5$l$?(B
   *-------------------------------------------------------------------------*/
  s_GetPredAddressOnName(I_PtrToMod,I_PredNameReg,I_PredArityReg,I_DstCodePtr);

  b_IfZero(I_DstCodePtr) {
      @DEBUG{ WARNING("kblt_b_predicate_to_code","code cannot get");}; 

      /* $B$3$3$KE~Ce$7$?$H$$$&$3$H$O!"(Bpredicate_to_code$B$N=R8lL>$H$7$F(B
	 $B;XDj$5$l$F$$$k(Batom $B$,$J$$!"Kt$O%Q%V%j%C%/@k8@$5$l$F$J$+$C$?(B
	 $B$3$H$G$"$k$N$G!"(B{I_PtrToMod, I_PredNameReg, I_PredArityReg}
	 $B$r=PNO$H$7$FJV$9!#(B */
      s_AllocVect3(I_DstCodePtr);
      s_PutVectElementImmOfst(I_DstCodePtr,
			      _PRED_TO_COD_PTR_TO_MOD_OFST,
			      I_PtrToMod);
      s_PutVectElementImmOfst(I_DstCodePtr,
			      _PRED_TO_COD_PRED_NAME_OFST,
			      I_PredNameReg);
      s_PutVectElementImmOfst(I_DstCodePtr,
			      _PRED_TO_COD_PRED_ARITY_OFST,
			      I_PredArityReg);
  } /* End of else for b_IfNotZero */
  goto End_of_KL1B_Instruction;

 Suspend: /* ----- $B%5%9%Z%s%I$9$k=hM}(B ------ */
  $RELEASE(D_WorkDerefPtr);
  f_DcodeEnqueue4Ope_IIIO(BLT_B_PREDICATE_TO_CODE, I_PtrToMod,
			  I_PredNameReg, I_PredArityReg, I_DstCodePtr);
  goto End_of_KL1B_Instruction;
 Exception: /* ----- $BNc30Js9p=hM}(B ------ */
  $RELEASE(D_WorkDerefPtr);
  $USE(D_WorkOpCode);$USE(D_WorkExceptionCode);
  b_SetImmTypeValueMRBoff(INT, BLT_B_PREDICATE_TO_CODE, D_WorkOpCode);
  b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
  $CALL(f_Exception_4Arg_IIIO_Sub
	(D_WorkExceptionCode,D_WorkOpCode,D_WorkExcepArgPos,I_PtrToMod,
	 I_PredNameReg, I_PredArityReg, I_DstCodePtr) );
  $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
  $RELEASE(D_WorkExcepArgPos);
 End_of_KL1B_Instruction:;
}

/******************************************************************** PSL **
b_code_to_predicate A1 A2 A3 A4 A5

       written by nakase@icot22      on Tue Oct  9 19:47:24 1990

    +-----------+-----------+-----------+-----------+
    | b_predicate_to_code   |    A1     |    A2     |
    +-----------+-----------+-----------+-----------+
    |    A3     |    A4     |    A5     |don't care |
    +-----------+-----------+-----------+-----------+

 A1: $B%3!<%I$X$N%]%$%s%?(B
 A2: $B%b%8%e!<%k$X$N%]%$%s%?!J=PNO!K(B
 A3: $B=R8lL>%"%H%`!J=PNO!K(B
 A4: $B0z?t8D?t!J=PNO!K(B
 A5: Info$B!J=PNO!K(B

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkPredData XXX

#OPF_define I_PtrToCod 		_IndirectRegField1
#OPF_define I_PtrToMod   	_IndirectRegField2
#OPF_define I_AtomName   	_IndirectRegField3
#OPF_define I_PredArity 	_IndirectRegField4
#OPF_define I_Info      	_IndirectRegField5

#PSL_define kblt_b_code_to_predicate()
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp5ArgVect_IOOOO_Sub(D_WorkArgVect,
					 I_PtrToCod,
					 I_PtrToMod,
					 I_AtomName,
					 I_PredArity,
					 I_Info));
      f_TraceBodyBuiltin(BLT_B_CODE_TO_PREDICATE,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };
  $USE(D_WorkDerefPtr);
  f_ActiveDeref(I_PtrToCod, D_WorkDerefPtr);
  s_IfCOD(I_PtrToCod){
    s_GetModuleTopFromCode(I_PtrToCod, I_PtrToMod);

    s_GetPredNameFromCode(I_PtrToCod, I_AtomName);
    b_SetImmTypeMRBoff(ATOM, I_AtomName);          /* $BG0$N$?$a(B */

    s_GetPredArityFromCode(I_PtrToCod, I_PredArity);
    b_SetImmTypeMRBoff(INT, I_PredArity);          /* $BG0$N$?$a(B */

    s_GetSoftInfoFromCode(I_PtrToCod, I_Info);
  } else {
    s_IfUnbound(I_PtrToCod){
      p_MoveWord(D_WorkDerefPtr, I_PtrToCod);
      f_DcodeEnqueue5Ope_IOOOO(BLT_B_CODE_TO_PREDICATE,
				I_PtrToCod, I_PtrToMod, I_AtomName,
				I_PredArity, I_Info);
    } else {
      $USE(D_WorkOpCode);$USE(D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff(INT, BLT_B_CODE_TO_PREDICATE, D_WorkOpCode);
      b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff(INT, _ZERO, D_WorkExcepArgPos);
      $CALL(f_Exception_5Arg_IOOOO_Sub(D_WorkExceptionCode,D_WorkOpCode,
		D_WorkExcepArgPos, I_PtrToCod, I_PtrToMod, I_AtomName,
				       I_PredArity, I_Info) );
      $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
      $RELEASE(D_WorkExcepArgPos);
    }
  }

  $RELEASE(D_WorkDerefPtr);
 End_of_KL1B_Instruction:;
}

/******************************************************************** PSL **
b_module_offset_to_code A1,A2,A3

       written by nakagosh@icot21      on Thu May 18 14:48:27 1989
       revised by imai@icot22      on Fri Feb  1 15:26:27 1991
    +-----------+-----------+-----------+-----------+
    |b_module_offset_to_code|    A1     |    A2     |
    +-----------+-----------+-----------+-----------+
    |    A3     |             don't care            | 
    +-----------+-----------+-----------+-----------+

<Arguments>
 A1: $B%b%8%e!<%k$X$N%]%$%s%?(B   
 A2: $B=R8l%3!<%I$N%b%8%e!<%k$N@hF,$+$i$N%*%U%;%C%H(B ( $B@0?t(B )
 A3: $B%3!<%I=PNO(B 
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
<Revised Memo on "Feb  1">
  $B=>Mh;EMM$O!"(Bmodule+offset --> COD $B$H$7$F$$$?$,!"(Bmodule+offset $B$,!"(B
  COD $B%?%0$G;X$;$J$$%"%I%l%9$K$J$k>l9g!"$=$N=R8l$N@hF,%"%I%l%9$rC5$7$F(B
  (VECT0$B$rC5$9(B) $B$D$1JQ$($k$h$&$K$7$?!#$9$J$o$A!"%"%I%l%9$NCM$O(B
  $BI,$:$7$b!"(B (I_PtrToMod + I_CodeOffset) = (DstCodePtr) $B$G$O$J$$!#(B
********************************************************************* PSL **/

#OPF_define I_PtrToMod 		_IndirectRegField1
#OPF_define I_CodOffset 	_IndirectRegField2
#OPF_define I_DstCodePtr 	_IndirectRegField3

#PSL_define kblt_b_module_offset_to_code() 
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp3ArgVect_IIO_Sub(D_WorkArgVect,
				       I_PtrToMod,I_CodOffset,I_DstCodePtr));
      f_TraceBodyBuiltin(BLT_B_MODULE_OFFSET_TO_CODE,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  $USE(D_WorkDerefPtr);
  f_ActiveDeref(I_PtrToMod,D_WorkDerefPtr);
  s_IfNotMOD(I_PtrToMod) {
    s_IfUnbound (I_PtrToMod) {
      p_MoveWord(D_WorkDerefPtr, I_PtrToMod);
      goto Suspend;
    } else {
      $USE(D_WorkExceptionCode);      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff(INT, _ZERO, D_WorkExcepArgPos);
      goto Exception;
    }
  }

  f_ActiveDeref(I_CodOffset,D_WorkDerefPtr);
  s_IfNotINT (I_CodOffset) {
    s_IfUnbound(I_CodOffset) {
      p_MoveWord(D_WorkDerefPtr, I_CodOffset);
      goto Suspend;
    } else {
      $USE(D_WorkExceptionCode);      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff(INT, _ONE, D_WorkExcepArgPos);
      goto Exception;
    }
  }

  $USE(D_WorkCodePtr); $USE(D_WorkResult);
  s_GetCodeFromModuleOffset(I_PtrToMod,I_CodOffset,D_WorkCodePtr,D_WorkResult);
  b_IfEqual(D_WorkResult, D_NULL) {
    $RELEASE(D_WorkDerefPtr);
    $RELEASE(D_WorkResult);
    p_MoveWord(D_WorkCodePtr,I_DstCodePtr);
    $RELEASE(D_WorkCodePtr);
    goto End_of_KL1B_Instruction;
  } else {
    $RELEASE(D_WorkResult);$RELEASE(D_WorkCodePtr);
    $USE(D_WorkExceptionCode); $USE(D_WorkExcepArgPos);
    b_SetImmTypeValueMRBoff(INT, _OUT_OF_BOUNDS_EXCP, D_WorkExceptionCode);
    b_SetImmTypeValueMRBoff(INT, _ONE, D_WorkExcepArgPos);
    goto Exception;
  }
 Suspend:
  $RELEASE(D_WorkDerefPtr);
  f_DcodeEnqueue3Ope_IIO(BLT_B_MODULE_OFFSET_TO_CODE, I_PtrToMod,
			 I_CodOffset,I_DstCodePtr);
  goto End_of_KL1B_Instruction;
 Exception:
  $RELEASE(D_WorkDerefPtr);
  $USE(D_WorkOpCode);
  b_SetImmTypeValueMRBoff(INT, BLT_B_MODULE_OFFSET_TO_CODE, D_WorkOpCode);
  $CALL( f_Exception_3Arg_IIO_Sub (D_WorkExceptionCode,D_WorkOpCode,
				   D_WorkExcepArgPos,
				   I_PtrToMod, I_CodOffset, I_DstCodePtr));
  $RELEASE(D_WorkExcepArgPos);$RELEASE(D_WorkExceptionCode);
  $RELEASE(D_WorkOpCode);
 End_of_KL1B_Instruction:;
}

/******************************************************************** PSL **
  module_element  A1, A2, A3, A4
       written by imai@icot22      on Wed Jan  9 16:45:23 1991

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |    b_module_element   |     A1    |     A2    |
    +-----------+-----------+-----------+-----------+
    |    A3     |    A4	    |      Don't Care	    |
    +-----------+-----------+-----------+-----------+
<Arguments>
  A1 : $BF~NO(B	$B%b%8%e!<%k$X$N%]%$%s%?(B (MOD)
  A2 : $BF~NO(B	$B%b%8%e!<%kFbMWAG0LCV(B (INT)
  A3 : $B=PNO(B	$B<h$j=P$7$?MWAG(B
  A4 : $B=PNO(B	$B%b%8%e!<%k$X$N%]%$%s%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
  $B!&F~NO$H=PNO$N%l%8%9%?$O!"=EJ#$7$J$$!#(B
<Function>
  $B!&(BA1$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I%4!<%k$r%(%s%-%e!<$7!"<!L?Na$r<B9T!#(B
    $B!&%b%8%e!<%k0J30$K6qBN2=$5$l$F$$$?$i!"Nc30=hM}!#(B
  $B!&(BA2$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I%4!<%k$r%(%s%-%e!<$7!"<!L?Na$r<B9T!#(B
    $B!&HsIi@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30=hM}!#(B
   $B%b%8%e!<%kFb$N(B A2 $BHVL\$NMWAG(B
	$B%o!<%I%"%I%l%C%7%s%0%^%7%s$G$O(B *(A1+A2)$B!"(B
	$B%P%$%H%"%I%l%C%7%s%0%^%7%s$G$O(B *(A1+8*A2)$B!"(B
   $B$r<h$j=P$7!"(BA3$B$H%f%K%U%!%$!#(B
   A1 $B$H(B A4 $B$r%f%K%U%!%$!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_SrcModule		_IndirectRegField1
#OPF_define I_SrcPosition	_IndirectRegField2
#OPF_define I_DstElement	_IndirectRegField3
#OPF_define I_DstModule		_IndirectRegField4

#PSL_define kblt_b_module_element ()
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp4ArgVect_IIOO_Sub
	    (D_WorkArgVect,
	     I_SrcModule,I_SrcPosition,I_DstElement,I_DstModule));
      f_TraceBodyBuiltin(BLT_B_MODULE_ELEMENT,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };
  $USE(D_WorkDerefPtr1);
  f_ActiveDeref(I_SrcModule, D_WorkDerefPtr1);
  s_IfMOD(I_SrcModule) {
    f_ActiveDeref(I_SrcPosition, D_WorkDerefPtr1);
    s_IfINT(I_SrcPosition) {
      b_IfLess (I_SrcPosition, D_NULL) {
	      /* $B;XDj$5$l$?MWAGHV9f$,Ii?t$J$iNc30(B */
	$USE (D_WorkExceptionCode);
	$USE (D_WorkExcepArgPos);
	b_SetImmTypeValueMRBoff(INT, _OUT_OF_BOUNDS_EXCP, D_WorkExceptionCode);
	b_SetImmTypeValueMRBoff(INT, _ONE, D_WorkExcepArgPos);
	goto Exception;
      }
      $USE(D_WorkSize);
      s_GetModuleSize(I_SrcModule,D_WorkSize);
      b_IfGreaterEq(I_SrcPosition,D_WorkSize) {
	      /* $B;XDj$5$l$?MWAGHV9f$,%b%8%e!<%k%5%$%:$h$jBg$-$$$J$iNc30(B */
	$RELEASE(D_WorkSize);
	$USE (D_WorkExceptionCode);
	$USE(D_WorkExcepArgPos);
	b_SetImmTypeValueMRBoff(INT, _OUT_OF_BOUNDS_EXCP,D_WorkExceptionCode);
	b_SetImmTypeValueMRBoff(INT, _ONE, D_WorkExcepArgPos);
	goto Exception;
      } 
      $RELEASE(D_WorkSize);
	     /* $B%b%8%e!<%k%5%$%:Fb$N%]%8%7%g%s$,;XDj$5$l$?$3$H$r3NG'$7$?(B */
      $USE(D_WorkElemAddr);
      s_GetStructElemAddrPosReg (I_SrcModule, I_SrcPosition, D_WorkElemAddr );
      p_Read(D_WorkElemAddr, I_DstElement );
      $RELEASE(D_WorkElemAddr);
      p_MoveWord(I_SrcModule,I_DstModule);
	     /* $B%b%8%e!<%k%5%$%:Fb$N%]%8%7%g%s$rFI$_=*$($?(B(OK) */
      goto End;
    }
    s_IfUnbound(I_SrcPosition) {
      /* I_SrcPosition $B$,6qBN2=$5$l$F$J$$(B */
      p_MoveWord(D_WorkDerefPtr1, I_SrcPosition);
      goto Suspend;
    } else {
      /* I_SrcPosition $B$,@0?t$G$J$$(B */
      $USE (D_WorkExceptionCode);
      $USE (D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _ONE, D_WorkExcepArgPos);
      goto Exception;
    }
  }
  s_IfUnbound(I_SrcModule) {
    /* I_SrcModule $B$,6qBN2=$5$l$F$J$$(B */
    p_MoveWord(D_WorkDerefPtr1, I_SrcModule);
    goto Suspend;
  } else {
    /* I_SrcModule $B$,%b%8%e!<%k$G$J$$(B */
    $USE (D_WorkExceptionCode);
    $USE(D_WorkExcepArgPos);
    b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
    b_SetImmTypeValueMRBoff (INT, _ZERO, D_WorkExcepArgPos);
    goto Exception;
  }
 Exception:
  $USE(D_WorkOpCode); 
  b_SetImmTypeValueMRBoff(INT, BLT_B_MODULE_ELEMENT, D_WorkOpCode);
  $CALL(f_Exception_4Arg_IIOO_Sub(D_WorkExceptionCode,D_WorkOpCode,
				  D_WorkExcepArgPos,
				  I_SrcModule,I_SrcPosition,
				  I_DstElement,I_DstModule));
  $RELEASE (D_WorkOpCode);
  $RELEASE (D_WorkExceptionCode);
  $RELEASE(D_WorkExcepArgPos);
  goto End;
 Suspend:
  f_DcodeEnqueue4Ope_IIOO
    (BLT_B_MODULE_ELEMENT,I_SrcModule,I_SrcPosition,I_DstElement,I_DstModule);
 End:
  $RELEASE(D_WorkDerefPtr1);
 End_of_KL1B_Instruction:;
}

/******************************************************************** PSL **
b_merge A1, A2
       written by nakase@icot22      on Wed Feb 22 10:45:33 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |        b_merge        |     A1    |     A2    |
    +-----------+-----------+-----------+-----------+

<Arguments>

 A1: $B%^!<%8%c$NF~NO%9%H%j!<%`(B
 A2: $B%^!<%8%c$N=PNO%9%H%j!<%`(B

<Temporally Used Variables>
<Level>
<PreCondition>
 $B0J2<$NNc$K<($9$h$&$K(B, A1,A2 $B$OL$Dj$N$^$^$3$N%k!<%A%s$,8F$P$l$k!#(B
 $B<B:]$N%^!<%8%c$NF~NO%9%H%j!<%`(B, $B=PNO%9%H%j!<%`$r7R$2$k:n6H$O(B, $BB3$/(B
 unify$BL?Na$K$h$j9T$o$l$k!#(B
<Function> 

<Examples> [KL1]
mer(In,Out):-true|merge(In,Out).

[KL1/B]
predicate(mer/2,{5}).
    commit.
    load(r0(0),r1).
    load(r0(1),r2).
    collect_goal(2,r0).
    b_merge(r3,r4).
    unify(r1,r3).
    unify(r2,r4).
    proceed.

<Test>
<Explanation>

$B0J2<$N9=B$$r:n@.$9$k(B
                                +-----+                                     
                                | A2 -+-------+
                                +-----+       |
                                              | 
+-----+       +---------+       +---------+   +--->+--------+
| A1 -+------>|MGHOK   -+------>|REF     -+------->|UNBOUND |
+-----+       +---------+       +---------+        +--------+
                                |INT    1 |
                                +---------+
                                |FPREC   -+----->      
                                +---------+ 

<ETC>
	$B%^!<%8%c$O!"2>A[%W%m%;%9$G$"$k$?$a!"(BForkCounter (Children Count)
	$B$r%$%s%/%j%a%s%H$9$kI,MW$,$"$k!#(B

  $B%^!<%8%c%W%m%;%9$O!":n$C$?%W%m%;%C%5$,=*N;$5$;$k!J:G8e$NF~NO(B
  $B%9%H%j!<%`$rJD$8$k!K$H$O8B$i$J$$!#$3$N$?$a!"%U%)!<%/%+%&%s%?(B
  $B$rA}$d$7$?;~E@$G@5$G$"$l$P!"N$?F%l%3!<%I$K=q$-La$9I,MW$,$"$k!#(B
  $B$9$J$o$A$3$l$O!"F~NO%9%H%j!<%`$r8x3+$7$?;~E@$G!"%/%i%9%?Fb$N(B
  $BG$0U$N%W%m%;%C%5$K%^!<%8%c%W%m%;%9%4!<%k$,Ej$2$i$l$?$b$N$H9M(B
  $B$($F$N=hM}$G$"$k!#(B
	(see. f_throw_goal_in_cluster.psl.c)
********************************************************************* PSL **/

#OPF_define I_InputStream _IndirectRegField1
#OPF_define I_OutputStream _IndirectRegField2

#DATA_define D_WorkMerger    XXX

#CONST_define _INITIAL_REF_COUNT 1

#PSL_define kblt_b_merge() 
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp2ArgVect_OO_Sub
	    (D_WorkArgVect,I_InputStream,I_OutputStream));
      f_TraceBodyBuiltin(BLT_B_MERGE,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  $USE(D_WorkMerger);
  $USE(D_WorkRefCnt);

  s_AllocMergerCell(D_WorkMerger);
  s_AllocMghok(D_WorkMerger,I_InputStream);
  s_AllocVariable(I_OutputStream);

  s_PutMergerOutStream(D_WorkMerger,I_OutputStream);
  b_SetImmTypeValueMRBoff(INT,_INITIAL_REF_COUNT,D_WorkRefCnt);
  s_PutMergerRefCount(D_WorkMerger,D_WorkRefCnt);
  s_PutMergerFPPtr(D_WorkMerger,D_Current_FP_Ptr);
  $USE(D_WorkModule);	$USE(D_WorkOfst);
	/* D_KLB_PC $B$+$i(B Module $B$H(B Offset $B$r$H$C$F$/$k(B */
  s_GetModuleTopAndOffsetFromPC(D_KLB_PC, D_WorkModule, D_WorkOfst);
  s_PutMergerModulePtr(D_WorkMerger,D_WorkModule);
  s_PutMergerOffsetInModule(D_WorkMerger,D_WorkOfst);
  $RELEASE(D_WorkOfst);	$RELEASE(D_WorkModule);

	/* $B%W%m%;%C%5(B $B#I#D!"%W%i%$%*%j%F%#!"B0@-$r=q$-9~$`(B */
  $USE(D_WorkPriority);
  $USE(D_WorkAttribute);
  s_GetPriorityEnvRecord(D_CurrentEnvRecPtr,D_WorkPriority);
  s_GetAttributeEnvRecord(D_CurrentEnvRecPtr,D_WorkAttribute);
  s_PutMergerProcessorId(D_WorkMerger,D_PE_Number);
  s_PutMergerPriority(D_WorkMerger,D_WorkPriority);
  s_PutMergerAttribute(D_WorkMerger,D_WorkAttribute);
  $RELEASE(D_WorkPriority);
  $RELEASE(D_WorkAttribute);

  s_IncrementForkCounter();
  s_IfForkCounterGTZero () {
    /*------- $B%U%)!<%/%+%&%s%?$N=q$-La$7=hM}(B --------*/
    $USE(D_WorkFPOrgLockTagReg);
    s_LockFPRecord(D_Current_FP_Ptr,D_WorkFPOrgLockTagReg);
    s_UpdateFPChildCount(D_Current_FP_Ptr);
    s_UnlockFPRecord(D_Current_FP_Ptr,D_WorkFPOrgLockTagReg);
    $RELEASE(D_WorkFPOrgLockTagReg);
    s_SetZeroForkCounter ();
  }
  $RELEASE(D_WorkMerger);
  $RELEASE(D_WorkRefCnt);
 End_of_KL1B_Instruction:;
}

/******************************************************************** PSL **
$BO@M}%W%i%$%*%j%F%#$N49;;MQAH$_9~$_=R8l(B ($B3d9g;XDj(B)

       written by goto@icot22      on Wed Sep  6 10:04:52 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |b_calculate_priority   |           |           |
    |        _from_minimum  |   Reg1    |    Reg2   |
    +-----------+-----------+-----------+-----------+
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B!&3d9g;XDj$NO@M}%W%i%$%*%j%F%#(B(Reg1)$B$rJ*M}%W%i%$%*%j%F%#(B(Reg2) $B$KJQ49$9$k(B
<Examples>
  foo :- true | bar@priority(*,100).
<Test>
<Explanation>
  $B3d9g;XDj(B: 0 =< $B3d9g(B =< 4096
  	$B2<8BCM(B + ($B>e8BCM(B - $B2<8BCM(B) X $B3d9g(B / 4096 

<ETC>
********************************************************************* PSL **/

#CONST_define _PRIO_SHIFT_AMOUNT	  12
#CONST_define _MAX_PRIO_RATIO	 	4096
#CONST_define _MIN_PRIO_RATIO     	   0

#OPF_define I_RegSrcPrio	_IndirectRegField1
#OPF_define I_RegDstPrio	_IndirectRegField2

#PSL_define kblt_b_calculate_priority_from_minimum()
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp2ArgVect_IO_Sub
	    (D_WorkArgVect,I_RegSrcPrio, I_RegDstPrio));
      f_TraceBodyBuiltin(BLT_B_CALC_PRIO_FROM_MINIMUM,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  $USE(D_WorkDerefPtr);
  f_ActiveDeref(I_RegSrcPrio, D_WorkDerefPtr);
  s_IfNotINT(I_RegSrcPrio) {
    s_IfUnbound(I_RegSrcPrio) {
      p_MoveWord(D_WorkDerefPtr,I_RegSrcPrio);
      $RELEASE(D_WorkDerefPtr);
      f_DcodeEnqueue2Ope_IO(BLT_B_CALC_PRIO_FROM_MINIMUM,
				 I_RegSrcPrio, I_RegDstPrio);
      goto End_of_KL1B_Instruction;
    } else {
      $RELEASE(D_WorkDerefPtr);
      $USE(D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      goto Exception;
    }
  }
  $RELEASE(D_WorkDerefPtr);

  b_IfGreaterImm(I_RegSrcPrio,_MAX_PRIO_RATIO) {
    $USE (D_WorkExceptionCode);
    b_SetImmTypeValueMRBoff(INT, _RANGE_OVERFLOW_EXCP,D_WorkExceptionCode);
    goto Exception;
  }
  b_IfLessImm(I_RegSrcPrio,_MIN_PRIO_RATIO) {
    $USE (D_WorkExceptionCode);
    b_SetImmTypeValueMRBoff(INT, _RANGE_OVERFLOW_EXCP,D_WorkExceptionCode);
    goto Exception;
  }
  $USE(D_WorkHigh);
  $USE(D_WorkLow);
  s_GetFPMaxPriority(D_Current_FP_Ptr, D_WorkHigh);
  s_GetFPMinPriority(D_Current_FP_Ptr, D_WorkLow);
  $USE(D_WorkPriority);
  b_SubtractWithDNTC(D_WorkHigh, D_WorkLow, D_WorkPriority);
  $RELEASE(D_WorkHigh);
  b_ShiftRightImmediateWithDNTC(D_WorkPriority, _PRIO_SHIFT_AMOUNT, 
				D_WorkPriority);
  b_MultiplyWithTag(I_RegSrcPrio, D_WorkPriority, D_WorkPriority);
		/*--- $B>e$N>h;;$G!"(BD_WorkPriority $B$K(B INT $B$,@_Dj$5$l$k(B --*/
  b_AddWithTag (D_WorkPriority, D_WorkLow, I_RegDstPrio);
		/*--- $B>e$N2C;;$G!"(BI_RegDstPrio $B$K(B INT $B$,@_Dj$5$l$k(B --*/
  $RELEASE(D_WorkLow);
  $RELEASE(D_WorkPriority);
  goto End_of_KL1B_Instruction;

 Exception:
  $USE(D_WorkOpCode);$USE(D_WorkExcepArgPos);
  b_SetImmTypeValueMRBoff(INT, BLT_B_CALC_PRIO_FROM_MINIMUM, D_WorkOpCode);
  b_SetImmTypeValueMRBoff(INT, _ZERO, D_WorkExcepArgPos);
  $CALL(f_Exception_2Arg_IO_Sub(D_WorkExceptionCode,D_WorkOpCode,
				D_WorkExcepArgPos,I_RegSrcPrio,I_RegDstPrio));
  $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
  $RELEASE(D_WorkExcepArgPos);

 End_of_KL1B_Instruction:;
}
/******************************************************************** PSL **
$BO@M}%W%i%$%*%j%F%#$N49;;MQAH$_9~$_=R8l(B ($BAjBP;XDj(B)

       written by goto@icot22      on Wed Sep  6 10:04:52 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |b_calculate_priority   |           |           |
    |        _from_current  |   Reg1    |    Reg2   |
    +-----------+-----------+-----------+-----------+
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B!&AjBP;XDj$NO@M}%W%i%$%*%j%F%#(B(Reg1)$B$rJ*M}%W%i%$%*%j%F%#(B(Reg2) $B$KJQ49$9$k(B
<Examples>
  foo :- true | bar@priority($,100).
<Test>
<Explanation>
  $BAjBP;XDj(B: 
  	0 =< $BAjBP3d9g(B =< 4096
		Cp + ($B>e8BCM(B - Cp) X |$BAjBP3d9g(B|/4096
  	-4096 =< $BAjBP3d9g(B < 0
		Cp - (Cp - $B2<8BCM(B) X |$BAjBP3d9g(B|/4096
	      =	Cp - ($B2<8BCM(B - Cp) X  $BAjBP3d9g(B /4096
<ETC>
********************************************************************* PSL **/

#CONST_define _MAX_RELATIVE_PRIO	4096
#CONST_define _MIN_RELATIVE_PRIO       -4096

#OPF_define I_RegSrcPrio	_IndirectRegField1
#OPF_define I_RegDstPrio	_IndirectRegField2

#PSL_define kblt_b_calculate_priority_from_current()
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp2ArgVect_IO_Sub
	    (D_WorkArgVect,I_RegSrcPrio, I_RegDstPrio));
      f_TraceBodyBuiltin(BLT_B_CALC_PRIO_FROM_CURRENT,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  $USE(D_WorkDerefPtr);
  f_ActiveDeref(I_RegSrcPrio, D_WorkDerefPtr);
  s_IfNotINT(I_RegSrcPrio) {
    s_IfUnbound(I_RegSrcPrio) {
      p_MoveWord(D_WorkDerefPtr,I_RegSrcPrio);
      $RELEASE(D_WorkDerefPtr);
      f_DcodeEnqueue2Ope_IO(BLT_B_CALC_PRIO_FROM_CURRENT,
			    I_RegSrcPrio, I_RegDstPrio);
      goto End_of_KL1B_Instruction;
    } else {
      $RELEASE(D_WorkDerefPtr);
      $USE(D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff(INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      goto Exception;
    }
  }
  $RELEASE(D_WorkDerefPtr);

  b_IfGreaterImm(I_RegSrcPrio, _MAX_RELATIVE_PRIO) {
    $USE(D_WorkExceptionCode);
    b_SetImmTypeValueMRBoff(INT, _RANGE_OVERFLOW_EXCP, D_WorkExceptionCode);
    goto Exception;
  }
  b_IfLessImm(I_RegSrcPrio, _MIN_RELATIVE_PRIO) {
    $USE(D_WorkExceptionCode);
    b_SetImmTypeValueMRBoff(INT, _RANGE_OVERFLOW_EXCP, D_WorkExceptionCode);
    goto Exception;
  }

  $USE(D_WorkPriority);
  $USE(D_WorkCurrentPriority);
  s_GetPriorityEnvRecord(D_CurrentEnvRecPtr,D_WorkCurrentPriority);

  b_IfGreaterEqImm(I_RegSrcPrio, _ZERO) {
    /*
     * WP := Highest - Current
     * DstPrio := (WP * Source_Priority) >> 12 + Current
     */
    s_GetFPMaxPriority(D_Current_FP_Ptr, D_WorkPriority);
    b_SubtractWithDNTC(D_WorkPriority, D_WorkCurrentPriority, D_WorkPriority);
  } else {
    /*
     * WP := Lowest - Current
     * DstPrio := Current - (WP * Source_Priority) >> 12
     */
    s_GetFPMinPriority(D_Current_FP_Ptr, D_WorkPriority);
    b_SubtractWithDNTC(D_WorkCurrentPriority, D_WorkPriority , D_WorkPriority);
  }
  b_AddWithDNTC (D_WorkPriority, D_WorkCurrentPriority, I_RegDstPrio);
  b_ShiftRightImmediateWithDNTC(D_WorkPriority, _PRIO_SHIFT_AMOUNT, 
				D_WorkPriority);

  b_MultiplyWithTag(I_RegSrcPrio, D_WorkPriority, D_WorkPriority);
  /* now type of D_WorkPriority is INT */
  b_AddWithTag (D_WorkPriority, D_WorkCurrentPriority, I_RegDstPrio);
  /* now type of I_RegDstPrio is INT */

  $RELEASE(D_WorkCurrentPriority);
  $RELEASE(D_WorkPriority);
  goto End_of_KL1B_Instruction;

 Exception:
  $USE(D_WorkOpCode);$USE(D_WorkExcepArgPos);
  b_SetImmTypeValueMRBoff(INT, BLT_B_CALC_PRIO_FROM_CURRENT, D_WorkOpCode);
  b_SetImmTypeValueMRBoff(INT, _ZERO, D_WorkExcepArgPos);
  $CALL(f_Exception_2Arg_IO_Sub(D_WorkExceptionCode,D_WorkOpCode,
				D_WorkExcepArgPos,I_RegSrcPrio,I_RegDstPrio));
  $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
  $RELEASE(D_WorkExcepArgPos);

 End_of_KL1B_Instruction:;
}

/******************************************************************** PSL **

$BO@M}%W%i%$%*%j%F%#$N49;;MQAH$_9~$_=R8l(B ($BAjBP;XDj(B)

       written by imai@icot22      on Thu Feb  7 17:27:48 1991

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |b_current_priority     |    A1     |    A2     |
    +-----------+-----------+-----------+-----------+
    |     A3    |           don't care              |
    +-----------+-----------+-----------+-----------+

<Arguments>
  I_RegDstPrio : $B8=:_$N!JO@M}!K%W%i%$%*%j%F%#$rJV$9%l%8%9%?!#(B
<Temporally Used Variables>
<Level>
  interpreter
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_RegCurrentPrio  _IndirectRegField1
#OPF_define I_RegShoenMinPrio _IndirectRegField2
#OPF_define I_RegShoenMaxPrio _IndirectRegField3

#PSL_define  kblt_b_current_priority()
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp3ArgVect_OOO_Sub(D_WorkArgVect, 
				       I_RegCurrentPrio,
				       I_RegShoenMinPrio,
				       I_RegShoenMaxPrio));
      f_TraceBodyBuiltin(BLT_B_CURRENT_PRIORITY,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };
  s_GetPriorityEnvRecord(D_CurrentEnvRecPtr,I_RegCurrentPrio);
  p_SetImmediateType(INT,I_RegCurrentPrio);
  s_GetFPMinPriority(D_Current_FP_Ptr,I_RegShoenMinPrio);
  p_SetImmediateType(INT,I_RegShoenMinPrio);
  s_GetFPMaxPriority(D_Current_FP_Ptr,I_RegShoenMaxPrio);
  p_SetImmediateType(INT,I_RegShoenMaxPrio);
 End_of_KL1B_Instruction:;
}

/******************************************************************** PSL **
 kblt_b_current_cluster A1 A2

       written by nakase@icot22      on Tue Feb 13 19:32:37 1990

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |b_vpim_current_cluster |     A1    |     A2    | 
    |                       |           |           |
    +-----------+-----------+-----------+-----------+

<Arguments>
 A1: $B8=:_$N%/%i%9%?HV9f(B
 A2: $B$=$N%7%9%F%`$N;}$DA4%/%i%9%??t(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_ClusterNum _IndirectRegField1
#OPF_define I_TotalCLNum _IndirectRegField2

#PSL_define kblt_b_current_cluster()
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp2ArgVect_OO_Sub
	    (D_WorkArgVect,I_ClusterNum,I_TotalCLNum));
      f_TraceBodyBuiltin(BLT_B_CURRENT_CLUSTER,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };
  p_MoveWord(D_CL_Number, I_ClusterNum);
  p_SetImmediateType(INT,I_ClusterNum);
  b_ReadClusterNumInSystem(I_TotalCLNum);
  p_SetImmediateType(INT,I_TotalCLNum);
 End_of_KL1B_Instruction:;
}


/******************************************************************** PSL **
kblt_b_current_processor PENum, NumOfPE

       written by f-doumae@icot22      on Fri Mar 16 11:57:18 1990
<Arguments>
    PENum     : $B%/%i%9%?FbJ*M}(BPE$BHV9f(B($B=PNO(B)
    NumOfPE   : $B%/%i%9%?Fb(BPE$BBf?t(B    ($B=PNO(B)

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#OPF_define I_RegPENum      _IndirectRegField1
#OPF_define I_RegNumOfPE    _IndirectRegField2

#OPF_define I_ImmRegPENum      _ImmediateField1
#OPF_define I_ImmRegNumOfPE    _ImmediateField2

#PSL_define kblt_b_current_processor()
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp2ArgVect_OO_Sub
	    (D_WorkArgVect,I_RegPENum,I_RegNumOfPE));
      f_TraceBodyBuiltin(BLT_B_CURRENT_PROCESSOR,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };
  @DEBUG {
    b_IfRangeErr( I_ImmRegPENum, _ZERO, _MAX_ARG_REG_OF_KLB ) {
      OUT_OF_SPEC("kblt_b_current_processor","r1_range");
    }
    b_IfRangeErr( I_ImmRegNumOfPE, _ZERO, _MAX_ARG_REG_OF_KLB ) {
      OUT_OF_SPEC("kblt_b_current_processor","r2_range");
    }
  };
  p_MoveWord(D_PE_Number, I_RegPENum);      /* $B%/%i%9%?FbJ*M}(BPE$BHV9f(B   */
  p_SetImmediateType(INT,I_RegPENum);
  b_ReadPENumInCluster(I_RegNumOfPE);       /* $B%/%i%9%?Fb(BPE$BBf?t(B       */
  p_SetImmediateType(INT,I_RegNumOfPE);
 End_of_KL1B_Instruction:;
}

/******************************************************************** PSL **
kblt_b_current_goal_attribute Attr

       written by f-doumae@icot22      on Fri Mar 16 12:01:47 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#OPF_define I_RegAttribute _IndirectRegField1

#OPF_define I_ImmRegAttribute _ImmediateField1

#PSL_define kblt_b_current_goal_attribute()
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp1ArgVect_O_Sub(D_WorkArgVect, I_RegAttribute));
      f_TraceBodyBuiltin(BLT_B_CURRENT_GOAL_ATTRIBUTE,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  @DEBUG {
    b_IfRangeErr( I_ImmRegAttribute, _ZERO, _MAX_ARG_REG_OF_KLB ) {
      OUT_OF_SPEC("kblt_b_current_goal_attribute","r1_range");
    }
  };
  s_GetAttributeEnvRecord(D_CurrentEnvRecPtr, I_RegAttribute);
  @DEBUG {
    s_IfNotINT( I_RegAttribute ) {
      VPIM_ERROR("kblt_b_current_goal_attribute","Illegal Type");
    }};
 End_of_KL1B_Instruction:;
}

/******************************************************************** PSL **
kblt_b_new_atom

       written by ttakagi@icot22      on Tue Dec 11 17:20:42 1990

    0           1           2           3           4
    +-----------+-----------+-----------+------------+
    |      b_new_atom       |   Atom    | don't care |
    +-----------+-----------+-----------+------------+

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#DATA_define D_WorkNewAtom  XXX
#CONST_define _NEW_ATOM_CL_NUM_OFST  24
#CONST_define _NEW_ATOM_CL_MASK     0x00ffffff

#OPF_define I_RegNewAtom    _IndirectRegField1

#PSL_define kblt_b_new_atom()
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp1ArgVect_O_Sub(D_WorkArgVect, I_RegNewAtom));
      f_TraceBodyBuiltin(BLT_B_NEW_ATOM,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  b_GetNewAtomCounterX(I_RegNewAtom);
  b_BitwiseAndImmediateWithTag(I_RegNewAtom,_NEW_ATOM_CL_MASK,I_RegNewAtom);
  /* type ATOM is set already in counter */
  $USE(D_WorkNewAtom);
  b_ShiftLeftImmediateWithDNTC(D_CL_Number, _NEW_ATOM_CL_NUM_OFST, 
			       D_WorkNewAtom);
  b_BitwiseOrWithTag(I_RegNewAtom, D_WorkNewAtom, I_RegNewAtom);
  $RELEASE(D_WorkNewAtom);
 End_of_KL1B_Instruction:;
}

#PSL_define i_InitNewAtomCounter(){
  $USE(D_WorkNewAtom);
  b_SetImmTypeValueMRBoff(ATOM,_ZERO,D_WorkNewAtom);
  b_InitNewAtomCounter(D_WorkNewAtom);
  $RELEASE(D_WorkNewAtom);
}


/******************************************************************** PSL **
unbound A1 A2

       written by ttakagi@icot22      on Wed Dec 12 11:38:26 1990

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |      b_unbound        |    A1     |    A2     |
    +-----------+-----------+-----------+-----------+

<Arguments>
 A1: $BL$Dj5A$+$I$&$+!"%A%'%C%/$5$l$kJQ?t(B
 A2: $B%A%'%C%/$7$?7k2L(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  unbound(I_RegVariable, I_RegDst)
    I_RegVariable$B$,L$Dj5A(B
             ---> I_RegDst = {D_CL_Number, VarPtr, I_RegVariable}
    I_RegVariable$B$,Dj5A:Q$_(B
             ---> I_RegDst = {I_RegVariable}
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkDerefPtr_unbound XXX

#OPF_define I_RegVariable   _IndirectRegField1
#OPF_define I_RegDst        _IndirectRegField2

#PSL_define kblt_b_unbound()
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp2ArgVect_IO_Sub(D_WorkArgVect, I_RegVariable, I_RegDst));
      f_TraceBodyBuiltin(BLT_B_UNBOUND,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  $USE(D_WorkDerefPtr);
 Retry_Label:
  f_ActiveDeref(I_RegVariable, D_WorkDerefPtr);
  TypeSwitch(I_RegVariable) {
  case AtomicGrp():
  case FloatingGrp():
  case StructureGroup():
  case CodeGrp():
    /* I_RegDst = {I_RegVariable} $B$rJV$9(B */
    s_AllocVect1(I_RegDst);
    s_PutVectElementImmOfst(I_RegDst, _ZERO, I_RegVariable);
    break;
  case UndefGrp():
  case HookGrp():
  case ExpVarGrp():
  case StreamGrp():
    /* I_RegDst = {CL_Num, VarPtr, I_RegVariable} $B$rJV$9(B */
    s_AllocVect3(I_RegDst);
    s_PutVectElementImmOfst(I_RegDst, _WORD_0, D_CL_Number);
    $USE(D_WorkDerefPtr_unbound);
    b_MoveWithImmTypeMRBoff(D_WorkDerefPtr,INT,D_WorkDerefPtr_unbound);
    s_PutVectElementImmOfst(I_RegDst, _WORD_1, D_WorkDerefPtr_unbound);
    $RELEASE(D_WorkDerefPtr_unbound);
    s_PutVectElementImmOfst(I_RegDst, _WORD_2, D_WorkDerefPtr);
    p_MoveWord(D_WorkDerefPtr, I_RegVariable);
    break;
  case EX_Grp():
    s_IfSuccessSoftLockExCell(D_WorkDerefPtr, I_RegVariable) {
      /* Dcode_b_unbound $B$r:n$C$FEj$2$k(B */
      $USE(D_WorkDcodeAddr);
      f_GetDcodeAddress(BLT_B_UNBOUND, D_WorkDcodeAddr);
      $USE(D_WorkGoalPtr); $USE(D_WorkPriority);
      s_GetPriorityEnvRecord(D_CurrentEnvRecPtr,D_WorkPriority);
      s_AllocAndInitNoDebugShortGoalRecord
	(D_WorkGoalPtr, _TWO, D_WorkDcodeAddr, D_WorkPriority,
	 _EMIGRANT_CLUSTER, D_Current_FP_Ptr);
      $RELEASE(D_WorkPriority);
      $RELEASE(D_WorkDcodeAddr);
      s_AllocVariable(I_RegDst);
      f_Put2ArgsGoalRecord(D_WorkGoalPtr, D_WorkDerefPtr, I_RegDst);
      $USE(D_WorkRecvCLNum);
      f_Get_CLNum_fromExCell(I_RegVariable, D_WorkRecvCLNum);
      $USE(D_WorkArg1);
      b_SetImmTypeValueMRBoff(INT, _TWO, D_WorkArg1);/*arity*/
      s_PutArityGoalRecord(D_WorkGoalPtr, D_WorkArg1);
      $RELEASE(D_WorkArg1);
      s_IfNodeOutOfBounds(D_Current_FP_Ptr, D_WorkRecvCLNum) {
	@DEBUG{ WARNING("kblt_b_unbound","node is out of bounds"); };
	s_SoftUnlockExCell(D_WorkDerefPtr, I_RegVariable);
      } else {
	/* $B0z?t$,Aw=P$G$-$k$+$I$&$+$r%A%'%C%/$7!"(B
	        $BAw=P$G$-$k(B   ---> $BIaDL$K(B throw_goal
		$BAw=P$G$-$J$$(B ---> WEC$BBT$A$G%5%9%Z%s%I(B  */
	f_IfUnifySendableUnifyArg(D_WorkDerefPtr, I_RegVariable) {
	  s_SoftUnlockExCell(D_WorkDerefPtr, I_RegVariable);
	  $CALL( f_Send_IntClMsg_ThrowUnbound_Sub
	              (D_WorkRecvCLNum, D_WorkGoalPtr, D_Current_FP_Ptr) );
	} else {
	  s_IncrementForkCounter();
	  f_MessageSusp_WaitingWEC
	              (D_WorkDerefPtr, I_RegVariable, D_WorkGoalPtr);
	}
      }
      $RELEASE(D_WorkRecvCLNum);
      $RELEASE(D_WorkGoalPtr);
      p_MoveWord(D_WorkDerefPtr, I_RegVariable);
      break;
    }
  case EXLOCK:
    p_MoveWord(D_WorkDerefPtr, I_RegVariable);
    goto Retry_Label;
  default:
    @DEBUG{ VPIM_ERROR("kblt_b_unbound", "Illegal type appeared"); };
    break;
  }
  $RELEASE(D_WorkDerefPtr);
 End_of_KL1B_Instruction:;
}
/******************************************************************** PSL **

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_RegNodeNum           _IndirectRegField1
#OPF_define I_RegClusterNum        _IndirectRegField2

#PSL_define kblt_b_node_to_cluster()
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp2ArgVect_IO_Sub(D_WorkArgVect, 
				      I_RegNodeNum, I_RegClusterNum));
      f_TraceBodyBuiltin(BLT_B_NODE_TO_CLUSTER,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  $USE(D_WorkDerefPtr);
  f_ActiveDeref(I_RegNodeNum, D_WorkDerefPtr);

  s_IfINT(I_RegNodeNum) {
    $RELEASE(D_WorkDerefPtr);
    b_IfLess(I_RegNodeNum,D_NULL) {
      goto Exception_Out_Of_Bounds;
    } else {
      $USE(D_WorkNodeCount);
      s_GetFPNodeCount(D_Current_FP_Ptr,D_WorkNodeCount);
      b_IfGreaterEq(I_RegNodeNum,D_WorkNodeCount) {
	$RELEASE(D_WorkNodeCount);
	goto Exception_Out_Of_Bounds;
      } else {
	$RELEASE(D_WorkNodeCount);
	goto L_body;
      }
    }
  }
  s_IfUnbound(I_RegNodeNum) {
    p_MoveWord(D_WorkDerefPtr, I_RegNodeNum);
    $RELEASE(D_WorkDerefPtr);
    f_DcodeEnqueue2Ope_IO(BLT_B_NODE_TO_CLUSTER,
			  I_RegNodeNum,I_RegClusterNum);
    goto End_of_KL1B_Instruction;
  }
 Exception_Illegal_Input:
  $RELEASE(D_WorkDerefPtr);
  $USE(D_WorkExceptionCode);
  b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
  goto ExceptionCommon;
 Exception_Out_Of_Bounds:
  $USE(D_WorkExceptionCode);
  b_SetImmTypeValueMRBoff (INT, _OUT_OF_BOUNDS_EXCP, D_WorkExceptionCode);
 ExceptionCommon:
  $USE (D_WorkOpCode);
  b_SetImmTypeValueMRBoff (INT, BLT_B_NODE_TO_CLUSTER, D_WorkOpCode);
  $USE(D_WorkExcepArgPos);
  b_SetImmTypeValueMRBoff (INT, _ZERO, D_WorkExcepArgPos);
  $CALL (f_Exception_2Arg_IO_Sub (D_WorkExceptionCode, 
				  D_WorkOpCode, 
				  D_WorkExcepArgPos, 
				  I_RegNodeNum,I_RegClusterNum) );
  $RELEASE (D_WorkExceptionCode);
  $RELEASE (D_WorkOpCode);
  $RELEASE(D_WorkExcepArgPos);
  goto End_of_KL1B_Instruction;

 L_body:
  s_GetFPMinNode(D_Current_FP_Ptr,I_RegClusterNum);
  b_AddWithDNTC(I_RegClusterNum,I_RegNodeNum,I_RegClusterNum);
  p_SetImmediateType(INT,I_RegClusterNum);

 End_of_KL1B_Instruction:;
}


#OPF_define I_RegNodeNum           _IndirectRegField1
#OPF_define I_RegTotalNode         _IndirectRegField2

#PSL_define kblt_b_current_node(){

  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp2ArgVect_OO_Sub(D_WorkArgVect, 
				      I_RegNodeNum, I_RegTotalNode));
      f_TraceBodyBuiltin(BLT_B_CURRENT_NODE,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  s_GetFPMinNode(D_Current_FP_Ptr,I_RegNodeNum);
  b_SubtractWithDNTC(D_CL_Number,I_RegNodeNum,I_RegNodeNum);
  p_SetImmediateType(INT,I_RegNodeNum);
  s_GetFPNodeCount(D_Current_FP_Ptr,I_RegTotalNode);
  p_SetImmediateType(INT,I_RegTotalNode);
 End_of_KL1B_Instruction:;
}

/**********************************************************************
$B!}(B $B%b%8%e!<%k$NA`:n!J#B!K(B
  $B!J%;%k%U%3%s%Q%$%iMQ!"N)$A>e$2;~$K$bI,MW!K(B

 $B!&(Bnew_module(^Module,Size,Gcsize)
	body, system
	$B?7$7$$%b%8%e!<%k$r@8@.$9$k!#(B

 $B!&(Bset_module_element(Module,Pos,Elem,^Newmod)
	body, system
	$BMWAG$r;XDj$N$b$N$KCV$-49$($k!#(B

kblt_module (G) $B$O(B kblt_guard_blt_struct $B$K$"$k!#(B
kblt_b_module_element (B) $B$O>/$7>e$K$"$k!#(B

**********************************************************************/

#OPF_define I_RegDstModule    _IndirectRegField1
#OPF_define I_RegModuleSize   _IndirectRegField2
#OPF_define I_RegGCSize       _IndirectRegField3

#PSL_define kblt_b_new_module(){

  @DEBUG {
    s_IfArgTypeErr (I_RegModuleSize){
	VPIM_ERROR ("b_new_module", "Illegal_A2");
    }
    s_IfArgTypeErr (I_RegGCSize) {
	VPIM_ERROR ("b_new_module", "Illegal_A3");
    }
  };

  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp3ArgVect_OII_Sub(D_WorkArgVect,
				       I_RegDstModule,
				       I_RegModuleSize,
				       I_RegGCSize));
      f_TraceBodyBuiltin(BLT_B_NEW_MODULE,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  $USE (D_Workreg1);
  f_ActiveDeref (I_RegModuleSize, D_Workreg1);
  TypeSwitch (I_RegModuleSize) {

    case INT:
      $RELEASE (D_Workreg1);
      break;

    case UnboundGroup (): 
      p_MoveWord (D_Workreg1, I_RegModuleSize);
      $RELEASE (D_Workreg1);
      f_DcodeEnqueue3Ope_OII(BLT_B_NEW_MODULE,
			     I_RegDstModule,
			     I_RegModuleSize,
			     I_RegGCSize);
      goto END;

    case ATOM:
    case FLT:
    case StructureGroup ():
    case RefGroup ():
    case ControlGroup ():
      $RELEASE (D_Workreg1);
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _ONE, D_WorkExcepArgPos);
      goto Exception;

    default: 
      @DEBUG {VPIM_ERROR ("kblt_b_new_module", "undefined type");};
      goto END;
  }
  
  b_IfLess (I_RegModuleSize, D_NULL) {
          /* $B;XDj$5$l$?%5%$%:$,Ii?t$J$iNc30(B */
    $USE (D_WorkExceptionCode);
    $USE(D_WorkExcepArgPos);
    b_SetImmTypeValueMRBoff (INT, 
			     _RANGE_OVERFLOW_EXCP, 
			     D_WorkExceptionCode);
    b_SetImmTypeValueMRBoff (INT, _ONE, D_WorkExcepArgPos);
    goto Exception;
  }
  b_IfGreater(I_RegModuleSize,D_AvailableHeapSize) {
    /* $B%R!<%WJRLL$N%5%$%:$h$jBg$-$$>l9g$ONc30(B */
    $USE (D_WorkExceptionCode);
    $USE(D_WorkExcepArgPos);
    b_SetImmTypeValueMRBoff
      (INT, _RANGE_OVERFLOW_EXCP, D_WorkExceptionCode);
    b_SetImmTypeValueMRBoff (INT, _ONE, D_WorkExcepArgPos);
    goto Exception;
  }
  
  $USE (D_Workreg2);
  f_ActiveDeref (I_RegGCSize, D_Workreg2);
  TypeSwitch (I_RegGCSize) {

    case INT:
      $RELEASE (D_Workreg2);
      break;

    case UnboundGroup (): 
      p_MoveWord (D_Workreg2, I_RegGCSize);
      $RELEASE (D_Workreg2);
      f_DcodeEnqueue3Ope_OII(BLT_B_NEW_MODULE,
			     I_RegDstModule,
			     I_RegModuleSize,
			     I_RegGCSize);
      goto END;
    
    case ATOM:
    case FLT:
    case StructureGroup ():
    case RefGroup ():
    case ControlGroup ():
      $RELEASE (D_Workreg2);
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, 
			       _ILLEGAL_INPUT_EXCP, 
			       D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _TWO, D_WorkExcepArgPos);
      goto Exception;

    default: 
      $RELEASE (D_Workreg2);
      @DEBUG {VPIM_ERROR ("kblt_b_new_module", "undefined type");};
      goto END;
  }

  b_IfLess (I_RegGCSize, D_NULL) {
    /* $B;XDj$5$l$?%5%$%:$,Ii?t$J$iNc30(B */
    $USE (D_WorkExceptionCode);
    $USE(D_WorkExcepArgPos);
    b_SetImmTypeValueMRBoff (INT, 
			     _RANGE_OVERFLOW_EXCP, 
			     D_WorkExceptionCode);
    b_SetImmTypeValueMRBoff (INT, _TWO, D_WorkExcepArgPos);
    goto Exception;
  }
  b_IfGreater(I_RegGCSize,I_RegModuleSize) {
    /* $B%b%8%e!<%k%5%$%:$h$jBg$-$$>l9g$ONc30(B */
    $USE (D_WorkExceptionCode);
    $USE(D_WorkExcepArgPos);
    b_SetImmTypeValueMRBoff
      (INT, _RANGE_OVERFLOW_EXCP, D_WorkExceptionCode);
    b_SetImmTypeValueMRBoff (INT, _TWO, D_WorkExcepArgPos);
    goto Exception;
  }
  
  $CALL(s_AllocCodeModule_Sub(I_RegModuleSize, I_RegDstModule));
  
  b_IfWordEq (I_RegDstModule, D_NULL) {
    /* $B%R!<%WNN0hITB-$G!"%b%8%e!<%k$r@8@.$G$-$J$+$C$?;~$O!"(B
      * Dcode $B%4!<%k$r(B enqueue $B$9$k!#(B
	*/
    f_DcodeEnqueue3Ope_OII (BLT_B_NEW_MODULE,
			    I_RegDstModule,
			    I_RegModuleSize,
			    I_RegGCSize);
    @DEBUG { WARNING ("kblt_b_new_module", 
		      "Dcode Goal enqueued"); };
  } else {
    /* $B%b%8%e!<%k$N=i4|2=$r9T$&(B */
    b_SetImmTypeMRBoff(MOD,I_RegDstModule);
    $CALL(s_InitializeCodeModule_Sub (I_RegModuleSize,
				      I_RegGCSize,I_RegDstModule));
  }
  
  goto END;

 Exception:
  $USE (D_WorkOpCode);
  b_SetImmTypeValueMRBoff (INT, BLT_B_NEW_MODULE, D_WorkOpCode);
  $CALL (f_Exception_3Arg_OII_Sub(D_WorkExceptionCode, D_WorkOpCode, 
				  D_WorkExcepArgPos,
				  I_RegDstModule,I_RegModuleSize,
				  I_RegGCSize));
  $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
  $RELEASE(D_WorkExcepArgPos);

 END:
 End_of_KL1B_Instruction:;
}

/************
 $B!&(Bset_module_element(Module,Pos,Elem,^Newmod)
	body, system
	$BMWAG$r;XDj$N$b$N$KCV$-49$($k!#(B
**************/

#DATA_define D_WorkModSize XXX

#OPF_define I_RegOldMod _IndirectRegField1
#OPF_define I_RegPos    _IndirectRegField2
#OPF_define I_RegElm    _IndirectRegField3
#OPF_define I_RegNewMod _IndirectRegField4

#PSL_define kblt_b_set_module_element(){

  @DEBUG {
    s_IfArgTypeErr (I_RegOldMod){
	VPIM_ERROR ("b_set_module_element", "Illegal_A1");
    }
    s_IfArgTypeErr (I_RegPos) {
	VPIM_ERROR ("b_set_module_element", "Illegal_A2");
    }
    s_IfArgTypeErr (I_RegElm){
	VPIM_ERROR ("b_set_module_element", "Illegal_A3");
    }
  };

  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp4ArgVect_IIIO_Sub
	    (D_WorkArgVect,
	     I_RegOldMod,I_RegPos,I_RegElm,I_RegNewMod));
      f_TraceBodyBuiltin(BLT_B_SET_MODULE_ELEMENT,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  $USE (D_Workreg1);
  f_ActiveDeref (I_RegPos, D_Workreg1);
  TypeSwitch (I_RegPos) {
    case INT:
      $RELEASE (D_Workreg1);
      break;

    case UnboundGroup ():   
      p_MoveWord (D_Workreg1, I_RegPos);
      $RELEASE (D_Workreg1);
      f_DcodeEnqueue4Ope_IIIO (BLT_B_SET_MODULE_ELEMENT,
			       I_RegOldMod,I_RegPos,I_RegElm,I_RegNewMod);
      goto END;
      
    case ATOM:
    case FLT:
    case StructureGroup ():
    case RefGroup ():
    case ControlGroup ():
      $RELEASE (D_Workreg1);
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _ONE, D_WorkExcepArgPos);
      goto Exception;

    default:
      $RELEASE (D_Workreg1);
      @DEBUG {VPIM_ERROR ("kblt_b_set_module_element", "undefined type");};
      goto END;
  }

  b_IfLessEq (I_RegPos, D_ONE) {
    /* $B;XDj$5$l$?MWAGHV9f$,Ii?t$J$iNc30(B */
    /* $B%b%8%e!<%k%5%$%:%o!<%I$X$N=q$-9~$_$ONc30(B */
    /* $B#G#C%5%$%:%o!<%I$X$N=q$-9~$_$ONc30(B */
    $USE (D_WorkExceptionCode);
    $USE(D_WorkExcepArgPos);
    b_SetImmTypeValueMRBoff (INT, _OUT_OF_BOUNDS_EXCP, 
			     D_WorkExceptionCode);
    b_SetImmTypeValueMRBoff (INT, _ONE, D_WorkExcepArgPos);
    goto Exception;
  }

  /* $B;XDj$5$l$?MWAGHV9f$,#20J>e$J$i(B... */
  $USE (D_Workreg2);
  f_ActiveDeref (I_RegOldMod, D_Workreg2);
  TypeSwitch (I_RegOldMod) {
    case MOD:  
      $RELEASE (D_Workreg2);
      break;
      
    case UnboundGroup ():   
      p_MoveWord (D_Workreg2, I_RegOldMod);
      $RELEASE (D_Workreg2);
      f_DcodeEnqueue4Ope_IIIO(BLT_B_SET_MODULE_ELEMENT,
			      I_RegOldMod,I_RegPos,
			      I_RegElm,I_RegNewMod);
      goto END;
      
    default:  
      $RELEASE (D_Workreg2);
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, 
			       _ILLEGAL_INPUT_EXCP, 
			       D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _ZERO, D_WorkExcepArgPos);
      goto Exception;
  }
 	 
  $USE (D_WorkModSize);

  s_GetGCAreaSize(I_RegOldMod, D_WorkModSize);
  b_IfEqual (I_RegPos, D_WorkModSize){
    /* CDESK$B%o!<%I$X$N=q$-9~$_$ONc30(B */
    $RELEASE (D_WorkModSize);
    $USE (D_WorkExceptionCode);
    $USE(D_WorkExcepArgPos);
    b_SetImmTypeValueMRBoff (INT, 
			     _OUT_OF_BOUNDS_EXCP, 
			     D_WorkExceptionCode);
    b_SetImmTypeValueMRBoff (INT, _ONE, D_WorkExcepArgPos);
    goto Exception;
  }

  s_GetSizeCodeModule(I_RegOldMod, D_WorkModSize);
  b_IfGreaterEq (I_RegPos, D_WorkModSize){
    /* $B%b%8%e!<%k%5%$%:0J>e$N;~$ONc30(B */
    $RELEASE (D_WorkModSize);
    $USE (D_WorkExceptionCode);
    $USE(D_WorkExcepArgPos);
    b_SetImmTypeValueMRBoff (INT, 
			     _OUT_OF_BOUNDS_EXCP, 
			     D_WorkExceptionCode);
    b_SetImmTypeValueMRBoff (INT, _ONE, D_WorkExcepArgPos);
    goto Exception;
  }

  /* $B%b%8%e!<%k%5%$%:L$K~$N;~(B */
  s_CopyCodeModuleMRB (I_RegOldMod, D_WorkModSize, I_RegNewMod);
  $RELEASE (D_WorkModSize);
  b_IfWordNotEq (I_RegNewMod, D_NULL) {
    /* $B%b%8%e!<%k$,$G$-$?;~!"?7MWAG$r=q$-9~$`(B */
    $USE(D_WorkModPtr);
    b_ExchangeElmposToOffset(I_RegPos,D_WorkModPtr);
    b_AddWithDNTC(I_RegNewMod,D_WorkModPtr,D_WorkModPtr);
    $USE(D_Workreg1);
    b_MoveWithMRBon(I_RegElm,D_Workreg1);
    p_Write(D_Workreg1,D_WorkModPtr);
    /* $B%;%k%U%3%s%Q%$%i$N<B9T8zN($r9M$($F!"(B
       $B$$$D$b9u%G!<%?$H$7$F=q$-9~$`$3$H$K$7$?!#(B
       92.04.30 REKI */
    /* I_RegElm $B$rD>@\9u$/$7$F$b$$$$$N$+$J!)(B */
    $RELEASE (D_Workreg1);
    $RELEASE(D_WorkModPtr);
  } else {
    /* $B%R!<%WNN0hITB-$G!"%b%8%e!<%k$r@8@.$G$-$J$+$C$?;~$O!"(B
      * Dcode $B%4!<%k$r(B enqueue $B$9$k!#(B
	*/
    f_DcodeEnqueue4Ope_IIIO
      (BLT_B_SET_MODULE_ELEMENT,
       I_RegOldMod,I_RegPos,I_RegElm,I_RegNewMod);
    @DEBUG { WARNING ("kblt_b_set_module_element", 
		      "Dcode Goal enqueued"); };
  }
  goto END;

 Exception:
  $USE (D_WorkOpCode);
  b_SetImmTypeValueMRBoff (INT, BLT_B_SET_MODULE_ELEMENT, D_WorkOpCode);
  $CALL (f_Exception_4Arg_IIIO_Sub (D_WorkExceptionCode, D_WorkOpCode, 
			     D_WorkExcepArgPos, I_RegOldMod,
			     I_RegPos, I_RegElm, I_RegNewMod));
  $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
  $RELEASE(D_WorkExcepArgPos);

 END:
 End_of_KL1B_Instruction:;
}
