
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/interpreter/klb_body_blt_bignum.psl.c
   ----- CREATED   : by yamamoto@icot22, on Fri Nov  8 15:57:47 1991
   ----- LAST SAVED: by yamamoto@icot22, on Tue Jul 14 17:39:15 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : 
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */
/******************************************************************** PSL **

  $BB?G\D9@0?t(B(BIGNUM)$B1i;;(B

$B?t<0=hM}$J$I$NBg$-$J@0?t$r07$&%"%W%j%1!<%7%g%sMQ$K(B
PIMOS$B$,Ds6!$9$kB?G\D9@0?t1i;;%i%$%V%i%j$r9bB.2=$9$k$?$a!"(B
$BB?G\D9@0?t1i;;$N4pK\1i;;$rAH9~=R8l2=$7$?!#(B

$B$^$?!"B?G\D9@0?t1i;;$r(BKL1$B%W%m%0%i%`$K$h$C$F$b<BAu2DG=$H$9$k$?$a!"(B
$BG\8lD9@0?t1i;;AH9~=R8l$b9g$o$;$F%5%]!<%H$9$k!#(B

$B4pK\1i;;$O!"B?G\D9@0?t1i;;$N%i%$%V%i%j1i;;=hM}$K$*$1$k:GFb3L%k!<%W$r(B
$BAH9~=R8l2=$9$k$H$$$&9M$(J}$K4p$E$-A*$P$l$?!#(B

$BB?G\D9@0?t$NI=8=7A<0$O(B 
$B?7$?$J%G!<%?7?$N%5%]!<%H$G$O$J$/!"(B
32 $B%S%C%H%9%H%j%s%0$GId9f$N$J$$@0?tCM$rI=$9!#(B
$B%9%H%j%s%0MWAGHV9f$N>.$5$$J}$K(BMSB$B$rCV$/$3$H$H$7!"(B
$BF~=PNO$H$b!">e0LB&$KM>J,$J!V%<%m!WMWAG$OF~$l$J$$(B/$BIU$1$J$$!#(B
0 $B$NI=8=7A<0$O6u%9%H%j%s%0$G$"$k!#(B

#PSL_define kblt_b_add_bignum()
#PSL_define kblt_b_subtract_bignum()
#PSL_define kblt_b_multiply_bignum_by_word()

  $BG\8lD9@0?t1i;;AH9~=R8l(B

$B$9$Y$FId9g$J$71i;;$N%\%G%#AH9~=R8l$G$"$k!#(B

$BB?G\D9@0?t1i;;$r(BKL1$B%W%m%0%i%`$K$h$C$F$b<BAu2DG=$H$9$k$?$a$N(B
$B@lMQ$N(B64$B%S%C%H1i;;AH9~=R8l$G$"$k!#(B
$B$?$@$7!"?7$?$J%G!<%?7?$N%5%]!<%H$G$O$J$/!"G\8lD9@0?t$O$9$Y$FFs$D$N(B
$B@0?t7?$KJ,2r$5$l$F$$$k!#(B

#PSL_define kblt_b_add_extended()
#PSL_define kblt_b_subtract_extended()
#PSL_define kblt_b_multiply_extended()
#PSL_define kblt_b_divide_extended()

********************************************************************* PSL **/

/******************************************************************** PSL **
 $BG\8lD9@0?t1i;;AH9~=R8l(B

add_extended A1 A2 A3 A4

  0            1            2            3            4
  +------------+------------+------------+------------+
  |  b_add_extended         |     A1     |     A2     |
  +------------+------------+------------+------------+
  |    A3      |    A4      |    don't care           |
  +------------+------------+------------+------------+

<Arguments>
  A1   $B%l%8%9%?(B($BL$Dj5A$J$i!"%5%9%Z%s%I!#(BINT$B0J30$K6qBN2=$5$l$F$$$?$i!"Nc30(B)
  A2   $B%l%8%9%?(B($BL$Dj5A$J$i!"%5%9%Z%s%I!#(BINT$B0J30$K6qBN2=$5$l$F$$$?$i!"Nc30(B)
  A3   $B%l%8%9%?(B($B=PNO!#(B)
  A4   $B%l%8%9%?(B($B=PNO!#(B)
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>

add_extended(X,Y,^Carry,^Z)
        32 bit + 32 bit = 32 bit with Carry

X($B@0?t(B)$B$H(BY($B@0?t(B)$B$NOB$r$H$j!"(B
$B7k2L$N2<0L(B32$B%S%C%H$r(BZ($B@0?t(B)$B!"7e0n$l$r(BCarry($B@0?t(B)$B$H$9$k!#(B

$B%*!<%P%U%m!<$O(BCarry$B$K$h$jH=Dj$G$-$k$N$GNc30$H$O$7$J$$!#(B

<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_IntSrc1   _IndirectRegField1
#OPF_define I_IntSrc2   _IndirectRegField2
#OPF_define I_DIntUDst  _IndirectRegField3
#OPF_define I_DIntLDst  _IndirectRegField4

#PSL_define kblt_b_add_extended(){
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp4ArgVect_IIOO_Sub
	    (D_WorkArgVect,I_IntSrc1,I_IntSrc2,I_DIntUDst,I_DIntLDst));
      f_TraceBodyBuiltin(BLT_B_ADD_EXTENDED,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };
  s_IfINT (I_IntSrc1) {
    s_IfINT (I_IntSrc2) {
      b_Add_ExtendedInt(I_IntSrc1,I_IntSrc2,I_DIntUDst,I_DIntLDst);
      goto End_of_KL1B_Instruction; /* end of KLB instruction */
    }
  }
  i_BodyBltExtendedInt4Arg (BLT_B_ADD_EXTENDED,
			      I_IntSrc1, I_IntSrc2, I_DIntUDst, I_DIntLDst);
 End_of_KL1B_Instruction: ;
}

/******************************************************************** PSL **
 $BG\8lD9@0?t1i;;AH9~=R8l(B

subtract_extended A1 A2 A3 A4

  0            1            2            3            4
  +------------+------------+------------+------------+
  |  b_subtract_extended    |     A1     |     A2     |
  +------------+------------+------------+------------+
  |    A3      |    A4      |    don't care           |
  +------------+------------+------------+------------+

<Arguments>
  A1   $B%l%8%9%?(B($BL$Dj5A$J$i!"%5%9%Z%s%I!#(BINT$B0J30$K6qBN2=$5$l$F$$$?$i!"Nc30(B)
  A2   $B%l%8%9%?(B($BL$Dj5A$J$i!"%5%9%Z%s%I!#(BINT$B0J30$K6qBN2=$5$l$F$$$?$i!"Nc30(B)
  A3   $B%l%8%9%?(B($B=PNO!#(B)
  A4   $B%l%8%9%?(B($B=PNO!#(B)
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>

subtract_extended(X,Y,^Borrow,^Z)
        32 bit - 32 bit = 32 bit with Borrow

X($B@0?t(B)$B$H(BY($B@0?t(B)$B$N:9(B(X - Y)$B$r$H$j!"(B
$B7k2L$N2<0L(B32$B%S%C%H$r(BZ($B@0?t(B)$B!"(B
$B7e<Z$j$r(BBorrow($B@0?t(B)$B$H$9$k!#(B

$B%*!<%P%U%m!<$O(BBorrow$B$K$h$jH=Dj$G$-$k$N$GNc30$H$O$7$J$$!#(B

<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_IntSrc1   _IndirectRegField1
#OPF_define I_IntSrc2   _IndirectRegField2
#OPF_define I_DIntUDst  _IndirectRegField3
#OPF_define I_DIntLDst  _IndirectRegField4

#PSL_define kblt_b_subtract_extended(){
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp4ArgVect_IIOO_Sub
	    (D_WorkArgVect,I_IntSrc1,I_IntSrc2,I_DIntUDst,I_DIntLDst));
      f_TraceBodyBuiltin(BLT_B_SUBTRACT_EXTENDED,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };
  s_IfINT (I_IntSrc1) {
    s_IfINT (I_IntSrc2) {
      b_Subtract_ExtendedInt(I_IntSrc1,I_IntSrc2,I_DIntUDst,I_DIntLDst);
      goto End_of_KL1B_Instruction; /* end of KLB instruction */
    }
  }
  i_BodyBltExtendedInt4Arg (BLT_B_SUBTRACT_EXTENDED,
			      I_IntSrc1, I_IntSrc2, I_DIntUDst, I_DIntLDst);
 End_of_KL1B_Instruction: ;
}

/******************************************************************** PSL **
 $BG\8lD9@0?t1i;;AH9~=R8l(B

multiply_extended A1 A2 A3 A4

  0            1            2            3            4
  +------------+------------+------------+------------+
  |  b_multiply_extended    |     A1     |     A2     |
  +------------+------------+------------+------------+
  |    A3      |    A4      |    don't care           |
  +------------+------------+------------+------------+

<Arguments>
  A1   $B%l%8%9%?(B($BL$Dj5A$J$i!"%5%9%Z%s%I!#(BINT$B0J30$K6qBN2=$5$l$F$$$?$i!"Nc30(B)
  A2   $B%l%8%9%?(B($BL$Dj5A$J$i!"%5%9%Z%s%I!#(BINT$B0J30$K6qBN2=$5$l$F$$$?$i!"Nc30(B)
  A3   $B%l%8%9%?(B($B=PNO!#(B)
  A4   $B%l%8%9%?(B($B=PNO!#(B)
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>

multiply_extended(X,Y,^Zhigh,^Zlow)
        32 bit * 32 bit = 64 bit

X($B@0?t(B)$B$H(BY($B@0?t(B)$B$N@Q$r$H$j!"(B
$B7k2L$N>e0L(B32$B%S%C%H$r(BZhigh($B@0?t(B)$B!"(B
$B2<0L(B32$B%S%C%H$r(BZlow($B@0?t(B)$B$H$9$k!#(B

$B%*!<%P%U%m!<$O5/$-$J$$!#(B


<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_IntSrc1   _IndirectRegField1
#OPF_define I_IntSrc2   _IndirectRegField2
#OPF_define I_DIntUDst  _IndirectRegField3
#OPF_define I_DIntLDst  _IndirectRegField4

#PSL_define kblt_b_multiply_extended(){
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp4ArgVect_IIOO_Sub
	    (D_WorkArgVect,I_IntSrc1,I_IntSrc2,I_DIntUDst,I_DIntLDst));
      f_TraceBodyBuiltin(BLT_B_MULTIPLY_EXTENDED,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };
  s_IfINT (I_IntSrc1) {
    s_IfINT (I_IntSrc2) {
      b_Multiply_ExtendedInt(I_IntSrc1,I_IntSrc2,I_DIntUDst,I_DIntLDst);
      goto End_of_KL1B_Instruction; /* end of KLB instruction */
    }
  }
  i_BodyBltExtendedInt4Arg (BLT_B_MULTIPLY_EXTENDED,
			      I_IntSrc1, I_IntSrc2, I_DIntUDst, I_DIntLDst);
 End_of_KL1B_Instruction: ;
}

/******************************************************************** PSL **
 $BG\8lD9@0?t1i;;AH9~=R8l(B

divide_extended A1 A2 A3 A4 A5

  0            1            2            3            4
  +------------+------------+------------+------------+
  |  b_divide_extended      |     A1     |     A2     |
  +------------+------------+------------+------------+
  |    A3      |    A4      |     A5     | don't care |
  +------------+------------+------------+------------+

<Arguments>
  A1   $B%l%8%9%?(B($BL$Dj5A$J$i!"%5%9%Z%s%I!#(BINT$B0J30$K6qBN2=$5$l$F$$$?$i!"Nc30(B)
  A2   $B%l%8%9%?(B($BL$Dj5A$J$i!"%5%9%Z%s%I!#(BINT$B0J30$K6qBN2=$5$l$F$$$?$i!"Nc30(B)
  A3   $B%l%8%9%?(B($BL$Dj5A$J$i!"%5%9%Z%s%I!#(BINT$B0J30$K6qBN2=$5$l$F$$$?$i!"Nc30(B)
  A4   $B%l%8%9%?(B($B=PNO!#(B)
  A5   $B%l%8%9%?(B($B=PNO!#(B)

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>

divide_extended(Xhigh,Xlow,Y,^Z,^Mod)
        64 bit / 32 bit = 32 bit $B$"$^$j(B 32 bit

$B>e0L2<0L$NFs$D$N@0?t$KJ,$1$i$l$?(B64$B%S%C%H@0?t(B
$B!J(BXhigh,Xlow$B!K$r(B32$B%S%C%H@0?t!J(BY$B!K$G3d$j!"(B
32$B%S%C%H$N>&$r(BZ($B@0?t(B)$B!"(B32$B%S%C%H$N$"$^$j$r(BMod($B@0?t(B)$B$H$9$k!#(B

$B0lHL$K$O(B (Xhigh,Xlow)/Y = (Zhigh,Zlow) $B$G$"$j!"(B
$B>&$N%*!<%P%U%m!<$ONc30!#(B
$B$"$^$j$O%*!<%P%U%m!<$7$J$$!#%<%m3d$ONc30!#(B

$BB?G\D91i;;$K$*$1$k3d;;$N<BAu$G$O!"(B
$B>&$N%*!<%P%U%m!<$,5/$-$k$h$&$J0z?t$OEO$5$l$J$$!#(B

<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_DIntUSrc1   _IndirectRegField1
#OPF_define I_DIntLSrc1   _IndirectRegField2
#OPF_define I_IntSrc2     _IndirectRegField3
#OPF_define I_IntDst1     _IndirectRegField4
#OPF_define I_IntDst2     _IndirectRegField5

#PSL_define kblt_b_divide_extended(){
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp5ArgVect_IIIOO_Sub
	    (D_WorkArgVect,I_DIntUSrc1,I_DIntLSrc1,
	     I_IntSrc2,I_IntDst1,I_IntDst2));
      f_TraceBodyBuiltin(BLT_B_DIVIDE_EXTENDED,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  $USE(D_WorkDrfPtr);
  f_ActiveDeref(I_DIntUSrc1,D_WorkDrfPtr);
  s_IfINT(I_DIntUSrc1) {
    f_ActiveDeref(I_DIntLSrc1,D_WorkDrfPtr);
    s_IfINT(I_DIntLSrc1) {
      f_ActiveDeref(I_IntSrc2,D_WorkDrfPtr);
      s_IfINT(I_IntSrc2) {
	$RELEASE(D_WorkDrfPtr);

	b_IfZero(I_IntSrc2){ 
	  $USE(D_WorkExceptionCode);
	  b_SetImmTypeValueMRBoff (INT, _INTEGER_ZERO_DIVISION_EXCP,
				   D_WorkExceptionCode);
	  goto Exception;
	}
	b_IfGreaterEqU(I_DIntUSrc1,I_IntSrc2){ 
	  /* iff this condition then overflow */ 
	  $USE(D_WorkExceptionCode);
	  b_SetImmTypeValueMRBoff (INT, _INTEGER_OVERFLOW_EXCP,
				   D_WorkExceptionCode);
	  goto Exception;
	}
	b_Divide_ExtendedInt(I_DIntUSrc1,I_DIntLSrc1,
			     I_IntSrc2,I_IntDst1,I_IntDst2);
	goto End_of_KL1B_Instruction; /* end of KLB instruction */

      } else {
	s_IfUnbound(I_DIntLSrc1) {
	  p_MoveWord(D_WorkDrfPtr, I_IntSrc2);
	  goto Suspend;
	} else {
	  goto Exception_2;
	}
      }
    } else {
      s_IfUnbound(I_DIntLSrc1) {
	p_MoveWord(D_WorkDrfPtr, I_DIntLSrc1);
	goto Suspend;
      } else {
	goto Exception_1;
      }
    }
  } else {
    s_IfUnbound(I_DIntUSrc1) {
      p_MoveWord(D_WorkDrfPtr, I_DIntUSrc1);
      goto Suspend;
    } else {
      goto Exception_0;
    }
  }

 Exception:
  $USE(D_WorkExcepArgPos);
  b_SetImmTypeValueMRBoff (INT, _ZERO, D_WorkExcepArgPos);
  $USE(D_WorkArithOpe);
  b_SetImmTypeValueMRBoff (INT, BLT_B_DIVIDE_EXTENDED, D_WorkArithOpe);
  $CALL (f_Exception_5Arg_IIIOO_Sub (D_WorkExceptionCode, 
				     D_WorkArithOpe,
				     D_WorkExcepArgPos, 
				     I_DIntUSrc1,I_DIntLSrc1,
				     I_IntSrc2,I_IntDst1,I_IntDst2));
  $RELEASE(D_WorkArithOpe);
  $RELEASE(D_WorkExcepArgPos);
  $RELEASE(D_WorkExceptionCode);
  goto End_of_KL1B_Instruction; /* end of KLB instruction */

 Suspend:
  $RELEASE(D_WorkDrfPtr);
  f_DcodeEnqueue5Ope_IIIOO(BLT_B_DIVIDE_EXTENDED,
			   I_DIntUSrc1,I_DIntLSrc1,
			   I_IntSrc2,I_IntDst1,I_IntDst2);
  goto End_of_KL1B_Instruction; /* end of KLB instruction */
 Exception_0:
  $RELEASE(D_WorkDrfPtr);
  $USE(D_WorkExcepArgPos);
  b_SetImmTypeValueMRBoff (INT, _ZERO, D_WorkExcepArgPos);
  goto Exception_Common;
 Exception_1:
  $RELEASE(D_WorkDrfPtr);
  $USE(D_WorkExcepArgPos);
  b_SetImmTypeValueMRBoff (INT, _ONE, D_WorkExcepArgPos);
  goto Exception_Common;
 Exception_2:
  $RELEASE(D_WorkDrfPtr);
  $USE(D_WorkExcepArgPos);
  b_SetImmTypeValueMRBoff (INT, _TWO, D_WorkExcepArgPos);
 Exception_Common:
  $USE(D_WorkExceptionCode);
  b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
  $USE(D_WorkArithOpe);
  b_SetImmTypeValueMRBoff (INT, BLT_B_DIVIDE_EXTENDED, D_WorkArithOpe);
  $CALL (f_Exception_5Arg_IIIOO_Sub (D_WorkExceptionCode, D_WorkArithOpe,
				     D_WorkExcepArgPos, 
				     I_DIntUSrc1,I_DIntLSrc1,
				     I_IntSrc2,I_IntDst1,I_IntDst2));
  $RELEASE(D_WorkArithOpe);
  $RELEASE(D_WorkExceptionCode);
  $RELEASE(D_WorkExcepArgPos);

 End_of_KL1B_Instruction: ;
}

/**************** i-level macros for extended interger ***********/

#PSL_define i_BodyBltExtendedInt4Arg(imm_ope, src1, src2, dstu, dstl)
{
  $USE(D_WorkArithOpe);
  b_SetImmTypeValueMRBoff (INT, imm_ope, D_WorkArithOpe);
  $CALL( i_BodyBltExtendedInt4Arg_Sub (D_WorkArithOpe, 
				       src1, src2, dstu, dstl) );
  $RELEASE(D_WorkArithOpe);
}

#SUBARG_define	A_ArithOpe	SRC
#SUBARG_define	A_Arg0		MODIFY
#SUBARG_define	A_Arg1		MODIFY
#SUBARG_define	A_Arg2		DST
#SUBARG_define	A_Arg3		DST

#SUBROUTINE i_BodyBltExtendedInt4Arg_Sub (A_ArithOpe, 
					  A_Arg0, A_Arg1, A_Arg2, A_Arg3)
{
  $USE(D_WorkDrfPtr);
  f_ActiveDeref(A_Arg0,D_WorkDrfPtr);
  s_IfINT(A_Arg0) {
    f_ActiveDeref(A_Arg1,D_WorkDrfPtr);
    s_IfINT(A_Arg1) {
      $RELEASE(D_WorkDrfPtr);
      i_ExecuteBodyExtendedInt4Arg(A_ArithOpe,A_Arg0,A_Arg1,A_Arg2,A_Arg3);
      $RETURN();
    } else {
      s_IfUnbound(A_Arg1) {
	p_MoveWord(D_WorkDrfPtr, A_Arg1);
	goto Suspend;
      } else {
	goto Exception_1;
      }
    }
  } else {
    s_IfUnbound(A_Arg0) {
      p_MoveWord(D_WorkDrfPtr, A_Arg0);
      goto Suspend;
    } else {
      goto Exception_0;
    }
  }
 Suspend:
  $RELEASE(D_WorkDrfPtr);
  f_DcodeEnqueue4Ope_IIOO_Reg(A_ArithOpe,A_Arg0,A_Arg1,A_Arg2,A_Arg3);
  $RETURN();
 Exception_0:
  $RELEASE(D_WorkDrfPtr);
  $USE(D_WorkExcepArgPos);
  b_SetImmTypeValueMRBoff (INT, _ZERO, D_WorkExcepArgPos);
  goto Exception_Common;
 Exception_1:
  $RELEASE(D_WorkDrfPtr);
  $USE(D_WorkExcepArgPos);
  b_SetImmTypeValueMRBoff (INT, _ONE, D_WorkExcepArgPos);
 Exception_Common:
  $USE(D_WorkExceptionCode);
  b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
  $CALL (f_Exception_4Arg_IIOO_Sub (D_WorkExceptionCode, A_ArithOpe, 
				    D_WorkExcepArgPos, 
				    A_Arg0, A_Arg1, A_Arg2, A_Arg3));
  $RELEASE (D_WorkExceptionCode);
  $RELEASE(D_WorkExcepArgPos);
  $RETURN ();
}

#PSL_define i_ExecuteBodyExtendedInt4Arg (ope_code_reg, arg0, arg1, arg2, arg3)
{
  ValueSwitch (ope_code_reg) {
    case BLT_B_ADD_EXTENDED:
      b_Add_ExtendedInt(arg0,arg1,arg2,arg3);
      break;
    case BLT_B_SUBTRACT_EXTENDED:
      b_Subtract_ExtendedInt(arg0,arg1,arg2,arg3);      
      break;
    case BLT_B_MULTIPLY_EXTENDED:
      b_Multiply_ExtendedInt(arg0,arg1,arg2,arg3);      
      break;
    default:
      @DEBUG{
	OUT_OF_SPEC("i_ExecuteBodyExtendedInt4Arg","illegal_operation");
      };
  } /* end of ValueSwitch */
}

/******************************************************************** PSL **
  $BB?G\D9@0?t(B(BIGNUM)$B1i;;(B

add_bignum A1 A2 A3

  0            1            2            3            4
  +------------+------------+------------+------------+
  |  b_add_bignum           |     A1     |     A2     |
  +------------+------------+------------+------------+
  |    A3      |              don't care              |
  +------------+------------+------------+------------+

<Arguments>
  A1   $B%l%8%9%?(B($BL$Dj5A$J$i!"%5%9%Z%s%I!#(B
		32$B%S%C%H%9%H%j%s%00J30$K6qBN2=$5$l$F$$$?$i!"Nc30!"(B
		BIGNUM$BI=8=$H$7$F!">e0LB&MWAG$KM>J,$J#0%o!<%I$,$"$C$?$iNc30(B)
  A2   $B%l%8%9%?(B($BL$Dj5A$J$i!"%5%9%Z%s%I!#(B
		32$B%S%C%H%9%H%j%s%00J30$K6qBN2=$5$l$F$$$?$i!"Nc30!"(B
		BIGNUM$BI=8=$H$7$F!">e0LB&MWAG$KM>J,$J#0%o!<%I$,$"$C$?$iNc30(B)
  A3   $B%l%8%9%?(B($B=PNO!#(B)

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>

add_bignum(Xstr,Ystr,^Zstr)
        bignum + bignum = bignum

Xstr(BIGNUM)$B$H(BYstr(BIGNUM)$B$NOB$r<h$j(B
Zstr(BIGNUM)$B$H$9$k!#(B

<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_StrSrc1   _IndirectRegField1
#OPF_define I_StrSrc2   _IndirectRegField2
#OPF_define I_StrDst    _IndirectRegField3

#DATA_define D_WorkBignumStrLen1_Ilevel XXX
#DATA_define D_WorkBignumStrLen2_Ilevel XXX
#DATA_define D_WorkBignumElmSize XXX
#DATA_define D_WorkBignumFirstElm XXX

#PSL_define kblt_b_add_bignum(){
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp3ArgVect_IIO_Sub
	    (D_WorkArgVect,I_StrSrc1,I_StrSrc2,I_StrDst));
      f_TraceBodyBuiltin(BLT_B_ADD_BIGNUM,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  $USE(D_WorkDrfPtr);
  f_ActiveDeref(I_StrSrc1,D_WorkDrfPtr);
  s_IfStrings(I_StrSrc1){ /* src1 string */
    $USE(D_WorkBignumStrLen1_Ilevel);
    $USE(D_WorkBignumElmSize);
    s_GetStringType(I_StrSrc1,D_WorkBignumStrLen1_Ilevel,D_WorkBignumElmSize);
    b_IfNotEqualImm(D_WorkBignumElmSize,_BIGNUM_ELM_SIZE){ 
      $RELEASE(D_WorkBignumStrLen1_Ilevel); /* src1 not 32 bit string */
      $RELEASE(D_WorkBignumElmSize);
  $RELEASE(D_WorkDrfPtr);
      goto Exception_0;
    }else{ /* src1 32 bit string */
      f_ActiveDeref(I_StrSrc2,D_WorkDrfPtr);
      s_IfStrings(I_StrSrc2) { /* src2 string */
	$USE(D_WorkBignumStrLen2_Ilevel);
	$RELEASE(D_WorkDrfPtr);
	s_GetStringType(I_StrSrc2,D_WorkBignumStrLen2_Ilevel,
			D_WorkBignumElmSize);
	b_IfNotEqualImm(D_WorkBignumElmSize,_BIGNUM_ELM_SIZE){
	  $RELEASE(D_WorkBignumStrLen1_Ilevel); /* src2 not 32 bit string */
	  $RELEASE(D_WorkBignumStrLen2_Ilevel);
	  $RELEASE(D_WorkBignumElmSize);

	  goto Exception_1;
	}else{ /* src2 32 bit string */
	  $RELEASE(D_WorkBignumElmSize);
	  b_IfNotZero(D_WorkBignumStrLen1_Ilevel){
	    $USE(D_WorkBignumFirstElm);
	    s_GetStringWordPosReg(I_StrSrc1,D_NULL,D_WorkBignumFirstElm);
	    b_IfZero(D_WorkBignumFirstElm){ /* src1 leading zero element */
	      $RELEASE(D_WorkBignumFirstElm);
	      $RELEASE(D_WorkBignumStrLen1_Ilevel);
	      $RELEASE(D_WorkBignumStrLen2_Ilevel);
	      goto Exception_0;
	    }else{
	      $RELEASE(D_WorkBignumFirstElm);
	    }
	  }
	  b_IfNotZero(D_WorkBignumStrLen2_Ilevel){
	    $USE(D_WorkBignumFirstElm);
	    s_GetStringWordPosReg(I_StrSrc2,D_NULL,D_WorkBignumFirstElm);
	    b_IfZero(D_WorkBignumFirstElm){ /* src2 leading zero element */
	      $RELEASE(D_WorkBignumFirstElm);
	      $RELEASE(D_WorkBignumStrLen1_Ilevel);
	      $RELEASE(D_WorkBignumStrLen2_Ilevel);
	      goto Exception_1;
	    }else{
	      $RELEASE(D_WorkBignumFirstElm);
	    }
	  }

	  $CALL(f_Add_BIGNUM_Sub(I_StrSrc1,I_StrSrc2,
				 D_WorkBignumStrLen1_Ilevel,
				 D_WorkBignumStrLen2_Ilevel,
				 I_StrDst));

	  $RELEASE(D_WorkBignumStrLen1_Ilevel);
	  $RELEASE(D_WorkBignumStrLen2_Ilevel);

	  b_IfEOL(I_StrDst){ 
	    /* $B%R!<%WITB-$G=PNOMQ%9%H%j%s%0$,$H$l$J$+$C$?;~(B */
	    goto Suspend;
	  }
	  goto End_of_KL1B_Instruction;
	}
      }else{ /* src2 not string */
	$RELEASE(D_WorkBignumStrLen1_Ilevel);
	$RELEASE(D_WorkBignumElmSize);
      	s_IfUnbound(I_StrSrc2) { /* src2 unbound */
	  p_MoveWord(D_WorkDrfPtr, I_StrSrc2);
	  $RELEASE(D_WorkDrfPtr);
	  goto Suspend;
	}else{ /* src2 other type */
	  $RELEASE(D_WorkDrfPtr);
	  goto Exception_1;
	}
      }
    }
  }else{ /* src1 not string */
    s_IfUnbound(I_StrSrc1) { /* src1 unbound */
      p_MoveWord(D_WorkDrfPtr, I_StrSrc1);
      $RELEASE(D_WorkDrfPtr);
      goto Suspend;
    }else{ /* src1 other type */
      $RELEASE(D_WorkDrfPtr);
      goto Exception_0;
    }
  }

 Suspend:
  f_DcodeEnqueue3Ope_IIO(BLT_B_ADD_BIGNUM,I_StrSrc1,I_StrSrc2,I_StrDst);
  goto End_of_KL1B_Instruction;

 Exception_0:
  $USE(D_WorkExcepArgPos);
  b_SetImmTypeValueMRBoff (INT, _ZERO, D_WorkExcepArgPos);
  goto Exception_Common;

 Exception_1:
  $USE(D_WorkExcepArgPos);
  b_SetImmTypeValueMRBoff (INT, _ONE, D_WorkExcepArgPos);

 Exception_Common:
  $USE(D_WorkExceptionCode);
  b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
  $USE(D_WorkArithOpe);
  b_SetImmTypeValueMRBoff (INT, BLT_B_ADD_BIGNUM, D_WorkArithOpe);
  $CALL (f_Exception_3Arg_IIO_Sub (D_WorkExceptionCode, D_WorkArithOpe, 
				    D_WorkExcepArgPos, 
				    I_StrSrc1,I_StrSrc2,I_StrDst));
  $RELEASE(D_WorkArithOpe);
  $RELEASE (D_WorkExceptionCode);
  $RELEASE(D_WorkExcepArgPos);

 End_of_KL1B_Instruction: ;

}

/******************************************************************** PSL **
  $BB?G\D9@0?t(B(BIGNUM)$B1i;;(B

subtract_bignum A1 A2 A3 A4

  0            1            2            3            4
  +------------+------------+------------+------------+
  |  b_subtract_bignum      |     A1     |     A2     |
  +------------+------------+------------+------------+
  |    A3      |     A4     |       don't care        |
  +------------+------------+------------+------------+

<Arguments>
  A1   $B%l%8%9%?(B($BL$Dj5A$J$i!"%5%9%Z%s%I!#(B
		32$B%S%C%H%9%H%j%s%00J30$K6qBN2=$5$l$F$$$?$i!"Nc30!"(B
		BIGNUM$BI=8=$H$7$F!">e0LB&MWAG$KM>J,$J#0%o!<%I$,$"$C$?$iNc30(B)
  A2   $B%l%8%9%?(B($BL$Dj5A$J$i!"%5%9%Z%s%I!#(B
		32$B%S%C%H%9%H%j%s%00J30$K6qBN2=$5$l$F$$$?$i!"Nc30!"(B
		BIGNUM$BI=8=$H$7$F!">e0LB&MWAG$KM>J,$J#0%o!<%I$,$"$C$?$iNc30(B)
  A3   $B%l%8%9%?(B($B=PNO!#(B)
  A4   $B%l%8%9%?(B($B=PNO!#(B)

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>

subtract_bignum(Xstr,Ystr,^Zsign,^Zstr)
        bignum - bignum = sign * | bignum |
        Zsign = $BId9g(B
        Zstr = $B@dBPCM(B

Xstr(BIGNUM)$B$H(BYstr(BIGNUM)$B$N:9(B(Xstr-Ystr)$B$r<h$j(B
$B$=$N@dBPCM$r(BZstr(BIGNUM)$B$H$7!"Id9g$r(BZsign($B@0?t(B)$B$H$9$k!#(B

<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_StrSrc1   _IndirectRegField1
#OPF_define I_StrSrc2   _IndirectRegField2
#OPF_define I_IntDst    _IndirectRegField3
#OPF_define I_StrDst    _IndirectRegField4

#PSL_define kblt_b_subtract_bignum(){
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp4ArgVect_IIOO_Sub
	    (D_WorkArgVect,I_StrSrc1,I_StrSrc2,I_IntDst,I_StrDst));
      f_TraceBodyBuiltin(BLT_B_SUBTRACT_BIGNUM,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  $USE(D_WorkDrfPtr);
  f_ActiveDeref(I_StrSrc1,D_WorkDrfPtr);
  s_IfStrings(I_StrSrc1){ /* src1 string */
    $USE(D_WorkBignumStrLen1_Ilevel);
    $USE(D_WorkBignumElmSize);
    s_GetStringType(I_StrSrc1,D_WorkBignumStrLen1_Ilevel,D_WorkBignumElmSize);
    b_IfNotEqualImm(D_WorkBignumElmSize,_BIGNUM_ELM_SIZE){ 
      $RELEASE(D_WorkBignumStrLen1_Ilevel); /* src1 not 32 bit string */
      $RELEASE(D_WorkBignumElmSize);
      $RELEASE(D_WorkDrfPtr);
      goto Exception_0;
    }else{ /* src1 32 bit string */
      f_ActiveDeref(I_StrSrc2,D_WorkDrfPtr);
      s_IfStrings(I_StrSrc2) { /* src2 string */
	$RELEASE(D_WorkDrfPtr);
	$USE(D_WorkBignumStrLen2_Ilevel);
	s_GetStringType(I_StrSrc2,D_WorkBignumStrLen2_Ilevel,
			D_WorkBignumElmSize);
	b_IfNotEqualImm(D_WorkBignumElmSize,_BIGNUM_ELM_SIZE){
	  $RELEASE(D_WorkBignumStrLen1_Ilevel); /* src2 not 32 bit string */
	  $RELEASE(D_WorkBignumStrLen2_Ilevel);
	  $RELEASE(D_WorkBignumElmSize);
	  goto Exception_1;
	}else{ /* src2 32 bit string */
	  $RELEASE(D_WorkBignumElmSize);
	  b_IfNotZero(D_WorkBignumStrLen1_Ilevel){
	    $USE(D_WorkBignumFirstElm);
	    s_GetStringWordPosReg(I_StrSrc1,D_NULL,D_WorkBignumFirstElm);
	    b_IfZero(D_WorkBignumFirstElm){ /* src1 leading zero element */
	      $RELEASE(D_WorkBignumFirstElm);
	      $RELEASE(D_WorkBignumStrLen1_Ilevel);
	      $RELEASE(D_WorkBignumStrLen2_Ilevel);
	      goto Exception_0;
	    }else{
	      $RELEASE(D_WorkBignumFirstElm);
	    }
	  }
	  b_IfNotZero(D_WorkBignumStrLen2_Ilevel){
	    $USE(D_WorkBignumFirstElm);
	    s_GetStringWordPosReg(I_StrSrc2,D_NULL,D_WorkBignumFirstElm);
	    b_IfZero(D_WorkBignumFirstElm){ /* src2 leading zero element */
	      $RELEASE(D_WorkBignumFirstElm);
	      $RELEASE(D_WorkBignumStrLen1_Ilevel);
	      $RELEASE(D_WorkBignumStrLen2_Ilevel);
	      goto Exception_1;
	    }else{
	      $RELEASE(D_WorkBignumFirstElm);
	    }
	  }

	  $CALL(f_Subtract_BIGNUM_Sub(I_StrSrc1,I_StrSrc2,
				      D_WorkBignumStrLen1_Ilevel,
				      D_WorkBignumStrLen2_Ilevel,
				      I_IntDst,I_StrDst));

	  $RELEASE(D_WorkBignumStrLen1_Ilevel);
	  $RELEASE(D_WorkBignumStrLen2_Ilevel);

	  b_IfEOL(I_StrDst){ 
	    /* $B%R!<%WITB-$G=PNOMQ%9%H%j%s%0$,$H$l$J$+$C$?;~(B */
	    goto Suspend;
	  }
	  goto End_of_KL1B_Instruction;
	}
      }else{ /* src2 not string */
	$RELEASE(D_WorkBignumStrLen1_Ilevel);
	$RELEASE(D_WorkBignumElmSize);
      	s_IfUnbound(I_StrSrc2) { /* src2 unbound */
	  p_MoveWord(D_WorkDrfPtr, I_StrSrc2);
	  $RELEASE(D_WorkDrfPtr);
	  goto Suspend;
	}else{ /* src2 other type */
	  $RELEASE(D_WorkDrfPtr);
	  goto Exception_1;
	}
      }
    }
  }else{ /* src1 not string */
    s_IfUnbound(I_StrSrc1) { /* src1 unbound */
      p_MoveWord(D_WorkDrfPtr, I_StrSrc1);
      $RELEASE(D_WorkDrfPtr);
      goto Suspend;
    }else{ /* src1 other type */
      $RELEASE(D_WorkDrfPtr);
      goto Exception_0;
    }
  }

 Suspend:
  f_DcodeEnqueue4Ope_IIOO(BLT_B_SUBTRACT_BIGNUM,
			  I_StrSrc1,I_StrSrc2,I_IntDst,I_StrDst);
  goto End_of_KL1B_Instruction;

 Exception_0:
  $USE(D_WorkExcepArgPos);
  b_SetImmTypeValueMRBoff (INT, _ZERO, D_WorkExcepArgPos);
  goto Exception_Common;

 Exception_1:
  $USE(D_WorkExcepArgPos);
  b_SetImmTypeValueMRBoff (INT, _ONE, D_WorkExcepArgPos);

 Exception_Common:
  $USE(D_WorkExceptionCode);
  b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
  $USE(D_WorkArithOpe);
  b_SetImmTypeValueMRBoff (INT, BLT_B_SUBTRACT_BIGNUM, D_WorkArithOpe);
  $CALL (f_Exception_4Arg_IIOO_Sub (D_WorkExceptionCode, D_WorkArithOpe, 
				    D_WorkExcepArgPos, 
				    I_StrSrc1,I_StrSrc2,I_IntDst,I_StrDst));
  $RELEASE(D_WorkArithOpe);
  $RELEASE (D_WorkExceptionCode);
  $RELEASE(D_WorkExcepArgPos);

 End_of_KL1B_Instruction: ;
}

/******************************************************************** PSL **
  $BB?G\D9@0?t(B(BIGNUM)$B1i;;(B

multiply_bignum_by_word A1 A2 A3

  0            1            2            3            4
  +------------+------------+------------+------------+
  |b_multiply_bignum_by_word|     A1     |     A2     |
  +------------+------------+------------+------------+
  |    A3      |              don't care              |
  +------------+------------+------------+------------+

<Arguments>
  A1   $B%l%8%9%?(B($BL$Dj5A$J$i!"%5%9%Z%s%I!#(B
		32$B%S%C%H%9%H%j%s%00J30$K6qBN2=$5$l$F$$$?$i!"Nc30!"(B
		BIGNUM$BI=8=$H$7$F!">e0LB&MWAG$KM>J,$J#0%o!<%I$,$"$C$?$iNc30(B)
  A2   $B%l%8%9%?(B($BL$Dj5A$J$i!"%5%9%Z%s%I!#(B
	        INT$B0J30$K6qBN2=$5$l$F$$$?$i!"Nc30(B)
  A3   $B%l%8%9%?(B($B=PNO!#(B)
  A4   $B%l%8%9%?(B($B=PNO!#(B)

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>

multiply_bignum_by_word(Xstr,Y,^Zstr)
        bignum * unsigned int = bignum

Xstr(BIGNUM)$B$H(BY($B@0?t(B)$B$N@Q$r<h$j(B
Zstr(BIGNUM)$B$H$9$k!#(B

<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_StrSrc   _IndirectRegField1
#OPF_define I_IntSrc   _IndirectRegField2
#OPF_define I_StrDst   _IndirectRegField3

#PSL_define kblt_b_multiply_bignum_by_word(){

  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp3ArgVect_IIO_Sub
	    (D_WorkArgVect,I_StrSrc,I_IntSrc,I_StrDst));
      f_TraceBodyBuiltin(BLT_B_MULTIPLY_BIGNUM_BY_WORD,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  $USE(D_WorkDrfPtr);
  f_ActiveDeref(I_StrSrc,D_WorkDrfPtr);
  s_IfStrings(I_StrSrc){ /* src1 string */
    $USE(D_WorkBignumStrLen1_Ilevel);
    $USE(D_WorkBignumElmSize);
    s_GetStringType(I_StrSrc,D_WorkBignumStrLen1_Ilevel,D_WorkBignumElmSize);

    b_IfNotEqualImm(D_WorkBignumElmSize,_BIGNUM_ELM_SIZE){ 
      $RELEASE(D_WorkBignumStrLen1_Ilevel); /* src1 not 32 bit string */
      $RELEASE(D_WorkBignumElmSize);
      $RELEASE(D_WorkDrfPtr);
      goto Exception_0;
    }else{ /* src1 32 bit string */

      $RELEASE(D_WorkBignumElmSize);

      b_IfNotZero(D_WorkBignumStrLen1_Ilevel){
	$USE(D_WorkBignumFirstElm);
	s_GetStringWordPosReg(I_StrSrc,D_NULL,D_WorkBignumFirstElm);
	b_IfZero(D_WorkBignumFirstElm){ /* src1 leading zero element */
	  $RELEASE(D_WorkBignumFirstElm);
	  $RELEASE(D_WorkBignumStrLen1_Ilevel);
	  $RELEASE(D_WorkDrfPtr);
	  goto Exception_0;
	}else{
	  $RELEASE(D_WorkBignumFirstElm);
	}
      }

      f_ActiveDeref(I_IntSrc,D_WorkDrfPtr);
      s_IfINT(I_IntSrc) { /* src2 int */
	$RELEASE(D_WorkDrfPtr);
	
	$CALL(f_Multiply_BIGNUM_By_Word_Sub(I_StrSrc,I_IntSrc,
		      D_WorkBignumStrLen1_Ilevel,I_StrDst));

	$RELEASE(D_WorkBignumStrLen1_Ilevel);

	b_IfEOL(I_StrDst){ 
	  /* $B%R!<%WITB-$G=PNOMQ%9%H%j%s%0$,$H$l$J$+$C$?;~(B */
	  goto Suspend;
	}
	  goto End_of_KL1B_Instruction;
      }else{ /* src2 not int */
	$RELEASE(D_WorkBignumStrLen1_Ilevel);

	s_IfUnbound(I_IntSrc) { /* src2 unbound */
	  p_MoveWord(D_WorkDrfPtr, I_IntSrc);
	  $RELEASE(D_WorkDrfPtr);
	  goto Suspend;
	}else{ /* src2 other type */
	  $RELEASE(D_WorkDrfPtr);
	  goto Exception_1;
	}
      }
    }
  }else{ /* src1 not string */
    s_IfUnbound(I_StrSrc) { /* src1 unbound */
      p_MoveWord(D_WorkDrfPtr, I_StrSrc);
      $RELEASE(D_WorkDrfPtr);
      goto Suspend;
    }else{ /* src1 other type */
      $RELEASE(D_WorkDrfPtr);
      goto Exception_0;
    }
  }

 Suspend:
  f_DcodeEnqueue3Ope_IIO(BLT_B_MULTIPLY_BIGNUM_BY_WORD,
			 I_StrSrc,I_IntSrc,I_StrDst);
  goto End_of_KL1B_Instruction;

 Exception_0:
  $USE(D_WorkExcepArgPos);
  b_SetImmTypeValueMRBoff (INT, _ZERO, D_WorkExcepArgPos);
  goto Exception_Common;

 Exception_1:
  $USE(D_WorkExcepArgPos);
  b_SetImmTypeValueMRBoff (INT, _ONE, D_WorkExcepArgPos);

 Exception_Common:
  $USE(D_WorkExceptionCode);
  b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
  $USE(D_WorkArithOpe);
  b_SetImmTypeValueMRBoff (INT, BLT_B_MULTIPLY_BIGNUM_BY_WORD, D_WorkArithOpe);
  $CALL (f_Exception_3Arg_IIO_Sub (D_WorkExceptionCode, D_WorkArithOpe, 
				    D_WorkExcepArgPos, 
				    I_StrSrc,I_IntSrc,I_StrDst));
  $RELEASE(D_WorkArithOpe);
  $RELEASE (D_WorkExceptionCode);
  $RELEASE(D_WorkExcepArgPos);

 End_of_KL1B_Instruction: ;

}
