/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V10/interpreter/klb_body_blt_arith.psl.c
   ----- CREATED   : by yamamoto@icot22, on Mon Jun  4 19:25:57 1990
   ----- LAST SAVED: by imai@icot22, on Tue Jan 29 21:35:47 1991
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : INTERPRETER
   ----- ABSTRACT  : $B%\%G%#$N;;=Q!&O@M}1i;;4X78$NAH$_9~$_=R8l(B

  $B;;=Q!&O@M}1i;;4X78$NAH$_9~$_=R8l$G$O!"F~NO0z?t$,;XDj$N%?%$%W$G$J$$>l9g!"Nc30(B
$B$rH/@8$7$FAq1`$KCN$i$;$k!#$^$?!"F~NO0z?t$,L$Dj5A$N>l9g$O!"%5%9%Z%s%I$9$k!#(B
  $BNc30$r?FAq1`$N%l%]!<%H%9%H%j!<%`$K7R$2$kA`:n$O!"(B'f_error.psl.c' $BCf$KDj5A$5$l(B
$B$F$$$k(B 'f_Exception_NArg_XXXX_Sub' $B$K$h$C$F9T$o$l$k!#(B
  $B%\%G%#$N%5%9%Z%s%I$N=hM}$O!"(B'f_dcode_ope.psl.c' $BCf$KDj5A$5$l$F$$$k(B 'f_Dcode
SuspendXXX' $B$K$h$C$F9T$o$l$k!#(B
  $B=PNO0z?t$O!"AH$_9~$_=R8l$N=hM}%k!<%A%s$KF~$C$?CJ3,$G$OCM$,Dj$^$C$F$$$J$$!#(B
$B=PNO0z?t$O$3$N$"$H$NL?Na$K$h$C$F<B:]$N=PNO0z$-?t$H%f%K%U%!%$$5$l$k!#(B

$B$3$N%U%!%$%k$GDj5A$5$l$F$$$kAH$_9~$_=R8l(B

1. $B@0?tO@M}1i;;7OAH$_9~$_=R8l(B
#PSL_define kblt_b_integer_and() 
#PSL_define kblt_b_integer_or() 
#PSL_define kblt_b_integer_exclusive_or() 
#PSL_define kblt_b_integer_shift_left() 
#PSL_define kblt_b_integer_shift_right() 

2. $B@0?t;;=Q1i;;7OAH$_9~$_=R8l(B
#PSL_define kblt_b_integer_add() 
#PSL_define kblt_b_integer_subtract() 
#PSL_define kblt_b_integer_multiply() 
#PSL_define kblt_b_integer_divide() 
#PSL_define kblt_b_integer_modulo() 
#PSL_define kblt_b_integer_increment() 
#PSL_define kblt_b_integer_decrement() 
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */


#DATA_define  D_Workreg   XXX	/* $BL>A0$rJQ$($k!)(B */
#DATA_define  D_Workreg1  XXX
#DATA_define  D_Workreg2  XXX


/******************************************************************** PSL **

       written by yamamoto@icot22      on Mon Jun  4 19:31:30 1990

b_integer_add  A1 A2 A3


  0            1            2            3            4
  +------------+------------+------------+------------+
  |  b_integer_add          |     A1     |     A2     |
  +------------+------------+------------+------------+
  |    A3      |              don't care              |
  +------------+------------+------------+------------+

<Arguments>
  A1   $B%l%8%9%?(B($BL$Dj5A$J$i!"%5%9%Z%s%I!#@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30(B)
  A2   $B%l%8%9%?(B($BL$Dj5A$J$i!"%5%9%Z%s%I!#@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30(B)
  A3   $B%l%8%9%?(B($B@0?t=PNO(B)
<Temporally Used Variables>
<Level>        INTERPRETER
<PreCondition>
<Function>
  $B!&(BA1$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I$K$h$k%5%9%Z%s%I=hM}$r9T$$!"<!L?Na$r<B9T!#(B
    $B!&@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30=hM}!#(B
  $B!&(BA2$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I$K$h$k%5%9%Z%s%I=hM}$r9T$$!"<!L?Na$r<B9T!#(B
    $B!&@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30=hM}!#(B
  $B!&(BA1$B$H(BA2$B$r2C$($?CM$r!"(BA3$B$K=q$-9~$`!#(B
<Examples>
<Test>
<Explanation>
  $B!&%=!<%9%l%8%9%?$,L$Dj5A$N>l9g!"(BD$B%3!<%I$K$h$k%4!<%k$r@8@.$7!"(B
    $B%5%9%Z%s%I=hM}$r9T$&!#(B
  $B!&0l$DL\$N0z?t$G%5%9%Z%s%I$r5/$3$9>l9g$K!"Fs$DL\$N0z?t$O%A%'%C%/$7$J$$(B
<ETC>
<Revised Memo on "Dec  8">
<Revised Memo on "Jun 21">
********************************************************************* PSL **/

#DATA_define D_WorkExcepArgPos XXX

#OPF_define I_IntSrc1 _IndirectRegField1
#OPF_define I_IntSrc2 _IndirectRegField2
#OPF_define I_IntDst  _IndirectRegField3

#PSL_define kblt_b_integer_add ()
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp3ArgVect_IIO_Sub
	    (D_WorkArgVect,I_IntSrc1,I_IntSrc2,I_IntDst));
      f_TraceBodyBuiltin(BLT_B_INTEGER_ADD,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };
  s_IfINT (I_IntSrc1) {
    s_IfINT (I_IntSrc2) {
      b_AddWithTag(I_IntSrc1, I_IntSrc2, I_IntDst);
      p_IfOverflow() {                 /* $B8=:_$O%*!<%P!<%U%m!<$ONc30(B */
	$USE (D_WorkOpCode); $USE (D_WorkExceptionCode);
	$USE(D_WorkExcepArgPos);
	b_SetImmTypeValueMRBoff (INT, BLT_B_INTEGER_ADD, D_WorkOpCode);
	b_SetImmTypeValueMRBoff
	  (INT, _INTEGER_OVERFLOW_EXCP, D_WorkExceptionCode);
	p_MoveWord(D_NULL, D_WorkExcepArgPos);
	$CALL (f_Exception_3Arg_IIO_Sub (D_WorkExceptionCode, D_WorkOpCode, 
		 D_WorkExcepArgPos,I_IntSrc1, I_IntSrc2, I_IntDst) );
	$RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
	$RELEASE(D_WorkExcepArgPos);
      }
      goto End_of_KL1B_Instruction; /* end of KLB instruction */
    }
  }
  i_BodyBltArith3Arg (BLT_B_INTEGER_ADD, I_IntSrc1, I_IntSrc2, I_IntDst);
 End_of_KL1B_Instruction: ;
}

/******************************************************************** PSL **

       written by yamamoto@icot22      on Mon Jun  4 19:31:30 1990

b_integer_subtract  A1 A2 A3


  0         1            2            3           4
  +---------+------------+------------+-----------+
  | b_integer_subtract   |     A1     |     A2    |
  +---------+------------+------------+-----------+
  |   A3    |              don't care             |
  +---------+-------------------------------------+

<Arguments>
  A1   $B%l%8%9%?(B($BL$Dj5A$J$i!"%5%9%Z%s%I!#@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30(B)
  A2   $B%l%8%9%?(B($BL$Dj5A$J$i!"%5%9%Z%s%I!#@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30(B)
  A3   $B%l%8%9%?(B($B@0?t=PNO(B)
<Temporally Used Variables>
<Level>         INTERPRETER
<PreCondition>
<Function>
  $B!&(BA1$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I$K$h$k%5%9%Z%s%I=hM}$r9T$$!"<!L?Na$r<B9T!#(B
    $B!&@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30=hM}!#(B
  $B!&(BA2$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I$K$h$k%5%9%Z%s%I=hM}$r9T$$!"<!L?Na$r<B9T!#(B
    $B!&@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30=hM}!#(B
  $B!&(BA1$B$+$i(BA2$B$r0z$$$?CM$r!"(BA3$B$K=q$-9~$`!#(B
<Examples>
<Test>
<Explanation>
  $B!&%=!<%9%l%8%9%?$,L$Dj5A$N>l9g!"(BD$B%3!<%I$K$h$k%4!<%k$r@8@.$7!"(B
    $B%5%9%Z%s%I=hM}$r9T$&!#(B
  $B!&0l$DL\$N0z?t$G%5%9%Z%s%I$r5/$3$9>l9g$K!"Fs$DL\$N0z?t$O%A%'%C%/$7$J$$(B
<ETC>
********************************************************************* PSL **/

#OPF_define I_IntSrc1 _IndirectRegField1
#OPF_define I_IntSrc2 _IndirectRegField2
#OPF_define I_IntDst  _IndirectRegField3

#PSL_define kblt_b_integer_subtract ()
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp3ArgVect_IIO_Sub
	    (D_WorkArgVect,I_IntSrc1,I_IntSrc2,I_IntDst));
      f_TraceBodyBuiltin(BLT_B_INTEGER_SUBTRACT,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };
  s_IfINT (I_IntSrc1) {
    s_IfINT (I_IntSrc2) {
      b_SubtractWithTag(I_IntSrc1, I_IntSrc2, I_IntDst);
      p_IfOverflow() {                 /* $B8=:_$O%*!<%P!<%U%m!<$ONc30(B */
	$USE (D_WorkOpCode); $USE (D_WorkExceptionCode);
	$USE(D_WorkExcepArgPos);
	b_SetImmTypeValueMRBoff (INT, BLT_B_INTEGER_SUBTRACT, D_WorkOpCode);
	b_SetImmTypeValueMRBoff
	  (INT, _INTEGER_OVERFLOW_EXCP, D_WorkExceptionCode);
	p_MoveWord(D_NULL, D_WorkExcepArgPos);
	$CALL (f_Exception_3Arg_IIO_Sub(D_WorkExceptionCode, D_WorkOpCode, 
               D_WorkExcepArgPos, I_IntSrc1, I_IntSrc2, I_IntDst) );
	$RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
	$RELEASE(D_WorkExcepArgPos);
      }
      goto End_of_KL1B_Instruction;  /* end of KLB instruction */
    }
  }
  i_BodyBltArith3Arg (BLT_B_INTEGER_SUBTRACT, I_IntSrc1, I_IntSrc2, I_IntDst);
 End_of_KL1B_Instruction: ;
}

/******************************************************************** PSL **

       written by yamamoto@icot22      on Mon Jun  4 19:31:30 1990

b_integer_multiply  A1 A2 A3


  0            1            2            3            4
  +------------+------------+------------+------------+
  |   b_integer_multiply    |     A1     |     A2     |
  +------------+------------+------------+------------+
  |  	A3     |              don't care              |
  +------------+------------+------------+------------+

<Arguments>
  A1   $B%l%8%9%?(B($BL$Dj5A$J$i!"%5%9%Z%s%I!#@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30(B)
  A2   $B%l%8%9%?(B($BL$Dj5A$J$i!"%5%9%Z%s%I!#@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30(B)
  A3   $B%l%8%9%?(B($B@0?t=PNO(B)
<Temporally Used Variables>
<Level>         INTERPRETER
<PreCondition>
<Function>
  $B!&(BA1$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I$K$h$k%5%9%Z%s%I=hM}$r9T$$!"<!L?Na$r<B9T!#(B
    $B!&@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30=hM}!#(B
  $B!&(BA2$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I$K$h$k%5%9%Z%s%I=hM}$r9T$$!"<!L?Na$r<B9T!#(B
    $B!&@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30=hM}!#(B
  $B!&(BA1$B$H(BA2$B$r3]$1$?CM$r!"(BA3$B$K=q$-9~$`!#(B
<Examples>
<Test>
<Explanation>
  $B!&%=!<%9%l%8%9%?$,L$Dj5A$N>l9g!"(BD$B%3!<%I$K$h$k%4!<%k$r@8@.$7!"(B
    $B%5%9%Z%s%I=hM}$r9T$&!#(B
  $B!&0l$DL\$N0z?t$G%5%9%Z%s%I$r5/$3$9>l9g$K!"Fs$DL\$N0z?t$O%A%'%C%/$7$J$$(B
<ETC>
********************************************************************* PSL **/

#OPF_define I_IntSrc1 _IndirectRegField1
#OPF_define I_IntSrc2 _IndirectRegField2
#OPF_define I_IntDst  _IndirectRegField3

#PSL_define kblt_b_integer_multiply ()
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp3ArgVect_IIO_Sub
	    (D_WorkArgVect,I_IntSrc1,I_IntSrc2,I_IntDst));
      f_TraceBodyBuiltin(BLT_B_INTEGER_MULTIPLY,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };
  s_IfINT (I_IntSrc1) {
    s_IfINT (I_IntSrc2) {
      b_MultiplyWithTag(I_IntSrc1, I_IntSrc2, I_IntDst);
      p_IfOverflow() {                 /* $B8=:_$O%*!<%P!<%U%m!<$ONc30(B */
	$USE (D_WorkOpCode); $USE (D_WorkExceptionCode);
	$USE(D_WorkExcepArgPos);
	b_SetImmTypeValueMRBoff (INT, BLT_B_INTEGER_MULTIPLY, D_WorkOpCode);
	b_SetImmTypeValueMRBoff
	  (INT, _INTEGER_OVERFLOW_EXCP, D_WorkExceptionCode);
	p_MoveWord(D_NULL, D_WorkExcepArgPos);
	$CALL (f_Exception_3Arg_IIO_Sub(D_WorkExceptionCode, D_WorkOpCode, 
			D_WorkExcepArgPos,I_IntSrc1, I_IntSrc2, I_IntDst) );
	$RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
	$RELEASE(D_WorkExcepArgPos);
      }
      goto End_of_KL1B_Instruction; /* end of KLB instruction */
    }
  }
  i_BodyBltArith3Arg (BLT_B_INTEGER_MULTIPLY, I_IntSrc1, I_IntSrc2, I_IntDst);
 End_of_KL1B_Instruction: ;
}

/******************************************************************** PSL **

       written by yamamoto@icot22      on Mon Jun  4 19:31:30 1990

b_integer_divide  A1 A2 A3


  0            1            2            3            4
  +------------+------------+------------+------------+
  |    b_integer_divide     |     A1     |     A2     |
  +------------+------------+------------+------------+
  |  	A3     |              don't care              |
  +------------+------------+------------+------------+

<Arguments>
  A1   $B%l%8%9%?(B($BL$Dj5A$J$i!"%5%9%Z%s%I!#@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30(B)
  A2   $B%l%8%9%?(B($BL$Dj5A$J$i!"%5%9%Z%s%I!#@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30(B)
  A3   $B%l%8%9%?(B($B@0?t=PNO(B)
<Temporally Used Variables>
<Level>         INTERPRETER
<PreCondition>
<Function>
  $B!&(BA1$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I$K$h$k%5%9%Z%s%I=hM}$r9T$$!"<!L?Na$r<B9T!#(B
    $B!&@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30=hM}!#(B
  $B!&(BA2$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I$K$h$k%5%9%Z%s%I=hM}$r9T$$!"<!L?Na$r<B9T!#(B
    $B!&@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30=hM}!#(B
  $B!&(BA1$B$r(BA2$B$G3d$C$?CM(B($B>&(B)$B$r!"(BA3$B$K=q$-9~$`!#(B
<Examples>
<Test>
<Explanation>
  $B!&%=!<%9%l%8%9%?$,L$Dj5A$N>l9g!"(BD$B%3!<%I$K$h$k%4!<%k$r@8@.$7!"(B
    $B%5%9%Z%s%I=hM}$r9T$&!#(B
  $B!&0l$DL\$N0z?t$G%5%9%Z%s%I$r5/$3$9>l9g$K!"Fs$DL\$N0z?t$O%A%'%C%/$7$J$$(B
<ETC>
********************************************************************* PSL **/

#OPF_define I_IntSrc1 _IndirectRegField1
#OPF_define I_IntSrc2 _IndirectRegField2
#OPF_define I_IntDst  _IndirectRegField3

#PSL_define kblt_b_integer_divide ()
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp3ArgVect_IIO_Sub
	    (D_WorkArgVect,I_IntSrc1,I_IntSrc2,I_IntDst));
      f_TraceBodyBuiltin(BLT_B_INTEGER_DIVIDE,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };
  s_IfINT (I_IntSrc1) {
    s_IfINT (I_IntSrc2) {
      b_DivideWithTag(I_IntSrc1, I_IntSrc2, I_IntDst);
      p_IfZeroDivide() {                /* $B8=:_$O%<%m3d$j;;$ONc30(B */
	$USE (D_WorkExceptionCode);
	b_SetImmTypeValueMRBoff
	  (INT, _INTEGER_ZERO_DIVISION_EXCP, D_WorkExceptionCode);
	goto Exception;
      } else {
	p_IfOverflow() {                /* $B8=:_$O%*!<%P!<%U%m!<$ONc30(B */
	  $USE (D_WorkExceptionCode);
	  b_SetImmTypeValueMRBoff
	    (INT, _INTEGER_OVERFLOW_EXCP, D_WorkExceptionCode);
	  goto Exception;
	}
      }
      goto End_of_KL1B_Instruction; /* end of KLB instruction */
    }
  }
  i_BodyBltArith3Arg (BLT_B_INTEGER_DIVIDE, I_IntSrc1, I_IntSrc2, I_IntDst);
  goto End_of_KL1B_Instruction;
 Exception:
  $USE (D_WorkOpCode);
  $USE(D_WorkExcepArgPos);
  b_SetImmTypeValueMRBoff (INT, BLT_B_INTEGER_DIVIDE, D_WorkOpCode);
  p_MoveWord(D_NULL, D_WorkExcepArgPos); /* $B%<%m3d;;$N;~$O0z?t$,FCDj$G$-$k$,!"(B
                                            $B$3$l$G$bJ,$+$k$G$7$g(B */
  $CALL (f_Exception_3Arg_IIO_Sub (D_WorkExceptionCode, D_WorkOpCode, 
		D_WorkExcepArgPos, I_IntSrc1, I_IntSrc2, I_IntDst));
  $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
  $RELEASE(D_WorkExcepArgPos);
 End_of_KL1B_Instruction: ;
}

/******************************************************************** PSL **

       written by yamamoto@icot22      on Mon Jun  4 19:31:30 1990

b_integer_modulo  A1 A2 A3


  0            1            2            3            4
  +------------+------------+------------+------------+
  |    b_integer_modulo     |     A1     |     A2     |
  +------------+------------+------------+------------+
  |  	A3     |              don't care              |
  +------------+------------+------------+------------+

<Arguments>
  A1   $B%l%8%9%?(B($BL$Dj5A$J$i!"%5%9%Z%s%I!#@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30(B)
  A2   $B%l%8%9%?(B($BL$Dj5A$J$i!"%5%9%Z%s%I!#@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30(B)
  A3   $B%l%8%9%?(B($B@0?t=PNO(B)
<Temporally Used Variables>
<Level>         INTERPRETER
<PreCondition>
<Function>
  $B!&(BA1$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I$K$h$k%5%9%Z%s%I=hM}$r9T$$!"<!L?Na$r<B9T!#(B
    $B!&@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30=hM}!#(B
  $B!&(BA2$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I$K$h$k%5%9%Z%s%I=hM}$r9T$$!"<!L?Na$r<B9T!#(B
    $B!&@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30=hM}!#(B
  $B!&(BA1$B$r(BA2$B3d$C$?M>$j$r!"(BA3$B$K=q$-9~$`!#(B
<Examples>
<Test>
<Explanation>
  $B!&%=!<%9%l%8%9%?$,L$Dj5A$N>l9g!"(BD$B%3!<%I$K$h$k%4!<%k$r@8@.$7!"(B
    $B%5%9%Z%s%I=hM}$r9T$&!#(B
  $B!&0l$DL\$N0z?t$G%5%9%Z%s%I$r5/$3$9>l9g$K!"Fs$DL\$N0z?t$O%A%'%C%/$7$J$$(B
<ETC>
********************************************************************* PSL **/

#OPF_define I_IntSrc1 _IndirectRegField1
#OPF_define I_IntSrc2 _IndirectRegField2
#OPF_define I_IntDst  _IndirectRegField3

#PSL_define kblt_b_integer_modulo ()
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp3ArgVect_IIO_Sub
	    (D_WorkArgVect,I_IntSrc1,I_IntSrc2,I_IntDst));
      f_TraceBodyBuiltin(BLT_B_INTEGER_MODULO,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };
  s_IfINT (I_IntSrc1) {
    s_IfINT (I_IntSrc2) {
      b_ModuloWithTag(I_IntSrc1, I_IntSrc2, I_IntDst);
      p_IfZeroDivide() {               /* $B8=:_$O%<%m3d$j;;$ONc30(B */
	$USE (D_WorkExceptionCode);
	b_SetImmTypeValueMRBoff
	  (INT, _INTEGER_ZERO_DIVISION_EXCP, D_WorkExceptionCode);
	goto Exception;
      } else {
	p_IfOverflow() {               /* $B8=:_$O%*!<%P!<%U%m!<$ONc30(B */
	  $USE (D_WorkExceptionCode);
	  b_SetImmTypeValueMRBoff
	    (INT, _INTEGER_OVERFLOW_EXCP, D_WorkExceptionCode);
	  goto Exception;
	}
      }
      goto End_of_KL1B_Instruction; /* end of KLB instruction */
    }
  }
  i_BodyBltArith3Arg (BLT_B_INTEGER_MODULO, I_IntSrc1, I_IntSrc2, I_IntDst);
  goto End_of_KL1B_Instruction;
 Exception:
  $USE (D_WorkOpCode);
  $USE(D_WorkExcepArgPos);
  b_SetImmTypeValueMRBoff (INT, BLT_B_INTEGER_MODULO, D_WorkOpCode);
  p_MoveWord(D_NULL, D_WorkExcepArgPos);
  $CALL (f_Exception_3Arg_IIO_Sub (D_WorkExceptionCode, D_WorkOpCode, 
		D_WorkExcepArgPos, I_IntSrc1, I_IntSrc2, I_IntDst));
  $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
  $RELEASE(D_WorkExcepArgPos);
 End_of_KL1B_Instruction: ;
}

/******************************************************************** PSL **

       written by yamamoto@icot22      on Mon Jun  4 19:31:30 1990

b_integer_increment  A1 A2


  0            1            2            3            4
  +------------+------------+------------+------------+
  |  b_integer_increment    |     A1     |     A2     |
  +------------+------------+------------+------------+

<Arguments>
  A1   $B%l%8%9%?(B($BL$Dj5A$J$i!"%5%9%Z%s%I!#@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30(B)
  A2   $B%l%8%9%?(B($B@0?t=PNO(B)
<Temporally Used Variables>
<Level>        INTERPRETER
<PreCondition>
<Function>
  $B!&(BA1$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I$K$h$k%5%9%Z%s%I=hM}$r9T$$!"<!L?Na$r<B9T!#(B
    $B!&@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30=hM}!#(B
  $B!&(BA1$B$K(B1$B$r2C$($?CM$r!"(BA2$B$K=q$-9~$`!#(B
<Examples>
<Test>
<Explanation>
  $B!&%=!<%9%l%8%9%?$,L$Dj5A$N>l9g!"(BD$B%3!<%I$K$h$k%4!<%k$r@8@.$7!"(B
    $B%5%9%Z%s%I=hM}$r9T$&!#(B
<ETC>
********************************************************************* PSL **/

#OPF_define I_IntSrc  _IndirectRegField1
#OPF_define I_IntDst  _IndirectRegField2

#PSL_define kblt_b_integer_increment ()
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp2ArgVect_IO_Sub(D_WorkArgVect,I_IntSrc,I_IntDst));
      f_TraceBodyBuiltin(BLT_B_INTEGER_INCREMENT,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };
  s_IfINT (I_IntSrc) {
    b_AddImmediateWithTag(I_IntSrc, _ONE, I_IntDst);
    p_IfOverflow() {                 /* $B8=:_$O%*!<%P!<%U%m!<$ONc30(B */
      $USE (D_WorkOpCode); $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, BLT_B_INTEGER_INCREMENT, D_WorkOpCode);
      b_SetImmTypeValueMRBoff(INT,_INTEGER_OVERFLOW_EXCP, D_WorkExceptionCode);
      p_MoveWord(D_NULL, D_WorkExcepArgPos);
      $CALL (f_Exception_2Arg_IO_Sub (D_WorkExceptionCode, D_WorkOpCode, 
			D_WorkExcepArgPos, I_IntSrc, I_IntDst) );
      $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
      $RELEASE(D_WorkExcepArgPos);
    }
    goto End_of_KL1B_Instruction; /* end of KLB instruction */
  }
  i_BodyBltArith2Arg (BLT_B_INTEGER_INCREMENT, I_IntSrc, I_IntDst);
 End_of_KL1B_Instruction: ;
}

/******************************************************************** PSL **

       written by yamamoto@icot22      on Mon Jun  4 19:31:30 1990

b_integer_decrement  A1 A2


  0            1            2            3            4
  +------------+------------+------------+------------+
  |  b_integer_decrement    |     A1     |     A2     |
  +------------+------------+------------+------------+

<Arguments>
  A1   $B%l%8%9%?(B($BL$Dj5A$J$i!"%5%9%Z%s%I!#@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30(B)
  A2   $B%l%8%9%?(B($B@0?t=PNO(B)
<Temporally Used Variables>
<Level>        INTERPRETER
<PreCondition>
<Function>
  $B!&(BA1$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I$K$h$k%5%9%Z%s%I=hM}$r9T$$!"<!L?Na$r<B9T!#(B
    $B!&@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30=hM}!#(B
  $B!&(BA1$B$+$i(B1$B$r8:$8$?CM$r!"(BA2$B$K=q$-9~$`!#(B
<Examples>
<Test>
<Explanation>
  $B!&%=!<%9%l%8%9%?$,L$Dj5A$N>l9g!"(BD$B%3!<%I$K$h$k%4!<%k$r@8@.$7!"(B
    $B%5%9%Z%s%I=hM}$r9T$&!#(B
<ETC>
********************************************************************* PSL **/

#OPF_define I_IntSrc  _IndirectRegField1
#OPF_define I_IntDst  _IndirectRegField2

#PSL_define kblt_b_integer_decrement ()
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp2ArgVect_IO_Sub(D_WorkArgVect,I_IntSrc,I_IntDst));
      f_TraceBodyBuiltin(BLT_B_INTEGER_DECREMENT,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };
  s_IfINT (I_IntSrc) {
    b_SubtractImmediateWithTag(I_IntSrc, _ONE, I_IntDst);
    p_IfOverflow() {                 /* $B8=:_$O%*!<%P!<%U%m!<$ONc30(B */
      $USE (D_WorkOpCode); $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, BLT_B_INTEGER_DECREMENT, D_WorkOpCode);
      b_SetImmTypeValueMRBoff (INT,_INTEGER_OVERFLOW_EXCP,D_WorkExceptionCode);
      p_MoveWord(D_NULL, D_WorkExcepArgPos);
      $CALL (f_Exception_2Arg_IO_Sub(D_WorkExceptionCode, D_WorkOpCode, 
			D_WorkExcepArgPos, I_IntSrc, I_IntDst) );
      $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
      $RELEASE(D_WorkExcepArgPos);
    }
    goto End_of_KL1B_Instruction; /* end of KLB instruction */
  }
  i_BodyBltArith2Arg (BLT_B_INTEGER_DECREMENT, I_IntSrc, I_IntDst);
 End_of_KL1B_Instruction: ;
}

/******************************************************************** PSL **

       written by yamamoto@icot22      on Mon Jun  4 19:31:30 1990

b_integer_shift_left  A1 A2 A3


  0            1            2            3            4
  +------------+------------+------------+------------+
  |   b_integer_shift_left  |     A1     |     A2     |
  +------------+------------+------------+------------+
  |  	A3     |              don't care              |
  +------------+------------+------------+------------+

<Arguments>
  A1   $B%l%8%9%?(B($BL$Dj5A$J$i!"%5%9%Z%s%I!#@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30(B)
  A2   $B%l%8%9%?(B($BL$Dj5A$J$i!"%5%9%Z%s%I!#@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30(B)
  A3   $B%l%8%9%?(B($B@0?t=PNO(B)
<Temporally Used Variables>
<Level>         INTERPRETER
<PreCondition>
<Function>
  $B!&(BA1$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I$K$h$k%5%9%Z%s%I=hM}$r9T$$!"<!L?Na$r<B9T!#(B
    $B!&@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30=hM}!#(B
  $B!&(BA2$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I$K$h$k%5%9%Z%s%I=hM}$r9T$$!"<!L?Na$r<B9T!#(B
    $B!&@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30=hM}!#(B
  $B!&(BA2$B$,(B32$B0J>e$NCM$J$i$P!"F~NOHO0O30$NNc30$rH/@8(B
  $B!&(BA1$B$r(BA2$B$@$1:8%7%U%H$7$?CM$r!"(BA3$B$K=q$-9~$`!#(B
<Examples>
<Test>
<Explanation>
  $B!&%=!<%9%l%8%9%?$,L$Dj5A$N>l9g!"(BD$B%3!<%I$K$h$k%4!<%k$r@8@.$7!"(B
    $B%5%9%Z%s%I=hM}$r9T$&!#(B
  $B!&0l$DL\$N0z?t$G%5%9%Z%s%I$r5/$3$9>l9g$K!"Fs$DL\$N0z?t$O%A%'%C%/$7$J$$(B
<ETC>
********************************************************************* PSL **/

#CONST_define  _WordLength  32    /* bits */

#OPF_define I_IntSrc1 _IndirectRegField1
#OPF_define I_IntSrc2 _IndirectRegField2
#OPF_define I_IntDst  _IndirectRegField3

#PSL_define kblt_b_integer_shift_left ()
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp3ArgVect_IIO_Sub
	    (D_WorkArgVect,I_IntSrc1,I_IntSrc2,I_IntDst));
      f_TraceBodyBuiltin(BLT_B_INTEGER_SHIFT_LEFT,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };
  s_IfINT (I_IntSrc1) {
    s_IfINT (I_IntSrc2) {
      b_IfGreaterEqImm (I_IntSrc2, _WordLength) {
	$USE(D_WorkExcepArgPos);
	b_SetImmTypeValueMRBoff(INT, _ONE, D_WorkExcepArgPos);
	goto Exception;
      }
      b_IfLess (I_IntSrc2, D_NULL) {
	$USE(D_WorkExcepArgPos);
	b_SetImmTypeValueMRBoff(INT, _ONE, D_WorkExcepArgPos);	
	goto Exception;
      }
      b_ShiftLeftWithTag (I_IntSrc1, I_IntSrc2, I_IntDst);
      goto End_of_KL1B_Instruction; /* end of KLB instruction */
    }
  }
  i_BodyBltArith3Arg(BLT_B_INTEGER_SHIFT_LEFT, I_IntSrc1, I_IntSrc2, I_IntDst);
  goto End_of_KL1B_Instruction;
 Exception:
  $USE (D_WorkOpCode); $USE (D_WorkExceptionCode);
  b_SetImmTypeValueMRBoff (INT, BLT_B_INTEGER_SHIFT_LEFT, D_WorkOpCode);
  b_SetImmTypeValueMRBoff (INT, _RANGE_OVERFLOW_EXCP, D_WorkExceptionCode);
  $CALL (f_Exception_3Arg_IIO_Sub(D_WorkExceptionCode, D_WorkOpCode, 
		D_WorkExcepArgPos,  I_IntSrc1, I_IntSrc2, I_IntDst) );
  $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
  $RELEASE(D_WorkExcepArgPos);
 End_of_KL1B_Instruction: ;
}

/******************************************************************** PSL **

       written by yamamoto@icot22      on Mon Jun  4 19:31:30 1990

b_integer_shift_right  A1 A2 A3


  0            1            2            3            4
  +------------+------------+------------+------------+
  |  b_integer_shift_right  |     A1     |     A2     |
  +------------+------------+------------+------------+
  |  	A3     |              don't care              |
  +------------+------------+------------+------------+

<Arguments>
  A1   $B%l%8%9%?(B($BL$Dj5A$J$i!"%5%9%Z%s%I!#@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30(B)
  A2   $B%l%8%9%?(B($BL$Dj5A$J$i!"%5%9%Z%s%I!#@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30(B)
  A3   $B%l%8%9%?(B($B@0?t=PNO(B)
<Temporally Used Variables>
<Level>        INTERPRETER
<PreCondition>
<Function>
  $B!&(BA1$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I$K$h$k%5%9%Z%s%I=hM}$r9T$$!"<!L?Na$r<B9T!#(B
    $B!&@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30=hM}!#(B
  $B!&(BA2$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I$K$h$k%5%9%Z%s%I=hM}$r9T$$!"<!L?Na$r<B9T!#(B
    $B!&@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30=hM}!#(B
  $B!&(BA2$B$,(B32$B0J>e$NCM$J$i$P!"F~NOHO0O30$NNc30$rH/@8(B
  $B!&(BA1$B$r(BA2$B$@$11&%7%U%H$7$?CM$r!"(BA3$B$K=q$-9~$`!#(B
<Examples>
<Test>
<Explanation>
  $B!&%=!<%9%l%8%9%?$,L$Dj5A$N>l9g!"(BD$B%3!<%I$K$h$k%4!<%k$r@8@.$7!"(B
    $B%5%9%Z%s%I=hM}$r9T$&!#(B
  $B!&0l$DL\$N0z?t$G%5%9%Z%s%I$r5/$3$9>l9g$K!"Fs$DL\$N0z?t$O%A%'%C%/$7$J$$(B
<ETC>
********************************************************************* PSL **/

#OPF_define I_IntSrc1 _IndirectRegField1
#OPF_define I_IntSrc2 _IndirectRegField2
#OPF_define I_IntDst  _IndirectRegField3

#PSL_define kblt_b_integer_shift_right ()
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp3ArgVect_IIO_Sub
	    (D_WorkArgVect,I_IntSrc1,I_IntSrc2,I_IntDst));
      f_TraceBodyBuiltin(BLT_B_INTEGER_SHIFT_RIGHT,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  s_IfINT (I_IntSrc1) {
    s_IfINT (I_IntSrc2) {
      b_IfGreaterEqImm (I_IntSrc2, _WordLength) {
	$USE(D_WorkExcepArgPos);
	b_SetImmTypeValueMRBoff(INT, _ONE, D_WorkExcepArgPos);
	goto Exception;
      }
      b_IfLess (I_IntSrc2, D_NULL) {
	$USE(D_WorkExcepArgPos);
	b_SetImmTypeValueMRBoff(INT, _ONE, D_WorkExcepArgPos);
	goto Exception;
      }
      b_ShiftRightWithTag (I_IntSrc1, I_IntSrc2, I_IntDst);
      goto End_of_KL1B_Instruction; /* end of KLB instruction */
    }
  }
  i_BodyBltArith3Arg(BLT_B_INTEGER_SHIFT_RIGHT,I_IntSrc1, I_IntSrc2, I_IntDst);
  goto End_of_KL1B_Instruction;
 Exception:
  $USE (D_WorkOpCode); $USE (D_WorkExceptionCode);
  b_SetImmTypeValueMRBoff (INT, BLT_B_INTEGER_SHIFT_RIGHT, D_WorkOpCode);
  b_SetImmTypeValueMRBoff (INT, _RANGE_OVERFLOW_EXCP, D_WorkExceptionCode);
  $CALL (f_Exception_3Arg_IIO_Sub(D_WorkExceptionCode, D_WorkOpCode, 
		D_WorkExcepArgPos,  I_IntSrc1, I_IntSrc2, I_IntDst) );
  $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
  $RELEASE(D_WorkExcepArgPos);
 End_of_KL1B_Instruction: ;
}

/******************************************************************** PSL **

       written by yamamoto@icot22      on Mon Jun  4 19:31:30 1990

b_integer_and  A1 A2 A3


  0            1            2            3            4
  +------------+------------+------------+------------+
  |  b_integer_and          |     A1     |     A2     |
  +------------+------------+------------+------------+
  |  	A3     |              don't care              |
  +------------+------------+------------+------------+

<Arguments>
  A1   $B%l%8%9%?(B($BL$Dj5A$J$i!"%5%9%Z%s%I!#@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30(B)
  A2   $B%l%8%9%?(B($BL$Dj5A$J$i!"%5%9%Z%s%I!#@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30(B)
  A3   $B%l%8%9%?(B($B@0?t=PNO(B)

<Temporally Used Variables>
<Level>         INTERPRETER
<PreCondition>
<Function>
  $B!&(BA1$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I$K$h$k%5%9%Z%s%I=hM}$r9T$$!"<!L?Na$r<B9T!#(B
    $B!&@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30=hM}!#(B
  $B!&(BA2$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I$K$h$k%5%9%Z%s%I=hM}$r9T$$!"<!L?Na$r<B9T!#(B
    $B!&@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30=hM}!#(B
  $B!&(BA1$B$H(BA2$B$NO@M}@Q$r!"(BA3$B$K=q$-9~$`!#(B
<Examples>
<Test>
<Explanation>
  $B!&%=!<%9%l%8%9%?$,L$Dj5A$N>l9g!"(BD$B%3!<%I$K$h$k%4!<%k$r@8@.$7!"(B
    $B%5%9%Z%s%I=hM}$r9T$&!#(B
  $B!&0l$DL\$N0z?t$G%5%9%Z%s%I$r5/$3$9>l9g$K!"Fs$DL\$N0z?t$O%A%'%C%/$7$J$$(B
<ETC>
********************************************************************* PSL **/

#OPF_define I_IntSrc1 _IndirectRegField1
#OPF_define I_IntSrc2 _IndirectRegField2
#OPF_define I_IntDst  _IndirectRegField3

#PSL_define kblt_b_integer_and ()
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp3ArgVect_IIO_Sub
	    (D_WorkArgVect,I_IntSrc1,I_IntSrc2,I_IntDst));
      f_TraceBodyBuiltin(BLT_B_INTEGER_AND,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  s_IfINT (I_IntSrc1) {
    s_IfINT (I_IntSrc2) {
      b_BitwiseAndWithTag(I_IntSrc1, I_IntSrc2, I_IntDst);
      goto End_of_KL1B_Instruction; /* end of KLB instruction */
    }
  }
  i_BodyBltArith3Arg (BLT_B_INTEGER_AND, I_IntSrc1, I_IntSrc2, I_IntDst);
 End_of_KL1B_Instruction: ;
}

/******************************************************************** PSL **

       written by yamamoto@icot22      on Mon Jun  4 19:31:30 1990

b_integer_or  A1 A2 A3


  0            1            2            3            4
  +------------+------------+------------+------------+
  |   b_integer_or          |     A1     |     A2     |
  +------------+------------+------------+------------+
  |  	A3     |              don't care              |
  +------------+------------+------------+------------+

<Arguments>
  A1   $B%l%8%9%?(B($BL$Dj5A$J$i!"%5%9%Z%s%I!#@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30(B)
  A2   $B%l%8%9%?(B($BL$Dj5A$J$i!"%5%9%Z%s%I!#@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30(B)
  A3   $B%l%8%9%?(B($B@0?t=PNO(B)
<Temporally Used Variables>
<Level>         INTERPRETER
<PreCondition>
<Function>
  $B!&(BA1$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I$K$h$k%5%9%Z%s%I=hM}$r9T$$!"<!L?Na$r<B9T!#(B
    $B!&@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30=hM}!#(B
  $B!&(BA2$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I$K$h$k%5%9%Z%s%I=hM}$r9T$$!"<!L?Na$r<B9T!#(B
    $B!&@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30=hM}!#(B
  $B!&(BA1$B$H(BA2$B$NO@M}OB$r!"(BA3$B$K=q$-9~$`!#(B
<Examples>
<Test>
<Explanation>
  $B!&%=!<%9%l%8%9%?$,L$Dj5A$N>l9g!"(BD$B%3!<%I$K$h$k%4!<%k$r@8@.$7!"(B
    $B%5%9%Z%s%I=hM}$r9T$&!#(B
  $B!&0l$DL\$N0z?t$G%5%9%Z%s%I$r5/$3$9>l9g$K!"Fs$DL\$N0z?t$O%A%'%C%/$7$J$$(B
<ETC>
********************************************************************* PSL **/

#OPF_define I_IntSrc1 _IndirectRegField1
#OPF_define I_IntSrc2 _IndirectRegField2
#OPF_define I_IntDst  _IndirectRegField3

#PSL_define kblt_b_integer_or ()
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp3ArgVect_IIO_Sub
	    (D_WorkArgVect,I_IntSrc1,I_IntSrc2,I_IntDst));
      f_TraceBodyBuiltin(BLT_B_INTEGER_OR,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  s_IfINT (I_IntSrc1) {
    s_IfINT (I_IntSrc2) {
      b_BitwiseOrWithTag(I_IntSrc1, I_IntSrc2, I_IntDst);
      goto End_of_KL1B_Instruction; /* end of KLB instruction */
    }
  }
  i_BodyBltArith3Arg (BLT_B_INTEGER_OR, I_IntSrc1, I_IntSrc2, I_IntDst);
 End_of_KL1B_Instruction: ;
}

/******************************************************************** PSL **

       written by yamamoto@icot22      on Mon Jun  4 19:31:30 1990

b_integer_exclusive_or  A1 A2 A3


  0            1            2            3            4
  +------------+------------+------------+------------+
  | b_integer_exclusive_or  |     A1     |     A2     |
  +------------+------------+------------+------------+
  |  	A3     |              don't care              |
  +------------+------------+------------+------------+

<Arguments>
  A1   $B%l%8%9%?(B($BL$Dj5A$J$i!"%5%9%Z%s%I!#@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30(B)
  A2   $B%l%8%9%?(B($BL$Dj5A$J$i!"%5%9%Z%s%I!#@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30(B)
  A3   $B%l%8%9%?(B($B@0?t=PNO(B)
<Temporally Used Variables>
<Level>         INTERPRETER
<PreCondition>
<Function>
  $B!&(BA1$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I$K$h$k%5%9%Z%s%I=hM}$r9T$$!"<!L?Na$r<B9T!#(B
    $B!&@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30=hM}!#(B
  $B!&(BA2$B$r%G%l%U%!%l%s%9$7!"(B
    $B!&L$Dj5A$J$i!"(BD$B%3!<%I$K$h$k%5%9%Z%s%I=hM}$r9T$$!"<!L?Na$r<B9T!#(B
    $B!&@0?t0J30$K6qBN2=$5$l$F$$$?$i!"Nc30=hM}!#(B
  $B!&(BA1$B$H(BA2$B$NGSB>E*O@M}OB$r!"(BA3$B$K=q$-9~$`!#(B
<Examples>
<Test>
<Explanation>
  $B!&%=!<%9%l%8%9%?$,L$Dj5A$N>l9g!"(BD$B%3!<%I$K$h$k%4!<%k$r@8@.$7!"(B
    $B%5%9%Z%s%I=hM}$r9T$&!#(B
  $B!&0l$DL\$N0z?t$G%5%9%Z%s%I$r5/$3$9>l9g$K!"Fs$DL\$N0z?t$O%A%'%C%/$7$J$$(B
<ETC>
********************************************************************* PSL **/

#OPF_define I_IntSrc1 _IndirectRegField1
#OPF_define I_IntSrc2 _IndirectRegField2
#OPF_define I_IntDst  _IndirectRegField3

#PSL_define kblt_b_integer_exclusive_or ()
{
  @TRACE{
    f_IfTraceMode() {
      $USE(D_WorkArgVect);
      $CALL(f_MakeExcp3ArgVect_IIO_Sub
	    (D_WorkArgVect,I_IntSrc1,I_IntSrc2,I_IntDst));
      f_TraceBodyBuiltin(BLT_B_INTEGER_EXCLUSIVE_OR,D_WorkArgVect);
      $RELEASE(D_WorkArgVect);
      goto End_of_KL1B_Instruction;
    }
  };

  s_IfINT (I_IntSrc1) {
    s_IfINT (I_IntSrc2) {
      b_BitwiseEorWithTag(I_IntSrc1, I_IntSrc2, I_IntDst);
      goto End_of_KL1B_Instruction; /* end of KLB instruction */
    }
  }
  i_BodyBltArith3Arg (BLT_B_INTEGER_EXCLUSIVE_OR, I_IntSrc1, I_IntSrc2, I_IntDst);
 End_of_KL1B_Instruction: ;
}

/******************************************************************** PSL **

       written by yamamoto@icot22      on Mon Jun  4 19:31:30 1990

$B;;=QO@M}1i;;$N%5%V%k!<%A%s8F$S=P$7$N=`Hw(B (2$B0z?t(B, 3$B0z?t(B)

<Arguments>
  imm_ope : $B1i;;<oN`(B
  src :
  src1 :
  src2 :
  dst :
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define i_BodyBltArith2Arg(imm_ope, src, dst)
{
  $USE(D_WorkArithOpe);
  b_SetImmTypeValueMRBoff (INT, imm_ope, D_WorkArithOpe);
  $CALL( i_BodyBltArith2Arg_Sub (D_WorkArithOpe, src, dst) );
  $RELEASE(D_WorkArithOpe);
}

#PSL_define i_BodyBltArith3Arg(imm_ope, src1, src2, dst)
{
  $USE(D_WorkArithOpe);
  b_SetImmTypeValueMRBoff (INT, imm_ope, D_WorkArithOpe);
  $CALL( i_BodyBltArith3Arg_Sub (D_WorkArithOpe, src1, src2, dst) );
  $RELEASE(D_WorkArithOpe);
}

/******************************************************************** PSL **

       written by yamamoto@icot22      on Mon Jun  4 19:31:30 1990

$B;;=QO@M}1i;;$N%5%V%k!<%A%s8F$S=P$7(B (2$B0z?t(B)

<Arguments>
  A_ArithOpe : $B1i;;<o(B
  A_Arg0 : $B0z?t(B (source)
  A_Arg1 : $B0z?t(B (dest)
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#SUBARG_define	A_ArithOpe	SRC
#SUBARG_define	A_Arg0		MODIFY
#SUBARG_define	A_Arg1		DST

#SUBROUTINE i_BodyBltArith2Arg_Sub(A_ArithOpe,A_Arg0,A_Arg1)
{
  $USE(D_WorkDrfPtr);
  f_ActiveDeref(A_Arg0,D_WorkDrfPtr);
  s_IfINT(A_Arg0) {/* $BBh0l0z?t$,(BINT$B$N>l9g(B */
    i_ExecuteBodyArith2Arg (A_ArithOpe,A_Arg0,A_Arg1);
  } else {
    s_IfUnbound(A_Arg0) {
      p_MoveWord(D_WorkDrfPtr, A_Arg0);
      f_DcodeEnqueue2Ope_IO_Reg(A_ArithOpe,A_Arg0,A_Arg1);
	  /* $BBh0l0z?t$,L$Dj5A$N>l9g(BD$B%3!<%I$K$h$k%4!<%k%l%3!<%I$r:n$j(B
             $BL$Dj5AJQ?t$K(BHOOK$B$5$;$k(B */
    } else {
      $USE (D_WorkExceptionCode);
      $USE(D_WorkExcepArgPos);
      b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
      b_SetImmTypeValueMRBoff (INT, _ZERO, D_WorkExcepArgPos);
      $CALL (f_Exception_2Arg_IO_Sub(D_WorkExceptionCode, A_ArithOpe, 
				     D_WorkExcepArgPos, A_Arg0, A_Arg1) );
      $RELEASE (D_WorkExceptionCode);
      $RELEASE(D_WorkExcepArgPos);
    }
  }
  $RELEASE(D_WorkDrfPtr);
  $RETURN ();
}

/******************************************************************** PSL **

       written by yamamoto@icot22      on Mon Jun  4 19:31:30 1990

$B;;=QO@M}1i;;$N%5%V%k!<%A%s8F$S=P$7(B (3$B0z?t(B)

<Arguments>
  A_ArithOpe : $B1i;;<o(B
  A_Arg0 : $B0z?t(B (source)
  A_Arg1 : $B0z?t(B (source)
  A_Arg2 : $B0z?t(B (dest)
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
  $B%3!<%INL@aLs$N$?$a$K%;%3%$$3$H$r$7$?$i%"%;%s%V%i$_$?$$$K$J$C$A$c$C$?!#(B
  $B$G$b!"B.$$$H;W$&$h!#(B(imai)
********************************************************************* PSL **/

#SUBARG_define	A_ArithOpe	SRC
#SUBARG_define	A_Arg0		MODIFY
#SUBARG_define	A_Arg1		MODIFY
#SUBARG_define	A_Arg2		DST

#SUBROUTINE i_BodyBltArith3Arg_Sub (A_ArithOpe, A_Arg0, A_Arg1, A_Arg2)
{
  $USE(D_WorkDrfPtr);
  f_ActiveDeref(A_Arg0,D_WorkDrfPtr);
  s_IfINT(A_Arg0) { 		/* $BBh0l0z?t$,(BINT$B$N>l9g(B */
    f_ActiveDeref(A_Arg1,D_WorkDrfPtr);
    s_IfINT(A_Arg1) {		/* $BBhFs0z?t$,(BINT$B$N>l9g(B  */
      $RELEASE(D_WorkDrfPtr);
      i_ExecuteBodyArith3Arg(A_ArithOpe,A_Arg0,A_Arg1,A_Arg2);
      $RETURN();
    } else {
      s_IfUnbound(A_Arg1) {
	p_MoveWord(D_WorkDrfPtr, A_Arg1);
	goto Suspend;
      } else {
	goto Exception_1;
      }
    }
  } else { /* $BBh0l0z?t$,(BINT$B0J30$N>l9g(B */
    s_IfUnbound(A_Arg0) {
      p_MoveWord(D_WorkDrfPtr, A_Arg0);
      goto Suspend;
    } else {
      goto Exception_0;
    }
  }
 Suspend:
  $RELEASE(D_WorkDrfPtr);
  f_DcodeEnqueue3Ope_IIO_Reg(A_ArithOpe,A_Arg0,A_Arg1,A_Arg2);
  $RETURN();
 Exception_0:
  $RELEASE(D_WorkDrfPtr);
  $USE(D_WorkExcepArgPos);
  b_SetImmTypeValueMRBoff (INT, _ZERO, D_WorkExcepArgPos);
  goto Exception_Common;
 Exception_1:
  $RELEASE(D_WorkDrfPtr);
  $USE(D_WorkExcepArgPos);
  b_SetImmTypeValueMRBoff (INT, _ONE, D_WorkExcepArgPos);
 Exception_Common:
  $USE(D_WorkExceptionCode);
  b_SetImmTypeValueMRBoff (INT, _ILLEGAL_INPUT_EXCP, D_WorkExceptionCode);
  $CALL (f_Exception_3Arg_IIO_Sub (D_WorkExceptionCode, A_ArithOpe, 
				   D_WorkExcepArgPos, A_Arg0, A_Arg1, A_Arg2));
  $RELEASE (D_WorkExceptionCode);
  $RELEASE(D_WorkExcepArgPos);
  $RETURN ();
}

/******************************************************************** PSL **

       written by yamamoto@icot22      on Mon Jun  4 19:31:30 1990

$B;;=QO@M}1i;;$N<B9T(B (3$B0z?t(B)

<<<$BL5BL$J(BD-code$B$r:n$j$?$/$J$$$+$i!"(Bsub$B$NCf$G$b1i;;$,<B9T$G$-$k$J$i(B
  							$B$3$N%^%/%m$r8F$V!#(B>>>

<Arguments>
  ope_code_reg : $B1i;;<o$r<($9%l%8%9%?(B
  arg1 : $B0z?t(B (INT $B7?(B)
  arg2 : $B0z?t(B (INT $B7?(B)
  arg3 : $B0z?t(B ($BITDj(B)
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define i_ExecuteBodyArith3Arg (ope_code_reg, arg1, arg2, arg3)
{
  ValueSwitch (ope_code_reg) {
    case BLT_B_INTEGER_ADD :
      b_AddWithTag(arg1,arg2,arg3);
      p_IfOverflow () {goto Overflow;}  /* $B8=:_$O%*!<%P!<%U%m!<$ONc30(B */
      break;
    case BLT_B_INTEGER_SUBTRACT :
      b_SubtractWithTag(arg1,arg2,arg3);
      p_IfOverflow () {goto Overflow;}  /* $B8=:_$O%*!<%P!<%U%m!<$ONc30(B */
      break;
    case BLT_B_INTEGER_MULTIPLY :
      b_MultiplyWithTag(arg1,arg2,arg3);
      p_IfOverflow () {goto Overflow;}  /* $B8=:_$O%*!<%P!<%U%m!<$ONc30(B */
      break;
    case BLT_B_INTEGER_DIVIDE :
      b_DivideWithTag(arg1,arg2,arg3);
      p_IfZeroDivide() {goto ZeroDivision;}   /* $B8=:_$O%<%m=|;;$ONc30(B */
      p_IfOverflow () {goto Overflow;}  /* $B8=:_$O%*!<%P!<%U%m!<$ONc30(B */
      break;
    case BLT_B_INTEGER_MODULO :
      b_ModuloWithTag(arg1,arg2,arg3);
      p_IfZeroDivide() {goto ZeroDivision;}   /* $B8=:_$O%<%m=|;;$ONc30(B */
      p_IfOverflow () {goto Overflow;}  /* $B8=:_$O%*!<%P!<%U%m!<$ONc30(B */
      break;
    case BLT_B_INTEGER_SHIFT_LEFT :
      b_IfGreaterEqImm (arg2, _WordLength) {goto InvalidArgRange;}
      b_IfLess (arg2, D_NULL) {goto InvalidArgRange;}
      b_ShiftLeftWithTag (arg1, arg2, arg3);
      break;
    case BLT_B_INTEGER_SHIFT_RIGHT :
      b_IfGreaterEqImm (arg2, _WordLength) {goto InvalidArgRange;}
      b_IfLess (arg2, D_NULL) {goto InvalidArgRange;}
      b_ShiftRightWithTag (arg1, arg2, arg3);
      break;
    case BLT_B_INTEGER_AND :
      b_BitwiseAndWithTag(arg1,arg2,arg3);
      break;
    case BLT_B_INTEGER_OR :
      b_BitwiseOrWithTag(arg1,arg2,arg3);
      break;
    case BLT_B_INTEGER_EXCLUSIVE_OR :
      b_BitwiseEorWithTag(arg1,arg2,arg3);
      break;
    default:
      @DEBUG{
	OUT_OF_SPEC("body_blt_3_ope_arith","illegal_operation");
      };
  } /* end of ValueSwitch */
  goto End_of_KL1B_Instruction;

 Overflow:
  $USE (D_WorkExceptionCode);
  $USE(D_WorkExcepArgPos);
  b_SetImmTypeValueMRBoff (INT, _INTEGER_OVERFLOW_EXCP, D_WorkExceptionCode);
  p_MoveWord(D_NULL, D_WorkExcepArgPos);
  $CALL (f_Exception_3Arg_IIO_Sub (D_WorkExceptionCode, ope_code_reg, 
				   D_WorkExcepArgPos, arg1, arg2, arg3) );
  $RELEASE (D_WorkExceptionCode);
  $RELEASE(D_WorkExcepArgPos);
  
  goto End_of_KL1B_Instruction;

 ZeroDivision:
  $USE (D_WorkExceptionCode);
  $USE(D_WorkExcepArgPos);
  b_SetImmTypeValueMRBoff (INT, _INTEGER_ZERO_DIVISION_EXCP, D_WorkExceptionCode);
  p_MoveWord(D_NULL, D_WorkExcepArgPos);
  $CALL (f_Exception_3Arg_IIO_Sub (D_WorkExceptionCode, ope_code_reg, 
				   D_WorkExcepArgPos, arg1, arg2, arg3) );
  $RELEASE (D_WorkExceptionCode);
  $RELEASE(D_WorkExcepArgPos);
  goto End_of_KL1B_Instruction;

 InvalidArgRange:
  $USE (D_WorkExceptionCode);
  $USE(D_WorkExcepArgPos);
  b_SetImmTypeValueMRBoff (INT, _RANGE_OVERFLOW_EXCP, D_WorkExceptionCode);
  b_SetImmTypeValueMRBoff (INT, _ONE, D_WorkExcepArgPos);
  $CALL (f_Exception_3Arg_IIO_Sub(D_WorkExceptionCode, ope_code_reg, 
				  D_WorkExcepArgPos, arg1, arg2, arg3) );
  $RELEASE(D_WorkExcepArgPos);
  $RELEASE (D_WorkExceptionCode);

 End_of_KL1B_Instruction: ;
}

/******************************************************************** PSL **

       written by yamamoto@icot22      on Mon Jun  4 19:31:30 1990

$B;;=QO@M}1i;;$N<B9T(B (2$B0z?t(B)

<Arguments>
  ope_code_reg : $B1i;;<o$r<($9%l%8%9%?(B
  arg1 : $B0z?t(B (INT $B7?(B)
  arg2 : $B0z?t(B (INT $B7?(B)
  arg3 : $B0z?t(B ($BITDj(B)
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define i_ExecuteBodyArith2Arg (ope_code_reg, arg1, arg2)
{
  ValueSwitch (ope_code_reg) {
    case BLT_B_INTEGER_INCREMENT :
      b_AddImmediateWithTag (arg1, _ONE, arg2);
      p_IfOverflow () {goto Overflow;}  /* $B8=:_$O%*!<%P!<%U%m!<$ONc30(B */
      break;
    case BLT_B_INTEGER_DECREMENT :
      b_SubtractImmediateWithTag (arg1, _ONE, arg2);
      p_IfOverflow () {goto Overflow;}  /* $B8=:_$O%*!<%P!<%U%m!<$ONc30(B */
      break;
    default:
      @DEBUG{
	OUT_OF_SPEC("body_blt_2_ope_arith","illegal_operation");
      };
  } /* end of ValueSwitch */
  goto End_of_KL1B_Instruction;

 Overflow:
  $USE(D_WorkExcepArgPos);
  $USE (D_WorkExceptionCode);
  b_SetImmTypeValueMRBoff (INT, _INTEGER_OVERFLOW_EXCP, D_WorkExceptionCode);
  p_MoveWord(D_NULL, D_WorkExcepArgPos);
  $CALL (f_Exception_2Arg_IO_Sub(D_WorkExceptionCode, ope_code_reg, 
				 D_WorkExcepArgPos, arg1, arg2) );
  $RELEASE (D_WorkExceptionCode);
  $RELEASE(D_WorkExcepArgPos);
 End_of_KL1B_Instruction: ;
}
