
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/interpreter/klb_argument.psl.c
   ----- CREATED   : by f-hataza@icot22, on Fri May 11 14:04:34 1990
   ----- LAST SAVED: by imai@icot22, on Sat May  2 12:41:32 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : INTERPRETER
   ----- ABSTRACT  : $B9=B$BNMWAG(B, $B%4!<%k0z?t(B, $B:n6HMQ%a%b%j(B, $B%l%8%9%?A`:n(B

  1. $B#S#S#P=i4|2=(B
  klb_reset_ssp

  2. $B9=B$BNMWAG$NA`:n(B
  klb_read_wait (Rstr, imm_ofst, Reg, Lsusp)
  klb_read_wait_single (Rstr, imm_ofst, Reg, Lsusp)
  klb_read_ind_wait (Rstr, Rpos, Reg, Lsusp)
  klb_read_ind_wait_single (Rstr, Rpos, Reg, Lsusp)
  klb_read_srp_wait (Rstr, imm_ofst, Reg, Lsusp)
  klb_read_srp_wait_single (Rptr, imm_ofst, Reg, Lsusp)
  klb_read (Rptr, imm_ofst, Reg)
  klb_read_ind (Rstr, Rpos, Reg)
  klb_read_srp (Rstr, imm_ofst, Reg)
  klb_write (Reg, Rstr, imm_ofst)
  klb_write_ind (Reg, Rstr, Rpos)

  3. $B%4!<%k0z?t$NA`:n(B
  klb_load_wait (Rgoal, imm_ofst, Reg, Lsusp)
  klb_load_wait_single (Rgoal, imm_ofst, Reg, Lsusp)
  klb_load (Rgoal, imm_ofst, Reg)
  klb_store (Reg, Rgoal, imm_ofst)

  4. $B:n6HMQ%a%b%j!"%l%8%9%?A`:n(B
  klb_save (Reg, imm_ofst)
  klb_restore (imm_ofst, Reg)
  klb_move (Rsource, Rdest)

 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
  1. $B#S#S#P=i4|2=(B
klb_reset_ssp

       written by f-doumae@icot22      on Tue Jul 11 14:50:00 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |       reset_ssp       |      don't care       |
    +-----------+-----------+-----------+-----------+
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    $B%5%9%Z%s%7%g%s%9%?%C%/%]%$%s%?$r=i4|2=$9$k!#(B
<Examples>
<Test>
<Explanation>
    $B%5%9%Z%s%7%g%s%9%?%C%/$N07$$$K$D$$$F(B

 $B8=:_$N(BnewKL1-b$B;EMM$H$7$F$O%,!<%IIt$G$O:G8e$NHFMQ%l%8%9%?$r%5%9%Z%s%7%g%s(B
 $B%9%?%C%/%]%$%s%?(B(SSP)$B$H$7$FMQ$$$k$3$H$r9M$($F$$$k!#%\%G%#It$G$O%5%9%Z%s%7%g%s(B
 $B%9%?%C%/$O(B $B;H$o$J$$$N$G0lHL$N:n6HMQ$H$7$F;HMQ$9$k!#$^$?!"(Bsingle-wait$B$N>l9g(B
 $B$K$O:GE,2=$H$7$F!"%5%9%Z%s%7%g%s%9%?%C%/$r;H$o$J$$%3!<%I$bMQ0U$7$F$$$k!#(B
 $B$h$C$F!"$=$N;~$K$O%,!<%IIt$G$b:n6HMQ$K;H$($k!#(B
 $B$7$+$7!"(BSSP$B$r$I$3$N%l%8%9%?$KCV$$$F$*$/$+$I$&$+$O(BPIM$B<B5!Kh$K0[$J$k!#(B
 $B$=$3$G!"8=:_$N(BVPIM$B$N%$%s%W%j%a%s%H$H$7$F$O(BSSP$B$,$I$3$K$"$k$+$O%3%s%Q%$%i$O(B
 $BCN$i$J$$$b$N(B($B=hM}7O$,$I$3$+$KJ];}$7$F$$$k(B)$B$H$7$F%5%9%Z%s%7%g%s%9%?%C%/$N(B
 $BA`:n$r9T$&!#(B

<ETC>
********************************************************************* PSL **/

#PSL_define klb_reset_ssp()
{
  s_ResetSuspendStack();
}

/******************************************************************** PSL **
  2. $B9=B$BNMWAG$NA`:n(B
klb_read_wait  Rstr, imm_ofst, Reg, Lsusp

       written by f-doumae@icot22      on Tue Jul 11 14:53:47 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |       read_wait       |    Rstr   |  imm_ofst | 
    +-----------+-----------+-----------+-----------+
    |	 Reg	|	  Lsusp         | don't care|
    +-----------+-----------+-----------+-----------+
<Arguments>
    Rstr     : $B9=B$BN$r;X$9%]%$%s%?%l%8%9%?(B 
    imm_ofst : $B9=B$BN$NMWAG$N%"%I%l%9%*%U%;%C%H(B
    Reg      : $B%l%8%9%?(B
    Lsusp    : $B%5%9%Z%s%I%i%Y%k(B

<Temporally Used Variables>
<Level>
<PreCondition>
    $B%3%s%Q%$%i$N=P$9%3!<%I$O(B Rstr \= Reg $B$G$"$k$H2>Dj$9$k!#(B
<Function>
    Rstr$B$G;X$5$l$?9=B$BN$N%"%I%l%9%*%U%;%C%H(Bimm_ofst $B$K$"$kMWAG$r(B
    Reg$B$KFI$_9~$_!"%G%l%U$H=q$-La$7$r9T$&!#(B
    Rstr$B$N(BMRB$B$,!|$J$i$P!"MWAG$H(BReg$B$r%^!<%/$9$k!#(B
        $B"*(B Reg$B$N$_%^!<%/$9$k!#(B
           $BMWAG$OI,MW$J;~$K!"9u%Q%9$+$i;2>H$5$l$k$N$G!"%^!<%/$7$J$$(B
           $B%,!<%I$G;2>H$7$?(BReg$B$,%\%G%#$G$b;2>H$5$l$k>l9g(B
           $B%3%s%Q%$%i$,!"I,MW$K1~$8$F!"(Bmark(Reg),write(Reg,$BMWAG(B)$B$r=P$9!#(B
           $BB>$N%j!<%I7O$bF1MM(B
    $B$3$N8e!"$b$7MWAG$,(B
    $BL$Dj5AJQ?t$J$i$P%5%9%Z%s%7%g%s%9%?%C%/$K@Q$_!"(BLsusp$B$KJ,4t$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
    imm_ofst$B$O%]%9%H%3%s%Q%$%i$,MWAG0LCV$r%"%I%l%9%*%U%;%C%H$K(B
    $BJQ49$7$?$b$N$G$"$k!#(B
********************************************************************* PSL **/
#OPF_define I_RegStrBase     _IndirectRegField1
#OPF_define I_ImmElemOfst    _ImmediateField2
#OPF_define I_RegElemDest    _IndirectRegField3
#OPF_define I_ImmLsusp       _ImmediateField4

#OPF_define I_ImmRegStrBase  _ImmediateField1
#OPF_define I_ImmRegElemDest _ImmediateField3

#PSL_define klb_read_wait()
{
  @PROBE2{ probe_increment_counter(D_PROBE_COUNTER_READ_WAIT);};
  @DEBUG {
    b_IfRangeErr(I_ImmRegStrBase, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_read_wait", "r1 range");
    }
    b_IfRangeErr(I_ImmRegElemDest, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_read_wait", "r3 range");
    }
    b_IfEqualOprOpr(I_ImmRegStrBase, I_ImmRegElemDest) {
      OUT_OF_SPEC ("klb_read_wait", "r1 = r3");
    }
  };
  s_ReadWithOffsetOprMRBor(I_RegStrBase, I_ImmElemOfst, I_RegElemDest);
  f_DerefElementOpr(I_RegStrBase, I_ImmElemOfst, I_RegElemDest);
  s_IfREF(I_RegElemDest){ 
    s_PushSuspendStack(I_RegElemDest);
    s_SetKLB_PC_OPR(I_ImmLsusp);
  }
}

/******************************************************************** PSL **
klb_read_wait_single  Rstr, imm_ofst, Reg, Lsusp

       written by f-doumae@icot22      on Tue Jul 11 14:53:47 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |     read_wait_single  |    Rstr   |  imm_ofst | 
    +-----------+-----------+-----------+-----------+
    |	 Reg	|	  Lsusp         | don't care|
    +-----------+-----------+-----------+-----------+
<Arguments>
    Rstr     : $B9=B$BN$r;X$9%]%$%s%?%l%8%9%?(B 
    imm_ofst : $B9=B$BN$NMWAG$N%"%I%l%9%*%U%;%C%H(B
    Reg      : $B%l%8%9%?(B
    Lsusp    : $B%5%9%Z%s%I%i%Y%k(B

<Temporally Used Variables>
<Level>
<PreCondition>
    $B%3%s%Q%$%i$N=P$9%3!<%I$O(B Rstr \= Reg $B$G$"$k$H2>Dj$9$k!#(B
<Function>
    Rstr$B$G;X$5$l$?9=B$BN$N%"%I%l%9%*%U%;%C%H(Bimm_ofst$B$K$"$kMWAG$r(B
    Reg$B$KFI$_9~$_!"%G%l%U$H=q$-La$7$r9T$&!#(B
    Rstr$B$N(BMRB$B$,!|$J$i$P!"MWAG$H(BReg$B$r%^!<%/$9$k!#$3$N8e!"$b$7MWAG$,(B
    $BL$Dj5AJQ?t$J$i$P!"(BLsusp$B$KJ,4t$9$k!#%5%9%Z%s%7%g%s%9%?%C%/$K$O@Q$^$J$$!#(B
<Examples>
<Test>
<Explanation>
    $B%5%9%Z%s%7%g%s%9%?%C%/$rMQ$$$J$$:GE,2=L?Na!#(B
    single-wait$B$N>l9g$O%5%9%Z%s%7%g%s%9%?%C%/$r;H$o$:$K!"(Bsuspend$B$KD>@\(B
    $BL$Dj5AJQ?t$X$N%]%$%s%?$rEO$;$P$h$$!#$3$NL?Na$K$O(Bsuspend_single $B$,BP1~$9$k!#(B
<ETC>
    imm_ofst$B$O%]%9%H%3%s%Q%$%i$,MWAG0LCV$r%"%I%l%9%*%U%;%C%H$K(B
    $BJQ49$7$?$b$N$G$"$k!#(B
********************************************************************* PSL **/
#OPF_define I_RegStrBase    _IndirectRegField1
#OPF_define I_ImmElemOfst   _ImmediateField2
#OPF_define I_RegElemDest   _IndirectRegField3
#OPF_define I_ImmLsusp      _ImmediateField4

#OPF_define I_ImmRegStrBase   _ImmediateField1
#OPF_define I_ImmRegElemDest  _ImmediateField3

#PSL_define klb_read_wait_single()
{
  @PROBE2{ probe_increment_counter(D_PROBE_COUNTER_READ_WAIT_SINGLE);};
  @DEBUG {
    b_IfRangeErr(I_ImmRegStrBase, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_read_wait_single", "r1 range");
    }
    b_IfRangeErr(I_ImmRegElemDest, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_read_wait_single", "r3 range");
    }
    b_IfEqualOprOpr(I_ImmRegStrBase, I_ImmRegElemDest) {
      OUT_OF_SPEC ("klb_read_wait_single", "r1 = r3");
    }
  };
  s_ReadWithOffsetOprMRBor(I_RegStrBase, I_ImmElemOfst, I_RegElemDest);
  f_DerefElementOpr(I_RegStrBase, I_ImmElemOfst, I_RegElemDest);
  s_IfREF(I_RegElemDest){ 
    s_SetKLB_PC_OPR(I_ImmLsusp);
  }
}

/******************************************************************** PSL **
klb_read_ind_wait  Rstr, Rpos, Reg, Lsusp

       written by f-doumae@icot22      on Tue Jan 30 18:07:32 1990

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |     read_ind_wait     |    Rstr   |    Rpos   | 
    +-----------+-----------+-----------+-----------+
    |	 Reg	|	  Lsusp         | don't care|
    +-----------+-----------+-----------+-----------+
<Arguments>
    Rstr    : $B9=B$BN$r;X$9%]%$%s%?%l%8%9%?(B 
    Rpos    : $B9=B$BN$NMWAG0LCV(B($B%l%8%9%?(B)
    Reg     : $B%l%8%9%?(B
    Lsusp   : $B%5%9%Z%s%I%i%Y%k(B
<Temporally Used Variables>
    D_WorkOffset : $B9=B$BNMWAG$N%*%U%;%C%H$rF~$l$k$?$a$N%l%8%9%?(B
                   (defined in klb_fork.psl.c)
<Level>
<PreCondition>
    $B%3%s%Q%$%i$N=P$9%3!<%I$O(B Rstr \= Reg $B$G$"$k$H2>Dj$9$k!#(B
<Function>
    Rstr$B$G;X$5$l$?9=B$BN$N!"%l%8%9%?(BRpos$B>e$N@0?t$G;XDj$5$l$?MWAG0LCV$K$"$k(B
    $BMWAG$r(BReg$B$KFI$_9~$_!"%G%l%U$H=q$-La$7$r9T$&!#(B
    Rstr$B$N(BMRB$B$,!|$J$i$P!"MWAG$H(BReg$B$r%^!<%/$9$k!#$3$N8e!"$b$7MWAG$,(B
    $BL$Dj5AJQ?t$J$i$P%5%9%Z%s%7%g%s%9%?%C%/$K@Q$_!"(BLsusp$B$KJ,4t$9$k!#(B
<Examples>
<Test>
<Explanation>
    $BMWAG0LCV$r%l%8%9%?$G;XDj$9$kB>$O(Bklb_read_wait$B$HF1$8!#(B
<ETC>
********************************************************************* PSL **/
#OPF_define I_RegStrBase      _IndirectRegField1
#OPF_define I_RegElemPos      _IndirectRegField2
#OPF_define I_RegElemDest     _IndirectRegField3
#OPF_define I_ImmLsusp        _ImmediateField4

#OPF_define I_ImmRegStrBase   _ImmediateField1
#OPF_define I_ImmRegElemPos   _ImmediateField2
#OPF_define I_ImmRegElemDest  _ImmediateField3

#PSL_define klb_read_ind_wait()
{
  @PROBE2{ probe_increment_counter(D_PROBE_COUNTER_READ_IND_WAIT);};
  @DEBUG {
    b_IfRangeErr(I_ImmRegStrBase, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_read_ind_wait", "r1 range");
    }
    b_IfRangeErr(I_ImmRegElemPos, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_read_ind_wait", "r2 range");
    }
    b_IfRangeErr(I_ImmRegElemDest, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_read_ind_wait", "r3 range");
    }
    b_IfEqualOprOpr(I_ImmRegStrBase, I_ImmRegElemDest) {
      OUT_OF_SPEC ("klb_read_ind_wait", "r1 = r3");
    }
  };
  $USE(D_WorkOffset);
  b_ExchangeElmposToOffset(I_RegElemPos, D_WorkOffset);
                         /* $B%"%I%l%C%7%s%0JQ49(B index --> offset */
  s_ReadWithRegOffsetMRBor(I_RegStrBase, D_WorkOffset, I_RegElemDest);
  f_DerefElementReg(I_RegStrBase, D_WorkOffset, I_RegElemDest);
  $RELEASE(D_WorkOffset);

  s_IfREF(I_RegElemDest){ 
    s_PushSuspendStack(I_RegElemDest);
    s_SetKLB_PC_OPR(I_ImmLsusp);
  }
}

/******************************************************************** PSL **
klb_read_ind_wait_single  Rstr, Rpos, Reg, Lsusp

       written by f-doumae@icot22      on Tue Jan 30 18:07:32 1990

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |  read_ind_wait_single |    Rstr   |   Rpos    | 
    +-----------+-----------+-----------+-----------+
    |	 Reg	|	  Lsusp         | don't care|
    +-----------+-----------+-----------+-----------+
<Arguments>
    Rstr    : $B9=B$BN$r;X$9%]%$%s%?%l%8%9%?(B 
    Rpos    : $B9=B$BN$NMWAG0LCV(B($B%l%8%9%?(B)
    Reg     : $B%l%8%9%?(B
    Lsusp   : $B%5%9%Z%s%I%i%Y%k(B
<Temporally Used Variables>
    D_WorkOffset : $B9=B$BNMWAG$N%*%U%;%C%H$rF~$l$k$?$a$N%l%8%9%?(B
<Level>
<PreCondition>
    $B%3%s%Q%$%i$N=P$9%3!<%I$O(B Rstr \= Reg $B$G$"$k$H2>Dj$9$k!#(B
<Function>
    Rstr$B$G;X$5$l$?9=B$BN$N(B,$B%l%8%9%?(BRpos$B>e$N@0?tCM$G;XDj$5$l$?MWAG0LCV$K$"$k(B
    $BMWAG$r(BReg$B$KFI$_9~$_!"%G%l%U$H=q$-La$7$r9T$&!#(B
    Rstr$B$N(BMRB$B$,!|$J$i$P!"MWAG$H(BReg$B$r%^!<%/$9$k!#$3$N8e!"$b$7MWAG$,(B
    $BL$Dj5AJQ?t$J$i$P!"(BLsusp$B$KJ,4t$9$k!#%5%9%Z%s%7%g%s%9%?%C%/$K$O@Q$^$J$$!#(B
<Examples>
<Test>
<Explanation>
    $B%5%9%Z%s%7%g%s%9%?%C%/$rMQ$$$J$$:GE,2=L?Na!#(B
    single-wait$B$N>l9g$O%5%9%Z%s%7%g%s%9%?%C%/$r;H$o$:$K!"(Bsuspend$B$KD>@\(B
    $BL$Dj5AJQ?t$X$N%]%$%s%?$rEO$;$P$h$$!#$3$NL?Na$K$O(Bsuspend_single $B$,BP1~$9$k!#(B
 
    $BMWAG0LCV$r%l%8%9%?$G;XDj$9$kB>$O(Bklb_read_wait_single$B$HF1$8!#(B
<ETC>
********************************************************************* PSL **/
#OPF_define I_RegStrBase      _IndirectRegField1
#OPF_define I_RegElemPos      _IndirectRegField2
#OPF_define I_RegElemDest     _IndirectRegField3
#OPF_define I_ImmLsusp        _ImmediateField4

#OPF_define I_ImmRegStrBase   _ImmediateField1
#OPF_define I_ImmRegElemPos   _ImmediateField2
#OPF_define I_ImmRegElemDest  _ImmediateField3

#PSL_define klb_read_ind_wait_single()
{
  @PROBE2{ probe_increment_counter(D_PROBE_COUNTER_READ_IND_WAIT_SINGLE);};
  @DEBUG {
    b_IfRangeErr(I_ImmRegStrBase, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_read_ind_wait_single", "r1 range");
    }
    b_IfRangeErr(I_ImmRegElemPos, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_read_ind_wait_single", "r2 range");
    }
    b_IfRangeErr(I_ImmRegElemDest, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_read_ind_wait_single", "r3 range");
    }
    b_IfEqualOprOpr(I_ImmRegStrBase, I_ImmRegElemDest) {
      OUT_OF_SPEC ("klb_read_wait_single", "r1 = r3");
    }
  };
  $USE(D_WorkOffset);
  b_ExchangeElmposToOffset(I_RegElemPos, D_WorkOffset);
                         /* $B%"%I%l%C%7%s%0JQ49(B index --> offset */
  s_ReadWithRegOffsetMRBor(I_RegStrBase, D_WorkOffset, I_RegElemDest);
  f_DerefElementReg(I_RegStrBase, D_WorkOffset, I_RegElemDest);
  $RELEASE(D_WorkOffset);

  s_IfREF(I_RegElemDest){ 
    s_SetKLB_PC_OPR(I_ImmLsusp);
  }
}

/******************************************************************** PSL **
klb_read_srp_wait  Rstr, imm_ofst, Reg, Lsusp

       written by f-doumae@icot22      on Tue Jul 11 14:53:47 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |    read_srp_wait      |    Rstr   |  imm_ofst | 
    +-----------+-----------+-----------+-----------+
    |	 Reg	|	  Lsusp         | don't care|
    +-----------+-----------+-----------+-----------+
<Arguments>
    Rstr     : $B9=B$BN$r;X$9%]%$%s%?%l%8%9%?(B 
    imm_ofst : $B9=B$BN$NMWAG$N%"%I%l%9%*%U%;%C%H(B
    Reg      : $B%l%8%9%?(B
    Lsusp    : $B%5%9%Z%s%I%i%Y%k(B

<Temporally Used Variables>
<Level>
<PreCondition>
    $B%3%s%Q%$%i$N=P$9%3!<%I$O(B Rstr \= Reg $B$G$"$k$H2>Dj$9$k!#(B
<Function>
    Rstr$B$G;X$5$l$?9=B$BN$N%"%I%l%9%*%U%;%C%H(Bimm_ofst$B$K$"$kMWAG$r(B
    Reg$B$KFI$_9~$_!"%G%l%U$H=q$-La$7$r9T$&!#(B
    $B$3$N8e!"$b$7MWAG$,L$Dj5AJQ?t$J$i$P%5%9%Z%s%7%g%s%9%?%C%/$K@Q$_!"(B
    Lsusp$B$KJ,4t$9$k!#(B
<Examples>
<Test>
<Explanation>
    Rstr$B$,%4!<%k$X$N%]%$%s%?$N>l9g!"$^$?$O:GE,2=%3%s%Q%$%i$,(BRstr$B$,!{(B
    $B$G$"$k$HJ]>Z$G$-$k>l9g$K@8@.$9$kL?Na!#(B
<ETC>
    imm_ofst$B$O%]%9%H%3%s%Q%$%i$,MWAG0LCV$r%"%I%l%9%*%U%;%C%H$K(B
    $BJQ49$7$?$b$N$G$"$k!#(B
    PIM/p $B$G$O(B read $B$H(B mrb-or read $B$N%3%9%H$OF1$8$G$"$k!#(B
    $B=>$C$F!"(Bklb_read_wait $B$HF1$8L?Na$K$J$k!#(B
********************************************************************* PSL **/
#OPF_define I_RegStrBase     _IndirectRegField1
#OPF_define I_ImmElemOfst    _ImmediateField2
#OPF_define I_RegElemDest    _IndirectRegField3
#OPF_define I_ImmLsusp       _ImmediateField4

#OPF_define I_ImmRegStrBase  _ImmediateField1
#OPF_define I_ImmRegElemDest _ImmediateField3

#PSL_define klb_read_srp_wait()
{
  @PROBE2 {
    s_IfHOOK(I_RegStrBase) {
      probe_increment_counter(D_PROBE_COUNTER_LOAD_WAIT);
    } else {
      probe_increment_counter(D_PROBE_COUNTER_READ_SRP_WAIT);
    }
  };
  @DEBUG {
    b_IfRangeErr(I_ImmRegStrBase, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_read_srp_wait", "r1 range");
    }
    b_IfRangeErr(I_ImmRegElemDest, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_read_srp_wait", "r3 range");
    }
    b_IfEqualOprOpr(I_ImmRegStrBase, I_ImmRegElemDest) {
      OUT_OF_SPEC ("klb_read_srp_wait", "r1 = r3");
    }
  };

  @REGOPE_OPT {	/* optimize for speed enhancement */
    p_ReadWithOffsetOPR(I_RegStrBase, I_ImmElemOfst, I_RegElemDest);
    s_IfREF(I_RegElemDest) {
      /* I_RegElemDest $B$,(B REF $B$N>l9g$K$N$_8F$P$l$k(B */
      $USE(D_WorkDerefPtr);
      s_DerefReg(I_RegElemDest, D_WorkDerefPtr);
      s_IfNotUnbound(I_RegElemDest) {
	LOOP() {
	  /* MRB off $B$J$i$P!"#1%o!<%I%;%k$r2s<}$9$k(B */
	  f_ReclaimIfSingleRefPath(I_RegElemDest,D_WorkDerefPtr);
	  s_IfNotREF(I_RegElemDest) {
	    /* REF $B$G$J$1$l$P!"=q$-La$7$F=*$j(B */
	    $RELEASE(D_WorkDerefPtr);
	    p_WriteWithOffsetOPR(I_RegElemDest, I_RegStrBase, I_ImmElemOfst);
	    goto End;
	  }
	  s_DerefReg(I_RegElemDest, D_WorkDerefPtr);
	  s_IfUnbound(I_RegElemDest) {
	    /* $BL$Dj5A$J$i$P!"=q$-La$7!"%5%9%Z%s%I%9%?%C%/$X$N(B Push */
	    p_WriteWithOffsetOPR(D_WorkDerefPtr, I_RegStrBase, I_ImmElemOfst);
	    /* s_PushSuspendStack $BAjEv$N=hM}!"(B*/
	    goto PushSuspendStack;
	  }
	}
      }   /* else $B$O(B REF->UNBOUND $B$@$C$?>l9g$N$_$G$"$k$+$i!"=q$-La$7$OITMW(B */
    PushSuspendStack:
      p_MoveWord(D_WorkDerefPtr, I_RegElemDest);
      s_IfNotREF(D_SuspendStackPtr) {
	p_MoveWord(I_RegElemDest, D_SuspendStackCache);
	s_SetValidSuspendStack();
      } else {
	b_PushWordStack(D_SuspendStackPtr,I_RegElemDest);
      }
      $RELEASE(D_WorkDerefPtr);
      s_SetKLB_PC_OPR(I_ImmLsusp);
    }
  End:;
  } else /* not @REGOPE_OPT */ {	/* original VPIM code */
    p_ReadWithOffsetOPR(I_RegStrBase, I_ImmElemOfst, I_RegElemDest);
    f_DerefElementOpr(I_RegStrBase, I_ImmElemOfst, I_RegElemDest);
    s_IfREF(I_RegElemDest){ 
      s_PushSuspendStack(I_RegElemDest);
      s_SetKLB_PC_OPR(I_ImmLsusp);
    }
  };
}

/******************************************************************** PSL **
klb_read_srp_wait_single  Rstr, imm_ofst, Reg, Lsusp

       written by f-doumae@icot22      on Tue Jul 11 14:53:47 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    | read_srp_wait_single  |    Rstr   |  imm_ofst | 
    +-----------+-----------+-----------+-----------+
    |	 Reg	|	  Lsusp         | don't care|
    +-----------+-----------+-----------+-----------+
<Arguments>
    Rstr     : $B9=B$BN$r;X$9%]%$%s%?%l%8%9%?(B 
    imm_ofst : $B9=B$BN$NMWAG$N%"%I%l%9%*%U%;%C%H(B
    Reg      : $B%l%8%9%?(B
    Lsusp    : $B%5%9%Z%s%I%i%Y%k(B

<Temporally Used Variables>
<Level>
<PreCondition>
    $B%3%s%Q%$%i$N=P$9%3!<%I$O(B Rstr \= Reg $B$G$"$k$H2>Dj$9$k!#(B
<Function>
    Rstr$B$G;X$5$l$?9=B$BN$N%"%I%l%9%*%U%;%C%H(Bimm_ofst$B$K$"$kMWAG$r(B
    Reg$B$KFI$_9~$_!"%G%l%U$H=q$-La$7$r9T$&!#(B
    $B$3$N8e!"$b$7MWAG$,L$Dj5AJQ?t$J$i$P(BLsusp$B$KJ,4t$9$k!#(B
<Examples>
<Test>
<Explanation>
    Rstr$B$,%4!<%k$X$N%]%$%s%?$N>l9g!"$^$?$O:GE,2=%3%s%Q%$%i$,(BRstr$B$,!{(B
    $B$G$"$k$HJ]>Z$G$-$k>l9g$K@8@.$9$kL?Na!#%5%9%Z%s%7%g%s%9%?%C%/$r(B
    $BMQ$$$J$$:GE,2=$N$?$a$NL?Na!#(B
<ETC>
    imm_ofst$B$O%]%9%H%3%s%Q%$%i$,MWAG0LCV$r%"%I%l%9%*%U%;%C%H$K(B
    $BJQ49$7$?$b$N$G$"$k!#(B
    PIM/p $B$G$O(B read $B$H(B mrb-or read $B$N%3%9%H$OF1$8$G$"$k!#(B
    $B=>$C$F!"(Bklb_read_wait_single $B$HF1$8L?Na$K$J$k!#(B
********************************************************************* PSL **/
#OPF_define I_RegStrBase     _IndirectRegField1
#OPF_define I_ImmElemOfst    _ImmediateField2
#OPF_define I_RegElemDest    _IndirectRegField3
#OPF_define I_ImmLsusp       _ImmediateField4

#OPF_define I_ImmRegStrBase  _ImmediateField1
#OPF_define I_ImmRegElemDest _ImmediateField3

#PSL_define klb_read_srp_wait_single()
{
  @PROBE2 {
    s_IfHOOK(I_RegStrBase) {
      probe_increment_counter(D_PROBE_COUNTER_LOAD_WAIT_SINGLE);
    } else {
      probe_increment_counter(D_PROBE_COUNTER_READ_SRP_WAIT_SINGLE);
    }
  };
  @DEBUG {
    b_IfRangeErr(I_ImmRegStrBase, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_read_srp_wait_single", "r1 range");
    }
    b_IfRangeErr(I_ImmRegElemDest, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_read_srp_wait_single", "r3 range");
    }
    b_IfEqualOprOpr(I_ImmRegStrBase, I_ImmRegElemDest) {
      OUT_OF_SPEC ("klb_read_srp_wait_single", "r1 = r3");
    }
  };
  @REGOPE_OPT {	/* optimize for speed enhancement */
    p_ReadWithOffsetOPR(I_RegStrBase, I_ImmElemOfst, I_RegElemDest);
    s_IfREF(I_RegElemDest) {
      /* I_RegElemDest $B$,(B REF $B$N>l9g$K$N$_8F$P$l$k(B */
      $USE(D_WorkDerefPtr);
      s_DerefReg(I_RegElemDest, D_WorkDerefPtr);
      s_IfNotUnbound(I_RegElemDest) {
	LOOP() {
	  /* MRB off $B$J$i$P!"#1%o!<%I%;%k$r2s<}$9$k(B */
	  f_ReclaimIfSingleRefPath(I_RegElemDest,D_WorkDerefPtr);
	  s_IfNotREF(I_RegElemDest) {
	    /* REF $B$G$J$1$l$P!"=q$-La$7$F=*$j(B */
	    $RELEASE(D_WorkDerefPtr);
	    p_WriteWithOffsetOPR(I_RegElemDest, I_RegStrBase, I_ImmElemOfst);
	    break; /* from LOOP(), (from this macro) */
	  }
	  s_DerefReg(I_RegElemDest, D_WorkDerefPtr);
	  s_IfUnbound(I_RegElemDest) {
	    /* $BL$Dj5A$J$i$P!"=q$-La$7!"%5%9%Z%s%I%9%?%C%/$X$N(B Push */
	    p_MoveWord(D_WorkDerefPtr, I_RegElemDest);
	    p_WriteWithOffsetOPR(D_WorkDerefPtr, I_RegStrBase, I_ImmElemOfst);
	    $RELEASE(D_WorkDerefPtr);
	    /* s_PushSuspendStack $BAjEv$N=hM}!"(B*/
	    s_SetKLB_PC_OPR(I_ImmLsusp); /* which means suspend */
	    break; /* from LOOP(), (from this macro) */
	  }
	}
      } else {
	/* REF->UNBOUND $B$@$C$?>l9g$N$_$G$"$k$+$i!"=q$-La$7$OITMW(B */
	p_MoveWord(D_WorkDerefPtr, I_RegElemDest);
	$RELEASE(D_WorkDerefPtr);
	/* s_PushSuspendStack $BAjEv$N=hM}!"(B*/
	s_SetKLB_PC_OPR(I_ImmLsusp); /* which means suspend */
      }
    }
  } else /* NOT @REGOPE_OPT */ {	/* ORIGINAL VPIM CODE */
    p_ReadWithOffsetOPR(I_RegStrBase, I_ImmElemOfst, I_RegElemDest);
    f_DerefElementOpr(I_RegStrBase, I_ImmElemOfst, I_RegElemDest);
    s_IfREF(I_RegElemDest){ 
      s_SetKLB_PC_OPR(I_ImmLsusp);
    }
  };
}

/******************************************************************** PSL **
klb_read Rstr, imm_ofst, Reg

       written by f-doumae@icot22      on Wed Jul 12 13:11:22 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |          read         |    Rstr   |  imm_ofst | 
    +-----------+-----------+-----------+-----------+
    |	 Reg	|	     don't care             |
    +-----------+-----------+-----------+-----------+
<Arguments>
    Rstr     : $B9=B$BN$r;X$9%]%$%s%?%l%8%9%?(B
    imm_ofst : $B9=B$BN$NMWAG$N%"%I%l%9%*%U%;%C%H(B
    Reg      : $B%l%8%9%?(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    Rstr$B$G;XDj$5$l$?9=B$BN$N%"%I%l%9%*%U%;%C%H(Bimm_ofst$B$N0LCV$K$"$k(B
    $BMWAG$NCM$r(BReg$B$KFI$_9~$`!#(B
    $B$^$?!"(BRstr$B$N(BMRB$B$,!|$J$i$P!"MWAG$H(BReg$B$r%^!<%/$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
    imm_ofst$B$O%]%9%H%3%s%Q%$%i$,MWAG0LCV$r%"%I%l%9%*%U%;%C%H$K(B
    $BJQ49$7$?$b$N$G$"$k!#(B
********************************************************************* PSL **/
#OPF_define I_RegStrBase      _IndirectRegField1
#OPF_define I_ImmElemOfst     _ImmediateField2
#OPF_define I_RegElemDest     _IndirectRegField3

#OPF_define I_ImmRegStrBase   _ImmediateField1
#OPF_define I_ImmRegElemDest  _ImmediateField3

#PSL_define klb_read()
{
  @PROBE2{ probe_increment_counter(D_PROBE_COUNTER_READ);};
  @DEBUG {
    b_IfRangeErr(I_ImmRegStrBase, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_read", "r1 range");
    }
    b_IfRangeErr(I_ImmRegElemDest, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_read", "r3 range");
    }
  };
  s_ReadWithOffsetOprMRBor(I_RegStrBase, I_ImmElemOfst, I_RegElemDest);
}

/******************************************************************** PSL **
klb_read_ind Rstr, Rpos, Reg

       written by f-doumae@icot22      on Mon Feb  5 11:53:19 1990

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |      read_ind         |    Rstr   |    Rpos   | 
    +-----------+-----------+-----------+-----------+
    |	 Reg	|	     don't care             |
    +-----------+-----------+-----------+-----------+

<Arguments>
    Rstr    : $B9=B$BN$r;X$9%]%$%s%?%l%8%9%?(B
    Rpos    : $B9=B$BN$NMWAG0LCV$rJ];}$7$?%l%8%9%?(B
    Reg     : $B%l%8%9%?(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    Rstr$B$G;XDj$5$l$?9=B$BN$N%l%8%9%?(BRpos$B$N<($9MWAG0LCV$K$"$k(B
    $BMWAG$NCM$r(BReg$B$KFI$_9~$`!#(B
    $B$^$?!"(BRstr$B$N(BMRB$B$,!|$J$i$P!"MWAG$H(BReg$B$r%^!<%/$9$k!#(B
<Examples>
<Test>
<Explanation>
    $BMWAG0LCV$r%l%8%9%?$G<($9B>$O(Bklb_read$B$HF1$8!#(B
<ETC>
********************************************************************* PSL **/
#OPF_define I_RegStrBase    _IndirectRegField1
#OPF_define I_RegElemPos    _IndirectRegField2
#OPF_define I_RegElemDest   _IndirectRegField3

#OPF_define I_ImmRegStrBase   _ImmediateField1
#OPF_define I_ImmRegElemPos   _ImmediateField2
#OPF_define I_ImmRegElemDest  _ImmediateField3

#PSL_define klb_read_ind()
{
  @PROBE2{ probe_increment_counter(D_PROBE_COUNTER_READ_IND);};
  @DEBUG {
    b_IfRangeErr(I_ImmRegStrBase, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_read_ind", "r1 range");
    }
    b_IfRangeErr(I_ImmRegElemPos, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_read_ind", "r2 range");
    }
    b_IfRangeErr(I_ImmRegElemDest, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_read_ind", "r3 range");
    }
  };
  $USE(D_WorkOffset);
  b_ExchangeElmposToOffset(I_RegElemPos, D_WorkOffset);
                         /* $B%"%I%l%C%7%s%0JQ49(B index --> offset */
  s_ReadWithRegOffsetMRBor(I_RegStrBase, D_WorkOffset, I_RegElemDest);
  $RELEASE(D_WorkOffset);
}

/******************************************************************** PSL **
klb_read_srp Rstr, imm_ofst, Reg

       written by f-doumae@icot22      on Wed Jul 12 13:11:22 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |        read_srp       |    Rstr   |  imm_ofst | 
    +-----------+-----------+-----------+-----------+
    |	 Reg	|	     don't care             |
    +-----------+-----------+-----------+-----------+
<Arguments>
    Rstr     : $B9=B$BN$r;X$9%]%$%s%?%l%8%9%?(B
    imm_ofst : $B9=B$BN$NMWAG$N%"%I%l%9%*%U%;%C%H(B
    Reg      : $B%l%8%9%?(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    Rstr$B$G;XDj$5$l$?9=B$BN$N9=B$BN$N%"%I%l%9%*%U%;%C%H(Bimm_ofst$B$K$"$k(B
    $BMWAG$NCM$r(BReg$B$KFI$_9~$`!#(B
<Examples>
<Test>
<Explanation>
    Rstr$B$,%4!<%k$^$?$O:n6HMQ%a%b%j$X$N%]%$%s%?$N>l9g!"$^$?$O(B
    $B:GE,2=%3%s%Q%$%i$,(BRstr$B$,!{$G$"$k$HJ]>Z$G$-$k>l9g$K@8@.$9$kL?Na!#(B
<ETC>
    imm_ofst$B$O%]%9%H%3%s%Q%$%i$,MWAG0LCV$r%"%I%l%9%*%U%;%C%H$K(B
    $BJQ49$7$?$b$N$G$"$k!#(B
********************************************************************* PSL **/
#OPF_define I_RegStrBase     _IndirectRegField1
#OPF_define I_ImmElemOfst    _ImmediateField2
#OPF_define I_RegElemDest    _IndirectRegField3

#OPF_define I_ImmRegStrBase  _ImmediateField1
#OPF_define I_ImmRegElemDest _ImmediateField3

#PSL_define klb_read_srp()
{
  @PROBE2 {
    s_IfHOOK(I_RegStrBase) {
      probe_increment_counter(D_PROBE_COUNTER_LOAD);
    } else {
      probe_increment_counter(D_PROBE_COUNTER_READ_SRP);
    }
  };
  @DEBUG {
    b_IfRangeErr(I_ImmRegStrBase, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_read_srp", "r1 range");
    }
    b_IfRangeErr(I_ImmRegElemDest, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_read_srp", "r3 range");
    }
  };
  p_ReadWithOffsetOPR(I_RegStrBase, I_ImmElemOfst, I_RegElemDest);
}

/******************************************************************** PSL **
klb_write Reg, Rstr, imm_ofst

       written by f-doumae@icot22      on Wed Jul 12 13:34:01 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |         write         |    Reg    |   Rstr    | 
    +-----------+-----------+-----------+-----------+
    |  imm_ofst	|	     don't care             |
    +-----------+-----------+-----------+-----------+
<Arguments>
    Reg      : $B%l%8%9%?(B
    Rstr     : $B9=B$BN$r;X$9%]%$%s%?%l%8%9%?(B
    imm_ofst : $B9=B$BN$NMWAG%"%I%l%9%*%U%;%C%H(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    Reg$B$NCM$r(BRstr$B$G;XDj$5$l$?9=B$BN$N%"%I%l%9%*%U%;%C%H(Bimm_ofst$B$K$"$k(B
    $BMWAG$K=q$-9~$`!#(B
<Examples>
<Test>
<Explanation>
<ETC>
    imm_ofst$B$O%]%9%H%3%s%Q%$%i$,MWAG0LCV$r%"%I%l%9%*%U%;%C%H$K(B
    $BJQ49$7$?$b$N$G$"$k!#(B
********************************************************************* PSL **/
#OPF_define   I_RegSrcElem     _IndirectRegField1
#OPF_define   I_RegStrBase     _IndirectRegField2
#OPF_define   I_ImmElemOfst    _ImmediateField3

#OPF_define   I_ImmRegSrcElem  _ImmediateField1
#OPF_define   I_ImmRegStrBase  _ImmediateField2

#PSL_define klb_write()
{
  @PROBE2 {
    s_IfHOOK(I_RegStrBase) {
      probe_increment_counter(D_PROBE_COUNTER_STORE);
    } else {
      probe_increment_counter(D_PROBE_COUNTER_WRITE);
    }
  };
  @DEBUG {
    b_IfRangeErr(I_ImmRegSrcElem, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_write", "r1 range");
    }
    b_IfRangeErr(I_ImmRegStrBase, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_write", "r3 range");
    }
  };
  p_WriteWithOffsetOPR(I_RegSrcElem, I_RegStrBase, I_ImmElemOfst);
}

/******************************************************************** PSL **
klb_write_ind Reg, Rstr, imm_ofst

       written by f-doumae@icot22      on Mon Feb  5 12:02:22 1990

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |     write_ind         |    Reg    |   Rstr    | 
    +-----------+-----------+-----------+-----------+
    |    Rpos	|	     don't care             |
    +-----------+-----------+-----------+-----------+
<Arguments>
    Reg     : $B%l%8%9%?(B
    Rstr    : $B9=B$BN$r;X$9%]%$%s%?%l%8%9%?(B
    Rpos    : $B9=B$BN$NMWAG0LCV$r<($9%l%8%9%?(B
<Temporally Used Variables>
    D_WorkElemAddr : $B9=B$BNMWAG$N%"%I%l%9$rF~$l$k%l%8%9%?(B
                     (defined in str_small_struct.psl.c)
<Level>
<PreCondition>
<Function>
    Reg$B$NCM$r(BRstr$B$G;XDj$5$l$?9=B$BN$N%l%8%9%?(BRpos$B>e$NCM$G<($5$l$?MWAG0LCV$K(B
    $B=q$-9~$`!#(B
<Examples>
<Test>
<Explanation>
    $BMWAG0LCV$r%l%8%9%?$G;XDj$9$kB>$O(Bklb_write$B$HF1$8!#(B
<ETC>
********************************************************************* PSL **/
#OPF_define   I_RegSrcElem  _IndirectRegField1
#OPF_define   I_RegStrBase  _IndirectRegField2
#OPF_define   I_RegElemPos  _IndirectRegField3

#OPF_define   I_ImmRegSrcElem  _ImmediateField1
#OPF_define   I_ImmRegStrBase  _ImmediateField2
#OPF_define   I_ImmRegElemPos  _ImmediateField3

#PSL_define klb_write_ind()
{
  @PROBE2{ probe_increment_counter(D_PROBE_COUNTER_WRITE_IND);};
  @DEBUG {
    b_IfRangeErr(I_ImmRegSrcElem, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_write_ind", "r1 range");
    }
    b_IfRangeErr(I_ImmRegStrBase, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_write_ind", "r2 range");
    }
    b_IfRangeErr(I_ImmRegElemPos, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_write_ind", "r3 range");
    }
  };
  $USE(D_WorkElemAddr);
  b_ExchangeElmposToOffset(I_RegElemPos, D_WorkElemAddr);
  b_AddWithDNTC(I_RegStrBase, D_WorkElemAddr, D_WorkElemAddr);
  p_Write(I_RegSrcElem, D_WorkElemAddr);
  $RELEASE(D_WorkElemAddr);
}

/******************************************************************** PSL **
  3. $B%4!<%k0z?t$NA`:n(B
klb_load_wait Rgoal, imm_ofst, Reg, Lsusp

       written by f-doumae@icot22      on Wed Jul 12 14:38:45 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |       load_wait       |    Rgoal  |  imm_ofst | 
    +-----------+-----------+-----------+-----------+
    |	 Reg	|	  Lsusp         | don't care|
    +-----------+-----------+-----------+-----------+
<Arguments>
    Rgoal    : $B%4!<%k%l%3!<%I$r;X$9%]%$%s%?%l%8%9%?(B
    imm_ofst : $B0z?t$N%"%I%l%9%*%U%;%C%H(B
    Reg      : $B%l%8%9%?(B
    Lsusp    : $B%5%9%Z%s%I%i%Y%k(B

<Temporally Used Variables>
<Level>
<PreCondition>
    Rgoal \= Reg $B$H2>Dj$9$k!#(B
<Function>
    Rgoal$B$G;XDj$5$l$?%4!<%k%l%3!<%I$N%"%I%l%9%*%U%;%C%H(Bimm_ofst$B$K$"$k0z?t$NCM$r(B
    Reg$B$KFI$_9~$_!"%G%l%U$H=q$-La$7$r9T$&!#$3$N8e!"$b$70z?t$,L$Dj5A$J$i$P(B
    $B%5%9%Z%s%7%g%s%9%?%C%/$X@Q$_!"(BLsusp$B$XJ,4t$9$k!#(B
<Examples>
<Test>
<Explanation>
    $B%4!<%k%l%3!<%I$NA`:n$r$9$kL?Na!#A`:n$NBP>]$H$9$k%4!<%k%l%3!<%I$O(B
    $BHFMQ%l%8%9%?$G;XDj$5$l$k!#>0!"%4!<%k%l%3!<%I$r;X$9%]%$%s%?$N(BMRB$B$O(B
    $BI,$:!{$J$N$G!"9=B$BN$NA`:n$H0[$J$j(BMRB$B$N%a%s%F%J%s%9$r$9$kI,MW$O$J$$!#(B
<ETC>
    $B%4!<%k%l%3!<%I$O0l<o$N9=B$BN$H9M$($k$3$H$,$G$-$k!#=>$C$F!"8=:_$3$NL?Na$O(B
    $B%]%9%H%3%s%Q%$%i$,(B read_srp_wait $B$KJQ49$7$F$$$k!#(B
    $B!J"*(B load_wait $B$H(B read_srp_wait $B$O!"%*%U%;%C%H$NB(CM$,0c$&$@$1!K(B

    ***********************************
    *    load_wait --> read_srp_wait  *
    ***********************************
********************************************************************* PSL **/

#PSL_define klb_load_wait()
{
    @DEBUG{ VPIM_ERROR ("klb_load_wait","No Such Instructions any more!");};
}

/******************************************************************** PSL **
klb_load_wait_single Rgoal, imm_ofst, Reg, Lsusp

       written by f-doumae@icot22      on Wed Jul 12 14:38:45 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |    load_wait_single   |    Rgoal  |  imm_ofst | 
    +-----------+-----------+-----------+-----------+
    |	 Reg	|	  Lsusp         | don't care|
    +-----------+-----------+-----------+-----------+
<Arguments>
    Rgoal    : $B%4!<%k%l%3!<%I$r;X$9%]%$%s%?%l%8%9%?(B
    imm_ofst : $B0z?t$N%"%I%l%9%*%U%;%C%H(B
    Reg      : $B%l%8%9%?(B
    Lsusp    : $B%5%9%Z%s%I%i%Y%k(B

<Temporally Used Variables>
<Level>
<PreCondition>
    Rgoal \= Reg $B$H2>Dj$9$k!#(B
<Function>
    Rgoal$B$G;XDj$5$l$?%4!<%k%l%3!<%I$N%"%I%l%9%*%U%;%C%H(Bimm_ofst$B$K$"$k0z?t$NCM$r(B
    Reg$B$KFI$_9~$_!"%G%l%U$H=q$-La$7$r9T$&!#$3$N8e!"$b$70z?t$,L$Dj5A$J$i$P(B
    Lsusp$B$XJ,4t$9$k!#(B
<Examples>
<Test>
<Explanation>
    $B%4!<%k%l%3!<%I$NA`:n$r$9$kL?Na!#A`:n$NBP>]$H$9$k%4!<%k%l%3!<%I$O(B
    $BHFMQ%l%8%9%?$G;XDj$5$l$k!#>0!"%4!<%k%l%3!<%I$r;X$9%]%$%s%?$N(BMRB$B$O(B
    $BI,$:!{$J$N$G!"9=B$BN$NA`:n$H0[$J$j(BMRB$B$N%a%s%F%J%s%9$r$9$kI,MW$O$J$$!#(B
<ETC>
    $B%4!<%k%l%3!<%I$O0l<o$N9=B$BN$H9M$($k$3$H$,$G$-$k!#=>$C$F!"8=:_$3$NL?Na$O(B
    $B%]%9%H%3%s%Q%$%i$,(B read_srp_wait_single $B$KJQ49$7$F$$$k!#(B
    *************************************************
    *    load_wait_single --> read_srp_wait_single  *
    *************************************************
********************************************************************* PSL **/

#PSL_define klb_load_wait_single()
{
    @DEBUG{ VPIM_ERROR("klb_load_wait_single","No such instructions any more");};
}

/******************************************************************** PSL **
klb_load Rgoal, imm_ofst, Reg

       written by f-doumae@icot22      on Wed Jul 12 14:38:45 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |          load         |    Rgoal  |  imm_ofst | 
    +-----------+-----------+-----------+-----------+
    |	 Reg	|	     don't care             |
    +-----------+-----------+-----------+-----------+
<Arguments>
    Rgoal    : $B%4!<%k%l%3!<%I$r;X$9%]%$%s%?%l%8%9%?(B
    imm_ofst : $B0z?t$N%"%I%l%9%*%U%;%C%H(B
    Reg      : $B%l%8%9%?(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    Rgoal$B$G;XDj$5$l$?%4!<%k%l%3!<%I$N%"%I%l%9%*%U%;%C%H(Bimm_ofst$B$K$"$k0z?t$NCM$r(B
    Reg$B$KFI$_9~$`!#(B
<Examples>
<Test>
<Explanation>
<ETC>
    $B%4!<%k%l%3!<%I$O0l<o$N9=B$BN$H9M$($k$3$H$,$G$-$k!#=>$C$F!"8=:_$3$NL?Na$O(B
    $B%]%9%H%3%s%Q%$%i$,(B read_srp $B$KJQ49$7$F$$$k!#(B
    ************************
    *   load --> read_srp  *
    ************************
********************************************************************* PSL **/

#PSL_define klb_load()
{
    @DEBUG{ VPIM_ERROR("klb_load","No Such Instructions any more!");};
}

/******************************************************************** PSL **
klb_store Reg, Rgoal, imm_ofst

       written by f-doumae@icot22      on Wed Jul 12 13:34:01 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |         store         |    Reg    |   Rgoal   | 
    +-----------+-----------+-----------+-----------+
    |  imm_ofst |	     don't care             |
    +-----------+-----------+-----------+-----------+
<Arguments>
    Reg      : $B%l%8%9%?(B
    Rstr     : $B%4!<%k%l%3!<%I$r;X$9%]%$%s%?%l%8%9%?(B
    imm_ofst : $B0z?t$N%"%I%l%9%*%U%;%C%H(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    Reg$B$NCM$r(BRgoal$B$G;XDj$5$l$?%4!<%k%l%3!<%I$N(Bimm_ofst$BHVL\$N0z?t$K=q$-9~$`!#(B
<Examples>
<Test>
<Explanation>
<ETC>
    $B%4!<%k%l%3!<%I$O0l<o$N9=B$BN$H9M$($k$3$H$,$G$-$k!#=>$C$F!"8=:_$3$NL?Na$O(B
    $B%]%9%H%3%s%Q%$%i$,(B write $B$KJQ49$7$F$$$k!#(B
    *************************
    *   store --> write     *
    *************************
********************************************************************* PSL **/

#PSL_define klb_store()
{
    @DEBUG{ VPIM_ERROR("klb_store","No Such Instructions Any More!");};
}

/******************************************************************** PSL **
  4. $B:n6HMQ%a%b%j!"%l%8%9%?A`:n(B
klb_save Reg, imm_ofst

       written by f-doumae@icot22      on Wed Jul 12 16:10:07 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |         save          |    Reg    | imm_ofst  | 
    +-----------+-----------+-----------+-----------+

<Arguments>
    Reg      : $B%;!<%V$9$k(Bklb$B%l%8%9%?(B
    imm_ofst : klb$B%l%8%9%?%;!<%V%(%j%"$N%*%U%;%C%H(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    $B%l%8%9%?(BReg$B>e$N%G!<%?$r(Bklb$B%l%8%9%?%;!<%V%(%j%"$N%"%I%l%9%*%U%;%C%H(B
    imm_ofst $B$K=q$-9~$`!#(B
<Examples>
<Test>
<Explanation>
  $B0z?t%l%8%9%?$,ITB-$9$k;~$K!"%3%s%Q%$%i$,@8@.$9$kL?Na(B
<ETC>
********************************************************************* PSL **/
#OPF_define  I_RegSource     _IndirectRegField1
#OPF_define  I_ImmOffset     _ImmediateField2

#OPF_define  I_ImmRegSource  _ImmediateField1

#PSL_define klb_save()
{
  @PROBE2{ probe_increment_counter(D_PROBE_COUNTER_SAVE);};
  @DEBUG{
    b_IfRangeErr(I_ImmRegSource, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC ("klb_save","r1_range");
    }
    b_IfRangeErr(I_ImmOffset, _ZERO, _MAX_SAVE_AREA_OFFSET){
      OUT_OF_SPEC ("klb_save","r2_range");
    }
  };
  s_SaveKlbReg(I_RegSource, I_ImmOffset);
}

/******************************************************************** PSL **
klb_restore imm_ofst Reg

       written by f-doumae@icot22      on Wed Jul 12 16:11:17 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |        restore        | imm_ofst  |    Reg    |
    +-----------+-----------+-----------+-----------+

<Arguments>
    imm_ofst : klb$B%l%8%9%?%;!<%V%(%j%"$N@hF,$+$i$N%*%U%;%C%H(B
    Reg      : klb$B%l%8%9%?(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    klb$B%l%8%9%?%;!<%V%(%j%"$N%"%I%l%9%*%U%;%C%H(Bimm_ofst$B$N%G!<%?$r(B
    $B%l%8%9%?(BReg$B$K%m!<%I$9$k!#(B
<Examples>
<Test>
<Explanation>
  $B0z?t%l%8%9%?$,ITB-$9$k;~$K!"%3%s%Q%$%i$,@8@.$9$kL?Na(B
<ETC>
********************************************************************* PSL **/
#OPF_define  I_ImmOffset     _ImmediateField1
#OPF_define  I_RegSource     _IndirectRegField2

#OPF_define  I_ImmRegSource  _ImmediateField2

#PSL_define klb_restore()
{
  @PROBE2{ probe_increment_counter(D_PROBE_COUNTER_RESTORE);};
  @DEBUG{
    b_IfRangeErr(I_ImmRegSource, _ZERO, _MAX_ARG_REG_OF_KLB){
      OUT_OF_SPEC ("klb_restore","r2_range");
    }
    b_IfRangeErr(I_ImmOffset, _ZERO, _MAX_SAVE_AREA_OFFSET){
      OUT_OF_SPEC ("klb_restore","r1_range");
    }
  };
  s_RestoreKlbReg(I_ImmOffset,I_RegSource);
}

/******************************************************************** PSL **
klb_move Rsource, Rdest

       written by f-doumae@icot22      on Wed Jul 12 16:11:44 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |          move         |  Rsource  |   Rdest   | 
    +-----------+-----------+-----------+-----------+
<Arguments>
    Rsource : $B%=!<%9%l%8%9%?(B
    Rdest   : $B%G%9%F%#%M!<%7%g%s%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    Rsource$B$NFbMF!J%?%0$D$-%o!<%I!K$r(BRdest$B$K%3%T!<$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#OPF_define  I_RegSource     _IndirectRegField1
#OPF_define  I_RegDest       _IndirectRegField2

#OPF_define  I_ImmRegSource  _ImmediateField1
#OPF_define  I_ImmRegDest    _ImmediateField2

#PSL_define klb_move()
{
  @DEBUG {
    b_IfRangeErr(I_ImmRegSource, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_move", "r1 range");
    }
    b_IfRangeErr(I_ImmRegDest, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_move", "r2 range");
    }
   };
  p_MoveWord(I_RegSource, I_RegDest);
}
