
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V05/interpreter/klb_alloc.psl.c
   ----- CREATED   : by f-hataza@icot22, on Fri May 11 17:15:00 1990
   ----- LAST SAVED: by f-hataza@icot22, on Mon Sep  3 12:17:21 1990
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : INTERPRETER
   ----- ABSTRACT  : $B9=B$BN(B, $BJQ?t$N3d$jEv$F(B

  klb_alloc_list (Reg)
  klb_alloc_vector (size, Reg)
  klb_alloc_variable (Reg)
  klb_alloc_void (Reg)

 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
klb_alloc_list Reg
 
       written by f-doumae@icot22      on Mon Jul 10 15:22:42 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |       alloc_list      |   Reg     | don't care| 
    +-----------+-----------+-----------+-----------+
<Arguments>
    Reg : $B%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    $B?7$?$K%j%9%H$r3d$jIU$1!"$=$N%j%9%H$r;X$9!{%]%$%s%?$r(BReg$B$K=q$-9~$`!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_RegDest     _IndirectRegField1
#OPF_define I_ImmRegDest  _ImmediateField1

#PSL_define  klb_alloc_list()
{
  @DEBUG {
    b_IfRangeErr(I_ImmRegDest, _ZERO ,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_alloc_list", "r1 range");
    }
  };
  s_AllocList(I_RegDest);
}

/******************************************************************** PSL **
klb_alloc_vector  size, Reg

       written by f-doumae@icot22      on Mon Jul 10 15:36:52 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |     alloc_vector      |   size    |   Reg     | 
    +-----------+-----------+-----------+-----------+

<Arguments>
    size  : $B3dEv$F$k%Y%/%?$NMWAG?t(B($B@0?t(B)
    Reg   : $B%l%8%9%?(B

<Temporally Used Variables>
    D_WorkVectSize : $B%Y%/%?%5%$%:3JG<MQ%l%8%9%?(B
<Level>
<PreCondition>
    $B3d$jEv$F$kMWAG%5%$%:$O%3%s%Q%$%i$K$h$C$F%A%'%C%/$5$l$F$$$k!#(B(0 ~ 255)
<Function>
    $B?7$?$KMWAG?t$,(B size $B$N%Y%/%?$r3d$jIU$1!"$=$3$X$N!{%]%$%s%?$r(B
    Reg$B$K=q$-9~$`!#(B
<Examples>
<Test>
<Explanation>
    $B<B:]$N%^%7%sL?Na$G$O(B, $B3d$jEv$F$k%Y%/%?$N%5%$%:Kh$KJL$NL?Na$H$9$k(B.
<ETC>
********************************************************************* PSL **/

#OPF_define I_ImmSize      _ImmediateField1
#OPF_define I_RegDest      _IndirectRegField2
#OPF_define I_ImmRegDest   _ImmediateField2

#PSL_define klb_alloc_vector()
{
  @DEBUG {
    b_IfRangeErr(I_ImmRegDest, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_alloc_vector", "r1 range");
    }
    $USE(D_WorkVectSize);
    b_MoveImmOprWithMRBandType (I_ImmSize, _MRB_OFF, INT, D_WorkVectSize);    
    b_IfLessImm(D_WorkVectSize, _ZERO){
      VPIM_ERROR("klb_alloc_vector","size_underflow");
    }
    b_IfGreaterEqImm(D_WorkVectSize, _SIZE_OF_HEAP_PAGE){
      VPIM_ERROR("klb_alloc_vector","size_overflow");
    }
    $RELEASE(D_WorkVectSize);
  };
  f_AllocVectorOpr(I_RegDest, I_ImmSize);
}

/******************************************************************** PSL **
klb_alloc_variable Reg

       written by f-doumae@icot22      on Mon Jul 10 15:52:01 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |     alloc_variable    |   Reg     | don't care| 
    +-----------+-----------+-----------+-----------+

<Arguments>
    Reg : $B%l%8%9%?(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    $B?7$?$KJQ?t%;%k$r3d$jIU$1!"$=$3$X$N(BREF$B!{%]%$%s%?$r(BReg$B$K=q$-9~$`!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_RegDest     _IndirectRegField1
#OPF_define I_ImmRegDest  _ImmediateField1

#PSL_define klb_alloc_variable()
{
  @DEBUG {
    b_IfRangeErr(I_ImmRegDest, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_alloc_variable", "r1 range");
    }
  };
  s_AllocVariable(I_RegDest);
}

/******************************************************************** PSL **
klb_alloc_void Reg

       written by f-doumae@icot22      on Mon Jul 10 16:00:37 1989

    0           1           2           3           4
    +-----------+-----------+-----------+-----------+
    |      alloc_void       |   Reg     | don't care| 
    +-----------+-----------+-----------+-----------+
<Arguments>
    Reg : $B%l%8%9%?(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    $B?7$?$K(BVOID$B%;%k$r3d$jIU$1!"$=$3$X$N(BREF$B!{%]%$%s%?$r(BReg$B$K=q$-9~$`!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#OPF_define I_RegDest      _IndirectRegField1
#OPF_define I_ImmRegDest   _ImmediateField1

#PSL_define klb_alloc_void() 
{
  @DEBUG {
    b_IfRangeErr(I_ImmRegDest, _ZERO,_MAX_ARG_REG_OF_KLB) {
      OUT_OF_SPEC ("klb_alloc_void", "r1 range");
    }
  };
  s_AllocVoid(I_RegDest);
}
