
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_shoen_with_fp.psl.c
   ----- CREATED   : by kawai@icot21, on Fri Jun  1 22:05:30 1990
   ----- LAST SAVED: by kawai@icot22, on Wed Mar 11 21:00:41 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : 
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **

       written by kawai@icot21      on Fri Jun  1 22:05:47 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define    D_WorkParentFPReg   XXX
#DATA_define    D_WorkShoenReturnResourceUpperReg  XXX
#DATA_define    D_WorkShoenReturnResourceLowerReg  XXX
#DATA_define    D_WorkShoenConsumedResourceDiffUpperReg  XXX
#DATA_define    D_WorkShoenConsumedResourceDiffLowerReg  XXX


/* !! $BAq1`=*7k;~$N%m%C%/4|4V3HBg$N$?$a$N?7%5%V%k!<%A%s(B */
#SUBARG_define A_PtrToShoenRecord   SRC
#SUBARG_define A_ShoenOrgLockTagReg SRC

#SUBROUTINE f_ShoenTerminateWithUnlock_Sub(A_PtrToShoenRecord,
					   A_ShoenOrgLockTagReg){
  @DEBUG{
    WARNING("f_ShoenTerminateWithUnlock_Sub","Shoen Begun to Terminate");
  };

  s_PutShoenTransitStatusImmediately(A_PtrToShoenRecord, _TERMINATED);

  $USE(D_WorkParentFPReg); 
  $USE(D_WorkShoenReturnResourceUpperReg);
  $USE(D_WorkShoenReturnResourceLowerReg);
  $USE(D_WorkShoenConsumedResourceDiffUpperReg);
  $USE(D_WorkShoenConsumedResourceDiffLowerReg);

  /* $BAq1`%l%3!<%I$r?FN$?F$N;RAq1`%j%s%/$+$i=|$/$?$a$NM=Ls$r$9$k!#(B */
  s_ReserveUnhookShoenRecord(A_PtrToShoenRecord);

  s_GetFPRecordOfShoen(A_PtrToShoenRecord, D_WorkParentFPReg);

  /*  $B2<$N%k!<%A%s$GAq1`%l%3!<%I$,2rJ|$5$l$k2DG=@-$,$"$k$?$a!"(B
      $B@h$K;q8;;DNL$r<h$j=P$7$F$*$/!#(B
  */
  s_GetShoenResourceLeft(A_PtrToShoenRecord, D_WorkShoenReturnResourceUpperReg,
			                    D_WorkShoenReturnResourceLowerReg);
  s_GetShoenResourceConsumedWithUpdate(A_PtrToShoenRecord, 
				       D_WorkShoenConsumedResourceDiffUpperReg,
				      D_WorkShoenConsumedResourceDiffLowerReg);

  s_IfShoenStatusFlagOn(A_PtrToShoenRecord,
				          _NO_MORE_EXTERNAL_EVENT_FLAG_MASK)
    { /* $B$9$G$KAq1`$N%3%s%H%m!<%k%9%H%j!<%`$,JD$8$i$l$F$$$?$i(B */
      /* $B$3$N;~E@$GAq1`%l%3!<%I$r2s<}$9$k(B */

      f_ReportShoenMessage(A_PtrToShoenRecord, _TERMINATED_REP);
      f_ReportShoenReturnResourceAtTermination(A_PtrToShoenRecord);
      f_CloseReportStream(A_PtrToShoenRecord);
      s_UnlockShoenRecord(A_PtrToShoenRecord, A_ShoenOrgLockTagReg);
      f_UnhookShoenFromFPChildLink(A_PtrToShoenRecord, D_WorkParentFPReg);

      @DEBUG{
	_PrintSHInfo(A_PtrToShoenRecord);
	WARNING("f_ShoenTerminateWithUnlock_Sub",
		"Shoen Record will be Reclaimed");
      };
      s_ReclaimShoenRecord(A_PtrToShoenRecord);
    }
  else
    { /* $B$^$@Aq1`$N%3%s%H%m!<%k%9%H%j!<%`$,JD$8$i$l$F$$$J$+$C$?$i(B */
      /* $B%3%s%H%m!<%k%9%H%j!<%`$,JD$8$i$l$?;~E@$GAq1`%l%3!<%I$r2s<}$9$k(B */

      f_ReportShoenMessage(A_PtrToShoenRecord, _TERMINATED_REP);
      s_UnlockShoenRecord(A_PtrToShoenRecord, A_ShoenOrgLockTagReg);
      f_UnhookShoenFromFPChildLink(A_PtrToShoenRecord, D_WorkParentFPReg);

      s_LockShoenRecord(A_PtrToShoenRecord, A_ShoenOrgLockTagReg);
      s_NonReserveUnhookShoenRecord(A_PtrToShoenRecord);
      s_IfShoenStatusFlagOn(A_PtrToShoenRecord,
			    _NO_MORE_EXTERNAL_EVENT_FLAG_MASK){
	s_UnlockShoenRecord(A_PtrToShoenRecord, A_ShoenOrgLockTagReg);
	@DEBUG{
	  _PrintSHInfo(A_PtrToShoenRecord);
	  WARNING("f_ShoenTerminateWithUnlock_Sub",
		  "Shoen Record will be Reclaimed");
	};
	s_ReclaimShoenRecord(A_PtrToShoenRecord);
      }else{
	s_UnlockShoenRecord(A_PtrToShoenRecord, A_ShoenOrgLockTagReg);
      }
    }

  /* $BAq1`$N;q8;;DNL$r?FN$?F$KJV5Q$9$k!#(B
       $BF1;~$K!"$3$NAq1`$KBP$9$k?FN$?F$+$i$N:G?7$N;q8;Ld$$9g$o$;8e$+$i!"Aq1`(B
     $B=*7k;~$^$G$K$3$NAq1`(B($BN$?F(B)$B$,?7$?$K>CHq$7$?;q8;NL$r?FN$?F$KEO$7!"?FN$?F$N(B
     $B>CHq;q8;NL$K2C$($F$b$i$&!#(B
  */
  f_FPResourceSuppliedByShoenTermination(D_WorkParentFPReg,
					  D_WorkShoenReturnResourceUpperReg,
					  D_WorkShoenReturnResourceLowerReg,
				      D_WorkShoenConsumedResourceDiffUpperReg,
				      D_WorkShoenConsumedResourceDiffLowerReg);
  $RELEASE(D_WorkShoenReturnResourceUpperReg);
  $RELEASE(D_WorkShoenReturnResourceLowerReg);
  $RELEASE(D_WorkShoenConsumedResourceDiffUpperReg);
  $RELEASE(D_WorkShoenConsumedResourceDiffLowerReg);

  f_CheckFPTermination(D_WorkParentFPReg);
  $RELEASE(D_WorkParentFPReg); 

  $RETURN();
}

/* !! $B>e5-%5%V%k!<%A%s$K$h$jGQ;_(B  '92.2.17
#SUBARG_define A_PtrToShoenRecord	MODIFY	 /!* ??? SRC ??? *!/

/!*****************************************************************************
 $B@5<0HG$NAq1`=*7k%k!<%A%s(B
   $B%3%s%H%m!<%k(B/$B%l%]!<%H%4!<%k$N%G%P%0$,40N;$9$k$^$G$O;CDj%k!<%A%s$rMQ$$$k(B
*****************************************************************************!/

/!* $B@5<0HG%5%]!<%H(B 90-10-30 reki *!/

#SUBROUTINE  f_ShoenTerminate_Sub(A_PtrToShoenRecord)
{
  @DEBUG{
    WARNING("f_ShoenTerminate_Sub","Shoen Begun to Terminate");
  };

  $USE(D_WorkShoenOrgLockTagReg);
  s_LockShoenRecord(A_PtrToShoenRecord, D_WorkShoenOrgLockTagReg);
  s_PutShoenTransitStatusImmediately(A_PtrToShoenRecord, _TERMINATED);

  $USE(D_WorkParentFPReg); 
  $USE(D_WorkShoenReturnResourceUpperReg);
  $USE(D_WorkShoenReturnResourceLowerReg);
  $USE(D_WorkShoenConsumedResourceDiffUpperReg);
  $USE(D_WorkShoenConsumedResourceDiffLowerReg);

  /!* $BAq1`%l%3!<%I$r?FN$?F$N;RAq1`%j%s%/$+$i=|$/$?$a$NM=Ls$r$9$k!#(B *!/
  s_ReserveUnhookShoenRecord(A_PtrToShoenRecord);

  s_GetFPRecordOfShoen(A_PtrToShoenRecord, D_WorkParentFPReg);

  /!*  $B2<$N%k!<%A%s$GAq1`%l%3!<%I$,2rJ|$5$l$k2DG=@-$,$"$k$?$a!"(B
      $B@h$K;q8;;DNL$r<h$j=P$7$F$*$/!#(B
  *!/
  s_GetShoenResourceLeft(A_PtrToShoenRecord, D_WorkShoenReturnResourceUpperReg,
			                    D_WorkShoenReturnResourceLowerReg);
  s_GetShoenResourceConsumedWithUpdate(A_PtrToShoenRecord, 
				       D_WorkShoenConsumedResourceDiffUpperReg,
				      D_WorkShoenConsumedResourceDiffLowerReg);

  s_IfShoenStatusFlagOn(A_PtrToShoenRecord,
				          _NO_MORE_EXTERNAL_EVENT_FLAG_MASK)
    { /!* $B$9$G$KAq1`$N%3%s%H%m!<%k%9%H%j!<%`$,JD$8$i$l$F$$$?$i(B *!/
      /!* $B$3$N;~E@$GAq1`%l%3!<%I$r2s<}$9$k(B *!/

      f_ReportShoenMessage(A_PtrToShoenRecord, _TERMINATED_REP);
      f_ReportShoenReturnResourceAtTermination(A_PtrToShoenRecord);
      f_CloseReportStream(A_PtrToShoenRecord);
      s_UnlockShoenRecord(A_PtrToShoenRecord, D_WorkShoenOrgLockTagReg);
      $RELEASE(D_WorkShoenOrgLockTagReg);
      f_UnhookShoenFromFPChildLink(A_PtrToShoenRecord, D_WorkParentFPReg);

      @DEBUG{
	_PrintSHInfo(A_PtrToShoenRecord);
	WARNING("f_ShoenTerminate_Sub","Shoen Record will be Reclaimed");
      };

      s_ReclaimShoenRecord(A_PtrToShoenRecord);

    }
  else
    { /!* $B$^$@Aq1`$N%3%s%H%m!<%k%9%H%j!<%`$,JD$8$i$l$F$$$J$+$C$?$i(B *!/
      /!* $B%3%s%H%m!<%k%9%H%j!<%`$,JD$8$i$l$?;~E@$GAq1`%l%3!<%I$r2s<}$9$k(B *!/

      f_ReportShoenMessage(A_PtrToShoenRecord, _TERMINATED_REP);
      s_UnlockShoenRecord(A_PtrToShoenRecord, D_WorkShoenOrgLockTagReg);
      $RELEASE(D_WorkShoenOrgLockTagReg);
      f_UnhookShoenFromFPChildLink(A_PtrToShoenRecord, D_WorkParentFPReg);

      $USE(D_WorkShoenOrgLockTagReg);
      s_LockShoenRecord(A_PtrToShoenRecord, D_WorkShoenOrgLockTagReg);
      s_NonReserveUnhookShoenRecord(A_PtrToShoenRecord);
      s_IfShoenStatusFlagOn(A_PtrToShoenRecord,
			    _NO_MORE_EXTERNAL_EVENT_FLAG_MASK){
	s_UnlockShoenRecord(A_PtrToShoenRecord, D_WorkShoenOrgLockTagReg);
	@DEBUG{
	  _PrintSHInfo(A_PtrToShoenRecord);
	  WARNING("f_ShoenTerminate_Sub","Shoen Record will be Reclaimed");
	};
	s_ReclaimShoenRecord(A_PtrToShoenRecord);
      }else{
	s_UnlockShoenRecord(A_PtrToShoenRecord, D_WorkShoenOrgLockTagReg);
      }
      $RELEASE(D_WorkShoenOrgLockTagReg);

    }

  /!* $BAq1`$N;q8;;DNL$r?FN$?F$KJV5Q$9$k!#(B
       $BF1;~$K!"$3$NAq1`$KBP$9$k?FN$?F$+$i$N:G?7$N;q8;Ld$$9g$o$;8e$+$i!"Aq1`(B
     $B=*7k;~$^$G$K$3$NAq1`(B($BN$?F(B)$B$,?7$?$K>CHq$7$?;q8;NL$r?FN$?F$KEO$7!"?FN$?F$N(B
     $B>CHq;q8;NL$K2C$($F$b$i$&!#(B
  *!/
  f_FPResourceSuppliedByShoenTermination(D_WorkParentFPReg,
					  D_WorkShoenReturnResourceUpperReg,
					  D_WorkShoenReturnResourceLowerReg,
				      D_WorkShoenConsumedResourceDiffUpperReg,
				      D_WorkShoenConsumedResourceDiffLowerReg);
  $RELEASE(D_WorkShoenReturnResourceUpperReg);
  $RELEASE(D_WorkShoenReturnResourceLowerReg);
  $RELEASE(D_WorkShoenConsumedResourceDiffUpperReg);
  $RELEASE(D_WorkShoenConsumedResourceDiffLowerReg);

  f_CheckFPTermination(D_WorkParentFPReg);
  $RELEASE(D_WorkParentFPReg); 

  $RETURN();
}

/*****************************************************************************
  $B%3%s%H%m!<%k(B/$B%l%]!<%H%4!<%k$N%G%P%0$,40N;$9$k$^$G$N;CDj%k!<%A%s(B
*****************************************************************************/

/********* $B@5<0HG%5%]!<%H$K$D$-%3%a%s%H2=(B 90-10-30 reki ******************

#SUBROUTINE  f_ShoenTerminate_Sub(A_PtrToShoenRecord)
{
  @DEBUG{
    WARNING("f_ShoenTerminate_Sub","Shoen Begun to Terminate");
  };

  $USE(D_WorkShoenOrgLockTagReg);
  s_LockShoenRecord(A_PtrToShoenRecord, D_WorkShoenOrgLockTagReg);
  s_PutShoenTransitStatusImmediately(A_PtrToShoenRecord, _TERMINATED);

  $USE(D_WorkParentFPReg); 
  $USE(D_WorkShoenReturnResourceUpperReg);
  $USE(D_WorkShoenReturnResourceLowerReg);
  $USE(D_WorkShoenConsumedResourceDiffUpperReg);
  $USE(D_WorkShoenConsumedResourceDiffLowerReg);

  /!* $BAq1`%l%3!<%I$r?FN$?F$N;RAq1`%j%s%/$+$i=|$/$?$a$NM=Ls$r$9$k!#(B *!/
  s_ReserveUnhookShoenRecord(A_PtrToShoenRecord);

  s_GetFPRecordOfShoen(A_PtrToShoenRecord, D_WorkParentFPReg);

  /!*  $B2<$N%k!<%A%s$GAq1`%l%3!<%I$,2rJ|$5$l$k2DG=@-$,$"$k$?$a!"(B
      $B@h$K;q8;;DNL$r<h$j=P$7$F$*$/!#(B
  *!/
  s_GetShoenResourceLeft(A_PtrToShoenRecord, D_WorkShoenReturnResourceUpperReg,
			                    D_WorkShoenReturnResourceLowerReg);
  s_GetShoenResourceConsumedWithUpdate(A_PtrToShoenRecord, 
				       D_WorkShoenConsumedResourceDiffUpperReg,
				      D_WorkShoenConsumedResourceDiffLowerReg);

  /!*
      $B0J2<$NItJ,$O!"@5<0HG$G$O%3%s%H%m!<%k%9%H%j!<%`$,4{$KJD$8$i$l$F$$$k$+H]$+(B
      $B$rH=Dj$7$F!"(B
      $B!&JD$8$i$l$F$$$l$P!"$3$N;~E@$GAq1`%l%3!<%I$r2s<}$9$k(B
      $B!&JD$8$i$l$F$$$J$1$l$P!"%3%s%H%m!<%k%9%H%j!<%`$,JD$8$i$l$?;~E@$GAq1`(B
        $B%l%3!<%I$r2s<}$9$k(B
      $B$H$$$&=hM}FbMF$H$J$k!#(B
  *!/

  /!** report "shoen_terminated" **!/
  f_ReportShoenMessage(A_PtrToShoenRecord, _TERMINATED_REP);
  f_CloseReportStream(A_PtrToShoenRecord);
  s_UnlockShoenRecord(A_PtrToShoenRecord, D_WorkShoenOrgLockTagReg);
  $RELEASE(D_WorkShoenOrgLockTagReg);
  f_UnhookShoenFromFPChildLink(A_PtrToShoenRecord, D_WorkParentFPReg);

  @DEBUG{
    WARNING("f_ShoenTerminate_Sub","Shoen Record will be Reclaimed");
  };

  s_ReclaimShoenRecord(A_PtrToShoenRecord);

  /!* $BAq1`$N;q8;;DNL$r?FN$?F$KJV5Q$9$k!#(B
       $BF1;~$K!"$3$NAq1`$KBP$9$k?FN$?F$+$i$N:G?7$N;q8;Ld$$9g$o$;8e$+$i!"Aq1`(B
     $B=*7k;~$^$G$K$3$NAq1`(B($BN$?F(B)$B$,?7$?$K>CHq$7$?;q8;NL$r?FN$?F$KEO$7!"?FN$?F$N(B
     $B>CHq;q8;NL$K2C$($F$b$i$&!#(B
  *!/
  f_FPResourceSuppliedByShoenTermination(D_WorkParentFPReg,
					  D_WorkShoenReturnResourceUpperReg,
					  D_WorkShoenReturnResourceLowerReg,
				      D_WorkShoenConsumedResourceDiffUpperReg,
				      D_WorkShoenConsumedResourceDiffLowerReg);
  $RELEASE(D_WorkShoenReturnResourceUpperReg);
  $RELEASE(D_WorkShoenReturnResourceLowerReg);
  $RELEASE(D_WorkShoenConsumedResourceDiffUpperReg);
  $RELEASE(D_WorkShoenConsumedResourceDiffLowerReg);

  f_CheckFPTermination(D_WorkParentFPReg);
  $RELEASE(D_WorkParentFPReg); 

  $RETURN();
}

******************************* $B;CDjHG$G$9(B ******************************/

/******************************************************************** PSL **

       written by kawai@icot22      on Mon Jun  4 12:31:23 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define  f_DistributeShoenResource(shoen_record)
{
  $USE(D_WorkShoenOrgLockTagReg);
  s_LockShoenRecord(shoen_record, D_WorkShoenOrgLockTagReg);
  /* !! */
  $CALL( f_Send_IntClMsg_SupplyResource_ToResourceRequestFPs_Sub
	                                                (shoen_record) );
/* !!  $CALL( f_DistributeShoenResourceWithoutLock_Sub(shoen_record) ); */

  s_UnlockShoenRecord(shoen_record, D_WorkShoenOrgLockTagReg);
  $RELEASE(D_WorkShoenOrgLockTagReg);
}

/******************************************************************** PSL **

       written by kawai@icot22      on Fri Jun 15 17:10:45 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define  D_WorkShoenResReqFPTable  XXX
#DATA_define  D_WorkDestTableVect  XXX
#DATA_define  D_WorkResReqTableVectSize  XXX

/* Original
#SUBARG_define  A_PtrToShoenRecord  SRC

#SUBROUTINE  f_DistributeShoenResourceWithoutLock_Sub(A_PtrToShoenRecord)
{
  s_IfShoenStatusFlagOn(A_PtrToShoenRecord, _RSC_REQ_FP_EXISTANCE_FLAG_MASK)
    { /!* $BN$?F$NCf$G;q8;MW5a$NK~$?$5$l$F$$$J$$$b$N$,$"$l$P(B *!/
      $USE(D_WorkShoenResReqFPTable);
      s_GetResourceRequestFPTable(A_PtrToShoenRecord,
				                   D_WorkShoenResReqFPTable);
      $USE(D_WorkResReqTableVectSize);
      s_GetSizeVectType(D_WorkShoenResReqFPTable, D_WorkResReqTableVectSize);
      $USE(D_WorkDestTableVect);
      $CALL( f_AllocVectorMRBoff_Sub(D_WorkResReqTableVectSize,
				                       D_WorkDestTableVect));
      f_ReplicateSupplyResourceDestinations(A_PtrToShoenRecord,
					D_WorkShoenResReqFPTable,
					D_WorkResReqTableVectSize,
					                  D_WorkDestTableVect);
      $RELEASE(D_WorkShoenResReqFPTable);
      f_Send_IntClMsg_FPs(A_PtrToShoenRecord, _NW_SUPPLY_RESOURCE,
				                          D_WorkDestTableVect);
      s_MaintainResReqFPTable(A_PtrToShoenRecord, D_WorkDestTableVect);
      b_IfLessEqImm(D_WorkResReqTableVectSize, _MAX_SIZE_OF_SVECT)
	{
	  s_ReclaimShortVector(D_WorkDestTableVect);
	}
      else
	{
	  s_ReclaimLongVector(D_WorkResReqTableVectSize, D_WorkDestTableVect);
	}
      $RELEASE(D_WorkDestTableVect);
      $RELEASE(D_WorkResReqTableVectSize);
    }
  $RETURN ();
}
*/

/* !! Moved to f_int_cl_send_control.psl.c on 11/22 1991 */

/* !! $BGQ;_(B  on 3/2 1992
   #SUBROUTINE f_Send_IntClMsg_SupplyResource_ToResourceRequestFPs_Sub
                                                       (A_PtrToShoenRecord) 
   in f_int_cl_send_control.psl.c
   $B$r$D$+$&$3$H(B
*/

/******************************************************************** PSL **

       written by kawai@icot22      on Tue Jun 12 15:52:16 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define  D_WorkTableElementPosition  XXX
#DATA_define  D_WorkRscCheckResult  XXX
/* !! #DATA_define  D_WorkReplicationResult  XXX  */
#DATA_define  D_WorkTableElement  XXX
#DATA_define  D_WorkNewTableElement  XXX
#DATA_define  D_WorkFlagPosition  XXX

/* !! #CONST_define  _NORMAL_REPLICATION    0  */     /* $BJ#@=@5>o=*N;(B */
/* #CONST_define  _ABNORMAL_REPLICATION  1 */ /* $BJ#@=0[>o=*N;(B */
#CONST_define  _SUFFICIENT_RESOURCE   0       /* $BAq1`;D;q8;$"$j(B */
#CONST_define  _RESOURCE_SHORT        1       /* $BAq1`;D;q8;$J$7(B */
#CONST_define  _RESOURCE_LIMIT_OVER   2       /* resource_low$BJs9p$NMW$"$j(B */

/* Original
#PSL_define  f_ReplicateSupplyResourceDestinations(shoen_record, res_req_table,
						        table_size, dest_table)
{
  $USE(D_WorkTableElementPosition);
  p_MoveValue(table_size, D_WorkTableElementPosition);
  $USE(D_WorkRscCheckResult);
  $USE(D_WorkReplicationResult);
  p_SetImmediateValue(_SUFFICIENT_RESOURCE, D_WorkRscCheckResult);
  p_SetImmediateValue(_NORMAL_REPLICATION, D_WorkReplicationResult);
  LOOP()	/!* $B30B&%k!<%W(B ($B%Y%/%?$NMWAG?tJ,2s$k(B) *!/
    {
      b_DecrementReg(D_WorkTableElementPosition);
      ValueSwitch(D_WorkRscCheckResult)
	{
	 case _SUFFICIENT_RESOURCE :	/!* $B@5>o>uBV(B *!/
	   b_IfLess(D_WorkTableElementPosition, D_NULL) {goto OuterLoopEnd;}
	   $USE(D_WorkTableElement);
	   s_GetVectElementPosReg(res_req_table, D_WorkTableElementPosition,
			                                  D_WorkTableElement);
	   b_IfNotEqual(D_WorkTableElement, D_NULL)
	     {
	       $USE(D_WorkFlagPosition);
	       p_SetImmediateValue(_WORD_BIT_LENGTH, D_WorkFlagPosition);
	       $USE(D_WorkNewTableElement);
	       p_MoveValue(D_NULL, D_WorkNewTableElement);
	       LOOP()	/!* $BFbB&%k!<%W(B (1$B%o!<%ICf$N%S%C%H?t(B 32 $B2s(B) *!/
		 {
		   b_DecrementReg(D_WorkFlagPosition);
		   b_IfLess(D_WorkFlagPosition, D_NULL)
		     {
		       s_PutVectElementPosReg(dest_table,
					 D_WorkTableElementPosition,
					              D_WorkNewTableElement);
		       break;
		     }
		   b_IfFlagOnPosReg(D_WorkTableElement, D_WorkFlagPosition)
		     {
		       f_SetNewFlagWithResourceLeftCheck(shoen_record,
						         D_WorkNewTableElement,
						         D_WorkFlagPosition,
							 D_WorkRscCheckResult);
		     }
		 }
	       $RELEASE(D_WorkFlagPosition);
	       $RELEASE(D_WorkNewTableElement);
	     }
 	   else
	     {
	       s_PutVectElementPosReg(dest_table, D_WorkTableElementPosition,
				                                      D_NULL);
	     }
	   $RELEASE(D_WorkTableElement);
	   break;

	 case _RESOURCE_SHORT :
              /!* $B$"$2$l$k%j%=!<%9$,$J$/$J$C$?8e$N>uBV(B($B%j%_%C%H<jA0(B) *!/
	   p_SetImmediateValue(_RESOURCE_SHORT, D_WorkReplicationResult);
	   b_IfLess(D_WorkTableElementPosition, D_NULL) {goto OuterLoopEnd;}
	   s_PutVectElementPosReg(dest_table, D_WorkTableElementPosition,
				                                      D_NULL);
	   break;

	 case _RESOURCE_LIMIT_OVER :
              /!* $B$"$2$l$k%j%=!<%9$,$J$/$J$C$?8e$N>uBV(B($B%j%_%C%H$r1[$($?(B) *!/
	   s_IfShoenStatusFlagOff(shoen_record, _RSC_REP_DISALLOWED_FLAG_MASK)
	     {
	       s_SetShoenStatusFlag(shoen_record,
				               _RSC_REP_DISALLOWED_FLAG_MASK);
	       f_ReportShoenMessage(shoen_record, _RSC_LOW_REP);
	     }
	   p_SetImmediateValue(_ABNORMAL_REPLICATION, D_WorkReplicationResult);
	   b_IfLess(D_WorkTableElementPosition, D_NULL) {goto OuterLoopEnd;}
	   s_PutVectElementPosReg(dest_table, D_WorkTableElementPosition,
				                                      D_NULL);
	   break;

	 default :
	   @DEBUG{ VPIM_ERROR("f_ReplicateSupplyResourceDestinations",
			      "Illegal Shoen Resource Check Result"); };
	   break;
	 }
    }

 OuterLoopEnd:
  b_IfEqualImm(D_WorkReplicationResult, _NORMAL_REPLICATION)
    {
      s_ResetShoenStatusFlag(shoen_record, _RSC_REQ_FP_EXISTANCE_FLAG_MASK);
    }
  $RELEASE(D_WorkTableElementPosition);
  $RELEASE(D_WorkRscCheckResult);
  $RELEASE(D_WorkReplicationResult);
}
*/

/* !! */
#PSL_define  f_ReplicateSupplyResourceDestinations(shoen_record, 
						   res_req_table_upper,
						   res_req_table_lower,
						   dest_table_upper,
						   dest_table_lower)
{
  $USE(D_WorkRscCheckResult);
  p_SetImmediateValue(_SUFFICIENT_RESOURCE, D_WorkRscCheckResult);

  /* upper word */
  f_ReplicateOneWordDestinations(shoen_record, res_req_table_upper,
				 dest_table_upper, D_WorkRscCheckResult);

  /* check D_WorkRscCheckResult for upper word */
  ValueSwitch(D_WorkRscCheckResult)
    {
     case _SUFFICIENT_RESOURCE :	/* $B@5>o>uBV(B */
       /* lower word */
       /* $B$b$7$3$NCf$G;q8;$,ITB-$7$?$i(B
            D_WorkRscCheckResult = _RESOURCE_SHORT/_RESOURCE_LIMIT_OVER
          $B$KJQ$o$k!#(B */
       f_ReplicateOneWordDestinations(shoen_record, res_req_table_lower,
				      dest_table_lower, D_WorkRscCheckResult);
       break;

     case _RESOURCE_SHORT :
       /* $B$"$2$l$k%j%=!<%9$,$J$/$J$C$?8e$N>uBV(B($B%j%_%C%H<jA0(B) */
       p_MoveValue(D_NULL, dest_table_lower);
       break;

     case _RESOURCE_LIMIT_OVER :
       /* $B$"$2$l$k%j%=!<%9$,$J$/$J$C$?8e$N>uBV(B($B%j%_%C%H$r1[$($?(B)*/
       s_IfShoenStatusFlagOff(shoen_record, _RSC_REP_DISALLOWED_FLAG_MASK)
	 {
	   s_SetShoenStatusFlag(shoen_record, _RSC_REP_DISALLOWED_FLAG_MASK);
	   f_ReportShoenMessage(shoen_record, _RSC_LOW_REP);
	 }
       p_MoveValue(D_NULL, dest_table_lower);
       break;

     default :
       @DEBUG{ VPIM_ERROR("f_ReplicateSupplyResourceDestinations",
			  "Illegal Shoen Resource Check Result in upper word"); };
       break;
     }

  /* check D_WorkRscCheckResult for lower word */
  ValueSwitch(D_WorkRscCheckResult)
    {
     case _SUFFICIENT_RESOURCE :	/* $B@5>o>uBV(B */
       s_ResetShoenStatusFlag(shoen_record, _RSC_REQ_FP_EXISTANCE_FLAG_MASK);
       break;

     case _RESOURCE_LIMIT_OVER :
       /* $B$"$2$l$k%j%=!<%9$,$J$/$J$C$?8e$N>uBV(B($B%j%_%C%H$r1[$($?(B)*/
       s_IfShoenStatusFlagOff(shoen_record, _RSC_REP_DISALLOWED_FLAG_MASK)
	 {
	   s_SetShoenStatusFlag(shoen_record, _RSC_REP_DISALLOWED_FLAG_MASK);
	   f_ReportShoenMessage(shoen_record, _RSC_LOW_REP);
	 }
       break;

     case _RESOURCE_SHORT :
       /* $B$"$2$l$k%j%=!<%9$,$J$/$J$C$?8e$N>uBV(B($B%j%_%C%H<jA0(B) */
       break;

     default :
       @DEBUG{ VPIM_ERROR("f_ReplicateSupplyResourceDestinations",
			  "Illegal Shoen Resource Check Result in lower word"); };
       break;
     }

  $RELEASE(D_WorkRscCheckResult);
}


/* !! $B?75,:n@.(B */
#PSL_define  f_ReplicateOneWordDestinations(shoen_record, res_req_table_word,
					    dest_table_word, rsc_check_result)
{
  p_MoveValue(D_NULL, dest_table_word);
  b_IfNotEqual(res_req_table_word, D_NULL)
    {
      $USE(D_WorkFlagPosition);
      p_SetImmediateValue(_WORD_BIT_LENGTH, D_WorkFlagPosition);
      LOOP()	/* $BFbB&%k!<%W(B (1$B%o!<%ICf$N%S%C%H?t(B 32 $B2s(B) */
	{
	  b_DecrementReg(D_WorkFlagPosition);
	  b_IfLess(D_WorkFlagPosition, D_NULL) {break;}
	  b_IfFlagOnPosReg(res_req_table_word, D_WorkFlagPosition)
	    {
	      f_SetNewFlagWithResourceLeftCheck(shoen_record,
					        dest_table_word,
						D_WorkFlagPosition,
						rsc_check_result);
	    }
	}
      $RELEASE(D_WorkFlagPosition);
    }
}



#DATA_define  D_WorkResSupUnit  XXX

#PSL_define  f_SetNewFlagWithResourceLeftCheck(shoen_record, new_table_elem,
					               flag_pos, check_result)
{
  b_IfEqualImm(check_result, _SUFFICIENT_RESOURCE)
    {
      $USE(D_WorkResSupUnit);
      p_SetImmediateValue(_RSC_SUPPLY_UNIT, D_WorkResSupUnit);
      f_CheckShoenResourceLeftMargin(shoen_record, D_WorkResSupUnit,
					                        check_result);
      s_IfEnoughShoenResourceLeft(shoen_record, D_NULL, D_WorkResSupUnit)
	{
	  s_SubtractShoenResourceLeft(shoen_record, D_NULL, D_WorkResSupUnit);
	  b_FlagOnPosReg(new_table_elem, flag_pos);
	}
      $RELEASE(D_WorkResSupUnit);
    }
}

#DATA_define  D_WorkParentFPRecord  XXX

#PSL_define  f_CheckShoenResourceLeftMargin(shoen_record, res_margin,
					                        check_result)
{
  s_IfNotEnoughShoenResourceLeft(shoen_record, D_NULL, res_margin)
    {
      s_IfEnoughShoenResourceLimitLeft(shoen_record, D_NULL, res_margin)
	{
	  $USE(D_WorkParentFPRecord);
	  s_GetFPRecordOfShoen(shoen_record, D_WorkParentFPRecord);
	  $USE(D_WorkFPOrgLockTagReg);
	  s_LockFPRecord(D_WorkParentFPRecord, D_WorkFPOrgLockTagReg);
	  s_IfEnoughFPResourceLeft(D_WorkParentFPRecord, res_margin)
	    {
	      s_SubtractShoenResourceLimitLeft(shoen_record, D_NULL,
					                         res_margin);

	      f_FPSupplyResourceToChildShoen(D_WorkParentFPRecord, D_NULL,
					     res_margin);

	      s_AddShoenResourceLeft(shoen_record, D_NULL, res_margin);
	      p_SetImmediateValue(_SUFFICIENT_RESOURCE, check_result);
	    }
	  else
	    {
	      /* Temporary routine for Debug. */
              /* Actually, this is NOT error case. */
	      @DEBUG{ WARNING("f_CheckShoenResourceLeftMargin",
			      "Fail to replicate whole dest_vect due to resource short");};
	      s_SetFPStatusFlag(D_WorkParentFPRecord, _FP_CHILD_RSC_REQ_FLAG);
	      p_SetImmediateValue(_RESOURCE_SHORT, check_result);
	    }
	  s_UnlockFPRecord(D_WorkParentFPRecord, D_WorkFPOrgLockTagReg);
	  $RELEASE(D_WorkFPOrgLockTagReg);
	  f_CheckFPResourceLeftMargin(D_WorkParentFPRecord, res_margin);
	  $RELEASE(D_WorkParentFPRecord);
	}
      else
	{
	  p_SetImmediateValue(_RESOURCE_LIMIT_OVER, check_result);
	}
    }
}


