
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_shoen_report.psl.c
   ----- CREATED   : by kawai@icot22, on Sun Jun 24 13:51:37 1990
   ----- LAST SAVED: by kawai@icot22, on Mon Mar  2 20:58:04 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : 
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **

       written by kawai@icot22      on Sun Jun 24 16:19:00 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
  $B8F$S=P$785$GAq1`%l%3!<%I$r%m%C%/$7$J$$$3$H!#(B
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
  $B%(%/%;%W%7%g%s$rH/8+$7$?>l9g!"N$?FB&$G>pJs$r<}=8$7$?8e!"$=$N>pJs$r%a%C%;!<%8(B
$B$K5M$a$FAq1`$KAw$k!#(B
  $BAq1`$G$O!"$=$N%(%/%;%W%7%g%s$r<u$1IU$1$k$+H]$+$rH=Dj$7(B($B%(%/%;%W%7%g%s%^%9%/(B
$B$K$h$C$F(B)$B!"<u$1IU$1$k$N$G$"$l$P$=$N>pJs$r%l%]!<%H%9%H%j!<%`$KN.$9!#$^$?!"(B
$B<u$1IU$1$J$$$N$G$"$l$P!"Aq1`$N?FN$?F$+$i99$K>e$NAq1`$K%a%C%;!<%8$r:FAw$9$k!#(B
********************************************************************* PSL **/

#DATA_define  D_WorkShoenReportMessageReg  XXX

#PSL_define f_ReportException(shoen_record, excpt_tag, 
			      excpt_num, /* !! $B0z?tDI2C(B */
			      excpt_info_vect, new_code, new_arg_vect)
{
  s_IfExceptionMasked(shoen_record, excpt_tag)
    { /* $B%(%/%;%W%7%g%s$,%^%9%/$5$l$F$$$k(B($B$3$NAq1`$G$O<u$1IU$1$J$$(B)$B>l9g(B */
      $USE(D_WorkParentFPRecord);
      s_GetFPRecordOfShoen(shoen_record, D_WorkParentFPRecord);
      /* $B?F$NN$?F$+$i$5$i$K?FAq1`$K%(%/%;%W%7%g%s>pJs$rAw$k!#(B*/
      $CALL( f_Send_IntClMsg_Exception_Sub(excpt_tag, 
					   excpt_num, /* !! $B0z?tDI2C(B */
					   excpt_info_vect, 
					   new_code, new_arg_vect, 
				                  D_WorkParentFPRecord) );
      $RELEASE(D_WorkParentFPRecord);
    }
  else
    { /* $B%(%/%;%W%7%g%s$,%^%9%/$5$l$F$$$J$$(B($B$3$NAq1`$G<u$1IU$1$k(B)$B>l9g(B */
      $USE(D_WorkShoenReportMessageReg);
      /* $BNc30$N%l%]!<%H$N%;%k$r:n$k!#(B*/
      s_MakeExceptionReport(excpt_num, excpt_info_vect,
 			               new_code, new_arg_vect, D_WorkShoenReportMessageReg);
      /* $BNc30>pJs$rAq1`$N%l%]!<%H%9%H%j!<%`$KN.$9(B */
      $USE(D_WorkShoenOrgLockTagReg);
      s_LockShoenRecord(shoen_record, D_WorkShoenOrgLockTagReg);

      $CALL( f_PutReportStream_Sub(shoen_record, D_WorkShoenReportMessageReg) );

      s_UnlockShoenRecord(shoen_record, D_WorkShoenOrgLockTagReg);
      $RELEASE(D_WorkShoenOrgLockTagReg);
      $RELEASE(D_WorkShoenReportMessageReg);
    }
}

/******************************************************************** PSL **

  $BAq1`$+$i$N%l%]!<%H%9%H%j!<%`$X$N1~Ez=hM}(B

       written by kawai@icot22      on Thu May 31 14:55:53 1990
<Arguments>
  shoen_record : $BAq1`%l%3!<%I$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
  message_imm : $B%l%]!<%H%9%H%j!<%`$XN.$9%a%C%;!<%8<oN`(B($BB(CM(B)
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $BAq1`$N%l%]!<%H%9%H%j!<%`$K%l%]!<%H>pJs$rN.$9!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define  f_ReportShoenMessage(shoen_record, message_imm)
{
  $USE(D_WorkShoenReportMessageReg);
  b_SetImmTypeValueMRBoff(INT, message_imm, D_WorkShoenReportMessageReg);
  f_PutReportResponse(shoen_record, D_WorkShoenReportMessageReg);
  $RELEASE(D_WorkShoenReportMessageReg);
}


#DATA_define  D_WorkShoenResourceConsumedUpperReg  XXX
#DATA_define  D_WorkShoenResourceConsumedLowerReg  XXX

#PSL_define  f_ReportShoenStatInformation(shoen_record)
{
  $USE(D_WorkShoenResourceConsumedUpperReg);
  $USE(D_WorkShoenResourceConsumedLowerReg);
  s_GetShoenResourceConsumed(shoen_record, D_WorkShoenResourceConsumedUpperReg,
			                  D_WorkShoenResourceConsumedLowerReg);
  f_ReportShoenResourceInfo(shoen_record, _STAT_REP,
			                  D_WorkShoenResourceConsumedUpperReg,
			                  D_WorkShoenResourceConsumedLowerReg);
  $RELEASE(D_WorkShoenResourceConsumedUpperReg);
  $RELEASE(D_WorkShoenResourceConsumedLowerReg);
}



#DATA_define  D_WorkShoenResourceReturnUpperReg1  XXX
#DATA_define  D_WorkShoenResourceReturnLowerReg1  XXX
#DATA_define  D_WorkShoenResourceReturnUpperReg2  XXX
#DATA_define  D_WorkShoenResourceReturnLowerReg2  XXX

#PSL_define  f_ReportShoenReturnResourceAtTermination(shoen_record)
{
  $USE(D_WorkShoenResourceReturnUpperReg1);
  $USE(D_WorkShoenResourceReturnLowerReg1);
  $USE(D_WorkShoenResourceReturnUpperReg2);
  $USE(D_WorkShoenResourceReturnLowerReg2);

  s_GetShoenResourceLeft(shoen_record, D_WorkShoenResourceReturnUpperReg1,
			               D_WorkShoenResourceReturnLowerReg1);
  s_GetShoenResourceLimitLeft(shoen_record, D_WorkShoenResourceReturnUpperReg2,
			                   D_WorkShoenResourceReturnLowerReg2);

  b_AddDoubleWord(D_WorkShoenResourceReturnUpperReg1,
		  D_WorkShoenResourceReturnLowerReg1,
		             D_WorkShoenResourceReturnUpperReg2,
		             D_WorkShoenResourceReturnLowerReg2,
		                        D_WorkShoenResourceReturnUpperReg2,
		                        D_WorkShoenResourceReturnLowerReg2);
  /* $B2C;;7k2L$,%*!<%P%U%m!<$9$k>l9g$O!"JL!9$K(B2$B2s$KJ,$1$F%l%]!<%H$9$k$+(B... */
  /* ShoenResourceLeft$B!"(BShoenResourceLimitLeft$B$H$b$K(B 2^63 $B0J2<$NCM$7$+F~$C$F(B
     $B$$$J$$H&$J$N$G!"$3$N2C;;$G%*!<%P%U%m!<$9$k$3$H$O$J$$H&(B */
		              
  $RELEASE(D_WorkShoenResourceReturnUpperReg1);
  $RELEASE(D_WorkShoenResourceReturnLowerReg1);

  f_ReportShoenResourceInfo(shoen_record, _RETURN_RSC_REP,
			                  D_WorkShoenResourceReturnUpperReg2,
			                  D_WorkShoenResourceReturnLowerReg2);

  $RELEASE(D_WorkShoenResourceReturnUpperReg2);
  $RELEASE(D_WorkShoenResourceReturnLowerReg2);
}


#ADDR_define  _FIRST_INFO_VECT_ELEMENT_OFST   1
#ADDR_define  _SECOND_INFO_VECT_ELEMENT_OFST  2
#ADDR_define  _THIRD_INFO_VECT_ELEMENT_OFST   3
#ADDR_define  _FOURTH_INFO_VECT_ELEMENT_OFST  4

#DATA_define  D_WorkShoenStatReportVector     XXX
#DATA_define  D_WorkReportVectorElement       XXX

#PSL_define f_ReportShoenResourceInfo(shoen_record, message_imm, 
				                          resource_upper,
				                              resource_lower)
{
  /*  3$BMWAG%Y%/%?$r<h$C$F$/$k(B */
  $USE(D_WorkShoenStatReportVector);
  s_AllocVect3(D_WorkShoenStatReportVector);
  /*  $B%Y%/%?$NBh(B0$BMWAG$K(B message_imm $B$r5M$a$k!#(B */
  $USE(D_WorkReportVectorElement);
  b_SetImmTypeValueMRBoff(INT, message_imm, D_WorkReportVectorElement);
  s_PutVectElementImmOfst(D_WorkShoenStatReportVector, _ZERO,
			                           D_WorkReportVectorElement);
  $RELEASE(D_WorkReportVectorElement);
  /*  $B%Y%/%?$NBh(B1$BMWAG$K(B  resource_upper $B$NFbMF(B $B$r5M$a$k!#(B*/
  b_SetImmTypeMRBoff(INT, resource_upper);
  s_PutVectElementImmOfst(D_WorkShoenStatReportVector,
                                         _FIRST_INFO_VECT_ELEMENT_OFST,
 			                                      resource_upper);
  /*  $B%Y%/%?$NBh(B2$BMWAG$K(B  resource_lower $B$NFbMF(B $B$r5M$a$k!#(B*/
  b_SetImmTypeMRBoff(INT, resource_lower);
  s_PutVectElementImmOfst(D_WorkShoenStatReportVector,
                                         _SECOND_INFO_VECT_ELEMENT_OFST,
			                                      resource_lower);

  /*  $B%Y%/%?$r%l%]!<%H%9%H%j!<%`$KN.$9!#(B  */
  f_PutReportResponse(shoen_record, D_WorkShoenStatReportVector);
  $RELEASE(D_WorkShoenStatReportVector);
}



#DATA_define  D_WorkShoenProfileReportVector     XXX

#PSL_define f_ReportShoenProfileInfo(shoen_record, cl_num, type, depth,
				                              profile_result)
{
  /*  5$BMWAG%Y%/%?$r<h$C$F$/$k(B */
  $USE(D_WorkShoenProfileReportVector);
  s_AllocVect5(D_WorkShoenProfileReportVector);
  /*  $B%Y%/%?$NBh(B0$BMWAG$K(B _PROF_INFO_REP $B$r5M$a$k!#(B */
  $USE(D_WorkReportVectorElement);
  b_SetImmTypeValueMRBoff(INT, _PROF_INFO_REP, D_WorkReportVectorElement);
  s_PutVectElementImmOfst(D_WorkShoenProfileReportVector, _ZERO,
			                           D_WorkReportVectorElement);
  $RELEASE(D_WorkReportVectorElement);
  /*  $B%Y%/%?$NBh(B1$BMWAG$K(B  cl_num $B$NFbMF(B $B$r5M$a$k!#(B*/
  b_SetImmTypeMRBoff(INT, cl_num);
  s_PutVectElementImmOfst(D_WorkShoenProfileReportVector,
                                         _FIRST_INFO_VECT_ELEMENT_OFST,
 			                                               cl_num);
  /*  $B%Y%/%?$NBh(B2$BMWAG$K(B  type $B$NFbMF(B $B$r5M$a$k!#(B*/
  b_SetImmTypeMRBoff(INT, type);
  s_PutVectElementImmOfst(D_WorkShoenProfileReportVector,
                                         _SECOND_INFO_VECT_ELEMENT_OFST, type);

  /*  $B%Y%/%?$NBh(B3$BMWAG$K(B  depth $B$NFbMF(B $B$r5M$a$k!#(B*/
  b_SetImmTypeMRBoff(INT, depth);
  s_PutVectElementImmOfst(D_WorkShoenProfileReportVector,
                                         _THIRD_INFO_VECT_ELEMENT_OFST, depth);

  /*  $B%Y%/%?$NBh(B4$BMWAG$K(B profile_result $B$NFbMF(B $B$r5M$a$k!#(B*/

  s_PutVectElementImmOfst(D_WorkShoenProfileReportVector,
                                         _FOURTH_INFO_VECT_ELEMENT_OFST,
			                                       profile_result);

  /*  $B%Y%/%?$r%l%]!<%H%9%H%j!<%`$KN.$9!#(B  */
  f_PutReportResponse(shoen_record, D_WorkShoenProfileReportVector);
  $RELEASE(D_WorkShoenProfileReportVector);
}


/******************************************************************** PSL **

       written by kawai@icot22      on Sun Jun 24 14:07:37 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
  $B8F$S=P$785$GAq1`%l%3!<%H$KBP$7$F%=%U%H%m%C%/$7$F$$$k$3$H!#(B
<Function>
  $BAq1`$N%l%]!<%H%9%H%j!<%`JQ?t$K%l%]!<%H%a%C%;!<%8$r$D$J$2$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define  D_WorkReportMessage  XXX

#PSL_define  f_PutReportResponse(shoen_record, message)
{
  $USE(D_WorkReportMessage);
  s_MakeResponseReport(message, D_WorkReportMessage);

  $CALL( f_PutReportStream_Sub(shoen_record, D_WorkReportMessage) );

  $RELEASE(D_WorkReportMessage);
}



#DATA_define  D_WorkReportStream  XXX
#DATA_define  D_WorkTypeCheckReg  XXX
#DATA_define  D_WorkReportCdr  XXX

#SUBARG_define  A_ShoenRecord	SRC 
#SUBARG_define  A_ReportMessage	SRC

/* !!! $B%3%s%Z%"%9%o%C%W$rMQ$$$?HG(B !!! */
#SUBROUTINE  f_PutReportStream_Sub(A_ShoenRecord, A_ReportMessage)
{
  $USE(D_WorkTypeCheckReg);
  $USE(D_WorkReportStream);
  $USE(D_WorkReportCdr);
  s_GetShoenReportStream(A_ShoenRecord, D_WorkReportStream);
  s_GetCdrList(A_ReportMessage, D_WorkReportCdr);

 Label_PutReport:
  p_Read(D_WorkReportStream, D_WorkTypeCheckReg);
  TypeSwitch(D_WorkTypeCheckReg)
    {
    case UndefGrp():
        /* $B%3%s%Z%"%9%o%C%W$G%l%]!<%H%9%H%j!<%`$K%j%9%H7A<0$K$J$C$?(B
	   $B%a%C%;!<%8$r7R$2$k(B */
      b_TypeValueCompareSwapX(D_WorkReportStream, D_WorkTypeCheckReg,
			                                   A_ReportMessage);
      p_IfEQ()
	{ /* $B%3%s%Z%"%9%o%C%W$K@.8y$9$l$P!"%l%]!<%H%9%H%j!<%`$N;X$9@h$r(B
	     $BL$Dj5AJQ?t$H$9$k(B */
	  s_PutShoenReportStream(A_ShoenRecord, D_WorkReportCdr);
	  $RELEASE(D_WorkReportCdr);
	}
      else
	{ /* $B%3%s%Z%"%9%o%C%W$K<:GT$9$l$P!"%j%H%i%$$9$k(B */
	  goto Label_PutReport;
	}
      break;

    case HookGrp():
        /* $B%3%s%Z%"%9%o%C%W$G%l%]!<%H%9%H%j!<%`$K%j%9%H7A<0$K$J$C$?(B
	   $B%a%C%;!<%8$r7R$2$k(B */
      b_TypeValueCompareSwapX(D_WorkReportStream, D_WorkTypeCheckReg,
			                                   A_ReportMessage);
      p_IfEQ()
	{ /* $B%3%s%Z%"%9%o%C%W$K@.8y$9$l$P!"%l%]!<%H%9%H%j!<%`$N;X$9@h$r(B
	     $BL$Dj5AJQ?t$H$9$k(B */
	  s_PutShoenReportStream(A_ShoenRecord, D_WorkReportCdr);
	  $RELEASE(D_WorkReportCdr);
	  /* $B%l%]!<%H%9%H%j!<%`JQ?t$K%U%C%/$7$F$$$?%4!<%k$r5/$3$9(B */
	  $CALL( f_WakeUpProcess_Sub(D_WorkTypeCheckReg) );
	}
      else
	{ /* $B%3%s%Z%"%9%o%C%W$K<:GT$9$l$P!"%j%H%i%$$9$k(B */
	  goto Label_PutReport;
	}
      break;

    case ListGrp():  /* $B$3$N$h$&$J>l9g$,K\Ev$K$"$k$+(B ? */
                     /* $B$J$1$l$P2<$N%(%i!<%0%k!<%W$KF~$l$k!#(B*/
    case RefGrp():
      p_MoveWord(D_WorkTypeCheckReg, D_WorkReportStream);
      goto Label_PutReport;
      break;

      /* $B0J2<$N>l9g$O!"Aq1`$N%l%]!<%H%9%H%j!<%`JQ?t$K%f!<%6(B($BAq1`%b%8%e!<%k(B)$BB&(B
         $B$+$iCM$r%P%$%s%I$7$?$H$-$K5/$3$k!#(B
         $B=>$C$F!"Aq1`%b%8%e!<%kB&$G%l%]!<%H%9%H%j!<%`JQ?t$X$N%P%$%s%I$r6X;_(B
         $B$9$l$P!"%(%i!<$H$7$F=hM}$G$-$k!#(B
      */
    case ConstantGroup():
    case StringGrp():
    case NullVectorGrp():
    case ShortVectorGrp():
    case LongVectorGrp():
    case ControlGroup():
      @DEBUG{WARNING("f_PutReportStream_Sub",
		     "ReportStream Variable already Bound");};
      break;

    default:
      @DEBUG{VPIM_ERROR("f_PutReportStream_Sub",
			"report_stream_status_error");};
      break;
    }
  $RELEASE(D_WorkReportStream);
  $RELEASE(D_WorkTypeCheckReg);
  $RETURN ();
}

/* !!! $B%*%j%8%J%kHG(B !!! 
#SUBROUTINE  f_PutReportStream_Sub(A_ShoenRecord, A_ReportMessage)
{
  $USE(D_WorkTypeCheckReg);
  $USE(D_WorkReportStream);
  $USE(D_WorkReportCdr);
  s_GetShoenReportStream(A_ShoenRecord, D_WorkReportStream);
  s_GetCdrList(A_ReportMessage, D_WorkReportCdr);

 Label_PutReport:
  p_ReadWithLock(D_WorkReportStream, D_WorkTypeCheckReg);
  TypeSwitch(D_WorkTypeCheckReg)
    {
    case UndefGrp():
        /!* $B%l%]!<%H%9%H%j!<%`$K%j%9%H7A<0$K$J$C$?%a%C%;!<%8$r7R$2$k(B *!/
      p_WriteAndUnlock(A_ReportMessage, D_WorkReportStream);
        /!* $B%l%]!<%H%9%H%j!<%`$N;X$9@h$rL$Dj5AJQ?t$H$9$k(B *!/
      s_PutShoenReportStream(A_ShoenRecord, D_WorkReportCdr);
      $RELEASE(D_WorkReportCdr);
      break;

    case HookGrp():
        /!* $B%l%]!<%H%9%H%j!<%`$K%j%9%H7A<0$K$J$C$?%a%C%;!<%8$r7R$2$k(B *!/
      p_WriteAndUnlock(A_ReportMessage, D_WorkReportStream);
        /!* $B%l%]!<%H%9%H%j!<%`$N;X$9@h$rL$Dj5AJQ?t$H$9$k(B *!/
      s_PutShoenReportStream(A_ShoenRecord, D_WorkReportCdr);
      $RELEASE(D_WorkReportCdr);
        /!* $B%l%]!<%H%9%H%j!<%`JQ?t$K%U%C%/$7$F$$$?%4!<%k$r5/$3$9(B *!/
      $CALL( f_WakeUpProcess_Sub(D_WorkTypeCheckReg) );
      break;

    case ListGrp():  /!* $B$3$N$h$&$J>l9g$,K\Ev$K$"$k$+(B ? *!/
                     /!* $B$J$1$l$P2<$N%(%i!<%0%k!<%W$KF~$l$k!#(B*!/
    case RefGrp():
      p_Unlock(D_WorkReportStream);
      p_MoveWord(D_WorkTypeCheckReg, D_WorkReportStream);
      goto Label_PutReport;
      break;

      /!* $B0J2<$N>l9g$O!"Aq1`$N%l%]!<%H%9%H%j!<%`JQ?t$K%f!<%6(B($BAq1`%b%8%e!<%k(B)$BB&(B
         $B$+$iCM$r%P%$%s%I$7$?$H$-$K5/$3$k!#(B
         $B=>$C$F!"Aq1`%b%8%e!<%kB&$G%l%]!<%H%9%H%j!<%`JQ?t$X$N%P%$%s%I$r6X;_(B
         $B$9$l$P!"%(%i!<$H$7$F=hM}$G$-$k!#(B
      *!/
    case ConstantGroup():
    case StringGrp():
    case NullVectorGrp():
    case ShortVectorGrp():
    case LongVectorGrp():
    case ControlGroup():
      p_Unlock(D_WorkReportStream);
      @DEBUG{WARNING("f_PutReportStream_Sub",
		     "ReportStream Variable already Bound");};
      break;

    default:
      p_Unlock(D_WorkReportStream);
      @DEBUG{VPIM_ERROR("shoen_report","report_stream_status_error");};
      break;
    }
  $RELEASE(D_WorkReportStream);
  $RELEASE(D_WorkTypeCheckReg);
  $RETURN ();
}

 !!! $B%*%j%8%J%kHG(B !!! */

/******************************************************************** PSL **

       written by kawai@icot22      on Sun Jun 24 15:49:16 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $BAq1`$N%l%]!<%H%9%H%j!<%`$rJD$8$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
('90.6.24)
$B!&%l%]!<%H%9%H%j!<%`$N=*C<$O7h$^$C$F$$$k(B(ATOM NULL = [])$B$?$a!"(B
  $B0z?t(B report_msg $B$r:o=|$7$?!#(B
********************************************************************* PSL **/

#DATA_define  D_WorkRepStreamTerminater  XXX

/* !!! $B%3%s%Z%"%9%o%C%W$rMQ$$$?HG(B !!! */
#PSL_define f_CloseReportStream(shoen_record)
{
  $USE(D_WorkReportStream);
  $USE(D_WorkTypeCheckReg);

  s_GetShoenReportStream(shoen_record, D_WorkReportStream);
  $USE(D_WorkRepStreamTerminater);
  b_MoveWithImmTypeMRBoff(D_NULL, ATOM, D_WorkRepStreamTerminater);

 Label_PutReport:
  p_Read(D_WorkReportStream, D_WorkTypeCheckReg);
  TypeSwitch(D_WorkTypeCheckReg)
    {
    case UndefGrp():
        /* $B%3%s%Z%"%9%o%C%W$G%l%]!<%H%9%H%j!<%`$K%j%9%H7A<0$K$J$C$?(B
	   $B%a%C%;!<%8$r7R$2$k(B */
      b_TypeValueCompareSwapX(D_WorkReportStream, D_WorkTypeCheckReg,
			                         D_WorkRepStreamTerminater);
      p_IfNE()
	{ /* $B%3%s%Z%"%9%o%C%W$K<:GT$9$l$P!"%j%H%i%$$9$k(B */
	  goto Label_PutReport;
	}
      break;

    case HookGrp():
        /* $B%3%s%Z%"%9%o%C%W$G%l%]!<%H%9%H%j!<%`$K%j%9%H7A<0$K$J$C$?(B
	   $B%a%C%;!<%8$r7R$2$k(B */
      b_TypeValueCompareSwapX(D_WorkReportStream, D_WorkTypeCheckReg,
			                         D_WorkRepStreamTerminater);
      p_IfNE()
	{ /* $B%3%s%Z%"%9%o%C%W$K<:GT$9$l$P!"%j%H%i%$$9$k(B */
	  goto Label_PutReport;
	}
      else
	{ /* $B%3%s%Z%"%9%o%C%W$K@.8y$9$l$P!"%l%]!<%H%9%H%j!<%`JQ?t$K%U%C%/(B
	     $B$7$F$$$?%4!<%k$r5/$3$9(B */
	  $CALL( f_WakeUpProcess_Sub(D_WorkTypeCheckReg) );
	}
      break;

    case ListGrp():  /* $B$3$N$h$&$J>l9g$,K\Ev$K$"$k$+(B ? */
                     /* $B$J$1$l$P2<$N%(%i!<%0%k!<%W$KF~$l$k!#(B*/
    case RefGrp():
      p_MoveWord(D_WorkTypeCheckReg, D_WorkReportStream);
      goto Label_PutReport;
      break;
      
      /* $B0J2<$N>l9g$O!"Aq1`$N%l%]!<%H%9%H%j!<%`JQ?t$K%f!<%6(B($BAq1`%b%8%e!<%k(B)$BB&(B
         $B$+$iCM$r%P%$%s%I$7$?$H$-$K5/$3$k!#(B
         $B=>$C$F!"Aq1`%b%8%e!<%kB&$G%l%]!<%H%9%H%j!<%`JQ?t$X$N%P%$%s%I$r6X;_(B
         $B$9$l$P!"%(%i!<$H$7$F=hM}$G$-$k!#(B
      */
    case ConstantGroup():
    case StringGrp():
    case NullVectorGrp():
    case ShortVectorGrp():
    case LongVectorGrp():
    case ControlGroup():
      @DEBUG{WARNING("f_CloseReportStream",
		     "ReportStream Variable already Bound");};
      break;

    default:
      @DEBUG{VPIM_ERROR("f_CloseReportStream","undefined_type");};
      break;
    }
  $RELEASE(D_WorkRepStreamTerminater);
  $RELEASE(D_WorkReportStream);
  $RELEASE(D_WorkTypeCheckReg);
}


/* !!! $B%*%j%8%J%kHG(B !!! 
#PSL_define f_CloseReportStream(shoen_record)
{
  $USE(D_WorkReportStream);
  $USE(D_WorkTypeCheckReg);

  s_GetShoenReportStream(shoen_record, D_WorkReportStream);
  $USE(D_WorkRepStreamTerminater);
  b_MoveWithImmTypeMRBoff(D_NULL, ATOM, D_WorkRepStreamTerminater);
 Label_PutReport:
  p_ReadWithLock(D_WorkReportStream, D_WorkTypeCheckReg);
  TypeSwitch(D_WorkTypeCheckReg)
    {
    case UndefGrp():
      p_WriteAndUnlock(D_WorkRepStreamTerminater, D_WorkReportStream);
      break;

    case HookGrp():
      p_WriteAndUnlock(D_WorkRepStreamTerminater, D_WorkReportStream);
      $CALL( f_WakeUpProcess_Sub(D_WorkTypeCheckReg) );
      break;

    case ListGrp():  /!* $B$3$N$h$&$J>l9g$,K\Ev$K$"$k$+(B ? *!/
                     /!* $B$J$1$l$P2<$N%(%i!<%0%k!<%W$KF~$l$k!#(B*!/
    case RefGrp():
      p_Unlock(D_WorkReportStream);
      p_MoveWord(D_WorkTypeCheckReg, D_WorkReportStream);
      goto Label_PutReport;
      break;
      
      /!* $B0J2<$N>l9g$O!"Aq1`$N%l%]!<%H%9%H%j!<%`JQ?t$K%f!<%6(B($BAq1`%b%8%e!<%k(B)$BB&(B
         $B$+$iCM$r%P%$%s%I$7$?$H$-$K5/$3$k!#(B
         $B=>$C$F!"Aq1`%b%8%e!<%kB&$G%l%]!<%H%9%H%j!<%`JQ?t$X$N%P%$%s%I$r6X;_(B
         $B$9$l$P!"%(%i!<$H$7$F=hM}$G$-$k!#(B
      *!/
    case ConstantGroup():
    case StringGrp():
    case NullVectorGrp():
    case ShortVectorGrp():
    case LongVectorGrp():
    case ControlGroup():
      p_Unlock(D_WorkReportStream);
      @DEBUG{WARNING("f_CloseReportStream_Sub",
		     "ReportStream Variable already Bound");};
      break;

    default:
      p_Unlock(D_WorkReportStream);
      @DEBUG{VPIM_ERROR("shoen_report","undefined_type");};
      break;
    }
  $RELEASE(D_WorkRepStreamTerminater);
  $RELEASE(D_WorkReportStream);
  $RELEASE(D_WorkTypeCheckReg);
}
 !!! $B%*%j%8%J%kHG(B !!! */
