
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_shoen_recv_message.psl.c
   ----- CREATED   : by kawai@icot22, on Fri May 25 21:03:16 1990
   ----- LAST SAVED: by kawai@icot22, on Thu Apr 30 11:42:07 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : 
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **

       written by kawai@icot22      on Mon Jun  4 21:37:26 1990
<Arguments>
  shoen_record : $BAq1`%l%3!<%I$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
  wtc_flag : $BAq1`$N;D(BWTC$BNL$rJ];}$9$k%l%8%9%?(B
             $B%a%C%;!<%8%O%s%I%i$,%a%C%;!<%8$r<u?.$7$?;~$K!"%a%C%;!<%8Cf$N(B
             $BAq1`$N30It;2>H(BID$B$+$iAq1`$X$N%]%$%s%?$rF@$k:]$KF1;~$K(BWTC$B$N%a%s(B
             $B%F$r9T$$!"$=$N7k2L$r$3$N%l%8%9%?$K>h$;$F$3$N%^%/%m$r8F$S=P$9!#(B
  cl_num_reg : $B$3$N%a%C%;!<%8$NAw?.85%/%i%9%?$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
  D_WorkShoenTransitStatusReg : $BAq1`$NA+0\>uBV$r0l;~J];}$9$k%l%8%9%?(B
  D_WorkReadyTerminateCountResult : $BAq1`$X$N(BReady/Terminate$B%a%C%;!<%8$r%+%&%s%H(B
                                    $B$7$?7k2L$r0l;~J];}$9$k%l%8%9%?(B
  D_WorkWTCResultFlag : $BAq1`$N;D(BWTC$BNL$r0l;~J];}$9$k%l%8%9%?(B
<Level>
<PreCondition>
  $B8F$S=P$785$G$O!"Aq1`%l%3!<%I$K%m%C%/$r3]$1$J$$$3$H!#(B
<Function>
  $BB>%/%i%9%?$K$3$NAq1`$NN$?F$,@8@.$5$l$?;~$KAw$i$l$F$/$k(B Ready$B%a%C%;!<%8$r(B
$B=hM}$9$k%^%/%m$G$"$k!#(B
  $B$3$N%^%/%m$O(BReady$B%a%C%;!<%8$r<u?.$7$?;~%M%C%H%o!<%/%O%s%I%i$+$i8F$S=P$5$l$k!#(B

  $B<g$J=hM}FbMF(B:
 (1) $BAq1`%l%3!<%I$N%m%C%/(B
 (2) Ready/Terminate$B%a%C%;!<%8$N%+%&%s%H(B
 (3) ($B?7N$?F@8@.;~(B)
     (3.1) $BN$?F%F!<%V%k$N%U%i%0$r(Bon
     (3.2) $B?7N$?F$X$N;q8;$H(BWTC$B$N6!5k(B
     (3.3) $B?7N$?F$X$NAq1`$NA+0\>uBVH?1G(B
 (4) ($BAq1`$K(BTerminated$B%a%C%;!<%8$NJ}$,B?$/E~Ce$7$F$$$?>l9g(B)
     (4.1) $BAq1`$N=*7kH=Dj(B
 (5) $BAq1`%l%3!<%I$N%"%s%m%C%/(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define  D_WorkShoenTransitStatusReg  XXX
#DATA_define  D_WorkReadyTerminateCountResult  XXX
#DATA_define  D_WorkWTCResultFlag  XXX
#DATA_define  D_WorkVOIDData       XXX

#PSL_define  f_ShoenReceiveReady(shoen_record, cl_num_reg)
{
  @DEBUG{
    _PrintSHInfo(shoen_record);
    WARNING("f_ShoenReceiveReady","Shoen Received Ready");
  };

  $USE(D_WorkShoenOrgLockTagReg);
  s_LockShoenRecord(shoen_record, D_WorkShoenOrgLockTagReg);
  $USE(D_WorkReadyTerminateCountResult);
  s_CountReadyMessage(shoen_record, cl_num_reg,
		                           D_WorkReadyTerminateCountResult);
  b_IfGreater(D_WorkReadyTerminateCountResult, D_NULL)
    { /* Ready$B%a%C%;!<%8$NJ}$,B?$/E~Ce$7$F$$$?$i(B */
      @DEBUG{
	b_IfGreater(D_WorkReadyTerminateCountResult, D_ONE)
	  { WARNING("f_ShoenReceiveReady",
	                       "Ready message overtaken occured"); }
      };

      b_IfEqual(D_WorkReadyTerminateCountResult, D_ONE)
	{ /* $B?7$?$KN$?F$,$G$-$?$i(B */
	  @DEBUG{
	  WARNING("f_ShoenReceiveReady","Shoen Recognized New FP Generation");
	  };
	  s_SetFPTableFlagOn(shoen_record, cl_num_reg);

	  $USE(D_WorkShoenTransitStatusReg);
	  s_GetShoenTransitStatus(shoen_record, D_WorkShoenTransitStatusReg);
	  ValueSwitch(D_WorkShoenTransitStatusReg)
	    {
	    case _STARTED :
	      s_IfStartStopBitTableFlagOn(shoen_record, cl_num_reg)
		{ /* start/stop$B%S%C%H$,(Bon$B$@$C$?$i(B */
		  f_Send_IntClMsg_OneFP(shoen_record, _NW_START, cl_num_reg);
		  s_SetStartStopBitTableFlagOff(shoen_record, cl_num_reg);
		}
	      break;
	    case _STOPPED_BY_CTRL :
	    case _STOPPED_BY_PARENT :
	    case _STOPPED_BY_BOTH :
	      s_IfStartStopBitTableFlagOn(shoen_record, cl_num_reg)
		{ /* start/stop$B%S%C%H$,(Bon$B$@$C$?$i(B */
                  /* $B$J$K$b$7$J$$(B */
		}
	      else
		{ /* start/stop$B%S%C%H$,(Boff$B$@$C$?$i(B */
		  f_Send_IntClMsg_OneFP(shoen_record, _NW_STOP, cl_num_reg);
		  s_SetStartStopBitTableFlagOn(shoen_record, cl_num_reg);
		}
	      break;
	    case _ABORTED :
	      f_Send_IntClMsg_OneFP(shoen_record, _NW_ABORT, cl_num_reg);
	      break;
	    case _TERMINATED :
	      @DEBUG{ VPIM_ERROR("f_ShoenReceiveReady",
				 "Terminated Shoen received Ready"); };
	      break;
	    default :
	      @DEBUG{ VPIM_ERROR("f_ShoenReceiveReady",
				 "Illegal Shoen Status when received Ready");};
	    }
	  $RELEASE(D_WorkShoenTransitStatusReg);
	}

      f_ShoenReceiveRequestResourceWithoutLock(shoen_record, cl_num_reg);

      $USE(D_WorkShoenID);
      s_GetShoenId(shoen_record, D_WorkShoenID);
      $CALL( f_Send_IntClMsg_Supply_WTC_Sub(shoen_record, D_WorkShoenID, 
					                       cl_num_reg) );
      $RELEASE(D_WorkShoenID);
    }
  else
    { /* Terminated$B%a%C%;!<%8$rB?$/<u$1<h$C$F$$$?$i(B */
      /* $B$+$&$s$H$7$?$"$H$O!"$J$K$b$7$J$$(B */
      @DEBUG{
	  WARNING("f_ShoenReceiveReady",
	                       "Terminated message overtaken occured"); 
      };
    }

  s_UnlockShoenRecord(shoen_record, D_WorkShoenOrgLockTagReg);
  $RELEASE(D_WorkShoenOrgLockTagReg);
  $RELEASE(D_WorkReadyTerminateCountResult);
}

/******************************************************************** PSL **

       written by kawai@icot22      on Mon Jun  4 22:16:59 1990
<Arguments>
  shoen_record : $BAq1`%l%3!<%I$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
  resource_left_upper_reg : $BN$?F$N;D;q8;NL(B($B>e0L(B)$B$rJ];}$9$k%l%8%9%?(B
  resource_left_lower_reg : $BN$?F$N;D;q8;NL(B($B2<0L(B)$B$rJ];}$9$k%l%8%9%?(B
  res_consume_upper_reg : $BN$?F$N>CHq;q8;NL:9J,(B($B>e0L(B)$B$rJ];}$9$k%l%8%9%?(B
  res_consume_lower_reg : $BN$?F$N>CHq;q8;NL:9J,(B($B2<0L(B)$B$rJ];}$9$k%l%8%9%?(B
  wtc_left_reg : $BAq1`$N;D(BWTC$BNL$rJ];}$9$k%l%8%9%?(B
                 $B%a%C%;!<%8%O%s%I%i$,%a%C%;!<%8$r<u?.$7$?;~$K!"%a%C%;!<%8Cf$N(B
                 $BAq1`$N30It;2>H(BID$B$+$iAq1`$X$N%]%$%s%?$rF@$k:]$KF1;~$K(BWTC$B$N%a%s(B
                 $B%F$r9T$$!"$=$N7k2L$r$3$N%l%8%9%?$K>h$;$F$3$N%^%/%m$r8F$S=P$9!#(B
  sender_cl_num_reg : $B$3$N%a%C%;!<%8$NAw?.85%/%i%9%?$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
  $B8F$S=P$785$G$O!"Aq1`%l%3!<%I$K%m%C%/$r3]$1$J$$$3$H!#(B
<Function>
  $BB>%/%i%9%?$K$"$k$3$NAq1`$NN$?F$,=*7k$7$?;~$KAw$i$l$F$/$k(B Terminated$B%a%C%;!<%8(B
$B$r=hM}$9$k%^%/%m$G$"$k!#(B
  $B$3$N%^%/%m$O(BTerminated$B%a%C%;!<%8$r<u?.$7$?;~%M%C%H%o!<%/%O%s%I%i$+$i8F$S=P$5(B
$B$l$k!#(B

  $B<g$J=hM}FbMF(B:
 (1) $BAq1`%l%3!<%I$N%m%C%/(B
 (2) Ready/Terminate$B%a%C%;!<%8$N%+%&%s%H(B
 (3) ($BN$?F=*7k;~(B)
     (3.1) $BN$?F%F!<%V%k$N%U%i%0$r(Boff
     (3.2) $BN$?F$N;D;q8;(B/$B>CHq;q8;NL$rAq1`$K2C;;(B
     (3.3) $BAq1`$N;q8;$rB>$NN$?F$KJ,G[(B($BMW5a$,$"$k>l9g(B)
 (4) $BAq1`%l%3!<%I$N%"%s%m%C%/(B
 (5) $BAq1`$N=*7kH=Dj(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define  D_WorkShoenResourceLeftUpper  XXX
#DATA_define  D_WorkShoenResourceLeftLower  XXX
#DATA_define  D_WorkShoenResourceLimitLeftUpper  XXX
#DATA_define  D_WorkShoenResourceLimitLeftLower  XXX
#DATA_define  D_WorkShoenResourceAddendUpper  XXX
#DATA_define  D_WorkShoenResourceAddendLower  XXX
#DATA_define  D_WorkShoenResourceSurplusUpper  XXX
#DATA_define  D_WorkShoenResourceSurplusLower  XXX
#DATA_define  D_WorkShoenResourceSurplusUpper1  XXX
#DATA_define  D_WorkShoenResourceSurplusLower1  XXX

#PSL_define  f_ShoenReceiveTerminated(shoen_record, resource_left_upper_reg,
				      resource_left_lower_reg,
				      res_consume_upper_reg,
				      res_consume_lower_reg,
				                            sender_cl_num_reg)
{
  @DEBUG{
    _PrintSHInfo(shoen_record);
    WARNING("f_ShoenReceiveTerminated","Shoen Received Terminated"); };
    
  /*  $BAq1`%l%3!<%I$r%=%U%H%m%C%/$9$k(B */
  $USE(D_WorkShoenOrgLockTagReg);
  s_LockShoenRecord(shoen_record, D_WorkShoenOrgLockTagReg);
  $USE(D_WorkReadyTerminateCountResult);
  s_CountTerminatedMessage(shoen_record, sender_cl_num_reg,
			                    D_WorkReadyTerminateCountResult);
  @DEBUG{
    b_IfLess(D_WorkReadyTerminateCountResult, D_NULL)
      {WARNING("f_ShoenReceiveTerminated",
	                       "Terminate message overtaken occured"); }
  };

  b_IfEqual(D_WorkReadyTerminateCountResult, D_NULL)
    { /* $BN$?F$,>CLG$7$?$i(B */
      s_SetFPTableFlagOff(shoen_record, sender_cl_num_reg);
      s_SetResourceRequestFPTableFlagOff(shoen_record, sender_cl_num_reg);
    }
  $RELEASE(D_WorkReadyTerminateCountResult);

  $USE(D_WorkShoenResourceLeftUpper);
  $USE(D_WorkShoenResourceLeftLower);

  s_GetShoenResourceLeft(shoen_record, D_WorkShoenResourceLeftUpper,
			                    D_WorkShoenResourceLeftLower);

  $USE(D_WorkShoenResourceAddendUpper);
  $USE(D_WorkShoenResourceAddendLower);
  $USE(D_WorkShoenResourceSurplusUpper);
  $USE(D_WorkShoenResourceSurplusLower);

  b_CheckResourceSurplus(D_WorkShoenResourceLeftUpper,
			 D_WorkShoenResourceLeftLower,
			 resource_left_upper_reg,
			 resource_left_lower_reg,
			 D_WorkShoenResourceAddendUpper,
			 D_WorkShoenResourceAddendLower,
			 D_WorkShoenResourceSurplusUpper,
			 D_WorkShoenResourceSurplusLower);

  $RELEASE(D_WorkShoenResourceLeftUpper);
  $RELEASE(D_WorkShoenResourceLeftLower);

  s_AddShoenResourceLeft(shoen_record, D_WorkShoenResourceAddendUpper,
			                     D_WorkShoenResourceAddendLower);

  b_IfNotZeroDoubleWord(D_WorkShoenResourceSurplusUpper,
			D_WorkShoenResourceSurplusLower)
    { /* !! If Overflow, Check ResourceLimitLeft Overflow !! */
      $USE(D_WorkShoenResourceLimitLeftUpper);
      $USE(D_WorkShoenResourceLimitLeftLower);

      s_GetShoenResourceLimitLeft(shoen_record,
				  D_WorkShoenResourceLimitLeftUpper,
				  D_WorkShoenResourceLimitLeftLower);

      $USE(D_WorkShoenResourceSurplusUpper1);
      $USE(D_WorkShoenResourceSurplusLower1);

      b_CheckResourceSurplus(D_WorkShoenResourceLimitLeftUpper,
			     D_WorkShoenResourceLimitLeftLower,
			     D_WorkShoenResourceSurplusUpper,
			     D_WorkShoenResourceSurplusLower,
			     D_WorkShoenResourceAddendUpper,
			     D_WorkShoenResourceAddendLower,
			     D_WorkShoenResourceSurplusUpper1,
			     D_WorkShoenResourceSurplusLower1);

      $RELEASE(D_WorkShoenResourceLimitLeftUpper);
      $RELEASE(D_WorkShoenResourceLimitLeftLower);

      s_AddShoenResourceLimitLeft(shoen_record,
				  D_WorkShoenResourceAddendUpper,
				  D_WorkShoenResourceAddendLower);
      b_IfNotZeroDoubleWord(D_WorkShoenResourceSurplusUpper1,
			    D_WorkShoenResourceSurplusLower1)
	{ /* !! If ResourceLimitLeft Overflow, Report ReturnResource !! */
	  f_ReportShoenResourceInfo(shoen_record, _RETURN_RSC_REP,
				    D_WorkShoenResourceSurplusUpper1,
				    D_WorkShoenResourceSurplusLower1);
	}

      $RELEASE(D_WorkShoenResourceSurplusUpper1);
      $RELEASE(D_WorkShoenResourceSurplusLower1);
    }

  s_AddShoenResourceConsumed(shoen_record, res_consume_upper_reg,
				                  res_consume_lower_reg);

  /* !! */  
  $CALL( f_Send_IntClMsg_SupplyResource_ToResourceRequestFPs_Sub
	                                                   (shoen_record) );
  /* !!  $CALL( f_DistributeShoenResourceWithoutLock_Sub(shoen_record) ); */

  s_UnlockShoenRecord(shoen_record, D_WorkShoenOrgLockTagReg);
  $RELEASE(D_WorkShoenOrgLockTagReg);

  b_IfNotZeroDoubleWord(D_WorkShoenResourceSurplusUpper,
			D_WorkShoenResourceSurplusLower)
    { /* !! PutBack Surplus Resource to Parent FP !! */
      $USE(D_WorkShoenParentFPReg);
      s_GetFPRecordOfShoen(shoen_record, D_WorkShoenParentFPReg);
      f_FPResourceSuppliedByShoenResourceOverflow(D_WorkShoenParentFPReg,
					    D_WorkShoenResourceSurplusUpper,
					    D_WorkShoenResourceSurplusLower);
      $RELEASE(D_WorkShoenParentFPReg);
    }
  $RELEASE(D_WorkShoenResourceAddendUpper);
  $RELEASE(D_WorkShoenResourceAddendLower);
  $RELEASE(D_WorkShoenResourceSurplusUpper);
  $RELEASE(D_WorkShoenResourceSurplusLower);
}

/******************************************************************** PSL **

       written by kawai@icot22      on Mon Jun  4 22:58:35 1990
<Arguments>
  shoen_record : $BAq1`%l%3!<%I$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
  cl_num_reg : $B$3$N%a%C%;!<%8$NAw?.85%/%i%9%?$rJ];}$9$k%l%8%9%?(B
  wtc_left_reg : $BAq1`$N;D(BWTC$BNL$rJ];}$9$k%l%8%9%?(B
                 $B%a%C%;!<%8%O%s%I%i$,%a%C%;!<%8$r<u?.$7$?;~$K!"%a%C%;!<%8Cf$N(B
                 $BAq1`$N30It;2>H(BID$B$+$iAq1`$X$N%]%$%s%?$rF@$k:]$KF1;~$K(BWTC$B$N%a%s(B
                 $B%F$r9T$$!"$=$N7k2L$r$3$N%l%8%9%?$K>h$;$F$3$N%^%/%m$r8F$S=P$9!#(B
<Temporally Used Variables>
<Level>
<PreCondition>
  $B8F$S=P$785$GAq1`%l%3!<%I$K%m%C%/$r3]$1$J$$$3$H!#(B
<Function>
  $BB>%/%i%9%?$K$"$k$3$NAq1`$NN$?F$+$i;q8;MW5a$,$"$C$?;~$KAw$i$l$F$/$k(B
 RequestResource$B%a%C%;!<%8$r=hM}$9$k%^%/%m$G$"$k!#(B
  $B$3$N%^%/%m$O(BRequestResource$B%a%C%;!<%8$r<u?.$7$?;~%M%C%H%o!<%/%O%s%I%i$+$i(B
$B8F$S=P$5$l$k!#(B

  $B<g$J=hM}FbMF(B:
 (1) $BAq1`$N=*7kH=Dj(B
 (2) ($BAq1`$,=*7k$7$J$$;~(B)
     (2.1) $BAq1`%l%3!<%I$N%m%C%/(B
     (2.2) $BAq1`$N;q8;$rN$?F$KJ,G[(B
     (2.3) $BAq1`%l%3!<%I$N%"%s%m%C%/(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define  f_ShoenReceiveRequestResource(shoen_record, cl_num_reg)
{
  @DEBUG{
    _PrintSHInfo(shoen_record);
    WARNING("f_ShoenReceiveRequestResource","Shoen Received Resource Request");
  };

  $USE(D_WorkShoenOrgLockTagReg);
  s_LockShoenRecord(shoen_record, D_WorkShoenOrgLockTagReg);
  f_ShoenReceiveRequestResourceWithoutLock(shoen_record, cl_num_reg);
  s_UnlockShoenRecord(shoen_record, D_WorkShoenOrgLockTagReg);
  $RELEASE(D_WorkShoenOrgLockTagReg);
}

/******************************************************************** PSL **

       written by kawai@icot22      on Mon Jun  4 22:59:50 1990
<Arguments>
  shoen_record : $BAq1`%l%3!<%I$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
  cl_num_reg : $B;q8;MW5a$r=P$7$?N$?F$N$$$k%/%i%9%?HV9f$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
  $B8F$S=P$785$GAq1`%l%3!<%I$r%m%C%/$7$F$*$/$3$H!#(B
<Function>
  $BN$?F$KAq1`$N;q8;$rJ,G[$9$k!#(B

  $B<g$J=hM}FbMF(B:
 (1) $B;q8;MW5aN$?F%F!<%V%k$NBP1~$9$k%S%C%H$r(Bon
 (2) $BAq1`$N;q8;J,G[(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define  f_ShoenReceiveRequestResourceWithoutLock(shoen_record, cl_num_reg)
{
  s_IfShoenTransitStatusImmediately(shoen_record, _ABORTED)
    { /* $BAq1`$,4{$K(BAbort$B$5$l$F$$$?$i(B
	 ($B;q8;MW5a$OL5;k$9$k(B $B"+(B $B$$$E$l$3$NAq1`(B/$BN$?F$b(B Abort$B$5$l$k$+$i(B) */
      @DEBUG{
	_PrintSHInfo(shoen_record);
	WARNING("f_ShoenReceiveRequestResourceWithoutLock",
		"ResourceRequest to Aborted Shoen : ignored"); };
    }
  else
    { /* $BAq1`$,$^$@(BAbort$B$5$l$F$$$J$+$C$?$i(B */
      $USE(D_WorkParentFPReg);
      s_GetFPRecordOfShoen(shoen_record, D_WorkParentFPReg);
      s_IfAbortedOrAbortedTerminateFP(D_WorkParentFPReg)
	{ /* $BAq1`$N?FN$?F$,4{$K(B Abort$B$5$l$F$$$?$i(B ($B;q8;MW5a$OL5;k$9$k(B) */
	  /* $BN$?F$O0lC6(B Aborted$B>uBV$K$J$C$?$iFsEY$H<B9T2DG=>uBV$K$OLa$i$:!"(B
             $B$^$?!"<B:]$K?FN$?F$+$i?FAq1`$K;q8;MW5a%a%C%;!<%8$rAw$k:]$K$O!"(B
             $B:F$SN$?F$N>uBV$r%A%'%C%/$9$k$N$G!"$3$3$G$O?FN$?F$r%m%C%/$9$k(B
             $BI,MW$O$J$$!#(B */
	  @DEBUG{
	    _PrintSHInfo(shoen_record);
	    _PrintFPInfo(D_WorkParentFPReg);
	    WARNING("f_ShoenReceiveRequestResourceWithoutLock",
		    "ResourceRequest to the Shoen whose ParentFP was Aborted: ignored"); };
	  $RELEASE(D_WorkParentFPReg);
	}
      else
	{ /* $BAq1`$b?FN$?F$b(B Abort$B$5$l$F$$$J$1$l$P(B */
	  $RELEASE(D_WorkParentFPReg);
	  s_SetResourceRequestFPTableFlagOn(shoen_record, cl_num_reg);

	  /* !! */
	  $CALL( f_Send_IntClMsg_SupplyResource_ToResourceRequestFPs_Sub
		                                          (shoen_record) );
	  /* !! $CALL( f_DistributeShoenResourceWithoutLock_Sub
		                                          (shoen_record) ); */
	}
    }
}

/******************************************************************** PSL **

       written by kawai@icot22      on Mon Jun  4 23:02:56 1990
<Arguments>
  shoen_record : $BAq1`%l%3!<%I$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
  stat_upper_reg : $BN$?F$+$i2sEz$5$l$?>CHq;q8;NL(B($B>e0L(B)
  stat_lower_reg : $BN$?F$+$i2sEz$5$l$?>CHq;q8;NL(B($B2<0L(B)
  wtc_left_reg : $BAq1`$N;D(BWTC$BNL$rJ];}$9$k%l%8%9%?(B
                 $B%a%C%;!<%8%O%s%I%i$,%a%C%;!<%8$r<u?.$7$?;~$K!"%a%C%;!<%8Cf$N(B
                 $BAq1`$N30It;2>H(BID$B$+$iAq1`$X$N%]%$%s%?$rF@$k:]$KF1;~$K(BWTC$B$N%a%s(B
                 $B%F$r9T$$!"$=$N7k2L$r$3$N%l%8%9%?$K>h$;$F$3$N%^%/%m$r8F$S=P$9!#(B
  cl_num_reg : $B$3$N%a%C%;!<%8$NAw?.85%/%i%9%?$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
  $B8F$S=P$785$GAq1`%l%3!<%I$K%m%C%/$r3]$1$J$$$3$H!#(B
<Function>
  $BB>%/%i%9%?$K$"$k$3$NAq1`$NN$?F$+$i>CHq;q8;NLD4::MW5a$KBP$9$k2sEz$H$7$FAw$i$l(B
$B$F$/$k(B AnswerStatistics$B%a%C%;!<%8$r=hM}$9$k%^%/%m$G$"$k!#(B
  $B$3$N%^%/%m$O(BAnswerStatistics$B%a%C%;!<%8$r<u?.$7$?;~%M%C%H%o!<%/%O%s%I%i$+$i(B
$B8F$S=P$5$l$k!#(B

  $B<g$J=hM}FbMF(B:
 (1) $BAq1`%l%3!<%I$N%m%C%/(B
 (2) $BAq1`$N>CHq;q8;NL$N2C;;(B
 (3) $BAq1`$N(BStatCount$B$N%G%/%j%a%s%H(B
 (4) ($BA4$F$NN$?F$+$i2sEz$,JV$C$F$-$?;~(B)
     (4.1) ($B?FN$?F$+$i$ND4::0MMj$@$C$?;~(B)
           (4.1.1) $B?FN$?F$K>CHq;q8;NL$rJs9p(B
     (4.2) ($B%3%s%H%m!<%k%9%H%j!<%`$+$i$ND4::0MMj$@$C$?;~(B)
           (4.2.1) $B%l%]!<%H%9%H%j!<%`$KJs9p(B
 (5) ($B$^$@>CHq;q8;D4::MW5a$,N/$^$C$F$$$k;~(B)
     (5.1) $B:F$SA4N$?F$K>CHq;q8;D4::MW5a$r=P$9(B
 (6) $BAq1`%l%3!<%I$N%"%s%m%C%/(B
 (7) $BAq1`$N=*7kH=Dj(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define  D_WorkShoenParentFPReg  XXX
#DATA_define  D_WorkShoenResourceConsumeUpper     XXX
#DATA_define  D_WorkShoenResourceConsumeLower     XXX
#DATA_define  D_WorkShoenAskMoreFlag  XXX

#PSL_define  f_ShoenReceiveAnswerStatistics(shoen_record, stat_upper_reg,
				                   stat_lower_reg, cl_num_reg)
{
  @DEBUG{
    _PrintSHInfo(shoen_record);
    WARNING("f_ShoenReceiveAnswerStatistics","Shoen Received Ans Stat");
  };

  $USE(D_WorkShoenOrgLockTagReg);
  s_LockShoenRecord(shoen_record, D_WorkShoenOrgLockTagReg);
  s_AddShoenResourceConsumed(shoen_record, stat_upper_reg, stat_lower_reg);
  s_DecrementShoenStatCount(shoen_record);
  s_IfNotReceiveAllAnsFromFP(shoen_record)
    { /* $BN$?F$+$i$N1~Ez$,$^$@A4$FLa$C$F$-$F$$$J$+$C$?$i(B */
      s_UnlockShoenRecord(shoen_record, D_WorkShoenOrgLockTagReg);
      $RELEASE(D_WorkShoenOrgLockTagReg);
    }
  else
    { /* $BN$?F$+$i$N1~Ez$,A4$FLa$C$F$-$?$i(B */

      @DEBUG{
	WARNING("f_ShoenReceiveAnswerStatistics","Ans From All FP arrived");
      };

      $USE(D_WorkShoenAskMoreFlag);
      /* $B$3$N$^$/$m$N$J$+$G!"$7$g$&$($s$l$3!<$I$O$"$s$m$C$/$5$l$k(B */
      f_ReportShoenStatistics(shoen_record, D_WorkShoenOrgLockTagReg,
			                            D_WorkShoenAskMoreFlag);

      /* $B$b$&0lEY%m%C%/$7$F!";q8;D4::MW5a$,;D$C$F$$$k$+H]$+$r8+$k(B */
      LOOP()
	{
	  s_LockShoenRecord(shoen_record, D_WorkShoenOrgLockTagReg);
	  b_IfNotEqual(D_WorkShoenAskMoreFlag, D_NULL)
	    {  /*  $B$^$@;q8;D4::MW5a$,;D$C$F$$$l$P(B  */
	      s_IfFPExist(shoen_record)
		{ /* $B$7$g$&$($s$K$5$H$*$d$,$$$l$P(B */
		  f_AskStatToAllFPs(shoen_record);
		  s_UnlockShoenRecord(shoen_record, D_WorkShoenOrgLockTagReg);
		  break;
		}
	      else
		{ /* $B$7$g$&$($s$K$5$H$*$d$,$$$J$1$l$P(B */
		  f_ReportShoenStatistics(shoen_record,
                                                D_WorkShoenOrgLockTagReg,
					               D_WorkShoenAskMoreFlag);
		}
	    }
	  else
	    {  /*  $B$b$&;q8;D4::MW5a$,;D$C$F$$$J$1$l$P(B  */
	      s_UnlockShoenRecord(shoen_record, D_WorkShoenOrgLockTagReg);
	      break;
	    }
	}
      $RELEASE(D_WorkShoenAskMoreFlag);
      $RELEASE(D_WorkShoenOrgLockTagReg);
    }
}


/* $B$3$N%^%/%m$NCf$G!"Aq1`%l%3!<%I$O%"%s%m%C%/$5$l$k(B */
#PSL_define  f_ReportShoenStatistics(shoen_record, shoen_lock_tag,
				                              ask_more_flag)
{
  s_IfAskShoenStatFromOnlyParentFP(shoen_record)
    { /* $B?FN$?F$+$i$ND4::0MMj$N$_$@$C$?$i(B */
      s_DecrementShoenUpperStatHook(shoen_record);
      $USE(D_WorkShoenParentFPReg);
      $USE(D_WorkShoenResourceConsumeUpper);
      $USE(D_WorkShoenResourceConsumeLower);
      s_GetShoenResourceConsumedWithUpdate(shoen_record, 
					   D_WorkShoenResourceConsumeUpper,
				           D_WorkShoenResourceConsumeLower);
      s_GetFPRecordOfShoen(shoen_record, D_WorkShoenParentFPReg);
      s_GetStatHook(shoen_record, ask_more_flag);

      /* $BAq1`%l%3!<%I$O0lC6%"%s%m%C%/$9$k(B */
      s_UnlockShoenRecord(shoen_record, shoen_lock_tag);

      /* $B$3$N%^%/%m$NCf$G!"?FN$?F$,%m%C%/(B/$B%"%s%m%C%/$5$l$k!#(B*/
      /* $B%/%i%9%?Fb(BPE$B$K%-%c%C%7%e$5$l$F$$$k;q8;$N%G%-%c%C%7%e$b9T$o$l$k(B */
      f_FPAddAnswerResource(D_WorkShoenParentFPReg, 
				     D_WorkShoenResourceConsumeUpper,
				           D_WorkShoenResourceConsumeLower);
      $RELEASE(D_WorkShoenResourceConsumeUpper);
      $RELEASE(D_WorkShoenResourceConsumeLower);
      $RELEASE(D_WorkShoenParentFPReg);
    }
  else
    {  /* CS$B$+$i$ND4::0MMj$@$C$?$i(B */
      s_IfAskShoenStatFromOnlyCS(shoen_record)
	{  /* $B%3%s%H%m!<%k%9%H%j!<%`$+$i$@$1$ND4::0MMj$@$C$?$i(B  */
	  s_DecrementShoenLowerStatHook(shoen_record);
	}
      else
	{  
	  s_IfAskShoenStatFromFPAndCS(shoen_record)
	    { /* $B?FN$?F$+$i$N;q8;NLLd$$9g$o$;$NA0$K!"<+Aq1`$K(BCS$B$+$i$N(B
		$BLd$$9g$o$;$,$"$C$?$i(B */
	      s_DecrementShoenUpperStatHook(shoen_record);
	    }
	  else
	    {
	      @DEBUG{ VPIM_ERROR("f_ReportShoenStatistics",
				 "Illegal StatHook Count"); };
	    }
	}

      @DEBUG{
	WARNING("f_ReportShoenStatistics",
		                 "Ans Stat will be reported to rep stream");
      };
      s_GetStatHook(shoen_record, ask_more_flag);

      f_ReportShoenStatInformation(shoen_record);
      s_UnlockShoenRecord(shoen_record, shoen_lock_tag);
    }
}

/******************************************************************** PSL **

       written by kawai@icot21      on Tue Jun  5 17:18:21 1990
<Arguments>
  shoen_record : $BAq1`%l%3!<%I$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
  return_res_upper_reg : $BJV5Q$5$l$?;q8;(B($B>e0L(B)$B$rJ];}$9$k%l%8%9%?(B
  return_res_lower_reg : $BJV5Q$5$l$?;q8;(B($B2<0L(B)$B$rJ];}$9$k%l%8%9%?(B
  wtc_left_reg : $BAq1`$N;D(BWTC$BNL$rJ];}$9$k%l%8%9%?(B
                 $B%a%C%;!<%8%O%s%I%i$,%a%C%;!<%8$r<u?.$7$?;~$K!"%a%C%;!<%8Cf$N(B
                 $BAq1`$N30It;2>H(BID$B$+$iAq1`$X$N%]%$%s%?$rF@$k:]$KF1;~$K(BWTC$B$N%a%s(B
                 $B%F$r9T$$!"$=$N7k2L$r$3$N%l%8%9%?$K>h$;$F$3$N%^%/%m$r8F$S=P$9!#(B
  cl_num_reg : $B$3$N%a%C%;!<%8$NAw?.85%/%i%9%?$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
  $B8F$S=P$785$GAq1`%l%3!<%I$K%m%C%/$r3]$1$J$$$3$H!#(B
<Function>
  $BAq1`$KBP$7$F;q8;$NJV5Q$H$7$FAw$i$l$F$/$k(B ReturnResource$B%a%C%;!<%8$r=hM}$9$k(B
$B%^%/%m$G$"$k!#(B
  $B$J$*!"Aq1`$K;q8;$,JV5Q$5$l$k$N$O0J2<$N>l9g$G$"$k!#(B
    (1) $BAq1`$+$iN$?F$KBP$7$F;q8;6!5k$r9T$C$?$,!"08@h$NN$?F$,4{$K=*7k$7$F$$$?>l(B
        $B9g(B
    (2) $BN$?F$N;RAq1`$N=*7k$J$I$K$h$j!"N$?F$KBgNL$N;q8;$,N/$^$C$F$7$^$C$?>l9g(B
  $B$3$N%^%/%m$O(BReturnResource$B%a%C%;!<%8$r<u?.$7$?;~%M%C%H%o!<%/%O%s%I%i$+$i(B
$B8F$S=P$5$l$k!#(B

  $B<g$J=hM}FbMF(B:
 (1) $BAq1`%l%3!<%I$N%m%C%/(B
 (2) $BAq1`$KJV5Q;q8;NL$r2C;;(B
 (3) $BAq1`$N;q8;$rN$?F$KJ,G[(B($BMW5a$,$"$k>l9g(B)
 (4) $BAq1`%l%3!<%I$N%"%s%m%C%/(B
 (5) $BAq1`$N=*7kH=Dj(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define  f_ShoenReceiveReturnResource(shoen_record, return_res_upper_reg,
				                         return_res_lower_reg)
{
  @DEBUG{
    _PrintSHInfo(shoen_record);
    WARNING("f_ShoenReceiveReturnResource","Shoen Receive Return Resource");
  };

  $USE(D_WorkShoenOrgLockTagReg);
  s_LockShoenRecord(shoen_record, D_WorkShoenOrgLockTagReg);

  $USE(D_WorkShoenResourceLeftUpper);
  $USE(D_WorkShoenResourceLeftLower);

  s_GetShoenResourceLeft(shoen_record, D_WorkShoenResourceLeftUpper,
			                    D_WorkShoenResourceLeftLower);

  $USE(D_WorkShoenResourceAddendUpper);
  $USE(D_WorkShoenResourceAddendLower);
  $USE(D_WorkShoenResourceSurplusUpper);
  $USE(D_WorkShoenResourceSurplusLower);
  /* !! Check Overflow !! */
  b_CheckResourceSurplus(D_WorkShoenResourceLeftUpper,
			 D_WorkShoenResourceLeftLower,
			 return_res_upper_reg,
			 return_res_lower_reg,
			 D_WorkShoenResourceAddendUpper,
			 D_WorkShoenResourceAddendLower,
			 D_WorkShoenResourceSurplusUpper,
			 D_WorkShoenResourceSurplusLower);

  $RELEASE(D_WorkShoenResourceLeftUpper);
  $RELEASE(D_WorkShoenResourceLeftLower);

  s_AddShoenResourceLeft(shoen_record, D_WorkShoenResourceAddendUpper,
			                     D_WorkShoenResourceAddendLower);

  b_IfNotZeroDoubleWord(D_WorkShoenResourceSurplusUpper,
			D_WorkShoenResourceSurplusLower)
    { /* !! If Overflow, Check ResourceLimitLeft Overflow !! */
      $USE(D_WorkShoenResourceLimitLeftUpper);
      $USE(D_WorkShoenResourceLimitLeftLower);

      s_GetShoenResourceLimitLeft(shoen_record,
				  D_WorkShoenResourceLimitLeftUpper,
				  D_WorkShoenResourceLimitLeftLower);

      $USE(D_WorkShoenResourceSurplusUpper1);
      $USE(D_WorkShoenResourceSurplusLower1);

      b_CheckResourceSurplus(D_WorkShoenResourceLimitLeftUpper,
			     D_WorkShoenResourceLimitLeftLower,
			     D_WorkShoenResourceSurplusUpper,
			     D_WorkShoenResourceSurplusLower,
			     D_WorkShoenResourceAddendUpper,
			     D_WorkShoenResourceAddendLower,
			     D_WorkShoenResourceSurplusUpper1,
			     D_WorkShoenResourceSurplusLower1);

      $RELEASE(D_WorkShoenResourceLimitLeftUpper);
      $RELEASE(D_WorkShoenResourceLimitLeftLower);

      s_AddShoenResourceLimitLeft(shoen_record,
				  D_WorkShoenResourceAddendUpper,
				  D_WorkShoenResourceAddendLower);
      b_IfNotZeroDoubleWord(D_WorkShoenResourceSurplusUpper1,
			    D_WorkShoenResourceSurplusLower1)
	{ /* !! If ResourceLimitLeft Overflow, Report ReturnResource !! */
	  f_ReportShoenResourceInfo(shoen_record, _RETURN_RSC_REP,
				    D_WorkShoenResourceSurplusUpper1,
				    D_WorkShoenResourceSurplusLower1);
	}

      $RELEASE(D_WorkShoenResourceSurplusUpper1);
      $RELEASE(D_WorkShoenResourceSurplusLower1);
    }

  /* !! */
  $CALL( f_Send_IntClMsg_SupplyResource_ToResourceRequestFPs_Sub
	                                                     (shoen_record) );
  /* !! $CALL( f_DistributeShoenResourceWithoutLock_Sub(shoen_record) ); */

  s_UnlockShoenRecord(shoen_record, D_WorkShoenOrgLockTagReg);
  $RELEASE(D_WorkShoenOrgLockTagReg);

  b_IfNotZeroDoubleWord(D_WorkShoenResourceSurplusUpper,
			D_WorkShoenResourceSurplusLower)
    { /* !! PutBack Surplus Resource to Parent FP !! */
      $USE(D_WorkShoenParentFPReg);
      s_GetFPRecordOfShoen(shoen_record, D_WorkShoenParentFPReg);
      f_FPResourceSuppliedByShoenResourceOverflow(D_WorkShoenParentFPReg,
					    D_WorkShoenResourceSurplusUpper,
					    D_WorkShoenResourceSurplusLower);
      $RELEASE(D_WorkShoenParentFPReg);
    }
  $RELEASE(D_WorkShoenResourceAddendUpper);
  $RELEASE(D_WorkShoenResourceAddendLower);
  $RELEASE(D_WorkShoenResourceSurplusUpper);
  $RELEASE(D_WorkShoenResourceSurplusLower);
}

/******************************************************************** PSL **

       written by kawai@icot22      on Wed Sep 26 16:37:48 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#SUBARG_define	A_ShoenRecord		SRC
#SUBARG_define	A_ExTag         	SRC  /* !! $B?75,DI2C(B */
#SUBARG_define	A_ExNum         	SRC
#SUBARG_define	A_ExInfoVect		SRC
#SUBARG_define	A_NewCode		SRC
#SUBARG_define	A_NewArgVect		SRC

#SUBROUTINE f_ShoenReceiveException_Sub(A_ShoenRecord, A_ExTag, A_ExNum, 
					A_ExInfoVect, A_NewCode, A_NewArgVect)
{
  f_ReportException(A_ShoenRecord, A_ExTag, A_ExNum, A_ExInfoVect,
		                                     A_NewCode, A_NewArgVect);
  $RETURN ();
}

/******************************************************************** PSL **

       written by kawai@icot22      on Tue Nov 20 21:08:45 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define  f_ShoenReceiveNAKStop(shoen_record, cl_num_reg)
{
  s_IfStartStopBitTableFlagOn(shoen_record, cl_num_reg)
    { /* start/stop$B%S%C%H$,(Bon$B$@$C$?$i(B */
      s_IfFPTableFlagOn(shoen_record, cl_num_reg)
	{ /* $B$=$N%/%i%9%?$KN$?F$,$$$?$i(B */
	  s_IfShoenStopped(shoen_record)
	    { /* $BAq1`$,(B stop$B>uBV(B(stopped_by_control/parent/both)$B$@$C$?$i(B */
	      f_Send_IntClMsg_OneFP(shoen_record, _NW_STOP, cl_num_reg);
	    }
	  else
	    { /* $BAq1`$,(B stop$B>uBV(B(stopped_by_control/parent/both)$B$G$J$1$l$P(B */
	      s_SetStartStopBitTableFlagOff(shoen_record, cl_num_reg);
	    }
	}
      else
	{ /* $B$=$N%/%i%9%?$KN$?F$,$$$J$1$l$P(B */
	  s_SetStartStopBitTableFlagOff(shoen_record, cl_num_reg);
	}
    }
  else
    { /* start/stop$B%S%C%H$,(Boff$B$@$C$?$i(B */
      f_Send_IntClMsg_OneFP(shoen_record, _NW_STOP, cl_num_reg);
    }
}


#PSL_define  f_ShoenReceiveNAKStart(shoen_record, cl_num_reg)
{
  s_IfStartStopBitTableFlagOn(shoen_record, cl_num_reg)
    { /* start/stop$B%S%C%H$,(Bon$B$@$C$?$i(B */
      f_Send_IntClMsg_OneFP(shoen_record, _NW_START, cl_num_reg);
    }
  else
    { /* start/stop$B%S%C%H$,(Boff$B$@$C$?$i(B */
      s_IfFPTableFlagOn(shoen_record, cl_num_reg)
	{ /* $B$=$N%/%i%9%?$KN$?F$,$$$?$i(B */
	  s_IfShoenTransitStatusImmediately(shoen_record, _STARTED)
	    { /* $BAq1`$,(B started$B>uBV$@$C$?$i(B */
	      f_Send_IntClMsg_OneFP(shoen_record, _NW_START, cl_num_reg);
	    }
	  else
	    { /* $BAq1`$,(B started$B>uBV$G$J$1$l$P(B */
	      s_SetStartStopBitTableFlagOn(shoen_record, cl_num_reg);
	    }
	}
      else
	{ /* $B$=$N%/%i%9%?$KN$?F$,$$$J$1$l$P(B */
	  s_SetStartStopBitTableFlagOn(shoen_record, cl_num_reg);
	}
    }
}

/******************************************************************** PSL **

       written by kawai@icot22      on Thu May 16 22:07:15 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define  f_ShoenReceiveAnswerProfile(shoen_record, type_reg,
					 total_ans_reg, depth_reg, 
					 cl_num_reg, profile_result)
{
  @DEBUG{
    _PrintSHInfo(shoen_record);
    WARNING("f_ShoenReceiveAnswerProfile","Shoen Received Ans Profile");
  };

  $USE(D_WorkShoenOrgLockTagReg);
  s_LockShoenRecord(shoen_record, D_WorkShoenOrgLockTagReg);

  s_IfShoenStatusFlagOn(shoen_record, _PROFILING_SHOEN_FLAG_MASK)
    { /* $B$3$NAq1`$,(B Profiling$BAq1`$@$C$?$i(B */
      f_AnswerProfileForProfilingShoen(shoen_record, type_reg, total_ans_reg,
				       depth_reg, cl_num_reg, profile_result);
      s_UnlockShoenRecord(shoen_record, D_WorkShoenOrgLockTagReg);
    }
  else
    { /* $B$3$NAq1`$,(B Profiling$BAq1`$G$J$+$C$?$i(B */
      /* kono macro no nakade shoen ha unlock sareru. */
      f_AnswerProfileForOrdinaryShoen(shoen_record, D_WorkShoenOrgLockTagReg,
				      type_reg, total_ans_reg,
				       depth_reg, cl_num_reg, profile_result);
    }
  $RELEASE(D_WorkShoenOrgLockTagReg);
}




#PSL_define  f_AnswerProfileForProfilingShoen(shoen_record, type_reg,
					      total_ans_reg, depth_reg, 
					      cl_num_reg, profile_result)
{
  ValueSwitch(type_reg)
    {
    case _FP_PROFILETYPE_ANSWER :
      /* Ask $B$KBP$9$k1~Ez$@$C$?$i(B */
      f_ReportShoenProfileInfo(shoen_record, cl_num_reg, type_reg, depth_reg,
			                                      profile_result);
      
      s_IncrementReportedProfileCount(shoen_record);
      s_IfLastAnsProfileFromFP(total_ans_reg)
	{ /* $BD>2<$NN$?F$+$i$N:G8e$N(B Profile$BJs9p$@$C$?$i(B */
	  s_AddSHTotalAnsProfileCount(shoen_record, total_ans_reg);
	  s_DecrementAskProfileFPCount(shoen_record);
	}
      s_IfShoenProfileCompleted(shoen_record)
	{ /* $BA4$F$N(B Profile$BJs9p$,40N;$7$?$i(B */
	  f_ReportShoenMessage(shoen_record, _PROF_COMPLETED_REP);
	}
      break;
    case _FP_PROFILETYPE_FPTERMINATE :
    case _FP_PROFILETYPE_COUNTLIMIT :
      /* Ask $B$KBP$9$k1~Ez$G$J$+$C$?$i(B(FP$B=*7k!"%+%&%s%?%*!<%P%U%m!<(B)
	$BC1$K%l%]!<%H$9$k$N$_(B */
      f_ReportShoenProfileInfo(shoen_record, cl_num_reg, type_reg, depth_reg,
			                                      profile_result);
      break;
    case _FP_PROFILETYPE_NO_FP :
      /* Ask$B$rAw$C$?%/%i%9%?$KN$?F$,$$$J$+$C$?$i(B */
      s_DecrementAskProfileFPCount(shoen_record);
      s_IfShoenProfileCompleted(shoen_record)
	{ /* $BA4$F$N(B Profile$BJs9p$,40N;$7$?$i(B */
	  f_ReportShoenMessage(shoen_record, _PROF_COMPLETED_REP);
	}
      break;
    default :
      /* $B$=$NB>$N(B TYPE $B$,Mh$?$i(B */
      @DEBUG{
       VPIM_ERROR("f_AnswerProfileForProfilingShoen","Illegal Profiling Type");
     };
    }
}



#DATA_define  D_WorkParentProfFP  XXX

#PSL_define  f_AnswerProfileForOrdinaryShoen(shoen_record, sh_org_lock_tag,
					     type_reg,
					     total_ans_reg, depth_reg, 
					     cl_num_reg, profile_result)
{
  s_IfShoenStatusFlagOn(shoen_record, _PROFILING_PARENT_SHOEN_FLAG_MASK)
    { /* $B$3$NAq1`$NAD@h$NAq1`$,(B Profiling$BAq1`$@$C$?$i(B */
      b_IncrementReg(depth_reg); /* $B?<$5$r%$%s%/%j%a%s%H$9$k(B */

      ValueSwitch(type_reg)
	    {
	    case _FP_PROFILETYPE_ANSWER :
	      /* Ask $B$KBP$9$k1~Ez$@$C$?$i(B */
	      s_IfLastAnsProfileFromFP(total_ans_reg)
		{ /* FP $B$+$i$N:G8e$N(B Ans $B$@$C$?$i(B */
		  s_AddSHTotalAnsProfileCount(shoen_record, total_ans_reg);
		  s_DecrementAskProfileFPCount(shoen_record);
		  s_IfAllFPAnsProfile(shoen_record)
		    { /* $BA4$F$N(B FP $B$+$i(B Ans $B$,E~Ce$7$?$i(B */
		      /* total_ans_reg $B$r(B $B=q$-DY$9$N$GCm0U$9$k$3$H(B */
		      s_GetSHTotalAnsProfileCount(shoen_record, total_ans_reg);
		    }
	          else
		    { /* $B$^$@(B Ans $B$rJV$7$F$$$J$$(B FP $B$,$"$C$?$i(B */
		      /* total_ans_reg $B$r(B $B=q$-DY$9$N$GCm0U$9$k$3$H(B */
		      p_MoveValue(D_NULL, total_ans_reg);
		    }
		}
	      /* FP $B$+$i$N:G8e$N(B Ans $B$G$J$+$C$?$i!"$=$N$^$^>e$K>e$2$k(B*/
	      /* $B$3$N;~$O(B total_ans_reg = D_NULL $B$NH&$G$"$k(B */
	      $USE(D_WorkParentProfFP);
	      s_GetFPRecordOfShoen(shoen_record, D_WorkParentProfFP);
	      s_UnlockShoenRecord(shoen_record, sh_org_lock_tag);

	      f_PassProfileToParentFP(D_WorkParentProfFP, type_reg,
				      total_ans_reg,
				      depth_reg, cl_num_reg, profile_result);
	      $RELEASE(D_WorkParentProfFP);
	      break;
	    case _FP_PROFILETYPE_FPTERMINATE :
	    case _FP_PROFILETYPE_COUNTLIMIT :
	      /* Ask $B$KBP$9$k1~Ez$G$J$+$C$?$i(B(FP$B=*7k!"%+%&%s%?%*!<%P%U%m!<(B)
		$B$=$N$^$^>e$K>e$2$k(B */
	      /* $B$3$N;~$O(B total_ans_reg = D_NULL $B$NH&$G$"$k(B */
	      $USE(D_WorkParentProfFP);
	      s_GetFPRecordOfShoen(shoen_record, D_WorkParentProfFP);
	      s_UnlockShoenRecord(shoen_record, sh_org_lock_tag);

	      f_PassProfileToParentFP(D_WorkParentProfFP, type_reg,
				      total_ans_reg,
				      depth_reg, cl_num_reg, profile_result);
	      $RELEASE(D_WorkParentProfFP);
	      break;
	    case _FP_PROFILETYPE_NO_FP :
	      /* Ask$B$rAw$C$?%/%i%9%?$KN$?F$,$$$J$+$C$?$i(B */
	      s_DecrementAskProfileFPCount(shoen_record);
	      s_IfAllFPAnsProfile(shoen_record)
		{ /* $BA4$F$N(B FP $B$+$i(B Ans $B$,E~Ce$7$?$i(B */
		  /* total_ans_reg $B$r(B $B=q$-DY$9$N$GCm0U$9$k$3$H(B */
		  s_GetSHTotalAnsProfileCount(shoen_record, total_ans_reg);

		  $USE(D_WorkParentProfFP);
		  s_GetFPRecordOfShoen(shoen_record, D_WorkParentProfFP);
		  s_UnlockShoenRecord(shoen_record, sh_org_lock_tag);

/* !!! For Debug !!! */
		  @DEBUG{
		    WARNING("f_AnswerProfileForOrdinaryShoen",
			    "SH receive No FP Ans From FP");};


		  f_PassProfileToParentFP(D_WorkParentProfFP, type_reg,
					  total_ans_reg, depth_reg,
					  cl_num_reg, profile_result);
		  $RELEASE(D_WorkParentProfFP);
		}
	      else
		{
		  s_UnlockShoenRecord(shoen_record, sh_org_lock_tag);
		}
	      break;
	    default :
	      /* $B$=$NB>$N(B TYPE $B$,Mh$?$i(B */
	      s_UnlockShoenRecord(shoen_record, sh_org_lock_tag);
	      @DEBUG{ VPIM_ERROR("f_AnswerProfileForOrdinaryShoen",
				 "Illegal Profiling Type"); };
	    }
    }
  else
    { /* $B$3$NAq1`$NAD@h$,(B Profiling$BAq1`$G$J$+$C$?$i(B */
      s_UnlockShoenRecord(shoen_record, sh_org_lock_tag);
      @DEBUG{ VPIM_ERROR("f_AnswerProfileForOrdinaryShoen",
			 "Ans Profile to Not Profile Shoen"); };
    }
}


/******************************************************************** PSL **

  $B?FN$?F$+$iAq1`$r%3%s%H%m!<%k$9$k%^%/%m(B

       written by kawai@icot21      on Tue Jun  5 21:34:34 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#SUBARG_define  A_SHRecord   SRC

#SUBROUTINE  f_StartByParent_Sub(A_SHRecord)
{
  @DEBUG{
    WARNING("f_StartByParent_Sub","Shoen Started by Parent");
  };

  /*  $BAq1`%l%3!<%I$r%=%U%H%m%C%/$9$k(B */
  $USE(D_WorkShoenOrgLockTagReg);
  s_LockShoenRecord(A_SHRecord, D_WorkShoenOrgLockTagReg);

  s_IfNotShoenUnhookReserved(A_SHRecord)
    { /* $BAq1`$,2rJ|M=Ls$G$J$+$C$?$i(B */
      $USE(D_WorkShoenTransitStatusReg);
      s_GetShoenTransitStatus(A_SHRecord, D_WorkShoenTransitStatusReg);
      ValueSwitch(D_WorkShoenTransitStatusReg)
	{
	case _STOPPED_BY_PARENT :
	  s_PutShoenTransitStatusImmediately(A_SHRecord, _STARTED);
	  s_IfFPExist(A_SHRecord)
	    {
	      /* !! */
	      $CALL( f_Send_IntClMsg_Start_ToStoppedFPs_Sub(A_SHRecord) );
	      /* !!
	      f_SendWithStartStopBitTable(A_SHRecord, _NW_START);
	      */
	    }
	  break;
	case _STOPPED_BY_BOTH :
	  s_PutShoenTransitStatusImmediately(A_SHRecord, _STOPPED_BY_CTRL);
	  break;
	case _STARTED :
	  @DEBUG{
	    VPIM_ERROR("f_StartByParent_Sub",
		                         "StartByParent to Started Shoen");
	  };
	  break;
	case _STOPPED_BY_CTRL :
	  @DEBUG{ VPIM_ERROR("f_StartByParent_Sub",
			     "StartByParent to StoppedByControl Shoen"); };
	  break;
	case _ABORTED :
	case _TERMINATED :
	  @DEBUG{ VPIM_ERROR("f_StartByParent",
			     "StartByParent to Aborted/Terminated Shoen"); };
	  break;
	default :
	  @DEBUG{ VPIM_ERROR("StartByParent_Sub", "Illegal Shoen Status"); };
	}
      $RELEASE(D_WorkShoenTransitStatusReg);
    }
  /*  $BAq1`%l%3!<%I$r%"%s%m%C%/$9$k(B */
  s_UnlockShoenRecord(A_SHRecord, D_WorkShoenOrgLockTagReg);
  $RELEASE(D_WorkShoenOrgLockTagReg);

  $RETURN();
}

/******************************************************************** PSL **

       written by kawai@icot22      on Thu Jul 26 21:40:52 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#SUBARG_define  A_SHRecord   SRC

#SUBROUTINE  f_StopByParent_Sub(A_SHRecord)
{
  @DEBUG{
    WARNING("f_StopByParent_Sub","Shoen Stopped by Parent");
  };

  /*  $BAq1`%l%3!<%I$r%=%U%H%m%C%/$9$k(B */
  $USE(D_WorkShoenOrgLockTagReg);
  s_LockShoenRecord(A_SHRecord, D_WorkShoenOrgLockTagReg);

  s_IfNotShoenUnhookReserved(A_SHRecord)
    { /* $BAq1`$,2rJ|M=Ls$G$J$+$C$?$i(B */
      $USE(D_WorkShoenTransitStatusReg);
      s_GetShoenTransitStatus(A_SHRecord, D_WorkShoenTransitStatusReg);
      ValueSwitch(D_WorkShoenTransitStatusReg)
	{
	case _STARTED :
	  s_PutShoenTransitStatusImmediately(A_SHRecord, _STOPPED_BY_PARENT);
	  s_IfFPExist(A_SHRecord)
	    {
	      /* !! */
	      $CALL( f_Send_IntClMsg_Stop_ToStartedFPs_Sub(A_SHRecord) );
	      /* !!
	      f_SendWithStartStopBitTable(A_SHRecord, _NW_STOP);
	      */
	    }
	  break;
	case _STOPPED_BY_CTRL :
	  s_PutShoenTransitStatusImmediately(A_SHRecord, _STOPPED_BY_BOTH);
	  break;
	case _STOPPED_BY_PARENT :
	  @DEBUG{ VPIM_ERROR("f_StopByParent_Sub",
			     "StopByParent to StoppedByParent Shoen"); };
	  break;
	case _STOPPED_BY_BOTH :
	  @DEBUG{
	   VPIM_ERROR("f_StopByParent_Sub",
		                     "StopByParent to StoppedByBoth Shoen");
	 };
	  break;
	case _ABORTED :
	case _TERMINATED :
	  @DEBUG{ VPIM_ERROR("f_StopByParent_Sub",
			     "StopByParent to Aborted/Terminated Shoen"); };
	  break;
	default :
	  @DEBUG{ VPIM_ERROR("StopByParent_Sub", "Illegal Shoen Status"); };
	}
      $RELEASE(D_WorkShoenTransitStatusReg);
    }

  /*  $BAq1`%l%3!<%I$r%"%s%m%C%/$9$k(B */
  s_UnlockShoenRecord(A_SHRecord, D_WorkShoenOrgLockTagReg);
  $RELEASE(D_WorkShoenOrgLockTagReg);

  $RETURN();
}

/******************************************************************** PSL **

       written by kawai@icot22      on Thu Jul 26 21:41:05 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#SUBARG_define  A_SHRecord   SRC

#SUBROUTINE  f_AbortByParent_Sub(A_SHRecord)
{
  @DEBUG{
    WARNING("f_AbortByParent_Sub","Shoen Aborted by Parent");
  };

  $USE(D_WorkShoenTransitStatusReg);

  /*  $BAq1`%l%3!<%I$r%=%U%H%m%C%/$9$k(B */
  $USE(D_WorkShoenOrgLockTagReg);
  s_LockShoenRecord(A_SHRecord, D_WorkShoenOrgLockTagReg);

  s_IfNotShoenUnhookReserved(A_SHRecord)
    { /* $BAq1`$,2rJ|M=Ls$G$J$+$C$?$i(B */
      s_GetShoenTransitStatus(A_SHRecord, D_WorkShoenTransitStatusReg);
      ValueSwitch(D_WorkShoenTransitStatusReg)
	{
	case _STARTED :
	case _STOPPED_BY_PARENT :
	case _STOPPED_BY_CTRL :
	case _STOPPED_BY_BOTH :
	  s_PutShoenTransitStatusImmediately(A_SHRecord, _ABORTED);
	  s_IfFPExist(A_SHRecord)
	    {
	      /* !! */
	      f_Send_IntClMsg_ToAllFPs(A_SHRecord, _NW_ABORT);

	      /* !!f_SendToAllFPs(A_SHRecord, _NW_ABORT); */
	    }
	  break;
	case _ABORTED :
	  @DEBUG{ WARNING("f_AbortByParent_Sub",
			  "Abort to Aborted ChildShoen"); };
	  break;
	case _TERMINATED :
	  @DEBUG{ VPIM_ERROR("f_AbortByParent_Sub",
			     "Abort to Terminated ChildShoen"); };
	  break;
	default :
	  @DEBUG{ VPIM_ERROR("f_AbortByParent_Sub",
			     "Illegal ChildShoen Status"); };
	}
      $RELEASE(D_WorkShoenTransitStatusReg);
    }

  /*  $BAq1`%l%3!<%I$r%"%s%m%C%/$9$k(B */
  s_UnlockShoenRecord(A_SHRecord, D_WorkShoenOrgLockTagReg);
  $RELEASE(D_WorkShoenOrgLockTagReg);

  $RETURN();
}
