
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_shoen_main.psl.c
   ----- CREATED   : by kawai@icot22, on Fri May 25 20:17:46 1990
   ----- LAST SAVED: by kawai@icot22, on Wed Mar  4 20:36:10 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : 
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **

(1) $BAq1`%l%3!<%I$N3d$jEv$F$H=i4|2=(B

       written by kawai@icot22      on Tue May 29 14:20:51 1990
<Arguments>
 ^shoen_record : $BAq1`%l%3!<%I$X$N%]%$%s%?$rJV$9%l%8%9%?(B
  min_prio_reg : $BAq1`Fb$G<B9T$5$l$k%4!<%k$N:GDc%W%i%$%*%j%F%#$,EO$5$l$k%l%8%9%?(B
  max_prio_reg : $BAq1`Fb$G<B9T$5$l$k%4!<%k$N:G9b%W%i%$%*%j%F%#$,EO$5$l$k%l%8%9%?(B
  ex_mask_reg : $BAq1`$N%(%/%;%W%7%g%s%^%9%/%Q%?%s$,EO$5$l$k%l%8%9%?(B
  rep_stream_reg : $BAq1`$N%l%]!<%H%9%H%j!<%`MQJQ?t$,EO$5$l$k%l%8%9%?(B
  shoen_status_imm : $BAq1`$N=i4|>uBV(B($BB(CM(B)$B$,EO$5$l$k%l%8%9%?(B
 ^shoen_id_reg : $BAq1`(BID$B$rJV$9%l%8%9%?(B
<Temporally Used Variables>
  D_WorkShoenInitReg : $BAq1`%l%3!<%I$N3F%9%m%C%H$N=i4|CM$r0l;~J];}$9$k%l%8%9%?(B
<Level>
<PreCondition>
<Function>
  $BAq1`%l%3!<%I$r3d$jEv$F!"F1;~$K3F%9%m%C%H$r=i4|2=$9$k!#(B
  $B3F%9%m%C%H$N=i4|CM$O0J2<$NDL$j!#(B


Original
$B0LCV(B    $B%9%m%C%H(B                    $B=i4|CM(B
-------------------------------------------------------------------------------
word0   ptr_to_fp_record            D_Current_FP_Ptr
word1   ptr_to_right_brother_shoen  D_EOL
word2   ptr_to_left_brother_shoen   D_EOL
word3   ptr_to_fp_table             $BN$?F%F!<%V%k%Y%/%?$X$N%]%$%s%?(B
word4   ptr_to_rsc_req_fp_table     $B;q8;MW5aN$?F%F!<%V%k%Y%/%?$X$N%]%$%s%?(B
word5   ptr_to_report_stream        $B0z?t$GEO$5$l$?JQ?t$X$N%]%$%s%?(B
word6   ptr_to_ready_terminate_cnt  ready/terminate$BDI$$1[$7%+%&%s%?%Y%/%?$X$N(B
                                    $B%]%$%s%?(B
word7   lock_flag                   $B%?%0It(B : INT   | $B%P%j%e!<It(B : D_NULL
word8   shoen_id                    $BAq1`$N30It;2>H(BID

word9   14($B%?%0$O(Bcdesc)             $B%?%0It(B : CDESC | $B%P%j%e!<It(B : 14
word10  shoen_status                $B%?%0It(B : DNTC  | $B%P%j%e!<It(B : D_NULL
word11  min_priority                $B%?%0It(B : DNTC  | $B%P%j%e!<It(B : $B0z?tDL$j(B
word12  max_priority                $B%?%0It(B : DNTC  | $B%P%j%e!<It(B : $B0z?tDL$j(B
word13  exception_mask              $B%?%0It(B : DNTC  | $B%P%j%e!<It(B : $B0z?tDL$j(B
word14  stat_hook                   $B%?%0It(B : DNTC  | $B%P%j%e!<It(B : D_NULL
word15  stat_count;                 $B%?%0It(B : DNTC  | $B%P%j%e!<It(B : D_NULL
word16  resource_consumed_u         $B%?%0It(B : DNTC  | $B%P%j%e!<It(B : D_NULL
word17  resource_consumed_l         $B%?%0It(B : DNTC  | $B%P%j%e!<It(B : D_NULL
word18  last_resource_consumed_u    $B%?%0It(B : DNTC  | $B%P%j%e!<It(B : D_NULL
word19  last_resource_consumed_l    $B%?%0It(B : DNTC  | $B%P%j%e!<It(B : D_NULL
word20  resource_left_u             $B%?%0It(B : DNTC  | $B%P%j%e!<It(B : D_NULL
word21  resource_left_l             $B%?%0It(B : DNTC  | $B%P%j%e!<It(B : 0x40000000
word22  resource_limit_left_u       $B%?%0It(B : DNTC  | $B%P%j%e!<It(B : D_NULL
word23  resource_limit_left_l       $B%?%0It(B : DNTC  | $B%P%j%e!<It(B : 0x40000000


Modified
$B0LCV(B    $B%9%m%C%H(B                    $B=i4|CM(B
-------------------------------------------------------------------------------
word1   lock_flag                     $B%?%0It(B : INT   | $B%P%j%e!<It(B : D_NULL
word2   shoen_id                      $BAq1`$N30It;2>H(BID
word3   ptr_to_fp_record              D_Current_FP_Ptr
word4   ptr_to_right_brother_shoen    D_EOL
word5   ptr_to_left_brother_shoen     D_EOL
word6   ptr_to_report_stream          $B0z?t$GEO$5$l$?JQ?t$X$N%]%$%s%?(B

word7   31($B%?%0$O(Bcdesc)               $B%?%0It(B : CDESC | $B%P%j%e!<It(B : 31
word8   shoen_status                  $B%?%0It(B : DNTC  | $B%P%j%e!<It(B : D_NULL
word9   min_priority                  $B%?%0It(B : DNTC  | $B%P%j%e!<It(B : $B0z?tDL$j(B
word10  max_priority                  $B%?%0It(B : DNTC  | $B%P%j%e!<It(B : $B0z?tDL$j(B
word11  exception_mask                $B%?%0It(B : DNTC  | $B%P%j%e!<It(B : $B0z?tDL$j(B
word12  ptr_to_fp_table_1             $B%?%0It(B : DNTC  | $B%P%j%e!<It(B : D_NULL
word13  ptr_to_fp_table_2             $B%?%0It(B : DNTC  | $B%P%j%e!<It(B : D_NULL
word14  ptr_to_rsc_req_fp_table_1     $B%?%0It(B : DNTC  | $B%P%j%e!<It(B : D_NULL
word15  ptr_to_rsc_req_fp_table_2     $B%?%0It(B : DNTC  | $B%P%j%e!<It(B : D_NULL
word16  ptr_to_ready_terminate_cnt_1  $B%?%0It(B : DNTC  | $B%P%j%e!<It(B : D_NULL
word17  ptr_to_ready_terminate_cnt_2  $B%?%0It(B : DNTC  | $B%P%j%e!<It(B : D_NULL
word18  ptr_to_ready_terminate_cnt_3  $B%?%0It(B : DNTC  | $B%P%j%e!<It(B : D_NULL
word19  ptr_to_ready_terminate_cnt_4  $B%?%0It(B : DNTC  | $B%P%j%e!<It(B : D_NULL
word20  ptr_to_ready_terminate_cnt_5  $B%?%0It(B : DNTC  | $B%P%j%e!<It(B : D_NULL
word21  ptr_to_ready_terminate_cnt_6  $B%?%0It(B : DNTC  | $B%P%j%e!<It(B : D_NULL
word22  ptr_to_ready_terminate_cnt_7  $B%?%0It(B : DNTC  | $B%P%j%e!<It(B : D_NULL
word23  ptr_to_ready_terminate_cnt_8  $B%?%0It(B : DNTC  | $B%P%j%e!<It(B : D_NULL
word23  start_stop_bit_table_u        $B%?%0It(B : DNTC  | $B%P%j%e!<It(B : D_NULL
word24  start_stop_bit_table_l        $B%?%0It(B : DNTC  | $B%P%j%e!<It(B : D_NULL

word25  stat_hook                     $B%?%0It(B : DNTC  | $B%P%j%e!<It(B : D_NULL
word26  stat_count;                   $B%?%0It(B : DNTC  | $B%P%j%e!<It(B : D_NULL
word27  ask_profile_FP_count          $B%?%0It(B : DNTC  | $B%P%j%e!<It(B : D_NULL
word28  reported_profile_count        $B%?%0It(B : DNTC  | $B%P%j%e!<It(B : D_NULL
word29  SH_total_ans_profile_count    $B%?%0It(B : DNTC  | $B%P%j%e!<It(B : D_NULL

word30  resource_consumed_u           $B%?%0It(B : DNTC  | $B%P%j%e!<It(B : D_NULL
word31  resource_consumed_l           $B%?%0It(B : DNTC  | $B%P%j%e!<It(B : D_NULL
word32  last_resource_consumed_u      $B%?%0It(B : DNTC  | $B%P%j%e!<It(B : D_NULL
word33  last_resource_consumed_l      $B%?%0It(B : DNTC  | $B%P%j%e!<It(B : D_NULL
word34  resource_left_u               $B%?%0It(B : DNTC  | $B%P%j%e!<It(B : D_NULL
word35  resource_left_l               $B%?%0It(B : DNTC  | $B%P%j%e!<It(B : 0x40000000
word36  resource_limit_left_u         $B%?%0It(B : DNTC  | $B%P%j%e!<It(B : D_NULL
word37  resource_limit_left_l         $B%?%0It(B : DNTC  | $B%P%j%e!<It(B : 0x40000000

<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#CONST_define  _INIT_SHOEN_RESOURCE  0x00000000  

#DATA_define  D_WorkShoenInitReg  XXX
#DATA_define  D_WorkShoenInitResReg  XXX
#DATA_define  D_WorkVOIDResult       XXX

/* Original
#PSL_define  f_AllocAndInitShoenRecord(shoen_record, min_prio_reg,
				       max_prio_reg, ex_mask_reg,
				       rep_stream_reg, shoen_status_imm,
				                                 shoen_id_reg)
{
/!** $BAq1`%l%3!<%I$N3d$jEv$F(B **!/
  s_AllocShoenRecord(shoen_record);

/!** $B3F%9%m%C%H$N=i4|2=(B **!/
  $USE(D_WorkShoenOrgLockTagReg);
  b_MoveWithImmTypeMRBoff(D_NULL, INT, D_WorkShoenOrgLockTagReg);
  s_PutShoenLockFlag(shoen_record, D_WorkShoenOrgLockTagReg);
  $RELEASE(D_WorkShoenOrgLockTagReg);
  s_PutShoenId(shoen_record, D_NULL);
  s_PutFPRecordOfShoen(shoen_record, D_Current_FP_Ptr);
  s_PutRightBrotherShoenLink(shoen_record, D_EOL);
  s_PutLeftBrotherShoenLink(shoen_record, D_EOL);
  f_AllocAndInitFPTables(shoen_record);

  /!* $BN$?F$N=i4|>uBV$rH?1G$5$;$F$*$/(B *!/
  s_SetFPTableFlagOn(shoen_record, D_CL_Number);
  s_SetStartStopBitTableFlagOn(shoen_record, D_CL_Number);
  /!* ready/terminate$B%+%&%s%H$r%$%s%/%j%a%s%H$7$F$*$/I,MW$,$"$k$+$J!)(B *!/
  f_AllocAndInitReadyTerminateCounter(shoen_record);
  $USE(D_WorkVOIDResult);
  s_CountReadyMessage(shoen_record, D_CL_Number, D_WorkVOIDResult);
  $RELEASE(D_WorkVOIDResult);
  s_PutShoenReportStream(shoen_record, rep_stream_reg);

  $USE(D_WorkShoenInitReg);
  p_SetImmediateWord(CDESC, _MRB_0, _SH_REC_GC_SKIP_SIZE, D_WorkShoenInitReg);
  s_PutShoenCDESC(shoen_record, D_WorkShoenInitReg);

  b_MoveWithImmTypeMRBoff(D_NULL, DNTC, D_WorkShoenInitReg);

  s_PutShoenStatus(shoen_record, D_WorkShoenInitReg);
  s_PutShoenTransitStatusImmediately(shoen_record, shoen_status_imm);
  s_PutStatHook(shoen_record, D_WorkShoenInitReg);
  s_PutStatCount(shoen_record, D_WorkShoenInitReg);

/!* !!! $B?75,DI2C(B for $BAq1`(Bprofiling *!/
  s_PutAskProfileFPCount(shoen_record, D_WorkShoenInitReg);
  s_PutReportedProfileCount(shoen_record, D_WorkShoenInitReg);
  s_PutSHTotalAnsProfileCount(shoen_record, D_WorkShoenInitReg);

  s_PutShoenResourceConsumed(shoen_record, D_WorkShoenInitReg,
			                                 D_WorkShoenInitReg);
  s_PutShoenLastResourceConsumed(shoen_record, D_WorkShoenInitReg,
			                                 D_WorkShoenInitReg);

  $USE(D_WorkShoenInitResReg);

  b_SetImmValueDNTC(_INIT_SHOEN_RESOURCE, D_WorkShoenInitResReg);
/!*   #CONST_define  _INIT_SHOEN_RESOURCE  0x00000000  *!/
  s_PutShoenResourceLeft(shoen_record, D_WorkShoenInitReg,
			                             D_WorkShoenInitResReg);
  s_PutShoenResourceLimitLeft(shoen_record, D_WorkShoenInitReg,
			                             D_WorkShoenInitResReg);
  $RELEASE(D_WorkShoenInitResReg);

  b_MoveWithImmTypeMRBoff(min_prio_reg, DNTC, D_WorkShoenInitReg);
  s_PutShoenMinPriority(shoen_record, D_WorkShoenInitReg);
  b_MoveWithImmTypeMRBoff(max_prio_reg, DNTC, D_WorkShoenInitReg);
  s_PutShoenMaxPriority(shoen_record, D_WorkShoenInitReg);
  b_MoveWithImmTypeMRBoff(ex_mask_reg, DNTC, D_WorkShoenInitReg);
  s_PutShoenExceptionMask(shoen_record, D_WorkShoenInitReg);

  $RELEASE(D_WorkShoenInitReg);

  s_SetResourceRequestFPTableFlagOn(shoen_record, D_CL_Number);

  f_EnterShoenInBET(shoen_record, shoen_id_reg);
  @DEBUG{
    _PrintSHInfo(shoen_record);
    WARNING("Tail of f_AllocAndInitShoenRecord","SH rec registered in BET");
  };
}
*/

/* !! */
#PSL_define  f_AllocAndInitShoenRecord(shoen_record, min_prio_reg,
				       max_prio_reg, ex_mask_reg,
				       rep_stream_reg, shoen_status_imm,
				                                 shoen_id_reg)
{
/** $BAq1`%l%3!<%I$N3d$jEv$F(B **/
  s_AllocShoenRecord(shoen_record);

/** $B3F%9%m%C%H$N=i4|2=(B **/
  $USE(D_WorkShoenOrgLockTagReg);
  b_MoveWithImmTypeMRBoff(D_NULL, INT, D_WorkShoenOrgLockTagReg);
  s_PutShoenLockFlag(shoen_record, D_WorkShoenOrgLockTagReg);
  $RELEASE(D_WorkShoenOrgLockTagReg);
  s_PutShoenId(shoen_record, D_NULL);
  s_PutFPRecordOfShoen(shoen_record, D_Current_FP_Ptr);
  s_PutRightBrotherShoenLink(shoen_record, D_EOL);
  s_PutLeftBrotherShoenLink(shoen_record, D_EOL);
/* !!
  f_AllocAndInitFPTables(shoen_record);
*/
  
  s_PutShoenReportStream(shoen_record, rep_stream_reg);

  $USE(D_WorkShoenInitReg);
  p_SetImmediateWord(CDESC, _MRB_0, _SH_REC_GC_SKIP_SIZE, D_WorkShoenInitReg);
  s_PutShoenCDESC(shoen_record, D_WorkShoenInitReg);

  /* CDESC$B$h$j2<$N%9%m%C%H$N=i4|2=(B */
  b_MoveWithImmTypeMRBoff(D_NULL, DNTC, D_WorkShoenInitReg);

  s_PutShoenStatus(shoen_record, D_WorkShoenInitReg);
  s_PutShoenTransitStatusImmediately(shoen_record, shoen_status_imm);
  s_PutStatHook(shoen_record, D_WorkShoenInitReg);
  s_PutStatCount(shoen_record, D_WorkShoenInitReg);

  /* !! $BN$?F%F!<%V%k(B(2$B%o!<%I(B)$B$N=i4|2=(B */
  s_PutFPTable(shoen_record, D_WorkShoenInitReg, D_WorkShoenInitReg);
  /* !! $B;q8;MW5aN$?F%F!<%V%k(B(2$B%o!<%I(B)$B$N=i4|2=(B */
  s_PutResourceRequestFPTable(shoen_record,
			      D_WorkShoenInitReg, D_WorkShoenInitReg);
  /* !! Start/Stop bit table(2$B%o!<%I(B)$B$N=i4|2=(B */
  s_PutShoenStartStopBitTable(shoen_record,
			      D_WorkShoenInitReg, D_WorkShoenInitReg);

  /* $BN$?F$N=i4|>uBV$rH?1G$5$;$F$*$/(B */
  s_SetFPTableFlagOn(shoen_record, D_CL_Number);
  s_SetStartStopBitTableFlagOn(shoen_record, D_CL_Number);
  /* ready/terminate$B%+%&%s%H$r%$%s%/%j%a%s%H$7$F$*$/I,MW$,$"$k$+$J!)(B */
  /* !! Ready/Terminate$B%+%&%s%?$N=i4|2=(B */
  s_InitShoenReadyTerminateCounter(shoen_record);

/* !! f_AllocAndInitReadyTerminateCounter(shoen_record); */

  $USE(D_WorkVOIDResult);
  s_CountReadyMessage(shoen_record, D_CL_Number, D_WorkVOIDResult);
  $RELEASE(D_WorkVOIDResult);


/* !!! $B?75,DI2C(B for $BAq1`(Bprofiling */
  s_PutAskProfileFPCount(shoen_record, D_WorkShoenInitReg);
  s_PutReportedProfileCount(shoen_record, D_WorkShoenInitReg);
  s_PutSHTotalAnsProfileCount(shoen_record, D_WorkShoenInitReg);

  s_PutShoenResourceConsumed(shoen_record, D_WorkShoenInitReg,
			                                 D_WorkShoenInitReg);
  s_PutShoenLastResourceConsumed(shoen_record, D_WorkShoenInitReg,
			                                 D_WorkShoenInitReg);

  $USE(D_WorkShoenInitResReg);

  b_SetImmValueDNTC(_INIT_SHOEN_RESOURCE, D_WorkShoenInitResReg);
/*   #CONST_define  _INIT_SHOEN_RESOURCE  0x00000000  */
  s_PutShoenResourceLeft(shoen_record, D_WorkShoenInitReg,
			                             D_WorkShoenInitResReg);
  s_PutShoenResourceLimitLeft(shoen_record, D_WorkShoenInitReg,
			                             D_WorkShoenInitResReg);
  $RELEASE(D_WorkShoenInitResReg);

  b_MoveWithImmTypeMRBoff(min_prio_reg, DNTC, D_WorkShoenInitReg);
  s_PutShoenMinPriority(shoen_record, D_WorkShoenInitReg);
  b_MoveWithImmTypeMRBoff(max_prio_reg, DNTC, D_WorkShoenInitReg);
  s_PutShoenMaxPriority(shoen_record, D_WorkShoenInitReg);
  b_MoveWithImmTypeMRBoff(ex_mask_reg, DNTC, D_WorkShoenInitReg);
  s_PutShoenExceptionMask(shoen_record, D_WorkShoenInitReg);

  $RELEASE(D_WorkShoenInitReg);

/* !!  s_SetResourceRequestFPTableFlagOn(shoen_record, D_CL_Number); */
/* $B:G=i$KN$?F$K(B start $B%a%C%;!<%8$,Ce$$$?;~$K!"N$?F$+$i(B request_resource
   $B$,JV$C$F$/$kH&$J$N$G!"$3$N;~$K(B supply_resource $B$9$k!#(B
   on '92.3.4 by kawai  */

  f_EnterShoenInBET(shoen_record, shoen_id_reg);
  @DEBUG{
    _PrintSHInfo(shoen_record);
    WARNING("Tail of f_AllocAndInitShoenRecord","SH rec registered in BET");
  };
}




/* !!! VOID$BAq1`GQ;_$KH<$$:o=|(B !!!
   $B=>Mh!"Aq1`@8@.;~$K?FN$?F$N>uBV$,(B Aborted $B$G$"$C$?>l9g$K$O!"Aq1`%l%3!<%I(B
   $B$H$7$FA4%9%m%C%H$,(B 0 $B$N%l%3!<%I$r3d$jEv$F$F$$$?!#(B
     $B$7$+$7!"A4Aq1`AH9~=R8l$G:G=i$K(BVOID$BAq1`$+H]$+$rH=Dj$9$kI,MW$,$"$k$?$a$K(B
   $B$3$NJ}<0$r2~$a!">e5-$N$h$&$J>l9g$K$OAq1`%l%3!<%I$H$7$F2?$bJV$5$J$$(B($B0z?t$G(B
   $BEO$5$l$?JQ?t$r6qBN2=$7$J$$(B)$B$3$H$H$7$?$?$a!"2<5-$N%^%/%m$rGQ;_$9$k!#(B
     $B$J$*!"$3$N>l9g!"@8@.$5$l$?Aq1`$r%3%s%H%m!<%k$9$k$?$a$N%4!<%k(B($BDL>o$OAq1`(B
   $B%b%8%e!<%kFb$N%4!<%k(B)$B$O!"Aq1`$,6qBN2=$5$l$J$$$?$a$K?FN$?F$N1J5WCfCG%4!<%k(B
   $B$H$J$k!#(B ('91.5.20)

#PSL_define  f_AllocVoidShoenRecord(shoen_record)
{
/!** $BAq1`%l%3!<%I$N3d$jEv$F(B **!/
  s_AllocShoenRecord(shoen_record);

/!** $B3F%9%m%C%H$N=i4|2=(B **!/
  $USE(D_WorkShoenInitReg);
  b_MoveWithImmTypeMRBoff(D_NULL, INT, D_WorkShoenInitReg);
  s_PutShoenLockFlag(shoen_record, D_WorkShoenInitReg);
  s_PutShoenId(shoen_record, D_WorkShoenInitReg);
  s_PutFPRecordOfShoen(shoen_record, D_WorkShoenInitReg);
  s_PutRightBrotherShoenLink(shoen_record, D_WorkShoenInitReg);
  s_PutLeftBrotherShoenLink(shoen_record, D_WorkShoenInitReg);
  s_PutFPTable(shoen_record, D_WorkShoenInitReg);
  s_PutResourceRequestFPTable(shoen_record, D_WorkShoenInitReg);
  s_PutShoenReadyTerminateCounter(shoen_record, D_WorkShoenInitReg);
  s_PutShoenReportStream(shoen_record, D_WorkShoenInitReg);
  s_PutShoenCDESC(shoen_record, D_WorkShoenInitReg);
  s_PutShoenStatus(shoen_record, D_WorkShoenInitReg);
  s_PutShoenTransitStatusImmediately(shoen_record, _VOID_SHOEN);
  s_PutStatHook(shoen_record, D_WorkShoenInitReg);
  s_PutStatCount(shoen_record, D_WorkShoenInitReg);
/!* !!! $B?75,DI2C(B for $BAq1`(Bprofiling *!/
  s_PutAskProfileFPCount(shoen_record, D_WorkShoenInitReg);
  s_PutReportedProfileCount(shoen_record, D_WorkShoenInitReg);
  s_PutSHTotalAnsProfileCount(shoen_record, D_WorkShoenInitReg);

  s_PutShoenResourceConsumed(shoen_record, D_WorkShoenInitReg,
			                                 D_WorkShoenInitReg);
  s_PutShoenLastResourceConsumed(shoen_record, D_WorkShoenInitReg,
			                                 D_WorkShoenInitReg);
  s_PutShoenResourceLeft(shoen_record, D_WorkShoenInitReg, D_WorkShoenInitReg);
			                             
  s_PutShoenResourceLimitLeft(shoen_record, D_WorkShoenInitReg, 
			                                 D_WorkShoenInitReg);
  s_PutShoenMinPriority(shoen_record, D_WorkShoenInitReg);
  s_PutShoenMaxPriority(shoen_record, D_WorkShoenInitReg);
  s_PutShoenExceptionMask(shoen_record, D_WorkShoenInitReg);

  @DEBUG{
    _PrintSHInfo(shoen_record);
    WARNING("Tail of f_AllocVoidShoenRecord","Void Shoen Record Created");
  };
  $RELEASE(D_WorkShoenInitReg);
}
 !!! VOID$BAq1`GQ;_$KH<$$:o=|(B !!! */



#DATA_define  D_WorkFPTableVect  XXX
#DATA_define  D_WorkFPTableVectSize  XXX
#DATA_define  D_WorkFPTableInitValue  XXX
#DATA_define  D_WorkRscReqFPTableVect  XXX
#DATA_define  D_WorkStartStopBitTableVect  XXX

/* !! Original
#PSL_define  f_AllocAndInitFPTables(shoen_record)
{ /!* $BN$?F%F!<%V%k$H;q8;MW5aN$?F%F!<%V%k$H(BStartStop$B%S%C%H%F!<%V%k$r(B
     $BF1;~$K=i4|2=$7$F!"%9%m%C%H$KF~$l$k(B *!/
  $USE(D_WorkFPTableVectSize);
  b_ReadClusterNumInSystem(D_WorkFPTableVectSize);
  b_DecrementReg(D_WorkFPTableVectSize);
  b_DivideImmediateWithDNTC(D_WorkFPTableVectSize, _WORD_BIT_LENGTH,
		                                      D_WorkFPTableVectSize);
  b_IncrementReg(D_WorkFPTableVectSize);
  /!* $BN$?F%F!<%V%k$N3d$jEv$F$H=i4|2=(B *!/
  $USE(D_WorkFPTableVect);
  $CALL( f_AllocVectorMRBoff_Sub(D_WorkFPTableVectSize, D_WorkFPTableVect));
  $USE(D_WorkFPTableInitValue);
  p_SetImmediateWord(INT, _MRB_0, _ZERO, D_WorkFPTableInitValue);
  f_InitializeVector(D_WorkFPTableInitValue, D_WorkFPTableVectSize,
		                                         D_WorkFPTableVect);
  s_PutFPTable(shoen_record, D_WorkFPTableVect);
  $RELEASE(D_WorkFPTableVect);

  /!* $B;q8;MW5aN$?F%F!<%V%k$N3d$jEv$F$H=i4|2=(B *!/
  $USE(D_WorkRscReqFPTableVect);
  $CALL( f_AllocVectorMRBoff_Sub(D_WorkFPTableVectSize,
				                   D_WorkRscReqFPTableVect));
  f_InitializeVector(D_WorkFPTableInitValue, D_WorkFPTableVectSize,
		                                    D_WorkRscReqFPTableVect);
  s_PutResourceRequestFPTable(shoen_record, D_WorkRscReqFPTableVect);
  $RELEASE(D_WorkRscReqFPTableVect);

  /!* StartStop$B%S%C%H%F!<%V%k$N3d$jEv$F$H=i4|2=(B *!/
  $USE(D_WorkStartStopBitTableVect);
  $CALL( f_AllocVectorMRBoff_Sub(D_WorkFPTableVectSize,
				               D_WorkStartStopBitTableVect));
  f_InitializeVector(D_WorkFPTableInitValue, D_WorkFPTableVectSize,
		                                D_WorkStartStopBitTableVect);
  s_PutShoenStartStopBitTable(shoen_record, D_WorkStartStopBitTableVect);

  $RELEASE(D_WorkFPTableInitValue);
  $RELEASE(D_WorkFPTableVectSize);
  $RELEASE(D_WorkStartStopBitTableVect);
}
*/

/* !! $BGQ;_(B */


#DATA_define  D_WorkReadyTerminateCounterSize  XXX
#DATA_define  D_WorkReadyTerminateCounterVect  XXX
#DATA_define  D_WorkCounterInitValue  XXX

/* !! Original
#PSL_define  f_AllocAndInitReadyTerminateCounter(shoen_record)
{ /!* Ready/Terminate$B%+%&%s%?$r=i4|2=$7!"%9%m%C%H$KF~$l$k(B *!/
  $USE(D_WorkReadyTerminateCounterSize);
  b_ReadClusterNumInSystem(D_WorkReadyTerminateCounterSize);
  b_DecrementReg(D_WorkReadyTerminateCounterSize);
  b_DivideImmediateWithDNTC(D_WorkReadyTerminateCounterSize,
                                          _READY_TERMINATE_COUNTER_PER_WORD,
		                             D_WorkReadyTerminateCounterSize);
  b_IncrementReg(D_WorkReadyTerminateCounterSize);
  $USE(D_WorkReadyTerminateCounterVect);
  $CALL( f_AllocVectorMRBoff_Sub(D_WorkReadyTerminateCounterSize,
                                            D_WorkReadyTerminateCounterVect));
  $USE(D_WorkCounterInitValue);
  p_SetImmediateWord(INT, _MRB_0, _INIT_READY_TERMINATE_COUNTER_VALUE,
                                                      D_WorkCounterInitValue);
  f_InitializeVector(D_WorkCounterInitValue, D_WorkReadyTerminateCounterSize,
                                             D_WorkReadyTerminateCounterVect);
  $RELEASE(D_WorkCounterInitValue);
  $RELEASE(D_WorkReadyTerminateCounterSize);
  s_PutShoenReadyTerminateCounter(shoen_record,
                                             D_WorkReadyTerminateCounterVect);
  $RELEASE(D_WorkReadyTerminateCounterVect);
}
*/

/* !! $BGQ;_(B */

#DATA_define D_WorkInitShoenWTC XXX

#PSL_define  f_EnterShoenInBET(shoen_record, shoen_id_reg)
{
  $USE(D_WorkInitShoenWTC);
  b_SetImmValueDNTC(_INIT_SHOEN_WTC,D_WorkInitShoenWTC);
  $CALL( s_AllocBlackExpEntry_withWTC_Sub(shoen_record, shoen_id_reg,
					  D_WorkInitShoenWTC) ); 
                       /* $B;v>p$K$h$j!"$3$A$i$r;H$C$F2<$5$$!#(Bnakase */
/*  $CALL( s_AllocBlackExpEntry_Sub(shoen_record, shoen_id_reg) ); */
  /* [$BCm0U(B] 
     shoen_id_reg$B$K$O!"9uM"=PI=%(%s%H%j$N%*%U%;%C%HCM$,JV$5$l$k!#(B
  */
  $RELEASE(D_WorkInitShoenWTC);
  s_SetClusterNum(shoen_id_reg, D_CL_Number);
  /* $BAq1`%l%3!<%I$+$i9uM"=PI=%(%s%H%j$X$N%]%$%s%?$K$O(BBEXVAL$B%?%0$G$O$J$/!"(B
     INT$B%?%0$rMQ$$$k!#(B
     ($BN$?F%l%3!<%I$+$i9uM"F~I=%(%s%H%j$X$N%]%$%s%?$O(BBEXVAL$B%?%0$G$h$$(B)
  */
  b_SetImmTypeMRBoff(INT, shoen_id_reg);
  s_PutShoenId(shoen_record, shoen_id_reg);
}

/******************************************************************** PSL **

(2) $BAq1`$N=i4|%4!<%k%l%3!<%I$N3d$jEv$F$H=i4|2=(B

       written by kawai@icot21      on Fri Jun  1 13:52:10 1990
<Arguments>
  code_reg : $BAq1`$N=i4|%4!<%k$N%3!<%I$,EO$5$l$k%l%8%9%?(B
  argv_reg : $BAq1`$N=i4|%4!<%k$N0z?t%Y%/%?$,EO$5$l$k%l%8%9%?(B
  max_prio_reg : $BAq1`Fb$N:G9b%W%i%$%*%j%F%#$,EO$5$l$k%l%8%9%?(B
  fp_record : ($BD>B0$N(B)$BN$?F$,EO$5$l$k%l%8%9%?(B
 ^goal_record : $B3d$jEv$F$?%4!<%k%l%3!<%I$rJV$9%l%8%9%?(B
<Temporally Used Variables>
  D_WorkShoenInitCodeReg : $BAq1`$N=i4|%4!<%k$r8F$S=P$9$?$a$N%3!<%I(B(D_code:apply)
                           $B$r0l;~J];}$9$k%l%8%9%?(B
<Level>
<PreCondition>
<Function>
  $BAq1`$N=i4|%4!<%k$r%4!<%k%9%?%C%/$KF~$l$k$?$a$K!"%4!<%k%l%3!<%I$r3d$jEv$F$F(B
$B=i4|2=$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#CONST_define _ARITY_OF_APPLY   2
#DATA_define  D_WorkShoenInitCodeReg   XXX

#PSL_define  f_AllocAndInitGoalRecord(code_reg, argv_reg, max_prio_reg,
                                                      fp_record, goal_record)
{
  s_AllocShortGoalRecord(goal_record);
  s_PutImmArityGoalRecord(goal_record, _ARITY_OF_APPLY);
  b_SetImmTypeMRBoff (COD, code_reg);
	/* dcode_b_apply $B$N=hM}$K$*$$$F(B $B0z?t%?%$%W$,(B "COD" $B$G$"$k$3$H$r(B
	 * $B%A%'%C%/$7$F$$$k(B
	 */
  s_PutArgImmPosGoalRecord(goal_record, _ARG0_OFST_GR, code_reg);
  s_PutArgImmPosGoalRecord(goal_record, _ARG1_OFST_GR, argv_reg);

  $USE(D_WorkShoenInitCodeReg);
  s_GetDcodeAddress(BLT_B_APPLY, D_WorkShoenInitCodeReg);
  b_SetImmTypeMRBoff(COD, D_WorkShoenInitCodeReg);
  
  s_PutCodeGoalRecord(goal_record, D_WorkShoenInitCodeReg);
       /* $B$3$3$G:n$i$l$k%4!<%k$NB0@-$O!"%/%i%9%?!"%W%m%;%C%5$H$b(Bemigrant
        * ($B%G%U%)%k%H$NB0@-(B) $B$H$9$k!#(B   (f-hataza, 90.03.19)
        */
  $USE(D_WorkEnvRecPtr);
  s_AllocNonDebugEnvRecord(D_WorkEnvRecPtr);
  s_PutPriorityEnvRecord(D_WorkEnvRecPtr,max_prio_reg);
  s_PutEmigrantClusterEnvRecord(D_WorkEnvRecPtr);
  s_PutEnvRecGoalRecord(goal_record, D_WorkEnvRecPtr);
  $RELEASE(D_WorkEnvRecPtr);
  s_PutFosterparentGoalRecord(goal_record, fp_record);
  s_PutProcessorIdGoalRecord(goal_record,D_PE_Number);
  s_PutNextGoalRecord(goal_record, D_EOL);
  $RELEASE(D_WorkShoenInitCodeReg);
}


/******************************************************************** PSL **

(3) $BAq1`$r?FN$?F$N;RAq1`%j%s%/(B{$B$K$D$J$0(B|$B$+$i30$9(B}$B=hM}(B

       written by kawai@icot21      on Wed May 30 22:13:50 1990
<Arguments>
  shoen_record : $BAq1`%l%3!<%I$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
  fp_record : $BAq1`$N?FN$?F%l%3!<%H$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
  $B?FN$?F%l%3!<%I5Z$S$=$N;RAq1`%j%s%/$,%m%C%/$5$l$F$$$k$3$H!#(B(Hook)
  $B?FN$?F%l%3!<%I5Z$S$=$N;RAq1`%j%s%/$,%m%C%/$5$l$F$$$J$$$3$H!#(B(Unhook)
<Function>
  $BAq1`$r?FN$?F$N;RAq1`%j%s%/$K2C$($k!#(B(Hook)
  $BAq1`$r?FN$?F$N;RAq1`%j%s%/$+$i30$9!#(B(Unhook)
<Examples>
<Test>
<Explanation>
<ETC>

$B!c!c!cCm0U!d!d!d(B
90-10-30$B8=:_$N%$%s%W%j%a%s%H$G$O!"(BHook$B;~$K$O(Bchild-count$B$rA}$d$7$F$$$k$,!"(B
Unhook$B;~$K$O8:$i$7$F$$$J$$!#!J(B f_CheckFPTermination$B$G9T$J$&!K(B
See f_ShoenTerminate_Sub(f_shoen_with_fp.psl.c)
-- Reki

90-11-14
$BK\%^%/%m$NA`:n$O!";RAq1`%j%s%/$NA`:n$J$N$G!";RAq1`%j%s%/$N%m%C%/$,I,MW$G$"$k!#(B
$B0lJ}!"?FN$?F$N=hM}$G!";RAq1`$,$J$$$3$H$@$1$r3NG'$7$?$$>l9g$K$^$G!"(B
$B;RAq1`%j%s%/$r%m%C%/$7$?$/$J$$$N$G!"5U$KK\%^%/%mA`:n$KBP$7$F!"(B
$BN$?F%m%C%/$bI,MW$G$"$k$3$H$K$7$?!#(B
$B%m%C%/$N=g$O;RAq1`%j%s%/"*N$?FK\BN$G$"$k!#!J%G%C%I%m%C%/GS=|$N$?$aNc30$OL5$$!K(B
$BC"$7!"(BHook$BA`:n$G$O8F$S$@$7B&$G!"(BUnhook$BA`:n$G$O8F$P$l$?B&!"(B
$B$9$J$o$AK\%^%/%m<+?H$G%m%C%/$r9T$J$C$F$$$k!#(B
-- Reki

********************************************************************* PSL **/

#DATA_define  D_WorkShoenLeftLinkReg   XXX
#DATA_define  D_WorkShoenRightLinkReg  XXX
#DATA_define  D_WorkShoenLinkOrgLockTagReg  XXX

#PSL_define  f_HookShoenToFPChildLink(shoen_record, fp_record)
{
  @DEBUG{
    _PrintSHInfo(shoen_record);
    WARNING("f_HookShoenToFPChildLink","Shoen Hooked to FP Child Link");
  };

  $USE(D_WorkShoenRightLinkReg);
  s_GetFPRightChildShoenLink(fp_record, D_WorkShoenRightLinkReg);
  s_PutRightBrotherShoenLink(shoen_record, D_WorkShoenRightLinkReg);
  s_PutFPRightChildShoenLink(fp_record, shoen_record);
  s_PutLeftBrotherShoenLink(shoen_record, fp_record);
  s_IfSHREC(D_WorkShoenRightLinkReg)
    {
      s_PutLeftBrotherShoenLink(D_WorkShoenRightLinkReg, shoen_record);
    }
    else
    {
      s_PutFPLeftChildShoenLink(fp_record, shoen_record);
    }

  /* $B?FN$?F$N(BChildCount$B$r%$%s%/%j%a%s%H(B */
  s_IncrementFPChildCount(fp_record);

  $RELEASE(D_WorkShoenRightLinkReg);
}



#PSL_define  f_UnhookShoenFromFPChildLink(shoen_record, fp_record)
{
  @DEBUG{
    _PrintSHInfo(shoen_record);
    WARNING("f_UnhookShoenFromFPChildLink","Shoen Unhooked from FP Childlink");
  };

  $USE(D_WorkShoenLeftLinkReg);
  $USE(D_WorkShoenRightLinkReg);

  /* $BN$?F$N;RAq1`%j%s%/$N%m%C%/(B */
  $USE(D_WorkShoenLinkOrgLockTagReg);
  s_LockFPChildShoenLink(fp_record, D_WorkShoenLinkOrgLockTagReg);

  /* $BN$?FK\BN$N%m%C%/(B */
  $USE(D_WorkFPOrgLockTagReg);
  s_LockFPRecord(fp_record, D_WorkFPOrgLockTagReg);

  s_GetLeftBrotherShoenLink(shoen_record, D_WorkShoenLeftLinkReg);
  s_GetRightBrotherShoenLink(shoen_record, D_WorkShoenRightLinkReg);
  s_IfSHREC(D_WorkShoenLeftLinkReg)
    {
      s_PutRightBrotherShoenLink(D_WorkShoenLeftLinkReg, 
				                   D_WorkShoenRightLinkReg);
    }
   else
     {
       s_PutFPRightChildShoenLink(D_WorkShoenLeftLinkReg, 
                                               D_WorkShoenRightLinkReg);
     }
  s_IfSHREC(D_WorkShoenRightLinkReg)
    {
      s_PutLeftBrotherShoenLink(D_WorkShoenRightLinkReg, 
                                               D_WorkShoenLeftLinkReg);
    }
   else
     {
       s_PutFPLeftChildShoenLink(D_WorkShoenRightLinkReg, 
                                               D_WorkShoenLeftLinkReg);
     }

  /* $BAq1`%l%3!<%ICf$N7;DoAq1`!"?FN$?F%l%3!<%I$X$N%]%$%s%?$r%/%j%"$9$k!#(B
     $B$3$l$r$7$J$$$H(BGC$B;~$K$3$1$k!#(B
     $B$?$@$7!"%G%P%0;~$N>pJsNL$r>/$7$G$bB?$/$9$k$?$a!"%]%$%s%?$N%P%j%e!<It$r(B
     $BJ]B8$9$k0J2<$N;CDj%k!<%A%s$rMQ$$$k!#(B
     $B%G%P%040N;;~$K$O!"0J2<$N@5<0HG$HF~$lBX$($k$3$H!#(B
  */

  /* $B@5<0HG(B */
  /*
  s_PutLeftBrotherShoenLink(shoen_record, D_EOL);
  s_PutRightBrotherShoenLink(shoen_record, D_EOL);
  s_PutFPRecordOfShoen(shoen_record, D_EOL);
  */

  /* $B;CDjHG(B */
     b_SetImmTypeMRBoff(INT, D_WorkShoenRightLinkReg);
     s_PutRightBrotherShoenLink(shoen_record, D_WorkShoenRightLinkReg);
     b_SetImmTypeMRBoff(INT, D_WorkShoenLeftLinkReg);
     s_PutLeftBrotherShoenLink(shoen_record, D_WorkShoenLeftLinkReg);

     s_GetFPRecordOfShoen(shoen_record, D_WorkShoenRightLinkReg);
     b_SetImmTypeMRBoff(INT, D_WorkShoenRightLinkReg);
     s_PutFPRecordOfShoen(shoen_record, D_WorkShoenRightLinkReg);


  $RELEASE(D_WorkShoenLeftLinkReg);
  $RELEASE(D_WorkShoenRightLinkReg);

/*********************** $B?FN$?F$N(BChildCount$B$N%G%/%j%a%s%H$O(B
                      f_CheckFPTermination$B$G9T$J$&$3$H$K$7$?!#(B90-10-30 reki
  s_DecrementFPChildCount(fp_record);
************************************************/
  /* $BN$?FK\BN$N%"%s%m%C%/(B */
  s_UnlockFPRecord(fp_record, D_WorkFPOrgLockTagReg);
  $RELEASE(D_WorkFPOrgLockTagReg);

 /* $BN$?F$N;RAq1`%j%s%/$N%"%s%m%C%/(B */
  s_UnlockFPChildShoenLink(fp_record, D_WorkShoenLinkOrgLockTagReg);
  $RELEASE(D_WorkShoenLinkOrgLockTagReg);
}

/******************************************************************** PSL **

(4) $BAq1`$X$N;q8;Ld$$9g$o$;=hM}(B

       written by kawai@icot21      on Wed May 30 22:34:41 1990
<Arguments>
  shoen_record : $BAq1`%l%3!<%I$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
  $B8F$S$@$785$GAq1`%l%3!<%I$r%m%C%/$7$J$$$3$H!#(B
<Function>
  $BAq1`$X$N;q8;Ld$$9g$o$;(B($B?FN$?F(B|$B%3%s%H%m!<%k%9%H%j!<%`$+$i(B)$B$r=hM}$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

/* $B8F$S=P$785$GAq1`%l%3!<%I$r%m%C%/$7$F$*$/$h$&$KJQ99$7$?(B */
#PSL_define  f_AskShoenStatFromFP(shoen_record)
{
  @DEBUG{
    _PrintSHInfo(shoen_record);
    WARNING("f_AskShoenStatFromFP","Shoen Asked Stat from FP");
  };

  s_IfNotInAskingShoenStat(shoen_record)
    { /* $B8=:_=87WCf$G$J$1$l$P(B */
      f_AskStatToAllFPs(shoen_record);
    }
  else
    { /* $B8=:_=87WCf$J$i$P(B */
      @DEBUG{
	s_IfInAskingShoenStatFromParentFP(shoen_record)
	  { /* $B$^$@?FN$?F$+$i$ND4::MW5a$KL$2sEz$@$C$?$i(B */
	    VPIM_ERROR("f_AskShoenStatFromFP",
		                           "Duplicated AskShoenStatFromFP");
	  }
      };
    }
  s_IncrementShoenLowerStatHookAndMoveToUpper(shoen_record);
}



#PSL_define  f_AskShoenStatFromControlStream(shoen_record)
{
  s_IfNotInAskingShoenStat(shoen_record)
    { /* $B8=:_=87WCf$G$J$1$l$P(B */
      f_AskStatToAllFPs(shoen_record);
    }
  s_IncrementShoenLowerStatHook(shoen_record);
}



#DATA_define  D_WorkShoenAllFPCount  XXX
#DATA_define  D_WorkShoenFPTableVect  XXX

/* !! */
#PSL_define  f_AskStatToAllFPs(shoen_record)
{
  $USE(D_WorkShoenAllFPCount);
  $USE(D_WorkShoenFPTable1);   /* !! */
  $USE(D_WorkShoenFPTable2);   /* !! */
  s_GetFPTable(shoen_record, D_WorkShoenFPTable1, D_WorkShoenFPTable2);
  s_CountDestinationFPs(D_WorkShoenFPTable1, D_WorkShoenFPTable2, 
			                        D_WorkShoenAllFPCount);
  $RELEASE(D_WorkShoenFPTable1);   /* !! */
  $RELEASE(D_WorkShoenFPTable2);   /* !! */
  b_IfZero(D_WorkShoenAllFPCount){
    $RELEASE(D_WorkShoenAllFPCount);
    s_AddShoenStatCount(shoen_record, D_ONE);
  @DEBUG{
    _PrintSHInfo(shoen_record);
    WARNING("f_AskStatToAllFPs","issue <<DUMMY>> ask stat msg");
  };
    f_Send_IntClMsg_OneFP(shoen_record,_NW_ASK_STATISTICS,D_CL_Number);
/* $B$3$N%^%/%m$,8F$P$l$?;~$O!"I,$:(B answer statistics $B$,JV$C$F$/$k$H(B
   $B?.$8$F$$$k$N$G!"<B$ON$?F$,$$$J$/$F$b%@%_!<$G0l$DHt$P$9!#(B
   $B$3$N>u67$O!"%M%C%H%o!<%/$r%4!<%k$,Ht$s$G$k$@$1$N;~$H$+!"(B
   receive terminated $B$N=hM}$NCf$G!"%[%s%H$KE9$8$^$$$9$kD>A0$N4V7d$H$+$K(B
   $BB8:_$9$k!#(B
 */
  }else{
    s_AddShoenStatCount(shoen_record, D_WorkShoenAllFPCount);
    $RELEASE(D_WorkShoenAllFPCount);

/* !! */
    f_Send_IntClMsg_ToAllFPs(shoen_record, _NW_ASK_STATISTICS);
/* !!    f_SendToAllFPs(shoen_record, _NW_ASK_STATISTICS); */
  }
}

/******************************************************************** PSL **

(5) Profile$B=hM}(B

       written by kawai@icot22      on Thu May 16 22:58:31 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

/* !! */
#PSL_define  f_AskShoenProfile(shoen_record)
{
  $USE(D_WorkShoenAllFPCount);
  $USE(D_WorkShoenFPTable1);  /* !! */
  $USE(D_WorkShoenFPTable2);  /* !! */
  s_GetFPTable(shoen_record, D_WorkShoenFPTable1, D_WorkShoenFPTable2);
  s_CountDestinationFPs(D_WorkShoenFPTable1, D_WorkShoenFPTable2, 
			                          D_WorkShoenAllFPCount);
  $RELEASE(D_WorkShoenFPTable1);  /* !! */
  $RELEASE(D_WorkShoenFPTable2);  /* !! */
  b_IfZero(D_WorkShoenAllFPCount){
    $RELEASE(D_WorkShoenAllFPCount);
    s_PutAskProfileFPCount(shoen_record, D_ONE); /* $B%9%m%C%H$N=i4|2=$b7s$M$k(B */
    @DEBUG{
      _PrintSHInfo(shoen_record);
      WARNING("f_AskShoenProfile","issue <<DUMMY>> ask prof msg");
    };

    f_Send_IntClMsg_OneFP(shoen_record, _NW_SHOEN_PROFILE_REQUEST,
			                                       D_CL_Number);

    /*   $B$3$N%^%/%m$,8F$P$l$?;~$O!"I,$:(B answer_profile $B$,JV$C$F$/$k$H(B
       $B?.$8$F$$$k$N$G!"<B$ON$?F$,$$$J$/$F$b%@%_!<$G0l$DHt$P$9!#(B
       $B$3$N>u67$O!"%M%C%H%o!<%/$r%4!<%k$,Ht$s$G$k$@$1$N;~$H$+!"(B
       receive terminated $B$N=hM}$NCf$G!"%[%s%H$KE9$8$^$$$9$kD>A0$N4V7d$H$+$K(B
       $BB8:_$9$k!#(B
         $B$3$&$9$k$3$H$K$h$C$F!"?FN$?F$+$i;RAq1`$KBP$7$F(B ask_profile $B$9$k(B
       $B0lO"$N=hM}$NCf$G!"?FN$?F$+$i?FAq1`$K(B answer_profile $B$rAw$k%1!<%9$r(B
       $B$J$/$9$3$H$,=PMh$k!#(B
    */
  }else{
    s_ResetSHProfileCounters(shoen_record);
    s_AddAskProfileFPCount(shoen_record, D_WorkShoenAllFPCount);
    $RELEASE(D_WorkShoenAllFPCount);

/* !! */
    f_Send_IntClMsg_ToAllFPs(shoen_record, _NW_SHOEN_PROFILE_REQUEST);

/* !!    f_SendToAllFPs(shoen_record, _NW_SHOEN_PROFILE_REQUEST); */
  }
}


/* !!! Modified for Shoen Profile ($B?75,DI2C(B) */
/* !!! $B8F$S=P$785$GAq1`%l%3!<%I$KBP$7$F%m%C%/$7$F$$$k$3$H(B */

#PSL_define  f_AskShoenProfileFromFP(shoen_record)
{
  @DEBUG{
    WARNING("f_AskShoenProfileFromFP","Shoen Profile by Parent");
  };

  s_IfShoenProfilableFromFP(shoen_record)
    {
      f_AskShoenProfile(shoen_record);
    }
  else
    {
      @DEBUG{ VPIM_ERROR("f_AskShoenProfileFromFP",
		     "Profile request to Not Profilable Shoen By Parent"); };
    }
}


/******************************************************************** PSL **

(6) $BA4N$?F$X$N%a%C%;!<%8%V%m!<%I%-%c%9%H(B

       written by kawai@icot22      on Mon Jun 18 23:08:34 1990
<Arguments>
  shoen_record : $BAq1`%l%3!<%I$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
  message_imm : $BA4N$?F$K%V%m!<%I%-%c%9%H$9$k%a%C%;!<%8(B($BB(CM(B)
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $BAq1`$,8=:_GD0.$7$F$$$kA4N$?F$K%a%C%;!<%8$r%V%m!<%I%-%c%9%H$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

/* !! Original
#PSL_define  f_SendToAllFPs(shoen_record, message_imm)
{
  $USE(D_WorkShoenFPTableVect);
  s_GetFPTable(shoen_record, D_WorkShoenFPTableVect);
  f_Send_IntClMsg_FPs(shoen_record, message_imm, D_WorkShoenFPTableVect);
  $RELEASE(D_WorkShoenFPTableVect);
}
*/

/* !! Moved to f_int_cl_send_control.psl.c on 11/22 1991 */

/* !! $BGQ;_(B  on 3/2 1992
   f_Send_IntClMsg_ToAllFPs(shoen_record, msg_id_imm)
        in f_int_cl_send_control.psl.c
   $B$r$D$+$&(B
*/

/* !! Moved to f_int_cl_send_control.psl.c on 11/22 1991 */
/*
#DATA_define  D_WorkShoenSendMesReg      XXX
#DATA_define  D_WorkShoenStartStopBitTableVect      XXX
#DATA_define  D_WorkShoenStartStopBitTableVectSize  XXX
*/


/* !! Original
#PSL_define  f_SendWithStartStopBitTable(shoen_record, message_imm)
{
  $USE(D_WorkShoenFPTableVect);
  $USE(D_WorkShoenStartStopBitTableVect);
  s_GetFPTable(shoen_record, D_WorkShoenFPTableVect);
  s_GetShoenStartStopBitTable(shoen_record, D_WorkShoenStartStopBitTableVect);
  $USE(D_WorkShoenStartStopBitTableVectSize);
  s_GetSizeVectType(D_WorkShoenStartStopBitTableVect,
		                        D_WorkShoenStartStopBitTableVectSize);
  $USE(D_WorkDestTableVect);
  $CALL( f_AllocVectorMRBoff_Sub(D_WorkShoenStartStopBitTableVectSize,
				                        D_WorkDestTableVect));
  $USE(D_WorkShoenSendMesReg);
  p_SetImmediateValue(message_imm, D_WorkShoenSendMesReg);
  ValueSwitch(D_WorkShoenSendMesReg)
    {
    case _NW_START:
      /!* $BN$?F%F!<%V%k$N%S%C%H$,N)$C$F$$$F!"$J$*$+$D(Bstart/stop$B%S%C%H%F!<%V%k(B
         $B$N%S%C%H$,N)$C$F$$$k%/%i%9%?$K$@$1(B %start$B%a%C%;!<%8$rAw$k(B       *!/
         
      s_MakeStoppedFPDestinationTable(D_WorkShoenFPTableVect,
				      D_WorkShoenStartStopBitTableVect,
			                                 D_WorkDestTableVect);
      f_Send_IntClMsg_FPs(shoen_record, _NW_START, D_WorkDestTableVect);
      s_UpdateWithStoppedFPDestinations(D_WorkShoenStartStopBitTableVect,
			                                 D_WorkDestTableVect);
      s_PutShoenStartStopBitTable(shoen_record,
				            D_WorkShoenStartStopBitTableVect);
      break;
    case _NW_STOP:
      /!* $BN$?F%F!<%V%k$N%S%C%H$,N)$C$F$$$F!"$J$*$+$D(Bstart/stop$B%S%C%H%F!<%V%k(B
         $B$N%S%C%H$,N)$C$F$$$J$$%/%i%9%?$K$@$1(B %stop$B%a%C%;!<%8$rAw$k(B      *!/

      s_MakeStartedFPDestinationTable(D_WorkShoenFPTableVect,
				      D_WorkShoenStartStopBitTableVect,
			                                 D_WorkDestTableVect);
      f_Send_IntClMsg_FPs(shoen_record, _NW_STOP, D_WorkDestTableVect);
      s_UpdateWithStartedFPDestinations(D_WorkShoenStartStopBitTableVect,
			                                 D_WorkDestTableVect);
      s_PutShoenStartStopBitTable(shoen_record,
				            D_WorkShoenStartStopBitTableVect);
      break;
    default:
      /!* $B%(%i!<%a%C%;!<%8(B *!/
      @DEBUG{
	VPIM_ERROR("f_SendWithStartStopBitTable","Illegal Message to FPs");
      };
      break;
    }
  $RELEASE(D_WorkShoenSendMesReg);

  b_IfLessEqImm(D_WorkShoenStartStopBitTableVectSize, _MAX_SIZE_OF_SVECT)
    {
      s_ReclaimShortVector(D_WorkDestTableVect);
    }
  else
    {
      s_ReclaimLongVector(D_WorkShoenStartStopBitTableVectSize,
			                                 D_WorkDestTableVect);
    }
  $RELEASE(D_WorkShoenFPTableVect);
  $RELEASE(D_WorkDestTableVect);
  $RELEASE(D_WorkShoenStartStopBitTableVect);
  $RELEASE(D_WorkShoenStartStopBitTableVectSize);
}
*/

/* !! Moved to f_int_cl_send_control.psl.c on 11/22 1991 */

/* !! $BGQ;_(B on 3/2 1992
      $B0z?t$N(B _NW_START$B!"(B_NW_STOP$B$K1~$8$F(B
        f_Send_IntClMsg_Start_ToStoppedFPs_Sub(A_ShoenRec)
        f_Send_IntClMsg_Stop_ToStartedFPs_Sub(A_ShoenRec)
           in f_int_cl_send_control.psl.c
   $B$r;H$$J,$1$k!#(B
*/
