
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_shoen_control.psl.c
   ----- CREATED   : by kawai@icot22, on Fri May 25 20:12:03 1990
   ----- LAST SAVED: by kawai@icot22, on Mon Mar  2 20:25:53 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : 

   $B$3$N%U%!%$%k$K$O!"Aq1`A`:nMQ$NAH$_9~$_=R8l$NK\BN$,Dj5A$5$l$F$$$k!#(B
   $B$3$3$GDj5A$5$l$F$$$kAH$_9~$_=R8l$NK\BN$O!"(B
     klb_body_blt_shoen.psl.c
   $B$NCf$+$i8F$S=P$5$l$k!#(B
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **

(1) $BAq1`$N@8@.(B

       written by kawai@icot22      on Fri May 25 21:39:11 1990
<Arguments>
  min_prio_reg : $BAq1`Fb$G<B9T$5$l$k%4!<%k$N:GDc%W%i%$%*%j%F%#$,EO$5$l$k%l%8%9%?(B
  max_prio_reg : $BAq1`Fb$G<B9T$5$l$k%4!<%k$N:G9b%W%i%$%*%j%F%#$,EO$5$l$k%l%8%9%?(B
  ex_mask_reg : $BAq1`$N%(%/%;%W%7%g%s%^%9%/%Q%?%s$,EO$5$l$k%l%8%9%?(B
  code_reg : $BAq1`$N=i4|%4!<%k$N%3!<%I$,EO$5$l$k%l%8%9%?(B
  argv_reg : $BAq1`$N=i4|%4!<%k$N0z?t%Y%/%?$,EO$5$l$k%l%8%9%?(B
  rep_stream_reg : $BAq1`$N%l%]!<%H%9%H%j!<%`MQJQ?t$,EO$5$l$k%l%8%9%?(B
 ^shoen_record : $BAq1`%l%3!<%I$X$N%]%$%s%?$rJV$9%l%8%9%?(B
<Temporally Used Variables>
  D_WorkFPRECReg : $BAq1`$HF1;~$K@8@.$5$l$kN$?F$N%l%3!<%I$r0l;~J];}$9$k%l%8%9%?(B
  D_WorkShoenIdReg : $BAq1`(BID($BAq1`%l%3!<%I$N30It;2>H(BID)$B$r0l;~J];}$9$k%l%8%9%?(B
  D_WorkInitWTCReg : $BN$?F$KM?$($k=i4|(BWTC$BNL$r0l;~J];}$9$k%l%8%9%?(B
<Level>
<PreCondition>
<Function>
  $BAq1`$r@8@.$7!"0z?t$GM?$($i$l$?=i4|%4!<%k$r%4!<%k%9%?%C%/$KF~$l$k!#(B
  $B$^$?!"F1;~$KF1$8%/%i%9%?$KB8:_$9$kN$?F(B($BD>B0$NN$?F(B)$B$r@8@.$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
  ('91.5.20) $B%5%V%k!<%A%s2=(B
********************************************************************* PSL **/

#CONST_define  _INIT_SHOEN_WTC     0x01000000   /*  2**24  */

/* for test of less WTC ( 91.02.04 REKI )
 * see also str_trade_init.psl.c and f_int_cl_send_throw_goal.psl.c
 *                               and f_int_cl_send_unify.psl.c 92.04.29
 * #CONST_define  _INIT_SHOEN_WTC     0x010
 */

/* !! $B$3$NDj?t$O!"Aq1`@8@.;~$KF1;~$K:n$i$l$kN$?F(B($BD>B0$NN$?F(B)$B$,3JG<$5$l$k9uM"F~(B
      $B%l%3!<%I$K!"N$?F$N=i4|(BWTC$BCM$H$7$FF~$l$i$l$kCM$G$"$k!#(B
      $B$3$N$?$a!"(B_INIT_FP_WTC$B$H2~L>$7$FN$?F=i4|3d$jEv$F%k!<%A%s$N$"$k%U%!%$%k(B
      $B$K0\F0$7$?J}$,NI$$!#(B
*/

#DATA_define  D_WorkFPRECReg      XXX
#DATA_define  D_WorkShoenIdReg    XXX
#DATA_define  D_WorkInitWTCReg    XXX
#DATA_define  D_WorkParentFPOrgLockTagReg   XXX
#DATA_define  D_WorkParentFPChildShoenLinkOrgLockTagReg   XXX
#DATA_define  D_WorkTempShoenRecord    XXX
#DATA_define  D_WorkFPImpRec   XXX
#DATA_define  D_WorkFPExRefID   XXX
#DATA_define  D_WorkShoenKindReg  XXX

#SUBARG_define  A_MinPrio       SRC
#SUBARG_define  A_MaxPrio       SRC
#SUBARG_define  A_MinNode       SRC
#SUBARG_define  A_NodeCount     SRC
#SUBARG_define  A_ExMask        SRC
#SUBARG_define  A_Code          SRC
#SUBARG_define  A_ArgVect       SRC
#SUBARG_define  A_RepStream     SRC
#SUBARG_define  A_SHRecord      DST

#SUBROUTINE  f_CreateShoen_Sub(A_MinPrio, A_MaxPrio, A_MinNode, A_NodeCount,
			       A_ExMask, A_Code, A_ArgVect, A_RepStream,
			                                           A_SHRecord)
{
  $USE(D_WorkShoenKindReg);
  p_SetImmediateValue(_ORDINARY_SHOEN, D_WorkShoenKindReg);
  $CALL( f_CreateShoenByKind_Sub(D_WorkShoenKindReg, A_MinPrio, A_MaxPrio,
				 A_MinNode, A_NodeCount, 
				 A_ExMask, A_Code, A_ArgVect, A_RepStream,
		                                               A_SHRecord) );
  $RELEASE(D_WorkShoenKindReg);
  $RETURN();
}


#SUBARG_define  A_MinPrio       SRC
#SUBARG_define  A_MaxPrio       SRC
#SUBARG_define  A_MinNode       SRC
#SUBARG_define  A_NodeCount     SRC
#SUBARG_define  A_ExMask        SRC
#SUBARG_define  A_Code          SRC
#SUBARG_define  A_ArgVect       SRC
#SUBARG_define  A_RepStream     SRC
#SUBARG_define  A_SHRecord      DST

#SUBROUTINE  f_CreateProfilingShoen_Sub(A_MinPrio, A_MaxPrio, 
					A_MinNode, A_NodeCount, A_ExMask,
					A_Code, A_ArgVect, A_RepStream,
				                                A_SHRecord)
{
  $USE(D_WorkShoenKindReg);
  p_SetImmediateValue(_PROFILING_SHOEN, D_WorkShoenKindReg);
  $CALL( f_CreateShoenByKind_Sub(D_WorkShoenKindReg, A_MinPrio, A_MaxPrio,
				 A_MinNode, A_NodeCount, 
				 A_ExMask, A_Code, A_ArgVect, A_RepStream,
		                                                A_SHRecord) );
  $RELEASE(D_WorkShoenKindReg);
  $RETURN();
}


#SUBARG_define  A_SHKind        SRC
#SUBARG_define  A_MinPrio       SRC
#SUBARG_define  A_MaxPrio       SRC
#SUBARG_define  A_MinNode       SRC
#SUBARG_define  A_NodeCount     SRC
#SUBARG_define  A_ExMask        SRC
#SUBARG_define  A_Code          SRC
#SUBARG_define  A_ArgVect       SRC
#SUBARG_define  A_RepStream     SRC
#SUBARG_define  A_SHRecord      DST


#SUBROUTINE  f_CreateShoenByKind_Sub(A_SHKind, A_MinPrio, A_MaxPrio,
				 A_MinNode, A_NodeCount, 
				 A_ExMask, A_Code, A_ArgVect,
				                A_RepStream, A_SHRecord)
{
  /* $BAq1`%l%3!<%I$N@8@.$H3F%9%m%C%H$N=i4|2=(B */
  $USE(D_WorkShoenIdReg);
  $USE(D_WorkTempShoenRecord);
  f_AllocAndInitShoenRecord(D_WorkTempShoenRecord, A_MinPrio,
			    A_MaxPrio, A_ExMask, A_RepStream,
			    _STOPPED_BY_CTRL, D_WorkShoenIdReg);

  /* $BN$?F$N@8@.$H=i4|2=(B */
  /* $B?FN$?F$N%m%C%/$O30$7$F$*$/I,MW$,$"$k!#(B*/
  /* $BM}M3(B:
    $B?7$7$/@8@.$7$?N$?F$r9uM"F~I=$KEPO?$9$kA0$K?FN$?F08$F$N%/%i%9%?4V(B
    $B%a%C%;!<%8$,E~Ce$9$k$H!"$=$N=hM}$NCf$G$O9uM"F~%O%C%7%eI=$r%m%C%/$7(B
    $B$?8e$K?FN$?F$r%m%C%/$7$h$&$H$9$k!#(B
      $B0lJ}!"?7$7$/@8@.$7$?N$?F$r9uM"F~I=$KEPO?$9$k=hM}$NCf$G$b9uM"F~%O(B
    $B%C%7%eI=$r%m%C%/$7$h$&$H$9$k$?$a!"%G%C%I%m%C%/$,@8$8$k!#(B
  */
  $USE(D_WorkFPRECReg);
  $USE(D_WorkInitWTCReg);
  b_SetImmTypeValueMRBoff(INT, _INIT_SHOEN_WTC, D_WorkInitWTCReg);
  
  s_IfProfilingFP(D_Current_FP_Ptr) 
    { /* $B?FN$?F$,(B Profile$BMQ$NN$?F$J$i(B */
      b_IfEqualImm(A_SHKind, _PROFILING_SHOEN)
	{ /* Profiling$BAq1`$N2<$K(BProfiling$BAq1`$r:n$k>l9g(B */
	  /* $B$3$N>l9g!"%(%/%;%W%7%g%s$H$7$?J}$,NI$$$+$bCN$l$J$$!#(B
	     Multi-PSI V2$B=hM}7O$G$OFC$K%(%/%;%W%7%g%s$H$O$;$:$K(B
	     $BAq1`$N%3%s%H%m!<%k%9%H%j!<%`$+$i(BProfile$BMW5a$r=P$7$?(B
	     $B;~$K(B reject $B$9$k$h$&$K$J$C$F$$$k!#(B
          */
	  @DEBUG{
	    WARNING("f_CreateShoenByKind_Sub",
		    "Profiling Shoen creation nested.");
	  };
	  /* s_SetShoenStatusFlag(D_WorkTempShoenRecord,
				  _PROFILING_SHOEN_FLAG_MASK); */
	}
      s_SetShoenStatusFlag(D_WorkTempShoenRecord,
			                   _PROFILING_PARENT_SHOEN_FLAG_MASK);
      f_AllocAndInitProfilingFP(A_MinPrio, A_MaxPrio,
				A_MinNode, A_NodeCount, 
				D_WorkShoenIdReg, D_WorkInitWTCReg,
				                              D_WorkFPRECReg);
    }
  else
    { /* $B?FN$?F$,(B Profile$BMQ$NN$?F$G$J$$$J$i(B */
      b_IfEqualImm(A_SHKind, _PROFILING_SHOEN)
	{ /* Profiling$BAq1`$r:n$k>l9g(B */
	  s_SetShoenStatusFlag(D_WorkTempShoenRecord,
			                          _PROFILING_SHOEN_FLAG_MASK);
	  f_AllocAndInitProfilingFP(A_MinPrio, A_MaxPrio,
				    A_MinNode, A_NodeCount, 
				    D_WorkShoenIdReg, D_WorkInitWTCReg,
				                              D_WorkFPRECReg);
	}
      else
	{ /* $BDL>o$NAq1`$r:n$k>l9g(B */
	  f_AllocAndInitFP(A_MinPrio, A_MaxPrio, 
			   A_MinNode, A_NodeCount, D_WorkShoenIdReg, 
			   D_WorkInitWTCReg, D_WorkFPRECReg);
	}
    }

  $RELEASE(D_WorkInitWTCReg);

  /* $B?FN$?F$N>uBV$,(B Aborted $B$K$J$C$F$$$J$$$+$I$&$+$r3NG'$9$k!#(B*/
  /* $BN$?F$N;RAq1`%j%s%/$r99?7$9$k>l9g$K$O!"(B
    (1) $B;RAq1`%j%s%/$N%m%C%/(B
    (2) $BN$?F%l%3!<%IK\BN$N%m%C%/(B
     $B$N=g$G%m%C%/$9$kI,MW$,M-$k$?$a!"A00J$F;RAq1`%j%s%/$b%m%C%/$7$F$7$^$&!#(B
  */

  $USE(D_WorkParentFPChildShoenLinkOrgLockTagReg);
  $USE(D_WorkParentFPOrgLockTagReg);
  s_LockFPChildShoenLink(D_Current_FP_Ptr, 
			          D_WorkParentFPChildShoenLinkOrgLockTagReg);
  s_LockFPRecord(D_Current_FP_Ptr, D_WorkParentFPOrgLockTagReg);
  s_IfAbortedFP(D_Current_FP_Ptr)
    { /* $B$b$7!":n$m$&$H$7$?Aq1`$N?FN$?F$,4{$K(B Aborted$B>uBV$K$J$C$F$$$?$i(B */
      /* $B0lEYM"=PF~I=$KEPO?$7$?Aq1`(B/$BN$?F$r:o=|$9$k!#(B */
      @DEBUG{ 
	WARNING("f_CreateShoenByKind_Sub",
		"Parent FP Aborted at SH creation. Shoen NEVER be bound forever");};

      s_UnlockFPRecord(D_Current_FP_Ptr, D_WorkParentFPOrgLockTagReg);
      $RELEASE(D_WorkParentFPOrgLockTagReg);
      s_UnlockFPChildShoenLink(D_Current_FP_Ptr, 
			          D_WorkParentFPChildShoenLinkOrgLockTagReg);
      $RELEASE(D_WorkParentFPChildShoenLinkOrgLockTagReg);

      /* $BAq1`$r9uM"=PI=$+$i:o=|$9$k!#(B*/
      $CALL( s_OnlyReclaimExpEntry_Sub(D_WorkShoenIdReg));
      s_ReclaimShoenRecord(D_WorkTempShoenRecord);

      /* $BN$?F$r9uM"F~I=$+$i:o=|$9$k!#(B*/
      $USE(D_WorkFPImpRec);
      $USE(D_WorkFPExRefID);
      s_GetFPImportTableEntry(D_WorkFPRECReg, D_WorkFPImpRec);
      s_GetExrefIdAllWtcAndLogicalReclaimBImpRec(D_WorkFPImpRec,
						     D_WorkFPExRefID, D_VOID);
      s_PhysicalReclaimBImpRec_FP(D_WorkFPImpRec, D_WorkFPExRefID);
      $RELEASE(D_WorkFPImpRec);
      $RELEASE(D_WorkFPExRefID);

      s_PutFPImportTableEntry(D_WorkFPRECReg, D_EOL);  /* for GC */
      s_ReclaimFPRecord(D_WorkFPRECReg);

      /* $BAq1`$N=PNO$OL$Dj5AJQ?t$H$J$k!#$3$N7k2L!"$3$NAq1`$KBP$9$k%3%s%H%m!<%k(B
         $B%4!<%k(B($BAq1`%b%8%e!<%kFb$N%4!<%k(B)$B$O!"(B($B%"%\!<%H$5$l$?(B)$B?FN$?F$N1J5WCfCG(B
         $B%4!<%k$H$J$k!#(B
           $B$3$N>l9g!"AH9~=R8l(B kblt_b_create_shoen()$B$N8F$S$@$785$G!"Aq1`$N=PNO(B
         $B$H2?$+$r(B Unify $B$9$k$h$&$J$3$H$,$"$k$H!"8mF0:n$r0z$-5/$3$92DG=@-$,$"(B
         $B$k$,!"Aq1`%b%8%e!<%k$NCf$G$3$N$h$&$J$3$H$O9T$o$J$$$H;W$o$l$k!#(B

           $B$J$*!"$3$N%$%s%?%U%'!<%9$G(B Fix $B$9$k$N$G$"$l$P!"%3%s%Q%$%i$,(B
         $BAH9~=R8l(B kblt_b_create_shoen() $B$N8F$S=P$7;~$K$"$i$+$8$a!"Aq1`$N(B
         $B=PNOMQ%l%8%9%?$KL$Dj5AJQ?t$r3d$jEv$F$F$*$-!"@5$7$/Aq1`$,@8@.$5$l(B
         $B$?>l9g$K$3$NJQ?t$r6qBN2=$9$kJ}<0$NJ}$,!"B>$NAq1`4X78AH9~=R8l$H$N(B
         $B@09g@-$,NI$$$h$&$K;W$o$l$k!#(B
      */
      s_AllocVariable(A_SHRecord);
    }
  else
    { /* $B?FN$?F$,(B Aborted $B$G$J$1$l$P(B */
      s_IfStoppedFP(D_Current_FP_Ptr)
	{ /* $B$b$7!":n$C$?Aq1`$N?FN$?F$,(B Stopped$B>uBV$@$C$?$i(B */
	  /* $B$"$i$+$8$a!"?FN$?F$N>uBV$rH?1G$5$;$F$*$/(B */
	  $CALL( f_StopByParent_Sub(D_WorkTempShoenRecord) );
	}

      /* $BAq1`$r?FN$?F$N;RAq1`%j%s%/$K$D$J$0(B */

      f_HookShoenToFPChildLink(D_WorkTempShoenRecord, D_Current_FP_Ptr);

      s_UnlockFPRecord(D_Current_FP_Ptr, D_WorkParentFPOrgLockTagReg);
      s_UnlockFPChildShoenLink(D_Current_FP_Ptr, 
			          D_WorkParentFPChildShoenLinkOrgLockTagReg);
      $RELEASE(D_WorkParentFPOrgLockTagReg);
      $RELEASE(D_WorkParentFPChildShoenLinkOrgLockTagReg);
      /* $BAq1`$N=i4|%4!<%k$N3d$jEv$F$H=i4|2=(B */
      $USE(D_WorkGoalPtr);
      f_AllocAndInitGoalRecord(A_Code, A_ArgVect, A_MaxPrio,
			                     D_WorkFPRECReg, D_WorkGoalPtr);

      /* $B=i4|%4!<%k$r%4!<%k%9%?%C%/$K%W%C%7%e$9$k(B **/
      $CALL( f_PushGoalToStackWithPriority_Sub(D_WorkGoalPtr, A_MaxPrio));

      $RELEASE(D_WorkGoalPtr);

      p_MoveWord(D_WorkTempShoenRecord, A_SHRecord);
    }
  $RELEASE(D_WorkFPRECReg); 
  $RELEASE(D_WorkTempShoenRecord);
  $RELEASE(D_WorkShoenIdReg);

  $RETURN();
}

/******************************************************************** PSL **

       written by kawai@icot22      on Wed Jun  6 21:03:50 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
  ('91.5.20) $B%5%V%k!<%A%s2=(B
********************************************************************* PSL **/

#DATA_define  D_WorkShoenTransitStatus  XXX

#SUBARG_define  A_SHRecord         SRC
#SUBARG_define  A_NewSHRecord      DST

#SUBROUTINE  f_StartShoen_Sub(A_SHRecord, A_NewSHRecord)
{
  @DEBUG{
    WARNING("f_StartShoen_Sub", "Shoen Begun to Start");};

  /*  $BAq1`%l%3!<%I$r%=%U%H%m%C%/$9$k(B */
  $USE(D_WorkShoenOrgLockTagReg);
  s_LockShoenRecord(A_SHRecord, D_WorkShoenOrgLockTagReg);

  /** report "started" **/
  f_ReportShoenMessage(A_SHRecord, _STARTED_REP);

  /** set transit status **/
  $USE(D_WorkShoenTransitStatus);
  s_GetShoenTransitStatus(A_SHRecord, D_WorkShoenTransitStatus);
  ValueSwitch(D_WorkShoenTransitStatus)
    {
    case _STOPPED_BY_CTRL :
      s_PutShoenTransitStatusImmediately(A_SHRecord, _STARTED);

      /* !! */
      $CALL( f_Send_IntClMsg_Start_ToStoppedFPs_Sub(A_SHRecord) );
      /* !!
      f_SendWithStartStopBitTable(A_SHRecord, _NW_START);
      */
      break;
    case _STOPPED_BY_BOTH :
      s_PutShoenTransitStatusImmediately(A_SHRecord, _STOPPED_BY_PARENT);
      break;
    case _STOPPED_BY_PARENT :
      @DEBUG{
	WARNING("f_StartShoen_Sub", "Start to StoppedByParent Shoen");
      };
      break;
    case _STARTED :
      @DEBUG{
	WARNING("f_StartShoen_Sub", "Start to Started Shoen");
      };
      break;
    case _ABORTED :
    case _TERMINATED :
      @DEBUG{
	WARNING("f_StartShoen_Sub", "Start to Aborted/Terminated Shoen");
      };
      break;
    default :
      @DEBUG{
	VPIM_ERROR("f_StartShoen_Sub", "Illegal Shoen Status");
      };
    }
  p_MoveWord(A_SHRecord, A_NewSHRecord);

  /*  $BAq1`%l%3!<%I$r%"%s%m%C%/$9$k(B */
  s_UnlockShoenRecord(A_SHRecord, D_WorkShoenOrgLockTagReg);
  $RELEASE(D_WorkShoenOrgLockTagReg);
  $RELEASE(D_WorkShoenTransitStatus);

  $RETURN();
}

/******************************************************************** PSL **

       written by kawai@icot22      on Fri Jul 20 21:35:03 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
  ('91.5.20) $B%5%V%k!<%A%s2=(B
********************************************************************* PSL **/

#SUBARG_define  A_SHRecord         SRC
#SUBARG_define  A_NewSHRecord      DST

#SUBROUTINE  f_StopShoen_Sub(A_SHRecord, A_NewSHRecord)
{
  @DEBUG{ WARNING("f_StopShoen_Sub","Shoen Begun to Stop");};

  /*  $BAq1`%l%3!<%I$r%=%U%H%m%C%/$9$k(B */
  $USE(D_WorkShoenOrgLockTagReg);
  s_LockShoenRecord(A_SHRecord, D_WorkShoenOrgLockTagReg);

  /** report "stopped" **/
  f_ReportShoenMessage(A_SHRecord, _STOPPED_REP);

  /** set transit status **/
  $USE(D_WorkShoenTransitStatus);
  s_GetShoenTransitStatus(A_SHRecord, D_WorkShoenTransitStatus);
  ValueSwitch(D_WorkShoenTransitStatus)
    {
    case _STARTED :
      s_PutShoenTransitStatusImmediately(A_SHRecord, _STOPPED_BY_CTRL);

      /* !! */
      $CALL( f_Send_IntClMsg_Stop_ToStartedFPs_Sub(A_SHRecord) );
      /* !!
      f_SendWithStartStopBitTable(A_SHRecord, _NW_STOP);
      */
      break;
    case _STOPPED_BY_PARENT :
      s_PutShoenTransitStatusImmediately(A_SHRecord, _STOPPED_BY_BOTH);
      break;
    case _STOPPED_BY_CTRL :
      @DEBUG{
	WARNING("f_StopShoen_Sub", "Stop to StoppedByControl Shoen");
      };
      break;
    case _STOPPED_BY_BOTH :
      @DEBUG{
	WARNING("f_StopShoen_Sub", "Stop to StoppedByBoth Shoen");
      };
      break;
    case _ABORTED :
    case _TERMINATED :
      @DEBUG{
	WARNING("f_StopShoen_Sub", "Stop to Aborted/Terminated Shoen");
      };
      break;
    default :
      @DEBUG{
	VPIM_ERROR("f_StopShoen_Sub", "Illegal Shoen Status");
      };
    }
  p_MoveWord(A_SHRecord, A_NewSHRecord);

  /*  $BAq1`%l%3!<%I$r%"%s%m%C%/$9$k(B */
  s_UnlockShoenRecord(A_SHRecord, D_WorkShoenOrgLockTagReg);
  $RELEASE(D_WorkShoenOrgLockTagReg);
  $RELEASE(D_WorkShoenTransitStatus);

  $RETURN();
}

/******************************************************************** PSL **

       written by kawai@icot22      on Fri Jul 20 21:35:17 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
  ('91.5.20) $B%5%V%k!<%A%s2=(B
********************************************************************* PSL **/

#SUBARG_define  A_SHRecord         SRC
#SUBARG_define  A_NewSHRecord      DST

#SUBROUTINE  f_AbortShoen_Sub(A_SHRecord, A_NewSHRecord)
{
  @DEBUG{ WARNING("f_AbortShoen_Sub","Shoen Begun to Abort");};
  
  /*  $BAq1`%l%3!<%I$r%=%U%H%m%C%/$9$k(B */
  $USE(D_WorkShoenOrgLockTagReg);
  s_LockShoenRecord(A_SHRecord, D_WorkShoenOrgLockTagReg);

  /** report "aborted" **/
  f_ReportShoenMessage(A_SHRecord, _ABORTED_REP);

  /** set transit status **/
  $USE(D_WorkShoenTransitStatus);
  s_GetShoenTransitStatus(A_SHRecord, D_WorkShoenTransitStatus);
  ValueSwitch(D_WorkShoenTransitStatus)
    {
    case _STARTED :
    case _STOPPED_BY_PARENT :
    case _STOPPED_BY_CTRL :
    case _STOPPED_BY_BOTH :
      s_PutShoenTransitStatusImmediately(A_SHRecord, _ABORTED);
      /* !! */
      f_Send_IntClMsg_ToAllFPs(A_SHRecord, _NW_ABORT);
      /* !!
      f_SendToAllFPs(A_SHRecord, _NW_ABORT);
      */
      break;
    case _ABORTED :
      @DEBUG{ WARNING("f_AbortShoen_Sub", "Abort to Aborted Shoen"); };
      break;
    case _TERMINATED :
      @DEBUG{ WARNING("f_AbortShoen_Sub", "Abort to terminated shoen");};
      /*	VPIM_ERROR $B$K$J$C$F$$$?$,!"(B
       *	$B@5>o=*N;8e$K%3%s%H%m!<%k%9%H%j!<%`$+$i(B abort $B$,Aw$i$l$k(B
       *	$B$3$H$b$"$k$N$G!"$3$l$O!"%(%i!<$G$O$J$$!#(B1990.11.29 imai
       */
      break;
    default :
      @DEBUG{
	VPIM_ERROR("AbortShoen_Sub", "Illegal Shoen Status");
      };
    }
  p_MoveWord(A_SHRecord, A_NewSHRecord);

  /*  $BAq1`%l%3!<%I$r%"%s%m%C%/$9$k(B */
  s_UnlockShoenRecord(A_SHRecord, D_WorkShoenOrgLockTagReg);
  $RELEASE(D_WorkShoenOrgLockTagReg);
  $RELEASE(D_WorkShoenTransitStatus);

  $RETURN();
}

/******************************************************************** PSL **

       written by kawai@icot22      on Fri Jul 20 21:35:29 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
  ('91.5.20) $B%5%V%k!<%A%s2=(B
********************************************************************* PSL **/

#SUBARG_define  A_SHRecord         MODIFY

#SUBROUTINE  f_RemoveShoen_Sub(A_SHRecord)
{
  @DEBUG{
    _PrintSHInfo(A_SHRecord);
    WARNING("f_RemoveShoen_Sub","Shoen Begun to be Removed");};

  $USE(D_WorkShoenOrgLockTagReg);
  s_LockShoenRecord(A_SHRecord, D_WorkShoenOrgLockTagReg);

  s_SetShoenStatusFlag(A_SHRecord, _NO_MORE_EXTERNAL_EVENT_FLAG_MASK);
  $USE(D_WorkShoenTransitStatus);
  s_GetShoenTransitStatus(A_SHRecord, D_WorkShoenTransitStatus);
  ValueSwitch(D_WorkShoenTransitStatus)
    {
    case  _TERMINATED : 
      f_ReportShoenReturnResourceAtTermination(A_SHRecord);
      f_CloseReportStream(A_SHRecord);
      s_IfNotShoenUnhookReserved(A_SHRecord){
	s_UnlockShoenRecord(A_SHRecord, D_WorkShoenOrgLockTagReg);
	@DEBUG{
	  WARNING("f_RemoveShoen_Sub","ShoenRecord will be Reclaimed");
	};
	s_ReclaimShoenRecord(A_SHRecord);
      }else{
	s_UnlockShoenRecord(A_SHRecord, D_WorkShoenOrgLockTagReg);
	/* f_ShoenTerminate_Sub $B$NCf$G(B s_ReclaimShoenRecord $B$5$l$k(B */
      }
      break;
    case  _STOPPED_BY_PARENT :
    case  _STOPPED_BY_CTRL :
    case  _STOPPED_BY_BOTH :
    case  _STARTED :
    case  _ABORTED :
      s_UnlockShoenRecord(A_SHRecord, D_WorkShoenOrgLockTagReg);
      @DEBUG{
	WARNING("f_RemoveShoen_Sub", "RemoveShoen to Unterminated Shoen");
      };
      break;
    default :
      s_UnlockShoenRecord(A_SHRecord, D_WorkShoenOrgLockTagReg);
      @DEBUG{
	VPIM_ERROR("RemoveShoen_Sub", "Illegal Shoen Status");
      };
    }
  $RELEASE(D_WorkShoenOrgLockTagReg);
  $RELEASE(D_WorkShoenTransitStatus);

  $RETURN();
}

/******************************************************************** PSL **

       written by kawai@icot22      on Fri Jul 20 21:35:41 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
  ('91.5.20) $B%5%V%k!<%A%s2=(B
********************************************************************* PSL **/

#SUBARG_define  A_SHRecord         SRC
#SUBARG_define  A_RscUpper         SRC
#SUBARG_define  A_RscLower         SRC
#SUBARG_define  A_NewSHRecord      DST

#SUBROUTINE  f_AddShoenResource_Sub(A_SHRecord, A_RscUpper, A_RscLower,
				                            A_NewSHRecord)
{
  @DEBUG{
    WARNING("f_AddShoenResource_Sub","Shoen Resource Begun to be Added");
  };

  /*  $BAq1`%l%3!<%I$r%=%U%H%m%C%/$9$k(B */
  $USE(D_WorkShoenOrgLockTagReg);
  s_LockShoenRecord(A_SHRecord, D_WorkShoenOrgLockTagReg);

  /** report "resource_added" **/
  f_ReportShoenMessage(A_SHRecord, _RSC_ADDED_REP);

  $USE(D_WorkShoenResourceLimitLeftUpper);
  $USE(D_WorkShoenResourceLimitLeftLower);

  s_GetShoenResourceLimitLeft(A_SHRecord, D_WorkShoenResourceLimitLeftUpper,
			                  D_WorkShoenResourceLimitLeftLower);

  $USE(D_WorkShoenResourceAddendUpper);
  $USE(D_WorkShoenResourceAddendLower);
  $USE(D_WorkShoenResourceSurplusUpper);
  $USE(D_WorkShoenResourceSurplusLower);

  b_CheckResourceSurplus(D_WorkShoenResourceLimitLeftUpper,
			 D_WorkShoenResourceLimitLeftLower,
			 A_RscUpper, A_RscLower,
			 D_WorkShoenResourceAddendUpper,
			 D_WorkShoenResourceAddendLower,
			 D_WorkShoenResourceSurplusUpper,
			 D_WorkShoenResourceSurplusLower);

  $RELEASE(D_WorkShoenResourceLimitLeftUpper);
  $RELEASE(D_WorkShoenResourceLimitLeftLower);

  s_AddShoenResourceLimitLeft(A_SHRecord,
			      D_WorkShoenResourceAddendUpper,
			      D_WorkShoenResourceAddendLower);
  b_IfNotZeroDoubleWord(D_WorkShoenResourceSurplusUpper,
			D_WorkShoenResourceSurplusLower)
    { /* !! If Overflow, Report ReturnResource !! */
      f_ReportShoenResourceInfo(A_SHRecord, _RETURN_RSC_REP,
				D_WorkShoenResourceSurplusUpper,
				D_WorkShoenResourceSurplusLower);
    }

  $RELEASE(D_WorkShoenResourceAddendUpper);
  $RELEASE(D_WorkShoenResourceAddendLower);
  $RELEASE(D_WorkShoenResourceSurplusUpper);
  $RELEASE(D_WorkShoenResourceSurplusLower);

  /* !! */
  $CALL( f_Send_IntClMsg_SupplyResource_ToResourceRequestFPs_Sub(A_SHRecord) );
  /* !!  $CALL( f_DistributeShoenResourceWithoutLock_Sub(A_SHRecord) ); */

  p_MoveWord(A_SHRecord, A_NewSHRecord);

  /*  $BAq1`%l%3!<%I$r%"%s%m%C%/$9$k(B */
  s_UnlockShoenRecord(A_SHRecord, D_WorkShoenOrgLockTagReg);
  $RELEASE(D_WorkShoenOrgLockTagReg);

  $RETURN();
}

/******************************************************************** PSL **

       written by kawai@icot22      on Fri Jul 20 21:35:56 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
  ('91.5.20) $B%5%V%k!<%A%s2=(B
********************************************************************* PSL **/

#SUBARG_define  A_SHRecord         SRC
#SUBARG_define  A_NewSHRecord      DST

#SUBROUTINE  f_ShoenStatistics_Sub(A_SHRecord, A_NewSHRecord)
{
  @DEBUG{
    WARNING("f_ShoenStatistics_Sub","Shoen Statistics Started");};

  /*  $BAq1`%l%3!<%I$r%=%U%H%m%C%/$9$k(B */
  $USE(D_WorkShoenOrgLockTagReg);
  s_LockShoenRecord(A_SHRecord, D_WorkShoenOrgLockTagReg);

  /** report "statistics_started" **/
  f_ReportShoenMessage(A_SHRecord, _STAT_STARTED_REP);

  $USE(D_WorkShoenTransitStatus);
  s_GetShoenTransitStatus(A_SHRecord, D_WorkShoenTransitStatus);
  ValueSwitch(D_WorkShoenTransitStatus)
    {
    case  _TERMINATED :
      /*  $B4{$KAq1`$,=*7k$7$F$$$?$i(B  */
      
      @DEBUG{
	WARNING("f_ShoenStatistics","Shoen Already Terminated");
      };

      f_ReportShoenStatInformation(A_SHRecord);
      break ;

    case  _STARTED :
    case  _STOPPED_BY_PARENT :
    case  _STOPPED_BY_CTRL :
    case  _STOPPED_BY_BOTH :
    case  _ABORTED :
      f_AskShoenStatFromControlStream(A_SHRecord);
      break;

    default :
      @DEBUG{
	VPIM_ERROR("ShoenStatistics_Sub", "Illegal Shoen Status");
      };
    }

  p_MoveWord(A_SHRecord, A_NewSHRecord);
  /*  $BAq1`%l%3!<%I$r%"%s%m%C%/$9$k(B */
  s_UnlockShoenRecord(A_SHRecord, D_WorkShoenOrgLockTagReg);
  $RELEASE(D_WorkShoenOrgLockTagReg);
  $RELEASE(D_WorkShoenTransitStatus);

  $RETURN();
}

/******************************************************************** PSL **

       written by kawai@icot22      on Fri Jul 20 21:36:06 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
  ('91.5.20) $B%5%V%k!<%A%s2=(B
********************************************************************* PSL **/

#SUBARG_define  A_SHRecord         SRC
#SUBARG_define  A_NewSHRecord      DST

#SUBROUTINE  f_AllowShoenResourceReport_Sub(A_SHRecord, A_NewSHRecord)
{
  @DEBUG{
    WARNING("f_AllowShoenResourceReport_Sub","Shoen Allowed Resource Report");
  };
      
  /*  $BAq1`%l%3!<%I$r%=%U%H%m%C%/$9$k(B */
  $USE(D_WorkShoenOrgLockTagReg);
  s_LockShoenRecord(A_SHRecord, D_WorkShoenOrgLockTagReg);
      
  /** report "resource_report_allowed" **/
  f_ReportShoenMessage(A_SHRecord, _RSC_REP_ALLOWED_REP);

  /*  $BAq1`$N(Bresource_report_disallowed$B>uBV$r%j%;%C%H$9$k!#(B */
  s_ResetShoenStatusFlag(A_SHRecord, _RSC_REP_DISALLOWED_FLAG_MASK);

  /* !! */
  $CALL( f_Send_IntClMsg_SupplyResource_ToResourceRequestFPs_Sub(A_SHRecord) );

  /* !! $CALL( f_DistributeShoenResourceWithoutLock_Sub(A_SHRecord) ); */

  p_MoveWord(A_SHRecord, A_NewSHRecord);
  /*  $BAq1`%l%3!<%I$r%"%s%m%C%/$9$k(B */
  s_UnlockShoenRecord(A_SHRecord, D_WorkShoenOrgLockTagReg);
  $RELEASE(D_WorkShoenOrgLockTagReg);

  $RETURN();
}

/******************************************************************** PSL **

  f_ShoenProfile

       written by kawai@icot22      on Fri May 17 11:53:09 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
  ('91.5.20) $B%5%V%k!<%A%s2=(B
********************************************************************* PSL **/

#SUBARG_define  A_SHRecord         SRC
#SUBARG_define  A_NewSHRecord      DST

#SUBROUTINE  f_ShoenProfile_Sub(A_SHRecord, A_NewSHRecord)
{
  @DEBUG{
    WARNING("f_ShoenProfile_Sub","Shoen Profile Started");};
  
  /*  $BAq1`%l%3!<%I$r%=%U%H%m%C%/$9$k(B */
  $USE(D_WorkShoenOrgLockTagReg);
  s_LockShoenRecord(A_SHRecord, D_WorkShoenOrgLockTagReg);

  s_IfShoenProfilable(A_SHRecord)
    {
      /** report "ShoenProfileStart" **/
      f_ReportShoenMessage(A_SHRecord, _PROF_STARTED_REP);
      f_AskShoenProfile(A_SHRecord);
    }
  else
    {
      /** report "ShoenProfileStart" **/
      f_ReportShoenMessage(A_SHRecord, _PROF_REJECTED_REP);
    }
  p_MoveWord(A_SHRecord, A_NewSHRecord);
  /*  $BAq1`%l%3!<%I$r%"%s%m%C%/$9$k(B */
  s_UnlockShoenRecord(A_SHRecord, D_WorkShoenOrgLockTagReg);
  $RELEASE(D_WorkShoenOrgLockTagReg);

  $RETURN();
}

/******************************************************************** PSL **

  f_ConsumeShoenResource

       written by kawai@icot22      on Fri May 17 11:54:34 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
  ('91.5.20) $B%5%V%k!<%A%s2=(B
********************************************************************* PSL **/

#SUBARG_define  A_RscUpper  SRC
#SUBARG_define  A_RscLower  SRC

#SUBROUTINE  f_ConsumeShoenResource_Sub(A_RscUpper, A_RscLower)
{
  @DEBUG{
    WARNING("f_ConsumeShoenResource_Sub","Resource Consumed");};

  /* Do something */

  $RETURN();
}

