
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pimp/ICOT/V10-scsi/functions/f_scsi_tgt_transfer.psl.c
   ----- CREATED   : by f-doumae@icot22, on Tue Oct  2 17:04:58 1990
   ----- LAST SAVED: by f-takei@icot22, on Thu Jul  4 20:51:51 1991
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : $B%G!<%?%$%s!&%G!<%?%"%&%H!&%9%F!<%?%9!&%a%C%;!<%8%$%s%U%'!<%:$N<B9T(B

  $B%3%^%s%IE>Aw0J30$NE>Aw%U%'!<%:$N<B9T$r$*$3$J$&!#%?!<%2%C%HF0:n;~$G$O(B
  $B%G!<%?%$%sE>Aw!&%a%C%;!<%8%$%sE>Aw!&%9%F!<%?%9E>Aw$O%"%&%H%W%C%HF0:n!"(B
  $B%G!<%?%"%&%HE>Aw$O%$%s%W%C%HF0:n$H$J$k!#$3$3$G$O!"A0<T$O%"%&%H%W%C%HF0:n$r(B
  $B9T$&(Bf_ScsiTargetSendData$B!"8e<T$O%$%s%W%C%HF0:n$r9T$&(Bf_ScsiTargetReceiveData
  $B$,<B:]$N=hM}$H$J$k!#$I$A$i$N>l9g$b!"(BTransfer$B%3%^%s%I$rMQ$$$?E>Aw$r9T$&!#(B
  $B$3$N$?$a!"4pK\E*$K=hM}FbMF$OF1$8$G$"$j!"%G!<%?$NAw=P!&<uNN$NItJ,(B
  (b_ScsiSendData, b_ScsiReceiveData)$B$H!"(BTransfer Pause$B%3%^%s%I$rMQ$$$kItJ,(B
  (b_ScsiTransferPauseOutput, b_ScsiTransferPauseInput)$B0[$J$k$@$1$G$"$k!#(B
  $B$^$?!"(B"Identify"$B%a%C%;!<%8$NAw=P!"%3%^%s%I%U%'!<%:$N<B9T$N=hM}$H$b$[$\F1$8(B
  $BFbMF$H$J$C$F$$$k!#(B($B$3$l$i$N6&DLItJ,$r$^$H$a$F%^%/%m$rDj5A$7D>$9$3$H$,9M$($i(B
  $B$l$k!#(B)

  $B$$$:$l$N=hM}$b0J2<$N$h$&$JFbMF$H$J$C$F$$$k!#(B

  1.$B%"%F%s%7%g%s%3%s%G%#%7%g%s$H%j%;%C%H%3%s%G%#%7%g%s$N%A%'%C%/(B
    $B$3$N(B2$B$D$N>uBV$O$$$D$G$b5/$3$jF@$k$?$a!"E>Aw$N<B9TA0$K%A%'%C%/$r$78!=P$5$l(B
    $B$F$$$l$P$=$N=hM}$r9T$&!#(B
  2.$B;XDj$5$l$?E>Aw$N<B9T(B
    $B!&E>Aw%G!<%?D9$K$h$j(BSPC$B$K(BTransfer$B%3%^%s%I$rH/9T$9$k!#(B
    $B!&E>AwJ}8~$K$7$?$,$C$F%G!<%?$NAw=P!&<uNN$r9T$&!#(B

  3.$BE>Aw=*N;8e$N=hM}(B
    Transfer$B%3%^%s%I$N<B9T7k2L$O3d$j9~$_$K$h$C$FH=Dj$9$k!#$^$?!"2?$i$+$N%(%i!<(B
    $B$,8!=P$5$l$?>l9g$K$O!"%(%i!<$N>pJs$rE>Aw%l%3!<%I$K%;%C%H$7$?8e!"%(%i!<(B
    $B%O%s%I%j%s%0$N%k!<%A%s$r8F$S=P$7$F8e$N=hM}$r9T$&!#@5>o$K=*N;$7$?>l9g$K$O!"(B
    $B7k2LJs9p$N=hM}$X@)8f$r0\$9!#(B
    $B3d$j9~$_$NFbMF$H=hM}$O0J2<$NDL$j!#(B

    A.Command Complete$B3d$j9~$_(B
      Transfer$B%3%^%s%I$N=*N;!#%(%i!<$N>uBV$K$h$C$F0J2<$N$h$&$K$o$+$l$k!#(B
        a.$B%(%i!<$,8!=P$5$l$J$+$C$?>l9g!#(B
         $BE>Aw$N@5>o=*N;!#7k2LJs9p$N=hM}$X0\$k!#(B
        b.$B%"%F%s%7%g%s%3%s%G%#%7%g%s$,8!=P$5$l$?>l9g!#(B
        c.$BE>Aw%G!<%?$K%Q%j%F%#%(%i!<$,8!=P$5$l$?>l9g!#(B
      b, c$B$N>l9g$O!"%(%i!<%O%s%I%j%s%0$N%k!<%A%s$r8F$S$@$78e=hM}$r9T$&!#(B
    B.Service Required$B3d$j9~$_$,8!=P$5$l$?>l9g!#(B
      $B%"%F%s%7%g%s%3%s%G%#%7%g%s$N8!=P!#(B
      (SPC$B%l%8%9%?(BSCMD.bit0:Termination Mode='1'$B$N;~(B)
      $B!&(BTransfer$B%3%^%s%I$,=*N;$7$F$$$J$$>l9g$,$"$k$N$G!"(BSPC$B$K(BTransfer Pause
        $B%3%^%s%I$rH/9T$7$F(BTransfer$B%3%^%s%I$r=*N;$5$;$k!#(B
      $B!&%(%i!<%O%s%I%j%s%0$N%k!<%A%s$r8F$S$@$78e$N=hM}$r9T$&!#(B
    C.SPC Hardware Error$B3d$j9~$_$,8!=P$5$l$?>l9g!#(B
      $B!&(BTransfer$B%3%^%s%I$,=*N;$7$F$$$J$$>l9g$,$"$k$N$G!"(BSPC$B$K(BTransfer Pause
        $B%3%^%s%I$rH/9T$7$F(BTransfer$B%3%^%s%I$r=*N;$5$;$k!#(B
      $B!&%(%i!<%O%s%I%j%s%0$N%k!<%A%s$r8F$S$@$78e$N=hM}$r9T$&!#(B
    D.Reset Condition$B3d$j9~$_$,8!=P$5$l$?>l9g!#(B
      $B!&%j%;%C%H%3%s%G%#%7%g%s;~$N=hM}$K0\$k!#(B

<Revised Memo on "Jul  3">
  $BE>Aw=*N;8e$N3d$j9~$_8!=P(B
    E.Selected, Reselected, Time Out
      Fatal Error $B$H$7$F8!=P;~$N=hM}$K0\$k!#(B
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */
#DATA_define D_WorkKind  XXX

/*------------------------------------------------------
  $B0z?t(B Kind $B$G;XDj$5$l$kE>Aw<oJL(B
  i_SCSIDeviceDriverTargetBody_Sub$B$+$i$b;2>H$9$k!#(B
-------------------------------------------------------*/
#CONST_define _KIND_DATA_OUT       0
#CONST_define _KIND_DATA_IN        2
#CONST_define _KIND_COMMAND        4
#CONST_define _KIND_STATUS         6
#CONST_define _KIND_MSG_IN         7

#SUBARG_define A_TransRec SRC
#SUBARG_define A_Phase    DST

#SUBROUTINE f_ScsiTargetSendData_Sub(A_TransRec, A_Phase)
{
    /*--- Service Required, Reset Condition $B3d$j9~$_$N%A%'%C%/(B---*/
    b_IfScsiAnyInterrupt(){
	f_ScsiTargetInterruptCheck(A_TransRec, A_Phase);
	goto END;
    }

    $USE(D_WorkDataLen);
    s_GetScsiTransRecDataLength(A_TransRec, D_WorkDataLen);
    /* $BE>Aw%G!<%?D9$r$H$C$F$/$k(B */
    $USE(D_WorkKind);
    s_GetScsiTransRecKind(A_TransRec, D_WorkKind);
    ValueSwitch(D_WorkKind){
	/* D_WorkKind$B$K$h$j(BTransfer$B%3%^%s%I$NH/9T(B */
      case _KIND_DATA_IN:
	b_TargetTransferCommandDataIn(D_WorkDataLen);
	break;
      case _KIND_MSG_IN:
	b_TargetTransferCommandMessageIn(D_WorkDataLen);
	break;
      case _KIND_STATUS:
	b_TargetTransferCommandStatus(D_WorkDataLen);
	break;
      default:
	@DEBUG{
	    VPIM_ERROR("f_ScsiTargetSendData", "Invalid argument : Kind");
	};
    }
    $RELEASE(D_WorkKind);
    LOOP(){
	b_IfSPCBusy(){ break;}
	b_IfScsiAnyInterrupt(){
	    $RELEASE(D_WorkDataLen);
	    goto Transfer_End;
	}
    }
    $USE(D_WorkDataPtr);
    s_GetScsiTransRecDataPtr(A_TransRec, D_WorkDataPtr);
    $USE(D_WorkDataBuff);
    s_GetScsiTransRecPtrToDataBuff(A_TransRec, D_WorkDataBuff);
    /* $B%G!<%?%P%C%U%!$X$N%]%$%s%?$r$H$C$F$/$k(B */
    $USE(D_WorkOldPtr);
    p_MoveWord(D_WorkDataPtr, D_WorkOldPtr);

    s_ScsiTargetSendData(D_WorkDataBuff, D_WorkDataPtr, D_WorkDataLen);

    $RELEASE(D_WorkDataBuff);
    $RELEASE(D_WorkDataLen);
    s_ModifyScsiTransRecDataCounter(A_TransRec, D_WorkOldPtr, D_WorkDataPtr);
    $RELEASE(D_WorkOldPtr);
    $RELEASE(D_WorkDataPtr);

  Transfer_End:
    $USE(D_WorkInterrupt);
    b_GetScsiInterrupt(D_WorkInterrupt);
    b_IfScsiInterruptResetCondition(D_WorkInterrupt){
	$RELEASE(D_WorkInterrupt);
	b_SetImmValueDNTC(_ERROR_END, A_Phase);
	goto END;
    }
    b_IfScsiInterruptSPCHardwareError(D_WorkInterrupt){
	$RELEASE(D_WorkInterrupt);
	f_ScsiTargetIntrHardwareErrorHandlingOutput(A_TransRec, A_Phase);
	goto END;
    }
    b_IfScsiInterruptCommandComplete(D_WorkInterrupt){
	$RELEASE(D_WorkInterrupt);
	f_ScsiTargetIntrCommandCompleteHandlingOutput(A_TransRec, A_Phase);
	goto END;
    }
    b_IfScsiInterruptServiceRequired(D_WorkInterrupt){
	/* $B%"%F%s%7%g%s%3%s%G%#%7%g%s8!=P(B */
	$RELEASE(D_WorkInterrupt);
	f_ScsiTargetIntrServiceRequiredHandlingOutput(A_TransRec, A_Phase);
	goto END;
    }
    /* Fatal Error */
    b_SetImmValueDNTC(_FATAL_ERROR_END, A_Phase);
    @DEBUG{
	b_IfScsiInterruptSelected(D_WorkInterrupt){
	    ;
	}else{
	    b_IfScsiInterruptReselected(D_WorkInterrupt){
		;
	    }else{
		b_IfScsiInterruptTimeOut(D_WorkInterrupt){
		    ;
		}else{
		    VPIM_ERROR("f_ScsiTargetSendData_Sub",
			       "Unknown data on register");
		}
	    }
	}
    };
    $RELEASE(D_WorkInterrupt);

  END:
    $RETURN();
}

#SUBARG_define A_TransRec SRC
#SUBARG_define A_Phase    DST

#SUBROUTINE f_ScsiTargetReceiveData_Sub(A_TransRec, A_Phase)
{
    /*--- Service Required, Reset Condition $B3d$j9~$_$N%A%'%C%/(B---*/
    b_IfScsiAnyInterrupt(){
	f_ScsiTargetInterruptCheck(A_TransRec, A_Phase);
	goto END;
    }

    $USE(D_WorkDataLen);
    s_GetScsiTransRecDataLength(A_TransRec, D_WorkDataLen);
    /* $BE>Aw%G!<%?D9(B */
    @DEBUG{/* $B$3$N%G%P%C%0%k!<%A%s$OI,MW$J$5$=$&!#(B*/
	$USE(D_WorkKind);
	s_GetScsiTransRecKind(A_TransRec, D_WorkKind);
	b_IfNotEqualImm(D_WorkKind, _KIND_DATA_OUT){
	    VPIM_ERROR("f_ScsiTargetReceiveData","Invalid argument : Kind");
	}
	$RELEASE(D_WorkKind);
    };
    b_TargetTransferCommandDataOut(D_WorkDataLen);
    LOOP(){
	b_IfSPCBusy(){ break;}
	b_IfScsiAnyInterrupt(){
	    $RELEASE(D_WorkDataLen);
	    goto Transfer_End;
	}
    }
    $USE(D_WorkDataPtr);
    $USE(D_WorkDataBuff);
    s_GetScsiTransRecPtrToDataBuff(A_TransRec, D_WorkDataBuff);
    s_GetScsiTransRecDataPtr(A_TransRec, D_WorkDataPtr);
    /* $B%G!<%?%P%C%U%!$X$N%]%$%s%?$r$H$C$F$/$k(B */
    $USE(D_WorkOldPtr);
    p_MoveWord(D_WorkDataPtr, D_WorkOldPtr);
    s_ScsiTargetReceiveData(D_WorkDataBuff, D_WorkDataPtr, D_WorkDataLen);
    $RELEASE(D_WorkDataBuff);
    $RELEASE(D_WorkDataLen);
    s_ModifyScsiTransRecDataCounter(A_TransRec, D_WorkOldPtr, D_WorkDataPtr);
    /*--------------------------------------------------
      D_WorkOldPtr$B$H(BD_WorkDataPtr$B$+$iE>Aw%P%$%H?t$r5a$a(B
      $B%G!<%?%+%&%s%?$NCM$r99?7$9$k!#(B
    ---------------------------------------------------*/
    $RELEASE(D_WorkOldPtr);
    $RELEASE(D_WorkDataPtr);

  Transfer_End:
    $USE(D_WorkInterrupt);
    b_GetScsiInterrupt(D_WorkInterrupt);
    b_IfScsiInterruptResetCondition(D_WorkInterrupt){
	$RELEASE(D_WorkInterrupt);
	b_SetImmValueDNTC(_ERROR_END, A_Phase);
	goto END;
    }
    b_IfScsiInterruptSPCHardwareError(D_WorkInterrupt){
	$RELEASE(D_WorkInterrupt);
	f_ScsiTargetIntrHardwareErrorHandlingInput(A_TransRec, A_Phase);
	goto END;
    }
    b_IfScsiInterruptCommandComplete(D_WorkInterrupt){
	$RELEASE(D_WorkInterrupt);
	f_ScsiTargetIntrCommandCompleteHandlingInput(A_TransRec, A_Phase);
	goto END;
    }
    b_IfScsiInterruptServiceRequired(D_WorkInterrupt){
	/* $B%"%F%s%7%g%s%3%s%G%#%7%g%s8!=P(B */
	$RELEASE(D_WorkInterrupt);
	f_ScsiTargetIntrServiceRequiredHandlingInput(A_TransRec, A_Phase);
	goto END;
    }
    /* Fatal Error */
    b_SetImmValueDNTC(_FATAL_ERROR_END, A_Phase);
    @DEBUG{
	b_IfScsiInterruptSelected(D_WorkInterrupt){
	    ;
	}else{
	    b_IfScsiInterruptReselected(D_WorkInterrupt){
		;
	    }else{
		b_IfScsiInterruptTimeOut(D_WorkInterrupt){
		    ;
		}else{
		    VPIM_ERROR("f_ScsiTargetReceiveData_Sub",
			       "Unknown data on register");
		}
	    }
	}
    };
    $RELEASE(D_WorkInterrupt);

  END:
    $RETURN();
}
