
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_scsi_tgt_reselection.psl.c
   ----- CREATED   : by f-doumae@icot22, on Tue Oct  2 17:00:05 1990
   ----- LAST SAVED: by f-takei@icot22, on Mon Mar  9 11:33:18 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : $B%j%;%l%/%7%g%s$N<B9T!&(BIdentify$B%a%C%;!<%8$NAw=P(B

  $BM=Ls$5$l$?E>Aw$r<B9T$9$k$?$a$N%j%;%l%/%7%g%s$N<B9T5Z$S(B"Identify"$B%a%C%;!<%8(B
  $B$NAw=P$r9T$&!#(B

  $B!&(Bf_ScsiReselectionPhase_Sub
  $B!&(Bf_ScsiTargetSendidentify_Sub

 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **

       written by f-takei@icot22      on Wed Mar 20 11:11:08 1991
<Arguments>
  A_TransRec
  A_Phase
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B%j%;%l%/%7%g%s!&%U%'!<%:$N<B9T(B
<Examples>
<Test>
<Explanation>
  $B%j%;%l%/%7%g%s!&%U%'!<%:$N<B9T$O!"(BSPC$B$KBP$7$F(BSelect$B%3%^%s%I$rH/9T$9$k$3$H$K(B
  $B$h$C$F9T$&!#(BSelect$B%3%^%s%I$N<B9T7k2L$O!"(BSPC$B$N8!=P$9$k3d$j9~$_$H(BSCSI$B$H$N(B
  $B@\B3>uBV$K$h$C$FH=JL$9$k!#(B
  $B<B9T7k2L$H$=$N=hM}FbMF$O0J2<$NDL$j!#(B

    A.$B%?!<%2%C%H$H$7$F@\B3$5$l$F$$$k>l9g(B
      $B!&(BSelected$B3d$j9~$_8!=P(B
        $BB>%P%9%G%P%$%9$+$i%;%l%/%H$5$l$?!#(B
        <$B=hM}(B>
         $B!&Ev3:E>Aw%l%3!<%I$r%P%98"%-%e!<$K%(%s%-%e!<$9$k!#(B
         $B!&%;%l%/%H;~$N=hM}%k!<%A%s$K0\$k!#(B
      $B!&(BCommand Complete$B3d$j9~$_8!=P(B
        Select$B%3%^%s%I$N@.8y!#(B
        <$B=hM}(B>
         $B!&(B"Identify"$B%a%C%;!<%8$NAw=P!#(B
      $B!&>e5-0J30(B
        $B%(%i!<$H$9$k(B($B$"$jF@$J$$(B)$B!#(B
    B.$B%$%K%7%(!<%?$H$7$F@\B3$7$F$$$k>l9g(B
      $B!&(BReselected$B3d$j9~$_8!=P(B
        $BB>%P%9%G%P%$%9$+$i%j%;%l%/%H$5$l$?!#(B
       <$B=hM}(B>
        $B!&Ev3:E>Aw%l%3!<%I$r%P%98"%-%e!<$K%(%s%-%e!<$9$k!#(B
        $B!&%j%;%l%/%H;~$N=hM}%k!<%A%s$K0\$k!#(B
    C.SCSI$B$H$O@\B3$5$l$F$$$J$$>l9g(B
      $B!&(BCommand Complete$B3d$j9~$_8!=P(B
        $B%"!<%S%H%l!<%7%g%s$K<:GT$7$?!#(B
       <$B=hM}(B>
        $B!&Ev3:E>Aw%l%3!<%I$r%P%98"%-%e!<$K%(%s%-%e!<$9$k!#(B
        $B!&%P%9%U%j!<%U%'!<%:8!=P3d$j9~$_$N@)8B$r30$7$F!"(B
          $B%4!<%k%j%@%/%7%g%s$KLa$k!#(B
          ($B%P%9%U%j!<%U%'!<%:$r%9%j%C%H%A%'%C%/;~$K3d$j9~$_$h$C$F8!=P$7!"(B
           $B%j%;%l%/%7%g%s$+$i%j%H%i%$$r9T$J$&!#(B)
      $B!&(BDisconnected$B3d$j9~$_8!=P(B
       $B%P%9%U%j!<%U%'!<%:$r8!=P$7$?!#$3$l$O!"B>%P%9%G%P%$%9$+$i%j%;%l%/%H(B
       $B$5$l$?8e$K!"$9$0$K@\B3$,@Z$l$?>l9g$G$"$k!#(B
       <$B=hM}(B>
        $B!&Ev3:E>Aw%l%3!<%I$r%P%98"%-%e!<$K%(%s%-%e!<$9$k!#(B
    D.Reset Condition$B3d$j9~$_8!=P(B
      $B!&%j%;%C%H%3%s%G%#%7%g%s;~$N=hM}$K0\$k!#(B
    E.SPC Hardware Error$B3d$j9~$_8!=P(B
      $B!&(BSelect$B%3%^%s%I$N%"%\!<%H=hM}$r9T$$%(%i!<=*N;$H$9$k!#(B
    F.Time Out$B3d$j9~$_8!=P(B
      $B!&%(%i!<=*N;$H$9$k!#(B
<ETC>
  Identify$B%a%C%;!<%8Aw=P=hM}$r%5%V%k!<%A%s2=!#(B
********************************************************************* PSL **/

#SUBARG_define A_TransRec   SRC
#SUBARG_define A_Phase      DST 

#SUBROUTINE f_ScsiReselectionPhase_Sub(A_TransRec, A_Phase)
{
 Reselection_Start:
    $USE(D_WorkUnit1);
    s_GetScsiTransRecUnit(A_TransRec, D_WorkUnit1);
    b_ScsiReselection(D_WorkUnit1);            /* Select$B%3%^%s%IH/9T(B */
    $RELEASE(D_WorkUnit1);
    b_BusyWaitScsiInterrupt();              /* SCSI$B3d$j9~$_(B */

    /* Select$B%3%^%s%I<B9T7k2L$N2r@O(B */
    $USE(D_WorkInterrupt);
    b_GetScsiInterrupt(D_WorkInterrupt); /* INTS$B%l%8%9%?FI$_=P$7(B */
    b_IfScsiInterruptResetCondition(D_WorkInterrupt){
	/* $B%j%;%C%H%3%s%G%#%7%g%s8!=P(B */
	$RELEASE(D_WorkInterrupt);
	b_SetImmValueDNTC(_ERROR_END, A_Phase);
	goto END;
    }
    b_IfScsiInterruptTimeOut(D_WorkInterrupt){
	/* $B%?%$%`%"%&%H8!=P(B */
	$RELEASE(D_WorkInterrupt);
	b_ResetScsiInterruptTimeOut();
	s_SetResultCodeTransRecError(_TIME_OUT, A_TransRec);
	/* $B%j%9%H$KEPO?$9$k!#(B*/
	$USE(D_WorkUnit1);
	$USE(D_WorkLun1);
	s_GetScsiTransRecUnit(A_TransRec, D_WorkUnit1);
	s_GetScsiTransRecLUN(A_TransRec, D_WorkLun1);
	f_EnqueueToErrDetectedConnectionList(D_WorkUnit1, D_WorkLun1);
	$CALL( f_CancelReservedTransfer_Sub(D_WorkUnit1,D_WorkLun1));
	/* $BF1$8(BUnit,LUN$B$K4X$9$kE>AwM=Ls$N%-%c%s%;%k(B */
	$RELEASE(D_WorkLun1);
	$RELEASE(D_WorkUnit1);
	b_SetImmValueDNTC(_TARGET_TERMINATE, A_Phase);
	goto END;
    }
    b_IfScsiInterruptSPCHardwareError(D_WorkInterrupt){
	/* $B%O!<%I%&%(%"%(%i!<8!=P(B */
	$RELEASE(D_WorkInterrupt);
	s_SetResultCodeTransRecError(_ERROR_IN_RESELECTION, A_TransRec);
	$CALL(f_ScsiReselectAbort_Sub(A_TransRec, A_Phase));
	/* $B%$%s%?%i%W%H$N%j%;%C%H$O(Bf_ScsiReselectAbort_Sub$B$NCf$G9T$J$&(B */
	goto END;
    }

    $USE(D_WorkStatus);
    b_GetScsiStatus(D_WorkStatus);          /* SSTS$B%l%8%9%?FI$_$@$7(B */
    b_GetScsiInterrupt(D_WorkInterrupt);    /* INTS$B%l%8%9%?FI$_$@$7(B */
    b_IfScsiStatusConnectedAsTarget(D_WorkStatus){
    /* $B%?!<%2%C%H$H$7$F@\B3(B */
	$RELEASE(D_WorkStatus);
	b_IfScsiInterruptSelected(D_WorkInterrupt){
	    /* $B%;%l%/%H$5$l$?(B */
	    $RELEASE(D_WorkInterrupt);
	    f_EnqueueToBusFreeWaiting(A_TransRec);
	    b_SetImmValueDNTC(_SELECTED, A_Phase);
	    goto END;
	}
	b_IfScsiInterruptCommandComplete(D_WorkInterrupt){
	    /* Select$B%3%^%s%I@.8y(B */
	    $RELEASE(D_WorkInterrupt);
	    /* $BI,$:(BCommand Complete$B3d$j9~$_$K$J$C$F$$$k$O$:(B */
	    b_ResetScsiInterruptCommandComplete();
	    $CALL(f_ScsiTargetSendIdentify_Sub(A_TransRec, A_Phase));
	    goto END;
	} /* End of b_IfScsiInterruptCommandComplete : Select$B%3%^%s%I(B */
	/* $B%?!<%2%C%H$H$7$F%3%M%/%H$7$F$$$k$,%j%;%l%/%7%g%s@.8y$G$b!"(B
	   $B%;%l%/%H$5$l$?$N$G$b$J$$!#(B                               */
	@DEBUG{
	    VPIM_ERROR("f_ScsiReselectionPhase_Sub","trouble in spc ?");
	};
    } /* End of b_IfScsiStatusConnectedAsTarget */
    b_IfScsiStatusConnectedAsInitiator(D_WorkStatus){
    /* $B%$%K%7%(!<%?$H$7$F@\B3(B */
	$RELEASE(D_WorkStatus);
	b_IfScsiInterruptReselected(D_WorkInterrupt){
	    $RELEASE(D_WorkInterrupt);
	    /* $B%j%;%l%/%H$5$l$?(B */
	    f_EnqueueToBusFreeWaiting(A_TransRec);
	    b_SetImmValueDNTC(_RESELECTED, A_Phase);
	    goto END;
	}
	/* $B%$%K%7%(!<%?$H$7$F@\B3$7$F$$$k$,%j%;%l%/%H$5$l$?$N$G$O$J$$!#(B*/
	@DEBUG{
	    VPIM_ERROR("f_ScsiReselectionPhase_Sub","trouble in spc ?");
	};
    } /* End of b_IfScsiStatusConnectedAsInitiator */
    b_IfScsiStatusNotConnected(D_WorkStatus){
    /* SCSI$B$H$O@\B3$7$F$$$J$$(B */
	$RELEASE(D_WorkStatus);
	b_IfScsiInterruptDisconnected(D_WorkInterrupt){
	    /* $B%P%9%U%j!<%U%'!<%:8!=P(B */
	    f_EnqueueToBusFreeWaiting(A_TransRec);
	    b_IfScsiInterruptReselected(D_WorkInterrupt){
		/* $B%j%;%l%/%H8e$K%P%9$,2rJ|$5$l$?(B */
		b_ResetScsiInterruptReselectedAndDisconnected();
	    }else{
	    /* Disconnected$B3d$j9~$_$,8!=P$5$l$k$N$O>e5-$N>l9g$@$1$N$O$:!#(B*/
		@DEBUG{
		  VPIM_ERROR("f_ScsiReselectionPhase_Sub","trouble in spc ?");
	        };
	    }
	    $RELEASE(D_WorkInterrupt);
	    goto END;
	}
	b_IfScsiInterruptCommandComplete(D_WorkInterrupt){
	    /* $B%"!<%S%H%l!<%7%g%s<:GT(B */
	    $RELEASE(D_WorkInterrupt);
	    b_ResetScsiInterruptCommandComplete();
	    f_EnqueueToBusFreeWaiting(A_TransRec);
	    b_SetScsiBusFreeInterruptOn();
	    /* PCTL $B%l%8%9%?(B.Bit7 : Bus Free Interrupt Enable = '1' */
	    b_SetImmValueDNTC(_ARBITRATION_FAILURE, A_Phase);
	    goto END;
	}
	@DEBUG{
	    VPIM_ERROR("f_ScsiReselectionPhase_Sub","truble in spc ?");
	};
    } /* End of b_IfScsiStatusNotConnected */
    @DEBUG{
	VPIM_ERROR("f_ScsiReselectionPhase_Sub","trouble in spc ?");
    };

  END:
    $RETURN();
}

/******************************************************************** PSL **

       written by f-takei@icot22      on Wed Mar 20 11:06:32 1991
<Arguments>
  A_TransRec
  A_Phase
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B%$%K%7%(!<%?$K(BIdentify$B%a%C%;!<%8$r(B($BI,MW$J$i3HD%(BIdentify$B%a%C%;!<%8$b(B)$BAw$k!#(B
<Examples>
<Test>
<Explanation>
  "Identify"$B%a%C%;!<%8$NAw=P$O!"(BSPC$B$N(BTransfer$B%3%^%s%I$K$h$C$F9T$&!#<B9T7k2L$O(B
  $B3d$j9~$_$K$h$C$FH=JL$9$k!#$^$?!"2?$i$+$N%(%i!<$,8!=P$5$l$?>l9g$K$O!"%(%i!<(B
  $B$N>pJs$rE>Aw%l%3!<%IFb$NNN0h$K%;%C%H$7$F!"%(%i!<%O%s%I%j%s%0$N%k!<%A%s$N8F$S(B
  $B=P$7$r9T$&!#3d$j9~$_$NFbMF$H=hM}$K$D$$$F$O0J2<$NDL$j!#(B

    A.Command Complete$B3d$j9~$_(B
      $BE>Aw=*N;!#8!=P$5$l$k%(%i!<$N>uBV$K$h$C$F0J2<$N=hM}$K$o$+$l$k!#(B
      <$B=hM}(B>
        a.$B%(%i!<$,8!=P$5$l$J$+$C$?>l9g!#(B
          $B;XDj$5$l$?E>Aw%U%'!<%:$N<B9T$K0\$k!#(B
        b.$B%Q%j%F%#%(%i!<$,8!=P$5$l$?>l9g!#(B
      b $B$N>l9g$O%(%i!<%O%s%I%j%s%0MQ$N%k!<%A%s(B(f_ScsiTargetErrorEnd_Sub)$B$r(B
      $B8F$S=P$7!"8e=hM}$r9T$&!#(B
    B.Service Required$B3d$j9~$_(B
      $B%"%F%s%7%g%s%3%s%G%#%7%g%s$,8!=P$5$l$?!#(B
      (SPC$B%l%8%9%?(BSCMD.bit0:Termination Mode='1'$B$N$H$-(B)
      <$B=hM}(B>
      $B!&(BTransfer$B%3%^%s%I$r<B9TCf$N>l9g$O!"(BTransfer Pause$B%3%^%s%I$rH/9T$7$F(B
        $B6/@)=*N;$9$k!#(B
      $B!&0J2<$N(B2$B$D$N>uBV$K$o$+$l$k!#(B
          a.$BB>$N%(%i!<$O8!=P$5$l$F$$$J$$>l9g!#(B
          b.$B%Q%j%F%#%(%i!<$,8!=P$5$l$F$$$k>l9g!#(B
        $B$$$:$l$N>l9g$b%(%i!<%O%s%I%j%s%0MQ$N%k!<%A%s(B(f_ScsiTargetErrorEnd_Sub)
        $B$r8F$S=P$7!"8e=hM}$r9T$&!#(B
    C.SPC Hardware Error$B3d$j9~$_(B
      SPC Hardware Error$B$,8!=P$5$l$?!#(B
      <$B=hM}(B>
      $B!&(BTransfer$B%3%^%s%I$r<B9TCf$N>l9g$O!"(BTransfer Pause$B%3%^%s%I$rH/9T$7$F(B
        $B6/@)=*N;$9$k!#(B
      $B!&%(%i!<%O%s%I%j%s%0MQ$N%k!<%A%s(B(f_ScsiTargetErrorEnd_Sub)$B$r8F$S=P$7!"(B
        $B8e=hM}$r9T$&!#(B
    D.Reset Condition$B3d$j9~$_(B
      $B%j%;%C%H%3%s%G%#%7%g%s$,8!=P$5$l$?!#(B
      <$B=hM}(B>
      $B!&%j%;%C%H%3%s%G%#%7%g%s;~$N=hM}$r9T$&!#(B
<ETC>
<Revised Memo on "Jul  3">
  $BE>Aw=*N;8e$N3d$j9~$_8!=P(B
    E.Selected, Reselected, Time Out
      Fatal Error $B$H$7$F8!=P;~$N=hM}$K0\$k!#(B
********************************************************************* PSL **/

#SUBARG_define A_TransRec   SRC
#SUBARG_define A_Phase      DST 

#SUBROUTINE f_ScsiTargetSendIdentify_Sub(A_TransRec, A_Phase)
{
    /*--- Service Required, Reset Condition $B3d$j9~$_$N%A%'%C%/(B---*/
    b_IfScsiAnyInterrupt(){
	f_ScsiTargetInterruptCheck(A_TransRec, A_Phase);
	goto END;
    }

    /*--- "Identify"$B%a%C%;!<%8$NAw=P(B ---*/
    $USE(D_WorkLun1);
    s_GetScsiTransRecLUN(A_TransRec, D_WorkLun1);
    s_IfATOM(D_WorkLun1){
	@DEBUG{
	    b_IfNotEqual(D_WorkLun1, D_NULL){
		VPIM_ERROR("f_ScsiReselectionPhase_Sub",
			   "invalid argument.");
	    }
	};
	$RELEASE(D_WorkLun1);
	b_SetImmValueDNTC(_TARGET_TRANSFER, A_Phase);
	goto END;
    }
    b_IfGreaterImm(D_WorkLun1, _MAX_SCSI_DEV_NUM){
	b_ScsiTargetSendExIdentify(D_WorkLun1);
	/* $B3HD%(BIdetify$B%a%C%;!<%8Aw=P(B */
    }else{
	b_ScsiTargetSendIdentify(D_WorkLun1);
	/* Identify$B%a%C%;!<%8Aw=P(B */
    }
    $RELEASE(D_WorkLun1);
    /* $BE>Aw$N=*N;>uBV(B */
    $USE(D_WorkInterrupt);
    b_GetScsiInterrupt(D_WorkInterrupt);
    /* $B%j%;%C%H%3%s%G%#%7%g%s$N8!=P(B */
    b_IfScsiInterruptResetCondition(D_WorkInterrupt){
	$RELEASE(D_WorkInterrupt);
	b_SetImmValueDNTC(_ERROR_END, A_Phase);
	goto END;
    }
    b_IfScsiInterruptSPCHardwareError(D_WorkInterrupt){
	$RELEASE(D_WorkInterrupt);
	f_ScsiTargetIntrHardwareErrorHandlingInput(A_TransRec, A_Phase);
	goto END;
    }
    b_IfScsiInterruptCommandComplete(D_WorkInterrupt){
	/* $B;XDjE>AwNL$NE>Aw=*N;(B */
	$RELEASE(D_WorkInterrupt);
	f_ScsiTargetIntrCommandCompleteHandlingOutput2(A_TransRec, A_Phase);
	goto END;
    }
    /* $B%"%F%s%7%g%s%3%s%G%#%7%g%s$N8!=P(B
	SPC.PCTL.Bit5:Attention Condition Interrput Enable="1" */
    b_IfScsiInterruptServiceRequired(D_WorkInterrupt){
	$RELEASE(D_WorkInterrupt);
	f_ScsiTargetIntrServiceRequiredHandlingOutput(A_TransRec, A_Phase);
	goto END;
    }
    /* Fatal Error */
    b_SetImmValueDNTC(_FATAL_ERROR_END, A_Phase);
    @DEBUG{
	b_IfScsiInterruptSelected(D_WorkInterrupt){
	    ;
	}else{
	    b_IfScsiInterruptReselected(D_WorkInterrupt){
		;
	    }else{
		b_IfScsiInterruptTimeOut(D_WorkInterrupt){
		    ;
		}else{
		    VPIM_ERROR("f_ScsiReselectionPhase",
			       "Unknown data on register?");
		}
	    }
	}
    };
    $RELEASE(D_WorkInterrupt);

  END:
    $RETURN();
}
