
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pimp/ICOT/V10-scsi/functions/f_scsi_tgt_interrupt_handling.psl.c
   ----- CREATED   : by f-takei@icot22, on Wed Mar 20 10:21:19 1991
   ----- LAST SAVED: by f-takei@icot22, on Thu Jul  4 20:59:58 1991
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : functions
   ----- ABSTRACT  : Transfer$B%3%^%s%IH/9T8e$N3F3d$j9~$_$KBP$9$k=hM}(B

  $B!&(Bf_ScsiTargetInterruptCheck
  $B!&(Bf_ScsiTargetParityErrorHandlingOutput
  $B!&(Bf_ScsiTargetParityErrorHandlingInput

 $B>pJsE>Aw;~$N3d$j9~$_=hM}(B
  $B!&(Bf_ScsiTargetIntrHardwareErrorHandlingOutput
  $B!&(Bf_ScsiTargetIntrHardwareErrorHandlingInput
  $B!&(Bf_ScsiTargetIntrCommandCompleteHandlingOutput
  $B!&(Bf_ScsiTargetIntrCommandCompleteHandlingInput
  $B!&(Bf_ScsiTargetIntrServiceRequiredHandlingOutput
  $B!&(Bf_ScsiTargetIntrServiceRequiredHandlingInput
  $B!&(Bf_ScsiTargetIntrCommandCompleteHandlingOutput2
  $B!&(Bf_ScsiTargetIntrCommandCompleteHandlingInput2  * not used? *

  $B!&(Bf_ScsiTargetDisconnect
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

#PSL_define f_ScsiTargetInterruptCheck(trans_rec_ptr_reg, phase_reg)
{
    $USE(D_WorkInterrupt);
    b_GetScsiInterrupt(D_WorkInterrupt);
    b_IfScsiInterruptResetCondition(D_WorkInterrupt){
	$RELEASE(D_WorkInterrupt);
	b_SetImmValueDNTC(_ERROR_END, phase_reg);
    }else{
	b_IfScsiInterruptServiceRequired(D_WorkInterrupt){
	    /* $B%"%F%s%7%g%s%3%s%G%#%7%g%s8!=P(B */
	    $RELEASE(D_WorkInterrupt);
	    $CALL(f_ScsiTargetErrorEnd_Sub(trans_rec_ptr_reg));
	    b_SetImmValueDNTC(_TARGET_TERMINATE, phase_reg);
	}else{
	    $RELEASE(D_WorkInterrupt);
	    b_SetImmValueDNTC(_FATAL_ERROR_END, phase_reg);
	}
    }
}

#PSL_define f_ScsiTargetParityErrorHandlingOutput(trans_rec_ptr_reg, phase_reg)
{
    b_ScsiSPCControlReset();
    /* SPC $B$N%G!<%?E>Aw@)8f2sO)$N%j%;%C%H(B */
    s_SetResultCodeTransRecError(_PARITY_ERROR_O, trans_rec_ptr_reg);
    /* $B%(%i!<%3!<%I$N%;%C%H(B */
    $CALL(f_ScsiTargetErrorEnd_Sub(trans_rec_ptr_reg));
    b_SetImmValueDNTC(_TARGET_TERMINATE, phase_reg);
}

#PSL_define f_ScsiTargetParityErrorHandlingInput(trans_rec_ptr_reg, phase_reg)
{
    b_ResetScsiErrorReg();
    /* $B%(%i!<%l%8%9%?$N%/%j%"(B */
    s_SetResultCodeTransRecError(_PARITY_ERROR_I, trans_rec_ptr_reg);
    /* $B%(%i!<%3!<%I$N%;%C%H(B */
    $CALL(f_ScsiTargetErrorEnd_Sub(trans_rec_ptr_reg));
    b_SetImmValueDNTC(_TARGET_TERMINATE, phase_reg);
}

#PSL_define f_ScsiTargetIntrHardwareErrorHandlingOutput
                                              (trans_rec_ptr_reg, phase_reg)
{
    b_ScsiTransferPauseOutput();
    /* Transfer$B%3%^%s%I$N6/@)=*N;(B */
    b_ScsiSPCControlReset();
    /* SPC $B$N%G!<%?E>Aw@)8f2sO)$N%j%;%C%H(B */
    s_SetResultCodeTransRecError(_SPC_HARDWARE_ERROR, trans_rec_ptr_reg);
    /* $B%(%i!<%3!<%I$N%;%C%H(B */
    $CALL(f_ScsiTargetErrorEnd_Sub(trans_rec_ptr_reg));
    b_SetImmValueDNTC(_TARGET_TERMINATE, phase_reg);
}

#PSL_define f_ScsiTargetIntrHardwareErrorHandlingInput
                                              (trans_rec_ptr_reg, phase_reg)
{
    b_ScsiTransferPauseInput();
    b_ScsiSPCControlReset();
    /* SPC $B$N%G!<%?E>Aw@)8f2sO)$N%j%;%C%H(B */
    s_SetResultCodeTransRecError(_SPC_HARDWARE_ERROR, trans_rec_ptr_reg);
    /* $B%(%i!<%3!<%I$N%;%C%H(B */
    $CALL(f_ScsiTargetErrorEnd_Sub(trans_rec_ptr_reg));
    b_SetImmValueDNTC(_TARGET_TERMINATE, phase_reg);
}

#PSL_define f_ScsiTargetIntrCommandCompleteHandlingOutput
                                     (trans_rec_ptr_reg, phase_reg)
{
    b_ResetScsiInterruptCommandComplete();
    b_IfScsiParityError(){
	f_ScsiTargetParityErrorHandlingOutput(trans_rec_ptr_reg, phase_reg);
	goto End;
    }
    b_IfScsiAttentionCondition(){
	/* $B%"%F%s%7%g%s%3%s%G%#%7%g%s8!=P(B */
	$CALL(f_ScsiTargetErrorEnd_Sub(trans_rec_ptr_reg));
	b_SetImmValueDNTC(_TARGET_TERMINATE, phase_reg);
	goto End;
    }
    /* "Save Data Pointer", "Disconnect"$B%a%C%;!<%8$NAw=P$H%P%9$N2rJ|(B */
    f_ScsiTargetDisconnect(trans_rec_ptr_reg);
    b_SetImmValueDNTC(_TARGET_TERMINATE, phase_reg);
    /* $B;XDj$5$l$?%U%'!<%:$G$NE>Aw$N@5>o=*N;(B */

  End:
    ;
}

#PSL_define f_ScsiTargetIntrCommandCompleteHandlingInput
                            (trans_rec_ptr_reg, phase_reg)
{
    b_ResetScsiInterruptCommandComplete();
    b_IfScsiParityError(){
	f_ScsiTargetParityErrorHandlingInput(trans_rec_ptr_reg, phase_reg);
	goto End;
    }
    b_IfScsiAttentionCondition(){
	/* $B%"%F%s%7%g%s%3%s%G%#%7%g%s8!=P(B */
	$CALL(f_ScsiTargetErrorEnd_Sub(trans_rec_ptr_reg));
	b_SetImmValueDNTC(_TARGET_TERMINATE, phase_reg);
	goto End;
    }
    /* "Save Data Pointer", "Disconnect"$B%a%C%;!<%8$NAw=P$H%P%9$N2rJ|(B */
    f_ScsiTargetDisconnect(trans_rec_ptr_reg);
    b_SetImmValueDNTC(_TARGET_TERMINATE, phase_reg);
    /* $B;XDj$5$l$?%U%'!<%:$G$NE>Aw$N@5>o=*N;(B */

  End:
    ;
}

#PSL_define f_ScsiTargetIntrServiceRequiredHandlingOutput
                                     (trans_rec_ptr_reg, phase_reg)
{
    /* $B%"%F%s%7%g%s%3%s%G%#%7%g%s8!=P(B */
    b_ScsiTransferPauseOutput();
    /* Transfer$B%3%^%s%I$N6/@)=*N;(B */
    b_IfScsiParityError(){
	f_ScsiTargetParityErrorHandlingOutput(trans_rec_ptr_reg, phase_reg);
    }else{
	$CALL(f_ScsiTargetErrorEnd_Sub(trans_rec_ptr_reg));
	b_SetImmValueDNTC(_TARGET_TERMINATE, phase_reg);
    }
}

#PSL_define f_ScsiTargetIntrServiceRequiredHandlingInput
                                       (trans_rec_ptr_reg, phase_reg)
{
    /* $B%"%F%s%7%g%s%3%s%G%#%7%g%s8!=P(B */
    b_ScsiTransferPauseInput();
    b_IfScsiParityError(){
	f_ScsiTargetParityErrorHandlingInput(trans_rec_ptr_reg, phase_reg);
    }else{
	$CALL(f_ScsiTargetErrorEnd_Sub(trans_rec_ptr_reg));
	b_SetImmValueDNTC(_TARGET_TERMINATE, phase_reg);
    }
}

#PSL_define f_ScsiTargetIntrCommandCompleteHandlingOutput2
                                    (trans_rec_ptr_reg, phase_reg)
{
    b_ResetScsiInterruptCommandComplete();
    b_IfScsiParityError(){
	f_ScsiTargetParityErrorHandlingOutput(trans_rec_ptr_reg, phase_reg);
	goto End;
    }
    b_IfScsiAttentionCondition(){
	/* $B%"%F%s%7%g%s%3%s%G%#%7%g%s8!=P(B */
	$CALL(f_ScsiTargetErrorEnd_Sub(trans_rec_ptr_reg));
	b_SetImmValueDNTC(_TARGET_TERMINATE, phase_reg);
	goto End;
    }
    b_SetImmValueDNTC(_TARGET_TRANSFER, phase_reg);

  End:
    ;
}

#PSL_define f_ScsiTargetIntrCommandCompleteHandlingInput2
                                       (trans_rec_ptr_reg, phase_reg)
{
    b_ResetScsiInterruptCommandComplete();
    b_IfScsiParityError(){
	f_ScsiTargetParityErrorHandlingInput(trans_rec_ptr_reg, phase_reg);
	goto End;
    }
    b_IfScsiAttentionCondition(){
	/* $B%"%F%s%7%g%s%3%s%G%#%7%g%s8!=P(B */
	$CALL(f_ScsiTargetErrorEnd_Sub(trans_rec_ptr_reg));
	b_SetImmValueDNTC(_TARGET_TERMINATE, phase_reg);
	goto End;
    }
    b_SetImmValueDNTC(_TARGET_TRANSFER, phase_reg);

  End:
    ;
}

#PSL_define f_ScsiTargetDisconnect(trans_rec_ptr_reg)
{
    $USE(D_WorkContinue);
    s_GetScsiTransRecContinue(trans_rec_ptr_reg, D_WorkContinue);
    /*----------------------------------------------------------------
      Continue$B$,(B0$B$J$i$PC1$K%P%9$r2rJ|$9$k!#(B
      Continue$B$,(B0$B$G$J$1$l$P!"(Bsave data pointer, disconnect $B%a%C%;!<%8(B
      $B$rAw$C$?8e$K%P%9$r2rJ|$9$k!#(B
     ----------------------------------------------------------------*/
    b_IfNotZero(D_WorkContinue){
	b_ScsiTargetSendMessageByManual(_MSG_SAVE_DATA_POINTER);
	b_ScsiTargetSendMessageByManual(_MSG_DISCONNECT);
	/* $B%Q%j%F%#%(%i!<8!=P;~$N=hM}$O$I$&$9$k$+!)(B */
    }
    $RELEASE(D_WorkContinue);
    b_SPCCommandBusRelease();
}
