
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_scsi_tgt_error_handler.psl.c
   ----- CREATED   : by f-doumae@icot22, on Tue Oct  2 17:07:55 1990
   ----- LAST SAVED: by f-takei@icot22, on Tue Jun  9 16:04:53 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : $BE>AwF0:n$N%"%\!<%H(B

1. $BE>AwF0:n$N%"%\!<%H(B
2. $B%j%;%l%/%7%g%s%U%'!<%:$N%"%\!<%H(B
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */
/******************************************************************** PSL **
1. $BE>AwF0:n$N%"%\!<%H(B
       written by f-takei@icot22      on Thu Sep 13 14:35:29 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  $BE>AwCf!"2?$i$+$N%(%i!<>uBV5Z$S%"%F%s%7%g%s%3%s%G%#%7%g%s$,8!=P$5$l$?;~!"(B
  f_ScsiTargetErrorEnd_Sub $B%k!<%A%s$K$h$C$F8e$N=hM}$rA4$F9T$&!#(B
  $B$3$3$G$N=hM}FbMF$O0J2<$NDL$j!#(B
    1.$B0[>o=*N;$7$?%3%M%/%7%g%s$r%j%9%H(B(ErrorDetectedConnectionList)$B$KEPO?$7!"(B
      $BM=Ls%-%e!<$KF1$8(BUnit,LUN$B$K4X$9$kE>AwM=Ls$,$"$l$PA4$F%-%c%s%;%k$9$k!#(B
    2.$B%"%F%s%7%g%s%3%s%G%#%7%g%s$K$J$C$F$$$l$P!"%"%F%s%7%g%s%3%s%G%#%7%g%s$,(B
      $BB3$/4V!"%P%C%U%!$,$"$U$l$J$$8B$j!"%$%K%7%(!<%?$+$i$N%a%C%;!<%8$rFI$_9~(B
      $B$`!#FI$_9~$s$@%a%C%;!<%8$HD9$5$OE>Aw%l%3!<%IFb$N%P%C%U%!5Z$S%9%m%C%H$K(B
      $B3JG<$9$k!#(B
    3.$BE>Aw7k2L$rJs9p$9$k!#(B
  $B$3$NFb!"(B1$B$O(Bf_ScsiTargetReceiveMsgWhileAttentionCondition$B$G=hM}$7!"(B
  3$B$K$D$$$F$O!"(Bf_ScsiTargetTerminate_Sub$B$G=hM}$9$k!#(B
  $B$J$*!"%a%C%;!<%83JG<MQ$N%P%C%U%!$NMFNL0J>e$N%a%C%;!<%8E>Aw$,MW5a$5$l$?>l9g!"(B
  $B$=$NJs9p$O$7$F$$$J$$!#(B
<ETC>
********************************************************************* PSL **/

#SUBARG_define A_TransRec    SRC

#SUBROUTINE f_ScsiTargetErrorEnd_Sub(A_TransRec)
{
    $USE(D_WorkUnit1);
    $USE(D_WorkLun1);
    s_GetScsiTransRecUnit(A_TransRec, D_WorkUnit1);
    s_GetScsiTransRecLUN(A_TransRec, D_WorkLun1);
    f_EnqueueToErrDetectedConnectionList(D_WorkUnit1, D_WorkLun1);
    /* $B%j%9%H$KEPO?$9$k!#(B*/
    $CALL( f_CancelReservedTransfer_Sub(D_WorkUnit1,D_WorkLun1));
    /* $BF1$8(BUnit,LUN$B$K4X$9$kE>AwM=Ls$N%-%c%s%;%k(B */
    $RELEASE(D_WorkLun1);
    $RELEASE(D_WorkUnit1);

    b_IfScsiAttentionCondition(){
	$USE(D_WorkMsgBuf);
	s_GetScsiTransRecPtrToMsgBuff(A_TransRec, D_WorkMsgBuf);
	s_SetResultCodeTransRecMsgReceived(A_TransRec);
	$USE(D_WorkMsgLen);
	b_SetImmTypeValueMRBoff(INT, _ZERO, D_WorkMsgLen);
	f_ScsiTargetReceiveMsgWhileAttentionCondition
	    (D_WorkMsgLen, D_WorkMsgBuf);
	$RELEASE(D_WorkMsgBuf);
	b_ResetScsiInterruptServiceRequired();
	/* $B3d$j9~$_(B(Service Required:$B%"%F%s%7%g%s%3%s%G%#%7%g%s8!=P(B)$B%j%;%C%H(B */
	s_SetScsiTransRecMsgLen(D_WorkMsgLen, A_TransRec);
	/* $BFI$_9~$s$@%a%C%;!<%8$ND9$5$r3JG<(B */
	$RELEASE(D_WorkMsgLen);
    }
    /* "Disconnect"$B%a%C%;!<%8$NAw=P$H%P%9$N2rJ|(B (91.2.1) */
    b_ScsiTargetSendMessageByManual(_MSG_DISCONNECT);
    b_SPCCommandBusRelease();
    $RETURN();
}

#PSL_define f_ScsiTargetReceiveMsgWhileAttentionCondition
                              (data_ctr_reg, strg_ptr_reg)
{
    b_SetScsiPhaseMsgOut();
    LOOP(){   /* Attention Condition -> Message Out:$B%a%C%;!<%8$NFI$_9~$_(B */
	b_IfScsiAttentionCondition(){
	    $USE(D_WorkMessage);
	    b_ScsiTargetReceiveDataByManual(D_WorkMessage);
	    /* manual $BE>Aw(B:1$B%P%$%H<uNN(B */
	    s_WriteByteData(D_WorkMessage, strg_ptr_reg, data_ctr_reg);
	       /* $BFI$_9~$s$@%a%C%;!<%8$r(B1$B%P%$%H3JG<$9$k(B */
	    b_IncrementReg(data_ctr_reg);

/*-----------------------------------------------------------------------
    $B=hM}7O$H$7$F$O%a%C%;!<%8$NFbMF$K$O4X78$J$/!"%"%F%s%7%g%s%3%s%G%#%7%g%s$N(B
    $B4V%$%K%7%(!<%?$+$iAw$i$l$F$/$k%a%C%;!<%8$r<u$1<h$k!#(B
	    b_IfEqualImm(D_WorkMessage, _EXTENDED_MSGS){
		$RELEASE(D_WorkMessage);
		$CALL(f_ScsiTargetReceiveExMsg_Sub(strg_ptr_reg,
						   data_ctr_reg));
	    }
--------------------------------------------------------------------------*/
	    $RELEASE(D_WorkMessage);
	    b_IfEqualImm(data_ctr_reg, _MAX_MSG_LEN){
		/* $B%a%C%;!<%83JG<MQ$N%P%C%U%!$"$U$l$k(B */
		break;
	    }
	}else{   /* Not Attention Condition */
	    break;
	}
    }
}


/******************************************************************** PSL **
2. $B%j%;%l%/%7%g%s%U%'!<%:$N%"%\!<%H(B
       written by f-takei@icot22      on Wed Aug 29 20:07:51 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  $B%j%;%l%/%7%g%s%U%'!<%:<B9T$N$?$a$N(BSelect$B%3%^%s%IH/9T8e$N(BSPC Hardware Error
  $B3d$j9~$_$KBP$9$k=hM}!#(B
  SPC Hardware Error$B3d$j9~$_$,8!=P$5$l$?>l9g!"$=$l$K$h$C$F(BSelect$B%3%^%s%I$N(B
  $BF0:n$,=*N;$9$k$3$H$O$J$$$N$G!"B>$N3d$j9~$_8!=P$K$h$C$F%3%^%s%I$N=*N;$r(B
  $B3NG'$9$k!#(B
  $B$3$3$G$N=hM}FbMF$O0J2<$NDL$j!#(B

  1.Select$B%3%^%s%I$N=*N;$r3NG'$9$k(B
       $B!&%3%M%/%H$7$F$$$J$$(B
       $B!&%3%M%/%H$7$F$$$k(B
       $B!&=*N;$7$F$$$J$$(B
          -> $B%?%$%`%"%&%H8!=P$r9T$&(B
             ($B%?%$%`%"%&%H$N8!=P$O4F;k$9$kI,MW$,$"$k!#(B)
  2.Select$B%3%^%s%I$N=*N;>uBV(B($B3d$j9~$_(B)$B$K$h$C$F0J2<$N=hM}$K$o$+$l$k!#(B
    2-1.Reset Condition$B3d$j9~$_8!=P(B
       $B!&%j%;%C%H%3%s%G%#%7%g%s;~$N=hM}$K>uBV$r@_Dj$9$k!#(B
    2-2.Time Out$B3d$j9~$_8!=P(B
       $B!&7k2LJs9p=hM}$r9T$$!"<!$NE>Aw=hM}$K>uBV$r@_Dj$9$k!#(B
    2-3.$B%?!<%2%C%H$H$7$F@\B3$7$F$$$k>l9g!#(B
     (1) Command Complete$B3d$j9~$_8!=P(B
       $B!&(B"Disconnect"$B%a%C%;!<%8$rAw=P$9$k!#(B
       $B!&%P%9$r2rJ|$7$F!"@\B3$r@Z$k!#(B
       $B!&7k2LJs9p=hM}$r9T$$!"<!$NE>Aw=hM}$K>uBV$r@_Dj$9$k!#(B
     (2) Selected$B3d$j9~$_8!=P(B
       $B!&7k2LJs9p=hM}$r9T$&!#(B
       $B!&%;%l%/%H;~$N3d$j9~$_=hM}$K>uBV$r@_Dj$9$k!#(B
    2-4.$B%$%K%7%(!<%?$H$7$F@\B3$7$F$$$k>l9g!#(B
     (1) Reslected$B3d$j9~$_8!=P(B
       $B!&7k2LJs9p=hM}$r9T$&!#(B
       $B!&%j%;%l%/%H;~$N3d$j9~$_=hM}$K>uBV$r@_Dj$9$k!#(B
    2-5.SCSI$B$H@\B3$7$F$$$J$$;~(B
     (1) Command Complete$B3d$j9~$_8!=P(B
       $B%"!<%S%H%l!<%7%g%s<:GT!#(B
       $B!&7k2LJs9p=hM}$r9T$$!"<!$NE>Aw=hM}$K>uBV$r@_Dj$9$k!#(B
     (2) Disconnected$B3d$j9~$_8!=P(B
       $B!&7k2LJs9p=hM}$r9T$$!"<!$NE>Aw=hM}$K>uBV$r@_Dj$9$k!#(B
<ETC>
********************************************************************* PSL **/

#SUBARG_define A_TransRec    MODIFY
#SUBARG_define A_Phase       DST

#SUBROUTINE f_ScsiReselectAbort_Sub(A_TransRec, A_Phase)
{
    /*----------------------------------------------------------------
	$B%?%$%`%"%&%H8!=P=hM}$,I,MW$H$J$k!#(B
	$B%?%$%`%"%&%H8!=P8e$O!"(B"Reset & Disable"$B$K$h$C$F(BSelect$B%3%^%s%I$r(B
	$B6/@)=*N;$5$;$k!#(B
    -----------------------------------------------------------------*/
    b_BusyWaitScsiIntExcpHardErrWithWatchingTimer();

    $USE(D_WorkInterrupt);
    b_GetScsiInterrupt(D_WorkInterrupt); /* INTS$B%l%8%9%?FI$_=P$7(B */
    b_IfScsiInterruptResetCondition(D_WorkInterrupt){
	$RELEASE(D_WorkInterrupt);
	b_SetImmValueDNTC(_ERROR_END, A_Phase);
	goto END;
    }
    b_IfScsiInterruptTimeOut(D_WorkInterrupt){
	$RELEASE(D_WorkInterrupt);
	b_ResetScsiInterruptTimeOut();
	s_SetResultCodeTransRecError(_TIME_OUT, A_TransRec);
	/* $B40N;>uBV$N%;%C%H(B */
	b_SetImmValueDNTC(_POP_NEXT_TRANS_REC, A_Phase);
	goto Target_Terminate;
    }

    /* SPC $B$N%G!<%?E>Aw@)8f2sO)$N%j%;%C%H(B */
    b_ScsiSPCControlReset();
    $USE(D_WorkStatus);
    b_GetScsiStatus(D_WorkStatus);
    b_GetScsiInterrupt(D_WorkInterrupt);
    b_IfScsiStatusConnectedAsTarget(D_WorkStatus){
	$RELEASE(D_WorkStatus);
	b_IfScsiInterruptSelected(D_WorkInterrupt){
	    /* $B%;%l%/%H$5$l$?(B */
	    $RELEASE(D_WorkInterrupt);
	    b_ResetScsiInterruptSelected(); /* $B3d$j9~$_%j%;%C%H(B */
	    b_SetImmValueDNTC(_SELECTED, A_Phase);
	    goto Target_Terminate;
	}
	b_IfScsiInterruptCommandComplete(D_WorkInterrupt){
	    /* Select$B%3%^%s%I@.8y(B */
	    /* $BI,$:(BCommand Complete$B3d$j9~$_$K$J$C$F$$$k$O$:(B */
	    b_ResetScsiInterruptCommandComplete();
	    /* $B%G%#%9%3%M%/%H$9$k(B */
	    b_ScsiTargetSendMessageByManual(_MSG_DISCONNECT);
	    b_ScsiBusReleaseCommand();
	    b_SetImmValueDNTC(_POP_NEXT_TRANS_REC, A_Phase);
	    goto Target_Terminate;
	}
	/* $B%?!<%2%C%H$H$7$F%3%M%/%H$7$F$$$k$,%j%;%l%/%7%g%s@.8y$G$b!"(B
	   $B%;%l%/%H$5$l$?$N$G$b$J$$!#(B                               */
	@DEBUG{
	    VPIM_ERROR("f_ScsiReselectAbort_Sub","trouble in spc ?");
	};
    } /* End of b_IfScsiStatusConnectedAsTarget */
    b_IfScsiStatusConnectedAsInitiator(D_WorkStatus){
	$RELEASE(D_WorkStatus);
	b_IfScsiInterruptReselected(D_WorkInterrupt){
	    $RELEASE(D_WorkInterrupt);
	    /* $B%j%;%l%/%H$5$l$?(B */
	    b_ResetScsiInterruptReselected();
	    b_SetImmValueDNTC(_RESELECTED, A_Phase);
	    /*----------------------------------------------------------------
	      If target has started data transfer during setting
	      "Control Reset", it's impossible to respond to this transfer
	      with "hard transfer mode".
	    -----------------------------------------------------------------*/
	    goto Target_Terminate;
	}
	/* $B%$%K%7%(!<%?$H$7$F@\B3$7$F$$$k$,%j%;%l%/%H$5$l$?$N$G$O$J$$!#(B*/
	@DEBUG{
	    VPIM_ERROR("f_ScsiReselectAbort_Sub","trouble in spc ?");
	};
    } /* End of b_IfScsiStatusConnectedAsInitiator */
    b_IfScsiStatusNotConnected(D_WorkStatus){
	$RELEASE(D_WorkStatus);
	b_IfScsiInterruptDisconnected(D_WorkInterrupt){
	    /* $B%P%9%U%j!<%U%'!<%:8!=P(B */
	    b_IfScsiInterruptReselected(D_WorkInterrupt){
		/* $B%j%;%l%/%H8e$K%P%9$,2rJ|$5$l$?(B */
		b_ResetScsiInterruptReselectedAndDisconnected();
		b_SetImmValueDNTC(_POP_NEXT_TRANS_REC, A_Phase);
		goto Target_Terminate;
	    }
	    /* Disconnected$B3d$j9~$_$,8!=P$5$l$k$N$O>e5-$N>l9g$@$1$N$O$:!#(B*/
	    @DEBUG{
		VPIM_ERROR("f_ScsiReselectAbort_Sub","trouble in spc ?");
	    };
	}
	b_IfScsiInterruptCommandComplete(D_WorkInterrupt){
	    /* $B%"!<%S%H%l!<%7%g%s<:GT(B */
	    $RELEASE(D_WorkInterrupt);
	    b_ResetScsiInterruptCommandComplete();
	    b_SetImmValueDNTC(_POP_NEXT_TRANS_REC, A_Phase);
	    goto Target_Terminate;
	}
	@DEBUG{
	    VPIM_ERROR("f_ScsiReselectAbort_Sub","truble in spc ?");
	};
    } /* End of b_IfScsiStatusNotConnected */
    @DEBUG{
	VPIM_ERROR("f_ScsiReselectAbort_Sub","trouble in spc ?");
    };

  Target_Terminate:
    /*---------------------------------------------------------------------
      $BDL>o$O!"(Bi_SCSIDeviceDriverInitiatorBody_Sub(comm_rec_ptr_reg) $B$NCf$G(B
      $B9T$&=hM}$@$,!"7k2LJs9p=hM}$K0\$k$3$H$r<($9%i%Y%k$r0l35$K@_Dj$G$-$J$$!#(B
      $B=>$C$F!"(B
      $B$3$N%5%V%k!<%A%s$G@_Dj$5$l$k$N$O!"(B_SELECTED, _RESELECTED, _ERROR_END
      _POP_NEXT_TRANS_REC$B$H$J$k!#(B
    ---------------------------------------------------------------------*/
    $USE(D_WorkUnit1);
    $USE(D_WorkLun1);
    s_GetScsiTransRecUnit(A_TransRec, D_WorkUnit1);
    s_GetScsiTransRecLUN(A_TransRec, D_WorkLun1);
    f_EnqueueToErrDetectedConnectionList(D_WorkUnit1, D_WorkLun1);
    /* $B%j%9%H$KEPO?$9$k!#(B*/
    $CALL( f_CancelReservedTransfer_Sub(D_WorkUnit1,D_WorkLun1));
    /* $BF1$8(BUnit,LUN$B$K4X$9$kE>AwM=Ls$N%-%c%s%;%k(B */
    $RELEASE(D_WorkLun1);
    $RELEASE(D_WorkUnit1);
    $CALL(f_ScsiTargetResultReport_Sub(A_TransRec));
    /*-----------------------------------------------------------
     $B$3$3$G(B1$B$D$NE>Aw$N<B9T$,40N;$9$k!#(B
    -------------------------------------------------------------*/
    f_ScsiQueueManagementOnTransferEnd(A_TransRec);
    
  END:
    $RETURN();
}

#SUBARG_define A_Unit  SRC
#SUBARG_define A_Lun   SRC
#SUBROUTINE f_CancelReservedTransfer_Sub(A_Unit, A_Lun)
{
  $USE(D_WorkRecord);
  /*------------------------------------------------------------------
   (1) $BM=Ls%-%e!<$K$"$kF1$8(B Unit, LUN $B$K4X$9$kE>AwM=Ls$rA4$F%-%c%s%;%k$9$k(B
  --------------------------------------------------------------------*/
  LOOP(){
      f_DequeueTransRecFromReservWithUnitAndLun(A_Unit,A_Lun,D_WorkRecord);
      b_IfEOL(D_WorkRecord){ break;}
      @DEBUG{
	  s_IfNotScsiTransRec(D_WorkRecord){
	      VPIM_ERROR("f_CancelReservedTransfer","Illegal-pointer");
	  }
      };

      $USE(D_WorkFPPtr);
      $USE(D_WorkEnvRecPtr);
      s_GetScsiTransRecFPPtr(D_WorkRecord, D_WorkFPPtr);
      s_GetScsiTransRecEnvironment(D_WorkRecord, D_WorkEnvRecPtr);

      $USE(D_WorkData);
      $USE(D_WorkNewData);
      s_GetScsiTransRecOldData(D_WorkRecord, D_WorkData); 
      s_GetScsiTransRecNewData(D_WorkRecord, D_WorkNewData);
      $CALL( f_UnifyRetryInOtherFP_Sub
	    (D_WorkFPPtr, D_WorkEnvRecPtr, D_WorkData, D_WorkNewData));
      $RELEASE(D_WorkNewData);
      $RELEASE(D_WorkData);

      $USE(D_Workreg);
      $USE(D_WorkResult);
      b_SetImmTypeValueMRBoff(ATOM, _ZERO, D_Workreg);
      s_GetScsiTransRecResult(D_WorkRecord, D_WorkResult);
      $CALL( f_UnifyRetryInOtherFP_Sub
	    (D_WorkFPPtr, D_WorkEnvRecPtr, D_Workreg, D_WorkResult));
      $RELEASE(D_WorkResult);
      $RELEASE(D_Workreg);
      
      $USE(D_WorkTransLen);
      $USE(D_WorkLength);
      b_SetImmTypeValueMRBoff(INT, _ZERO, D_WorkLength);
      s_GetScsiTransRecTransLength(D_WorkRecord, D_WorkTransLen);
      $CALL( f_UnifyRetryInOtherFP_Sub
	    (D_WorkFPPtr, D_WorkEnvRecPtr, D_WorkTransLen, D_WorkLength));
      $RELEASE(D_WorkLength);
      $RELEASE(D_WorkTransLen);
      $RELEASE(D_WorkEnvRecPtr);
      $RELEASE(D_WorkFPPtr);
      
      s_ReclaimTransRec(D_WorkRecord);
      f_IfNotEmptyTransRecFreeListWaiting(){
	  $USE(D_WorkGoalPtr);
	  f_DequeueFromTransRecFreeListWaiting(D_WorkGoalPtr);
	  $USE(D_WorkPriority);
	  s_GetPriorityEnvGoalRecord(D_WorkGoalPtr, D_WorkPriority);
	  $CALL(f_PushGoalToStackWithPriority_Sub
		(D_WorkGoalPtr, D_WorkPriority));
	  $RELEASE(D_WorkPriority);
	  $RELEASE(D_WorkGoalPtr);
      }
      s_GetScsiTransRecNextPtr(D_WorkRecord, D_WorkRecord);
  }

  /*------------------------------------------------------------------
   (2) $B%P%98"%-%e!<$K$"$kF1$8(B Unit, LUN $B$K4X$9$kE>AwM=Ls$r%-%c%s%;%k$9$k(B
  --------------------------------------------------------------------*/
  f_DequeueTransRecFromBusFreeWaitingWithUnitAndLun
      (A_Unit, A_Lun, D_WorkRecord);
  b_IfNotEOL(D_WorkRecord){
      @DEBUG{
	  s_IfNotScsiTransRec(D_WorkRecord){
	      VPIM_ERROR("f_CancelReservedTransfer","Illegal-pointer-type");
	  }
      };
      $USE(D_WorkFPPtr);
      $USE(D_WorkEnvRecPtr);
      s_GetScsiTransRecFPPtr(D_WorkRecord, D_WorkFPPtr);
      s_GetScsiTransRecEnvironment(D_WorkRecord, D_WorkEnvRecPtr);

      $USE(D_WorkData);
      $USE(D_WorkNewData);
      s_GetScsiTransRecOldData(D_WorkRecord, D_WorkData); 
      s_GetScsiTransRecNewData(D_WorkRecord, D_WorkNewData);
      $CALL( f_UnifyRetryInOtherFP_Sub
	    (D_WorkFPPtr, D_WorkEnvRecPtr, D_WorkData, D_WorkNewData));
      $RELEASE(D_WorkNewData);
      $RELEASE(D_WorkData);

      $USE(D_Workreg);
      $USE(D_WorkResult);
      b_SetImmTypeValueMRBoff(ATOM, _ZERO, D_Workreg);
      s_GetScsiTransRecResult(D_WorkRecord, D_WorkResult);
      $CALL( f_UnifyRetryInOtherFP_Sub
	    (D_WorkFPPtr, D_WorkEnvRecPtr, D_Workreg, D_WorkResult));
      $RELEASE(D_WorkResult);
      $RELEASE(D_Workreg);
      
      $USE(D_WorkTransLen);
      $USE(D_WorkLength);
      b_SetImmTypeValueMRBoff(INT, _ZERO, D_WorkLength);
      s_GetScsiTransRecTransLength(D_WorkRecord, D_WorkTransLen);
      $CALL( f_UnifyRetryInOtherFP_Sub
	    (D_WorkFPPtr, D_WorkEnvRecPtr, D_WorkTransLen, D_WorkLength));
      $RELEASE(D_WorkLength);
      $RELEASE(D_WorkTransLen);
      $RELEASE(D_WorkEnvRecPtr);
      $RELEASE(D_WorkFPPtr);
      
      s_ReclaimTransRec(D_WorkRecord);
      f_IfNotEmptyTransRecFreeListWaiting(){
	  $USE(D_WorkGoalPtr);
	  f_DequeueFromTransRecFreeListWaiting(D_WorkGoalPtr);
	  $USE(D_WorkPriority);
	  s_GetPriorityEnvGoalRecord(D_WorkGoalPtr, D_WorkPriority);
	  $CALL(f_PushGoalToStackWithPriority_Sub
		(D_WorkGoalPtr, D_WorkPriority));
	  $RELEASE(D_WorkPriority);
	  $RELEASE(D_WorkGoalPtr);
      }
  }
  $RELEASE(D_WorkRecord);
  $RETURN();
}
