
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_scsi_tgt_command_transfer.psl.c
   ----- CREATED   : by f-doumae@icot22, on Tue Oct  2 17:02:10 1990
   ----- LAST SAVED: by f-takei@icot22, on Thu Nov  7 19:28:37 1991
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : $B%3%^%s%IE>Aw$N<B9T(B

  $B%3%^%s%I%U%'!<%:$N<B9T$r9T$&!#%$%K%7%(!<%?$NAw=P$9$k(BCDB$B$r<uNN$7!"E>Aw%l%3!<%I(B
  $B$K3JG<$9$k!#E>Aw%G!<%?D9$O!"AH9~$_=R8l$N0z?t$K;XDj$5$l$k$,!"%3%^%s%IE>Aw$N(B
  $B>l9g$O!"(BCDB$B$NBh(B1$B%P%$%HL\$K4^$^$l$k%0%k!<%W%3!<%I$K$h$jH=Dj$7!"(BCDB$BD9J,$NE>Aw$r(B
  $B9T$&!#<B:]$NE>AwNL$OE>Aw%l%3!<%IFb$N%9%m%C%H$K3JG<$9$k!#(B
  $B=hM}FbMF$O0J2<$NDL$j!#(B

  1.$B%"%F%s%7%g%s%3%s%G%#%7%g%s$H%j%;%C%H%3%s%G%#%7%g%s$N%A%'%C%/(B
    $B$3$N(B2$B$D$N>uBV$O$$$D$G$b5/$3$jF@$k$?$a!"E>Aw$N<B9TA0$K%A%'%C%/$r$78!=P$5$l(B
    $B$F$$$l$P$=$N=hM}$r9T$&!#(B
  2.$B%3%^%s%I%U%'!<%:$N<B9T5Z$SE>Aw(B
    $B%3%^%s%I%U%'!<%:$N<B9T!&E>Aw$O(B2$BCJ3,$K$o$+$l$k!#(B
    2-1.$BBh(B1$B%P%$%HL\$N<uNN!#(B
        $B!&(BCDB$B$NBh(B1$B%P%$%HL\$r(BSPC$B$N%^%K%e%"%kE>Aw%b!<%I$GFI$_=P$9!#(B
        $B!&%0%k!<%W%3!<%I(B($B>e0L(B3$B%S%C%H(B)$B$+$i(BCDB$BD9$r5a$a$k!#(B
    2-2.$BBh(B2$B%P%$%HL\0J9_$N<uNN!#(B
        $B!&(B2-1$B$G5a$a$?(BCDB$BD9$K$h$j(BSPC$B$N(BTransfer$B%3%^%s%I$rMQ$$$F;D$j$N(BN$B%P%$%H$N(B
          $B<uNN$r9T$&!#(B
  3.$BE>Aw=*N;8e$N=hM}(B
    Transfer$B%3%^%s%I$N<B9T7k2L$O3d$j9~$_$K$h$C$FH=Dj$9$k!#$^$?!"2?$i$+$N%(%i!<(B
    $B$,8!=P$5$l$?>l9g$K$O!"%(%i!<$N>pJs$r%3%^%s%I%l%3!<%IFb$NNN0h$K%;%C%H$7$F!"(B
    $B%(%i!<%O%s%I%j%s%0$N%k!<%A%s$N8F$S=P$7$r9T$&!#@5>o$K=*N;$7$?>l9g$K$O!"7k2L(B
    $BJs9p$N=hM}$X@)8f$r0\$9!#(B
    $B3d$j9~$_$NFbMF$H=hM}$O0J2<$NDL$j!#(B

    A.Command Complete$B3d$j9~$_(B
      Transfer$B%3%^%s%I$N=*N;!#%(%i!<$N>uBV$K$h$C$F0J2<$N$h$&$K$o$+$l$k!#(B
        a.$B%(%i!<$,8!=P$5$l$J$+$C$?>l9g!#(B
         $BE>Aw$N@5>o=*N;!#7k2LJs9p$N=hM}$X0\$k!#(B
        b.$B%"%F%s%7%g%s%3%s%G%#%7%g%s$,8!=P$5$l$?>l9g!#(B
        c.$BE>Aw%G!<%?$K%Q%j%F%#%(%i!<$,8!=P$5$l$?>l9g!#(B
      b, c$B$N>l9g$O!"%(%i!<%O%s%I%j%s%0$N%k!<%A%s$r8F$S$@$78e=hM}$r9T$&!#(B
    B.Service Required$B3d$j9~$_$,8!=P$5$l$?>l9g!#(B
      $B%"%F%s%7%g%s%3%s%G%#%7%g%s$N8!=P!#(B
      (SPC$B%l%8%9%?(BSCMD.bit0:Termination Mode='1'$B$N;~(B)
      $B!&(BTransfer$B%3%^%s%I$,=*N;$7$F$$$J$$>l9g$,$"$k$N$G!"(BSPC$B$K(BTransfer Pause
        $B%3%^%s%I$rH/9T$7$F(BTransfer$B%3%^%s%I$r=*N;$5$;$k!#(B
      $B!&%(%i!<$N>uBV$K$h$C$F0J2<$N$h$&$K$o$+$l$k!#(B
          a.$BB>$K%(%i!<$,8!=P$5$l$J$+$C$?>l9g!#(B
          b.$BE>Aw%G!<%?$K%Q%j%F%#%(%i!<$,8!=P$5$l$?>l9g!#(B
        $B$$$:$l$N>l9g$b%(%i!<%O%s%I%j%s%0$N%k!<%A%s$r8F$S$@$78e$N=hM}$r9T$&!#(B
    C.SPC Hardware Error$B3d$j9~$_$,8!=P$5$l$?>l9g!#(B
      $B!&(BTransfer$B%3%^%s%I$,=*N;$7$F$$$J$$>l9g$,$"$k$N$G!"(BSPC$B$K(BTransfer Pause
        $B%3%^%s%I$rH/9T$7$F(BTransfer$B%3%^%s%I$r=*N;$5$;$k!#(B
      $B!&%(%i!<%O%s%I%j%s%0MQ$N%k!<%A%s$r8F$S$@$78e$N=hM}$r9T$&!#(B
    D.Reset Condition$B3d$j9~$_$,8!=P$5$l$?>l9g!#(B
      $B!&%j%;%C%H%3%s%G%#%7%g%s;~$N=hM}$K0\$k!#(B

<Revised Memo on "Jul  3">
  $BE>Aw=*N;8e$N3d$j9~$_8!=P(B
    E.Selected, Reselected, Time Out
      Fatal Error $B$H$7$F8!=P;~$N=hM}$K0\$k!#(B
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

#SUBARG_define A_TransRec  SRC
#SUBARG_define A_Phase     DST

#SUBROUTINE f_ScsiTargetCommandTransfer_Sub(A_TransRec, A_Phase)
{
    /*--- Service Required, Reset Condition $B3d$j9~$_$N%A%'%C%/(B---*/
    b_IfScsiAnyInterrupt(){
	f_ScsiTargetInterruptCheck(A_TransRec, A_Phase);
	goto END;
    }

    $USE(D_WorkData);
    $USE(D_WorkDataPtr);
    s_GetScsiTransRecPtrToDataBuff(A_TransRec, D_WorkDataPtr);
    /* $B%G!<%?%P%C%U%!$X$N%]%$%s%?$r$H$C$F$/$k(B */
    b_SetScsiPhaseCommand(); 
    b_ScsiTargetReceiveDataByManual(D_WorkData);
    /* manual $B$G(B1byte $B<uNN(B */
    b_IfScsiParityError(){
	$RELEASE(D_WorkData);
	$RELEASE(D_WorkDataPtr);
	f_ScsiTargetParityErrorHandlingInput(A_TransRec, A_Phase);
	goto END;
    }
    $USE(D_WorkDataCtr1);
    s_GetScsiTransRecDataPos(A_TransRec, D_WorkDataCtr1);
    $USE(D_WorkDataCtr2);
    p_MoveWord(D_WorkDataCtr1, D_WorkDataCtr2);
    s_WriteByteData(D_WorkData, D_WorkDataPtr, D_WorkDataCtr1);
    /* CDB$B$rE>Aw%l%3!<%I$N%G!<%?%P%C%U%!$K3JG<$9$k(B */
    b_IncrementReg(D_WorkDataCtr1);
    $USE(D_WorkDataLen);
    s_GetScsiCDBLength(D_WorkData, D_WorkDataLen);
    /* CDB $B$h$j%3%^%s%ID9$r<h$j=P$9(B */
    /* $B%3%^%s%I$N:GBgD9$N%A%'%C%/(B : $BJ]N1(B */
    $RELEASE(D_WorkData);
    b_IfEqual(D_NULL, D_WorkDataLen){
	s_SetResultCodeTransRecError(_INVALID_CDB_LEN, A_TransRec);
	$CALL(f_ScsiTargetErrorEnd_Sub(A_TransRec));
	$RELEASE(D_WorkDataLen); $RELEASE(D_WorkDataPtr);
	$RELEASE(D_WorkDataCtr1); $RELEASE(D_WorkDataCtr2);
	b_SetImmValueDNTC(_TARGET_TERMINATE, A_Phase);
	goto END;
    }
    b_DecrementReg(D_WorkDataLen); /* $BBh(B1$B%P%$%HL\$NJ,$r=|$/(B */
    b_TargetTransferCommandCommand(D_WorkDataLen);
    LOOP(){
	b_IfSPCBusy(){break;}
	b_IfScsiAnyInterrupt(){
	    $RELEASE(D_WorkDataLen); $RELEASE(D_WorkDataPtr);
	    $RELEASE(D_WorkDataCtr1); $RELEASE(D_WorkDataCtr2);
	    goto Transfer_End;
	}
    }
    s_ScsiTargetReceiveData(D_WorkDataPtr, D_WorkDataCtr1, D_WorkDataLen);
        /* $B3d$j9~$_$,$+$+$C$?$i=*N;$9$k(B */
    $RELEASE(D_WorkDataLen);
    s_ModifyScsiTransRecDataCounter
	                (A_TransRec, D_WorkDataCtr2, D_WorkDataCtr1);
    $RELEASE(D_WorkDataPtr);
    $RELEASE(D_WorkDataCtr2);
    $RELEASE(D_WorkDataCtr1);

  Transfer_End:
    $USE(D_WorkInterrupt);
    b_GetScsiInterrupt(D_WorkInterrupt);
    /* Transfer $B%3%^%s%I$N=*N;H=Dj(B */
    b_IfScsiInterruptResetCondition(D_WorkInterrupt){
	$RELEASE(D_WorkInterrupt);
	b_SetImmValueDNTC(_ERROR_END, A_Phase);
	goto END;
    }
    b_IfScsiInterruptSPCHardwareError(D_WorkInterrupt){
	/* $B%O!<%I%&%(%"%(%i!<8!=P(B */
	$RELEASE(D_WorkInterrupt);
	f_ScsiTargetIntrHardwareErrorHandlingInput(A_TransRec, A_Phase);
	goto END;
    }
    b_IfScsiInterruptCommandComplete(D_WorkInterrupt){
	$RELEASE(D_WorkInterrupt);
	f_ScsiTargetIntrCommandCompleteHandlingInput(A_TransRec, A_Phase);
	goto END;
    }
    b_IfScsiInterruptServiceRequired(D_WorkInterrupt){
	/* $B%"%F%s%7%g%s%3%s%G%#%7%g%s8!=P(B */
	$RELEASE(D_WorkInterrupt);
	f_ScsiTargetIntrServiceRequiredHandlingInput(A_TransRec, A_Phase);
	goto END;
    }
    /* Fatal Error */
    b_SetImmValueDNTC(_FATAL_ERROR_END, A_Phase);
    @DEBUG{
	b_IfScsiInterruptSelected(D_WorkInterrupt){
	    ;
	}else{
	    b_IfScsiInterruptReselected(D_WorkInterrupt){
		;
	    }else{
		b_IfScsiInterruptTimeOut(D_WorkInterrupt){
		    ;
		}else{
		    VPIM_ERROR("f_ScsiTargetCommandTransfer_Sub",
			       "trouble in spc?");
		}
	    }
	}
    };
    $RELEASE(D_WorkInterrupt);

  END:
    $RETURN();
}

