
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_scsi_reset_condition_handler.psl.c
   ----- CREATED   : by f-takei@icot22, on Wed Nov 21 14:24:59 1990
   ----- LAST SAVED: by f-takei@icot22, on Sat Jan 11 20:55:10 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : function
   ----- ABSTRACT  : SCSI $B%I%i%$%P$N%j%;%C%H(B

  1.$B%j%;%C%H%3%s%G%#%7%g%s8!=P$K$h$k%j%;%C%H(B
    f_ScsiResetConditionHandling_Sub
  2.$B0[>o$J3d$j9~$_$N8!=P$K$h$k%j%;%C%H(B
    f_ScsiFatalErrorEnd_Sub
  3.$BM=LsA`:n$K$D$$$F$N%j%;%C%H=hM}(B
    f_ScsiResultReport
  4.$B0[>o$J3d$j9~$_8!=P$NDLCN(B
    f_ScsiInterruptedReprt_Sub
  5.$B0[>o$r8!=P$7$?%3%M%/%7%g%s$N5-O?%F!<%V%k$N%j%;%C%H(B
    f_ResetScsiErrDetectedConnectionList
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */
/******************************************************************** PSL **
  1.$B%j%;%C%H%3%s%G%#%7%g%s8!=P$K$h$k%j%;%C%H(B
    f_ScsiResetConditionHandling_Sub(A_Int, A_Rec)

       written by f-doumae@icot22      on Wed Nov 28 17:55:15 1990
       revised by f-takei@icot22      on Fri Jul  5 19:29:50 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
    A_Rec $B$K$O%j%;%C%H%3%s%G%#%7%g%s$,8!=P$5$l$?;~$N%3%^%s%I%l%3!<%I!"(B
    $B$^$?$OE>Aw%l%3!<%I$X$N%]%$%s%?$,$N$C$F$$$k!#(B
    $B$"$k$$$O!"(BD_NULL $B$,$N$C$F$$$k!#(B
<Function>
    1. A_Rec $B$N;X$9%3%^%s%I%l%3!<%I!"$^$?$OE>Aw%l%3!<%I$N7k2LJs9p$r9T$J$&!#(B
    2. $BM=Ls%-%e!<!"%P%98"%-%e!<$K$"$k<B9TA0$N%3%^%s%I%l%3!<%I!"$^$?$O(B
       $BE>Aw%l%3!<%I$K$D$$$F7k2LJs9p$r9T$J$&!#(B
    3. $B<B9TCf%j%9%H$K$"$k<B9TCf$N%3%^%s%I%l%3!<%I$K$D$$$F7k2LJs9p$r9T$J$&!#(B

    $B7k2LJs9p$r9T$J$$%l%3!<%I$r%U%j!<%j%9%H$KLa$9;~!"%U%j!<%j%9%HBT$A$N(B
    D$B%3!<%I%4!<%k$,B8:_$9$k;~$O$=$l$r%9%1%8%e!<%j%s%0%-%e!<$KF~$l$k!#(B
<Examples>
<Test>
<Explanation>
    $B%j%;%C%H%3%s%G%#%7%g%s8!=P;~$O!"<B9TCf$N%3%^%s%I!&E>Aw!"$*$h$S(B
    $B$9$Y$F$NM=LsA`:n$r%(%i!<=*N;$H$9$k!#(B
<ETC>
<Revised Memo on "Jul  5">
    $B!&(B1 $B!A(B 3 $B$N=hM}$O!"(Bf_ScsiResultReport $B$K$h$C$F5-=R$5$l$F$$$k!#(B
    $B!&(BA_Rec $B$K(B D_NULL $B$,$N$C$F$*$j!"$+$DM=LsA`:n$,B>$KA4$/$J$$>l9g!"(B
      f_ScsiInterruptedReport_Sub $B$K$h$C$F(B KL1 $B$KDLCN$9$k!#(B
********************************************************************* PSL **/
#DATA_define D_WorkRec  XXX

#SUBARG_define A_Rec SRC

#SUBROUTINE f_ScsiResetConditionHandling_Sub(A_Rec)
{
    b_IfEqual(A_Rec, D_NULL){
	f_IfScsiEmptyAllQueues(){
	    $USE(D_Workreg);
	    b_SetImmTypeValueMRBoff(INT, _SPC_INTS_RESET_CONDITION, D_Workreg);
	    $CALL(f_ScsiInterruptedReport_Sub(D_Workreg));
	    $RELEASE(D_Workreg);
	    goto END;
	}
    }

    f_ScsiResultReport(_RESET_CONDITION_DETECTED, A_Rec);

 END:
  b_BusyWaitScsiRSTOff();
  b_ResetScsiInterruptResetCondition();
  f_InitializeSPC();	/* SPC $B$N=i4|2=(B */
  $RETURN();
}

/******************************************************************** PSL **
  2.$B0[>o$J3d$j9~$_$N8!=P$K$h$k%j%;%C%H(B
    f_ScsiFatalErrorEnd_Sub(A_Int, A_Rec)

       written by f-takei@icot22      on Wed Jul  3 21:34:55 1991
<Arguments>
    A_Int
    A_Rec
<Temporally Used Variables>
<Level>
<PreCondition>
    A_Int $B$K$O3d$j9~$_$rI=$9%3!<%I!"$"$k$$$O(B D_NULL $B$,$N$C$F$$$k!#(B
    A_Rec $B$K$O(B A_Int $B$GI=$5$l$k3d$j9~$_$,8!=P$5$l$?;~$N%3%^%s%I%l%3!<%I!"(B
    $B$^$?$OE>Aw%l%3!<%I!"$"$k$$$O(B D_NULL $B$,$N$C$F$$$k!#(B
<Function>
    A_Rec $B$K(B D_NULL $B$,$N$C$F$*$j!"$+$DM=LsA`:n$,B>$KA4$/$J$$>l9g!"(B
    f_ScsiInterruptedReport_Sub $B$K$h$C$F(B KL1 $B$KDLCN$9$k!#(B
    $B$=$&$G$J$$>l9g$O!"<!$N(B1 $B!A(B 3 $B$N=hM}$r(B f_ScsiResultReport $B$K$h$C$F(B
    $B5-=R$5$l$F$$$k!#(B
    1. A_Rec $B$N;X$9%3%^%s%I%l%3!<%I!"$^$?$OE>Aw%l%3!<%I$N7k2LJs9p$r9T$J$&!#(B
    2. $BM=Ls%-%e!<!"%P%98"%-%e!<$K$"$k<B9TA0$N%3%^%s%I%l%3!<%I!"$^$?$O(B
       $BE>Aw%l%3!<%I$K$D$$$F7k2LJs9p$r9T$J$&!#(B
    3. $B<B9TCf%j%9%H$K$"$k<B9TCf$N%3%^%s%I%l%3!<%I$K$D$$$F7k2LJs9p$r9T$J$&!#(B

    $B7k2LJs9p$r9T$J$$%l%3!<%I$r%U%j!<%j%9%H$KLa$9;~!"%U%j!<%j%9%HBT$A$N(B
    D$B%3!<%I%4!<%k$,B8:_$9$k;~$O$=$l$r%9%1%8%e!<%j%s%0%-%e!<$KF~$l$k!#(B
<Examples>
<Test>
<Explanation>
    $BM=LsA`:n$N<B9TCf$"$k$$$O%9%j%C%H%A%'%C%/;~$K!"@5>oF0:n$G$O9M$($i$l$J$$(B
    $B$h$&$J(B SPC $B$N3d$j9~$_$r8!=P$9$k2DG=@-$,$"$k!#$=$N>l9g$K!"$3$N%k!<%A%s(B
    $B$K$h$C$F(B KL1 $B$XDLCN$9$k!#M=LsA`:n$,$"$l$P$9$Y$F%(%i!<=*N;$H$7$F(B KL1 
    $B$XJV$9!#(B
<ETC>
********************************************************************* PSL **/

#SUBARG_define A_Int SRC
#SUBARG_define A_Rec SRC

#SUBROUTINE f_ScsiFatalErrorEnd_Sub(A_Int, A_Rec)
{
    b_IfEqual(A_Rec, D_NULL){
	f_IfScsiEmptyAllQueues(){
	    $CALL(f_ScsiInterruptedReport_Sub(A_Int));
	    goto END;
	}
    }

    f_ScsiResultReport(_SCSI_FATAL_ERROR, A_Rec);

  END:
    b_ScsiSPCResetAndDisable();		/* SPC $B%A%C%W$N%j%;%C%H(B */
    f_InitializeSPC();			/* SPC $B$N=i4|2=(B */
    $RETURN();
}

/******************************************************************** PSL **
  3.$BM=LsA`:n$K$D$$$F$N%j%;%C%H=hM}(B
    f_ScsiResultReport(imm_error, rec_ptr_reg)

       written by f-takei@icot22      on Fri Jul  5 20:12:05 1991
<Arguments>
    imm_error
    rec_ptr_reg
<Temporally Used Variables>
<Level>
<PreCondition>
    rec_ptr_reg $B$K$O%3%^%s%I%l%3!<%I!"$^$?$OE>Aw%l%3!<%I$X$N%]%$%s%?$,(B
    $B$N$C$F$$$k!#(B
    imm_error $B$O%(%i!<%3!<%I$rI=$9B(CM!#(B
<Function>
    1. rec_ptr_reg $B$N;X$9%3%^%s%I%l%3!<%I!"$^$?$OE>Aw%l%3!<%I$N7k2LJs9p$r(B
       $B9T$J$&!#(B
    2. $BM=Ls%-%e!<!"%P%98"%-%e!<$K$"$k<B9TA0$N%3%^%s%I%l%3!<%I!"$^$?$O(B
       $BE>Aw%l%3!<%I$K$D$$$F7k2LJs9p$r9T$J$&!#(B
    3. $B<B9TCf%j%9%H$K$"$k<B9TCf$N%3%^%s%I%l%3!<%I$K$D$$$F7k2LJs9p$r9T$J$&!#(B

    $B$J$*!"%(%i!<%3!<%I$O(B imm_error $B$K$h$C$FM?$($i$l$k!#(B

    $B7k2LJs9p$r9T$J$$%l%3!<%I$r%U%j!<%j%9%H$KLa$9;~!"%U%j!<%j%9%HBT$A$N(B
    D$B%3!<%I%4!<%k$,B8:_$9$k;~$O$=$l$r%9%1%8%e!<%j%s%0%-%e!<$KF~$l$k!#(B
<Examples>
<Test>
<Explanation>
    VPIM-SCSI $B%I%i%$%P$N%j%;%C%H$r9T$&>l9g$KMQ$$$k!#(B
    $B8=:_$O!"(Bf_ScsiResetConditionHandling_Sub, f_ScsiFatalErrorEnd_Sub
    $B$G$N$_MQ$$$i$l$k!#(B
<ETC>
********************************************************************* PSL **/

#PSL_define f_ScsiResultReport(imm_error, rec_ptr_reg)
{
    s_IfScsiCommRec(rec_ptr_reg){/* rec_ptr_reg $B$,%3%^%s%I%l%3!<%I$N>l9g(B */
	s_OrResultCodeCommRec(_SCSI_ERROR_END, rec_ptr_reg);
	/* $B40N;>uBV%U%i%0$r@_Dj$9$k(B */
	s_OrErrorCodeCommRec(imm_error, rec_ptr_reg);
	/* $B%(%i!<%3!<%I$r@_Dj$9$k(B */
	$CALL( f_ScsiInitiatorResultReport_Sub(rec_ptr_reg));

	s_ReclaimCommRec(rec_ptr_reg); /* $B%U%j!<%j%9%H$KLa$9!#(B*/
	f_IfNotEmptyCommRecFreeListWaiting(){
	    $USE(D_WorkGoalPtr);
	    f_DequeueFromCommRecFreeListWaiting(D_WorkGoalPtr);
	    $USE(D_WorkPriority);
	    s_GetPriorityEnvGoalRecord(D_WorkGoalPtr, D_WorkPriority);
	    $CALL(f_PushGoalToStackWithPriority_Sub
		  (D_WorkGoalPtr, D_WorkPriority));
	    $RELEASE(D_WorkPriority);
	    $RELEASE(D_WorkGoalPtr);
	}
    }else{ /* rec_ptr_reg $B$,E>Aw%l%3!<%I$N>l9g(B */
	s_IfScsiTransRec(rec_ptr_reg){
	    s_OrResultCodeTransRecError(imm_error, rec_ptr_reg);
	    /* $B0[>o=*N;;~$N%(%i!<%3!<%I$r@_Dj$9$k(B */
	    $CALL( f_ScsiTargetResultReport_Sub(rec_ptr_reg));

	    s_ReclaimTransRec(rec_ptr_reg); /* $B%U%j!<%j%9%H$KLa$9!#(B*/
	    f_IfNotEmptyTransRecFreeListWaiting(){
		$USE(D_WorkGoalPtr);
		f_DequeueFromTransRecFreeListWaiting(D_WorkGoalPtr);
		$USE(D_WorkPriority);
		s_GetPriorityEnvGoalRecord(D_WorkGoalPtr, D_WorkPriority);
		$CALL(f_PushGoalToStackWithPriority_Sub
		      (D_WorkGoalPtr, D_WorkPriority));
		$RELEASE(D_WorkPriority);
		$RELEASE(D_WorkGoalPtr);
	    }
	}else{
	    b_IfNotEqual(D_NULL, rec_ptr_reg){
		@DEBUG{
		    VPIM_ERROR("f_ScsiResetConditionHandling_Sub",
			       "Illegal Pointer");
		};
	    }
	}
    }
      
/*---------------------------------------------------------------------
  1. $BM=Ls%-%e!<(B,$B%P%98"%-%e!<$NCf$K$"$kA4$F$N%3%^%s%I(B,$B5Z$SE>Aw%l%3!<%I$r(B
     $B%-%c%s%;%k$9$k!#(B
 ----------------------------------------------------------------------*/
    LOOP(){
	$USE(D_WorkRec);
	f_IfNotEmptyReserv(){
	    f_DequeueFromReserv(D_WorkRec);
	}else{
	    f_IfNotEmptyBusFreeWaiting(){
		f_DequeueFromBusFreeWaiting(D_WorkRec);
	    }else{
		$RELEASE(D_WorkRec);
		break; 
	    }
	}
	s_IfScsiCommRec(D_WorkRec){
	    s_OrResultCodeCommRec(_CANCELED_BEFORE_EXEC, D_WorkRec);
	    /* $B40N;>uBV%U%i%0$r@_Dj$9$k!#(B */
	    s_OrErrorCodeCommRec(imm_error, rec_ptr_reg);
	    /* $B%(%i!<%3!<%I$r@_Dj$9$k(B */
	    $CALL( f_ScsiInitiatorResultReport_Sub(D_WorkRec));

	    s_ReclaimCommRec(D_WorkRec); /* $B%U%j!<%j%9%H$KLa$9!#(B*/
	    $RELEASE(D_WorkRec);

	    f_IfNotEmptyCommRecFreeListWaiting(){
		$USE(D_WorkGoalPtr);
		f_DequeueFromCommRecFreeListWaiting(D_WorkGoalPtr);
		$USE(D_WorkPriority);
		s_GetPriorityEnvGoalRecord(D_WorkGoalPtr, D_WorkPriority);
		$CALL(f_PushGoalToStackWithPriority_Sub
		      (D_WorkGoalPtr, D_WorkPriority));
		$RELEASE(D_WorkPriority);
		$RELEASE(D_WorkGoalPtr);
	    }
	}else{
	    s_IfScsiTransRec(D_WorkRec){
		s_SetResultCodeTransRecError
		    (imm_error, D_WorkRec);
		/* $B0[>o=*N;;~$N%(%i!<%3!<%I$r@_Dj$9$k(B */
		$CALL( f_ScsiTargetResultReport_Sub(D_WorkRec));

		s_ReclaimTransRec(D_WorkRec); /* $B%U%j!<%j%9%H$KLa$9!#(B*/
		$RELEASE(D_WorkRec);
		f_IfNotEmptyTransRecFreeListWaiting(){
		    $USE(D_WorkGoalPtr);
		    f_DequeueFromTransRecFreeListWaiting(D_WorkGoalPtr);
		    $USE(D_WorkPriority);
		    s_GetPriorityEnvGoalRecord(D_WorkGoalPtr, D_WorkPriority);
		    $CALL(f_PushGoalToStackWithPriority_Sub
			  (D_WorkGoalPtr, D_WorkPriority));
		    $RELEASE(D_WorkPriority);
		    $RELEASE(D_WorkGoalPtr);
		}
	    }else{
		@DEBUG{
		    VPIM_ERROR("f_ScsiResetConditionHandling_Sub",
			       "Illegal pointer");
		};
	    }
	}
    }

/*---------------------------------------------------------------------
  2. $B<B9TCf%j%9%H$NCf$K$"$kA4$F$N%3%^%s%I%l%3!<%I$r%-%c%s%;%k$9$k!#(B
 ----------------------------------------------------------------------*/
    LOOP(){
	$USE(D_WorkRec);
	f_IfNotEmptyExecutingList(){
	    f_DequeueFromExecutingList(D_WorkRec);
	}else{
	    $RELEASE(D_WorkRec);
	    break; 
	}
	@DEBUG{
	    s_IfNotScsiCommRec(D_WorkRec){
		VPIM_ERROR("f_ScsiResetConditionHandling_Sub",
			   "Illegal pointer");
	    }
	};
	s_OrResultCodeCommRec(_CANCELED_AFTER_EXEC, D_WorkRec);
	/* $B%3%^%s%I40N;A0$N%-%c%s%;%k$K$h$k40N;>uBV%U%i%0$r%;%C%H$9$k!#(B*/
	s_IfScsiCommRecCanceled(D_WorkRec){
	    ;
	}else{
	    s_OrErrorCodeCommRec(imm_error, D_WorkRec);
	    /* $B%(%i!<%3!<%I$r@_Dj$9$k(B */
	}
	$CALL( f_ScsiInitiatorResultReport_Sub(D_WorkRec));

	s_ReclaimCommRec(D_WorkRec); /* $B%U%j!<%j%9%H$KLa$9!#(B*/
	$RELEASE(D_WorkRec);
	f_IfNotEmptyCommRecFreeListWaiting(){
	    $USE(D_WorkGoalPtr);
	    f_DequeueFromCommRecFreeListWaiting(D_WorkGoalPtr);
	    $USE(D_WorkPriority);
	    s_GetPriorityEnvGoalRecord(D_WorkGoalPtr, D_WorkPriority);
	    $CALL(f_PushGoalToStackWithPriority_Sub
		  (D_WorkGoalPtr, D_WorkPriority));
	    $RELEASE(D_WorkPriority);
	    $RELEASE(D_WorkGoalPtr);
	}
    }
    f_ResetScsiErrDetectedConnectionList();
    /* $B%(%i!<$r8!=P$7$?%3%M%/%7%g%s$N5-O?%F!<%V%k$r%j%;%C%H(B($B>C5n(B)$B$9$k!#(B*/
}

/******************************************************************** PSL **
  4.$B0[>o$J3d$j9~$_8!=P$NDLCN(B
    f_ScsiInterruptedReprt_Sub(A_Int)

       written by f-takei@icot22      on Fri Jul  5 20:49:13 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
    A_Int $B$K$O3d$j9~$_$rI=$9%3!<%I$,$N$C$F$$$k!#(B
<Function>
    $B0[>o$J3d$j9~$_$rDLCN$9$k%9%H%j!<%`$K%a%C%;!<%8%3!<%I$rN.$9!#(B
<Examples>
<Test>
<Explanation>
    VPIM-SCSI $B%I%i%$%P$G8!=P$7$?%(%i!<$O!"DL>oAH9~=R8l$N=PNO0z?t$K$h$C$F(B
    KL1 $B$XDLCN$9$k$,!"M=LsA`:n$,$J$$>uBV$G$O$=$l$O$G$-$J$$!#$=$N>l9g$K$O!"(B
    $B$3$N3d$j9~$_DLCN%9%H%j!<%`$K%a%C%;!<%8%3!<%I$rN.$9$3$H$K$h$C$F!"(BKL1
    $B$KDLCN$9$k!#(B
<ETC>
********************************************************************* PSL **/

#SUBARG_define A_Int SRC

#SUBROUTINE f_ScsiInterruptedReport_Sub(A_Int)
{
    $USE(D_WorkData);
    s_AllocList(D_WorkData);
    b_SetImmTypeMRBoff(INT, A_Int);
    p_WriteWithOffset(A_Int, D_WorkData, _CAR_OFST_LIST);
    $USE(D_WorkData1);
    s_AllocVariable(D_WorkData1);
    p_WriteWithOffset(D_WorkData1, D_WorkData, _CDR_OFST_LIST);

    $USE(D_WorkEnvRecPtr);
    s_AllocNonDebugEnvRecord(D_WorkEnvRecPtr);
    $USE(D_WorkPriority);
    b_SetImmTypeValueMRBoff(INT, _MAX_LOGICAL_PRIO, D_WorkPriority);
    s_PutPriorityEnvRecord(D_WorkEnvRecPtr, D_WorkPriority);
    $RELEASE(D_WorkPriority);
    s_PutImmAttributeEnvRecord(D_WorkEnvRecPtr, _RESIDENT_PE);
    $USE(D_WorkFPPtr);
    b_SetImmTypeValueMRBoff
	(FPREC, _DUMMY_FOSTER_PARENT_AREA_BASE, D_WorkFPPtr); 
    $CALL(f_UnifyRetryInOtherFP_Sub
	  (D_WorkFPPtr, D_WorkEnvRecPtr, D_WorkData, D_ScsiInterruptStr));
    $RELEASE(D_WorkFPPtr);
    $RELEASE(D_WorkEnvRecPtr);

    p_MoveWord(D_WorkData1, D_ScsiInterruptStr);
    $RELEASE(D_WorkData1);
    $RELEASE(D_WorkData);
    $RETURN();
}

/******************************************************************** PSL **
  5.$B0[>o$r8!=P$7$?%3%M%/%7%g%s$N5-O?%F!<%V%k$N%j%;%C%H(B
    f_ResetScsiErrDetectedConnectionList()

       written by f-takei@icot22      on Fri Jul  5 21:01:36 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    $B0[>o$r8!=P$7$?%3%M%/%7%g%s$N5-O?%F!<%V%k$r%j%;%C%H$9$k!#(B
    $B%F!<%V%k$N%j%s%/$r$?$I$C$F%l%3!<%I(B(4 word $B%Y%/%?(B)$B$r2s<}$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define f_ResetScsiErrDetectedConnectionList()
{
    f_IfNotEmptyErrDetectedConnectionList(){
	$USE(D_Workreg);
	LOOP(){
	    b_PopLink(D_Workreg, D_ScsiErrDetectedConnectionListTop,
		      _SCSI_RECORD_NEXT_OFST);
	    b_IfNotEOL(D_Workreg){
		s_ReclaimVect4(D_Workreg);
	    }else{
		break;
	    }
	}
	$RELEASE(D_Workreg);
    }
}
