
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_scsi_queue.psl.c
   ----- CREATED   : by f-doumae@icot22, on Wed Sep 19 14:44:09 1990
   ----- LAST SAVED: by f-takei@icot22, on Sat Jan 11 20:46:19 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : $B%-%e!<(B,$B%F!<%V%k4IM}A`:n(B

$B!&(B $BM=Ls%-%e!<(B
    $B%3%^%s%IM=Ls!"E>AwM=Ls$r5-O?$9$k$?$a$N%-%e!<!#$3$3$K$OF1$8%f%K%C%H!"(BLUN$B$K(B
    $B4X$9$k%3%^%s%I$^$?$OE>Aw$,8=:_=hM}Cf(B($B%P%98"%-%e!<!"<B9TCf%j%9%H$KB8:_$9$k(B)
    $B$G$"$k$?$a$^$@<B9T$K$OF~$l$J$$$h$&$J%3%^%s%I!"E>Aw$K4X$9$k%l%3!<%I$,F~$k!#(B
    $BAPJ}8~%j%9%H$G4IM}$9$k!#(B

$B!&(B $B%P%98"%-%e!<(B
    $BM=Ls:Q$_$N%3%^%s%I$*$h$SE>Aw$N$&$A!"%P%9$5$($H$l$l$P<B9T3+;O2DG=$G$"$k$,!"(B
    $B%P%9$N3MF@$rBT$C$F$$$k$b$N$N%-%e!<!#(B
    $BAPJ}8~%j%9%H$G4IM}$9$k!#(B

$B!&(B $B<B9TCf%j%9%H(B
    $B8=:_<B9TCf$G$"$k$,%G%#%9%3%M%/%H>uBV$G$"$k%3%^%s%I$rEPO?$9$k%F!<%V%k!#(B
    $BAPJ}8~%j%9%H$G4IM}$9$k!#(B

$B!&(B $B8e=hM}%-%e!<(B  
    GC$BCf$N3d$j9~$_=hM}(B($B%j%;%l%/%H(B)$B$G<B9T$,=*N;$7$?%3%^%s%I$K$D$$$F=*N;(B
    $B8e$N=hM}$,(BGC$B$N$?$aB(:B$K<B9T$G$-$J$$$b$N$K4X$9$k%l%3!<%I$r5-O?$9$k%-%e!<!#(B
    PIM$B$r%?!<%2%C%H$H$7$FF0:n$5$;$?>l9g!"%$%K%7%(!<%?$+$i%;%l%/%H$5$l$k$H$$$&(B
    $B;v>]$OHsF14|$K(BGC$BCf$K$b5/$3$jF@$k!#$=$N>l9g!"%P%9$rAa4|$K3+J|$9$k$?$a$K(BGC
    $BCf$G$bB(:B$KBP1~$7!"(BGC$B8e$K(BKL1$B%W%m%0%i%`$K$3$N%;%l%/%7%g%s$rDLCN$G$-$k$h$&(B
    $B%;%l%/%7%g%s%l%3!<%I$H$7$F3d$j9~$_$r5-21$78e=hM}%-%e!<$KF~$l$F$*$/!#(B

$B!&%3%^%s%I%l%3!<%I$N%U%j!<%j%9%HBT$A%-%e!<(B
    $B%3%^%s%I%l%3!<%I$N%U%j!<%j%9%H$,6u$G<B9T$G$-$J$$(Bscsi_command$BAH$_9~$_=R8l(B
    $B$r(BD$B%3!<%I%4!<%k$H$7$F$3$3$KF~$l$FCV$/!#(B

$B!&E>Aw%l%3!<%I$N%U%j!<%j%9%HBT$A%-%e!<(B
    $BE>Aw%l%3!<%I$N%U%j!<%j%9%H$,6u$G<B9T$G$-$J$$(Bscsi_transfer$BAH$_9~$_=R8l$r(B
    D$B%3!<%I%4!<%k$H$7$F$3$3$KF~$l$FCV$/!#(B

$B!&%(%i!<$r8!=P$7$?%3%M%/%7%g%s%j%9%H(B
    $BE>Aw$,%"%F%s%7%g%s$dB>$N0[>o$G@5>o=*N;$7$J$+$C$?>l9g!"%$%K%7%(!<%?B&(B
    $B%f%K%C%HHV9f$H%?!<%2%C%HB&O@M}%f%K%C%HHV9f$NBP$r$3$3$K5-O?$7$F$*$/!#(B

1.  $B%l%3!<%I$N%(%s%-%e!<!"%G%-%e!<(B
2.  $BM=Ls%-%e!<$NA`:n(B
3.  $B%P%98"%-%e!<$NA`:n(B
4.  $B<B9TCf%j%9%H$NA`:n(B
5.  $B8e=hM}%-%e!<$NA`:n(B  
6.  $B%(%i!<$r8!=P$7$?%3%M%/%7%g%s$N%j%9%H$NA`:n(B
7.  $B%3%^%s%I(B($BE>Aw(B)$B%l%3!<%I$N%U%j!<%j%9%HBT$A%-%e!<$NA`:n(B
8.  $B%3%^%s%I(B($BE>Aw(B)$B=*N;;~$N?7$7$$%3%^%s%I(B($BE>Aw(B)$B%l%3!<%I$N<h$j=P$7(B
9.  $B%3%^%s%I(B($BE>Aw(B)$B%l%3!<%I$N%5!<%A(B(With Unit and LUN)
10. $B%3%^%s%I(B($BE>Aw(B)$B<B9T=*N;8e$N%-%e!<$N%a%s%F%J%s%9(B
11. $B%j%3%M%/%H;~$N%3%^%s%I%l%3!<%I$N%5!<%A(B(With Unit and LUN)
12. $B$9$Y$F$N%-%e!<!&%j%9%HCf$N%l%3!<%I$NM-L5$N%F%9%H(B
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */
/* #DATA_define D_WorkNextPtr XXX */
#DATA_define D_WorkPrevPtr XXX

/******************************************************************** PSL **
1.  $B%l%3!<%I$N%(%s%-%e!<!"%G%-%e!<(B

       written by f-doumae@icot22      on Tue Nov  6 16:39:25 1990
<Arguments>
  src_rec_ptr  : $B%3%^%s%I%l%3!<%I(B,$BE>Aw%l%3!<%I$N$$$:$l$+$X$N%]%$%s%?(B
  queue_top_ptr: $B%-%e!<$N@hF,$r;X$9%]%$%s%?%l%8%9%?(B
  queue_end_ptr: $B%-%e!<$NKvHx$r;X$9%]%$%s%?%l%8%9%?(B

<Temporally Used Variables>
<Level>
<PreCondition>
    f_DequeueScsiRecord$B$,8F$P$l$k;~$O(Bqueue_top_ptr$B$,(BEOL$B$G$J$$$3$H$,(B
    $B%A%'%C%/:Q$_!#(B
<Function>
    f_EnqueueScsiRecord(src_rec_ptr, queue_top_ptr, queue_end_ptr)
        $B%-%e!<$NKvHx$K(Bsrc_rec_ptr$B$N;X$9%l%3!<%I$r7R$0!#(B
    f_DequeueScsiRecord(queue_top_ptr, dst_rec_ptr)
        $B%-%e!<$N@hF,$+$i<h$j=P$7$?%l%3!<%I$X$N%]%$%s%?$r(Bdst_rec_ptr$B$KJV$9!#(B
    f_RemoveScsiRecord(src_rec_ptr, queue_top_ptr, queue_end_ptr)
        src_rec_ptr$B$,;X$9(B($B$^$@%-%e!<$KF~$C$F$k(B)$B%l%3!<%I$NA08e$N%j%s%/$r(B
        $B@Z$jN%$9!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#PSL_define f_EnqueueScsiRecord(src_rec_ptr, queue_top_ptr, queue_end_ptr)
{
  @DEBUG{
    s_IfNotScsiCommRec(src_rec_ptr){
      s_IfNotScsiTransRec(src_rec_ptr){
	s_IfNotScsiSelectRec(src_rec_ptr){
	  s_IfNotVECT4(src_rec_ptr){
	      /* $B%(%i!<$r8!=P$7$?%3%M%/%7%g%s$r5-O?$9$k%l%3!<%I(B */
	      VPIM_ERROR("f_EnqueueScsiRecord",
			 "Illegal pointer. not scsi-record");
	  }
        }
      }
    }
  };
  b_IfEOL(queue_top_ptr){
    p_MoveWord(src_rec_ptr, queue_top_ptr);
    p_MoveWord(src_rec_ptr, queue_end_ptr);
    s_SetScsiRecPrevPtr(D_EOL, src_rec_ptr);
  }else{
    s_SetScsiRecNextPtr(src_rec_ptr, queue_end_ptr);
    b_PushLink(src_rec_ptr, queue_end_ptr, _SCSI_RECORD_PREV_OFST);
  }
  s_SetScsiRecNextPtr(D_EOL, src_rec_ptr);
}

#PSL_define f_DequeueScsiRecord(queue_top_ptr, dst_rec_ptr)
{
    @DEBUG{
	b_IfEOL(queue_top_ptr){
	    VPIM_ERROR("f_DequeueScsiRecord","queue is empty!");
	}
    };
    b_PopLink(dst_rec_ptr, queue_top_ptr, _SCSI_RECORD_NEXT_OFST);
    b_IfNotEOL(queue_top_ptr){
	s_SetScsiRecPrevPtr(D_EOL, queue_top_ptr);
    }
}

#PSL_define f_RemoveScsiRecord(src_rec_ptr, queue_top_ptr, queue_end_ptr)
{
  @DEBUG{
    s_IfNotScsiCommRec(src_rec_ptr){
      s_IfNotScsiTransRec(src_rec_ptr){
	s_IfNotVECT4(src_rec_ptr){
	    VPIM_ERROR("f_RemoveScsiRecord","Illegal pointer-type");
	}
      }
    }
  };
  $USE(D_WorkNextPtr);$USE(D_WorkPrevPtr);
  s_GetScsiRecNextPtr(src_rec_ptr, D_WorkNextPtr);
  s_GetScsiRecPrevPtr(src_rec_ptr, D_WorkPrevPtr);
  b_IfEOL(D_WorkPrevPtr){
    p_MoveWord(D_WorkNextPtr, queue_top_ptr);
  }else{
    s_SetScsiRecNextPtr(D_WorkNextPtr, D_WorkPrevPtr);
  }
  b_IfEOL(D_WorkNextPtr){
    p_MoveWord(D_WorkPrevPtr, queue_end_ptr);
  }else{
    s_SetScsiRecPrevPtr(D_WorkPrevPtr, D_WorkNextPtr);
  }
  $RELEASE(D_WorkPrevPtr);
  $RELEASE(D_WorkNextPtr);
}

/******************************************************************** PSL **
2.  $BM=Ls%-%e!<$NA`:n(B

       written by f-doumae@icot22      on Thu Sep 20 11:45:40 1990
<Arguments>
    D_ScsiReservTop : $B%-%e!<$N@hF,$N%l%3!<%I$r;X$9%]%$%s%?%l%8%9%?(B
    D_ScsiReservEnd : $B%-%e!<$NKvHx$N%l%3!<%I$r;X$9%]%$%s%?%l%8%9%?(B
    src_rec_ptr : $B%3%^%s%I%l%3!<%I!"$^$?$OE>Aw%l%3!<%I$X$N%]%$%s%?(B(source)
    dst-rec_ptr : $B%3%^%s%I%l%3!<%I!"$^$?$OE>Aw%l%3!<%I$X$N%]%$%s%?(B(destination)
    unit        : $B%f%K%C%HHV9f(B($B%l%8%9%?(B)
    lun         : $BO@M}%f%K%C%HHV9f(B($B%l%8%9%?(B)

<Temporally Used Variables>
<Level>
<PreCondition>
    f_DequeueFromReserv$B$,8F$P$l$k;~$OM=Ls%-%e!<$,6u$G$J$$$3$H$,%A%'%C%/:Q$_!#(B
<Function>
  f_IfNotEmptyReserve()           : $BM=Ls%-%e!<$,6u$+$I$&$+$N%A%'%C%/(B
  f_EnqueueToReserv (src_rec_ptr) : $B%l%3!<%I$N%(%s%-%e!<(B
  f_DequeueFromReserv (dst_rec_ptr) : $B%l%3!<%I$N%G%-%e!<(B
  f_DequeueCommRecFromReservWithUnitAndLun (unit,lun,dst_rec_ptr) :
           $B;XDj$5$l$?(BUnit, LUN$B$K4X$9$k%3%^%s%I%l%3!<%I$N<h$j=P$7!#(B
           $B$J$$>l9g$K$O(BEOL$B$,(Bdst_rec_ptr$B$KJV$5$l$k!#(B
  f_DequeueCommRecFromReservWithID (id, dst_rec_ptr) :
           $B;XDj$5$l$?M=Ls<u$1IU$1HV9f(Bid $B$N%3%^%s%I%l%3!<%I$N<h$j=P$7!#(B
           $B$J$$>l9g$K$O(BEOL$B$,(Bdst_rec_ptr$B$KJV$5$l$k!#(B

  f_DequeueTransRecFromReservWithUnitAndLun (unit,lun,dst_rec_ptr) :  
           $B;XDj$5$l$?(BUnit, LUN$B$K4X$9$kE>Aw%l%3!<%I$N<h$j=P$7!#(B
           $B$J$$>l9g$K$O(BEOL$B$,(Bdst_rec_ptr$B$KJV$5$l$k!#(B
<Examples>
<Test>
<Explanation>
    $BDL>o!"M=Ls%-%e!<$+$i%l%3!<%I$,<h$j=P$5$l$k;~$OF1$8(BUnit$B!"(BLUN$B$K4X$9$k(B
    $B%3%^%s%I(B,$B$^$?$OE>Aw$,=*N;>l9g$N$_$G$"$k!#(B($BCm(B1)
    $B$3$N;~$OI,$:(BUnit$B!"(BLUN$B$,;XDj$5$l$k!#(B
    (etc. f_DequeueCommRecFromReserv, f_DequeueTransRecFromReserv)
    
    $B$^$?!"F1$8(BUnit, LUN$B$K4X$9$k%3%^%s%I!"$^$?$OE>Aw%l%3!<%I$,M=Ls$5$l$k(B
    $B$3$H$,$"$k$,$3$l$K$D$$$F$O!X@hF~$l@h=P$7!Y$rJ]>Z$9$k!#(B

    $BCm(B1$B!K(Breset condition$B$,8!=P$5$l$?>l9g$K$O$9$Y$F$N%3%^%s%I!"E>Aw$O(B
         $B%-%c%s%;%k$5$l$k$?$a!"%-%e!<$+$i<h$j=P$9(B($B%-%c%s%;%k$9$k(B)$B=g=x$O(B
         $BC1=c$K@hF,$+$i9T$J$&!#(B(f_DequeueFromReserv)
         scsi_abort$B$K$h$C$F%-%c%s%;%k$5$l$k;~$K$O(BID$B$,;XDj$5$l$k!#(B
         (f_DequeueCommRecFromReservWithID)
<ETC>
********************************************************************* PSL **/
#DATA_define D_ScsiReservTop   XXX
#DATA_define D_ScsiReservEnd   XXX

#CTRL_define f_IfNotEmptyReserv()
{
  b_IfNotEOL(D_ScsiReservTop)
}

#PSL_define f_EnqueueToReserv(src_rec_ptr)
{
  @DEBUG{
      s_IfNotScsiCommRec(src_rec_ptr){
	  s_IfNotScsiTransRec(src_rec_ptr){
	      VPIM_ERROR("f_EnqueueToReserv","Illegal pointer-type");
	  }
      }
  };
  f_EnqueueScsiRecord(src_rec_ptr, D_ScsiReservTop, D_ScsiReservEnd);
}

#PSL_define f_DequeueFromReserv(dst_rec_ptr)
{
  f_DequeueScsiRecord(D_ScsiReservTop, dst_rec_ptr);
  @DEBUG{
      s_IfNotScsiCommRec(dst_rec_ptr){
	  s_IfNotScsiTransRec(dst_rec_ptr){
	      VPIM_ERROR("f_DequeueFromReserv","Illegal pointer-type");
	  }
      }
  };
}

#PSL_define f_DequeueCommRecFromReservWithUnitAndLun(unit, lun, dst_rec_ptr)
{
  f_SearchCommRecWithUnitAndLUN(D_ScsiReservTop, unit, lun, dst_rec_ptr);
  /* unit,lun$B$K4X$9$k%l%3!<%I$,B8:_$7$J$+$C$?>l9g(Bdst_rec_ptr$B$K$O(BEOL$B$,JV$k!#(B*/
  b_IfNotEOL(dst_rec_ptr){
    @DEBUG{
      s_IfNotScsiCommRec(dst_rec_ptr){
	  VPIM_ERROR("f_DequeueCommRecFromReservWithUnitAndLun",
		     "Illegal pointer. not comm-rec");
      }
    };
    f_RemoveScsiRecord(dst_rec_ptr, D_ScsiReservTop, D_ScsiReservEnd);
    /* $B%j%s%/$r30$9(B */
  }
}

#PSL_define f_DequeueCommRecFromReservWithID(id, dst_rec_ptr)
{
  f_SearchCommRecWithID(D_ScsiReservTop, id, dst_rec_ptr);
  /* $BM=Ls<u$1IU$1HV9f(Bid $B$N%3%^%s%I%l%3!<%I$,B8:_$7$J$+$C$?>l9g(B
     dst_rec_ptr$B$K$O(BEOL$B$,JV$k!#(B*/
  b_IfNotEOL(dst_rec_ptr){
    @DEBUG{
      s_IfNotScsiCommRec(dst_rec_ptr){
	  VPIM_ERROR("f_DequeueCommRecFromReservWithID",
		     "Illegal pointer. not comm-rec");
      }
    };
    f_RemoveScsiRecord(dst_rec_ptr, D_ScsiReservTop, D_ScsiReservEnd);
    /* $B%j%s%/$r30$9(B */
  }
}

#PSL_define f_DequeueTransRecFromReservWithUnitAndLun(unit, lun, dst_rec_ptr)
{
  f_SearchTransRecWithUnitAndLUN(D_ScsiReservTop, unit, lun, dst_rec_ptr);
  /* unit,lun$B$K4X$9$k%l%3!<%I$,B8:_$7$J$+$C$?>l9g(Bdst_rec_ptr$B$K$O(BEOL$B$,JV$k!#(B*/
  b_IfNotEOL(dst_rec_ptr){
    @DEBUG{
      s_IfNotScsiTransRec(dst_rec_ptr){
	  VPIM_ERROR("f_DequeueTransRecFromReservWithUnitAndLun",
		     "Illegal pointer. not trans-rec");
      }
    };
    f_RemoveScsiRecord(dst_rec_ptr, D_ScsiReservTop, D_ScsiReservEnd);
    /* $B%j%s%/$r30$9(B */
  }
}

/******************************************************************** PSL **
3.  $B%P%98"%-%e!<$NA`:n(B

       written by f-doumae@icot22      on Thu Sep 20 14:23:52 1990
<Arguments>
  D_ScsiBusFreeWaitingTop: $B%P%98"%-%e!<$N@hF,$r;X$9%]%$%s%?%l%8%9%?(B
  D_ScsiBusFreeWaitingEnd: $B%P%98"%-%e!<$NKvHx$r;X$9%]%$%s%?%l%8%9%?(B

  src_rec_ptr: $B%3%^%s%I%l%3!<%I!"$^$?$OE>Aw%l%3!<%I$X$N%]%$%s%?(B(source)
  dst_rec_ptr: $B%3%^%s%I%l%3!<%I!"$^$?$OE>Aw%l%3!<%I$X$N%]%$%s%?(B(destination)
  unit       : $B%f%K%C%HHV9f(B($B%l%8%9%?(B)
  lun        : $BO@M}%f%K%C%HHV9f(B($B%l%8%9%?(B)

<Temporally Used Variables>
<Level>
<PreCondition>
    f_DequeueFromBusFreeWaiting$B$r8F$V;~$K$O%P%98"%-%e!<$,6u$G$J$$$3$H$,(B
    $B%A%'%C%/:Q$_(B
<Function>
    f_IfNotEmptyBusFreeWaiting()           : $B%P%98"%-%e!<$,6u$+$I$&$+$N%A%'%C%/(B
    f_EnqueueToBusFreeWaiting(src_rec_ptr)   :  $B%l%3!<%I$N%(%s%-%e!<(B
    f_DequeueFromBusFreeWaiting(dst_rec_ptr) :  $B%l%3!<%I$N%G%-%e!<(B
    f_DequeueCommRecFromBusFreeWaitingWithUnitAndLun(unit,lun,dst_rec_ptr) :  
            $B;XDj$5$l$?(BUnit$B!"(BLUN$B$K4X$9$k%3%^%s%I%l%3!<%I$N%G%-%e!<(B($BL$;HMQ(B)
    f_DequeueTransRecFromBusFreeWaitingWithUnitAndLun(unit,lun,dst_rec_ptr) :
            $B;XDj$5$l$?(BUnit$B!"(BLUN$B$K4X$9$kE>Aw%l%3!<%I$N%G%-%e!<(B
    f_DequeueCommRecFromBusFreeWaitingWithID(id, dst_rec_ptr) :  
            $B;XDj$5$l$?M=Ls<u$1IU$1HV9f(Bid $B$N%3%^%s%I%l%3!<%I$N%G%-%e!<(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#DATA_define D_ScsiBusFreeWaitingTop  XXX
#DATA_define D_ScsiBusFreeWaitingEnd  XXX

#CTRL_define f_IfNotEmptyBusFreeWaiting()
{
    b_IfNotEOL(D_ScsiBusFreeWaitingTop)
}

#PSL_define f_EnqueueToBusFreeWaiting(src_rec_ptr)
{
  @DEBUG{
      s_IfNotScsiCommRec(src_rec_ptr){
	  s_IfNotScsiTransRec(src_rec_ptr){
	      VPIM_ERROR("f_EnqueueToBusFreeWaiting",
			 "Illegal pointer-type");
	  }
      }
  };
  f_EnqueueScsiRecord
      (src_rec_ptr, D_ScsiBusFreeWaitingTop, D_ScsiBusFreeWaitingEnd);
/*  p_MoveWord(D_EOL, src_rec_ptr); */ 
  /* $B%(%s%-%e!<8e$N(Bsrc_rec_ptr$B$K$O(BEOL$B$r%;%C%H$9$k(B */
}

#PSL_define f_DequeueFromBusFreeWaiting(dst_rec_ptr)
{
  f_DequeueScsiRecord(D_ScsiBusFreeWaitingTop, dst_rec_ptr);
  @DEBUG{
      s_IfNotScsiCommRec(dst_rec_ptr){
	  s_IfNotScsiTransRec(dst_rec_ptr){
	      VPIM_ERROR("f_DequeueFromBusFreeWaiting",
			 "Illegal pointer-type");
	  }
      }
  };
}

#PSL_define f_DequeueCommRecFromBusFreeWaitingWithUnitAndLun
                                            (unit, lun, dst_rec_ptr)
{
  f_SearchCommRecWithUnitAndLUN(D_ScsiBusFreeWaitingTop, 
				unit, lun, dst_rec_ptr);
  /* unit,lun$B$K4X$9$k%l%3!<%I$,B8:_$7$J$+$C$?>l9g(Bdst_rec_ptr$B$K$O(BNULL$B$,JV$k!#(B*/
  b_IfNotEOL(dst_rec_ptr){
    @DEBUG{
       s_IfNotScsiCommRec(dst_rec_ptr){
	   VPIM_ERROR("f_DequeueCommRecFromBusFreeWaitingWithUnitAndLun",
		      "Illegal pointer. not comm-rec");
       }
    };
    f_RemoveScsiRecord
	(dst_rec_ptr, D_ScsiBusFreeWaitingTop, D_ScsiBusFreeWaitingEnd);
  }
}

#PSL_define f_DequeueTransRecFromBusFreeWaitingWithUnitAndLun
                                            (unit, lun, dst_rec_ptr)
{
  f_SearchTransRecWithUnitAndLUN(D_ScsiBusFreeWaitingTop,unit,lun,dst_rec_ptr);
  /* unit,lun$B$K4X$9$k%l%3!<%I$,B8:_$7$J$+$C$?>l9g(Bdst_rec_ptr$B$K$O(BNULL$B$,JV$k!#(B*/
  b_IfNotEOL(dst_rec_ptr){
    @DEBUG{
       s_IfNotScsiTransRec(dst_rec_ptr){
	   VPIM_ERROR("f_DequeueTransRecFromBusFreeWaitingWithUnitAndLun",
		      "Illegal pointer. not trans-rec");
       }
    };
    f_RemoveScsiRecord
	(dst_rec_ptr, D_ScsiBusFreeWaitingTop, D_ScsiBusFreeWaitingEnd);
  }
}

#PSL_define f_DequeueCommRecFromBusFreeWaitingWithID (id, dst_rec_ptr)
{
  f_SearchCommRecWithID(D_ScsiBusFreeWaitingTop, id, dst_rec_ptr);
  /* $BM=Ls<u$1IU$1HV9f(Bid $B$N%3%^%s%I%l%3!<%I$,B8:_$7$J$+$C$?>l9g(B
      dst_rec_ptr$B$K$O(BNULL$B$,JV$k!#(B*/
  b_IfNotEOL(dst_rec_ptr){
    @DEBUG{
       s_IfNotScsiCommRec(dst_rec_ptr){
	   VPIM_ERROR("f_DequeueCommRecFromBusFreeWaitingWithID",
		      "Illegal pointer. not comm-rec");
       }
    };
    f_RemoveScsiRecord
	(dst_rec_ptr, D_ScsiBusFreeWaitingTop, D_ScsiBusFreeWaitingEnd);
  }
}

/******************************************************************** PSL **
4.  $B<B9TCf%j%9%H$NA`:n(B

       written by f-doumae@icot22      on Thu Sep 20 14:45:05 1990
<Arguments>
  D_ScsiExecutingListTop: $B<B9TCf%j%9%H$N@hF,$r;X$9%]%$%s%?%l%8%9%?(B
  D_ScsiExecutingListEnd: $B<B9TCf%j%9%H$NKvHx$r;X$9%]%$%s%?%l%8%9%?(B

  src_rec_ptr : $B%3%^%s%I%l%3!<%I$X$N%]%$%s%?(B(source)
  dst_rec_ptr : $B%3%^%s%I%l%3!<%I$X$N%]%$%s%?(B(destination)
  unit        : $B%f%K%C%HHV9f(B($B%l%8%9%?(B)
  lun         : $BO@M}%f%K%C%HHV9f(B($B%l%8%9%?(B)

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    f_EnqueueToExecutingList(src_rec_ptr) :  $B%3%^%s%I%l%3!<%I$N%(%s%-%e!<(B
    f_DequeueFromExecutingLit(dst_rec_ptr) : $B%3%^%s%I%l%3!<%I$N%(%s%-%e!<(B
    f_DequeueFromExecutingListWithUnitAndLun(unit, lun, dst_rec_ptr) :  
           $B;XDj$5$l$?(BUnit,LUN$B$K4X$9$k%3%^%s%I%l%3!<%I$N<h$j=P$7(B
    f_ScsiCommandCancelFlagOn(id) :
           $B;XDj$5$l$?(Bid $B$N%3%^%s%I%l%3!<%I$N%-%c%s%;%k%U%i%0$r(B
           ON$B$K$9$k!#(B
<Examples>
<Test>
<Explanation>
    $B<B9TCf%j%9%H$K$O%3%^%s%I%l%3!<%I$N$_$,F~$k!#(B
<ETC>
********************************************************************* PSL **/
#DATA_define D_ScsiExecutingListTop  XXX
#DATA_define D_ScsiExecutingListEnd  XXX

#CTRL_define f_IfNotEmptyExecutingList()
{
    b_IfNotEOL(D_ScsiExecutingListTop)
}

#PSL_define f_EnqueueToExecutingList(src_rec_ptr)
{
  @DEBUG{
    s_IfNotScsiCommRec(src_rec_ptr){
	VPIM_ERROR("f_EnqueueToExecutingList","Illegal pointer-type");
    }
  };
  f_EnqueueScsiRecord
      (src_rec_ptr, D_ScsiExecutingListTop, D_ScsiExecutingListEnd);
  p_MoveWord(D_EOL, src_rec_ptr);
  /* $B%(%s%-%e!<8e$N(Bsrc_rec_ptr$B$K$O(BEOL$B$,%;%C%H$5$l$k(B */
}

#PSL_define f_DequeueFromExecutingList(dst_rec_ptr)
{
  f_DequeueScsiRecord(D_ScsiExecutingListTop, dst_rec_ptr);
  @DEBUG{
      s_IfNotScsiCommRec(dst_rec_ptr){
	  VPIM_ERROR("f_DequeueFromExecutingList","Illegal pointer-type");
      }
  };
}
 
#PSL_define f_DequeueFromExecutingListWithUnitAndLun(unit, lun, dst_rec_ptr)
{
  f_SearchCommRecWithUnitAndLUN(D_ScsiExecutingListTop,unit, lun, dst_rec_ptr);
  /* unit,lun$B$K4X$9$k%l%3!<%I$,B8:_$7$J$+$C$?>l9g(Bdst_rec_ptr$B$K$O(BNULL$B$,JV$k!#(B*/
  b_IfNotEOL(dst_rec_ptr){
    @DEBUG{
      s_IfNotScsiCommRec(dst_rec_ptr){
	  VPIM_ERROR("f_DequeueFromExecutingListWithUnitAndLun",
		     "Illegal pointer. not comm-rec");
      }
    };
    f_RemoveScsiRecord
	(dst_rec_ptr, D_ScsiExecutingListTop, D_ScsiExecutingListEnd);
    /* $B%j%s%/$+$i30$9(B */
  }
}

#PSL_define f_ScsiCommandCancelFlagOn(id,dst_rec_ptr)
{
  $USE(D_WorkCommRec);
  f_SearchCommRecWithID(D_ScsiExecutingListTop, id, D_WorkCommRec);
  b_IfNotEOL(D_WorkCommRec){
    @DEBUG{
      s_IfNotScsiCommRec(dst_rec_ptr){
	  VPIM_ERROR("f_ScsiCommandCancelFlagOn",
		     "Illegal pointer. not comm-rec");
      }
    };
    s_SetScsiCommRecCancelFlagOn(D_WorkCommRec);
  }    
  $RELEASE(D_WorkCommRec);
}

/******************************************************************** PSL **
5.  $B8e=hM}%-%e!<$NA`:n(B

       written by f-doumae@icot22      on Tue Nov  6 20:29:33 1990
<Arguments>
    D_ScsiDeferredExecution: $B8e=hM}%-%e!<$N@hF,$r;X$9%]%$%s%?%l%8%9%?(B

    src_rec_ptr : $B%3%^%s%I%l%3!<%I!"$^$?$O%;%l%/%7%g%s%l%3!<%I$X$N%]%$%s%?(B
                  (source)
    dst_rec_ptr : $B%3%^%s%I%l%3!<%I!"$^$?$O%;%l%/%7%g%s%l%3!<%I$X$N%]%$%s%?(B
                  (destination)
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    f_IfNotEmptyDeferredExec()            : $B8e=hM}%-%e!<$,6u$+$I$&$+$r%A%'%C%/$9$k(B
    f_EnqueueToDeferredExec(src_rec_ptr)  : $B%(%s%-%e!<(B
    f_DequeueFromDeferredExec(dst_rec_ptr): $B%G%-%e!<(B
<Examples>
<Test>
<Explanation>
    $B8e=hM}%-%e!<$KF~$l$i$l$?%l%3!<%I$O#G#C8e$KD>$A$K<h$j=P$5$l$F(B
    $B=hM}$5$l$k!#$=$N;~$N<h$j=P$5$l$k=gHV$O@hF~$l@h=P$7$rJ]>Z$9$kI,MW$O(B
    $B$J$$$H;W$&!#(B($B$[$s$H$+$7$i(B)
<ETC>
********************************************************************* PSL **/
#DATA_define D_ScsiDeferredExecution   XXX

#CTRL_define f_IfNotEmptyDeferredExec()
{
    b_IfNotEOL(D_ScsiDeferredExecution)
}

#PSL_define f_EnqueueToDeferredExec(src_rec_ptr)
{
    b_PushLink(src_rec_ptr, D_ScsiDeferredExecution, _SCSI_RECORD_NEXT_OFST);
}

#PSL_define f_DequeueFromDeferredExec(dst_rec_ptr)
{
    b_PopLink(dst_rec_ptr, D_ScsiDeferredExecution, _SCSI_RECORD_NEXT_OFST);
}

/******************************************************************** PSL **
6.  $B%(%i!<$r8!=P$7$?%3%M%/%7%g%s$N%j%9%H$NA`:n(B

       written by f-doumae@icot22      on Tue Dec 25 21:15:55 1990
<Arguments>
  D_ScsiErrDetectedConnectionListTop: $B%j%9%H$N@hF,$r;X$9%]%$%s%?%l%8%9%?(B
  D_ScsiErrDetectedConnectionListEnd: $B%j%9%H$NKvHx$r;X$9%]%$%s%?%l%8%9%?(B

  unit        : $B%$%K%7%(!<%?B&%f%K%C%HHV9f(B($B%l%8%9%?(B)
  lun         : $B%?!<%2%C%HB&O@M}%f%K%C%HHV9f(B($B%l%8%9%?(B)

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    f_IfScsiErrDetectedConnection(unit, lun, rec)
         unit,lun$B$N%3%M%/%7%g%s$,%(%i!<$r8!=P$7$?%3%M%/%7%g%s%j%9%H$K(B
         $B5-O?$,$"$k$+$I$&$+$N%F%9%H!#(Brec$B$O%o!<%/%l%8%9%?$H$7$F$N$_(B
         $B;HMQ$7$F$$$k!#(B
    f_EnqueueToErrDetectedConnectionList(unit, lun) 
         $B5-O?%l%3!<%I$N%(%s%-%e!<(B
    f_DequeueFromErrDetectedConnectionListWithUnitAndLun(unit, lun) 
         $B;XDj$5$l$?(BUnit,LUN$B$K4X$9$k5-O?%l%3!<%I$N%l%3!<%I$N>C5n!#(B
         $B3:Ev$9$k%l%3!<%I$,$J$1$l$P2?$b$7$J$$!#(B
<Examples>
<Test>
<Explanation>
    $BE>Aw$,%"%F%s%7%g%s$dB>$N0[>o$G@5>o=*N;$7$J$+$C$?>l9g!"%$%K%7%(!<%?B&(B
    $B%f%K%C%HHV9f$H%?!<%2%C%HB&O@M}%f%K%C%HHV9f$NBP$r$3$3$K5-O?$7$F$*$/!#(B
    $B5-O?$9$k$?$a$N%l%3!<%I$K$O%R!<%W$K$"$k(B 4$B%o!<%I%;%k(B(VECT4) $B$r;HMQ$9$k!#(B

    +-------------------------+
    | $B<!$N%l%3!<%I$X$N%]%$%s%?(B|
    +-------------------------+
    | $BA0$N%l%3!<%I$X$N%]%$%s%?(B|
    +-------------------------+
    |      $B%f%K%C%HHV9f(B       |
    +-------------------------+
    |    $BO@M}%f%K%C%HHV9f(B     |
    +-------------------------+
        
<ETC>
********************************************************************* PSL **/
#DATA_define D_ScsiErrDetectedConnectionListTop  XXX
#DATA_define D_ScsiErrDetectedConnectionListEnd  XXX
#ADDR_define _CONNECTION_REC_UNIT_OFST      2
#ADDR_define _CONNECTION_REC_LUN_OFST       3

#CTRL_define f_IfScsiErrDetectedConnection(unit, lun, rec)
{
  f_SearchErrDetectedConnectionListWithUnitAndLUN(unit, lun, rec);
  b_IfNotEOL(rec)
}

#CTRL_define f_IfNotEmptyErrDetectedConnectionList()
{
    b_IfNotEOL(D_ScsiErrDetectedConnectionListTop)
}

#CTRL_define f_IfEmptyErrDetectedConnectionList()
{
    b_IfEOL(D_ScsiErrDetectedConnectionListTop)
}

#PSL_define f_EnqueueToErrDetectedConnectionList(unit, lun)
{
  $USE(D_WorkRecord);
  s_AllocVect4(D_WorkRecord);
  p_WriteWithOffset(unit, D_WorkRecord, _CONNECTION_REC_UNIT_OFST);
  p_WriteWithOffset(lun, D_WorkRecord, _CONNECTION_REC_LUN_OFST);
  f_EnqueueScsiRecord (D_WorkRecord, D_ScsiErrDetectedConnectionListTop, 
		       D_ScsiErrDetectedConnectionListEnd);
  $RELEASE(D_WorkRecord);
}

#PSL_define f_DequeueFromErrDetectedConnectionListWithUnitAndLun (unit, lun)
{
  $USE(D_WorkRecord);
  f_SearchErrDetectedConnectionListWithUnitAndLUN(unit, lun, D_WorkRecord);
  /* unit,lun$B$K4X$9$k%l%3!<%I$,B8:_$7$J$+$C$?>l9g(BD_WorkRecord$B$K$O(BNULL$B$,JV$k!#(B*/
  b_IfNotEOL(D_WorkRecord){
    @DEBUG{
      s_IfNotVECT4(D_WorkRecord){
	  VPIM_ERROR("f_DequeueFromErrDetectedConnectionListWithUnitAndLun",
		     "Illegal pointer-type");
      }
    };
    f_RemoveScsiRecord(D_WorkRecord, D_ScsiErrDetectedConnectionListTop,
		       D_ScsiErrDetectedConnectionListEnd);
    /* $B%j%s%/$+$i30$9(B */
    s_ReclaimVect4(D_WorkRecord);
    /* $B%U%j!<%j%9%H$KLa$9(B */
  }
  $RELEASE(D_WorkRecord);
}

#PSL_define f_SearchErrDetectedConnectionListWithUnitAndLUN(unit, lun, rec_ptr)
{
  p_MoveWord(D_ScsiErrDetectedConnectionListTop, rec_ptr);
  LOOP(){
    b_IfEOL(rec_ptr){ break; }
    $USE(D_WorkSlot);
    p_ReadWithOffset(rec_ptr, _CONNECTION_REC_UNIT_OFST, D_WorkSlot);
    b_IfEqual(unit, D_WorkSlot){
      p_ReadWithOffset(rec_ptr, _CONNECTION_REC_LUN_OFST, D_WorkSlot);
      b_IfEqual(lun, D_WorkSlot){
	  $RELEASE(D_WorkSlot);
	  break;
      }
    }
    $RELEASE(D_WorkSlot);
    p_ReadWithOffset(rec_ptr, _SCSI_RECORD_NEXT_OFST, rec_ptr);
  }
}

/******************************************************************** PSL **
7. $B%3%^%s%I!JE>Aw!K%l%3!<%I$N%U%j!<%j%9%HBT$A%-%e!<$NA`:n(B

       written by f-doumae@icot22      on Tue Nov  6 20:30:15 1990
<Arguments>
  D_ScsiCommRecFreeListWaitingTop: $B%3%^%s%I%l%3!<%I%U%j!<%j%9%HBT$A%-%e!<$N(B
                                   $B@hF,$r;X$9%]%$%s%?%l%8%9%?(B
  D_ScsiCommRecFreeListWaitingEnd: $B%3%^%s%I%l%3!<%I%U%j!<%j%9%HBT$A%-%e!<$N(B
                                   $BKvHx$r;X$9%]%$%s%?%l%8%9%?(B
  D_ScsiTransRecFreeListWaitingTop: $BE>Aw%l%3!<%I%U%j!<%j%9%HBT$A%-%e!<$N(B
                                    $B@hF,$r;X$9%]%$%s%?%l%8%9%?(B
  D_ScsiTransRecFreeListWaitingEnd: $BE>Aw%l%3!<%I%U%j!<%j%9%HBT$A%-%e!<$N(B
                                    $BKvHx$r;X$9%]%$%s%?%l%8%9%?(B

  src_goal_ptr: $B%4!<%k%l%3!<%I$X$N%]%$%s%?(B(source)
  dst_goal_ptr: $B%4!<%k%l%3!<%I$X$N%]%$%s%?(B(destination)
<Temporally Used Variables>
<Level>
<PreCondition>
    $B%G%-%e!<$5$l$k;~$K$O%U%j!<%j%9%HBT$A%-%e!<$N@hF,$r;X$9%]%$%s%?%l%8%9%?$,(B
    EOL$B$G$J$$$3$H$,%A%'%C%/:Q$_!#(B
<Function>
    f_IfNotEmptyCommRecFreeListWaiting() 
       $B%3%^%s%I%l%3!<%I%U%j!<%j%9%HBT$A%-%e!<$,6u$+$I$&$+$r%A%'%C%/$9$k!#(B
    f_EnqueueToCommRecFreeListWaiting(src_goal_ptr) 
       $B%3%^%s%I%l%3!<%I%U%j!<%j%9%HBT$A%-%e!<$K%4!<%k%l%3!<%I(B
       (dcode_scsi_command)$B$r%(%s%-%e!<$9$k!#(B
    f_DequeueFromCommRecFreeListWaiting(dst_goal_ptr) 
       $B%3%^%s%I%l%3!<%I%U%j!<%j%9%HBT$A%-%e!<$+$i%4!<%k%l%3!<%I(B
       (dcode_scsi_command)$B$r%G%-%e!<$9$k!#(B

    f_IfNotEmptyTransRecFreeListWaiting()
       $BE>Aw%l%3!<%I%U%j!<%j%9%HBT$A%-%e!<$,6u$+$I$&$+$r%A%'%C%/$9$k!#(B
    f_EnqueueToTransRecFreeListWaiting(src_goal_ptr) 
       $BE>Aw%l%3!<%I%U%j!<%j%9%HBT$A%-%e!<$K%4!<%k%l%3!<%I(B
       (dcode_scsi_transfer)$B$r%(%s%-%e!<$9$k!#(B
    f_DequeueFromTransRecFreeListWaiting(dst_goal_ptr) 
       $BE>Aw%l%3!<%I%U%j!<%j%9%HBT$A%-%e!<$+$i%4!<%k%l%3!<%I(B
       (dcode_scsi_transfer)$B$r%G%-%e!<$9$k!#(B

<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#DATA_define  D_ScsiCommRecFreeListWaitingTop  XXX
#DATA_define  D_ScsiCommRecFreeListWaitingEnd   XXX
#DATA_define  D_ScsiTransRecFreeListWaitingTop  XXX
#DATA_define  D_ScsiTransRecFreeListWaitingEnd  XXX

#CTRL_define f_IfNotEmptyCommRecFreeListWaiting()
{
  b_IfNotEOL(D_ScsiCommRecFreeListWaitingTop)
}

#PSL_define f_EnqueueToCommRecFreeListWaiting(src_goal_ptr)
{
  @DEBUG{
    s_IfNotHOOK(src_goal_ptr){
	VPIM_ERROR("f_EnqueueToCommRecFreeListWaiting",
		   "Illegal type. This is not goal-record");
    }
  };
  b_IfEOL(D_ScsiCommRecFreeListWaitingTop){
      p_MoveWord(src_goal_ptr, D_ScsiCommRecFreeListWaitingTop);
      p_MoveWord(src_goal_ptr, D_ScsiCommRecFreeListWaitingEnd);
  }else{
      s_PutNextGoalRecord(D_ScsiCommRecFreeListWaitingEnd, src_goal_ptr);
      /*-----------------------------------------------------
      s_PutNextEOLGoalRecord(src_goal_ptr); $BI,MW$+$b$7$s$J$$!#(B
      -------------------------------------------------------*/
      p_MoveWord(src_goal_ptr, D_ScsiCommRecFreeListWaitingEnd);
  }
}

#PSL_define f_DequeueFromCommRecFreeListWaiting(dst_goal_ptr)
{
  b_PopLink(dst_goal_ptr, D_ScsiCommRecFreeListWaitingTop, _NEXT_PTR_OFST_GR);
  @DEBUG{
      s_IfNotHOOK(dst_goal_ptr){
	  VPIM_ERROR("f_DequeueFromCommRecFreeListWaiting",
		     "Illegal pointer. This is not goal-record.");
      }
  };
}

#CTRL_define f_IfNotEmptyTransRecFreeListWaiting()
{
    b_IfNotEOL(D_ScsiTransRecFreeListWaitingTop)
}

#PSL_define f_EnqueueToTransRecFreeListWaiting(src_goal_ptr)
{
  @DEBUG{
    s_IfNotHOOK(src_goal_ptr){
	VPIM_ERROR("f_EnqueueToTransRecFreeListWaiting",
		   "Illegal type. This is not goal-record");
    }
  };
  b_IfEOL(D_ScsiTransRecFreeListWaitingTop){
      p_MoveWord(src_goal_ptr, D_ScsiTransRecFreeListWaitingTop);
      p_MoveWord(src_goal_ptr, D_ScsiTransRecFreeListWaitingEnd);
  }else{
      s_PutNextGoalRecord(D_ScsiTransRecFreeListWaitingEnd, src_goal_ptr);
      p_MoveWord(src_goal_ptr, D_ScsiTransRecFreeListWaitingEnd);
  }
}

#PSL_define f_DequeueFromTransRecFreeListWaiting(dst_goal_ptr)
{
  b_PopLink(dst_goal_ptr, D_ScsiTransRecFreeListWaitingTop, _NEXT_PTR_OFST_GR);
  @DEBUG{
      s_IfNotHOOK(dst_goal_ptr){
	  VPIM_ERROR("f_DequeueFromTransRecFreeListWaiting",
		     "Illegal pointer. This is not goal-record.");
      }
  };
}

/******************************************************************** PSL **
8.  $B%3%^%s%I(B($BE>Aw(B)$B=*N;;~$N?7$7$$%3%^%s%I(B($BE>Aw(B)$B%l%3!<%I$N<h$j=P$7(B

       written by f-doumae@icot22      on Fri Nov  2 14:26:01 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    f_DequeueNewScsiCommRec(comm_rec_ptr)
       $B<B9T$N=*N;$7$?%3%^%s%I$K$D$$$FF1$8(BUnit,Lun$B$G<B9T$rBT$C$F$$$k(B
       $B%3%^%s%I$,M=Ls%-%e!<$K$"$C$?$i(B($B%P%98"%-%e!<$KB>$N%3%^%s%I(B($BE>Aw(B)
       $B%l%3!<%I$,5M$^$C$F$$$F$b(B)comm_rec_ptr$B$K$=$N%3%^%s%I%l%3!<%I(B
       $B$X$N%]%$%s%?$rJV$9!#(B
       $BM=Ls%-%e!<$KF1$8(BUnit,Lun$B$G<B9T$rBT$C$F$$$k%3%^%s%I$,$J$1$l$P!"(B
       $B%P%98"%-%e!<$N@hF,$K$"$k%3%^%s%I!"$^$?$OE>Aw%l%3!<%I$X$N%]%$%s%?$r(B
       comm_reg_ptr$B$KJV$9!#(B($B%P%98"%-%e!<$,6u$N>l9g$O(BNULL$B$,JV$k!#(B)

    f_DequeueNewScsiTransRec(trans_rec_ptr)
       $B<B9T$N=*N;$7$?E>Aw$K$D$$$FF1$8(BUnit,Lun$B$G<B9T$rBT$C$F$$$k(B
       $BE>Aw$,M=Ls%-%e!<$K$"$C$?$i(B($B%P%98"%-%e!<$KB>$NE>Aw(B($B%3%^%s%I(B)
       $B%l%3!<%I$,5M$^$C$F$$$F$b(B)trans_rec_ptr$B$K$=$NE>Aw%l%3!<%I(B
       $B$X$N%]%$%s%?$rJV$9!#(B
       $BM=Ls%-%e!<$KF1$8(BUnit,Lun$B$G<B9T$rBT$C$F$$$k%3%^%s%I$,$J$1$l$P!"(B
       $B%P%98"%-%e!<$N@hF,$K$"$kE>Aw!"$^$?$O%3%^%s%I%l%3!<%I$X$N%]%$%s%?$r(B
       trans_rec_ptr$B$KJV$9!#(B($B%P%98"%-%e!<$,6u$N>l9g$O(BNULL$B$,JV$k!#(B)
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#PSL_define f_DequeueNewScsiCommRec(comm_rec_ptr)
{
  @DEBUG{
    s_IfNotScsiCommRec(comm_rec_ptr){
	VPIM_ERROR("f_DequeueNewScsiCommRec","Illegal type");
    }
  };
  $USE(D_WorkUnit);
  $USE(D_WorkLun);
  s_GetScsiCommRecUnit(comm_rec_ptr, D_WorkUnit);
  s_GetScsiCommRecLUN(comm_rec_ptr, D_WorkLun);
  f_DequeueCommRecFromReservWithUnitAndLun(D_WorkUnit, D_WorkLun,comm_rec_ptr);
  $RELEASE(D_WorkLun);
  $RELEASE(D_WorkUnit);
  b_IfEOL(comm_rec_ptr){
    f_IfNotEmptyBusFreeWaiting(){
      f_DequeueFromBusFreeWaiting(comm_rec_ptr);
    }
  }
}

#PSL_define f_DequeueNewScsiTransRec(trans_rec_ptr)
{
  @DEBUG{
    s_IfNotScsiTransRec(trans_rec_ptr){
	VPIM_ERROR("f_DequeueNewScsiTransRec","Illegal type");
    }
  };
  $USE(D_WorkUnit);
  $USE(D_WorkLun);
  s_GetScsiTransRecUnit(trans_rec_ptr, D_WorkUnit);
  s_GetScsiTransRecLUN(trans_rec_ptr, D_WorkLun);
  f_DequeueTransRecFromReservWithUnitAndLun
      (D_WorkUnit, D_WorkLun, trans_rec_ptr);
  $RELEASE(D_WorkLun);
  $RELEASE(D_WorkUnit);
  b_IfEOL(trans_rec_ptr){
    f_IfNotEmptyBusFreeWaiting(){
	f_DequeueFromBusFreeWaiting(trans_rec_ptr);
    }
  }
}

/******************************************************************** PSL **
9.  $B%3%^%s%I(B($BE>Aw(B)$B%l%3!<%I$N%5!<%A(B

       written by f-doumae@icot22      on Fri Nov  2 16:09:52 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    f_SearchCommRecWithUnitAndLUN(queue_ptr, unit, lun, dst_ptr)
      $B;XDj$5$l$?(Bqueue_ptr($BM=Ls%-%e!<(B,$B%P%98"%-%e!<(B,$B<B9TCf%j%9%H$N$$$:$l$+(B)
      $B$+$i(Bunit,lun$B$K4X$9$k%3%^%s%I%l%3!<%I$r<h$j=P$7!"$=$3$X$N%]%$%s%?$r(B
      dst_ptr$B$K=q$-9~$`!#(B

    f_SearchTransRecWithUnitAndLUN(queue_ptr, unit, lun, dst_ptr)
      $B;XDj$5$l$?(Bqueue_ptr($BM=Ls%-%e!<(B,$B%P%98"%-%e!<$N$$$:$l$+(B)$B$+$i(Bunit,lun$B$K(B
      $B4X$9$k%3%^%s%I%l%3!<%I$r<h$j=P$7!"$=$3$X$N%]%$%s%?$r(Bdst_ptr$B$K=q$-9~$`!#(B

    f_SearchCommRecWithID(queue_ptr, id, dst_ptr)
      $B;XDj$5$l$?(Bqueue_ptr($BM=Ls%-%e!<(B,$B%P%98"%-%e!<(B,$B<B9TCf%j%9%H$N$$$:$l$+(B)
      $B$+$iM=Ls<u$1IU$1HV9f(Bid $B$N%3%^%s%I%l%3!<%I$r<h$j=P$7!"$=$3$X$N%]%$%s%?$r(B
      dst_ptr$B$K=q$-9~$`!#(B

<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#PSL_define f_SearchCommRecWithUnitAndLUN(queue_ptr, unit, lun, dst_ptr)
{
  p_MoveWord(queue_ptr, dst_ptr);
  LOOP(){
    b_IfEOL(dst_ptr){
      break;
    }
    s_IfScsiCommRec(dst_ptr){
      $USE(D_WorkSlot);
      s_GetScsiCommRecUnit(dst_ptr, D_WorkSlot);
      b_IfEqual(unit, D_WorkSlot){
        s_GetScsiCommRecLUN(dst_ptr, D_WorkSlot);
	b_IfEqual(lun, D_WorkSlot){
	    $RELEASE(D_WorkSlot);
	    break;
	}
      }
      $RELEASE(D_WorkSlot);
    }
    s_GetScsiCommRecNextPtr(dst_ptr, dst_ptr);
  }
}
  
#PSL_define f_SearchTransRecWithUnitAndLUN(queue_ptr, unit, lun, dst_ptr)
{
  p_MoveWord(queue_ptr, dst_ptr);
  LOOP(){
    b_IfEOL(dst_ptr){
      break;
    }
    s_IfScsiTransRec(dst_ptr){
      $USE(D_WorkSlot);
      s_GetScsiTransRecUnit(dst_ptr, D_WorkSlot);
      b_IfEqual(unit, D_WorkSlot){
        s_GetScsiTransRecLUN(dst_ptr, D_WorkSlot);
	b_IfEqual(lun, D_WorkSlot){
	    $RELEASE(D_WorkSlot);
	    break;
	}
      }
      $RELEASE(D_WorkSlot);
    }
    s_GetScsiTransRecNextPtr(dst_ptr, dst_ptr);
  }
}

#PSL_define f_SearchCommRecWithID(queue_ptr, id, dst_ptr)
{
  p_MoveWord(queue_ptr, dst_ptr);
  LOOP(){
    b_IfEOL(dst_ptr){ break; }
    b_IfEqual(id, dst_ptr){
	@DEBUG{
	    s_IfNotScsiCommRec(dst_ptr){
		VPIM_ERROR("f_SearchCommRecWithID","Illegal pointer");
	    }
	};
	break;
    }
    s_GetScsiCommRecNextPtr(dst_ptr, dst_ptr);
  }
}

/******************************************************************** PSL **
10. $B%3%^%s%I(B($BE>Aw(B)$B<B9T=*N;8e$N%-%e!<$N%a%s%F%J%s%9(B

       written by f-doumae@icot22      on Fri Mar  8 16:03:02 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    f_ScsiQueueManagementOnCommandEnd(comm_rec_ptr_reg)
        $B%3%^%s%I<B9T=*N;;~$K9T$J$&=hM}!#$3$3$G$$$&<B9T=*N;$H$O(B
        $B%;%l%/%7%g%s<B9T0J9_$N(BKL1$B$X$N7k2LJs9p=*N;(B($B%(%i!<=*N;$b4^$`(B)$B!"(B
        $B5Z$S%P%98"%-%e!<$K$"$C$?;~$N%-%c%s%;%k=*N;$r$$$&!#(B
        $B<!$N=hM}$r9T$J$&!#(B

       $B!&N$?F$N(BChildCount$B$r(B1$B8:$i$9!#"*(B $B:o=|(B(91.11.20)
       $B!&(Bcomm_rec_ptr_reg$B$N;X$9%3%^%s%I%l%3!<%I$r%U%j!<%j%9%H$KLa$9!#(B
       $B!&%3%^%s%I%l%3!<%IBT$A$N%4!<%k$,$"$l$P%j%9%1%8%e!<%k$9$k!#(B
       $B!&F1$8(BUnit,LUN$B$G<B9T$rBT$C$F$$$?%3%^%s%I$,M=Ls%-%e!<$K$"$l$P(B
         $B%P%98"%-%e!<$K0\$9!#(B

    f_ScsiQueueManagementOnTransferEnd(trans_rec_ptr_reg)
        $BE>Aw<B9T=*N;;~$K9T$J$&=hM}!#$3$3$G$$$&<B9T=*N;$H$O(B
        KL1$B$X$N7k2LJs9p=*N;(B($B%(%i!<=*N;$b4^$`(B)$B$r$$$&!#(B
        $B<!$N=hM}$r9T$J$&!#(B

       $B!&N$?F$N(BChildCount$B$r(B1$B8:$i$9!#"*(B $B:o=|(B(91.11.20)
       $B!&(Btrans_rec_ptr_reg$B$N;X$9E>Aw%l%3!<%I$r%U%j!<%j%9%H$KLa$9!#(B
       $B!&E>Aw%l%3!<%IBT$A$N%4!<%k$,$"$l$P%j%9%1%8%e!<%k$9$k!#(B
       $B!&F1$8(BUnit,LUN$B$G<B9T$rBT$C$F$$$?E>Aw$,M=Ls%-%e!<$K$"$l$P(B
         $B%P%98"%-%e!<$K0\$9!#(B

<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#PSL_define f_ScsiQueueManagementOnCommandEnd(comm_rec_ptr_reg)
{
/*  91.11.20
  $USE(D_WorkFPPtr);
  s_GetScsiCommRecFPPtr(comm_rec_ptr_reg, D_WorkFPPtr);
  s_DecrementFPChildCount(D_WorkFPPtr);
  $RELEASE(D_WorkFPPtr);
*/
  s_ReclaimCommRec(comm_rec_ptr_reg); /* $B%U%j!<%j%9%H$KLa$9!#(B*/

  f_IfNotEmptyCommRecFreeListWaiting(){
      $USE(D_WorkGoalPtr);
      f_DequeueFromCommRecFreeListWaiting(D_WorkGoalPtr);
      $USE(D_WorkPriority);
      s_GetPriorityEnvGoalRecord(D_WorkGoalPtr, D_WorkPriority);
      $CALL(f_PushGoalToStackWithPriority_Sub(D_WorkGoalPtr, D_WorkPriority));
      $RELEASE(D_WorkPriority);
      $RELEASE(D_WorkGoalPtr);
  }
  /*-----------------------------------------------------------
      $BF1$8(BUnit,LUN$B$G<B9T$rBT$C$F$$$?%3%^%s%I$,M=Ls%-%e!<$K$"$l$P(B
      $B%P%98"%-%e!<$K0\$9!#(B
   -------------------------------------------------------------*/
  $USE(D_WorkUnit1);$USE(D_WorkLun1);
  s_GetScsiCommRecUnit(comm_rec_ptr_reg, D_WorkUnit1);
  s_GetScsiCommRecLUN(comm_rec_ptr_reg, D_WorkLun1);
  f_DequeueCommRecFromReservWithUnitAndLun
      (D_WorkUnit1,D_WorkLun1,comm_rec_ptr_reg);
  $RELEASE(D_WorkLun1);$RELEASE(D_WorkUnit1);
  s_IfScsiCommRec(comm_rec_ptr_reg){
    f_EnqueueToBusFreeWaiting(comm_rec_ptr_reg);
  }else{
    @DEBUG{
      b_IfNotEOL(comm_rec_ptr_reg){
	  VPIM_ERROR("f_ScsiQueueManagementOnCommandEnd","Illegal pointer");
      }
    };
  }
}

#PSL_define f_ScsiQueueManagementOnTransferEnd(trans_rec_ptr_reg)
{
/*  91.11.20
  $USE(D_WorkFPPtr);
  s_GetScsiTransRecFPPtr(trans_rec_ptr_reg, D_WorkFPPtr);
  s_DecrementFPChildCount(D_WorkFPPtr);
  $RELEASE(D_WorkFPPtr);
*/
  s_ReclaimTransRec(trans_rec_ptr_reg); /* $B%U%j!<%j%9%H$KLa$9!#(B*/

  f_IfNotEmptyTransRecFreeListWaiting(){
      $USE(D_WorkGoalPtr);
      f_DequeueFromTransRecFreeListWaiting(D_WorkGoalPtr);
      $USE(D_WorkPriority);
      s_GetPriorityEnvGoalRecord(D_WorkGoalPtr, D_WorkPriority);
      $CALL(f_PushGoalToStackWithPriority_Sub(D_WorkGoalPtr, D_WorkPriority));
      $RELEASE(D_WorkPriority);
      $RELEASE(D_WorkGoalPtr);
  }
  /*-----------------------------------------------------------
      $BF1$8(BUnit,LUN$B$G<B9T$rBT$C$F$$$?E>Aw$,M=Ls%-%e!<$K$"$l$P(B
      $B%P%98"%-%e!<$K0\$9!#(B
   -------------------------------------------------------------*/
  $USE(D_WorkUnit1);$USE(D_WorkLun1);
  s_GetScsiTransRecUnit(trans_rec_ptr_reg, D_WorkUnit1);
  s_GetScsiTransRecLUN(trans_rec_ptr_reg, D_WorkLun1);
  f_DequeueTransRecFromReservWithUnitAndLun
      (D_WorkUnit1,D_WorkLun1,trans_rec_ptr_reg);
  $RELEASE(D_WorkLun1);$RELEASE(D_WorkUnit1);
  s_IfScsiTransRec(trans_rec_ptr_reg){
      f_EnqueueToBusFreeWaiting(trans_rec_ptr_reg);
  }else{
      @DEBUG{
	  b_IfNotEOL(trans_rec_ptr_reg){
	      VPIM_ERROR("f_ScsiQueueManagementOnTransferEnd",
			 "Illegal pointer");
	  }
      };
  }
}

/******************************************************************** PSL **
11. $B%j%3%M%/%H;~$N%3%^%s%I%l%3!<%I$N%5!<%A(B(With Unit and LUN)
       written by f-takei@icot22      on Thu Jul  4 19:10:50 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
   f_ScsiSearchCommRecFromExecuting_Sub(A_Unit, A_Lun, A_CommRec, A_Next)
     $B<B9TCf%j%9%H$+$i(B A_Unit, A_Lun $B$G;XDj$5$l$?%3%^%s%I%l%3!<%I$r(B
     $BC5$9!#(B
     $BB8:_$7$?$i!"(BA_CommRec $B$K$=$N%3%^%s%I%l%3!<%I$X$N%]%$%s%?$rJV$7!"(B
     $B99$K%j%3%M%/%H8e$KI|5"$9$Y$-%U%'!<%:$rFI$_$@$7$F(B A_Next $B$KJV$9!#(B
     $BB8:_$7$J$+$C$?$i!"(BA_CommRec $B$K(B EOL $B$rJV$9!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#SUBARG_define A_Unit		SRC
#SUBARG_define A_Lun		SRC
#SUBARG_define A_CommRec	DST
#SUBARG_define A_Next		DST

#SUBROUTINE f_ScsiSearchCommRecFromExecuting_Sub
                               (A_Unit, A_Lun, A_CommRec, A_Next)
{
    f_DequeueFromExecutingListWithUnitAndLun
	(A_Unit, A_Lun, A_CommRec);
    b_IfEOL(A_CommRec){
	/* $B3:Ev$9$k%3%^%s%I%l%3!<%I$,$J$$(B*/
	$CALL(f_ScsiTransferAbort_Sub(D_NULL));
	p_MoveWord(D_NULL, A_Next);
    }else{
	s_IfScsiCommRecCanceled(A_CommRec){
	    /*$B%-%c%s%;%k$5$l$F$$$?(B*/
	    s_OrResultCodeCommRec(_CANCELED_AFTER_EXEC, A_CommRec);
	    $CALL(f_ScsiTransferAbort_Sub(D_NULL));
	    b_SetImmValueDNTC(_RESULT_REPORT, A_Next);
	}else{
	    /* Disconnect -> Reconnect $B8e$NE>Aw%U%'!<%:$X(B */
	    s_GetScsiCommRecDataPtr(A_CommRec,
				    D_CurrentDataPtrReg);
	    /* $B%G!<%?%]%$%s%?$N%j%9%H%"(B */
	    s_GetScsiCommRecNextPhase(A_CommRec, A_Next);
	}
    }
    $RETURN();
}

/******************************************************************** PSL **
12. $B$9$Y$F$N%-%e!<!&%j%9%HCf$N%l%3!<%I$NM-L5$N%F%9%H(B
    f_IfScsiEmptyAllQueues

       written by f-takei@icot22      on Fri Jul  5 20:44:24 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    $BM=Ls%-%e!<!&%P%98"%-%e!<!&<B9TCf%j%9%H$,$9$Y$F6u$+$I$&$+$r%F%9%H$9$k!#(B
<Examples>
<Test>
<Explanation>
    SCSI $B%I%i%$%P$N%j%;%C%H$N:]$KMQ$$$k!#(B
<ETC>
********************************************************************* PSL **/

#CTRL_define f_IfScsiEmptyAllQueues()
{
    f_IfNotEmptyReserv(){
	b_SetFail();
    }else{
	f_IfNotEmptyBusFreeWaiting(){
	    b_SetFail();
	}else{
	    f_IfNotEmptyExecutingList(){
		b_SetFail();
	    }else{
		b_SetSuccess();
	    }
	}
    }
    b_IfSuccess()
}
