/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_scsi_ope.psl.c
   ----- CREATED   : by f-doumae@icot22, on Tue Oct 30 20:10:39 1990
   ----- LAST SAVED: by f-takei@icot22, on Tue Nov 12 14:38:10 1991
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : 
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

#PSL_define f_DcodeEnqueueToCommRecFreeListWaiting
                            (arg0, arg1, arg2, arg3, arg4, arg5, arg6)
{
  s_AllocVariable(arg2);
  s_AllocVariable(arg3);
  s_AllocVariable(arg4);
  s_AllocVariable(arg5);
  s_AllocVariable(arg6);
  $USE(D_WorkNewGR);
  $CALL ( f_Make_DcodeGoalRecord_Sub (D_WorkNewGR) );
  s_PutImmArityGoalRecord(D_WorkNewGR, _DCODE_GOAL_ARITY7);
  $USE(D_WorkDcodeaddr);
  f_GetDcodeAddress(BLT_B_SCSI_COMMAND, D_WorkDcodeaddr);
  s_PutCodeGoalRecord(D_WorkNewGR, D_WorkDcodeaddr);
  $RELEASE(D_WorkDcodeaddr);
  f_Put7ArgsGoalRecord 
      (D_WorkNewGR, arg0, arg1, arg2, arg3, arg4, arg5, arg6);
  f_EnqueueToCommRecFreeListWaiting(D_WorkNewGR);
  $RELEASE(D_WorkNewGR);
}

#PSL_define f_DcodeEnqueueToTransRecFreeListWaiting
                            (arg0, arg1, arg2, arg3, arg4, arg5)
{
  s_AllocVariable(arg2);
  s_AllocVariable(arg3);
  s_AllocVariable(arg4);
  s_AllocVariable(arg5);
  $USE(D_WorkNewGR);
  $CALL ( f_Make_DcodeGoalRecord_Sub (D_WorkNewGR) );
  s_PutImmArityGoalRecord(D_WorkNewGR, _DCODE_GOAL_ARITY6);
  $USE(D_WorkDcodeaddr);
  f_GetDcodeAddress(BLT_B_SCSI_TRANSFER, D_WorkDcodeaddr);
  s_PutCodeGoalRecord(D_WorkNewGR, D_WorkDcodeaddr);
  $RELEASE(D_WorkDcodeaddr);
  f_Put6ArgsGoalRecord 
      (D_WorkNewGR, arg0, arg1, arg2, arg3, arg4, arg5);
  f_EnqueueToTransRecFreeListWaiting(D_WorkNewGR);
  $RELEASE(D_WorkNewGR);
}

/******************************************************************** PSL **
f_IfScsiInvalidKind(src_reg)

       written by f-doumae@icot22      on Fri Nov 16 15:04:29 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#CTRL_define f_IfScsiInvalidKind(src_reg)
{
  b_IfEqualImm(src_reg, _ONE){
      b_SetSuccess();
  }else{
      b_IfEqualImm(src_reg, _THREE){
	  b_SetSuccess();
      }else{
	  b_IfEqualImm(src_reg, _FIVE){
	      b_SetSuccess();
	  }else{
	      b_SetFail();
	  }
      }
  }
  b_IfSuccess()
}

#CTRL_define f_IfScsiInvalidPhysicalCommandLength(src_reg)
{
  b_IfEqualImm(src_reg, _FIVE){
      b_SetSuccess();
  }else{
      b_IfEqualImm(src_reg, _NINE){
	  b_SetSuccess();
      }else{
	  b_IfEqualImm(src_reg, _ELEVEN){
	      b_SetSuccess();
	  }else{
	      b_SetFail();
	  }
      }
  }
  b_IfFail()
}

#CTRL_define f_IfScsiInvalidLogicalCommandLength(src_reg)
{
  b_IfEqualImm(src_reg, _SIX){
      b_SetSuccess();
  }else{
      b_IfEqualImm(src_reg, _TEN){
	  b_SetSuccess();
      }else{
	  b_IfEqualImm(src_reg, _TWELVE){
	      b_SetSuccess();
	  }else{
	      b_SetFail();
	  }
      }
  }
  b_IfFail()
}

/******************************************************************** PSL **
f_CopyDataBuffToStringBody

       written by f-doumae@icot22      on Thu Nov 22 14:19:02 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#PSL_define f_CopyByteDataToStringBody(string1, string2, pos_reg, len_reg)
{
  $USE(D_WorkCounter);
  $USE(D_WorkElement);
  b_SetZero(D_WorkCounter);
  LOOP(){
    s_ReadByteData(string1, D_WorkCounter, D_WorkElement);
    s_WriteByteData(D_WorkElement, string2, pos_reg);
    b_IncrementReg(D_WorkCounter);
    b_IncrementReg(pos_reg);
    b_IfGreaterEq(D_WorkCounter, len_reg){ break;}
  }
  $RELEASE(D_WorkElement);
  $RELEASE(D_WorkCounter);
}

#CTRL_define f_IfArbitrationFailure(scsi_rec)
{
    b_IfEOL(scsi_rec)
}

/******************************************************************** PSL **
f_ScsiDeferredExecution_Sub()
       written by f-takei@icot22      on Tue Oct  1 21:48:16 1991

<Arguments>
    $B$J$7!#(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    $B8e=hM}%-%e!<$+$i!"%3%^%s%I%l%3!<%I$^$?$O%;%l%/%7%g%s%l%3!<%I$r(B
    $B%G%-%e!<$7!"3F!9$N=hM}$r9T$&!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#SUBROUTINE f_ScsiDeferredExecution_Sub()
{
    $USE(D_WorkRec);
    LOOP(){
	f_IfNotEmptyDeferredExec(){
	    f_DequeueFromDeferredExec(D_WorkRec);
	    s_IfScsiCommRec(D_WorkRec){
		$CALL(f_ScsiInitiatorResultReport_Sub(D_WorkRec));
	    }else{
		s_IfScsiSelectRec(D_WorkRec){
		    $CALL(f_ScsiSelectedReport_Sub(D_WorkRec));
		}else{
		    @DEBUG{
			VPIM_ERROR("f_ScsiDeferredExecution_Sub",
				   "illegal pointer");
		    };
		}
	    }
	}else{
	    break;
	}
    }
    $RELEASE(D_WorkRec);
    b_ResetEventFlag(_SCSI_DEFERRED_EXEC_EVENT, D_PE_Number);
    /* $B%;%k%U%$%Y%s%H$r$*$m$9!#(B*/
    $RETURN();
}

/******************************************************************** PSL **
f_ScsiInterruptHandling_Sub
       written by f-takei@icot22      on Wed Oct  2 16:20:57 1991

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    SCSI $B$+$i$N3d$j9~$_=hM}$r$*$3$J$&!#(B
    $B<u$1IU$1$k(B($B=hM}$r9T$&(B)$B3d$j9~$_MW0x$O!"(BSelected, Reseleced $B$N$U$?$D$G$"$k!#(B
<Examples>
<Test>
<Explanation>
    $B$3$3$K=q$$$?%3!<%G%#%s%0$O%F%9%H%3!<%G%#%s%0$H$7$F$G$"$k!#(B
    $B%3!<%ICf$N%3%a%s%H$K$b=q$$$?$h$&$K!"3d$j9~$_MW0xJL$K8F$S=P$9%k!<%A%s$O!"(B
    $B<B:]$K$O4{B8$N=hM}%k!<%A%s$H0c$$$,$"$k!#(B
    $B=>$C$F<BAu;~$K$O!"7k2LJs9p=hM}$r8e=hM}(B(cf. f_ScsiDeferredExecution_Sub)
    $B$H$9$k$b$N$K$J$k!#(B
<ETC>
********************************************************************* PSL **/

#SUBROUTINE f_ScsiInterruptHandling_Sub()
{
    $USE(D_WorkInterrupt);
    b_GetScsiInterrupt(D_WorkInterrupt);
    b_IfScsiInterruptSelected(D_WorkInterrupt){
	$CALL(f_ScsiSelected_Sub());
	/*------------------------------------------------------------------
	  $B<B:]$O!"(Bf_ScsiSelected_Sub $B$NFb(B f_ScsiSelectedReport_Sub $B$N(B
	  $B8F$S=P$7$r9T$o$J$:!"8e=hM}%-%e!<$K%(%s%-%e!<$9$k=hM}%k!<%A%s$H$J$k!#(B
	 -------------------------------------------------------------------*/
	b_ResetScsiInterruptSelected();
    }else{
	b_IfScsiInterruptReselected(D_WorkInterrupt){
	    $CALL(f_ScsiReselected_Sub());
	    /*-----------------------------------------------------
	      $B<B:]$O!"(Bf_ScsiReselected_Sub $B$NFb!"7k2LJs9p$r9T$o$:$K(B
	      $B8e=hM}%-%e!<$K%(%s%-%e!<$9$k=hM}%k!<%A%s$H$J$k!#(B
	     -----------------------------------------------------*/
	    b_ResetScsiInterruptReselected();
	}
    }
    $RELEASE(D_WorkInterrupt);
    b_SetEventFlag(_SCSI_DEFERRED_EXEC_EVENT, D_PE_Number);
    /* $B%;%k%U%$%Y%s%H$r$"$2$k!#(B*/
    $RETURN();
}
