  
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_scsi_intr_terminate.psl.c
   ----- CREATED   : by f-doumae@icot22, on Tue Oct  2 16:51:29 1990
   ----- LAST SAVED: by f-takei@icot22, on Wed Jul 22 10:41:19 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : $B%3%^%s%I<B9T=*N;(B
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */
/******************************************************************** PSL **
1. $B%3%^%s%I<B9T=*N;$N3NG'(B
       written by f-takei@icot22      on Wed Sep 19 14:24:12 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  $B%3%^%s%I<B9T8e$N=*N;%a%C%;!<%8$N<uNN$r9T$&!#(B
  $B4|BT$9$k%U%'!<%:$O%a%C%;!<%8%$%s%U%'!<%:$@$,!"B>$N%U%'!<%:$,%?!<%2%C%H$+$i(B
  $BMW5a$5$l$?>l9g$K$O!"0J2<$N$h$&$J=hM}$H$J$k!#(B

    $B!&%a%C%;!<%8%$%s%U%'!<%:(B
        $B<uNN$7$?%a%C%;!<%8$K$h$j=hM}$r9T$&!#(B
    $B!&%a%C%;!<%8%"%&%H%U%'!<%:(B
        "NOP"$B%a%C%;!<%8$rAw=P$7$F!"%^%/%m$N%H%C%W%l%Y%k$KLa$k!#(B
    $B!&%9%F!<%?%9%U%'!<%:(B
        $BE>Aw%"%\!<%H=hM}$r9T$&!#(B
    $B!&%G!<%?%$%s%U%'!<%:(B
        $BE>Aw%"%\!<%H=hM}$r9T$&!#(B
    $B!&%G!<%?%"%&%H%U%'!<%:(B
        $BE>Aw%"%\!<%H=hM}$r9T$&!#(B
    $B!&%3%^%s%I%U%'!<%:(B
        $BE>Aw%"%\!<%H=hM}$r9T$&!#(B

  $B=hM}FbMF$N>\:Y$O0J2<$NDL$j!#(B

  1.$B%P%9%U%j!<%U%'!<%:8!=P!&%j%;%C%H%3%s%G%#%7%g%s8!=P$N%A%'%C%/(B
    $B$3$N(B2$B$D$N>uBV$O$$$D$G$b5/$3$jF@$k$?$a!"E>Aw$N<B9TA0$K%A%'%C%/$r$7$F8!=P$5$l(B
    $B$F$$$l$P$=$N=hM}$r9T$&!#(B
  2.$B%?!<%2%C%H$NMW5a%U%'!<%:$N<B9T(B
       ($B4|BT%U%'!<%:(B:$B%a%C%;!<%8%$%s%U%'!<%:(B)
    $BMW5a%U%'!<%:$K$h$j0J2<$N$h$&$K$J$k!#(B
    A.$B%a%C%;!<%8%$%s%U%'!<%:(B
      $B!&%a%C%;!<%8$r(B1$B%P%$%H<uNN$9$k!#(B
      $B!&<uNN$7$?%a%C%;!<%8$h$j=hM}$,$o$+$l$k!#(B
        $B$3$3$G!"4|BT$9$k%a%C%;!<%8$O(B"Command Complete"$B$G$"$k$,!"$=$NB>$N>l9g(B
        $B$K$b0J2<$N$h$&$K1~$8$k!#(B
        - Command Complete
            $B@5>o=*N;$H$7$F!"7k2LJs9p=hM}$K0\$k!#(B
        - Save Data Pointer
            $B%+%l%s%H%G!<%?%]%$%s%?(BD_CurrentDataPtrReg$B$NCM$r%3%^%s%I%l%3!<%I(B
            $BCf$NBTHrNN0h$K%;!<%V$9$k!#(B
        - Restore Pointers
            $B%3%^%s%I%l%3!<%ICf$NBTHr%G!<%?%]%$%s%?$NCM$r%+%l%s%H%G!<%?(B
            $B%]%$%s%?$H$7$F%m!<%I$7!"%^%/%m$N%H%C%W%l%Y%k$KLa$k!#(B
        - Disconnect
          $B%G%#%9%3%M%/%H=hM}$r9T$&!#(B
        $B0J2<$N>l9g$OE>Aw%"%\!<%H=hM}$r9T$&!#(B
        - Message Reject
        - Linked Command Complete
        - Linked Command Complete With Flag
        - Identify
        $B0J2<$N>l9g$OL$5-=R!#(B
        - $B3HD%%a%C%;!<%8(B
    B.$B%a%C%;!<%8%"%&%H%U%'!<%:(B
       "NOP"$B%a%C%;!<%8$rAw=P$7$F%^%/%m$N%H%C%W%l%Y%k$KLa$k!#(B
    C.$B%9%F!<%?%9%U%'!<%:(B
      $BE>Aw%"%\!<%H=hM}$r9T$&!#(B
    D.$B%G!<%?%$%s%U%'!<%:(B
      $BE>Aw%"%\!<%H=hM}$r9T$&!#(B
    E.$B%G!<%?%"%&%H%U%'!<%:(B
      $BE>Aw%"%\!<%H=hM}$r9T$&!#(B
    F.$B%3%^%s%I%U%'!<%:(B
      $BE>Aw%"%\!<%H=hM}$r9T$&!#(B
<ETC>
********************************************************************* PSL **/
#DATA_define D_WorkData  XXX
#DATA_define D_WorkDataBuff XXX
#DATA_define D_WorkNewData XXX
#DATA_define D_WorkSlot   XXX
#DATA_define D_WorkTransLen XXX

#SUBARG_define A_CommRec SRC
#SUBARG_define A_Phase   DST

#SUBROUTINE f_ScsiInitiatorTerminate_Sub(A_CommRec, A_Phase)
{
  Transfer:
    /*--- Disconnected, Reset Condition $B3d$j9~$_$N%A%'%C%/(B---*/
    b_IfScsiAnyInterrupt(){
	f_ScsiInitiatorInterruptCheck(A_CommRec, A_Phase);
	goto END;
    }

    $USE(D_WorkPhase);
    b_GetScsiPhase(D_WorkPhase);
    ValueSwitch(D_WorkPhase){
      case _MESSAGE_IN_PHASE:
	$RELEASE(D_WorkPhase);
	$USE(D_WorkMessage);
	b_ScsiInitiatorReceiveDataByManual(D_WorkMessage);
	/* SPC$B$N%^%K%e%"%kE>Aw$G%a%C%;!<%8$r(B1$B%P%$%H<uNN(B */
	b_IfScsiParityError(){
	    $RELEASE(D_WorkMessage);
	    f_ScsiInitiatorParityErrorHandlingInput(A_CommRec, A_Phase);
	    goto END;
	}
	ValueSwitch(D_WorkMessage){
	  case _MSG_COMMAND_COMPLETE:
	    $RELEASE(D_WorkMessage);
	    b_BusyWaitScsiDisconnected();
	    /* $B40N;>uBV$N%;%C%H(B */
	    s_SetResultCodeCommRecMsgReceived(A_CommRec);
	    b_SetImmValueDNTC(_RESULT_REPORT, A_Phase);
	    break;
	  case _MSG_SAVE_DATA_POINTER:
	    $RELEASE(D_WorkMessage);
	    s_SetScsiCommRecDataPtr (D_CurrentDataPtrReg, A_CommRec);
	    goto Transfer;
	  case _MSG_DISCONNECT:
	    $RELEASE(D_WorkMessage);
	    s_SetScsiCommRecImmNextPhase(_INITIATOR_TERMINATE, A_CommRec);
	    f_EnqueueToExecutingList (A_CommRec);
	    b_BusyWaitScsiDisconnected();
	    b_SetImmValueDNTC (_POP_NEXT_COMM_REC, A_Phase);
	    break;
	  case _MSG_RESTORE_POINTERS:
	    $RELEASE(D_WorkMessage);
	    s_GetScsiCommRecDataPtr(A_CommRec, D_CurrentDataPtrReg);
	    /* $B%3%^%s%I%l%3!<%IFb$N%G!<%?%]%$%s%?$N$_$r%j%9%H%"$9$k!#(B */
	    goto Transfer;
	  case _EXTENDED_MSGS:
	    /* $BJ]N1(B */
	  case _MSG_MESSAGE_REJECT:
	  case _MSG_LINKED_COMMAND_COMPLETE:
	  case _MSG_LINKED_COMMAND_COMPLETE_WITH_FLAG:
	  default:
	    b_IfScsiIdentifyMsg(D_WorkMessage){
		;
	    }
	    $RELEASE(D_WorkMessage);
	    /* $B40N;>uBV$N>pJs%9%m%C%H$N%;%C%H(B */
	    s_SetErrorCodeCommRec(_UNEXPECTED_MSG, A_CommRec);
	    f_ScsiInitiatorErrorEnd(A_CommRec, A_Phase);
	    goto END;
	}
	break;
      case _MESSAGE_OUT_PHASE:
	$RELEASE(D_WorkPhase);
	b_ScsiInitiatorSendMessageByManual(_MSG_NOP);
	b_IfScsiParityError(){
	    f_ScsiInitiatorParityErrorHandlingOutput(A_CommRec, A_Phase);
	    goto END;
	}
	goto Transfer;
      case _STATUS_PHASE:
      case _COMMAND_PHASE:
      case _DATA_IN_PHASE:
      case _DATA_OUT_PHASE:
	$RELEASE(D_WorkPhase);
	/* $B40N;>uBV$N>pJs%9%m%C%H$N%;%C%H(B */
	s_SetErrorCodeCommRec(_UNEXPECTED_PHASE, A_CommRec);
	f_ScsiInitiatorErrorEnd(A_CommRec, A_Phase);
	break;
      case _BUS_FREE_PHASE:
	$RELEASE(D_WorkPhase);
	$USE(D_WorkInterrupt);
	b_GetScsiInterrupt(D_WorkInterrupt);
	b_IfScsiInterruptDisconnected(D_WorkInterrupt){
	    $RELEASE(D_WorkInterrupt);
	    b_ResetScsiInterruptDisconnected();
	    s_SetErrorCodeCommRec(_DISCONNECTED, A_CommRec);
	    s_OrResultCodeCommRec(_SCSI_ERROR_END, A_CommRec);
	    b_SetImmValueDNTC(_RESULT_REPORT, A_Phase);
	    break;
	}
	$RELEASE(D_WorkInterrupt);
      default:
	@DEBUG{
	    VPIM_ERROR("f_ScsiInitiatorTerminate_Sub","unknown phase.");
	};
    }
  END:
    $RETURN();
}

/******************************************************************** PSL **
6. $B%3%^%s%I<B9T=*N;$N8e=hM}(B(KL1$BJQ?t$N%f%K%U%!%$(B)

       written by f-doumae@icot22      on Wed Sep 26 20:58:53 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    $B%3%^%s%I<B9T$,=*N;$7$?8e!"$=$N=*N;>u67$NJs9p$r(BKL1$BJQ?t$N%f%K%U%!%$$K$h$C$F(B
    $B9T$J$&!#(B
<Examples>
<Test>
<Explanation>
     $B7k2L$N%f%K%U%#%1!<%7%g%s$r9T$J$&%4!<%k$r%(%s%-%e!<$9$k!#(B
<ETC>
********************************************************************* PSL **/
#DATA_define D_WorkResultCode XXX

#SUBARG_define  A_CommRec  SRC

#SUBROUTINE f_ScsiInitiatorResultReport_Sub(A_CommRec)
{
  /*---- (1) KL1$B=PNOJQ?t(BNewData$B$N%f%K%U%#%1!<%7%g%s(B -------*/
  $USE(D_WorkDirection);
  s_GetScsiCommRecDirection(A_CommRec, D_WorkDirection);
  b_IfEqualImm(D_WorkDirection, _DIR_DATA_IN){
  /*------------------------------------------------------------
    $BE>AwJ}8~$,(Bdata_in$B$N;~$O!"%G!<%?%P%C%U%!$NFbMF$r(BKL1$B=PNOJQ?t(BData$B$K(B
    $BMWAG0LCV(BDataP$B$+$i%3%T!<$9$k!#(B
   --------------------------------------------------------------*/
    $USE(D_WorkData1);
    $USE(D_WorkDataPos);
    $USE(D_WorkDataBuff);
    $USE(D_WorkDataLen);
    s_GetScsiCommRecOldData(A_CommRec, D_WorkData1);
    s_GetScsiCommRecDataPos(A_CommRec, D_WorkDataPos);
    s_GetScsiCommRecDataCounter(A_CommRec, D_WorkDataLen);
    s_GetScsiCommRecPtrToDataBuff(A_CommRec, D_WorkDataBuff);
    f_CopyByteDataToStringBody
	(D_WorkDataBuff, D_WorkData1, D_WorkDataPos, D_WorkDataLen);
    $RELEASE(D_WorkDataLen);
    $RELEASE(D_WorkDataBuff);
    $RELEASE(D_WorkDataPos);
    $RELEASE(D_WorkData1);
  }
  $RELEASE(D_WorkDirection);
  $USE(D_WorkFPPtr);
  $USE(D_WorkEnvRecPtr);
  s_GetScsiCommRecEnvironment(A_CommRec, D_WorkEnvRecPtr);
  s_GetScsiCommRecFPPtr(A_CommRec, D_WorkFPPtr);

  $USE(D_WorkData1);
  $USE(D_WorkNewData);
  s_GetScsiCommRecOldData(A_CommRec, D_WorkData1);
  s_GetScsiCommRecNewData(A_CommRec, D_WorkNewData);
  $CALL( f_UnifyRetryInOtherFP_Sub
	(D_WorkFPPtr, D_WorkEnvRecPtr, D_WorkData1, D_WorkNewData));
  /* OldData$B$H(BNewData$B$r%f%K%U%!%$$9$k%4!<%k$r%(%s%-%e!<$9$k!#(B*/
  $RELEASE(D_WorkNewData);
  $RELEASE(D_WorkData1);

  /*  (2) KL1$B=PNOJQ?t(BResult $B$N%f%K%U%#%1!<%7%g%s(B -------*/
  /*------------------------------------------------------------------
    $B%3%^%s%I$N40N;>uBV$rJ];}$9$k%9%m%C%H(BErrorCode(16bit),ResultCode(8bit),
    Status(8bit)$B$r(B32$B%S%C%H$K%(%s%3!<%I$9$k!#(B
   -------------------------------------------------------------------*/
  $USE(D_WorkSlot);
  $USE(D_WorkResultCode);
  s_GetScsiCommRecErrorCode(A_CommRec, D_WorkSlot);
  b_ShiftLeftImmediateWithTag(D_WorkSlot, _SHIFT_LEN_16, D_WorkResultCode);
  s_GetScsiCommRecResultCode(A_CommRec, D_WorkSlot);
  b_ShiftLeftImmediateWithDNTC(D_WorkSlot, _SHIFT_LEN_8, D_WorkSlot);
  b_BitwiseOrWithTag(D_WorkResultCode, D_WorkSlot, D_WorkResultCode);
  s_GetScsiCommRecStatus(A_CommRec, D_WorkSlot);
  b_BitwiseOrWithTag(D_WorkResultCode, D_WorkSlot, D_WorkResultCode);
  s_GetScsiCommRecResult(A_CommRec, D_WorkSlot);
  $CALL (f_UnifyRetryInOtherFP_Sub
	 (D_WorkFPPtr, D_WorkEnvRecPtr, D_WorkResultCode, D_WorkSlot));
  /* Result$B$H%3%^%s%I40N;>uBVCM$r%f%K%U%!%$$9$k%4!<%k$r%(%s%-%e!<$9$k!#(B*/
  $RELEASE(D_WorkResultCode);
  $RELEASE(D_WorkSlot);

  /*  (3) KL1$B=PNOJQ?t(BTransferredLength $B$N%f%K%U%#%1!<%7%g%s(B -------*/
  $USE(D_WorkDataCtr1);
  $USE(D_WorkTransLen);
  s_GetScsiCommRecDataCounter(A_CommRec, D_WorkDataCtr1);
  s_GetScsiCommRecTransLength(A_CommRec, D_WorkTransLen);
  $CALL ( f_UnifyRetryInOtherFP_Sub
	 (D_WorkFPPtr, D_WorkEnvRecPtr, D_WorkDataCtr1, D_WorkTransLen));
  $RELEASE(D_WorkTransLen);
  $RELEASE(D_WorkDataCtr1);

  $RELEASE(D_WorkFPPtr);
  $RELEASE(D_WorkEnvRecPtr);

  /*----- $B$3$3$G(B1$B$D$N(Bscsi_command$B$N=hM}$,$9$Y$F=*7k$9$k!#(B-----*/
  $RETURN();
}

