
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_scsi_intr_status_transfer.psl.c
   ----- CREATED   : by f-doumae@icot22, on Tue Oct  2 16:49:42 1990
   ----- LAST SAVED: by f-takei@icot22, on Wed Jul 22 10:41:42 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : $B%9%F!<%?%9E>Aw$N<B9T(B

  $B%9%F!<%?%9%P%$%H$NE>Aw$r9T$&!#4|BT$9$k%U%'!<%:$O%9%F!<%?%9%U%'!<%:$G$"$k$,!"(B
  $BB>$N%U%'!<%:$,%?!<%2%C%H$+$iMW5a$5$l$?>l9g$O!"0J2<$N$h$&$J=hM}$H$J$k!#(B

    $B!&%9%F!<%?%9%U%'!<%:(B
        $B%9%F!<%?%9%P%$%H$r<uNN$7!"%3%^%s%I<B9T=*N;>uBV$K0\$k!#(B
    $B!&%a%C%;!<%8%$%s%U%'!<%:(B
        $B<uNN$7$?%a%C%;!<%8$K$h$j=hM}$r9T$&!#(B
    $B!&%a%C%;!<%8%"%&%H%U%'!<%:(B
        "NOP"$B%a%C%;!<%8$rAw=P$7$F!":F$S%9%F!<%?%9E>Aw>uBV$KLa$k!#(B
    $B!&%G!<%?%$%s%U%'!<%:(B
        $BE>Aw%"%\!<%H=hM}$r9T$&!#(B
    $B!&%G!<%?%"%&%H%U%'!<%:(B
        $BE>Aw%"%\!<%H=hM}$r9T$&!#(B
    $B!&%3%^%s%I%U%'!<%:(B
        $BE>Aw%"%\!<%H=hM}$r9T$&!#(B

  $B=hM}FbMF$N>\:Y$O0J2<$NDL$j!#(B

  1.$B%P%9%U%j!<%U%'!<%:8!=P!&%j%;%C%H%3%s%G%#%7%g%s8!=P$N%A%'%C%/(B
    $B$3$N(B2$B$D$N>uBV$O$$$D$G$b5/$3$jF@$k$?$a!"E>Aw$N<B9TA0$K%A%'%C%/$r$7$F8!=P$5$l(B
    $B$F$$$l$P$=$N=hM}$r9T$&!#(B
  2.$B%?!<%2%C%H$NMW5a%U%'!<%:$N<B9T(B
       ($B4|BT%U%'!<%:(B:$B%9%F!<%?%9%U%'!<%:(B)
    $BMW5a%U%'!<%:$K$h$j0J2<$N$h$&$K$J$k!#(B
    A.$B%9%F!<%?%9%U%'!<%:(B
      $B!&(BSPC$B$N(BTransfer$B%3%^%s%I$rMQ$$$F(B1$B%P%$%H$N%G!<%?(B($B%9%F!<%?%9%P%$%H(B)$B$r(B
        $B<uNN$9$k!#(B
      $B!&<B9T7k2L$O(BSPC$B$N3d$j9~$_$K$h$jH=Dj$9$k!#(B
        - Command Complete$B3d$j9~$_(B
          Transfer$B%3%^%s%I$N@5>o=*N;!#(B
          <$B=hM}(B>
           $B!&%Q%j%F%#%(%i!<$,8!=P$5$l$F$$$J$1$l$P%3%^%s%I=*N;3NG'$K0\$k!#(B
           $B!&%Q%j%F%#%(%i!<$,8!=P$5$l$F$$$l$PE>Aw%"%\!<%H=hM}$r9T$&!#(B
        - Service Required$B3d$j9~$_(B
          $B;XDj$7$?E>Aw%P%$%H?t$NE>Aw=*N;A0$K%?!<%2%C%H$,%U%'!<%:$rJQ99$7$?!#(B
          $B%G%#%9%3%M%/%HMW5a$N$?$a$N%U%'!<%:JQ99$b9M$($i$l$k$N$G!"0J2<$N(B
          $B$h$&$J=hM}FbMF$H$J$k!#(B
          <$B=hM}(B>
           $B!&%Q%j%F%#%(%i!<$,8!=P$5$l$F$$$k>l9g!#(B
             - $BE>Aw%"%\!<%H=hM}$r9T$&!#(B
           $B!&%Q%j%F%#%(%i!<$,8!=P$5$l$F$$$J$$>l9g!#(B
             - $B%^%/%m$N%H%C%W%l%Y%k$KLa$k!#(B
        - Disconnected$B3d$j9~$_(B
          $B%P%9%U%j!<%U%'!<%:$r8!=P$7$?!#(B
          <$B=hM}(B>
           $B!&%(%i!<=*N;=hM}$K0\$k!#(B
        - SPC Hardware Error$B3d$j9~$_(B
          SPC$B$N%O!<%I%&%(%"%(%i!<$r8!=P$7$?!#(B
          $B$3$3$G$O!"E>Aw%P%$%H%+%&%s%?$X$N=q$-9~$_;~$N%Q%j%F%#$N8m$j!"$"$k$$$O(B
          REQ, ACK$B?.9f$NGH7A3d$l$,9M$($i$l$k!#(B
           $B!&E>Aw%"%\!<%H=hM}$r9T$&!#(B
        - Reset Condition$B3d$j9~$_(B
  B.$B%a%C%;!<%8%$%s%U%'!<%:(B
    $B!&%a%C%;!<%8$r(B1$B%P%$%H<uNN$9$k!#(B
    $B!&<uNN$7$?%a%C%;!<%8$N<oN`$K$h$j=hM}$,$o$+$l$k!#(B
      $B0J2<$N>l9g$O$=$l$>$l$N=hM}$r9T$C$?8e$K!"%^%/%m$N%H%C%W%l%Y%k$KLa$k!#(B
      - Save Data Pointer
          $B%+%l%s%H%G!<%?%]%$%s%?(BD_CurrentDataPtrReg$B$NCM$r%3%^%s%I%l%3!<%I(B
          $BCf$NBTHrNN0h$K%;!<%V$9$k!#(B
      - Disconnect
          $B%G%#%9%3%M%/%H=hM}$r9T$&!#(B
      - Restore Pointers
          $B%3%^%s%I%l%3!<%ICf$NBTHr%G!<%?%]%$%s%?$NCM$r%+%l%s%H%G!<%?(B
          $B%]%$%s%?$H$7$F%m!<%I$7!"%^%/%m$N%H%C%W%l%Y%k$KLa$k!#(B
      - Command Complete
          $B%3%^%s%I%l%3!<%IFb$N(BResult$B%U%#!<%k%I$K(BCommand Complete$B%a%C%;!<%8$r(B
          $B<uNN$7$?$3$H$r5-O?$9$k!#(B
          $BE>Aw%"%\!<%H=hM}$r9T$&!#(B
      $B0J2<$N>l9g$OE>Aw%"%\!<%H=hM}$r9T$&!#(B
      - Message Reject
      - Linked Command Complete
      - Linked Command Complete With Flag
      - Identify
      $B0J2<$N>l9g$OL$5-=R!#(B
      - $B3HD%%a%C%;!<%8(B
  C.$B%a%C%;!<%8%"%&%H%U%'!<%:(B
    "NOP"$B%a%C%;!<%8$rAw=P$7$F%^%/%m$N%H%C%W%l%Y%k$KLa$k!#(B
  D.$B%G!<%?%$%s%U%'!<%:(B
    $BE>Aw%"%\!<%H=hM}$r9T$&!#(B
  E.$B%G!<%?%"%&%H%U%'!<%:(B
    $BE>Aw%"%\!<%H=hM}$r9T$&!#(B
  F.$B%3%^%s%I%U%'!<%:(B
    $BE>Aw%"%\!<%H=hM}$r9T$&!#(B

<Revised Memo on "Jul  3">
    A.$B%9%F!<%?%9%U%'!<%:(B
       $BE>Aw=*N;8e$N3d$j9~$_8!=P(B
       - Selected, Reselected, Time Out
           Fatal Error $B$H$7$F8!=P;~$N=hM}$K0\$k!#(B
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

#SUBARG_define A_CommRec SRC
#SUBARG_define A_Phase   DST

#SUBROUTINE f_ScsiStatusTransferPhase_Sub(A_CommRec, A_Phase)
{
  Transfer:
    /*--- Disconnected, Reset Condition $B3d$j9~$_$N%A%'%C%/(B---*/
    b_IfScsiAnyInterrupt(){
	f_ScsiInitiatorInterruptCheck(A_CommRec, A_Phase);
	goto END;
    }

    $USE(D_WorkPhase);
    b_GetScsiPhase(D_WorkPhase);
    ValueSwitch(D_WorkPhase){
      case _STATUS_PHASE:
	$RELEASE(D_WorkPhase);
	$USE(D_WorkStatusReg);
	b_ScsiInitiatorReceiveStatus(D_WorkStatusReg);
	/* 1$B%P%$%H(B($B%9%F!<%?%9%P%$%H(B)$B<uNN(B */
	$RELEASE(D_WorkStatusReg);

	/*--- $BE>Aw7k2L$N2r@O(B ---*/
	$USE(D_WorkInterrupt);
	b_GetScsiInterrupt(D_WorkInterrupt);
	b_IfScsiInterruptResetCondition(D_WorkInterrupt){
	    $RELEASE(D_WorkInterrupt);
	    b_SetImmValueDNTC (_ERROR_END, A_Phase);
	    goto END;
	}
	b_IfScsiInterruptSPCHardwareError(D_WorkInterrupt){
	    $RELEASE(D_WorkInterrupt);
	    f_ScsiInitiatorIntrHardwareErrorHandling
		                       (A_CommRec, A_Phase);
	    goto END;
	}
	b_IfScsiInterruptCommandComplete(D_WorkInterrupt){
	    $RELEASE(D_WorkInterrupt);
	    f_ScsiInitiatorIntrCommandCompleteHandlingInput(A_CommRec,A_Phase);
	    b_IfZero(A_Phase){ /* $B%9%F!<%?%9%P%$%H$r@5>o$K<uNN(B */
		b_SetImmValueDNTC(_INITIATOR_TERMINATE, A_Phase);
		s_SetScsiCommRecStatus(D_WorkStatusReg, A_CommRec);
		/* $B%9%F!<%?%9%P%$%H$N3JG<(B */
	    }
	    goto END;
	}
	b_IfScsiInterruptServiceRequired(D_WorkInterrupt){
	    $RELEASE(D_WorkInterrupt);
	    f_ScsiInitiatorIntrServiceRequiredHandlingInput(A_CommRec,A_Phase);
	    b_IfZero(A_Phase){
		b_SetImmValueDNTC(_STATUS_TRANSFER, A_Phase);
		goto Transfer;
		/* $B%G%#%9%3%M%/%HMW5a$N$?$a$N%U%'!<%:JQ99$KHw$($k!#(B*/
	    }else{
		goto END;
	    }
	}
	b_IfScsiInterruptDisconnected(D_WorkInterrupt){
	    $RELEASE(D_WorkInterrupt);
	    f_ScsiInitiatorIntrDisconnectedHandlingInput(A_CommRec, A_Phase);
	    goto END;
	}
	/* Fatal Error */
	b_IfScsiInterruptSelected(D_WorkInterrupt){
	    $RELEASE(D_WorkInterrupt);
	    b_SetImmValueDNTC(_FATAL_ERROR_END, A_Phase);
	    goto END;
	}
	b_IfScsiInterruptReselected(D_WorkInterrupt){
	    $RELEASE(D_WorkInterrupt);
	    b_SetImmValueDNTC(_FATAL_ERROR_END, A_Phase);
	    goto END;
	}
	b_IfScsiInterruptTimeOut(D_WorkInterrupt){
	    $RELEASE(D_WorkInterrupt);
	    b_SetImmValueDNTC(_FATAL_ERROR_END, A_Phase);
	    goto END;
	}
	/* Fatal Error */
	b_SetImmValueDNTC(_FATAL_ERROR_END, A_Phase);
	@DEBUG{
	    b_IfScsiInterruptSelected(D_WorkInterrupt){
		;
	    }else{
		b_IfScsiInterruptReselected(D_WorkInterrupt){
		    ;
		}else{
		    b_IfScsiInterruptTimeOut(D_WorkInterrupt){
			;
		    }else{
			VPIM_ERROR("f_ScsiStatusTransferPhase_Sub",
				   "Unknown data on register");
		    };
		}
	    }
	};
	$RELEASE(D_WorkInterrupt);
	goto END;
      case _MESSAGE_IN_PHASE:
	$RELEASE(D_WorkPhase);
	$USE(D_WorkMessage);
	b_ScsiInitiatorReceiveDataByManual(D_WorkMessage);
	/* SPC$B$N%^%K%e%"%kE>Aw$G%a%C%;!<%8$r(B1$B%P%$%H<uNN(B */
	b_IfScsiParityError(){
	    $RELEASE(D_WorkMessage);
	    f_ScsiInitiatorParityErrorHandlingInput(A_CommRec, A_Phase);
	    break;
	}
	ValueSwitch (D_WorkMessage){
	  case _MSG_SAVE_DATA_POINTER:
	    $RELEASE(D_WorkMessage);
	    s_SetScsiCommRecDataPtr (D_CurrentDataPtrReg, A_CommRec);
	    goto Transfer;
	  case _MSG_DISCONNECT:
	    $RELEASE(D_WorkMessage);
	    s_SetScsiCommRecImmNextPhase(_STATUS_TRANSFER, A_CommRec); 
	    f_EnqueueToExecutingList (A_CommRec);
	    b_BusyWaitScsiDisconnected();
	    b_SetImmValueDNTC (_POP_NEXT_COMM_REC, A_Phase);
	    break;
	  case _MSG_RESTORE_POINTERS:
	    $RELEASE(D_WorkMessage);
	    s_GetScsiCommRecDataPtr(A_CommRec, D_CurrentDataPtrReg);
	    /* $B%3%^%s%I%l%3!<%IFb$N%G!<%?%]%$%s%?$N$_$r%j%9%H%"$9$k!#(B */
	    goto Transfer;
	  case _MSG_COMMAND_COMPLETE:
	    s_SetResultCodeCommRecMsgReceived(A_CommRec);
	  case _EXTENDED_MSGS:
	    /* $BJ]N1(B */
	  case _MSG_MESSAGE_REJECT:
	  case _MSG_LINKED_COMMAND_COMPLETE:
	  case _MSG_LINKED_COMMAND_COMPLETE_WITH_FLAG:
	  default:
	    b_IfScsiIdentifyMsg(D_WorkMessage){
		;
	    }
	    $RELEASE(D_WorkMessage);
	    /* $B40N;>uBV$N>pJs%9%m%C%H$N@_Dj(B */
	    s_SetErrorCodeCommRec(_UNEXPECTED_MSG, A_CommRec);
	    f_ScsiInitiatorErrorEnd(A_CommRec, A_Phase);
	    break;
	}
	break;
      case _MESSAGE_OUT_PHASE:
	$RELEASE(D_WorkPhase);
	b_ScsiInitiatorSendMessageByManual(_MSG_NOP);
	b_IfScsiParityError(){
	    f_ScsiInitiatorParityErrorHandlingOutput(A_CommRec, A_Phase);
	    goto END;
	}
	goto Transfer;
      case _COMMAND_PHASE:
      case _DATA_IN_PHASE:
      case _DATA_OUT_PHASE:
	$RELEASE(D_WorkPhase);
	/* $B40N;>uBV$N>pJs%9%m%C%H$N@_Dj(B */
	s_SetErrorCodeCommRec(_UNEXPECTED_PHASE, A_CommRec);
	f_ScsiInitiatorErrorEnd(A_CommRec, A_Phase);
	break;
      case _BUS_FREE_PHASE:
	$RELEASE(D_WorkPhase);
	$USE(D_WorkInterrupt);
	b_GetScsiInterrupt(D_WorkInterrupt);
	b_IfScsiInterruptDisconnected(D_WorkInterrupt){
	    $RELEASE(D_WorkInterrupt);
	    b_ResetScsiInterruptDisconnected();
	    s_SetErrorCodeCommRec(_DISCONNECTED, A_CommRec);
	    s_OrResultCodeCommRec(_SCSI_ERROR_END, A_CommRec);
	    b_SetImmValueDNTC(_RESULT_REPORT, A_Phase);
	    break;
	}
	$RELEASE(D_WorkInterrupt);
      default:
	@DEBUG{
	    VPIM_ERROR("f_ScsiStatusTransferPhase_Sub",
		       "What happened?");
	};
    }
  END:
    $RETURN();
}
