
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_scsi_intr_selection.psl.c
   ----- CREATED   : by f-doumae@icot22, on Tue Oct  2 16:42:03 1990
   ----- LAST SAVED: by f-takei@icot22, on Mon Mar  9 11:31:35 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : $B%;%l%/%7%g%s$N<B9T!&(BIdentify$B%a%C%;!<%8$NAw=P(B

  $BM=Ls$5$l$?%3%^%s%I$r<B9T$9$k$?$a$N%;%l%/%7%g%s$N<B9T5Z$S(B"Identify"$B%a%C%;!<%8(B
  $B$NAw=P$r9T$&!#%;%l%/%7%g%s%U%'!<%:$N<B9T$O!"(BSPC$B$KBP$7$F(BSelect$B%3%^%s%I$rH/9T(B
  $B$9$k$3$H$K$h$C$F9T$&!#(BSelect$B%3%^%s%I$N<B9T7k2L$O!"(BSPC$B$N8!=P$9$k3d$j9~$_$H(B
  SCSI$B$H$N@\B3>uBV$K$h$jH=JL$9$k!#(B
  $B<B9T7k2L$H$=$N=hM}FbMF$O0J2<$NDL$j!#(B

    A.$B%$%K%7%(!<%?$H$7$F@\B3$5$l$F$$$k>l9g(B
      $B!&(BReselected$B3d$j9~$_8!=P(B
        $BB>%P%9%G%P%$%9$+$i%j%;%l%/%H$5$l$?!#(B
        <$B=hM}(B>
         $B!&Ev3:%3%^%s%I%l%3!<%I$r%P%98"%-%e!<$K%(%s%-%e!<$9$k!#(B
         $B!&%j%;%l%/%H;~$N=hM}%k!<%A%s$K0\$k!#(B
      $B!&(BCommand Complete$B3d$j9~$_8!=P(B
        Select$B%3%^%s%I$N@.8y!#(B
        <$B=hM}(B>
         $B!&(B"Identify"$B%a%C%;!<%8$NAw=P!#(B
      $B!&>e5-0J30(B
        $B%(%i!<$H$9$k(B($B$"$jF@$J$$(B)$B!#(B
    B.$B%?!<%2%C%H$H$7$F@\B3$7$F$$$k>l9g(B
      $B!&(BSelected$B3d$j9~$_8!=P(B
        $BB>%P%9%G%P%$%9$+$i%;%l%/%H$5$l$?!#(B
       <$B=hM}(B>
        $B!&Ev3:%3%^%s%I%l%3!<%I$r%P%98"%-%e!<$K%(%s%-%e!<$9$k!#(B
        $B!&%;%l%/%H;~$N=hM}%k!<%A%s$K0\$k!#(B
    C.SCSI$B$H$O@\B3$5$l$F$$$J$$>l9g(B
      $B!&(BCommand Complete$B3d$j9~$_8!=P(B
        $B%"!<%S%H%l!<%7%g%s$K<:GT$7$?!#(B
       <$B=hM}(B>
        $B!&Ev3:%3%^%s%I%l%3!<%I$r%P%98"%-%e!<$K%(%s%-%e!<$9$k!#(B
        $B!&%P%9%U%j!<%U%'!<%:8!=P3d$j9~$_$N@)8B$r30$7$F!"(B
          $B%4!<%k%j%@%/%7%g%s$KLa$k!#(B
          ($B%P%9%U%j!<%U%'!<%:$r%9%j%C%H%A%'%C%/;~$K3d$j9~$_$h$C$F8!=P$7!"(B
           $B%;%l%/%7%g%s$+$i%j%H%i%$$r9T$J$&!#(B)
      $B!&(BDisconnected$B3d$j9~$_8!=P(B
       $B%P%9%U%j!<%U%'!<%:$r8!=P$7$?!#$3$l$O!"(BSelect$B%3%^%s%I$N@.8y8e$"$k$$$O(B
       $BB>%P%9%G%P%$%9$+$i%j%;%l%/%H$5$l$?8e$K!"$9$0$K@\B3$,@Z$l$?>l9g$G$"$k!#(B
       <$B=hM}(B>
        $B!&Ev3:%3%^%s%I%l%3!<%I$r%P%98"%-%e!<$K%(%s%-%e!<$9$k!#(B
    D.Reset Condition$B3d$j9~$_8!=P(B
      <$B=hM}(B>
       $B!&%j%;%C%H%3%s%G%#%7%g%s;~$N=hM}$K0\$k!#(B
    E.SPC Hardware Error$B3d$j9~$_8!=P(B
      <$B=hM}(B>
      $B!&(BSelect$B%3%^%s%I$N%"%\!<%H=hM}$r9T$$%(%i!<=*N;$H$9$k!#(B
    F.Time Out$B3d$j9~$_(B
      $B!&%(%i!<=*N;$H$9$k!#(B
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/*----------------------------------------------------------
  $B%U%'!<%:A+0\$r<($9%3%s%9%?%s%H!#(B
  functions$B%l%Y%k$G@_Dj$5$l!"(Binterpreter$B%l%Y%k$G;2>H$5$l$k!#(B
  $B%?!<%2%C%H=hM}%^%/%m$+$i$b;2>H$5$l$k$,$3$3$K$^$H$a$FCV$/!#(B
-------------------------------------------------------------*/
#CONST_define  _COMMAND_TRANSFER        1
#CONST_define  _DATA_TRANSFER           2
#CONST_define  _STATUS_TRANSFER         3
#CONST_define  _INITIATOR_TERMINATE     4
#CONST_define  _RESULT_REPORT           5
#CONST_define  _RESELECTED              6
#CONST_define  _SELECTED                7
#CONST_define  _POP_NEXT_COMM_REC       8
#CONST_define  _ARBITRATION_FAILURE     9
#CONST_define  _ERROR_END              10
#CONST_define  _TARGET_TRANSFER        11
#CONST_define  _POP_NEXT_TRANS_REC     12
#CONST_define  _TARGET_TERMINATE       13
#CONST_define  _FATAL_ERROR_END        14

#CONST_define  _SCSI_FATAL_ERROR _RESET_CONDITION_DETECTED /* Temporary */

#DATA_define D_CurrentDataPtrReg  XXX

#DATA_define D_WorkUnit       XXX
#DATA_define D_WorkInterrupt  XXX
#DATA_define D_WorkPhase      XXX

#SUBARG_define A_CommRec    SRC
#SUBARG_define A_Phase      DST

#SUBROUTINE f_ScsiSelectionPhase_Sub(A_CommRec, A_Phase)
{
  Selection_Start:
    b_ScsiSetATN();
    $USE(D_WorkUnit1);
    s_GetScsiCommRecUnit(A_CommRec, D_WorkUnit1);
    b_ScsiSelection(D_WorkUnit1);            /* $B%;%l%/%H%3%^%s%IH/9T(B */
    $RELEASE(D_WorkUnit1);
    b_BusyWaitScsiInterrupt();            /* SCSI$B3d$j9~$_(B */

    /*--- Select$B%3%^%s%I$N<B9T7k2L$N2r@O(B ---*/
    $USE(D_WorkInterrupt);
    b_GetScsiInterrupt(D_WorkInterrupt); /* INTS$B%l%8%9%?FI$_=P$7(B */
    b_IfScsiInterruptResetCondition(D_WorkInterrupt){
	/* $B%j%;%C%H%3%s%G%#%7%g%s8!=P(B */
	$RELEASE(D_WorkInterrupt);
	b_SetImmValueDNTC(_ERROR_END, A_Phase);
	goto END;
    }
    b_IfScsiInterruptTimeOut(D_WorkInterrupt){
	/* $B%?%$%`%"%&%H8!=P(B */
	$RELEASE(D_WorkInterrupt);
	b_ResetScsiInterruptTimeOut();
	s_OrResultCodeCommRec(_CANCELED_BEFORE_EXEC, A_CommRec);
	s_SetErrorCodeCommRec(_TIME_OUT, A_CommRec);
	b_SetImmValueDNTC(_RESULT_REPORT, A_Phase);
	goto END;
    }
    b_IfScsiInterruptSPCHardwareError(D_WorkInterrupt){
	/* $B%O!<%I%&%(%"%(%i!<8!=P(B */
	$RELEASE(D_WorkInterrupt);
	s_OrResultCodeCommRec(_CANCELED_BEFORE_EXEC, A_CommRec);
	s_SetErrorCodeCommRec(_ERROR_IN_SELECTION, A_CommRec);
	$CALL(f_ScsiSelectAbort_Sub(A_CommRec, A_Phase));
	/* $B%$%s%?%i%W%H$N%j%;%C%H$O(Bf_ScsiSelectAbort_Sub$B$NCf$G9T$J$&(B */
	goto END;
    }
    $USE(D_WorkStatus);
    b_GetScsiStatus (D_WorkStatus);       /* SSTS$B%l%8%9%?FI$_=P$7(B */
    b_GetScsiInterrupt(D_WorkInterrupt);  /* INTS$B%l%8%9%?FI$_=P$7(B */
    b_IfScsiStatusConnectedAsInitiator(D_WorkStatus){
    /* $B%$%K%7%(!<%?$H$7$F@\B3(B */
	b_IfScsiInterruptReselected(D_WorkInterrupt){
	    /* $B%j%;%l%/%H$5$l$?(B */
	    $RELEASE(D_WorkInterrupt);
	    $RELEASE(D_WorkStatus);
	    f_EnqueueToBusFreeWaiting(A_CommRec);
	    b_SetImmValueDNTC(_RESELECTED, A_Phase);
	    goto END;
	}
	b_IfScsiInterruptCommandComplete(D_WorkInterrupt){
	    /* Select$B%3%^%s%I@.8y(B */
	    $RELEASE(D_WorkInterrupt);
	    $RELEASE(D_WorkStatus);
	    /* $BI,$:(BCommand Complete$B3d$j9~$_$K$J$C$F$$$k$O$:(B */
	    b_ResetScsiInterruptCommandComplete();
	    $CALL(f_ScsiInitiatorSendIdentify_Sub(A_CommRec, A_Phase));
	    goto END;
	} /* End of b_ScsiInterruptCommandComplete */
	/* $B%$%K%7%(!<%?$H$7$F%3%M%/%H$7$F$$$k$,%;%l%/%7%g%s@.8y$G$b!"(B
	   $B%j%;%l%/%H$5$l$?$N$G$b$J$$!#(B                             */
	@DEBUG{
	    VPIM_ERROR("f_ScsiSelectionPhase_Sub","trouble in spc ?");
	};
    } /* End of b_IfScsiStatusConnectedAsInitiator */
    b_IfScsiStatusConnectedAsTarget(D_WorkStatus){
    /* $B%?!<%2%C%H$H$7$F@\B3(B */
	b_IfScsiInterruptSelected(D_WorkInterrupt){
	    $RELEASE(D_WorkInterrupt);
	    $RELEASE(D_WorkStatus);
	    /* $B%;%l%/%H$5$l$?(B */
	    f_EnqueueToBusFreeWaiting(A_CommRec);
	    b_SetImmValueDNTC(_SELECTED, A_Phase);
	    goto END;
	}
	/* $B%?!<%2%C%H$H$7$F@\B3$7$F$$$k$,%;%l%/%H$5$l$?$N$G$O$J$$!#(B*/
	@DEBUG{
	    VPIM_ERROR("f_ScsiSelectionPhase_Sub","trouble in spc ?");
	};
    } /* End of b_IfScsiStatusConnectedAsTarget */
    b_IfScsiStatusNotConnected(D_WorkStatus){
    /* SCSI$B$H$O@\B3$7$F$$$J$$(B */
	b_IfScsiInterruptDisconnected(D_WorkInterrupt){
	    /* $B%P%9%U%j!<%U%'!<%:8!=P(B */
	    $RELEASE(D_WorkStatus);
	    f_EnqueueToBusFreeWaiting(A_CommRec);
	    b_IfScsiInterruptReselected(D_WorkInterrupt){
		/* $B%j%;%l%/%H8e$K%P%9$,2rJ|$5$l$?(B */
		b_ResetScsiInterruptReselectedAndDisconnected();
	    }else{
		/* Select$B%3%^%s%I@.8y8e$K%P%9$,2rJ|$5$l$?(B */
		b_ResetScsiInterruptDisconnected();
	    }
	    $RELEASE(D_WorkInterrupt);
	    b_SetImmValueDNTC(_POP_NEXT_COMM_REC, A_Phase);
	    goto END;
	}
	b_IfScsiInterruptCommandComplete(D_WorkInterrupt){
	    /* $B%"!<%S%H%l!<%7%g%s<:GT(B */
	    $RELEASE(D_WorkInterrupt);
	    $RELEASE(D_WorkStatus);
	    b_ResetScsiInterruptCommandComplete();
	    f_EnqueueToBusFreeWaiting(A_CommRec);
	    b_SetScsiBusFreeInterruptOn();
	    /* PCTL $B%l%8%9%?(B.Bit7 : Bus Free Interrupt Enable = '1' */
	    b_SetImmValueDNTC(_ARBITRATION_FAILURE, A_Phase);
	    goto END;
	}
	@DEBUG{
	    VPIM_ERROR("f_ScsiSelectionPhase_Sub","truble in spc ?");
	};
    } /* End of b_IfScsiStatusNotConnected */
    @DEBUG{
	VPIM_ERROR("f_ScsiSelectionPhase_Sub",
		   "fatal error!! What happened?");
    };

  END:
    $RETURN();
}

/******************************************************************** PSL **

       written by f-takei@icot22      on Thu Mar  7 14:43:21 1991
       revised by f-takei@icot22      on Wed Jul  3 09:46:35 1991
<Arguments>
  A_Commrec
  A_Phase
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B%?!<%2%C%H$K(BIdentify$B%a%C%;!<%8$r(B($BI,MW$J$i3HD%(BIdentify$B%a%C%;!<%8$b(B)$BAw$k!#(B
<Examples>
<Test>
<Explanation>
  "Identify"$B%a%C%;!<%8$NAw=P$O!"(BSPC$B$N(BTransfer$B%3%^%s%I$K$h$C$F9T$&!#<B9T7k2L$O(B
  $B3d$j9~$_$K$h$C$FH=JL$9$k!#$^$?!"2?$i$+$N%(%i!<$,8!=P$5$l$?>l9g$K$O!"%(%i!<(B
  $B$N>pJs$r%3%^%s%I%l%3!<%IFb$NNN0h$K%;%C%H$7$F!"%(%i!<%O%s%I%j%s%0$N%k!<%A%s$N(B
  $B8F$S=P$7$r9T$&!#3d$j9~$_$NFbMF$H=hM}$K$D$$$F$O0J2<$NDL$j!#(B

    A.Command Complete$B3d$j9~$_(B
      $BE>Aw=*N;!#8!=P$5$l$k%(%i!<$N>uBV$K$h$C$F0J2<$N=hM}$K$o$+$l$k!#(B
      <$B=hM}(B>
        a.$B%(%i!<$,8!=P$5$l$J$+$C$?>l9g!#(B
          $B!&%+%l%s%H%G!<%?%]%$%s%?$r%m!<%I$9$k!#(B
          $B!&%3%^%s%IE>Aw=hM}$X0\$k!#(B
        b.$B%Q%j%F%#%(%i!<$,8!=P$5$l$?>l9g!#(B
          $B!&E>Aw%"%\!<%H=hM}$r9T$$!"%(%i!<=*N;$H$9$k!#(B
    B.Disconnected$B3d$j9~$_(B
      $B%P%9%U%j!<%U%'!<%:$N8!=P!#(B
      <$B=hM}(B>
        $B!&%(%i!<=*N;$H$9$k!#(B
    C.Service Required$B3d$j9~$_(B
      $BE>AwESCf$G%?!<%2%C%H$,%U%'!<%:$rJQ99$7$?!#(B
      <$B=hM}(B>
        $B!&E>Aw%"%\!<%H=hM}$r9T$$!"%(%i!<=*N;$H$9$k!#(B
    D.SPC Hardware Error$B3d$j9~$_(B
      SPC$B$N%O!<%I%&%(%"%(%i!<$r8!=P$7$?!#(B
      $B$3$3$G$O!"E>Aw%P%$%H%+%&%s%?$X$N=q$-9~$_;~$N%Q%j%F%#$N8m$j!"$"$k$$$O(B
      REQ, ACK$B?.9f$NGH7A3d$l$,9M$($i$l$k!#(B
      <$B=hM}(B>
        $B!&E>Aw%"%\!<%H=hM}$r9T$$!"%(%i!<=*N;$H$9$k!#(B
    E.Reset Condition$B3d$j9~$_(B
      $B%j%;%C%H%3%s%G%#%7%g%s$r8!=P$7$?!#(B
      <$B=hM}(B>
        $B!&%j%;%C%H%3%s%G%#%7%g%s;~$N=hM}$K0\$k!#(B
<ETC>
<Revised Memo on "Jul  3">
  $BE>Aw=*N;8e$N3d$j9~$_8!=P(B
    F.Selected, Reselected, Time Out
      Fatal Error $B$H$7$F8!=P;~$N=hM}$K0\$k!#(B
********************************************************************* PSL **/

#SUBARG_define A_CommRec    SRC
#SUBARG_define A_Phase      DST

#SUBROUTINE f_ScsiInitiatorSendIdentify_Sub(A_CommRec, A_Phase)
{
    /*--- Disconnected, Reset Condition $B3d$j9~$_$N%A%'%C%/(B---*/
    b_IfScsiAnyInterrupt(){
	f_ScsiInitiatorInterruptCheck(A_CommRec, A_Phase);
	goto END;
    }

    $USE(D_WorkPhase);
    b_GetScsiPhase(D_WorkPhase);   /* PSNS$B%l%8%9%?FI$_=P$7(B */
    b_IfEqualImm(D_WorkPhase, _MESSAGE_OUT_PHASE){
	/* $B%a%C%;!<%8%"%&%H%U%'!<%:(B */
	$RELEASE(D_WorkPhase);
	$USE(D_WorkLun1);
	s_GetScsiCommRecLUN(A_CommRec, D_WorkLun1);
	b_IfGreaterImm(D_WorkLun1, _MAX_SCSI_DEV_NUM){
	    b_ScsiInitiatorSendExIdentify(D_WorkLun1);
	    /* $B3HD%(BIdentify$B%a%C%;!<%8Aw=P(B */
	}else{
	    b_ScsiInitiatorSendIdentify(D_WorkLun1);
	    /* Identify$B%a%C%;!<%8Aw=P(B */
	}
	$RELEASE(D_WorkLun1);

	b_ScsiResetATN(); /* $B$?$V$sI,MW$J$$(B */
	$USE(D_WorkInterrupt);
	b_GetScsiInterrupt(D_WorkInterrupt);
	/* $BAw=P7k2L(B */
	b_IfScsiInterruptResetCondition(D_WorkInterrupt){
	    $RELEASE(D_WorkInterrupt);
	    b_SetImmValueDNTC(_ERROR_END, A_Phase);
	    goto END;
	}
	b_IfScsiInterruptSPCHardwareError(D_WorkInterrupt){
	    $RELEASE(D_WorkInterrupt);
	    f_ScsiInitiatorIntrHardwareErrorHandling
		                       (A_CommRec, A_Phase);
	    goto END;
	}
	b_IfScsiInterruptCommandComplete(D_WorkInterrupt){
	    $RELEASE(D_WorkInterrupt);
	    f_ScsiInitiatorIntrCommandCompleteHandlingOutput
		                                       (A_CommRec, A_Phase);
	    b_IfZero(A_Phase){
		/* $B@5>o$K%a%C%;!<%8Aw=P$r=*N;(B */
		s_GetScsiCommRecDataPtr(A_CommRec, D_CurrentDataPtrReg);
		b_SetImmValueDNTC(_COMMAND_TRANSFER, A_Phase);
	    }
	    goto END;
	}
	b_IfScsiInterruptDisconnected(D_WorkInterrupt){
	    $RELEASE(D_WorkInterrupt);
	    f_ScsiInitiatorIntrDisconnectedHandlingOutput(A_CommRec, A_Phase);
	    goto END;
	}
	b_IfScsiInterruptServiceRequired(D_WorkInterrupt){
	    $RELEASE(D_WorkInterrupt);
	    f_ScsiInitiatorIntrServiceRequiredHandlingAsErrorOutput
		                                          (A_CommRec, A_Phase);
	    goto END;
	}
	/* Fatal Error */
	b_SetImmValueDNTC(_FATAL_ERROR_END, A_Phase);
	@DEBUG{
	    b_IfScsiInterruptSelected(D_WorkInterrupt){
		;
	    }else{
		b_IfScsiInterruptReselected(D_WorkInterrupt){
		    ;
		}else{
		    b_IfScsiInterruptTimeOut(D_WorkInterrupt){
			;
		    }else{
			VPIM_ERROR("f_ScsiInitiatorSendIdentify_Sub",
				   "Unknown data on register");
		    }
		}
	    }
	};
	$RELEASE(D_WorkInterrupt);
	goto END;
    } /* End of b_IfScsiPhaseMsgOut */
    /* $B%;%l%/%7%g%s$K@.8y$7!"%$%K%7%(!<%?$H$7$F(Bconnect$B$7$F$$$k(B
	$B$N$K$b4X$o$i$:%U%'!<%:$,%a%C%;!<%8%"%&%H$K0\9T$7$J$$!#(B*/
    /* $B%*%W%7%g%s$J$7%G%P%$%9$N$?$a$N=hM}(B(not yet) */
    @DEBUG{
	OUT_OF_SPEC("f_ScsiInitiatorSendIdentify_Sub",
		    "not supported option");
    };

  END:
    $RETURN();
}
