
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_scsi_intr_reselection.psl.c
   ----- CREATED   : by f-takei@icot22, on Wed May 22 20:06:16 1991
   ----- LAST SAVED: by f-takei@icot22, on Mon Mar  9 11:35:54 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : function
   ----- ABSTRACT  : $B%$%K%7%(!<%?;~%j%3%M%/%H=hM}(B

 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */
/******************************************************************** PSL **
    $B%j%3%M%/%H=hM}(B
    f_ScsiReselected_Sub()

       written by f-takei@icot22      on Sat Jul  6 14:46:28 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  SCSI$B%P%9$+$i$N%j%3%M%/%HMW5a$KBP$9$k=hM}$r9T$&!#6qBNE*$K$O!"(BSPC$B$N8!=P$9$k(B
  Reselected$B3d$j9~$_$KBP$9$k=hM}$H$J$k!#(B
  $B%j%3%M%/%H$KH<$&%a%C%;!<%8=hM}$r9T$$!"@5>o$K%3%M%/%7%g%s$,3NN)$7$?8e$K!"(B
  $B%;%C%7%g%s$,=*N;$9$k$^$G$N@)8f$r9T$&!#(B
<Examples>
<Test>
<Explanation>
  Reselected$B3d$j9~$_$,8!=P$5$lF@$k$N$O!"0J2<$N(B2$BDL$j$N>l9g$G$"$k!#(B
    A.$BHsF14|$N(BSCSI$B$+$i$NA*Br!#(B
    B.$B%"!<%S%H%l!<%7%g%s$K<:GT$7$?8e$N(BSCSI$B$+$i$NA*Br!#(B
  A$B$N>l9g$O3d$j9~$_=hM}%k!<%A%s$+$i$3$N%k!<%A%s$,8F$S=P$5$l$k!#(B($B8=:_$O!"(B
  $B3d$j9~$_=hM}%k!<%A%s$O$^$@%5%]!<%H$7$F$$$J$$!#(B)
  B$B$N>l9g$O!"%;%l%/%7%g%s(B/$B%j%;%l%/%7%g%s%U%'!<%:$N<B9T%k!<%A%s$+$i$N8F$S=P$7(B
  $B$H$J$k!#(B

  $B=hM}FbMF$O0J2<$NDL$j!#(B
  1.$B%j%;%l%/%7%g%s!&%U%'!<%:$G$N%P%9%U%'!<%:>e$N(B ID $B>pJs$rFI$`!#(B
  2.$B%a%C%;!<%8$N<uNN$r9T$&!#(B
    $B$3$l$O!"(Bf_ScsiInitiatorReceiveIdentify_Sub $B$K$h$C$F=hM}$9$k!#(B
  3.f_ScsiInitiatorReceiveIdentify_Sub $B$N7k2L$K$h$C$F0J2<$N=hM}$K$o$+$l$k!#(B
    a. LUN$B$,7h$^$C$?$b$N(B $B!D(B Identify $B%a%C%;!<%8(B($B3HD%(B Identify $B%a%C%;!<%8$r4^$`(B)
                            $B$r@5>o$K<uNN$7$F$$$k!#(B
       $B!&%3%^%s%I%l%3!<%I$N8!:w=hM}$r9T$&!#(B
         $B8!:w$K@.8y$7$?>l9g$O%j%3%M%/%H=hM}$K0\$k!#(B
           $B!7(B  $B<:GT$7$?>l9g$O%"%\!<%H=hM}$r9T$&!#(B
    b. LUN$B$,7h$^$C$F%a%C%;!<%8$r(B 1byte $B<uNN$7$?$b$N(B
                         $B!D(B Identify $B%a%C%;!<%8$N$_$rMQ$$$?<B9T$G!"B>$K(B 1Byte
                            $B%a%C%;!<%8$r<uNN$7$F$$$k!#(B
       $B!&%3%^%s%I%l%3!<%I$N8!:w=hM}$r9T$&!#(B
         $B8!:w$K@.8y$7$?>l9g$O%a%C%;!<%8Kh$N=hM}$r9T$&!#(B
           $B!7(B  $B<:GT$7$?>l9g$O%"%\!<%H=hM}$r9T$&!#(B
       $B!&%a%C%;!<%8Kh$N=hM}$K$h$j0J2<$N>l9g$K$o$+$l$k!#(B
         - $B%j%3%M%/%H=hM}(B
         - $B%G%#%9%3%M%/%H=hM}(B
         - $B%"%\!<%H=hM}(B
    c. LUN$B$,7h$^$kA0$K0[>o$r8!=P$7$?$b$N(B
       $B!&%"%\!<%H=hM}$r9T$&!#(B
    d. Reset Condition$B$,8!=P$5$l$?>l9g(B
       $B!&%j%;%C%H=hM}$r9T$&!#(B
    e. SPC $B$N0[>o$J3d$j9~$_$r8!=P$7$?>l9g(B
       $B!&%j%;%C%H=hM}$r9T$&!#(B
  4.$B%j%3%M%/%H=hM}(B
    $B%j%3%M%/%H8e$NE>Aw%U%'!<%:$K$D$$$F$O!"%3%^%s%I%l%3!<%IFb$N(BNextPhase$B$h$j(B
    $B;O$a!"=*N;$^$G$N>uBVA+0\$N@)8f$r9T$&!#(B
<ETC>
  V1.0 $B$G$OK\%k!<%A%s$K$*$$$F!"%?!<%2%C%H$NMW5a%U%'!<%:$*$h$S<uNN%a%C%;!<%8(B
  $B$K1~$8$?=hM}$r9T$C$F$$$?$,!"8=:_$O(B f_ScsiInitiatorReceiveIdentify_Sub $B$K(B
  $B$*$$$F5-=R$7$F$$$k!#(B
********************************************************************* PSL **/

#CONST_define _RECONNECT		1
#CONST_define _NEXT_MSG			2
#CONST_define _ERROR_IN_RECEIVE_MSG	3
#CONST_define _RESET_END		4

/* #DATA_define D_WorkID       XXX */
#DATA_define D_WorkNextMsg  XXX
/* #DATA_define D_WorkResult   XXX */
#DATA_define D_WorkRec2 XXX

#SUBROUTINE f_ScsiReselected_Sub()
{
    $USE(D_WorkInterrupt);
    b_GetScsiInterrupt(D_WorkInterrupt);
    b_IfScsiInterruptDisconnected(D_WorkInterrupt){
	$RELEASE(D_WorkInterrupt);
	b_ResetScsiInterruptReselectedAndDisconnected();
	goto END;
    }
    $RELEASE(D_WorkInterrupt);

    $USE(D_WorkID);
    s_GetScsiTargetID(D_WorkID);
    b_ResetScsiInterruptReselected();

    $USE(D_WorkLun);
    $USE(D_WorkResult);
    $USE(D_WorkNextMsg);
    /* $B3HD%%a%C%;!<%8;HMQ(B */
    $CALL(f_ScsiInitiatorReceiveIdentify_Sub
	  (D_WorkLun, D_WorkResult, D_WorkNextMsg));
    ValueSwitch(D_WorkResult){
	/*----------------------------------------------
	 $B!&(BLUN$B$,7h$^$C$?$b$N(B
	 $B!&(BLUN$B$,7h$^$C$F%a%C%;!<%8$r(B1byte$B<uNN$7$?$b$N(B
	 $B!&(BLUN$B$,7h$^$kA0$K0[>o$r8!=P$7$?$b$N(B
	 $B!&(BReset Condition$B$,8!=P$5$l$?>l9g(B
	 $B!&(BSPC $B$N0[>o$J3d$j9~$_$r8!=P$7$?>l9g(B
        -----------------------------------------------*/
      case _RECONNECT:
	$RELEASE(D_WorkResult);
	$RELEASE(D_WorkNextMsg);
	goto Search_Rec;
      case _NEXT_MSG:
	$RELEASE(D_WorkResult);
	$USE(D_WorkRec2);
	$USE(D_WorkNextPhase);
	$CALL(f_ScsiSearchCommRecFromExecuting_Sub
	      (D_WorkID, D_WorkLun, D_WorkRec2, D_WorkNextPhase));
	$RELEASE(D_WorkID);
	$RELEASE(D_WorkLun);

	b_IfEqual(D_WorkNextPhase, D_NULL){
	    $RELEASE(D_WorkNextMsg);
	    $RELEASE(D_WorkRec2);
	    $RELEASE(D_WorkNextPhase);
	    goto END;
	}else{
	    b_IfEqualImm(D_WorkNextPhase, _RESULT_REPORT){
		$RELEASE(D_WorkNextMsg);
		$RELEASE(D_WorkNextPhase);
		goto Result_Report;
	    }
	}
	/* $B3:Ev$9$k%3%^%s%I%l%3!<%I$,B8:_(B */
	ValueSwitch(D_WorkNextMsg){
	  case _MSG_COMMAND_COMPLETE:
	    $RELEASE(D_WorkNextMsg);
	    b_BusyWaitScsiDisconnected();
	    s_SetResultCodeCommRecMsgReceived(D_WorkRec2);
	    $USE(D_WorkNext);
	    s_GetScsiCommRecNextPhase(D_WorkRec2, D_WorkNext);
	    b_IfNotEqual(D_WorkNext, D_WorkNextPhase){
		$RELEASE(D_WorkNext);
		$RELEASE(D_WorkNextPhase);
		s_SetErrorCodeCommRec(_UNEXPECTED_MSG, D_WorkRec2);
		s_OrResultCodeCommRec(_SCSI_ERROR_END, D_WorkRec2);
		$CALL(f_ScsiTransferAbort_Sub(D_WorkRec2));
	    }
	    $RELEASE(D_WorkNext);
	    goto Result_Report;
	  case _MSG_SAVE_DATA_POINTER:
	    $RELEASE(D_WorkNextMsg);
	    s_SetScsiCommRecDataPtr(D_CurrentDataPtrReg, D_WorkRec2);
	    break;
	  case _MSG_RESTORE_POINTERS:
	    $RELEASE(D_WorkNextMsg);
	    s_GetScsiCommRecDataPtr(D_WorkRec2, D_CurrentDataPtrReg);
	    break;
	  case _MSG_DISCONNECT:
	    $RELEASE(D_WorkNextMsg);
	    $RELEASE(D_WorkNextPhase);
	    b_BusyWaitScsiDisconnected();
	    f_EnqueueToBusFreeWaiting(D_WorkRec2);
	    goto END;
	  case _MSG_MESSAGE_REJECT:
	  case _MSG_LINKED_COMMAND_COMPLETE:
	  case _MSG_LINKED_COMMAND_COMPLETE_WITH_FLAG:
	  default:
	    $RELEASE(D_WorkNextMsg);
	    $RELEASE(D_WorkNextPhase);
	    s_SetErrorCodeCommRec(_UNEXPECTED_MSG, D_WorkRec2);
	    s_OrResultCodeCommRec(_SCSI_ERROR_END, D_WorkRec2);
	    $CALL(f_ScsiTransferAbort_Sub(D_WorkRec2));
	    goto Result_Report;
	}
	goto Reconnect;
      case _ERROR_IN_RECEIVE_MSG:
	$RELEASE(D_WorkID);
	$RELEASE(D_WorkLun);
	$RELEASE(D_WorkResult);
	$RELEASE(D_WorkNextMsg);
	goto END;
      case _RESET_END:
	$RELEASE(D_WorkID);
	$RELEASE(D_WorkLun);
	$RELEASE(D_WorkResult);
	$RELEASE(D_WorkNextMsg);
	$CALL(f_ScsiResetConditionHandling_Sub(D_NULL));
	goto END;
      case _FATAL_ERROR_END:
	$RELEASE(D_WorkID);
	$RELEASE(D_WorkLun);
	$RELEASE(D_WorkResult);
	$RELEASE(D_WorkNextMsg);
	goto END;
      default:
	@DEBUG{
	    VPIM_ERROR("f_ScsiReselected_Sub","Illegal parameter set");
	};
    }

  Search_Rec:
    $USE(D_WorkRec2);
    $USE(D_WorkNextPhase);
    $CALL(f_ScsiSearchCommRecFromExecuting_Sub
	  (D_WorkID, D_WorkLun, D_WorkRec2, D_WorkNextPhase));
    $RELEASE(D_WorkID);
    $RELEASE(D_WorkLun);

    b_IfEqual(D_WorkNextPhase, D_NULL){
	$RELEASE(D_WorkRec2);
	$RELEASE(D_WorkNextPhase);
	goto END;
    }else{
	b_IfEqualImm(D_WorkNextPhase, _RESULT_REPORT){
	    $RELEASE(D_WorkNextPhase);
	    goto Result_Report;
	}
    }

  Reconnect:
    ValueSwitch(D_WorkNextPhase){
      case _COMMAND_TRANSFER:
	goto Command_Transfer;
      case _DATA_TRANSFER:
	goto Data_Transfer;
      case _STATUS_TRANSFER:
	goto Status_Transfer;
      case _INITIATOR_TERMINATE:
	goto Initiator_Terminate;
      default:
	$RELEASE(D_WorkRec2);
	$RELEASE(D_WorkNextPhase);
	@DEBUG{
	    VPIM_ERROR("f_ScsiReselected_Sub","unknown phase. unbelievable!!");
	};
    }

  Command_Transfer:
    $CALL(f_ScsiCommandTransferPhase_Sub(D_WorkRec2, D_WorkNextPhase));
    ValueSwitch(D_WorkNextPhase){
      case _DATA_TRANSFER:
	goto Data_Transfer;
      case _RESULT_REPORT:
	$RELEASE(D_WorkNextPhase);
	goto Result_Report;
      case _POP_NEXT_COMM_REC:
	$RELEASE(D_WorkNextPhase);
	goto Pop_Next_Comm_Rec;
      case _ERROR_END:
	$RELEASE(D_WorkNextPhase);
	goto Error_End;
      case _FATAL_ERROR_END:
	$RELEASE(D_WorkNextPhase);
	goto Fatal_Error_End;
      default:
	$RELEASE(D_WorkNextPhase);
	$RELEASE(D_WorkRec2);
	@DEBUG{
	    VPIM_ERROR("f_ScsiReselected_Sub","unknown phase. unbelievable!!");
	};
    }

  Data_Transfer:
    $CALL(f_ScsiDataTransferPhase_Sub(D_WorkRec2, D_WorkNextPhase));
    ValueSwitch(D_WorkNextPhase) {
      case _STATUS_TRANSFER:
	goto Status_Transfer;
      case _RESULT_REPORT:
	$RELEASE(D_WorkNextPhase);
	goto Result_Report;
      case _POP_NEXT_COMM_REC:
	$RELEASE(D_WorkNextPhase);
	goto Pop_Next_Comm_Rec;
      case _ERROR_END:
	$RELEASE(D_WorkNextPhase);
	goto Error_End;
      case _FATAL_ERROR_END:
	$RELEASE(D_WorkNextPhase);
	goto Fatal_Error_End;
      default:
	$RELEASE(D_WorkNextPhase);
	$RELEASE(D_WorkRec2);
	@DEBUG{
	    VPIM_ERROR("f_ScsiReselected_Sub","unknown phase. unbelievable!!");
	};
    }

  Status_Transfer:
    $CALL(f_ScsiStatusTransferPhase_Sub(D_WorkRec2, D_WorkNextPhase));
    ValueSwitch(D_WorkNextPhase) {
      case _INITIATOR_TERMINATE:
	goto Initiator_Terminate;
      case _RESULT_REPORT:
	$RELEASE(D_WorkNextPhase);
	goto Result_Report;
      case _POP_NEXT_COMM_REC:
	$RELEASE(D_WorkNextPhase);
	goto Pop_Next_Comm_Rec;
      case _ERROR_END:
	$RELEASE(D_WorkNextPhase);
	goto Error_End;
      case _FATAL_ERROR_END:
	$RELEASE(D_WorkNextPhase);
	goto Fatal_Error_End;
      default:
	$RELEASE(D_WorkNextPhase);
	$RELEASE(D_WorkRec2);
	@DEBUG{
	    VPIM_ERROR("f_ScsiReselected_Sub","unknown phase. unbelievable!!");
	};
    }

  Initiator_Terminate:
    $CALL(f_ScsiInitiatorTerminate_Sub(D_WorkRec2, D_WorkNextPhase));
    ValueSwitch(D_WorkNextPhase) {
      case _RESULT_REPORT:
	$RELEASE(D_WorkNextPhase);
	goto Result_Report;
      case _POP_NEXT_COMM_REC:
	$RELEASE(D_WorkNextPhase);
	goto Pop_Next_Comm_Rec;
      case _ERROR_END:
	$RELEASE(D_WorkNextPhase);
	goto Error_End;
      case _FATAL_ERROR_END:
	$RELEASE(D_WorkNextPhase);
	goto Fatal_Error_End;
      default:
	$RELEASE(D_WorkNextPhase);
	$RELEASE(D_WorkRec2);
	@DEBUG{
	    VPIM_ERROR("f_ScsiReselected_Sub","unknown phase. unbelievable!!");
	};
    }

  Result_Report:
    $CALL(f_ScsiInitiatorResultReport_Sub(D_WorkRec2));
    f_ScsiQueueManagementOnCommandEnd(D_WorkRec2);
    $RELEASE(D_WorkRec2);
    goto END;

  Error_End:
    $CALL(f_ScsiResetConditionHandling_Sub(D_WorkRec2));
    $RELEASE(D_WorkRec2);
    goto END;

  Fatal_Error_End:
    $CALL(f_ScsiFatalErrorEnd_Sub(D_NULL, D_WorkRec2));
    $RELEASE(D_WorkRec2);
    goto END;

  Pop_Next_Comm_Rec:
    $RELEASE(D_WorkRec2);

  END:
    $RETURN();
}
