
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pimp/ICOT/V10-scsi/functions/f_scsi_intr_interrupt_handling.psl.c
   ----- CREATED   : by f-takei@icot22, on Tue Mar  5 14:17:43 1991
   ----- LAST SAVED: by f-takei@icot22, on Thu Jul  4 16:30:27 1991
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : functions
   ----- ABSTRACT  : Transfer$B%3%^%s%IH/9T8e$N3F3d$j9~$_$KBP$9$k=hM}(B

  $B!&(Bf_ScsiInitiatorInterruptCheck
  $B!&(Bf_ScsiInitiatorParityErrorHandlingOutput
  $B!&(Bf_ScsiInitiatorParityErrorHandlingInput
  $B!&(Bf_ScsiInitiatorErrorEnd

 $B>pJsE>Aw(B($B%G!<%?0J30(B)$B;~$N3d$j9~$_=hM}(B
  $B!&(Bf_ScsiInitiatorIntrHardwareErrorHandling
  $B!&(Bf_ScsiInitiatorIntrDisconnectedHandlingOutput
  $B!&(Bf_ScsiInitiatorIntrDisconnectedHandlingInput
  $B!&(Bf_ScsiInitiatorIntrCommandCompleteHandlingOutput
  $B!&(Bf_ScsiInitiatorIntrCommandCompleteHandlingInput
  $B!&(Bf_ScsiInitiatorIntrServiceRequiredHandlingAsErrorOutput
  $B!&(Bf_ScsiInitiatorIntrServiceRequiredHandlingAsErrorInput
  $B!&(Bf_ScsiInitiatorIntrServiceRequiredHandlingOutput
  $B!&(Bf_ScsiInitiatorIntrServiceRequiredHandlingInput

 $B%G!<%?E>Aw;~$N3d$j9~$_=hM}(B
  $B!&(Bf_ScsiInitiatorIntrHardwareErrorHandlingOnData
  $B!&(Bf_ScsiInitiatorIntrDisconnectedHandlingOnDataOutput
  $B!&(Bf_ScsiInitiatorIntrDisconnectedHandlingOnDataInput
  $B!&(Bf_ScsiInitiatorIntrCommandCompleteHandlingOnDataOutput
  $B!&(Bf_ScsiInitiatorIntrCommandCompleteHandlingOnDataInput
  $B!&(Bf_ScsiInitiatorIntrServiceRequiredHandlingOnDataOutput
  $B!&(Bf_ScsiInitiatorIntrServiceRequiredHandlingOnDataInput

 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

#PSL_define f_ScsiInitiatorInterruptCheck(comm_rec_ptr_reg, phase_reg)
{
    $USE(D_WorkInterrupt);
    b_GetScsiInterrupt(D_WorkInterrupt);
    b_IfScsiInterruptResetCondition(D_WorkInterrupt){
	b_SetImmValueDNTC(_ERROR_END, phase_reg);
    }else{
	b_IfScsiInterruptDisconnected(D_WorkInterrupt){
	    b_ResetScsiInterruptDisconnected();
	    s_SetErrorCodeCommRec(_DISCONNECTED, comm_rec_ptr_reg);
	    s_OrResultCodeCommRec(_SCSI_ERROR_END, comm_rec_ptr_reg);
	    b_SetImmValueDNTC(_RESULT_REPORT, phase_reg);
	}else{
	    b_SetImmValueDNTC(_FATAL_ERROR_END, phase_reg);
	}
    }
    $RELEASE(D_WorkInterrupt);
}

#PSL_define f_ScsiInitiatorParityErrorHandlingOutput
                                        (comm_rec_ptr_reg, phase_reg)
{
    b_ScsiSPCControlReset();
    s_OrErrorCodeCommRec(_PARITY_ERROR_O, comm_rec_ptr_reg);
    f_ScsiInitiatorErrorEnd(comm_rec_ptr_reg, phase_reg);
}

#PSL_define f_ScsiInitiatorParityErrorHandlingInput
                                        (comm_rec_ptr_reg, phase_reg)
{
    b_ResetScsiErrorReg();
    s_OrErrorCodeCommRec(_PARITY_ERROR_I, comm_rec_ptr_reg);
    f_ScsiInitiatorErrorEnd(comm_rec_ptr_reg, phase_reg);
}

#PSL_define f_ScsiInitiatorErrorEnd(comm_rec_ptr_reg, phase_reg)
{
    s_OrResultCodeCommRec(_SCSI_ERROR_END, comm_rec_ptr_reg);
    $CALL(f_ScsiTransferAbort_Sub(comm_rec_ptr_reg));
    b_SetImmValueDNTC(_RESULT_REPORT, phase_reg);
}

/*--- $B>pJsE>Aw(B($B%G!<%?0J30(B)$B;~$N3d$j9~$_=hM}(B ---*/

#PSL_define f_ScsiInitiatorIntrHardwareErrorHandling
			               (comm_rec_ptr_reg, phase_reg)
{
    b_ScsiSPCControlReset();
    s_SetErrorCodeCommRec(_SPC_HARDWARE_ERROR, comm_rec_ptr_reg);
    $USE(D_WorkInterrupt);
    b_GetScsiInterrupt(D_WorkInterrupt);
    b_IfScsiInterruptDisconnected(D_WorkInterrupt){
	$RELEASE(D_WorkInterrupt);
	b_ResetScsiInterruptDisconnected();
	s_OrErrorCodeCommRec(_DISCONNECTED, comm_rec_ptr_reg);
	s_OrResultCodeCommRec(_SCSI_ERROR_END, comm_rec_ptr_reg);
	b_SetImmValueDNTC(_RESULT_REPORT, phase_reg);
	goto End;
    }else{
	b_IfScsiInterruptCommandComplete(D_WorkInterrupt){
	    b_ResetScsiInterruptCommandComplete();
	    goto Abort;
	}
	b_IfScsiInterruptServiceRequired(D_WorkInterrupt){
	    b_ResetScsiInterruptServiceRequired();
	    goto Abort;
	}
	$RELEASE(D_WorkInterrupt);
	b_SetImmValueDNTC(_FATAL_ERROR_END, phase_reg);
	goto End;
    }

  Abort:
    $RELEASE(D_WorkInterrupt);
    f_ScsiInitiatorErrorEnd(comm_rec_ptr_reg, phase_reg);

  End:
    ;
}

#PSL_define f_ScsiInitiatorIntrDisconnectedHandlingOutput
			                   (comm_rec_ptr_reg, phase_reg)
{
    s_OrErrorCodeCommRec(_DISCONNECTED, comm_rec_ptr_reg);
    s_OrResultCodeCommRec(_SCSI_ERROR_END, comm_rec_ptr_reg);
    b_IfScsiParityError(){
	s_OrErrorCodeCommRec(_PARITY_ERROR_O, comm_rec_ptr_reg);
    }
    b_ResetScsiInterruptDisconnected();
    b_SetImmValueDNTC(_RESULT_REPORT, phase_reg);
}

#PSL_define f_ScsiInitiatorIntrDisconnectedHandlingInput
			                   (comm_rec_ptr_reg, phase_reg)
{
    s_OrErrorCodeCommRec(_DISCONNECTED, comm_rec_ptr_reg);
    s_OrResultCodeCommRec(_SCSI_ERROR_END, comm_rec_ptr_reg);
    b_IfScsiParityError(){
	s_OrErrorCodeCommRec(_PARITY_ERROR_I, comm_rec_ptr_reg);
    }
    b_ResetScsiInterruptDisconnected();
    b_SetImmValueDNTC(_RESULT_REPORT, phase_reg);
}

#PSL_define f_ScsiInitiatorIntrCommandCompleteHandlingOutput
			                     (comm_rec_ptr_reg, phase_reg)
{
    b_ResetScsiInterruptCommandComplete();
    b_IfScsiParityError(){
	f_ScsiInitiatorParityErrorHandlingOutput(comm_rec_ptr_reg, phase_reg);
    }else{
	p_MoveWord(D_NULL, phase_reg);
    }
}

#PSL_define f_ScsiInitiatorIntrCommandCompleteHandlingInput
			                     (comm_rec_ptr_reg, phase_reg)
{
    b_ResetScsiInterruptCommandComplete();
    b_IfScsiParityError(){
	f_ScsiInitiatorParityErrorHandlingInput(comm_rec_ptr_reg, phase_reg);
    }else{
	p_MoveWord(D_NULL, phase_reg);
    }
}

#PSL_define f_ScsiInitiatorIntrServiceRequiredHandlingAsErrorOutput
			                         (comm_rec_ptr_reg, phase_reg)
{
    b_ResetScsiInterruptServiceRequired();
    s_SetErrorCodeCommRec(_SERVICE_REQUIRED, comm_rec_ptr_reg);
    b_IfScsiParityError(){
	f_ScsiInitiatorParityErrorHandlingOutput(comm_rec_ptr_reg, phase_reg);
    }else{
	f_ScsiInitiatorErrorEnd(comm_rec_ptr_reg, phase_reg);
    }
}

#PSL_define f_ScsiInitiatorIntrServiceRequiredHandlingAsErrorInput
			                         (comm_rec_ptr_reg, phase_reg)
{
    b_ResetScsiInterruptServiceRequired();
    s_SetErrorCodeCommRec(_SERVICE_REQUIRED, comm_rec_ptr_reg);
    b_IfScsiParityError(){
	f_ScsiInitiatorParityErrorHandlingInput(comm_rec_ptr_reg, phase_reg);
    }else{
	f_ScsiInitiatorErrorEnd(comm_rec_ptr_reg, phase_reg);
    }
}

#PSL_define f_ScsiInitiatorIntrServiceRequiredHandlingOutput
			                      (comm_rec_ptr_reg, phase_reg)
{
    b_ResetScsiInterruptServiceRequired();
    b_IfScsiParityError(){
	f_ScsiInitiatorParityErrorHandlingOutput(comm_rec_ptr_reg, phase_reg);
    }else{
	p_MoveWord(D_NULL, phase_reg);
    }
}

#PSL_define f_ScsiInitiatorIntrServiceRequiredHandlingInput
			                      (comm_rec_ptr_reg, phase_reg)
{
    b_ResetScsiInterruptServiceRequired();
    b_IfScsiParityError(){
	f_ScsiInitiatorParityErrorHandlingInput(comm_rec_ptr_reg, phase_reg);
    }else{
	p_MoveWord(D_NULL, phase_reg);
    }
}

/*--- $B%G!<%?E>Aw;~$N3d$j9~$_=hM}(B ---*/

#PSL_define f_ScsiInitiatorIntrHardwareErrorHandlingOnData
			               (comm_rec_ptr_reg, phase_reg)
{
    b_ScsiSPCControlReset();
    s_DiscountScsiCommRecDataCounter(comm_rec_ptr_reg);
    s_SetErrorCodeCommRec(_SPC_HARDWARE_ERROR, comm_rec_ptr_reg);
    $USE(D_WorkInterrupt);
    b_GetScsiInterrupt(D_WorkInterrupt);
    b_IfScsiInterruptDisconnected(D_WorkInterrupt){
	$RELEASE(D_WorkInterrupt);
	b_ResetScsiInterruptDisconnected();
	s_OrErrorCodeCommRec(_DISCONNECTED, comm_rec_ptr_reg);
	s_OrResultCodeCommRec(_SCSI_ERROR_END, comm_rec_ptr_reg);
	b_SetImmValueDNTC(_RESULT_REPORT, phase_reg);
	goto End;
    }else{
	b_IfScsiInterruptCommandComplete(D_WorkInterrupt){
	    b_ResetScsiInterruptCommandComplete();
	    goto Abort;
	}
	b_IfScsiInterruptServiceRequired(D_WorkInterrupt){
	    b_ResetScsiInterruptServiceRequired();
	    goto Abort;
	}
	$RELEASE(D_WorkInterrupt);
	b_SetImmValueDNTC(_FATAL_ERROR_END, phase_reg);
	goto End;
    }

  Abort:
    $RELEASE(D_WorkInterrupt);
    f_ScsiInitiatorErrorEnd(comm_rec_ptr_reg, phase_reg);

  End:
    ;
}

#PSL_define f_ScsiInitiatorIntrDisconnectedHandlingOnDataOutput
				            (comm_rec_ptr_reg, phase_reg)
{
    s_SetErrorCodeCommRec(_DISCONNECTED, comm_rec_ptr_reg);
    s_OrResultCodeCommRec(_SCSI_ERROR_END, comm_rec_ptr_reg);
    b_IfScsiParityError(){
	s_DiscountScsiCommRecDataCounter(comm_rec_ptr_reg);
	s_OrErrorCodeCommRec(_PARITY_ERROR_O, comm_rec_ptr_reg);
    }
    b_ResetScsiInterruptDisconnected();
    b_SetImmValueDNTC(_RESULT_REPORT, phase_reg);
}

#PSL_define f_ScsiInitiatorIntrDisconnectedHandlingOnDataInput
				             (comm_rec_ptr_reg, phase_reg)
{
    s_SetErrorCodeCommRec(_DISCONNECTED, comm_rec_ptr_reg);
    s_OrResultCodeCommRec(_SCSI_ERROR_END, comm_rec_ptr_reg);
    b_IfScsiParityError(){
	s_DiscountScsiCommRecDataCounter(comm_rec_ptr_reg);
	s_OrErrorCodeCommRec(_PARITY_ERROR_I, comm_rec_ptr_reg);
    }
    b_ResetScsiInterruptDisconnected();
    b_SetImmValueDNTC(_RESULT_REPORT, phase_reg);
}

#PSL_define f_ScsiInitiatorIntrCommandCompleteHandlingOnDataOutput
			                        (comm_rec_ptr_reg, phase_reg)
{
    b_ResetScsiInterruptCommandComplete();
    b_IfScsiParityError(){
	s_DiscountScsiCommRecDataCounter(comm_rec_ptr_reg);
	f_ScsiInitiatorParityErrorHandlingOutput(comm_rec_ptr_reg, phase_reg);
    }else{
	b_SetImmValueDNTC(_STATUS_TRANSFER, phase_reg);
    }
}

#PSL_define f_ScsiInitiatorIntrCommandCompleteHandlingOnDataInput
			                        (comm_rec_ptr_reg, phase_reg)
{
    b_ResetScsiInterruptCommandComplete();
    b_IfScsiParityError(){
	s_DiscountScsiCommRecDataCounter(comm_rec_ptr_reg);
	f_ScsiInitiatorParityErrorHandlingInput(comm_rec_ptr_reg, phase_reg);
    }else{
	b_SetImmValueDNTC(_STATUS_TRANSFER, phase_reg);
    }
}

#PSL_define f_ScsiInitiatorIntrServiceRequiredHandlingOnDataOutput
			                         (comm_rec_ptr_reg, phase_reg)
{
    b_ResetScsiInterruptServiceRequired();
    b_IfScsiParityError(){
	s_DiscountScsiCommRecDataCounter(comm_rec_ptr_reg);
	f_ScsiInitiatorParityErrorHandlingOutput(comm_rec_ptr_reg, phase_reg);
    }else{
	b_SetImmValueDNTC(_DATA_TRANSFER, phase_reg);
    }
}

#PSL_define f_ScsiInitiatorIntrServiceRequiredHandlingOnDataInput
			                         (comm_rec_ptr_reg, phase_reg)
{
    b_ResetScsiInterruptServiceRequired();
    b_IfScsiParityError(){
	s_DiscountScsiCommRecDataCounter(comm_rec_ptr_reg);
	f_ScsiInitiatorParityErrorHandlingInput(comm_rec_ptr_reg, phase_reg);
    }else{
	b_SetImmValueDNTC(_DATA_TRANSFER, phase_reg);
    }
}

