
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_scsi_intr_extended_msg.psl.c
   ----- CREATED   : by f-takei@icot22, on Thu Nov 15 11:19:16 1990
   ----- LAST SAVED: by f-takei@icot22, on Wed Oct 30 19:55:56 1991
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : $B3HD%(BIdentify$B%a%C%;!<%8$N<uNN(B

  1.$B%j%3%M%/%H8e$N%a%C%;!<%8<uNN(B
  2.$B3HD%(B Identify $B%a%C%;!<%8$N<uNN(B
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
  1. $B%j%3%M%/%H8e$N%a%C%;!<%8<uNN(B f_ScsiInitiatorReceiveIdentify_Sub

       written by f-takei@icot22      on Thu Jul  4 18:51:10 1991
<Arguments>
    A_Lun
    A_Result
    A_NextMsg
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  Identify $B%a%C%;!<%8(B($B3HD%(B Identify $B$b4^$`(B) $B$r<uNN$7!"$=$l$h$j(B LUN $B$r5a$a$k!#(B
  $B@5>o$K=*N;$7$?>l9g$O!"(BA_Lun $B$K5a$a$?(B LUN $B$rJV$9!#(B
  $B<B9T7k2L$O(B A_Result $B$KJV$9!#(B
    A_Result :: _RECONNECT   $B!D(B $B@5>o=*N;!#(BA_Lun $B$K(B LUN $B$,$N$C$F$$$k!#(B
                _NEXT_MSG    $B!D(B $B@5>o=*N;!#(BA_Lun $B$K(B LUN $B$,$N$C$F$$$k!#(B
                                A_NexMsg $B$K<uNN$7$?%a%C%;!<%8$,$N$C$F$$$k!#(B
                _ERROR_IN_RECEIVE_MSG
                             $B!D(B $B%(%i!<=*N;!#(B
                _RESET_END   $B!D(B $B%j%;%C%H%3%s%G%#%7%g%s$K$h$k=*N;!#(B
                _FATAL_ERROR_END
                             $B!D(B $B0[>o$J3d$j9~$_8!=P$K$h$k=*N;!#(B
                                SCSI $B%I%i%$%P$N%j%;%C%H:Q$_!#(B
<Examples>
<Test>
<Explanation>
  $B=hM}FbMF$O0J2<$NDL$j!#(B
  $B%?!<%2%C%H$NMW5a%U%'!<%:$K$h$j0J2<$K$o$+$l$k!#(B
  $B!&%a%C%;!<%8%$%s!&%U%'!<%:0J30$N>l9g(B
    $B%(%i!<=*N;$N%3!<%I$r(B A_Result $B$KJV$9!#(B
  $B!&%a%C%;!<%8%$%s!&%U%'!<%:$N>l9g(B
    $B0J2<$N=hM}$r9T$&!#(B
     $B!&%a%C%;!<%8$r(B 1byte $B<uNN$9$k!#(B
       $B<uNN$7$?%a%C%;!<%8$K$h$j0J2<$N=hM}$K$o$+$l$k!#(B
       A.$B3HD%%a%C%;!<%8$G$"$C$?>l9g!#(B
         $B!&(Bf_ScsiInitiatorReceiveExMsg_Sub $B$K$h$C$F!";D$j$N%a%C%;!<%8$r(B
           $B<uNN$9$k!#(B
	 $B@5>o=*N;$7$?>l9g$K$N$_0J2<$N=hM}$r9T$&!#(B
	 $B!&%a%C%;!<%8%$%s!&%U%'!<%:$G$"$l$P%a%C%;!<%8$r(B 1byte $B<uNN$9$k!#(B
	   a.$B<uNN$7$?%a%C%;!<%8$,(B Identify $B%a%C%;!<%8$@$C$?>l9g$O!"@h$K(B
	     $B<uNN$7$?3HD%(B Identify $B%a%C%;!<%8$r9g$o$;$F!"(BLUN $B$r5a$a7k2L$r(B
	     A_Lun $B$KJV$9!#(B
	   b.$B<uNN$7$?%a%C%;!<%8$,$=$l0J30$@$C$?>l9g$K$O!"%(%i!<=*N;$H$9$k!#(B
	 $B!&%a%C%;!<%8%$%s!&%U%'!<%:0J30$N>l9g$K$O%(%i!<=*N;$H$9$k!#(B
       B.$B%a%C%;!<%8$,(B"Idetify"$B%a%C%;!<%8$G$"$C$?>l9g!#(B
	 $B%?!<%2%C%H$NMW5a%U%'!<%:$K$h$j0J2<$K$o$+$l$k!#(B
	 $B!&%a%C%;!<%8%$%s!&%U%'!<%:0J30$N>l9g(B
	   $B@h$K<uNN$7$?(B Identify $B%a%C%;!<%8$+$i(B LUN $B$r5a$a!"7k2L$r(B A_Lun
	   $B$KJV$9!#(B
	 $B!&%a%C%;!<%8%$%s!&%U%'!<%:$N>l9g(B
	   $B%a%C%;!<%8$r(B 1byte $B<uNN$9$k!#(B
	   $B<uNN$7$?%a%C%;!<%8$K$h$j0J2<$K$o$+$l$k!#(B
	   a.$B<uNN$7$?%a%C%;!<%8$,3HD%%a%C%;!<%8$@$C$?>l9g!#(B
	     f_ScsiInitiatorReceiveExMsg_Sub $B$K$h$C$F;D$j$N%a%C%;!<%8$r(B
	     $B<uNN$9$k!#(B
             $B@5>o=*N;$7$?>l9g$K$N$_!"@h$K<uNN$7$?(B Idetify $B%a%C%;!<%8$r9g$o$;$F(B 
	     LUN $B$r5a$a!"7k2L$r(B A_Lun $B$KJV$9!#(B
	   b.$B<uNN$7$?%a%C%;!<%8$,(B $B$=$l0J30$@$C$?>l9g$K$O!"@h$K<uNN$7$?(BIdentify
	     $B%a%C%;!<%8$+$i(B LUN $B$r5a$a!"(BA_Lun $B$KJV$9!#(B $B$^$?!"(BA_NextMsg $B$K<!$N(B
	     $B%a%C%;!<%8$rJV$9!#(B
<ETC>
********************************************************************* PSL **/

#SUBARG_define A_Lun		DST
#SUBARG_define A_Result		DST
#SUBARG_define A_NextMsg	DST

#SUBROUTINE f_ScsiInitiatorReceiveIdentify_Sub(A_Lun, A_Result, A_NextMsg)
{
    b_IfScsiAnyInterrupt(){
	$USE(D_WorkInterrupt);
	b_GetScsiInterrupt(D_WorkInterrupt);
	b_IfScsiInterruptResetCondition(D_WorkInterrupt){
	    $RELEASE(D_WorkInterrupt);
	    b_SetImmValueDNTC(_RESET_END, A_Result);
	    goto END;
	}
	b_IfScsiInterruptDisconnected(D_WorkInterrupt){
	    $RELEASE(D_WorkInterrupt);
	    b_SetImmValueDNTC(_ERROR_IN_RECEIVE_MSG, A_Result);
	    goto ABORT;
	}
	$CALL(f_ScsiFatalErrorEnd_Sub(D_WorkInterrupt, D_NULL));
	$RELEASE(D_WorkInterrupt);
	b_SetImmValueDNTC(_FATAL_ERROR_END, A_Result);
	goto END;
    }

    $USE(D_WorkPhase);
    b_GetScsiPhase(D_WorkPhase);
    b_IfNotEqualImm(D_WorkPhase, _MESSAGE_IN_PHASE){
	$RELEASE(D_WorkPhase);
	b_SetImmValueDNTC(_ERROR_IN_RECEIVE_MSG, A_Result);
	goto ABORT;
    }
    $RELEASE(D_WorkPhase);

    b_ScsiInitiatorReceiveDataByManual(A_Lun);
    b_IfScsiParityError(){
	b_SetImmValueDNTC(_ERROR_IN_RECEIVE_MSG, A_Result);
	b_ResetScsiErrorReg();
	goto ABORT;
    }

    b_IfEqualImm(A_Lun, _EXTENDED_MSGS){
	/* Reconnect$B8e$N:G=i$N%a%C%;!<%8$,3HD%%a%C%;!<%8(B */
	$USE(D_WorkMessage);
	$CALL(f_ScsiInitiatorReceiveExMsg_Sub(D_WorkMessage, A_Result));
	ValueSwitch(A_Result){
	  case _RECONNECT:
	    break;
	  case _ERROR_IN_RECEIVE_MSG:
	    $RELEASE(D_WorkMessage);
	    goto ABORT;
	  case _RESET_END:
	    $RELEASE(D_WorkMessage);
	    goto END;
	  case _FATAL_ERROR_END:
	    $CALL(f_ScsiFatalErrorEnd_Sub(D_WorkMessage, D_NULL));
	    $RELEASE(D_WorkMessage);
	    goto END;
	  default:
	    @DEBUG{
		VPIM_ERROR("f_ScsiInitiatorReceiveIdentify_Sub",
			   "Illegal parameter set");
	    };
	    $RELEASE(D_WorkMessage);
	    goto END;
	}
	/* $B%a%C%;!<%8<uNN(B */
	$USE(D_WorkPhase);
	b_GetScsiPhase(D_WorkPhase);
	b_IfNotEqualImm(D_WorkPhase, _MESSAGE_IN_PHASE){
	    /* $B3HD%(BIdentify$B%a%C%;!<%8$O<uNN$7$?$,!"(BIdentify$B%a%C%;!<%8$r(B
	       $BAw$C$F$3$J$$(B */
	    $RELEASE(D_WorkPhase);
	    $RELEASE(D_WorkMessage);
	    b_SetImmValueDNTC(_ERROR_IN_RECEIVE_MSG, A_Result);
	    goto ABORT;
	}else{
	    $RELEASE(D_WorkPhase);
	    /* Identify$B%a%C%;!<%8(B(1Byte$BD9(B)$B$N<uNN(B */
	    b_ScsiInitiatorReceiveDataByManual(A_Lun);
	    b_IfScsiParityError(){
		$RELEASE(D_WorkMessage);
		b_ResetScsiErrorReg();
		b_SetImmValueDNTC(_ERROR_IN_RECEIVE_MSG, A_Result);
		goto ABORT;
	    }
/*	    b_SetImmValueDNTC(_RECONNECT, A_Result); */
	    b_GetScsiLUNFromExIdentify(A_Lun, D_WorkMessage);
	    $RELEASE(D_WorkMessage);
	    goto END;
	}
    }else{
	/* Reconnect$B8e$N:G=i$N%a%C%;!<%8$O(B1byte$BD9(B */
	b_IfScsiIdentifyMsg(A_Lun){
	    $USE(D_WorkPhase);
	    b_GetScsiPhase(D_WorkPhase);
	    b_IfNotEqualImm(D_WorkPhase, _MESSAGE_IN_PHASE){
		/* Identify$B%a%C%;!<%8$N$_$r;H$C$?(BLUN$B;XDj(B */
		$RELEASE(D_WorkPhase);
		b_GetScsiLUNFromIdentify(A_Lun);
		b_SetImmValueDNTC(_RECONNECT, A_Result);
		goto END;
	    }
	    $RELEASE(D_WorkPhase);
	    $USE(D_WorkMessage);
	    b_ScsiInitiatorReceiveDataByManual(D_WorkMessage);
	    b_IfScsiParityError(){
		$RELEASE(D_WorkMessage);
		b_ResetScsiErrorReg();
		b_SetImmValueDNTC(_ERROR_IN_RECEIVE_MSG, A_Result);
		goto ABORT;
	    }
	    b_IfNotEqualImm(D_WorkMessage, _EXTENDED_MSGS){
		/* Identify$B%a%C%;!<%8$N$_$N;XDj!"(B1byte$BD9%a%C%;!<%8$N<uNN(B */
		p_MoveWord(D_WorkMessage, A_NextMsg);
		$RELEASE(D_WorkMessage);
		b_SetImmValueDNTC(_NEXT_MSG, A_Result);
		b_GetScsiLUNFromIdentify(A_Lun);
		goto END;
	    }else{
		/* $B3HD%%a%C%;!<%8$N<uNN(B */
		$CALL(f_ScsiInitiatorReceiveExMsg_Sub
		      (D_WorkMessage, A_Result));
		ValueSwitch(A_Result){
		  case _RECONNECT:
		    break;
		  case _ERROR_IN_RECEIVE_MSG:
		    $RELEASE(D_WorkMessage);
		    goto ABORT;
		  case _RESET_END:
		    $RELEASE(D_WorkMessage);
		    goto END;
		  case _FATAL_ERROR_END:
		    $CALL(f_ScsiFatalErrorEnd_Sub(D_WorkMessage, D_NULL));
		    $RELEASE(D_WorkMessage);
		    goto END;
		  default:
		    $RELEASE(D_WorkMessage);
		    @DEBUG{
			VPIM_ERROR("f_ScsiInitiatorReceiveIdentify_Sub",
				   "Illegal parameter set");
		    };
		    goto END;
		}
		/* $B%a%C%;!<%8<uNN(B */
		b_GetScsiLUNFromExIdentify(A_Lun, D_WorkMessage);
		$RELEASE(D_WorkMessage);
		goto END;
	    }
	}else{
	    /* Reconnect$B8e$N:G=i$N%a%C%;!<%8$,(BIdentify$B$G$b(B
	       $B3HD%(BIdentify$B$G$b$J$$(B */
	    b_SetImmValueDNTC(_ERROR_IN_RECEIVE_MSG, A_Result);
	    goto ABORT;
	}
    }

  ABORT:
    $CALL(f_ScsiTransferAbort_Sub(D_NULL));

  END:
    $RETURN();
}

/******************************************************************** PSL **
  2.$B3HD%(B Identify $B%a%C%;!<%8$N<uNN(B f_ScsiInitiatorReceiveExMsg_Sub

       written by f-takei@icot22      on Thu Jul  4 18:56:19 1991
<Arguments>
    A_Lun
    A_Result
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B3HD%(B Identify $B%a%C%;!<%8$r<uNN$9$k!#(B
  $B@5>o$K<uNN$7$?>l9g$K$N$_3HD%(B Identify $B%a%C%;!<%8$K4^$^$l$k(B LUN $B$r(B A_Lun $B$K(B
  $BJV$9!#(B
  $B@5>o$K=*N;$7$J$+$C$?>l9g$K$O0J2<$NCM$r(B A_Result $B$KJV$9!#(B
    _ERROR_IN_RECEIVE_MSG $B!D(B $B<uNNF0:nCf$K%(%i!<$r8!=P$7$?!#(B
    _RESET_END            $B!D(B $B%j%;%C%H%3%s%G%#%7%g%s$r8!=P$7$?!#(B
    _FATAL_ERROR_END      $B!D(B $B0[>o$J3d$j9~$_$r8!=P$7$?!#(B
<Examples>
<Test>
<Explanation>
  $B3HD%(B IDentify $B%a%C%;!<%8$NBh(B 2 $B%P%$%HL\!ABh(B 4 $B%P%$%HL\$^$G$r<uNN$9$k!#(B
  3 $B%P%$%H$N%a%C%;!<%8$N<uNN$,@5>o=*N;$7$?8e!"3HD%(B Identify $B%a%C%;!<%8$G$"$k(B
  $B$3$H$r3NG'$9$k!#3HD%(B Identify $B%a%C%;!<%8$G$"$C$?$J$i$P(B LUN $B$r<h$j=P$7!"(B
  A_Lun $B$KJV$9!#(B
<ETC>
  V1.0 $B%j%j!<%9;~$NF1L>$N%5%V%k!<%A%s$H$OA4$/F~$lBX$o$C$F$$$k!#(B
********************************************************************* PSL **/

#CONST_define _MSG_EXTENDED_IDENTIFY   0x01020200
#CONST_define _MASK_OF_EX_IDENTIFY_FORMAT 0xffffff00

#SUBARG_define A_Lun	DST
#SUBARG_define A_Result	DST

#SUBROUTINE f_ScsiInitiatorReceiveExMsg_Sub(A_Lun, A_Result)
{
    $USE(D_WorkDataLen);
    b_SetImmValueDNTC(_THREE, D_WorkDataLen);
    b_InitiatorTransferCommandMessageIn(D_WorkDataLen);
    $RELEASE(D_WorkDataLen);
    $USE(D_WorkData);
    p_MoveWord(D_ONE, D_WorkData);
    LOOP(){
	b_IfSPCBusy(){ break; }
	b_IfScsiAnyInterrupt(){
	    goto Transfer_End;
	}
    }

    $USE(D_WorkMsg);
    LOOP(){
	$USE(D_WorkInterrupt);
	b_GetScsiInterrupt(D_WorkInterrupt);
	b_IfScsiInterruptSPCHardwareError(D_WorkInterrupt){
	    b_ScsiSetATN();
	}
	$RELEASE(D_WorkInterrupt);
	b_IfScsiParityError(){
	    b_ScsiSetATN();
	}
	b_IfSPCDataBufferNotEmpty(){
	    b_ShiftLeftImmediateWithDNTC(D_WorkData, _SHIFT_LEN_8, D_WorkData);
	    b_GetScsiDataReg(D_WorkMsg);
	    b_BitwiseOrWithDNTC(D_WorkData, D_WorkMsg, D_WorkData);
	}
	b_IfSPCNotBusy(){
	    break;
	}
    }

  Transfer_End:
    $USE(D_WorkInterrupt);
    b_GetScsiInterrupt(D_WorkInterrupt);
    b_IfScsiInterruptResetCondition(D_WorkInterrupt){
	$RELEASE(D_WorkInterrupt);
	$RELEASE(D_WorkMsg);
	$RELEASE(D_WorkData);
	b_SetImmValueDNTC(_RESET_END, A_Result);
	goto END;
    }
    b_IfScsiInterruptSPCHardwareError(D_WorkInterrupt){
	$RELEASE(D_WorkMsg);
	$RELEASE(D_WorkData);
	b_ScsiSPCControlReset();
	b_IfScsiInterruptCommandComplete(D_WorkInterrupt){
	    b_ResetScsiInterruptCommandComplete();
	}
	b_IfScsiInterruptServiceRequired(D_WorkInterrupt){
	    b_ResetScsiInterruptServiceRequired();
	}
	b_IfScsiInterruptDisconnected(D_WorkInterrupt){
	    b_ResetScsiInterruptDisconnected();
	}
	$RELEASE(D_WorkInterrupt);
	b_SetImmValueDNTC(_ERROR_IN_RECEIVE_MSG, A_Result);
	goto END;
    }
    b_IfScsiInterruptCommandComplete(D_WorkInterrupt){
	$RELEASE(D_WorkInterrupt);
	b_ResetScsiInterruptCommandComplete();
	b_IfScsiParityError(){
	    $RELEASE(D_WorkMsg);
	    $RELEASE(D_WorkData);
	    b_ResetScsiErrorReg();
	    b_SetImmValueDNTC(_ERROR_IN_RECEIVE_MSG, A_Result);
	    goto END;
	}
	b_BitwiseAndImmediateWithDNTC
	    (D_WorkData, _MASK_OF_EX_IDENTIFY_FORMAT, D_WorkData);
	p_CompareImmediate(D_WorkData, _MSG_EXTENDED_IDENTIFY);
	p_IfNE(){
	    $RELEASE(D_WorkMsg);
	    $RELEASE(D_WorkData);
	    b_SetImmValueDNTC(_ERROR_IN_RECEIVE_MSG, A_Result);
	    goto END;
	}
	$RELEASE(D_WorkData);
	/* D_WorkMsg$B$K$O(BLUN$B$,$N$C$F$$$k(B */
	p_MoveWord(D_WorkMsg, A_Lun);
	$RELEASE(D_WorkMsg);
	b_SetImmValueDNTC(_RECONNECT, A_Result);
	goto END;
    }
    b_IfScsiInterruptServiceRequired(D_WorkInterrupt){
	$RELEASE(D_WorkInterrupt);
	$RELEASE(D_WorkMsg);
	$RELEASE(D_WorkData);
	b_ResetScsiInterruptServiceRequired();
	b_IfScsiParityError(){
	    b_ResetScsiErrorReg();
	}
	b_SetImmValueDNTC(_ERROR_IN_RECEIVE_MSG, A_Result);
	goto END;
    }
    b_IfScsiInterruptDisconnected(D_WorkInterrupt){
	$RELEASE(D_WorkInterrupt);
	$RELEASE(D_WorkMsg);
	$RELEASE(D_WorkData);
	b_IfScsiParityError(){
	    b_ResetScsiErrorReg();
	}
	b_SetImmValueDNTC(_ERROR_IN_RECEIVE_MSG, A_Result);
	goto END;
    }
    b_IfScsiInterruptSelected(D_WorkInterrupt){
	$RELEASE(D_WorkMsg);
	$RELEASE(D_WorkData);
	p_MoveWord(D_WorkInterrupt, A_Lun);
	b_SetImmValueDNTC(_FATAL_ERROR_END, A_Result);
	$RELEASE(D_WorkInterrupt);
	goto END;
    }
    b_IfScsiInterruptReselected(D_WorkInterrupt){
	$RELEASE(D_WorkMsg);
	$RELEASE(D_WorkData);
	p_MoveWord(D_WorkInterrupt, A_Lun);
	b_SetImmValueDNTC(_FATAL_ERROR_END, A_Result);
	$RELEASE(D_WorkInterrupt);
	goto END;
    }
    b_IfScsiInterruptTimeOut(D_WorkInterrupt){
	$RELEASE(D_WorkMsg);
	$RELEASE(D_WorkData);
	p_MoveWord(D_WorkInterrupt, A_Lun);
	b_SetImmValueDNTC(_FATAL_ERROR_END, A_Result);
	$RELEASE(D_WorkInterrupt);
    }

  END:
    $RETURN();
}
