
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_scsi_intr_error_handler.psl.c
   ----- CREATED   : by f-doumae@icot22, on Tue Oct  2 16:54:13 1990
   ----- LAST SAVED: by f-takei@icot22, on Wed Jul 22 10:40:47 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : $B%(%i!<=hM}(B

1. $B%;%l%/%7%g%s%U%'!<%:$N%"%\!<%H(B
2. $BE>AwF0:n$N%"%\!<%H(B

 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */
/******************************************************************** PSL **
1. $B%;%l%/%7%g%s%U%'!<%:$N%"%\!<%H(B
       written by f-takei@icot22      on Fri Sep 14 15:41:38 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  Select$B%3%^%s%IH/9T8e$N(BSPC Hardware Error$B3d$j9~$_$KBP$9$k=hM}!#(B
  SPC Hardware Error$B3d$j9~$_$,8!=P$5$l$?>l9g!"$=$l$K$h$C$F(BSelect$B%3%^%s%I$N(B
  $BF0:n$,=*N;$9$k$3$H$O$J$$$N$G!"B>$N3d$j9~$_8!=P$K$h$C$F%3%^%s%I$N=*N;$r(B
  $B3NG'$9$k!#(B
  $B$3$3$G$N=hM}FbMF$O0J2<$NDL$j!#(B

  1.Select$B%3%^%s%I$N=*N;$r3NG'$9$k(B
       $B!&%3%M%/%H$7$F$$$J$$(B
       $B!&%3%M%/%H$7$F$$$k(B
       $B!&=*N;$7$F$$$J$$(B
          -> $B%?%$%`%"%&%H8!=P$r9T$&(B
             ($B%?%$%`%"%&%H$N8!=P$O4F;k$9$kI,MW$,$"$k!#(B)
  2.Select$B%3%^%s%I$N=*N;>uBV(B($B3d$j9~$_(B)$B$K$h$C$F0J2<$N=hM}$K$o$+$l$k!#(B
    2-1.Reset Condition$B3d$j9~$_8!=P(B
       $B!&%j%;%C%H%3%s%G%#%7%g%s;~$N=hM}$K>uBV$r@_Dj$9$k!#(B
    2-2.Time Out$B3d$j9~$_8!=P(B
       $B!&7k2LJs9p=hM}$r9T$$!"<!$N%3%^%s%I=hM}$K>uBV$r@_Dj$9$k!#(B
    2-3.$B%$%K%7%(!<%?$H$7$F@\B3$7$F$$$k>l9g!#(B
     (1) Command Complete$B3d$j9~$_8!=P(B
       $B!&E>Aw%"%\!<%H=hM}$r9T$&!#(B
       $B!&7k2LJs9p=hM}$r9T$$!"<!$N%3%^%s%I=hM}$K>uBV$r@_Dj$9$k!#(B
     (2) Reselected$B3d$j9~$_8!=P(B
       $B!&7k2LJs9p=hM}$r9T$&!#(B
       $B!&%j%;%l%/%H;~$N3d$j9~$_=hM}$K>uBV$r@_Dj$9$k!#(B
    2-4.$B%?!<%2%C%H$H$7$F@\B3$7$F$$$k>l9g!#(B
     (1) Selected$B3d$j9~$_8!=P(B
       $B!&7k2LJs9p=hM}$r9T$&!#(B
       $B!&%;%l%/%H;~$N3d$j9~$_=hM}$K>uBV$r@_Dj$9$k!#(B
    2-5.SCSI$B$H@\B3$7$F$$$J$$;~(B
     (1) Command Complete$B3d$j9~$_8!=P(B
       $B%"!<%S%H%l!<%7%g%s<:GT!#(B
       $B!&7k2LJs9p=hM}$r9T$$!"<!$N%3%^%s%I=hM}$K>uBV$r@_Dj$9$k!#(B
     (2) Disconnected$B3d$j9~$_8!=P(B
       $B!&7k2LJs9p=hM}$r9T$$!"<!$N%3%^%s%I=hM}$K>uBV$r@_Dj$9$k!#(B
<ETC>
********************************************************************* PSL **/

#SUBARG_define A_CommRec     MODIFY
#SUBARG_define A_Phase       DST

#SUBROUTINE f_ScsiSelectAbort_Sub(A_CommRec, A_Phase)
{
    $USE(D_WorkInterrupt);
    LOOP(){
	/*----------------------------------------------------------------
	  $B%?%$%`%"%&%H8!=P=hM}$,I,MW$H$J$k!#(B
	  $B$3$N$?$a!"L5>r7o%k!<%W$G$O$J$/$F0lDj2s?t$N>r7o$D$-$K$9$k$3$H(B
	  $B$b9M$($i$l$k!#(B
	  $B%?%$%`%"%&%H8!=P8e$O!"(B"Reset & Disable"$B$K$h$C$F(BSelect$B%3%^%s%I$r(B
	  $B6/@)=*N;$5$;$k!#(B
	-----------------------------------------------------------------*/
	b_GetScsiInterrupt(D_WorkInterrupt);
	/* $BB>$N3d$j9~$_$N8!=PBT$A(B */
	b_BitwiseEorImmediateWithDNTC
	    (D_WorkInterrupt, _SPC_INTS_SPC_HARDWARE_ERROR, D_VOID);
	p_IfEQ(){ /* SPC Hardware Error $B$N$_(B */
	    ;
	}else{ /* $B>e5-0J30$N3d$j9~$_$N8!=P(B */
	    break;
	}
    }
    b_ResetScsiInterruptSPCHardwareError();

    b_IfScsiInterruptResetCondition(D_WorkInterrupt){
	/* $B%j%;%C%H%3%s%G%#%7%g%s8!=P(B */
	$RELEASE(D_WorkInterrupt);
	b_SetImmValueDNTC(_ERROR_END, A_Phase);
	goto END;
    }
    b_IfScsiInterruptTimeOut(D_WorkInterrupt){
	/* $B%?%$%`%"%&%H8!=P(B */
	$RELEASE(D_WorkInterrupt);
	b_ResetScsiInterruptTimeOut();
	s_OrErrorCodeCommRec(_TIME_OUT, A_CommRec);
	/* $B40N;>uBV$N%;%C%H(B */
	b_SetImmValueDNTC(_POP_NEXT_COMM_REC, A_Phase);
	goto Result_Report;
    }

    b_ScsiSPCControlReset();
    /* SPC $B$N%G!<%?E>Aw@)8f2sO)$N%j%;%C%H(B */
    $USE(D_WorkStatus);
    b_GetScsiStatus(D_WorkStatus);
    b_GetScsiInterrupt(D_WorkInterrupt);
    b_IfScsiStatusConnectedAsInitiator(D_WorkStatus){
    /* $B%$%K%7%(!<%?$H$7$F@\B3(B */
	b_IfScsiInterruptReselected(D_WorkInterrupt){
	    /* $B%j%;%l%/%H$5$l$?(B */
	    $RELEASE(D_WorkInterrupt);
	    $RELEASE(D_WorkStatus);
	    b_ResetScsiInterruptReselected(); /* $B3d$j9~$_%j%;%C%H(B */
	    b_SetImmValueDNTC(_RESELECTED, A_Phase);
	    goto Result_Report;
	}
	b_IfScsiInterruptCommandComplete(D_WorkInterrupt){
	    /* Select$B%3%^%s%I@.8y(B */
	    $RELEASE(D_WorkStatus);
	    $RELEASE(D_WorkInterrupt);
	    b_ResetScsiInterruptCommandComplete();
	    $CALL(f_ScsiTransferAbort_Sub(A_CommRec));
	    b_SetImmValueDNTC(_POP_NEXT_COMM_REC, A_Phase);
	    goto Result_Report;
	}
	/* $B%$%K%7%(!<%?$H$7$F%3%M%/%H$7$F$$$k$,%;%l%/%7%g%s@.8y$G$b!"(B
	   $B%j%;%l%/%H$5$l$?$N$G$b$J$$!#(B                             */
	@DEBUG{
	    VPIM_ERROR("f_ScsiSelectAbort_Sub","trouble in spc ?");
	};
    } /* End of b_IfScsiStatusConnectedAsInitiator */

    b_IfScsiStatusConnectedAsTarget(D_WorkStatus){
    /* $B%?!<%2%C%H$H$7$F@\B3(B */
	b_IfScsiInterruptSelected(D_WorkInterrupt){
	    /* $B%;%l%/%H$5$l$?(B */
	    $RELEASE(D_WorkInterrupt);
	    $RELEASE(D_WorkStatus);
	    b_ResetScsiInterruptSelected();
	    b_SetImmValueDNTC(_SELECTED, A_Phase);
	    goto Result_Report;
	}
	/* $B%?!<%2%C%H$H$7$F@\B3$7$F$$$k$,%;%l%/%H$5$l$?$N$G$O$J$$!#(B*/
	@DEBUG{
	    VPIM_ERROR("f_ScsiSelectAbort_Sub","trouble in spc ?");
	};
    } /* End of b_IfScsiStatusConnectedAsTarget */
    b_IfScsiStatusNotConnected(D_WorkStatus){
    /* SCSI$B$H$O@\B3$7$F$$$J$$(B */
	b_IfScsiInterruptDisconnected(D_WorkInterrupt){
	    /* $B%P%9%U%j!<%U%'!<%:8!=P(B */
	    $RELEASE(D_WorkStatus);
	    b_IfScsiInterruptReselected(D_WorkInterrupt){
		/* $B%j%;%l%/%H8e$K%P%9$,2rJ|$5$l$?(B */
		b_ResetScsiInterruptReselectedAndDisconnected();
	    }else{
		/* Select$B%3%^%s%I@.8y8e$K%P%9$,2rJ|$5$l$?(B */
		b_ResetScsiInterruptDisconnected();
	    }
	    $RELEASE(D_WorkInterrupt);
	    b_SetImmValueDNTC(_POP_NEXT_COMM_REC, A_Phase);
	    goto Result_Report;
	}
	b_IfScsiInterruptCommandComplete(D_WorkInterrupt){
	    /* $B%"!<%S%H%l!<%7%g%s<:GT(B */
	    $RELEASE(D_WorkInterrupt);
	    $RELEASE(D_WorkStatus);
	    b_ResetScsiInterruptCommandComplete();
	    b_SetImmValueDNTC(_POP_NEXT_COMM_REC, A_Phase);
	    goto Result_Report;
	}
	@DEBUG{
	    VPIM_ERROR("f_ScsiSelectAbort_Sub","truble in spc ?");
	};
    } /* End of b_IfScsiStatusNotConnected */
    @DEBUG{
	VPIM_ERROR("f_ScsiSelectAbort_Sub",
		   "fatal error!! What happened?");
    };

  Result_Report:
    /*---------------------------------------------------------------------
      $BDL>o$O!"(Bi_SCSIDeviceDriverInitiatorBody_Sub(comm_rec_ptr_reg) $B$NCf$G(B
      $B9T$&=hM}$@$,!"7k2LJs9p=hM}$K0\$k$3$H$r<($9%i%Y%k$r0l35$K@_Dj$G$-$J$$!#(B
      $B=>$C$F!"(B
      $B$3$N%5%V%k!<%A%s$G@_Dj$5$l$k$N$O!"(B_SELECTED, _RESELECTED, _ERROR_END
      _POP_NEXT_COMM_REC$B$H$J$k!#(B
    ---------------------------------------------------------------------*/
    $CALL(f_ScsiInitiatorResultReport_Sub(A_CommRec));
    /*-------------------------------------------------------
      $B$3$3$G(B1$B$D$N%3%^%s%I$N<B9T$,40N;$9$k!#(B
      $B%3%^%s%I%l%3!<%I$r%U%j!<%j%9%H$KJV$9;~!"%3%^%s%I%l%3!<%I%U%j!<%j%9%H(B
      $BBT$A%-%e!<$K%4!<%k%l%3!<%I$,$"$l$P$=$l$r%l%G%#%4!<%k%9%?%C%/$KF~$l$k!#(B
    ----------------------------------------------------------*/
    s_ReclaimCommRec(A_CommRec); /* $B%U%j!<%j%9%H$KLa$9!#(B*/
    f_IfNotEmptyCommRecFreeListWaiting(){
	$USE(D_WorkGoalPtr);
	f_DequeueFromCommRecFreeListWaiting(D_WorkGoalPtr);
	$USE(D_WorkPriority);
	s_GetPriorityEnvGoalRecord(D_WorkGoalPtr, D_WorkPriority);
	$CALL(f_PushGoalToStackWithPriority_Sub
	      (D_WorkGoalPtr, D_WorkPriority));
	$RELEASE(D_WorkPriority);
	$RELEASE(D_WorkGoalPtr);
    }
    /*-----------------------------------------------------------
      $BF1$8(BUnit,LUN$B$G<B9T$rBT$C$F$$$?%3%^%s%I$,M=Ls%-%e!<$K$"$l$P(B
      $B%P%98"%-%e!<$K0\$9!#%U%j!<%j%9%H$KLa$7$?%3%^%s%I%l%3!<%I$X$N(B
      $B%]%$%s%?$O(B A_CommRec $B$,$^$@0.$C$F$k!#(B
    -------------------------------------------------------------*/
    $USE(D_WorkUnit1);$USE(D_WorkLun1);
    s_GetScsiCommRecUnit(A_CommRec, D_WorkUnit1);
    s_GetScsiCommRecLUN(A_CommRec, D_WorkLun1);
    f_DequeueCommRecFromReservWithUnitAndLun
	                      (D_WorkUnit1, D_WorkLun1, A_CommRec);
    $RELEASE(D_WorkLun1);$RELEASE(D_WorkUnit1);
    s_IfScsiCommRec(A_CommRec){
	f_EnqueueToBusFreeWaiting(A_CommRec);
    }else{
	@DEBUG{
	    b_IfNotEOL(A_CommRec){
		VPIM_ERROR("f_ScsiSelectAbort_Sub","Illegal pointer");
	    }
	};
    }
    
  END:
    $RETURN();
}

/******************************************************************** PSL **
2. $BE>AwF0:n$N%"%\!<%H(B
       written by f-takei@icot22      on Thu Sep 20 14:13:39 1990
       revised by f-takei@icot22      on Mon Jul  8 20:12:46 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  $BE>AwCf$K%(%i!<$,@8$8$?>l9g$K!"%?!<%2%C%H$K(B"Abort"$B%a%C%;!<%8$rAw$j%;%C%7%g%s(B
  $B$,=*N;$9$k$^$G$N=hM}$r9T$&!#$=$N:]$K%a%C%;!<%8%"%&%H%U%'!<%:0J30$N%U%'!<%:$r(B
  $B%?!<%2%C%H$,MW5a$7$F$-$?>l9g$K$b$=$l$K1~$8$k!#(B
  $B$^$?!"(Bf_ScsiSelectAbort_Sub $B$G%?!<%2%C%H$H$N%;%C%7%g%s$r%"%\!<%H$9$k>l9g!"(B
  $B5Z$S(Bf_ScsiReselected_Sub$B$G3:Ev$9$k%3%^%s%I%l%3!<%I$,$J$$0?$$$O%-%c%s%;%k$5$l(B
  $B$F$$$?>l9g$K!"0z?t$K(BD_NULL$B$,$o$?$5$l$k!#$3$N$H$-!"%3%^%s%I%l%3!<%I$X$N(B
  $B%"%/%;%9$O9T$o$J$$!#(B
  $B=hM}FbMF$O0J2<$NDL$j!#(B

  1.$B%"%F%s%7%g%s%3%s%G%#%7%g%s$H$9$k!#(B
  2.$B%a%C%;!<%8%"%&%H%U%'!<%:$H$J$k$N$rBT$D!#(B
    $B%?!<%2%C%H$NMW5a$9$k%U%'!<%:$K$h$j0J2<$N$h$&$K$o$+$l$k!#(B
    $B!&%a%C%;!<%8%"%&%H%U%'!<%:(B
      $B%k!<%W$+$iH4$1$k!#(B
    $B!&%G!<%?%$%s%U%'!<%:(B
      $B%G!<%?$r<uNN$7(B($BFI$_<N$F(B)$B!"%k!<%W$9$k!#(B
    $B!&%G!<%?%"%&%H%U%'!<%:(B
      NULL$B%G!<%?$rAw$j!"%k!<%W$9$k!#(B
    $B!&%3%^%s%I%U%'!<%:(B
      NULL$B%G!<%?$rAw$j!"%k!<%W$9$k!#(B
    $B!&%a%C%;!<%8%$%s%U%'!<%:(B
      $B%a%C%;!<%8$r(B1$B%P%$%H<uNN$9$k!#(B
      $B<uNN$7$?%G!<%?$K$h$j0J2<$N=hM}$K$o$+$l$k!#(B
        - Command Complete
            $B!&(BA_CommRec$B$,(B0$B$G$J$1$l$P40N;>uBV%U%i%0$r%;%C%H$9$k!#(B
            $B!&%P%9%U%j!<%U%'!<%:BT$A$K0\9T$9$k!#(B
        - Disconnect
            $B%P%9%U%j!<%U%'!<%:BT$A$K0\9T$9$k!#(B
        - Disconnect$B0J30$N%a%C%;!<%8(B
            $BFI$_<N$F$F%k!<%W$9$k!#(B
    $B!&%9%F!<%?%9%U%'!<%:(B
      - A_CommRec$B$,(B0$B$G$J$1$l$P%9%F!<%?%9%P%$%H$r<uNN!"(B
        $B%3%^%s%I%l%3!<%I$K3JG<$9$k!#(B
      - $B%k!<%W$9$k!#(B
    $B!&%P%9%U%j!<%U%'!<%:(B
      $B=*N;$9$k!#(B
  3."Abort"$B%a%C%;!<%8$rAw=P$9$k!#(B
    $B!&%Q%j%F%#%(%i!<$,8!=P$5$l$?>l9g$N=hM}$OL$Dj!#(B
  4.$B%P%9%U%j!<%U%'!<%:$N8!=PBT$A!#(B
    $B%U%'!<%:$K$h$j0J2<$N=hM}$K$o$+$l$k!#(B
    $B!&%P%9%U%j!<%U%'!<%:(B
      $B=*N;$9$k!#(B
    $B!&%a%C%;!<%8%$%s%U%'!<%:(B
      $B%a%C%;!<%8$r(B1$B%P%$%H<uNN$9$k!#(B
      $B<uNN$7$?%G!<%?$K$h$j0J2<$N=hM}$K$o$+$l$k!#(B
        - Disconnect
            $B%P%9%U%j!<%U%'!<%:BT$A$K0\9T$9$k!#(B
        - Disconnect$B0J30$N%a%C%;!<%8(B
            ($B@)8f$G$-$J$$(B)
    $B!&%3%^%s%I%U%'!<%:(B
    $B!&%G!<%?%$%s%U%'!<%:(B
    $B!&%G!<%?%"%&%H%U%'!<%:(B
    $B!&%9%F!<%?%9%U%'!<%:(B
      ($B@)8f$G$-$J$$(B)
  5.$B%P%9%U%j!<%U%'!<%:BT$A!#(B
    $B!&(BSPC$B$N3d$j9~$_$rD4$Y$k!#(B
        - Disconnected$B$J$i$P3d$j9~$_$r%j%;%C%H$7$F=*N;!#(B
        - $B$=$l0J30$N>l9g(B($B@)8f$G$-$J$$(B)$B!#(B

<ETC>
<Revised Memo on "Jul  8">
  SPC $B$N0[>o$J3d$j9~$_8!=P$r(B KL1 $B$XDLCN$9$k!#(B
********************************************************************* PSL **/

#SUBARG_define A_CommRec    SRC

#SUBROUTINE f_ScsiTransferAbort_Sub(A_CommRec)
{
    b_IfScsiAnyInterrupt(){
	goto Intr_Check;
    }

    b_ScsiSetATN();
    /*--------------------------------------
     ATN$B?.9f$r=P$7!"%?!<%2%C%H$,%U%'!<%:$r(B
     $B%a%C%;!<%8%"%&%H$K0\9T$9$k$N$rBT$D(B
     ---------------------------------------*/
    LOOP(){
	$USE(D_WorkPhase);
	b_GetScsiPhase(D_WorkPhase);
	ValueSwitch(D_WorkPhase){
	  case _MESSAGE_OUT_PHASE:
	    $RELEASE(D_WorkPhase);
	    goto Send_Abort;
	  case _DATA_IN_PHASE:
	    $RELEASE(D_WorkPhase);
	    b_ScsiIgnoreReceiveData(); /* $B%G!<%?FI$_<N$F(B */
	    break;
	  case _DATA_OUT_PHASE:
	  case _COMMAND_PHASE:
	    $RELEASE(D_WorkPhase);
	    b_ScsiSendNullData(); /* NULL DATA$B$rAw$k!#(B*/
	    break;
	  case _MESSAGE_IN_PHASE:
	    $RELEASE(D_WorkPhase);
	    $USE(D_WorkMessage);
	    b_ScsiInitiatorReceiveDataByManual(D_WorkMessage);
	    /* $B%a%C%;!<%8$N<uNN(B */
	    ValueSwitch(D_WorkMessage){
	      case _MSG_COMMAND_COMPLETE:
		b_ScsiResetATN();
		$RELEASE(D_WorkMessage);
		b_IfNotZero(A_CommRec){
		    s_SetResultCodeCommRecMsgReceived(A_CommRec);
		}
		goto Wait_BusFree;
	      case _MSG_DISCONNECT:
		b_ScsiResetATN();
		$RELEASE(D_WorkMessage);
		goto Wait_BusFree;
	      default:
		$RELEASE(D_WorkMessage);
		break;
	    }
	    break;
	  case _STATUS_PHASE:
	    $RELEASE(D_WorkPhase);
	    b_IfNotZero(A_CommRec){
		$USE(D_WorkStatus);
		b_ScsiInitiatorReceiveDataByManual(D_WorkStatus);
		s_SetScsiCommRecStatus(D_WorkStatus, A_CommRec);
		$RELEASE(D_WorkStatus);
	    }else{
		b_ScsiIgnoreReceiveData();
	    }
	    break;
	  case _BUS_FREE_PHASE:
	    $RELEASE(D_WorkPhase);
	    goto Intr_Check;
	  default:
	    $RELEASE(D_WorkPhase);
	    b_IfScsiAnyInterrupt(){
		goto Intr_Check;
	    }
	    @DEBUG{
		VPIM_ERROR("f_ScsiTransferAbort_Sub","unknown phase");
	    };
	    break;
	}/* end of ValueSwitch */
    }/* end of LOOP */
  Send_Abort:
    b_ScsiInitiatorSendMessageByManual(_MSG_ABORT);
    /* send "Abort" message */
    b_IfScsiParityError(){
	; /* not yet */
    }
/*    b_ScsiResetATN(); */
    LOOP(){
	b_IfScsiAnyInterrupt(){
	    $USE(D_WorkInterrupt);
	    b_GetScsiInterrupt(D_WorkInterrupt);
	    b_IfScsiInterruptDisconnected(D_WorkInterrupt){
		$RELEASE(D_WorkInterrupt);
		b_ResetScsiInterruptDisconnected();
		goto END;
	    }
	    goto Intr_Check;
	}
	$USE(D_WorkPhase);
	b_GetScsiPhase(D_WorkPhase);
	ValueSwitch(D_WorkPhase){
	  case _BUS_FREE_PHASE:
	    $RELEASE(D_WorkPhase);
	    goto Intr_Check;
	  case _MESSAGE_IN_PHASE:
	    $USE(D_WorkMessage);
	    b_ScsiInitiatorReceiveDataByManual(D_WorkMessage);
	    /* $B%a%C%;!<%8$N<uNN(B */
	    b_IfEqualImm(D_WorkMessage, _MSG_DISCONNECT){
		$RELEASE(D_WorkMessage);
		$RELEASE(D_WorkPhase);
		goto Wait_BusFree;
	    }
	    $RELEASE(D_WorkMessage);
	    $RELEASE(D_WorkPhase);
	    /* "Disconnect"$B%a%C%;!<%80J30$N$b$N$O@)8f$G$-$J$$!#(B */
	    break;
	  case _MESSAGE_OUT_PHASE:
	  case _COMMAND_PHASE:
	  case _DATA_IN_PHASE:
	  case _DATA_OUT_PHASE:
	  case _STATUS_PHASE:
	    /* cannot control */
	    $RELEASE(D_WorkPhase);
	    @DEBUG{
		VPIM_ERROR("f_ScsiTransferAbort_Sub","cannot control!");
	    };
	    break;
	  default:   /* not assigned phase */
	    $RELEASE(D_WorkPhase);
	    @DEBUG{
		VPIM_ERROR("f_ScsiTransferAbort_Sub","unknown phase");
	    };
	    break;
	}
    }

  Wait_BusFree:
    b_BusyWaitScsiInterrupt();
    $USE(D_WorkInterrupt);
    b_GetScsiInterrupt(D_WorkInterrupt);
    b_IfScsiInterruptDisconnected(D_WorkInterrupt){
	$RELEASE(D_WorkInterrupt);
	b_ResetScsiInterruptDisconnected();
	goto END;
    }else{
	/* SPC Hardware Error, Service Required, Command Complete, Time Out */
	goto Intr_Check;
    }

  Intr_Check:
    $USE(D_WorkInterrupt);
    b_GetScsiInterrupt(D_WorkInterrupt);
    b_IfScsiInterruptResetCondition(D_WorkInterrupt){
	$RELEASE(D_WorkInterrupt);
	b_IfNotZero(A_CommRec){
	    s_OrErrorCodeCommRec(_RESET_CONDITION_DETECTED, A_CommRec);
	}
	$CALL(f_ScsiResetConditionHandling_Sub(D_NULL));
	goto END;
    }
    b_IfScsiInterruptDisconnected(D_WorkInterrupt){
	$RELEASE(D_WorkInterrupt);
	b_ResetScsiInterruptDisconnected();
	b_IfNotZero(A_CommRec){
	    s_OrErrorCodeCommRec(_DISCONNECTED, A_CommRec);
	}
	goto END;
    }
    b_IfNotZero(A_CommRec){
	s_OrErrorCodeCommRec(_SCSI_FATAL_ERROR, A_CommRec);
    }
    $CALL(f_ScsiFatalErrorEnd_Sub(D_WorkInterrupt, D_NULL));
    $RELEASE(D_WorkInterrupt);

  END:
    $RETURN();
}
