
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_scsi_initialize.psl.c
   ----- CREATED   : by f-takei@icot22, on Wed Nov 21 15:53:14 1990
   ----- LAST SAVED: by f-takei@icot22, on Thu May 14 21:54:58 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : function
   ----- ABSTRACT  : SPC $B$N=i4|2=%k!<%A%s(B
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **

       written by f-takei@icot22      on Fri Nov  8 17:38:45 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  SPC$B$N=i4|@_Dj$r9T$&!#(B
<Examples>
<Test>
<Explanation>
  SCSI$B%G%P%$%9(BID$B$r9=@.>pJs$r85$K@_Dj$9$k!#(B
<ETC>
********************************************************************* PSL **/

#CONST_define  _SPC_INTERRUPT_MODE  0x60 /* 01100000 */
#CONST_define  _SPC_OPERATION_MODE  0x1f /* 00011111 */

#PSL_define f_InitializeSPC()
{
    $USE(D_WorkDataPtr);
    $USE(D_WorkData);
    b_SetImmValueDNTC(_SYSTEM_CONFIG_AREA_BASE, D_WorkDataPtr);
    b_AddImmediateWithDNTC
	(D_WorkDataPtr, _SCSI_SYS_CONFIG_AREA_BASE, D_WorkDataPtr);
    LOOP(){
	b_ReadScsiConfigClusterNumInSystem(D_WorkDataPtr, D_WorkData);
	b_IfWordNotEq(D_WorkData, D_NULL){
	    b_IfWordEq(D_WorkData, D_CL_Number){
		b_ReadScsiConfigPENumInCluster(D_WorkDataPtr, D_WorkData);
		b_IfWordEq(D_WorkData, D_PE_Number){
		    break;
		}
	    }
	}else{
	    goto End;
	}
	b_AddImmediateWithDNTC(D_WorkDataPtr,
		       _SIZE_OF_SCSI_SYS_CONFIG_AREA, D_WorkDataPtr);
    }
    b_ReadScsiConfigDeviceNumOnScsi(D_WorkDataPtr, D_DeviceNumberOnScsi);
    /* $B%Q!<%^%M%s%H%l%8%9%?$K@_Dj$9$k!#(B*/

    b_SetScsiBusDeviceID(D_DeviceNumberOnScsi);
    /* $B%l%8%9%?$N=i4|@_Dj(B */
    /* SCMD */
    b_SetScsiCommand(D_NULL);
    /* added 92.5.14 */
    /* TMOD */
    b_SetScsiTransMode(D_NULL);
    /* TEMP */
    b_SetScsiTempReg(D_NULL);
    /* MBC */
    b_SetScsiByteCounter(D_NULL);
    /* TCH, TCM, TCL */
    b_SetScsiTransCtrHigh(D_NULL);
    b_SetScsiTransCtrMid(D_NULL);
    b_SetScsiTransCtrLow(D_NULL);
    /*===============*/
    /* PCTL */
    b_SetImmValueDNTC(_SPC_INTERRUPT_MODE, D_WorkData);
    b_SetScsiPhaseCtrl(D_WorkData);

    /* $BF0:n%b!<%I$N@_Dj$H%j%;%C%H>uBV$N2r=|(B : SCTL */
    b_SetImmValueDNTC(_SPC_OPERATION_MODE, D_WorkData);
    b_SetScsiSPCCtrl(D_WorkData);

  End:
    $RELEASE(D_WorkDataPtr);
    $RELEASE(D_WorkData);
}
