
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_reduce_vector_ope.psl.c
   ----- CREATED   : by f-hataza@icot22, on Wed May 16 13:43:18 1990
   ----- LAST SAVED: by imai@icot22, on Wed Nov  6 21:00:42 1991
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : FUNCTIONS
   ----- ABSTRACT  : $B%Y%/%?4XO"%^%/%m(B

  VPIM $B$K$*$1$k%Y%/%?$N%G!<%?9=B$$K$D$$$F$O!"(Bstr_vector.psl.c $B$K5-=R$9$k!#(B

  $B$3$N%U%!%$%kFb$N%^%/%m$O%Y%/%?$KBP$9$k0J2<$NA`:n$rDj5A$7$F$$$k!#(B
    1. $B%Y%/%?$N3d$jIU$1(B
    2. $B%Y%/%?MWAG$N=i4|2=(B
    3. $B%Y%/%?$N%3%T!<(B
    4. $B%m%s%0%Y%/%?$N%5%$%:$NHf3S(B
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
  1. $B%Y%/%?$r3d$jIU$1$kA`:n(B

       written by goto@icot22      Mon Jan  9 09:42:46 1989

<Arguments>
    dest_reg :         $B3d$jIU$1$?%Y%/%?$X$N%]%$%s%?$r3JG<$9$k%l%8%9%?(B
    opr_reg :          $B%Y%/%?$N%5%$%:$r<($9(B KL1-B $BL?Na$NB(CM%*%Z%i%s%I(B
    A_AllocVectSize :  $B%Y%/%?$N%5%$%:(B($B%l%8%9%?(B)
    A_Vector :         $B%Y%/%?$r3d$jIU$1$k%l%8%9%?(B  
<Temporally Used Variables>
<Level> functions
<PreCondition>
<Function>
  $B%Y%/%?$N3d$jIU$1(B(MRB$B!;(B)
   ($B%R!<%WNN0h$,ITB-$7$?;~$K$O!"(BA_Vector $B$K(B D_NULL $B$r$+$($9$N$G!"(B
    $B8F$S=P$7$?B&$G=hM}$7$J$1$l$P$J$i$J$$!#(B ex. Dcode $B%4!<%k$N%(%s%-%e!<!#(B
    GC $BMW5a$O(B $B$3$N%5%V%k!<%A%s$,8F$S=P$9%^%/%mFb$G9T$o$l$k!#(B)
<Examples>
<Test>
<Explanation>
<ETC>
  $B!&(Bf_AllocVector $B$O:o=|$7!"%Y%/%?$N3d$jIU$1$K$OD>@\(B f_AllocVectorMRBoff_Sub
  $B$r8F$V!#(B
  $B!&(Bf_AllocVectorOpr $B$O!"(BKL1-B$BL?Na(B(reuse_vector,alloc_vector) $B$+$i8F$P$l$k!#(B
********************************************************************* PSL **/

#PSL_define f_AllocVectorOpr(dest_reg,opr_size) 
{
  $USE(D_WorkVectSize);
  b_MoveImmOprWithMRBandType (opr_size, _MRB_OFF, INT, D_WorkVectSize);
  $CALL( f_AllocVectorMRBoff_Sub(D_WorkVectSize, dest_reg));
  $RELEASE(D_WorkVectSize);
}


#SUBARG_define	A_AllocVectSize		SRC
#SUBARG_define	A_Vector		DST

#SUBROUTINE f_AllocVectorMRBoff_Sub (A_AllocVectSize, A_Vector)
{
  @DEBUG{
    b_IfLess(A_AllocVectSize, D_NULL) {
      VPIM_ERROR( "f_AllocVectorMRBoff_Sub", "Illegal vector size");
    }
  };
  ValueSwitch(A_AllocVectSize) {
   case 0: s_AllocVect0(A_Vector); break;
   case 1: s_AllocVect1(A_Vector); break;
   case 2: s_AllocVect2(A_Vector); break;
   case 3: s_AllocVect3(A_Vector); break;
   case 4: s_AllocVect4(A_Vector); break;
   case 5: s_AllocVect5(A_Vector); break;
   case 6: s_AllocVect6(A_Vector); break;
   case 7: s_AllocVect7(A_Vector); break;
   case 8: s_AllocVect8(A_Vector); break;
   default: 
     $CALL( s_AllocLongVect_Sub(A_AllocVectSize, A_Vector) );
  } /* end of ValueSwitch */
  $RETURN ();
}

/******************************************************************** PSL **
  2. $B%Y%/%?MWAG$N=i4|2=A`:n(B
     f_InitializeVector(init_elem_reg, size_reg, vect_ptr) 

       written by f-hataza@icot21     Thu Sep 27 17:19:00 1989

<Arguments>
  init_elem_reg :    $B=i4|CM(B             ($B%l%8%9%?(B)
  size_reg :         $B%Y%/%?%5%$%:(B       ($B%l%8%9%?(B)
  vect_ptr :         $B%Y%/%?$X$N%]%$%s%?(B	($B%l%8%9%?(B)
<Temporally Used Variables>
<Level> functions
<PreCondition>
<Function>
  $B!&(Bvect_ptr $B$,;X$9%Y%/%?$N3FMWAG$r=i4|CM(B init_elem_reg $B$G=i4|2=$9$k!#(B
<Examples>
  kblt_new_vector()
<Test>
<Explanation>
<ETC>
  f_GetNewVector $B$O:o=|$7!"(Bkblt_new_vector $B$+$i%Y%/%?$r@8@.$9$k>l9g$K$O!"(B
  f_AllocVectorMRBoff_Sub $B$r(B call $B$7$?8e!"$3$N%^%/%m$r8F$S=P$9!#(B
  (1989.9.27 f-hataza)
********************************************************************* PSL **/
#DATA_define D_WorkElemOfst  XXX

#PSL_define f_InitializeVector(init_elem_reg, size_reg, vect_ptr) 
{
  $USE(D_WorkElemOfst);
  b_ExchangeElmposToOffset(size_reg, D_WorkElemOfst);
  b_DecrementAddrReg(D_WorkElemOfst);
  LOOP(){
    b_IfLess(D_WorkElemOfst, D_NULL){ break;}
    s_PutVectElementOffsetReg(vect_ptr, D_WorkElemOfst, init_elem_reg);
    b_DecrementAddrReg(D_WorkElemOfst);
  }
  $RELEASE(D_WorkElemOfst);
}

/******************************************************************** PSL **
  3. $B%Y%/%?$N%3%T!<(B

       written by nakase@icot22      on Mon Feb 13 19:27:52 1989

<Arguments>
 src_vect_ptr: $B%Y%/%?$N%3%T!<$N%=!<%9(B
 dst_vect_ptr: $B%Y%/%?$N%3%T!<$N%G%#%9%A%M!<%7%g%s(B
 size_reg :    $B%3%T!<$9$k%Y%/%?$N%5%$%:(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  f_CopyNullVector(src_vect_ptr, dst_vect_ptr) 
  f_CopyShortVectorMRB(src_vect_ptr, size_reg, dst_vect_ptr) 
  f_CopyLongVectorMRB(src_vect_ptr, size_reg, dst_vect_ptr) 
  $B!&(B $B$=$l$>$l!"%J%k%Y%/%?!"%7%g!<%H%Y%/%?!"%m%s%0%Y%/%?$r%3%T!<$9$k!#(B
  $B!&(B src_vect_ptr$B$N(BMRB$B$,(B o $B$J$i$P(Bsrc_vect_ptr$B$r(Bdst_vect_ptr$B$K%3%T!<(B
     src_vect_ptr$B$N(BMRB$B$,(B x $B$J$i$P(Bsrc_vect_ptr$B$N;X$9%Y%/%?$r(Bdst_vect_ptr$B$N@h$K(B
     $B%3%T!<(B
  $B!&(B $B%R!<%WNN0h$,ITB-$7$?;~$K$O!"(Bdst_vect_ptr $B$K(B D_NULL $B$r$+$($9$N$G!"(B
     $B8F$S=P$7$?B&$G=hM}$7$J$1$l$P$J$i$J$$!#(B(f_CopyLongVectorMRB $B$N;~(B)
<Examples>
<Test>
<Explanation>
<ETC>
  f_CopyVectorMRB $B$O:o=|$7!"%J%k%Y%/%?!"%7%g!<%H%Y%/%?!"%m%s%0%Y%/%?$N(B
  $B$=$l$>$l$KBP$7$F%3%T!<MQ$N%^%/%m$r:n$C$?(B(1989.11.1)
********************************************************************* PSL **/

/***** Copy Null Vector ***(only for kblt_b_vector() )*****/
#PSL_define f_CopyNullVector(src_vect_ptr, dst_vect_ptr) 
{
  @DEBUG{
    s_IfNotNullVectors(src_vect_ptr) {
      VPIM_ERROR("f_CopyNullVector", "Illegal type");
    }
  };
  p_MoveWord(src_vect_ptr, dst_vect_ptr);
}

/***** Copy Short Vector *****/
#PSL_define f_CopyShortVectorMRB(src_vect_ptr, size_reg, dst_vect_ptr) 
{
  @DEBUG{
    s_IfNotShortVectors(src_vect_ptr) {
      VPIM_ERROR("f_CopyShortVectorMRB", "Illegal type");
    }
  };
  s_IfMRBoff(src_vect_ptr) {
    p_MoveWord(src_vect_ptr,dst_vect_ptr);
  } else {
    $CALL( f_AllocVectorMRBoff_Sub(size_reg, dst_vect_ptr) );
    $CALL( s_CopyElemShortVect_Sub(src_vect_ptr, dst_vect_ptr) );
  }
}

/***** Copy Long Vector *****/
#PSL_define f_CopyLongVectorMRB(src_vect_ptr, size_reg, dst_vect_ptr) 
{
  @DEBUG{
    s_IfNotLongVectors(src_vect_ptr) {
      VPIM_ERROR("f_CopyLongVectorMRB", "Illegal type");
    }
  };
  s_IfMRBoff(src_vect_ptr) {
    p_MoveWord(src_vect_ptr,dst_vect_ptr);
  } else {
    $CALL (s_AllocLongVect_Sub(size_reg, dst_vect_ptr));
    b_IfWordNotEq(dst_vect_ptr, D_NULL) {       /* $B%"%m%1!<%H@.8y(B */
      $CALL( s_CopyElemLongVect_Sub(src_vect_ptr, size_reg, dst_vect_ptr) );
    }
  }
}

/******************************************************************** PSL **
 4. $B%m%s%0%Y%/%?$N%5%$%:$NHf3S(B
    f_IfLongVectSizeEqual
    f_IfLongVectSizeNotEqual

       written by f-doumae@icot22      on Thu Mar 30 11:34:16 1989
<Arguments>
    vect_ptr_regx  $B%Y%/%?$r;X$9%l%8%9%?(B
    vect_ptr_regy  $B%Y%/%?$r;X$9%l%8%9%?(B

<Temporally Used Variables>
<Level>    functions
<PreCondition>
<Function>
  2$B$D$N(B long vector(vect_ptr_regx $B$H(B vect_ptr_regy) $B$N%Y%/%?%5%$%:$rHf3S$9$k(B
<Examples>
  klb_compare
<Test>
<Explanation>
<ETC>
  $B%^%/%mL>$r(B f_IfLongVectSizeEQ $B$+$i(B f_IfLongVectSizeEqual $B$KJQ99(B(1989.11.1)
********************************************************************* PSL **/
#DATA_define D_WorkVectXSize    XXX
#DATA_define D_WorkVectYSize    XXX

#CTRL_define f_IfLongVectSizeEqual(vect_ptr_regx, vect_ptr_regy)
{
  $USE(D_WorkVectXSize); 
  $USE(D_WorkVectYSize);
    
  s_GetSizeLongVect(vect_ptr_regx, D_WorkVectXSize);
  s_GetSizeLongVect(vect_ptr_regy, D_WorkVectYSize);
  p_Compare(D_WorkVectXSize, D_WorkVectYSize);

  $RELEASE(D_WorkVectXSize); 
  $RELEASE(D_WorkVectYSize);

  p_IfEQ()
}

#CTRL_define f_IfLongVectSizeNotEqual(vect_ptr_regx, vect_ptr_regy)
{
  $USE(D_WorkVectXSize); 
  $USE(D_WorkVectYSize);
    
  s_GetSizeLongVect(vect_ptr_regx, D_WorkVectXSize);
  s_GetSizeLongVect(vect_ptr_regy, D_WorkVectYSize);
  p_Compare(D_WorkVectXSize, D_WorkVectYSize);

  $RELEASE(D_WorkVectXSize); 
  $RELEASE(D_WorkVectYSize);

  p_IfNE()
}

/******************************************************************** PSL **

       written by imai@icot22      on Tue Sep 10 16:47:14 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define f_GetVectElementWithDeref(vect_ptr,elem_pos,dst_vect_elm)
{
  $USE(D_WorkOffset);
  b_ExchangeElmposToOffset(elem_pos, D_WorkOffset);
  s_ReadWithRegOffsetMRBor( vect_ptr, D_WorkOffset, dst_vect_elm );
  f_DerefElementReg(vect_ptr, D_WorkOffset, dst_vect_elm);
  $RELEASE(D_WorkOffset);
}
