
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_reduce_string_ope.psl.c
   ----- CREATED   : by f-hataza@icot22, on Wed May 16 14:42:03 1990
   ----- LAST SAVED: by kawai@icot22, on Thu Dec  5 15:52:01 1991
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : FUNCTIONS
   ----- ABSTRACT  : $B%9%H%j%s%04XO"%^%/%m(B

  VPIM $B$K$*$1$k%9%H%j%s%0$N%G!<%?9=B$$K$D$$$F$O!"(Bstr_string.psl.c $B$K5-=R$9$k!#(B

  $B$3$N%U%!%$%kFb$N%^%/%m$O%9%H%j%s%0$KBP$9$k0J2<$NA`:n$rDj5A$7$F$$$k!#(B
    1. $B%9%H%j%s%0$N3d$jIU$1(B
    2. $B%9%H%j%s%0MWAG$N=i4|2=(B
    3. $B%9%H%j%s%0$N%3%T!<(B
    4. $B%9%H%j%s%0$NHf3S(B
    5. $B%9%H%j%s%0$N%O%C%7%eCM7W;;(B
    6. $BItJ,%9%H%j%s%0$N%3%T!<(B
    7. $B%9%H%j%s%0MWAG$N%5!<%A(B
    8. $B%9%H%j%s%0$NMWAG$4$H$N1i;;(B
    9. $B%9%H%j%s%0$NMWAG%5%$%:$NJQ99(B
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
  1. $B%9%H%j%s%0$N3d$jIU$1(B

       written by f-hataza@icot21      on Tue Sep  5 14:11:37 1989

<Arguments>
  dst_reg :         $B3d$jIU$1$?%9%H%j%s%0$X$N%]%$%s%?$r3JG<$9$k%l%8%9%?(B
  strg_length_reg : $B%9%H%j%s%0MWAG?t(B($B%l%8%9%?(B)
  elem_size_reg :   $B%9%H%j%s%0MWAG%5%$%:(B($B%l%8%9%?(B)

<Temporally Used Variables>
  D_WorkDesc :      $B%9%H%j%s%0$N%G%#%9%/%j%W%?(B(defined in str_string.psl.c)
<Level> functions
<PreCondition>
<Function>
  $BMWAG?t(B strg_length_reg$B!"MWAG%5%$%:(B elem_size_reg $B$N%9%H%j%s%0$r!"(B
  $BE,Ev$J%U%j!<%j%9%H$+$i3d$jIU$1!"(Bdst_reg $B$K!"%]%$%s%?$r=q$-9~$`(B (MRB off)$B!#(B
  $B!&%R!<%WNN0h$,ITB-$7$?;~$O!"(Bdst_reg $B$K(B D_NULL $B$rJV$9!#(B
<Examples>
<Test>
<Explanation>
<ETC>
  MRB on $B$N%9%H%j%s%0$N3d$jIU$1$O9M$($J$$!#(B
********************************************************************* PSL **/

#PSL_define f_AllocString(dst_reg, strg_length_reg, elem_size_reg)
{
  $USE(D_WorkDesc);
  s_SetStringDescOnReg(strg_length_reg, elem_size_reg, D_WorkDesc);
  $CALL( s_AllocStrgMRBoffWithDesc_Sub(dst_reg, D_WorkDesc) );
  $RELEASE(D_WorkDesc);
}

/******************************************************************** PSL **
  2. $B%9%H%j%s%0MWAG$N=i4|2=(B
     f_InitializeString init_word string

       written by f-hataza@icot21      on Wed Sep  6 09:56:41 1989

<Arguments>
  init_word_reg :   $B=i4|2=%G!<%?(B($B%l%8%9%?(B)
  string_ptr :      $B%9%H%j%s%0$X$N%]%$%s%?(B($B%l%8%9%?(B)

<Temporally Used Variables>
  D_WorkStrgSize :  $B%9%H%j%s%0$NMWAG$N%o!<%I?t(B($B%G%#%9%/%j%W%?4^$^$:(B)
                    $B%+%&%s%?$H$7$F;HMQ(B(defined in str_string.psl.c)
<Level> functions
<PreCondition>
<Function>
  $B!&(Bstring_ptr $B$N;X$9%9%H%j%s%0$NMWAGIt$N3F%o!<%I$r!"(B
   init_word_reg $B$G=i4|2=$9$k!#(B
    ($BCm0U(B:: $B$3$N%^%/%m$G$O!"MWAGKh$G$O$J$/!"%o!<%IKh$K=i4|2=$9$k(B)

<Examples>
  kblt_b_new_string()
<Test>
<Explanation>
<ETC>
  $B!&(Bf_GetNewString $B$O:o=|$7!"(Bf_AllocString $B$r8F$s$@8e!"(B
  $B$3$N%^%/%m$K$h$j%9%H%j%s%0$r=i4|2=$9$k!#(B(1989.10.05 f-hataza)
********************************************************************* PSL **/

#PSL_define f_InitializeString (init_word_reg, string_ptr)
{
  $USE(D_WorkStrgSize);
  s_GetStringSize(string_ptr, D_WorkStrgSize);

  b_DecrementReg(D_WorkStrgSize);
  LOOP(){                            /* for(i=size-1; i>=0; i--) */
    b_IfLess(D_WorkStrgSize, D_NULL) { break;}
    s_PutStringWordPosReg(string_ptr, D_WorkStrgSize, init_word_reg);
    b_DecrementReg(D_WorkStrgSize);
  }
  $RELEASE(D_WorkStrgSize);
}

/******************************************************************** PSL **
  3. $B%9%H%j%s%0$N%3%T!<(B
     f_CopyStringMRB source destination

       written by f-hataza@icot21      on Wed Sep  6 10:59:38 1989

<Arguments>
 src_string_ptr: $B%9%H%j%s%0$N%3%T!<$N%=!<%9(B ($B%l%8%9%?(B)
 dst_string_ptr: $B%9%H%j%s%0$N%3%T!<$N%G%9%A%M!<%7%g%s(B ($B%l%8%9%?(B)
<Temporally Used Variables>
<Level> functions
<PreCondition>
<Function>
  $B!&(B src_string_ptr$B$N(BMRB$B$,(B o $B$J$i$P(Bsrc_string_ptr$B$r(Bdestination$B$K%3%T!<(B
  $B!&(B src_string_ptr$B$N(BMRB$B$,(B x $B$J$i$P(Bsrc_string_ptr$B$N;X$9%9%H%j%s%0$r(B
                                               destination$B$N@h$K%3%T!<(B
  $B!&%R!<%WNN0h$,ITB-$7$?;~$O!"(Bdst_string_ptr $B$K(B D_NULL $B$rJV$9!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define f_CopyStringMRB(src_string_ptr, dst_string_ptr)
{
  s_IfMRBoff(src_string_ptr) {
    p_MoveWord(src_string_ptr, dst_string_ptr);
  } else {
    $USE(D_WorkDesc);
    s_GetStringDesc(src_string_ptr, D_WorkDesc);
    $CALL( s_AllocStrgMRBoffWithDesc_Sub(dst_string_ptr, D_WorkDesc) );
    $RELEASE(D_WorkDesc);
    b_IfWordNotEq(dst_string_ptr, D_NULL) {
      $CALL(s_CopyWordString_Sub(src_string_ptr, dst_string_ptr));
    }
  }
}

/******************************************************************** PSL **
  4. $B%9%H%j%s%0$NHf3S(B
     f_IfStringEqual string1 string2
     f_IfStringNotEqual string1 string2
     f_StringLessThan_Sub(A_String1, A_String2, A_Result)

       written by f-hataza@icot21      on Mon Sep 11 16:15:11 1989
<Arguments>
  string1 : $B%9%H%j%s%0$r;X$9%]%$%s%?(B($B%l%8%9%?(B)
  string2 : $B%9%H%j%s%0$r;X$9%]%$%s%?(B($B%l%8%9%?(B)
<Temporally Used Variables>
<Level> functions
<PreCondition>
  string1, string2 $B$O%G%l%U!"%?%$%W%A%'%C%/:Q$_!#(B
<Function>
  string1, string2 $B$N;X$9%9%H%j%s%0$NK\BN$rHf3S$9$k!#(B
  $B:G=*%o!<%I$NL$;HMQNN0h$O!"(B0$B$,F~$C$F$$$k$N$G!"%o!<%IKh$NHf3S$r9T$J$&!#(B
  f_StringLessThan_Sub$B$N(BA_Result$B$K$O(B
    _STRING_COMPARE_RESULT_SUCCESS
    _STRING_COMPARE_RESULT_FAIL
$B$N$$$:$l$+$NCM$,JV$k!#(B
<Examples>
<Test>
<Explanation>
  Equal $B$N%^%/%m$b(B NotEqual $B$N%^%/%m$b!"FbMF$OF1$8$G$"$k!#(B($B:G8e$N(B1$B9T$@$10c$&(B)
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkString1      XXX
#DATA_define D_WorkString2      XXX

#CONST_define	_STRING_EQUAL		_ONE
#CONST_define	_STRING_DIFF		_ZERO

#CTRL_define f_IfStringEqual(string1, string2)
{
  @DEBUG{
    s_IfNotStrings(string1) {VPIM_ERROR("f_IfStringEqual", "Illegal Type"); }
    s_IfNotStrings(string2) {VPIM_ERROR("f_IfStringEqual", "Illegal Type"); }
  };
  $USE(D_Workreg);
  $CALL( f_CompareString_Sub (string1, string2, D_Workreg) );
  p_CompareImmediate (D_Workreg, _STRING_EQUAL);
  $RELEASE(D_Workreg);
  p_IfEQ()
}

#CTRL_define f_IfStringNotEqual(string1, string2)
{
  @DEBUG{
    s_IfNotStrings(string1) {VPIM_ERROR("f_IfStringEqual", "Illegal Type"); }
    s_IfNotStrings(string2) {VPIM_ERROR("f_IfStringEqual", "Illegal Type"); }
  };
  $USE(D_Workreg);
  $CALL( f_CompareString_Sub (string1, string2, D_Workreg) );
  p_CompareImmediate (D_Workreg, _STRING_EQUAL);
  $RELEASE(D_Workreg);
  p_IfNE()
}

#SUBARG_define	A_String1	SRC
#SUBARG_define	A_String2	SRC
#SUBARG_define	A_Result	DST	/* value=1 for equal, =0 for not eq */

#SUBROUTINE f_CompareString_Sub(A_String1, A_String2, A_Result)
{
  /* pointer check */
  b_IfEqual(A_String1, A_String2) {
    b_SetImmValueDNTC(_STRING_EQUAL, A_Result);
    $RETURN();
  }

  /* type and word size check */
  $USE(D_WorkString1); $USE(D_WorkString2);
  s_GetStringDesc(A_String1, D_WorkString1);     /* read descriptor */
  s_GetStringDesc(A_String2, D_WorkString2);

  b_IfEqual(D_WorkString1, D_WorkString2) {
    $USE(D_WorkStrgSize);
    s_GetStringSizeWithDesc(D_WorkString1, D_WorkStrgSize);

        /* each word check */
    b_DecrementReg(D_WorkStrgSize);
    LOOP() {
      b_IfLess(D_WorkStrgSize, D_NULL) {        /* string equal */
	b_SetImmValueDNTC(_STRING_EQUAL, A_Result);
        break;	 /* set result */
      }
      s_GetStringWordPosReg(A_String1, D_WorkStrgSize, D_WorkString1);
      s_GetStringWordPosReg(A_String2, D_WorkStrgSize, D_WorkString2);
      b_IfNotEqual(D_WorkString1, D_WorkString2) { /* string not equal */
	b_SetImmValueDNTC(_STRING_DIFF, A_Result);
        break;/* set result */
      }
      b_DecrementReg(D_WorkStrgSize);
    } /* end of LOOP */
    $RELEASE(D_WorkStrgSize);
  } else {                                         /* different string type */
    b_SetImmValueDNTC(_STRING_DIFF, A_Result); /* set result */
  } /* end of b_IfEqual */

  $RELEASE(D_WorkString1);$RELEASE(D_WorkString2);
  $RETURN();
}


#CONST_define  _STRING_COMPARE_RESULT_SUCCESS  _ZERO
#CONST_define  _STRING_COMPARE_RESULT_FAIL     _ONE

#SUBARG_define  A_String1   SRC
#SUBARG_define  A_String2   SRC
#SUBARG_define  A_Result    DST

#SUBROUTINE  f_StringLessThan_Sub(A_String1, A_String2, A_Result)
{
  s_WhichIsLessString(A_String1, A_String2, A_Result);
  b_IfEqualImm(A_Result, _ARG_STR_NO1)
    {
      p_SetImmediateValue(_STRING_COMPARE_RESULT_SUCCESS, A_Result);      
    }
  else
    {
      p_SetImmediateValue(_STRING_COMPARE_RESULT_FAIL, A_Result);      
    }

  $RETURN();
}


/******************************************************************** PSL **
  5. $B%9%H%j%s%0$N%O%C%7%eCM7W;;(B

       written by f-hataza@icot22      on Wed May 16 15:27:01 1990
<Arguments>
    src_reg :  $B%9%H%j%s%0$X$N%]%$%s%?(B
    hash_reg : $B%O%C%7%eCM$r3JG<$9$k%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    $BAH9~=R8l(B hash/3 $B$N$?$a$K!"%9%H%j%s%0$N%O%C%7%eCM$r7W;;$9$k!#(B
<Examples>
<Test>
<Explanation>
    $B%9%H%j%s%0K\BN$,(B3$B%o!<%I0J>e$N;~(B: $B:G=i$N(B1$B%o!<%I$H:G8e$h$j0l$DA0$N%o!<%I$N(B
                                     $BGSB>E*O@M}OB(B
    $B%9%H%j%s%0K\BN$,(B2$B%o!<%I$N;~(B:     $B:G=i$N(B1$B%o!<%I(B
    $B%9%H%j%s%0K\BN$,(B1$B%o!<%I$N;~(B:     $B:G=i$N(B1$BMWAG(B
    $B%9%H%j%s%0K\BN$,(B0$B%o!<%I$N;~(B:     0
<ETC>
********************************************************************* PSL **/

/* #DATA_define D_WorkStringSize  XXX   defined in klb_debug.psl.c */
#DATA_define D_WorkLength       XXX
#DATA_define D_WorkElemSize	XXX
#DATA_define D_WorkHash  XXX

#PSL_define f_GetStringHashValue (src_reg, hash_reg)
{
  $USE (D_WorkStringSize);
  s_GetStringSize (src_reg, D_WorkStringSize);
  b_IfGreater(D_WorkStringSize, D_ONE) {
      /* 2$B%o!<%I0J>e$N;~(B */
    s_GetStringWordPosReg (src_reg, D_NULL, hash_reg);
    b_IfGreaterImm (D_WorkStringSize, _TWO) {
      b_SubtractImmediateWithDNTC(D_WorkStringSize, _TWO, D_WorkStringSize);
      $USE (D_WorkHash);
      s_GetStringWordPosReg (src_reg, D_WorkStringSize,
			     D_WorkHash);
      b_BitwiseEorWithDNTC(hash_reg, D_WorkHash, hash_reg);
      $RELEASE (D_WorkHash);
    }
  } else {
    $USE(D_WorkLength); $USE(D_WorkElemSize);
    s_GetStringType(src_reg,D_WorkLength,D_WorkElemSize);
    b_IfGreater(D_WorkLength,D_NULL) {
      s_GetStringElementPosReg(src_reg,D_NULL,D_WorkElemSize,hash_reg);
    } else {
      b_MoveWithImmTypeMRBoff (D_NULL, INT, hash_reg);
    }
    $RELEASE(D_WorkLength); $RELEASE(D_WorkElemSize);
  }
  $RELEASE (D_WorkStringSize);
}

/******************************************************************** PSL **
  6. $BItJ,%9%H%j%s%0$N%3%T!<(B (8$B%S%C%H%9%H%j%s%0$N%o!<%IC10L%3%T!<(B)
     f_CopyByteSubStringByWord(string1,string2,pos_reg,len_reg,unuse_reg)

       written by f-hataza@icot22      on Thu Nov 15 16:33:08 1990
<Arguments>
    string1:    $B%3%T!<85$N%9%H%j%s%0$X$N%]%$%s%?$r;}$D%l%8%9%?(B
    string2:    $B%3%T!<@h$N%9%H%j%s%0$X$N%]%$%s%?$r;}$D%l%8%9%?(B
    pos_reg:    $B%3%T!<3+;OMWAGHV9f$r;}$D%l%8%9%?(B
    len_reg:    $B%3%T!<$9$kMWAG?t$r;}$D%l%8%9%?(B
    unuse_reg:  $B%3%T!<7k2L$NBh(B1$B%o!<%ICf$NL58zMWAG?t(B
<Temporally Used Variables>
<Level>
<PreCondition>
  string1, string2 $B$O!"(B8$B%S%C%H%9%H%j%s%0$K8BDj$9$k!#(B
  string1, string2 $B$K$D$$$F$N!"MWAG%5%$%:!"MWAGD9$J$I$N%A%'%C%/$O:Q$s$G$$$k(B
  $B$b$N$H$9$k!#(B
<Function>
  string1 $B$N(B pos_reg$BHVL\$r4^$`%o!<%I$+$i(Blen_reg$B8D$NMWAG$r4^$`%o!<%I$r(B
  $B%o!<%IC10L$G%3%T!<$9$k!#$3$N$H$-!":G=i$N(B1$B%o!<%I$NFb!"(Bpos_reg$BHVL\$^$G$N(B
  $BL58z$JMWAG$N?t$r(Bunuse_reg$B$K=PNO$9$k!#(B
<Examples>
<Test>
<Explanation>
    string1 $B$,<!$N$h$&$J%9%H%j%s%0$G!"(Bpos_reg=5, len_reg=6 $B$N$H$-!"(B
    string2 $B$O:8$N$h$&$K@_Dj$5$l!"(Bunuse_reg=1 $B$G$"$k!#(B

    string1                    ====>   string2
    +-----+----------------+           +-----+----------------+
    |CDESC|                |           |CDESC|                |
    +-----+----------------+           +-----+----------------+
    |     | -   -   -   -  |           |     | -   A   B   C  |
    +-----+----------------+           +-----+----------------+
    |     | -   A   B   C  |           |     | D   E   F   -  |
    +-----+----------------+           +-----+----------------+
    |     | D   E   F   -  |
    +-----+----------------+
    |     | -   -   -   -  |
    +-----+----------------+

<ETC>
    $BF2A0;a$NMW@A$K$h$j:n@.$7$?!#(B(1990.11.15, f-hataza)
********************************************************************* PSL **/
#DATA_define D_WorkPosInWord1     XXX
#DATA_define D_WorkPosInWord2     XXX
#DATA_define D_WorkEndPosInWord   XXX

#PSL_define f_CopyByteSubStringByWord
                 (string1,string2,pos_reg,len_reg,unuse_reg)
{
  b_IfEqual(len_reg,D_NULL) {
    b_MoveWithImmTypeMRBoff(D_NULL,INT,unuse_reg);
  } else {

      /* $B%3%T!<HO0O$r5a$a$k(B */
    $USE(D_WorkPosInWord1);$USE(D_WorkEndPosInWord);
    b_DivideImmediateWithDNTC(pos_reg, _NUM_OF_ELEM_STRG8, D_WorkPosInWord1);
    b_AddWithDNTC(pos_reg, len_reg, D_WorkEndPosInWord);
    b_DecrementReg(D_WorkEndPosInWord);
    b_DivideImmediateWithDNTC(D_WorkEndPosInWord, _NUM_OF_ELEM_STRG8,
			                                 D_WorkEndPosInWord);

      /* $B;O$a$N%o!<%I$NL58zMWAG?t$r5a$a$k(B */
    b_ModuloImmediateWithTag(pos_reg, _NUM_OF_ELEM_STRG8, unuse_reg);

      /* $B%3%T!<%k!<%A%s$NK\BN(B */
    $USE(D_WorkPosInWord2);$USE(D_WorkStringWord);
    p_MoveValue(D_NULL,D_WorkPosInWord2);
    LOOP() {
/*      s_GetStringWordPosReg(string1,D_WorkPosInWord1,D_WorkStringWord);
      s_PutStringWordPosReg(string2,D_WorkPosInWord2,D_WorkStringWord);
*/
	$USE(D_WorkElemAddr);
	s_GetStructElemAddrPosReg(string1, D_WorkPosInWord1, D_WorkElemAddr);
	b_IncrementAddrReg(D_WorkElemAddr);      /* $B%G%#%9%/%j%W%?$NJ,(B */
	s_ReadWithMRBor(D_WorkElemAddr, D_WorkStringWord);
	s_GetStructElemAddrPosReg(string2, D_WorkPosInWord2, D_WorkElemAddr);
	b_IncrementAddrReg(D_WorkElemAddr);      /* $B%G%#%9%/%j%W%?$NJ,(B */
	p_Write(D_WorkStringWord, D_WorkElemAddr);
	$RELEASE(D_WorkElemAddr);
	b_IfEqual(D_WorkPosInWord1,D_WorkEndPosInWord) {break;}
	b_IncrementReg(D_WorkPosInWord1);
	b_IncrementReg(D_WorkPosInWord2);
    }
    $RELEASE(D_WorkPosInWord1);$RELEASE(D_WorkEndPosInWord);
    $RELEASE(D_WorkPosInWord2);$RELEASE(D_WorkStringWord);
  }
}

/******************************************************************** PSL **
  7. $B%9%H%j%s%0MWAG$N%5!<%A(B
     f_SearchCharacter(string, start_pos, end_pos, target,
			                               table_mask, found_pos)
     f_SearchCharBackward_Sub(A_String, A_StartPos, A_EndPos, 
		 		        A_Target, A_TableMask, A_FoundPos)

       written by kawai@icot22      on Wed Jul 17 14:24:21 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
 $B0z?t(Btable_mask$B$N%?%0$,(B ATOM $B$N;~(B:
  $B%9%H%j%s%0(B(string)$B$N8!:w3+;OMWAG0LCV(B(start_pos)$B$+$i8!:w=*N;MWAG0LCV(B(end_pos)
  $B$NHO0O$G8!:wBP>]J8;z(B(target)$B$rC5$7!":G=i$K8+$D$+$C$?MWAG0LCV$rH/8+MWAG0LCV(B
  (found_pos)$B$KJV$9!#(B
 $B0z?t(Btable_mask$B$N%?%0$,(B INT $B$N;~(B:
  $B%9%H%j%s%0(B(string)$B$N8!:w3+;OMWAG0LCV(B(start_pos)$B$+$i8!:w=*N;MWAG0LCV(B(end_pos)
  $B$NHO0O$N3FMWAG$NCM$G8!:wMQ%F!<%V%k(B(target)$B$r0z$-(B($B3FMWAG$NCM$r8!:wMQ%F!<%V%k(B
  $B$NMWAG0LCV$H$7$F$=$NCM$r<h$j=P$7(B)$B!"$=$NCM$H8!:wMQ%^%9%/(B(table_mask)$B$H$N(BAND$B$r(B
  $B$H$C$?7k2L$,(B 0 $B$G$J$$$b$N$r8!:w$7!":G=i$K8+$D$+$C$?MWAG0LCV$rH/8+MWAG0LCV(B
  (found_pos)$B$KJV$9!#(B

  $B8!:w3+;OMWAG0LCV(B(start_pos) < $B8!:w=*N;MWAG0LCV(B(end_pso)$B$N>l9g$K$O%9%H%j%s%0(B
(string)$B$NKvHx$+$i8!:w$9$k!#(B
  $B$^$?!";XDj$5$l$?HO0OFb$G8!:wBP>]J8;z$,8+$D$+$i$J$+$C$?>l9g$K$O!"H/8+MWAG0LCV(B
(found_pos)$B$K(B -1 $B$rJV$9!#(B

 $BCm0U(B:
   $B0z?t(Btarget$B$K$O!"(B
     $B0z?t(Btable_mask$B$N%?%0$,(B ATOM $B$N;~(B : $B8!:wBP>]J8;z%3!<%I(B
     $B0z?t(Btable_mask$B$N%?%0$,(B INT $B$N;~(B : $BJ8;z8!:wMQ%F!<%V%k(B(8$B%S%C%H%9%H%j%s%0(B)
   $B$,$/$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define  f_SearchCharacter(string, start_pos, end_pos, target,
			                               table_mask, found_pos)
{
  b_IfLessEq(start_pos, end_pos)
    { /* $B=gJ}8~%5!<%A(B */
      $CALL( f_SearchCharForward_Sub(string, start_pos, end_pos,
				          target, table_mask, found_pos) );
    }
  else
    { /* $B5UJ}8~%5!<%A(B */
      $CALL( f_SearchCharBackward_Sub(string, end_pos, start_pos,
				          target, table_mask, found_pos) );
    }
}

/******************************************************************** PSL **
     f_SearchCharForward_Sub(A_String, A_StartPos, A_EndPos, 
	 		               A_Target, A_TableMask, A_FoundPos)

       written by kawai@icot22      on Wed Sep 11 15:31:46 1991
<Arguments>
 A_String : $B%5!<%ABP>]%9%H%j%s%0(B
 A_StartPos : $B%5!<%A3+;OMWAG0LCV(B
 A_EndPos : $B%5!<%A=*N;MWAG0LCV(B
 A_Target : $B%5!<%ABP>]J8;z%3!<%I(B/$B%5!<%AMQ%F!<%V%k(B(8$B%S%C%H%9%H%j%s%0(B)
 A_TableMask : $B%F!<%V%k%5!<%AMQ%^%9%/(B(Tag=ATOM/INT)
 A_FoundPos : $BH/8+$7$?MWAG0LCV(B($B=PNO(B)
<Temporally Used Variables>
 D_WorkStrLength : $B%9%H%j%s%0$NA4D9(B
 D_WorkStrElmSize : $B%9%H%j%s%0$NMWAG%5%$%:(B
 D_WorkElmsCntInWord : 1$B%9%H%j%s%0%o!<%ICf$NMWAG?t(B
 D_WorkElmMask : $B%9%H%j%s%0%o!<%I$+$i(B1$BMWAG<h$j=P$9$?$a$N%^%9%/(B
 D_WorkStrSearchFirstWordPos : $B%5!<%AHO0O$N:G=i$N%9%H%j%s%0%o!<%I0LCV(B
 D_WorkSkipElmsCntInFirstWord : $B%5!<%AHO0O$N:G=i$N%9%H%j%s%0%o!<%ICf$G%5!<%A(B
                                $BHO0O$KF~$i$J$$MWAG$N?t(B
 D_WorkStrSearchLastWordPos : $B%5!<%AHO0O$N:G8e$N%9%H%j%s%0%o!<%I0LCV(B
 D_WorkElmsCntInLastWord : $B%5!<%AHO0O$N:G8e$N%9%H%j%s%0%o!<%ICf$G%5!<%AHO0O$K(B
                           $BF~$kMWAG$N?t(B
 D_WorkFoundPosInWord : $BH/8+$7$?MWAG0LCV(B
 D_WorkSearchElmsCntInWord : $B%9%H%j%s%0%o!<%ICf$G%5!<%AHO0O$KF~$kMWAG$N?t(B
 D_WorkStrSearchTargetWord : $B%5!<%ABP>]$N%9%H%j%s%0%o!<%I(B
<Level>
<PreCondition>
<Function>
  $B%9%H%j%s%0Cf$r=gJ}8~(B($BMWAG0LCV(B $B>.(B -> $BBg(B)$B$KJ8;z8!:w$9$k!#(B
<Examples>
<Test>
<Explanation>
  $B=hM}J}<0$O4pK\E*$K0J2<$N$h$&$K$J$C$F$$$k!#(B
   1. $B=gJ}8~%5!<%A$+5UJ}8~%5!<%A$+$r7h$a$k!#(B
   2. $B%5!<%AHO0O$,4^$^$l$k%9%H%j%s%0%o!<%I$N@hF,$HKvHx$r5a$a$k!#(B
   3. $B%5!<%AHO0O$N@hF,%o!<%ICf$G%9%-%C%W$9$kMWAG?t$r5a$a$k!#(B
   4. $B%5!<%AHO0O$NKvHx%o!<%ICf$N%5!<%ABP>]MWAG?t$r5a$a$k!#(B
   5. $B%5!<%AHO0O$N@hF,%o!<%I$+$iKvHx%o!<%I$^$G!"(B1$B%o!<%I$E$D8!:wBP>]J8;z$rC5$9!#(B
   6. $BH/8+MWAG0LCV$rJV$9!#(B

 [$BNc(B] 8$B%S%C%H%9%H%j%s%0(B("abcd...xyz")$B$NBh(B10$BMWAG(B(k)$B$+$iBh(B18$BMWAG(B(s)$B$^$G$,(B
      $B%5!<%AHO0O$N>l9g$O!"0J2<$N$h$&$JCM$,%o!<%/%l%8%9%?$K@_Dj$5$l$k!#(B

                               +-------------------------------+
                               |   $B%9%H%j%s%0%G%#%9%/%j%W%?(B    |
                               +-------+-------+-------+-------+
                               |   a   |   b   |   c   |   d   |  0
                               +-------+-------+-------+-------+
                              $B!A(B                              $B!A(B
            D_WorkSkipElmsCntInFirstWord(=2) ->|
                               +-------+-------+-------+-------+
D_WorkStrSearchFirstWordPos -> |   i   |   j   |   k   |   l   |  2
                               +-------+-------+-------+-------+
                               |   m   |   n   |   o   |   p   |  3
                               +-------+-------+-------+-------+
D_WorkStrSearchLastWordPos  -> |   q   |   r   |   s   |   t   |  4
                               +-------+-------+-------+-------+
                         D_WorkElmsCntInLastWord(=3) ->|
                              $B!A(B                              $B!A(B
                               +-------+-------+-------+-------+
                               |   y   |   z   |   -   |   -   |  6
                               +-------+-------+-------+-------+
                                   0       1       2       3

<ETC>
********************************************************************* PSL **/

#DATA_define  D_WorkStrLength   XXX
#DATA_define  D_WorkStrElmSize  XXX
#DATA_define  D_WorkElmsCntInWord   XXX
#DATA_define  D_WorkElmMask   XXX
#DATA_define  D_WorkStrSearchFirstWordPos   XXX
#DATA_define  D_WorkSkipElmsCntInFirstWord   XXX
#DATA_define  D_WorkStrSearchLastWordPos   XXX
#DATA_define  D_WorkElmsCntInLastWord   XXX
#DATA_define  D_WorkFoundPosInWord   XXX
#DATA_define  D_WorkSearchElmsCntInWord   XXX
#DATA_define  D_WorkStrSearchTargetWord   XXX

#SUBARG_define  A_String    SRC
#SUBARG_define  A_StartPos  SRC
#SUBARG_define  A_EndPos    SRC
#SUBARG_define  A_Target  SRC
#SUBARG_define  A_TableMask  SRC
#SUBARG_define  A_FoundPos  DST

#SUBROUTINE  f_SearchCharForward_Sub(A_String, A_StartPos, A_EndPos, 
		 		           A_Target, A_TableMask, A_FoundPos)
{
  $USE(D_WorkStrLength);
  $USE(D_WorkStrElmSize);
  /* $B%9%H%j%s%0$NA4D9$HMWAG%5%$%:$rF@$k(B */
  s_GetStringType(A_String, D_WorkStrLength, D_WorkStrElmSize);
  $USE(D_WorkElmsCntInWord);
  $USE(D_WorkElmMask);
  /* 1$B%9%H%j%s%0%o!<%ICf$NMWAG?t$H<h$j=P$7$N$?$a$N%^%9%/%Q%?%s$rF@$k(B */
  s_GetElmCountInWordAndMask(D_WorkStrElmSize, D_WorkElmsCntInWord,
			                                 D_WorkElmMask);
  $USE(D_WorkStrSearchFirstWordPos);
  $USE(D_WorkSkipElmsCntInFirstWord);
  $USE(D_WorkStrSearchLastWordPos);
  $USE(D_WorkElmsCntInLastWord);
  /* $B%9%H%j%s%0Cf$N%5!<%AHO0O$r7h$a$k(B */
  s_DecideSearchRegion(A_StartPos, A_EndPos, D_WorkElmsCntInWord,
		       D_WorkStrSearchFirstWordPos,
		       D_WorkSkipElmsCntInFirstWord,
		       D_WorkStrSearchLastWordPos, D_WorkElmsCntInLastWord);

  @DEBUG{
    b_IfGreater(D_WorkStrSearchLastWordPos, D_WorkStrLength)
      {
	VPIM_ERROR("f_SearchCharForward_Sub","SearchRegion Overflow !!");
      }
  };
  $RELEASE(D_WorkStrLength);

  $USE(D_WorkStrSearchTargetWord);
  $USE(D_WorkSearchElmsCntInWord);
  $USE(D_WorkFoundPosInWord);
  p_SetImmediateValue(_CHARACTER_NOT_FOUND, D_WorkFoundPosInWord);
  LOOP()
    { 
      b_IfNotEqualImm(D_WorkFoundPosInWord, _CHARACTER_NOT_FOUND)
	{ /* $BC5$7$F$$$k(B Char $B$,8+$D$+$C$?$i!"(BPosition $B$r%;%C%H$7$FH4$1$k(B */
	  b_DecrementReg(D_WorkStrSearchFirstWordPos);
	  b_MultiplyWithDNTC(D_WorkStrSearchFirstWordPos, D_WorkElmsCntInWord,
		                                                 A_FoundPos);
	  b_AddWithDNTC(A_FoundPos, D_WorkFoundPosInWord, A_FoundPos);
	  b_SetImmTypeMRBoff(INT, A_FoundPos);
	  break;
	}
      
      b_IfGreater(D_WorkStrSearchFirstWordPos, D_WorkStrSearchLastWordPos)
	{ /* $BA4C5:wHO0O$rC5$7$F8+$D$+$i$J$1$l$P!"(BPosition = -1 $B$H$7$FH4$1$k(B */
	  b_SetImmTypeValueMRBoff(INT, _CHARACTER_NOT_FOUND, A_FoundPos);
	  break;
	}

      b_IfEqual(D_WorkStrSearchFirstWordPos, D_WorkStrSearchLastWordPos)
	{ /* $BC5:wHO0O$N:G=*%o!<%I$@$C$?$i!"$=$N%o!<%IFb$NC5:w%(%l%a%s%H?t$r(B
	     $B%;%C%H$9$k(B */
	  p_MoveValue(D_WorkElmsCntInLastWord, D_WorkSearchElmsCntInWord);
	}
      else
	{ /* $BC5:wHO0O$N:G=*%o!<%I$G$J$1$l$P!"%o!<%IFb$N%(%l%a%s%H?t$r(B
	     $B%;%C%H$9$k(B */
	  p_MoveValue(D_WorkElmsCntInWord, D_WorkSearchElmsCntInWord);
	}

      /* $B%5!<%AHO0OFb$N(B1$B%9%H%j%s%0%o!<%I$rFI$_9~$`(B */
      s_GetStringWordPosReg(A_String, D_WorkStrSearchFirstWordPos,
			                          D_WorkStrSearchTargetWord);

      s_IfATOM(A_TableMask)
	{ /* A_TableMask$B$N%?%0$,(BATOM$B$J$i!"(B1$B%9%H%j%s%0%o!<%ICf$GDL>o$NJ8;z(B
             $B%5!<%A$r9T$&(B */
	  s_SearchCharForwardInWord(D_WorkStrSearchTargetWord, A_Target, 
				    D_WorkStrElmSize, D_WorkElmsCntInWord,
				    D_WorkSkipElmsCntInFirstWord,
				    D_WorkSearchElmsCntInWord,
				    D_WorkElmMask, D_WorkFoundPosInWord);
	}
      else
	{ /* A_TableMask$B$N%?%0$,(BINT$B$J$i!"(B1$B%9%H%j%s%0%o!<%ICf$G%F!<%V%k$r(B
	     $BMQ$$$?%5!<%A$r9T$&(B */
	  s_SearchCharForwardInWordWithTable(D_WorkStrSearchTargetWord,
					     A_Target, A_TableMask,
					     D_WorkStrElmSize,
					     D_WorkElmsCntInWord,
					     D_WorkSkipElmsCntInFirstWord,
					     D_WorkSearchElmsCntInWord,
					     D_WorkElmMask,
					     D_WorkFoundPosInWord);
	}

      /* $B%5!<%AHO0O$N%9%H%j%s%0%o!<%I$r(B1$B?J$a$k(B */
      b_IncrementReg(D_WorkStrSearchFirstWordPos);

      /* $B%5!<%AHO0O$N:G=i$N%9%H%j%s%0%o!<%I0J30$G$O!"%9%-%C%W$9$kMWAG?t$O(B
         $B>o$K(B0$B$NH&(B */
      p_MoveValue(D_NULL, D_WorkSkipElmsCntInFirstWord);
    }

  $RELEASE(D_WorkFoundPosInWord);
  $RELEASE(D_WorkSearchElmsCntInWord);
  $RELEASE(D_WorkStrSearchTargetWord);
  $RELEASE(D_WorkStrSearchFirstWordPos);
  $RELEASE(D_WorkSkipElmsCntInFirstWord);
  $RELEASE(D_WorkStrSearchLastWordPos);
  $RELEASE(D_WorkElmsCntInLastWord);
  $RELEASE(D_WorkStrElmSize);
  $RELEASE(D_WorkElmsCntInWord);
  $RELEASE(D_WorkElmMask);

  $RETURN();
}

/******************************************************************** PSL **
     f_SearchCharBackward_Sub(A_String, A_StartPos, A_EndPos, 
	 		               A_Target, A_TableMask, A_FoundPos)

       written by kawai@icot22      on Wed Sep 11 15:31:46 1991
<Arguments>
 A_String : $B%5!<%ABP>]%9%H%j%s%0(B
 A_StartPos : $B%5!<%A3+;OMWAG0LCV(B
 A_EndPos : $B%5!<%A=*N;MWAG0LCV(B
 A_Target : $B%5!<%ABP>]J8;z%3!<%I(B/$B%5!<%AMQ%F!<%V%k(B(8$B%S%C%H%9%H%j%s%0(B)
 A_TableMask : $B%F!<%V%k%5!<%AMQ%^%9%/(B(Tag=ATOM/INT)
 A_FoundPos : $BH/8+$7$?MWAG0LCV(B($B=PNO(B)
<Temporally Used Variables>
 D_WorkStrLength : $B%9%H%j%s%0$NA4D9(B
 D_WorkStrElmSize : $B%9%H%j%s%0$NMWAG%5%$%:(B
 D_WorkElmsCntInWord : 1$B%9%H%j%s%0%o!<%ICf$NMWAG?t(B
 D_WorkElmMask : $B%9%H%j%s%0%o!<%I$+$i(B1$BMWAG<h$j=P$9$?$a$N%^%9%/(B
 D_WorkStrSearchFirstWordPos : $B%5!<%AHO0O$N:G=i$N%9%H%j%s%0%o!<%I0LCV(B
 D_WorkElmsCntInFirstWord : $B%5!<%AHO0O$N:G=i$N%9%H%j%s%0%o!<%ICf$G%5!<%A(B
                            $BHO0O$KF~$kMWAG$N?t(B
 D_WorkStrSearchLastWordPos : $B%5!<%AHO0O$N:G8e$N%9%H%j%s%0%o!<%I0LCV(B
 D_WorkSkipElmsCntInLastWord : $B%5!<%AHO0O$N:G8e$N%9%H%j%s%0%o!<%ICf$G%5!<%A(B
                               $BHO0O$KF~$i$J$$MWAG$N?t(B
 D_WorkFoundPosInWord : $BH/8+$7$?MWAG0LCV(B
 D_WorkSearchElmsCntInWord : $B%9%H%j%s%0%o!<%ICf$G%5!<%AHO0O$KF~$kMWAG$N?t(B
 D_WorkStrSearchTargetWord : $B%5!<%ABP>]$N%9%H%j%s%0%o!<%I(B
<Level>
<PreCondition>
<Function>
  $B%9%H%j%s%0Cf$r5UJ}8~(B($BMWAG0LCV(B $BBg(B -> $B>.(B)$B$KJ8;z8!:w$9$k!#(B
<Examples>
<Test>
<Explanation>
  $B=hM}J}<0$O4pK\E*$K0J2<$N$h$&$K$J$C$F$$$k!#(B
   1. $B=gJ}8~%5!<%A$+5UJ}8~%5!<%A$+$r7h$a$k!#(B
   2. $B%5!<%AHO0O$,4^$^$l$k%9%H%j%s%0%o!<%I$N@hF,$HKvHx$r5a$a$k!#(B
   3. $B%5!<%AHO0O$N@hF,%o!<%ICf$G%9%-%C%W$9$kMWAG?t$r5a$a$k!#(B
   4. $B%5!<%AHO0O$NKvHx%o!<%ICf$N%5!<%ABP>]MWAG?t$r5a$a$k!#(B
   5. $B%5!<%AHO0O$N@hF,%o!<%I$+$iKvHx%o!<%I$^$G!"(B1$B%o!<%I$E$D8!:wBP>]J8;z$rC5$9!#(B
   6. $BH/8+MWAG0LCV$rJV$9!#(B

 [$BNc(B] 8$B%S%C%H%9%H%j%s%0(B("abcd...xyz")$B$NBh(B18$BMWAG(B(s)$B$+$iBh(B10$BMWAG(B(k)$B$^$G$,(B
      $B%5!<%AHO0O$N>l9g$O!"0J2<$N$h$&$JCM$,%o!<%/%l%8%9%?$K@_Dj$5$l$k!#(B

                               +-------------------------------+
                               |   $B%9%H%j%s%0%G%#%9%/%j%W%?(B    |
                               +-------+-------+-------+-------+
                               |   a   |   b   |   c   |   d   |  0
                               +-------+-------+-------+-------+
                              $B!A(B                              $B!A(B
             D_WorkSkipElmsCntInLastWord(=2) ->|
                               +-------+-------+-------+-------+
D_WorkStrSearchLastWordPos  -> |   i   |   j   |   k   |   l   |  2
                               +-------+-------+-------+-------+
                               |   m   |   n   |   o   |   p   |  3
                               +-------+-------+-------+-------+
D_WorkStrSearchFirstWordPos -> |   q   |   r   |   s   |   t   |  4
                               +-------+-------+-------+-------+
                        D_WorkElmsCntInFirstWord(=3) ->|
                              $B!A(B                              $B!A(B
                               +-------+-------+-------+-------+
                               |   y   |   z   |   -   |   -   |  6
                               +-------+-------+-------+-------+
                                   0       1       2       3

<ETC>
********************************************************************* PSL **/


#DATA_define  D_WorkSkipElmsCntInLastWord  XXX
#DATA_define  D_WorkElmsCntInFirstWord     XXX
#DATA_define  D_WorkSkipElmsCntInWord  XXX

#SUBARG_define  A_String    SRC
#SUBARG_define  A_StartPos  SRC
#SUBARG_define  A_EndPos    SRC
#SUBARG_define  A_Target  SRC
#SUBARG_define  A_TableMask  SRC
#SUBARG_define  A_FoundPos  DST

#SUBROUTINE  f_SearchCharBackward_Sub(A_String, A_StartPos, A_EndPos, 
		 		         A_Target, A_TableMask, A_FoundPos)
{
  $USE(D_WorkStrLength);
  $USE(D_WorkStrElmSize);
  /* $B%9%H%j%s%0$NA4D9$HMWAG%5%$%:$rF@$k(B */
  s_GetStringType(A_String, D_WorkStrLength, D_WorkStrElmSize);
  $USE(D_WorkElmsCntInWord);
  $USE(D_WorkElmMask);
  /* 1$B%9%H%j%s%0%o!<%ICf$NMWAG?t$H<h$j=P$7$N$?$a$N%^%9%/%Q%?%s$rF@$k(B */
  s_GetElmCountInWordAndMask(D_WorkStrElmSize, D_WorkElmsCntInWord,
			                               D_WorkElmMask);
  $USE(D_WorkStrSearchFirstWordPos);
  $USE(D_WorkSkipElmsCntInLastWord);
  $USE(D_WorkStrSearchLastWordPos);
  $USE(D_WorkElmsCntInFirstWord);
  /* $B%9%H%j%s%0Cf$N%5!<%AHO0O$r7h$a$k(B */
  s_DecideSearchRegion(A_StartPos, A_EndPos, D_WorkElmsCntInWord,
		       D_WorkStrSearchLastWordPos, D_WorkSkipElmsCntInLastWord,
		       D_WorkStrSearchFirstWordPos, D_WorkElmsCntInFirstWord);

  @DEBUG{
    b_IfGreater(D_WorkStrSearchFirstWordPos, D_WorkStrLength)
      {
	VPIM_ERROR("f_SearchCharBackward_Sub","SearchRegion Overflow !!");
      }
  };
  $RELEASE(D_WorkStrLength);

  $USE(D_WorkStrSearchTargetWord);
  $USE(D_WorkSkipElmsCntInWord);
  $USE(D_WorkFoundPosInWord);
  p_SetImmediateValue(_CHARACTER_NOT_FOUND, D_WorkFoundPosInWord);
  p_MoveValue(D_NULL, D_WorkSkipElmsCntInWord);
  LOOP()
    { 
      b_IfNotEqualImm(D_WorkFoundPosInWord, _CHARACTER_NOT_FOUND)
 	{ /* $BC5$7$F$$$k(B Char $B$,8+$D$+$C$?$i!"(BPosition $B$r%;%C%H$7$FH4$1$k(B */
	  b_IncrementReg(D_WorkStrSearchFirstWordPos);
	  b_MultiplyWithDNTC(D_WorkStrSearchFirstWordPos, D_WorkElmsCntInWord,
		                                                 A_FoundPos);
	  b_AddWithDNTC(A_FoundPos, D_WorkFoundPosInWord, A_FoundPos);
	  b_SetImmTypeMRBoff(INT, A_FoundPos);
	  break;
	}
      
      b_IfLess(D_WorkStrSearchFirstWordPos, D_WorkStrSearchLastWordPos)
	{ /* $BA4C5:wHO0O$rC5$7$F8+$D$+$i$J$1$l$P!"(BPosition = -1 $B$H$7$FH4$1$k(B */
	  b_SetImmTypeValueMRBoff(INT, _CHARACTER_NOT_FOUND, A_FoundPos);
	  break;
	}
      b_IfEqual(D_WorkStrSearchFirstWordPos, D_WorkStrSearchLastWordPos)
	{ /* $BC5:wHO0O$N:G=*%o!<%I$@$C$?$i!"$=$N%o!<%IFb$N%9%-%C%W%(%l%a%s%H?t$r(B
	     $B%;%C%H$9$k(B */
	  p_MoveValue(D_WorkSkipElmsCntInLastWord, D_WorkSkipElmsCntInWord);
	}

      /* $B%5!<%AHO0OFb$N(B1$B%9%H%j%s%0%o!<%I$rFI$_9~$`(B */
      s_GetStringWordPosReg(A_String, D_WorkStrSearchFirstWordPos,
			                           D_WorkStrSearchTargetWord);

      s_IfATOM(A_TableMask)
	{ /* A_TableMask$B$N%?%0$,(BATOM$B$J$i!"(B1$B%9%H%j%s%0%o!<%ICf$GDL>o$NJ8;z(B
             $B%5!<%A$r9T$&(B */
	  s_SearchCharBackwardInWord(D_WorkStrSearchTargetWord, A_Target, 
				     D_WorkStrElmSize, D_WorkElmsCntInWord,
				     D_WorkSkipElmsCntInWord,
				     D_WorkElmsCntInFirstWord,
				     D_WorkElmMask, D_WorkFoundPosInWord);
	}
      else
	{ /* A_TableMask$B$N%?%0$,(BINT$B$J$i!"(B1$B%9%H%j%s%0%o!<%ICf$G%F!<%V%k$r(B
	     $BMQ$$$?%5!<%A$r9T$&(B */
	  s_SearchCharBackwardInWordWithTable(D_WorkStrSearchTargetWord,
					      A_Target, A_TableMask,
					      D_WorkStrElmSize,
					      D_WorkElmsCntInWord,
					      D_WorkSkipElmsCntInWord,
					      D_WorkElmsCntInFirstWord,
					      D_WorkElmMask,
					      D_WorkFoundPosInWord);
	}

      /* $B%5!<%AHO0O$N%9%H%j%s%0%o!<%I$r(B1$B?J$a$k(B */
      b_DecrementReg(D_WorkStrSearchFirstWordPos);

      p_MoveValue(D_WorkElmsCntInWord, D_WorkElmsCntInFirstWord);
    }

  $RELEASE(D_WorkFoundPosInWord);
  $RELEASE(D_WorkStrSearchTargetWord);
  $RELEASE(D_WorkStrSearchFirstWordPos);
  $RELEASE(D_WorkSkipElmsCntInLastWord);
  $RELEASE(D_WorkSkipElmsCntInWord);
  $RELEASE(D_WorkStrSearchLastWordPos);
  $RELEASE(D_WorkElmsCntInFirstWord);
  $RELEASE(D_WorkStrElmSize);
  $RELEASE(D_WorkElmsCntInWord);
  $RELEASE(D_WorkElmMask);

  $RETURN();
}

/******************************************************************** PSL **
  8. $B%9%H%j%s%0$NMWAG$4$H$N1i;;(B
       written by kawai@icot22      on Wed Jul 17 14:24:21 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $BF~NO$5$l$?%9%H%j%s%0$N;XDj$5$l$?HO0OFb$NMWAGF1;N$G%S%C%H%o%$%:$N1i;;$r9T$$!"(B
$B$=$N1i;;7k2L$G85$N%9%H%j%s%0$NMWAG$rCV$-49$($k!#(B
  $B0J2<$N(B3$B<oN`$N%5%V%k!<%A%s$,$"$k!#(B
    f_BinaryStringOpe_Sub
    f_ShiftingStringOpe_Sub
    f_UnaryStringOpe_Sub
  $B$J$*!"%S%C%H%o%$%:1i;;$N<oN`$K$D$$$F$O!"(Bklb_body_built_structures.psl.c $B$r(B
$B;2>H$N$3$H!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

/******************************************************************** PSL **
  f_BinaryStringOpe_Sub(A_Operation, A_String1, A_Position1,
				   A_Length, A_String2, A_Position2)

       written by kawai@icot22      on Wed Sep 11 19:49:37 1991
<Arguments>
  A_Operation : $B%9%H%j%s%0MWAG4V$N%S%C%H%o%$%:1i;;<oJL(B($B@0?t(B0$B!A(B15)
  A_String1 : $BF~NO%9%H%j%s%0(B($B$=$N(B1)
  A_Position1 : $BF~NO%9%H%j%s%0(B($B$=$N(B1)$B$N1i;;3+;OMWAG0LCV(B
  A_Length : $B1i;;BP>]MWAG?t(B
  A_String2 : $BF~NO%9%H%j%s%0(B($B$=$N(B2)
  A_Position2 : $BF~NO%9%H%j%s%0(B($B$=$N(B2)$B$N1i;;3+;OMWAG0LCV(B
<Temporally Used Variables>
  D_WorkEndPosition1 : $BF~NO%9%H%j%s%0(B($B$=$N(B1)$B$N1i;;=*N;MWAG0LCV(B
  D_WorkStrSearchFirstWordPos1 : $BF~NO%9%H%j%s%0(B($B$=$N(B1)$B$N1i;;3+;OMWAG0LCV$,(B
                                 $B4^$^$l$k%9%H%j%s%0%o!<%I0LCV(B
  D_WorkElmsCntInFirstWord1 : $BF~NO%9%H%j%s%0(B($B$=$N(B1)$B$N1i;;3+;OMWAG0LCV$,4^$^$l(B
                              $B$k%9%H%j%s%0%o!<%ICf$NBP>]MWAG?t(B
  D_WorkEndPosition2 : $BF~NO%9%H%j%s%0(B($B$=$N(B2)$B$N1i;;=*N;MWAG0LCV(B
  D_WorkStrSearchFirstWordPos2 : $BF~NO%9%H%j%s%0(B($B$=$N(B2)$B$N1i;;3+;OMWAG0LCV$,(B
                                 $B4^$^$l$k%9%H%j%s%0%o!<%I0LCV(B
  D_WorkElmsCntInFirstWord2 : $BF~NO%9%H%j%s%0(B($B$=$N(B2)$B$N1i;;3+;OMWAG0LCV$,4^$^$l(B
                              $B$k%9%H%j%s%0%o!<%ICf$NBP>]MWAG?t(B
<Level>
<PreCondition>
<Function>
  $BF~NO%9%H%j%s%0(B($B$=$N(B1)(A_String1)$B$N1i;;3+;OMWAG0LCV(B(A_Position1)$B$+$i1i;;BP>](B
$BMWAG?t(B(A_Length)$BJ,$NMWAG$H!"F~NO%9%H%j%s%0(B($B$=$N(B2)(A_String2)$B$N1i;;3+;OMWAG0LCV(B
(A_String2)$B$+$i1i;;BP>]MWAG?t(B(A_Length)$BJ,$NMWAG$H$N4V$G1i;;<oJL(B(A_Operation)$B$G(B
$B<($5$l$k%S%C%H%o%$%:1i;;$r9T$$!"$=$N7k2L$GF~NO%9%H%j%s%0(B($B$=$N(B1)(A_String1)$B$N(B
$B1i;;3+;OMWAG0LCV(B(A_Position1)$B$+$i1i;;BP>]MWAG?t(B(A_Length)$BJ,$NMWAG$rCV$-49$($k!#(B
<Examples>
<Test>
<Explanation>
  $BCm0U(B:
    $BF~NO%9%H%j%s%0(B($B$=$N(B1)$B$HF~NO%9%H%j%s%0(B($B$=$N(B2)$B$,F10l%9%H%j%s%0$G!"F~NO%9%H(B
$B%j%s%0(B($B$=$N(B1)$B$H$7$F$NCV$-49$(HO0O$HF~NO%9%H%j%s%0(B($B$=$N(B2)$B$H$7$F$NFI$_9~$_HO0O$,(B
$B=EJ#$9$k>l9g!"CV$-49$($?7k2L$NMWAG$rFI$_9~$^$J$$$?$a$K<!$N$h$&$JJ}<0$r<h$C$F$$(B
$B$k!#(B
   (1) $BCV$-49$(HO0O$N@hF,MWAG0LCV(B $B!e(B $BFI$_9~$_HO0O$N@hF,MWAG0LCV$N$H$-(B
         $BF~NO%9%H%j%s%0(B($B$=$N(B1)$B$N@hF,$+$iMWAG$rCV$-49$($k!#(B
   (2) $BCV$-49$(HO0O$N@hF,MWAG0LCV(B $B!d(B $BFI$_9~$_HO0O$N@hF,MWAG0LCV$N$H$-(B
         $BF~NO%9%H%j%s%0(B($B$=$N(B1)$B$NKvHx$+$iMWAG$rCV$-49$($k!#(B
<ETC>
********************************************************************* PSL **/

#DATA_define  D_WorkEndPosition1             XXX
#DATA_define  D_WorkStrSearchFirstWordPos1   XXX
#DATA_define  D_WorkElmsCntInFirstWord1  XXX
#DATA_define  D_WorkEndPosition2             XXX
#DATA_define  D_WorkStrSearchFirstWordPos2   XXX
#DATA_define  D_WorkElmsCntInFirstWord2  XXX
#DATA_define  D_WorkArgStrLength  XXX

#SUBARG_define  A_Operation   SRC
#SUBARG_define  A_String1     MODIFY
#SUBARG_define  A_Position1   SRC
#SUBARG_define  A_Length      SRC
#SUBARG_define  A_String2     SRC
#SUBARG_define  A_Position2   SRC

#SUBROUTINE  f_BinaryStringOpe_Sub(A_Operation, A_String1, A_Position1,
				   A_Length, A_String2, A_Position2)
{
  /* A_String1$B$NMWAG%5%$%:$H%^%9%/%Q%?%s$rF@$k(B */
  $USE(D_WorkStrLength);
  $USE(D_WorkStrElmSize);
  /* $B%9%H%j%s%0$NA4D9$HMWAG%5%$%:$rF@$k(B */
  s_GetStringType(A_String1, D_WorkStrLength, D_WorkStrElmSize);
  $USE(D_WorkElmsCntInWord);
  $USE(D_WorkElmMask);
  /* 1$B%9%H%j%s%0%o!<%ICf$NMWAG?t$H<h$j=P$7$N$?$a$N%^%9%/%Q%?%s$rF@$k(B */
  s_GetElmCountInWordAndMask(D_WorkStrElmSize, D_WorkElmsCntInWord,
			                                      D_WorkElmMask);
  $USE(D_WorkEndPosition1);
  $USE(D_WorkStrSearchFirstWordPos1);
  $USE(D_WorkElmsCntInFirstWord1);

  $USE(D_WorkEndPosition2);
  $USE(D_WorkStrSearchFirstWordPos2);
  $USE(D_WorkElmsCntInFirstWord2);


  $USE(D_WorkArgStrLength);
  p_MoveValue(A_Length, D_WorkArgStrLength);

  b_IfLessEq(A_Position1, A_Position2)
    { /* $B%9%H%j%s%0$NA0J}$+$iA`:n$9$k(B */
      /* A_String1$B$N(BA_Position1$B$,4^$^$l$k%o!<%I$*$h$S$=$N%o!<%IFb$N%(%l%a%s%H(B
 	 $BHV9f$r5a$a$k(B */
      b_AddWithDNTC(A_Position1, A_Length, D_WorkEndPosition1);
      b_DecrementReg(D_WorkEndPosition1);
      /* $B%9%H%j%s%0(B($B$=$N(B1)$BCf$N1i;;HO0O$r7h$a$k(B */
      s_DecideSearchRegion(A_Position1, D_WorkEndPosition1,
			   D_WorkElmsCntInWord,
			   D_WorkStrSearchFirstWordPos1,
			   D_WorkElmsCntInFirstWord1, /* $B@hF,%(%l%a%s%H0LCV(B */
			   D_VOID, D_VOID);

      /* A_String2$B$N(BA_Position2$B$,4^$^$l$k%o!<%I$*$h$S$=$N%o!<%IFb$N%(%l%a%s%H(B
	 $BHV9f$r5a$a$k(B */
      b_AddWithDNTC(A_Position2, A_Length, D_WorkEndPosition2);
      b_DecrementReg(D_WorkEndPosition2);
      /* $B%9%H%j%s%0(B($B$=$N(B2)$BCf$N1i;;HO0O$r7h$a$k(B */
      s_DecideSearchRegion(A_Position2, D_WorkEndPosition2,
			   D_WorkElmsCntInWord,
			   D_WorkStrSearchFirstWordPos2,
			   D_WorkElmsCntInFirstWord2,  /* $B@hF,%(%l%a%s%H0LCV(B */
			   D_VOID, D_VOID);

      /* $BA`:nHO0OFb$N3F%(%l%a%s%H$KBP$7$F(B A_Operation$B$G;XDj$5$l$?1i;;$r9T$$!"(B
	A_String1$B$r99?7$9$k(B */
      s_GeneralStringOpeForward(A_String1, D_WorkStrSearchFirstWordPos1,
				D_WorkElmsCntInFirstWord1,
				A_String2, D_WorkStrSearchFirstWordPos2,
				D_WorkElmsCntInFirstWord2,
				A_Operation, D_WorkElmMask,
				D_WorkArgStrLength, D_WorkStrElmSize,
				D_WorkElmsCntInWord);
    }
  else
    { /* $B%9%H%j%s%0$N8eJ}$+$iA`:n$9$k(B */
      /* A_String1$B$N(BA_Position1$B$,4^$^$l$k%o!<%I$*$h$S$=$N%o!<%IFb$N%(%l%a%s%H(B
 	 $BHV9f$r5a$a$k(B */
      b_AddWithDNTC(A_Position1, A_Length, D_WorkEndPosition1);
      b_DecrementReg(D_WorkEndPosition1);
      /* $B%9%H%j%s%0(B($B$=$N(B1)$BCf$N1i;;HO0O$r7h$a$k(B */
      s_DecideSearchRegion(A_Position1, D_WorkEndPosition1,
			   D_WorkElmsCntInWord,
			   D_VOID, D_VOID,
			   D_WorkStrSearchFirstWordPos1,
			   D_WorkElmsCntInFirstWord1);

      /* A_String2$B$N(BA_Position2$B$,4^$^$l$k%o!<%I$*$h$S$=$N%o!<%IFb$N%(%l%a%s%H(B
	 $BHV9f$r5a$a$k(B */
      b_AddWithDNTC(A_Position2, A_Length, D_WorkEndPosition2);
      b_DecrementReg(D_WorkEndPosition2);
      /* $B%9%H%j%s%0(B($B$=$N(B2)$BCf$N1i;;HO0O$r7h$a$k(B */
      s_DecideSearchRegion(A_Position2, D_WorkEndPosition2,
			   D_WorkElmsCntInWord,
			   D_VOID, D_VOID,
			   D_WorkStrSearchFirstWordPos2,
			   D_WorkElmsCntInFirstWord2);

      /* $BA`:nHO0OFb$N3F%(%l%a%s%H$KBP$7$F(B A_Operation$B$G;XDj$5$l$?1i;;$r9T$$!"(B
	A_String1$B$r99?7$9$k(B */
      /* $B%(%l%a%s%H8D?t(B -> $B%(%l%a%s%H0LCV(B $B$NJQ49(B */
      b_DecrementReg(D_WorkElmsCntInFirstWord1);
      b_DecrementReg(D_WorkElmsCntInFirstWord2);

      s_GeneralStringOpeBackward(A_String1, D_WorkStrSearchFirstWordPos1,
				 D_WorkElmsCntInFirstWord1,
				 A_String2, D_WorkStrSearchFirstWordPos2,
				 D_WorkElmsCntInFirstWord2,
				 A_Operation, D_WorkElmMask,
				 D_WorkArgStrLength, D_WorkStrElmSize,
				 D_WorkElmsCntInWord);
    }

  $RELEASE(D_WorkStrLength);
  $RELEASE(D_WorkStrElmSize);
  $RELEASE(D_WorkElmsCntInWord);
  $RELEASE(D_WorkElmMask);
  $RELEASE(D_WorkEndPosition1);
  $RELEASE(D_WorkStrSearchFirstWordPos1);
  $RELEASE(D_WorkElmsCntInFirstWord1);
  $RELEASE(D_WorkEndPosition2);
  $RELEASE(D_WorkStrSearchFirstWordPos2);
  $RELEASE(D_WorkElmsCntInFirstWord2);
  $RELEASE(D_WorkArgStrLength);

  $RETURN();
}

/******************************************************************** PSL **
  f_ShiftingStringOpe_Sub(A_Operation, A_String1, A_Position1,
				                  A_Length, A_Position2)

       written by kawai@icot22      on Wed Sep 11 20:56:00 1991
<Arguments>
  A_Operation : $B%9%H%j%s%0MWAG4V$N%S%C%H%o%$%:1i;;<oJL(B($B@0?t(B0$B!A(B15)
  A_String1 : $BF~NO%9%H%j%s%0(B
  A_Position1 : $BF~NO%9%H%j%s%0$N1i;;3+;OMWAG0LCV(B($B$=$N(B1)
  A_Length : $B1i;;BP>]MWAG?t(B
  A_Position2 : $BF~NO%9%H%j%s%0$N1i;;3+;OMWAG0LCV(B($B$=$N(B2)
<Temporally Used Variables>
  D_WorkEndPosition1 : $BF~NO%9%H%j%s%0$N1i;;=*N;MWAG0LCV(B($B$=$N(B1)
  D_WorkStrSearchFirstWordPos1 : $BF~NO%9%H%j%s%0$N1i;;3+;OMWAG0LCV(B($B$=$N(B1)$B$,(B
                                 $B4^$^$l$k%9%H%j%s%0%o!<%I0LCV(B
  D_WorkElmsCntInFirstWord1 : $BF~NO%9%H%j%s%0$N1i;;3+;OMWAG0LCV(B($B$=$N(B1)$B$,4^$^$l(B
                              $B$k%9%H%j%s%0%o!<%ICf$NBP>]MWAG?t(B
  D_WorkEndPosition2 : $BF~NO%9%H%j%s%0$N1i;;=*N;MWAG0LCV(B($B$=$N(B2)
  D_WorkStrSearchFirstWordPos2 : $BF~NO%9%H%j%s%0$N1i;;3+;OMWAG0LCV(B($B$=$N(B2)$B$,(B
                                 $B4^$^$l$k%9%H%j%s%0%o!<%I0LCV(B
  D_WorkElmsCntInFirstWord2 : $BF~NO%9%H%j%s%0$N1i;;3+;OMWAG0LCV(B($B$=$N(B2)$B$,4^$^$l(B
                              $B$k%9%H%j%s%0%o!<%ICf$NBP>]MWAG?t(B
<Level>
<PreCondition>
<Function>
  $BF~NO%9%H%j%s%0(B(A_String1)$B$N1i;;3+;OMWAG0LCV(B($B$=$N(B1)(A_Position1)$B$+$i1i;;BP>](B
$BMWAG?t(B(A_Length)$BJ,$NMWAG$H!"F~NO%9%H%j%s%0(B(A_String2)$B$N1i;;3+;OMWAG0LCV(B($B$=$N(B2)
(A_String2)$B$+$i1i;;BP>]MWAG?t(B(A_Length)$BJ,$NMWAG$H$N4V$G1i;;<oJL(B(A_Operation)$B$G(B
$B<($5$l$k%S%C%H%o%$%:1i;;$r9T$$!"$=$N7k2L$GF~NO%9%H%j%s%0(B(A_String1)$B$N1i;;3+;O(B
$BMWAG0LCV(B($B$=$N(B1)(A_Position1)$B$+$i1i;;BP>]MWAG?t(B(A_Length)$BJ,$NMWAG$rCV$-49$($k!#(B
<Examples>
<Test>
<Explanation>
  $BCm0U(B:
    $BF~NO%9%H%j%s%0$NCV$-49$(HO0O$HFI$_9~$_HO0O$,=EJ#$9$k>l9g!"CV$-49$($?7k2L$N(B
$BMWAG$rFI$_9~$^$J$$$?$a$K<!$N$h$&$JJ}<0$r<h$C$F$$$k!#(B
   (1) $BCV$-49$(HO0O$N@hF,MWAG0LCV(B $B!e(B $BFI$_9~$_HO0O$N@hF,MWAG0LCV$N$H$-(B
         $BF~NO%9%H%j%s%0(B($B$=$N(B1)$B$N@hF,$+$iMWAG$rCV$-49$($k!#(B
   (2) $BCV$-49$(HO0O$N@hF,MWAG0LCV(B $B!d(B $BFI$_9~$_HO0O$N@hF,MWAG0LCV$N$H$-(B
         $BF~NO%9%H%j%s%0(B($B$=$N(B1)$B$NKvHx$+$iMWAG$rCV$-49$($k!#(B
<ETC>
********************************************************************* PSL **/

#SUBARG_define  A_Operation   SRC
#SUBARG_define  A_String1     MODIFY
#SUBARG_define  A_Position1   SRC
#SUBARG_define  A_Length      SRC
#SUBARG_define  A_Position2   SRC

#SUBROUTINE  f_ShiftingStringOpe_Sub(A_Operation, A_String1, A_Position1,
				     A_Length, A_Position2)
{
  /* A_String1$B$NMWAG%5%$%:$H%^%9%/%Q%?%s$rF@$k(B */
  $USE(D_WorkStrLength);
  $USE(D_WorkStrElmSize);
  /* $B%9%H%j%s%0$NA4D9$HMWAG%5%$%:$rF@$k(B */
  s_GetStringType(A_String1, D_WorkStrLength, D_WorkStrElmSize);
  $USE(D_WorkElmsCntInWord);
  $USE(D_WorkElmMask);
  /* 1$B%9%H%j%s%0%o!<%ICf$NMWAG?t$H<h$j=P$7$N$?$a$N%^%9%/%Q%?%s$rF@$k(B */
  s_GetElmCountInWordAndMask(D_WorkStrElmSize, D_WorkElmsCntInWord,
			                     D_WorkElmMask);
  $USE(D_WorkEndPosition1);
  $USE(D_WorkStrSearchFirstWordPos1);
  $USE(D_WorkElmsCntInFirstWord1);

  $USE(D_WorkEndPosition2);
  $USE(D_WorkStrSearchFirstWordPos2);
  $USE(D_WorkElmsCntInFirstWord2);

  $USE(D_WorkArgStrLength);
  p_MoveValue(A_Length, D_WorkArgStrLength);

  b_IfLessEq(A_Position1, A_Position2)
    { /* $B%9%H%j%s%0$NA0J}$+$iA`:n$9$k(B */
      /* A_String1$B$N(BA_Position1$B$,4^$^$l$k%o!<%I$*$h$S$=$N%o!<%IFb$N%(%l%a%s%H(B
 	 $BHV9f$r5a$a$k(B */
      b_AddWithDNTC(A_Position1, A_Length, D_WorkEndPosition1);
      b_DecrementReg(D_WorkEndPosition1);
      /* $B%9%H%j%s%0Cf$N1i;;HO0O(B($B$=$N(B1)$B$r7h$a$k(B */
      s_DecideSearchRegion(A_Position1, D_WorkEndPosition1,
			   D_WorkElmsCntInWord,
			   D_WorkStrSearchFirstWordPos1,
			   D_WorkElmsCntInFirstWord1, /* $B@hF,%(%l%a%s%H0LCV(B */
			   D_VOID, D_VOID);

      /* A_String1$B$N(BA_Position2$B$,4^$^$l$k%o!<%I$*$h$S$=$N%o!<%IFb$N%(%l%a%s%H(B
	 $BHV9f$r5a$a$k(B */
      b_AddWithDNTC(A_Position2, A_Length, D_WorkEndPosition2);
      b_DecrementReg(D_WorkEndPosition2);
      /* $B%9%H%j%s%0Cf$N1i;;HO0O(B($B$=$N(B2)$B$r7h$a$k(B */
      s_DecideSearchRegion(A_Position2, D_WorkEndPosition2,
			   D_WorkElmsCntInWord,
			   D_WorkStrSearchFirstWordPos2,
			   D_WorkElmsCntInFirstWord2,  /* $B@hF,%(%l%a%s%H0LCV(B */
			   D_VOID, D_VOID);

      /* $BA`:nHO0OFb$N3F%(%l%a%s%H$KBP$7$F(B A_Operation$B$G;XDj$5$l$?1i;;$r9T$$!"(B
	A_String1$B$r99?7$9$k(B */
      s_GeneralStringOpeForward(A_String1, D_WorkStrSearchFirstWordPos1,
				D_WorkElmsCntInFirstWord1,
				A_String1, D_WorkStrSearchFirstWordPos2,
				D_WorkElmsCntInFirstWord2,
				A_Operation, D_WorkElmMask,
				D_WorkArgStrLength, D_WorkStrElmSize,
				D_WorkElmsCntInWord);
    }
  else
    { /* $B%9%H%j%s%0$N8eJ}$+$iA`:n$9$k(B */
      /* A_String1$B$N(BA_Position1$B$,4^$^$l$k%o!<%I$*$h$S$=$N%o!<%IFb$N%(%l%a%s%H(B
 	 $BHV9f$r5a$a$k(B */
      b_AddWithDNTC(A_Position1, A_Length, D_WorkEndPosition1);
      b_DecrementReg(D_WorkEndPosition1);
      /* $B%9%H%j%s%0Cf$N1i;;HO0O(B($B$=$N(B1)$B$r7h$a$k(B */
      s_DecideSearchRegion(A_Position1, D_WorkEndPosition1,
			   D_WorkElmsCntInWord,
			   D_VOID, D_VOID,
			   D_WorkStrSearchFirstWordPos1,
			   D_WorkElmsCntInFirstWord1);

      /* A_String1$B$N(BA_Position2$B$,4^$^$l$k%o!<%I$*$h$S$=$N%o!<%IFb$N%(%l%a%s%H(B
	 $BHV9f$r5a$a$k(B */
      b_AddWithDNTC(A_Position2, A_Length, D_WorkEndPosition2);
      b_DecrementReg(D_WorkEndPosition2);
      /* $B%9%H%j%s%0Cf$N1i;;HO0O(B($B$=$N(B2)$B$r7h$a$k(B */
      s_DecideSearchRegion(A_Position2, D_WorkEndPosition2,
			   D_WorkElmsCntInWord,
			   D_VOID, D_VOID,
			   D_WorkStrSearchFirstWordPos2,
			   D_WorkElmsCntInFirstWord2);

      /* $BA`:nHO0OFb$N3F%(%l%a%s%H$KBP$7$F(B A_Operation$B$G;XDj$5$l$?1i;;$r9T$$!"(B
	A_String1$B$r99?7$9$k(B */
      /* $B%(%l%a%s%H8D?t(B -> $B%(%l%a%s%H0LCV(B $B$NJQ49(B */
      b_DecrementReg(D_WorkElmsCntInFirstWord1);
      b_DecrementReg(D_WorkElmsCntInFirstWord2);

      s_GeneralStringOpeBackward(A_String1, D_WorkStrSearchFirstWordPos1,
				 D_WorkElmsCntInFirstWord1,
				 A_String1, D_WorkStrSearchFirstWordPos2,
				 D_WorkElmsCntInFirstWord2,
				 A_Operation, D_WorkElmMask,
				 D_WorkArgStrLength, D_WorkStrElmSize,
				 D_WorkElmsCntInWord);
    }

  $RELEASE(D_WorkStrLength);
  $RELEASE(D_WorkStrElmSize);
  $RELEASE(D_WorkElmsCntInWord);
  $RELEASE(D_WorkElmMask);
  $RELEASE(D_WorkEndPosition1);
  $RELEASE(D_WorkStrSearchFirstWordPos1);
  $RELEASE(D_WorkElmsCntInFirstWord1);
  $RELEASE(D_WorkEndPosition2);
  $RELEASE(D_WorkStrSearchFirstWordPos2);
  $RELEASE(D_WorkElmsCntInFirstWord2);
  $RELEASE(D_WorkArgStrLength);

  $RETURN();
}

/******************************************************************** PSL **
  f_UnaryStringOpe_Sub(A_Operation, A_String1, A_Position1, A_Length)

       written by kawai@icot22      on Wed Sep 11 21:11:23 1991
<Arguments>
  A_Operation : $B%9%H%j%s%0MWAG4V$N%S%C%H%o%$%:1i;;<oJL(B($B@0?t(B0$B!A(B15)
  A_String1 : $BF~NO%9%H%j%s%0(B
  A_Position1 : $BF~NO%9%H%j%s%0$N1i;;3+;OMWAG0LCV(B
  A_Length : $B1i;;BP>]MWAG?t(B
<Temporally Used Variables>
  D_WorkEndPosition1 : $BF~NO%9%H%j%s%0$N1i;;=*N;MWAG0LCV(B
  D_WorkStrSearchFirstWordPos1 : $BF~NO%9%H%j%s%0$N1i;;3+;OMWAG0LCV$,(B
                                 $B4^$^$l$k%9%H%j%s%0%o!<%I0LCV(B
  D_WorkElmsCntInFirstWord1 : $BF~NO%9%H%j%s%0$N1i;;3+;OMWAG0LCV$,4^$^$l(B
                              $B$k%9%H%j%s%0%o!<%ICf$NBP>]MWAG?t(B
  D_WorkEndPosition2 : D_WorkEndPosition1$B$HF1$8CM(B(Dummy)
  D_WorkStrSearchFirstWordPos2 : D_WorkStrSearchFirstWordPos1$B$HF1$8CM(B(Dummy)
  D_WorkElmsCntInFirstWord2 : D_WorkElmsCntInFirstWord1$B$HF1$8CM(B(Dummy)
<Level>
<PreCondition>
<Function>
  $BF~NO%9%H%j%s%0(B(A_String1)$B$N1i;;3+;OMWAG0LCV(B(A_Position1)$B$+$i1i;;BP>](B
$BMWAG?t(B(A_Length)$BJ,$NMWAGF1;N$G1i;;<oJL(B(A_Operation)$B$G<($5$l$k%S%C%H%o%$%:1i;;(B
$B$r9T$$!"$=$N7k2L$GF~NO%9%H%j%s%0(B(A_String1)$B$N1i;;3+;OMWAG0LCV(B(A_Position1)$B$+$i(B
$B1i;;BP>]MWAG?t(B(A_Length)$BJ,$NMWAG$rCV$-49$($k!#(B
<Examples>
<Test>
<Explanation>
  $BCm0U(B:
    $BMWAGF1;N$N1i;;(B&$BMWAG$NCV$-49$(%k!<%A%s$O(B
      f_BinaryStringOpe_Sub
      f_ShiftingStringOpe_Sub
  $B$HF1$8$b$N$r;H$C$F$$$k$?$a!"0z?t$K%@%_!<$N%l%8%9%?$rEO$7$F$$$k!#(B
<ETC>
********************************************************************* PSL **/

#SUBARG_define  A_Operation   SRC
#SUBARG_define  A_String1     MODIFY
#SUBARG_define  A_Position1   SRC
#SUBARG_define  A_Length      SRC

#SUBROUTINE  f_UnaryStringOpe_Sub(A_Operation, A_String1,
				  A_Position1, A_Length)
{
  /* A_String1$B$NMWAG%5%$%:$H%^%9%/%Q%?%s$rF@$k(B */
  $USE(D_WorkStrLength);
  $USE(D_WorkStrElmSize);
  /* $B%9%H%j%s%0$NA4D9$HMWAG%5%$%:$rF@$k(B */
  s_GetStringType(A_String1, D_WorkStrLength, D_WorkStrElmSize);
  $USE(D_WorkElmsCntInWord);
  $USE(D_WorkElmMask);
  /* 1$B%9%H%j%s%0%o!<%ICf$NMWAG?t$H<h$j=P$7$N$?$a$N%^%9%/%Q%?%s$rF@$k(B */
  s_GetElmCountInWordAndMask(D_WorkStrElmSize, D_WorkElmsCntInWord,
			                    D_WorkElmMask);
  $USE(D_WorkEndPosition1);
  $USE(D_WorkStrSearchFirstWordPos1);
  $USE(D_WorkElmsCntInFirstWord1);

  /* A_String1$B$N(BA_Position1$B$,4^$^$l$k%o!<%I$*$h$S$=$N%o!<%IFb$N%(%l%a%s%H(B
     $BHV9f$r5a$a$k(B */
  b_AddWithDNTC(A_Position1, A_Length, D_WorkEndPosition1);
  b_DecrementReg(D_WorkEndPosition1);
  /* $B%9%H%j%s%0Cf$N1i;;HO0O$r7h$a$k(B */
  s_DecideSearchRegion(A_Position1, D_WorkEndPosition1, D_WorkElmsCntInWord,
		       D_WorkStrSearchFirstWordPos1,
		       D_WorkElmsCntInFirstWord1,
		       D_VOID, D_VOID);

  $USE(D_WorkStrSearchFirstWordPos2);
  $USE(D_WorkElmsCntInFirstWord2);

  /* $B$3$l$i$NCM$O!"2<$N(B s_GeneralStringOpe $B$NCf$GFs$D$N%9%H%j%s%0$KBP$7$F(B
     $BFHN)$K%a%s%F%J%s%9$5$l$k$?$a!"F1$8%l%8%9%?$r0z?t$GEO$7$F$O9T$1$J$$(B */
  p_MoveValue(D_WorkStrSearchFirstWordPos1, D_WorkStrSearchFirstWordPos2);
  p_MoveValue(D_WorkElmsCntInFirstWord1, D_WorkElmsCntInFirstWord2);

  /* $BA`:nHO0OFb$N3F%(%l%a%s%H$KBP$7$F(B A_Operation$B$G;XDj$5$l$?1i;;$r9T$$!"(B
     A_String1$B$r99?7$9$k(B */

  $USE(D_WorkArgStrLength);
  p_MoveValue(A_Length, D_WorkArgStrLength);

  s_GeneralStringOpeForward(A_String1, D_WorkStrSearchFirstWordPos1,
			    D_WorkElmsCntInFirstWord1,
			    A_String1, D_WorkStrSearchFirstWordPos2,
			    D_WorkElmsCntInFirstWord2,
			    A_Operation, D_WorkElmMask,
			    D_WorkArgStrLength, D_WorkStrElmSize,
			    D_WorkElmsCntInWord);
  $RELEASE(D_WorkArgStrLength);

  $RELEASE(D_WorkStrLength);
  $RELEASE(D_WorkStrElmSize);
  $RELEASE(D_WorkElmsCntInWord);
  $RELEASE(D_WorkElmMask);
  $RELEASE(D_WorkEndPosition1);
  $RELEASE(D_WorkStrSearchFirstWordPos1);
  $RELEASE(D_WorkElmsCntInFirstWord1);
  $RELEASE(D_WorkStrSearchFirstWordPos2);
  $RELEASE(D_WorkElmsCntInFirstWord2);

  $RETURN();
}

/******************************************************************** PSL **
  9. $B%9%H%j%s%0$NMWAG%5%$%:$NJQ99(B
    f_ChangeElementSize_Sub(A_String, A_NewElmSize)

       written by kawai@icot22      on Wed Jul 17 14:24:21 1991
<Arguments>
  A_String : $B%9%H%j%s%0(B
  A_NewElmSize : $B?7$?$K@_Dj$9$kMWAG%5%$%:(B
<Temporally Used Variables>
  D_WorkConvStrDesc : $B%9%H%j%s%0%G%#%9%/%j%W%?(B
<Level>
<PreCondition>
<Function>
  $B0z?t$GM?$($i$l$?%9%H%j%s%0$NMWAG%5%$%:$r!"0z?t$GM?$($i$l$?MWAG%5%$%:$KJQ99(B
$B$9$k!#(B
<Examples>
<Test>
<Explanation>
  $BCm0U(B:
    $B0z?t$GEO$C$F$/$k%9%H%j%s%0$O!"(B
      MRB$B!{$J$iAH9~=R8l8F$S=P$7;~$HF10l$N%9%H%j%s%0(B
      MRB$B!|$J$i%3%T!<:Q$_$N%9%H%j%s%0(B
  $B$G$"$k!#(B
<ETC>
********************************************************************* PSL **/

#DATA_define  D_WorkConvStrDesc  XXX

#SUBARG_define  A_String     MODIFY
#SUBARG_define  A_NewElmSize SRC

#SUBROUTINE  f_ChangeElementSize_Sub(A_String, A_NewElmSize)
{
  $USE(D_WorkConvStrDesc);
  /* f_CopyStringMRB(A_String, A_NewString)$B8e$N%9%H%j%s%0$,EO$C$F$/$k(B */
  s_GetConvertedStrDesc(A_String, A_NewElmSize, D_WorkConvStrDesc);
  s_PutStringDesc(D_WorkConvStrDesc, A_String);
  $RELEASE(D_WorkConvStrDesc);

  $RETURN();
}
