
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_reduce_spy_handler.psl.c
   ----- CREATED   : by imai@icot22, on Wed Dec  5 15:28:59 1990
   ----- LAST SAVED: by kawai@icot22, on Mon Mar  2 22:15:17 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : 

  PIMOS $B$N%j%9%J(B ($B%G%P%C%,(B) $B$N%5%]!<%H$N$?$a$KMQ0U$5$l$?%9%Q%$5!G=$r(B
  $B<B8=$9$k$?$a$N5!G=$rDj5A$7$?%U%!%$%k$G$"$k!#(B

  $B%9%Q%$$H$O!"(BKL1$B%W%m%0%i%`$N%G%P%C%0Cf$K!"%f!<%6$K$h$C$F;XDj$5$l$?(B
  $B=R8l$,8F$S=P$5$l$?;~E@!J%$%s%W%j%a%s%H>e!"(Benqueue $B$^$?$O(B execute
  $B$5$l$?;~E@!K$GNc30$rH/@8$9$k;EAH$_$G$"$k!#(B

  $B%9%Q%$%b!<%I$O!"AH$_9~$_=R8l(B
	apply_spying(Code,ArgV,SpyCodeVector,SpyID)
  $B$K$h$C$F8F$P$l$?=R8l0J9_$N;R%4!<%k!J$N$_!K$K0z$-7Q$,$l$k!#$9$J$o$A!"(B
  $B%9%Q%$$r@_Dj$7$?$+$i$H$$$C$F!"(Bapply_spying $B$N;R%4!<%k0J30$N%4!<%k$K(B
  $BBP$7$F$O!"%9%Q%$Nc30$OH/@8$7$J$$!#(B

  SpyCodeVector $B$O!"(B
  {Mod1, Pred1, Arity1, Mod2, Pred2, Arity2, ......, ModN, PredN, ArityN}
  $B$N$h$&$J!"(B
	$B%b%8%e!<%kL>%"%H%`!"=R8lL>%"%H%`!"0z?t8D?t(B(INT)
  $B$r%Z%"$H$9$k%Y%/%?$G$"$j!"%9%Q%$%b!<%I$G$O(B enqueue $B$NEY$K!"(Benqueue$BBP>](B
  $B%4!<%k$,!"$3$l$i$N%Y%/%?$K%^%C%A$9$k$+$I$&$+$rD4$Y$k!#(B
  $B$3$l$i$K$O!"%o%$%k%I%+!<%I$b;HMQ$G$-!"(B
	Mod, Pred $B$N%o%$%k%I%+!<%I$O!"(B	INT!0
	Arity $B$N%o%$%k%I%+!<%I$O(B	ATOM!0 '[]'
  $B$G$"$k!#%9%Q%$%3!<%I%Y%/%?$NMWAG$O!"#K#L#1%f!<%6$N@UG$$G6qBN2=$9$k!#(B

  SpyID $B$O!"#K#L#1%f!<%6!J(BPIMOS$B3+H/<T(B s-nakao@icot21.icot.or.jp$B!K$,$D$1$k(B
  ID $B$G!"G$0U$N#K#L#1%?%$%W$G$"$k!#(B

  $B%9%Q%$%b!<%I$+H]$+$O!"(BD_CurrentSpyId $B$N%?%$%W$,(B
	EOL	--> $B%9%Q%$%b!<%I$G$O$J$$(B (EOL$B$O!"(BKL1$B$N%?%$%W$G$O$J$$$?$a(B)
	$B$=$l0J30(B--> $B%9%Q%$%b!<%I$G$"$k(B
  $B$G6hJL$9$k!#(B

  $B%9%Q%$%b!<%I$G<B9T$9$Y$-%4!<%k$K$O!"4D6-%l%3!<%I$H$7$F(B
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
  $BDj?t!"$J$i$S$K%l%8%9%?$NDj5A(B

       written by imai@icot22      on Wed Dec 26 11:03:53 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#CONST_define	_PAIR_ELEMENTS_OF_SPIED_CODE_VECT	3
#ADDR_define	_NEXT_PAIR_OFST_SPIED_CODE_VECT		3

#DATA_define D_CurrentSpyId		XXX
#DATA_define D_CurrentSpiedCodeVect	XXX
	/* $B%Q!<%^%M%s%H%l%8%9%?!"%a%b%j>e$G==J,(B */

#DATA_define D_WorkSpiedCodeVect	XXX
#DATA_define D_WorkCurrentModName	XXX
#DATA_define D_WorkCurrentPredName	XXX
#DATA_define D_WorkCurrentPredArity	XXX

/******************************************************************** PSL **
1.  apply_spying $B$N%9%Q%$%3!<%I%Y%/%?$N%A%'%C%/(B

       written by imai@icot22      on Thu Dec 20 14:44:06 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
	apply_spying $B$NBh#30z?t$GM?$($i$l$k(B SpiedCodeVector $B$,(B
	$B@5$7$$$+$I$&$+$N%A%'%C%/(B
<Examples>
<Test>
<Explanation>
  apply_spying $B$NBh#30z?t$G$"$k!"(BSpiedCodeVector $B$O!"<!$N$9$Y$F$N>r7o$r(B
  $BK~$?$7$F$$$J$1$l$P!"(BEXCEPTION $B$G$"$k!#(B
    1. $B%Y%/%?$N%5%$%:$O#3$NG\?t$G$"$k(B
    2. $B%Y%/%?$NMWAG$O$9$Y$F6qBN2=$5$l$F$$$k!#(B
    3. (0$B%*%j%8%s$H$7$F(B)
	$BMWAGHV9f(B mod 3 == 0	ATOM $B$^$?$O(B INT!0
	$BMWAGHV9f(B mod 3 == 1	ATOM $B$^$?$O(B INT!0
	$BMWAGHV9f(B mod 3 == 2	INT  $B$^$?$O(B ATOM!0
<ETC>
********************************************************************* PSL **/

#CTRL_define f_IfAcceptableSpiedCodeVect(vect)
{
  $USE(D_WorkResult);
  $CALL(f_CheckAcceptableSpiedCodeVect_Sub(vect,D_WorkResult));
  p_Compare(D_WorkResult,D_NULL);
  $RELEASE(D_WorkResult);
  p_IfEQ()
}

#SUBARG_define A_Vect		SRC
#SUBARG_define A_Boolean	DST

#SUBROUTINE f_CheckAcceptableSpiedCodeVect_Sub(A_Vect,A_Boolean)
{
  $USE(D_WorkSize);  $USE(D_WorkElement);
  s_GetSizeVectType(A_Vect,D_WorkSize);
  LOOP() {
    p_Compare(D_WorkSize,D_NULL);
    p_IfEQ() { /* $B#3$G3d$j@Z$l$?(B */
      p_MoveWord(D_NULL,A_Boolean); break;
    }
    p_IfLT() { /* $B#3$G3d$j@Z$l$J$$(B */
      p_MoveWord(D_ALL1,A_Boolean); break;
    }
		/* $B$^$@;D$j$,$"$k(B */
    b_DecrementReg(D_WorkSize);
		/* $BMWAG0LCV(B mod 3 == 2 */
    f_GetVectElementWithDeref(A_Vect, D_WorkSize, D_WorkElement);
    f_IfNotIntOrAtomZero(D_WorkElement) {
      p_MoveWord(D_ALL1,A_Boolean); break;
    }
    b_DecrementReg(D_WorkSize);
		/* $BMWAG0LCV(B mod 3 == 1 */
    f_GetVectElementWithDeref(A_Vect, D_WorkSize, D_WorkElement);
    f_IfNotAtomOrIntZero(D_WorkElement) {
      p_MoveWord(D_ALL1,A_Boolean); break;
    }
    b_DecrementReg(D_WorkSize);
		/* $BMWAG0LCV(B mod 3 == 0 */
    f_GetVectElementWithDeref(A_Vect, D_WorkSize, D_WorkElement);
    f_IfNotAtomOrIntZero(D_WorkElement) {
      p_MoveWord(D_ALL1,A_Boolean); break;
    }
  }
  $RELEASE(D_WorkSize); $RELEASE(D_WorkElement);
  $RETURN();
}

#CTRL_define f_IfNotAtomOrIntZero(reg)
{
  TypeSwitch(reg) {
  case ATOM:    b_SetFail();    break;
  case INT:
    b_IfZero(reg) {
      b_SetFail();
    } else {
      b_SetSuccess();
    }
    break;
  default:
    b_SetSuccess();
  }
  b_IfSuccess()
}

#CTRL_define f_IfNotIntOrAtomZero(reg)
{
  TypeSwitch(reg) {
  case INT:    b_SetFail();    break;
  case ATOM:
    b_IfZero(reg) {
      b_SetFail();
    } else {
      b_SetSuccess();
    } break;
  default:
    b_SetSuccess();
  }
  b_IfSuccess()
}

/******************************************************************** PSL **
$B%9%Q%$%b!<%I$NH=Dj$H!"%9%Q%$%b!<%I$N%;%C%H(B

       written by imai@icot22      on Fri Dec 21 14:49:54 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  f_IfSpyMode() ($B<B9T;~$K(B) $B%9%Q%$%b!<%I$+$I$&$+$NH=Dj$r9T$J$&(B
	D_CurrentSpyId $B$N%?%$%W$,(B EOL (KL1$B$+$i@_Dj$G$-$J$$%?%$%W(B)
	$B$+$I$&$+$N%A%'%C%/(B
  f_ResetSpyMode (suspend, proceed $B$J$I$N;~$K(B)
	$B%9%Q%$%b!<%I$r%/%j%"$9$k!JDL>o<B9T%b!<%I$K$9$k!K(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#CTRL_define f_IfSpyMode()
{
  p_IfTypeNEImmediate(D_CurrentSpyId,EOL)
}

#PSL_define f_ResetSpyMode()
{
  p_MoveWord(D_NULL,D_CurrentSpyId);
}


/******************************************************************** PSL **
enqueue $B$7$h$&$H$7$F$$$k%4!<%k$,!"%9%Q%$BP>]%4!<%k$+$I$&$+$N%A%'%C%/(B

       written by imai@icot22      on Fri Dec 21 13:38:29 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  $B%9%Q%$BP>]%4!<%k$+$I$&$+$N%A%'%C%/$O!"<!$N$h$&$J3,AX$K$h$C$F(B
  $B<B8=$5$l$k!#(B

  f_IfSpiedGoal (interpreter$B%l%Y%k$+$i8F$V(B)
  PIM/p $B$N$h$&$J%^%7%s$X$N<BAu$r9MN8$7!"%5%V%k!<%A%s$N8F$S=P$7$H!"(B
  $B4JC1$JHf3S$@$1$K$7$F$$$k(B
  -->  f_CheckGoalIsSpiedGoal_Sub
       $B%U%)!<%/$7$h$&$H$7$F$$$k%4!<%k$N(B COD $B%]%$%s%?$r85$K!"(B
       $B%b%8%e!<%k$NCf?H$rFI$s$G!"%b%8%e!<%kL>%"%H%`!"=R8lL>%"%H%`!"(B
       $B%"%j%F%#$N#3MWAG$r$H$C$F$/$k!#(B
       $B4D6-%l%3!<%I$+$i!"%9%Q%$%3!<%I%Y%/%?$r$H$C$F$/$k!#(B
       --> f_SearchInSpiedCodeVector
	    $B%k!<%W$K$h$C$F!"%9%Q%$%3!<%I%Y%/%?$NCf?H$rD4$Y$k(B
	    --> f_MatchTestOnePairSpiedCodeVect
	        $B%9%Q%$%3!<%I%Y%/%?Cf$N#1$D$N%Z%"!J#3MWAG!K$K$D$$$F!"(B
		$B8=:_%U%)!<%/$7$h$&$H$7$F$$$k%4!<%k$N%b%8%e!<%kL>%"%H%`!"(B
		$B=R8lL>%"%H%`!"%"%j%F%#$H$NHf3S$r9T$J$&(B
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkResult XXX

#CTRL_define f_IfSpiedGoal(ptr_to_gr)
{
  $USE(D_WorkCodePtr);
  s_GetCodeGoalRecord(ptr_to_gr,D_WorkCodePtr);
  $USE(D_WorkResult);
  $CALL(f_CheckGoalIsSpiedGoal_Sub(D_WorkCodePtr,D_WorkResult));
  p_Compare(D_WorkResult,D_NULL);
  $RELEASE(D_WorkResult);
  $RELEASE(D_WorkCodePtr);
  p_IfEQ()
}

#CTRL_define f_IfSpiedCode(code_reg)
{
  $USE(D_WorkResult);
  $CALL(f_CheckGoalIsSpiedGoal_Sub(code_reg,D_WorkResult));
  p_Compare(D_WorkResult,D_NULL);
  $RELEASE(D_WorkResult);
  p_IfEQ()
}

#SUBARG_define	A_CodeReg	SRC
#SUBARG_define	A_ResultReg	DST

#SUBROUTINE f_CheckGoalIsSpiedGoal_Sub(A_CodeReg,A_ResultReg)
{
  @DEBUG{
    p_IfTypeNEImmediate(D_CurrentEnvRecPtr,_SPY_ENV_REC_TYPE) {
      VPIM_ERROR("f_SheckGoalIsSpiedGoal_Sub",
		 "Illegal Invoke (because of the type of D_CurrentEnvRecPtr)");
    }
  };
  $USE(D_WorkCurrentModName);
  $USE(D_WorkCurrentPredName);
  $USE(D_WorkCurrentPredArity);
  s_GetModNameFromCode(A_CodeReg,D_WorkCurrentModName);
  s_GetPredNameFromCode(A_CodeReg,D_WorkCurrentPredName);
  s_GetPredArityFromCode(A_CodeReg,D_WorkCurrentPredArity);
  f_SearchInSpiedCodeVector(D_WorkCurrentModName,
			    D_WorkCurrentPredName,
			    D_WorkCurrentPredArity,
			    D_CurrentSpiedCodeVect,
			    A_ResultReg);
  $RELEASE(D_WorkCurrentPredArity);
  $RELEASE(D_WorkCurrentPredName);
  $RELEASE(D_WorkCurrentModName);
  $RETURN();
}

#PSL_define f_SearchInSpiedCodeVector
	(mod_name, pred_name, pred_arity, spied_code_vect, dst_result)
{
  $USE(D_WorkSize);
  s_GetSizeVectType(spied_code_vect,D_WorkSize);
  $USE(D_WorkPos);
  b_SetZero(D_WorkPos);
  LOOP() {
    b_IfGreaterEq(D_WorkPos,D_WorkSize) {
      /*-- $B:G8e$^$G%A%'%C%/$7$?$1$I!"7k6I%^%C%A$9$k$b$N$,$J$+$C$?(B --*/
      p_MoveWord(D_ALL1,dst_result);
      break;
    }
    f_MatchTestOnePairSpiedCodeVect
      (D_WorkPos,spied_code_vect,mod_name,pred_name,pred_arity,dst_result);
    b_IfEqual(dst_result,D_NULL) {
      /*-- $B$3$N%Z%"$G%^%C%A$7$?(B --*/
      break;
    }
    b_AddImmediateWithTag
      (D_WorkPos,_PAIR_ELEMENTS_OF_SPIED_CODE_VECT,D_WorkPos);
  }
  $RELEASE(D_WorkPos);
  $RELEASE(D_WorkSize);
}

#PSL_define f_MatchTestOnePairSpiedCodeVect
	(position,spied_code_vect,mod_name,pred_name,pred_arity,dst_result)
{
  $USE(D_WorkElement);
  $USE(D_WorkElemPos);
  p_MoveWord(position,D_WorkElemPos);
  s_GetVectElementPosReg(spied_code_vect,D_WorkElemPos,D_WorkElement);

 Check_Module_Name:
  b_IfTypeValueEq(D_WorkElement,mod_name) { goto Check_Pred_Name; }
  s_IfINT(D_WorkElement) {
    b_IfZero(D_WorkElement) { goto Check_Pred_Name; }
  }
  goto Fail_End;
 Check_Pred_Name:
  b_IncrementReg(D_WorkElemPos);
  s_GetVectElementPosReg(spied_code_vect,D_WorkElemPos,D_WorkElement);
  b_IfTypeValueEq(D_WorkElement,pred_name) { goto Check_Arity; }
  s_IfINT(D_WorkElement) {
    b_IfZero(D_WorkElement) { goto Check_Arity; }
  }
  goto Fail_End;
 Check_Arity:
  b_IncrementReg(D_WorkElemPos);
  s_GetVectElementPosReg(spied_code_vect,D_WorkElemPos,D_WorkElement);
  b_IfTypeValueEq(D_WorkElement,pred_arity) { goto OK_End; }
  s_IfATOM(D_WorkElement) {
    b_IfZero(D_WorkElement) { goto OK_End; }
  }
  goto Fail_End;
 OK_End:
  p_MoveWord(D_NULL,dst_result);
  goto End;
 Fail_End:
  p_MoveWord(D_ALL1,dst_result);
 End:
  $RELEASE(D_WorkElemPos);
  $RELEASE(D_WorkElement);
}

/******************************************************************** PSL **
 $B%9%Q%$Nc30$NJs9p(B
       written by imai@icot22      on Fri Dec 21 15:01:36 1990

 $B%9%Q%$Nc30$,Js9p$5$l$k$N$O!"(B
  enqueue, execute, execute_self $B$+$i8F$P$l$k(B
	$BDL>o%4!<%k(B
  enqueue_with_priority $B$+$i8F$P$l$k(B
	$B%W%i%$%*%j%F%#$D$-%4!<%k(B
  enqueue_to_cluster, enqueue_to_processor, enqueue_to_node $B$+$i8F$P$l$k(B
	$B9T$-@h;XDj%4!<%k(B
 $B$N#3DL$j$G$"$k!#(B

********************************************************************* PSL **/

#DATA_define D_WorkSpyInfoVector	XXX

/******************************************************************** PSL **

  klb_enqueue, klb_execute $B$+$i8F$P$l$k%9%Q%$Nc30$N%H%C%W%l%Y%k(B

       written by imai@icot22      on Fri Dec 21 16:15:08 1990
<Arguments>
  imm_instr_id : KL1-B $B$N%$%s%9%H%i%/%7%g%s#I#D(B (ENQUEUE, EXECUTE... etc.)
  goal_ptr     : ($B%9%Q%$BP>]$G$"$C$?(B) $B%U%)!<%/$7$h$&$H$7$?(B
		 $B%4!<%k%l%3!<%I$X$N%]%$%s%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
  $B%9%Q%$BP>]%4!<%k$G$"$k$3$H$,3NG'$5$l$F$$$k$3$H(B
<Function>
 { CLandPEnum, SpyID, { KL1Bopcode, Code, ArgV }, Module, Offset}
  $B$N7A$N%Y%/%?$r(B Info $B$H$9$kNc30%Y%/%?$r:n$j!"(B  $BJs9p$9$k(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define f_ReportSpyExceptionNormalGoal(imm_instr_id, goal_ptr)
{
  $USE(D_WorkInstrId);
  b_SetImmTypeValueMRBoff(INT,imm_instr_id,D_WorkInstrId);
  @DEBUG{ b_IfLess(D_WorkInstrId,D_NULL) {
    VPIM_ERROR("f_ReportSpyExceptionNormalGoal","Negative InstrID");
  }};
  $CALL( f_ReportSpyExceptionNormalGoal_Sub(D_WorkInstrId, goal_ptr));
  $RELEASE(D_WorkInstrId);
}

#SUBARG_define A_InstrId	SRC
#SUBARG_define A_GoalPtr	MODIFY

#SUBROUTINE f_ReportSpyExceptionNormalGoal_Sub(A_InstrId,A_GoalPtr)
{
  $USE(D_WorkCodePtr);
  s_GetCodeGoalRecord(A_GoalPtr,D_WorkCodePtr);
  $USE(D_WorkSpyInfoVector);
  f_CreateSpyInfoVectorNormalGoal
    (D_WorkSpyInfoVector, A_InstrId, A_GoalPtr,D_WorkCodePtr);
  $RELEASE(D_WorkCodePtr);
  $USE(D_WorkModule); $USE(D_WorkOfst);
  s_GetModuleTopAndOffsetFromPC(D_KLB_PC,D_WorkModule,D_WorkOfst);
  $CALL(f_ReportSpyException_Sub
	(A_InstrId, D_WorkSpyInfoVector, D_WorkModule, D_WorkOfst));
  $RELEASE(D_WorkOfst);
  $RELEASE(D_WorkModule);
  $RELEASE(D_WorkSpyInfoVector);
  $RETURN();
}

#PSL_define f_CreateSpyInfoVectorNormalGoal
	(dst_info_vect, instr_id_reg, goal_ptr, code_reg)
{
  s_AllocVect3(dst_info_vect);
  s_PutVectElementImmOfst(dst_info_vect,_ELEM1_OFST_VECT,instr_id_reg);
  s_PutVectElementImmOfst(dst_info_vect,_ELEM2_OFST_VECT,code_reg);
  $USE(D_WorkArgVect);
  f_GetArgVectFromGoalRecord(D_WorkArgVect,goal_ptr);
  s_PutVectElementImmOfst(dst_info_vect,_ELEM3_OFST_VECT,D_WorkArgVect);
  $RELEASE(D_WorkArgVect);
  s_ReclaimGoalRecord(goal_ptr);
}


/******************************************************************** PSL **

  klb_enqueue_with_priority $B$+$i8F$P$l$k%9%Q%$Nc30$N%H%C%W%l%Y%k(B

       written by imai@icot22      on Fri Dec 21 16:15:33 1990
<Arguments>
  imm_instr_id : KL1-B $B$N%$%s%9%H%i%/%7%g%s#I#D(B (ENQUEUE_WITH_PRIORITY)
  goal_ptr     : ($B%9%Q%$BP>]$G$"$C$?(B) $B%U%)!<%/$7$h$&$H$7$?(B
		 $B%4!<%k%l%3!<%I$X$N%]%$%s%?(B
  prio	       : $B%U%)!<%/$7$h$&$H$7$?%4!<%k$N!JO@M}!K%W%i%$%*%j%F%#(B
<Temporally Used Variables>
<Level>
<PreCondition>
  $B%9%Q%$BP>]%4!<%k$G$"$k$3$H$,3NG'$5$l$F$$$k$3$H(B
<Function>
 { CLandPEnum, SpyID, { KL1Bopcode, Code, ArgV, Prio }, Module, Offset}
  $B$N7A$N%Y%/%?$r(B Info $B$H$9$kNc30%Y%/%?$r:n$j!"(B  $BJs9p$9$k(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define f_ReportSpyExceptionPrioGoal(imm_instr_id, goal_ptr, prio)
{
  $USE(D_WorkInstrId);
  b_SetImmTypeValueMRBoff(INT,imm_instr_id,D_WorkInstrId);
  $CALL( f_ReportSpyExceptionPrioGoal_Sub(D_WorkInstrId, goal_ptr, prio));
  $RELEASE(D_WorkInstrId);
}

#SUBARG_define A_InstrId	SRC
#SUBARG_define A_GoalPtr	MODIFY
#SUBARG_define A_Prio		SRC

#SUBROUTINE f_ReportSpyExceptionPrioGoal_Sub(A_InstrId,A_GoalPtr,A_Prio)
{
  $USE(D_WorkCodePtr);
  s_GetCodeGoalRecord(A_GoalPtr,D_WorkCodePtr);
  $USE(D_WorkSpyInfoVector);
  f_CreateSpyInfoVectorPrioGoal
    (D_WorkSpyInfoVector, A_InstrId, A_GoalPtr,D_WorkCodePtr,A_Prio);
  $RELEASE(D_WorkCodePtr);
  $USE(D_WorkModule); $USE(D_WorkOfst);
  s_GetModuleTopAndOffsetFromPC(D_KLB_PC,D_WorkModule,D_WorkOfst);
  $CALL(f_ReportSpyException_Sub
	(A_InstrId, D_WorkSpyInfoVector, D_WorkModule, D_WorkOfst));
  $RELEASE(D_WorkOfst);
  $RELEASE(D_WorkModule);
  $RELEASE(D_WorkSpyInfoVector);
  $RETURN();
}

#PSL_define f_CreateSpyInfoVectorPrioGoal
	(dst_info_vect, instr_id_reg, goal_ptr, code_reg, prio_reg)
{
  s_AllocVect4(dst_info_vect);
  s_PutVectElementImmOfst(dst_info_vect,_ELEM1_OFST_VECT,instr_id_reg);
  s_PutVectElementImmOfst(dst_info_vect,_ELEM2_OFST_VECT,code_reg);
  $USE(D_WorkArgVect);
  f_GetArgVectFromGoalRecord(D_WorkArgVect,goal_ptr);
  s_PutVectElementImmOfst(dst_info_vect,_ELEM3_OFST_VECT,D_WorkArgVect);
  $RELEASE(D_WorkArgVect);
  s_PutVectElementImmOfst(dst_info_vect,_ELEM4_OFST_VECT,prio_reg);
  s_ReclaimGoalRecord(goal_ptr);
}

/******************************************************************** PSL **

  klb_enqueue_to_node
  klb_enqueue_to_cluster
  klb_enqueue_to_processor
	$B$+$i8F$P$l$k%9%Q%$Nc30$N%H%C%W%l%Y%k(B

       written by imai@icot22      on Fri Dec 21 16:16:47 1990
<Arguments>
  imm_instr_id : KL1-B $B$N%$%s%9%H%i%/%7%g%s#I#D(B (ENQUEUE, EXECUTE... etc.)
  goal_ptr     : ($B%9%Q%$BP>]$G$"$C$?(B) $B%U%)!<%/$7$h$&$H$7$?(B
		 $B%4!<%k%l%3!<%I$X$N%]%$%s%?(B
  destination  : $B%U%)!<%/$7$h$&$H$7$?%4!<%k$N9T$-@h!J#P#E!?%/%i%9%?!KHV9f(B

<Temporally Used Variables>
<Level>
<PreCondition>
  $B%9%Q%$BP>]%4!<%k$G$"$k$3$H$,3NG'$5$l$F$$$k$3$H(B
<Function>
 { CLandPEnum, SpyID, { KL1Bopcode, Code, ArgV, Destination }, Module, Offset}
  $B$N7A$N%Y%/%?$r(B Info $B$H$9$kNc30%Y%/%?$r:n$j!"(B  $BJs9p$9$k(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define f_ReportSpyExceptionThrowGoalFamily
	(imm_instr_id, goal_ptr, destination)
{
  $USE(D_WorkInstrId);
  b_SetImmTypeValueMRBoff(INT,imm_instr_id,D_WorkInstrId);
  $CALL( f_ReportSpyExceptionThrowGoalFamily_Sub
	(D_WorkInstrId, goal_ptr, destination));
  $RELEASE(D_WorkInstrId);
}

#SUBARG_define A_InstrId	SRC
#SUBARG_define A_GoalPtr	MODIFY
#SUBARG_define A_Destination		SRC

#SUBROUTINE f_ReportSpyExceptionThrowGoalFamily_Sub
	(A_InstrId,A_GoalPtr,A_Destination)
{
  $USE(D_WorkCodePtr);
  s_GetCodeGoalRecord(A_GoalPtr,D_WorkCodePtr);
  $USE(D_WorkSpyInfoVector);
  f_CreateSpyInfoVectorThrowGoalFamily
    (D_WorkSpyInfoVector, A_InstrId, A_GoalPtr,D_WorkCodePtr,A_Destination);
  $RELEASE(D_WorkCodePtr);
  $USE(D_WorkModule); $USE(D_WorkOfst);
  s_GetModuleTopAndOffsetFromPC(D_KLB_PC,D_WorkModule,D_WorkOfst);
  $CALL(f_ReportSpyException_Sub
	(A_InstrId, D_WorkSpyInfoVector, D_WorkModule, D_WorkOfst));
  $RELEASE(D_WorkOfst);
  $RELEASE(D_WorkModule);
  $RELEASE(D_WorkSpyInfoVector);
  $RETURN();
}

#PSL_define f_CreateSpyInfoVectorThrowGoalFamily
	(dst_info_vect, instr_id_reg, goal_ptr, code_reg, destination)
{
  s_AllocVect4(dst_info_vect);
  s_PutVectElementImmOfst(dst_info_vect,_ELEM1_OFST_VECT,instr_id_reg);
  s_PutVectElementImmOfst(dst_info_vect,_ELEM2_OFST_VECT,code_reg);
  $USE(D_WorkArgVect);
  f_GetArgVectFromGoalRecord(D_WorkArgVect,goal_ptr);
  s_PutVectElementImmOfst(dst_info_vect,_ELEM3_OFST_VECT,D_WorkArgVect);
  $RELEASE(D_WorkArgVect);
  s_PutVectElementImmOfst(dst_info_vect,_ELEM4_OFST_VECT,destination);
  s_ReclaimGoalRecord(goal_ptr);
}

/******************************************************************** PSL **
  $B%\%G%#AH$_9~$_=R8l$N%9%Q%$Nc30(B

       written by imai@icot22      on Fri Jan 11 13:53:52 1991
<Arguments>
  imm_instr_id : KL1-B $B$N%$%s%9%H%i%/%7%g%s#I#D(B (ENQUEUE, EXECUTE... etc.)
  argv_reg: $B!JM=$a:n@.$7$?!K%\%G%#AH$_9~$_=R8l0z?t$r%Y%/%?$K$^$H$a$?$b$N(B
<Temporally Used Variables>
<Level>
<PreCondition>
  $B%9%Q%$%b!<%I$G<B9TCf$G$"$k$3$H(B
<Function>
 { CLandPEnum, SpyID, { KL1Bopcode, ArgV }, Module, Offset}
  $B$N7A$N%Y%/%?$r(B Info $B$H$9$kNc30%Y%/%?$r:n$j!"Js9p$9$k(B
<Examples>
<Test>
<Explanation>
  apply_tracing, apply_spying, create_shoen $B$O!"(B
  $B%9%Q%$%b!<%I$N;~$K$O>o$K%9%Q%$Nc30$rH/@8$9$k!#(B

  apply $B$O!"$=$l$K$h$C$F@8@.$5$l$k%5%V%4!<%k$,%9%Q%$BP>]$G$"$l$P(B
  $B%9%Q%$Nc30$rH/@8$9$k!#(B

  $B$=$l0J30$N%\%G%#AH$_9~$_=R8l$O!"%9%Q%$Nc30$OH/@8$7$J$$!#(B
<ETC>
********************************************************************* PSL **/

#PSL_define f_ReportSpyExceptionBuiltin(imm_instr_id, argv_reg)
{
  $USE(D_WorkInstrId);
  b_SetImmTypeValueMRBoff(INT,imm_instr_id,D_WorkInstrId);
  $CALL(f_ReportSpyExceptionBuiltin_Sub(D_WorkInstrId, argv_reg));
  $RELEASE(D_WorkInstrId);
}

#SUBARG_define A_InstrId	SRC
#SUBARG_define A_Argv		SRC

#SUBROUTINE f_ReportSpyExceptionBuiltin_Sub(A_InstrId,A_Argv)
{
  $USE(D_WorkSpyInfoVector);
  f_CreateSpyInfoVectorBuiltin(D_WorkSpyInfoVector, A_InstrId, A_Argv);
  $USE(D_WorkModule); $USE(D_WorkOfst);
  s_GetModuleTopAndOffsetFromPC(D_KLB_PC,D_WorkModule,D_WorkOfst);
  $CALL(f_ReportSpyException_Sub
	(A_InstrId, D_WorkSpyInfoVector, D_WorkModule, D_WorkOfst));
  $RELEASE(D_WorkOfst);
  $RELEASE(D_WorkModule);
  $RELEASE(D_WorkSpyInfoVector);
  $RETURN();
}

#PSL_define f_CreateSpyInfoVectorBuiltin(dst_info_vect, instr_id_reg, argv)
{
  s_AllocVect2(dst_info_vect);
  s_PutVectElementImmOfst(dst_info_vect,_ELEM1_OFST_VECT,instr_id_reg);
  s_PutVectElementImmOfst(dst_info_vect,_ELEM2_OFST_VECT,argv);
}

/******************************************************************** PSL **
  $B%9%Q%$Nc30$NJs9p(B
       written by imai@icot22      on Fri Dec 21 16:19:04 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
  f_reduce_exception_handler.psl.c $B$K0z1[$7$9$Y$-$+!)!)(B
********************************************************************* PSL **/

#SUBARG_define A_InstrId	SRC
#SUBARG_define A_SpyInfoVector	SRC
#SUBARG_define A_Module		SRC
#SUBARG_define A_OfstInModule	SRC

#SUBROUTINE f_ReportSpyException_Sub
	(A_InstrId, A_SpyInfoVector, A_Module, A_OfstInModule)
{
  $USE(D_WorkNewCode); 
  $USE(D_WorkNewArgv);

  s_AllocVariable(D_WorkNewCode); 
  s_AllocVariable(D_WorkNewArgv);
        /* $BBe$o$j$K<B9T$5$l$k%4!<%k$rF~$l$kJQ?t$r:n$k(B */

  f_DcodeEnqueue2OpeWithoutParentInfo_II
    (BLT_B_APPLY, D_WorkNewCode, D_WorkNewArgv);

  $USE(D_WorkExcepInfoVect);
  f_MakeExcpArgVect( _FIVE, D_WorkExcepInfoVect);
                   /* Spy Exception $B$K4X$9$k>pJs$r!"%Y%/%?$KF~$l$k(B */
  f_Put5ArgsArgVect(D_WorkExcepInfoVect,
		    D_ExceptionProcId,
		    D_CurrentSpyId,
		    A_SpyInfoVector,
		    A_Module,
		    A_OfstInModule);

  $USE(D_WorkExceptionTag);  /* !! $BDI2C(B */
  $USE(D_WorkExceptionNumber);
  b_SetImmValueDNTC(_TRACE_EXCP, D_WorkExceptionNumber);
  /*--- $BNc30HV9f$O!"%H%l!<%9$HF1$8$b$N$r;HMQ$9$k(B ---*/

  /* !! $BDI2C(B */
  f_ConvertExceptionNumberToTag(D_WorkExceptionNumber, D_WorkExceptionTag);

  $CALL(f_Send_IntClMsg_Exception_Sub(D_WorkExceptionTag, /* !! $BDI2C(B */
				      D_WorkExceptionNumber, 
				      D_WorkExcepInfoVect,
				      D_WorkNewCode,
				      D_WorkNewArgv,
				      D_Current_FP_Ptr) );

  $RELEASE(D_WorkExceptionTag);  /* !! $BDI2C(B */
  $RELEASE(D_WorkExceptionNumber);
  $RELEASE(D_WorkExcepInfoVect);
  $RELEASE(D_WorkNewCode);
  $RELEASE(D_WorkNewArgv); 
  $RETURN();
}


/******************************************************************** PSL **
  $B%9%Q%$%b!<%I$N;~$N!"(Benqueue_to_cluster $B$+$i8F$P$l$k=hM}(B
       written by imai@icot22      on Tue Dec 25 21:10:08 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkID XXX

#SUBARG_define A_CLNum	SRC
#SUBARG_define A_Goal	MODIFY

#SUBROUTINE f_SendGoalWithSpyMode_Sub (A_CLNum, A_Goal)
{
  $USE(D_WorkArgVect); $USE(D_WorkCodeAddress);
  s_GetCodeGoalRecord(A_Goal, D_WorkCodeAddress);
  f_GetArgVectFromGoalRecord(D_WorkArgVect,A_Goal);
  $USE(D_WorkDcodeaddr);
  f_GetDcodeAddress(DCODE_ENQUEUE_CLUSTER_WITH_SPY_MODE,D_WorkDcodeaddr);

  $USE(D_WorkEnvRecPtr);
  s_GetEnvRecGoalRecord(A_Goal,D_WorkEnvRecPtr);
  $USE(D_WorkSpyInfoVector);
  $USE(D_WorkID);
  s_GetSpyIdEnvRecord(D_WorkEnvRecPtr,D_WorkID);
  /* Info Vector $B$r9u$/$7$F$*$+$J$$$HM"=P$N;~IT6q9g$,5/$3$k(B */
  s_GetSpyTablePtrEnvRecordWithMark(D_WorkEnvRecPtr,D_WorkSpyInfoVector);
  $RELEASE(D_WorkEnvRecPtr);
  $CALL( f_DcodeEnqueue5OperandWithoutParentInfo_Sub
	(D_WorkDcodeaddr,A_CLNum,D_WorkCodeAddress,
	 D_WorkArgVect,D_WorkSpyInfoVector,D_WorkID));
  s_ReclaimGoalRecord( A_Goal );
          /* Reclaim$B$5$l$?(Bgoal$B$NJ,(B */
  s_DecrementForkCounter();
  $RELEASE(D_WorkDcodeaddr);  $RELEASE(D_WorkCodeAddress);
  $RELEASE(D_WorkArgVect);  $RELEASE(D_WorkSpyInfoVector);
  $RELEASE(D_WorkID);
  $RETURN();
}
