
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_reduce_processor_profiler.psl.c
   ----- CREATED   : by imai@icot22, on Fri Aug  2 11:44:51 1991
   ----- LAST SAVED: by imai@ss-pimp2, on Thu Jun 18 16:59:06 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : 
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

#DATA_define	D_WorkProcessorProfilerFlag	XXX

/******************************************************************** PSL **
  $B=i4|2=(B
       written by imai@icot22      on Sat Aug 24 13:08:09 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define f_InitProcessorProfile()
{
  s_InitMeasurementRecPointerArea();
  s_InitializeProcessorProfilerMainSwitch();
  @DEBUG{
    s_MRBoffReg(D_MsgEncodeStartTime);
    s_MRBoffReg(D_MsgDecodeStartTime);
  };
}

/******************************************************************** PSL **
f_DoProcessorProfile_Sub

       written by imai@icot22      on Tue Aug  6 15:59:38 1991
<Arguments>
 A_NextVect (SRC): $BM?$($k%W%m%U%!%$%k%Y%/%?(B	($B%G%l%U%!%l%s%9:Q(B)
 A_CurrentVect (DST) : $BJV$C$F$/$k%W%m%U%!%$%k%Y%/%?(B
 A_Result (DST): A_NextVect $B$,IT@5F~NO$N>l9g(B $B%?%$%W$K(B EOL $B$rJV$9(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#SUBARG_define A_NextVect SRC
#SUBARG_define A_CurrentVect DST
#SUBARG_define A_Result DST

#SUBROUTINE f_DoProcessorProfileBuiltin_Sub
	( A_NextVect, A_CurrentVect, A_Result )
{
  @DEBUG{
    s_IfNotVectors( A_NextVect ) {
      VPIM_ERROR("f_DoProcessorProfileBuiltin_Sub","Not Vectors!!");
    }
  };
  TypeSwitch(A_NextVect) {
  case VECT0:	/* OKEY */
    s_SetProperInputProcessorProfile(A_Result);
    s_InitMeasurementRecTempArea();
    break;
  case ShortVectorGrp():
    $USE(D_WorkElemPos); $USE(D_WorkProfVectElm);
    s_GetSizeVectType(A_NextVect,D_WorkElemPos);
    b_IfGreaterImm(D_WorkElemPos,_MAX_ELEMENTS_PROFILE_VECT) {
      s_SetRangeOverflowProcessorProfile(A_Result);
      $RETURN();
    }
    s_InitMeasurementRecTempArea();
    LOOP() {
      b_DecrementReg(D_WorkElemPos);
      f_GetVectElementWithDeref(A_NextVect, D_WorkElemPos, D_WorkProfVectElm);
    /* $B#1F~NO$r%A%'%C%/$7!"NI$1$l$P!"%a%8%c!<%a%s%H%l%3!<%I$r!"(B
       $B%F%s%]%i%j!<NN0h$KCV$/(B */
      $CALL(f_CheckProfileVectElmAndConnectTempArea_Sub
	    (D_WorkElemPos, D_WorkProfVectElm, A_Result));
      s_IfNotProperInputProcessorProfile(A_Result) {
	/* $B%W%m%U%!%$%k%Y%/%?$NCf$K!"IT@5F~NO(B or $BL$Dj5A$,$"$C$?(B */
	$RELEASE(D_WorkElemPos); $RELEASE(D_WorkProfVectElm); $RETURN();
      }
      b_IfZero(D_WorkElemPos) { break; }
    }
    $RELEASE(D_WorkElemPos); $RELEASE(D_WorkProfVectElm);
    break;
  default:
    @DEBUG{VPIM_ERROR("f_DoProcessorProfileBuiltin_Sub",
		      "Illegal Type A_NextVect");};
  }

  $CALL(f_MakeWhiteMeasurementRecordOnTempArea_Sub(A_Result));
  s_IfNotProperInputProcessorProfile(A_Result) {
    /* $BF~NO$K(B MRB on $B$N%9%H%j%s%0!?%Y%/%?$,$"$j!"$3$l$HF1$8$b$N$r(B
	$B%3%T!<$7$h$&$H$7$?$i!"%a%b%jITB-$r@8$8$?(B */
    $RETURN();
  }

  /* $B%F%s%]%i%j!<NN0h$K$*$$$?!"%a%8%c!<%a%s%H%l%3!<%I$r!"@55,$N0LCV$KCV$/(B */
  $CALL(f_ReplaceMeasuremetRecordAndCreateCurrentVect_Sub(A_CurrentVect));
  /* $B%a%8%c!<%a%s%H%l%3!<%I$K$h$j!"%W%m%U%!%$%k$N3+;O!?=*N;$r9T$J$&(B */
  f_StartOrStopProcessorProfile(A_NextVect);
  s_IfMRBoff(A_NextVect) {
    s_IfNotVECT0(A_NextVect) {
      s_ReclaimShortVector(A_NextVect);
    }
  }
  $RETURN();
}

/******************************************************************** PSL **

       written by imai@icot22      on Tue Aug  6 16:18:20 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $BF~NO%Y%/%?$N3FMWAG$,!"IT@5F~NO$G$"$k$+$I$&$+$r8!::$7!"@5$7$1$l$P(B
  $B2>NN0h$K7R$0!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#SUBARG_define A_ElemPos	SRC
#SUBARG_define A_VectElem	MODIFY
#SUBARG_define A_Result		DST

#SUBROUTINE f_CheckProfileVectElmAndConnectTempArea_Sub
	(A_ElemPos, A_VectElem, A_Result)
{
  ValueSwitch(A_ElemPos) {
  case _IDLE_TIME_ELEM_POS_PROFILE_VECT:
    /* (0) $B%"%$%I%k;~4V(B			--- $B%W%m%;%C%5Kh(B (String) --- */
    f_CheckProcessorwiseProfileVectElmAndConnectTempArea
      (A_ElemPos, A_VectElem, A_Result, STRG,
       _IDLE_TIME_MEASUREMENT_REC_ELMS_MIN,
       _IDLE_TIME_MEASUREMENT_REC_ELMS_MAX);
    break;
  case _GEVC_ELEM_POS_PROFILE_VECT:
    /* (1) GEVC				--- NOP --- */
    @DEBUG{
      s_IfNotINT(A_VectElem) {
	WARNING("f_CheckProfileVectElmAndConnectTempArea",
		"Measurement Record is connected to GEVC field (nop)");
      }
    };
    /* $B<B:]!"!{$J$i2s<}$G$-$k$,!"$A$g$C$HLLE]$J$N$G%Q%9(B */
    s_SetProperInputProcessorProfile(A_Result);
    break;
  case _MSG_SEND_FREQ_ELEM_POS_PROFILE_VECT:
    /* (2) $B%a%C%;!<%8Aw?.IQEY(B		--- $B%W%m%;%C%5Kh(B (String) --- */
    f_CheckProcessorwiseProfileVectElmAndConnectTempArea
      (A_ElemPos, A_VectElem, A_Result, STRG,
       _MSG_SEND_FREQ_MEASUREMENT_REC_ELMS_MIN,
       _MSG_SEND_FREQ_MEASUREMENT_REC_ELMS_MAX);
    break;
  case _MSG_RECV_FREQ_ELEM_POS_PROFILE_VECT:
    /* (3) $B%a%C%;!<%8<u?.IQEY(B		--- $B%W%m%;%C%5Kh(B (String) --- */
    f_CheckProcessorwiseProfileVectElmAndConnectTempArea
      (A_ElemPos, A_VectElem, A_Result,  STRG,
       _MSG_RECV_FREQ_MEASUREMENT_REC_ELMS_MIN,
       _MSG_RECV_FREQ_MEASUREMENT_REC_ELMS_MAX);
    break;
  case _LOCAL_GC_ELEM_POS_PROFILE_VECT:
    /* (4) GC				--- $B%/%i%9%?Kh(B (String) --- */
    f_CheckClusterwiseProfileVectElmAndConnectTempArea
      (A_ElemPos, A_VectElem, A_Result, 
       _LOCAL_GC_MEASUREMENT_REC_ELMS_MIN,
       _LOCAL_GC_MEASUREMENT_REC_ELMS_MAX);
    break;
  case _LOG_EVENT_ELEM_POS_PROFILE_VECT:
    /* (5) $B%m%0%$%Y%s%H(B			--- $B%W%m%;%C%5Kh(B (Vector) --- */
    f_CheckProcessorwiseProfileVectElmAndConnectTempArea
      (A_ElemPos, A_VectElem, A_Result, VECT,
       _LOG_EVENT_MEASUREMENT_REC_ELMS_MIN,
       _LOG_EVENT_MEASUREMENT_REC_ELMS_MAX);
    break;
  case _MSG_ENC_DEC_TIME_ELEM_POS_PROFILE_VECT:
    /* (6) $B%a%C%;!<%8=hM};~4V(B		--- $B%W%m%;%C%5Kh(B (String) --- */
    f_CheckProcessorwiseProfileVectElmAndConnectTempArea
      (A_ElemPos, A_VectElem, A_Result, STRG,
       _MSG_ENC_DEC_TIME_MEASUREMENT_REC_ELMS_MIN,
       _MSG_ENC_DEC_TIME_MEASUREMENT_REC_ELMS_MAX);
    break;
  default:
    @DEBUG{ VPIM_ERROR("f_CheckProfileVectElmAndConnectTempArea",
		       "Illegal Element Position");};
  }
  $RETURN();
}

/******************************************************************** PSL **

       written by imai@icot22      on Tue Aug 27 14:41:46 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B%W%m%;%C%5Kh$K7WB,$9$k9`L\$N!"F~NO%A%'%C%/(B
<Examples>
<Test>
<Explanation>
  vect_elm $B$O!"%9%H%j%s%0(B/$B%Y%/%?(B/$B@0?t#0$N$$$:$l$+$r4|BT$7$F$$$k!#(B
<ETC>
********************************************************************* PSL **/


#PSL_define f_CheckProcessorwiseProfileVectElmAndConnectTempArea
	(elm_pos, vect_elm, dst_result, imm_type_required,
	 imm_min_measurement_rec_size, imm_max_measurement_rec_size)
{
  $USE(D_WorkSize); $USE(D_WorkPENum);
  $USE(D_WorkPtrToMeasurementRec);

  TypeSwitch(vect_elm) {
  case REF:
    s_SetSuspentionInputProcessorProfile(dst_result);
    goto End;
  case ShortVectorGrp():
  case LongVectorGrp():
    /* (1) $B%/%i%9%?Fb%W%m%;%C%5Bf?t$H!"%Y%/%?MWAG?t$N%A%'%C%/(B */
    s_GetSizeVectType(vect_elm,D_WorkSize);
    b_ReadPENumInCluster(D_WorkPENum);
    b_IfNotEqual(D_WorkSize,D_WorkPENum) {
      goto Illegal_Input;
    }
    /* (2) $B3FMWAG$N%A%'%C%/(B */
    LOOP() {
      b_DecrementReg(D_WorkSize);
      f_GetVectElementWithDeref(vect_elm,D_WorkSize,D_WorkPtrToMeasurementRec);
      TypeSwitch(D_WorkPtrToMeasurementRec) {
      case ShortVectorGrp():
      case LongVectorGrp():
	$USE(D_WorkTypeCheckReg);
	b_SetImmTypeMRBoff(imm_type_required,D_WorkTypeCheckReg);
	s_IfVECT(D_WorkTypeCheckReg) {
	  $RELEASE(D_WorkTypeCheckReg);
	  $USE(D_WorkAllocSize);
	  s_GetSizeVectType(D_WorkPtrToMeasurementRec,D_WorkAllocSize);
	  b_IfRangeErr(D_WorkAllocSize,imm_min_measurement_rec_size,
		       imm_max_measurement_rec_size) {
	    $RELEASE(D_WorkAllocSize);
	    goto Illegal_Input;
	  }
	  $RELEASE(D_WorkAllocSize);
       } else {
	   $RELEASE(D_WorkTypeCheckReg);
	   goto Illegal_Input;
       }
	break;
      case STRG:
	$USE(D_WorkTypeCheckReg);
	b_SetImmTypeMRBoff(imm_type_required,D_WorkTypeCheckReg);
	s_IfSTRG(D_WorkTypeCheckReg) {
	  $RELEASE(D_WorkTypeCheckReg);
	  $USE(D_WorkAllocSize); $USE(D_WorkElemSize);
	  s_GetStringType
	    (D_WorkPtrToMeasurementRec,D_WorkAllocSize,D_WorkElemSize);
	  b_IfNotEqualImm(D_WorkElemSize,_ELEM_SIZE_OF_STRG32) {
	    /* 32 bit $B%9%H%j%s%0$G$O$J$+$C$?(B */
	    $RELEASE(D_WorkAllocSize);  $RELEASE(D_WorkElemSize);
	    goto Illegal_Input;
	  }
	  $RELEASE(D_WorkElemSize);
	  b_IfRangeErr(D_WorkAllocSize,imm_min_measurement_rec_size,
		       imm_max_measurement_rec_size) {
	    $RELEASE(D_WorkAllocSize);
	    goto Illegal_Input;
	  }
	  $RELEASE(D_WorkAllocSize);
	} else {
	  $RELEASE(D_WorkTypeCheckReg);
	  goto Illegal_Input;
	}
	break;
      case INT:
	b_IfNotZero(D_WorkPtrToMeasurementRec) {
	  goto Illegal_Input;
	}/* else  Okey */
	break;
      case REF:
	s_SetSuspentionInputProcessorProfile(dst_result);
	goto End;
      default:
	@DEBUG{
	  VPIM_ERROR("f_CheckProcessorwiseProfileVectElmAndConnectTempArea",
		     "Unbelievable!!");};
      }
      s_PutToMeasurementRecordTempArea
	  (elm_pos,D_WorkSize,D_WorkPtrToMeasurementRec);
      b_IfZero(D_WorkSize) { break; }
    } /* END of LOOP */
    break;
  default:
    goto Illegal_Input;
  }
  s_IfMRBoff(vect_elm) {
    TypeSwitch(vect_elm) {
    case ShortVectorGrp():
      s_ReclaimShortVector(vect_elm);
      break;
    case LongVectorGrp():
      $USE(D_WorkVectSize);
      s_GetSizeLongVect(vect_elm, D_WorkVectSize);
      s_ReclaimLongVector(D_WorkVectSize, vect_elm);
      $RELEASE(D_WorkVectSize);
      break;
    default:
      @DEBUG{ VPIM_ERROR("f_CheckProcessorwiseProfileVectElmAndConnectTempArea"
			 ,"Illegal-type");};
    }
  }
  s_SetProperInputProcessorProfile(dst_result);  goto End;
 Illegal_Input:
  s_SetIllegalInputProcessorProfile(dst_result); goto End;
 End:;
  $RELEASE(D_WorkPtrToMeasurementRec); 
  $RELEASE(D_WorkPENum);$RELEASE(D_WorkSize);
}

/******************************************************************** PSL **

       written by imai@icot22      on Mon Sep  9 10:56:58 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B%/%i%9%?Kh$K7WB,$9$k9`L\$N!"F~NO%A%'%C%/(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define  f_CheckClusterwiseProfileVectElmAndConnectTempArea
	(elm_pos, vect_elm, dst_result,
	 imm_min_measurement_rec_size, imm_max_measurement_rec_size)
{
  $USE(D_WorkElemSize); $USE(D_WorkAllocSize);

  /* 1. $B%9%H%j%s%0$+!)(B */
  s_IfNotSTRG(vect_elm) {
    s_IfINT(vect_elm) {
      /* INT!0 $B$J$i(B OK! */
      b_IfZero(vect_elm) {
	goto Check_Finished;
      } else {
	goto Illegal_Input;
      }
    }
    s_IfREF(vect_elm) {
      s_SetSuspentionInputProcessorProfile(dst_result);
      goto End;
    } else {
      goto Illegal_Input;
    }
  }
  s_GetStringType(vect_elm,D_WorkAllocSize,D_WorkElemSize);

  /* 2. 32 bit $B%9%H%j%s%0$+!)(B */
  b_IfNotEqualImm(D_WorkElemSize,_ELEM_SIZE_OF_STRG32) {
    goto Illegal_Input;
  }

  /* 3. $B%5%$%:$N:G>.8B!?:GBg8B%A%'%C%/(B */
  b_IfRangeErr(D_WorkAllocSize,
	       imm_min_measurement_rec_size,imm_max_measurement_rec_size) {
    goto Illegal_Input;
  }

 Check_Finished:
  /* 0 $BHV(B PE $B$N=j$r;H$&(B */
  s_PutToMeasurementRecordTempArea(elm_pos, D_NULL, vect_elm);
  s_SetProperInputProcessorProfile(dst_result);
  goto End;
 Illegal_Input:
  s_SetIllegalInputProcessorProfile(dst_result);
 End:
  $RELEASE(D_WorkAllocSize);$RELEASE(D_WorkElemSize);
}


/******************************************************************** PSL **

       written by imai@icot22      on Fri Aug 23 14:02:24 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  processor_profile/2 $BAH$_9~$_$K$h$j!"7WB,$N%a%$%s%9%$%C%A$,(B
	on --> off
  $B$"$k$$$O!"(B
	off --> on
  $B$K$J$k>l9g$K!"%/%i%9%?Fb$NB>$N(BPE$B$K>uBVJQ99$r%V%m!<%I%-%c%9%H$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define f_StartOrStopProcessorProfile(flag_reg)
{
  s_IfVECT0(flag_reg) {
    /* $B$3$l0J9_%a%$%s%9%$%C%A$O(B Off */
    s_IfProfileMainSwitchOn() {
      s_ProfileMainSwitchOff();
      s_BroadcastProcessorProfileSwitch();
    }
  } else {
    /* $B$3$l0J9_%a%$%s%9%$%C%A$O(B On */
    s_IfProfileMainSwitchOff() {
      s_ProfileMainSwitchOn();
      s_BroadcastProcessorProfileSwitch();
    }
  }
}

/******************************************************************** PSL **
  
       written by imai@icot22      on Mon Sep  9 10:59:31 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
  $BA4$F$NF~NO$,IT@5F~NO$G$J$$$3$H$N8!::$,=*$j!"2>NN0h$K$D$J$,$l$F$$$k$3$H(B
<Function>
  $B@55,NN0h$K7R$,$l$F$$$k%a%8%c!<%a%s%H%l%3!<%I$r!"2>NN0h$K7R$,$l$F$$$k(B
  $B%l%3!<%I$r@55,NN0h$K0\F0$9$k$H6&$K!":#$^$G@55,NN0h$K$D$J$,$C$F$$$?(B
  $B%l%3!<%I$r85$K!"AH9~=R8l$,JV$9%Y%/%?$r9=@.$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkProfVect	XXX

#SUBARG_define A_CurrentVect DST

#SUBROUTINE f_ReplaceMeasuremetRecordAndCreateCurrentVect_Sub(A_CurrentVect)
{
  $USE(D_WorkPENum);	$USE(D_WorkElemSize);
  b_ReadPENumInCluster(D_WorkPENum);
  b_SetImmValueDNTC(_MAX_ELEMENTS_PROFILE_VECT,D_WorkElemSize);
  $USE(D_WorkPos); $USE(D_WorkProfVect); $USE(D_WorkVectElem);
  s_IfProfileMainSwitchOn() {
    $CALL(f_AllocVectorMRBoff_Sub(D_WorkElemSize,A_CurrentVect));
    LOOP(){
      b_DecrementReg(D_WorkElemSize);
      s_IfClusterwiseMeasurementItem(D_WorkElemSize) {
	/* $B%/%i%9%?Kh$N7WB,9`L\(B */
	$CALL(f_MoveFromTempAreaToMeasurementRecordPointerArea_Sub
	      (D_WorkElemSize, D_NULL,D_WorkVectElem));
	s_PutVectElementPosReg(A_CurrentVect,D_WorkElemSize,D_WorkVectElem);
      } else {
	/* PE $BKh$N7WB,9`L\(B */
	/* $B%/%i%9%?Fb#P#EBf?t$rMWAG$H$9$k%Y%/%?$r3d$jIU$1$k(B */
	$CALL(f_AllocVectorMRBoff_Sub(D_WorkPENum,D_WorkProfVect));
	p_MoveValue(D_WorkPENum,D_WorkPos);
	/* $B<h$j49$($k(B */
	LOOP() {
	  b_DecrementReg(D_WorkPos);
	  $CALL(f_MoveFromTempAreaToMeasurementRecordPointerArea_Sub
		(D_WorkElemSize, D_WorkPos,D_WorkVectElem));
	  s_PutVectElementPosReg(D_WorkProfVect,D_WorkPos,D_WorkVectElem);
	  b_IfZero(D_WorkPos) { break; }
	}
	s_PutVectElementPosReg(A_CurrentVect,D_WorkElemSize,D_WorkProfVect);
      }
      b_IfZero(D_WorkElemSize) { break; }
    }
  } else {
    LOOP() {
      s_AllocVect0(A_CurrentVect);
      b_DecrementReg(D_WorkElemSize);
      s_IfClusterwiseMeasurementItem(D_WorkElemSize) {
	/* $B%/%i%9%?Kh$N7WB,9`L\(B */
	$CALL(f_MoveFromTempAreaToMeasurementRecordPointerArea_Sub
	      (D_WorkElemSize, D_NULL,D_WorkVectElem));
      } else {
	/* PE $BKh$N7WB,9`L\(B */
	/* $B%/%i%9%?Fb#P#EBf?t$rMWAG$H$9$k%Y%/%?$r3d$jIU$1$k(B */
	$CALL(f_AllocVectorMRBoff_Sub(D_WorkPENum,D_WorkProfVect));
	p_MoveValue(D_WorkPENum,D_WorkPos);
	/* $B<h$j49$($k(B */
	LOOP() {
	  b_DecrementReg(D_WorkPos);
	  $CALL(f_MoveFromTempAreaToMeasurementRecordPointerArea_Sub
		(D_WorkElemSize, D_WorkPos,D_WorkVectElem));
	  b_IfZero(D_WorkPos) { break; }
	}
      }
      b_IfZero(D_WorkElemSize) { break; }
    }
  }
  $RELEASE(D_WorkPos); $RELEASE(D_WorkProfVect); $RELEASE(D_WorkVectElem);
  $RELEASE(D_WorkPENum);   $RELEASE(D_WorkElemSize);
  $RETURN();
}

/******************************************************************** PSL **
 $B2>NN0h$K$*$+$l$?%a%8%c!<%a%s%H%l%3!<%I$N$&$A!"(BMRB on $B$N$b$N$,$"$l$P(B
 $B%3%T!<$7!"(BMRB off $B$K$7$F$7$^$&!#(B

       written by imai@icot22      on Thu May  7 12:26:10 1992
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  MRB on $B$N;~%3%T!<$K<:GT!J%a%b%jITB-!K$7$?$i!"(Bbulitin $B$N<B9T$rCfCG$7(B
  $B$J$1$l$P$J$i$J$$!#$3$N$?$a$K!"7WB,$r3+;O$9$kA0$K!"I,MW$J%a%b%j$r(B
  $B3d$jIU$1$F$*$/!#(B
<ETC>

********************************************************************* PSL **/
#SUBARG_define	A_Result	DST

#SUBROUTINE f_MakeWhiteMeasurementRecordOnTempArea_Sub(A_Result)
{
  $USE(D_WorkElemSize);      $USE(D_WorkPENum);	
  $USE(D_WorkPtrToMeasurementRec);
  b_SetImmValueDNTC(_MAX_ELEMENTS_PROFILE_VECT,D_WorkElemSize);
  LOOP() {
    b_DecrementReg(D_WorkElemSize);
    s_IfClusterwiseMeasurementItem(D_WorkElemSize) {
      /* $B%/%i%9%?Kh$N7WB,9`L\(B */
      s_GetFromMeasurementRecordTempArea
	(D_WorkElemSize, D_NULL, D_WorkPtrToMeasurementRec);
	/* $B8=>u$G$O!"%/%i%9%?Kh$N7WB,$O!"A4$F%9%H%j%s%0(B */
      s_IfMRBon(D_WorkPtrToMeasurementRec) {
	TypeSwitch(D_WorkPtrToMeasurementRec) {
	case STRG:
	  $USE(D_WorkNewData);
	  f_CopyStringMRB(D_WorkPtrToMeasurementRec,D_WorkNewData);
	  s_IfPageAllocFail() {
	    @DEBUG{WARNING("f_MakeWhiteMeasurementRecordOnTempArea_Sub","PageAllocFail (small)!! Let's invoke GC");};
	    s_SetSuspentionInputProcessorProfile(A_Result);
	    $RELEASE(D_WorkNewData); goto End;
	  }
	  b_IfWordEq(D_WorkNewData,D_NULL) {
	    @DEBUG{WARNING("f_MakeWhiteMeasurementRecordOnTempArea_Sub","PageAllocFail (large)!! Let's invoke GC");};
	    s_SetSuspentionInputProcessorProfile(A_Result);
	    $RELEASE(D_WorkNewData); goto End;
	  }
	  s_PutToMeasurementRecordTempArea
	    (D_WorkElemSize, D_NULL, D_WorkNewData);
	  $RELEASE(D_WorkNewData);
	  break;
	case INT:
	  b_IfZero(D_WorkPtrToMeasurementRec) { break; /* from switch */ }
	default:
	  @DEBUG{VPIM_ERROR("f_MakeWhiteMeasurementRecordOnTempArea_Sub",
			    "Illegal Type or Not INT!0");};
	}
      }
    } else {
      /* PE $BKh$N7WB,9`L\(B */
      b_ReadPENumInCluster(D_WorkPENum);
	/* $B<h$j49$($k(B */
      LOOP() {
	b_DecrementReg(D_WorkPENum);
	s_GetFromMeasurementRecordTempArea
	  (D_WorkElemSize, D_WorkPENum, D_WorkPtrToMeasurementRec);
	s_IfMRBon(D_WorkPtrToMeasurementRec) {
	  $USE(D_WorkNewData);
	  TypeSwitch(D_WorkPtrToMeasurementRec) {
	  case STRG:
	    f_CopyStringMRB(D_WorkPtrToMeasurementRec,D_WorkNewData);
	    break;
	  case ShortVectorGrp():
	    $USE(D_WorkVectXSize);
	    s_GetSizeShortVect(D_WorkPtrToMeasurementRec,D_WorkVectXSize);
	    f_CopyShortVectorMRB
	      (D_WorkPtrToMeasurementRec,D_WorkVectXSize,D_WorkNewData);
	    $RELEASE(D_WorkVectXSize);
	    break;
	  case LongVectorGrp():
	    $USE(D_WorkVectXSize);
	    s_GetSizeLongVect(D_WorkPtrToMeasurementRec,D_WorkVectXSize);
	    f_CopyLongVectorMRB
	      (D_WorkPtrToMeasurementRec,D_WorkVectXSize,D_WorkNewData);
	    $RELEASE(D_WorkVectXSize);
	    break;
	  case INT: goto Okey;
	  default:
	    @DEBUG{VPIM_ERROR("f_MakeWhiteMeasurementRecordOnTempArea_Sub",
			      "Illegal Type");};
	  }
	  s_IfPageAllocFail() {
	    @DEBUG{WARNING("f_MakeWhiteMeasurementRecordOnTempArea_Sub","PageAllocFail (small)!! Let's invoke GC");};
	    s_SetSuspentionInputProcessorProfile(A_Result);
	    $RELEASE(D_WorkNewData); goto End;
	  }
	  b_IfWordEq(D_WorkNewData,D_NULL) {
	    @DEBUG{WARNING("f_MakeWhiteMeasurementRecordOnTempArea_Sub","PageAllocFail (large)!! Let's invoke GC");};
	    s_SetSuspentionInputProcessorProfile(A_Result); 
	    $RELEASE(D_WorkNewData); goto End;
	  }
	  s_PutToMeasurementRecordTempArea
	    (D_WorkElemSize, D_WorkPENum, D_WorkNewData);
	Okey:
	  $RELEASE(D_WorkNewData);
	}
	b_IfZero(D_WorkPENum) { break; }
      }
    }
    b_IfZero(D_WorkElemSize) { break; }
  }
  s_SetProperInputProcessorProfile(A_Result);
 End:
  $RELEASE(D_WorkPtrToMeasurementRec); $RELEASE(D_WorkElemSize);
  $RELEASE(D_WorkPENum);
  $RETURN();
}

/******************************************************************** PSL **
f_MoveFromTempAreaToMeasurementRecordPointerArea
  $B2>NN0h$+$i@55,NN0h$X$N%3%T!<(B
       written by imai@icot22      on Wed Sep 11 13:55:39 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  $B2>NN0h$KCV$+$l$?%9%H%j%s%0!"%Y%/%?$N(B MRB $B$,(B on $B$N>l9g$K$O!"(B
  $BF1$8Bg$-$5$N%9%H%j%s%0!"%Y%/%?$r3d$jIU$1!"=i4|2=$9$k!#(B

  --> $B$3$N=hM}$O!"(Bf_MakeWhiteMeasurementRecordOnTempArea_Sub
      $B$K0\F0$7$?!#(B
<ETC>
********************************************************************* PSL **/

#SUBARG_define A_SlotPosReg	SRC
#SUBARG_define A_PeNum		SRC
#SUBARG_define A_PreviousPtr	DST

#SUBROUTINE f_MoveFromTempAreaToMeasurementRecordPointerArea_Sub
	(A_SlotPosReg, A_PeNum, A_PreviousPtr)
{
  $USE(D_WorkPtrToMeasurementRec);
  s_GetFromMeasurementRecordTempArea
    (A_SlotPosReg, A_PeNum, D_WorkPtrToMeasurementRec);
  /* $B$3$3$K$"$C$?(B if(MRB$B9u(B) $B$N=hM}$O(B
	f_MakeWhiteMeasurementRecordOnTempArea_Sub
     $B$K$F9T$J$&$h$&$K$7$?!#(B*/
  @DEBUG{
    s_IfMRBon(D_WorkPtrToMeasurementRec) {
      VPIM_ERROR("f_MoveFromTempAreaToMeasurementRecordPointerArea_Sub",
		 "Why MRB on??");
    }
  };
  ValueSwitch(A_SlotPosReg) {
  case _IDLE_TIME_ELEM_POS_PROFILE_VECT:
    s_SoftLockMeasurementRecordPointerAreaPosReg
      (A_SlotPosReg, A_PeNum, A_PreviousPtr);
    /* $B;~7W$r8+$k=hM}$,$"$k$N$G!"%m%C%/Cf$K=i4|2=(B */
    $USE(D_WorkCurrentTime);
    b_GetCurrentTime(D_WorkCurrentTime);
    s_IfNotINT(D_WorkPtrToMeasurementRec) {
      s_InitIdleLogMeasurementRecord
	(D_WorkPtrToMeasurementRec,D_WorkCurrentTime,A_PreviousPtr);
    }
    s_IfRunningPE(A_PreviousPtr) {
      s_TurnOnRunning(D_WorkPtrToMeasurementRec);
    } else {
      s_TurnOnIdling(D_WorkPtrToMeasurementRec);
    }
    s_SoftUnlockMeasurementRecordPointerAreaPosReg
      (A_SlotPosReg, A_PeNum, D_WorkPtrToMeasurementRec);
    s_IfNotINT(A_PreviousPtr) {
      s_TerminateIdleLogMeasurementRecord
	(A_PreviousPtr,D_WorkCurrentTime);
    }
    $RELEASE(D_WorkCurrentTime);
    break;
  case _GEVC_ELEM_POS_PROFILE_VECT:
    b_SetImmTypeValueMRBoff(INT,_ZERO,A_PreviousPtr);
    break;
  case _MSG_SEND_FREQ_ELEM_POS_PROFILE_VECT:
  case _MSG_RECV_FREQ_ELEM_POS_PROFILE_VECT:
    s_IfNotINT(D_WorkPtrToMeasurementRec) {
      s_InitMsgCountLogMeasurementRecord(D_WorkPtrToMeasurementRec);
    }
    s_SoftLockMeasurementRecordPointerAreaPosReg
      (A_SlotPosReg, A_PeNum, A_PreviousPtr);
    s_SoftUnlockMeasurementRecordPointerAreaPosReg
      (A_SlotPosReg, A_PeNum, D_WorkPtrToMeasurementRec);
    break;
  case _LOCAL_GC_ELEM_POS_PROFILE_VECT:
    s_SoftLockMeasurementRecordPointerAreaPosReg
      (A_SlotPosReg, A_PeNum, A_PreviousPtr);
    s_IfNotINT(D_WorkPtrToMeasurementRec) {
      /* $B;~7W$r8+$k=hM}$,$"$k$N$G!"%m%C%/Cf$K=i4|2=(B */
      s_InitLocalGCLogMeasurementRecord(D_WorkPtrToMeasurementRec);
    }
    s_SoftUnlockMeasurementRecordPointerAreaPosReg
      (A_SlotPosReg, A_PeNum, D_WorkPtrToMeasurementRec);
    s_IfNotINT(A_PreviousPtr) {
      s_TerminateLocalGCLogMeasurementRecord(A_PreviousPtr);
    }
    break;
  case _LOG_EVENT_ELEM_POS_PROFILE_VECT:
    s_IfNotINT(D_WorkPtrToMeasurementRec) {
      s_InitLogEventLogMeasurementRecord(D_WorkPtrToMeasurementRec);
    }
    s_SoftLockMeasurementRecordPointerAreaPosReg
      (A_SlotPosReg, A_PeNum, A_PreviousPtr);
    s_SoftUnlockMeasurementRecordPointerAreaPosReg
      (A_SlotPosReg, A_PeNum, D_WorkPtrToMeasurementRec);
    break;
  case _MSG_ENC_DEC_TIME_ELEM_POS_PROFILE_VECT:
    $USE(D_WorkCurrentTime);
    b_GetCurrentTime(D_WorkCurrentTime);
    s_SoftLockMeasurementRecordPointerAreaPosReg
      (A_SlotPosReg, A_PeNum, A_PreviousPtr);
    s_IfNotINT(D_WorkPtrToMeasurementRec) {
      s_InitMsgEncDecTimeMeasurementRecord
	(D_WorkPtrToMeasurementRec,D_WorkCurrentTime);
    }
    s_SoftUnlockMeasurementRecordPointerAreaPosReg
      (A_SlotPosReg, A_PeNum, D_WorkPtrToMeasurementRec);
    s_IfNotINT(A_PreviousPtr) {
      s_TerminateMsgEncDecTimeMeasurementRecord
	(A_PreviousPtr,D_WorkCurrentTime);
    }
    $RELEASE(D_WorkCurrentTime);
    break;
  default:
    @DEBUG{VPIM_ERROR("f_MoveFromTempAreaToMeasurementRecordPointerArea",
		      "Illeal Value A_SlotPosReg");};
  }
  $RELEASE(D_WorkPtrToMeasurementRec);
  $RETURN();
}

/******************************************************************** PSL **

       written by imai@icot22      on Tue Aug 27 17:48:27 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
  $B$"$k(B PE $B$,(B profile $B>uBVJQ99$r5/$3$7$F!"(Bf_StartOrStopProcessorProfile
  $B$r<B9T$7$?;~$K!"$=$l0J30$N(B PE $B$G(B invoke $B$5$l$k!#(B
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
  $BB>$N%W%m%;%C%5$,!"(Bprocessor_profile/2 $B$r<B9T$7$F!"(BMainSwitch$B$r(B
  $B99?7$9$Y$-;~$K(B SIGP $B$5$l$k!#$=$N%O%s%I%i$G$"$k!#(B
********************************************************************* PSL **/

#SUBROUTINE  f_ProcessorProfileChangeHandler_Sub()
{
  b_ResetEventFlag(_PROCESSOR_PROFILE_CHANGE_EVENT,D_PE_Number);
  b_ReadCommArea
    (_PROCESSOR_PROFILE_STAT_CHANGE, D_ProcessorProfilerMainSwitch);
  $RETURN();
}

/******************************************************************** PSL **
  log_event $B$N<B9T(B
       written by imai@icot22      on Mon Sep  9 10:59:02 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/


#PSL_define f_DoLogEvent(id_reg)
{
  s_RecordLogEventLog(id_reg);
}
