
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V10/functions/f_reduce_passive_unify.psl.c
   ----- CREATED   : by f-hataza@icot22, on Fri May 25 20:16:01 1990
   ----- LAST SAVED: by f-doumae@icot22, on Sat Aug 17 15:13:38 1991
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : functions
   ----- ABSTRACT  : 

1. f_EqualStruct src_reg1, src_reg2, imm_lsusp, imm_lfail
2. (SUBROUTINE) f_Equal_Sub 
3. Passive genreal unify operations
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
1. f_EqualStruct src_reg1, src_reg2, imm_lsusp, imm_lfail
(PIM/p $B$K$*$1$k%^%/%mL?Na(B)
       written by f-doumae@icot22      on Wed Sep 20 10:26:49 1989
<Arguments>
    src_reg1 : $B%l%8%9%?(B
    src_reg2 : $B%l%8%9%?(B
    imm_lsusp: $B%5%9%Z%s%I%i%Y%k(B
    imm_lfail: $B%U%'%$%k%i%Y%k(B

<Temporally Used Variables>
<Level>
<PreCondition>
  src_reg1, src_reg2 $B$O0z?t%l%8%9%?$G$"$k$3$H$KCm0U(B
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define 	D_WorkRegPu1    XXX
#DATA_define 	D_WorkRegPu2    XXX
#DATA_define	D_WorkLsusp	XXX
#DATA_define	D_WorkLfail	XXX

#PSL_define f_EqualStruct (src_reg1, src_reg2, imm_lsusp, imm_lfail)
{
  p_IfTypeNE(src_reg1, src_reg2) {
    s_SetKLB_PC_OPR(imm_lfail);
  } else {
    TypeSwitch (src_reg1) {
      case FloatingGrp () :
	@DEBUG { WARNING("f_EqualStruct", "Floating Type Unification"); };
	f_IfFloatingNotEqual(src_reg1, src_reg2){ 
	    s_SetKLB_PC_OPR(imm_lfail);
	}
	break;
      case StringGrp () : 
	f_IfStringNotEqual(src_reg1, src_reg2){ 
	    s_SetKLB_PC_OPR(imm_lfail);
	}
	break;
      case NullVectorGrp():
	/*
	 * null vector$B$O%a%b%j$K$O3d$jIU$1$i$l$F$$$J$$$N$G(Batomic$B$J$b$N$HF1MM$N(B
	 * $B=hM}$,9T$o$l$k$N$G!"0lHL$N(Bshort vector$B$H$O6hJL$7$J$1$l$P$J$i$J$$!#(B
	 */
	s_IfNotNullVectors(src_reg2) {
	  s_SetKLB_PC_OPR(imm_lfail);
	}
	break;
      case LongVectorGrp () :
	f_IfLongVectSizeEqual(src_reg1, src_reg2){
	/* short vector$B$HF1$8(B */;
	} else {
	    s_SetKLB_PC_OPR(imm_lfail);			/* Lfail $B$KJ,4t(B	*/
	    break;
	}
      case ListGrp () :
      case ShortVectorGrp():
	$USE(D_WorkLsusp);
	$USE(D_WorkLfail);
	s_GetKLB_Address_OPR(imm_lsusp, D_WorkLsusp);
	s_GetKLB_Address_OPR(imm_lfail, D_WorkLfail);
/*      @DEBUG{WARNING("klb_equal","equal check for List or Svect");}; */
	/*
	 * src_reg1$B$H(Bsrc_reg2$B$O<B:]$O0z?t%l%8%9%?$N2DG=@-$,M-$k$N$G!"(B
	 * $B%3%_%C%H$9$k$^$G$OB>$N$b$N$K=q$-49$($F$O$J$i$J$$!#(B(Deref$B$O(BOK)
	 */
	$USE(D_WorkRegPu1);
	$USE(D_WorkRegPu2);
	p_MoveWord(src_reg1, D_WorkRegPu1);
	p_MoveWord(src_reg2, D_WorkRegPu2);
	$CALL(f_Equal_Sub(D_WorkRegPu1, D_WorkRegPu2,D_WorkLsusp,D_WorkLfail));
	$RELEASE(D_WorkRegPu1);
	$RELEASE(D_WorkRegPu2);
	$RELEASE(D_WorkLsusp);
	$RELEASE(D_WorkLfail);
	break;
      case SHREC:
      case MOD:
      case COD:
	b_IfTypeValueNotEq(src_reg1, src_reg2){
	  s_SetKLB_PC_OPR(imm_lfail);
	}	
	break;
      default:
	@DEBUG{
	  VPIM_ERROR("klb_equal","Illegal type");
        };
    }
  }
}

/******************************************************************** PSL **
2. (SUBROUTINE) f_Equal_Sub 
       written by f-doumae@icot22      on Mon Jul 10 18:11:30 1989
<Arguments>
    
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
== $B;HMQ%l%8%9%?(B

  $B%f%K%U%!%$%9%?%C%/$K@Q$^$l$F$$$/$b$N(B ($BDL>o$O%l%8%9%?>e$KE83+$5$l$F$$$k(B)

	D_WorkRegXadr      $B9=B$BN(BX$BB&$NK\BN$N@hF,%"%I%l%9(B
	D_WorkRegYadr      $B9=B$BN(BY$BB&$NK\BN$N@hF,%"%I%l%9(B
	D_WorkRegSSize     $B9=B$BN%5%$%:(B
	D_WorkRegCrp       $B9=B$BNFb$G$N8=:_0LCV(B ($BK\BN@hF,$+$i$N%*%U%;%C%H(B)

  $B%f%K%U%#%1!<%7%g%s$N$?$a$N%o!<%/%l%8%9%?(B

  	D_WorkRegPu1      X$BB&%(%l%a%s%H(B ($B8F$S=P$7B&$G@_Dj(B)
	D_WorkRegPu2      Y$BB&%(%l%a%s%H(B ($B8F$S=P$7B&$G@_Dj(B)

== $B;HMQ%^%/%m(B

  f_ExpandStructure reg1 reg2
  $B!&(Breg1$B$r(BD_WorkRegXadr$B$K!"(Breg2$B$r(BD_WorkRegYadr$B$K0\$9(B
  $B!&(Breg1(reg2)$B$N9=B$BN$N%5%$%:$r(BD_WorkRegSSize$B$K3JG<$9$k(B
  $B!&(BD_WorkRegCrp$B$r%<%m$K$9$k(B

  f_GetNextElm
  $B!&9=B$BN$N:G=i$NMWAG$r(BD_WorkRegPu1$B$H(BD_WorkRegPu2$B$K(B
    $BFI$_=P$7$F$/$k!#(B
  $B!&(BD_WorkRegXadr$B$r%$%s%G%/%9$H$7$F(B
    D_WorkRegPu1$B$K9=B$BNMWAG$rFI$_$@$7%G%l%U$9$k!#(B
  $B!&(BD_WorkRegYadr$B$r%$%s%G%/%9$H$7$F(B
    D_WorkRegPu2$B$K9=B$BNMWAG$rFI$_$@$7%G%l%U$9$k!#(B
  $B!&(BD_WorkRegXadr, D_WorkRegYadr, D_WorkRegCrp$B$r(B
    $B%$%s%/%j%a%s%H$9$k!#(B

<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkRegXadr   XXX
#DATA_define D_WorkRegYadr   XXX
#DATA_define D_WorkRegSSize  XXX
#DATA_define D_WorkRegCrp    XXX

#SUBARG_define	A_RegPu1	MODIFY
#SUBARG_define	A_RegPu2	MODIFY
#SUBARG_define	A_Lsusp		SRC
#SUBARG_define	A_Lfail		SRC

#SUBROUTINE f_Equal_Sub( A_RegPu1, A_RegPu2, A_Lsusp, A_Lfail) 
{
  s_InitializeUnifyStack(); 

  $USE(D_WorkRegXadr); $USE(D_WorkRegYadr);
  $USE(D_WorkRegSSize); $USE(D_WorkRegCrp); 
  $CALL( f_ExpandStrAndGetElem_Sub  (   A_RegPu1, A_RegPu2, 
				        D_WorkRegXadr, D_WorkRegYadr, 
				        D_WorkRegSSize, D_WorkRegCrp  ) );
  LOOP() {
	/* A_RegPu1, A_RegPu2 $B$N$$$:$l$+$,(B REF $B$N;~(B ($BMWAG$,L$Dj5A(B)
	 * $B$N;~$O(B, $B%5%9%Z%s%I%9%?%C%/$K%W%C%7%e$7$FHt$S=P$9(B.
	 */
    s_IfREF(A_RegPu1) {		/* $BBh(B1$B0z?t$,L$Dj5AJQ?t$J$i(B Lsusp $B$KJ,4t(B	*/
      s_PushSuspendStack(A_RegPu1);
      s_SetKLB_PC(A_Lsusp);
      goto PU_Suspend;
    }
    s_IfREF(A_RegPu2) {		/* $BBh(B2$B0z?t$,L$Dj5AJQ?t$J$i(B Lsusp $B$KJ,4t(B	*/
      s_PushSuspendStack(A_RegPu2);
      s_SetKLB_PC(A_Lsusp);
      goto PU_Suspend;
    }
    p_IfTypeNE(A_RegPu1, A_RegPu2) {	/* type$B$,Ey$7$/$J$$;~(BLfail $B$KJ,4t(B */
      s_SetKLB_PC(A_Lfail);
      goto PU_Fail;
    }
    @PROBE { s_CountType (A_RegPu1); };
    TypeSwitch(A_RegPu1){
    case AtomicGrp():
    case COD: case MOD:
      b_IfTypeValueNotEq(A_RegPu1, A_RegPu2) {
	s_SetKLB_PC(A_Lfail);  /*  Lfail $B$KJ,4t(B  */
	goto PU_Fail;
      }
      goto Next_Unify_Point;

    case FloatingGrp () :
      @DEBUG { WARNING("f_Equal_Sub", "Floating Type Unification"); };
      f_IfFloatingNotEqual(A_RegPu1, A_RegPu2){
	s_SetKLB_PC(A_Lfail);
	goto PU_Fail;
      }
      goto Next_Unify_Point;

    case StringGrp():
      f_IfStringNotEqual(A_RegPu1, A_RegPu2){
	s_SetKLB_PC(A_Lfail);
	goto PU_Fail;
      }
				/* $B%J%k%Y%/%?$N>l9g!"CMIt$NHf3S$OI,MW$J$/$F(B */
    case NullVectorGrp():	/* $B$3$3$^$GMh$l$PL5>r7o$K(Bsuccess	*/
 Next_Unify_Point:
      s_IfMoreStrElem(D_WorkRegCrp, D_WorkRegSSize) {
			/* $B<!$N(Btop level$B$N(BLOOP$B$N$?$a$K(BA_RegPu1,2$B$r99?7$9$k(B */
	f_GetNextElem (D_WorkRegXadr, D_WorkRegYadr, D_WorkRegCrp, 
		       A_RegPu1, A_RegPu2);
      } else {
	LOOP () {	/* Equality$B$rD4$Y$k<!$N%]%$%s%H$r8+$D$1=P$9(B	*/
	  s_IfUnifyStackEmpty() {
	    goto PU_Success;
	  }
	  s_PopUnifyStack
	    (D_WorkRegCrp, D_WorkRegSSize, D_WorkRegXadr, D_WorkRegYadr);
	  s_IfMoreStrElem(D_WorkRegCrp, D_WorkRegSSize) {
	    f_GetNextElem (D_WorkRegXadr, D_WorkRegYadr, D_WorkRegCrp, 
			   A_RegPu1,  A_RegPu2);
	    break;	/* Equality$B$rD4$Y$k<!$N%]%$%s%H$,8+$D$+$C$?(B	*/
			/* inner LOOP$B$rH4$1$F!"30B&$N(BLOOP$B$N(Btop$B$X(B	*/
	  }
	} /* end of inner LOOP */
      } /* end of s_IfMoreStrElem */
      break;
    case LongVectorGrp():
      f_IfLongVectSizeNotEqual(A_RegPu1, A_RegPu2){
        s_SetKLB_PC(A_Lfail);
	goto PU_Fail;
      }
    case LIST:
    case ShortVectorGrp():
      s_IfUnifyStackFull() {
	s_SetKLB_PC(A_Lsusp);
	@DEBUG{ WARNING("f_Equal_Sub","unify stack full");};
	goto PU_Suspend;
      }
      s_PushUnifyStack(D_WorkRegCrp,D_WorkRegSSize,D_WorkRegXadr,D_WorkRegYadr);
      $CALL( f_ExpandStrAndGetElem_Sub( A_RegPu1, A_RegPu2, 
				       D_WorkRegXadr, D_WorkRegYadr, 
				       D_WorkRegSSize, D_WorkRegCrp ));
      break;
    default:
      @DEBUG{ VPIM_ERROR("f_Equal_Sub","Illegal Type!!"); };
    } /* end of TypeSwitch */
  } /* end of LOOP() */

 PU_Fail:
 PU_Suspend:
 PU_Success:
    ;
  $RELEASE(D_WorkRegXadr);
  $RELEASE(D_WorkRegYadr);
  $RELEASE(D_WorkRegSSize);
  $RELEASE(D_WorkRegCrp);
  $RETURN ();
}

/******************************************************************** PSL **
3. Passive genreal unify operations

       written by nishida@icot22      Wed Nov 16 14:49:32 1988

<Arguments>
  reg_x : $B9=B$BN$X$N%]%$%s%?(B
  reg_y : $B9=B$BN$X$N%]%$%s%?(B
  reg_crp : 	$B9=B$BNFb$G$N8=:_0LCV(B (D_WorkRegCrp) $B$rI=$9(B
  reg_str_size:	$B9=B$BN%5%$%:(B  (D_WorkRegSSize)
		($B9=B$BNK\BN$ND9$5(B -- 1 origin )
  reg_x_addr :	$B9=B$BN(BX$BB&$NK\BN$N@hF,%"%I%l%9(B (D_WorkRegXadr)
  reg_y_addr :	$B9=B$BN(BY$BB&$NK\BN$N@hF,%"%I%l%9(B (D_WorkRegYadr)
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  f_ExpandStructure (reg_x, reg_y, reg_x_addr, reg_y_addr,
		     reg_str_size, reg_crp) :
	"reg_x",     "reg_y"      $B$,;X$99=B$BN$NK\BN$N@hF,%"%I%l%9$r(B
	"reg_x_addr","reg_y_addr" $B$K%;%C%H$9$k(B. 
	$BN>9=B$BN$NMWAG?t$r(B reg_str_size $B$K%;%C%H$9$k(B.
	$B9=B$BN$NMWAG0LCV$r<($9%l%8%9%?(B "reg_crp" $B$r%<%m%/%j%"$9$k(B.

  f_GetNextElem (reg_x_addr, reg_y_addr, reg_crp, reg_pu1, reg_pu2) :
	"reg_x_addr" $B$,;X$99=B$BNK\BN$N(B "reg_crp"$BHVL\$NMWAG$r(B
	"reg_pu1" $B$KFI$_=P$7(B, $B%G%l%U7k2L$r(B reg_pu1 $B$H9=B$BNK\BN$K=q$-La$9(B.
	"reg_y_addr" $B$,;X$99=B$BNK\BN$N(B "reg_crp"$BHVL\$NMWAG$r(B
	"reg_pu2" $B$KFI$_=P$7(B, $B%G%l%U7k2L$r(B reg_pu1 $B$H9=B$BNK\BN$K=q$-La$9(B.
	"reg_crp" $B$r(B $B%$%s%/%j%a%s%H$7(B, $B<!$NMWAG0LCV$r;X$9(B.
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#SUBARG_define	A_RegPu1	MODIFY	/* ?? */
#SUBARG_define	A_RegPu2	MODIFY	/* ?? */
#SUBARG_define	A_RegXadr	DST	/* ?? */
#SUBARG_define	A_RegYadr	DST	/* ?? */
#SUBARG_define	A_RegSSize	DST	/* ?? */
#SUBARG_define	A_RegCrp	DST	/* ?? */

#SUBROUTINE f_ExpandStrAndGetElem_Sub
	(A_RegPu1, A_RegPu2, A_RegXadr, A_RegYadr, A_RegSSize, A_RegCrp)
{
  f_ExpandStructure (A_RegPu1, A_RegPu2,
		     A_RegXadr, A_RegYadr, A_RegSSize, A_RegCrp);
  f_GetNextElem (A_RegXadr, A_RegYadr, A_RegCrp, A_RegPu1, A_RegPu2);
  $RETURN ();
}

#PSL_define f_ExpandStructure
	(src_reg_x, src_reg_y,
	 dst_reg_x_addr, dst_reg_y_addr, dst_reg_str_size, dst_reg_crp) 
{
  p_MoveWord(src_reg_x, dst_reg_x_addr);
  p_MoveWord(src_reg_y, dst_reg_y_addr);
  s_GetSizeofStrct(src_reg_x, dst_reg_str_size);
  p_MoveWord( D_NULL, dst_reg_crp); /* $B9=B$BNFbMWAG0LCV$r%<%m%/%j%"(B */
}

#PSL_define f_GetNextElem
	(reg_x_addr, reg_y_addr, reg_crp, reg_pu1, reg_pu2) 
{
  /* $B$3$3$G!"(Bs_ReadWithRegOffsetMRBor $B$H(B f_DerefElementReg $B$N%^%/%m$O(B       *
   * $B$=$l$>$l$NFbIt$G%l%8%9%?(Breg_crp$B>e$N0LCVHV9f$r%*%U%;%C%H$KJQ49$7$F$$$k!#(B*
   * ==> $B13!*!*(B reg_crp $B$O$3$3$G%*%U%;%C%H$H9M$($k!#(Breg_crp $B$O$3$N%^%/%mFb$G(B*
   * $B@UG$$r$b$C$F%"%I%l%9%$%s%/%j%a%s%H$r$9$k!#(B1991.08.17 f-doumae          */
  s_ReadWithRegOffsetMRBor(reg_x_addr, reg_crp, reg_pu1);
  f_DerefElementReg(reg_x_addr, reg_crp, reg_pu1);
  s_ReadWithRegOffsetMRBor(reg_y_addr, reg_crp, reg_pu2);
  f_DerefElementReg(reg_y_addr, reg_crp, reg_pu2);
	/* $B9=B$BNCf$N<!$NMWAG$r;X$9$h$&$KMWAG0LCV$N%$%s%/%j%a%s%H$r$9$k(B */
  b_IncrementAddrReg(reg_crp);
}
 
