
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_reduce_goal_queue.psl.c
   ----- CREATED   : by f-hataza@icot22, on Thu Jun  7 10:46:50 1990
   ----- LAST SAVED: by yamamoto@icot22, on Mon Jul 13 17:56:28 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : FUNCTIONS
   ----- ABSTRACT  : $B%4!<%k$N%(%s%-%e!<!?%G%-%e!<A`:n(B

  1. $B8=:_$N%4!<%k$HF10l%W%i%$%*%j%F%#%4!<%k$N%(%s%-%e!<(B/$B%G%-%e!<(B
  2. $B%W%i%$%*%j%F%#$r;XDj$7$?%4!<%k$N%(%s%-%e!<(B
  3. $B:G9b0L%W%i%$%*%j%F%#$N(BD_CurrentGoalStackPtr $B$rF@$k(B
  4. $B%+%l%s%H%4!<%k%]%$%s%?$NL58z2=!"M-8z!?L58zH=Dj(B

 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

#DATA_define D_GoalCntInStack	XXX
	/* $B%4!<%k%9%?%C%/Cf$N%4!<%k?t$N%+%&%s%?(B */

/******************************************************************** PSL **
1. $B8=:_$N%4!<%k$HF10l%W%i%$%*%j%F%#%4!<%k$N%(%s%-%e!<(B/$B%G%-%e!<(B

       written by goto@icot22      Wed Jan 11 19:43:05 1989

<Arguments>
  ptr_to_gr : $B%(%s%-%e!<(B/$B%G%-%e!<$9$k%4!<%k%l%3!<%I$X$N%]%$%s%?(B
<Temporally Used Variables> none
<Level>
<PreCondition>
<Function>
  f_PushGoalToStack (ptr_to_gr) :
	ptr_to_gr $B$N%4!<%k%l%3!<%I$r(BD_CurrentGoalStackPtr $B$K%W%C%7%e%j%s%/$9$k(B.
  f_PopGoalFromStack (ptr_to_gr) :
	ptr_to_gr $B$N%4!<%k%l%3!<%I$X(BD_CurrentGoalStackPtr $B$+$i%]%C%W%j%s%/$9$k(B.
<Examples> 
  f_PushGoalToStack (ptr_to_gr) :
  	klb_enqueue in klb_fork.psl.c
<Test>
<Explanation>
  $B0J2<$N$h$&$K(B, $B%W%C%7%e$7$?%4!<%k$O(B D_CurrentGoalStackPtr $B$+$i$N$_;X$5$l$k(B
  $B$3$H$KCm0U(B.

					D_CurrentGoalStackPtr
  					|
					V
			Goal Stack	+-------+
			|	|	|  GR	+---+
 D_CurrentStackEntryPtr	|	|	+-------+   |
	|	  	+-------+		    V
	+-------------->|	|		+-------+
			|   *------------------>|  GR	|
		  	+-------+		+-------+
			|	|
			|	|
<ETC>
********************************************************************* PSL **/

#CTRL_define f_IfNoCurrentPhyPrioGoal() 
{
  b_IfEOL(D_CurrentGoalStackPtr)
}

#PSL_define f_PushGoalToStack (ptr_to_gr)
{
  @DEBUG {
    s_IfNotHOOK (ptr_to_gr) {
      s_IfEHOOK (ptr_to_gr) {
	VPIM_ERROR ("f_PushGoalToStack", "EHOOK_goal_appeared");
      } else {
	VPIM_ERROR ("f_PushGoalToStack", "Illegal_goal_record_type");
      }
    }
    $USE(D_WorkPushGoalSub_FPRec);
    s_GetFosterparentGoalRecord(ptr_to_gr,D_WorkPushGoalSub_FPRec);
    s_IfAbortedOrAbortedTerminateFP(D_WorkPushGoalSub_FPRec) {
      ;/* do nothing $B!J@lMQ$N%A%'%C%/%k!<%A%s$r=q$/$Y$-$+$J!K(B*/
    }else{
      s_ArityCheck( ptr_to_gr );    
    }
    $RELEASE(D_WorkPushGoalSub_FPRec);
  };
  s_PushGoalRecord (ptr_to_gr, D_CurrentGoalStackPtr);
  b_IncrementReg(D_GoalCntInStack);
}

#PSL_define f_PopGoalFromStack (ptr_to_gr)
{
  s_PopGoalRecord (ptr_to_gr, D_CurrentGoalStackPtr);
  s_PutNextEOLGoalRecord (ptr_to_gr);
  b_DecrementReg(D_GoalCntInStack);
}

/******************************************************************** PSL **
2. $B%W%i%$%*%j%F%#$r;XDj$7$?%4!<%k$N%(%s%-%e!<(B

       written by goto@icot22      Thu Jan 12 12:45:00 1989
       greatly modified by imai@icot22	   Tue Dec 18 18:18:03 1990

<Arguments>
  A_PtrToGR      : $B%(%s%-%e!<$9$k%4!<%k%l%3!<%I$X$N%]%$%s%?(B
  A_LogicalPrio   : $B%(%s%-%e!<$9$k%4!<%k$N%W%i%$%*%j%F%#$r<($9%l%8%9%?(B
  		    ($BO@M}%W%i%$%*%j%F%#(B)
<Temporally Used Variables>
  D_WorkEntryPos : $B%9%?%C%/%(%s%H%j(B
  D_WorkGoalLink : $B%9%?%C%/%(%s%H%j$K$D$J$,$C$F$$$k%4!<%k$X$N%]%$%s%?(B
  D_WorkNextEntryPos : $B$H$J$j$N%9%?%C%/%(%s%H%j$X$N%]%$%s%?(B
  D_WorkGetEntry : s_GetHigher/LowerValidEntry $B$GF@$?%(%s%H%j$X$N%]%$%s%?(B
<Level>
<PreCondition>
<Function>
  $B!&(BA_LogicalPrio $B$G;XDj$5$l$?%W%i%$%*%j%F%#$KAjEv$9$k%4!<%k%9%?%C%/%(%s%H%j$K(B
    $B%4!<%k(B(A_PtrToGR)$B$r%(%s%-%e!<$9$k(B.
  $B!&%(%s%-%e!<$7$?%4!<%k$N%W%i%$%*%j%F%#(B(A_LogicalPrio-->D_WorkPhysicalPrio)
    $B$,8=%j%@%/%7%g%sCf$N:G9b0L%W%i%$%*%j%F%#(B(D_Max_Priority)$B$h$j$b9b$+$C$?$i(B,
    $B$=$N%W%i%$%*%j%F%#$r(B D_Max_Priority$B$K%;%C%H$7(B(VALID$B$K$7(B),
    "$B:G9b0L%W%i%$%*%j%F%#99?7(B"$B$N%9%j%C%H%A%'%C%/MW0x$r@85/$5$;$k!#(B
     (see bsc_slit_check.psl.c)
<Examples>
<Test>
<Explanation>
1990.12.18 $B$[$H$s$IA4LLJQ99(B

+-----------------------------------------------------------------------+
|			| $BO@M}%W%i%$%*%j%F%#(B	| $BJ*M}%W%i%$%*%j%F%#(B	|
|-----------------------+-----------------------+-----------------------|
|$B%(%s%-%e!<$9$k%4!<%k(B	|			|			|
|$B$N%W%i%$%*%j%F%#(B	| A_LogicalPriority	| D_WorkPhysicalPrio	|
|-----------------------+-----------------------+-----------------------|
|$B8=:_<B9TCf$N%4!<%k(B	| ???$B%9%?%C%/%(%s%H%j(B???|			|
|$B$N%W%i%$%*%j%F%#(B	| ??$B$+$iJ*M}$r$H$k$?$a(B??| D_WorkCurrentPhysicalPrio|
|-----------------------+-----------------------+-----------------------|
|$B:#$N$H$3$mCN$C$F$$$k(B	|			|			|
|$B:G9b$N%W%i%$%*%j%F%#(B	|	   ----------	|	D_Max_Priority	|
+-----------------------------------------------------------------------+

$B!&(BD_Max_Priority $B$O!"(BD_WorkCurrentPhisicalPrio $B$HCM$,Ey$7$$>l9g$O(B
  INVALID $B$J>uBV$H$7$FJ];}$5$l$k!#(B
	  VALID --> INVALID $B$O!"(BInner Event $B$r%j%;%C%H$9$k;~$K9T$J$$!"(B
	INVALID -->   VALID $B$O!"2<$N(B (2.a) $B$G9T$J$&(B

$B!&(BD_CurrentStackEntryPtr $B$O!"(B
	D_WorkCurrentPhysicalPrio $B$N%W%i%$%*%j%F%#$r(B
       $B$b$D%9%?%C%/%(%s%H%j$NCM$r%l%8%9%?>e$K%-%c%C%7%e$7$F$"$k!#(B

$B!&(BD_WorkPhysicalPrio, D_WorkCurrentPhysicalPrio, D_Max_Priority $B$N#3<T$K$O(B
  $B<!$N$h$&$J%P%j%(!<%7%g%s$,9M$($i$l!"$=$l$>$l<!$N$h$&$JA`:n$rK\%5%V%k!<%A(B
  $B%sCf$G9T$J$&(B

$B#1(B. $B!V(BD_Max_Priority $B$,(B VALID $B$G$"$l!"(BINVALID $B$G$"$lF1$8>l9g!W(B
  (1.a) D_WorkPhysicalPrio = D_WorkCurrentPhysicalPrio
	$B8=:_<B9TCf$N%4!<%k$HF1$8J*M}%W%i%$%*%j%F%#$N%4!<%k$N%(%s%-%e!<(B
	$B"*(B $BC1=c$K!"(BD_CurrentGoalStackPtr $B$K%(%s%-%e!<$9$k(B.
  (1.b) D_WorkPhysicalPrio $B$N%(%s%H%j$K4{$K%4!<%k$,7R$,$C$F$$$?(B
	$B"*(B $BC1=c$K!"$=$N%(%s%H%j$K%(%s%-%e!<$9$k(B.
  (1.c) D_WorkCurrentPhysicalPrio > D_WorkPhysicalPrio
	$B8=:_<B9TCf$N%4!<%k$h$j$b!"Dc$$J*M}%W%i%$%*%j%F%#$N%4!<%k$N%(%s%-%e!<(B
	$B"*(B D_WorkPhysicalPrio $B$KAjEv$9$k%9%?%C%/$N%(%s%H%j$OL$;HMQ$G$"$l$P(B,
	   $B%W%i%$%*%j%F%#$N9b$$J}8~$X%4!<%k%j%s%/$,6u$G$J$$%(%s%H%j$rC5$7(B,
	   $B%(%s%-%e!<$7$h$&$H$7$F$$$k%(%s%H%j$N>e2<$N%(%s%H%j$rF@$FAj8_$K7k$V!#(B

$B#2(B. $B!V(BD_Max_Priority = INVALID$B$N>l9g!W(B
  (2.a) D_WorkPhysicalPrio > D_WorkCurrentPhysicalPrio
	$B8=:_<B9TCf$N%4!<%k$h$j$b!"9b$$J*M}%W%i%$%*%j%F%#$N%4!<%k$N%(%s%-%e!<(B
	$B"*(B D_WorkPhysicalPrio $B$KAjEv$9$k%9%?%C%/$N%(%s%H%j$OL$;HMQ$N$O$:(B.
	   $B$=$l$H(B, D_Max_Priority$B$N%(%s%H%j$N4V$r7k$V(B.
	    D_Max_Priority := D_WorkPhysicalPrio $B$H$7$F(B (VALID$B$K$7$F(B)
	    slit-check$BMW0x$r(BON$B$K$9$k(B.

$B#3(B. $B!V(BD_Max_Priority = VALID$B$N>l9g!W(B
  (3.a) D_WorkPhysicalPrio > D_Max_Priority > D_WorkCurrentPhysicalPrio
	D_WorkPhysicalPrio $B$KAjEv$9$k%9%?%C%/$N%(%s%H%j$OL$;HMQ$N$O$:(B.
	$B$=$l$H(B, D_Max_Priority$B$N%(%s%H%j$N4V$r7k$V(B.
	D_Max_Priority := D_WorkPhysicalPrio $B$H$9$k(B.
  (3.b) D_Max_Priority > D_WorkPhysicalPrio > D_WorkCurrentPhysicalPrio
	D_WorkPhysicalPrio $B$KAjEv$9$k%9%?%C%/$N%(%s%H%j$OL$;HMQ$G$"$l$P(B,
	$B%W%i%$%*%j%F%#$NDc$$J}8~$X%4!<%k%j%s%/$,6u$G$J$$%(%s%H%j$rC5$7(B,
	$B%(%s%-%e!<$7$h$&$H$7$F$$$k%(%s%H%j$N>e2<$N%(%s%H%j$rF@$FAj8_$K7k$V!#(B
  (3.c) D_Max_Priority = D_WorkPhysicalPrio > D_WorkCurrentPhysicalPrio
	$B4{$K(B D_Max_Priority $B$r%;%C%H$7$?%4!<%k$,7R$,$C$F$$$k$O$:!#(B
	($B$3$N$h$&$J>uBV$O$"$jF@$J$$(B)
	
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkGoals	XXX
#DATA_define D_WorkSCR          XXX     /* for DEBUG */
#DATA_define D_WorkPhysicalPrio	XXX
#DATA_define D_WorkCurrentPhysicalPrio	XXX

#DATA_define D_WorkPushGoalSub_FPRec XXX

#SUBARG_define	A_GoalPtr	SRC
#SUBARG_define	A_LogicalPriority	SRC

#SUBROUTINE f_PushGoalToStackWithPriority_Sub ( A_GoalPtr, A_LogicalPriority)
{
  @DEBUG {
    s_IfNotSingleHookGrp (A_GoalPtr) {
      VPIM_ERROR ("f_PushGoalToStackWithPriority_Sub", "Illegal_gr_type");
    }
    s_IfEHOOK (A_GoalPtr){
      VPIM_ERROR ("f_PushGoalToStackWithPriority_Sub","EHOOK_goal_appeared");
    }
    s_StackEntryLinkCheck(D_CurrentStackEntryPtr);
    $USE(D_WorkPushGoalSub_FPRec);
    s_GetFosterparentGoalRecord(A_GoalPtr,D_WorkPushGoalSub_FPRec);
    s_IfAbortedOrAbortedTerminateFP(D_WorkPushGoalSub_FPRec) {
      ;/* do nothing $B!J@lMQ$N%A%'%C%/%k!<%A%s$r=q$/$Y$-$+$J!K(B*/
    }else{
      s_ArityCheck( A_GoalPtr );/* nomal arity check */
    }
    $RELEASE(D_WorkPushGoalSub_FPRec);
  };

  $USE(D_WorkPhysicalPrio);
  $USE(D_WorkCurrentPhysicalPrio);

  s_GetPriorityStackEntry(D_CurrentStackEntryPtr,D_WorkCurrentPhysicalPrio);
	/* $BO@M}"*J*M}JQ49(B */
  s_ConvertLogicalToPhysicalPriority( A_LogicalPriority, D_WorkPhysicalPrio );

  b_IfEqual(D_WorkPhysicalPrio,D_WorkCurrentPhysicalPrio) {
	/* (1.a) $B$b$7$bJ*M}%W%i%$%*%j%F%#$,F1$8$J$iOC$O4JC1(B */
    f_PushGoalToStack(A_GoalPtr);
    goto OK_End;
  }
  $USE(D_WorkGoalLink);
  $USE(D_WorkEntryPos);
  /* $B%W%C%7%e$7$h$&$H$9$k%4!<%k$NJ*M}%9%?%C%/%(%s%H%j$N>l=j$H(B	D_WorkEntryPos
     $B!J4{$K$"$k$+$bCN$l$J$$!K%4!<%k%j%s%/$rF@$k(B			D_WorkGoalLink
   */
  s_GetEntryPosition (D_WorkPhysicalPrio, D_WorkEntryPos);
  @DEBUG{
    b_IfEqual(D_WorkEntryPos,D_CurrentStackEntryPtr) {
      VPIM_ERROR("f_PushGoalToStackWithPriority_Sub",
		 "Why phisical priorities are not same??");
    }
  };
  s_GetGoalPtrStackEntry (D_WorkEntryPos, D_WorkGoalLink);

  b_IfNotEOL( D_WorkGoalLink ) {
    /*-- $B%4!<%k%j%s%/$,$"$k(B (1.b) --*/
    goto PUSH;
  }
  b_IfLess(D_WorkPhysicalPrio,D_WorkCurrentPhysicalPrio) {
	/* (1.c) $B8=:_<B9TCf$N$b$N$h$j$b%W%i%$%*%j%F%#$,Dc$$>l9g(B */
    $USE(D_WorkEntryHi);
    s_GetHighStackEntry (D_WorkEntryPos,D_WorkEntryHi);
    b_IfEOL(D_WorkEntryHi) {
      @DEBUG{
	$USE(D_WorkEntryLo);
	s_GetLowStackEntry (D_WorkEntryPos,D_WorkEntryLo);
	b_IfNotEOL(D_WorkEntryLo) {
	  VPIM_ERROR("f_PushGoalToStackWithPriority_Sub","Illegal Entry(1.b)");
	}
	$RELEASE(D_WorkEntryLo);
      };
      /*--- $B>e2<%j%s%/$N$J$+$C$?%(%s%H%j(B ---*/
      s_InsertAsLowerStackEntry (D_WorkEntryPos);
    }
    $RELEASE(D_WorkEntryHi);
    goto PUSH;
  }

  s_IfInvalidMaxPriority() {
	/* (2.a) $B$O$8$a$F8=:_$N$b$N$h$j9b$$%W%i%$%*%j%F%#%4!<%k$rF~$l$k(B */
    b_SetEventFlag (_HIGH_PRIO_GOAL_EVENT, D_PE_Number);
    s_InsertAsHighestStackEntry(D_WorkEntryPos,D_WorkCurrentPhysicalPrio);
    s_SetMaxPriority(D_WorkPhysicalPrio);
    goto PUSH;
  } else {
    p_Compare(D_WorkPhysicalPrio,D_Max_Priority);
    p_IfGT() {
	/* (3.a)-------------------------------------- */
      s_InsertAsHighestStackEntry(D_WorkEntryPos,D_Max_Priority);
      s_SetMaxPriority(D_WorkPhysicalPrio);
      goto PUSH;
    }
    p_IfLT() {
	/* (3.b)-------------------------------------- */
      $USE(D_WorkEntryHi);
      s_GetHighStackEntry (D_WorkEntryPos,D_WorkEntryHi);
      b_IfEOL(D_WorkEntryHi) {
	@DEBUG{
	  $USE(D_WorkEntryLo);
	  s_GetLowStackEntry (D_WorkEntryPos,D_WorkEntryLo);
	  b_IfNotEOL(D_WorkEntryLo) {
	    VPIM_ERROR("f_PushGoalToStackWithPriority_Sub",
		       "Illegal Entry (3.b)");
	  }
	  $RELEASE(D_WorkEntryLo);
	};
	/*--- $B%j%s%/$N$J$+$C$?%(%s%H%j(B ---*/
	s_InsertAsHigherStackEntry(D_WorkEntryPos);
      }
      $RELEASE(D_WorkEntryHi);
      goto PUSH;
    }
    else {
	/* (3.c)-------------------------------------- */
      @DEBUG{VPIM_ERROR("f_PushGoalToStackWithPriority_Sub","Illegal Point");};
    }
  }
 PUSH:
  @DEBUG{ s_StackEntryLinkCheck(D_CurrentStackEntryPtr); };
  s_PushGoalRecord (A_GoalPtr, D_WorkGoalLink);
  b_IncrementReg(D_GoalCntInStack);
  s_PutGoalPtrStackEntry (D_WorkEntryPos, D_WorkGoalLink);
  $RELEASE(D_WorkGoalLink);
  $RELEASE(D_WorkEntryPos);
 OK_End:
  $RELEASE(D_WorkPhysicalPrio);
  $RELEASE(D_WorkCurrentPhysicalPrio);
  $RETURN ();
}

/******************************************************************** PSL **
3. $B:G9b0L%W%i%$%*%j%F%#$N(BD_CurrentGoalStackPtr $B$rF@$k(B

       written by goto@icot22      on Wed Mar 29 17:12:40 1989

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
  D_Max_Priority = D_WorkCurrentPriority
<Function>
  D_CurrentGoalStackPtr $B$,(B EOL$B$N;~(B, $B8=:_$N(BD_Max_Priority (= D_WorkCurrentPriority)
  $B$h$jDc$$%W%i%$%*%j%F%#$G6u$G$J$$%4!<%k%9%?%C%/%(%s%H%j$rC5$7(B, 
        D_Max_Priority 
  	D_CurrentGoalStackPtr
  $B$r99?7$9$k!#(B
  D_CurrentGoalStackPtr $B$,(B EOL$B$G$J$$;~$O(B No Operation.
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#SUBROUTINE f_GetHighestCurrentGoalStackPtr_Sub ()
{
  b_IfEOL (D_CurrentGoalStackPtr) {
    s_PutGoalPtrStackEntry(D_CurrentStackEntryPtr, D_CurrentGoalStackPtr);
    s_DeleteAsHighestStackEntry(D_CurrentStackEntryPtr);
	/* $B>e5-$N%^%/%m$G!"(BD_CurrentStackEntryPtr$B$O!"0l$D2<$N(B
	 * $B%W%i%$%*%j%F%#%9%?%C%/$r;X$9$h$&$K$J$k!#(B
	 */
    s_GetGoalPtrStackEntry (D_CurrentStackEntryPtr, D_CurrentGoalStackPtr);
    @DEBUG {
      b_IfEOL (D_CurrentGoalStackPtr){
	VPIM_ERROR("f_GetHighestCurrentGoalStackPtr_Sub","Illegal chain");
      }
    };
  }  /* end of b_IfEOL */
  $RETURN ();
}

/******************************************************************** PSL **
4. $B%+%l%s%H%4!<%k%]%$%s%?$NL58z2=!"M-8z!?L58zH=Dj(B
       written by goto@icot22      on Fri Sep  1 13:48:33 1989
<Arguments>
  ptr_to_gr : $B%4!<%k%l%3!<%I$X$N%]%$%s%?(B ($BDL>o(B D_ArgReg0)
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  f_MakeEmptyCGP : ptr_to_gr $B$N%l%8%9%?$r6u$K$9$k(B (D_NULL $B$r=q$/(B)
  f_IfEmptyCGP, f_IfNotEmptyCGP : ptr_to_gr $B$,6u$+$I$&$+D4$Y$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define f_MakeEmptyCGP (ptr_to_gr)
{
  p_MoveWord(D_NULL, ptr_to_gr);
}

#CTRL_define f_IfEmptyCGP (ptr_to_gr)
{
  b_IfWordEq(D_NULL, ptr_to_gr)
}

#CTRL_define f_IfNotEmptyCGP (ptr_to_gr)
{
  b_IfWordNotEq(D_NULL, ptr_to_gr)
}

/******************************************************************** PSL **
  $B<h$j=P$7$?%4!<%k$,<B9T2DG=$G$"$k$+$I$&$+$r%A%'%C%/$9$k%^%/%m(B

       written by imai@icot22      on Mon Nov 26 15:00:33 1990
<Arguments>
  goal_ptr   : $B<h$j=P$7$?%4!<%k$X$N%]%$%s%?(B $B!JDL>o(B D_ArgReg0$B!K(B
  old_fp_ptr : $BD>A0$^$G<B9T$7$F$$$?N$?F$X$N%]%$%s%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  $B<B9T2DG=$G$J$+$C$?>l9g$O!"(Bgoal_ptr $B$r(B D_NULL $B$K$9$k!#(B
  $B$3$NA`:n$O!"(Bf_MakeEmptyCGP( goal_ptr ) $B$G9T$J$C$F$$$k(B
<ETC>
********************************************************************* PSL **/

#PSL_define f_CheckGoalExecutable( goal_ptr, old_fp_ptr)
{
  @DEBUG{
    f_IfEmptyCGP( goal_ptr ) {
      VPIM_ERROR("f_CheckGoalExecutable","Illegal Invoke!");
    }
  };
  /*-- $B%W%i%$%*%j%F%#$HN$?F$N%Q!<%^%M%s%H%l%8%9%?$r@_Dj(B --*/
  s_SetCurrentEnvRecPtrAndFP( goal_ptr );
  /* $B$3$N$J$+$G(B D_Current_FP_Ptr $B$,%;%C%H$5$l$k(B */
  @DEBUG{
    s_IfNotFPREC(D_Current_FP_Ptr) {
      VPIM_ERROR("i_DequeueNewGoal_Sub","Illegal Type of D_Current_FP_Ptr");
    }
  };
  b_IfNotEqual( D_Current_FP_Ptr, old_fp_ptr ) {
				/*---  1. $BN$?F$,0c$C$?$i(B  ---*/
    $USE(D_WorkFPOrgLockTagReg);
    s_LockFPRecord( D_Current_FP_Ptr, D_WorkFPOrgLockTagReg );  
    s_IfNotRunnableFP( D_Current_FP_Ptr ) {
				/*-- 1.a $BN$?F$,<B9T2DG=>uBV$G$J$+$C$?$i(B ---*/
      $CALL( f_FPNotRunnableWithUnlock_Sub(D_WorkFPOrgLockTagReg, old_fp_ptr));
      $RELEASE(D_WorkFPOrgLockTagReg);
	   /* $B$3$NCf$GN$?F%l%3!<%I$r2s<}$9$k>l9g$,$"$k$?$a!"(B
              $BN$?F%l%3!<%I$N%"%s%m%C%/$O$3$NCf$G9T$J$&!#(B       */
           /* $BCm0U(B :
                $B?7$?$K%4!<%k%9%?%C%/$+$i<h$j=P$7$?%4!<%k$NN$?F$,<B9T2DG=>uBV$G(B
              $B$J$$;~$K$O!"$3$NItJ,$G%k!<%W$H$J$k!#(B
                $B$3$N;~!"D>A0$^$G<B9T$7$F$$$?%4!<%k$NN$?F$O(B old_fp_ptr $B$KBT(B
              $BHr$5$l$F$$$k$,!"%-%c%C%7%e;q8;$d%A%c%$%k%I%+%&%s%H$O$^$@N$?F%l%3(B
              $B!<%I$K=q$-La$5$l$F$$$J$$!#(B
                $BC"$7!"$3$NItJ,$G%k!<%W$7$F$$$k4V$O;q8;$NLd$$9g$o$;=hM}$J$I$O9T(B
              $B$J$o$l$J$$$O$:$G$"$k$?$a!"(B($B"+(B $B%9%j%C%H%A%'%C%/$,F~$i$J$$$+$i(B)
              $B<B32$O$J$$$O$:$G$"$k!#(B
           */
      /* $B!v!v!v<h$j=P$7$?%4!<%k$O!"<B9TIT2DG=$G$"$C$?!v!v!v(B */
      f_MakeEmptyCGP( goal_ptr );
    } else {
				/*--- 1.b $BN$?F$,<B9T2DG=>uBV$@$C$?$i(B ---*/
       /* D_ResourceCache, D_Fork_Ctr$B$rJ]B8$9$k(B */
      $USE(D_WorkOldResourceCache);
      $USE(D_WorkOldForkCount);
      p_MoveWord(D_ResourceCache, D_WorkOldResourceCache);
      s_ReadForkCounterTo (D_WorkOldForkCount);
      
      s_IfProfilingFP(D_Current_FP_Ptr){
	f_SetSHProfMode();
      }else{
	f_ResetSHProfMode();
      }

      f_CacheFPResource( D_Current_FP_Ptr );
      @DEBUG{
	b_IfLessEq( D_ResourceCache, D_NULL) {
	/*--- $BN$?F%l%3!<%I$r%m%C%/$7$?$^$^$J$N$G!"(B
		$B%-%c%C%7%e$G$-$J$$$3$H$J$I$"$jF@$J$$(B ---*/
	  VPIM_ERROR("f_CheckGoalExecutable",
		     "Why Resource Cache Failed??(Different FP case)");
	}
      };

      /* D_Current_FP_Ptr $B$+$i$N%j%U%!%l%s%9$r%+%&%s%H$9$k(B */
      /* $B%j%U%!%l%s%9$rMn$9$N$O!"(Bf_MaintainOLdFP_Sub */
      s_EnsureFPExistance(D_Current_FP_Ptr,D_ONE);

      s_UnlockFPRecord( D_Current_FP_Ptr, D_WorkFPOrgLockTagReg );  
      $RELEASE(D_WorkFPOrgLockTagReg);
      b_IfEqual(D_NeedRequestResourceMsgFlag,D_ONE){
	$CALL(f_Send_IntClMsg_Request_Resource_Sub(D_Current_FP_Ptr));
	p_MoveWord(D_NULL,D_NeedRequestResourceMsgFlag);
      }
      $CALL( f_MaintainOldFP_Sub(old_fp_ptr, D_WorkOldResourceCache,
				                          D_WorkOldForkCount));
      $RELEASE(D_WorkOldResourceCache);
      $RELEASE(D_WorkOldForkCount);
      s_SetZeroForkCounter ();
      /* $B!v!v!v<h$j=P$7$?%4!<%k$O!"<B9T2DG=$G$"$C$?!v!v!v(B */
      @DEBUG{ f_IfEmptyCGP( goal_ptr ) {
	VPIM_ERROR("f_CheckGoalExecutable","Why?? Unbelievable??");
      }};
    }
  } else {				/*---  2. $BN$?F$,F1$8$J$i(B  ---*/
    b_IfLessEq( D_ResourceCache, D_NULL) {
					/*--- 2.A $B%j%=!<%9%-%c%C%7%e$,6u$J$i(B */
      $USE(D_WorkFPOrgLockTagReg);
      s_LockFPRecord( D_Current_FP_Ptr, D_WorkFPOrgLockTagReg );  
      s_IfNotRunnableFP( D_Current_FP_Ptr ) {
				/*-- 2.A.a $BN$?F$,<B9T2DG=>uBV$G$J$+$C$?$i(B -*/
	$CALL( f_FPNotRunnableWithUnlock_Sub(D_WorkFPOrgLockTagReg,
					     old_fp_ptr ));
	$RELEASE(D_WorkFPOrgLockTagReg);
	      /* $B$3$NCf$GN$?F%l%3!<%I$r2s<}$9$k>l9g$,$"$k$?$a!"(B
		$BN$?F%l%3!<%I$N%"%s%m%C%/$O$3$NCf$G9T$J$&!#(B       */
	/* $B!v!v!v<h$j=P$7$?%4!<%k$O!"<B9TIT2DG=$G$"$C$?!v!v!v(B */
	f_MakeEmptyCGP( goal_ptr );
      } else {
				/*-- 2.A.b $BN$?F$,<B9T2DG=>uBV$J$i$P(B -*/
	f_CacheFPResource( D_Current_FP_Ptr );
	@DEBUG{
	  b_IfLessEq( D_ResourceCache, D_NULL) {
	    /*--- $BN$?F%l%3!<%I$r%m%C%/$7$?$^$^$J$N$G!"(B
	      $B%-%c%C%7%e$G$-$J$$$3$H$J$I$"$jF@$J$$(B ---*/
	    VPIM_ERROR("f_CheckGoalExecutable",
		       "Why Resource Cache Failed??(Same FP case)");
	  }
	};
	s_UnlockFPRecord( D_Current_FP_Ptr, D_WorkFPOrgLockTagReg );  
	$RELEASE(D_WorkFPOrgLockTagReg);
	b_IfEqual(D_NeedRequestResourceMsgFlag,D_ONE){
	  $CALL(f_Send_IntClMsg_Request_Resource_Sub(D_Current_FP_Ptr));
	  p_MoveWord(D_NULL,D_NeedRequestResourceMsgFlag);
	}
	/* $B!v!v!v<h$j=P$7$?%4!<%k$O!"<B9T2DG=$G$"$C$?!v!v!v(B */
	@DEBUG{ f_IfEmptyCGP( goal_ptr ) {
	  VPIM_ERROR("f_CheckGoalExecutable","Why?? Unbelievable??");
	}};
      }
    } else {
    				/*-- 2.B $B%j%=!<%9%-%c%C%7%e$,$"$l$P(B -*/
      /* $B0lHVB?$$%1!<%9$,$3$3$N(B $B!JF1$8N$?F!K!u!J%j%=!<%9%-%c%C%7%e$,$"$l$P!K(B
         $B$G$"$k$HM=A[$5$l$k$,!"$3$N>l9g<B$O2?$b$9$kI,MW$O$J$$(B */
      @DEBUG{ f_IfEmptyCGP( goal_ptr ) {
	VPIM_ERROR("f_CheckGoalExecutable","Why?? Unbelievable??");
      }};
    }
  }
}

/******************************************************************** PSL **
 $B9b$$%W%i%$%*%j%F%#%4!<%k$,H/@8$7$?;~$K!"%4!<%k%9%?%C%/$r99?7$9$k(B
       written by imai@icot22      on Fri Apr 26 19:07:23 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define f_UpdateCurrentPhyPrioGoal()
{
  s_PutGoalPtrStackEntry (D_CurrentStackEntryPtr, D_CurrentGoalStackPtr);
	/* D_CurrentStackEntryPtr $B$,;X$9%(%s%H%j$N%4!<%k$X$N%]%$%s%?$r(B
	 * D_CurrentGoalStackPtr $B$H$9$k(B.
	 */
  @DEBUG{
    s_IfInvalidMaxPriority() {
      VPIM_ERROR("f_UpdateCurrentPhyPrioGoal","Illegal Max Priority");
    }
  };
  s_GetEntryPosition(D_Max_Priority, D_CurrentStackEntryPtr);
  s_GetGoalPtrStackEntry (D_CurrentStackEntryPtr, D_CurrentGoalStackPtr);
}
