
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_reduce_floating_point.psl.c
   ----- CREATED   : by yamamoto@icot22, on Mon Aug  5 21:59:48 1991
   ----- LAST SAVED: by yamamoto@icot22, on Tue Apr 14 15:56:22 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : 
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

#DATA_define D_WorkFLTEqual1 XXX
#DATA_define D_WorkFLTEqual2 XXX

#CTRL_define f_IfFloatingNotEqual(src_reg1, src_reg2){
  @DEBUG{
    s_IfNotFLT(src_reg1) {VPIM_ERROR("f_IfFloatingNotEqual", "Illegal Type"); }
    s_IfNotFLT(src_reg2) {VPIM_ERROR("f_IfFloatingNotEqual", "Illegal Type"); }
  };
  $USE(D_WorkFLTEqual1);
  $USE(D_WorkFLTEqual2);
  b_ReadFLTMSWord(src_reg1,D_WorkFLTEqual1);
  b_ReadFLTMSWord(src_reg2,D_WorkFLTEqual2);
  p_Compare(D_WorkFLTEqual1,D_WorkFLTEqual2);
  $RELEASE(D_WorkFLTEqual1);
  $RELEASE(D_WorkFLTEqual2);
  p_IfEQ(){
    $USE(D_WorkFLTEqual1);
    $USE(D_WorkFLTEqual2);
    b_ReadFLTLSWord(src_reg1,D_WorkFLTEqual1);
    b_ReadFLTLSWord(src_reg2,D_WorkFLTEqual2);
    p_Compare(D_WorkFLTEqual1,D_WorkFLTEqual2);
    $RELEASE(D_WorkFLTEqual1);
    $RELEASE(D_WorkFLTEqual2);
  }
  p_IfNE()
}

#CTRL_define f_IfFloatingEqual(src_reg1, src_reg2){
  @DEBUG{
    s_IfNotFLT(src_reg1) {VPIM_ERROR("f_IfFloatingNotEqual", "Illegal Type"); }
    s_IfNotFLT(src_reg2) {VPIM_ERROR("f_IfFloatingNotEqual", "Illegal Type"); }
  };
  $USE(D_WorkFLTEqual1);
  $USE(D_WorkFLTEqual2);
  b_ReadFLTMSWord(src_reg1,D_WorkFLTEqual1);
  b_ReadFLTMSWord(src_reg2,D_WorkFLTEqual2);
  p_Compare(D_WorkFLTEqual1,D_WorkFLTEqual2);
  $RELEASE(D_WorkFLTEqual1);
  $RELEASE(D_WorkFLTEqual2);
  p_IfEQ(){
    $USE(D_WorkFLTEqual1);
    $USE(D_WorkFLTEqual2);
    b_ReadFLTLSWord(src_reg1,D_WorkFLTEqual1);
    b_ReadFLTLSWord(src_reg2,D_WorkFLTEqual2);
    p_Compare(D_WorkFLTEqual1,D_WorkFLTEqual2);
    $RELEASE(D_WorkFLTEqual1);
    $RELEASE(D_WorkFLTEqual2);
  }
  p_IfEQ()
}


#PSL_define f_FloatingPointToIntegerAndCheckOverFlowException(src,dst){
  s_FPURegReadDoubleWord(src,D_FPU_REG0);

  p_FloatingPointToInteger(D_FPU_REG0,dst);
  p_IfOverflow() {    /* $B8=:_$O@0?t%*!<%P!<%U%m!<$ONc30(B */
    $USE (D_WorkOpCode); $USE (D_WorkExceptionCode);
    $USE(D_WorkExcepArgPos);
    b_SetImmTypeValueMRBoff 
      (INT, BLT_B_FLOATING_POINT_TO_INTEGER, D_WorkOpCode);
    b_SetImmTypeValueMRBoff
      (INT, _INTEGER_OVERFLOW_EXCP, D_WorkExceptionCode);
    p_MoveWord(D_NULL, D_WorkExcepArgPos);
    $CALL (f_Exception_2Arg_IO_Sub (D_WorkExceptionCode, D_WorkOpCode, 
				    D_WorkExcepArgPos,src,dst));
    $RELEASE (D_WorkOpCode); $RELEASE (D_WorkExceptionCode);
    $RELEASE(D_WorkExcepArgPos);
  }else{
    b_SetImmTypeMRBoff(INT,dst);
    s_IfMRBoff(src){s_ReclaimFLT(src);}
  }
}
