
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_reduce_exception_handler.psl.c
   ----- CREATED   : by f-hataza@icot22, on Tue May 15 11:57:21 1990
   ----- LAST SAVED: by imai@icot22, on Mon Mar 23 22:47:56 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : FUNCTIONS
   ----- ABSTRACT  : $BNc30!"<:GT=hM}(B

  KL1 $B%W%m%0%i%`Fb$GNc30!"<:GT$,@8$8$k860x$H$7$F$O0J2<$N9`L\$,9M$($i$l$k!#(B

$B!&%\%G%#It$G$N%f%K%U%#%1!<%7%g%s$N<:GT(B
$B!&%4!<%k$r<B9T$G$-$k@a$,B8:_$7$J$$(B
$B!&AH9~=R8lFb$G$NNc30(B ($B0z?tNc30!"1i;;Nc30(B)
$B!&Aq1`$NNc30(B ($B;q8;ITB-!"Ey(B)

  $BNc30$,@8$8$k$H!"Nc30$r5/$3$7$?%4!<%k$NN$?F$NB0$9$kAq1`$KNc30$,Js9p$5$l$k!#(B

     +--------+                                       +----------+
     |  $BN$?F(B  +-------->  [ $BM"=PF~I=7PM3(B ] ---------> |  $B?FAq1`(B  |
     |        |                                       |          |
     +--------+                                       +----------+
         ^ 
         | 
         | 
     +--------+
     | $B%4!<%k(B |
     +--------+
  
  'f_reduce_exception_handler.psl.c'$BFb$N3F%^%/%m$O(B'f_shoen_report.psl.c'$BFb$N(B
$B%^%/%m$r8F$S=P$7$=$NCf$G?FAq1`$N%l%]!<%H%9%H%j!<%`$K<:GT(B, $BNc30$N>pJs$rEA$($F(B
$B$$$k!#(B
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
  f_FailActiveUnify_Sub

       written by nakase@icot22      Wed Jan 11 20:13:02 1989

<Arguments>
  A_Term1: $B%f%K%U%#%1!<%7%g%s<:GT$N860x$H$J$C$?9`(B1 (register)
  A_Term2: $B%f%K%U%#%1!<%7%g%s<:GT$N860x$H$J$C$?9`(B2 (register)
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B%"%/%F%#%V%f%K%U%#%1!<%7%g%s<:GT$N>pJs$rAq1`$N%l%]!<%H%9%H%j!<%`$KN.$9!#(B
<Examples>
<Test>
<Explanation>
  $B%l%]!<%H%9%H%j!<%`$KN.$l$k%a%C%;!<%8$N7A<0!#(B
{shoen#exception, ExceptionNumber, {ProcessorId,Term1,Term2}, NewCode, NewArgv}

<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkNewCode XXX
#DATA_define D_WorkNewArgv XXX
#DATA_define D_WorkArgVect XXX
#DATA_define D_WorkExceptionTag XXX   /* !! $BNc30%U%)!<%^%HJQ99$KH<$$?75,DI2C(B */
#DATA_define D_WorkExceptionNumber XXX
#DATA_define D_WorkExcepInfoVect   XXX

#SUBARG_define	A_Term1		SRC
#SUBARG_define	A_Term2		SRC

#SUBROUTINE f_FailActiveUnify_Sub(A_Term1, A_Term2)
{

  /* $BBe$o$j$K<B9T$5$l$k%4!<%k$rF~$l$kJQ?t$r:n$k(B */
  $USE(D_WorkNewCode);
  $USE(D_WorkNewArgv);
  s_AllocVariable(D_WorkNewCode); 
  s_AllocVariable(D_WorkNewArgv);

  f_DcodeEnqueue2OpeWithoutParentInfo_II
    (BLT_B_APPLY, D_WorkNewCode, D_WorkNewArgv);

  $USE(D_WorkExcepInfoVect);
  f_MakeExcpArgVect( _THREE, D_WorkExcepInfoVect);
                   /* Unification_failure$B$K4X$9$k>pJs$r!"%Y%/%?$KF~$l$k(B */

  f_Put3ArgsArgVect(D_WorkExcepInfoVect, D_ExceptionProcId, A_Term1, A_Term2);

  $USE(D_WorkExceptionTag);  /* !! $BDI2C(B */
  $USE(D_WorkExceptionNumber);
  b_SetImmValueDNTC(_UNIFICATION_FAILURE_EXCP, D_WorkExceptionNumber);

  /* !! $BDI2C(B */
  f_ConvertExceptionNumberToTag(D_WorkExceptionNumber, D_WorkExceptionTag);

  $CALL(f_Send_IntClMsg_Exception_Sub(D_WorkExceptionTag,  /* !! $BDI2C(B */
				      D_WorkExceptionNumber, 
				      D_WorkExcepInfoVect,
				      D_WorkNewCode, D_WorkNewArgv,
				      D_Current_FP_Ptr) );

  $RELEASE(D_WorkExceptionTag);  /* !! $BDI2C(B */
  $RELEASE(D_WorkExceptionNumber);
  $RELEASE(D_WorkExcepInfoVect);
  
  $RELEASE(D_WorkNewCode);
  $RELEASE(D_WorkNewArgv);

  $RETURN ();
}

/******************************************************************** PSL **
 f_Fail
 f_Failue_Sub
       written by nakase@icot22      on $BJ?@.(B01$BG/(B01$B7n(B18$BF|(B($B?eMKF|(B) 16$B;~(B53$BJ,(B54$BIC(B
<Arguments>	none
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B%,!<%IIt$G<:GT(B (klb_suspend $B$G%5%9%Z%s%I%9%?%C%/$,6u(B) $B$7$?%4!<%k$K$D$$$F(B,
  	a. $B$=$N%4!<%k0z?t(B($B%Y%/%?(B),
  	b. $BL?Na%"%I%l%9(B($B8=:_$O(Bkbl_suspend$BL?Na$N%"%I%l%9(B),
  	c. $BBe$o$j$K<B9T$5$l$k%4!<%k$rF~$l$kJQ?t(B (apply$BMQ$K(B2$B8D(B)
  $B$r4^$`(BFAILURE$B>pJs$r(B, $BAq1`$N%l%]!<%H%9%H%j!<%`$K>e$2$k!#(B

  $B$^$?(B, $B>e5-(B c. $B$NJQ?t$K(B, apply $B%4!<%k$r%U%C%/$7$F$*$/!#(B

<Examples>
  invoked by klb_suspend and klb_failure
<Test>
<Explanation>
  $B%l%]!<%H%9%H%j!<%`$KN.$l$k%a%C%;!<%8$N7A<0!#(B
{shoen#exception, ExceptionNumber, {ProcessorID, Code, Argv}, NewCode, NewArgv}
<ETC>
  f_Fail $B$O!"(BV02$B$G$O(Binterpreter$B%l%Y%k$K$"$C$?%^%/%m(B(i_Fail)$B$G$"$k!#(B
********************************************************************* PSL **/

#DATA_define D_WorkCodePtr	XXX

#PSL_define f_Fail()
{

  $CALL( f_Failure_Sub() );
  s_ReclaimGoalRecord( D_ArgReg0 );
  f_MakeEmptyCGP ( D_ArgReg0 );
  s_DecrementForkCounter();
  /* 
   *  fail$B$N$H$-$O!"$3$N%4!<%k$,$*$o$C$?$H9M$($F!"(B $BN$?F$N%A%c%$%k%I%+%&%s%H$r(B
   *  1$B$D$X$i$9!#(B 
   */
}

#SUBROUTINE f_Failure_Sub() 
{
  $USE(D_WorkNewCode); 
  $USE(D_WorkNewArgv);
  s_AllocVariable(D_WorkNewCode); 
  s_AllocVariable(D_WorkNewArgv);
        /* $BBe$o$j$K<B9T$5$l$k%4!<%k$rF~$l$kJQ?t$r:n$k(B */

  f_DcodeEnqueue2OpeWithoutParentInfo_II
    (BLT_B_APPLY, D_WorkNewCode, D_WorkNewArgv);

  $USE(D_WorkCodePtr); 
  $USE(D_WorkArgVect); 
  s_GetCodeGoalRecord(D_ArgReg0, D_WorkCodePtr);
  f_GetArgVectFromGoalRecord(D_WorkArgVect,D_ArgReg0);

  $USE(D_WorkExcepInfoVect);
  f_MakeExcpArgVect( _THREE, D_WorkExcepInfoVect);
                   /* Reduction_failure$B$K4X$9$k>pJs$r!"%Y%/%?$KF~$l$k(B */

  f_Put3ArgsArgVect(D_WorkExcepInfoVect, D_ExceptionProcId, D_WorkCodePtr,
		    D_WorkArgVect);

  $RELEASE(D_WorkCodePtr); 
  $RELEASE(D_WorkArgVect); 

  $USE(D_WorkExceptionTag);  /* !! $BDI2C(B */
  $USE(D_WorkExceptionNumber);
  b_SetImmValueDNTC(_REDUCTION_FAILURE_EXCP, D_WorkExceptionNumber);

  /* !! $BDI2C(B */
  f_ConvertExceptionNumberToTag(D_WorkExceptionNumber, D_WorkExceptionTag);

  $CALL(f_Send_IntClMsg_Exception_Sub(D_WorkExceptionTag,  /* !! $BDI2C(B */
				      D_WorkExceptionNumber, 
				      D_WorkExcepInfoVect,
				      D_WorkNewCode, D_WorkNewArgv,
				      D_Current_FP_Ptr) );

  $RELEASE(D_WorkExceptionTag);  /* !! $BDI2C(B */
  $RELEASE(D_WorkExceptionNumber);
  $RELEASE(D_WorkExcepInfoVect);
  $RELEASE(D_WorkNewCode);
  $RELEASE(D_WorkNewArgv); 
  
  $RETURN ();
}

/******************************************************************** PSL **
$B1J5WCfCG%4!<%k$N8!=P$K$h$k(B Raise
       written by imai@icot22      on Sat Oct 13 17:06:23 1990
<Arguments>
  A_GoalPtr : $B1J5WCfCG$7$?%4!<%k$X$N%]%$%s%?(B
  A_Type    : $B1J5WCfCG$N<oN`(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
$B0l3g#G#C$*$h$S!"(B%release $B%a%C%;!<%8$K$h$k>l9g!"(B
	{CLandPE, Type, Predicate, Inputs}
$BDL>o<B9T;~$N>l9g!"(B
	{CLandPE, Type, Predicate, Inputs, Collector}
$B$N(B $BNc30(B Info Vector $B$r@8@.$9$k!#(B

$B$3$3$G!"(BPredicate/Collector $B$O!"(B
	$BDL>o%4!<%k$N>l9g!"$=$N%4!<%k$N(B COD $B%]%$%s%?!"(B
	$BAH$_9~$_=R8l$N>l9g!"(B{BltID, Module, Offset}
$B$H$J$k!#(B

<Examples>
<Test>
<Explanation>
  A_Collector $B$O!"HH?M$,$o$+$k>l9g$O!"(B    COD or {BltID, Module, Offset}$B!"(B
			$B$o$+$i$J$$>l9g$O!"(BEOL
<ETC>
  $B0l3g#G#C$G$N8!=P$HB(;~#G#C$G$N8!=P$N%k!<%A%s$r6&MQ$7$F$$$k$?$a!"(B
  $BN$?F%l%3!<%I!"4D6-%l%3!<%I$J$I$r<h$j=P$9=hM}$,F~$C$F$$$k!#(B
********************************************************************* PSL **/
#DATA_define	D_WorkDeadlockType	XXX /* A_Type $B$KMQ$$$i$l$k$3$H$r4|BT(B */
#DATA_define	D_WorkNewEnvRecPtr	XXX
#DATA_define	D_WorkCollectorInfo	XXX
#DATA_define	D_WorkCollectorInfo2	XXX

#SUBARG_define	A_GoalPtr	SRC
#SUBARG_define	A_Type		SRC
#SUBARG_define	A_Collector	SRC

#SUBROUTINE f_PerpetualSuspensionException_Sub(A_GoalPtr, A_Type, A_Collector)
{
  @DEBUG{
    s_IfNotSingleHookGrp(A_GoalPtr) {
      VPIM_ERROR("f_PerpetualSuspensionException_Sub","Illegal A_GoalPtr");
    }
    s_IfNotINT(A_Type) {
      VPIM_ERROR("f_PerpetualSuspensionException_Sub","Not Int A_Type");
    }
    TypeSwitch( A_Collector ) {
    case EOL: case VECT3: case COD: break;
    default:
      VPIM_ERROR("f_PerpetualSuspensionException_Sub","Illegal A_Collector");
    }
  };
  b_SetImmTypeMRBoff(HOOK,A_GoalPtr);

  /*--- check foster-parent's status --- 1992.03.23 */
  $USE(D_WorkFPPtr);
  s_GetFosterparentGoalRecord(A_GoalPtr,D_WorkFPPtr);
  $USE(D_WorkFPOrgLockTagReg);
  s_LockFPRecord(D_WorkFPPtr, D_WorkFPOrgLockTagReg);
  s_IfAbortedOrAbortedTerminateFP(D_WorkFPPtr) {
    s_UnlockFPRecord(D_WorkFPPtr, D_WorkFPOrgLockTagReg);
    $RELEASE(D_WorkFPOrgLockTagReg); $RELEASE(D_WorkFPPtr);
    $RETURN();
  } else {
    s_UnlockFPRecord(D_WorkFPPtr, D_WorkFPOrgLockTagReg);
    $RELEASE(D_WorkFPOrgLockTagReg); $RELEASE(D_WorkFPPtr);
  }
  /*--- end of check foster-parent's status --- 1992.03.23 */

  $USE(D_WorkNewCode); 
  $USE(D_WorkNewArgv);
  s_AllocVariable(D_WorkNewCode); 
  s_AllocVariable(D_WorkNewArgv);
        /* $BBe$o$j$K<B9T$5$l$k%4!<%k$rF~$l$kJQ?t$r:n$k(B */

  $USE(D_WorkEnvRecPtr);  $USE(D_WorkNewEnvRecPtr);
  s_GetEnvRecGoalRecord( A_GoalPtr, D_WorkEnvRecPtr );
  f_MakeNonDebugEnvRecord( D_WorkEnvRecPtr, D_WorkNewEnvRecPtr );
  $USE(D_WorkFPPtr);
  s_GetFosterparentGoalRecord( A_GoalPtr, D_WorkFPPtr );
  f_DcodeEnqueue2OpeWithEnvRecAndFPPtr_II
    (BLT_B_APPLY, D_WorkNewEnvRecPtr,D_WorkFPPtr,D_WorkNewCode, D_WorkNewArgv);
  $RELEASE(D_WorkFPPtr);
  $RELEASE(D_WorkNewEnvRecPtr); $RELEASE(D_WorkEnvRecPtr);

	/* InfoVector $B$r:n@.$9$k(B */
  $USE(D_WorkPredInfo);
  $USE(D_WorkArgVect); 
  $USE(D_WorkExcepInfoVect);
  $CALL( f_MakePredicateInfo_NotCurrentGoal_Sub
	( A_GoalPtr, D_WorkPredInfo ));
  f_GetArgVectFromGoalRecord(D_WorkArgVect,A_GoalPtr);
  b_IfEOL( A_Collector ) {
    f_MakeExcpArgVect( _SIZE_OF_ARGV4, D_WorkExcepInfoVect);
    f_Put4ArgsArgVect(D_WorkExcepInfoVect, D_ExceptionProcId,
		      A_Type, D_WorkPredInfo, D_WorkArgVect);
  } else {
    f_MakeExcpArgVect( _SIZE_OF_ARGV5, D_WorkExcepInfoVect);
    f_Put5ArgsArgVect( D_WorkExcepInfoVect, D_ExceptionProcId,
		      A_Type, D_WorkPredInfo, D_WorkArgVect, A_Collector );
  }
  $RELEASE(D_WorkPredInfo); 
  $RELEASE(D_WorkArgVect); 

  $USE(D_WorkExceptionTag);  /* !! $BDI2C(B */
  $USE(D_WorkExceptionNumber);
  b_SetImmValueDNTC(_DEADLOCK_EXCP, D_WorkExceptionNumber);
  $USE(D_WorkFPPtr);
  s_GetFosterparentGoalRecord(A_GoalPtr,D_WorkFPPtr);

  /* !! $BDI2C(B */
  f_ConvertExceptionNumberToTag(D_WorkExceptionNumber, D_WorkExceptionTag);

  $CALL(f_Send_IntClMsg_Exception_Sub(D_WorkExceptionTag,  /* !! $BDI2C(B */
				      D_WorkExceptionNumber, 
				      D_WorkExcepInfoVect,
				      D_WorkNewCode, D_WorkNewArgv,
				      D_WorkFPPtr) );

  $RELEASE(D_WorkExceptionTag);  /* !! $BDI2C(B */
  $RELEASE(D_WorkExceptionNumber);
  $RELEASE(D_WorkExcepInfoVect);
  $RELEASE(D_WorkNewCode);
  $RELEASE(D_WorkNewArgv); 
  $USE(D_WorkFPOrgLockTagReg);
  s_LockFPRecord( D_WorkFPPtr, D_WorkFPOrgLockTagReg );
  s_DecrementFPChildCount( D_WorkFPPtr );
  s_UnlockFPRecord( D_WorkFPPtr, D_WorkFPOrgLockTagReg );
  $RELEASE(D_WorkFPOrgLockTagReg);
  $RELEASE(D_WorkFPPtr);
  s_ReclaimGoalRecord( A_GoalPtr );
  
  $RETURN ();
}

/******************************************************************** PSL **
  $B%^!<%8%c$N1J5WCfCG(B
       written by imai@icot22      on Wed Jan 16 19:28:21 1991

  f_MergerPerpetualSuspensionExceptionl_Sub
	(A_MergerRecPtr,A_Type,A_NumberOfLostInputs)
    $B"*(B  MGHOK $B$H(B VOID $B$N%f%K%U%!%$(B
	MGHOK $B$X$N(B Collect_Value
	MGHOK $B$H!"(BREFo--> HOOKo $B$H$N%f%K%U%!%$(B
	$B0l3g(B GC
<Arguments>
  A_MergerRecPtr : $B1J5WCfCG$K4Y$C$?%^!<%8%c%l%3!<%I$X$N%]%$%s%?(B
  A_Type : $B8!=P$N%?%$%W(B (INT) $B$G!"CMIt$O0J2<$N$$$:$l$+(B
	_DEADLOCK_NORMAL_GOAL_BY_GC
	_DEADLOCK_BY_COLLECT_VALUE
		klb_collect_value $B$G!"(BREFo ---> MGHOK
	_DEADLOCK_BY_HOOK_HOOK_UNIFY
		REFo ---> MGHOK $B$H!"(BREFo ---> HOOKo
		REFo ---> MGHOK $B$H!"(BREFo ---> MGHOK
	_DEADLOCK_BY_VOID_HOOK_UNIFY
		REFo ---> MGHOK $B$H!"(BREFo ---> VOIDo
	_DEADLOCK_BY_RELEASE_MESSAGE
		REFo ---> EMGHOK $B$K(B %release $B$,FO$$$?(B
  A_NumberOfLostInputs: $B<:$C$?F~NO$N?t(B
	$BDL>o<B9T;~$KH/8+$7$?>l9g$O!"#1(B
	$B0l3g(BGC$B$GH/8+$7$?>l9g$O!"$=$N;~$N;2>H%+%&%s%H(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
$B0l3g#G#C$*$h$S!"(B%release $B%a%C%;!<%8$K$h$k>l9g!"(B
	{CLandPE, Type, {BltID(merge), OrgMod, OrgOfst}, Inputs}
$BDL>o<B9T;~$N>l9g!"(B
	{CLandPE, Type, {BltID(merge), OrgMod, OrgOfst}, Inputs, Collector}
$B$N(B $BNc30(B Info Vector $B$r@8@.$9$k!#(B

$B$3$3$G!"(BInputs $B$O!"<N$F$i$l$?%^!<%8%cF~NO$G$"$j!"(BA_NumberOfLostInputs $B$N(B
$BMWAG%Y%/%?$G!"MWAG$O$9$Y$F!"(BREFo --> MGHOK $B$H$J$k!#(B

  Collector $B$O!"8=:_$N(B D_KLB_PC $B$r85$K$7$?(B MODULE OFFSET $B$N%Z%"$G$"$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
	$B0l3g#G#C$GK\?t$N8:>/$N8!=P$O!"L$%3!<%G%#%s%0$G$"$k!#(B
********************************************************************* PSL **/

#SUBARG_define	A_MergerRecPtr		SRC
#SUBARG_define	A_Type			SRC
#SUBARG_define	A_NumberOfLostInputs	MODIFY
#SUBARG_define	A_Collector		SRC

#SUBROUTINE f_MergerPerpetualSuspensionException_Sub
	(A_MergerRecPtr, A_Type, A_NumberOfLostInputs, A_Collector)
{
  @DEBUG{
    s_IfNotMGHOK(A_MergerRecPtr) {
      VPIM_ERROR("f_MergerPerpetualSuspensionExceptionFinal_Sub",
		 "Illegal Type (A_MergerRecPtr)");
    }
  };

  /*--- check foster-parent's status --- 1992.03.23 */
  $USE(D_WorkFPPtr);
  s_GetMergerFPPtr(A_MergerRecPtr,D_WorkFPPtr);
  $USE(D_WorkFPOrgLockTagReg);
  s_LockFPRecord(D_WorkFPPtr, D_WorkFPOrgLockTagReg);
  s_IfAbortedOrAbortedTerminateFP(D_WorkFPPtr) {
    s_UnlockFPRecord(D_WorkFPPtr, D_WorkFPOrgLockTagReg);
    $RELEASE(D_WorkFPOrgLockTagReg); $RELEASE(D_WorkFPPtr);
    $RETURN();
  } else {
    s_UnlockFPRecord(D_WorkFPPtr, D_WorkFPOrgLockTagReg);
    $RELEASE(D_WorkFPOrgLockTagReg); $RELEASE(D_WorkFPPtr);
  }
  /*--- end of check foster-parent's status --- 1992.03.23 */

  	/* Inputs $B$r:n@.$9$k(B */
  $USE(D_WorkVectPtr); $USE(D_WorkPtrToMGHOK);
  @DEBUG{ b_IfZero(A_NumberOfLostInputs) {
    VPIM_ERROR("f_MergerPerpetualSuspensionException_Sub",
	       "Not Perpetual Suspension");
  }};

  $CALL(f_AllocVectorMRBoff_Sub(A_NumberOfLostInputs, D_WorkVectPtr ));
  LOOP() {
    b_DecrementReg(A_NumberOfLostInputs);
    s_AllocMghok(A_MergerRecPtr,D_WorkPtrToMGHOK);
    s_PutVectElementPosReg
	(D_WorkVectPtr,A_NumberOfLostInputs,D_WorkPtrToMGHOK);
    b_IfZero(A_NumberOfLostInputs) { break; }
  }
  $RELEASE(D_WorkPtrToMGHOK);

  $USE(D_WorkPredInfo); $USE(D_WorkExcepInfoVect);
  s_MakePredicateInfoMerger(A_MergerRecPtr,D_WorkPredInfo);
  b_IfEOL( A_Collector ) {
    f_MakeExcpArgVect( _SIZE_OF_ARGV4, D_WorkExcepInfoVect);
    f_Put4ArgsArgVect( D_WorkExcepInfoVect, D_ExceptionProcId,
		      A_Type, D_WorkPredInfo, D_WorkVectPtr );
  } else {
    f_MakeExcpArgVect( _SIZE_OF_ARGV5, D_WorkExcepInfoVect);
    f_Put5ArgsArgVect( D_WorkExcepInfoVect, D_ExceptionProcId,
		      A_Type, D_WorkPredInfo, D_WorkVectPtr, A_Collector );
  }
  $RELEASE(D_WorkPredInfo); $RELEASE(D_WorkVectPtr);

  $USE(D_WorkExceptionTag);  /* !! $BDI2C(B */
  $USE(D_WorkExceptionNumber);
  b_SetImmValueDNTC(_MERGER_DEADLOCK_EXCP, D_WorkExceptionNumber);

  /* !! $BDI2C(B */
  f_ConvertExceptionNumberToTag(D_WorkExceptionNumber, D_WorkExceptionTag);

  $USE(D_WorkFPPtr);
        /* $BBe$o$j$K<B9T$5$l$k%4!<%k$r:n$k(B */
  $USE(D_WorkNewCode);
  $USE(D_WorkNewArgv); 
  $CALL(f_CreateSubstituteApplyGoalOfMerger_Sub
	(A_MergerRecPtr, D_WorkFPPtr, D_WorkNewCode, D_WorkNewArgv));
  $CALL(f_Send_IntClMsg_Exception_Sub(D_WorkExceptionTag,  /* !! $BDI2C(B */
				      D_WorkExceptionNumber, 
				      D_WorkExcepInfoVect,
				      D_WorkNewCode, D_WorkNewArgv,
				      D_WorkFPPtr) );

  $RELEASE(D_WorkExceptionTag);  /* !! $BDI2C(B */
  $RELEASE(D_WorkExceptionNumber);
  $RELEASE(D_WorkExcepInfoVect);
  $RELEASE(D_WorkNewCode);
  $RELEASE(D_WorkNewArgv); 
  $RELEASE(D_WorkFPPtr);
  /*--- $B%^!<%8%c$N>l9g$O!"%W%m%;%9$,=*N;$7$J$$(B
	( NewInput $B$rMQ0U$9$k$?$a(B ) ---*/
  $RETURN ();
}

/******************************************************************** PSL **
$B%^!<%8%c$KBP$9$kIT@5F~NO(B
f_IllegalMergerInputException_Sub

       written by imai@icot22      on Thu Apr 18 10:58:40 1991
<Arguments>
 A_PtrToMGHOK:   $B%?%$%W$O(B REF (*A_PtrToMGHOK = A_MergerRecPtr)
 A_MergerRecPtr: $B%?%$%W$O(B MGHOK
 A_IllegalInput: $B%?%$%W$OITL@(B ($B$?$@$7!"(B[],VECT,LIST $B$r=|$/(B)
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
  p :- true | merge({5,55},_).
<Test>
<Explanation>
  {ClsAndProc,Predicate,Input,Merger} $B$r(B Info $B$H$9$k%Y%/%?$r:n$j!"(B
  $BJs9p$9$k!#$3$3$G!"(BPredicate $B$O!"(B
	{b_merge $B$N(B Instruction ID, Module, Offset}
  $B$G$"$k!#(BModule, Offset $B$O!"%^!<%8%c%l%3!<%I$K5-O?$5$l$F$$$k!#(B
  Input $B$O!"IT@5$JF~NO(B (A_IllegalInput)$B!"(B
  Merger $B$O!"?7$?$K3d$jIU$1$?(B A_MergerRecPtr $B$r;X$9(B

<ETC>
  $B8=:_<B9TCf$NN$?F$G$O$J$/!"%^!<%8%c$N=jB0$9$k(B
  $BN$?F$X$NNc30Js9p$K$J$k$3$H$KCm0U!#(B
********************************************************************* PSL **/

#SUBARG_define A_PtrToMGHOK	SRC
#SUBARG_define A_MergerRecPtr	SRC
#SUBARG_define A_IllegalInput	SRC

#SUBROUTINE f_IllegalMergerInputException_Sub
		(A_PtrToMGHOK, A_MergerRecPtr, A_IllegalInput)
{
  @DEBUG{
    s_IfNotREF(A_PtrToMGHOK) {
      VPIM_ERROR("f_IllegalMergerInputException_Sub","Illegal A_PtrToMGHOK");
    }
    s_IfNotMGHOK(A_MergerRecPtr) {
      VPIM_ERROR("f_IllegalMergerInputException_Sub","Illegal A_MergerRecPtr");
    }
    s_IfVectors(A_IllegalInput) {
      VPIM_ERROR("f_IllegalMergerInputException_Sub","Not Illegal (VECT?)");
    }
    s_IfLIST(A_IllegalInput) {
      VPIM_ERROR("f_IllegalMergerInputException_Sub","Not Illegal (LIST)");
    }
  };

  $USE(D_WorkNewAllocVariable);
  s_IfMRBon(A_PtrToMGHOK) {
    /* MGHOK $B%X$N%]%$%s%?$,9u$$>l9g$O!"(Billegal_arg $B$G%P%$%s%I$9$k(B */
    f_IfFailActUnifyWithPtrMRBX(A_PtrToMGHOK, A_MergerRecPtr, A_IllegalInput) {
	  /*---  $B4{$K=q$-JQ$o$C$F$$$?>l9g$O!"(BD-Code $B$G%j%H%i%$$9$k(B ---*/
      $CALL( f_UnifyRetryByDcode_Sub(A_PtrToMGHOK,A_IllegalInput) );
      $RETURN();
    }
    /* New Input $B$r3d$jIU$1$k(B */
    s_AllocMghok(A_MergerRecPtr, D_WorkNewAllocVariable);
  } else {
    /* New Input $B$O!":FMxMQ$9$k!#(B*/
    p_MoveWord(A_PtrToMGHOK, D_WorkNewAllocVariable);
  }

  $USE(D_WorkExcepInfoVect);
  f_MakeExcpArgVect( _FOUR, D_WorkExcepInfoVect);


  $USE(D_WorkPredicateInfo);
  s_MakePredicateInfoMerger(A_MergerRecPtr, D_WorkPredicateInfo);

  f_Put4ArgsArgVect(D_WorkExcepInfoVect,D_ExceptionProcId,D_WorkPredicateInfo,
		    A_IllegalInput,D_WorkNewAllocVariable);
  $RELEASE(D_WorkPredicateInfo);
  $RELEASE(D_WorkNewAllocVariable);

  $USE(D_WorkFPPtr);
  $USE(D_WorkNewCode); $USE(D_WorkNewArgv);
  $CALL(f_CreateSubstituteApplyGoalOfMerger_Sub
	(A_MergerRecPtr, D_WorkFPPtr, D_WorkNewCode, D_WorkNewArgv));

  $USE(D_WorkExceptionTag);  /* !! $BDI2C(B */
  $USE(D_WorkExceptionNumber);
  b_SetImmValueDNTC(_ILLEGAL_MERGER_INPUT_EXCP , D_WorkExceptionNumber);

  /* !! $BDI2C(B */
  f_ConvertExceptionNumberToTag(D_WorkExceptionNumber, D_WorkExceptionTag);

  $CALL(f_Send_IntClMsg_Exception_Sub(D_WorkExceptionTag,  /* !! $BDI2C(B */
				      D_WorkExceptionNumber, 
				      D_WorkExcepInfoVect,
				      D_WorkNewCode, D_WorkNewArgv,
				      D_WorkFPPtr) );
  $RELEASE(D_WorkNewCode); $RELEASE(D_WorkNewArgv);
  $RELEASE(D_WorkExceptionTag);  /* !! $BDI2C(B */
  $RELEASE(D_WorkExceptionNumber);
  $RELEASE(D_WorkExcepInfoVect);
  $RELEASE(D_WorkFPPtr);
  $RETURN();
}

/******************************************************************** PSL **
 $B%^!<%8%c$NNc30H/@8;~$K!"BeBX%4!<%k$r:n@.$9$k!#(B
 f_CreateSubstituteApplyGoalOfMerger_Sub

       written by imai@icot22      on Thu Apr 18 10:58:38 1991

<Arguments>
A_PtrToMerger:	(src) $B%^!<%8%c%l%3!<%I$X$N%]%$%s%?(B (MGHOK)
A_FPPtr:	(dst) $B%^!<%8%c$N=jB0$9$kN$?F$X$N%]%$%s%?(B
A_NewCode:	(dst) $BBeBX%4!<%k$N%3!<%I$X$N%]%$%s%?(B
A_NewArgv:	(dst) $BBeBX%4!<%k$N0z?t$X$N%]%$%s%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
  Illegal Input, Perpetual Suspension $B$G6&DL$K;H$&(B
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#SUBARG_define A_PtrToMerger SRC
#SUBARG_define A_FPPtr DST
#SUBARG_define A_NewCode DST
#SUBARG_define A_NewArgv DST

#SUBROUTINE f_CreateSubstituteApplyGoalOfMerger_Sub
	(A_PtrToMerger,A_FPPtr,A_NewCode,A_NewArgv)
{
  $USE(D_WorkNewEnvRecPtr);
  $USE(D_WorkElement);
  s_AllocVariable(A_NewCode); 
  s_AllocVariable(A_NewArgv);
  s_AllocNonDebugEnvRecord(D_WorkNewEnvRecPtr);
  /* $BB0@-!?%W%i%$%*%j%F%#$O!"%^!<%8%c$N$b$N$r;H$&(B */
  s_GetMergerAttribute(A_PtrToMerger,D_WorkElement);
  s_PutAttributeEnvRecord(D_WorkNewEnvRecPtr,D_WorkElement);
  s_GetMergerPriority(A_PtrToMerger,D_WorkElement);
  s_PutPriorityEnvRecord(D_WorkNewEnvRecPtr,D_WorkElement);
  $RELEASE(D_WorkElement);
  s_GetMergerFPPtr(A_PtrToMerger,A_FPPtr);

  f_DcodeEnqueue2OpeWithEnvRecAndFPPtr_II
    (BLT_B_APPLY, D_WorkNewEnvRecPtr, A_FPPtr, A_NewCode, A_NewArgv);
  $RELEASE(D_WorkNewEnvRecPtr);
  $RETURN();
}


/******************************************************************** PSL **
f_GetArgVectFromGoalRecord
       written by nakase@icot21      on Tue Apr 18 20:32:14 1989
<Arguments>
    dst_argv  : $B0z?t%Y%/%?(B ($B=PNO(B)
    ptr_to_gr : $B%4!<%k%l%3!<%I$X$N%]%$%s%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  dst_argv $B$K0z?t%Y%/%?$r3d$jEv$F(B, $B%4!<%k(B(ptr_to_gr)$B$N%4!<%k0z?t$r%;!<%V$9$k!#(B
<Examples>
  invoked (only ?) by f_Failure_Sub
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkPtrGR	XXX	/* $B%4!<%k%l%3!<%IFb$N%]%$%s%?(B 	*/
#DATA_define D_WorkPtrAV	XXX	/* $B0z?t%Y%/%?Fb$N%]%$%s%?(B 	*/
#DATA_define D_WorkArgument	XXX	/* $B0z?t$rCV$/%o!<%/%l%8%9%?(B 	*/

#PSL_define f_GetArgVectFromGoalRecord (dst_argv, ptr_to_gr) 
{
  @DEBUG{
    s_IfNotSingleHookGrp (ptr_to_gr) {
	VPIM_ERROR("f_GetArgVect","Illegal input");
    }
  };
  $USE(D_WorkArity); 
  s_GetArityGoalRecord(ptr_to_gr, D_WorkArity);
  $CALL( f_AllocVectorMRBoff_Sub(D_WorkArity, dst_argv));
                  /* D_WorkArity $B$,(B256$B0J>e$N;~!"%R!<%WNN0h$,B-$j$J$$$H(B
                   * dst_argv $B$K(B D_NULL $B$rJV$9$,!"EvLL$O$"$jF@$J$$(B(f-hataza)
                   */

  $USE(D_WorkPtrGR);	$USE(D_WorkPtrAV);
  b_AddImmediateWithDNTC (ptr_to_gr, _ARG0_OFST_GR, D_WorkPtrGR);
  p_MoveWord(dst_argv, D_WorkPtrAV);

  $USE(D_WorkArgument);

  LOOP () {
    b_IfZero (D_WorkArity) { break; }
    p_Read (D_WorkPtrGR, D_WorkArgument);
    b_IncrementAddrReg (D_WorkPtrGR);
    p_Write(D_WorkArgument, D_WorkPtrAV);
    b_IncrementAddrReg (D_WorkPtrAV);
    b_DecrementReg(D_WorkArity);
  }
  $RELEASE(D_WorkArgument);
  $RELEASE(D_WorkPtrGR); $RELEASE(D_WorkPtrAV);
  $RELEASE(D_WorkArity);
}

/******************************************************************** PSL **
raised$BNc30$N=hM}(B

       written by nakase@icot22      on Fri Oct  5 20:20:18 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#SUBARG_define A_Tag     SRC
#SUBARG_define A_Info    SRC
#SUBARG_define A_Data    SRC

#SUBROUTINE f_Raise_Sub(A_Tag, A_Info, A_Data)
{
  $USE(D_WorkNewCode); 
  $USE(D_WorkNewArgv);
  s_AllocVariable(D_WorkNewCode); 
  s_AllocVariable(D_WorkNewArgv);
        /* $BBe$o$j$K<B9T$5$l$k%4!<%k$rF~$l$kJQ?t$r:n$k(B */

  f_DcodeEnqueue2OpeWithoutParentInfo_II
    (BLT_B_APPLY, D_WorkNewCode, D_WorkNewArgv);

  $USE(D_WorkExcepInfoVect);
  f_MakeExcpArgVect( _THREE, D_WorkExcepInfoVect);
                   /* Raise$B$K4X$9$k>pJs$r!"%Y%/%?$KF~$l$k(B */
  f_Put3ArgsArgVect(D_WorkExcepInfoVect, D_ExceptionProcId, A_Info, A_Data);

  $USE(D_WorkExceptionNumber);  /* !! $BDI2C(B */
  b_SetImmValueDNTC(_RAISED_EXCP, D_WorkExceptionNumber);

  $CALL(f_Send_IntClMsg_Exception_Sub(A_Tag,
				      D_WorkExceptionNumber, /* !! $BDI2C(B */
				      D_WorkExcepInfoVect,
				      D_WorkNewCode, D_WorkNewArgv,
				      D_Current_FP_Ptr) );
  $RELEASE(D_WorkExcepInfoVect);
  $RELEASE(D_WorkExceptionNumber);
  $RELEASE(D_WorkNewArgv);
  $RELEASE(D_WorkNewCode);

  $RETURN();
}


/******************************************************************** PSL **
  $B%\%G%#AH$_9~$_=R8l$NNc30=hM}(B
       written by f-hataza@icot21      on Wed Nov 29 11:17:54 1989
       revised by f-hataza@icot22      on Tue May 15 17:03:21 1990

<$B%\%G%#AH9~=R8l(B($B%G%P%0L?Na$r=|$/(B) $B$K$*$1$k(B I/O $B$NAH$_9g$o$;(B>

  I        : $BAq1`(B (kblt_b_remove_shoen, kblt_b_consume_resource)
  O        : $B@)8f(B (kblt_b_current_goal_attribute)
  II       : $B@)8f(B (kblt_b_apply)
  IO       : 2$B0z?t$N1i;;(B (kblt_b_integer_increment, kblt_b_integer_decrement),
             $B@)8f(B (kblt_b_rate, kblt_b_rltv),
             $BAq1`(B (kblt_b_start_shoen, kblt_b_stop_shoen, kblt_b_abort_shoen,
                   kblt_b_shoen_statistics, kblt_b_allow_shoen_resouce_report)
             $B$=$NB>(B (kblt_b_atom_number)
  OI       : $B%Y%/%?(B (kblt_b_new_vector)
  OO       : $B@)8f(B (kblt_b_merge)
  III      : $BAq1`(B (kblt_b_raise)
  IIO      : 3$B0z?t$N1i;;(B, 
             $B@)8f(B (kblt_b_module_offset_to_code)
  IOO      : $B%Y%/%?(B (kblt_b_vector_size),
             $B%G!<%?(B (kblt_b_hash)
  OII      : $B%9%H%j%s%0(B (kblt_b_new_string)
  OOO      : $B@)8f(B (kblt_b_current_priority)
  IIIO     : $B%9%H%j%s%0(B (kblt_b_set_string_element),
             $B@)8f(B (kblt_b_predicate_to_code),
             $BAq1`(B (kblt_b_add_shoen_resource)
  IIOO     : $B%Y%/%?(B (kblt_b_vector_element),
             $B%9%H%j%s%0(B (kblt_b_string_element)
  IOOO     : $B%9%H%j%s%0(B (kblt_b_string_length_element_size)
  OOOO     : $B@)8f(B (kblt_b_current_processor)
  IIOIO    : $B%Y%/%?(B (kblt_b_set_vector_element)
  IIIIIOO  : $BAq1`(B (kblt_b_create_shoen)

<Revised Memo on "May 15"> update for V05
********************************************************************* PSL **/

#ADDR_define _ARG0_OFST_ARGV              0
#ADDR_define _ARG1_OFST_ARGV              1
#ADDR_define _ARG2_OFST_ARGV              2
#ADDR_define _ARG3_OFST_ARGV              3
#ADDR_define _ARG4_OFST_ARGV              4
#ADDR_define _ARG5_OFST_ARGV              5
#ADDR_define _ARG6_OFST_ARGV              6
#ADDR_define _ARG7_OFST_ARGV              7

#CONST_define _SIZE_OF_ARGV1              1
#CONST_define _SIZE_OF_ARGV2              2
#CONST_define _SIZE_OF_ARGV3              3
#CONST_define _SIZE_OF_ARGV4              4
#CONST_define _SIZE_OF_ARGV5              5
#CONST_define _SIZE_OF_ARGV6              6
#CONST_define _SIZE_OF_ARGV7              7
#CONST_define _SIZE_OF_ARGV8              8

#DATA_define D_WorkExceptionCode   XXX
#DATA_define D_WorkArgv		   XXX

/******************************************************************** PSL **
  f_Exception_NArg_XXXX_Sub

       written by f-hataza@icot21      on Tue Nov 28 17:29:53 1989

<Arguments>
  A_ExceptionCode : Input, Register, Exception Code
  A_OpCode :        Input, Register, Operation Code of Builtin Predicate
  A_ArgN :          Input/Output, Register, Nth Argument of the Predicate
              ( If the Argument is for output, variable will be allocated.)
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkOpCode XXX

#SUBARG_define	A_ExceptionCode		SRC
#SUBARG_define	A_OpCode		SRC
#SUBARG_define	A_Position		SRC
#SUBARG_define	A_Arg0			SRC

#SUBROUTINE f_Exception_1Arg_I_Sub(A_ExceptionCode, A_OpCode, A_Position, 
				                                     A_Arg0)
{
  /* $B0z?t%Y%/%?$r3d$jIU$1$k(B */
  $USE (D_WorkArgv);
  $CALL( f_MakeExcp1ArgVect_I_Sub (D_WorkArgv, A_Arg0));

  /* $B%5%V%k!<%A%sFb$G!"%l%]!<%H=PNO!"BeBX%4!<%k@_DjEy$N=hM}$r9T$&(B */
  $CALL (f_Exception_Sub (A_ExceptionCode, A_OpCode, A_Position, D_WorkArgv) );
  $RELEASE (D_WorkArgv);
  $RETURN ();
}

#SUBARG_define	A_ExceptionCode		SRC
#SUBARG_define	A_OpCode		SRC
#SUBARG_define	A_Position		SRC
#SUBARG_define	A_Arg0			SRC
#SUBARG_define	A_Arg1			DST

#SUBROUTINE f_Exception_2Arg_IO_Sub(A_ExceptionCode, A_OpCode, A_Position, 
				    A_Arg0, A_Arg1)
{
  $USE (D_WorkArgv);
  $CALL( f_MakeExcp2ArgVect_IO_Sub( D_WorkArgv, A_Arg0, A_Arg1));
  $CALL (f_Exception_Sub (A_ExceptionCode, A_OpCode, A_Position, D_WorkArgv) );
  $RELEASE (D_WorkArgv);
  $RETURN ();
}

#SUBARG_define	A_ExceptionCode		SRC
#SUBARG_define	A_OpCode		SRC
#SUBARG_define	A_Position		SRC
#SUBARG_define	A_Arg0			DST
#SUBARG_define	A_Arg1			SRC

#SUBROUTINE f_Exception_2Arg_OI_Sub (A_ExceptionCode, A_OpCode, A_Position,
				     A_Arg0, A_Arg1)
{
  $USE (D_WorkArgv);
  $CALL( f_MakeExcp2ArgVect_OI_Sub( D_WorkArgv, A_Arg0, A_Arg1));
  $CALL (f_Exception_Sub (A_ExceptionCode, A_OpCode, A_Position, D_WorkArgv) );
  $RELEASE (D_WorkArgv);
  $RETURN ();
}

#SUBARG_define	A_ExceptionCode		SRC
#SUBARG_define	A_OpCode		SRC
#SUBARG_define	A_Position		SRC
#SUBARG_define	A_Arg0			SRC
#SUBARG_define	A_Arg1			SRC

#SUBROUTINE f_Exception_2Arg_II_Sub (A_ExceptionCode, A_OpCode, A_Position, 
				     A_Arg0, A_Arg1)
{
  $USE (D_WorkArgv);
  $CALL( f_MakeExcp2ArgVect_II_Sub( D_WorkArgv, A_Arg0, A_Arg1));
  $CALL (f_Exception_Sub (A_ExceptionCode, A_OpCode, A_Position, D_WorkArgv) );
  $RELEASE (D_WorkArgv);
  $RETURN ();
}

#SUBARG_define	A_ExceptionCode		SRC
#SUBARG_define	A_OpCode		SRC
#SUBARG_define	A_Position		SRC
#SUBARG_define	A_Arg0			SRC
#SUBARG_define	A_Arg1			DST
#SUBARG_define	A_Arg2			DST

#SUBROUTINE f_Exception_3Arg_IOO_Sub
		  (A_ExceptionCode, A_OpCode, A_Position, 
		   A_Arg0, A_Arg1, A_Arg2)
{
  $USE (D_WorkArgv);
  $CALL( f_MakeExcp3ArgVect_IOO_Sub(D_WorkArgv, A_Arg0, A_Arg1, A_Arg2));
  $CALL (f_Exception_Sub (A_ExceptionCode, A_OpCode, A_Position, D_WorkArgv) );
  $RELEASE (D_WorkArgv);
  $RETURN ();
}

#SUBARG_define	A_ExceptionCode		SRC
#SUBARG_define	A_OpCode		SRC
#SUBARG_define	A_Position		SRC
#SUBARG_define	A_Arg0			SRC
#SUBARG_define	A_Arg1			SRC
#SUBARG_define	A_Arg2			DST

#SUBROUTINE f_Exception_3Arg_IIO_Sub(A_ExceptionCode, A_OpCode, A_Position, 
				     A_Arg0, A_Arg1, A_Arg2)
{
  $USE (D_WorkArgv);
  $CALL( f_MakeExcp3ArgVect_IIO_Sub(D_WorkArgv, A_Arg0, A_Arg1, A_Arg2));
  $CALL (f_Exception_Sub (A_ExceptionCode, A_OpCode, A_Position, D_WorkArgv) );
  $RELEASE (D_WorkArgv);
  $RETURN ();
}

#SUBARG_define	A_ExceptionCode		SRC
#SUBARG_define	A_OpCode		SRC
#SUBARG_define	A_Position		SRC
#SUBARG_define	A_Arg0			DST
#SUBARG_define	A_Arg1			SRC
#SUBARG_define	A_Arg2			SRC

#SUBROUTINE f_Exception_3Arg_OII_Sub(A_ExceptionCode, A_OpCode, A_Position, 
				     A_Arg0, A_Arg1, A_Arg2)
{
  $USE (D_WorkArgv);
  $CALL( f_MakeExcp3ArgVect_OII_Sub(D_WorkArgv, A_Arg0, A_Arg1, A_Arg2));
  $CALL (f_Exception_Sub (A_ExceptionCode, A_OpCode, A_Position, D_WorkArgv) );
  $RELEASE (D_WorkArgv);
  $RETURN ();
}

#SUBARG_define	A_ExceptionCode		SRC
#SUBARG_define	A_OpCode		SRC
#SUBARG_define	A_Position		SRC
#SUBARG_define	A_Arg0			SRC
#SUBARG_define	A_Arg1			SRC
#SUBARG_define	A_Arg2			SRC

#SUBROUTINE f_Exception_3Arg_III_Sub (A_ExceptionCode, A_OpCode, A_Position, 
				     A_Arg0, A_Arg1, A_Arg2)
{
  $USE (D_WorkArgv);
  $CALL( f_MakeExcp3ArgVect_III_Sub(D_WorkArgv, A_Arg0, A_Arg1, A_Arg2));
  $CALL (f_Exception_Sub (A_ExceptionCode, A_OpCode, A_Position, D_WorkArgv) );
  $RELEASE (D_WorkArgv);
  $RETURN ();
}

#SUBARG_define	A_ExceptionCode		SRC
#SUBARG_define	A_OpCode		SRC
#SUBARG_define	A_Position		SRC
#SUBARG_define	A_Arg0			SRC
#SUBARG_define	A_Arg1			DST
#SUBARG_define	A_Arg2			DST
#SUBARG_define	A_Arg3			DST

#SUBROUTINE f_Exception_4Arg_IOOO_Sub(A_ExceptionCode, A_OpCode, A_Position,
				      A_Arg0, A_Arg1, A_Arg2, A_Arg3)
{
  $USE (D_WorkArgv);
  $CALL( f_MakeExcp4ArgVect_IOOO_Sub(D_WorkArgv, A_Arg0, A_Arg1, A_Arg2, A_Arg3));
  $CALL (f_Exception_Sub (A_ExceptionCode, A_OpCode, A_Position, D_WorkArgv) );
  $RELEASE (D_WorkArgv);
  $RETURN ();
}

#SUBARG_define	A_ExceptionCode		SRC
#SUBARG_define	A_OpCode		SRC
#SUBARG_define	A_Position		SRC
#SUBARG_define	A_Arg0			SRC
#SUBARG_define	A_Arg1			SRC
#SUBARG_define	A_Arg2			DST
#SUBARG_define	A_Arg3			DST

#SUBROUTINE f_Exception_4Arg_IIOO_Sub(A_ExceptionCode, A_OpCode, A_Position,
				      A_Arg0, A_Arg1, A_Arg2, A_Arg3)
{
  $USE (D_WorkArgv);
  $CALL( f_MakeExcp4ArgVect_IIOO_Sub(D_WorkArgv, A_Arg0, A_Arg1, A_Arg2, A_Arg3));
  $CALL (f_Exception_Sub (A_ExceptionCode, A_OpCode, A_Position, D_WorkArgv) );
  $RELEASE (D_WorkArgv);
  $RETURN ();
}

#SUBARG_define	A_ExceptionCode		SRC
#SUBARG_define	A_OpCode		SRC
#SUBARG_define	A_Position		SRC
#SUBARG_define	A_Arg0			SRC
#SUBARG_define	A_Arg1			SRC
#SUBARG_define	A_Arg2			SRC
#SUBARG_define	A_Arg3			DST

#SUBROUTINE f_Exception_4Arg_IIIO_Sub(A_ExceptionCode, A_OpCode, A_Position,
				      A_Arg0, A_Arg1, A_Arg2, A_Arg3)
{
  $USE (D_WorkArgv);
  $CALL( f_MakeExcp4ArgVect_IIIO_Sub
    (D_WorkArgv, A_Arg0, A_Arg1, A_Arg2, A_Arg3));
  $CALL (f_Exception_Sub (A_ExceptionCode, A_OpCode, A_Position, D_WorkArgv) );
  $RELEASE (D_WorkArgv);
  $RETURN ();
}

#SUBARG_define	A_ExceptionCode		SRC
#SUBARG_define	A_OpCode		SRC
#SUBARG_define	A_Position		SRC
#SUBARG_define	A_Arg0			SRC
#SUBARG_define	A_Arg1			SRC
#SUBARG_define	A_Arg2			SRC
#SUBARG_define	A_Arg3			SRC

#SUBROUTINE f_Exception_4Arg_IIII_Sub(A_ExceptionCode, A_OpCode, A_Position,
				      A_Arg0, A_Arg1, A_Arg2, A_Arg3)
{
  $USE (D_WorkArgv);
  $CALL( f_MakeExcp4ArgVect_IIII_Sub
    (D_WorkArgv, A_Arg0, A_Arg1, A_Arg2, A_Arg3));
  $CALL (f_Exception_Sub (A_ExceptionCode, A_OpCode, A_Position, D_WorkArgv) );
  $RELEASE (D_WorkArgv);
  $RETURN ();
}

#SUBARG_define	A_ExceptionCode		SRC
#SUBARG_define	A_OpCode		SRC
#SUBARG_define	A_Position		SRC
#SUBARG_define	A_Arg0			SRC
#SUBARG_define	A_Arg1			SRC
#SUBARG_define	A_Arg2			DST
#SUBARG_define	A_Arg3			SRC
#SUBARG_define	A_Arg4			DST

#SUBROUTINE f_Exception_5Arg_IIOIO_Sub(A_ExceptionCode, A_OpCode, A_Position,
				       A_Arg0, A_Arg1, A_Arg2, A_Arg3, A_Arg4)
{
  $USE (D_WorkArgv);
  $CALL( f_MakeExcp5ArgVect_IIOIO_Sub
    ( D_WorkArgv, A_Arg0, A_Arg1, A_Arg2, A_Arg3, A_Arg4));
  $CALL (f_Exception_Sub (A_ExceptionCode, A_OpCode, A_Position, D_WorkArgv) );
  $RELEASE (D_WorkArgv);
  $RETURN ();
}

#SUBARG_define	A_ExceptionCode		SRC
#SUBARG_define	A_OpCode		SRC
#SUBARG_define	A_Position		SRC
#SUBARG_define	A_Arg0			SRC
#SUBARG_define	A_Arg1			SRC
#SUBARG_define	A_Arg2			SRC
#SUBARG_define	A_Arg3			DST
#SUBARG_define	A_Arg4			DST

#SUBROUTINE f_Exception_5Arg_IIIOO_Sub(A_ExceptionCode, A_OpCode, A_Position,
				       A_Arg0, A_Arg1, A_Arg2, A_Arg3, A_Arg4)
{
  $USE (D_WorkArgv);
  $CALL( f_MakeExcp5ArgVect_IIIOO_Sub
    (D_WorkArgv, A_Arg0, A_Arg1, A_Arg2, A_Arg3, A_Arg4));
  $CALL (f_Exception_Sub (A_ExceptionCode, A_OpCode, A_Position, D_WorkArgv) );
  $RELEASE (D_WorkArgv);
  $RETURN ();
}

#SUBARG_define	A_ExceptionCode		SRC
#SUBARG_define	A_OpCode		SRC
#SUBARG_define	A_Position		SRC
#SUBARG_define	A_Arg0			SRC
#SUBARG_define	A_Arg1			SRC
#SUBARG_define	A_Arg2			SRC
#SUBARG_define	A_Arg3			SRC
#SUBARG_define	A_Arg4			DST

#SUBROUTINE f_Exception_5Arg_IIIIO_Sub(A_ExceptionCode, A_OpCode, A_Position,
				       A_Arg0, A_Arg1, A_Arg2, A_Arg3, A_Arg4)
{
  $USE (D_WorkArgv);
  $CALL( f_MakeExcp5ArgVect_IIIIO_Sub
    (D_WorkArgv, A_Arg0, A_Arg1, A_Arg2, A_Arg3, A_Arg4));
  $CALL (f_Exception_Sub (A_ExceptionCode, A_OpCode, A_Position, D_WorkArgv) );
  $RELEASE (D_WorkArgv);
  $RETURN ();
}

#SUBARG_define	A_ExceptionCode		SRC
#SUBARG_define	A_OpCode		SRC
#SUBARG_define	A_Position		SRC
#SUBARG_define	A_Arg0			SRC
#SUBARG_define	A_Arg1			DST
#SUBARG_define	A_Arg2			DST
#SUBARG_define	A_Arg3			DST
#SUBARG_define	A_Arg4			DST

#SUBROUTINE f_Exception_5Arg_IOOOO_Sub(A_ExceptionCode, A_OpCode, A_Position,
				       A_Arg0, A_Arg1, A_Arg2, A_Arg3, A_Arg4)
{
  $USE (D_WorkArgv);
  $CALL( f_MakeExcp5ArgVect_IOOOO_Sub
    ( D_WorkArgv, A_Arg0, A_Arg1, A_Arg2, A_Arg3, A_Arg4));
  $CALL (f_Exception_Sub (A_ExceptionCode, A_OpCode, A_Position, D_WorkArgv) );
  $RELEASE (D_WorkArgv);
  $RETURN ();
}

#SUBARG_define	A_ExceptionCode		SRC
#SUBARG_define	A_OpCode		SRC
#SUBARG_define	A_Position		SRC
#SUBARG_define	A_Arg0			SRC
#SUBARG_define	A_Arg1			SRC
#SUBARG_define	A_Arg2			DST
#SUBARG_define	A_Arg3			DST
#SUBARG_define	A_Arg4			DST
#SUBARG_define	A_Arg5			DST

#SUBROUTINE f_Exception_6Arg_IIOOOO_Sub(A_ExceptionCode,A_OpCode,A_Position,
			 A_Arg0,A_Arg1,A_Arg2,A_Arg3,A_Arg4,A_Arg5)
{
  $USE (D_WorkArgv);
  $CALL( f_MakeExcp6ArgVect_IIOOOO_Sub
    (D_WorkArgv,A_Arg0,A_Arg1,A_Arg2,A_Arg3,A_Arg4,A_Arg5));
  $CALL (f_Exception_Sub (A_ExceptionCode, A_OpCode, A_Position, D_WorkArgv) );
  $RELEASE (D_WorkArgv);
  $RETURN ();
}

#SUBARG_define	A_ExceptionCode		SRC
#SUBARG_define	A_OpCode		SRC
#SUBARG_define	A_Position		SRC
#SUBARG_define	A_Arg0			SRC
#SUBARG_define	A_Arg1			SRC
#SUBARG_define	A_Arg2			SRC
#SUBARG_define	A_Arg3			SRC
#SUBARG_define	A_Arg4			DST
#SUBARG_define	A_Arg5			DST

#SUBROUTINE f_Exception_6Arg_IIIIOO_Sub(A_ExceptionCode,A_OpCode,A_Position,
			 A_Arg0,A_Arg1,A_Arg2,A_Arg3,A_Arg4,A_Arg5)
{
  $USE (D_WorkArgv);
  $CALL( f_MakeExcp6ArgVect_IIIIOO_Sub
    (D_WorkArgv,A_Arg0,A_Arg1,A_Arg2,A_Arg3,A_Arg4,A_Arg5));
  $CALL (f_Exception_Sub (A_ExceptionCode, A_OpCode, A_Position, D_WorkArgv) );
  $RELEASE (D_WorkArgv);
  $RETURN ();
}

#SUBARG_define	A_ExceptionCode		SRC
#SUBARG_define	A_OpCode		SRC
#SUBARG_define	A_Position		SRC
#SUBARG_define	A_Arg0			SRC
#SUBARG_define	A_Arg1			SRC
#SUBARG_define	A_Arg2			SRC
#SUBARG_define	A_Arg3			SRC
#SUBARG_define	A_Arg4			SRC
#SUBARG_define	A_Arg5			DST

#SUBROUTINE f_Exception_6Arg_IIIIIO_Sub(A_ExceptionCode,A_OpCode,A_Position,
			 A_Arg0,A_Arg1,A_Arg2,A_Arg3,A_Arg4,A_Arg5)
{
  $USE (D_WorkArgv);
  $CALL( f_MakeExcp6ArgVect_IIIIIO_Sub
    (D_WorkArgv,A_Arg0,A_Arg1,A_Arg2,A_Arg3,A_Arg4,A_Arg5));
  $CALL (f_Exception_Sub (A_ExceptionCode, A_OpCode, A_Position, D_WorkArgv) );
  $RELEASE (D_WorkArgv);
  $RETURN ();
}

#SUBARG_define	A_ExceptionCode		SRC
#SUBARG_define	A_OpCode		SRC
#SUBARG_define	A_Position		SRC
#SUBARG_define	A_Arg0			SRC
#SUBARG_define	A_Arg1			SRC
#SUBARG_define	A_Arg2			SRC
#SUBARG_define	A_Arg3			SRC
#SUBARG_define	A_Arg4			SRC
#SUBARG_define	A_Arg5			DST
#SUBARG_define	A_Arg6			DST

#SUBROUTINE f_Exception_7Arg_IIIIIOO_Sub(A_ExceptionCode,A_OpCode,A_Position,
			 A_Arg0,A_Arg1,A_Arg2,A_Arg3,A_Arg4,A_Arg5,A_Arg6)
{
  $USE (D_WorkArgv);
  $CALL( f_MakeExcp7ArgVect_IIIIIOO_Sub
    (D_WorkArgv,A_Arg0,A_Arg1,A_Arg2,A_Arg3,A_Arg4,A_Arg5,A_Arg6));
  $CALL (f_Exception_Sub (A_ExceptionCode, A_OpCode, A_Position, D_WorkArgv) );
  $RELEASE (D_WorkArgv);
  $RETURN ();
}

#SUBARG_define	A_ExceptionCode		SRC
#SUBARG_define	A_OpCode		SRC
#SUBARG_define	A_Position		SRC
#SUBARG_define	A_Arg0			SRC
#SUBARG_define	A_Arg1			SRC
#SUBARG_define	A_Arg2			DST
#SUBARG_define	A_Arg3			DST
#SUBARG_define	A_Arg4			DST
#SUBARG_define	A_Arg5			DST
#SUBARG_define	A_Arg6			DST

#SUBROUTINE f_Exception_7Arg_IIOOOOO_Sub(A_ExceptionCode,A_OpCode,A_Position,
			 A_Arg0,A_Arg1,A_Arg2,A_Arg3,A_Arg4,A_Arg5,A_Arg6)
{
  $USE (D_WorkArgv);
  $CALL( f_MakeExcp7ArgVect_IIOOOOO_Sub
    (D_WorkArgv,A_Arg0,A_Arg1,A_Arg2,A_Arg3,A_Arg4,A_Arg5,A_Arg6));
  $CALL (f_Exception_Sub (A_ExceptionCode, A_OpCode, A_Position, D_WorkArgv) );
  $RELEASE (D_WorkArgv);
  $RETURN ();
}

#SUBARG_define	A_ExceptionCode		SRC
#SUBARG_define	A_OpCode		SRC
#SUBARG_define	A_Position		SRC
#SUBARG_define	A_Arg0			SRC
#SUBARG_define	A_Arg1			SRC
#SUBARG_define	A_Arg2			SRC
#SUBARG_define	A_Arg3			SRC
#SUBARG_define	A_Arg4			SRC
#SUBARG_define	A_Arg5			SRC
#SUBARG_define	A_Arg6			DST
#SUBARG_define	A_Arg7			DST

#SUBROUTINE f_Exception_8Arg_IIIIIIOO_Sub(A_ExceptionCode,A_OpCode,A_Position,
		       A_Arg0,A_Arg1,A_Arg2,A_Arg3,A_Arg4,A_Arg5,A_Arg6,A_Arg7)
{
  $USE (D_WorkArgv);
  $CALL( f_MakeExcp8ArgVect_IIIIIIOO_Sub
    (D_WorkArgv,A_Arg0,A_Arg1,A_Arg2,A_Arg3,A_Arg4,A_Arg5,A_Arg6,A_Arg7));
  $CALL (f_Exception_Sub (A_ExceptionCode, A_OpCode, A_Position, D_WorkArgv) );
  $RELEASE (D_WorkArgv);
  $RETURN ();
}



#SUBARG_define	A_ExceptionCode		SRC
#SUBARG_define	A_OpCode		SRC
#SUBARG_define	A_Position		SRC
#SUBARG_define	A_Arg0			SRC
#SUBARG_define	A_Arg1			SRC
#SUBARG_define	A_Arg2			SRC
#SUBARG_define	A_Arg3			SRC
#SUBARG_define	A_Arg4			SRC
#SUBARG_define	A_Arg5			DST
#SUBARG_define	A_Arg6			DST
#SUBARG_define	A_Arg7			DST

#SUBROUTINE f_Exception_8Arg_IIIIIOOO_Sub(A_ExceptionCode,A_OpCode,A_Position,
		       A_Arg0,A_Arg1,A_Arg2,A_Arg3,A_Arg4,A_Arg5,A_Arg6,A_Arg7)
{
  $USE (D_WorkArgv);
  $CALL( f_MakeExcp8ArgVect_IIIIIOOO_Sub
    (D_WorkArgv,A_Arg0,A_Arg1,A_Arg2,A_Arg3,A_Arg4,A_Arg5,A_Arg6,A_Arg7));
  $CALL (f_Exception_Sub (A_ExceptionCode, A_OpCode, A_Position, D_WorkArgv) );
  $RELEASE (D_WorkArgv);
  $RETURN ();
}

/******************************************************************** PSL **
  $B0z?t%Y%/%?$N@8@.(B

       written by imai@icot22      on Wed Dec 19 14:33:32 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#SUBARG_define A_DstVect	DST
#SUBARG_define A_Arg0		SRC

#SUBROUTINE f_MakeExcp1ArgVect_I_Sub(A_DstVect,A_Arg0)
{
  f_MakeExcpArgVect (_SIZE_OF_ARGV1, A_DstVect);
  f_Put1ArgArgVect (A_DstVect, A_Arg0);
  $RETURN();
}

#SUBARG_define A_DstVect	DST
#SUBARG_define A_Arg0		DST

#SUBROUTINE f_MakeExcp1ArgVect_O_Sub(A_DstVect,A_Arg0)
{
  /*--- $B$3$l$O!"(BTRACE $B$N;~$N$_!"DL>o<B9T;~$O!"F~NO$,$J$$$N$GNc30$r5/$3$5$J$$(B */
  s_AllocVariable (A_Arg0);
  f_MakeExcpArgVect (_SIZE_OF_ARGV1, A_DstVect);
  f_Put1ArgArgVect (A_DstVect, A_Arg0);
  $RETURN();
}

#SUBARG_define A_DstVect	DST
#SUBARG_define A_Arg0		DST
#SUBARG_define A_Arg1		DST

#SUBROUTINE f_MakeExcp2ArgVect_OO_Sub(A_DstVect,A_Arg0, A_Arg1)
{
  /*--- $B$3$l$O!"(BTRACE $B$N;~$N$_!"DL>o<B9T;~$O!"F~NO$,$J$$$N$GNc30$r5/$3$5$J$$(B */
  s_AllocVariable (A_Arg0);
  s_AllocVariable (A_Arg1);
  f_MakeExcpArgVect (_SIZE_OF_ARGV2, A_DstVect);
  f_Put2ArgsArgVect (A_DstVect, A_Arg0, A_Arg1);
  $RETURN();
}

#SUBARG_define A_DstVect	DST
#SUBARG_define A_Arg0		SRC
#SUBARG_define A_Arg1		DST

#SUBROUTINE f_MakeExcp2ArgVect_IO_Sub(A_DstVect,A_Arg0, A_Arg1)
{
  s_AllocVariable (A_Arg1);
  f_MakeExcpArgVect (_SIZE_OF_ARGV2, A_DstVect);
  f_Put2ArgsArgVect (A_DstVect, A_Arg0, A_Arg1);
  $RETURN();
}

#SUBARG_define A_DstVect	DST
#SUBARG_define A_Arg0		DST
#SUBARG_define A_Arg1		SRC

#SUBROUTINE f_MakeExcp2ArgVect_OI_Sub(A_DstVect,A_Arg0, A_Arg1)
{
  s_AllocVariable (A_Arg0);
  f_MakeExcpArgVect (_SIZE_OF_ARGV2, A_DstVect);
  f_Put2ArgsArgVect (A_DstVect, A_Arg0, A_Arg1);
  $RETURN();
}

#SUBARG_define A_DstVect	DST
#SUBARG_define A_Arg0		SRC
#SUBARG_define A_Arg1		SRC

#SUBROUTINE f_MakeExcp2ArgVect_II_Sub(A_DstVect, A_Arg0, A_Arg1)
{
  f_MakeExcpArgVect (_SIZE_OF_ARGV2, A_DstVect);
  f_Put2ArgsArgVect (A_DstVect, A_Arg0, A_Arg1);
  $RETURN();
}

#SUBARG_define A_DstVect	DST
#SUBARG_define A_Arg0		SRC
#SUBARG_define A_Arg1		DST
#SUBARG_define A_Arg2		DST

#SUBROUTINE f_MakeExcp3ArgVect_IOO_Sub(A_DstVect, A_Arg0, A_Arg1, A_Arg2)
{
  s_AllocVariable (A_Arg1);
  s_AllocVariable (A_Arg2);
  f_MakeExcpArgVect (_SIZE_OF_ARGV3, A_DstVect);
  f_Put3ArgsArgVect (A_DstVect, A_Arg0, A_Arg1, A_Arg2);
  $RETURN();
}

#SUBARG_define A_DstVect	DST
#SUBARG_define A_Arg0		SRC
#SUBARG_define A_Arg1		SRC
#SUBARG_define A_Arg2		DST

#SUBROUTINE f_MakeExcp3ArgVect_IIO_Sub(A_DstVect, A_Arg0, A_Arg1, A_Arg2)
{
  s_AllocVariable (A_Arg2);
  f_MakeExcpArgVect (_SIZE_OF_ARGV3, A_DstVect);
  f_Put3ArgsArgVect (A_DstVect, A_Arg0, A_Arg1, A_Arg2);
  $RETURN();
}

#SUBARG_define A_DstVect	DST
#SUBARG_define A_Arg0		DST
#SUBARG_define A_Arg1		SRC
#SUBARG_define A_Arg2		SRC

#SUBROUTINE f_MakeExcp3ArgVect_OII_Sub(A_DstVect, A_Arg0, A_Arg1, A_Arg2)
{
  s_AllocVariable (A_Arg0);
  f_MakeExcpArgVect (_SIZE_OF_ARGV3, A_DstVect);
  f_Put3ArgsArgVect (A_DstVect, A_Arg0, A_Arg1, A_Arg2);
  $RETURN();
}

#SUBARG_define A_DstVect	DST
#SUBARG_define A_Arg0		SRC
#SUBARG_define A_Arg1		SRC
#SUBARG_define A_Arg2		SRC

#SUBROUTINE f_MakeExcp3ArgVect_III_Sub(A_DstVect, A_Arg0, A_Arg1, A_Arg2)
{
  f_MakeExcpArgVect (_SIZE_OF_ARGV3, A_DstVect);
  f_Put3ArgsArgVect (A_DstVect, A_Arg0, A_Arg1, A_Arg2);
  $RETURN();
}

#SUBARG_define A_DstVect	DST
#SUBARG_define A_Arg0		DST
#SUBARG_define A_Arg1		DST
#SUBARG_define A_Arg2		DST

#SUBROUTINE f_MakeExcp3ArgVect_OOO_Sub(A_DstVect, A_Arg0, A_Arg1, A_Arg2)
{
  s_AllocVariable (A_Arg0);
  s_AllocVariable (A_Arg1);
  s_AllocVariable (A_Arg2);
  f_MakeExcpArgVect (_SIZE_OF_ARGV3, A_DstVect);
  f_Put3ArgsArgVect (A_DstVect, A_Arg0, A_Arg1, A_Arg2);
  $RETURN();
}

#SUBARG_define A_DstVect	DST
#SUBARG_define A_Arg0		SRC
#SUBARG_define A_Arg1		DST
#SUBARG_define A_Arg2		DST
#SUBARG_define A_Arg3		DST

#SUBROUTINE f_MakeExcp4ArgVect_IOOO_Sub
	(A_DstVect, A_Arg0, A_Arg1, A_Arg2, A_Arg3)
{
  s_AllocVariable (A_Arg1);
  s_AllocVariable (A_Arg2);
  s_AllocVariable (A_Arg3);
  f_MakeExcpArgVect (_SIZE_OF_ARGV4, A_DstVect);
  f_Put4ArgsArgVect (A_DstVect, A_Arg0, A_Arg1, A_Arg2, A_Arg3);
  $RETURN();
}

#SUBARG_define A_DstVect	DST
#SUBARG_define A_Arg0		SRC
#SUBARG_define A_Arg1		SRC
#SUBARG_define A_Arg2		DST
#SUBARG_define A_Arg3		DST

#SUBROUTINE f_MakeExcp4ArgVect_IIOO_Sub
	(A_DstVect, A_Arg0, A_Arg1, A_Arg2, A_Arg3)
{
  s_AllocVariable (A_Arg2);
  s_AllocVariable (A_Arg3);
  f_MakeExcpArgVect (_SIZE_OF_ARGV4, A_DstVect);
  f_Put4ArgsArgVect (A_DstVect, A_Arg0, A_Arg1, A_Arg2, A_Arg3);
  $RETURN();
}

#SUBARG_define A_DstVect	DST
#SUBARG_define A_Arg0		SRC
#SUBARG_define A_Arg1		SRC
#SUBARG_define A_Arg2		SRC
#SUBARG_define A_Arg3		DST

#SUBROUTINE f_MakeExcp4ArgVect_IIIO_Sub
	(A_DstVect, A_Arg0, A_Arg1, A_Arg2, A_Arg3)
{
  s_AllocVariable (A_Arg3);
  f_MakeExcpArgVect (_SIZE_OF_ARGV4, A_DstVect);
  f_Put4ArgsArgVect (A_DstVect, A_Arg0, A_Arg1, A_Arg2, A_Arg3);
  $RETURN();
}

#SUBARG_define A_DstVect	DST
#SUBARG_define A_Arg0		SRC
#SUBARG_define A_Arg1		SRC
#SUBARG_define A_Arg2		SRC
#SUBARG_define A_Arg3		SRC

#SUBROUTINE f_MakeExcp4ArgVect_IIII_Sub
	(A_DstVect, A_Arg0, A_Arg1, A_Arg2, A_Arg3)
{

  f_MakeExcpArgVect (_SIZE_OF_ARGV4, A_DstVect);
  f_Put4ArgsArgVect (A_DstVect, A_Arg0, A_Arg1, A_Arg2, A_Arg3);
  $RETURN();
}

#SUBARG_define A_DstVect	DST
#SUBARG_define A_Arg0		DST
#SUBARG_define A_Arg1		DST
#SUBARG_define A_Arg2		DST
#SUBARG_define A_Arg3		DST

#SUBROUTINE f_MakeExcp4ArgVect_OOOO_Sub
	(A_DstVect, A_Arg0, A_Arg1, A_Arg2, A_Arg3)
{
  /*--- $B$3$l$O!"(BTRACE $B$N;~$N$_!"DL>o<B9T;~$O!"F~NO$,$J$$$N$GNc30$r5/$3$5$J$$(B */
  s_AllocVariable(A_Arg0);
  s_AllocVariable(A_Arg1);
  s_AllocVariable(A_Arg2);
  s_AllocVariable(A_Arg3);
  f_MakeExcpArgVect (_SIZE_OF_ARGV4, A_DstVect);
  f_Put4ArgsArgVect (A_DstVect, A_Arg0, A_Arg1, A_Arg2, A_Arg3);
  $RETURN();
}

#SUBARG_define A_DstVect	DST
#SUBARG_define A_Arg0		SRC
#SUBARG_define A_Arg1		SRC
#SUBARG_define A_Arg2		DST
#SUBARG_define A_Arg3		SRC
#SUBARG_define A_Arg4		DST

#SUBROUTINE f_MakeExcp5ArgVect_IIOIO_Sub
	(A_DstVect, A_Arg0, A_Arg1, A_Arg2, A_Arg3, A_Arg4)
{
  s_AllocVariable (A_Arg2);
  s_AllocVariable (A_Arg4);
  f_MakeExcpArgVect (_SIZE_OF_ARGV5, A_DstVect);
  f_Put5ArgsArgVect (A_DstVect, A_Arg0, A_Arg1, A_Arg2, A_Arg3, A_Arg4);
  $RETURN();
}

#SUBARG_define A_DstVect	DST
#SUBARG_define A_Arg0		SRC
#SUBARG_define A_Arg1		SRC
#SUBARG_define A_Arg2		SRC
#SUBARG_define A_Arg3		DST
#SUBARG_define A_Arg4		DST

#SUBROUTINE f_MakeExcp5ArgVect_IIIOO_Sub
	(A_DstVect, A_Arg0, A_Arg1, A_Arg2, A_Arg3, A_Arg4)
{
  s_AllocVariable (A_Arg3);
  s_AllocVariable (A_Arg4);
  f_MakeExcpArgVect (_SIZE_OF_ARGV5, A_DstVect);
  f_Put5ArgsArgVect (A_DstVect, A_Arg0, A_Arg1, A_Arg2, A_Arg3, A_Arg4);
  $RETURN();
}

#SUBARG_define A_DstVect	DST
#SUBARG_define A_Arg0		SRC
#SUBARG_define A_Arg1		SRC
#SUBARG_define A_Arg2		SRC
#SUBARG_define A_Arg3		SRC
#SUBARG_define A_Arg4		DST

#SUBROUTINE f_MakeExcp5ArgVect_IIIIO_Sub
	(A_DstVect, A_Arg0, A_Arg1, A_Arg2, A_Arg3, A_Arg4)
{
  s_AllocVariable (A_Arg4);
  f_MakeExcpArgVect (_SIZE_OF_ARGV5, A_DstVect);
  f_Put5ArgsArgVect (A_DstVect, A_Arg0, A_Arg1, A_Arg2, A_Arg3, A_Arg4);
  $RETURN();
}

#SUBARG_define A_DstVect	DST
#SUBARG_define A_Arg0		SRC
#SUBARG_define A_Arg1		DST
#SUBARG_define A_Arg2		DST
#SUBARG_define A_Arg3		DST
#SUBARG_define A_Arg4		DST

#SUBROUTINE f_MakeExcp5ArgVect_IOOOO_Sub
	(A_DstVect, A_Arg0, A_Arg1, A_Arg2, A_Arg3, A_Arg4)
{
  s_AllocVariable (A_Arg1);
  s_AllocVariable (A_Arg2);
  s_AllocVariable (A_Arg3);
  s_AllocVariable (A_Arg4);
  f_MakeExcpArgVect (_SIZE_OF_ARGV5, A_DstVect);
  f_Put5ArgsArgVect (A_DstVect, A_Arg0, A_Arg1, A_Arg2, A_Arg3, A_Arg4);
  $RETURN();
}

#SUBARG_define A_DstVect	DST
#SUBARG_define A_Arg0		SRC
#SUBARG_define A_Arg1		SRC
#SUBARG_define A_Arg2		DST
#SUBARG_define A_Arg3		DST
#SUBARG_define A_Arg4		DST
#SUBARG_define A_Arg5		DST

#SUBROUTINE f_MakeExcp6ArgVect_IIOOOO_Sub
	(A_DstVect, A_Arg0,A_Arg1,A_Arg2,A_Arg3,A_Arg4,A_Arg5)
{
  s_AllocVariable (A_Arg2);
  s_AllocVariable (A_Arg3);
  s_AllocVariable (A_Arg4);
  s_AllocVariable (A_Arg5);
  f_MakeExcpArgVect(_SIZE_OF_ARGV6, A_DstVect);
  f_Put6ArgsArgVect(A_DstVect,A_Arg0,A_Arg1,A_Arg2,A_Arg3,A_Arg4,A_Arg5);
  $RETURN();
}

#SUBARG_define A_DstVect	DST
#SUBARG_define A_Arg0		SRC
#SUBARG_define A_Arg1		SRC
#SUBARG_define A_Arg2		SRC
#SUBARG_define A_Arg3		SRC
#SUBARG_define A_Arg4		DST
#SUBARG_define A_Arg5		DST

#SUBROUTINE f_MakeExcp6ArgVect_IIIIOO_Sub
	(A_DstVect, A_Arg0,A_Arg1,A_Arg2,A_Arg3,A_Arg4,A_Arg5)
{
  s_AllocVariable (A_Arg4);
  s_AllocVariable (A_Arg5);
  f_MakeExcpArgVect(_SIZE_OF_ARGV6, A_DstVect);
  f_Put6ArgsArgVect(A_DstVect,A_Arg0,A_Arg1,A_Arg2,A_Arg3,A_Arg4,A_Arg5);
  $RETURN();
}

#SUBARG_define A_DstVect	DST
#SUBARG_define A_Arg0		SRC
#SUBARG_define A_Arg1		SRC
#SUBARG_define A_Arg2		SRC
#SUBARG_define A_Arg3		SRC
#SUBARG_define A_Arg4		SRC
#SUBARG_define A_Arg5		DST

#SUBROUTINE f_MakeExcp6ArgVect_IIIIIO_Sub
	(A_DstVect, A_Arg0,A_Arg1,A_Arg2,A_Arg3,A_Arg4,A_Arg5)
{
  s_AllocVariable (A_Arg5);
  f_MakeExcpArgVect(_SIZE_OF_ARGV6, A_DstVect);
  f_Put6ArgsArgVect(A_DstVect,A_Arg0,A_Arg1,A_Arg2,A_Arg3,A_Arg4,A_Arg5);
  $RETURN();
}

#SUBARG_define A_DstVect	DST
#SUBARG_define A_Arg0		SRC
#SUBARG_define A_Arg1		SRC
#SUBARG_define A_Arg2		SRC
#SUBARG_define A_Arg3		SRC
#SUBARG_define A_Arg4		SRC
#SUBARG_define A_Arg5		DST
#SUBARG_define A_Arg6		DST

#SUBROUTINE f_MakeExcp7ArgVect_IIIIIOO_Sub
	(A_DstVect, A_Arg0,A_Arg1,A_Arg2,A_Arg3,A_Arg4,A_Arg5,A_Arg6)
{
  s_AllocVariable (A_Arg5);
  s_AllocVariable (A_Arg6);
  f_MakeExcpArgVect(_SIZE_OF_ARGV7, A_DstVect);
  f_Put7ArgsArgVect
    (A_DstVect,A_Arg0,A_Arg1,A_Arg2,A_Arg3,A_Arg4,A_Arg5,A_Arg6);
  $RETURN();
}

#SUBARG_define A_DstVect	DST
#SUBARG_define A_Arg0		SRC
#SUBARG_define A_Arg1		SRC
#SUBARG_define A_Arg2		DST
#SUBARG_define A_Arg3		DST
#SUBARG_define A_Arg4		DST
#SUBARG_define A_Arg5		DST
#SUBARG_define A_Arg6		DST

#SUBROUTINE f_MakeExcp7ArgVect_IIOOOOO_Sub
	(A_DstVect, A_Arg0,A_Arg1,A_Arg2,A_Arg3,A_Arg4,A_Arg5,A_Arg6)
{
  s_AllocVariable (A_Arg2);
  s_AllocVariable (A_Arg3);
  s_AllocVariable (A_Arg4);
  s_AllocVariable (A_Arg5);
  s_AllocVariable (A_Arg6);
  f_MakeExcpArgVect(_SIZE_OF_ARGV7, A_DstVect);
  f_Put7ArgsArgVect
    (A_DstVect,A_Arg0,A_Arg1,A_Arg2,A_Arg3,A_Arg4,A_Arg5,A_Arg6);
  $RETURN();
}

#SUBARG_define A_DstVect	DST
#SUBARG_define A_Arg0		SRC
#SUBARG_define A_Arg1		SRC
#SUBARG_define A_Arg2		SRC
#SUBARG_define A_Arg3		SRC
#SUBARG_define A_Arg4		SRC
#SUBARG_define A_Arg5		SRC
#SUBARG_define A_Arg6		DST
#SUBARG_define A_Arg7		DST

#SUBROUTINE f_MakeExcp8ArgVect_IIIIIIOO_Sub
	(A_DstVect, A_Arg0,A_Arg1,A_Arg2,A_Arg3,A_Arg4,A_Arg5,A_Arg6,A_Arg7)
{
  s_AllocVariable (A_Arg6);
  s_AllocVariable (A_Arg7);
  f_MakeExcpArgVect(_SIZE_OF_ARGV8, A_DstVect);
  f_Put8ArgsArgVect
    (A_DstVect,A_Arg0,A_Arg1,A_Arg2,A_Arg3,A_Arg4,A_Arg5,A_Arg6,A_Arg7);
  $RETURN();
}


#SUBARG_define A_DstVect	DST
#SUBARG_define A_Arg0		SRC
#SUBARG_define A_Arg1		SRC
#SUBARG_define A_Arg2		SRC
#SUBARG_define A_Arg3		SRC
#SUBARG_define A_Arg4		SRC
#SUBARG_define A_Arg5		DST
#SUBARG_define A_Arg6		DST
#SUBARG_define A_Arg7		DST

#SUBROUTINE f_MakeExcp8ArgVect_IIIIIOOO_Sub
	(A_DstVect, A_Arg0,A_Arg1,A_Arg2,A_Arg3,A_Arg4,A_Arg5,A_Arg6,A_Arg7)
{
  s_AllocVariable (A_Arg5);
  s_AllocVariable (A_Arg6);
  s_AllocVariable (A_Arg7);
  f_MakeExcpArgVect(_SIZE_OF_ARGV8, A_DstVect);
  f_Put8ArgsArgVect
    (A_DstVect,A_Arg0,A_Arg1,A_Arg2,A_Arg3,A_Arg4,A_Arg5,A_Arg6,A_Arg7);
  $RETURN();
}
/******************************************************************** PSL **
f_Exception_Sub

       written by nakase@icot22      Fri Jan 13 18:39:27 1989

<Arguments>
  A_ExceptionCode : $B%(%/%;%W%7%g%s%3!<%I(B
  A_OpCode :        $B%*%Z%l!<%7%g%s%3!<%I(B
  A_Position:       $BNc300z?t0LCV(B
  A_Argv :          $B0z?t%Y%/%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
 $BAq1`$N%l%]!<%H%9%H%j!<%`$K%(%/%;%W%7%g%s$r>e$2$k!#(B
<Examples>
<Test>
<Explanation>
  f_Exception_Sub$B$J$I$H$$$&0lHLE*$JL>A0$,$D$$$F$$$$$k$,!"(B
  $B$9$Y$F$N(Bexception$B$,$3$N%5%V%k!<%A%s$G=hM}$5$l$k$o$1$G$O$J$$!#(B

  $B$3$N%5%V%k!<%A%s$O!"AH$_9~$_=R8l$r<B9T$7$?;~$K5/$3$k!"(B
	illegal_input	
	range_overflow,out_of_bounds,integer_overflow,integer_zero_divisions,
	invalid_floating_point_operation, arity_mismatch
  $B$NNc30$r07$&!#(B

<ETC>
  A_ExceptionCode, A_OpCode $B$N%?%$%W$O!"(BDNTC $B$K$J$C$F$$$k!#!J;;=Q!"9=B$BN$N(B
  $BAH9~=R8l!K(B(1990.02.20 f-hataza)
********************************************************************* PSL **/

#DATA_define D_WorkModTopPtr    XXX
#DATA_define D_WorkModOffsetReg XXX
#DATA_define D_WorkPredicateInfo XXX

#SUBARG_define	A_ExceptionCode		SRC
#SUBARG_define	A_OpCode		SRC
#SUBARG_define	A_Position		SRC
#SUBARG_define	A_Argv			SRC

#SUBROUTINE f_Exception_Sub (A_ExceptionCode, A_OpCode, A_Position, A_Argv)
{
  $USE (D_WorkNewCode); $USE (D_WorkNewArgv);

  s_AllocVariable (D_WorkNewCode); 
  s_AllocVariable (D_WorkNewArgv);
         /* $BBe$o$j$K<B9T$5$l$k%4!<%k$rF~$l$kJQ?t$r:n$k(B */
  f_DcodeEnqueue2OpeWithoutParentInfo_II
    (BLT_B_APPLY, D_WorkNewCode, D_WorkNewArgv);
  $USE(D_WorkPredicateInfo);
  $CALL(f_MakePredicateInfo_BuiltinException_Sub
	(A_OpCode,D_WorkPredicateInfo));
  $USE(D_WorkExcepInfoVect);
  ValueSwitch(A_ExceptionCode) {
  case _ILLEGAL_INPUT_EXCP:
  case _RANGE_OVERFLOW_EXCP:
  case _OUT_OF_BOUNDS_EXCP:
    f_MakeExcpArgVect( _FOUR, D_WorkExcepInfoVect);
    f_Put4ArgsArgVect(D_WorkExcepInfoVect, D_ExceptionProcId,
		    D_WorkPredicateInfo, A_Argv,A_Position);
    break;
  case _INTEGER_OVERFLOW_EXCP:
  case _INTEGER_ZERO_DIVISION_EXCP:
  case _INVALID_FLOATING_POINT_OPE_EXCP:
  case _ARITY_MISMATCH_EXCP:
    /* A_Position $B$r;H$o$J$$$b$N(B */
    f_MakeExcpArgVect( _THREE, D_WorkExcepInfoVect );
    f_Put3ArgsArgVect(D_WorkExcepInfoVect, D_ExceptionProcId,
		      D_WorkPredicateInfo, A_Argv);
    break;
  default:
    @DEBUG{OUT_OF_SPEC("f_Exception_Sub","Unsupported EXCPT_TAG!!");};
  }

  $USE(D_WorkExceptionTag);  /* !! $BDI2C(B */
  /* !! $BDI2C(B */
  f_ConvertExceptionNumberToTag(A_ExceptionCode, D_WorkExceptionTag);

  $CALL(f_Send_IntClMsg_Exception_Sub(D_WorkExceptionTag, /* !! $BDI2C(B */
				      A_ExceptionCode, 
				      D_WorkExcepInfoVect,
				      D_WorkNewCode, D_WorkNewArgv,
				      D_Current_FP_Ptr) );

  $RELEASE(D_WorkExceptionTag);  /* !! $BDI2C(B */
  $RELEASE(D_WorkExcepInfoVect);
  $RELEASE(D_WorkPredicateInfo);
  $RELEASE (D_WorkNewCode); $RELEASE (D_WorkNewArgv);

  $RETURN ();
}

/******************************************************************** PSL **
  f_MakeExcpArgVect imm_arity dst_vect

       written by f-hataza@icot21      on Tue Nov 28 17:21:36 1989

<Arguments>
  imm_arity : Input, Immediate Integer, Size of Argument Vector
  dst_vect :  Output, Register, Pointer to Argument Vector

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  allocate Argument Vector for Exception Report  
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkExcpVectSize       XXX

#PSL_define f_MakeExcpArgVect (imm_arity, dst_vect)
{
  /* $B0z?t%Y%/%?$r3d$jIU$1$k(B */
  $USE (D_WorkExcpVectSize);
  p_SetImmediateValue (imm_arity, D_WorkExcpVectSize);
  $CALL (f_AllocVectorMRBoff_Sub (D_WorkExcpVectSize, dst_vect) );
      /* $B0z?t$N?t$O(B255$B$r1[$($J$$$H9M$($i$l$k$N$G!"%R!<%WNN0hITB-$K$D$$$F$O(B
       * $B9M$($F$$$J$$!#(B
       */
  $RELEASE (D_WorkExcpVectSize);
}

/******************************************************************** PSL **
f_MakePredicateInfo_BuiltinException_Sub
  $BNc30$r5/$3$7$?%\%G%#AH$_9~$_=R8l$r<1JL$9$k$?$a$N>pJs(B($B=R8l>pJs(B)$B$r@8@.$9$k!#(B

       written by imai@icot22      on Wed Jan 16 13:45:48 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
dst_info $B$O!"<!$N$h$&$J7A<0$H$J$k!#(B
(1)  {BltID, OriginMod, OriginOfst}
	 --- $B%U%!!<%`Dj5A$NAH$_9~$_=R8l$GH/@8(B

(2)  {BltID, OriginMod, OriginOfst, CallerMod, CallerOfst}
	 ---	KL1$BDj5A$NAH$_9~$_=R8l$+$i8F$P$l$?(B
			$B%U%!!<%`Dj5A$NAH$_9~$_=R8l$GH/@8(B

D_CurrentEnvRecPtr $B$N%?%$%W$K$h$j<!$N$h$&$J=hM}$r9T$J$&!#(B

 VECT2: (1) D_KLB_PC $B$r$b$H$K!"(BOriginMod, OriginOfst $B$r7W;;$9$k!#(B
		$B!JAH$_9~$_$,CfCG$9$k$3$H$J$/<B9T$5$lNc30$rH/@8$7$?!K(B
 VECT4: (1) D_CurrentEnvRecPtr $B$NCf$K=q$+$l$?!"(BModule, Offset $B$r;HMQ$9$k(B
		$B!JAH$_9~$_$,0lEYCfCG$7!"$=$N8e:F3+$5$l$FNc30$rH/@8$7$?!K(B
 VECT6: (2) D_CurrentEnvRecPtr $B$NCf$K=q$+$l$?!"(BCallerMod,CallerOfst$B$r;HMQ$9$k!#(B
	    OriginModule, OriginOffset $B$O!"8=:_$N4D6-%l%3!<%I$N%9%m%C%H$,(B
	    $BM-8z$G$"$l$P$=$l$r;H$&!#(B
		$B!JAH$_9~$_$,CfCG$9$k$3$H$J$/<B9T$5$lNc30$rH/@8$7$?!K(B
	    $BM-8z$G$J$1$l$P!"(BD_KLB_PC $B$r85$K7W;;$9$k!#(B
		$B!JAH$_9~$_$,0lEYCfCG$7!"$=$N8e:F3+$5$l$FNc30$rH/@8$7$?!K(B
 VECT8: (1) $B$+(B (2) $B$+$O!"8=:_$N4D6-%l%3!<%I$N%9%m%C%H$,M-8z$+L58z$+$N(B
	$BH=Dj$r9T$J$&!#(B
 VECT3: $B%H%l!<%9%b!<%I$G$"$k$N$G!"%H%l!<%9Nc300J30$NNc30$rH/@8$9$k$3$H(B
        $B<+BN$,4V0c$$!J7h$7$F8F$P$l$J$$$O$:!K(B
<Test>
<Explanation>
<ETC>
  KL1$BDj5A$NAH$_9~$_=R8l$N>l9g!"(BReduction_Failure (f_Fail_Sub)$B$N$J$+$G!"(B
	Code
	{Code,CallerMod,CallerOfst}
  $B$N$$$:$l$K$J$k$+$rH=Dj$9$k!#(B
********************************************************************* PSL **/

#DATA_define D_WorkCallerModTopPtr	XXX
#DATA_define D_WorkCallerModOffsetReg	XXX


#SUBARG_define	A_Opcode	SRC
#SUBARG_define	A_DstInfo	DST

#SUBROUTINE f_MakePredicateInfo_BuiltinException_Sub(A_Opcode,A_DstInfo)
{
  $USE(D_WorkVectSize);

  TypeSwitch(D_CurrentEnvRecPtr) {
  case _NON_DEBUG_ENV_REC_TYPE:
    goto OrigFromPC;
  case _ORIGINAL_CODE_INFO_ENV_REC_TYPE:
    goto OrigFromEnvRec;
  case _CALLER_CODE_INFO_ENV_REC_TYPE:
    goto GetCallerInfo;
  case _SPY_ENV_REC_TYPE:
    s_IfValidCallerInfo(D_CurrentEnvRecPtr) {
      goto GetCallerInfo;
    } else {
      s_IfValidOriginalInfo(D_CurrentEnvRecPtr) {
	goto OrigFromEnvRec;
      } else {
	goto OrigFromPC;
      }
    }
  case _TRACE_ENV_REC_TYPE:
    @DEBUG{VPIM_ERROR("f_MakePredicateInfo_BuiltinException","Ilegal Type (TRACE)");};
  default:
    @DEBUG{VPIM_ERROR("f_MakePredicateInfo_BuiltinException","Non Envrec Type!!");};
  }

 GetCallerInfo:
  b_SetImmTypeMRBoff(VECT5,D_WorkVectSize);
  s_AllocVect5(A_DstInfo);
  $USE(D_WorkCallerModTopPtr);
  $USE(D_WorkCallerModOffsetReg);
  s_GetCallerModulePtrEnvRecord(D_CurrentEnvRecPtr,D_WorkCallerModTopPtr);
  s_GetCallerModuleOfstEnvRecord(D_CurrentEnvRecPtr,D_WorkCallerModOffsetReg);
  s_IfValidOriginalInfo(D_CurrentEnvRecPtr) {
    goto GetOrigFromEnvRec;
  } else {
    goto GetOrigFromPC;
  }

 OrigFromEnvRec:
  b_SetImmTypeMRBoff(VECT3,D_WorkVectSize);
  s_AllocVect3(A_DstInfo);
 GetOrigFromEnvRec:
  $USE(D_WorkModTopPtr);$USE(D_WorkModOffsetReg);
  s_GetOriginalModulePtrEnvRecord(D_CurrentEnvRecPtr,D_WorkModTopPtr);
  s_GetOriginalModuleOfstEnvRecord(D_CurrentEnvRecPtr,D_WorkModOffsetReg);
  goto PutElements;

 OrigFromPC:
  b_SetImmTypeMRBoff(VECT3,D_WorkVectSize);
  s_AllocVect3(A_DstInfo);
 GetOrigFromPC:
  $USE(D_WorkModTopPtr);$USE(D_WorkModOffsetReg);
  s_GetModuleTopAndOffsetFromPC(D_KLB_PC,D_WorkModTopPtr,D_WorkModOffsetReg);

 PutElements:
  TypeSwitch(D_WorkVectSize) {
  case VECT5:
    s_PutVectElementImmOfst
      (A_DstInfo,_ELEM5_OFST_VECT,D_WorkCallerModOffsetReg);
    $RELEASE(D_WorkCallerModOffsetReg);
    s_PutVectElementImmOfst(A_DstInfo,_ELEM4_OFST_VECT,D_WorkCallerModTopPtr);
    $RELEASE(D_WorkCallerModTopPtr);
  case VECT3:
    s_PutVectElementImmOfst(A_DstInfo,_ELEM3_OFST_VECT,D_WorkModOffsetReg);
    $RELEASE(D_WorkModOffsetReg);
    s_PutVectElementImmOfst(A_DstInfo,_ELEM2_OFST_VECT,D_WorkModTopPtr);
    $RELEASE(D_WorkModTopPtr);
    s_PutVectElementImmOfst(A_DstInfo,_ELEM1_OFST_VECT,A_Opcode);
    break;
  default:
    @DEBUG{ VPIM_ERROR("f_MakePredicateInfo_BuiltinException",
		       "Illegal Type");};
  }
  $RELEASE(D_WorkVectSize);
  $RETURN();
}

/******************************************************************** PSL **
f_MakePredicateInfo_ReductionFailure_Sub
  $BNc30$r5/$3$7$?=R8l$r<1JL$9$k$?$a$N>pJs(B($B=R8l>pJs(B)$B$r@8@.$9$k!#(B

       written by imai@icot22      on Fri Jan 18 11:17:16 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#SUBARG_define	A_GoalPtr	SRC
#SUBARG_define	A_DstInfo	DST

#SUBROUTINE f_MakePredicateInfo_ReductionFailure_Sub (A_GoalPtr, A_DstInfo)
{
  TypeSwitch(D_CurrentEnvRecPtr) {
  case _NON_DEBUG_ENV_REC_TYPE:
  case _TRACE_ENV_REC_TYPE:
    goto OnlyCode;
  case _ORIGINAL_CODE_INFO_ENV_REC_TYPE:
    @DEBUG{VPIM_ERROR("f_MakePredicateInfo_ReductionFailure_Sub",
		      "Check D-Code Program not to cause ReductionFailure");};
    break;
  case _CALLER_CODE_INFO_ENV_REC_TYPE:
    goto CodeAndCallerInfo;
  case _SPY_ENV_REC_TYPE:
    s_IfValidCallerInfo(D_CurrentEnvRecPtr) { goto CodeAndCallerInfo; }
    else { goto OnlyCode; }
  default:
    @DEBUG{VPIM_ERROR("f_MakePredicateInfo_ReductionFailure_Sub",
		      "Illegal Type");};
  }

 CodeAndCallerInfo:
  @DEBUG{ s_IfValidOriginalInfo(D_CurrentEnvRecPtr) {
    VPIM_ERROR("f_MakePredicateInfo_ReductionFailure_Sub",
	       "Check D-Code Program not to cause ReductionFailure"); }};
  f_MakePredInfo_CreatedForKL1Builtin
    (A_GoalPtr, D_CurrentEnvRecPtr, A_DstInfo);
  $RETURN();
 OnlyCode:
  s_GetCodeGoalRecord( A_GoalPtr, A_DstInfo );
  $RETURN();
}

/******************************************************************** PSL **
f_MakePredicateInfo_NotCurrentGoal_Sub
  $B8=:_<B9TCf$G$O$J$$%4!<%k$,!J1J5WCfCG$J$I!KNc30$r5/$3$7$?>l9g$K(B
  $B=R8l$r<1JL$9$k$?$a$N>pJs(B($B=R8l>pJs(B)$B$r@8@.$9$k!#(B

       written by imai@icot22      on Fri Jan 18 11:38:39 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#SUBARG_define	A_GoalRecPtr	SRC
#SUBARG_define	A_DstInfo	DST

#SUBROUTINE f_MakePredicateInfo_NotCurrentGoal_Sub
	(A_GoalRecPtr,A_DstInfo)
{
  @DEBUG { s_IfNotHOOK(A_GoalRecPtr) {
    VPIM_ERROR("f_MakePredicateInfo_NotCurrentGoal_Sub","Not HOOK!!");}};

  $USE(D_WorkEnvRecPtr);
  s_GetEnvRecGoalRecord(A_GoalRecPtr,D_WorkEnvRecPtr);
  TypeSwitch(D_WorkEnvRecPtr) {
  case _NON_DEBUG_ENV_REC_TYPE:
  case _TRACE_ENV_REC_TYPE:
    s_GetCodeGoalRecord(A_GoalRecPtr,A_DstInfo);
    break;
  case _ORIGINAL_CODE_INFO_ENV_REC_TYPE:
    f_MakePredInfo_CreatedByFirmBuiltinSuspend
      (A_GoalRecPtr,D_WorkEnvRecPtr,A_DstInfo);
    break;
  case _CALLER_CODE_INFO_ENV_REC_TYPE:
    s_IfValidOriginalInfo(D_WorkEnvRecPtr) {
      f_MakePredInfo_CreatedByFirmBuiltinSuspendInKL1Builtin
	(A_GoalRecPtr,D_WorkEnvRecPtr,A_DstInfo);
    } else {
      f_MakePredInfo_CreatedForKL1Builtin(A_GoalRecPtr,D_WorkEnvRecPtr,A_DstInfo);
    }
    break;
  case _SPY_ENV_REC_TYPE:
    s_IfValidCallerInfo(D_WorkEnvRecPtr) {
      s_IfValidOriginalInfo(D_WorkEnvRecPtr) {
	f_MakePredInfo_CreatedByFirmBuiltinSuspendInKL1Builtin
	  (A_GoalRecPtr,D_WorkEnvRecPtr,A_DstInfo);
      } else {
	f_MakePredInfo_CreatedForKL1Builtin
	  (A_GoalRecPtr,D_WorkEnvRecPtr,A_DstInfo);
      }
    } else {
      s_IfValidOriginalInfo(D_WorkEnvRecPtr) {
	f_MakePredInfo_CreatedByFirmBuiltinSuspend
	  (A_GoalRecPtr,D_WorkEnvRecPtr,A_DstInfo);
      } else {
	s_GetCodeGoalRecord(A_GoalRecPtr,A_DstInfo);
      }
    }
    break;
  default:
    @DEBUG{
      VPIM_ERROR("f_MakePredicateInfo_NotCurrentGoal_Sub","Illegal Type");
    };
  }
  $RELEASE(D_WorkEnvRecPtr);
  $RETURN();
}

#PSL_define f_MakePredInfo_CreatedByFirmBuiltinSuspend
	(goal_rec,env_rec,dst_info)
{
  s_AllocVect3(dst_info);
  $USE(D_WorkCodePtr);
  s_GetCodeGoalRecord(goal_rec,D_WorkCodePtr);
  $USE(D_WorkElement);
  s_GetSoftInfoFromCode(D_WorkCodePtr,D_WorkElement);
  $RELEASE(D_WorkCodePtr);
  s_PutVectElementImmOfst(dst_info,_ELEM1_OFST_VECT,D_WorkElement);
  s_GetOriginalModulePtrEnvRecord(env_rec,D_WorkElement);
  s_PutVectElementImmOfst(dst_info,_ELEM2_OFST_VECT,D_WorkElement);
  s_GetOriginalModuleOfstEnvRecord(env_rec,D_WorkElement);
  s_PutVectElementImmOfst(dst_info,_ELEM3_OFST_VECT,D_WorkElement);
  $RELEASE(D_WorkElement);
}

#PSL_define f_MakePredInfo_CreatedForKL1Builtin
	(goal_rec,env_rec,dst_info)
{
  s_AllocVect3(dst_info);
  $USE(D_WorkElement);
  s_GetCodeGoalRecord(goal_rec,D_WorkElement);
  s_PutVectElementImmOfst(dst_info,_ELEM1_OFST_VECT,D_WorkElement);
  s_GetCallerModulePtrEnvRecord(env_rec,D_WorkElement);
  s_PutVectElementImmOfst(dst_info,_ELEM2_OFST_VECT,D_WorkElement);
  s_GetCallerModuleOfstEnvRecord(env_rec,D_WorkElement);
  s_PutVectElementImmOfst(dst_info,_ELEM3_OFST_VECT,D_WorkElement);
  $RELEASE(D_WorkElement);
}

#PSL_define f_MakePredInfo_CreatedByFirmBuiltinSuspendInKL1Builtin
	(goal_rec,env_rec,dst_info)
{
  s_AllocVect5(dst_info);
  $USE(D_WorkCodePtr);
  s_GetCodeGoalRecord(goal_rec,D_WorkCodePtr);
  $USE(D_WorkElement);
  s_GetSoftInfoFromCode(D_WorkCodePtr,D_WorkElement);
  $RELEASE(D_WorkCodePtr);
  s_PutVectElementImmOfst(dst_info,_ELEM1_OFST_VECT,D_WorkElement);
  s_GetOriginalModulePtrEnvRecord(env_rec,D_WorkElement);
  s_PutVectElementImmOfst(dst_info,_ELEM2_OFST_VECT,D_WorkElement);
  s_GetOriginalModuleOfstEnvRecord(env_rec,D_WorkElement);
  s_PutVectElementImmOfst(dst_info,_ELEM3_OFST_VECT,D_WorkElement);
  s_GetCallerModulePtrEnvRecord(env_rec,D_WorkElement);
  s_PutVectElementImmOfst(dst_info,_ELEM4_OFST_VECT,D_WorkElement);
  s_GetCallerModuleOfstEnvRecord(env_rec,D_WorkElement);
  s_PutVectElementImmOfst(dst_info,_ELEM5_OFST_VECT,D_WorkElement);
  $RELEASE(D_WorkElement);
}

/******************************************************************** PSL **
  f_PutNArgsArgVect arg_vect, arg0, arg1,...

       written by f-hataza@icot21      on Tue Nov 28 17:26:44 1989

<Arguments>
  arg_vect  : Input, Register, Pointer to Argument Vector
  arg0,1,.. : Input, Register, Argument No.0,1,..

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  put N Arguments into Argument Vector Element
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#PSL_define f_Put1ArgArgVect (arg_vect, arg0)
{
  /* $B0z?t%Y%/%?$K0z?t$r3JG<$9$k(B */
  p_WriteWithOffset(arg0, arg_vect, _ARG0_OFST_ARGV);
}

#PSL_define f_Put2ArgsArgVect (arg_vect, arg0, arg1)
{
  /* $B0z?t%Y%/%?$K0z?t$r3JG<$9$k(B */
  p_WriteWithOffset(arg0, arg_vect, _ARG0_OFST_ARGV);
  p_WriteWithOffset(arg1, arg_vect, _ARG1_OFST_ARGV);
}

#PSL_define f_Put3ArgsArgVect (arg_vect, arg0, arg1, arg2)
{
  p_WriteWithOffset(arg0, arg_vect, _ARG0_OFST_ARGV);
  p_WriteWithOffset(arg1, arg_vect, _ARG1_OFST_ARGV);
  p_WriteWithOffset(arg2, arg_vect, _ARG2_OFST_ARGV);
}

#PSL_define f_Put4ArgsArgVect (arg_vect, arg0, arg1, arg2, arg3)
{
  p_WriteWithOffset(arg0, arg_vect, _ARG0_OFST_ARGV);
  p_WriteWithOffset(arg1, arg_vect, _ARG1_OFST_ARGV);
  p_WriteWithOffset(arg2, arg_vect, _ARG2_OFST_ARGV);
  p_WriteWithOffset(arg3, arg_vect, _ARG3_OFST_ARGV);
}
 
#PSL_define f_Put5ArgsArgVect (arg_vect, arg0, arg1, arg2, arg3, arg4)
{
  p_WriteWithOffset(arg0, arg_vect, _ARG0_OFST_ARGV);
  p_WriteWithOffset(arg1, arg_vect, _ARG1_OFST_ARGV);
  p_WriteWithOffset(arg2, arg_vect, _ARG2_OFST_ARGV);
  p_WriteWithOffset(arg3, arg_vect, _ARG3_OFST_ARGV);
  p_WriteWithOffset(arg4, arg_vect, _ARG4_OFST_ARGV);
}

#PSL_define f_Put6ArgsArgVect (arg_vect, arg0, arg1, arg2, arg3, arg4, arg5)
{
  p_WriteWithOffset(arg0, arg_vect, _ARG0_OFST_ARGV);
  p_WriteWithOffset(arg1, arg_vect, _ARG1_OFST_ARGV);
  p_WriteWithOffset(arg2, arg_vect, _ARG2_OFST_ARGV);
  p_WriteWithOffset(arg3, arg_vect, _ARG3_OFST_ARGV);
  p_WriteWithOffset(arg4, arg_vect, _ARG4_OFST_ARGV);
  p_WriteWithOffset(arg5, arg_vect, _ARG5_OFST_ARGV);
}

#PSL_define f_Put7ArgsArgVect
                          (arg_vect, arg0, arg1, arg2, arg3, arg4, arg5, arg6)
{
  p_WriteWithOffset(arg0, arg_vect, _ARG0_OFST_ARGV);
  p_WriteWithOffset(arg1, arg_vect, _ARG1_OFST_ARGV);
  p_WriteWithOffset(arg2, arg_vect, _ARG2_OFST_ARGV);
  p_WriteWithOffset(arg3, arg_vect, _ARG3_OFST_ARGV);
  p_WriteWithOffset(arg4, arg_vect, _ARG4_OFST_ARGV);
  p_WriteWithOffset(arg5, arg_vect, _ARG5_OFST_ARGV);
  p_WriteWithOffset(arg6, arg_vect, _ARG6_OFST_ARGV);
}

#PSL_define f_Put8ArgsArgVect
                  (arg_vect, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7)
{
  p_WriteWithOffset(arg0, arg_vect, _ARG0_OFST_ARGV);
  p_WriteWithOffset(arg1, arg_vect, _ARG1_OFST_ARGV);
  p_WriteWithOffset(arg2, arg_vect, _ARG2_OFST_ARGV);
  p_WriteWithOffset(arg3, arg_vect, _ARG3_OFST_ARGV);
  p_WriteWithOffset(arg4, arg_vect, _ARG4_OFST_ARGV);
  p_WriteWithOffset(arg5, arg_vect, _ARG5_OFST_ARGV);
  p_WriteWithOffset(arg6, arg_vect, _ARG6_OFST_ARGV);
  p_WriteWithOffset(arg7, arg_vect, _ARG7_OFST_ARGV);
}

/******************************************************************** PSL **
ExceptionCode
       written by nakase@icot22      on Fri Feb  3 11:09:31 1989
       revised by imai@icot22      on Wed Jan 16 17:28:21 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  $BNc30%3!<%I0lMw(B
<ETC>
<Revised Memo on "Jan 16">
  $B;CDjE*$JNc30%?%0L>$J$I$H$$$&2x$7$2$J$b$N$r>C$7$F!"@5<0HG$K$7$?(B
********************************************************************* PSL **/

/* !! (New) $BNc30HV9f(B($B%3!<%I(B)$B$NDj5A(B */
#CONST_define  _ILLEGAL_INPUT_EXCP		0
#CONST_define  _RANGE_OVERFLOW_EXCP		1
#CONST_define  _OUT_OF_BOUNDS_EXCP		2
#CONST_define  _INTEGER_OVERFLOW_EXCP		3
#CONST_define  _INTEGER_ZERO_DIVISION_EXCP	4

#CONST_define  _INVALID_FLOATING_POINT_OPE_EXCP	5
               /* VPIM$B7O$N(B PIM $B$G$O$3$NNc30$O>e$2$J$$$3$H$K$7$?!#(B*/
               /* $B1i;;7k2L$N%A%'%C%/$OJLAH9~$G9T$J$&!#(B*/

#CONST_define  _ARITY_MISMATCH_EXCP		6
#CONST_define  _RESERVED_1_EXCP			7
#CONST_define  _ILLEGAL_MERGER_INPUT_EXCP	8
#CONST_define  _REDUCTION_FAILURE_EXCP		9
#CONST_define  _UNIFICATION_FAILURE_EXCP	10
#CONST_define  _DEADLOCK_EXCP			11
#CONST_define  _MERGER_DEADLOCK_EXCP		12
#CONST_define  _TRACE_EXCP			13
#CONST_define  _RESERVED_2_EXCP			14
#CONST_define  _ETC_EXCP			15
#CONST_define  _RAISED_EXCP			16

#CONST_define  _EXCP_TAG_BASE			0x00010000

/* $BNc30%?%0$NDj5A(B */
/* Old
#CONST_define  _ILLEGAL_INPUT_EXCP		0x00010000
#CONST_define  _RANGE_OVERFLOW_EXCP		0x00020000
#CONST_define  _OUT_OF_BOUNDS_EXCP		0x00040000
#CONST_define  _INTEGER_OVERFLOW_EXCP		0x00080000
#CONST_define  _INTEGER_ZERO_DIVISION_EXCP	0x00100000

#CONST_define  _INVALID_FLOATING_POINT_OPE_EXCP	0x00200000
               /!* VPIM$B7O$N(B PIM $B$G$O$3$NNc30$O>e$2$J$$$3$H$K$7$?!#(B*!/
               /!* $B1i;;7k2L$N%A%'%C%/$OJLAH9~$G9T$J$&!#(B*!/

#CONST_define  _ARITY_MISMATCH_EXCP		0x00400000
#CONST_define  _RESERVED_1_EXCP			0x00800000
#CONST_define  _ILLEGAL_MERGER_INPUT_EXCP	0x01000000
#CONST_define  _REDUCTION_FAILURE_EXCP		0x02000000
#CONST_define  _UNIFICATION_FAILURE_EXCP	0x04000000
#CONST_define  _DEADLOCK_EXCP			0x08000000
#CONST_define  _MERGER_DEADLOCK_EXCP		0x10000000
#CONST_define  _TRACE_EXCP			0x20000000
#CONST_define  _RESERVED_2_EXCP			0x40000000
#CONST_define  _ETC_EXCP			0x80000000
*/

/*--- $B%G%C%I%m%C%/$N<oN`(B by imai (V2$B$HF1$8>pJs(B from s-nakao@icot21) ---*/

/*---- Collector $B$,$o$+$i$J$$(B  (Multi-PSI$B$HF1$8HV9f(B) ----*/
#CONST_define	_DEADLOCK_NORMAL_GOAL_BY_GC	0
#CONST_define	_DEADLOCK_TRACED_GOAL_BY_GC	1
#CONST_define	_DEADLOCK_SPIED_GOAL_BY_GC	2

/*---- Collector $B$,$o$+$k(B ---- (Multi-PSI$B$HF1$8HV9f(B) -----*/
#CONST_define	_DEADLOCK_BY_COLLECT_VALUE	10
#CONST_define	_DEADLOCK_BY_HOOK_SUSPEND	11
#CONST_define	_DEADLOCK_BY_HOOK_HOOK_UNIFY	12

/*---- Collector $B$,$o$+$i$J$$(B -- (Multi-PSI$B$K$O8!=P$G$-$J$$(B) ---*/
#CONST_define	_DEADLOCK_BY_VOID_SUSPEND	13
#CONST_define	_DEADLOCK_BY_VOID_HOOK_UNIFY	14
#CONST_define	_DEADLOCK_BY_RELEASE_MESSAGE	15

#PSL_define  f_ConvertExceptionNumberToTag(exception_num, exception_tag)
{
  b_SetImmValueDNTC(_EXCP_TAG_BASE, exception_tag);
  b_ShiftLeftWithDNTC(exception_tag, exception_num, exception_tag);	
}
