
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_reduce_deref.psl.c
   ----- CREATED   : by hirata@icot22, on Mon Jun  4 16:31:42 1990
   ----- LAST SAVED: by imai@icot22, on Thu Nov 28 18:13:50 1991
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : function
   ----- ABSTRACT  : 
A. $B9`L\(B
  1. $B%G%l%U%!%l%s%9(B
    1.1 $B%G%l%U%!%l%s%9$N4pK\%k!<%A%s(B
    1.2 $B%G%l%U%!%l%s%9;~$N%G!<%?2s<}(B
  2. $B9=B$BN$NMWAG$N%G%l%U%!%l%s%9(B
    2.1 $B9=B$BN%G%l%U%!%l%s%9$N%5%V%k!<%A%s(B
    2.2 $BMWAG0LCV;XDj(B(KL1-B$BL?Na%*%Z%i%s%I(B, $B%l%8%9%?(B, $BB(CM(B) $BKh$N%^%/%m(B
  3. CollectValue $B$+$i8F$P$l$k:F5"E*$J2s<}(B

B. $B35MW(B
  $B%G%l%U%!%l%s%9$O(B, KL1-B$BL?Na$K$*$1$k4pK\A`:n$G$"$k$,(B, $B%G%l%U%!%l%s%9$N$_$rFHN)(B
  $B$7$?A`:n$H$7$F@Z$j$@$7Fq$$!#$3$N$?$a(B, $B<uF0It$N(BKL1-B $BL?Na$NB?$/$O$=$NL?Na$N0U(B
  $BL#$K9g$o$;$F%G%l%U%!%l%s%9A`:n$rE83+$7$F$$$k!#(B

  $B0J2<$GDj5A$7$F$$$k%G%l%U%!%l%s%9$N%^%/%m$O(B,  $BG=F0It$N%f%K%U%#%1!<%7%g%s$H(B
  	klb_read_wait, klb_load_wait
  $BEy$N$h$&$K(B, $B%G%l%U%!%l%s%98e$KFCJL$NA`:n$,IU?o$7$J$$(BKL1-B$BL?Na$N$?$a$N$b$N$G(B
  $B$"$k!#(B

  $B$3$l$i$NA`:n$,<g$K;H$o$l$F$$$k>l=j$K$D$$$F(B:
  	f_PassiveDeref: f_Receive_NW_Read_Sub$B$J$I(B (f_int_cl_recv_read.psl.c)
  	f_ActiveDeref: klb_fork, klb_shoen, klb_unify, klb_debug $B$J$I(B
	f_DerefElementOpr: klb_argument 
  	f_DerefElementReg: f_passive_unify, f_merger_unify
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

#DATA_define D_WorkDerefPtr	XXX

/******************************************************************** PSL **
1. $B%G%l%U%!%l%s%9(B
1.1 $B%G%l%U%!%l%s%9$N4pK\%k!<%A%s(B

       written by hirata@icot22      on Mon Jun  4 16:54:24 1990
<Arguments>
  data_reg : $B%G%l%U%!%l%s%9$r9T$&0z?t%l%8%9%?(B
  ptr_reg : $B%G%l%U%!%l%s%9$K$*$$$F%;%k$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables> none
<Level>
<PreCondition>
<Function>
  $B0z?t%l%8%9%?$N@h$r(Bderef$B$7(B, ($B2DG=$G$"$l$P(B)$B4V@\%;%k$r2s<}$9$k!#(B
<Examples>
<Test>
<Explanation>
  $B%G%l%U%!%l%s%9$K$*$$$F$O(B, $B%G%l%U%!%l%s%98e$N0z?t%l%8%9%?$O(B REF $B0J30(B
  $B$N%?%$%W$,;D$k!#(B
  $BL$Dj5AJQ?t$N>l9g$O(B, $B%^%/%m$N30B&$G(B $B%;%k$X$N%]%$%s%?(B (ptr_reg) $B$KLa$9I,MW$"$j(B.
<ETC>
  VOID $B%?%$%W$r(BMulti-PSI$B$N$h$&$K(B($B%*%V%8%'%/%H%;%k$K$*$$$F(B)MRB ON + UNDF
  $B$HI=8=$9$k$H!"(Bderef$B7k2L$,(B Unbound $B%?%$%W$N;~!"%l%8%9%?>e$N$=$N(BVOID$B%X$N(B
  $B%]%$%s%?$N(BMRB$B%S%C%H$,(BON$B$K$J$C$F$7$^$&!#(B
  $B$3$N$?$a!"(Bf_Deref_Sub$B$NCf$G$O!"%o!<%/%l%8%9%?(B(A_PtrReg)$B$r0l$DM>7W$K(B
  $B;H$C$F(B
  ==> $B%G%l%U;~$K(B, 
  (MRB OFF + UNDF $B$K$9$l$PLdBj$O$J$$!#DL>o$N(B UNDF $B$O(B MRB ON + UNDF $B$H(B
   $B$J$k$1$I!"(BUNDF $B$O(BMRP$B$,9u$+Gr$+$OLdBj$K$7$J$$$N$G4X78$J$$(B)
  ==> VOID $B%?%$%W$O!"@lMQ$N%?%$%W$rMQ$$$FI=8=$7$F$$$k!#(B

********************************************************************* PSL **/

#PSL_define f_ActiveDeref(data_reg, ptr_reg)
{
  @DEBUG { 
    b_ErrorIfSameRegNum (data_reg, ptr_reg); 
    s_IfArgTypeErr (data_reg) {
      VPIM_ERROR ("f_Active/PassiveDeref", "Illegal_Goal_Argument_Type");
    }
  };
  @PROBE{ deref_probe(data_reg); };

  s_IfREF (data_reg) {
    $CALL( f_Deref_Sub (data_reg, ptr_reg) );
  } else {
    @DEBUG{	/* ptr_reg $B$,ITDj$G$"$k$3$H$r6/D4$9$k$?$a$K(B .... */
      s_IfEXLOCK(data_reg) {
	VPIM_ERROR("f_ActiveDeref","Illegal Type!!");
      }
      p_MoveWord(D_ALL1, ptr_reg);
    };
  }
}

#PSL_define f_PassiveDeref(data_reg, ptr_reg) 
{
  f_ActiveDeref(data_reg, ptr_reg);
}

#SUBARG_define	A_DerefData	MODIFY
#SUBARG_define	A_PtrReg	DST	/* ?? */

#SUBROUTINE f_Deref_Sub ( A_DerefData, A_PtrReg )
{
  LOOP(){
    s_DerefReg(A_DerefData, A_PtrReg);
    /*
     * A_PtrReg$B$K$O(B A_DerefData$B$NA0$NCM(B, i.e. "REF! *->" $B$,F~$C$F$$$k!#(B
     * A_DerefData $B$N(BMRB$B$O%;%k(BMRB$B$H%Q%9(BMRB (A_PtrReg)$B$N(BOR$B$K$J$C$F$$$k!#(B
     */
    s_IfNotUnbound(A_DerefData) {  	/* deref$B$N@h$,6qBN2=$5$l$?CM$N;~(B */
      f_ReclaimIfSingleRefPath (A_DerefData, A_PtrReg);
      s_IfNotREF(A_DerefData) {
	break;		/* break from LOOP if instantiated value	*/
      }		/* bounded to REF, so going back to LOOP top again 	*/
    } else {			/* jumping out of LOOP when Unbound	*/
      break;
    } 
  }
  $RETURN ();
}

/******************************************************************** PSL **
1.2 $B%G%l%U%!%l%s%9;~$N%G!<%?2s<}(B

       written by goto@icot22      Tue Jan 17 20:13:15 1989

<Arguments>
  data_reg : $B%G%l%U%!%l%s%9$7$?0z?t%l%8%9%?(B
  ptr_reg : $B%G%l%U%!%l%s%9$7$?%;%k$X$N%]%$%s%?(B ($B2s<}$NBP>]$H$J$k%;%k(B)
<Explanation>
<ETC>
********************************************************************* PSL **/
#PSL_define f_ReclaimIfSingleRefPath (data_reg, ptr_reg)
{
  @DEBUG { b_ErrorIfSameRegNum (data_reg, ptr_reg); };
  s_IfMRBoff(data_reg) {		/* MRB $B$,Gr$N;~$O2s<}$9$k(B	*/
    s_ReclaimVariable(ptr_reg);
  }
}

/******************************************************************** PSL **
2. $B9=B$BN$NMWAG$N%G%l%U%!%l%s%9(B
2.1  $B9=B$BN%G%l%U%!%l%s%9$N%5%V%k!<%A%s(B ($B6&DL%k!<%A%s(B)

       written by goto@icot22      on Mon Jul 31 11:23:19 1989
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B9=B$BN0z?t$N%G%l%U%!%l%s%9$r9T$&!#(B
  $BL$Dj5A$N>l9g$O$=$N%;%k$X$N%]%$%s%?$r7k2L$H$9$k!#(B
  $B0l2s0J>e%G%l%U$7$?;~$O<j7+$C$?CM$r9=B$BN$K=q$-La$9!#(B
<Examples>
<Test>
<Explanation>
  $B!&9=B$BN$X$N;2>H%Q%9$,(B MRB-ON $B$N;~$O(B, $B9=B$BN$NK\BN$+$iMWAG$N<BBN$^$G$N;2>H(B
    $B%Q%9$K$"$k4V@\%;%k$r2s<}$7$J$$!#$^$?(B, $B%G%l%U7k2L$O(B MRB-ON $B$H$7$F9=B$BN$K(B
    $B=q$-La$9!#(B
    $B$3$l$O(B, $B9=B$BN$NMWAG$rJL$N%Q%9$+$iFI$_=q$1$F$$$?%W%m%;%C%5$,$"$C$?>l9g(B,
    $BESCf$N4V@\%;%k$,2s<}$5$l$k$HLB;R$K$J$C$F$7$^$&$?$a$G$"$k!#(B
    $B$3$N$?$a$K(B, $B9=B$BNMWAG$rFI$_=P$9;~$K(B, str_reg $B$N(BMRB$B$,(Belm_reg$B$N(BMRB$B$K(BOR$B$5$l$k(B
    $B$h$&$K$J$C$F$$$k!#(B

  <before>		      elm_reg
				REFo
 str_reg	+-------+	|
  STRx ---+---->|	|	|
          |	|-------|	|	+-------+	+-------+
  STRx ---+	|  REFo-+-------+------>|  REFo-+------>| ATOMo	|
		+-------+		+-------+	+-------+

  <after>		      elm_reg
				ATOMo
 str_reg	+-------+	
  STRx ---+---->|	|		$B2s<}$7$J$$(B	$B2s<}$7$J$$(B
          |	|-------|		+-------+	+-------+
  STRx ---+	| ATOMx	|		|  REFo-+------>| ATOMo	|
		+-------+		+-------+	+-------+
<ETC>
********************************************************************* PSL **/

#SUBARG_define	A_StrPtr	SRC	/* ?? */
#SUBARG_define	A_ElemPos      	SRC
#SUBARG_define	A_ElemReg	MODIFY

#SUBROUTINE f_DerefElement_Sub (A_StrPtr, A_ElemPos, A_ElemReg)
{
  @DEBUG{
    s_IfNotREF(A_ElemReg) {
      VPIM_ERROR("f_DerefElement_Sub","Illegal Invocation");
    }
  };
  $USE(D_WorkDerefPtr); 
  s_DerefReg(A_ElemReg, D_WorkDerefPtr);
  s_IfUnbound(A_ElemReg) {				/* $BL$Dj5A$N>l9g(B	*/
		/* $B0z?t%l%8%9%?(B(A_ElemReg)$B$K(Bderef$B%;%k$X$N%]%$%s%?$rEO$9(B */
    p_MoveWord (D_WorkDerefPtr, A_ElemReg);
  } else {					/* $B6qBN2=$7$?CM$N;~(B	*/
    f_ReclaimDerefRestoreUnboundLoop (A_ElemReg, D_WorkDerefPtr);
    $USE(D_WorkElemAddr);
    s_GetStructElemAddrPosReg (A_StrPtr, A_ElemPos, D_WorkElemAddr); 
    	/* Write $BA`:n$,%"%H%_%C%/A`:n$H$7$F9T$o$l$J$$$H4m81(B ?? by Goto */
    p_Write(A_ElemReg, D_WorkElemAddr);
    $RELEASE(D_WorkElemAddr);
  }
  $RELEASE(D_WorkDerefPtr);
  $RETURN ();
}

#PSL_define f_ReclaimDerefRestoreUnboundLoop (data_reg, ptr_reg)
{
  @DEBUG{
    s_IfNotREF(ptr_reg) {
      VPIM_ERROR("f_ReclaimDerefRestoreUnboundLoop","Illegal Invocation");
    }
  };
  LOOP(){
    f_ReclaimIfSingleRefPath (data_reg, ptr_reg);
    s_IfREF(data_reg) {
      s_DerefReg(data_reg, ptr_reg);
      s_IfUnbound (data_reg) {
	/* $B0z?t%l%8%9%?(B(data_reg)$B$K(Bderef$B$7$?(Bunbound var$B$X$N%]%$%s%?$rF~$l$k(B */
	p_MoveWord (ptr_reg, data_reg);
	break;	/* if (reaching unbound var) {going out of LOOP}	*/
      }
    } else {
      break;			/* if (not REF) {going out of LOOP}	*/
    }
  }
  @DEBUG{
    s_IfUnbound(data_reg){
      VPIM_ERROR("f_ReclaimDerefRestoreUnboundLoop","Illegal Return Value");
    }
  };
}

/******************************************************************** PSL **
2.2 $BMWAG0LCV;XDj(B(KL1-B$BL?Na%*%Z%i%s%I(B, $B%l%8%9%?(B, $BB(CM(B) $BKh$N%^%/%m(B

       written by goto@icot22      on Mon Jul 31 11:31:05 1989
<Arguments>
  str_ptr : $B9=B$BN(B($BK\BN(B)$B$X$N%]%$%s%?(B
  opr_ofst : $BMWAG0LCV$r<($9L?Na%*%Z%i%s%I(B($B%"%I%l%9%*%U%;%C%H(B)
  ofst_reg : $BMWAG0LCV$r<($9%l%8%9%?(B($B%"%I%l%9%*%U%;%C%H(B)
  elm_reg : $B%G%l%U%!%l%s%9$r9T$&0z?t%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  f_DerefElementOpr : $B<uF0It$N4pK\A`:n(B (invoked only by klb_new_argument.psl.c)
  f_DerefElementReg : $B<uF0It$NHFMQ%f%K%U%#%1!<%7%g%s$G;HMQ(B
                                       (invoked only by f_passive_unify.psl.c)
                      $B%,!<%I$NAH9~=R8l(B(vector_element)$B$G$b;HMQ(B(1989.10.24)
                                       (invoked also by klb_guard_blt.psl.c)
<ETC>
********************************************************************* PSL **/
#DATA_define D_WorkElemPos	XXX

#PSL_define f_DerefElementOpr (str_ptr, opr_ofst, elm_reg) 
{
  @DEBUG { b_ErrorIfSameRegNum (str_ptr, elm_reg); };
  @PROBE{ deref_probe(elm_reg); };
  s_IfREF(elm_reg) {
    $USE(D_WorkElemPos);
    p_MoveImmediateValueFromImmediateField (opr_ofst, D_WorkElemPos);
    $CALL ( f_DerefElement_Sub (str_ptr, D_WorkElemPos, elm_reg) );
    $RELEASE(D_WorkElemPos);
  }
}

#PSL_define f_DerefElementReg (str_ptr, ofst_reg, elm_reg) 
/* ofst_reg$B$O8F$S$@$7B&$G%"%I%l%C%7%s%0JQ49$5$l$F$$$k!#(B*/
{
  @DEBUG { b_ErrorIfSameRegNum (str_ptr, elm_reg); };
  @PROBE{ deref_probe(elm_reg); };
  s_IfREF(elm_reg) {
    $CALL ( f_DerefElement_Sub (str_ptr, ofst_reg, elm_reg) );
  } 
}

/******************************************************************** PSL **
3. CollectValue $B$+$i8F$P$l$k:F5"E*$J2s<}(B

(#SUBROUTINE) f_CollectValue_Sub()

       written by imai@icot22      on Mon Nov 26 10:47:41 1990
<Arguments>
  A_Arg: $B:F5"E*$K2s<}$9$k9=B$$X$N%]%$%s%?$r(B MRB-off $B$GJ];}$7$?%l%8%9%?(B
<Temporally Used Variables>
  D_WorkVectSize : $B%m%s%0%Y%/%?$N%5%$%:$r3JG<$9$k%l%8%9%?(B
                     (defined in klb_body_blt_data.psl.c)
<Level>
<PreCondition>
  A_Arg $B$N(B MRB $B$O!"I,$:!{$G$"$k$3$H(B
<Function>
<Examples>
<Test>
<Explanation>
  $B;2>H2U=j(B
    $B!&(Bklb_collect_value $B$NK\BN(B(klb_collect.psl.c)
    $B!&Gr%Q%9(BVOID$B$HJQ?t$H$N%f%K%U%!%$$NK\BN(B(klb_unify.psl.c)
<ETC>
  1990.11.16 :	1) functions $B%l%Y%k$K0\F0(B
********************************************************************* PSL **/

#DATA_define D_WorkVOID		XXX    /* $B%3%s%Z%"%9%o%C%WMQ%l%8%9%?(B */
#DATA_define D_WorkDrfPtr       XXX    /* $B%G%l%UMQ$N%o!<%/%]%$%s%?(B */
#DATA_define D_WorkCollect      XXX    /* $B%j%9%H(BCDR$BIt$r2s<}$9$k%l%8%9%?(B */
#DATA_define D_WorkCollectCtr   XXX    /* $B%j%9%H(BCDR$BIt$N2s<}%+%&%s%?(B */
#DATA_define D_WorkCollectValueCaller	XXX	/* A_Caller$B$K;HMQ(B */

#CONST_define _COLLECT_VALUE_NEST_DEPTH  8

#CONST_define _COLLECT_VALUE_FROM_KL1B_COLLECT_VALUE	0
#CONST_define _COLLECT_VALUE_FROM_RELEASE_MESSAGE	1
#CONST_define _COLLECT_VALUE_FROM_UNIFY_VOID		2

#SUBARG_define A_Arg	MODIFY
#SUBARG_define A_Caller	SRC

#SUBROUTINE f_CollectValue_Sub(A_Arg, A_Caller)
{
  @DEBUG{
    s_IfMRBon(A_Arg) {
      VPIM_ERROR("f_CollectValue_Sub","Illegal Invoke! (MRB is ON)");
    }
  };
  $USE(D_WorkDrfPtr);   $USE(D_WorkCollectCtr);
  b_SetImmValueDNTC(_COLLECT_VALUE_NEST_DEPTH, D_WorkCollectCtr);

  LOOP() {	/* $B%k!<%W$G2s$k$N$O!"(BCDR$B$,%j%9%H$G$"$k;~$@$1(B */
    f_ActiveDeref(A_Arg, D_WorkDrfPtr);
    s_IfMRBon(A_Arg) { goto EndOfLoop; }
    @COUNT_TYPE { s_CountType (A_Arg); };
    TypeSwitch(A_Arg){
      case LIST:
	$USE(D_WorkCollect);
	s_GetCdrList(A_Arg,D_WorkCollect);
	s_ReclaimList(A_Arg);
	p_MoveWord(D_WorkCollect,A_Arg);
	$RELEASE(D_WorkCollect);
	b_DecrementReg(D_WorkCollectCtr);
	p_IfEQ() { goto EndOfLoop; }
	break; /* Loop Again */
      case AtomicGrp(): case NullVectorGrp(): case ControlGroup():
	/* $B2?$b$7$J$$$G!"%j%?!<%s$9$k(B */
	goto EndOfLoop;
      case FloatingGrp():
/*	@DEBUG {WARNING("f_CollectValue_Sub", "collect FLT");};		*/
	s_ReclaimFLT(A_Arg);
	goto EndOfLoop;
      case ShortVectorGrp():
	s_ReclaimShortVector(A_Arg); 
	goto EndOfLoop;
      case LongVectorGrp():
	$USE(D_WorkVectSize);
	s_GetSizeLongVect(A_Arg, D_WorkVectSize);
	s_ReclaimLongVector(D_WorkVectSize, A_Arg);
	$RELEASE(D_WorkVectSize);
	goto EndOfLoop;
      case StringGrp():
        s_ReclaimString(A_Arg);
	goto EndOfLoop;
      case VOID:
	s_ReclaimVariable(D_WorkDrfPtr); 
	goto EndOfLoop;
      case UNDF: case EUNDF:
	$USE(D_WorkVOID); 
	b_MoveWithImmTypeMRBoff(D_NULL, VOID, D_WorkVOID);
	b_CompareSwapWithOffsetX(D_WorkDrfPtr,_WORD_0,A_Arg,D_WorkVOID);
	p_IfNE() {
	  $RELEASE(D_WorkVOID);
	  p_MoveWord(D_WorkDrfPtr,A_Arg);
		/* UNDF --> EUNDF $B$G(B C&S $B$K<:GT$9$k$H$^$:$$$N$G(B */
	  break; /* Retry */
	}
	$RELEASE(D_WorkVOID);
	goto EndOfLoop;
      case HOOK: case EHOOK:
	s_IfMRBoff(A_Arg) { /* $B%*%V%8%'%/%H(BMRB$B$,!{$N>l9g!"1J5WCfCG$N8!=P(B */
	  $USE(D_WorkDeadlockType);
	  ValueSwitch( A_Caller ) {
	  case _COLLECT_VALUE_FROM_KL1B_COLLECT_VALUE:
	    /*--- CollectorInfo $B$O!"8=:_<B9TCf$N%4!<%k(B ---*/
	    b_SetImmTypeValueMRBoff
	      (INT,_DEADLOCK_BY_COLLECT_VALUE,D_WorkDeadlockType);
	    $USE(D_WorkCollectorInfo);
	    /*-- D_ArgReg0 $B$,;X$9%4!<%k%l%3!<%ICf$N(B CODE $B$O!"$"$F$K$J$i$J$$(B */
	    s_GetPredTopFromPC( D_KLB_PC, D_WorkCollectorInfo );
	    /*-- D_WorkDrfPtr $B$N@h$r(B UNDF $B$KD>$9(B --*/
	    b_WriteImmTagWithOffset(_MRB_OFF,UNDF,D_NULL,D_WorkDrfPtr,_ZERO);
	    $CALL(f_PerpetualSuspensionException_Sub
		  (A_Arg, D_WorkDeadlockType, D_WorkCollectorInfo));
	    $RELEASE(D_WorkCollectorInfo);
	    break;
	  case _COLLECT_VALUE_FROM_RELEASE_MESSAGE:
	    /*--- CollectorInfo $B$O!"$o$+$i$J$$(B ---*/
	    b_SetImmTypeValueMRBoff
	      (INT,_DEADLOCK_BY_RELEASE_MESSAGE,D_WorkDeadlockType);
	    /*-- D_WorkDrfPtr $B$N@h$r(B UNDF $B$KD>$9(B --*/
	    @DEBUG{ s_IfHOOK(A_Arg) {
	      VPIM_ERROR("f_CollectValue_Sub","Why HOOK not EHOOK???");}};
	    b_WriteImmTagWithOffset(_MRB_OFF,UNDF,D_NULL,D_WorkDrfPtr,_ZERO);
	    b_SetImmTypeMRBoff( HOOK, A_Arg ); /* EHOOK $B$K$J$C$F$$$k$O$:(B */
	    $CALL(f_PerpetualSuspensionException_Sub
		  (A_Arg, D_WorkDeadlockType, D_EOL));
	    break;
	  case _COLLECT_VALUE_FROM_UNIFY_VOID:
	    /*--- CollectorInfo $B$O!"$o$+$i$J$$(B ---*/
	    b_SetImmTypeValueMRBoff
	      (INT,_DEADLOCK_BY_VOID_HOOK_UNIFY,D_WorkDeadlockType);
	    /*-- D_WorkDrfPtr $B$N@h$r(B UNDF $B$KD>$9(B --*/
	    b_WriteImmTagWithOffset(_MRB_OFF,UNDF,D_NULL,D_WorkDrfPtr,_ZERO);
	    $CALL(f_PerpetualSuspensionException_Sub
		  (A_Arg, D_WorkDeadlockType, D_EOL));
	    break;
	  default:
	    @DEBUG{VPIM_ERROR("f_CollectValue_Sub","Illegal A_Caller");};
	  }
	  $RELEASE(D_WorkDeadlockType);
	  goto EndOfLoop;
	} /* else same as MHOOK etc */
      case MHOOK: case EMHOK:
	$USE(D_WorkVOID); 
	b_MoveWithImmTypeMRBoff(D_NULL, VOID, D_WorkVOID);
	b_CompareSwapWithOffsetX
	  (D_WorkDrfPtr,_ZERO, A_Arg,D_WorkVOID);
	p_IfEQ() {
  	/* $BC!$-5/$3$7$?%4!<%k$,<+J,$G%G%C%I%m%C%/$rJs9p$9$k2DG=@-$,$"$k$?$a(B */
	  $RELEASE(D_WorkVOID); 
	  $CALL( f_WakeUpProcess_Sub( A_Arg ) );
	  goto EndOfLoop;
	} else { 
	  $RELEASE(D_WorkVOID); 
	  p_MoveWord(D_WorkDrfPtr,A_Arg); 
		/* MHOOK --> EMHOOK $B$G(B C&S $B$K<:GT$9$k$H$^$:$$$N$G(B */
	  break; /* Retry! */
	}
      case EXLOCK:
      case RDHOK:
      case RHOOK:
	/* $BJ#?t;2>H$J$N$G(Bcollect$BL?Na$,=P$F$b2?$b$7$J$$(B */
	goto EndOfLoop;
      case ExvalGrp():
      case ExrefGrp():
	s_IfSuccessSoftLockExCell(D_WorkDrfPtr, A_Arg){
	  $CALL( f_Send_IntClMsg_Release_byCollectValue_Sub(D_WorkDrfPtr,
							    A_Arg) );
	}
	goto EndOfLoop;
      case StreamGrp():
	$USE(D_WorkNumCount);	$USE(D_WorkDeadlockType);
	b_SetImmTypeValueMRBoff(INT,_ONE,D_WorkNumCount);
	ValueSwitch( A_Caller ) {
	case _COLLECT_VALUE_FROM_KL1B_COLLECT_VALUE:
	    /*--- CollectorInfo $B$O!"8=:_<B9TCf$N%4!<%k(B ---*/
	  b_SetImmTypeValueMRBoff
	    (INT,_DEADLOCK_BY_COLLECT_VALUE,D_WorkDeadlockType);
	  $USE(D_WorkCollectorInfo);
	    /*-- D_ArgReg0 $B$,;X$9%4!<%k%l%3!<%ICf$N(B CODE $B$O!"$"$F$K$J$i$J$$(B */
	  s_GetPredTopFromPC( D_KLB_PC, D_WorkCollectorInfo );
	  $CALL(f_MergerPerpetualSuspensionException_Sub
		(A_Arg,D_WorkDeadlockType,D_WorkNumCount,D_WorkCollectorInfo));
	  $RELEASE(D_WorkCollectorInfo);
	  break;
	case _COLLECT_VALUE_FROM_RELEASE_MESSAGE:
	    /*--- CollectorInfo $B$O!"$o$+$i$J$$(B ---*/
	  b_SetImmTypeValueMRBoff
	    (INT,_DEADLOCK_BY_RELEASE_MESSAGE,D_WorkDeadlockType);
	  $CALL(f_MergerPerpetualSuspensionException_Sub
		(A_Arg,D_WorkDeadlockType,D_WorkNumCount,D_EOL));
	  break;
	case _COLLECT_VALUE_FROM_UNIFY_VOID:
	    /*--- CollectorInfo $B$O!"$o$+$i$J$$(B ---*/
	  b_SetImmTypeValueMRBoff
	    (INT,_DEADLOCK_BY_VOID_HOOK_UNIFY,D_WorkDeadlockType);
	  $CALL(f_MergerPerpetualSuspensionException_Sub
		(A_Arg,D_WorkDeadlockType,D_WorkNumCount,D_EOL));
	  break;
	default:
	  @DEBUG{VPIM_ERROR("f_CollectValue_Sub","Illegal A_Caller");};
	}
	$RELEASE(D_WorkNumCount);	$RELEASE(D_WorkDeadlockType);
	goto EndOfLoop;
      default: /* $B4^$`(B REF */
	@DEBUG{	VPIM_ERROR("collect_value","Illegal_type"); };
    }
  }
 EndOfLoop:
  $RELEASE(D_WorkDrfPtr); $RELEASE(D_WorkCollectCtr);
  $RETURN();
}
