
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_reduce_bignum.psl.c
   ----- CREATED   : by yamamoto@icot22, on Sun Feb 23 19:00:43 1992
   ----- LAST SAVED: by yamamoto@icot22, on Sun Feb 23 19:20:22 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : 
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **

       written by yamamoto@icot22      on Sun Feb 23 19:19:21 1992

$BG\@:EY@0?t!"B>G\D9@:EY@0?t$N%5%]!<%H$G?7$?$K:n@.$7$?!"(B
$B#f%l%Y%k%^%/%m(B

********************************************************************* PSL **/

#DATA_define D_WorkBignumStrLen1 XXX
#DATA_define D_WorkBignumStrLen2 XXX
#DATA_define D_WorkBignumStr1 XXX
#DATA_define D_WorkBignumStr2 XXX

#DATA_define D_WorkBignumStrAllocSize XXX

#SUBARG_define A_StrSrc1 SRC
#SUBARG_define A_StrSrc2 SRC
#SUBARG_define A_StrLen1 SRC
#SUBARG_define A_StrLen2 SRC
#SUBARG_define A_StrDst  DST

#SUBROUTINE f_Add_BIGNUM_Sub(A_StrSrc1,A_StrSrc2,A_StrLen1,A_StrLen2,A_StrDst){
  /* $B?7$?$J%9%H%j%s%0$N3d$jIU$1$K<:GT$7$?;~$O!"(BA_StrDst $B$K(B D_NULL $B$r$+$($9!#(B*/
  /* D-code $B$K$h$k:F<B9T$O8F$S=P$7B&$G5-=R$9$k$3$H!#(B*/

  b_IfZero(A_StrLen1){
    f_CopyStringMRB(A_StrSrc2,A_StrDst);
    /* $BGr$J$i%]%$%s%?$N%3%T!<!"9u$J$i%9%H%j%s%0$r3d$jIU$1$FMWAG$r%3%T!<(B */
    /* $B3d$jIU$1$K<:GT$7$?;~$O!"(BD_NULL $B$rJV$9!#(B*/
    b_IfNotEOL(A_StrDst){
      s_IfMRBoff(A_StrSrc1){s_ReclaimString(A_StrSrc1);}
    }
    goto L_END;
  }
  b_IfZero(A_StrLen2){
    f_CopyStringMRB(A_StrSrc1,A_StrDst);
    b_IfNotEOL(A_StrDst){
      s_IfMRBoff(A_StrSrc2){s_ReclaimString(A_StrSrc2);}
    }
    goto L_END;
  }

  $USE(D_WorkBignumElmSize);
  b_SetImmTypeValueMRBoff (INT,_BIGNUM_ELM_SIZE,D_WorkBignumElmSize);

  $USE(D_WorkBignumStrLen1);/* $BD9$$J}!JC;$/$J$$!D!K(B */
  $USE(D_WorkBignumStr1);
  $USE(D_WorkBignumStrLen2);/* $BC;$$J}(B */
  $USE(D_WorkBignumStr2);
  $USE(D_WorkBignumStrAllocSize);

  b_IfEqual(A_StrLen1,A_StrLen2){
    p_MoveWord(A_StrLen1,D_WorkBignumStrAllocSize);
    p_MoveWord(A_StrLen1,D_WorkBignumStrLen1);
    p_MoveWord(A_StrSrc1,D_WorkBignumStr1);
    p_MoveWord(A_StrLen2,D_WorkBignumStrLen2);
    p_MoveWord(A_StrSrc2,D_WorkBignumStr2);
    goto L_SameLen;
  }

  b_IfGreater(A_StrLen1,A_StrLen2){
    p_MoveWord(A_StrLen1,D_WorkBignumStrAllocSize);
    p_MoveWord(A_StrLen1,D_WorkBignumStrLen1);
    p_MoveWord(A_StrSrc1,D_WorkBignumStr1);
    p_MoveWord(A_StrLen2,D_WorkBignumStrLen2);
    p_MoveWord(A_StrSrc2,D_WorkBignumStr2);
  }else{
    p_MoveWord(A_StrLen2,D_WorkBignumStrAllocSize);
    p_MoveWord(A_StrLen2,D_WorkBignumStrLen1);
    p_MoveWord(A_StrSrc2,D_WorkBignumStr1);
    p_MoveWord(A_StrLen1,D_WorkBignumStrLen2);
    p_MoveWord(A_StrSrc1,D_WorkBignumStr2);
  }

  $USE(D_WorkBignumFirstElm);
  s_GetStringWordPosReg(D_WorkBignumStr1,D_NULL,D_WorkBignumFirstElm);
  b_IfNotEqual(D_WorkBignumFirstElm,D_ALL1){goto L_NoCarry;}
  $RELEASE(D_WorkBignumFirstElm);    

  b_IncrementReg(D_WorkBignumStrAllocSize);/* $B7W;;7k2L3dIU$N$?$a0l$DD9$/(B */
  f_AllocString(A_StrDst,D_WorkBignumStrAllocSize,D_WorkBignumElmSize);
  b_IfEOL(A_StrDst){goto L_END2;}

  /* dst_len -1 = src_len1 > src_len2 */
  s_Add_BIGNUM_1(D_WorkBignumStr1,D_WorkBignumStrLen1,
		 D_WorkBignumStr2,D_WorkBignumStrLen2,
		 A_StrDst,D_WorkBignumStrAllocSize);
  goto L_END3;

 L_NoCarry:
  $RELEASE(D_WorkBignumFirstElm);    
  f_AllocString(A_StrDst,D_WorkBignumStrAllocSize,D_WorkBignumElmSize);
  b_IfEOL(A_StrDst){goto L_END2;}

  /* dst_len = src_len1 > src_len2 */
  s_Add_BIGNUM_2(D_WorkBignumStr1,D_WorkBignumStrLen1,
		 D_WorkBignumStr2,D_WorkBignumStrLen2,
		 A_StrDst,D_WorkBignumStrAllocSize);
  goto L_END3;

 L_SameLen:
  b_IncrementReg(D_WorkBignumStrAllocSize);/* $B7W;;7k2L3dIU$N$?$a0l$DD9$/(B */
  f_AllocString(A_StrDst,D_WorkBignumStrAllocSize,D_WorkBignumElmSize);
  b_IfEOL(A_StrDst){goto L_END2;}

  /* dst_len -1 = src_len1 = src_len2 */
  s_Add_BIGNUM_3(D_WorkBignumStr1,D_WorkBignumStrLen1,
		 D_WorkBignumStr2,D_WorkBignumStrLen2,
		 A_StrDst,D_WorkBignumStrAllocSize);
 L_END3:
  s_IfMRBoff(A_StrSrc1){s_ReclaimString(A_StrSrc1);}
  s_IfMRBoff(A_StrSrc2){s_ReclaimString(A_StrSrc2);}
 L_END2:
  $RELEASE(D_WorkBignumElmSize);
  $RELEASE(D_WorkBignumStrLen1);
  $RELEASE(D_WorkBignumStr1);
  $RELEASE(D_WorkBignumStrLen2);
  $RELEASE(D_WorkBignumStr2);
  $RELEASE(D_WorkBignumStrAllocSize);
 L_END: ;

  $RETURN();

}

#SUBARG_define A_StrSrc1 SRC
#SUBARG_define A_StrSrc2 SRC
#SUBARG_define A_StrLen1 SRC
#SUBARG_define A_StrLen2 SRC
#SUBARG_define A_IntDst  DST
#SUBARG_define A_StrDst  DST

#SUBROUTINE f_Subtract_BIGNUM_Sub(A_StrSrc1,A_StrSrc2,A_StrLen1,
				  A_StrLen2,A_IntDst,A_StrDst){
  /* $B?7$?$J%9%H%j%s%0$N3d$jIU$1$K<:GT$7$?;~$O!"(BA_StrDst $B$K(B D_NULL $B$r$+$($9!#(B*/
  /* D-code $B$K$h$k:F<B9T$O8F$S=P$7B&$G5-=R$9$k$3$H!#(B*/

  b_IfZero(A_StrLen2){
    f_CopyStringMRB(A_StrSrc1,A_StrDst);
    /* $BGr$J$i%]%$%s%?$N%3%T!<!"9u$J$i%9%H%j%s%0$r3d$jIU$1$FMWAG$r%3%T!<(B */
    /* $B3d$jIU$1$K<:GT$7$?;~$O!"(BD_NULL $B$rJV$9!#(B*/
    b_IfNotEOL(A_StrDst){
      b_SetImmTypeValueMRBoff (INT, _ZERO, A_IntDst);
      s_IfMRBoff(A_StrSrc2){s_ReclaimString(A_StrSrc2);}
    }
    goto L_END;
  }
  b_IfZero(A_StrLen1){
    f_CopyStringMRB(A_StrSrc2,A_StrDst);
    b_IfNotEOL(A_StrDst){
      b_SetImmTypeValueMRBoff (INT, _ONE, A_IntDst);
      s_IfMRBoff(A_StrSrc1){s_ReclaimString(A_StrSrc1);}
    }
    goto L_END;
  }

  $USE(D_WorkBignumElmSize);
  b_SetImmTypeValueMRBoff (INT,_BIGNUM_ELM_SIZE,D_WorkBignumElmSize);

  $USE(D_WorkBignumStrLen1);/* $BBg$-$$J}!J>.$5$/$J$$!D!K(B */
  $USE(D_WorkBignumStr1);
  $USE(D_WorkBignumStrLen2);/* $B>.$5$$J}(B */
  $USE(D_WorkBignumStr2);
  $USE(D_WorkBignumStrAllocSize);

  s_CompareBIGNUM(A_StrSrc1,A_StrSrc2);
  p_IfEQ(){
    b_SetImmTypeValueMRBoff (INT, _ZERO, A_IntDst);
    p_MoveWord(D_NULL,D_WorkBignumStrAllocSize);
    goto L_Same;
  }  
  p_IfGT(){
    b_SetImmTypeValueMRBoff (INT, _ZERO, A_IntDst);
    p_MoveWord(A_StrLen1,D_WorkBignumStrAllocSize);
    p_MoveWord(A_StrLen1,D_WorkBignumStrLen1);
    p_MoveWord(A_StrSrc1,D_WorkBignumStr1);
    p_MoveWord(A_StrLen2,D_WorkBignumStrLen2);
    p_MoveWord(A_StrSrc2,D_WorkBignumStr2);
  }else{
    b_SetImmTypeValueMRBoff (INT, _ONE, A_IntDst);
    p_MoveWord(A_StrLen2,D_WorkBignumStrAllocSize);
    p_MoveWord(A_StrLen2,D_WorkBignumStrLen1);
    p_MoveWord(A_StrSrc2,D_WorkBignumStr1);
    p_MoveWord(A_StrLen1,D_WorkBignumStrLen2);
    p_MoveWord(A_StrSrc1,D_WorkBignumStr2);
  }
  f_AllocString(A_StrDst,D_WorkBignumStrAllocSize,D_WorkBignumElmSize);
  b_IfEOL(A_StrDst){goto L_END2;}

  s_Subtract_BIGNUM(D_WorkBignumStr1,D_WorkBignumStrLen1,
		    D_WorkBignumStr2,D_WorkBignumStrLen2,
		    A_StrDst,D_WorkBignumStrAllocSize);
  goto L_END2;
 L_Same:
  f_AllocString(A_StrDst,D_WorkBignumStrAllocSize,D_WorkBignumElmSize);
  /* alloc just CDESK word */
 L_END2:
  $RELEASE(D_WorkBignumElmSize);
  $RELEASE(D_WorkBignumStrLen1);
  $RELEASE(D_WorkBignumStr1);
  $RELEASE(D_WorkBignumStrLen2);
  $RELEASE(D_WorkBignumStr2);
  $RELEASE(D_WorkBignumStrAllocSize);

 L_END: ;
  $RETURN();

}

#SUBARG_define A_StrSrc SRC
#SUBARG_define A_IntSrc SRC
#SUBARG_define A_StrLen SRC
#SUBARG_define A_StrDst DST

#SUBROUTINE f_Multiply_BIGNUM_By_Word_Sub(A_StrSrc,A_IntSrc,A_StrLen,A_StrDst){
  /* $B?7$?$J%9%H%j%s%0$N3d$jIU$1$K<:GT$7$?;~$O!"(BA_StrDst $B$K(B D_NULL $B$r$+$($9!#(B*/
  /* D-code $B$K$h$k:F<B9T$O8F$S=P$7B&$G5-=R$9$k$3$H!#(B*/

  b_IfZero(A_StrLen){
    f_CopyStringMRB(A_StrSrc,A_StrDst);
    /* $BGr$J$i%]%$%s%?$N%3%T!<!"9u$J$i%9%H%j%s%0$r3d$jIU$1$FMWAG$r%3%T!<(B */
    /* $B3d$jIU$1$K<:GT$7$?;~$O!"(BD_NULL $B$rJV$9!#(B*/
    goto L_END;
  }
  b_IfZero(A_IntSrc){
    $USE(D_WorkBignumElmSize);
    b_SetImmTypeValueMRBoff (INT,_BIGNUM_ELM_SIZE,D_WorkBignumElmSize);
    f_AllocString(A_StrDst,D_NULL,D_WorkBignumElmSize);
    $RELEASE(D_WorkBignumElmSize);
    b_IfNotEOL(A_StrDst){
      s_IfMRBoff(A_StrSrc){s_ReclaimString(A_StrSrc);}
    }
    goto L_END;
  }

  $USE(D_WorkBignumElmSize);
  b_SetImmTypeValueMRBoff (INT,_BIGNUM_ELM_SIZE,D_WorkBignumElmSize);

  $USE(D_WorkBignumStrLen1);
  $USE(D_WorkBignumStr1);
  $USE(D_WorkBignumStrAllocSize);

  p_MoveWord(A_StrLen,D_WorkBignumStrAllocSize);
  p_MoveWord(A_StrLen,D_WorkBignumStrLen1);
  p_MoveWord(A_StrSrc,D_WorkBignumStr1);

/* for add
  $USE(D_WorkBignumFirstElm);
  s_GetStringWordPosReg(D_WorkBignumStrLen1,D_NULL,D_WorkBignumFirstElm);
  b_IfNotEqual(D_WorkBignumFirstElm,D_ALL1){goto L_NoCarry;}
  $RELEASE(D_WorkBignumFirstElm);    
*/

  b_IncrementReg(D_WorkBignumStrAllocSize);/* $B7W;;7k2L3dIU$N$?$a0l$DD9$/(B */
  f_AllocString(A_StrDst,D_WorkBignumStrAllocSize,D_WorkBignumElmSize);
  b_IfEOL(A_StrDst){goto L_END2;}

  s_Multiply_BIGNUM_By_Word(D_WorkBignumStr1,D_WorkBignumStrLen1,
			    A_IntSrc,A_StrDst,D_WorkBignumStrAllocSize);
  goto L_END3;

/* for add 
 L_NoCarry:
  $RELEASE(D_WorkBignumFirstElm);    
  f_AllocString(A_StrDst,D_WorkBignumStrAllocSize,D_WorkBignumElmSize);
  b_IfEOL(A_StrDst){goto L_END2;}

  s_Add_BIGNUM_2(D_WorkBignumStr1,D_WorkBignumStrLen1,
		 D_WorkBignumStr2,D_WorkBignumStrLen2,
		 A_StrDst,D_WorkBignumStrAllocSize);
  goto L_END3;
*/

 L_END3:
  s_IfMRBoff(A_StrSrc){s_ReclaimString(A_StrSrc);}
 L_END2:
  $RELEASE(D_WorkBignumElmSize);
  $RELEASE(D_WorkBignumStrLen1);
  $RELEASE(D_WorkBignumStr1);
  $RELEASE(D_WorkBignumStrAllocSize);
 L_END: ;
$RETURN();
}

