
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_reduce_active_unify.psl.c
   ----- CREATED   : by hirata@icot22, on Mon Jun  4 15:25:46 1990
   ----- LAST SAVED: by imai@icot22, on Mon May 11 14:41:25 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : function
   ----- ABSTRACT  : GET$B7OL?NaEy$K$*$1$k%"%/%F%#%V%f%K%U%!%$A`:n(B

A. $B9`L\(B
  1. $B%"%/%F%#%V%f%K%U%!%$A`:n(B
  2. $B%5%9%Z%s%I%4!<%k$N%j%s%/(B
  3. UNIFY$B7OL?Na$G(B, $BL$Dj5AJQ?t$N6qBN2=$r(BDcode$B%4!<%k$G:F<B9T$9$k$?$a$N%^%/%m(B

B. MRB
  $B!&2<?^$N$h$&$K(B, Ptr$B$K;X$5$l$?L$Dj5AJQ?t$H(BSTRUCT $B$r%f%K%U%!%$$9$k;~$O(B,
    $BL$Dj5AJQ?t%;%k$N(BMRB$B$O(B Ptr$B$N(BMRB$B$H(BSTRUCT$B$N(BMRB$B$N(BOR$B$H$J$k!#(B
			 ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	  		+-------+
	Ptr  	------->|UNDF	|
	  		+-------+

	  		+-------+
	STRUCT 	------->+-------+
			+-------+
	  		+-------+

 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
f_IfSuccessActUnifyWithPtrMRBX
f_IfFailActUnifyWithPtrMRBX

       written by hirata@icot22      on Mon Jun  4 16:03:58 1990
<Arguments>
  ptr_reg : $BGSB>%"%/%;%9$NBP>]$H$J$k%"%I%l%9$G!"(B
		$B?7%G!<%?$KIU2C$5$l$k(BMRB$B$r;}$C$F$$$k(B
  org_reg : $BA0$b$C$FFI$_=P$7$?GSB>%"%/%;%9$NBP>]$H$J$k%o!<%I$NCf?H(B 
  new_reg : $B%9%o%C%W$9$k?7%G!<%?$N%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
  org_reg$B$K$OA0$b$C$FFI$_=P$7$?%o!<%I$NCf?H$,F~$C$F$$$k$H$9$k(B
<Function>
  ptr_reg$B$N@h$r%m%C%/$7$FFI$_=P$7$?$b$N$H(B org_reg$B$N%?%$%W$N$_$rHf3S$7$F(B, 
  $BEy$7$1$l$P(B new_reg$B$NFbMF$r(B ptr_reg$B$N@h$K=q$-9~$s$G%"%s%m%C%/$9$k!#(B
  $BEy$7$/$J$1$l$P(B, $BFI$_=P$7$?CM$r(B org_reg$B$H$7$F(B ptr_reg$B$N@h$r%"%s%m%C%/$9$k!#(B
  IF$BJ8$H$7$F$NHt$S@h$OHf3S7k2L$K$h$k!#(B
  $B6qBN2=$5$l$kJQ?t$N(BMRB$B$O(B, $B%]%$%s%?%l%8%9%?$N(BMRB$B$H(Bnew_reg$B$N(BMRB$B$N(BOR$B$H$9$k!#(B
<Examples>
  .......
 LabelRetry:
  .......
  s_IfUNDF (org_reg) {
    f_IfSuccessActUnifyWithPtrMRBX (ptr_reg, org_reg, new_reg) {
      .......
    } else {
      goto LabelRetry;
    }
  }
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#CTRL_define f_IfSuccessActUnifyWithPtrMRBX (ptr_reg, org_reg, new_reg)
{
  s_IfMRBon(ptr_reg){
    /* ptr_reg$B$N(BMRB$B$H(Bnew_reg$B$N(BMRB$B$N(BOR$B$r!"(Bnew_reg$B$N(BMRB$B$K@_Dj$9$k!#(B	*/
    p_SetImmediateMRB(_MRB_ON, new_reg);
  }
  b_TypeValueCompareSwapX (ptr_reg, org_reg, new_reg);
  p_IfEQ ()
}
 
#CTRL_define f_IfFailActUnifyWithPtrMRBX (ptr_reg, org_reg, new_reg)
{
  s_IfMRBon(ptr_reg){
    p_SetImmediateMRB(_MRB_ON, new_reg);
  }
  b_TypeValueCompareSwapX (ptr_reg, org_reg, new_reg);
  p_IfNE ()
}

/******************************************************************** PSL **
2. $B%5%9%Z%s%I%A%'!<%s$N%j%s%/(B
  f_IfSuccessHookGoalX
  f_IfFailHookGoalX
       written by goto@icot22      on Mon Apr 10 13:32:50 1989
<Arguments>
 ptr_reg: HOOK, MHOOK $B$J$I$N%;%k$X$N%]%$%s%?$rJ];}$7$?%l%8%9%?(B
 org_reg: ptr_reg $B$,;X$7$F$$$?%;%k$rA0$b$C$FFI$_$@$7$?CM$rJ];}$7$?%l%8%9%?(B
 new_reg: ptr_reg $B$N@h$K%9%o%C%W$9$k?7%G!<%?$N%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  ptr_reg$B$N@h$r%m%C%/$7$FFI$_=P$7$?$b$N$H(B org_reg$B$N%?%$%W$N$_$rHf3S$7$F(B, 
  $BEy$7$1$l$P(B new_reg$B$NFbMF$r(B ptr_reg$B$N@h$K=q$-9~$s$G%"%s%m%C%/$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#CTRL_define f_IfSuccessHookGoalX (ptr_reg, org_reg, new_reg)
{
  b_TypeValueCompareSwapX (ptr_reg, org_reg, new_reg);
  p_IfEQ ()
}

#CTRL_define f_IfFailHookGoalX (ptr_reg, org_reg, new_reg)
{
  b_TypeValueCompareSwapX (ptr_reg, org_reg, new_reg);
  p_IfNE ()
}

/******************************************************************** PSL **
3. UNIFY$B7OL?Na$G(B, $BL$Dj5AJQ?t$N6qBN2=$r(BDcode$B%4!<%k$G:F<B9T$9$k$?$a$N%^%/%m(B

       written by goto@icot22      on Fri Jun 23 20:17:58 1989
<Arguments>
  A_Arg1 : $B0z?t(B ($BDj?t$^$?$O%]%$%s%?(B)
  A_Arg2 : $B0z?t(B ($BDj?t$^$?$O%]%$%s%?(B)
  A_PtrToFP: $B%j%H%i%$$9$k%4!<%k$,=jB0$9$kN$?F$X$N%]%$%s%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  f_IfSuccessActUnifyWithPtrMRBX$B!"(Bf_IfFailActUnifyWithPtrMRBX
  $B$N%3%s%Z%"%9%o%C%W$K$h$kJQ?t$N6qBN2=$K$*$$$F(B, compare$B$K<:GT$7$?;~(B
  ($B$D$^$j(B, $B%m%C%/$7$FFI$_=P$7$?JQ?t%;%k$,(B, $BA0$KFI$_=P$7$?L$Dj5AJQ?t$H(B
  $B0[$J$k;~(B)$B!"%"%/%F%#%V%f%K%U%#%1!<%7%g%s$r9T$&(BDcode Goal $B$r:n$j!"(B
  $B%4!<%k%9%?%C%/$K(Benqueue$B$9$k!#(B
<Examples>
  klb_unify_xxx, f_int_cl_send_throw_goal f_merger_unify $B$K$*$$$F;HMQ(B.
<Test>
<Explanation>
  $B%4!<%k%j%@%/%7%g%s$,A}$($k$3$H$KCm0U!#(B
<ETC>
  f_UnifyRetryInOtherFP_Sub $B$O!"%^!<%8%c$N=jB0$9$kAq1`$,!"8=:_%j%@%/(B
  $B%7%g%sCf$N%4!<%k$,=jB0$9$kAq1`$H0[$J$k>l9g$KMQ$$$i$l$k!#(B
********************************************************************* PSL **/

#SUBARG_define A_ArgReg1 SRC
#SUBARG_define A_ArgReg2 SRC

#SUBROUTINE f_UnifyRetryByDcode_Sub(A_ArgReg1,A_ArgReg2)
{
  $USE(D_WorkNewGR);
  $CALL( f_MakeUnifier_Sub(D_WorkNewGR,A_ArgReg1,A_ArgReg2) );
  f_PushGoalToStack (D_WorkNewGR);
  $RELEASE(D_WorkNewGR);
  $RETURN();
}

#SUBARG_define A_PtrToFP SRC
#SUBARG_define A_EnvRecPtr SRC
#SUBARG_define A_ArgReg1 SRC
#SUBARG_define A_ArgReg2 SRC

#SUBROUTINE f_UnifyRetryInOtherFP_Sub
	(A_PtrToFP,A_EnvRecPtr,A_ArgReg1,A_ArgReg2)
{
  $USE(D_WorkNewGR);
  $USE(D_WorkPriority);
  $USE(D_WorkFPOrgLockTagReg);
  s_LockFPRecord(A_PtrToFP,D_WorkFPOrgLockTagReg);
  $CALL(f_MakeUnifierInOtherFP_Sub
	(A_PtrToFP,A_EnvRecPtr,D_WorkNewGR,A_ArgReg1,A_ArgReg2));
  s_UnlockFPRecord(A_PtrToFP,D_WorkFPOrgLockTagReg);
  $RELEASE(D_WorkFPOrgLockTagReg);
  s_GetPriorityEnvRecord(A_EnvRecPtr, D_WorkPriority);
  $CALL(f_PushGoalToStackWithPriority_Sub(D_WorkNewGR, D_WorkPriority));
  $RELEASE(D_WorkPriority);
  $RELEASE(D_WorkNewGR);
  $RETURN();
}


/******************************************************************** PSL **
(#SUBROUTINE)
  f_HookUnifier_Sub
       written by imai@icot22      on Thu Dec 14 11:10:04 1989
<Arguments>
  A_PtrToHook:   $B%U%C%/%;%k$X$N%]%$%s%?(B
  A_UnifyObject: $BBh(B1$B0z?t$,6qBN2=$5$l$?;~$K!"Bh(B1$B0z?t$H%f%K%U%!%$$5$l$kJQ?t(B
			$B$X$N%]%$%s%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  
<Examples>
<Test>
<Explanation>
<ETC>
  D_WorkPtrToHook$B$N@h$O!"4{$K6qBN2=$5$l$F$$$k2DG=@-$,(B($B$H$&$<$s(B)$B$"$k$,!"(B
  $B$=$N>l9g$N=hM}$O!"(Bf_HookSingleSuspendGoal_Sub $B$K$F5-=R$5$l$F$$$k$N$G!"(B
  $B$=$A$i$r;2>H$5$l$?$7!#(B
********************************************************************* PSL **/

#SUBARG_define A_PtrToHOOK SRC
#SUBARG_define A_UnifyObject SRC

#SUBROUTINE f_HookUnifier_Sub(A_PtrToHOOK, A_UnifyObject)
{
  $USE(D_WorkNewGR);
  $CALL( f_MakeUnifier_Sub(D_WorkNewGR,A_PtrToHOOK, A_UnifyObject) );
  $CALL( f_HookSingleSuspendGoal_Sub(D_WorkNewGR, A_PtrToHOOK) );
  $RELEASE(D_WorkNewGR);
  $RETURN();
}

#SUBARG_define A_PtrToUnifierGR DST
#SUBARG_define A_ArgReg1	SRC
#SUBARG_define A_ArgReg2	SRC

#SUBROUTINE f_MakeUnifier_Sub(A_PtrToUnifierGR,A_ArgReg1,A_ArgReg2)
{
  $CALL( f_Make_DcodeGoalRecordWithoutParentInfo_Sub(A_PtrToUnifierGR) );
  s_PutImmArityGoalRecord(A_PtrToUnifierGR, _TWO);
  f_PutDcodeAddress(A_PtrToUnifierGR, DCODE_UNIFY_RETRY);
  f_Put2ArgsGoalRecord(A_PtrToUnifierGR,A_ArgReg1,A_ArgReg2);
  $RETURN();
}

#SUBARG_define A_PtrToFP SRC
#SUBARG_define A_EnvRecPtr SRC
#SUBARG_define A_PtrToGR DST
#SUBARG_define A_ArgReg1 SRC
#SUBARG_define A_ArgReg2 SRC

#SUBROUTINE f_MakeUnifierInOtherFP_Sub
	(A_PtrToFP,A_EnvRecPtr,A_PtrToGR,A_ArgReg1,A_ArgReg2)
{
  s_AllocShortGoalRecord(A_PtrToGR);
  s_PutEnvRecGoalRecord(A_PtrToGR,A_EnvRecPtr);
        /* $B%W%i%$%*%j%F%#HO0O$r1[$($k$3$H$,$"$k$3$H$KCm0U$;$h(B!! */
  s_PutProcessorIdGoalRecord(A_PtrToGR, D_PE_Number);
  s_PutNextGoalRecord(A_PtrToGR, D_EOL);
  s_PutFosterparentGoalRecord(A_PtrToGR, A_PtrToFP);
  s_IncrementFPChildCount(A_PtrToFP);
  s_PutImmArityGoalRecord(A_PtrToGR, _TWO);
  f_PutDcodeAddress(A_PtrToGR, DCODE_UNIFY_RETRY);
  f_Put2ArgsGoalRecord(A_PtrToGR,A_ArgReg1,A_ArgReg2);
  $RETURN();
}

/******************************************************************** PSL **
f_MakeUnifier_Wait1stArg_Sub
       written by imai@icot22      on Fri Sep 14 09:58:14 1990
<Arguments>
 A_PtrToUnifierGR: $B%f%K%U%!%$%d$N%4!<%k%l%3!<%I$X$N%]%$%s%?(B (DST)
 A_ArgReg1: $BBh#10z?t$X$N%]%$%s%?(B
 A_ArgReg2: $BBh#20z?t$X$N%]%$%s%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
 $BBh#10z?t$r(BRead$B$7$F!"$=$N8e$K%"%/%F%#%V%f%K%U%!%$$9$k(BD$B%3!<%I(B
       dcode_unify_retry_wait_1st_arg(X,Y):-wait(X)|X=Y.
 $B$r<B9T$9$k%4!<%k$r:n$k!#(B
 $B$3$3$G$O(B  $BBh#10z?t(B: $B30It;2>H%;%k!J$X$N%]%$%s%?!K(B 
           $BBh#20z?t(B: MGHOK$B%;%k$X$N%]%$%s%?(B 
 $B$H$J$C$F$$$k!#(B
<Examples>
  EXREF $B$H(B MGHOK $B$N%f%K%U%!%$$r9T$J$&;~$KMQ$$$i$l$k!#(B
	$BBh#10z?t$,(B  REF --> EXREF
	$BBh#20z?t$,(B  REF --> MGHOK
  $B$H$J$k!#(B

  EXREF $B$KBP$7$F(B %read $B%a%C%;!<%8$rAw$j!"(B%answer_value $B$,5"$C$F$/$k$^$G(B
  $B$3$N%f%K%U%!%$%d$r%5%9%Z%s%I$7$F$*$/(B
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#SUBARG_define A_PtrToUnifierGR DST
#SUBARG_define A_ArgReg1	SRC
#SUBARG_define A_ArgReg2	SRC

#SUBROUTINE f_MakeUnifier_Wait1stArg_Sub(A_PtrToUnifierGR,A_ArgReg1,A_ArgReg2)
{
  $CALL( f_Make_DcodeGoalRecord_Sub(A_PtrToUnifierGR) );
  s_PutImmArityGoalRecord(A_PtrToUnifierGR, _TWO);
  f_PutDcodeAddress(A_PtrToUnifierGR, DCODE_UNIFY_RETRY_WAIT_1ST_ARG);

  s_MRBonReg(A_ArgReg1);
    /* $B30It;2>H%;%k$X$N%Q%9$,J#?t$H$J$k$3$H$,$"$k$?$a(B */
  f_Put2ArgsGoalRecord(A_PtrToUnifierGR,A_ArgReg1,A_ArgReg2);
  $RETURN();
}

/******************************************************************** PSL **
  f_MakeConnectionPath
       written by imai@icot22      on Mon Nov 26 12:09:17 1990
<Arguments>
 ptr_reg1:	$B%f%K%U%!%$BP>]$NBh#10z?t$X$N%]%$%s%?(B
 ptr_reg2:	$B%f%K%U%!%$BP>]$NBh#20z?t$X$N%]%$%s%?(B
 object_reg1:	$B%f%K%U%!%$BP>]$NBh#10z?t$rA0$b$C$FFI$_=P$7$?CM(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
	$BBh#10z?t$+$iBh#20z?t$K8~$1$?%Q%9$rD%$k(B
  $B$9$J$o$A!"(Bptr_reg1 $B$N;X$7$F$$$k@h$r(B ptr_reg2 $B$K=q$-49$($k$,!"(B
  Compare&Swap$B$K<:GT$7$?;~$O!"(BUnify $B$r9T$J$&(B D-Code $B%4!<%k$G:F;n9T$9$k(B
<Examples>
<Test>
<Explanation>
  $B%f%K%U%#%1!<%7%g%s0lHL$GMQ$$$i$l$k!#(B
<ETC>
********************************************************************* PSL **/


#PSL_define f_MakeConnectionPath(ptr_reg1,object_reg1,ptr_reg2)
{
  b_IfNotEqual(ptr_reg1,ptr_reg2) {
    f_IfFailActUnifyWithPtrMRBX(ptr_reg1, object_reg1, ptr_reg2 ){
      $CALL( f_UnifyRetryByDcode_Sub(ptr_reg1, ptr_reg2) );
    }
  }
}

#PSL_define f_MakeConnectionPathWithoutCompare
	(ptr_reg1,object_reg1,ptr_reg2)
{
  f_IfFailActUnifyWithPtrMRBX(ptr_reg1, object_reg1, ptr_reg2 ){
    $CALL( f_UnifyRetryByDcode_Sub(ptr_reg1, ptr_reg2) );
  }
}

/******************************************************************** PSL **
$BGr%Q%9$N(BVOID $B$N%"%/%F%#%V%f%K%U%#%1!<%7%g%s(B

f_Unify_VOID

       written by ttakagi@icot22      on Thu Mar  7 15:20:58 1991

<Arguments>
  ptr_to_void: $BGr%Q%9$N(BVOID $B%;%k$X$N%]%$%s%?(B (REF) ----> VOID
  arg:         VOID$B$H%f%K%U%!%$$9$Y$-Aj<j(B (Deref$B:Q$_$+$I$&$+$OITDj(B)

<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  $BGr%Q%9$G;X$5$l$F$$$k(BVOID$BJQ?t$H$b$&0l$D$N0z?t$H$N%f%K%U%#%1!<%7%g%s$G$O(B,
  VOID$BJQ?t$X$N;2>H%Q%9$,M#0l$G$"$k$?$a(B, $B%f%K%U%#%1!<%7%g%sA`:n$N4V$KJL$N;2>H(B
  $B%Q%9$+$i(BVOID$BJQ?t$,%"%/%;%9$5$l$k$3$H$O$"$jF@$J$$!#(B

  $BK\%5%V%k!<%A%s$G$O(B, A_PtrToVOID $B;X$9(BVOID $BJQ?t$r(B, i_KlbUnifyBound_Sub
  $B$K$*$1$k6qBN2=:Q$_$NCM$HF1MM$N07$$$r$7$F(B, $B%f%K%U%#%1!<%7%g%sA`:n$r(B
  $B$^$H$a$?$b$N$G$"$k!#(B
<ETC>
  VOID $B$H(B NO_UNDEF $B$N%f%K%U%!%$$K$*$$$F$O(B Source$B>e$K(BVOID$B$,>h$C$?$^$^$K$J$k$3$H(B
  $B$,:_$j$^$9!#(B(???)

********************************************************************* PSL **/

#PSL_define f_Unify_VOID (ptr_to_void, arg)
{
  @DEBUG{ /* ptr_to_void $BB&$,(B REFo -> VOID $B$+$I$&$+$N%A%'%C%/(B */
    s_IfMRBon(ptr_to_void) {
      VPIM_ERROR("f_Unify_VOID","MRB_ON(ptr_to_void)_is_not_VOID");
    }
    $USE(D_WorkDrfPtr);
    p_Read(ptr_to_void, D_WorkDrfPtr);
    s_IfNotVOID(D_WorkDrfPtr){
      VPIM_ERROR("f_Unify_VOID","ptr_to_void_is_not_VOID");
    }
    $RELEASE(D_WorkDrfPtr);
    s_IfArgTypeErr(arg) {
      VPIM_ERROR("f_Unify_VOID","Illegal argument type");
    }
  };
  /*==== VOID $B%;%k$O!"L5>r7o$K2s<}$7$FNI$$(B =====*/
  s_ReclaimVariable(ptr_to_void); 
  s_IfMRBoff(arg) {
    $USE(D_WorkCollectValueCaller);
    b_SetImmValueDNTC
             (_COLLECT_VALUE_FROM_UNIFY_VOID, D_WorkCollectValueCaller);
    $CALL( f_CollectValue_Sub(arg,D_WorkCollectValueCaller) );
    $RELEASE(D_WorkCollectValueCaller);
  }
}

/******************************************************************** PSL **
$B9=B$BNF1;N$N%f%K%U%!%$(B

       written by ttakagi@icot22      on Thu Mar  7 15:27:14 1991

f_Unify_List_List
f_Unify_Vect_Vect	$B$O!"9=B$BN$N(Bunification$B$N$?$a$N(Bdcode$B8F$S=P$7(B

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  $BL$Dj5AJQ?t$N6qBN2=$KH<$&(B RETRY $BA`:n(B
  $B!&%3%s%Z%"%9%o%C%W$NHf3SA`:n$,<:GT$7$?;~$K(B, $B$=$N0z?tF1;N$N%f%K%U%!%$$r9T$&(B
    Dcode $B%4!<%k$r@8@.$9$k!#(B (see f_UnifyRetryByDcode)

  	  f_ActiveDeref (data,ptr);
          TypeSwitch (data) {
	    ......
	    case UNDF:
	      f_IfSuccessActUnifyWithPtrMRBX (ptr, data, new) {
		....
	      } else {
		p_MoveWord (ptr, data);
		f_UnifyRetryByDcode (data, new);
	      }
	    ......
	  }

  $B!&$?$@$7(B, $B<B:]$NF0$-$H$7$F$O(B, Unify$BL?Na<B9TA0$N>uBV$O(B, $B$[$H$s$I$N>l9g(B,
	<register>	<memory>
  	   REFo ------> UNDF/HOOK
  	   REFx ------> UNDF/HOOK
    $B$G$"$k$HM=A[$5$l$k!#(B
    $B$3$N$?$a(B,  $B<B5!MQ$N%3!<%G%#%s%0$G$O(B, $B:G=i$N(B f_ActiveDeref$B$rE83+$7(B,
    $B>e5-$N>l9g$r%a%$%s%Q%9$H$7$?J}$,NI$$!#(B
<ETC>
********************************************************************* PSL **/

#PSL_define f_Unify_List_List (arg_reg1, arg_reg2)
{
  @DEBUG { 
    s_IfNotLIST(arg_reg1){
      VPIM_ERROR("f_Unify_List_List","Illegal Type : arg_reg1");
    }
    s_IfNotLIST(arg_reg2){
      VPIM_ERROR("f_Unify_List_List","Illegal Type : arg_reg2");
    }
  };
  f_DcodeEnqueue2OpeWithoutParentInfo_II(DCODE_LIST_UNIFIER,arg_reg1,arg_reg2);
}

#PSL_define f_Unify_Vect_Vect (arg_reg1, arg_reg2)
{
  @DEBUG{
    s_IfNotVectors(arg_reg1){
      VPIM_ERROR("f_Unify_Vect_Vect","Illegal Type: arg_reg1");
    }
    s_IfNotVectors(arg_reg2){
      VPIM_ERROR("f_Unify_Vect_Vect","Illegal Type: arg_reg2");
    }
  };

  $USE(D_WorkS1);
  $USE(D_WorkS2);
  s_GetSizeVectType(arg_reg1, D_WorkS1);
  s_GetSizeVectType(arg_reg2, D_WorkS2);
  p_Compare(D_WorkS1,D_WorkS2);
  $RELEASE(D_WorkS2);
  p_IfEQ() {
    f_DcodeEnqueue3OpeWithoutParentInfo_III
                      (DCODE_VECT_UNIFIER, D_WorkS1, arg_reg1, arg_reg2);
    $RELEASE(D_WorkS1);
  } else {
    $RELEASE(D_WorkS1);
    $CALL( f_FailActiveUnify_Sub(arg_reg1, arg_reg2) );
  }
}

/******************************************************************** PSL **
Hook$BF1;N$N(BGeneral Unify

       written by ttakagi@icot22      on Thu Mar  7 15:31:53 1991

<Arguments>
  ptr1 :  $B%a%b%jCf$K$"$k(BHOOK ($B$H;W$o$l$k(B) $B%;%k$X$N%]%$%s%?(B--> $B6qBN2=$5$l$k(B
  hook1 : $BA0$KFI$_=P$7$?(B ptr1 $B$N@h$NCM(B ($BDL>o(B $B%4!<%k0z?t%l%8%9%?(B)
  ptr2 :  $B%a%b%jCf$K$"$k(BHOOK ($B$H;W$o$l$k(B) $B%;%k$X$N%]%$%s%?(B
  hook2 : $BA0$KFI$_=P$7$?(B ptr2 $B$N@h$NCM(B ($BDL>o(B $B%4!<%k0z?t%l%8%9%?(B)

<PreCondition>
<Function>
  f_IfSuccessActUnifyWithPtrMRBX$B$NCf$G!"(Bptr1 $B$N@h$,(B hook1$B$G$"$k$N$rD4$Y$F!"(B
  $B$b$7$=$&$J$i(B(compare swap$B$G(B) ptr1 $B$N@h$r(Bptr2 $B$H$7$F!"(B
  i_ConnectHookLink_Sub $B$r8F$S=P$9!#(B
  compare swap $B$K<:GT$7$?$i(B, ptr1 $B$H(B ptr2 $B$r$=$l$>$l(B hook1, hook2 $B$K(B
  $B%3%T!<$7$F!"$=$l$i$r0z?t$H$9$k(BDcode$B%4!<%k$r%U%)!<%/$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define f_ConnectHookLink (ptr1, hook1, ptr2, hook2)
{
  s_IfMRBoff(hook1) {
    s_IfMRBoff(hook2) {
      s_IfMRBoff(ptr1) {
	s_IfMRBoff(ptr2) {
	  s_IfSingleHookGrp(hook1) {
	    s_IfSingleHookGrp(hook2) {
	      $USE(D_WorkDeadlockType);
	      $USE(D_WorkCollectorInfo);
	      $USE(D_WorkCollectorInfo2);
	      b_SetImmTypeValueMRBoff
		(INT, _DEADLOCK_BY_HOOK_HOOK_UNIFY, D_WorkDeadlockType);
	      $CALL( f_MakePredicateInfo_NotCurrentGoal_Sub
		           (hook2, D_WorkCollectorInfo) );
	      $CALL( f_MakePredicateInfo_NotCurrentGoal_Sub
		           (hook1, D_WorkCollectorInfo2) );
	      /*--  (1) ptr2 $B$N@h$r(B UNDF $B$KD>$9(B --*/
	      /*--- (2) $B%f%K%U%!%$$9$k(B (ptr1 $B$N@h$r(B REF!ptr2 $B$K$9$k(B) --*/
	      /*-- $BB>$K%Q%9$O$J$$$N$G!"GSB>@)8f$OITMW$G$"$k(B ---*/
	      b_WriteImmTagWithOffset(_MRB_OFF, UNDF, D_NULL, ptr2, _ZERO);
	      b_WriteImmTagWithOffset(_MRB_OFF, REF,  ptr2,   ptr1, _ZERO);
	      /*--- hook1 $B$,1J5WCfCG$7$?$N$O(B hook2 $B$N$;$$$@(B ---*/
	      $CALL( f_PerpetualSuspensionException_Sub
		       (hook1, D_WorkDeadlockType, D_WorkCollectorInfo) );
	      /*--- hook2 $B$,1J5WCfCG$7$?$N$O(B hook1 $B$N$;$$$@(B ---*/
	      $CALL( f_PerpetualSuspensionException_Sub
		       (hook2, D_WorkDeadlockType, D_WorkCollectorInfo2) );
	      $RELEASE(D_WorkCollectorInfo2);
	      $RELEASE(D_WorkCollectorInfo);
	      $RELEASE(D_WorkDeadlockType);
	      goto End;
	    }
	  }
	}
      }
    }
  }
  s_IfEHookGrp(hook1){
    f_IfSuccessActUnifyWithPtrMRBX (ptr2, hook2, ptr1) {
	/* 
	 * At this point, "hook2" holds the suspend goal link. 
	 * This will not be resumed by other processors.	    
         * Note: MRB of "hook2" shows the PATH-MRB.
	 */
      $CALL( f_ConnectHookLink_Sub (hook2, hook1, ptr1) );
      p_MoveWord (ptr1, hook1); /* ptr1 $B$OJQ2=$7$F$$$k2DG=@-$,$"$k$?$a(B */
    } else {
      p_MoveWord (ptr1, hook1);
      p_MoveWord (ptr2, hook2);
      $CALL( f_UnifyRetryByDcode_Sub (hook1, hook2));
    }
  } else {
    f_IfSuccessActUnifyWithPtrMRBX (ptr1, hook1, ptr2) {
        /* 
	 * At this point, "hook1" holds the suspend goal link. 
	 * This will not be resumed by other processors.	    
         * Note: MRB of "hook1" shows the PATH-MRB.
	 */
      $CALL( f_ConnectHookLink_Sub (hook1, hook2, ptr2) );
      p_MoveWord (ptr2, hook2); /* ptr2 $B$OJQ2=$7$F$$$k2DG=@-$,$"$k$?$a(B */
    } else {
      p_MoveWord (ptr1, hook1);
      p_MoveWord (ptr2, hook2);
      $CALL( f_UnifyRetryByDcode_Sub (hook1, hook2));
    }
  }
 End:;
}

/******************************************************************** PSL **
Hook $BF1;N$N%8%'%M%i%k%f%K%U%!%$$K$*$1$k%5%9%Z%s%I%j%s%/$N7k9g(B

       written by ttakagi@icot22      on Thu Mar  7 15:34:51 1991

<Arguments>
  D_WorkHook1 : $BJQ?t%;%k$+$i<h$j>e$2$?%5%9%Z%s%I%4!<%k$N%j%s%/(B
		($B%j%8%e!<%`$5$l$F$7$^$&$3$H$O$J$$(B)
		$B<B9T8e$O(B, $BO"7k$7$?%5%9%Z%s%I%4!<%k$N%j%s%/$N@hF,(B, $B$^$?$O(B,
  		EOL ($BESCf$G%j%8%e!<%`$7$F$7$^$C$?>l9g(B) $B$H$J$k(B.
  D_WorkHook2 : $B%a%b%jCf$K;D$C$F$$$k%5%9%Z%s%I%4!<%k$N%j%s%/(B
		($B%j%8%e!<%`$5$l$F$7$^$C$?$j(B, $B%j%s%/$,?-$S$F$$$k2DG=@-$"$j(B)
  D_WorkHookPtr2 : $B%a%b%jCf$K;D$C$F$$$k%5%9%Z%s%I%4!<%k$N%j%s%/$X$N%]%$%s%?(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#SUBARG_define	A_Hook1		MODIFY
#SUBARG_define	A_Hook2		MODIFY
#SUBARG_define	A_HookPtr2	MODIFY

#DATA_define D_WorkSusEndPtr	XXX

#SUBROUTINE f_ConnectHookLink_Sub(A_Hook1, A_Hook2, A_HookPtr2)
{
  $USE(D_WorkSusEndPtr);
  f_ReadHookEnd (A_Hook1, D_WorkSusEndPtr);
	/* 
	 * D_WorkSusEndPtr holds a pointer to the last suspendrecord
	 * (pointed by MHOOK) or goalrecord (pointed by HOOK).
	 *
	 * A_Hook2 also holds the suspend goal link, however, its
	 * link might already been resumed by other processor, or
	 * another goal record is linked to the variable cell that 
	 * A_HookPtr2 points to.
	 * But, two suspend goal links are concatenated here.
         * Note: MRB of A_Hook2 shows the PATH-MRB.
	 */

  TypeSwitch(D_WorkSusEndPtr){
    case HOOK:
    case EHOOK:  /* A_Hook1$B$,(BEHOOK$B$G#1$D$7$+%4!<%k$,7R$,$C$F$$$J$$>l9g(B */
      TypeSwitch(A_Hook2){
        case HOOK:
	case MHOOK:
	case RHOOK:
   	  s_PutNextGoalRecord (D_WorkSusEndPtr, A_Hook2);
	  break;
	case EHOOK:
	/* Goal Record$B$d(BSus.Rec.$B$N(BNext-Link$BItJ,$K(BEHOOK$B7O%?%0$rF~$l$J$$$?$a(B */
	  f_SetTypeAndNextLinkGoalRecord(EHOOK,HOOK,A_Hook2, D_WorkSusEndPtr);
	  break;
	case EMHOK:
	  f_SetTypeAndNextLinkGoalRecord(EMHOK,MHOOK,A_Hook2, D_WorkSusEndPtr);
	  break;
	default:
	  @DEBUG{VPIM_ERROR("i_ConnectHookLink_Sub","Illegal_type_A_Hook2");} ;
	  break;
	}
      break;
    case MHOOK:
    case EMHOK:  /* A_Hook1$B$,(BEMHOK$B$G#1$D$7$+%4!<%k$,7R$,$C$F$$$J$$>l9g(B */
      TypeSwitch(A_Hook2){
        case HOOK:
	case MHOOK:
	case RHOOK:
   	  s_PutNextPtrSuspendRecord (D_WorkSusEndPtr, A_Hook2);
	  break;
	case EHOOK:
       /*--- $B%4!<%k%l%3!<%IEy$N(BNext-Link$BItJ,$K(BEHOOK$B7O%?%0$rF~$l$J$$$?$a(B ---- */
	  f_SetTypeAndNextLinkSuspendRecord(EHOOK,HOOK,A_Hook2, D_WorkSusEndPtr);
	  break;
	case EMHOK:
	  f_SetTypeAndNextLinkSuspendRecord(EMHOK,MHOOK,A_Hook2, D_WorkSusEndPtr);
	  break;
	default:
	  @DEBUG{VPIM_ERROR("f_ConnectHookLink_Sub","Illegal_type_A_Hook2");} ;
	  break;
	}
      break;
    case RHOOK:
      TypeSwitch(A_Hook2){
        case HOOK:
	case MHOOK:
	case RHOOK:
   	  s_PutNextLinkReplyRec(D_WorkSusEndPtr, A_Hook2);
	  break;
	case EHOOK:
       /*--- $B%4!<%k%l%3!<%IEy$N(BNext-Link$BItJ,$K(BEHOOK$B7O%?%0$rF~$l$J$$$?$a(B ---- */
	  f_SetTypeAndNextLinkReplyRecord(HOOK,A_Hook2, D_WorkSusEndPtr);
	  break;
	case EMHOK:
	  f_SetTypeAndNextLinkReplyRecord(MHOOK,A_Hook2, D_WorkSusEndPtr);
	  break;
	default:
	  @DEBUG{VPIM_ERROR("f_ConnectHookLink_Sub","Illegal_type_A_Hook2");} ;
	  break;
	}
      break;

    default: /* Including EHOOK and EMHOK */
      @DEBUG{VPIM_ERROR("f_ConnectHookLink_Sub","Illegal_type_HookEnd");} ;
      break;
    }
	/* Here, the suspend goal link is: ( O shows a suspended goal record.)
	 *
	 *	    D_WorkSusEndPtr  ---+    +---A_Hook2
	 *				|    |	
	 *				V    V	
	 *        A_Hook1  -->O--->O--->O--->O--->
	 *		         	     ^	
	 *				     |	
	 *				* A_HookPtr2 (HOOK/MHOOK)
	 *				       |
	 * D_WorkPtr1/2-> *D_WorkPtr1/2(REF) --+
	 */

  /* A_Hook1 $B$H!"(BA_Hook2 $B$N$&$A!"$$$:$l$+$,(B E$BIU$-%?%0$G$"$l$P!"(B
     $B?7$7$/=q$-9~$`(B A_Hook1 $B$N%?%$%W$r(B E$BIU$-%?%0$K$9$k(B --> $B%^%/%m$K$7$h$&!*(B*/

  TypeSwitch(A_Hook2) {
  case EHookGrp():
    TypeSwitch(A_Hook1) {
    case HOOK:  p_SetImmediateType(EHOOK,A_Hook1); break;
    case MHOOK: p_SetImmediateType(EMHOK,A_Hook1); break;
    default: /* Including case EHookGrp():  Nothing To Do */ break;
    }
  default:;
  }

  f_IfFailHookGoalX(A_HookPtr2, A_Hook2, A_Hook1) {
    /* $B$D$J$2$F$_$?$i!"$=$N4V$K(BA_Hook2$B$N@h$,=q$-49$o$C$F$$$?(B */
    TypeSwitch(D_WorkSusEndPtr){
    case HOOK:				/* A_Hook2$B0J2<$r@Z$jN%$9(B	*/
    case EHOOK:
    case RHOOK:
      s_PutNextEOLGoalRecord (D_WorkSusEndPtr);
      break;
    case MHOOK:				/* A_Hook2$B0J2<$r@Z$jN%$9(B	*/
    case EMHOK:
      s_PutNextEOLSuspendRecord (D_WorkSusEndPtr);
      break;
    default:
      @DEBUG{ VPIM_ERROR("f_ConnectHookLink_Sub","Illegal Type!!");};
    }
    @DEBUG{ WARNING("f_ConnectHookLink_Sub","Hook2 is modified!! Resume Hook1 link!"); };
	/* Hook1 $B$+$i$D$J$,$C$F$$$k%4!<%k$r(B resume $B$9$k(B */
    $CALL( f_WakeUpProcess_Sub( A_Hook1) );
	/* $B<B9T8e$O(B A_Hook1 == EOL $B$H$J$C$F$$$k(B */
  }
  $RELEASE(D_WorkSusEndPtr);
	/* When success :
	 *
	 *	    D_WorkSusEndPtr  ---+    +---A_Hook2
	 *				|    |	
	 *				V    V	
	 *       A_Hook1   -->O--->O--->O--->O--->
	 *		      ^	
	 *		      |	
	 *		      +-------- * A_HookPtr2 (HOOK/MHOOK)
	 *				     |
	 * D_WorkPtr1 --> *D_WorkPtr1(REF) --+
	 */
  $RETURN ();
}

/******************************************************************** PSL **
  $B30It;2>H$H!"$=$NB>$N%?%$%W$N%f%K%U%#%1!<%7%g%s(B

       written by imai@icot22      on Mon Nov 26 14:06:29 1990

<Arguments>
 ptr_to_ex: $B30It;2>H%;%k$X$N%]%$%s%?$rJ];}$7$?%l%8%9%?(B (REF)
 excell_object: $B30It;2>H%;%k$NFbMF$rA0$b$C$FFI$_=P$7$?%l%8%9%?(B (WEX or BEX)
 ptr_to_arg: 
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  EX$B%;%k$r%=%U%H%m%C%/$G$-$?$i(B %unify $B%a%C%;!<%8$rAw?.$9$k(B
  $B%=%U%H%m%C%/$K<:GT$7$?>l9g$O!"(BD-Code $B%4!<%k$G:F;n9T$9$k(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define f_Unify_EX_General(ptr_to_ex,excell_object,ptr_to_arg)
{
  @DEBUG{ s_IfNotExternal(excell_object) {
    VPIM_ERROR("f_Unify_EX_General","Illegal Invoke");
  }};

  s_IfSuccessSoftLockExCell(ptr_to_ex, excell_object) {
    $CALL( f_Send_IntClMsg_Unify_Sub(ptr_to_ex,excell_object, ptr_to_arg) );
    /* ptr_to_ex $B$N@h$O%5%V%k!<%A%sFbIt$G%"%s%m%C%/(B */
  } else {
    $CALL( f_UnifyRetryByDcode_Sub(ptr_to_ex,ptr_to_arg) );
  }
}

#PSL_define f_Unify_EX_Eundf(ptr_to_ex,excell_object,ptr_to_arg)
{
  @DEBUG{ s_IfNotExternal(excell_object) {
    VPIM_ERROR("f_Unify_EX_Eundf","Illegal Invoke");
  }};

  s_IfSuccessSoftLockExCell(ptr_to_ex, excell_object) {
    $CALL( f_Send_IntClMsg_Unify_EX_Eundf_Sub
	  (ptr_to_ex, excell_object, ptr_to_arg));
    /* ptr_to_ex $B$N@h$O%5%V%k!<%A%sFbIt$G%"%s%m%C%/(B */
  } else {
    $CALL( f_UnifyRetryByDcode_Sub(ptr_to_ex,ptr_to_arg) );
  }
}

#PSL_define f_Unify_EX_Bounded(ptr_to_ex,excell_object,bounded_reg)
{
  @DEBUG{ s_IfNotExternal(excell_object) {
    VPIM_ERROR("f_Unify_EX_Bounded","Illegal Invoke");
  }};
  s_IfSuccessSoftLockExCell(ptr_to_ex, excell_object) {
	/*
	 * excell_object = *ptr_to_ex = WEXVAL/REF or BEXVAL/REF or RDHOK,
	 * bounded_reg == Bounded $B$NH&(B
	 * s_IfSuccessSoftLockExCell$B$NCf$G%m%C%/$r$+$1$F$$$k$N$G!"(Bswitch
	 * $B$+$i(Bcase$B$N4V$G(BRDHOK$B$,=q$-BX$o$C$F$$$F$b:#$N$^$^$G(BOK$B$NH&(B
	 */
    $CALL(f_Send_IntClMsg_Unify_EX_Bounded_Sub
	  (ptr_to_ex, excell_object, bounded_reg) );
	/* ptr_to_ex $B$N@h$O%5%V%k!<%A%sFbIt$G%"%s%m%C%/(B */
  } else {
    $CALL( f_UnifyRetryByDcode_Sub(ptr_to_ex,bounded_reg ) );
  }
  p_MoveWord(ptr_to_ex, excell_object);
}
