
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_int_cl_send_unify.psl.c
   ----- CREATED   : by ttakagi@icot22, on Fri Jun  8 13:29:55 1990
   ----- LAST SAVED: by ttakagi@icot22, on Fri Jun 12 15:14:35 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : 

<Message Format in VPIM>
      39       31                              0
       +---------------------------------------+
    0  | DNTC   !  $B%a%C%;!<%8<oJL(B(_NW_UNIFY)   |
       +---------------------------------------+
    1  | DNTC   !  $BAq1`#I#D(B                    |
       +---------------------------------------+
    2  | DNTC   !  $B#W#T#C(B                      |
       +---------------------------------------+
    3  | DNTC   !  $B%+%l%s%H%W%i%$%*%j%F%#(B      |
       +---------------------------------------+
    4  | D_ONE or D_NULL !  Profiling flag     |
       +---------------------------------------+ \
    5  | DNTC   !  $B:G>.%N!<%IHV9f(B              |
       +---------------------------------------+   $B6u4V>pJs(B
    6  | DNTC   !  $B%N!<%I?t(B                    |
       +---------------------------------------+ /
       |        !  $BBh#10z?t(B                    |
       /                                       /
       +---------------------------------------+
       |        !  $BBh#20z?t(B                    |
       /                                       /
       +---------------------------------------+
       |        !  End of Message              |
       +---------------------------------------+

  %unify$B$r=P$9A0$N#W#E#C%A%'%C%/(B

  s_GetExrefIdAndWtcBImpRec_Sub
 

 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
1. $B%/%i%9%?4V%f%K%U%!%$;~$N%a%C%;!<%8Aw?.=hM}(B

(SUBROUTINE) f_Send_IntClMsg_Unify_Sub

       written by ttakagi@icot22      on Fri Jun  8 13:39:39 1990

<Arguments>
  A_PtrToExCell: $B%"%/%F%#%V%f%K%U%#%1!<%7%g%s$NBh#10z$-?t(B
                   $B%=%U%H%m%C%/:Q$_$N30It;2>H%;%k$X$N%]%$%s%?(B
  A_ExCell:      A_PtrToExCell $B$,;X$7$F$$$?30It;2>H%;%k$NCf?H(B
  A_Arg2:        $B%"%/%F%#%V%f%K%U%#%1!<%7%g%s$NBh#20z$-?t(B
                   $BDj?t(B, $B9=B$BN(B, $B30It;2>H%;%k$r4^$`L$Dj5AJQ?t$X$N%]%$%s%?(B

<Temporally Used Variables>
<Level>
<PreCondition>
  $B!&(BA_PtrToExCell$B$N@h$N30It;2>H%;%k$O4{$K%G%l%U(B/$B%m%C%/:Q$_(B (EXLOCK)
  $B!&(BA_ExCell$B$O(BA_PtrToExCell$B$N@h$N30It;2>H%;%k$NCf?H(B(EXREF$BKt$O(BEXVAL)
  $B!&(BA_Arg2$B$O2?$r;X$7$F$$$k$+J,$+$i$J$$!#(B

                            +----------+
                            | A_ExCell |--+
                            +----------+  |
       +-------------+      +----------+  |   +-----------+
       |A_PtrToExCell|----->| EXLOCK   |----->| ImpRec    |
       +-------------+      +----------+      /           /
                                              |           |
                                              +-----------+
       +-------------+
       | A_Arg2      |-----> $B$J$s$G$b(B
       +-------------+

<Function>
  $B!&(BA_Arg2$B$N@h$r%G%l%U$7$F!"0J2<$N%?%$%WH=Dj$K$h$j%f%K%U%!%$$r9T$&!#(B
   (1) UNDF, HOOK$B7O(B
       A_Arg2$B$,;X$7$F$$$kJQ?t%;%k$+$i(BA_PtrToExCell$B$N@h$X$N%Q%9$rD%$k!#(B
       HOOK$B7O$N>l9g(B, $B%U%C%/$5$l$F$$$?%4!<%k$r%j%8%e!<%`$9$k(B.
       HOOK$B7O$N>l9g$=$N$^$^(BEX$B%;%k$N@h$K(B%read$B$r=P$7$F$bNI$$$,!":GE,2=$J$N$G(B
       $B$3$3$G$O9T$C$F$$$J$$!#(B
   (2) EUNDF, EHOOK$B7O(B
       safe/unsafe$B$NH=Dj$r$7$?8e$K!"%Q%9$rD%$k$+(B%unify$B$rAw$k$+7h$a$k!#(B
       HOOK$B7O$N>l9g$=$N$^$^(BEX$B%;%k$N@h$K(B%read$B$r=P$7$F$bNI$$$,!":GE,2=$J$N$G(B
       $B$3$3$G$O9T$C$F$$$J$$!#(B
   (3) EXREF, EXVAL$B7O(B
       %unify$B$r=P$9!#(BA_PtrToExCell$B$N30It;2>H%;%k$NJ}8~$K=P$9$+(B, A_Arg2$B$N(B
       $B30It;2>H%;%k$NJ}8~$K=P$9$+$O!"$=$N;~$N>u67$K$h$k!#(B
       "f_Send_IntClMsg_Unify_EX_EX_Sub"$B$r;2>H$N$3$H!#(B
   (4) $B$=$l0J30(B
       A_PtrToExCell$B$N@h$N30It;2>H%;%kJ}8~$K(B%unify$B$r=P$9!#(B

<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define	D_WorkUnifyArg1	XXX
#DATA_define	D_WorkUnifyArg2	XXX

#SUBARG_define  A_PtrToExCell   MODIFY
#SUBARG_define  A_ExCell        SRC
#SUBARG_define  A_Arg2          MODIFY

#SUBROUTINE f_Send_IntClMsg_Unify_Sub(A_PtrToExCell, A_ExCell, A_Arg2)
{
  @EXLOCK_CHECK{
    $USE(D_WorkEx);
    p_Read(A_PtrToExCell, D_WorkEx);
    s_IfNotEXLOCK(D_WorkEx) {
      VPIM_ERROR("f_Send_IntClMsg_Unify_Sub",
		 "*A_PtrToExCell is not yet ExLocked");
    }
    $RELEASE(D_WorkEx);
  };

  $USE(D_WorkUnifyArg2);
Retry_Label:
  f_ActiveDeref(A_Arg2, D_WorkUnifyArg2);
  TypeSwitch(A_Arg2){
    case VOID:
      s_IfMRBoff(A_Arg2){
	s_SoftUnlockExCell(A_PtrToExCell, A_ExCell);
	@DEBUG{ WARNING("f_Send_IntClMsg_Unify_Sub","VOIDo<->EX unify"); };
     	f_Unify_VOID(D_WorkUnifyArg2, A_PtrToExCell); 
	break;
      }
      /* s_IfMRBon(A_Arg2)$B$O!"(BUNDF$B$HF1$8(B */
    case UNDF:
    case HookGrp():  /* HOOK MHOOK */
      $USE(D_WorkPtrToExCell);
      p_MoveWord(A_PtrToExCell, D_WorkPtrToExCell);
      f_IfSuccessActUnifyWithPtrMRBX
	          (D_WorkUnifyArg2, A_Arg2, D_WorkPtrToExCell) {
	$RELEASE(D_WorkPtrToExCell);
	s_SoftUnlockExCell(A_PtrToExCell, A_ExCell);
	s_IfHookGrp(A_Arg2) {
	  $CALL( f_WakeUpProcess_Sub(A_Arg2) ); /* A_Arg2$B$N@h$N%4!<%k$,5/$-$?8e(B
	                                           A_ExCell$B$N@h$K(B%Read$B$,=P$k(B */
	}
	break;
      } else {
        $RELEASE(D_WorkPtrToExCell);
        p_MoveWord(D_WorkUnifyArg2, A_Arg2);
        goto Retry_Label;
      }
    case ExpVarGrp(): /* EUNDF EHOOK RHOOK EMHOK */
      $CALL( f_Send_IntClMsg_Unify_EX_Eundf_Sub
	                       (A_PtrToExCell, A_ExCell, D_WorkUnifyArg2) );
      break;
    case EX_Grp(): /* WEXREF/VAL BEXREF/VAL RDHOK */
      s_IfSuccessSoftLockExCell(D_WorkUnifyArg2, A_Arg2) {
	   /* %Unify$B$N0z?t#2$,(B $B!|(B -> WEXREF $B$H$J$C$?$H$-$N$?$a$N%A%'%C%/(B */
	f_IfIndirectExportData(A_PtrToExCell, A_ExCell){
	  $CALL( f_Send_IntClMsg_Unify_EX_EX_Sub
		(A_PtrToExCell, A_ExCell, D_WorkUnifyArg2, A_Arg2) );
	} else {
	  $CALL( f_Send_IntClMsg_Unify_EX_EX_Sub
		(D_WorkUnifyArg2, A_Arg2, A_PtrToExCell, A_ExCell) );
	}
        /* A_PtrToExCell, A_Arg2$B$N@h$O!"%5%V%k!<%A%sFb$G%=%U%H%"%s%m%C%/(B */
      } else {
        p_MoveWord(D_WorkUnifyArg2, A_Arg2);
        goto Retry_Label;
      }
      break;
    case AtomicGrp():
    case FloatingGrp(): 
    case StructureGroup():	/* EXREF$BEy$H6qBN2=$5$l$?%G!<%?$N%f%K%U%!%$(B */
    case CodeGrp():
      $CALL( f_Send_IntClMsg_Unify_EX_Bounded_Sub
	                     (A_PtrToExCell, A_ExCell, A_Arg2) );
      break;
    case StreamGrp():           /* EX <-> MGHOK$B$N%f%K%U%!%$(B */
      $CALL( f_Unify_MGHOK_EX_Sub
	             (D_WorkUnifyArg2,A_Arg2,A_PtrToExCell,A_ExCell) );
      break;
    case EXLOCK: /* $B%=%U%H%m%C%/$5$l$F$$$k;~$O!"(B Retry_by_Dcode */
      s_SoftUnlockExCell(A_PtrToExCell, A_ExCell);
      b_IfEqual(A_PtrToExCell, D_WorkUnifyArg2){
	@DEBUG{
	  WARNING("f_Send_IntClMsg_Unify_Sub","Unify Same address Ex - Ex");
	/*  preg(A_PtrToExCell); */
	};
      } else {
	$CALL( f_UnifyRetryByDcode_Sub (A_PtrToExCell, D_WorkUnifyArg2) );
      }
      break;
    default:
      @DEBUG{ VPIM_ERROR("f_Send_IntClMsg_Unify_Sub","Undefined type Arg2"); };
  }
  p_MoveWord(D_WorkUnifyArg2, A_Arg2);
  $RELEASE(D_WorkUnifyArg2);

  $RETURN();
}

/******************************************************************** PSL **
1.1 %unify$B%a%C%;!<%8Aw?.=hM}(B
   $B30It;2>H%;%k$H0lHL$N%G!<%?(B($BM"=P$7$?L$Dj5AJQ?t7O!"30It;2>H0J30(B)$B$H$N(B
   $B%f%K%U%#%1!<%7%g%s(B

f_Send_IntClMsg_Unify_EX_Bounded_Sub

       written by nakase@icot22      on Mon Jul 17 15:14:33 1989

<Arguments>
  A_PtrToExCell : $B%f%K%U%!%$$NBh#10z$-?t(B EXLOCK$B$5$l$?30It;2>H%;%k$X$N%]%$%s%?(B
  A_ExCell : $B%f%K%U%!%$$NBh#10z$-?t$H$J$k30It;2>H%;%k$N%3%T!<(B 
  A_Bounded : $B%f%K%U%!%$$NBh#20z$-?t(B (bounded value)

<Temporally Used Variables>
<Level>
<PreCondition>
  A_PtrToExCell $B$N@h$N30It;2>H%;%k$O(B, $B8F$S=P$7A0$K%m%C%/(B(EXLOCK$B:Q$_(B)
  ---> $B=hM}$NFbIt$G(B, $B%"%s%m%C%/$9$k(B. (??)
<Function>
<Examples>
<Test>
<Explanation>
  $B!&30It;2>H%;%k$N<($9%/%i%9%?$K(B Unify$B%a%C%;!<%8$rAw$k!#(B
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkPtrToImpRec XXX
#DATA_define D_WorkExRefID     XXX
#DATA_define D_WorkRecvCLNum   XXX

#CONST_define _UNIFY_WTC_UNIT 10  /* %unify$BAw?.;~$K$D$1$k#W#T#C(B */

/* for test of less WTC ( 92.04.29 REKI )
 * see also f_shoen_control.psl.c
 * #CONST_define _UNIFY_WTC_UNIT  4
 */

#SUBARG_define	A_PtrToExCell	SRC
#SUBARG_define	A_ExCell	SRC
#SUBARG_define	A_Bounded       MODIFY

#SUBROUTINE f_Send_IntClMsg_Unify_EX_Bounded_Sub
                                           (A_PtrToExCell, A_ExCell, A_Bounded)
{
  @EXLOCK_CHECK{
    $USE(D_WorkEx);
    p_Read(A_PtrToExCell, D_WorkEx);
    s_IfNotEXLOCK(D_WorkEx) {
      VPIM_ERROR("f_Send_IntClMsg_Unify_EX_Bounded_Sub",
		 "A_PtrToExCell is not yet ExLocked");
    }
    $RELEASE(D_WorkEx);
  };

  f_IfUnifySendableUnifyArg(A_PtrToExCell, A_ExCell) {
           /* $B0z?t#1$,Aw?.2DG=$J>l9g(B */
    s_RecordMsgEncodeStart(); /*** for Processor Profile ***/
    $USE(D_WorkRequestWTC);
    b_SetImmTypeValueMRBoff(INT, _UNIFY_WTC_UNIT, D_WorkRequestWTC);
    $USE(D_WorkAssignWTC);
    $USE(D_WorkLeftWTC);
    $USE(D_WorkShoenID);

    $USE(D_WorkImpRec);
    s_GetFPImportTableEntry(D_Current_FP_Ptr, D_WorkImpRec);
    $USE(D_WorkOrginalData);
    s_SoftLockBImpRec_FP(D_WorkImpRec, D_WorkOrginalData);

    /* $BM"F~I=%l%3!<%I$N%m%C%/$r30$K=P$7$^$7$?!#(B92.04.28 ttakagi
    f_Get_WTCandShoenID_fromFP(D_Current_FP_Ptr, D_WorkRequestWTC,
			       D_WorkAssignWTC, D_WorkLeftWTC, D_WorkShoenID);
    */

    $CALL( s_GetExrefIdAndWtcBImpRecWithoutLock_Sub
 	                (D_WorkImpRec, D_WorkRequestWTC, D_WorkShoenID,
			 D_WorkAssignWTC, D_WorkLeftWTC) );

    $RELEASE(D_WorkRequestWTC);

    b_IfGreaterEqImm(D_WorkLeftWTC, _WTC_RESERVED) { /* $B#W#T#C==J,$N>l9g(B */

      s_SoftUnlockBImpRec_FP(D_WorkImpRec, D_WorkOrginalData);
      $RELEASE(D_WorkOrginalData);  $RELEASE(D_WorkImpRec);

      $RELEASE(D_WorkLeftWTC);
      $USE(D_WorkRecvCLNum);
      f_Get_CLNum_fromExCell(A_ExCell, D_WorkRecvCLNum);
      $USE(D_WorkPtrToPacket);  $USE(D_WorkPacketSize);
      $CALL( f_MakeLogicalPacket_Unify_Sub
 	             (D_WorkPtrToPacket, D_WorkPacketSize, A_PtrToExCell,
		      A_ExCell, A_Bounded, D_WorkShoenID, D_WorkAssignWTC,
		      D_WorkRecvCLNum) );
      $RELEASE(D_WorkShoenID);
      b_IfNotIllegalPointer(D_WorkPtrToPacket) {
	$CALL( s_SendPacket_Sub
	      (D_WorkPtrToPacket, D_WorkPacketSize, D_WorkRecvCLNum) );
      } else {
	/* $B%a%b%jITB-$N;~$O!"(BRetry by D-code */
	@DEBUG{ WARNING("f_Send_IntClMsg_Unify_EX_Bounded_Sub",
			"%unify EX bounded suspend"); };
	/*** $B#W#T#C$NJV5Q(B ***/
	f_Return_WTC_toFP(D_Current_FP_Ptr, D_WorkAssignWTC);
	s_SoftUnlockExCell(A_PtrToExCell, A_ExCell);
        $CALL( f_UnifyRetryByDcode_Sub (A_PtrToExCell, A_Bounded) );
      }
      $RELEASE(D_WorkRecvCLNum);   $RELEASE(D_WorkPacketSize);
      $RELEASE(D_WorkPtrToPacket); $RELEASE(D_WorkAssignWTC);
    } else {
      @DEBUG{
	WARNING("f_Send_IntClMsg_Unify_EX_Bounded_Sub", "Suspended (WTC low)");
      };
      $RELEASE(D_WorkLeftWTC);
      /* %unify$B%a%C%;!<%8$N%5%9%Z%s%I(B */
      s_SoftUnlockExCell(A_PtrToExCell, A_ExCell);
      $CALL( f_UnifyMsgSusp_WaitingWTC_Sub(A_PtrToExCell, A_Bounded) );

      s_SoftUnlockBImpRec_FP(D_WorkImpRec, D_WorkOrginalData);
      $RELEASE(D_WorkOrginalData);  $RELEASE(D_WorkImpRec);

      b_IfNotZero(D_WorkAssignWTC) { /* $B#W#T#CMW5a%a%C%;!<%8$NAw?.(B */
	s_RecordMsgEncodeStop(); /*** for Processor Profile ***/
	$CALL(f_Send_IntClMsg_Request_WTC_Sub(D_WorkShoenID, D_WorkAssignWTC));
	s_RecordMsgEncodeStart(); /*** for Processor Profile ***/
      }
      $RELEASE(D_WorkAssignWTC);
      $RELEASE(D_WorkShoenID);
    }
    s_RecordMsgEncodeStop(); /*** for Processor Profile ***/
  } else {
           /* $B0z?t#1$K$D$$$F(BRequest_BEXID$B$r=P$5$M$P$J$i$J$$>l9g(B */ 
    $CALL( f_UnifyMsgSusp_WaitingWEC_Sub(A_PtrToExCell, A_ExCell, A_Bounded) );
  } /* end of  f_IfUnifySendableUnifyArg1(A_PtrToExCell, A_ExCell) */

  $RETURN();
}

/******************************************************************** PSL **
3. %unify$B%a%C%;!<%8Aw?.=hM}(B
   $B30It;2>H%;%k$H!"M"=P$7$?L$Dj5AJQ?t7O$H$N%f%K%U%#%1!<%7%g%s(B
   
f_Send_IntClMsg_Unify_EX_Eundf_Sub

       written by ttakagi@icot22      on Wed Jul  4 16:16:42 1990

<Arguments>
 A_PtrToExCell:
 A_ExCell:
 A_Eundf:

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkEundfCell XXX
#DATA_define D_WorkPtrToImpRecExEundf XXX
#DATA_define D_WorkExrefIDExEundf     XXX

#SUBARG_define	A_PtrToExCell	SRC
#SUBARG_define	A_ExCell	SRC
#SUBARG_define	A_Eundf         MODIFY

#SUBROUTINE f_Send_IntClMsg_Unify_EX_Eundf_Sub(A_PtrToExCell,A_ExCell,A_Eundf)
{
  @EXLOCK_CHECK{
    $USE(D_WorkEx);
    p_Read(A_PtrToExCell, D_WorkEx);
    s_IfNotEXLOCK(D_WorkEx) {
      VPIM_ERROR("f_Send_IntClMsg_Unify_EX_Eundf_Sub",
		 "*A_PtrToExCell is not yet ExLocked");
    }
    $RELEASE(D_WorkEx);
  };

  $USE(D_WorkPtrToImpRecExEundf);
  s_IfRDHOK(A_ExCell) { /* $BM"F~%l%3!<%I$X$N%]%$%s%?$rF@$k(B */
    s_GetPtrToImpRecRdhokRec(A_ExCell, D_WorkPtrToImpRecExEundf);
  } else {
    p_MoveWord(A_ExCell, D_WorkPtrToImpRecExEundf);
  }
  $USE(D_WorkExrefIDExEundf);
  TypeSwitch(D_WorkPtrToImpRecExEundf){
    case ExrefGrp():
      s_IfWEXT(D_WorkPtrToImpRecExEundf) {
	s_GetExrefIdWImpRec(D_WorkPtrToImpRecExEundf, D_WorkExrefIDExEundf);
      } else {
	s_GetExrefIdBImpRec(D_WorkPtrToImpRecExEundf, D_WorkExrefIDExEundf);
      }
      s_IfUnSafeExRef(D_WorkExrefIDExEundf) {
	$CALL( f_Send_IntClMsg_Unify_EX_Bounded_Sub
	                          (A_PtrToExCell, A_ExCell, A_Eundf) );
	$RELEASE(D_WorkExrefIDExEundf);
	$RELEASE(D_WorkPtrToImpRecExEundf);
	goto END_Label;
      }
      break;
    case ExvalGrp():
      @TRADE_PROBE{
	s_IfWEXT(D_WorkPtrToImpRecExEundf) {
	  s_GetExrefIdWImpRec(D_WorkPtrToImpRecExEundf, D_WorkExrefIDExEundf);
	} else {
	  s_GetExrefIdBImpRec(D_WorkPtrToImpRecExEundf, D_WorkExrefIDExEundf);
	}
      };
      break;
    case EOL:
      /* %Reqest_BEXID$B$rAw=PCf$N30It;2>H(BID$B$r$?$^$?$^$D$+$s$G$7$^$C$?;~!"(B
	$B$3$3$KE~Ce$9$k!#(B*/
      @DEBUG{
	s_IfNotRDHOK(A_ExCell) { 
	  VPIM_ERROR("f_Send_IntClMsg_Unify_EX_Eundf_Sub", "invalid rdhok");
	} 
	WARNING("f_Send_IntClMsg_Unify_EX_Eundf_Sub",
		"EX->EOLx Eunbound Unify");
      };
      s_SoftUnlockExCell(A_PtrToExCell, A_ExCell);
      $CALL( f_UnifyRetryByDcode_Sub(A_PtrToExCell, A_Eundf) );
      $RELEASE(D_WorkExrefIDExEundf);
      $RELEASE(D_WorkPtrToImpRecExEundf);
      goto END_Label;
    default:
      @DEBUG{VPIM_ERROR("f_Send_IntClMsg_Unify_EX_Eundf_Sub",
			"invalid exref/rdhok type");};
      break;
    }

  $RELEASE(D_WorkExrefIDExEundf);
  $RELEASE(D_WorkPtrToImpRecExEundf);

  $USE(D_WorkEundfCell);
  s_ReadWithMRBor(A_Eundf, D_WorkEundfCell);
  TypeSwitch(D_WorkEundfCell) {
   case ExpVarGrp():
     f_IfFailActUnifyWithPtrMRBX(A_Eundf, D_WorkEundfCell, A_PtrToExCell) {
       s_SoftUnlockExCell(A_PtrToExCell, A_ExCell);
       $CALL( f_UnifyRetryByDcode_Sub(A_PtrToExCell, A_Eundf) );
     } else {
       s_SoftUnlockExCell(A_PtrToExCell, A_ExCell);
       s_IfNotEUNDF(D_WorkEundfCell) {
         $CALL( f_WakeUpProcess_Sub(D_WorkEundfCell) );
       }
     }
     break;
   default:
     s_SoftUnlockExCell(A_PtrToExCell, A_ExCell);
     $CALL( f_UnifyRetryByDcode_Sub(A_PtrToExCell, A_Eundf) );
   }
   $RELEASE(D_WorkEundfCell);
 END_Label:

  $RETURN();
}

/******************************************************************** PSL **
4. %unify$B%a%C%;!<%8Aw?.=hM}(B
   $B30It;2>H%;%k$H30It;2>H%;%k$N%f%K%U%#%1!<%7%g%s(B

f_Send_IntClMsg_Unify_EX_EX_Sub

       written by ttakagi@icot22      on Tue Dec  5 15:53:19 1989

<Arguments>
  A_PtrToExCell1: $B%f%K%U%!%$$NBh(B1$B0z$-?t(B($B30It;2>H$X$N%]%$%s%?(B)
  A_ExCell1:      A_PtrToExCell1$B$,;X$7$F$$$?30It;2>H%;%k$NCf?H(B($B%m%C%/A0(B)
  A_PtrToExCell2: $B%f%K%U%!%$$NBh(B2$B0z$-?t(B($B30It;2>H$X$N%]%$%s%?(B)
  A_ExCell2:      A_PtrToExCell2$B$,;X$7$F$$$?30It;2>H%;%k$NCf?H(B($B%m%C%/A0(B)

<Temporally Used Variables>
<Level>

<PreCondition>
  A_PtrToExCell1$B$N@h$O%=%U%H%m%C%/:Q$_(B(EXLOCK)
  A_PtrToExCell2$B$N@h$O%=%U%H%m%C%/:Q$_(B(EXLOCK)

<Function>
<Examples>
<Test>
<Explanation>
<ETC>
  $BK\Ev$O$b$C$HJ#;($J:GE,2=$,F~$k(B
********************************************************************* PSL **/

#SUBARG_define	A_PtrToExCell1	SRC
#SUBARG_define  A_ExCell1	SRC
#SUBARG_define	A_PtrToExCell2	SRC
#SUBARG_define  A_ExCell2	SRC

#SUBROUTINE f_Send_IntClMsg_Unify_EX_EX_Sub
		         (A_PtrToExCell1, A_ExCell1, A_PtrToExCell2, A_ExCell2)
{
  @EXLOCK_CHECK{
    $USE(D_WorkEx);
    p_Read(A_PtrToExCell1, D_WorkEx);
    s_IfNotEXLOCK(D_WorkEx) {
      VPIM_ERROR("f_Send_IntClMsg_Unify_EX_EX_Sub",
		 "A_PtrToExCell1 is not yet ExLocked");
    }
    p_Read(A_PtrToExCell2, D_WorkEx);
    s_IfNotEXLOCK(D_WorkEx) {
      VPIM_ERROR("f_Send_IntClMsg_Unify_EX_EX_Sub",
		 "A_PtrToExCell2 is not yet ExLocked");
    }
    $RELEASE(D_WorkEx);
  };

  f_IfUnifySendableUnifyArg(A_PtrToExCell1, A_ExCell1) {
           /* $B0z?t#1$,Aw?.2DG=$J>l9g(B */
    f_IfUnifySendableUnifyArg(A_PtrToExCell2, A_ExCell2) {
           /* $B0z?t#2$,Aw?.2DG=$J>l9g(B */          
      s_RecordMsgEncodeStart(); /*** for Processor Profile ***/
      $USE(D_WorkRequestWTC);
      b_SetImmTypeValueMRBoff(INT, _UNIFY_WTC_UNIT, D_WorkRequestWTC);
      $USE(D_WorkAssignWTC);
      $USE(D_WorkLeftWTC);
      $USE(D_WorkShoenID);

      $USE(D_WorkImpRec);
      s_GetFPImportTableEntry(D_Current_FP_Ptr, D_WorkImpRec);
      $USE(D_WorkOrginalData);
      s_SoftLockBImpRec_FP(D_WorkImpRec, D_WorkOrginalData);

      /* $BM"F~I=%l%3!<%I$N%m%C%/$r30$K=P$7$^$7$?!#(B92.04.28 ttakagi
      f_Get_WTCandShoenID_fromFP(D_Current_FP_Ptr, D_WorkRequestWTC,
				 D_WorkAssignWTC,D_WorkLeftWTC,D_WorkShoenID);
      */

      $CALL( s_GetExrefIdAndWtcBImpRecWithoutLock_Sub
 	                (D_WorkImpRec, D_WorkRequestWTC, D_WorkShoenID,
			 D_WorkAssignWTC, D_WorkLeftWTC) );

      $RELEASE(D_WorkRequestWTC);

      b_IfGreaterEqImm(D_WorkLeftWTC, _WTC_RESERVED) {
        /*** WTC$B==J,$N>l9g(B ***/
	s_SoftUnlockBImpRec_FP(D_WorkImpRec, D_WorkOrginalData);
	$RELEASE(D_WorkOrginalData);  $RELEASE(D_WorkImpRec);

	$USE(D_WorkRecvCLNum);
	f_Get_CLNum_fromExCell(A_ExCell1, D_WorkRecvCLNum);
	$RELEASE(D_WorkLeftWTC);
	$USE(D_WorkPtrToPacket);
	$USE(D_WorkPacketSize);
	$CALL( f_MakeLogicalPacket_Unify_EX_EX_Sub
  	          (D_WorkPtrToPacket, D_WorkPacketSize, A_PtrToExCell1,
		   A_ExCell1, A_PtrToExCell2, A_ExCell2,
		   D_WorkShoenID, D_WorkAssignWTC, D_WorkRecvCLNum) );
	$RELEASE(D_WorkShoenID);
	$RELEASE(D_WorkAssignWTC);
	$CALL( s_SendPacket_Sub
	      (D_WorkPtrToPacket, D_WorkPacketSize, D_WorkRecvCLNum) );
	$RELEASE(D_WorkPtrToPacket);
	$RELEASE(D_WorkPacketSize);
	$RELEASE(D_WorkRecvCLNum);
      } else {
        /*** WTC$BITB-$N>l9g(B ***/
	@DEBUG{
	  WARNING("f_Send_IntClMsg_Unify_EX_EX_Sub","Suspended(WTC low)");
	};
	$RELEASE(D_WorkLeftWTC);
	/* %unify$B%a%C%;!<%8$N%5%9%Z%s%I(B */
	s_SoftUnlockExCell(A_PtrToExCell1, A_ExCell1);
	s_SoftUnlockExCell(A_PtrToExCell2, A_ExCell2);
	$CALL( f_UnifyMsgSusp_WaitingWTC_Sub(A_PtrToExCell1, A_PtrToExCell2) );

	s_SoftUnlockBImpRec_FP(D_WorkImpRec, D_WorkOrginalData);
	$RELEASE(D_WorkOrginalData);  $RELEASE(D_WorkImpRec);

	b_IfNotZero(D_WorkAssignWTC) { /* WTC$BMW5a%a%C%;!<%8$NAw?.(B */
	  s_RecordMsgEncodeStop(); /*** for Processor Profile ***/
	  $CALL( f_Send_IntClMsg_Request_WTC_Sub
		                 (D_WorkShoenID, D_WorkAssignWTC) );
	  s_RecordMsgEncodeStart(); /*** for Processor Profile ***/
	}
	$RELEASE(D_WorkAssignWTC);
	$RELEASE(D_WorkShoenID);
      } /* end of b_IfGreaterEqImm(D_WorkLeftWTC, _WTC_RESERVED) */
      s_RecordMsgEncodeStop(); /*** for Processor Profile ***/
    } else {
      /* $B0z?t#2$K$D$$$F(BRequest_BEXID$B$r=P$5$M$P$J$i$J$$>l9g(B */ 
      $CALL( f_UnifyMsgSusp_WaitingWEC_Sub
	                    (A_PtrToExCell2, A_ExCell2, A_PtrToExCell1) );
      s_SoftUnlockExCell(A_PtrToExCell1, A_ExCell1);
    }
  } else {
    $CALL( f_UnifyMsgSusp_WaitingWEC_Sub
	                    (A_PtrToExCell1, A_ExCell1, A_PtrToExCell2) );
    s_SoftUnlockExCell(A_PtrToExCell2, A_ExCell2);
  } /* end of f_IfUnifySendableUnifyArg1(A_PtrToExCell1, A_ExCell1) */

  $RETURN();
}

/******************************************************************** PSL **
2.2 %unify$B%a%C%;!<%8$NO@M}%Q%1%C%H$r:n@.$9$k(B(EX_EX$B$r=|$/(B)
    
f_MakeLogicalPacket_Unify_Sub

       written by ttakagi@icot22      on Fri Jun 29 10:16:27 1990

<Arguments>
  A_PtrToPacket: $B:n@.$9$kO@M}%Q%1%C%H$X$N%]%$%s%?(B
  A_PacketSize:  $BO@M}%Q%1%C%H$N%5%$%:(B
  A_PtrToExCell: $B30It;2>H%;%k(B($B%f%K%U%!%$$NBh(B1$B0z?t(B)$B$X$N%]%$%s%?(B
  A_ExCell:      $BGr(B($B9u(B)$BM"F~%l%3!<%I$X$N%]%$%s%?(B
  A_Arg2:        $B6qBN2=$5$l$?JQ?t(B($B%f%K%U%!%$$NBh(B2$B0z?t(B)$B$X$N%]%$%s%?(B
  A_ShoenID:     $BAq1`(BID
  A_WTC:         %unify$BAw?.;~$KIU$1$i$l$k(BWTC

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  %Unify$B%a%C%;!<%8$N%Q%1%C%H$r:n@.$9$k!#(B
  $B0z?t#1$N#W#E#CITB-$G%5%9%Z%s%I$9$k$3$H$O$J$$!#(B
     $B!J;vA0$K%A%'%C%/:Q$_$G!"(BEX$B%;%k$K%m%C%/$r3]$1$?$^$^%^%/%m$,8F$P$l$F$$$k!K(B

<ETC>
********************************************************************* PSL **/

#SUBARG_define A_PtrToPacket     DST
#SUBARG_define A_PacketSize      DST
#SUBARG_define A_PtrToExCell     SRC
#SUBARG_define A_ExCell          SRC
#SUBARG_define A_Bounded         SRC
#SUBARG_define A_ShoenID         SRC
#SUBARG_define A_WTC             SRC
#SUBARG_define A_ReceiveCLNum    SRC

#SUBROUTINE f_MakeLogicalPacket_Unify_Sub
                         (A_PtrToPacket, A_PacketSize, A_PtrToExCell, A_ExCell,
			  A_Bounded, A_ShoenID, A_WTC, A_ReceiveCLNum)
{
  $USE(D_WorkCurrentPtr_inLogicalPacket);
  f_AllocLogicalPacket_Unify
                  (A_PtrToPacket, D_WorkCurrentPtr_inLogicalPacket, A_Bounded);
  f_Put_Unify_ControlInfo_inLogicalPacket
                  (D_WorkCurrentPtr_inLogicalPacket, A_ShoenID, A_WTC);
  $CALL( f_Put_Unify_Arg1_inLogicalPacket_Sub
	         (D_WorkCurrentPtr_inLogicalPacket, A_PtrToExCell, A_ExCell) );

  s_IfMOD(A_Bounded){
    /* %Unify$B$N0z?t#2$,9=B$BN4IM}$9$k%G!<%?$N;~$O!"%l%Y%k#0M"=P$9$k(B */
    /* $B%b%8%e!<%k0J30$K$b9=B$BN4IM}$r$9$k%G!<%?$,A}$($?;~$O!"(B
       $B>r7oH=Dj$,A}$($k!#(B*/
    $CALL( f_Put_Data_Level0_inLogicalPacket_Sub
	  (D_WorkCurrentPtr_inLogicalPacket, A_Bounded, A_ReceiveCLNum) );
  } else {
    $CALL( f_Put_Data_Level1_inLogicalPacket_Sub
	  (D_WorkCurrentPtr_inLogicalPacket, A_Bounded, A_ReceiveCLNum) );
  }

  f_Put_EOM_inLogicalPacket(D_WorkCurrentPtr_inLogicalPacket);
  s_GetPacketSize
       (A_PtrToPacket, D_WorkCurrentPtr_inLogicalPacket, A_PacketSize);
  $RELEASE(D_WorkCurrentPtr_inLogicalPacket);
  $RETURN();
}

/******************************************************************** PSL **
2.2 %unify$B%a%C%;!<%8$NO@M}%Q%1%C%H$r:n@.$9$k(B(EX_EX$B$N>l9g(B)
    
f_MakeLogicalPacket_Unify_EX_EX_Sub

       written by ttakagi@icot22      on Thu Jul  5 14:23:41 1990

<Arguments>
  A_PtrToPacket: $B:n@.$9$kO@M}%Q%1%C%H$X$N%]%$%s%?(B
  A_PacketSize:  $BO@M}%Q%1%C%H$N%5%$%:(B
  A_PtrToExCell1: $B30It;2>H%;%k(B($B%f%K%U%!%$$NBh(B1$B0z?t(B)$B$X$N%]%$%s%?(B
  A_PtrToImpRec1: $BGr(B($B9u(B)$BM"F~%l%3!<%I$X$N%]%$%s%?(B
  A_PtrToExCell2: $B30It;2>H%;%k(B($B%f%K%U%!%$$NBh(B2$B0z?t(B)$B$X$N%]%$%s%?(B
  A_PtrToImpRec2: $BGr(B($B9u(B)$BM"F~%l%3!<%I$X$N%]%$%s%?(B
  A_ShoenID:     $BAq1`(BID
  A_WTC:         %unify$BAw?.;~$KIU$1$i$l$k(BWTC

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkResultFlag XXX

#SUBARG_define A_PtrToPacket      DST
#SUBARG_define A_PacketSize       DST
#SUBARG_define A_PtrToExCell1     SRC
#SUBARG_define A_ExCell1          SRC
#SUBARG_define A_PtrToExCell2     SRC
#SUBARG_define A_ExCell2          SRC
#SUBARG_define A_ShoenID          SRC
#SUBARG_define A_WTC              SRC
#SUBARG_define A_ReceiveCLNum     SRC

#SUBROUTINE f_MakeLogicalPacket_Unify_EX_EX_Sub
                  (A_PtrToPacket, A_PacketSize, A_PtrToExCell1, A_ExCell1,
 	           A_PtrToExCell2, A_ExCell2, A_ShoenID, A_WTC, A_ReceiveCLNum)
{
  $USE(D_WorkCurrentPtr_inLogicalPacket);
  f_AllocLogicalPacket_Unify
             (A_PtrToPacket, D_WorkCurrentPtr_inLogicalPacket, A_PtrToExCell2);
  f_Put_Unify_ControlInfo_inLogicalPacket
             (D_WorkCurrentPtr_inLogicalPacket, A_ShoenID, A_WTC);
  $CALL( f_Put_Unify_Arg1_inLogicalPacket_Sub
	     (D_WorkCurrentPtr_inLogicalPacket, A_PtrToExCell1, A_ExCell1) );
  $USE(D_WorkResultFlag);
  $CALL( f_Put_EX_inLogicalPacket_Sub
	       (D_WorkCurrentPtr_inLogicalPacket,
	        A_PtrToExCell2, A_ExCell2, D_WorkResultFlag) );
  b_IfRegFlagOn(D_WorkResultFlag) {
    b_IfIllegalPointer(A_ExCell2) { /* A_ExCell2$B$N;X$9M"F~I=$,2rJ|$5$l$?;~(B */
      s_ReclaimVariable(A_PtrToExCell2);
    } else {
      s_SoftUnlockExCell(A_PtrToExCell2, A_ExCell2);  
    }
    f_Put_EOM_inLogicalPacket(D_WorkCurrentPtr_inLogicalPacket);
    s_GetPacketSize
      (A_PtrToPacket, D_WorkCurrentPtr_inLogicalPacket, A_PacketSize);
  } else {
    @DEBUG{
      VPIM_ERROR("f_MakeLogicalPacket_Unify_EX_EX_Sub",
		 "Arg2 is requesting BEXID");
    };
  }
  $RELEASE(D_WorkResultFlag);
  $RELEASE(D_WorkCurrentPtr_inLogicalPacket);
  $RETURN();
}
/******************************************************************** PSL **
$B30It;2>H%;%k$NM"=P$,4V@\M"=P$K$J$k$+$I$&$+$N%A%'%C%/(B

f_IfIndirectExportData

       written by ttakagi@icot22      on Thu Jul  5 10:54:58 1990

<Arguments>
  ptr_to_excell: $B30It;2>H%;%k$X$N%]%$%s%?(B
                 $B30It;2>H%;%k$O%m%C%/$5$l$F$$$k(B
  excell:        $B30It;2>H%;%k$N%*%j%8%J%k%G!<%?(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  excell$B$N@h$,9uM"F~%l%3!<%I$G!"#W#E#C!a#1$J$i$P$9$Y$F4V@\M"=P$K$J$k$HH=CG$9$k!#(B
  $B3N$+$K#W#E#C!a#1$G$b!"30It;2>H%;%k$X$N#M#R#B$,!{$G!"(Bimport_flag$B$,(Boff$B$J$i$P2rJ|M"=P$K$J$k2DG=@-$,$"$k!#$7$+$7!"$3$N>l9g$b$7(B%Unify$B$N0z?t#2$,4V@\M"=P$K$J$C$FAj<j%/%i%9%?B&$G:F$SEj$2JV$5$l$F$-$?$H$7$F$b!"<!2s$N(BUnification$B$G$O!"0z?t#1$N#W#E#C$O==J,Bg$-$/4V@\M"=P$G$J$/$J$C$F$$$k$3$H$,M=A[$5$l$k!#(B
<ETC>
********************************************************************* PSL **/

#CTRL_define f_IfIndirectExportData(ptr_to_excell, excell)
{
  $USE(D_WorkImpRec);
  $USE(D_WorkExrefIdUnify);
  s_IfRDHOK(excell) {
    s_GetPtrToImpRecRdhokRec(excell, D_WorkImpRec);
  } else {
    p_MoveWord(excell, D_WorkImpRec);
  }
  TypeSwitch(D_WorkImpRec){
    case WEXREF:
    case WEXVAL:
      s_GetExrefIdForCheck(D_WorkImpRec, D_WorkExrefIdUnify);
      s_IfMRBoff(ptr_to_excell){
	s_IfUnifyFlagOn(D_WorkExrefIdUnify){
	  @DEBUG{
	    VPIM_ERROR("f_IfIndirectExportData","ExCell is WEXo UnifyFlagOn");
	  };
	} else {
	  b_SetFail(); /* $B4V@\M"=P$G$J$$(B */
	}
      } else { /*  s_IfMRBon(ptr_to_excell)  */
	b_SetSuccess(); /* $B4V@\M"=P(B */
      }
      break;
    case BEXREF:
    case BEXVAL:
      s_IfEnoughWECinBImp_Rec(D_WorkImpRec){
	b_SetFail(); /* $B4V@\M"=P$G$J$$(B */
      } else {
	b_SetSuccess(); /* $B4V@\M"=P!J$N2DG=@-$,$"$k!K(B */
      }
      break;
      
    case EOL:
      b_SetSuccess(); /* $B4V@\M"=P(B */
      break;
      
    default:
      @DEBUG{ VPIM_ERROR("f_IfIndirectExportData","invalid data"); };
      break;
    }
  $RELEASE(D_WorkExrefIdUnify);
  $RELEASE(D_WorkImpRec);
  b_IfSuccess()
}

/******************************************************************** PSL **
$B#W#T#CITB-$G(B%unify$B%a%C%;!<%8$r%5%9%Z%s%I$9$k(B

f_UnifyMsgSusp_WaitingWTC

       written by ttakagi@icot22      on Thu Jul  5 11:42:22 1990

<Arguments>
 A_PtrToArg1: $B%f%K%U%!%$$NBh#10z?t$X$N%]%$%s%?(B
 A_PtrToArg2: $B%f%K%U%!%$$NBh#20z?t$X$N%]%$%s%?(B

<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#SUBARG_define A_PtrToArg1 SRC
#SUBARG_define A_PtrToArg2 SRC

#SUBROUTINE f_UnifyMsgSusp_WaitingWTC_Sub(A_PtrToArg1, A_PtrToArg2)
{
  $USE(D_WorkFPOrgLockTagReg);
  s_LockFPRecord(D_Current_FP_Ptr, D_WorkFPOrgLockTagReg);
  $USE(D_WorkMsgSusRec);
  s_AllocEntryOfMsgSusRec_Unify(D_WorkMsgSusRec);
  s_PutMsgIdMsgSusRec(D_WorkMsgSusRec, _NW_UNIFY);
  s_PutArg1OfMsgSusRec_Unify(D_WorkMsgSusRec, A_PtrToArg1);
  s_PutArg2OfMsgSusRec_Unify(D_WorkMsgSusRec, A_PtrToArg2);

  $USE(D_WorkCurrentPriority);
  s_GetPriorityEnvRecord(D_CurrentEnvRecPtr,D_WorkCurrentPriority);
  s_PutPrioOfMsgSusRec_Unify(D_WorkMsgSusRec, D_WorkCurrentPriority);
  $RELEASE(D_WorkCurrentPriority);

  f_PushSuspendedMsgToFP(D_Current_FP_Ptr, D_WorkMsgSusRec);
                                           /* in f_int_cl_send_throw_goal */
  $RELEASE(D_WorkMsgSusRec);
  s_UnlockFPRecord(D_Current_FP_Ptr, D_WorkFPOrgLockTagReg);
  $RELEASE(D_WorkFPOrgLockTagReg);
  $RETURN();
}

/******************************************************************** PSL **
%unify$B$NBh#10z?t$N#W#E#CITB-$G%a%C%;!<%8$r%5%9%Z%s%I$9$k(B

f_UnifyMsgSusp_WaitingWEC

       written by ttakagi@icot22      on Thu Jul  5 11:45:15 1990

<Arguments>
 A_PtrToExref: $B30It;2>H%;%k$X$N%]%$%s%?(B
 A_Exref:      $B30It;2>H%;%k(B($B%f%K%U%!%$$NBh#10z?t(B)
 A_PtrToArg2:  $B%f%K%U%!%$$NBh#20z?t$X$N%]%$%s%?(B

<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkUnifySuspendGR XXX

#SUBARG_define A_PtrToExref SRC
#SUBARG_define A_Exref      SRC
#SUBARG_define A_PtrToArg2  SRC

#SUBROUTINE f_UnifyMsgSusp_WaitingWEC_Sub(A_PtrToExref, A_Exref, A_PtrToArg2)
{
  $USE(D_WorkUnifySuspendGR);

  $CALL( f_MakeUnifier_Sub(D_WorkUnifySuspendGR, A_PtrToExref, A_PtrToArg2) );
   /* *** $BCm0U(B *** $B$3$NCf$G(Bchild-count$B$r#1%$%s%/%j%a%s%H$7$F$$$k(B */

  f_MessageSusp_WaitingWEC(A_PtrToExref, A_Exref, D_WorkUnifySuspendGR);
  $RELEASE(D_WorkUnifySuspendGR);    

  $RETURN();
}

#PSL_define f_MessageSusp_WaitingWEC(ptr_to_exref, exref, ptr_to_goal)
{
  $USE(D_WorkPtrToImpRec);
  s_IfRDHOK(exref) {
    s_GetPtrToImpRecRdhokRec(exref, D_WorkPtrToImpRec);
  } else {
    p_MoveWord(exref, D_WorkPtrToImpRec);
  }
  
  b_IfEOL(D_WorkPtrToImpRec){
    /* Request_BEXID$BAw=PCf$O!"M"F~I=$X$N%]%$%s%?(B(D_WorkPtrToImpRec)
      $B$,(BEOL$B$H$J$C$F$$$k!#(B*/
    /* Request_BEXID$B%a%C%;!<%8$OAw=P:Q$_!#%4!<%k$r%U%C%/$9$k$@$1$GNI$$!#(B*/
    @DEBUG{
      s_IfNotRDHOK(exref){
	VPIM_ERROR("f_MessageSusp_WaitingWEC", "Invalid PtrToImpRec");
      }
    };
    s_PushGoalsRdhokRec(exref, ptr_to_goal);
    s_SoftUnlockExCell(ptr_to_exref, exref);
  } else {
    /* Request_BEXID$B$OL$$@Aw=P$7$F$$$J$$!#(B
       Request_BEXID$B$rAw=P$7$F!"%4!<%k$r%U%C%/$5$;$k(B */      
    f_Send_IntClMsg_Request_BEXID(D_WorkPtrToImpRec, ptr_to_exref);
    s_IfNotRDHOK(exref) {
      s_AllocRdhokWithGoalAndHookExCell(ptr_to_goal, D_NULL, ptr_to_exref);
      /* $BL$$@(BRDHOK$B%l%3!<%I$,3d$jIU$1$i$l$F$$$J$$;~$O!"<+J,$G3d$jIU$1$k!#(B
	 $BM"F~%l%3!<%I$X$N%]%$%s%?$O(BD_NULL$B$H$9$k!#(B*/
    } else {
      s_PushGoalsRdhokRec(exref, ptr_to_goal);
      s_PutPtrToImpRecRdhokRec(exref, D_NULL);
      s_SoftUnlockExCell(ptr_to_exref, exref);
      /* RDHOK$B%l%3!<%I$,4{$K3d$jIU$1$i$l$F$$$k;~$O!"%4!<%k$r%U%C%/$9$k!#(B
	 $BM"F~%l%3!<%I$X$N%]%$%s%?$O(BD_NULL$B$H$9$k!#(B*/
    }
  }
  $RELEASE(D_WorkPtrToImpRec);
}

/******************************************************************** PSL **
%unify$B$N0z?t$,M"=P2DG=$+$I$&$+$N%A%'%C%/(B

f_IfUnifySendableUnifyArg

       written by nakase@icot22      on Wed Aug 22 20:13:26 1990

<Arguments>
  ptr_to_excell: $B30It;2>H%;%k$X$N%]%$%s%?(B
                 $B$3$N@h$O%m%C%/$5$l$F$$$k(B
  excell:        $B30It;2>H%;%k$N%*%j%8%J%k%G!<%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkUnifyArgSendableFlag XXX
#DATA_define D_WorkExrefIdUnify         XXX
#DATA_define D_WorkPtrToImpRecUnifyCheck XXX

#CTRL_define f_IfUnifySendableUnifyArg(ptr_to_excell, excell)
{
  $USE(D_WorkPtrToImpRecUnifyCheck);
  s_IfRDHOK(excell) {
    s_GetPtrToImpRecRdhokRec(excell, D_WorkPtrToImpRecUnifyCheck);
  } else {
    p_MoveWord(excell, D_WorkPtrToImpRecUnifyCheck);
  }

  TypeSwitch(D_WorkPtrToImpRecUnifyCheck) {
    case WEXTGrp():
      $USE(D_WorkExrefIdUnify);
      s_GetExrefIdForCheck(D_WorkPtrToImpRecUnifyCheck, D_WorkExrefIdUnify);
      s_IfUnifyFlagOn(D_WorkExrefIdUnify) {
	b_SetFail();
	@DEBUG{
	  WARNING("f_CheckUnifyArgSendable",
		  "UnifyArg is not sendable(WEX unify_on)");
	};
      } else {
	b_SetSuccess();	
      }
      $RELEASE(D_WorkExrefIdUnify);
      break;
    case BEXTGrp():
      s_IfEnoughWECinBImp_Rec(D_WorkPtrToImpRecUnifyCheck) {
	b_SetSuccess();
      } else {
	b_SetFail();
	@DEBUG{
	  WARNING("f_CheckUnifyArgSendable",
		  "UnifyArg is not sendable(WEC=1)");
	};
      }
      break;
    case EOL: /* requestBEXID$BAw?.Cf$O(B EOLx */
      b_SetFail();
      @DEBUG{
	WARNING("f_IfUnifySendableUnifyArg",
		"UnifyArg is not sendable(Sending requestBEXID)");
      };
      break;
    default:
      @DEBUG{ VPIM_ERROR("f_CheckUnifyArgSendable", "invalid ImpRec type"); };
      break;
  }
  $RELEASE(D_WorkPtrToImpRecUnifyCheck);

  b_IfSuccess()
}

