
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_int_cl_send_release.psl.c
   ----- CREATED   : by ttakagi@icot22, on Fri Jun 22 21:51:39 1990
   ----- LAST SAVED: by ttakagi@icot22, on Fri Jun 12 15:01:25 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : %release$BAw?.=hM}(B

<$BO@M}%Q%1%C%H$N7A<0(B>

$B!NGrM"=PI=$N2rJ|$N>l9g!O(B
      39                                       0
       +---------------------------------------+
    0  | DNTC     |Release$B$N%a%C%;!<%8<oJL(B     |
       +---------------------------------------+
    1  |WEXREF/VAL|$BJV?.@h$N%/%i%9%?Fb#I#D(B      |
       +---------------------------------------+
    2  |         End of Message                |
       +---------------------------------------+

$B!N9uM"=PI=$N2rJ|$N>l9g!O(B
      39                                       0
       +---------------------------------------+
    0  | DNTC     |Release$B$N%a%C%;!<%8<oJL(B     |
       +---------------------------------------+
    1  |BEXREF/VAL|$BJV?.@h$N%/%i%9%?Fb#I#D(B      |
       +---------------------------------------+
    2  | DNTC     |$BJV?.$5$l$k#W#E#C(B            |
       +---------------------------------------+
    3  |         End of Message                |
       +---------------------------------------+

 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
1. f_Send_IntClMsg_Release_Sub

       written by ttakagi@icot22      on Fri Jul  6 16:30:26 1990

<Arguments>
  A_PtrToImpRec: $B2rJ|$5$l$kM"F~I=%l%3!<%I$X$N%]%$%s%?(B

<Temporally Used Variables>
<Level>
<PreCondition>
  EX$B%;%k$d(BReadHook$B%;%k$r2s<}$9$k$N$O!"#1$D>e$N%^%/%m$NLrL\!#(B
<Function>
  $BM"F~%G!<%?$r3+J|$7$?$3$H$rM"=P85$KCN$i$;$k(B(%release)
<Examples>
<Test>
<Explanation>
$B!&(Banswer_value$B$G2rJ|$9$k>l9g!"(BEX$B%;%k$O4{$K%P%$%s%I$5$l$F$$$k!#(B
$B!&(Bcollect_value$B$G9uM"F~I=$O2rJ|$7$J$$!#(B
  ($BJL$K2rJ|$7$F$bNI$$!#$=$N2rJ|$9$k>l9g!"(BEX$B%;%k$K%m%C%/$r3]$1$F9uM"F~I=$r(B
   $B8+$K9T$-!"(Bimport_count$B$,#1$G$"$k$3$H$r3NG'$7!"(BEX$B%;%k$N%m%C%/$r30$7$F!"(B
   $B%O%C%7%eI=$K%m%C%/$r3]$1!"$^$?(Bimport_count=1$B$G$"$k$3$H$r3NG'$7$F!"2rJ|(B
   $B$9$k!#(B)

<ETC>
$B!&#G#CL?Na$G$"$k(Bcollect_value$B$H!"(B%answer_value$B<u?.$N%^%/%m$+$i8F$P$l$k!#(B
 $B%/%i%9%?Fb$N0l3g#G#C8e$K=P$99uM"F~$N(B %release $B$O!"JL%^%/%m(B
********************************************************************* PSL **/

#SUBARG_define A_PtrToImpRec SRC

#SUBROUTINE f_Send_IntClMsg_Release_Sub(A_PtrToImpRec)
{
  s_RecordMsgEncodeStart(); /*** for Processor Profile ***/
  s_IfWEXT(A_PtrToImpRec) {
    f_SendPacket_Release_WEX(A_PtrToImpRec);
  } else {
    f_SendPacket_Release_BEX(A_PtrToImpRec);
  }
  s_RecordMsgEncodeStop(); /*** for Processor Profile ***/
  $RETURN();
}

#PSL_define f_MakeLogicalPacket_Release_WEX(ptr_to_packet, exref_id)
{
  $USE(D_WorkPacketCurrentPtr);
  f_AllocLogicalPacket_Release_WEX(ptr_to_packet, D_WorkPacketCurrentPtr);
  f_Put_Release_WEX_inLogicalPacket(D_WorkPacketCurrentPtr, exref_id);
  f_Put_EOM_inLogicalPacket(D_WorkPacketCurrentPtr);
  $RELEASE(D_WorkPacketCurrentPtr);
}

#PSL_define f_SendPacket_Release_WEX(ptr_to_wimprec)
{
  $USE(D_WorkExrefID);
  s_GetExrefIdAndReclaimWImpRec(ptr_to_wimprec, D_WorkExrefID);
  $USE(D_WorkCLNum);
  s_GetClusterNum(D_WorkExrefID, D_WorkCLNum);
  $USE(D_WorkPacketSize);
  f_GetPacketSize_Release_WEX(D_WorkPacketSize);
  b_IfNetWorkBufferStatusOK(D_WorkPacketSize) {
    s_RecordMsgSendCountLogMsgTypeImm(_NW_RELEASE);
                                     /*** for Processor Profile ***/
    s_Send_PacketHeader_toNetwork(D_WorkCLNum, D_WorkPacketSize);
    f_Send_Release_WEX_toNetwork(D_WorkExrefID);
    f_Send_EOM_toNetwork();
  } else {
    @DEBUG{WARNING("f_SendPacket_Release_WEX","Network buffer FULL");};
    $USE(D_WorkPtrToPacket);
    f_MakeLogicalPacket_Release_WEX(D_WorkPtrToPacket, D_WorkExrefID);
    b_AddImmediateWithDNTC
         (D_WorkPacketSize, _SINGLE_PACKET_CONTROL_SIZE, D_WorkPacketSize);
    s_PacketSuspend_Single(D_WorkPtrToPacket, D_WorkPacketSize, D_WorkCLNum);
    $RELEASE(D_WorkPtrToPacket);
  }
  $RELEASE(D_WorkPacketSize);
  $RELEASE(D_WorkCLNum);
  $RELEASE(D_WorkExrefID);
}
  
#DATA_define D_WorkZeroWECFlag XXX

#PSL_define f_MakeLogicalPacket_Release_BEX(ptr_to_packet, exref_id, wec)
{
  $USE(D_WorkPacketCurrentPtr);
  f_AllocLogicalPacket_Release_BEX(ptr_to_packet, D_WorkPacketCurrentPtr);
  f_Put_Release_BEX_inLogicalPacket(D_WorkPacketCurrentPtr, exref_id, wec);
  f_Put_EOM_inLogicalPacket(D_WorkPacketCurrentPtr);
  $RELEASE(D_WorkPacketCurrentPtr);
}

#DATA_define D_WorkPacketWEC XXX

#PSL_define f_SendPacket_Release_BEX(ptr_to_bimprec)
{
  $USE(D_WorkExrefID);
  $USE(D_WorkPacketWEC);
  $CALL( s_GetExrefIdAllWecAndReclaimBImpRec_AnswerValue_Sub
                            (ptr_to_bimprec, D_WorkExrefID, D_WorkPacketWEC) );
  @DEBUG{
      b_IfEqualImm(D_WorkPacketWEC, _ZERO){
	VPIM_ERROR("f_SendPacket_Release_BEX","invalid WEC for Release");
      }};
  $USE(D_WorkCLNum);
  s_GetClusterNum(D_WorkExrefID, D_WorkCLNum);
  $USE(D_WorkPacketSize);
  f_GetPacketSize_Release_BEX(D_WorkPacketSize);
  b_IfNetWorkBufferStatusOK(D_WorkPacketSize) {
    s_RecordMsgSendCountLogMsgTypeImm(_NW_RELEASE);
                                     /*** for Processor Profile ***/
    s_Send_PacketHeader_toNetwork(D_WorkCLNum, D_WorkPacketSize);
    f_Send_Release_BEX_toNetwork(D_WorkExrefID, D_WorkPacketWEC);
    f_Send_EOM_toNetwork();
  } else {
    @DEBUG{WARNING("f_SendPacket_Release_BEX","Network buffer FULL");};
    $USE(D_WorkPtrToPacket);
    f_MakeLogicalPacket_Release_BEX
                        (D_WorkPtrToPacket, D_WorkExrefID, D_WorkPacketWEC);
    b_AddImmediateWithDNTC
         (D_WorkPacketSize, _SINGLE_PACKET_CONTROL_SIZE, D_WorkPacketSize);
    s_PacketSuspend_Single(D_WorkPtrToPacket, D_WorkPacketSize, D_WorkCLNum);
    $RELEASE(D_WorkPtrToPacket);
  }
  $RELEASE(D_WorkPacketSize);
  $RELEASE(D_WorkCLNum);
  $RELEASE(D_WorkExrefID);
  $RELEASE(D_WorkPacketWEC);
}

/******************************************************************** PSL **
2. f_Send_IntClMsg_Release_BEX_AfterGC_Sub

       written by nakase@icot22      on Thu Dec 13 17:10:28 1990
<Arguments>
  A_PtrToImpRec: $BM"F~I=$X$N%]%$%s%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#SUBARG_define A_PtrToImpRec SRC

#SUBROUTINE f_Send_IntClMsg_Release_BEX_AfterGC_Sub(A_PtrToImpRec)
{
  s_RecordMsgEncodeStart(); /*** for Processor Profile ***/

  f_SendPacket_Release_BEX_AfterGC(A_PtrToImpRec);

  s_RecordMsgEncodeStop(); /*** for Processor Profile ***/
  $RETURN();
}

#PSL_define f_SendPacket_Release_BEX_AfterGC(ptr_to_bimprec)
{
  $USE(D_WorkExrefID);
  $USE(D_WorkPacketWEC);
  $CALL( s_GetExrefIdAllWecAfterGC_Sub
	                    (ptr_to_bimprec, D_WorkExrefID, D_WorkPacketWEC) );
  $USE(D_WorkCLNum);
  s_GetClusterNum(D_WorkExrefID, D_WorkCLNum);
  $USE(D_WorkPacketSize);
  f_GetPacketSize_Release_BEX(D_WorkPacketSize);
  b_IfNetWorkBufferStatusOK(D_WorkPacketSize) {
    s_RecordMsgSendCountLogMsgTypeImm(_NW_RELEASE);
                                     /*** for Processor Profile ***/
    s_Send_PacketHeader_toNetwork(D_WorkCLNum, D_WorkPacketSize);
    f_Send_Release_BEX_toNetwork(D_WorkExrefID, D_WorkPacketWEC);
    f_Send_EOM_toNetwork();
  } else {
    @DEBUG{WARNING("f_SendPacket_Release_BEX_AfterGC","Network buffer FULL");};
    $USE(D_WorkPtrToPacket);
    f_MakeLogicalPacket_Release_BEX
                        (D_WorkPtrToPacket, D_WorkExrefID, D_WorkPacketWEC);
    b_AddImmediateWithDNTC
         (D_WorkPacketSize, _SINGLE_PACKET_CONTROL_SIZE, D_WorkPacketSize);
    s_PacketSuspend_Single(D_WorkPtrToPacket, D_WorkPacketSize, D_WorkCLNum);
    $RELEASE(D_WorkPtrToPacket);
  }
  $RELEASE(D_WorkPacketSize);
  $RELEASE(D_WorkCLNum);
  $RELEASE(D_WorkExrefID);
  $RELEASE(D_WorkPacketWEC);
}

/******************************************************************** PSL **
3. f_Send_IntClMsg_Release_byCollectValue_Sub

       written by ttakagi@icot22      on Tue Jul 10 15:17:51 1990

<Arguments>
  A_ExCell    : $B30It;2>H%;%k(B
  A_ExCellPtr : $B30It;2>H%;%k$X$N%]%$%s%?(B

<PreCondition>
  A_ExCellPtr$B$N@h$K$O%m%C%/$,3]$+$C$F$$$k!#(B

<Explanation>
  A_ExCellPtr$B$N@h$N%G!<%?$O$3$N%5%V%k!<%A%sFb$G%"%s%m%C%/$9$k$+!"2s<}$9$k!#(B
<ETC>
********************************************************************* PSL **/

#SUBARG_define A_ExCellPtr MODIFY
#SUBARG_define A_ExCell    MODIFY

#SUBROUTINE f_Send_IntClMsg_Release_byCollectValue_Sub(A_ExCellPtr, A_ExCell)
{
  s_RecordMsgEncodeStart(); /*** for Processor Profile ***/
  TypeSwitch(A_ExCell) {
  case WEXTGrp():
    f_SendPacket_Release_WEX(A_ExCell);
    s_SoftUnlockExCell(A_ExCellPtr, A_ExCell);
    s_ReclaimVariable(A_ExCellPtr);
    break;
  case BEXTGrp():
    $USE(D_WorkFlagReg);
    f_SendPacket_Release_BEX_CollectValue(A_ExCell, D_WorkFlagReg);
    b_IfRegFlagOn(D_WorkFlagReg) {
      s_SoftUnlockExCell(A_ExCellPtr, A_ExCell);
      s_ReclaimVariable(A_ExCellPtr);
    } else {
      s_SoftUnlockExCell(A_ExCellPtr, A_ExCell);
    }
    $RELEASE(D_WorkFlagReg);
    break;
  default:
    @DEBUG{
      VPIM_ERROR("f_Send_IntClMsg_Release_byCollectValue_Sub",
		 "Invalid Exref for collect value");
    };
  }
  s_RecordMsgEncodeStop(); /*** for Processor Profile ***/

  $RETURN();
}

#PSL_define f_SendPacket_Release_BEX_CollectValue(ptr_to_bimprec, collect_flag)
{
  $USE(D_WorkExrefID);
  $USE(D_WorkPacketWEC);
  $CALL( s_GetExrefIdAllWecAndReclaimBImpRec_Sub
                            (ptr_to_bimprec, D_WorkExrefID, D_WorkPacketWEC) );
  b_IfGreaterImm(D_WorkPacketWEC, _ZERO){
    /* $B2s<}$G$-$k>l9g(B */
    $USE(D_WorkCLNum);
    s_GetClusterNum(D_WorkExrefID, D_WorkCLNum);
    $USE(D_WorkPacketSize);
    f_GetPacketSize_Release_BEX(D_WorkPacketSize);
    b_IfNetWorkBufferStatusOK(D_WorkPacketSize) {
      s_RecordMsgSendCountLogMsgTypeImm(_NW_RELEASE);
                                       /*** for Processor Profile ***/
      s_Send_PacketHeader_toNetwork(D_WorkCLNum, D_WorkPacketSize);
      f_Send_Release_BEX_toNetwork(D_WorkExrefID, D_WorkPacketWEC);
      f_Send_EOM_toNetwork();
    } else {
      @DEBUG{WARNING("f_SendPacket_Release_BEX_CollectValue",
		     "Network buffer FULL");};
      $USE(D_WorkPtrToPacket);
      f_MakeLogicalPacket_Release_BEX
                        (D_WorkPtrToPacket, D_WorkExrefID, D_WorkPacketWEC);
      b_AddImmediateWithDNTC
         (D_WorkPacketSize, _SINGLE_PACKET_CONTROL_SIZE, D_WorkPacketSize);
      s_PacketSuspend_Single(D_WorkPtrToPacket, D_WorkPacketSize, D_WorkCLNum);
      $RELEASE(D_WorkPtrToPacket);
    }
    $RELEASE(D_WorkPacketSize);
    $RELEASE(D_WorkCLNum);
    b_SetRegFlagOn(collect_flag);
  } else {
    /* $B2s<}$G$-$J$$>l9g(B */
    b_SetRegFlagOff(collect_flag);
  }
  $RELEASE(D_WorkExrefID);
  $RELEASE(D_WorkPacketWEC);
}

/******************************************************************** PSL **
4. f_Send_IntClMsg_Release_ExistingStruct_Sub

       written by ttakagi@icot22      on Tue Sep  4 10:14:14 1990

<Arguments>
  A_ExrefID: $B30It;2>H(BID
  A_WEC:     $BJV5Q$5$l$k(BWEC

<Explanation>
<ETC>
********************************************************************* PSL **/

#SUBARG_define A_ExrefID SRC
#SUBARG_define A_Wec     SRC

#SUBROUTINE f_Send_IntClMsg_Release_ExistingStruct_Sub(A_ExrefID, A_Wec)
{
  s_RecordMsgEncodeStart(); /*** for Processor Profile ***/
  s_IfWEXT(A_ExrefID) {
    f_SendPacket_Release_WEX_ExistingStruct(A_ExrefID);
  } else {
    f_SendPacket_Release_BEX_ExistingStruct(A_ExrefID, A_Wec);
  }
  s_RecordMsgEncodeStop(); /*** for Processor Profile ***/
  $RETURN();
}

#PSL_define f_SendPacket_Release_WEX_ExistingStruct(exref_id)
{
  $USE(D_WorkCLNum);
  s_GetClusterNum(exref_id, D_WorkCLNum);
  $USE(D_WorkPacketSize);
  f_GetPacketSize_Release_WEX(D_WorkPacketSize);
  b_IfNetWorkBufferStatusOK(D_WorkPacketSize) {
    s_RecordMsgSendCountLogMsgTypeImm(_NW_RELEASE);
                                     /*** for Processor Profile ***/
    s_Send_PacketHeader_toNetwork(D_WorkCLNum, D_WorkPacketSize);
    f_Send_Release_WEX_toNetwork(exref_id);
    f_Send_EOM_toNetwork();
  } else {
    @DEBUG{WARNING("f_SendPacket_Release_WEX_ExistingStruct",
		   "Network buffer FULL");};
    $USE(D_WorkPtrToPacket);
    f_MakeLogicalPacket_Release_WEX(D_WorkPtrToPacket, exref_id);
    b_AddImmediateWithDNTC
         (D_WorkPacketSize, _SINGLE_PACKET_CONTROL_SIZE, D_WorkPacketSize);
    s_PacketSuspend_Single(D_WorkPtrToPacket, D_WorkPacketSize, D_WorkCLNum);
    $RELEASE(D_WorkPtrToPacket);
  }
  $RELEASE(D_WorkPacketSize);
  $RELEASE(D_WorkCLNum);
}

#PSL_define f_SendPacket_Release_BEX_ExistingStruct(exref_id, wec_reg)
{
  $USE(D_WorkCLNum);
  s_GetClusterNum(exref_id, D_WorkCLNum);
  $USE(D_WorkPacketSize);
  f_GetPacketSize_Release_BEX(D_WorkPacketSize);
  b_IfNetWorkBufferStatusOK(D_WorkPacketSize) {
    s_RecordMsgSendCountLogMsgTypeImm(_NW_RELEASE);
                                     /*** for Processor Profile ***/
    s_Send_PacketHeader_toNetwork(D_WorkCLNum, D_WorkPacketSize);
    f_Send_Release_BEX_toNetwork(exref_id, wec_reg);
    f_Send_EOM_toNetwork();
  } else {
    @DEBUG{WARNING("f_SendPacket_Release_BEX_ExistingStruct",
		   "Network buffer FULL");};
    $USE(D_WorkPtrToPacket);
    f_MakeLogicalPacket_Release_BEX(D_WorkPtrToPacket, exref_id, wec_reg);
    b_AddImmediateWithDNTC
         (D_WorkPacketSize, _SINGLE_PACKET_CONTROL_SIZE, D_WorkPacketSize);
    s_PacketSuspend_Single(D_WorkPtrToPacket, D_WorkPacketSize, D_WorkCLNum);
    $RELEASE(D_WorkPtrToPacket);
  }
  $RELEASE(D_WorkPacketSize);
  $RELEASE(D_WorkCLNum);
}
