
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_int_cl_send_read.psl.c
   ----- CREATED   : by ttakagi@icot22, on Tue Jun 19 12:09:16 1990
   ----- LAST SAVED: by ttakagi@icot22, on Wed Jun 17 12:56:56 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : %read$BAw?.=hM}(B

[$B%U%!%$%kFbMF(B]
1.  $BGr%Q%9!"Gr30It;2>H!"C10lBT$A$N>l9g(B
2.  $B9u%Q%9!"Gr30It;2>H!"C10lBT$A$N>l9g(B
3.  $B9u30It;2>H!"C10lBT$A$N>l9g(B
4.  $BGr30It;2>H!"B?=EBT$A$N>l9g(B
5.  $B9u30It;2>H!"B?=EBT$A$N>l9g(B

6. %read$BAw?.$K$*$1$kJV?.@h$N@8@.(B

<$BO@M}%Q%1%C%H$N7A<0(B>

  [$BGr30It;2>H%;%k$N>l9g(B]
      39                                       0
       +---------------------------------------+
    1  |DNTC      |Read$B$N%a%C%;!<%8<oJL(B        |
       +---------------------------------------+
    2  |WEXREF/VAL|$BFI$_=P$9%;%k$N30It;2>H#I#D(B  |
       +---------------------------------------+
    3  |WEXREF    |$BJV?.@h$N30It;2>H#I#D(B        |
       +---------------------------------------+
    4  |           End of Message              |
       +---------------------------------------+

  [$B9u30It;2>H%;%k$N>l9g(B]
      39                                       0
       +---------------------------------------+
    1  |DNTC      |Read$B$N%a%C%;!<%8<oJL(B        |
       +---------------------------------------+
    2  |BEXREF/VAL|$BFI$_=P$9%;%k$N30It;2>H#I#D(B  |
       +---------------------------------------+
    3  |DNTC      |$BJV$5$l$k#W#E#C(B              |
       +---------------------------------------+
    4  |WEXREF    |$BJV?.@h$N30It;2>H#I#D(B        |
       +---------------------------------------+
    5  |           End of Message              |
       +---------------------------------------+

 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
1. $B%G!<%?$NFI$_=P$7MW5a;~$N%a%C%;!<%8Aw?.=hM}(B(%read)
  $BGr%Q%9!"Gr30It;2>H!"C10lBT$A$N>l9g(B

(SUBROUTINE)f_Send_IntClMsg_Read_W_WEX_SingleWait_Sub

       written by ttakagi@icot22      on Tue Jun 19 12:29:42 1990

<Arguments>
  A_PtrToExCell:   $B30It;2>H%;%k$X$N%]%$%s%?(B
  A_PtrToSuspGoal: $B30It;2>H%;%k$rFI$b$&$H$7$?%4!<%k$X$N%]%$%s%?(B

<Function>
  $B!&2rJ|M"=P(B
  $B!&2rJ|M"=PA`:n$N8e(B, $B30It;2>H%;%k$rFI$b$&$H$7$?%4!<%k$,(B, $B$3$N30It;2>H%;%k$K(B
    $B%U%C%/$5$l$k!#(B

<<< before >>>
    +---------------+    +--------------+    +--------------+
    | A_PtrToExCell |--->| EX cell      |--->| WImp record  |---> other cluster
    | (REFo)        |    | (WEXVAL/REF) |    | (WEXVAL/REF) |
    +---------------+    +--------------+    +--------------+

<<< after >>>
                         +-----------------+
                    +--->| A_PtrToSuspGoal |---> Goal record
                    |    | (HOOK)          |
                    |    +-----------------+
                    |                        +--------------+
                    +------------------------| WExp record  |<--- other cluster
                                             | (REFo)       |
                                             +--------------+
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkPtrToWImpRec XXX

#SUBARG_define A_PtrToExCell   SRC
#SUBARG_define A_PtrToSuspGoal SRC

#SUBROUTINE f_Send_IntClMsg_Read_W_WEX_SingleWait_Sub
                                       (A_PtrToExCell, A_PtrToSuspGoal)
{
  @DEBUG{
    s_IfMRBon(A_PtrToExCell) {
      VPIM_ERROR("f_Send_IntClMsg_Read_W_WEX_SingleWait_Sub",
		 "A_PtrToExCell is not white");
    }
    s_IfNotHOOK(A_PtrToSuspGoal) {
      s_IfNotRHOOK(A_PtrToSuspGoal) {
	VPIM_ERROR("f_Send_IntClMsg_Read_W_WEX_SingleWait_Sub",
		   "Illegal A_PtrToSuspGoal");
      }
    }
  };

  s_RecordMsgEncodeStart(); /*** for Processor Profile ***/

  $USE(D_WorkPtrToWImpRec);
  p_Read(A_PtrToExCell, D_WorkPtrToWImpRec);

  $USE(D_WorkExRefID_Read);
  s_GetExrefIdAndReclaimWImpRec(D_WorkPtrToWImpRec, D_WorkExRefID_Read);

  @DEBUG{
    s_IfUnifyFlagOn(D_WorkExRefID_Read) {
     VPIM_ERROR("f_Send_IntClMsg_Read_W_WEX_SingleWait_Sub","invalid exrefid");
    }
  };

  f_SendPacket_Read_WEX(A_PtrToExCell, D_WorkExRefID_Read);

  f_HookToExCell(A_PtrToSuspGoal, A_PtrToExCell);

  $RELEASE(D_WorkExRefID_Read);
  $RELEASE(D_WorkPtrToWImpRec);

  s_RecordMsgEncodeStop(); /*** for Processor Profile ***/

  $RETURN();
}

#PSL_define f_HookToExCell(ptr_to_goal, ptr_to_exref)
{
  p_Write(ptr_to_goal, ptr_to_exref);
}

#PSL_define f_MakeLogicalPacket_Read_WEX(ptr_to_packet, ptr_to_exref, exref_id)
{
  $USE(D_WorkCurrentPtr_inLogicalPacket);
  f_AllocLogicalPacket_Read_WEX(ptr_to_packet,
				D_WorkCurrentPtr_inLogicalPacket);
  f_Put_Read_WEX_inLogicalPacket(D_WorkCurrentPtr_inLogicalPacket, 
				 ptr_to_exref, exref_id);
                /* %Read$BMW5a@h30It;2>H(BID$B$HJV?.@h30It;2>H(BID$B$r%Q%1%C%H$K=q$/(B */
  f_Put_EOM_inLogicalPacket(D_WorkCurrentPtr_inLogicalPacket);
  $RELEASE(D_WorkCurrentPtr_inLogicalPacket);
}

#PSL_define f_SendPacket_Read_WEX(ptr_to_exref, exref_id)
{
  $USE(D_WorkCLNum);
  s_GetClusterNum(exref_id, D_WorkCLNum);
  $USE(D_WorkPacketSize);
  f_GetPacketSize_Read_WEX(D_WorkPacketSize);
  b_IfNetWorkBufferStatusOK(D_WorkPacketSize) {
    s_RecordMsgSendCountLogMsgTypeImm(_NW_READ);/*** for Processor Profile ***/
    s_Send_PacketHeader_toNetwork(D_WorkCLNum, D_WorkPacketSize);
    f_Send_Read_WEX_toNetwork(ptr_to_exref, exref_id);
    f_Send_EOM_toNetwork();
  } else {
    @DEBUG{WARNING("f_SendPacket_Read_WEX","Network buffer FULL");};
    $USE(D_WorkPtrToPacket);
    f_MakeLogicalPacket_Read_WEX(D_WorkPtrToPacket, ptr_to_exref, exref_id);
    b_AddImmediateWithDNTC
         (D_WorkPacketSize, _SINGLE_PACKET_CONTROL_SIZE, D_WorkPacketSize);
    s_PacketSuspend_Single(D_WorkPtrToPacket, D_WorkPacketSize, D_WorkCLNum);
    $RELEASE(D_WorkPtrToPacket);
  }
  $RELEASE(D_WorkPacketSize);
  $RELEASE(D_WorkCLNum);
}

/******************************************************************** PSL **
2. $B%G!<%?$NFI$_=P$7MW5a;~$N%a%C%;!<%8Aw?.=hM}(B(%read)
  $B9u%Q%9!"Gr30It;2>H!"C10lBT$A$N>l9g(B

(SUBROUTINE)f_Send_IntClMsg_Read_B_WEX_SingleWait_Sub

       written by ttakagi@icot22      on Tue Jun 19 15:58:55 1990

<Arguments>
  A_PtrToExCell:   $B30It;2>H%;%k$X$N%]%$%s%?(B
  A_PtrToWImpRec:  $BGrM"F~%l%3!<%I$X$N%]%$%s%?(B
  A_PtrToSuspGoal: $B30It;2>H%;%k$rFI$b$&$H$7$?%4!<%k$X$N%]%$%s%?(B

<PreCondition>
  $B!&30It;2>H%;%k(B(A_PtrToExCell$B$N@h(B)$B$O(BEXLOCK$B:Q$_(B

<Explanation>

<<< before >>>
   +---------------+    +--------+
   | A_PtrToExCell |--->| EXLOCK |
   | (REFx)        |    +--------+
   +---------------+    +----------------+    +--------------+
                        | A_PtrToWImpRec |--->| WImp record  |---> other
                        | (WEXVAL/REF)   |    | (WEXVAL/REF) |       cluster
                        +----------------+    +--------------+

<<< after >>>
   +------+      +---------+    +--------------+    +--------------+
   | REFx |--+-->| EX cell |--->| RDHOK record |--->| WImp record  |---> other
   +------+  |   | (RDHOK) |    | (WEXVAL/REF) |    | (WEXVAL/REF) |    cluster
             |   +---------+    |--------------|    +--------------+
             |                  | (HOOK)       |---> Goal record
             |                  +--------------+
             |                                      +--------------+
             +--------------------------------------| WExp record  |<--- other
                                                    | (REFo)       |    cluster
                                                    +--------------+
<ETC>
********************************************************************* PSL **/

#SUBARG_define A_PtrToExCell   SRC
#SUBARG_define A_PtrToWImpRec  SRC
#SUBARG_define A_PtrToSuspGoal SRC

#SUBROUTINE f_Send_IntClMsg_Read_B_WEX_SingleWait_Sub
                              (A_PtrToExCell, A_PtrToWImpRec, A_PtrToSuspGoal)
{
  @DEBUG{
    s_IfMRBoff(A_PtrToExCell) {
      VPIM_ERROR("f_Send_IntClMsg_Read_W_WEX_SingleWait_Sub",
		 "A_PtrToExCell is not black");
    }
    s_IfBEXT(A_PtrToWImpRec) {
      VPIM_ERROR("f_Send_IntClMsg_Read_B_WEX_SingleWait_Sub",
		 "A_PtrToWImpRec is not WEXT");
    }
    s_IfNotHOOK(A_PtrToSuspGoal) {
      s_IfNotRHOOK(A_PtrToSuspGoal) {
	VPIM_ERROR("f_Send_IntClMsg_Read_B_WEX_SingleWait_Sub",
		   "Illegal A_PtrToSuspGoal");
      }
    }
  };

  s_RecordMsgEncodeStart(); /*** for Processor Profile ***/

  $USE(D_WorkExRefID_Read);
  s_GetExrefIdAndSetUnifyFlagOrReclaimWImpRec_Read
                                   (A_PtrToWImpRec, D_WorkExRefID_Read);

  b_IfIllegalPointer(A_PtrToWImpRec) {
    /* $B4{$K(Bunify_flag$B$,(Bon$B$G$"$C$?>l9g(B                 */
    /* $BGrM"F~%l%3!<%I$r2rJ|$7$F!"(BRequest BEXID $B$r=P$9(B */
    /* $BGrM"F~%l%3!<%I$N2rJ|$O(B "s_GetExrefIdAnd..." $B$G9T$J$o$l$F$$$k(B */

    @DEBUG{ WARNING("f_Send_IntClMsg_Read_B_WEX_SingleWait_Sub",
		    "Now, Sending Request_BEXID_WEX in read"); };

    f_SendPacket_Request_BEXID_WEX(A_PtrToExCell, D_WorkExRefID_Read);
  } else {
    /* unify_flag$B$,(Boff$B$G$"$C$?>l9g(B                              */
    /* $BGr30It;2>H(BID$B$N(Bunify_flag$B$r(Bon$B$K$7$F!"(BRead$B%a%C%;!<%8$r=P$9(B */
    @DEBUG{
      s_IfUnifyFlagOff(D_WorkExRefID_Read) {
	VPIM_ERROR("f_Send_IntClMsg_Read_B_WEX_SingleWait_Sub",
		   "invalid exrefid");
      } 
    };
    f_SendPacket_Read_WEX(A_PtrToExCell, D_WorkExRefID_Read);
  }
  s_AllocRdhokWithGoalAndHookExCell
                      (A_PtrToSuspGoal, A_PtrToWImpRec, A_PtrToExCell);
  $RELEASE(D_WorkExRefID_Read);

  s_RecordMsgEncodeStop(); /*** for Processor Profile ***/

  $RETURN();
}

/******************************************************************** PSL **
3. $B%G!<%?$NFI$_=P$7MW5a;~$N%a%C%;!<%8Aw?.=hM}(B(%read)
  $B9u30It;2>H!"C10lBT$A$N>l9g(B

(SUBROUTINE)f_Send_IntClMsg_Read_BEX_SingleWait_Sub

       written by ttakagi@icot22      on Tue Jun 19 16:08:18 1990

<Arguments>
  A_PtrToExCell:   $B30It;2>H%;%k$X$N%]%$%s%?(B
  A_PtrToBImpRec:  $B9uM"F~%l%3!<%I$X$N%]%$%s%?(B
  A_PtrToSuspGoal: $B30It;2>H%;%k$rFI$b$&$H$7$?%4!<%k$X$N%]%$%s%?(B

<PreCondition>
  A_PtrToExCell $B$N@h$O%m%C%/:Q$_(B
<Function>
  %read $B%a%C%;!<%8$rAw=P$7(B, $B%5%9%Z%s%I$9$k%4!<%k$r30It;2>H%;%k$K%U%C%/$9$k(B.
  ($B%U%C%/$9$k$3$H$K$h$j(B, $B30It;2>H%;%k$O%=%U%H%"%s%m%C%/$5$l$k(B)

<<< before >>>
   +---------------+    +--------+
   | A_PtrToExCell |--->| EXLOCK |
   | (REFo/x)      |    +--------+
   +---------------+    +----------------+    +--------------+
                        | A_PtrToBImpRec |--->| BImp record  |---> other
                        | (BEXVAL/REF)   |    | (BEXVAL/REF) |       cluster
                        +----------------+    +--------------+

<<< after : $B2rJ|M"=P$G$-$?;~(B >>>
   +------+      +---------+    +--------------+
   | REFo |--+-->| EX cell |--->| RDHOK record |     (BImpRec reclaimed)
   +------+  |   | (RDHOK) |    | (EOL)        |
             |   +---------+    |--------------|
             |                  | (HOOK)       |---> Goal record
             |                  +--------------+
             |                                      +--------------+
             +--------------------------------------| WExp record  |<--- other
                                                    | (REFo)       |    cluster
                                                    +--------------+

<<< after : $B2rJ|M"=P$G$-$J$+$C$?;~(B >>>
   +------+      +---------+    +--------------+    +--------------+
   | REFo |--+-->| EX cell |--->| RDHOK record |--->| BImp record  |---> other
   |    x |  |   | (RDHOK) |    | (BEXVAL/REF) |    | (BEXVAL/REF) |    cluster
   +------+  |   +---------+    |--------------|    +--------------+
             |                  | (HOOK)       |---> Goal record
             |                  +--------------+
             |                                      +--------------+
             +--------------------------------------| WExp record  |<--- other
                                                    | (REFo)       |    cluster
                                                    +--------------+
<ETC>
********************************************************************* PSL **/

#SUBARG_define A_PtrToExCell   SRC
#SUBARG_define A_PtrToBImpRec  SRC
#SUBARG_define A_PtrToSuspGoal SRC

#SUBROUTINE f_Send_IntClMsg_Read_BEX_SingleWait_Sub
                               (A_PtrToExCell, A_PtrToBImpRec, A_PtrToSuspGoal)
{
  @DEBUG{
    s_IfWEXT(A_PtrToBImpRec) {
      VPIM_ERROR("f_Send_IntClMsg_Read_BEX_SingleWait_Sub",
		 "A_PtrToWImpRec is not BEXT");
    }
    s_IfNotHOOK(A_PtrToSuspGoal) {
      s_IfNotRHOOK(A_PtrToSuspGoal) {
	VPIM_ERROR("f_Send_IntClMsg_Read_BEX_SingleWait_Sub",
		   "Illegal A_PtrToSuspGoal");
      }
    }
  };

  s_RecordMsgEncodeStart(); /*** for Processor Profile ***/

  $USE(D_WorkExRefID_Read);
  $USE(D_WorkWEC_Read);

  f_GetExrefIdAndWec_forRead_BEX
           (A_PtrToExCell, A_PtrToBImpRec, D_WorkExRefID_Read, D_WorkWEC_Read);

  b_IfZero(D_WorkWEC_Read){
    /* Request BEX $B$r=P$9(B. $B$3$N>u67$OLGB?$K$J$$(B */
    f_SendPacket_Request_BEXID_BEX(A_PtrToBImpRec, A_PtrToExCell);
    @DEBUG{
      b_IfNotEOL(A_PtrToBImpRec) {
	VPIM_ERROR("f_Send_IntClMsg_Read_BEX_SingleWait_Sub",
		   "invalid bimp_rec");
      } };

    s_AllocRdhokWithGoalAndHookExCell
                        (A_PtrToSuspGoal, A_PtrToBImpRec, A_PtrToExCell);
  } else {
    f_SendPacket_Read_BEX(A_PtrToExCell, D_WorkExRefID_Read, D_WorkWEC_Read);
    b_IfIllegalPointer(A_PtrToBImpRec) { 
/*      f_HookToExCell(A_PtrToSuspGoal, A_PtrToExCell); */
/*
      @DEBUG{WARNING("f_Send_IntClMsg_Read_BEX_SingleWait_Sub","kaihou read");
	   preg(A_PtrToExCell);};
*/
      s_Write_WithUnlockExCell(A_PtrToSuspGoal, A_PtrToExCell);
    } else {
      s_AllocRdhokWithGoalAndHookExCell
	                  (A_PtrToSuspGoal, A_PtrToBImpRec, A_PtrToExCell);
/*
      @DEBUG{WARNING("f_Send_IntClMsg_Read_BEX_SingleWait_Sub","bunkatsu read");};
*/
    }
  }
  $RELEASE(D_WorkExRefID_Read);
  $RELEASE(D_WorkWEC_Read);

  s_RecordMsgEncodeStop(); /*** for Processor Profile ***/

  $RETURN();
}

#PSL_define f_MakeLogicalPacket_Read_BEX
                              (ptr_to_packet, ptr_to_exref, exref_id, wec_reg)
{
  $USE(D_WorkPacketCurrentPtr);
  f_AllocLogicalPacket_Read_BEX(ptr_to_packet, D_WorkPacketCurrentPtr);
  f_Put_Read_BEX_inLogicalPacket
                 (D_WorkPacketCurrentPtr, ptr_to_exref, exref_id, wec_reg);
  f_Put_EOM_inLogicalPacket(D_WorkPacketCurrentPtr);
  $RELEASE(D_WorkPacketCurrentPtr);
}

#PSL_define f_SendPacket_Read_BEX(ptr_to_exref, exref_id, wec_reg)
{
  $USE(D_WorkCLNum);
  s_GetClusterNum(exref_id, D_WorkCLNum);
  $USE(D_WorkPacketSize);
  f_GetPacketSize_Read_BEX(D_WorkPacketSize);
  b_IfNetWorkBufferStatusOK(D_WorkPacketSize) {
    s_RecordMsgSendCountLogMsgTypeImm(_NW_READ);/*** for Processor Profile ***/
    s_Send_PacketHeader_toNetwork(D_WorkCLNum, D_WorkPacketSize);
    f_Send_Read_BEX_toNetwork(ptr_to_exref, exref_id, wec_reg);
    f_Send_EOM_toNetwork();
  } else {
    @DEBUG{WARNING("f_SendPacket_Read_BEX","Network buffer FULL");};
    $USE(D_WorkPtrToPacket);
    f_MakeLogicalPacket_Read_BEX
                        (D_WorkPtrToPacket, ptr_to_exref, exref_id, wec_reg);
    b_AddImmediateWithDNTC
         (D_WorkPacketSize, _SINGLE_PACKET_CONTROL_SIZE, D_WorkPacketSize);
    s_PacketSuspend_Single(D_WorkPtrToPacket, D_WorkPacketSize, D_WorkCLNum);
    $RELEASE(D_WorkPtrToPacket);
  }
  $RELEASE(D_WorkPacketSize);
  $RELEASE(D_WorkCLNum);
}    

/******************************************************************** PSL **
4. $B%G!<%?$NFI$_=P$7MW5a;~$N%a%C%;!<%8Aw?.=hM}(B(%read)
  $BGr30It;2>H!"B?=EBT$A$N>l9g(B

(SUBROUTINE)f_Send_IntClMsg_Read_WEX_MultipleWait_Sub

       written by ttakagi@icot22      on Tue Jun 19 17:40:12 1990

<Arguments>
  A_PtrToExCell:   $B30It;2>H%;%k$X$N%]%$%s%?(B
  A_PtrToWImpRec:  $BGrM"F~%l%3!<%I$X$N%]%$%s%?(B
  A_PtrToSuspGoal: $B30It;2>H%;%k$rFI$b$&$H$7$?%4!<%k$X$N%]%$%s%?(B

<Temporally Used Variables>
<Level>
<PreCondition>
  A_PtrToExCell $B$N@h$O%m%C%/:Q$_(B
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#SUBARG_define A_PtrToExCell   SRC
#SUBARG_define A_PtrToWImpRec  SRC
#SUBARG_define A_PtrToSuspGoal SRC

#SUBROUTINE f_Send_IntClMsg_Read_WEX_MultipleWait_Sub
                               (A_PtrToExCell, A_PtrToWImpRec, A_PtrToSuspGoal)
{
  @DEBUG{
    s_IfBEXT(A_PtrToWImpRec) {
      VPIM_ERROR("f_Send_IntClMsg_Read_WEX_MultipleWait_Sub",
		 "A_PtrToWImpRec is not WEXT");
    }
    s_IfNotHOOK(A_PtrToSuspGoal) { /* MGHOK<->EX unify$B$N$?$a(B */
      s_IfNotMHOOK(A_PtrToSuspGoal) {
	b_IfNotEOL(A_PtrToSuspGoal) { /* ReadEagerly$B$N$?$a(B */
	  VPIM_ERROR("f_Send_IntClMsg_Read_WEX_MultipleWait_Sub",
		     "Illegal A_PtrToSuspGoal");
	}
      }
    }
  };

  s_RecordMsgEncodeStart(); /*** for Processor Profile ***/

  $USE(D_WorkExRefID_Read);
  s_GetExrefIdAndSetUnifyFlagOrReclaimWImpRec_Read
                                          (A_PtrToWImpRec, D_WorkExRefID_Read);
  @DEBUG{
    s_IfUnifyFlagOff(D_WorkExRefID_Read){
      VPIM_ERROR("f_Send_IntClMsg_Read_WEX_MultipleWait_Sub",
		 "invalid exrefid");
    }
  };

  b_IfIllegalPointer(A_PtrToWImpRec) {
    /* Request BEX $B$r=P$9(B */
    f_SendPacket_Request_BEXID_WEX(A_PtrToExCell, D_WorkExRefID_Read);
  } else {
    f_SendPacket_Read_WEX(A_PtrToExCell, D_WorkExRefID_Read);
  }
  s_AllocRdhokWithGoalAndHookExCell
                      (A_PtrToSuspGoal, A_PtrToWImpRec, A_PtrToExCell);
  $RELEASE(D_WorkExRefID_Read);

  s_RecordMsgEncodeStop(); /*** for Processor Profile ***/

  $RETURN();
}

/******************************************************************** PSL **
5. $B%G!<%?$NFI$_=P$7MW5a;~$N%a%C%;!<%8Aw?.=hM}(B(%read)
  $B9u30It;2>H!"B?=EBT$A$N>l9g(B

(SUBROUTINE)f_Send_IntClMsg_Read_BEX_MultipleWait_Sub

       written by ttakagi@icot22      on Tue Jun 19 18:46:07 1990

<Arguments>
  A_PtrToExCell:   $B30It;2>H%;%k$X$N%]%$%s%?(B
  A_PtrToBImpRec:  $B9uM"F~%l%3!<%I$X$N%]%$%s%?(B
  A_PtrToSuspGoal: $B30It;2>H%;%k$rFI$b$&$H$7$?%4!<%k$X$N%]%$%s%?(B

<Temporally Used Variables>
<Level>
<PreCondition>
  A_PtrToExCell $B$N@h$O%m%C%/:Q$_(B
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define  D_WorkDummyPtrToExCell XXX

#SUBARG_define A_PtrToExCell   SRC
#SUBARG_define A_PtrToBImpRec  SRC
#SUBARG_define A_PtrToSuspGoal SRC

#SUBROUTINE f_Send_IntClMsg_Read_BEX_MultipleWait_Sub
                               (A_PtrToExCell, A_PtrToBImpRec, A_PtrToSuspGoal)
{
  @DEBUG{
    s_IfWEXT(A_PtrToBImpRec) {
      VPIM_ERROR("f_Send_IntClMsg_Read_BEX_MultipleWait_Sub",
		 "A_PtrToWImpRec is not BEXT");
    }
    s_IfNotHOOK(A_PtrToSuspGoal) { /* MGHOK<->EX unify$B$N$?$a(B */
      s_IfNotMHOOK(A_PtrToSuspGoal) {
	b_IfNotEOL(A_PtrToSuspGoal) { /* ReadEagerly$B$N$?$a(B */
	  VPIM_ERROR("f_Send_IntClMsg_Read_BEX_MultipleWait_Sub",
		     "Illegal A_PtrToSuspGoal");
	}
      }
    }
  };

  s_RecordMsgEncodeStart(); /*** for Processor Profile ***/

  $USE(D_WorkExRefID_Read);
  $USE(D_WorkWEC_Read);

  $USE(D_WorkDummyPtrToExCell);
  p_MoveWord(A_PtrToExCell, D_WorkDummyPtrToExCell);
  s_MRBonReg(D_WorkDummyPtrToExCell);
  f_GetExrefIdAndWec_forRead_BEX
     (D_WorkDummyPtrToExCell,A_PtrToBImpRec,D_WorkExRefID_Read,D_WorkWEC_Read);
  $RELEASE(D_WorkDummyPtrToExCell);

  b_IfZero(D_WorkWEC_Read){
    /* Request BEX $B$r=P$9(B */
    f_SendPacket_Request_BEXID_BEX(A_PtrToBImpRec, A_PtrToExCell);
  } else {
    f_SendPacket_Read_BEX(A_PtrToExCell, D_WorkExRefID_Read, D_WorkWEC_Read);
  }
  s_AllocRdhokWithGoalAndHookExCell
                        (A_PtrToSuspGoal, A_PtrToBImpRec, A_PtrToExCell);
  $RELEASE(D_WorkExRefID_Read);
  $RELEASE(D_WorkWEC_Read);

  s_RecordMsgEncodeStop(); /*** for Processor Profile ***/

  $RETURN();
}

/******************************************************************** PSL **
6. %read$BAw?.$K$*$1$kJV?.@h$N@8@.(B

f_AllocReturnEntryRead

       written by ttakagi@icot22      on Fri Jun 29 13:42:20 1990

<Arguments>
+ ptr_to_exref: %read$B$r=P$7$?30It;2>H%;%k$X$N%]%$%s%?(B
- exref_id:     $BJV?.@h$N30It;2>H#I#D(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkReturnEntry XXX

#PSL_define f_AllocReturnEntryRead(ptr_to_exref, exref_id)
{
  $USE(D_WorkReturnEntry);
  s_AllocReadReturnWhiteExpEntry(ptr_to_exref, D_WorkReturnEntry); 
  b_BitwiseOrWithTag(D_WEXREF_SAFE_STRUCToff_UNIFYoff_CLnum,
		     D_WorkReturnEntry, exref_id);
  $RELEASE(D_WorkReturnEntry);
}
