/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_int_cl_send_bexid.psl.c
   ----- CREATED   : by ttakagi@icot22, on Fri Nov 29 18:56:18 1991
   ----- LAST SAVED: by ttakagi@icot22, on Fri Jun 12 15:07:48 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : %request_BEXID, %supply_BEXID $B$K4X$9$k=hM}(B
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
1.1  $B9u30It;2>H(BID$B$NMW5a%a%C%;!<%8(B

f_Send_IntClMsg_Request_BEXID

       written by nakase@icot22      on Fri Aug 10 10:45:34 1990

<Arguments>
 ptr_to_imp_rec: $BM"F~%l%3!<%I$X$N%]%$%s%?(B
 ptr_to_exref:   $B30It;2>H%;%k$X$N%]%$%s%?(B

<Packet Format>
$B!J!{30It;2>H#I#D$+$i!|30It;2>H#I#D$X$NJQ49MW5a!K(B

      39       31                              0
       +---------------------------------------+
    1  | DNTC   !  _NW_REQUEST_BEXID_WEX       |
       +---------------------------------------+
    2  | DNTC   !  BEXID$B$rMW5a$9$k30It;2>H#I#D(B |
       +---------------------------------------+
    3  | DNTC   !  BEXID$B$NJV?.@h(B               |
       +---------------------------------------+
    4  |           $B#E#O#M(B                      |
       +---------------------------------------+

$B!J!|30It;2>H#I#D$N#W#E#CMW5a!K(B

      39       31                              0
       +---------------------------------------+
    1  | DNTC   !  _NW_REQUEST_BEXID_BEX       |
       +---------------------------------------+
    2  | DNTC   !  BEXID$B$rMW5a$9$k30It;2>H#I#D(B |
       +---------------------------------------+
    3  | DNTC   !  WEC                         |
       +---------------------------------------+
    4  | DNTC   !  BEXID$B$NJV?.@h(B               |
       +---------------------------------------+
    5  |           $B#E#O#M(B                      |
       +---------------------------------------+

<Function>
  $BGr30It;2>H$K#2$D0J>e$N%a%C%;!<%8$,Aw$i$l$k;~!"(B
  $B9u30It;2>H$N#W#E#C$,#1$K$J$C$?;~!"8F$S=P$5$l$k!#(B

<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkExrefID_ReqBEXID XXX

#PSL_define f_Send_IntClMsg_Request_BEXID(ptr_to_imp_rec, ptr_to_exref)
{
  s_RecordMsgEncodeStart(); /*** for Processor Profile ***/

  TypeSwitch(ptr_to_imp_rec) {
  case WEXREF:
  case WEXVAL:
    $USE(D_WorkExrefID_ReqBEXID);
    s_GetExrefIdAndReclaimWImpRec(ptr_to_imp_rec, D_WorkExrefID_ReqBEXID);
    @DEBUG{
      s_IfUnifyFlagOff(D_WorkExrefID_ReqBEXID) {
	VPIM_ERROR("f_Send_IntClMsg_Request_BEXID", "invalid exrefid");
      }
    };
    f_SendPacket_Request_BEXID_WEX(ptr_to_exref, D_WorkExrefID_ReqBEXID);
    $RELEASE(D_WorkExrefID_ReqBEXID);
    break;
  case BEXREF:
  case BEXVAL:
    f_SendPacket_Request_BEXID_BEX(ptr_to_imp_rec, ptr_to_exref);
    break;
  default:
    @DEBUG{ VPIM_ERROR("f_Send_IntClMsg_Request_BEXID", "invalid type"); };
    break;
  }

  s_RecordMsgEncodeStop(); /*** for Processor Profile ***/
}

/******************************************************************** PSL **
1.2 $BGr30It;2>H$+$i$N9u30It;2>H(BID$BMW5a$N%Q%C%1%H:n@.(B

f_MakeLogicalPacket_Request_BEXID_WEX

       written by nakase@icot22      on Tue Dec  4 11:59:36 1990

<Arguments>
 ptr_to_packet: $B%Q%1%C%H$X$N%]%$%s%?(B
 packet_size  : $B%Q%1%C%H$N%5%$%:(B
 ptr_to_exref : $B9u30It;2>H(BID$BMW5a$r=P$9Gr30It;2>H%;%k$X$N%]%$%s%?(B
 exref_id     : $B9u30It;2>H(BID$BMW5a$r=P$9Gr30It;2>H(BID

<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkPacketCurrentPtr XXX
#DATA_define D_WorkWec_ReqBEXID     XXX

#PSL_define f_MakeLogicalPacket_Request_BEXID_WEX
                                (ptr_to_packet, ptr_to_exref, exref_id)
{
  $USE(D_WorkPacketCurrentPtr);
  f_AllocLogicalPacket_Request_BEXID_WEX(ptr_to_packet,D_WorkPacketCurrentPtr);
  f_Put_Request_BEXID_WEX_inLogicalPacket
                              (D_WorkPacketCurrentPtr, ptr_to_exref, exref_id);
  f_Put_EOM_inLogicalPacket(D_WorkPacketCurrentPtr);
  $RELEASE(D_WorkPacketCurrentPtr);
}

#PSL_define f_SendPacket_Request_BEXID_WEX(ptr_to_exref, exref_id)
{
  $USE(D_WorkCLNum);
  s_GetClusterNum(exref_id, D_WorkCLNum);
  $USE(D_WorkPacketSize);
  f_GetPacketSize_Request_BEXID_WEX(D_WorkPacketSize);
  b_IfNetWorkBufferStatusOK(D_WorkPacketSize) {
    s_RecordMsgSendCountLogMsgTypeImm(_NW_REQUEST_BEXID_WEX);
                                     /*** for Processor Profile ***/
    s_Send_PacketHeader_toNetwork(D_WorkCLNum, D_WorkPacketSize);
    f_Send_Request_BEXID_WEX_toNetwork(ptr_to_exref, exref_id);
    f_Send_EOM_toNetwork();
  } else {
    @DEBUG{WARNING("f_SendPacket_Request_BEXID_WEX","Network buffer FULL");};
    $USE(D_WorkPtrToPacket);
    f_MakeLogicalPacket_Request_BEXID_WEX
                        (D_WorkPtrToPacket, ptr_to_exref, exref_id);
    b_AddImmediateWithDNTC
         (D_WorkPacketSize, _SINGLE_PACKET_CONTROL_SIZE, D_WorkPacketSize);
    s_PacketSuspend_Single(D_WorkPtrToPacket, D_WorkPacketSize, D_WorkCLNum);
    $RELEASE(D_WorkPtrToPacket);
  }
  $RELEASE(D_WorkPacketSize);
  $RELEASE(D_WorkCLNum);
}    

/******************************************************************** PSL **
1.3 $BGr30It;2>H$+$i$N9u30It;2>H(BID$BMW5a$N%Q%C%1%H:n@.(B

f_MakeLogicalPacket_Request_BEXID_BEX

       written by nakase@icot22      on Tue Dec  4 12:04:15 1990

<Arguments>
 ptr_to_packet: $B%Q%1%C%H$X$N%]%$%s%?(B
 packet_size  : $B%Q%1%C%H$N%5%$%:(B
 ptr_to_exref : $B9u30It;2>H(BID$BMW5a$r=P$9Gr30It;2>H%;%k$X$N%]%$%s%?(B
 exref_id     : $B9u30It;2>H(BID$BMW5a$r=P$9Gr30It;2>H(BID

<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define f_MakeLogicalPacket_Request_BEXID_BEX
                        (ptr_to_packet, ptr_to_exref, exref_id, wec_reg)
{
  $USE(D_WorkPacketCurrentPtr);
  f_AllocLogicalPacket_Request_BEXID_BEX(ptr_to_packet,D_WorkPacketCurrentPtr);
  f_Put_Request_BEXID_BEX_inLogicalPacket
                (D_WorkPacketCurrentPtr, ptr_to_exref, exref_id, wec_reg);
  f_Put_EOM_inLogicalPacket(D_WorkPacketCurrentPtr);
  $RELEASE(D_WorkPacketCurrentPtr);
}

#PSL_define f_SendPacket_Request_BEXID_BEX(ptr_to_imp_rec, ptr_to_exref)
{
  $USE(D_WorkExrefID_ReqBEXID);
  $USE(D_WorkWec_ReqBEXID);
  $CALL( s_GetExrefIdAllWecAndReclaimBImpRecforRequestBEX_Sub
                (ptr_to_imp_rec, D_WorkExrefID_ReqBEXID, D_WorkWec_ReqBEXID) );
  $USE(D_WorkCLNum);
  s_GetClusterNum(D_WorkExrefID_ReqBEXID, D_WorkCLNum);
  $USE(D_WorkPacketSize);
  f_GetPacketSize_Request_BEXID_BEX(D_WorkPacketSize);
  b_IfNetWorkBufferStatusOK(D_WorkPacketSize) {
    s_RecordMsgSendCountLogMsgTypeImm(_NW_REQUEST_BEXID_BEX);
                                     /*** for Processor Profile ***/
    s_Send_PacketHeader_toNetwork(D_WorkCLNum, D_WorkPacketSize);
    f_Send_Request_BEXID_BEX_toNetwork
           (ptr_to_exref, D_WorkExrefID_ReqBEXID, D_WorkWec_ReqBEXID);
    f_Send_EOM_toNetwork();
  } else {
    @DEBUG{WARNING("f_SendPacket_Request_BEXID_BEX","Network buffer FULL");};
    $USE(D_WorkPtrToPacket);
    f_MakeLogicalPacket_Request_BEXID_BEX
                        (D_WorkPtrToPacket, ptr_to_exref,
			 D_WorkExrefID_ReqBEXID, D_WorkWec_ReqBEXID);
    b_AddImmediateWithDNTC
         (D_WorkPacketSize, _SINGLE_PACKET_CONTROL_SIZE, D_WorkPacketSize);
    s_PacketSuspend_Single(D_WorkPtrToPacket, D_WorkPacketSize, D_WorkCLNum);
    $RELEASE(D_WorkPtrToPacket);
  }
  $RELEASE(D_WorkPacketSize);
  $RELEASE(D_WorkCLNum);
  $RELEASE(D_WorkWec_ReqBEXID);
  $RELEASE(D_WorkExrefID_ReqBEXID);
}    

/******************************************************************** PSL **
2.1 $B9u30It;2>H(BID$B$NJd5k%a%C%;!<%8(B

f_Send_IntClMsg_Supply_BEXID_Sub

       written by nakase@icot22      on Wed Aug 29 14:36:22 1990

<Arguments>
 A_DataPtr:       
 A_ReturnExrefID:
 A_SafeFlag:

<Packet Format>
      39       31                              0
       +---------------------------------------+
    1  | DNTC   !  _NW_SUPPLY_BEXID            |
       +---------------------------------------+
    2  | DNTC   !  BEXID$B$NJV?.@h(B               |
       +---------------------------------------+
    3  | DNTC   !  $BJd5k$5$l$k9u30It;2>H#I#D(B    |
       +---------------------------------------+
    4  | DNTC   !  WEC                         |
       +---------------------------------------+
    5  |           $B#E#O#M(B                      |
       +---------------------------------------+

<Explanation>
<ETC>
********************************************************************* PSL **/

#SUBARG_define A_DataPtr         MODIFY
#SUBARG_define A_ReturnExrefID   SRC
#SUBARG_define A_SafeFlag        SRC
#SUBARG_define A_StructID        SRC

#SUBROUTINE f_Send_IntClMsg_Supply_BEXID_Sub
                         (A_DataPtr, A_ReturnExrefID, A_SafeFlag, A_StructID)
{
  s_RecordMsgEncodeStart(); /*** for Processor Profile ***/
  $USE(D_WorkCLNum);
  s_GetClusterNum(A_ReturnExrefID, D_WorkCLNum);
  f_SendPacket_Supply_BEXID
        (A_DataPtr, A_ReturnExrefID, D_WorkCLNum, A_SafeFlag, A_StructID);
  $RELEASE(D_WorkCLNum);
  s_RecordMsgEncodeStop(); /*** for Processor Profile ***/
  $RETURN();
}

/******************************************************************** PSL **
2.2 %supply_BEXID $B$NO@M}%Q%1%C%H$r:n@.$9$k(B

f_MakeLogicalPacket_Supply_BEXID

       written by ttakagi@icot22      on Mon Dec 16 14:07:29 1991

<Arguments>
- ptr_to_packet: $B:n@.$7$?O@M}%Q%1%C%H$X$N%]%$%s%?(B
- packet_size:   $BO@M}%Q%1%C%H$N%5%$%:(B
+ data_ptr:      
+ ret_exref_id:
+ cl_num:
- safe_flag:

<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define f_MakeLogicalPacket_Supply_BEXID
        (ptr_to_packet, data_ptr, ret_exref_id, cl_num, safe_flag, struct_id)
{
  $USE(D_WorkPacketCurrentPtr);
  f_AllocLogicalPacket_Supply_BEXID(ptr_to_packet, D_WorkPacketCurrentPtr);
  f_Put_Supply_BEXID_inLogicalPacket
           (D_WorkPacketCurrentPtr, data_ptr,
	    ret_exref_id, cl_num, safe_flag, struct_id);
  f_Put_EOM_inLogicalPacket(D_WorkPacketCurrentPtr);
  $RELEASE(D_WorkPacketCurrentPtr);
}

#PSL_define f_SendPacket_Supply_BEXID
                     (data_ptr, ret_exref_id, cl_num, safe_flag, struct_id)
{
  $USE(D_WorkPacketSize);
  f_GetPacketSize_Supply_BEXID(D_WorkPacketSize);
  b_IfNetWorkBufferStatusOK(D_WorkPacketSize) {
    s_RecordMsgSendCountLogMsgTypeImm(_NW_SUPPLY_BEXID);
                                     /*** for Processor Profile ***/
    s_Send_PacketHeader_toNetwork(cl_num, D_WorkPacketSize);
    f_Send_Supply_BEXID_toNetwork
           (data_ptr, ret_exref_id, cl_num, safe_flag, struct_id);
    f_Send_EOM_toNetwork();
  } else {
    @DEBUG{WARNING("f_SendPacket_Supply_BEXID","Network buffer FULL");};
    $USE(D_WorkPtrToPacket);
    f_MakeLogicalPacket_Supply_BEXID
      (D_WorkPtrToPacket, data_ptr,
       ret_exref_id, cl_num, safe_flag, struct_id);
    b_AddImmediateWithDNTC
         (D_WorkPacketSize, _SINGLE_PACKET_CONTROL_SIZE, D_WorkPacketSize);
    s_PacketSuspend_Single(D_WorkPtrToPacket, D_WorkPacketSize, cl_num);
    $RELEASE(D_WorkPtrToPacket);
  }
  $RELEASE(D_WorkPacketSize);
}    
