
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_int_cl_send_answer_value.psl.c
   ----- CREATED   : by ttakagi@icot22, on Fri Jun 22 19:55:48 1990
   ----- LAST SAVED: by ttakagi@icot22, on Mon Jun 15 19:38:27 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : functions
   ----- ABSTRACT  : %answer_value$BAw?.=hM}(B

<$BO@M}%Q%1%C%H$N7A<0(B>

      39         32                            0
       +---------------------------------------+
    1  |DNTC      |AnswerValue$B$N%a%C%;!<%8<oJL(B |
       +---------------------------------------+
    2  |WEXREF/VAL|$BJV?.@h$N%/%i%9%?Fb#I#D(B      |
       +---------------------------------------+
    3  |$B%?%0(B      |$BJV?.$5$l$k%G!<%?(B            |
       /                                       /
       +---------------------------------------+
       |DNTC      |   End of Message           |
       +---------------------------------------+

<$BDj5A%^%/%m(B>
  1. %read$B$KBP$9$k1~Ez%a%C%;!<%8Aw?.=hM}(B(%answer_value)
     (SUBROUTINE) f_Send_IntClMsg_AnswerValue_Sub
  2. %answer_value$B%a%C%;!<%8$NO@M}%Q%1%C%H$r:n$k(B
     f_MakeLogicalPacket_AnswerValue

 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
1. %read$B$KBP$9$k1~Ez%a%C%;!<%8Aw?.=hM}(B(%answer_value)

(SUBROUTINE) f_Send_IntClMsg_AnswerValue_Sub

       written by ttakagi@icot22      on Fri Jun 22 19:58:04 1990

<Arguments>
  A_ReturnExrefID:    $BJV?.@h$N30It;2>H#I#D(B
  A_PtrToAnswerValue: $BJV?.$9$k%G!<%?$X$N%]%$%s%?(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkPacketSize      XXX
#DATA_define D_WorkPtrToMsgSuspRec XXX

#SUBARG_define A_ReturnExrefID  SRC
#SUBARG_define A_AnswerValue    MODIFY

#SUBROUTINE f_Send_IntClMsg_AnswerValue_Sub(A_ReturnExrefID, A_AnswerValue)
{
  $USE(D_WorkPtrToPacket);
  $USE(D_WorkCLNum);
  $USE(D_WorkPacketSize);

  s_RecordMsgEncodeStart(); /*** for Processor Profile ***/

  f_MakeLogicalPacket_AnswerValue(D_WorkPtrToPacket, A_ReturnExrefID,
				A_AnswerValue, D_WorkCLNum, D_WorkPacketSize);
  b_IfIllegalPointer(D_WorkPtrToPacket) {
    $USE(D_WorkExCellPtr);
    $USE(D_WorkReg);
    s_AllocWhiteImpRecAndExCell_forAnsVal(A_ReturnExrefID, D_WorkReg);
    p_Read(D_WorkReg, D_WorkExCellPtr);
    $RELEASE(D_WorkReg);
    /* Send answer_value $B$N%5%9%Z%s%I=hM}(B */
    @DEBUG{ WARNING("f_Send_IntClMsg_AnswerValue_Sub","Message Suspend"); };
    $USE(D_WorkPtrToMsgSuspRec);
    s_AllocMsgSuspRec(D_WorkPtrToMsgSuspRec);
    s_PutSuspMsgID_MsgSuspRec
                   (_MSG_SUSP_SEND_ANSWER_VALUE, D_WorkPtrToMsgSuspRec);
    s_PutMsgInfo1_MsgSuspRec(D_WorkExCellPtr, D_WorkPtrToMsgSuspRec);
    $RELEASE(D_WorkExCellPtr);
    s_PutMsgInfo2_MsgSuspRec(A_AnswerValue, D_WorkPtrToMsgSuspRec);
    s_PushMsgSuspRec(D_WorkPtrToMsgSuspRec);
    $RELEASE(D_WorkPtrToMsgSuspRec);
  } else {
    $CALL( s_SendPacket_Sub(D_WorkPtrToPacket, D_WorkPacketSize, D_WorkCLNum));
  }

  s_RecordMsgEncodeStop(); /*** for Processor Profile ***/

  $RELEASE(D_WorkPtrToPacket);
  $RELEASE(D_WorkCLNum);
  $RELEASE(D_WorkPacketSize);
  $RETURN();
}

/******************************************************************** PSL **
2. %answer_value$B%a%C%;!<%8$NO@M}%Q%1%C%H$r:n$k(B($B%7%s%0%k%Q%1%C%H$N;~(B)

f_MakeLogicalPacket_AnswerValue

       written by ttakagi@icot22      on Thu Aug  9 14:29:43 1990

<Arguments>
-  ptr_to_packet:   $BO@M}%Q%1%C%H$X$N%]%$%s%?(B
+  exref_id:        $BJV?.@h$N30It;2>H#I#D(B
+  ptr_to_data:     $BJV?.$9$k%G!<%?$X$N%]%$%s%?(B
-  cluster_num_reg: $BJV?.@h%/%i%9%?HV9f(B
-  packet_size_reg: $BO@M}%Q%1%C%H$N%5%$%:(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define f_MakeLogicalPacket_AnswerValue(ptr_to_packet, exref_id, ptr_to_data, cluster_num_reg, packet_size_reg)
{
  $USE(D_WorkCurrentPtr_inLogicalPacket);
  f_AllocLogicalPacket_AnswerValue
           (ptr_to_packet, D_WorkCurrentPtr_inLogicalPacket, ptr_to_data);
  b_IfNotIllegalPointer(ptr_to_packet) {
    s_GetClusterNum(exref_id, cluster_num_reg);
    f_Put_AnswerValue_inLogicalPacket
                     (D_WorkCurrentPtr_inLogicalPacket, exref_id, ptr_to_data,
		      cluster_num_reg);
    f_Put_EOM_inLogicalPacket(D_WorkCurrentPtr_inLogicalPacket);
    s_GetPacketSize
            (ptr_to_packet, D_WorkCurrentPtr_inLogicalPacket, packet_size_reg);
  }
  $RELEASE(D_WorkCurrentPtr_inLogicalPacket);
}

/******************************************************************** PSL **
3. %Answer_Value$B$G9=B$BN(BID$B$N$_$rJV$9;~$N=hM}!#(B

       written by nakase@icot22      on Tue Nov 27 17:05:47 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#SUBARG_define A_ReturnExrefID    SRC
#SUBARG_define A_AnswerValue MODIFY

#SUBROUTINE f_Send_IntClMsg_AnswerValue_StrID_Sub(A_ReturnExrefID, 
						  A_AnswerValue)
{
  $USE(D_WorkPtrToPacket);
  $USE(D_WorkCLNum);
  $USE(D_WorkPacketSize);
  f_MakeLogicalPacket_AnswerValue_StrID(D_WorkPtrToPacket, A_ReturnExrefID,
			    A_AnswerValue, D_WorkCLNum, D_WorkPacketSize);
  $CALL( s_SendPacket_Sub(D_WorkPtrToPacket, D_WorkPacketSize, D_WorkCLNum) );
  $RELEASE(D_WorkPtrToPacket);
  $RELEASE(D_WorkCLNum);
  $RELEASE(D_WorkPacketSize);
  $RETURN();
}

#PSL_define f_MakeLogicalPacket_AnswerValue_StrID(ptr_to_packet, exref_id, ptr_to_data, cluster_num_reg, packet_size_reg)
{
  $USE(D_WorkCurrentPtr_inLogicalPacket);
  f_AllocLogicalPacket_AnswerValue
                (ptr_to_packet, D_WorkCurrentPtr_inLogicalPacket, ptr_to_data);
  s_GetClusterNum(exref_id, cluster_num_reg);
  f_Put_AnswerValue_StrID_inLogicalPacket
                     (D_WorkCurrentPtr_inLogicalPacket, exref_id, ptr_to_data,
		      cluster_num_reg);
  f_Put_EOM_inLogicalPacket(D_WorkCurrentPtr_inLogicalPacket);
  s_GetPacketSize
            (ptr_to_packet, D_WorkCurrentPtr_inLogicalPacket, packet_size_reg);
  $RELEASE(D_WorkCurrentPtr_inLogicalPacket);
}
