
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_int_cl_recv_unify.psl.c
   ----- CREATED   : by nakase@icot22, on Tue Jun 19 21:45:40 1990
   ----- LAST SAVED: by ttakagi@icot22, on Fri Jun 12 18:04:54 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : %unify$B%a%C%;!<%8$N<u?.=hM}(B
  
<Message Format in VPIM>

      39       31                              0
       +---------------------------------------+
    0  | DNTC   !  $B%a%C%;!<%8<oJL(B(_NW_UNIFY)   |
       +---------------------------------------+
    1  | DNTC   !  $BAq1`#I#D(B                    |
       +---------------------------------------+
    2  | DNTC   !  $B#W#T#C(B                      |
       +---------------------------------------+
    3  | DNTC   !  $B%+%l%s%H%W%i%$%*%j%F%#(B      |
       +---------------------------------------+
    4  | D_ONE or D_NULL !  Profiling flag     |
       +---------------------------------------+ \
    5  | DNTC   !  $B:G>.%N!<%IHV9f(B              |
       +---------------------------------------+   $B6u4V>pJs(B
    6  | DNTC   !  $B%N!<%I?t(B                    |
       +---------------------------------------+ /
       |        !  $BBh#10z?t(B                    |
       /                                       /
       +---------------------------------------+
       |        !  $BBh#20z?t(B                    |
       /                                       /
       +---------------------------------------+

 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
1. %unify$B%a%C%;!<%8$N<u?.=hM}(B

f_Recv_IntClMsg_Unify_Sub

       written by nakase@icot22      on Tue Jun 19 21:46:49 1990

<Arguments>
  A_PacketPtr: $B<u?.$7$?%Q%1%C%H!JO@M}%Q%1%C%H!K$X$N%]%$%s%?(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkUnifyWTC    XXX
#DATA_define D_WorkUnifyPrio   XXX
#DATA_define D_WorkSuccessFlag XXX
#DATA_define D_WorkNodeNum_inNW XXX
#DATA_define D_WorkNodeCnt_inNW XXX

#SUBARG_define A_PacketPtr     MODIFY
#SUBARG_define A_RealPacketPtr SRC
#SUBARG_define A_FlagReg       DST

#SUBROUTINE f_Recv_IntClMsg_Unify_Sub
                   (A_PacketPtr, A_RealPacketPtr, A_FlagReg)
{
  $USE(D_WorkShoenID);    $USE(D_WorkUnifyWTC);    $USE(D_WorkUnifyPrio);
  $USE(D_WorkUnifyArg1);  $USE(D_WorkUnifyArg2);
  $USE(D_WorkLogicalPacketPtr);
  $USE(D_WorkProfilingFlag);
  $USE(D_WorkNodeNum_inNW);    $USE(D_WorkNodeCnt_inNW);

  /* $B%a%C%;!<%8%5%9%Z%s%I$N$3$H$r9M$($F!"(BA_PacketPtr$B$r<h$C$F$*$/(B */
  p_MoveWord(A_PacketPtr, D_WorkLogicalPacketPtr);

  f_Get_ShoenID_fromLogicalPacket(D_WorkLogicalPacketPtr, D_WorkShoenID);
  f_Get_WTC_fromLogicalPacket(D_WorkLogicalPacketPtr, D_WorkUnifyWTC);
  f_Get_Prio_fromLogicalPacket(D_WorkLogicalPacketPtr, D_WorkUnifyPrio);
  f_Get_ProfilingFlag_fromLogicalPacket
                      (D_WorkLogicalPacketPtr, D_WorkProfilingFlag);
  f_Get_PartitionInfo_fromLogicalPacket
        (D_WorkLogicalPacketPtr, D_WorkNodeNum_inNW, D_WorkNodeCnt_inNW);

  f_Get_UnifyArg1_fromLogicalPacket(D_WorkLogicalPacketPtr, D_WorkUnifyArg1);

  $CALL( f_Get_Data_Level1_fromLogicalPacket_Sub
	            (D_WorkLogicalPacketPtr, D_WorkUnifyArg2, D_VOID) );
  $RELEASE(D_WorkLogicalPacketPtr);

  b_IfIllegalPointer(D_WorkUnifyArg2) {
    $USE(D_WorkMsgSuspRec);
    s_AllocMsgSuspRec(D_WorkMsgSuspRec);
    s_PutSuspMsgID_MsgSuspRec(_MSG_SUSP_RECV_PACKET, D_WorkMsgSuspRec);
    s_PutMsgInfo1_MsgSuspRec(A_RealPacketPtr, D_WorkMsgSuspRec);
    s_PutMsgInfo2_MsgSuspRec(D_NULL, D_WorkMsgSuspRec); /* $BG0$N$?$a(B */
    s_PushMsgSuspRec(D_WorkMsgSuspRec);
    $RELEASE(D_WorkMsgSuspRec);
    p_MoveWord(D_ONE, A_FlagReg);
    goto MSG_SUSP_LABEL;
  }

  $USE(D_WorkSuccessFlag);
  $CALL( f_SuccessCheckRecvUnify_Sub
	               (D_WorkUnifyArg1, D_WorkUnifyArg2, D_WorkSuccessFlag) );

  b_IfEqual(D_WorkSuccessFlag, D_ONE) {
    /* Compare&Swap $B$@$1$G%f%K%U%!%$$G$-$J$+$C$?>l9g$N=hM}(B */
    $RELEASE(D_WorkSuccessFlag);
    $USE(D_WorkFPPtr);
    s_RecordMsgDecodeStop(); /*** for Processor Profile ***/
    f_Get_FP_Ptr_Unify
                 (D_WorkFPPtr, D_WorkShoenID, D_WorkUnifyWTC, D_WorkUnifyPrio,
		  D_WorkProfilingFlag, D_WorkNodeNum_inNW, D_WorkNodeCnt_inNW);
    s_RecordMsgDecodeStart(); /*** for Processor Profile ***/
    $USE(D_WorkNewGR);
    $USE(D_WorkDcodeaddr);
    f_GetDcodeAddress(DCODE_UNIFY_RETRY,D_WorkDcodeaddr);
    s_AllocAndInitNoDebugShortGoalRecord
      (D_WorkNewGR,_TWO,D_WorkDcodeaddr,D_WorkUnifyPrio,
       _EMIGRANT_CLUSTER,D_WorkFPPtr);
    $RELEASE(D_WorkDcodeaddr);

/*    @DEBUG{WARNING("f_Recv_IntClMsg_Unify_Sub","unify_retry");
	   preg(D_WorkNewGR);}; */

    f_Put2ArgsGoalRecord(D_WorkNewGR, D_WorkUnifyArg1, D_WorkUnifyArg2);
    $RELEASE(D_WorkUnifyArg1);
    $RELEASE(D_WorkUnifyArg2);
    $CALL( f_PushGoalToStackWithPriority_Sub(D_WorkNewGR, D_WorkUnifyPrio));
        /* $B<B:]$N%f%K%U%#%1!<%7%g%s$O%f%K%U%!%$$N#D%3!<%I$,9T$&(B */
    $RELEASE(D_WorkFPPtr);
    $RELEASE(D_WorkNewGR);
  } else {
    $RELEASE(D_WorkSuccessFlag);
    $RELEASE(D_WorkUnifyArg1);
    $RELEASE(D_WorkUnifyArg2);
    s_RecordMsgDecodeStop(); /*** for Processor Profile ***/
    f_ReturnWTC_Scc_Unify(D_WorkShoenID, D_WorkUnifyWTC);
    s_RecordMsgDecodeStart(); /*** for Processor Profile ***/
    /* %Unify$B$KIU$$$F$-$?(BWTC$B$rN$?F$KLa$9A`:n!#(B*/
  }

 MSG_SUSP_LABEL:
  $RELEASE(D_WorkShoenID);
  $RELEASE(D_WorkUnifyWTC);
  $RELEASE(D_WorkUnifyPrio);
  $RELEASE(D_WorkProfilingFlag);
  $RELEASE(D_WorkNodeNum_inNW);
  $RELEASE(D_WorkNodeCnt_inNW);

  $RETURN();
}

/******************************************************************** PSL **
2. Dcode$B$r:n$i$J$/$F$b$G$-$k%f%K%U%!%$$N%A%'%C%/(B
   $B%f%K%U%!%$$G$-$k>l9g$O!"$d$C$F$7$^$&!#(B

f_SuccessCheckRecvUnify_Sub

       written by nakase@icot22      on Tue Jun 19 22:38:04 1990

<Arguments>
  A_UnifyArg1:   $B%f%K%U%!%$$NBh#10z?t(B
  A_UnifyArg2:   $B%f%K%U%!%$$NBh#20z?t(B
  A_SuccessFlag: Compare&Swap$B$G%f%K%U%!%$$G$-$?$+$I$&$+$N%U%i%0(B
                   $B@.8y(B --> D_NULL     $B<:GT(B --> D_ONE

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkArg1Ptr XXX
#DATA_define D_WorkArg2Ptr XXX

#SUBARG_define A_UnifyArg1   MODIFY
#SUBARG_define A_UnifyArg2   MODIFY
#SUBARG_define A_SuccessFlag DST

#SUBROUTINE f_SuccessCheckRecvUnify_Sub
                                      (A_UnifyArg1, A_UnifyArg2, A_SuccessFlag)
{
  $USE(D_WorkArg1Ptr);
  f_ActiveDeref(A_UnifyArg1, D_WorkArg1Ptr);
  TypeSwitch(A_UnifyArg1) {
  case UNDF:
  case HookGrp(): 
    @DEBUG{
      VPIM_ERROR("f_SuccessCheckRecvUnify_Sub","Invalid Arg1 Tag");
    };
    break;
  case ExpVarGrp():
    $USE(D_WorkArg2Ptr);
    f_ActiveDeref(A_UnifyArg2, D_WorkArg2Ptr);
    TypeSwitch(A_UnifyArg2) {
    case ConstantGroup():  case StructureGroup():
    case COD: case MOD:
      f_IfFailActUnifyWithPtrMRBX(D_WorkArg1Ptr, A_UnifyArg1, A_UnifyArg2) {
        p_MoveWord(D_ONE, A_SuccessFlag);
      } else {
        TypeSwitch(A_UnifyArg1) {
        case HookGrp():  case EHOOK:  case EMHOK:  case RHOOK:
	  s_RecordMsgDecodeStop(); /*** for Processor Profile ***/
          $CALL( f_WakeUpProcess_Sub(A_UnifyArg1) );
	  s_RecordMsgDecodeStart(); /*** for Processor Profile ***/
	  break;
        default:  break;
        }
        p_MoveWord(D_NULL, A_SuccessFlag);
      }
      break;
    case UnboundGroup():
      p_MoveWord(D_ONE, A_SuccessFlag);
      p_MoveWord(D_WorkArg2Ptr, A_UnifyArg2);
      break;
    default:
      p_MoveWord(D_ONE, A_SuccessFlag);
      p_MoveWord(D_WorkArg2Ptr, A_UnifyArg2);
      break;
    }
    $RELEASE(D_WorkArg2Ptr);
    p_MoveWord(D_WorkArg1Ptr, A_UnifyArg1);
    break;
  case ConstantGroup():
  case StructureGroup():
  case MOD: case COD:
    $USE(D_WorkArg2Ptr);
    f_ActiveDeref(A_UnifyArg2, D_WorkArg2Ptr);
    TypeSwitch(A_UnifyArg2) {
    case ConstantGroup():  case StructureGroup():
      p_MoveWord(D_ONE, A_SuccessFlag);  break;
    case UNDF:
    case HookGrp():  
      @DEBUG{
	VPIM_ERROR("f_SuccessCheckRecvUnify_Sub","Invalid Arg2 Tag");
      };
      break;
    case ExpVarGrp():
      f_IfFailActUnifyWithPtrMRBX(D_WorkArg2Ptr, A_UnifyArg2, A_UnifyArg1) {
        p_MoveWord(D_ONE, A_SuccessFlag);
      } else {
	TypeSwitch(A_UnifyArg2){
 	case HookGrp():
	case EHOOK:
	case EMHOK:
	case RHOOK:
	  s_RecordMsgDecodeStop(); /*** for Processor Profile ***/
          $CALL( f_WakeUpProcess_Sub(A_UnifyArg2) );
	  s_RecordMsgDecodeStart(); /*** for Processor Profile ***/
	  break;
	default:  break;
        }
	p_MoveWord(D_NULL, A_SuccessFlag);
      }
      p_MoveWord(D_WorkArg2Ptr, A_UnifyArg2);  break;
    case ExternalGrp():
    case StreamGrp():
    case VOID:
      p_MoveWord(D_ONE, A_SuccessFlag);
      p_MoveWord(D_WorkArg2Ptr, A_UnifyArg2);
      break;
    default:
      p_MoveWord(D_ONE, A_SuccessFlag);
      p_MoveWord(D_WorkArg2Ptr, A_UnifyArg2);
      break;
    }
    $RELEASE(D_WorkArg2Ptr);
    break;
  case ExternalGrp():
  case StreamGrp():
  case VOID:
    p_MoveWord(D_ONE, A_SuccessFlag);
    p_MoveWord(D_WorkArg1Ptr, A_UnifyArg1);
    break;
  default:
    p_MoveWord(D_ONE, A_SuccessFlag);
    p_MoveWord(D_WorkArg1Ptr, A_UnifyArg1);
    break;
  }
  $RELEASE(D_WorkArg1Ptr);
  $RETURN();
}


/******************************************************************** PSL **
3. %unify$B<u?.;~$K!"N$?F$X$N%]%$%s%?$rF@$k(B

f_Get_FP_Ptr_Unify

       written by nakase@icot22      on Tue Jun 19 16:46:46 1990

<Arguments>
  fp_ptr:           $BN$?F$X$N%]%$%s%?!J=PNO!K(B
  shoen_id_reg:     $BAq1`#I#D!J%l%8%9%?F~NO!K(B
  wtc_reg:          $B#W#T#C!J%l%8%9%?F~NO!K(B
  prio_reg:         $B%W%i%$%*%j%F%#!J%l%8%9%?F~NO!K(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
$B!&Aq1`#I#D$G<($5$l$kN$?F$,L5$1$l$P!"?7$7$/%"%m%1!<%H$9$k!#(B
  fp_ptr$B$KN$?F$X$N%]%$%s%?$,JV$k(B
$B!&4{$KB8:_$7$F$$$l$P!"(Bfp_ptr$B$KN$?F$X$N%]%$%s%?$rJV$9!#(B

$B!NN$?F%l%3!<%I$,%/%i%9%?Fb$KM-$k$+H]$+$N8!:w<j=g!O(B

$B!&Aq1`#I#D$r%-!<$H$7$F!"9uM"=P%O%C%7%eI=%(%s%H%j$K%=%U%H%m%C%/$r3]$1$k!#(B
$B!&%O%C%7%e%A%'!<%s$rC)$C$FAq1`#I#D$rC5$9!#(B
{ $BAq1`#I#D$,8+$D$+$C$?>l9g(B }
  $B!&N$?F%l%3!<%I$K%m%C%/$r3]$1$k!#(B
  $B!&#W#T#C$rA}$d$9!#(B
  $B!&N$?F$N(Bchild_count$B$r0l$DA}$d$9!#(B
  $B!&N$?F%l%3!<%I$N%m%C%/$r30$9!#(B

{ $BAq1`#I#D$,8+$D$+$i$J$+$C$?>l9g(B }

<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkMinNodeNum XXX
#DATA_define D_WorkNodeCount  XXX

#PSL_define f_Get_FP_Ptr_Unify
    (fp_ptr, shoen_id_reg, wtc_reg, prio_reg, profile_flag, node_num, node_cnt)
{
  $USE(D_WorkLeftWTC);
  $USE(D_WorkAssignChildCnt);
  p_MoveWord(D_ONE, D_WorkAssignChildCnt);
  $CALL( s_GetFPRecPtrAndAllocBImpRecWithWTC_Sub(shoen_id_reg, wtc_reg,
						 D_WorkAssignChildCnt,
						 fp_ptr, D_WorkLeftWTC) );
  $RELEASE(D_WorkAssignChildCnt);
  b_IfEqual(wtc_reg, D_WorkLeftWTC) {
                     /* $BN$?F$KM?$($?#W#T#C$H!">e$N=hM}$,=*$C$?;~$NN$?F$N#W#T#C(B
		      * $B$,Ey$7$+$C$?>l9g!#(B
		      *	  --->  $B?7$?$KN$?F$r@8@.$7$?>l9g!#(B
                      *
		      *	s_GetFPRecPtrAllocBImpRecWithWtcAnd_Sub$B$N0z?t$K!"N$?F(B
                      * $B$r@8@.$7$?$+H]$+$N0z?t$r$D$1$F$bNI$$!#(B
                      */
  /** $B3F%9%m%C%H$N=i4|2=(B **/
    $USE(D_WorkFPOrgLockTagReg);
    s_LockFPRecord(fp_ptr, D_WorkFPOrgLockTagReg);

    b_IfEqual(profile_flag, D_ONE) {
      f_InitFPSlots(fp_ptr, _FP_INIT_PROFILING, _FP_STARTED,
		    _FP_RSC_EXHAUSTED_FLAG, D_ONE, 
		    prio_reg, prio_reg, node_num, node_cnt);
    } else {
      f_InitFPSlots(fp_ptr, _FP_INIT_NO_PROFILING, _FP_STARTED,
		    _FP_RSC_EXHAUSTED_FLAG, D_ONE,
		    prio_reg, prio_reg, node_num, node_cnt);
    }

    s_EnsureFPExistance(fp_ptr, D_ONE);
    /* %ready $B$N(B send $B$N=*$j$^$G$N%j%U%!%l%s%9%+%&%s%H$H$7$F>e$2$F$$$k!#(B */
    s_UnlockFPRecord(fp_ptr, D_WorkFPOrgLockTagReg);
    $RELEASE(D_WorkFPOrgLockTagReg);
    $CALL (f_Send_IntClMsg_Ready_Sub(fp_ptr) );/* %ready $B$N(B send */
  }
    /*   $BN$?F$,$9$G$KB8:_$7$F$$$?>l9g$O!"2?$b$7$J$/$FNI$$(B */
  $RELEASE(D_WorkLeftWTC);
}

/******************************************************************** PSL **
4. $B%f%K%U%!%$$,@.8y$7$?;~!"Aw$i$l$F$-$?#W#T#C$rJV$9(B

f_ReturnWTC_Scc_Unify

       written by nakase@icot22      on Mon Sep  3 16:34:22 1990

<Arguments>
  shoen_id_reg: $BAq1`#I#D(B($B#W#T#C$rJV$9@h(B)
  wtc_reg:      $B#W#T#C(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define f_ReturnWTC_Scc_Unify(shoen_id_reg, wtc_reg)
{
  $USE(D_WorkFPPtr);
  $USE(D_WorkAssignChildCnt);
  $USE(D_WorkLeftWTC);
  p_MoveWord(D_NULL, D_WorkAssignChildCnt);
  $CALL ( s_GetFPRecPtrAndAddChildCountIfExist_Sub(shoen_id_reg, wtc_reg, 
  		           D_WorkAssignChildCnt, D_WorkFPPtr, D_WorkLeftWTC) );
  b_IfIllegalPointer(D_WorkFPPtr) {
    $CALL( f_Send_IntClMsg_Return_WTC_Sub(shoen_id_reg, wtc_reg) );
    @DEBUG{
      WARNING("f_ReturnWTC_Scc_Unify",
	      "Unify opt success but no fp... WTC return");
    };
  }
  $RELEASE(D_WorkLeftWTC);
  $RELEASE(D_WorkAssignChildCnt);
  $RELEASE(D_WorkFPPtr);
}


