
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_int_cl_recv_read.psl.c
   ----- CREATED   : by nakase@icot22, on Wed Jun 20 11:05:57 1990
   ----- LAST SAVED: by ttakagi@icot22, on Mon Jun 15 19:37:00 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : FUNCTIONS
   ----- ABSTRACT  : %Read $B%a%C%;!<%8$N<u?.=hM}(B
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
1.  f_Recv_IntClMsg_Read_Sub

       written by nakase@icot22      on Wed Jun 20 11:07:34 1990
<Arguments>
  A_PacketPtr: $B<u?.$7$?%Q%1%C%H!JO@M}%Q%1%C%H!K$X$N%]%$%s%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
$B!&(B %Read$B%a%C%;!<%8$N<u?.A`:n(B

  (1) $BJV?.$9$k%G!<%?$,6qBN2=$5$l$F$$$?;~(B ---> $BB(;~$K(B%Answer_Value$B$GJV?.$9$k(B
         
  (2) $BJV?.$9$k%G!<%?$,JQ?t$@$C$?;~(B ---> Reply_Hook $B$9$k(B

$B!&(B $BJV?.$9$k%G!<%?$,9=B$BN4IM}$NBP>]$N%G!<%?$@$C$?;~(B

  (1) %Read$B%a%C%;!<%8$N30It;2>H(BID$B$K9=B$BN%U%i%0$,N)$C$F$$$?;~(B
           --- > $BJV?.$9$k%G!<%?$r%l%Y%k#1M"=P$9$k(B

  (2) %Read$B%a%C%;!<%8$N30It;2>H(BID$B$K9=B$BN%U%i%0$,N)$C$F$$$J$+$C$?;~(B
           --- > $BJV?.$9$k%G!<%?$r%l%Y%k#0M"=P$9$k(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define	D_WorkReadData		XXX
#DATA_define	D_WorkReplyRec		XXX
#DATA_define	D_WorkReturnExRefID	XXX
#DATA_define	D_WorkRhookRes		XXX
#DATA_define    D_WorkStrFlag           XXX

#SUBARG_define A_PacketPtr MODIFY

#SUBROUTINE f_Recv_IntClMsg_Read_Sub(A_PacketPtr)
{
  $USE(D_WorkReadData);
  $USE(D_WorkStrFlag);
  f_Get_ReadData_fromLogicalPacket(A_PacketPtr, D_WorkReadData, D_WorkStrFlag);
     /* $B<u?.$7$?30It;2>H#I#D!J#W#E#C!K$+$i!"M"=P%l%3!<%I$X$N%]%$%s%?$rF@$k(B */
     /* D_WorkStrFlag$B$K$O!"<u?.$7$?30It;2>H(BID$B$N9=B$BN%U%i%0$NM-L5$,F~$k!#(B  */
  $USE(D_WorkReturnExRefID);
  f_Get_ReturnExRefID_fromLogicalPacket(A_PacketPtr, D_WorkReturnExRefID);
     /* $BJV?.@h$N!JGr!K30It;2>H#I#D$rF@$k(B */

  $USE(D_Workreg1);
RetryLabel1:
  f_PassiveDeref(D_WorkReadData, D_Workreg1);
  TypeSwitch(D_WorkReadData){
    case ConstantGroup():
    case StructureGroup():
    case COD:      /* $BJQ?t%0%k!<%W0J30$J$i$PD>$A$KJV?.$9$k(B */
      $RELEASE(D_Workreg1);
      s_RecordMsgDecodeStop(); /*** for Processor Profile ***/
      $CALL( f_Send_IntClMsg_AnswerValue_Sub
	                     (D_WorkReturnExRefID, D_WorkReadData) );
      s_RecordMsgDecodeStart(); /*** for Processor Profile ***/
      $RELEASE(D_WorkReadData);
      break;
    case MOD:
      $RELEASE(D_Workreg1);
      s_RecordMsgDecodeStop(); /*** for Processor Profile ***/
      b_IfEqualImm(D_WorkStrFlag, _ONE){
         /* $B9=B$BN%U%i%0$,(B on $B$N$b$N$+$i(B %read $B$,Mh$?;~$O!"D>$A$K%l%Y%k#1(B
            $BM"=P$GJV?.$9$k(B */
	$CALL( f_Send_IntClMsg_AnswerValue_Sub
	                       (D_WorkReturnExRefID, D_WorkReadData) );
      } else {
         /* $B9=B$BN%U%i%0$,(B off $B$N$b$N$+$i(B %read $B$,Mh$?$N$K!"JV?.BP>]$,(B
	    $B9=B$BN4IM}$r$9$k$b$N$N;~$O!"%l%Y%k#0M"=P$GJV?.$9$k!#(B
	    ---> $B9=B$BN(BID$B$H9=B$BN$X$N30It;2>H$N$_$rJV$9!#(B */
	$CALL( f_Send_IntClMsg_AnswerValue_StrID_Sub
	                       (D_WorkReturnExRefID, D_WorkReadData) );
      }
      s_RecordMsgDecodeStart(); /*** for Processor Profile ***/
      $RELEASE(D_WorkReadData);
      break;
    case UnboundGroup():
      $USE(D_WorkReplyRec);
      $CALL( f_MakeReplyHook_Sub (D_Workreg1, D_WorkReplyRec) );

      $USE(D_WorkExCellPtr);
      s_AllocWhiteImpRecAndExCell_forAnsVal(D_WorkReturnExRefID, D_WorkExCellPtr);

      b_IfEqualImm(D_WorkStrFlag, _ONE){
	/* $B9=B$BN%U%i%0$,(B on $B$N$b$N$+$i(B %read $B$,Mh$?;~$O!"(BRHook $B$,(B
	   $B%j%8%e!<%`$5$l$k$H$-$K!"%l%Y%k#1$GJV?.$7$J$1$l$P$J$i$J$$$N$G!"(B
	   $B$=$l$r3P$($F$*$/$?$a$K!"JV?.@h$X$N%]%$%s%?$N(B MRB $B$r(B on $B$K(B
	   $B$7$F$*$/!#(B */
	s_MRBonReg(D_WorkExCellPtr);
      }

      s_PutReturnEXRefReplyRec(D_WorkReplyRec, D_WorkExCellPtr);
           /* %Answer_Value$B$NJV?.@h$rMQ0U$7$F(BReply_Record$B$K=q$-9~$`(B */
      /* $BL$40@.!JJV?.@h$,$^$@EPO?$5$l$F$$$J$$!K$N(BReplyHookRecord$B$r(B
	 $B$D$J$2$F$7$^$&$H!"(BRHOOK$B$K$O%m%C%/$,$J$$$N$G!"B>$K(BAnswer$B$7(B
	 $B$h$&$H$7$?(BPE$B$,JQ$JJV?.@h$r$D$+$s$G$3$1$F$7$^$&!#(B
	 $B$3$N$?$a!"JV?.@h$O(Bf_HookReplyRec$B$K@h$s$8$FEPO?$7$F$*$/!#(B
	 $B$?$@$7!"(BReplyRecord$B$N%U%C%/$K<:GT$7$?;~$O!"(BReplyRecord$B$H(B
	 $BF1;~$KJV?.@h$b2s<}$7$F%j%H%i%$$9$k!#(B by ttakagi  1992.3.9 */

      $USE(D_WorkRhookRes);
      s_RecordMsgDecodeStop(); /*** for Processor Profile ***/
      f_HookReplyRec(D_WorkReplyRec, D_Workreg1, D_WorkRhookRes);
                     /* D_WorkRhookRes = D_NULL : $B%U%C%/<:GT(B
		        D_WorkRhookRes = D_ONE  : $B%U%C%/@.8y(B */
      s_RecordMsgDecodeStart(); /*** for Processor Profile ***/
      b_IfEqualImm(D_WorkRhookRes, _ZERO) {
	@DEBUG{
	  WARNING("f_Recv_IntClMsg_Read_Sub",
		  "Reply_Hook failed ...other PE instantiated Unbound Cell");
	};
	$RELEASE(D_WorkRhookRes);  /* ReplyHook$B%l%3!<%I$N2s<}(B */
	$CALL( f_ReclaimReplyHook_Sub (D_WorkReplyRec) );
	$USE(D_WorkWImpRecPtr);
	p_Read(D_WorkExCellPtr, D_WorkWImpRecPtr);
	s_ReclaimWImpRec(D_WorkWImpRecPtr); /* $BM"F~I=%(%s%H%j$N2s<}(B */
	s_ReclaimVariable(D_WorkExCellPtr); /* $B30It;2>H%;%k$N2s<}(B   */
	$RELEASE(D_WorkWImpRecPtr);
	$RELEASE(D_WorkExCellPtr);
	p_MoveWord(D_Workreg1, D_WorkReadData);
	$RELEASE(D_WorkReplyRec);
	goto RetryLabel1;
      }

      $RELEASE(D_WorkExCellPtr);
      $RELEASE(D_WorkRhookRes);
      $RELEASE(D_WorkReadData);
      $RELEASE(D_WorkReplyRec);
      $RELEASE(D_Workreg1);
      break;
    default:
      @DEBUG{ VPIM_ERROR("f_Receive_NW_Read","invalide_type"); };
      $RELEASE(D_Workreg1);
      $RELEASE(D_WorkReadData);
      break;
    }
  $RELEASE(D_WorkStrFlag);
  $RELEASE(D_WorkReturnExRefID);
  $RETURN();
}

/******************************************************************** PSL **
2.  Reply_Record$B$r%U%C%/$9$kA`:n(B

       written by nakase@icot22      on Wed Jun 20 14:17:26 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>

(1) f_MakeReplyHook_Sub $BD>8e$N>uBV(B

			Unbound cell to be hooked (EUNDF, EHOOK, EMHOK, RHOOK)
  	REF		+-------+
       A_PtrToHookVar ->| link	+------> $B!&!&!&(B
	 		+-------+
	 ^				Reply Hook Record
	 |	RHOOK			+-------+
	 |	 A_PtrToReplyRec ------>| EOL	|
  	 |				|-------|
	 |	$BJV?.@h$X$N%]%$%s%?(B	|EOL	+
	 |				|-------|	
         |         (A_PtrToHookVarExRef)|REF	+----+
         |                              +-------+    |
         |                                           |
         +-------------------------------------------+

(2)  f_HookReplyRec$B$G%U%C%/$K@.8y$7$?D>8e$N>uBV(B


			Unbound cell to be hooked (EUNDF, EHOOK, EMHOK, RHOOK)
  	REF		+-------+
       A_PtrToHookVar ->| RHOOK	+-+
	 		+-------+ |
	 ^			  |	Reply Hook Record
	 |	RHOOK		  |	+-------+
	 |	 A_PtrToReplyRec -+---->| link	+--> (EHOOK, EMHOK, RHOOK, EOL)
  	 |				|-------|
	 |	$BJV?.@h$X$N%]%$%s%?(B	|EOL	+
	 |				|-------|	
         |         (A_PtrToHookVarExRef)|REF	+----+
         |                              +-------+    |
         |                                           |
         +-------------------------------------------+

       
       $B%U%C%/$K<:GT$7$?>l9g$O!"(BReply_Record$B$N$_$,2s<}$5$l$k!#(B

(3) Reply_Record$B$KJV?.@h$X$N%]%$%s%?$r=q$-9~$s$@D>8e$N>uBV(B

			Unbound cell to be hooked (EUNDF, EHOOK, EMHOK, RHOOK)
  	REF		+-------+
       A_PtrToHookVar ->| RHOOK	+-+
	 		+-------+ |
	 ^			  |	Reply Hook Record
	 |	RHOOK		  |	+-------+
	 |	 A_PtrToReplyRec -+---->| link	+--> (EHOOK, EMHOK, RHOOK, EOL)
  	 |				|-------|
	 |	$BJV?.@h$X$N%]%$%s%?(B	|REF	+-----------+
	 |				|-------|	    |
         |         (A_PtrToHookVarExRef)|REF	+----+      |
         |                              +-------+    |      |
         |                                           |      |
         +-------------------------------------------+      |
                                                            |
      +------------+         +------------+                 |                  
      |$B30It;2>H#I#D(B| <-------+WEX         | <---------------+
      +------------+         +------------+
   %Answer_Value$B$NJV?.@h(B

<ETC>
$B!&K\J}<0$G$O!"(BReply_Record$B$NJV?.@h$X$N%]%$%s%?%9%m%C%H!JJV?.@h$r;X$9GrM"F~(B
$B%l%3!<%I$r;X$9Gr30It;2>H%;%k$r;X$9!K$NCM$O(BEOL$B$H$7$F=i4|2=$7$F$$$k!#(B
  $B$3$N;~E@$G(BReply_Record$B$NJV?.@h$X$N%]%$%s%?%9%m%C%H$K6qBNE*$JCM$rF~$l$k$H!"(B
Reply_Record$B$N(BA_PtrToHookVar$B$X$N%U%C%/$,<:GT$7$?;~$K!"Gr30It;2>H%;%k$d(B
$BGrM"F~I=$r2s<}$9$kA`:n$,1x$/$J$k$+$i$G$"$k!#(B

$B!&(BReply_Record$B$r(BA_PtrToHookVar$B$K%U%C%/$7$F$+$iJV?.@h$r3d$jIU$1$k$N$G!"(B
$B%j%W%i%$%l%3!<%I$r%j%8%e!<%`$9$k:]$KJV?.@h$X$N%]%$%s%?$,(BEOL$B$G$"$k2DG=@-$,$"$k!#(B
  $B$3$N>l9g!"(Bbusy_wait$B$GJV?.@h$X$N%]%$%s%?$,6qBNE*$JCM$K=q$-JQ$o$k$N$rBT$DI,MW(B
$B$,$"$k!#(B
********************************************************************* PSL **/

/******************************************************************** PSL **
2.1 Reply_Record$B$r3d$jIU$1$k(B

       written by nakase@icot22      on Wed Jun 27 21:33:35 1990
<Arguments>
  A_PtrToHookVar  : $B%U%C%/$9$kL$Dj5AJQ?t%;%k$X$N%]%$%s%?(B
  A_PtrToReplyRec : $B3d$jEv$F$?(B Reply Hook Record $B$X$N%]%$%s%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#SUBARG_define	A_PtrToHookVar		SRC
#SUBARG_define	A_PtrToReplyRec		DST

#SUBROUTINE f_MakeReplyHook_Sub(A_PtrToHookVar, A_PtrToReplyRec)
{
  s_AllocEntryOfReplyRec(A_PtrToReplyRec);
  /* Reply-Hook$B%;%k$N3d$jIU$1(B */
  s_PutNextLinkReplyRec(A_PtrToReplyRec, D_EOL);
  s_PutReturnEXRefReplyRec(A_PtrToReplyRec, D_EOL);
  s_PutHookedVarReplyRec(A_PtrToReplyRec, A_PtrToHookVar);
  b_SetImmTypeMRBoff(RHOOK, A_PtrToReplyRec);
  $RETURN();
}

/******************************************************************** PSL **
2.2 Reply_Record$B$r2s<}$9$k(B

       written by nakase@icot22      on Wed Jun 20 14:35:32 1990
<Arguments>
  A_PtrToReplyRec: $B2s<}$9$k(BReply-Record$B$X$N%]%$%s%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

/* Reply-Hook$B=hM}$N$?$a$K3d$jIU$1$?%;%k$r2s<}$9$k(B */

#SUBARG_define A_Ptr_To_Reply_Rec MODIFY

#SUBROUTINE  f_ReclaimReplyHook_Sub(A_Ptr_To_Reply_Rec)
{
  s_ReclaimEntryOfReplyRec(A_Ptr_To_Reply_Rec);
  $RETURN();
}

/******************************************************************** PSL **
2.3 Reply_Record$B$rJQ?t$K%U%C%/$9$kA`:n(B

       written by nakase@icot22      on Wed Jun 20 14:37:29 1990
<Arguments>
  ptr_rhook_cell : Reply-hook$B%l%3!<%I$X$N%]%$%s%?(B
  ptr_to_var     : $B%U%C%/$9$kJQ?t$X$N%]%$%s%?(B
  result_reg     : $B%U%C%/$,@.8y$7$?$+H]$+$r<($9%l%8%9%?!J(BD_ONE : $B%U%C%/@.8y(B)
                                                        (D_NULL: $B%U%C%/<:GT(B)
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkRhookVar XXX
#DATA_define D_WorkLinkedGoal XXX

#PSL_define f_HookReplyRec(ptr_rhook_cell, ptr_to_var, result_reg)
{
  @DEBUG{
    s_IfNotRHOOK(ptr_rhook_cell) {
      VPIM_ERROR("f_HookReplyCell", "invalid rhook ptr");
    };
    $USE(D_WorkLinkedGoal);
    s_GetNextGoalsReplyRec(ptr_rhook_cell, D_WorkLinkedGoal);
    b_IfNotEOL(D_WorkLinkedGoal) {
      VPIM_ERROR("f_HookReplyRec", "invalid next_link in Reply_record");
    }
    $RELEASE(D_WorkLinkedGoal);
  };

  $USE(D_WorkRhookVar);
  p_Read(ptr_to_var, D_WorkRhookVar);
  TypeSwitch(D_WorkRhookVar) {
    case VOID:
    case UNDF:
    case EUNDF:
      b_TypeValueCompareSwapX(ptr_to_var, D_WorkRhookVar, ptr_rhook_cell);
      p_IfNE(){
	p_MoveWord(D_NULL, result_reg);
      } else {
	p_MoveWord(D_ONE, result_reg);
      }
      break;
    case HOOK:
    case MHOOK:
    case RHOOK: 
      s_PutNextLinkReplyRec(ptr_rhook_cell, D_WorkRhookVar);
      b_TypeValueCompareSwapX(ptr_to_var, D_WorkRhookVar, ptr_rhook_cell);
      p_IfNE() {
	p_MoveWord(D_NULL, result_reg);
      } else {
	p_MoveWord(D_ONE, result_reg);
      }
      break;
    case EHOOK:
      f_SetTypeAndNextLinkReplyRecord(HOOK, D_WorkRhookVar, ptr_rhook_cell);
      b_TypeValueCompareSwapX(ptr_to_var, D_WorkRhookVar, ptr_rhook_cell);
      p_IfNE() {
	p_MoveWord(D_NULL, result_reg);
      } else {
	p_MoveWord(D_ONE, result_reg);
      }
      break;
    case EMHOK:
      f_SetTypeAndNextLinkReplyRecord(MHOOK, D_WorkRhookVar, ptr_rhook_cell);
      b_TypeValueCompareSwapX(ptr_to_var, D_WorkRhookVar, ptr_rhook_cell);
      p_IfNE() {
	p_MoveWord(D_NULL, result_reg);
      } else {
	p_MoveWord(D_ONE, result_reg);
      }
      break;
    case WEXVAL:
    case WEXREF:
      s_IfMRBoff(ptr_to_var) {
	/* $B2rJ|M"=P$G$-$k$?$a!"(Bptr_to_var$B$N@h$N%m%C%/$OITMW(B */
	$CALL( f_Send_IntClMsg_Read_W_WEX_SingleWait_Sub
	                                  (ptr_to_var, ptr_rhook_cell) );
	@DEBUG{ WARNING("f_HookReplyRec","Read transfered, O -> WEX"); };
	p_MoveWord(D_ONE, result_reg);
      } else {
	/* $B%<%mM"=P$N$?$a!"(Bptr_to_var$B$N@h$N%m%C%/$,I,MW(B */
	s_IfSuccessSoftLockExCell(ptr_to_var, D_WorkRhookVar){
	  $CALL( f_Send_IntClMsg_Read_B_WEX_SingleWait_Sub
		             (ptr_to_var, D_WorkRhookVar, ptr_rhook_cell) );
	  @DEBUG{ WARNING("f_HookReplyRec","Read transfered, X -> WEX"); };
	  p_MoveWord(D_ONE, result_reg);
	} else {
	  p_MoveWord(D_NULL, result_reg);
	}
      }
      break;
    case BEXVAL:
    case BEXREF:
      s_IfSuccessSoftLockExCell(ptr_to_var, D_WorkRhookVar){
	$CALL( f_Send_IntClMsg_Read_BEX_SingleWait_Sub
	                        (ptr_to_var, D_WorkRhookVar, ptr_rhook_cell) );
	@DEBUG{ WARNING("f_HookReplyRec","Read transfered, REF -> BEX"); };
	p_MoveWord(D_ONE, result_reg);
      } else {
	p_MoveWord(D_NULL, result_reg);
      }
      break;
    case EXLOCK:
      p_MoveWord(D_NULL, result_reg);
      @DEBUG{
	WARNING("f_HookReplyRec", "Try to answer ExLocked. Retry");
      };
      break;
    case RDHOK:
      s_IfSuccessSoftLockExCell(ptr_to_var, D_WorkRhookVar) {
	s_PushGoalsRdhokRec(D_WorkRhookVar, ptr_rhook_cell);
	s_SoftUnlockExCell(ptr_to_var, D_WorkRhookVar);
	p_MoveWord(D_ONE, result_reg);
	@DEBUG{
	  WARNING("f_HookReplyRec", "Read was merged to previous RDHOK");
	};
      } else {
	p_MoveWord(D_NULL, result_reg);
      }
      break;
    case ConstantGroup():
    case StructureGroup():
    case COD:
    case MOD:
    case REF:
      p_MoveWord(D_NULL, result_reg);
      break;
    default:
      @DEBUG{ VPIM_ERROR("f_HookReplyRec", "invalid type"); };
      break;
    }
  $RELEASE(D_WorkRhookVar);
}

/******************************************************************** PSL **
2.4 Reply_Record$B$r%j%8%e!<%`$9$k=hM}(B

       written by nakase@icot22      on Wed Jun 27 21:40:53 1990

<Arguments>
 ptr_to_rhook: Rhook $B%;%k$X$N%]%$%s%?(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkWEX_Ref_Ptr XXX
#DATA_define D_WorkWEX_Ref XXX
#DATA_define D_WorkWEXRefID XXX
#DATA_define D_WorkHookedVarPtr XXX

#PSL_define f_ResumeRhookCell(ptr_to_rhook)
{
  $USE(D_WorkHookedVar);
  $USE(D_WorkHookedVarPtr);
 Retry_Label:
  s_GetHookedVarReplyRec(ptr_to_rhook, D_WorkHookedVar);
  f_ActiveDeref(D_WorkHookedVar, D_WorkHookedVarPtr);
  s_IfUnbound(D_WorkHookedVar) {
         /* Supply_BEXID$B$r<u$1$F(BReply_Record$B$,5/$-$?;~$3$3$KE~C#$7F@$k!#(B*/
    s_PutNextLinkReplyRec(ptr_to_rhook, D_EOL);
         /* Reply_Record$B$N(BNext_Link$B$K$O!"B>$N%4!<%kEy$,7R$,$l$F$$$?$+$b(B
	   $BCN$l$J$$$N$G(B */
    $USE(D_WorkRhookRes);
    s_PutHookedVarReplyRec(ptr_to_rhook, D_WorkHookedVarPtr);
    f_HookReplyRec(ptr_to_rhook, D_WorkHookedVarPtr, D_WorkRhookRes);
    b_IfZero(D_WorkRhookRes) {
      $RELEASE(D_WorkRhookRes);
      goto Retry_Label;
    }
    $RELEASE(D_WorkRhookRes);
  } else {
    $USE(D_WorkWEX_Ref_Ptr);
    s_GetReturnEXRefReplyRec(ptr_to_rhook, D_WorkWEX_Ref_Ptr);
    b_IfEOL(D_WorkWEX_Ref_Ptr){
      $RELEASE(D_WorkWEX_Ref_Ptr);
      goto Retry_Label;
    /* $B$3$NM}M3$K$D$$$F$O!"(B" 2.Reply_Record$B$r%U%C%/$9$kA`:n(B"$B$N%3%a%s%H$r8+$h(B */
    }
    $USE(D_WorkWEX_Ref);
    p_Read(D_WorkWEX_Ref_Ptr, D_WorkWEX_Ref);
    @DEBUG{
      s_IfNotWEXREF(D_WorkWEX_Ref) {
	VPIM_ERROR("f_ResumeRhookCell","invalid exref cell");
      }
    };

    $USE(D_WorkWEXRefID);
    s_GetExrefIdAndReclaimWImpRec_AnsVal(D_WorkWEX_Ref, D_WorkWEXRefID);
                               /* $B30It;2>H(BID$B$N<h$j$@$7$HGrM"F~%l%3!<%I$N2rJ|(B */

    s_IfMOD(D_WorkHookedVar) {
      s_IfMRBoff(D_WorkWEX_Ref_Ptr) {
	$CALL ( f_Send_IntClMsg_AnswerValue_StrID_Sub
	                        (D_WorkWEXRefID, D_WorkHookedVar) );
	goto END_Label;
      }
    }

    $CALL ( f_Send_IntClMsg_AnswerValue_Sub(D_WorkWEXRefID, D_WorkHookedVar) );

  END_Label:
    s_ReclaimVariable(D_WorkWEX_Ref_Ptr);    
                               /* $BJV?.@h$r;X$9GrM"F~I=$r;X$9Gr30It;2>H%;%k$r(B
				  $B2rJ|$9$k(B */
    $RELEASE(D_WorkWEX_Ref_Ptr);
    $RELEASE(D_WorkWEX_Ref);
    $RELEASE(D_WorkWEXRefID);
  }
  $RELEASE(D_WorkHookedVarPtr);
  $RELEASE(D_WorkHookedVar);
}

