/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_int_cl_recv_dispatch.psl.c
   ----- CREATED   : by nakase@icot22, on Thu Jun 14 14:09:38 1990
   ----- LAST SAVED: by ttakagi@icot22, on Mon Jun 15 19:35:25 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : FUNCTIONS
   ----- ABSTRACT  : $B%a%C%;!<%8<u?.!"%G%#%9%Q%C%A(B

 1.1 $B%M%C%H%o!<%/<u?.%^%/%m(B
    f_NwMessageHandler_Sub()
 1.2 $B%5%9%Z%s%I$7$F$$$?%a%C%;!<%8$rAH$_N)$F$k(B
    f_ResumeMessageMultiPacket()

 2. $B%a%C%;!<%8<oJL$r8+$F!"%Q%1%C%H$r3F2r<a%k!<%A%s$KEO$9(B
    f_Receive_IntClMsg_Sub(A_PacketPtr)

 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/* $B$3$N%U%!%$%k$G;HMQ$9$k%o!<%/%l%8%9%?(B */
#DATA_define D_WorkPacketPtr		XXX
#DATA_define D_WorkRecvPacketPtr        XXX
#DATA_define D_WorkMultiRec             XXX
#DATA_define D_WorkRecvCnt              XXX
#DATA_define D_WorkTotalNum             XXX
#DATA_define D_WorkCurrentPacketPtr	XXX
#DATA_define D_WorkRecvCurrentPacketPtr	XXX
#DATA_define D_WorkMsgId		XXX

/******************************************************************** PSL **
1.1 $B%M%C%H%o!<%/<u?.%^%/%m(B

f_NwMessageHandler_Sub

       written by nakase@icot22      on Thu Jun 14 14:29:43 1990

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B%M%C%H%o!<%/%a%C%;!<%8E~Ce$N3d$j9~$_$r<u$1!"%Q%1%C%H$r<u?.$K9T$/!#(B
  s_ReceivePacket$B$G$O!"0J2<$N#3<oN`$NCM$,JV$k2DG=@-$,$"$k!#(B

 (1) $B40@.$7$F$$$k%Q%1%C%H!J%7%s%0%k%Q%1%C%H$+%^%k%A%Q%1%C%H$+$N6hJL$O$J$$!K(B
 (2) $B%^%k%A%Q%1%C%H$N0lIt(B
 (3) NULL$BCM!JE~Ce$7$?%Q%1%C%H$OA4$FFI$s$G$7$^$C$?8e!K(B

 (1),(2)$B$N>l9g$O!"(B(3)$B$K$J$k$^$G%Q%1%C%H$rFI$_B3$1$J$1$l$P$J$i$J$$!#(B
 (1) $B$N>l9g$O!"%a%C%;!<%8<u?.=hM}$r9T$J$&!#(B

<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#SUBROUTINE f_NwMessageHandler_Sub()
{
  s_RecordMsgDecodeStart(); /*** for Processor Profile ***/

  $USE(D_WorkRecvPacketPtr);
  /* $B%a%C%;!<%8$NFI$_9~$_(B */
  s_ReceivePacket(D_WorkRecvPacketPtr);

  b_IfNotIllegalPointer(D_WorkRecvPacketPtr) {
    LOOP() {
      s_IfCompletePacket(D_WorkRecvPacketPtr){
	/* $B407k$7$?%a%C%;!<%8$,F@$i$l$l$P!"%a%C%;!<%8<u?.=hM}$r9T$J$&!#(B */
	$CALL( f_Receive_IntClMsg_Sub(D_WorkRecvPacketPtr) );
      }
      s_IfPageAllocFail() {
	/* GC$BMW5a$,$"$C$?$?$a!"%a%C%;!<%8$NFI$_<h$j$rCfCG$7$?$3$H$r(B
	   $B3P$($F$*$/$?$a$N(B $B%U%i%0$rN)$F$k!#(B */
	s_SetRecvPacketSuspFlag();
	goto NotResetSCR;
      }
      s_ReceivePacket(D_WorkRecvPacketPtr);
      b_IfIllegalPointer(D_WorkRecvPacketPtr) {
	s_ResetRecvPacketSuspFlag();
	break;
        /* $BB3$-$N%Q%1%C%H$,$J$1$l$P!"<u?.=hM}$r=*$k!#(B*/
      }
    }
  } else {
    /* GC$B$K$h$k%a%C%;!<%8FI$_$H$jCfCG%U%i%0$N%A%'%C%/(B */
    s_IfRecvPacketSuspFlagOn() {
      /* $BCfCG%U%i%0$,N)$C$F$$$?>l9g!"%U%i%0$r%j%;%C%H$7$F=*N;(B */
      s_ResetRecvPacketSuspFlag();
      @DEBUG{ WARNING("f_NwMessageHandler_Sub", "No message handled"); };
    } else {
      /* $BCfCG%U%i%0$,N)$C$F$$$J$$>l9g!"%(%i!<(B */
      /* @DEBUG{ VPIM_ERROR("f_NwMessageHandler_Sub", "Invalid SCF"); }; */
      /* GC$B%9%?!<%H$,6u?6$j$7$?;~!"CfCG%U%i%0$ON)$C$F$$$J$$(B */
      @DEBUG{ WARNING("f_NwMessageHandler_Sub", "Invalid SCF"); };
    }
  }
  /* $B%9%j%C%H%A%'%C%/MW0x$N%j%;%C%H(B */
  b_ResetEventFlag(_NW_MSG_PACKET_ARV_EVENT,D_PE_Number);
 NotResetSCR:
  $RELEASE(D_WorkRecvPacketPtr);
  s_RecordMsgDecodeStop(); /*** for Processor Profile ***/
  $RETURN();
}

/******************************************************************** PSL **
2. $B%a%C%;!<%8<oJL$r8+$F!"%Q%1%C%H$r3F2r<a%k!<%A%s$KEO$9(B

f_Receive_IntClMsg_Sub

       written by nakase@icot22      on Thu Jun 14 15:37:47 1990

<Arguments>
  A_PacketPtr: $B<u?.$7$?%Q%1%C%H$X$N%]%$%s%?(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B<u?.$7$?O@M}%Q%1%C%H$NBh#1%o!<%IL\!J%a%C%;!<%8<oJL!K$rFI$_!"(B
  $B3F%a%C%;!<%8$N2r<a%k!<%A%s$KEO$9!#(B

<Examples>
<Test>
<Explanation>
$B!&%a%C%;!<%8$rFI$_=*$C$?$i!"O@M}%Q%1%C%H$O2s<}$9$k(B

<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkSuspFlag XXX

#SUBARG_define A_PacketPtr      MODIFY

#SUBROUTINE f_Receive_IntClMsg_Sub(A_PacketPtr)
{
  s_RecordMsgRecvCountLogMsgType(A_PacketPtr); /*** for Processor Profile ***/

  $USE(D_WorkRecvCurrentPacketPtr);
  p_MoveWord(A_PacketPtr, D_WorkRecvCurrentPacketPtr);
  b_IncrementAddrReg(D_WorkRecvCurrentPacketPtr);
  $USE(D_WorkMsgId);
  s_Get_1_Data_fromLogicalPacket(D_WorkRecvCurrentPacketPtr, D_WorkMsgId);
  $USE(D_WorkSuspFlag);
  p_MoveWord(D_NULL, D_WorkSuspFlag);
  ValueSwitch(D_WorkMsgId) {
    case _NW_THROW_GOAL:
      $CALL( f_Recv_IntClMsg_Throw_Goal_Sub
	           (D_WorkRecvCurrentPacketPtr, A_PacketPtr, D_WorkSuspFlag) );
      break;
    case _NW_READY:
      $CALL( f_Recv_IntClMsg_Ready_Sub(D_WorkRecvCurrentPacketPtr) );
      break;
    case _NW_TERMINATED:
      $CALL( f_Recv_IntClMsg_Terminated_Sub(D_WorkRecvCurrentPacketPtr) );
      break;
    case _NW_START:
      $CALL( f_Recv_IntClMsg_Start_Sub(D_WorkRecvCurrentPacketPtr) );
      break;
    case _NW_STOP:
      $CALL( f_Recv_IntClMsg_Stop_Sub(D_WorkRecvCurrentPacketPtr) );
      break;
    case _NW_ABORT:
      $CALL( f_Recv_IntClMsg_Abort_Sub(D_WorkRecvCurrentPacketPtr) );
      break;
    case _NW_READ:
      $CALL( f_Recv_IntClMsg_Read_Sub(D_WorkRecvCurrentPacketPtr) );
      break;
    case _NW_ANSWER_VALUE:
      $CALL( f_Recv_IntClMsg_Answer_Value_Sub
	           (D_WorkRecvCurrentPacketPtr, A_PacketPtr, D_WorkSuspFlag) );
      break;
    case _NW_RELEASE:
      $CALL( f_Recv_IntClMsg_Release_Sub(D_WorkRecvCurrentPacketPtr) );
      break;
    case _NW_UNIFY:
      $CALL( f_Recv_IntClMsg_Unify_Sub
                  (D_WorkRecvCurrentPacketPtr, A_PacketPtr, D_WorkSuspFlag) );
      break;
    case _NW_EXCEPTION:
      $CALL( f_Recv_IntClMsg_Exception_Sub(D_WorkRecvCurrentPacketPtr) );
      break; 

    case _NW_REQUEST_WTC:
      $CALL( f_Recv_IntClMsg_Request_WTC_Sub(D_WorkRecvCurrentPacketPtr) );
      break;
    case _NW_SUPPLY_WTC:
      $CALL( f_Recv_IntClMsg_Supply_WTC_Sub(D_WorkRecvCurrentPacketPtr) );
      break;
    case _NW_RETURN_WTC:
      $CALL( f_Recv_IntClMsg_Return_WTC_Sub(D_WorkRecvCurrentPacketPtr) );
      break;
    case _NW_REQUEST_RESOURCE:
      $CALL( f_Recv_IntClMsg_Request_Resource_Sub
	                             (D_WorkRecvCurrentPacketPtr) );
      break;
    case _NW_SUPPLY_RESOURCE:
      $CALL( f_Recv_IntClMsg_Supply_Resource_Sub(D_WorkRecvCurrentPacketPtr) );
      break;
    case _NW_RETURN_RESOURCE:
      $CALL( f_Recv_IntClMsg_Return_Resource_Sub(D_WorkRecvCurrentPacketPtr) );
      break;
    case _NW_ASK_STATISTICS:
      $CALL( f_Recv_IntClMsg_Ask_Statistics_Sub(D_WorkRecvCurrentPacketPtr) );
      break;
    case _NW_ANSWER_STATISTICS:
      $CALL( f_Recv_IntClMsg_Answer_Statistics_Sub
	                            (D_WorkRecvCurrentPacketPtr) );
      break;
    case _NW_SHOEN_PROFILE:
      $CALL( f_Recv_IntClMsg_Shoen_Profile_Sub(D_WorkRecvCurrentPacketPtr) );
      break;
    case _NW_SHOEN_PROFILE_REQUEST:
      $CALL( f_Recv_IntClMsg_Shoen_Profile_Request_Sub
	                                   (D_WorkRecvCurrentPacketPtr) );  
      break;

    case _NW_REQUEST_BEXID_WEX:
      $CALL( f_Recv_IntClMsg_Request_BEXID_WEX_Sub
	                             (D_WorkRecvCurrentPacketPtr) );  
      break;
    case _NW_REQUEST_BEXID_BEX:
      $CALL( f_Recv_IntClMsg_Request_BEXID_BEX_Sub
	                             (D_WorkRecvCurrentPacketPtr) );  
      break;
    case _NW_SUPPLY_BEXID:
      $CALL( f_Recv_IntClMsg_Supply_BEXID_Sub(D_WorkRecvCurrentPacketPtr) );  
      break;
    case _NW_NAK_START:
      $CALL( f_Recv_IntClMsg_NAKStart_Sub(D_WorkRecvCurrentPacketPtr) );  
      break;
    case _NW_NAK_STOP:
      $CALL( f_Recv_IntClMsg_NAKStop_Sub(D_WorkRecvCurrentPacketPtr) );  
      break;

    case _NW_PIMS_SHUTDOWN:
      $CALL( f_Recv_IntClMsg_PIMs_Shutdown_Sub() );	
                                           /* PIM/s $B@lMQ(B */
      break;
    default:
      @DEBUG{VPIM_ERROR("f_Recv_IntClMsg_Dispacher", "Invalid MessateID");};
      break;
    }
  b_IfEqual(D_WorkSuspFlag, D_NULL) {
    s_ReclaimLogicalPacket(A_PacketPtr);
  }
  $RELEASE(D_WorkSuspFlag);
  $RELEASE(D_WorkMsgId);
  $RELEASE(D_WorkRecvCurrentPacketPtr);
  $RETURN();
}

/******************************************************************** PSL **
3. $B%5%9%Z%s%I$7$?%a%C%;!<%8$N%j%8%e!<%`(B

       written by ttakagi@icot22      on Fri Apr 26 12:05:23 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkPtrToMsgRec XXX

#PSL_define f_Resume_SuspendedMessage()
{
  $USE(D_WorkPtrToMsgRec);
  LOOP() {
    s_PopMsgSuspRec(D_WorkPtrToMsgRec);
    b_IfIllegalPointer(D_WorkPtrToMsgRec) { break; }
    f_Resume_EachSuspendedMessage(D_WorkPtrToMsgRec);
    s_IfPageAllocFail() { break; }
  }
  $RELEASE(D_WorkPtrToMsgRec);
}

#DATA_define D_WorkMsgSuspID       XXX
#DATA_define D_WorkMsgSuspInfo1    XXX
#DATA_define D_WorkMsgSuspInfo2    XXX
#DATA_define D_WorkPtrToFP          XXX
#DATA_define D_WorkPtrToLogiPacket XXX
#DATA_define D_WorkTotalPacketNumber XXX
#DATA_define D_WorkExrefID_SuspMsg   XXX

#PSL_define f_Resume_EachSuspendedMessage(msg_rec_ptr)
{
  $USE(D_WorkMsgSuspID);
  s_GetSuspMsgID_MsgSuspRec(msg_rec_ptr, D_WorkMsgSuspID);
  $USE(D_WorkMsgSuspInfo1);
  s_GetMsgInfo1_MsgSuspRec(msg_rec_ptr, D_WorkMsgSuspInfo1);
  $USE(D_WorkMsgSuspInfo2);
  ValueSwitch(D_WorkMsgSuspID) {
  case _MSG_SUSP_SEND_THROW_GOAL:
    /* D_WorkMsgSuspInfo1 == receiver cluster number */
    s_GetMsgInfo2_MsgSuspRec(msg_rec_ptr, D_WorkMsgSuspInfo2);
    /* D_WorkMsgSuspInfo2 == pointer to goal record */
    $USE(D_WorkPtrToFP);
    s_GetFosterparentGoalRecord(D_WorkMsgSuspInfo2, D_WorkPtrToFP);
    s_IfNodeOutOfBounds(D_WorkPtrToFP, D_WorkMsgSuspInfo1) {
      @DEBUG{
	WARNING("f_Resume_EachSuspendedMessage","node is out of bounds");
      };
    } else {
      $CALL( f_Send_IntClMsg_ThrowGoal_Sub
	          (D_WorkMsgSuspInfo1, D_WorkMsgSuspInfo2, D_WorkPtrToFP) );
    }
    $RELEASE(D_WorkPtrToFP);
    break;
  case _MSG_SUSP_SEND_ANSWER_VALUE:
    /* D_WorkMsgSuspInfo1 == return exref */
    $USE(D_WorkExrefID_SuspMsg);
    s_GetExrefIdAndReclaimWImpRec_AnsVal(D_WorkMsgSuspInfo1, D_WorkExrefID_SuspMsg); 
    s_GetMsgInfo2_MsgSuspRec(msg_rec_ptr, D_WorkMsgSuspInfo2);
    /* D_WorkMsgSuspInfo2 == answer data */
    $CALL( f_Send_IntClMsg_AnswerValue_Sub
  	                   (D_WorkExrefID_SuspMsg, D_WorkMsgSuspInfo2) );
    $RELEASE(D_WorkExrefID_SuspMsg);
    break;
  case _MSG_SUSP_RECV_PACKET:
    /* D_WorkMsgSuspInfo1 == pointer to logical packet */
    s_RecordMsgDecodeStart(); /*** for Processor Profile ***/
    $CALL( f_Receive_IntClMsg_Sub(D_WorkMsgSuspInfo1) );
    s_RecordMsgDecodeStop(); /*** for Processor Profile ***/
    break;
  case _MSG_SUSP_MAKE_MULTI_PACKET:
    /* D_WorkMsgSuspInfo1 == pointer to multi packet record */
    $USE(D_WorkTotalPacketNumber);
    s_GetTotalPacketNum_fromMultiPacketRecord
                        (D_WorkMsgSuspInfo1, D_WorkTotalPacketNumber);
    $USE(D_WorkPtrToLogiPacket);
    s_MakeLogicalPacket_fromSeparateLogicalPacket
      (D_WorkPtrToLogiPacket, D_WorkMsgSuspInfo1, D_WorkTotalPacketNumber);
    $RELEASE(D_WorkTotalPacketNumber);
    b_IfNotIllegalPointer(D_WorkPtrToLogiPacket){
      s_RecordMsgDecodeStart(); /*** for Processor Profile ***/
      $CALL( f_Receive_IntClMsg_Sub(D_WorkPtrToLogiPacket) );
      s_RecordMsgDecodeStop(); /*** for Processor Profile ***/
    }
    $RELEASE(D_WorkPtrToLogiPacket);
    break;
  default:
    @DEBUG{ VPIM_ERROR("f_Resume_EachSuspendedMessage","Illegal msg id"); };
    break;
  }
  s_ReclaimMsgSuspRec(msg_rec_ptr);
  $RELEASE(D_WorkMsgSuspInfo1);
  $RELEASE(D_WorkMsgSuspInfo2);
  $RELEASE(D_WorkMsgSuspID);
}

/******************************************************************** PSL **
$B%5%9%Z%s%I$7$F$$$k%Q%1%C%H$rAw=P$9$k(B

f_RetrySendPacket

       written by ttakagi@icot22      on Sat Jul  6 16:59:27 1991

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkPtrToPacketRec XXX
#DATA_define D_WorkNextPacketRec  XXX

#PSL_define f_RetrySendPacket()
{
  b_ResetEventFlag(_NETWORK_BUFFER_FULL_EVENT,D_PE_Number);
  $USE(D_WorkPtrToPacketRec);
  $USE(D_WorkNextPacketRec);
  LOOP() {
    s_PopPacketSuspRec(D_WorkPtrToPacketRec);
    b_IfIllegalPointer(D_WorkPtrToPacketRec) { break; }
    f_RetrySendEachPacket(D_WorkPtrToPacketRec);
    s_GetNextRecLink_PacketSuspRec(D_WorkPtrToPacketRec, D_WorkNextPacketRec);
    b_IfIllegalPointer(D_WorkNextPacketRec) { break; }
    s_IfPageAllocFail() { break; }
  }
  $RELEASE(D_WorkNextPacketRec);
  $RELEASE(D_WorkPtrToPacketRec);
}

#DATA_define D_WorkPacketSuspID    XXX
#DATA_define D_WorkPacketSuspInfo1 XXX
#DATA_define D_WorkPacketSuspInfo2 XXX
#DATA_define D_WorkPacketSuspInfo3 XXX
#DATA_define D_WorkPacketSuspInfo4 XXX
#DATA_define D_WorkPacketSuspInfo5 XXX
#DATA_define D_WorkPacketSuspInfo6 XXX

#PSL_define f_RetrySendEachPacket(packet_rec_ptr)
{
  $USE(D_WorkPacketSuspID);
  s_GetSuspPacketID_PacketSuspRec(packet_rec_ptr, D_WorkPacketSuspID);
  $USE(D_WorkPacketSuspInfo1);
  s_GetPacketInfo1_PacketSuspRec(packet_rec_ptr, D_WorkPacketSuspInfo1);
  $USE(D_WorkPacketSuspInfo2);
  s_GetPacketInfo2_PacketSuspRec(packet_rec_ptr, D_WorkPacketSuspInfo2);
  ValueSwitch(D_WorkPacketSuspID){
  case _PACKET_SUSP_SINGLE:
    $USE(D_WorkPacketSuspInfo3);
    s_GetPacketInfo3_PacketSuspRec(packet_rec_ptr, D_WorkPacketSuspInfo3);
    s_SendSinglePacket
         (D_WorkPacketSuspInfo3, D_WorkPacketSuspInfo2, D_WorkPacketSuspInfo1);
    $RELEASE(D_WorkPacketSuspInfo3);
    break;
  case _PACKET_SUSP_MULTI:
    $USE(D_WorkPacketSuspInfo3);
    s_GetPacketInfo3_PacketSuspRec(packet_rec_ptr, D_WorkPacketSuspInfo3);
    $USE(D_WorkPacketSuspInfo4);
    s_GetPacketInfo4_PacketSuspRec(packet_rec_ptr, D_WorkPacketSuspInfo4);
    $USE(D_WorkPacketSuspInfo5);
    s_GetPacketInfo5_PacketSuspRec(packet_rec_ptr, D_WorkPacketSuspInfo5);
    $USE(D_WorkPacketSuspInfo6);
    s_GetPacketInfo6_PacketSuspRec(packet_rec_ptr, D_WorkPacketSuspInfo6);
    s_SendMultiPacket(D_WorkPacketSuspInfo6, D_WorkPacketSuspInfo1,
		      D_WorkPacketSuspInfo2, D_WorkPacketSuspInfo5,
		      D_WorkPacketSuspInfo4, D_WorkPacketSuspInfo3);
    $RELEASE(D_WorkPacketSuspInfo3);
    $RELEASE(D_WorkPacketSuspInfo4);
    $RELEASE(D_WorkPacketSuspInfo5);
    $RELEASE(D_WorkPacketSuspInfo6);
    break;
  case _PACKET_SUSP_DISTRIBUTE:
    $USE(D_WorkPacketSuspInfo3);
    s_GetPacketInfo3_PacketSuspRec(packet_rec_ptr, D_WorkPacketSuspInfo3);
    $CALL( s_SendPacket_ToFPs_Sub
	                (D_WorkPacketSuspInfo3,
			 D_WorkPacketSuspInfo1, D_WorkPacketSuspInfo2) );
    $RELEASE(D_WorkPacketSuspInfo3);
    break;
  default:
    @DEBUG{VPIM_ERROR("f_RetrySendEachPacket","Illegal packet susp rec ID");};
  }
  s_ReclaimPacketSuspRec(packet_rec_ptr);
  $RELEASE(D_WorkPacketSuspInfo2);
  $RELEASE(D_WorkPacketSuspInfo1);
  $RELEASE(D_WorkPacketSuspID);
}
