
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_int_cl_recv_control.psl.c
   ----- CREATED   : by kawai@icot22, on Fri Jun 22 19:57:04 1990
   ----- LAST SAVED: by ttakagi@icot22, on Fri Jun 12 17:57:43 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : 

  $B%/%i%9%?4V=hM}A4BN$N%U%!%$%k9=@.$O!"(B"f_int_cl_msg.psl.c"$B$r;2>H$N$3$H(B

A. $B9`L\(B
-------
1.  $BAq1`$N=*N;(B, $B5/F0(B, $B%"%\!<%H$J$I(B
  1.1  f_Recv_IntClMsg_Terminated_Sub
  1.2  f_Recv_IntClMsg_Start_Sub
  1.3  f_Recv_IntClMsg_Stop_Sub
  1.4  f_Recv_IntClMsg_Abort_Sub
  1.5  f_Recv_IntClMsg_Ready_Sub
2.  WTC $B4XO"(B
  2.1  f_Recv_IntClMsg_Request_WTC_Sub
  2.2  f_Recv_IntClMsg_Supply_WTC_Sub
  2.3  f_Recv_IntClMsg_Return_WTC_Sub
3.  $B%9%H%j!<%`4XO"(B
  3.1  f_Recv_IntClMsg_Stream_Sub
  3.2  f_Recv_IntClMsg_Make_Streams_Sub
  3.3  f_Recv_IntClMsg_Close_Streams_Sub
  3.4  f_Recv_IntClMsg_Put_Stream_Element_Sub
  3.5  f_Recv_IntClMsg_Add_Streams_Sub
4.  $B;q8;4XO"(B
  4.1  f_Recv_IntClMsg_Request_Resorce_Sub
  4.2  f_Recv_IntClMsg_Supply_Resorce_Sub
  4.3  f_Recv_IntClMsg_Returen_Resource_Sub
5.  $BE}7W%G!<%?4XO"(B
  5.1  f_Recv_IntClMsg_Ask_Statistics_Sub
  5.2  f_Recv_IntClMsg_Answer_Statistics_Sub
  5.3  f_Recv_IntClMsg_Ask_Profile_Sub
  5.4  f_Recv_IntClMsg_Answer_Profile_Sub
6.  $BNc304XO"(B
  6.1  f_Recv_IntClMsg_Exception_Sub
  6.2  f_Recv_IntClMsg_Guard_Failure_Sub
  6.3  f_Recv_IntClMsg_Unification_Failure_Sub
  6.4  f_Recv_IntClMsg_Raised_Sub
100.  PIM/s $B@lMQ$N%/%i%9%?Dd;_MQ$N%a%C%;!<%8(B
  100.1  f_Recv_IntClMsg_PIMs_Shutdown_Sub

 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
1.0  f_AddWTCWithReclaimExpEntryAndShoenTerminate_Sub

       written by kawai@icot22      on Fri Jun 22 19:58:38 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B#W#T#C$,#0$J$i$P!"9uM"F~I=$r2rJ|$7!"Aq1`$N(BTerminate$B=hM}$r9T$J$&%k!<%A%s!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define  D_WorkShoenOrgLockTagInTerminateReg  XXX

#SUBARG_define A_RecvShoenId SRC
#SUBARG_define A_ShoenPtr    SRC
#SUBARG_define A_RecvWTC     SRC

#SUBROUTINE f_AddWTCWithReclaimExpEntryAndShoenTerminate_Sub(A_RecvShoenId,
							     A_ShoenPtr,
							     A_RecvWTC){
  $USE(D_WorkWTC_Flag);
  $USE(D_WorkShoenOrgLockTagInTerminateReg);
  s_LockShoenRecord(A_ShoenPtr, D_WorkShoenOrgLockTagInTerminateReg);
  $CALL( s_AddWecWithReclaimExpEntry_Sub(A_RecvShoenId, A_RecvWTC,
					 D_WorkWTC_Flag) );
  b_IfZero(D_WorkWTC_Flag){
    @DEBUG{  WARNING("f_AddWTCWithReclaimExpEntryAndShoenTerminate_Sub",
		     "WTC in Bexp is 0... SHOEN will terminate");};
    s_RecordMsgDecodeStop(); /*** for Processor Profile ***/
    $CALL(f_ShoenTerminateWithUnlock_Sub(A_ShoenPtr,
				   D_WorkShoenOrgLockTagInTerminateReg) );
    $RELEASE(D_WorkShoenOrgLockTagInTerminateReg);
    s_RecordMsgDecodeStart(); /*** for Processor Profile ***/
  }else{
    s_UnlockShoenRecord(A_ShoenPtr, D_WorkShoenOrgLockTagInTerminateReg);
    $RELEASE(D_WorkShoenOrgLockTagInTerminateReg);
  }
  $RELEASE(D_WorkWTC_Flag);
  $RETURN();
}

/******************************************************************** PSL **
1.1  f_Receive_NW_Terminated_Sub

       written by kawai@icot22      on Fri Jun 22 19:58:38 1990
<Arguments>
  A_Packet_Ptr : $BO@M}%Q%1%C%H$X$N%]%$%s%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $BN$?F$+$i$N(BTerminate$B%a%C%;!<%8$N<u?.!#(B
  $B#W#T#C$,#0$J$i$P!"9uM"F~I=$r2rJ|$7!"Aq1`$N(BTerminate$B=hM}$r9T$J$&!#(B
<Examples>
<Test>
<Explanation>
  $BAq1`$,<u?.$9$k%a%C%;!<%8(B
<ETC>
********************************************************************* PSL **/

#DATA_define  D_WorkRecvShoenId  	XXX
#DATA_define  D_WorkRecvWTC  		XXX
#DATA_define  D_WorkRecvResourceLeftUpper  XXX
#DATA_define  D_WorkRecvResourceLeftLower  XXX
#DATA_define  D_WorkRecvResourceConsumedUpper  XXX
#DATA_define  D_WorkRecvResourceConsumedLower  XXX
#DATA_define  D_WorkBExpShoenPtr  	XXX
#DATA_define  D_WorkWTCFlag  		XXX
#DATA_define  D_WorkRecvClNum 		XXX

#SUBARG_define	A_PacketPtr	 MODIFY

#SUBROUTINE f_Recv_IntClMsg_Terminated_Sub(A_PacketPtr)
{
  $USE(D_WorkRecvShoenId);
  $USE(D_WorkRecvWTC);
  $USE(D_WorkRecvClNum);
  f_Get_ShoenID_fromLogicalPacket(A_PacketPtr, D_WorkRecvShoenId);
  f_Get_CL_Num_fromLogicalPacket(A_PacketPtr, D_WorkRecvClNum);
  f_Get_WTC_fromLogicalPacket(A_PacketPtr, D_WorkRecvWTC);

  $USE(D_WorkBExpShoenPtr);
  $CALL( s_GetBExpData_Sub(D_WorkRecvShoenId, D_WorkBExpShoenPtr) ); 

  $USE(D_WorkRecvResourceLeftUpper);
  $USE(D_WorkRecvResourceLeftLower);
  f_Get_ResourceLeft_fromLogicalPacket(A_PacketPtr, 
				       D_WorkRecvResourceLeftUpper,
				       D_WorkRecvResourceLeftLower);
  $USE(D_WorkRecvResourceConsumedUpper);
  $USE(D_WorkRecvResourceConsumedLower);
  f_Get_ResourceConsumed_fromLogicalPacket(A_PacketPtr, 
					   D_WorkRecvResourceConsumedUpper,
					   D_WorkRecvResourceConsumedLower);
  s_RecordMsgDecodeStop(); /*** for Processor Profile ***/
  f_ShoenReceiveTerminated(D_WorkBExpShoenPtr,
			   D_WorkRecvResourceLeftUpper,
			   D_WorkRecvResourceLeftLower,
			   D_WorkRecvResourceConsumedUpper,
			   D_WorkRecvResourceConsumedLower,
			   D_WorkRecvClNum);
  s_RecordMsgDecodeStart(); /*** for Processor Profile ***/
  $RELEASE(D_WorkRecvClNum);
  $RELEASE(D_WorkRecvResourceLeftUpper);
  $RELEASE(D_WorkRecvResourceLeftLower);
  $RELEASE(D_WorkRecvResourceConsumedUpper);
  $RELEASE(D_WorkRecvResourceConsumedLower);

/* !! $BAq1`=*7k;~$N%m%C%/4|4V3HBg$N$?$a!"(BWTC$B2C;;(B $B"*(B ($BAq1`=*7k(B)$B$N=hM}$K$O(B
      $B0J2<$N%5%V%k!<%A%s$rMQ$$$k!#(B '92.2.17 */
  $CALL( f_AddWTCWithReclaimExpEntryAndShoenTerminate_Sub
	             (D_WorkRecvShoenId, D_WorkBExpShoenPtr, D_WorkRecvWTC) );

  $RELEASE(D_WorkRecvShoenId);
  $RELEASE(D_WorkRecvWTC);  
  $RELEASE(D_WorkBExpShoenPtr);
  $RETURN();
}

/******************************************************************** PSL **
1.2  f_Recv_IntClMsg_Start_Sub

       written by nakase@icot22      on Tue Jun 26 23:10:28 1990
<Arguments>
  A_Packet_Ptr : $BO@M}%Q%1%C%H$X$N%]%$%s%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  $BN$?F$,<u?.$9$k%a%C%;!<%8(B
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkReceiveShoenID XXX
#DATA_define D_WorkGetWTC XXX

#SUBARG_define A_PacketPtr MODIFY

#SUBROUTINE  f_Recv_IntClMsg_Start_Sub(A_PacketPtr) {
  $USE(D_WorkReceiveShoenID);
  $USE(D_WorkGetWTC);
  $USE(D_WorkFPPtr);
  $USE(D_WorkLeftWTC);
  f_Get_ShoenID_fromLogicalPacket(A_PacketPtr, D_WorkReceiveShoenID);
  f_Get_WTC_fromLogicalPacket(A_PacketPtr, D_WorkGetWTC);
  $CALL( s_GetFPRecPtrAndAddChildCountIfExist_Sub(D_WorkReceiveShoenID, 
                                                  D_WorkGetWTC, 
					          D_ONE,
                                                  D_WorkFPPtr, 
                                                  D_WorkLeftWTC) );
         /* $B>e5-%5%V%k!<%A%s$O!"Aq1`#I#D$+$iN$?F$X$N%]%$%s%?$r<h$j$K9T$/$3$H(B
	  * $B$N$_$r9T$J$$!"N$?F$d9uM"F~%l%3!<%I$N%=%U%H%m%C%/$O30$7$F=*N;$9$k!#(B
	  * $B$7$+$7$=$l$G$O!"<!$K<B:]$N(Bstart$B=hM}$r9T$J$&;~$K$ON$?F$,=*N;$7$F(B
	  * $B2rJ|$5$l$F$$$k2DG=@-$,$"$k$N$G!"(BChild_Count$B$r0l;~E*$K#1A}$d$7$F(B
	  * $BN$?F$,=*N;$7$J$$$h$&$K$7$F$*$/!#(B  	  */  

  $RELEASE(D_WorkLeftWTC);

  s_RecordMsgDecodeStop(); /*** for Processor Profile ***/
  b_IfZero(D_WorkFPPtr){
    $USE(D_WorkMsgKind);
    b_SetImmValueDNTC(_NW_NAK_START, D_WorkMsgKind);
    $CALL( f_Send_IntClMsg_NAKStartStop_Sub(D_WorkReceiveShoenID, 
					    D_WorkGetWTC, D_WorkMsgKind) );
    $RELEASE(D_WorkMsgKind);
    $RELEASE(D_WorkGetWTC);
    $RELEASE(D_WorkReceiveShoenID);  
    @DEBUG{
      WARNING("f_Recv_IntClMsg_Start_Sub","No FP WTC return");
    };
  } else {
    $RELEASE(D_WorkGetWTC);
    $RELEASE(D_WorkReceiveShoenID);  
    f_FPReceiveStart(D_WorkFPPtr);
    f_DecrementChildCountAndTerminateFPIfNoChild(D_WorkFPPtr);
         /* s_GetFPRecPtrAndAddChildCountIfExist_Sub$B$GA}$d$7$?(Bchild_count$B$r(B
	  * $B#18:$i$7$FLa$7$F$*$/!#$b$7(BChild_Count$B$,#0$K$J$C$?$iN$?F%l%3!<%I(B
	  * $B$r2rJ|$7$J$1$l$P$J$i$J$$!#(B*/  
  }
  s_RecordMsgDecodeStart(); /*** for Processor Profile ***/

  $RELEASE(D_WorkFPPtr);

  $RETURN();
}

/******************************************************************** PSL **
  1.3  f_Recv_IntClMsg_Stop_Sub

       written by nakase@icot22      on Fri Jun 29 13:45:23 1990
<Arguments>
  A_Packet_Ptr : $BO@M}%Q%1%C%H$X$N%]%$%s%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  $BN$?F$,<u?.$9$k%a%C%;!<%8(B
<ETC>
********************************************************************* PSL **/

#SUBARG_define A_PacketPtr MODIFY

#SUBROUTINE f_Recv_IntClMsg_Stop_Sub(A_PacketPtr)
{
  $USE(D_WorkReceiveShoenID);
  $USE(D_WorkRecvWTC);
  $USE(D_WorkFPPtr);
  $USE(D_WorkLeftWTC);
  f_Get_ShoenID_fromLogicalPacket(A_PacketPtr, D_WorkReceiveShoenID);
  f_Get_WTC_fromLogicalPacket(A_PacketPtr, D_WorkRecvWTC);
  $CALL( s_GetFPRecPtrAndAddChildCountIfExist_Sub(D_WorkReceiveShoenID, 
                                                  D_WorkRecvWTC, 
					          D_ONE, 
                                                  D_WorkFPPtr, 
                                                  D_WorkLeftWTC) );
         /* $B>e5-%5%V%k!<%A%s$O!"Aq1`#I#D$+$iN$?F$X$N%]%$%s%?$r<h$j$K9T$/$3$H(B
	  * $B$N$_$r9T$J$$!"N$?F$d9uM"F~%l%3!<%I$N%=%U%H%m%C%/$O30$7$F=*N;$9$k!#(B
	  * $B$7$+$7$=$l$G$O!"<!$K<B:]$N(Bstop$B=hM}$r9T$J$&;~$K$ON$?F$,=*N;$7$F(B
	  * $B2rJ|$5$l$F$$$k2DG=@-$,$"$k$N$G!"(BChild_Count$B$r0l;~E*$K#1A}$d$7$F(B
	  * $BN$?F$,=*N;$7$J$$$h$&$K$7$F$*$/!#(B  	  */  

  $RELEASE(D_WorkLeftWTC);

  s_RecordMsgDecodeStop(); /*** for Processor Profile ***/
  b_IfZero(D_WorkFPPtr){
    $USE(D_WorkMsgKind);
    b_SetImmValueDNTC(_NW_NAK_STOP, D_WorkMsgKind);
    $CALL( f_Send_IntClMsg_NAKStartStop_Sub(D_WorkReceiveShoenID, 
					    D_WorkRecvWTC,D_WorkMsgKind) );
    $RELEASE(D_WorkMsgKind);
    $RELEASE(D_WorkRecvWTC);
    $RELEASE(D_WorkReceiveShoenID);  
    @DEBUG{
      WARNING("f_Recv_IntClMsg_Stop_Sub","No FP... WTC return");
    };
  } else {
    $RELEASE(D_WorkRecvWTC);
    $RELEASE(D_WorkReceiveShoenID);  
    f_FPReceiveStop(D_WorkFPPtr);
    f_DecrementChildCountAndTerminateFPIfNoChild(D_WorkFPPtr);
         /* s_GetFPRecPtrAndAddChildCountIfExist_Sub$B$GA}$d$7$?(Bchild_count$B$r(B
	  * $B#18:$i$7$FLa$7$F$*$/!#$b$7(BChild_Count$B$,#0$K$J$C$?$iN$?F%l%3!<%I(B
	  * $B$r2rJ|$7$J$1$l$P$J$i$J$$!#(B*/  
  }
  s_RecordMsgDecodeStart(); /*** for Processor Profile ***/

  $RELEASE(D_WorkFPPtr);

  $RETURN();
}

/******************************************************************** PSL **
1.4  f_Recv_IntClMsg_Abort_Sub

       written by nakase@icot22      on Fri Jun 29 15:46:40 1990
<Arguments>
  Packet_Ptr: $BO@M}%Q%1%C%H$X$N%]%$%s%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  $BN$?F$,<u?.$9$k%a%C%;!<%8(B
<ETC>
********************************************************************* PSL **/

#SUBARG_define A_PacketPtr MODIFY

#SUBROUTINE f_Recv_IntClMsg_Abort_Sub(A_PacketPtr)
{
  $USE(D_WorkReceiveShoenID);
  $USE(D_WorkRecvWTC);
  $USE(D_WorkFPPtr);
  $USE(D_WorkLeftWTC);
  f_Get_ShoenID_fromLogicalPacket(A_PacketPtr, D_WorkReceiveShoenID);
  f_Get_WTC_fromLogicalPacket(A_PacketPtr, D_WorkRecvWTC);
  $CALL( s_GetFPRecPtrAndAddChildCountIfExist_Sub(D_WorkReceiveShoenID, 
                                                  D_WorkRecvWTC, 
					          D_ONE, 
                                                  D_WorkFPPtr, 
                                                  D_WorkLeftWTC) );
         /* $B>e5-%5%V%k!<%A%s$O!"Aq1`#I#D$+$iN$?F$X$N%]%$%s%?$r<h$j$K9T$/$3$H(B
	  * $B$N$_$r9T$J$$!"N$?F$d9uM"F~%l%3!<%I$N%=%U%H%m%C%/$O30$7$F=*N;$9$k!#(B
	  * $B$7$+$7$=$l$G$O!"<!$K<B:]$N(Babort$B=hM}$r9T$J$&;~$K$ON$?F$,=*N;$7$F(B
	  * $B2rJ|$5$l$F$$$k2DG=@-$,$"$k$N$G!"(BChild_Count$B$r0l;~E*$K#1A}$d$7$F(B
	  * $BN$?F$,=*N;$7$J$$$h$&$K$7$F$*$/!#(B  	  */  

  $RELEASE(D_WorkLeftWTC);

  s_RecordMsgDecodeStop(); /*** for Processor Profile ***/
  b_IfZero(D_WorkFPPtr){
    $CALL( f_Send_IntClMsg_Return_WTC_Sub(D_WorkReceiveShoenID, 
                                          D_WorkRecvWTC) );
    $RELEASE(D_WorkRecvWTC);
    $RELEASE(D_WorkReceiveShoenID);  
    @DEBUG{
      WARNING("f_Recv_IntClMsg_Abort_Sub","No FP... WTC return");
    };
  } else {
    $RELEASE(D_WorkRecvWTC);
    $RELEASE(D_WorkReceiveShoenID);  
    f_FPReceiveAbort(D_WorkFPPtr);
    f_DecrementChildCountAndTerminateFPIfNoChild(D_WorkFPPtr);
         /* s_GetFPRecPtrAndAddChildCountIfExist_Sub$B$GA}$d$7$?(Bchild_count$B$r(B
	  * $B#18:$i$7$FLa$7$F$*$/!#$b$7(BChild_Count$B$,#0$K$J$C$?$iN$?F%l%3!<%I(B
	  * $B$r2rJ|$7$J$1$l$P$J$i$J$$!#(B*/  
  }
  s_RecordMsgDecodeStart(); /*** for Processor Profile ***/

  $RELEASE(D_WorkFPPtr);

  $RETURN();
}

/******************************************************************** PSL **
1.5  f_Recv_IntClMsg_Ready_Sub

       written by kawai@icot22      on Mon Jun 25 19:45:00 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  $BLdBj$H$J$k>u67(B: ($BN$?F$+$i$N(B)Ready$B%a%C%;!<%8$r<u?.$7$F!"$=$N1~Ez$H$7$F(B
    SupplyResource$B%a%C%;!<%8$rAw?.$9$k$^$G$N4V$K!"(B($BF1$8N$?F$+$i$N(B)Terminated
    $B%a%C%;!<%8$r<u?.$7!"$=$N7k2L(B($BAq1`$,EPO?$5$l$F$$$k(B)$B9uM"=PI=%l%3!<%I$N(BWTC$B$,(B
    0$B$K$J$C$F$7$^$C$?>l9g!#(B
  $B2r@b(B:
    (1) $BAq1`$O$"$k%?%$%_%s%0$GN$?F$+$i$N(B"ready"$B%a%C%;!<%8$r<u$1<h$k!#(B
    (2) $BAq1`$O$=$NN$?F$KBP$7$F!"(B"supply_resource"$B%a%C%;!<%8$rAw$m$&$H$9$k!#(B
    (3) $B;~$r$[$\F1$8$/$7$F!"F1$8N$?F$+$i(B"terminated"$B%a%C%;!<%8$r<u$1<h$k!#(B
    (4) "terminated"$B%a%C%;!<%8<u?.$K$h$C$F!"(B($BAq1`$,EPO?$5$l$F$$$k(B)$B9uM"=PI=(B
        $B%l%3!<%I$N(BWTC$B$,(B0$B$H$J$j!"9uM"=PI=%l%3!<%I$,2rJ|$5$l$k!#(B
    (5) $B$5$i$K(BWTC=0$B$K$h$j!"Aq1`$r=*7k$7$h$&$H$9$k!#(B
    (6) $B$7$+$7!"(B(2)$B$N=hM}$GAq1`$K%m%C%/$r3]$1$k$?$a!"(B(5)$B$N=hM}$OBT$?$5$l$k!#(B
    (7) (2)$B$NB3$-$H$7$F!"9uM"=PI=%l%3!<%I$+$i(B"supply_resource"$B%a%C%;!<%8Aw?.(B
        $BMQ$N(BWTC$B$r<h$j$K9T$/!#(B
    (8) (4)$B$G9uM"=PI=%l%3!<%I$,2rJ|$5$l$F$$$k$?$a!"?7$?$K9uM"=PI=%l%3!<%I$,3d$j(B
        $BEv$F$i$l!"$=$3$+$i(BWTC$B$,0z$+$l$k!#$J$*!"Aq1`%l%3!<%I$O?7$7$$9uM"=PI=%l%3(B
        $B!<%I$+$i;X$5$l$k!#(B
    (9) $BN$?F$K(B"supply_resource"$B$rAw?.$7$?8e!"Aq1`%l%3!<%I$r%"%s%m%C%/$9$k!#(B
    (10) (6)$B$GBT$?$5$l$F$$$?Aq1`$N=*7k=hM}$,9T$o$l$k!#(B
    (11) $BN$?F$N$$$?%/%i%9%?$K(B"supply_resource"$B%a%C%;!<%8$,E~Ce$9$k$,!"N$?F$O(B
         $B4{$K=*7k$7$F$$$k$?$a!"Aq1`$K8~$+$C$F(B"return_resource"$B$,JV$5$l$k!#(B
    (12) "return_resource"$B$,Aq1`$N$$$?%/%i%9%?$KJV$C$F$/$k!#(B
    (13) $B9uM"=P%l%3!<%I$O2s<}$G$-$k$,!"Aq1`$O4{$K=*7k$7$?8e$G$"$k!#(B
         ($BJV5Q$5$l$F$-$?;q8;$O$I$&$7$^$7$g(B?)
  $B8=:_$NBP1~(B:
      $B>e5-(B(1)$B$G!"(B"ready"$B%a%C%;!<%8$K$D$$$F$-$?(BWTC$B$r9uM"=PI=%l%3!<%I$N(BWTC$B$K2C$((B
    $B$kA0$K!"(B"supply_resource"$B%a%C%;!<%8$KIU2C$9$k(BWTC$BNL$r0z$$$F$7$^$&!#(B
      $B$=$7$F!"<B:]$K(B"supply_resource"$B$rAw?.$9$k;~(B($BAq1`$,<u?.$7$?(B"ready"$B$NJ}$,(B
    "terminated"$B$h$j$bB?$$;~(B)$B$K$O!"$=$N(BWTC$BCM$r$=$N$^$^%a%C%;!<%8$KIU2C$7$FAw?.(B
    $B$9$k!#(B
      $B$^$?!"<B:]$K$O(B"supply_resource"$B$rAw?.$7$J$$;~(B($BAq1`$,<u?.$7$?(B"terminated"
    $B$NJ}$,(B"ready"$B$h$j$b>/$J$/$J$$;~(B)$B$K$O!"$=$N(BWTC$BCM$r9uM"=PI=%l%3!<%I$K:F$S2C;;(B
    $B$7$F!"$=$N7k2L9uM"=PI=%l%3!<%I$N(BWTC$B$,(B0$B$K$J$C$?>l9g$K$OAq1`$N=*7k$r9T$&!#(B
      $B$J$*!"$3$N;~F1;~$K9uM"=PI=%l%3!<%I$b2rJ|$5$l$k!#(B
  $B8=:_$NBP1~$G$NITK~E@(B:
    "ready"$B%a%C%;!<%8$K$D$$$F$-$?(BWTC$B$r9uM"=PI=%l%3!<%I$K2C;;$9$kA0$K!"(B"supply_
  resouce"$B%a%C%;!<%8J,$N(BWTC$B$r9uM"=PI=%l%3!<%I$+$i<h$j=P$=$&$H$9$k$H!"9uM"=PI=(B
  $B%l%3!<%IA`:n$N0lIt$r$3$N%l%Y%k$G5-=R$9$kI,MW$,$"$k!#(B
    $B=>$C$F!"$3$NItJ,$N%^%/%m$r%5%]!<%H$7$FM_$7$$!#(B(str_exp_table_rec.psl.c$B$K(B)
<ETC>
  $BAq1`$,<u?.$9$k%a%C%;!<%8(B
********************************************************************* PSL **/

#DATA_define D_WorkWTC_Flag XXX

#SUBARG_define	A_PacketPtr	MODIFY

#SUBROUTINE f_Recv_IntClMsg_Ready_Sub(A_PacketPtr)
{
  $USE(D_WorkRecvShoenId);
  $USE(D_WorkRecvWTC);
  f_Get_ShoenID_fromLogicalPacket(A_PacketPtr, D_WorkRecvShoenId);
  f_Get_WTC_fromLogicalPacket(A_PacketPtr, D_WorkRecvWTC);

  $USE(D_WorkBExpShoenPtr);
  $CALL( s_GetBExpData_Sub(D_WorkRecvShoenId, D_WorkBExpShoenPtr) ); 

  $USE(D_WorkRecvClNum);
  f_Get_SenderClusterNum_fromLogicalPacket(A_PacketPtr, D_WorkRecvClNum);
  s_RecordMsgDecodeStop(); /*** for Processor Profile ***/
  f_ShoenReceiveReady(D_WorkBExpShoenPtr, D_WorkRecvClNum);
      /* $BAw?.85$X$N;q8;(B/WTC$B$NJd5k$O$3$N%^%/%m$G9T$&(B */
  s_RecordMsgDecodeStart(); /*** for Processor Profile ***/
  $RELEASE(D_WorkRecvClNum);

/* !! $BAq1`=*7k;~$N%m%C%/4|4V3HBg$N$?$a!"(BWTC$B2C;;(B $B"*(B ($BAq1`=*7k(B)$B$N=hM}$K$O(B
      $B0J2<$N%5%V%k!<%A%s$rMQ$$$k!#(B '92.2.17 */
  $CALL( f_AddWTCWithReclaimExpEntryAndShoenTerminate_Sub
	             (D_WorkRecvShoenId, D_WorkBExpShoenPtr, D_WorkRecvWTC) );

  $RELEASE(D_WorkRecvShoenId);
  $RELEASE(D_WorkRecvWTC);  
  $RELEASE(D_WorkBExpShoenPtr);
  $RETURN();
}

/******************************************************************** PSL **
1.6  f_Recv_IntClMsg_NAKStop_Sub

       written by nakase@icot22      on Tue Nov 20 20:07:13 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#SUBARG_define	A_PacketPtr	MODIFY

#SUBROUTINE f_Recv_IntClMsg_NAKStop_Sub(A_PacketPtr)
{
  $USE(D_WorkRecvShoenId);
  $USE(D_WorkRecvWTC);
  f_Get_ShoenID_fromLogicalPacket(A_PacketPtr, D_WorkRecvShoenId);
  f_Get_WTC_fromLogicalPacket(A_PacketPtr, D_WorkRecvWTC);

  $USE(D_WorkBExpShoenPtr);
  $CALL( s_GetBExpData_Sub(D_WorkRecvShoenId, D_WorkBExpShoenPtr) ); 

  $USE(D_WorkRecvClNum);
  f_Get_SenderClusterNum_fromLogicalPacket(A_PacketPtr, D_WorkRecvClNum);
  s_RecordMsgDecodeStop(); /*** for Processor Profile ***/
  f_ShoenReceiveNAKStop(D_WorkBExpShoenPtr, D_WorkRecvClNum);
  s_RecordMsgDecodeStart(); /*** for Processor Profile ***/

  $RELEASE(D_WorkRecvClNum);

/* !! $BAq1`=*7k;~$N%m%C%/4|4V3HBg$N$?$a!"(BWTC$B2C;;(B $B"*(B ($BAq1`=*7k(B)$B$N=hM}$K$O(B
      $B0J2<$N%5%V%k!<%A%s$rMQ$$$k!#(B '92.2.17 */
  $CALL( f_AddWTCWithReclaimExpEntryAndShoenTerminate_Sub
	             (D_WorkRecvShoenId, D_WorkBExpShoenPtr, D_WorkRecvWTC) );

  $RELEASE(D_WorkRecvShoenId);
  $RELEASE(D_WorkRecvWTC);  
  $RELEASE(D_WorkBExpShoenPtr);
  $RETURN();
}

/******************************************************************** PSL **
1.7  f_Recv_IntClMsg_NAKStart_Sub

       written by nakase@icot22      on Tue Nov 20 20:07:13 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#SUBARG_define	A_PacketPtr	MODIFY

#SUBROUTINE f_Recv_IntClMsg_NAKStart_Sub(A_PacketPtr)
{
  $USE(D_WorkRecvShoenId);
  $USE(D_WorkRecvWTC);
  f_Get_ShoenID_fromLogicalPacket(A_PacketPtr, D_WorkRecvShoenId);
  f_Get_WTC_fromLogicalPacket(A_PacketPtr, D_WorkRecvWTC);

  $USE(D_WorkBExpShoenPtr);
  $CALL( s_GetBExpData_Sub(D_WorkRecvShoenId, D_WorkBExpShoenPtr) ); 

  $USE(D_WorkRecvClNum);
  f_Get_SenderClusterNum_fromLogicalPacket(A_PacketPtr, D_WorkRecvClNum);
  s_RecordMsgDecodeStop(); /*** for Processor Profile ***/
  f_ShoenReceiveNAKStart(D_WorkBExpShoenPtr, D_WorkRecvClNum);
  s_RecordMsgDecodeStart(); /*** for Processor Profile ***/

  $RELEASE(D_WorkRecvClNum);

/* !! $BAq1`=*7k;~$N%m%C%/4|4V3HBg$N$?$a!"(BWTC$B2C;;(B $B"*(B ($BAq1`=*7k(B)$B$N=hM}$K$O(B
      $B0J2<$N%5%V%k!<%A%s$rMQ$$$k!#(B '92.2.17 */
  $CALL( f_AddWTCWithReclaimExpEntryAndShoenTerminate_Sub
	             (D_WorkRecvShoenId, D_WorkBExpShoenPtr, D_WorkRecvWTC) );

  $RELEASE(D_WorkRecvShoenId);
  $RELEASE(D_WorkRecvWTC);  
  $RELEASE(D_WorkBExpShoenPtr);
  $RETURN();
}

/******************************************************************** PSL **
2.1  f_Recv_IntClMsg_Request_WTC_Sub

       written by nakase@icot22      on Fri Jun 29 15:57:45 1990
<Arguments>
  A_PacketPtr: $BO@M}%Q%1%C%H$X$N%]%$%s%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  $BAq1`$,<u?.$9$k%a%C%;!<%8(B
<ETC>
********************************************************************* PSL **/

#SUBARG_define A_PacketPtr MODIFY

#SUBROUTINE f_Recv_IntClMsg_Request_WTC_Sub(A_PacketPtr)
{
  $USE(D_WorkReceiveShoenID);
  $USE(D_WorkRecvWTC);
  $USE(D_WorkShoenPtr);
  f_Get_ShoenID_fromLogicalPacket(A_PacketPtr, D_WorkReceiveShoenID);
  f_Get_WTC_fromLogicalPacket(A_PacketPtr, D_WorkRecvWTC);

  $CALL( s_GetBExpData_Sub(D_WorkReceiveShoenID, D_WorkShoenPtr) );

/* 92-03-25 kawai & yamamoto
$B%P%0!'(B
   f_Recv_IntClMsg_Request_WTC_Sub $B$G$O(B
   2.17 $B$N2~=$0JA0$O!"Aq1`$N=*7kH=Dj$N(B 
   else $B@a!JAq1`$O=*7k$7$J$$!K$G$N$_(B supply WTC $B$rH/9T$7$F$$$?!#(B
   $B$7$+$7!"(B2.17 $B$N2~=$$G!"(B
   $B!V(BWTC$B$NJV5Q$HAq1`=*7kH=Dj!W$rF1$8%m%C%/4|4V$K9T$J$&$?$a$N(B
   $BHFMQ%^%/%m$r%5%]!<%H$7$?$H$-!"(B
   request WTC $B<u?.;~$N(B supply WTC $B$NH/9T$r9MN8$7$F$$$J$+$C$?!#(B
$BBP:v!'(B
   $B!V(BWTC$B$NJV5Q$HAq1`=*7kH=Dj!W$r9T$J$&A0$K!"(B
   $BI,$:(B suplly WTC $B$rH/9T$7$F$7$^$&$3$H$K$7$?!#(B
   $B%a%C%;!<%8$NDI$$1[$7$K$h$j!"<u?.$7$?(B request WTC $B$,(B
   $BK\Mh:G8e$N%a%C%;!<%8$G$"$C$?>l9g$O!"(B
   supply WTC $B$,(B return WTC $B$H$7$FLa$C$F$-$F=*N;$9$k!#(B
*/
  $USE(D_WorkRecvClNum);
  f_Get_SenderClusterNum_fromLogicalPacket(A_PacketPtr, D_WorkRecvClNum);
  s_RecordMsgDecodeStop(); /*** for Processor Profile ***/
  $CALL( f_Send_IntClMsg_Supply_WTC_Sub(D_WorkShoenPtr, 
					D_WorkReceiveShoenID, 
					D_WorkRecvClNum) );
  s_RecordMsgDecodeStart(); /*** for Processor Profile ***/
  $RELEASE(D_WorkRecvClNum);

/* !! $BAq1`=*7k;~$N%m%C%/4|4V3HBg$N$?$a!"(BWTC$B2C;;(B $B"*(B ($BAq1`=*7k(B)$B$N=hM}$K$O(B
      $B0J2<$N%5%V%k!<%A%s$rMQ$$$k!#(B '92.2.17 */
  $CALL( f_AddWTCWithReclaimExpEntryAndShoenTerminate_Sub
	             (D_WorkReceiveShoenID, D_WorkShoenPtr, D_WorkRecvWTC) );

  $RELEASE(D_WorkReceiveShoenID);
  $RELEASE(D_WorkRecvWTC);  
  $RELEASE(D_WorkShoenPtr);
  $RETURN();
}

/******************************************************************** PSL **
2.2  f_Recv_IntClMsg_Supply_WTC_Sub

       written by nakase@icot22      on Fri Jun 29 16:00:29 1990
<Arguments>
  A_PacketPtr: $BO@M}%Q%1%C%H$X$N%]%$%s%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  $BN$?F$,<u?.$9$k%a%C%;!<%8(B
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkSupplyWTC XXX

#SUBARG_define A_PacketPtr MODIFY

#SUBROUTINE f_Recv_IntClMsg_Supply_WTC_Sub(A_PacketPtr)
{
  $USE(D_WorkReceiveShoenID);
  $USE(D_WorkSupplyWTC);
  $USE(D_WorkFPPtr);
  $USE(D_WorkLeftWTC);
  f_Get_ShoenID_fromLogicalPacket(A_PacketPtr, D_WorkReceiveShoenID);
  f_Get_WTC_fromLogicalPacket(A_PacketPtr, D_WorkSupplyWTC);
  $CALL( s_GetFPRecPtrAndAddChildCountIfExist_Sub(D_WorkReceiveShoenID, 
                                                  D_WorkSupplyWTC, 
					          D_ONE,
                                                  D_WorkFPPtr, 
                                                  D_WorkLeftWTC) );
         /* $B>e5-%5%V%k!<%A%s$O!"Aq1`#I#D$+$iN$?F$X$N%]%$%s%?$r<h$j$K9T$/$3$H(B
	  * $B$N$_$r9T$J$$!"N$?F$d9uM"F~%l%3!<%I$N%=%U%H%m%C%/$O30$7$F=*N;$9$k!#(B
	  * $B$7$+$7$=$l$G$O!"<!$K<B:]$N(Bwtc$BDI2C=hM}$r9T$J$&;~$K$ON$?F$,=*N;$7$F(B
	  * $B2rJ|$5$l$F$$$k2DG=@-$,$"$k$N$G!"(BChild_Count$B$r0l;~E*$K#1A}$d$7$F(B
	  * $BN$?F$,=*N;$7$J$$$h$&$K$7$F$*$/!#(B  	  */  

  $RELEASE(D_WorkLeftWTC);

  s_RecordMsgDecodeStop(); /*** for Processor Profile ***/
  b_IfZero(D_WorkFPPtr){
    $CALL( f_Send_IntClMsg_Return_WTC_Sub(D_WorkReceiveShoenID, 
                                          D_WorkSupplyWTC) );
    $RELEASE(D_WorkSupplyWTC);
    $RELEASE(D_WorkReceiveShoenID);  
    @DEBUG{
      WARNING("f_Recv_IntClMsg_Supply_WTC_Sub","No FP... WTC return");
    };
  } else {
    $RELEASE(D_WorkSupplyWTC);
    $RELEASE(D_WorkReceiveShoenID);  
    f_FPReceiveSupplyWTC(D_WorkFPPtr);
    f_DecrementChildCountAndTerminateFPIfNoChild(D_WorkFPPtr);
         /* s_GetFPRecPtrAndAddChildCountIfExist_Sub$B$GA}$d$7$?(Bchild_count$B$r(B
	  * $B#18:$i$7$FLa$7$F$*$/!#$b$7(BChild_Count$B$,#0$K$J$C$?$iN$?F%l%3!<%I(B
	  * $B$r2rJ|$7$J$1$l$P$J$i$J$$!#(B*/  
  }
  s_RecordMsgDecodeStart(); /*** for Processor Profile ***/

  $RELEASE(D_WorkFPPtr);

  $RETURN();
}


/******************************************************************** PSL **
2.3  f_Recv_IntClMsg_Return_WTC_Sub

       written by nakase@icot22      on Fri Jun 29 16:01:12 1990
<Arguments>
  A_PacketPtr: $BO@M}%Q%1%C%H$X$N%]%$%s%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  $BAq1`$,<u?.$9$k%a%C%;!<%8(B
<ETC>
********************************************************************* PSL **/


#SUBARG_define A_PacketPtr MODIFY

#SUBROUTINE f_Recv_IntClMsg_Return_WTC_Sub(A_PacketPtr)
{
  $USE(D_WorkReceiveShoenID);
  $USE(D_WorkRecvWTC);
  $USE(D_WorkShoenPtr);
  f_Get_ShoenID_fromLogicalPacket(A_PacketPtr, D_WorkReceiveShoenID);
  f_Get_WTC_fromLogicalPacket(A_PacketPtr, D_WorkRecvWTC);

  $CALL( s_GetBExpData_Sub(D_WorkReceiveShoenID, D_WorkShoenPtr) );

/* !! $BAq1`=*7k;~$N%m%C%/4|4V3HBg$N$?$a!"(BWTC$B2C;;(B $B"*(B ($BAq1`=*7k(B)$B$N=hM}$K$O(B
      $B0J2<$N%5%V%k!<%A%s$rMQ$$$k!#(B '92.2.17 */
  $CALL( f_AddWTCWithReclaimExpEntryAndShoenTerminate_Sub
	             (D_WorkReceiveShoenID, D_WorkShoenPtr, D_WorkRecvWTC) );

  $RELEASE(D_WorkReceiveShoenID);
  $RELEASE(D_WorkRecvWTC);  
  $RELEASE(D_WorkShoenPtr);
  $RETURN();
}

/******************************************************************** PSL **
3. $B%9%H%j!<%`4XO"$N%^%/%m!JL$%$%s%W%j%a%s%H!K(B
                           ^^^^^^^^^^^^^^^^
                   $B$h$&$9$k$K!"J}<0$H$7$F:NMQ$9$k$+$,L$Dj!D(B 90-11-15 -- Reki

       written by nakase@icot22      on Mon Jul  2 17:43:24 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
$B!&L$Dj$N$b$N$O%@%_!<%^%/%m$9$i:n$i$J$$$h$&$K$7$F$M(B
  $B:#2s$O!"Dj5A$=$N$b$N$r%3%a%s%H%"%&%H$7$F$*$-$^$7$?(B  by ttakagi
********************************************************************* PSL **/

/* #SUBARG_define A_PacketPtr MODIFY

#SUBROUTINE f_Recv_IntClMsg_Stream_Sub(A_PacketPtr)
{
  $RETURN();
} */

/* #SUBARG_define A_PacketPtr MODIFY

#SUBROUTINE f_Recv_IntClMsg_Make_Streams_Sub(A_PacketPtr)
{
  $RETURN();
} */

/* #SUBARG_define A_PacketPtr MODIFY

#SUBROUTINE f_Recv_IntClMsg_Close_Streams_Sub(A_PacketPtr)
{
  $RETURN();
} */

/* #SUBARG_define A_PacketPtr MODIFY

#SUBROUTINE f_Recv_IntClMsg_Put_Stream_Element_Sub(A_PacketPtr)
{
  $RETURN();
} */

/* #SUBARG_define A_PacketPtr MODIFY

#SUBROUTINE f_Recv_IntClMsg_Add_Streams_Sub(A_PacketPtr)
{
  $RETURN();
} */

/******************************************************************** PSL **
  4.1  f_Recv_IntClMsg_Request_Resource_Sub

       written by nakase@icot22      on Tue Jun 26 22:07:41 1990
<Arguments>
  A_PacketPtr: $B<u?.$7$?%Q%1%C%H!JO@M}%Q%1%C%H!K$X$N%]%$%s%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  $BAq1`$,<u?.$9$k%a%C%;!<%8(B
<ETC>
********************************************************************* PSL **/

#SUBARG_define	A_PacketPtr	MODIFY

#SUBROUTINE f_Recv_IntClMsg_Request_Resource_Sub(A_PacketPtr)
{
  $USE(D_WorkRecvShoenId);
  $USE(D_WorkRecvWTC);
  f_Get_ShoenID_fromLogicalPacket(A_PacketPtr, D_WorkRecvShoenId);
  f_Get_WTC_fromLogicalPacket(A_PacketPtr, D_WorkRecvWTC);

  $USE(D_WorkBExpShoenPtr);
  $CALL( s_GetBExpData_Sub(D_WorkRecvShoenId, D_WorkBExpShoenPtr) ); 
  $USE(D_WorkRecvClNum);
  f_Get_SenderClusterNum_fromLogicalPacket(A_PacketPtr, D_WorkRecvClNum);
  s_RecordMsgDecodeStop(); /*** for Processor Profile ***/
  f_ShoenReceiveRequestResource(D_WorkBExpShoenPtr, D_WorkRecvClNum);
  s_RecordMsgDecodeStart(); /*** for Processor Profile ***/
  $RELEASE(D_WorkRecvClNum);

/* !! $BAq1`=*7k;~$N%m%C%/4|4V3HBg$N$?$a!"(BWTC$B2C;;(B $B"*(B ($BAq1`=*7k(B)$B$N=hM}$K$O(B
      $B0J2<$N%5%V%k!<%A%s$rMQ$$$k!#(B '92.2.17 */
  $CALL( f_AddWTCWithReclaimExpEntryAndShoenTerminate_Sub
	             (D_WorkRecvShoenId, D_WorkBExpShoenPtr, D_WorkRecvWTC) );

  $RELEASE(D_WorkRecvShoenId);
  $RELEASE(D_WorkRecvWTC);  
  $RELEASE(D_WorkBExpShoenPtr);
  $RETURN();
}

/******************************************************************** PSL **
  4.2  f_Recv_IntClMsg_Supply_Resource_Sub

       written by nakase@icot22      on Fri Jun 29 19:19:28 1990
<Arguments>
  A_PacketPtr: $BO@M}%Q%1%C%H$X$N%]%$%s%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  $BN$?F$,<u?.$9$k%a%C%;!<%8(B
<ETC>
********************************************************************* PSL **/
#DATA_define  D_WorkSuppliedResource  XXX

#SUBARG_define A_PacketPtr MODIFY

#SUBROUTINE f_Recv_IntClMsg_Supply_Resource_Sub(A_PacketPtr)
{
  $USE(D_WorkReceiveShoenID);
  $USE(D_WorkRecvWTC);
  $USE(D_WorkFPPtr);
  $USE(D_WorkLeftWTC);
  $USE(D_WorkResource);
  f_Get_ShoenID_fromLogicalPacket(A_PacketPtr, D_WorkReceiveShoenID);
  f_Get_WTC_fromLogicalPacket(A_PacketPtr, D_WorkRecvWTC);

  b_SetImmValueDNTC(_RSC_SUPPLY_UNIT, D_WorkResource);
  /* supply resource $B$G$O!"(B_RSC_SUPPLY_UNIT $B$,0EL[$N0z?t$K$J$C$F$$$k(B */

  $CALL( s_GetFPRecPtrAndAddChildCountIfExist_Sub(D_WorkReceiveShoenID, 
                                                  D_WorkRecvWTC, 
					          D_ONE, 
                                                  D_WorkFPPtr, 
                                                  D_WorkLeftWTC) );
         /* $B>e5-%5%V%k!<%A%s$O!"Aq1`#I#D$+$iN$?F$X$N%]%$%s%?$r<h$j$K9T$/$3$H(B
	  * $B$N$_$r9T$J$$!"N$?F$d9uM"F~%l%3!<%I$N%=%U%H%m%C%/$O30$7$F=*N;$9$k!#(B
	  * $B$7$+$7$=$l$G$O!"<!$K<B:]$N(Bwtc$BDI2C=hM}$r9T$J$&;~$K$ON$?F$,=*N;$7$F(B
	  * $B2rJ|$5$l$F$$$k2DG=@-$,$"$k$N$G!"(BChild_Count$B$r0l;~E*$K#1A}$d$7$F(B
	  * $BN$?F$,=*N;$7$J$$$h$&$K$7$F$*$/!#(B  	  */  

  $RELEASE(D_WorkLeftWTC);

  s_RecordMsgDecodeStop(); /*** for Processor Profile ***/
  b_IfZero(D_WorkFPPtr){
    $RELEASE(D_WorkResource);
    $RELEASE(D_WorkFPPtr);
    $USE(D_WorkZeroResource);
    $USE(D_WorkSuppliedResource);
    b_MoveWithImmTypeMRBoff(D_NULL, DNTC, D_WorkZeroResource);
    b_SetImmValueDNTC(_RSC_SUPPLY_UNIT,D_WorkSuppliedResource);
    f_SendPacket_FPtoShoen_6Data(D_WorkReceiveShoenID, _NW_RETURN_RESOURCE,
				 D_WorkZeroResource, D_WorkSuppliedResource,
				 D_WorkRecvWTC);
    $RELEASE(D_WorkZeroResource);
    $RELEASE(D_WorkSuppliedResource);
    $RELEASE(D_WorkRecvWTC);
    $RELEASE(D_WorkReceiveShoenID);  
    @DEBUG{
      WARNING("f_Recv_IntClMsg_Supply_Rfesource_Sub","No FP.. RSC/WTC return");
    };
  } else {
    $RELEASE(D_WorkRecvWTC);
    $RELEASE(D_WorkReceiveShoenID);  
    @DEBUG{
      WARNING("f_Recv_IntClMsg_Supply_Resource_Sub","Resource Supplied");
      /*    preg(D_WorkResource); */
    };   
    f_FPReceiveSupplyResource(D_WorkFPPtr, D_WorkResource);
    f_DecrementChildCountAndTerminateFPIfNoChild(D_WorkFPPtr);
         /* s_GetFPRecPtrAndAddChildCountIfExist_Sub$B$GA}$d$7$?(Bchild_count$B$r(B
	  * $B#18:$i$7$FLa$7$F$*$/!#$b$7(BChild_Count$B$,#0$K$J$C$?$iN$?F%l%3!<%I(B
	  * $B$r2rJ|$7$J$1$l$P$J$i$J$$!#(B*/  
    $RELEASE(D_WorkResource);
    $RELEASE(D_WorkFPPtr);
  }
  s_RecordMsgDecodeStart(); /*** for Processor Profile ***/

  $RETURN();
}

/******************************************************************** PSL **
  4.3  f_Recv_IntClMsg_Return_Resource_Sub

       written by nakase@icot22      on Tue Jun 26 22:10:20 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define  D_WorkRecvReturnedResourceUpper  XXX
#DATA_define  D_WorkRecvReturnedResourceLower  XXX

#SUBARG_define	A_PacketPtr   MODIFY

#SUBROUTINE f_Recv_IntClMsg_Return_Resource_Sub(A_PacketPtr)
{
  $USE(D_WorkRecvShoenId);
  $USE(D_WorkRecvWTC);
  f_Get_ShoenID_fromLogicalPacket(A_PacketPtr, D_WorkRecvShoenId);
  f_Get_WTC_fromLogicalPacket(A_PacketPtr, D_WorkRecvWTC);

  $USE(D_WorkBExpShoenPtr);
  $CALL( s_GetBExpData_Sub(D_WorkRecvShoenId, D_WorkBExpShoenPtr) ); 
  $USE(D_WorkRecvReturnedResourceUpper);
  $USE(D_WorkRecvReturnedResourceLower);
  f_Get_ReturnResource_fromLogicalPacket(A_PacketPtr,
					 D_WorkRecvReturnedResourceUpper,
					 D_WorkRecvReturnedResourceLower);

  s_RecordMsgDecodeStop(); /*** for Processor Profile ***/
  f_ShoenReceiveReturnResource(D_WorkBExpShoenPtr,
			       D_WorkRecvReturnedResourceUpper,
			       D_WorkRecvReturnedResourceLower);
  s_RecordMsgDecodeStart(); /*** for Processor Profile ***/
  $RELEASE(D_WorkRecvReturnedResourceUpper);
  $RELEASE(D_WorkRecvReturnedResourceLower);

/* !! $BAq1`=*7k;~$N%m%C%/4|4V3HBg$N$?$a!"(BWTC$B2C;;(B $B"*(B ($BAq1`=*7k(B)$B$N=hM}$K$O(B
      $B0J2<$N%5%V%k!<%A%s$rMQ$$$k!#(B '92.2.17 */
  $CALL( f_AddWTCWithReclaimExpEntryAndShoenTerminate_Sub
	             (D_WorkRecvShoenId, D_WorkBExpShoenPtr, D_WorkRecvWTC) );

  $RELEASE(D_WorkRecvShoenId);
  $RELEASE(D_WorkRecvWTC);  
  $RELEASE(D_WorkBExpShoenPtr);
  $RETURN();
}

/******************************************************************** PSL **
  5.1  f_Recv_IntClMsg_Ask_Statistics_Sub

       written by nakase@icot22      on Fri Jun 29 19:24:01 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#SUBARG_define A_PacketPtr MODIFY

#SUBROUTINE f_Recv_IntClMsg_Ask_Statistics_Sub(A_PacketPtr)
{
  $USE(D_WorkReceiveShoenID);
  $USE(D_WorkRecvWTC);
  $USE(D_WorkFPPtr);
  $USE(D_WorkLeftWTC);
  f_Get_ShoenID_fromLogicalPacket(A_PacketPtr, D_WorkReceiveShoenID);
  f_Get_WTC_fromLogicalPacket(A_PacketPtr, D_WorkRecvWTC);
  $CALL( s_GetFPRecPtrAndAddChildCountIfExist_Sub(D_WorkReceiveShoenID, 
                                                  D_WorkRecvWTC, 
					          D_ONE, 
                                                  D_WorkFPPtr, 
                                                  D_WorkLeftWTC) );
         /* $B>e5-%5%V%k!<%A%s$O!"Aq1`#I#D$+$iN$?F$X$N%]%$%s%?$r<h$j$K9T$/$3$H(B
	  * $B$N$_$r9T$J$$!"N$?F$d9uM"F~%l%3!<%I$N%=%U%H%m%C%/$O30$7$F=*N;$9$k!#(B
	  * $B$7$+$7$=$l$G$O!"<!$K<B:]$NE}7W>pJs<}=8$r9T$J$&;~$K$ON$?F$,=*N;$7$F(B
	  * $B2rJ|$5$l$F$$$k2DG=@-$,$"$k$N$G!"(BChild_Count$B$r0l;~E*$K#1A}$d$7$F(B
	  * $BN$?F$,=*N;$7$J$$$h$&$K$7$F$*$/!#(B  	  */  

  $RELEASE(D_WorkLeftWTC);

  s_RecordMsgDecodeStop(); /*** for Processor Profile ***/
  b_IfZero(D_WorkFPPtr){
    $CALL( f_Send_IntClMsg_Answer_Statistics_With_Zero_Resource_Sub(
	                           D_WorkReceiveShoenID, D_WorkRecvWTC) );
    $RELEASE(D_WorkRecvWTC);
    $RELEASE(D_WorkReceiveShoenID);  
    @DEBUG{
      WARNING("f_Recv_IntClMsg_Ask_Statistics_Sub",
	      "No FP...  Return ans_stat with Zero rsc");
    };
  } else {
    $RELEASE(D_WorkRecvWTC);
    $RELEASE(D_WorkReceiveShoenID);  
    f_FPReceiveAskStatistics(D_WorkFPPtr);
/*
    f_DecrementChildCountAndTerminateFPIfNoChild(D_WorkFPPtr);
          * s_GetFPRecPtrAndAddChildCountIfExist_Sub$B$GA}$d$7$?(Bchild_count$B$r(B
	  * $B#18:$i$7$FLa$7$F$*$/!#$b$7(BChild_Count$B$,#0$K$J$C$?$iN$?F%l%3!<%I(B
	  * $B$r2rJ|$7$J$1$l$P$J$i$J$$!#(B

$B"*(B AskStat$B$K8B$j!"$3$N=hM}$O(Bf_Send_IntClMsg_Answer_Statistics_Sub$B$G9T$J$&(B
*/  
  }
  s_RecordMsgDecodeStart(); /*** for Processor Profile ***/

  $RELEASE(D_WorkFPPtr);

  $RETURN();
}

/******************************************************************** PSL **
  5.2  f_Recv_IntClMsg_Answer_Statistics_Sub

       written by nakase@icot22      on Tue Jun 26 22:21:50 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define  D_WorkRecvStatUpper  XXX
#DATA_define  D_WorkRecvStatLower  XXX

#SUBARG_define	A_PacketPtr	MODIFY

#SUBROUTINE f_Recv_IntClMsg_Answer_Statistics_Sub(A_PacketPtr)
{
  $USE(D_WorkRecvShoenId);
  $USE(D_WorkRecvWTC);

  f_Get_ShoenID_fromLogicalPacket(A_PacketPtr, D_WorkRecvShoenId);
  f_Get_WTC_fromLogicalPacket(A_PacketPtr, D_WorkRecvWTC);

  $USE(D_WorkBExpShoenPtr);
  $CALL( s_GetBExpData_Sub(D_WorkRecvShoenId, D_WorkBExpShoenPtr) ); 

  $USE(D_WorkRecvStatUpper);
  $USE(D_WorkRecvStatLower);
  f_Get_StatResource_fromLogicalPacket(A_PacketPtr, 
				       D_WorkRecvStatUpper,
				       D_WorkRecvStatLower);
  $USE(D_WorkRecvClNum);
  f_Get_SenderClusterNum_fromLogicalPacket(A_PacketPtr, D_WorkRecvClNum);
  s_RecordMsgDecodeStop(); /*** for Processor Profile ***/
  f_ShoenReceiveAnswerStatistics(D_WorkBExpShoenPtr, D_WorkRecvStatUpper,
				 D_WorkRecvStatLower, D_WorkRecvClNum);
  s_RecordMsgDecodeStart(); /*** for Processor Profile ***/
  $RELEASE(D_WorkRecvStatUpper);
  $RELEASE(D_WorkRecvStatLower);
  $RELEASE(D_WorkRecvClNum);

/* !! $BAq1`=*7k;~$N%m%C%/4|4V3HBg$N$?$a!"(BWTC$B2C;;(B $B"*(B ($BAq1`=*7k(B)$B$N=hM}$K$O(B
      $B0J2<$N%5%V%k!<%A%s$rMQ$$$k!#(B '92.2.17 */
  $CALL( f_AddWTCWithReclaimExpEntryAndShoenTerminate_Sub
	             (D_WorkRecvShoenId, D_WorkBExpShoenPtr, D_WorkRecvWTC) );

  $RELEASE(D_WorkRecvShoenId);
  $RELEASE(D_WorkRecvWTC);  
  $RELEASE(D_WorkBExpShoenPtr);
  $RETURN();
}

/******************************************************************** PSL **
5.3 f_Recv_IntClMsg_Ask_Profile_Sub

       written by kawai@icot22      on Fri May 17 11:11:43 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#SUBARG_define	A_PacketPtr	MODIFY

#SUBROUTINE f_Recv_IntClMsg_Shoen_Profile_Request_Sub(A_PacketPtr)
{
  $USE(D_WorkReceiveShoenID);
  $USE(D_WorkRecvWTC);
  $USE(D_WorkFPPtr);
  $USE(D_WorkLeftWTC);
  f_Get_ShoenID_fromLogicalPacket(A_PacketPtr, D_WorkReceiveShoenID);
  f_Get_WTC_fromLogicalPacket(A_PacketPtr, D_WorkRecvWTC);
  $CALL( s_GetFPRecPtrAndAddChildCountIfExist_Sub(D_WorkReceiveShoenID, 
                                                  D_WorkRecvWTC, 
					          D_ONE, 
                                                  D_WorkFPPtr, 
                                                  D_WorkLeftWTC) );
         /* $B>e5-%5%V%k!<%A%s$O!"Aq1`#I#D$+$iN$?F$X$N%]%$%s%?$r<h$j$K9T$/$3$H(B
	  * $B$N$_$r9T$J$$!"N$?F$d9uM"F~%l%3!<%I$N%=%U%H%m%C%/$O30$7$F=*N;$9$k!#(B
	  * $B$7$+$7$=$l$G$O!"<!$K<B:]$NE}7W>pJs<}=8$r9T$J$&;~$K$ON$?F$,=*N;$7$F(B
	  * $B2rJ|$5$l$F$$$k2DG=@-$,$"$k$N$G!"(BChild_Count$B$r0l;~E*$K#1A}$d$7$F(B
	  * $BN$?F$,=*N;$7$J$$$h$&$K$7$F$*$/!#(B  	  */  

  $RELEASE(D_WorkLeftWTC);

  s_RecordMsgDecodeStop(); /*** for Processor Profile ***/
  b_IfZero(D_WorkFPPtr){
    $CALL( f_Send_IntClMsg_Shoen_Profile_With_Zero_Count_Sub(
	                           D_WorkReceiveShoenID, D_WorkRecvWTC) );
    $RELEASE(D_WorkRecvWTC);
    $RELEASE(D_WorkReceiveShoenID);  
    @DEBUG{
      WARNING("f_Recv_IntClMsg_Ask_Profile_Sub",
	      "No FP...  Return ans_prof with Zero count");
    };
  } else {
    $RELEASE(D_WorkRecvWTC);
    $RELEASE(D_WorkReceiveShoenID);  
    f_FPReceiveAskProfile(D_WorkFPPtr);
/*
    f_DecrementChildCountAndTerminateFPIfNoChild(D_WorkFPPtr);
          * s_GetFPRecPtrAndAddChildCountIfExist_Sub$B$GA}$d$7$?(Bchild_count$B$r(B
	  * $B#18:$i$7$FLa$7$F$*$/!#$b$7(BChild_Count$B$,#0$K$J$C$?$iN$?F%l%3!<%I(B
	  * $B$r2rJ|$7$J$1$l$P$J$i$J$$!#(B

$B"*(B AskProf$B$G$O!"(B
  $B$3$N=hM}$O(Bf_Send_IntClMsg_Answer_Profile_Sub$B$G9T$J$&(B
*/  
  }
  s_RecordMsgDecodeStart(); /*** for Processor Profile ***/

  $RELEASE(D_WorkFPPtr);

  $RETURN();
}


/******************************************************************** PSL **
5.4 f_Recv_IntClMsg_Answer_Profile_Sub

       written by kawai@icot22      on Fri May 17 11:13:03 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define  D_WorkRecvProfType       XXX
#DATA_define  D_WorkRecvProfAnsCnt     XXX
#DATA_define  D_WorkRecvProfNestLevel  XXX
#DATA_define  D_WorkRecvProfCLNum      XXX
#DATA_define  D_WorkRecvProfData       XXX

#SUBARG_define	A_PacketPtr	MODIFY

#SUBROUTINE f_Recv_IntClMsg_Shoen_Profile_Sub(A_PacketPtr)
{
  $USE(D_WorkRecvShoenId);
  $USE(D_WorkRecvWTC);

  f_Get_ShoenID_fromLogicalPacket(A_PacketPtr, D_WorkRecvShoenId);
  f_Get_WTC_fromLogicalPacket(A_PacketPtr, D_WorkRecvWTC);

  $USE(D_WorkBExpShoenPtr);
  $CALL( s_GetBExpData_Sub(D_WorkRecvShoenId, D_WorkBExpShoenPtr) ); 

  $USE(D_WorkRecvProfType);
  $USE(D_WorkRecvProfAnsCnt);
  $USE(D_WorkRecvProfNestLevel);
  $USE(D_WorkRecvProfCLNum);
  $USE(D_WorkRecvProfData);

  f_Get_ProfileType_fromLogicalPacket(A_PacketPtr, D_WorkRecvProfType);
  f_Get_ProfileAnsCount_fromLogicalPacket(A_PacketPtr, D_WorkRecvProfAnsCnt);
  f_Get_ProfileNestLevel_fromLogicalPacket(A_PacketPtr, D_WorkRecvProfNestLevel);
  f_Get_ProfileCLNum_fromLogicalPacket(A_PacketPtr, D_WorkRecvProfCLNum);
  b_IfEqualImm(D_WorkRecvProfType, _FP_PROFILETYPE_NO_FP)
    { /* ask_profile $B$7$?$,!"%/%i%9%?$KN$?F$,$$$J$/$FLa$C$F$-$?>l9g(B */
      /* Tag of D_WorkRecvProfData must be correct !!! */
      b_MoveWithImmTypeMRBoff(D_NULL, INT, D_WorkRecvProfData);
    }
  else
    { /* $B$A$c$s$H(B answer_frofile $B$5$l$F$-$?>l9g(B */
      f_Get_ProfileData_fromLogicalPacket(A_PacketPtr, D_WorkRecvProfData);
      /* $B$3$N%G!<%?$O%"%H%_%C%/%G!<%?$G$O$J$/!"M"=PF~4IM}$NBP>]$H$J$k(B
         $B%G!<%?$G$"$k(B */
    }

  s_RecordMsgDecodeStop(); /*** for Processor Profile ***/
  f_ShoenReceiveAnswerProfile(D_WorkBExpShoenPtr, D_WorkRecvProfType,
			      D_WorkRecvProfAnsCnt, D_WorkRecvProfNestLevel,
			      D_WorkRecvProfCLNum, D_WorkRecvProfData);
  s_RecordMsgDecodeStart(); /*** for Processor Profile ***/

  $RELEASE(D_WorkRecvProfType);
  $RELEASE(D_WorkRecvProfAnsCnt);
  $RELEASE(D_WorkRecvProfNestLevel);
  $RELEASE(D_WorkRecvProfCLNum);
  $RELEASE(D_WorkRecvProfData);

/* !! $BAq1`=*7k;~$N%m%C%/4|4V3HBg$N$?$a!"(BWTC$B2C;;(B $B"*(B ($BAq1`=*7k(B)$B$N=hM}$K$O(B
      $B0J2<$N%5%V%k!<%A%s$rMQ$$$k!#(B '92.2.17 */
  $CALL( f_AddWTCWithReclaimExpEntryAndShoenTerminate_Sub
	             (D_WorkRecvShoenId, D_WorkBExpShoenPtr, D_WorkRecvWTC) );

  $RELEASE(D_WorkRecvShoenId);
  $RELEASE(D_WorkRecvWTC);  
  $RELEASE(D_WorkBExpShoenPtr);
  $RETURN();
}

/******************************************************************** PSL **
6. $BNc304X78$N%a%C%;!<%8(B

       written by nakase@icot22      on Mon Jul  2 18:14:53 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#SUBARG_define A_PacketPtr MODIFY

#SUBROUTINE f_Recv_IntClMsg_Exception_Sub(A_PacketPtr)
{
  $USE(D_WorkRecvShoenId);
  $USE(D_WorkRecvWTC);
  f_Get_ShoenID_fromLogicalPacket(A_PacketPtr, D_WorkRecvShoenId);
  f_Get_WTC_fromLogicalPacket(A_PacketPtr, D_WorkRecvWTC);

  $USE(D_WorkBExpShoenPtr);
  $CALL( s_GetBExpData_Sub(D_WorkRecvShoenId, D_WorkBExpShoenPtr) ); 

  /* ?? $BDI2C(B */
  $USE(D_WorkExceptionTag);

  $USE(D_WorkExceptionNumber);$USE(D_WorkExcepInfoVect);
  $USE(D_WorkNewCode);$USE(D_WorkNewArgv);

  /* ?? $BDI2C(B */
  s_Get_1_Data_fromLogicalPacket(A_PacketPtr, D_WorkExceptionTag);
  b_SetImmTypeMRBoff(INT, D_WorkExceptionTag);

  s_Get_1_Data_fromLogicalPacket(A_PacketPtr, D_WorkExceptionNumber);
  b_SetImmTypeMRBoff(INT, D_WorkExceptionNumber);

  $CALL(f_Get_Data_Level0_fromLogicalPacket_Sub
	                  (A_PacketPtr, D_WorkExcepInfoVect) );
  $CALL(f_Get_Data_Level0_fromLogicalPacket_Sub(A_PacketPtr, D_WorkNewCode) );
  $CALL(f_Get_Data_Level0_fromLogicalPacket_Sub(A_PacketPtr, D_WorkNewArgv) );

  s_RecordMsgDecodeStop(); /*** for Processor Profile ***/
  $CALL(f_ShoenReceiveException_Sub(D_WorkBExpShoenPtr,
				    D_WorkExceptionTag /* ?? $BDI2C(B */,
				    D_WorkExceptionNumber,
				    D_WorkExcepInfoVect, D_WorkNewCode,
				    D_WorkNewArgv) );
  s_RecordMsgDecodeStart(); /*** for Processor Profile ***/

  $RELEASE(D_WorkNewArgv);$RELEASE(D_WorkNewCode);
  $RELEASE(D_WorkExcepInfoVect);$RELEASE(D_WorkExceptionNumber);

  /* ?? $BDI2C(B */
  $RELEASE(D_WorkExceptionTag);

/* !! $BAq1`=*7k;~$N%m%C%/4|4V3HBg$N$?$a!"(BWTC$B2C;;(B $B"*(B ($BAq1`=*7k(B)$B$N=hM}$K$O(B
      $B0J2<$N%5%V%k!<%A%s$rMQ$$$k!#(B '92.2.17 */
  $CALL( f_AddWTCWithReclaimExpEntryAndShoenTerminate_Sub
	             (D_WorkRecvShoenId, D_WorkBExpShoenPtr, D_WorkRecvWTC) );

  $RELEASE(D_WorkRecvShoenId);
  $RELEASE(D_WorkRecvWTC);  
  $RELEASE(D_WorkBExpShoenPtr);
  $RETURN();
}

/******************************************************************** PSL **
100.  PIM/s $B@lMQ$N%/%i%9%?Dd;_MQ$N%a%C%;!<%8(B
  100.1  f_Receive_NW_PIMs_Shutdown_Sub()

       written by imai@icot22      on Fri Feb 16 16:12:02 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  $B%/%i%9%?Dd;_%U%i%0$r%;%C%H$9$k!#(B
<ETC>
  PIM/s $B@lMQ$G$"$k!#=i4|Aq1`$,=*N;$7$?;~$KAw$i$l$F$/$k!#(B
  $B$3$l$r<u$1$H$k$3$H$G!"0BA4$KDd;_$9$k!#(B
********************************************************************* PSL **/

#SUBROUTINE f_Recv_IntClMsg_PIMs_Shutdown_Sub()
{
  @DEBUG{
    WARNING("f_Receive_NW_PIMs_Shutdown_Sub","Shutdown message received");
  };
  b_WriteClusterHaltFlag(D_ONE);
  $RETURN();
}
